#!/usr/bin/perl

package eBay::API::XML::Call::SetStoreCategories::SetStoreCategoriesResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SetStoreCategoriesResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::SetStoreCategories::SetStoreCategoriesResponseType

=head1 DESCRIPTION

Returns the status of the processing progress for changes to the category 
structure for a store.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::SetStoreCategories::SetStoreCategoriesResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::Enum::TaskStatusCodeType;


my @gaProperties = ( [ 'Status', 'ns:TaskStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::TaskStatusCodeType', '' ]
	, [ 'TaskID', 'xs:long', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setStatus()

When a category structure change is processed synchronously, the status 
is returned as Complete or Failed. For asynchronously processed changes, 
the status is reported as Pending. Use GetStoreCategoryUpdateStatus to 
monitor the status of asynchronously processed changes.

#    Argument: 'ns:TaskStatusCodeType'

=cut

sub setStatus {
  my $self = shift;
  $self->{'Status'} = shift
}

=head2 getStatus()

  Returned: Always
#    Returns: 'ns:TaskStatusCodeType'

=cut

sub getStatus {
  my $self = shift;
  return $self->{'Status'};
}


=head2 setTaskID()

The task ID associated with the category structure change request. If the 
SetStoreCategories call is process synchronously, the task ID is 0. If the 
category structure changes affect many listings, the changes will be 
processed asynchronously and the task ID will be a positive number. Use 
the task ID with GetStoreCategoryUpdateStatus to monitor the status of 
asynchronously processed changes.

#    Argument: 'xs:long'

=cut

sub setTaskID {
  my $self = shift;
  $self->{'TaskID'} = shift
}

=head2 getTaskID()

  Returned: Always
#    Returns: 'xs:long'

=cut

sub getTaskID {
  my $self = shift;
  return $self->{'TaskID'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
