use strict;
use warnings;

package WebService::Gitter;

use Moo;
use LWP::UserAgent;
use JSON::Tiny;

#ABSTRACT: An interface to Gitter REST API via Perl 5.
our $VERSION = '0.2.0'; # VERSION

has token_pass => (
    is       => 'ro',
    required => 1
);

my $ua = LWP::UserAgent->new;
$ua->timeout(12);
$ua->env_proxy;

# these are for the Gitter api links
my $url_rooms = 'https://api.gitter.im/v1/rooms';
my $url_user  = 'https://api.gitter.im/v1/user';

# This method send a GET request to a server to get authentication data as the authenticated user.

sub get_user_who {
    my $self = shift;

    my $req = $ua->get(
        'https://api.gitter.im/v1/user/me?access_token=' . $self->token_pass );
	
	my $message = JSON::Tiny::decode_json $req->decoded_content;
    if ( $req->is_success ) {
       
		foreach my $mes(keys $message) {
			print "$mes: " . $message->{$mes} . "\n";
			
		}
    }

    else {
        die $req->status_line;
    }
}

# This method send a POST request to the server, to get the room id(and other info). You need to specify $room_uri eg('gitterhq/blah')
sub post_room_id {

    my ( $self, $room_uri ) = @_;
    my $req = HTTP::Request->new( POST => $url_rooms );
    $req->header( 'Content-Type'  => 'application/json' );
    $req->header( 'Accept'        => 'application/json' );
    $req->header( 'Authorization' => 'Bearer ' . $self->token_pass );

    my $post_body = JSON::Tiny::encode_json( { uri => $room_uri } );
    $req->content($post_body);

    my $resp = $ua->request($req);
	my $message = JSON::Tiny::decode_json $resp->decoded_content;
    if ( $resp->is_success ) {
        print "Room ID: " . $message->{'id'} . "\n";
    }

    else {
        print "Error code: ",    $resp->code,    "\n";
        print "Error message: ", $resp->message, "\n";
    }
}
# This method send a message to a room. It needs room id and of course, the text to send.
    sub post_room_message {
        my ( $self, $room_id, $text ) = @_;
        my $req =
          HTTP::Request->new( POST => $url_rooms . "/$room_id/chatMessages" );

        $req->header( 'Content-Type'  => 'application/json' );
        $req->header( 'Accept'        => 'application/json' );
        $req->header( 'Authorization' => 'Bearer ' . $self->token_pass );

        my $post_body = JSON::Tiny::encode_json( { text => $text } );
        $req->content($post_body);

        my $resp = $ua->request($req);

        if ( $resp->is_success ) {
            print "Message: text '$text' sent to room with room ID: $room_id\n";
        }

        else {

            print 'Error code, ' . $resp->code . "\n";
            print 'Error message, ' . $resp->message . "\n";
       }
}

=pod

=encoding UTF-8

=head1 NAME

WebService::Gitter - An interface to Gitter REST API via Perl 5.

=head1 VERSION

version 0.2.0

=head1 SYNOPSIS

	use WebService::Gitter;

	my $serv = WebService::Gitter->new(token_pass => 'mytoken123');

	# Prints the info about the authenticated user
	$serv->get_user_who;

	# Prints the info about Gitter room ('Room name')
	$serv->get_room_id('FreeCodeCamp/FreeCodeCamp');

	# Send a message to a room
	$serv->post_room_message('546fd572db8155e6700d6eaf', 'Hi');

=head1 DESCRIPTION

An interface to Gitter REST API (v1). Currently only supports two method (see SYNOPSIS)

=head1 AUTHOR

faraco <skelic3@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by faraco.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__END__


1;
