# Generated by default/object.tt
package Paws::MediaLive::AutomaticInputFailoverSettings;
  use Moose;
  has ErrorClearTimeMsec => (is => 'ro', isa => 'Int', request_name => 'errorClearTimeMsec', traits => ['NameInRequest']);
  has FailoverConditions => (is => 'ro', isa => 'ArrayRef[Paws::MediaLive::FailoverCondition]', request_name => 'failoverConditions', traits => ['NameInRequest']);
  has InputPreference => (is => 'ro', isa => 'Str', request_name => 'inputPreference', traits => ['NameInRequest']);
  has SecondaryInputId => (is => 'ro', isa => 'Str', request_name => 'secondaryInputId', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaLive::AutomaticInputFailoverSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaLive::AutomaticInputFailoverSettings object:

  $service_obj->Method(Att1 => { ErrorClearTimeMsec => $value, ..., SecondaryInputId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaLive::AutomaticInputFailoverSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->ErrorClearTimeMsec

=head1 DESCRIPTION

The settings for Automatic Input Failover.

=head1 ATTRIBUTES


=head2 ErrorClearTimeMsec => Int

This clear time defines the requirement a recovered input must meet to
be considered healthy. The input must have no failover conditions for
this length of time. Enter a time in milliseconds. This value is
particularly important if the input_preference for the failover pair is
set to PRIMARY_INPUT_PREFERRED, because after this time, MediaLive will
switch back to the primary input.


=head2 FailoverConditions => ArrayRef[L<Paws::MediaLive::FailoverCondition>]

A list of failover conditions. If any of these conditions occur,
MediaLive will perform a failover to the other input.


=head2 InputPreference => Str

Input preference when deciding which input to make active when a
previously failed input has recovered.


=head2 B<REQUIRED> SecondaryInputId => Str

The input ID of the secondary input in the automatic input failover
pair.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaLive>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

