use Unicode::Collate::CJK::JISX0208;
+{
   locale_version => 1.14,
   overrideCJK => \&Unicode::Collate::CJK::JISX0208::weightJISX0208,
   entry => <<'ENTRY', # for DUCET v7.0.0
30A1      ; [.38D4.0020.000F.0002] # KATAKANA LETTER SMALL A
30A2      ; [.38D4.0020.0011.0002] # KATAKANA LETTER A
30A3      ; [.38D5.0020.000F.0002] # KATAKANA LETTER SMALL I
30A4      ; [.38D5.0020.0011.0002] # KATAKANA LETTER I
30A5      ; [.38D6.0020.000F.0002] # KATAKANA LETTER SMALL U
30A6      ; [.38D6.0020.0011.0002] # KATAKANA LETTER U
30A7      ; [.38D8.0020.000F.0002] # KATAKANA LETTER SMALL E
30A8      ; [.38D8.0020.0011.0002] # KATAKANA LETTER E
30A9      ; [.38D9.0020.000F.0002] # KATAKANA LETTER SMALL O
30AA      ; [.38D9.0020.0011.0002] # KATAKANA LETTER O
30AB      ; [.38DA.0020.0011.0002] # KATAKANA LETTER KA
30AC      ; [.38DA.0020.0011.0002][.0000.0037.0002] # KATAKANA LETTER GA
30AD      ; [.38DB.0020.0011.0002] # KATAKANA LETTER KI
30AE      ; [.38DB.0020.0011.0002][.0000.0037.0002] # KATAKANA LETTER GI
30AF      ; [.38DC.0020.0011.0002] # KATAKANA LETTER KU
30B0      ; [.38DC.0020.0011.0002][.0000.0037.0002] # KATAKANA LETTER GU
30B1      ; [.38DD.0020.0011.0002] # KATAKANA LETTER KE
30B2      ; [.38DD.0020.0011.0002][.0000.0037.0002] # KATAKANA LETTER GE
30B3      ; [.38DE.0020.0011.0002] # KATAKANA LETTER KO
30B4      ; [.38DE.0020.0011.0002][.0000.0037.0002] # KATAKANA LETTER GO
30B5      ; [.38DF.0020.0011.0002] # KATAKANA LETTER SA
30B6      ; [.38DF.0020.0011.0002][.0000.0037.0002] # KATAKANA LETTER ZA
30B7      ; [.38E0.0020.0011.0002] # KATAKANA LETTER SI
30B8      ; [.38E0.0020.0011.0002][.0000.0037.0002] # KATAKANA LETTER ZI
30B9      ; [.38E1.0020.0011.0002] # KATAKANA LETTER SU
30BA      ; [.38E1.0020.0011.0002][.0000.0037.0002] # KATAKANA LETTER ZU
30BB      ; [.38E2.0020.0011.0002] # KATAKANA LETTER SE
30BC      ; [.38E2.0020.0011.0002][.0000.0037.0002] # KATAKANA LETTER ZE
30BD      ; [.38E3.0020.0011.0002] # KATAKANA LETTER SO
30BE      ; [.38E3.0020.0011.0002][.0000.0037.0002] # KATAKANA LETTER ZO
30BF      ; [.38E4.0020.0011.0002] # KATAKANA LETTER TA
30C0      ; [.38E4.0020.0011.0002][.0000.0037.0002] # KATAKANA LETTER DA
30C1      ; [.38E5.0020.0011.0002] # KATAKANA LETTER TI
30C2      ; [.38E5.0020.0011.0002][.0000.0037.0002] # KATAKANA LETTER DI
30C3      ; [.38E6.0020.000F.0002] # KATAKANA LETTER SMALL TU
30C4      ; [.38E6.0020.0011.0002] # KATAKANA LETTER TU
30C5      ; [.38E6.0020.0011.0002][.0000.0037.0002] # KATAKANA LETTER DU
30C6      ; [.38E7.0020.0011.0002] # KATAKANA LETTER TE
30C7      ; [.38E7.0020.0011.0002][.0000.0037.0002] # KATAKANA LETTER DE
30C8      ; [.38E8.0020.0011.0002] # KATAKANA LETTER TO
30C9      ; [.38E8.0020.0011.0002][.0000.0037.0002] # KATAKANA LETTER DO
30CA      ; [.38E9.0020.0011.0002] # KATAKANA LETTER NA
30CB      ; [.38EA.0020.0011.0002] # KATAKANA LETTER NI
30CC      ; [.38EB.0020.0011.0002] # KATAKANA LETTER NU
30CD      ; [.38EC.0020.0011.0002] # KATAKANA LETTER NE
30CE      ; [.38ED.0020.0011.0002] # KATAKANA LETTER NO
30CF      ; [.38EE.0020.0011.0002] # KATAKANA LETTER HA
30D0      ; [.38EE.0020.0011.0002][.0000.0037.0002] # KATAKANA LETTER BA
30D1      ; [.38EE.0020.0011.0002][.0000.0038.0002] # KATAKANA LETTER PA
30D2      ; [.38EF.0020.0011.0002] # KATAKANA LETTER HI
30D3      ; [.38EF.0020.0011.0002][.0000.0037.0002] # KATAKANA LETTER BI
30D4      ; [.38EF.0020.0011.0002][.0000.0038.0002] # KATAKANA LETTER PI
30D5      ; [.38F0.0020.0011.0002] # KATAKANA LETTER HU
30D6      ; [.38F0.0020.0011.0002][.0000.0037.0002] # KATAKANA LETTER BU
30D7      ; [.38F0.0020.0011.0002][.0000.0038.0002] # KATAKANA LETTER PU
30D8      ; [.38F1.0020.0011.0002] # KATAKANA LETTER HE
30D9      ; [.38F1.0020.0011.0002][.0000.0037.0002] # KATAKANA LETTER BE
30DA      ; [.38F1.0020.0011.0002][.0000.0038.0002] # KATAKANA LETTER PE
30DB      ; [.38F2.0020.0011.0002] # KATAKANA LETTER HO
30DC      ; [.38F2.0020.0011.0002][.0000.0037.0002] # KATAKANA LETTER BO
30DD      ; [.38F2.0020.0011.0002][.0000.0038.0002] # KATAKANA LETTER PO
30DE      ; [.38F3.0020.0011.0002] # KATAKANA LETTER MA
30DF      ; [.38F4.0020.0011.0002] # KATAKANA LETTER MI
30E0      ; [.38F5.0020.0011.0002] # KATAKANA LETTER MU
30E1      ; [.38F6.0020.0011.0002] # KATAKANA LETTER ME
30E2      ; [.38F7.0020.0011.0002] # KATAKANA LETTER MO
30E3      ; [.38F8.0020.000F.0002] # KATAKANA LETTER SMALL YA
30E4      ; [.38F8.0020.0011.0002] # KATAKANA LETTER YA
30E5      ; [.38F9.0020.000F.0002] # KATAKANA LETTER SMALL YU
30E6      ; [.38F9.0020.0011.0002] # KATAKANA LETTER YU
30E7      ; [.38FB.0020.000F.0002] # KATAKANA LETTER SMALL YO
30E8      ; [.38FB.0020.0011.0002] # KATAKANA LETTER YO
30E9      ; [.38FC.0020.0011.0002] # KATAKANA LETTER RA
30EA      ; [.38FD.0020.0011.0002] # KATAKANA LETTER RI
30EB      ; [.38FE.0020.0011.0002] # KATAKANA LETTER RU
30EC      ; [.38FF.0020.0011.0002] # KATAKANA LETTER RE
30ED      ; [.3900.0020.0011.0002] # KATAKANA LETTER RO
30EE      ; [.3901.0020.000F.0002] # KATAKANA LETTER SMALL WA
30EF      ; [.3901.0020.0011.0002] # KATAKANA LETTER WA
30F0      ; [.3902.0020.0011.0002] # KATAKANA LETTER WI
30F1      ; [.3903.0020.0011.0002] # KATAKANA LETTER WE
30F2      ; [.3904.0020.0011.0002] # KATAKANA LETTER WO
30F3      ; [.3905.0020.0011.0002] # KATAKANA LETTER N
30F4      ; [.38D6.0020.0011.0002][.0000.0037.0002] # KATAKANA LETTER VU
30F5      ; [.38DA.0020.000F.0002] # KATAKANA LETTER SMALL KA
30F6      ; [.38DD.0020.000F.0002] # KATAKANA LETTER SMALL KE
30F7      ; [.3901.0020.0011.0002][.0000.0037.0002] # KATAKANA LETTER VA
30F8      ; [.3902.0020.0011.0002][.0000.0037.0002] # KATAKANA LETTER VI
30F9      ; [.3903.0020.0011.0002][.0000.0037.0002] # KATAKANA LETTER VE
30FA      ; [.3904.0020.0011.0002][.0000.0037.0002] # KATAKANA LETTER VO
30FD      ; [.18D5.0020.0002.0002] # KATAKANA ITERATION MARK
30FE      ; [.18D5.0020.0002.0002][.0000.0037.0002] # KATAKANA VOICED ITERATION MARK
3041      ; [.38D4.0020.000F.0001] # HIRAGANA LETTER SMALL A
3042      ; [.38D4.0020.0011.0001] # HIRAGANA LETTER A
3043      ; [.38D5.0020.000F.0001] # HIRAGANA LETTER SMALL I
3044      ; [.38D5.0020.0011.0001] # HIRAGANA LETTER I
3045      ; [.38D6.0020.000F.0001] # HIRAGANA LETTER SMALL U
3046      ; [.38D6.0020.0011.0001] # HIRAGANA LETTER U
3047      ; [.38D8.0020.000F.0001] # HIRAGANA LETTER SMALL E
3048      ; [.38D8.0020.0011.0001] # HIRAGANA LETTER E
3049      ; [.38D9.0020.000F.0001] # HIRAGANA LETTER SMALL O
304A      ; [.38D9.0020.0011.0001] # HIRAGANA LETTER O
304B      ; [.38DA.0020.0011.0001] # HIRAGANA LETTER KA
304C      ; [.38DA.0020.0011.0001][.0000.0037.0002] # HIRAGANA LETTER GA
304D      ; [.38DB.0020.0011.0001] # HIRAGANA LETTER KI
304E      ; [.38DB.0020.0011.0001][.0000.0037.0002] # HIRAGANA LETTER GI
304F      ; [.38DC.0020.0011.0001] # HIRAGANA LETTER KU
3050      ; [.38DC.0020.0011.0001][.0000.0037.0002] # HIRAGANA LETTER GU
3051      ; [.38DD.0020.0011.0001] # HIRAGANA LETTER KE
3052      ; [.38DD.0020.0011.0001][.0000.0037.0002] # HIRAGANA LETTER GE
3053      ; [.38DE.0020.0011.0001] # HIRAGANA LETTER KO
3054      ; [.38DE.0020.0011.0001][.0000.0037.0002] # HIRAGANA LETTER GO
3055      ; [.38DF.0020.0011.0001] # HIRAGANA LETTER SA
3056      ; [.38DF.0020.0011.0001][.0000.0037.0002] # HIRAGANA LETTER ZA
3057      ; [.38E0.0020.0011.0001] # HIRAGANA LETTER SI
3058      ; [.38E0.0020.0011.0001][.0000.0037.0002] # HIRAGANA LETTER ZI
3059      ; [.38E1.0020.0011.0001] # HIRAGANA LETTER SU
305A      ; [.38E1.0020.0011.0001][.0000.0037.0002] # HIRAGANA LETTER ZU
305B      ; [.38E2.0020.0011.0001] # HIRAGANA LETTER SE
305C      ; [.38E2.0020.0011.0001][.0000.0037.0002] # HIRAGANA LETTER ZE
305D      ; [.38E3.0020.0011.0001] # HIRAGANA LETTER SO
305E      ; [.38E3.0020.0011.0001][.0000.0037.0002] # HIRAGANA LETTER ZO
305F      ; [.38E4.0020.0011.0001] # HIRAGANA LETTER TA
3060      ; [.38E4.0020.0011.0001][.0000.0037.0002] # HIRAGANA LETTER DA
3061      ; [.38E5.0020.0011.0001] # HIRAGANA LETTER TI
3062      ; [.38E5.0020.0011.0001][.0000.0037.0002] # HIRAGANA LETTER DI
3063      ; [.38E6.0020.000F.0001] # HIRAGANA LETTER SMALL TU
3064      ; [.38E6.0020.0011.0001] # HIRAGANA LETTER TU
3065      ; [.38E6.0020.0011.0001][.0000.0037.0002] # HIRAGANA LETTER DU
3066      ; [.38E7.0020.0011.0001] # HIRAGANA LETTER TE
3067      ; [.38E7.0020.0011.0001][.0000.0037.0002] # HIRAGANA LETTER DE
3068      ; [.38E8.0020.0011.0001] # HIRAGANA LETTER TO
3069      ; [.38E8.0020.0011.0001][.0000.0037.0002] # HIRAGANA LETTER DO
306A      ; [.38E9.0020.0011.0001] # HIRAGANA LETTER NA
306B      ; [.38EA.0020.0011.0001] # HIRAGANA LETTER NI
306C      ; [.38EB.0020.0011.0001] # HIRAGANA LETTER NU
306D      ; [.38EC.0020.0011.0001] # HIRAGANA LETTER NE
306E      ; [.38ED.0020.0011.0001] # HIRAGANA LETTER NO
306F      ; [.38EE.0020.0011.0001] # HIRAGANA LETTER HA
3070      ; [.38EE.0020.0011.0001][.0000.0037.0002] # HIRAGANA LETTER BA
3071      ; [.38EE.0020.0011.0001][.0000.0038.0002] # HIRAGANA LETTER PA
3072      ; [.38EF.0020.0011.0001] # HIRAGANA LETTER HI
3073      ; [.38EF.0020.0011.0001][.0000.0037.0002] # HIRAGANA LETTER BI
3074      ; [.38EF.0020.0011.0001][.0000.0038.0002] # HIRAGANA LETTER PI
3075      ; [.38F0.0020.0011.0001] # HIRAGANA LETTER HU
3076      ; [.38F0.0020.0011.0001][.0000.0037.0002] # HIRAGANA LETTER BU
3077      ; [.38F0.0020.0011.0001][.0000.0038.0002] # HIRAGANA LETTER PU
3078      ; [.38F1.0020.0011.0001] # HIRAGANA LETTER HE
3079      ; [.38F1.0020.0011.0001][.0000.0037.0002] # HIRAGANA LETTER BE
307A      ; [.38F1.0020.0011.0001][.0000.0038.0002] # HIRAGANA LETTER PE
307B      ; [.38F2.0020.0011.0001] # HIRAGANA LETTER HO
307C      ; [.38F2.0020.0011.0001][.0000.0037.0002] # HIRAGANA LETTER BO
307D      ; [.38F2.0020.0011.0001][.0000.0038.0002] # HIRAGANA LETTER PO
307E      ; [.38F3.0020.0011.0001] # HIRAGANA LETTER MA
307F      ; [.38F4.0020.0011.0001] # HIRAGANA LETTER MI
3080      ; [.38F5.0020.0011.0001] # HIRAGANA LETTER MU
3081      ; [.38F6.0020.0011.0001] # HIRAGANA LETTER ME
3082      ; [.38F7.0020.0011.0001] # HIRAGANA LETTER MO
3083      ; [.38F8.0020.000F.0001] # HIRAGANA LETTER SMALL YA
3084      ; [.38F8.0020.0011.0001] # HIRAGANA LETTER YA
3085      ; [.38F9.0020.000F.0001] # HIRAGANA LETTER SMALL YU
3086      ; [.38F9.0020.0011.0001] # HIRAGANA LETTER YU
3087      ; [.38FB.0020.000F.0001] # HIRAGANA LETTER SMALL YO
3088      ; [.38FB.0020.0011.0001] # HIRAGANA LETTER YO
3089      ; [.38FC.0020.0011.0001] # HIRAGANA LETTER RA
308A      ; [.38FD.0020.0011.0001] # HIRAGANA LETTER RI
308B      ; [.38FE.0020.0011.0001] # HIRAGANA LETTER RU
308C      ; [.38FF.0020.0011.0001] # HIRAGANA LETTER RE
308D      ; [.3900.0020.0011.0001] # HIRAGANA LETTER RO
308E      ; [.3901.0020.000F.0001] # HIRAGANA LETTER SMALL WA
308F      ; [.3901.0020.0011.0001] # HIRAGANA LETTER WA
3090      ; [.3902.0020.0011.0001] # HIRAGANA LETTER WI
3091      ; [.3903.0020.0011.0001] # HIRAGANA LETTER WE
3092      ; [.3904.0020.0011.0001] # HIRAGANA LETTER WO
3093      ; [.3905.0020.0011.0001] # HIRAGANA LETTER N
3094      ; [.38D6.0020.0011.0001][.0000.0037.0002] # HIRAGANA LETTER VU
3095      ; [.38DA.0020.000F.0001] # HIRAGANA LETTER SMALL KA
3096      ; [.38DD.0020.000F.0001] # HIRAGANA LETTER SMALL KE
309D      ; [.18D5.0020.0002.0001] # HIRAGANA ITERATION MARK
309E      ; [.18D5.0020.0002.0001][.0000.0037.0002] # HIRAGANA VOICED ITERATION MARK
3000      ; [*0209.0020.0002] # IDEOGRAPHIC SPACE
FF01      ; [*025F.0020.0002] # FULLWIDTH EXCLAMATION MARK
FF02      ; [*02FF.0020.0002] # FULLWIDTH QUOTATION MARK
FF03      ; [*038B.0020.0002] # FULLWIDTH NUMBER SIGN
FF04      ; [.18D8.0020.0002] # FULLWIDTH DOLLAR SIGN
FF05      ; [*038C.0020.0002] # FULLWIDTH PERCENT SIGN
FF06      ; [*0389.0020.0002] # FULLWIDTH AMPERSAND
FF07      ; [*02F8.0020.0002] # FULLWIDTH APOSTROPHE
FF08      ; [*030A.0020.0002] # FULLWIDTH LEFT PARENTHESIS
FF09      ; [*030B.0020.0002] # FULLWIDTH RIGHT PARENTHESIS
FF0A      ; [*0382.0020.0002] # FULLWIDTH ASTERISK
FF0B      ; [*05D6.0020.0002] # FULLWIDTH PLUS SIGN
FF0C      ; [*0221.0020.0002] # FULLWIDTH COMMA
FF0D      ; [*020D.0020.0002] # FULLWIDTH HYPHEN-MINUS
FF0E      ; [*0274.0020.0002] # FULLWIDTH FULL STOP
FF0F      ; [*0387.0020.0002] # FULLWIDTH SOLIDUS
FF10      ; [.1902.0020.0002] # FULLWIDTH DIGIT ZERO
FF11      ; [.1903.0020.0002] # FULLWIDTH DIGIT ONE
FF12      ; [.1904.0020.0002] # FULLWIDTH DIGIT TWO
FF13      ; [.1905.0020.0002] # FULLWIDTH DIGIT THREE
FF14      ; [.1906.0020.0002] # FULLWIDTH DIGIT FOUR
FF15      ; [.1907.0020.0002] # FULLWIDTH DIGIT FIVE
FF16      ; [.1908.0020.0002] # FULLWIDTH DIGIT SIX
FF17      ; [.1909.0020.0002] # FULLWIDTH DIGIT SEVEN
FF18      ; [.190A.0020.0002] # FULLWIDTH DIGIT EIGHT
FF19      ; [.190B.0020.0002] # FULLWIDTH DIGIT NINE
FF1A      ; [*0238.0020.0002] # FULLWIDTH COLON
FF1B      ; [*0233.0020.0002] # FULLWIDTH SEMICOLON
FF1C      ; [*05DA.0020.0002] # FULLWIDTH LESS-THAN SIGN
FF1D      ; [*05DB.0020.0002] # FULLWIDTH EQUALS SIGN
FF1E      ; [*05DC.0020.0002] # FULLWIDTH GREATER-THAN SIGN
FF1F      ; [*0264.0020.0002] # FULLWIDTH QUESTION MARK
FF20      ; [*0381.0020.0002] # FULLWIDTH COMMERCIAL AT
FF21      ; [.190C.0020.0008] # FULLWIDTH LATIN CAPITAL LETTER A
FF22      ; [.1925.0020.0008] # FULLWIDTH LATIN CAPITAL LETTER B
FF23      ; [.193E.0020.0008] # FULLWIDTH LATIN CAPITAL LETTER C
FF24      ; [.1953.0020.0008] # FULLWIDTH LATIN CAPITAL LETTER D
FF25      ; [.196E.0020.0008] # FULLWIDTH LATIN CAPITAL LETTER E
FF26      ; [.19A9.0020.0008] # FULLWIDTH LATIN CAPITAL LETTER F
FF27      ; [.19B8.0020.0008] # FULLWIDTH LATIN CAPITAL LETTER G
FF28      ; [.19DC.0020.0008] # FULLWIDTH LATIN CAPITAL LETTER H
FF29      ; [.19F6.0020.0008] # FULLWIDTH LATIN CAPITAL LETTER I
FF2A      ; [.1A10.0020.0008] # FULLWIDTH LATIN CAPITAL LETTER J
FF2B      ; [.1A29.0020.0008] # FULLWIDTH LATIN CAPITAL LETTER K
FF2C      ; [.1A3B.0020.0008] # FULLWIDTH LATIN CAPITAL LETTER L
FF2D      ; [.1A6E.0020.0008] # FULLWIDTH LATIN CAPITAL LETTER M
FF2E      ; [.1A7D.0020.0008] # FULLWIDTH LATIN CAPITAL LETTER N
FF2F      ; [.1AA1.0020.0008] # FULLWIDTH LATIN CAPITAL LETTER O
FF30      ; [.1ACE.0020.0008] # FULLWIDTH LATIN CAPITAL LETTER P
FF31      ; [.1AE3.0020.0008] # FULLWIDTH LATIN CAPITAL LETTER Q
FF32      ; [.1AF5.0020.0008] # FULLWIDTH LATIN CAPITAL LETTER R
FF33      ; [.1B33.0020.0008] # FULLWIDTH LATIN CAPITAL LETTER S
FF34      ; [.1B57.0020.0008] # FULLWIDTH LATIN CAPITAL LETTER T
FF35      ; [.1B77.0020.0008] # FULLWIDTH LATIN CAPITAL LETTER U
FF36      ; [.1BA5.0020.0008] # FULLWIDTH LATIN CAPITAL LETTER V
FF37      ; [.1BB7.0020.0008] # FULLWIDTH LATIN CAPITAL LETTER W
FF38      ; [.1BC1.0020.0008] # FULLWIDTH LATIN CAPITAL LETTER X
FF39      ; [.1BCD.0020.0008] # FULLWIDTH LATIN CAPITAL LETTER Y
FF3A      ; [.1BE3.0020.0008] # FULLWIDTH LATIN CAPITAL LETTER Z
FF3B      ; [*030C.0020.0002] # FULLWIDTH LEFT SQUARE BRACKET
FF3C      ; [*02F8.0020.0002] # FULLWIDTH REVERSE SOLIDUS
FF3D      ; [*030D.0020.0002] # FULLWIDTH RIGHT SQUARE BRACKET
FF3E      ; [*0449.0020.0002] # FULLWIDTH CIRCUMFLEX ACCENT
FF3F      ; [*020B.0020.0002] # FULLWIDTH LOW LINE
FF40      ; [*0446.0020.0002] # FULLWIDTH GRAVE ACCENT
FF41      ; [.190C.0020.0002] # FULLWIDTH LATIN SMALL LETTER A
FF42      ; [.1925.0020.0002] # FULLWIDTH LATIN SMALL LETTER B
FF43      ; [.193E.0020.0002] # FULLWIDTH LATIN SMALL LETTER C
FF44      ; [.1953.0020.0002] # FULLWIDTH LATIN SMALL LETTER D
FF45      ; [.196E.0020.0002] # FULLWIDTH LATIN SMALL LETTER E
FF46      ; [.19A9.0020.0002] # FULLWIDTH LATIN SMALL LETTER F
FF47      ; [.19B8.0020.0002] # FULLWIDTH LATIN SMALL LETTER G
FF48      ; [.19DC.0020.0002] # FULLWIDTH LATIN SMALL LETTER H
FF49      ; [.19F6.0020.0002] # FULLWIDTH LATIN SMALL LETTER I
FF4A      ; [.1A10.0020.0002] # FULLWIDTH LATIN SMALL LETTER J
FF4B      ; [.1A29.0020.0002] # FULLWIDTH LATIN SMALL LETTER K
FF4C      ; [.1A3B.0020.0002] # FULLWIDTH LATIN SMALL LETTER L
FF4D      ; [.1A6E.0020.0002] # FULLWIDTH LATIN SMALL LETTER M
FF4E      ; [.1A7D.0020.0002] # FULLWIDTH LATIN SMALL LETTER N
FF4F      ; [.1AA1.0020.0002] # FULLWIDTH LATIN SMALL LETTER O
FF50      ; [.1ACE.0020.0002] # FULLWIDTH LATIN SMALL LETTER P
FF51      ; [.1AE3.0020.0002] # FULLWIDTH LATIN SMALL LETTER Q
FF52      ; [.1AF5.0020.0002] # FULLWIDTH LATIN SMALL LETTER R
FF53      ; [.1B33.0020.0002] # FULLWIDTH LATIN SMALL LETTER S
FF54      ; [.1B57.0020.0002] # FULLWIDTH LATIN SMALL LETTER T
FF55      ; [.1B77.0020.0002] # FULLWIDTH LATIN SMALL LETTER U
FF56      ; [.1BA5.0020.0002] # FULLWIDTH LATIN SMALL LETTER V
FF57      ; [.1BB7.0020.0002] # FULLWIDTH LATIN SMALL LETTER W
FF58      ; [.1BC1.0020.0002] # FULLWIDTH LATIN SMALL LETTER X
FF59      ; [.1BCD.0020.0002] # FULLWIDTH LATIN SMALL LETTER Y
FF5A      ; [.1BE3.0020.0002] # FULLWIDTH LATIN SMALL LETTER Z
FF5B      ; [*030E.0020.0002] # FULLWIDTH LEFT CURLY BRACKET
FF5C      ; [*05DE.0020.0002] # FULLWIDTH VERTICAL LINE
FF5D      ; [*030F.0020.0002] # FULLWIDTH RIGHT CURLY BRACKET
FF5E      ; [*05E0.0020.0002] # FULLWIDTH TILDE
FF5F      ; [*0320.0020.0002] # FULLWIDTH LEFT WHITE PARENTHESIS
FF60      ; [*0321.0020.0002] # FULLWIDTH RIGHT WHITE PARENTHESIS
FF61      ; [*0287.0020.0002] # HALFWIDTH IDEOGRAPHIC FULL STOP
FF62      ; [*0366.0020.0002] # HALFWIDTH LEFT CORNER BRACKET
FF63      ; [*0367.0020.0002] # HALFWIDTH RIGHT CORNER BRACKET
FF64      ; [*0230.0020.0002] # HALFWIDTH IDEOGRAPHIC COMMA
FF65      ; [*0220.0020.0002] # HALFWIDTH KATAKANA MIDDLE DOT
FF66      ; [.3904.0020.0011.0002] # HALFWIDTH KATAKANA LETTER WO
FF67      ; [.38D4.0020.000F.0002] # HALFWIDTH KATAKANA LETTER SMALL A
FF68      ; [.38D5.0020.000F.0002] # HALFWIDTH KATAKANA LETTER SMALL I
FF69      ; [.38D6.0020.000F.0002] # HALFWIDTH KATAKANA LETTER SMALL U
FF6A      ; [.38D8.0020.000F.0002] # HALFWIDTH KATAKANA LETTER SMALL E
FF6B      ; [.38D9.0020.000F.0002] # HALFWIDTH KATAKANA LETTER SMALL O
FF6C      ; [.38F8.0020.000F.0002] # HALFWIDTH KATAKANA LETTER SMALL YA
FF6D      ; [.38F9.0020.000F.0002] # HALFWIDTH KATAKANA LETTER SMALL YU
FF6E      ; [.38FB.0020.000F.0002] # HALFWIDTH KATAKANA LETTER SMALL YO
FF6F      ; [.38E6.0020.000F.0002] # HALFWIDTH KATAKANA LETTER SMALL TU
FF70      ; [.18D4.0020.0002] # HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK
FF71      ; [.38D4.0020.0011.0002] # HALFWIDTH KATAKANA LETTER A
FF72      ; [.38D5.0020.0011.0002] # HALFWIDTH KATAKANA LETTER I
FF73      ; [.38D6.0020.0011.0002] # HALFWIDTH KATAKANA LETTER U
FF74      ; [.38D8.0020.0011.0002] # HALFWIDTH KATAKANA LETTER E
FF75      ; [.38D9.0020.0011.0002] # HALFWIDTH KATAKANA LETTER O
FF76      ; [.38DA.0020.0011.0002] # HALFWIDTH KATAKANA LETTER KA
FF77      ; [.38DB.0020.0011.0002] # HALFWIDTH KATAKANA LETTER KI
FF78      ; [.38DC.0020.0011.0002] # HALFWIDTH KATAKANA LETTER KU
FF79      ; [.38DD.0020.0011.0002] # HALFWIDTH KATAKANA LETTER KE
FF7A      ; [.38DE.0020.0011.0002] # HALFWIDTH KATAKANA LETTER KO
FF7B      ; [.38DF.0020.0011.0002] # HALFWIDTH KATAKANA LETTER SA
FF7C      ; [.38E0.0020.0011.0002] # HALFWIDTH KATAKANA LETTER SI
FF7D      ; [.38E1.0020.0011.0002] # HALFWIDTH KATAKANA LETTER SU
FF7E      ; [.38E2.0020.0011.0002] # HALFWIDTH KATAKANA LETTER SE
FF7F      ; [.38E3.0020.0011.0002] # HALFWIDTH KATAKANA LETTER SO
FF80      ; [.38E4.0020.0011.0002] # HALFWIDTH KATAKANA LETTER TA
FF81      ; [.38E5.0020.0011.0002] # HALFWIDTH KATAKANA LETTER TI
FF82      ; [.38E6.0020.0011.0002] # HALFWIDTH KATAKANA LETTER TU
FF83      ; [.38E7.0020.0011.0002] # HALFWIDTH KATAKANA LETTER TE
FF84      ; [.38E8.0020.0011.0002] # HALFWIDTH KATAKANA LETTER TO
FF85      ; [.38E9.0020.0011.0002] # HALFWIDTH KATAKANA LETTER NA
FF86      ; [.38EA.0020.0011.0002] # HALFWIDTH KATAKANA LETTER NI
FF87      ; [.38EB.0020.0011.0002] # HALFWIDTH KATAKANA LETTER NU
FF88      ; [.38EC.0020.0011.0002] # HALFWIDTH KATAKANA LETTER NE
FF89      ; [.38ED.0020.0011.0002] # HALFWIDTH KATAKANA LETTER NO
FF8A      ; [.38EE.0020.0011.0002] # HALFWIDTH KATAKANA LETTER HA
FF8B      ; [.38EF.0020.0011.0002] # HALFWIDTH KATAKANA LETTER HI
FF8C      ; [.38F0.0020.0011.0002] # HALFWIDTH KATAKANA LETTER HU
FF8D      ; [.38F1.0020.0011.0002] # HALFWIDTH KATAKANA LETTER HE
FF8E      ; [.38F2.0020.0011.0002] # HALFWIDTH KATAKANA LETTER HO
FF8F      ; [.38F3.0020.0011.0002] # HALFWIDTH KATAKANA LETTER MA
FF90      ; [.38F4.0020.0011.0002] # HALFWIDTH KATAKANA LETTER MI
FF91      ; [.38F5.0020.0011.0002] # HALFWIDTH KATAKANA LETTER MU
FF92      ; [.38F6.0020.0011.0002] # HALFWIDTH KATAKANA LETTER ME
FF93      ; [.38F7.0020.0011.0002] # HALFWIDTH KATAKANA LETTER MO
FF94      ; [.38F8.0020.0011.0002] # HALFWIDTH KATAKANA LETTER YA
FF95      ; [.38F9.0020.0011.0002] # HALFWIDTH KATAKANA LETTER YU
FF96      ; [.38FB.0020.0011.0002] # HALFWIDTH KATAKANA LETTER YO
FF97      ; [.38FC.0020.0011.0002] # HALFWIDTH KATAKANA LETTER RA
FF98      ; [.38FD.0020.0011.0002] # HALFWIDTH KATAKANA LETTER RI
FF99      ; [.38FE.0020.0011.0002] # HALFWIDTH KATAKANA LETTER RU
FF9A      ; [.38FF.0020.0011.0002] # HALFWIDTH KATAKANA LETTER RE
FF9B      ; [.3900.0020.0011.0002] # HALFWIDTH KATAKANA LETTER RO
FF9C      ; [.3901.0020.0011.0002] # HALFWIDTH KATAKANA LETTER WA
FF9D      ; [.3905.0020.0011.0002] # HALFWIDTH KATAKANA LETTER N
FF9E      ; [.0000.0037.0002] # HALFWIDTH KATAKANA VOICED SOUND MARK
FF9F      ; [.0000.0038.0002] # HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK
FFE0      ; [.18D7.0020.0002] # FULLWIDTH CENT SIGN
FFE1      ; [.18D9.0020.0002] # FULLWIDTH POUND SIGN
FFE2      ; [*05DD.0020.0002] # FULLWIDTH NOT SIGN
FFE3      ; [*0209.0020.0002] # FULLWIDTH MACRON
FFE4      ; [*05DF.0020.0002] # FULLWIDTH BROKEN BAR
FFE5      ; [.18DA.0020.0002] # FULLWIDTH YEN SIGN
FFE6      ; [.18ED.0020.0002] # FULLWIDTH WON SIGN
FFE8      ; [*07D6.0020.0002] # HALFWIDTH FORMS LIGHT VERTICAL
FFE9      ; [*055C.0020.0002] # HALFWIDTH LEFTWARDS ARROW
FFEA      ; [*055E.0020.0002] # HALFWIDTH UPWARDS ARROW
FFEB      ; [*055D.0020.0002] # HALFWIDTH RIGHTWARDS ARROW
FFEC      ; [*055F.0020.0002] # HALFWIDTH DOWNWARDS ARROW
FFED      ; [*0874.0020.0002] # HALFWIDTH BLACK SQUARE
FFEE      ; [*089F.0020.0002] # HALFWIDTH WHITE CIRCLE
30A1 30FC ; [.38D4.0020.000F.0002][.38D4.0020.0007.0002] # <KATAKANA LETTER SMALL A, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF67 30FC ; [.38D4.0020.000F.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SMALL A, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF67 FF70 ; [.38D4.0020.000F.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SMALL A, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3041 30FC ; [.38D4.0020.000F.0001][.38D4.0020.0007.0002] # <HIRAGANA LETTER SMALL A, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30A2 30FC ; [.38D4.0020.0011.0002][.38D4.0020.0007.0002] # <KATAKANA LETTER A, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF71 30FC ; [.38D4.0020.0011.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER A, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF71 FF70 ; [.38D4.0020.0011.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER A, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3042 30FC ; [.38D4.0020.0011.0001][.38D4.0020.0007.0002] # <HIRAGANA LETTER A, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30AB 30FC ; [.38DA.0020.0011.0002][.38D4.0020.0007.0002] # <KATAKANA LETTER KA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF76 30FC ; [.38DA.0020.0011.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER KA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF76 FF70 ; [.38DA.0020.0011.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER KA, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
304B 30FC ; [.38DA.0020.0011.0001][.38D4.0020.0007.0002] # <HIRAGANA LETTER KA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30AC 30FC ; [.38DA.0020.0011.0002][.0000.0037.0002][.38D4.0020.0007.0002] # <KATAKANA LETTER GA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30AB 3099 30FC ; [.38DA.0020.0011.0002][.0000.0037.0002][.38D4.0020.0007.0002] # <KATAKANA LETTER KA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF76 FF9E 30FC ; [.38DA.0020.0011.0002][.0000.0037.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER KA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF76 FF9E FF70 ; [.38DA.0020.0011.0002][.0000.0037.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER KA, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
304C 30FC ; [.38DA.0020.0011.0001][.0000.0037.0002][.38D4.0020.0007.0002] # <HIRAGANA LETTER GA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
304B 3099 30FC ; [.38DA.0020.0011.0001][.0000.0037.0002][.38D4.0020.0007.0002] # <HIRAGANA LETTER KA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B5 30FC ; [.38DF.0020.0011.0002][.38D4.0020.0007.0002] # <KATAKANA LETTER SA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7B 30FC ; [.38DF.0020.0011.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7B FF70 ; [.38DF.0020.0011.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SA, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3055 30FC ; [.38DF.0020.0011.0001][.38D4.0020.0007.0002] # <HIRAGANA LETTER SA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B6 30FC ; [.38DF.0020.0011.0002][.0000.0037.0002][.38D4.0020.0007.0002] # <KATAKANA LETTER ZA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B5 3099 30FC ; [.38DF.0020.0011.0002][.0000.0037.0002][.38D4.0020.0007.0002] # <KATAKANA LETTER SA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7B FF9E 30FC ; [.38DF.0020.0011.0002][.0000.0037.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7B FF9E FF70 ; [.38DF.0020.0011.0002][.0000.0037.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SA, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3056 30FC ; [.38DF.0020.0011.0001][.0000.0037.0002][.38D4.0020.0007.0002] # <HIRAGANA LETTER ZA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3055 3099 30FC ; [.38DF.0020.0011.0001][.0000.0037.0002][.38D4.0020.0007.0002] # <HIRAGANA LETTER SA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30BF 30FC ; [.38E4.0020.0011.0002][.38D4.0020.0007.0002] # <KATAKANA LETTER TA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF80 30FC ; [.38E4.0020.0011.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER TA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF80 FF70 ; [.38E4.0020.0011.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER TA, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
305F 30FC ; [.38E4.0020.0011.0001][.38D4.0020.0007.0002] # <HIRAGANA LETTER TA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C0 30FC ; [.38E4.0020.0011.0002][.0000.0037.0002][.38D4.0020.0007.0002] # <KATAKANA LETTER DA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30BF 3099 30FC ; [.38E4.0020.0011.0002][.0000.0037.0002][.38D4.0020.0007.0002] # <KATAKANA LETTER TA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF80 FF9E 30FC ; [.38E4.0020.0011.0002][.0000.0037.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER TA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF80 FF9E FF70 ; [.38E4.0020.0011.0002][.0000.0037.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER TA, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3060 30FC ; [.38E4.0020.0011.0001][.0000.0037.0002][.38D4.0020.0007.0002] # <HIRAGANA LETTER DA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
305F 3099 30FC ; [.38E4.0020.0011.0001][.0000.0037.0002][.38D4.0020.0007.0002] # <HIRAGANA LETTER TA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30CA 30FC ; [.38E9.0020.0011.0002][.38D4.0020.0007.0002] # <KATAKANA LETTER NA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF85 30FC ; [.38E9.0020.0011.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER NA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF85 FF70 ; [.38E9.0020.0011.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER NA, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
306A 30FC ; [.38E9.0020.0011.0001][.38D4.0020.0007.0002] # <HIRAGANA LETTER NA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30CF 30FC ; [.38EE.0020.0011.0002][.38D4.0020.0007.0002] # <KATAKANA LETTER HA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8A 30FC ; [.38EE.0020.0011.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER HA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8A FF70 ; [.38EE.0020.0011.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER HA, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
306F 30FC ; [.38EE.0020.0011.0001][.38D4.0020.0007.0002] # <HIRAGANA LETTER HA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D0 30FC ; [.38EE.0020.0011.0002][.0000.0037.0002][.38D4.0020.0007.0002] # <KATAKANA LETTER BA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30CF 3099 30FC ; [.38EE.0020.0011.0002][.0000.0037.0002][.38D4.0020.0007.0002] # <KATAKANA LETTER HA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8A FF9E 30FC ; [.38EE.0020.0011.0002][.0000.0037.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER HA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8A FF9E FF70 ; [.38EE.0020.0011.0002][.0000.0037.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER HA, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3070 30FC ; [.38EE.0020.0011.0001][.0000.0037.0002][.38D4.0020.0007.0002] # <HIRAGANA LETTER BA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
306F 3099 30FC ; [.38EE.0020.0011.0001][.0000.0037.0002][.38D4.0020.0007.0002] # <HIRAGANA LETTER HA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D1 30FC ; [.38EE.0020.0011.0002][.0000.0038.0002][.38D4.0020.0007.0002] # <KATAKANA LETTER PA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30CF 309A 30FC ; [.38EE.0020.0011.0002][.0000.0038.0002][.38D4.0020.0007.0002] # <KATAKANA LETTER HA, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8A FF9F 30FC ; [.38EE.0020.0011.0002][.0000.0038.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER HA, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8A FF9F FF70 ; [.38EE.0020.0011.0002][.0000.0038.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER HA, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3071 30FC ; [.38EE.0020.0011.0001][.0000.0038.0002][.38D4.0020.0007.0002] # <HIRAGANA LETTER PA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
306F 309A 30FC ; [.38EE.0020.0011.0001][.0000.0038.0002][.38D4.0020.0007.0002] # <HIRAGANA LETTER HA, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30DE 30FC ; [.38F3.0020.0011.0002][.38D4.0020.0007.0002] # <KATAKANA LETTER MA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8F 30FC ; [.38F3.0020.0011.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER MA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8F FF70 ; [.38F3.0020.0011.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER MA, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
307E 30FC ; [.38F3.0020.0011.0001][.38D4.0020.0007.0002] # <HIRAGANA LETTER MA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30E3 30FC ; [.38F8.0020.000F.0002][.38D4.0020.0007.0002] # <KATAKANA LETTER SMALL YA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6C 30FC ; [.38F8.0020.000F.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SMALL YA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6C FF70 ; [.38F8.0020.000F.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SMALL YA, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3083 30FC ; [.38F8.0020.000F.0001][.38D4.0020.0007.0002] # <HIRAGANA LETTER SMALL YA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30E4 30FC ; [.38F8.0020.0011.0002][.38D4.0020.0007.0002] # <KATAKANA LETTER YA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF94 30FC ; [.38F8.0020.0011.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER YA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF94 FF70 ; [.38F8.0020.0011.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER YA, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3084 30FC ; [.38F8.0020.0011.0001][.38D4.0020.0007.0002] # <HIRAGANA LETTER YA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30E9 30FC ; [.38FC.0020.0011.0002][.38D4.0020.0007.0002] # <KATAKANA LETTER RA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF97 30FC ; [.38FC.0020.0011.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER RA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF97 FF70 ; [.38FC.0020.0011.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER RA, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3089 30FC ; [.38FC.0020.0011.0001][.38D4.0020.0007.0002] # <HIRAGANA LETTER RA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30EE 30FC ; [.3901.0020.000F.0002][.38D4.0020.0007.0002] # <KATAKANA LETTER SMALL WA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
308E 30FC ; [.3901.0020.000F.0001][.38D4.0020.0007.0002] # <HIRAGANA LETTER SMALL WA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30EF 30FC ; [.3901.0020.0011.0002][.38D4.0020.0007.0002] # <KATAKANA LETTER WA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF9C 30FC ; [.3901.0020.0011.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER WA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF9C FF70 ; [.3901.0020.0011.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER WA, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
308F 30FC ; [.3901.0020.0011.0001][.38D4.0020.0007.0002] # <HIRAGANA LETTER WA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F7 30FC ; [.3901.0020.0011.0002][.0000.0037.0002][.38D4.0020.0007.0002] # <KATAKANA LETTER VA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30EF 3099 30FC ; [.3901.0020.0011.0002][.0000.0037.0002][.38D4.0020.0007.0002] # <KATAKANA LETTER WA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF9C FF9E 30FC ; [.3901.0020.0011.0002][.0000.0037.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER WA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF9C FF9E FF70 ; [.3901.0020.0011.0002][.0000.0037.0002][.38D4.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER WA, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F5 30FC ; [.38DA.0020.000F.0002][.38D4.0020.0007.0002] # <KATAKANA LETTER SMALL KA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3095 30FC ; [.38DA.0020.000F.0001][.38D4.0020.0007.0002] # <HIRAGANA LETTER SMALL KA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31F5 30FC ; [.38EE.0020.000F][.38D4.0020.0007.0002] # <KATAKANA LETTER SMALL HA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31FB 30FC ; [.38FC.0020.000F][.38D4.0020.0007.0002] # <KATAKANA LETTER SMALL RA, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30A3 30FC ; [.38D5.0020.000F.0002][.38D5.0020.0007.0002] # <KATAKANA LETTER SMALL I, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF68 30FC ; [.38D5.0020.000F.0002][.38D5.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SMALL I, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF68 FF70 ; [.38D5.0020.000F.0002][.38D5.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SMALL I, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3043 30FC ; [.38D5.0020.000F.0001][.38D5.0020.0007.0002] # <HIRAGANA LETTER SMALL I, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30A4 30FC ; [.38D5.0020.0011.0002][.38D5.0020.0007.0002] # <KATAKANA LETTER I, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF72 30FC ; [.38D5.0020.0011.0002][.38D5.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER I, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF72 FF70 ; [.38D5.0020.0011.0002][.38D5.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER I, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3044 30FC ; [.38D5.0020.0011.0001][.38D5.0020.0007.0002] # <HIRAGANA LETTER I, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30AD 30FC ; [.38DB.0020.0011.0002][.38D5.0020.0007.0002] # <KATAKANA LETTER KI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF77 30FC ; [.38DB.0020.0011.0002][.38D5.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER KI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF77 FF70 ; [.38DB.0020.0011.0002][.38D5.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER KI, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
304D 30FC ; [.38DB.0020.0011.0001][.38D5.0020.0007.0002] # <HIRAGANA LETTER KI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30AE 30FC ; [.38DB.0020.0011.0002][.0000.0037.0002][.38D5.0020.0007.0002] # <KATAKANA LETTER GI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30AD 3099 30FC ; [.38DB.0020.0011.0002][.0000.0037.0002][.38D5.0020.0007.0002] # <KATAKANA LETTER KI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF77 FF9E 30FC ; [.38DB.0020.0011.0002][.0000.0037.0002][.38D5.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER KI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF77 FF9E FF70 ; [.38DB.0020.0011.0002][.0000.0037.0002][.38D5.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER KI, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
304E 30FC ; [.38DB.0020.0011.0001][.0000.0037.0002][.38D5.0020.0007.0002] # <HIRAGANA LETTER GI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
304D 3099 30FC ; [.38DB.0020.0011.0001][.0000.0037.0002][.38D5.0020.0007.0002] # <HIRAGANA LETTER KI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B7 30FC ; [.38E0.0020.0011.0002][.38D5.0020.0007.0002] # <KATAKANA LETTER SI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7C 30FC ; [.38E0.0020.0011.0002][.38D5.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7C FF70 ; [.38E0.0020.0011.0002][.38D5.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SI, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3057 30FC ; [.38E0.0020.0011.0001][.38D5.0020.0007.0002] # <HIRAGANA LETTER SI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B8 30FC ; [.38E0.0020.0011.0002][.0000.0037.0002][.38D5.0020.0007.0002] # <KATAKANA LETTER ZI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B7 3099 30FC ; [.38E0.0020.0011.0002][.0000.0037.0002][.38D5.0020.0007.0002] # <KATAKANA LETTER SI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7C FF9E 30FC ; [.38E0.0020.0011.0002][.0000.0037.0002][.38D5.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7C FF9E FF70 ; [.38E0.0020.0011.0002][.0000.0037.0002][.38D5.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SI, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3058 30FC ; [.38E0.0020.0011.0001][.0000.0037.0002][.38D5.0020.0007.0002] # <HIRAGANA LETTER ZI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3057 3099 30FC ; [.38E0.0020.0011.0001][.0000.0037.0002][.38D5.0020.0007.0002] # <HIRAGANA LETTER SI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C1 30FC ; [.38E5.0020.0011.0002][.38D5.0020.0007.0002] # <KATAKANA LETTER TI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF81 30FC ; [.38E5.0020.0011.0002][.38D5.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER TI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF81 FF70 ; [.38E5.0020.0011.0002][.38D5.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER TI, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3061 30FC ; [.38E5.0020.0011.0001][.38D5.0020.0007.0002] # <HIRAGANA LETTER TI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C2 30FC ; [.38E5.0020.0011.0002][.0000.0037.0002][.38D5.0020.0007.0002] # <KATAKANA LETTER DI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C1 3099 30FC ; [.38E5.0020.0011.0002][.0000.0037.0002][.38D5.0020.0007.0002] # <KATAKANA LETTER TI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF81 FF9E 30FC ; [.38E5.0020.0011.0002][.0000.0037.0002][.38D5.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER TI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF81 FF9E FF70 ; [.38E5.0020.0011.0002][.0000.0037.0002][.38D5.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER TI, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3062 30FC ; [.38E5.0020.0011.0001][.0000.0037.0002][.38D5.0020.0007.0002] # <HIRAGANA LETTER DI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3061 3099 30FC ; [.38E5.0020.0011.0001][.0000.0037.0002][.38D5.0020.0007.0002] # <HIRAGANA LETTER TI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30CB 30FC ; [.38EA.0020.0011.0002][.38D5.0020.0007.0002] # <KATAKANA LETTER NI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF86 30FC ; [.38EA.0020.0011.0002][.38D5.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER NI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF86 FF70 ; [.38EA.0020.0011.0002][.38D5.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER NI, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
306B 30FC ; [.38EA.0020.0011.0001][.38D5.0020.0007.0002] # <HIRAGANA LETTER NI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D2 30FC ; [.38EF.0020.0011.0002][.38D5.0020.0007.0002] # <KATAKANA LETTER HI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8B 30FC ; [.38EF.0020.0011.0002][.38D5.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER HI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8B FF70 ; [.38EF.0020.0011.0002][.38D5.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER HI, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3072 30FC ; [.38EF.0020.0011.0001][.38D5.0020.0007.0002] # <HIRAGANA LETTER HI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D3 30FC ; [.38EF.0020.0011.0002][.0000.0037.0002][.38D5.0020.0007.0002] # <KATAKANA LETTER BI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D2 3099 30FC ; [.38EF.0020.0011.0002][.0000.0037.0002][.38D5.0020.0007.0002] # <KATAKANA LETTER HI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8B FF9E 30FC ; [.38EF.0020.0011.0002][.0000.0037.0002][.38D5.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER HI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8B FF9E FF70 ; [.38EF.0020.0011.0002][.0000.0037.0002][.38D5.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER HI, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3073 30FC ; [.38EF.0020.0011.0001][.0000.0037.0002][.38D5.0020.0007.0002] # <HIRAGANA LETTER BI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3072 3099 30FC ; [.38EF.0020.0011.0001][.0000.0037.0002][.38D5.0020.0007.0002] # <HIRAGANA LETTER HI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D4 30FC ; [.38EF.0020.0011.0002][.0000.0038.0002][.38D5.0020.0007.0002] # <KATAKANA LETTER PI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D2 309A 30FC ; [.38EF.0020.0011.0002][.0000.0038.0002][.38D5.0020.0007.0002] # <KATAKANA LETTER HI, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8B FF9F 30FC ; [.38EF.0020.0011.0002][.0000.0038.0002][.38D5.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER HI, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8B FF9F FF70 ; [.38EF.0020.0011.0002][.0000.0038.0002][.38D5.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER HI, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3074 30FC ; [.38EF.0020.0011.0001][.0000.0038.0002][.38D5.0020.0007.0002] # <HIRAGANA LETTER PI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3072 309A 30FC ; [.38EF.0020.0011.0001][.0000.0038.0002][.38D5.0020.0007.0002] # <HIRAGANA LETTER HI, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30DF 30FC ; [.38F4.0020.0011.0002][.38D5.0020.0007.0002] # <KATAKANA LETTER MI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF90 30FC ; [.38F4.0020.0011.0002][.38D5.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER MI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF90 FF70 ; [.38F4.0020.0011.0002][.38D5.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER MI, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
307F 30FC ; [.38F4.0020.0011.0001][.38D5.0020.0007.0002] # <HIRAGANA LETTER MI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30EA 30FC ; [.38FD.0020.0011.0002][.38D5.0020.0007.0002] # <KATAKANA LETTER RI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF98 30FC ; [.38FD.0020.0011.0002][.38D5.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER RI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF98 FF70 ; [.38FD.0020.0011.0002][.38D5.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER RI, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
308A 30FC ; [.38FD.0020.0011.0001][.38D5.0020.0007.0002] # <HIRAGANA LETTER RI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F0 30FC ; [.3902.0020.0011.0002][.38D5.0020.0007.0002] # <KATAKANA LETTER WI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3090 30FC ; [.3902.0020.0011.0001][.38D5.0020.0007.0002] # <HIRAGANA LETTER WI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F8 30FC ; [.3902.0020.0011.0002][.0000.0037.0002][.38D5.0020.0007.0002] # <KATAKANA LETTER VI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F0 3099 30FC ; [.3902.0020.0011.0002][.0000.0037.0002][.38D5.0020.0007.0002] # <KATAKANA LETTER WI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31F1 30FC ; [.38E0.0020.000F][.38D5.0020.0007.0002] # <KATAKANA LETTER SMALL SI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31F6 30FC ; [.38EF.0020.000F][.38D5.0020.0007.0002] # <KATAKANA LETTER SMALL HI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31FC 30FC ; [.38FD.0020.000F][.38D5.0020.0007.0002] # <KATAKANA LETTER SMALL RI, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30A5 30FC ; [.38D6.0020.000F.0002][.38D6.0020.0007.0002] # <KATAKANA LETTER SMALL U, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF69 30FC ; [.38D6.0020.000F.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SMALL U, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF69 FF70 ; [.38D6.0020.000F.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SMALL U, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3045 30FC ; [.38D6.0020.000F.0001][.38D6.0020.0007.0002] # <HIRAGANA LETTER SMALL U, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30A6 30FC ; [.38D6.0020.0011.0002][.38D6.0020.0007.0002] # <KATAKANA LETTER U, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF73 30FC ; [.38D6.0020.0011.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER U, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF73 FF70 ; [.38D6.0020.0011.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER U, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3046 30FC ; [.38D6.0020.0011.0001][.38D6.0020.0007.0002] # <HIRAGANA LETTER U, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30AF 30FC ; [.38DC.0020.0011.0002][.38D6.0020.0007.0002] # <KATAKANA LETTER KU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF78 30FC ; [.38DC.0020.0011.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER KU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF78 FF70 ; [.38DC.0020.0011.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER KU, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
304F 30FC ; [.38DC.0020.0011.0001][.38D6.0020.0007.0002] # <HIRAGANA LETTER KU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B0 30FC ; [.38DC.0020.0011.0002][.0000.0037.0002][.38D6.0020.0007.0002] # <KATAKANA LETTER GU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30AF 3099 30FC ; [.38DC.0020.0011.0002][.0000.0037.0002][.38D6.0020.0007.0002] # <KATAKANA LETTER KU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF78 FF9E 30FC ; [.38DC.0020.0011.0002][.0000.0037.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER KU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF78 FF9E FF70 ; [.38DC.0020.0011.0002][.0000.0037.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER KU, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3050 30FC ; [.38DC.0020.0011.0001][.0000.0037.0002][.38D6.0020.0007.0002] # <HIRAGANA LETTER GU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
304F 3099 30FC ; [.38DC.0020.0011.0001][.0000.0037.0002][.38D6.0020.0007.0002] # <HIRAGANA LETTER KU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B9 30FC ; [.38E1.0020.0011.0002][.38D6.0020.0007.0002] # <KATAKANA LETTER SU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7D 30FC ; [.38E1.0020.0011.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7D FF70 ; [.38E1.0020.0011.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SU, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3059 30FC ; [.38E1.0020.0011.0001][.38D6.0020.0007.0002] # <HIRAGANA LETTER SU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30BA 30FC ; [.38E1.0020.0011.0002][.0000.0037.0002][.38D6.0020.0007.0002] # <KATAKANA LETTER ZU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B9 3099 30FC ; [.38E1.0020.0011.0002][.0000.0037.0002][.38D6.0020.0007.0002] # <KATAKANA LETTER SU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7D FF9E 30FC ; [.38E1.0020.0011.0002][.0000.0037.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7D FF9E FF70 ; [.38E1.0020.0011.0002][.0000.0037.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SU, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
305A 30FC ; [.38E1.0020.0011.0001][.0000.0037.0002][.38D6.0020.0007.0002] # <HIRAGANA LETTER ZU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3059 3099 30FC ; [.38E1.0020.0011.0001][.0000.0037.0002][.38D6.0020.0007.0002] # <HIRAGANA LETTER SU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C3 30FC ; [.38E6.0020.000F.0002][.38D6.0020.0007.0002] # <KATAKANA LETTER SMALL TU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6F 30FC ; [.38E6.0020.000F.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SMALL TU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6F FF70 ; [.38E6.0020.000F.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SMALL TU, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3063 30FC ; [.38E6.0020.000F.0001][.38D6.0020.0007.0002] # <HIRAGANA LETTER SMALL TU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C4 30FC ; [.38E6.0020.0011.0002][.38D6.0020.0007.0002] # <KATAKANA LETTER TU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF82 30FC ; [.38E6.0020.0011.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER TU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF82 FF70 ; [.38E6.0020.0011.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER TU, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3064 30FC ; [.38E6.0020.0011.0001][.38D6.0020.0007.0002] # <HIRAGANA LETTER TU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C5 30FC ; [.38E6.0020.0011.0002][.0000.0037.0002][.38D6.0020.0007.0002] # <KATAKANA LETTER DU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C4 3099 30FC ; [.38E6.0020.0011.0002][.0000.0037.0002][.38D6.0020.0007.0002] # <KATAKANA LETTER TU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF82 FF9E 30FC ; [.38E6.0020.0011.0002][.0000.0037.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER TU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF82 FF9E FF70 ; [.38E6.0020.0011.0002][.0000.0037.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER TU, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3065 30FC ; [.38E6.0020.0011.0001][.0000.0037.0002][.38D6.0020.0007.0002] # <HIRAGANA LETTER DU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3064 3099 30FC ; [.38E6.0020.0011.0001][.0000.0037.0002][.38D6.0020.0007.0002] # <HIRAGANA LETTER TU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30CC 30FC ; [.38EB.0020.0011.0002][.38D6.0020.0007.0002] # <KATAKANA LETTER NU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF87 30FC ; [.38EB.0020.0011.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER NU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF87 FF70 ; [.38EB.0020.0011.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER NU, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
306C 30FC ; [.38EB.0020.0011.0001][.38D6.0020.0007.0002] # <HIRAGANA LETTER NU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D5 30FC ; [.38F0.0020.0011.0002][.38D6.0020.0007.0002] # <KATAKANA LETTER HU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8C 30FC ; [.38F0.0020.0011.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER HU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8C FF70 ; [.38F0.0020.0011.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER HU, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3075 30FC ; [.38F0.0020.0011.0001][.38D6.0020.0007.0002] # <HIRAGANA LETTER HU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D6 30FC ; [.38F0.0020.0011.0002][.0000.0037.0002][.38D6.0020.0007.0002] # <KATAKANA LETTER BU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D5 3099 30FC ; [.38F0.0020.0011.0002][.0000.0037.0002][.38D6.0020.0007.0002] # <KATAKANA LETTER HU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8C FF9E 30FC ; [.38F0.0020.0011.0002][.0000.0037.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER HU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8C FF9E FF70 ; [.38F0.0020.0011.0002][.0000.0037.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER HU, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3076 30FC ; [.38F0.0020.0011.0001][.0000.0037.0002][.38D6.0020.0007.0002] # <HIRAGANA LETTER BU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3075 3099 30FC ; [.38F0.0020.0011.0001][.0000.0037.0002][.38D6.0020.0007.0002] # <HIRAGANA LETTER HU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D7 30FC ; [.38F0.0020.0011.0002][.0000.0038.0002][.38D6.0020.0007.0002] # <KATAKANA LETTER PU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D5 309A 30FC ; [.38F0.0020.0011.0002][.0000.0038.0002][.38D6.0020.0007.0002] # <KATAKANA LETTER HU, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8C FF9F 30FC ; [.38F0.0020.0011.0002][.0000.0038.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER HU, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8C FF9F FF70 ; [.38F0.0020.0011.0002][.0000.0038.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER HU, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3077 30FC ; [.38F0.0020.0011.0001][.0000.0038.0002][.38D6.0020.0007.0002] # <HIRAGANA LETTER PU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3075 309A 30FC ; [.38F0.0020.0011.0001][.0000.0038.0002][.38D6.0020.0007.0002] # <HIRAGANA LETTER HU, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30E0 30FC ; [.38F5.0020.0011.0002][.38D6.0020.0007.0002] # <KATAKANA LETTER MU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF91 30FC ; [.38F5.0020.0011.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER MU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF91 FF70 ; [.38F5.0020.0011.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER MU, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3080 30FC ; [.38F5.0020.0011.0001][.38D6.0020.0007.0002] # <HIRAGANA LETTER MU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30E5 30FC ; [.38F9.0020.000F.0002][.38D6.0020.0007.0002] # <KATAKANA LETTER SMALL YU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6D 30FC ; [.38F9.0020.000F.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SMALL YU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6D FF70 ; [.38F9.0020.000F.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SMALL YU, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3085 30FC ; [.38F9.0020.000F.0001][.38D6.0020.0007.0002] # <HIRAGANA LETTER SMALL YU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30E6 30FC ; [.38F9.0020.0011.0002][.38D6.0020.0007.0002] # <KATAKANA LETTER YU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF95 30FC ; [.38F9.0020.0011.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER YU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF95 FF70 ; [.38F9.0020.0011.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER YU, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3086 30FC ; [.38F9.0020.0011.0001][.38D6.0020.0007.0002] # <HIRAGANA LETTER YU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30EB 30FC ; [.38FE.0020.0011.0002][.38D6.0020.0007.0002] # <KATAKANA LETTER RU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF99 30FC ; [.38FE.0020.0011.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER RU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF99 FF70 ; [.38FE.0020.0011.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER RU, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
308B 30FC ; [.38FE.0020.0011.0001][.38D6.0020.0007.0002] # <HIRAGANA LETTER RU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F4 30FC ; [.38D6.0020.0011.0002][.0000.0037.0002][.38D6.0020.0007.0002] # <KATAKANA LETTER VU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30A6 3099 30FC ; [.38D6.0020.0011.0002][.0000.0037.0002][.38D6.0020.0007.0002] # <KATAKANA LETTER U, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF73 FF9E 30FC ; [.38D6.0020.0011.0002][.0000.0037.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER U, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF73 FF9E FF70 ; [.38D6.0020.0011.0002][.0000.0037.0002][.38D6.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER U, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3094 30FC ; [.38D6.0020.0011.0001][.0000.0037.0002][.38D6.0020.0007.0002] # <HIRAGANA LETTER VU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3046 3099 30FC ; [.38D6.0020.0011.0001][.0000.0037.0002][.38D6.0020.0007.0002] # <HIRAGANA LETTER U, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31F0 30FC ; [.38DC.0020.000F][.38D6.0020.0007.0002] # <KATAKANA LETTER SMALL KU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31F2 30FC ; [.38E1.0020.000F][.38D6.0020.0007.0002] # <KATAKANA LETTER SMALL SU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31F4 30FC ; [.38EB.0020.000F][.38D6.0020.0007.0002] # <KATAKANA LETTER SMALL NU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31F7 30FC ; [.38F0.0020.000F][.38D6.0020.0007.0002] # <KATAKANA LETTER SMALL HU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31FA 30FC ; [.38F5.0020.000F][.38D6.0020.0007.0002] # <KATAKANA LETTER SMALL MU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31FD 30FC ; [.38FE.0020.000F][.38D6.0020.0007.0002] # <KATAKANA LETTER SMALL RU, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30A7 30FC ; [.38D8.0020.000F.0002][.38D8.0020.0007.0002] # <KATAKANA LETTER SMALL E, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6A 30FC ; [.38D8.0020.000F.0002][.38D8.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SMALL E, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6A FF70 ; [.38D8.0020.000F.0002][.38D8.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SMALL E, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3047 30FC ; [.38D8.0020.000F.0001][.38D8.0020.0007.0002] # <HIRAGANA LETTER SMALL E, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30A8 30FC ; [.38D8.0020.0011.0002][.38D8.0020.0007.0002] # <KATAKANA LETTER E, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF74 30FC ; [.38D8.0020.0011.0002][.38D8.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER E, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF74 FF70 ; [.38D8.0020.0011.0002][.38D8.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER E, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3048 30FC ; [.38D8.0020.0011.0001][.38D8.0020.0007.0002] # <HIRAGANA LETTER E, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B1 30FC ; [.38DD.0020.0011.0002][.38D8.0020.0007.0002] # <KATAKANA LETTER KE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF79 30FC ; [.38DD.0020.0011.0002][.38D8.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER KE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF79 FF70 ; [.38DD.0020.0011.0002][.38D8.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER KE, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3051 30FC ; [.38DD.0020.0011.0001][.38D8.0020.0007.0002] # <HIRAGANA LETTER KE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B2 30FC ; [.38DD.0020.0011.0002][.0000.0037.0002][.38D8.0020.0007.0002] # <KATAKANA LETTER GE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B1 3099 30FC ; [.38DD.0020.0011.0002][.0000.0037.0002][.38D8.0020.0007.0002] # <KATAKANA LETTER KE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF79 FF9E 30FC ; [.38DD.0020.0011.0002][.0000.0037.0002][.38D8.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER KE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF79 FF9E FF70 ; [.38DD.0020.0011.0002][.0000.0037.0002][.38D8.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER KE, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3052 30FC ; [.38DD.0020.0011.0001][.0000.0037.0002][.38D8.0020.0007.0002] # <HIRAGANA LETTER GE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3051 3099 30FC ; [.38DD.0020.0011.0001][.0000.0037.0002][.38D8.0020.0007.0002] # <HIRAGANA LETTER KE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30BB 30FC ; [.38E2.0020.0011.0002][.38D8.0020.0007.0002] # <KATAKANA LETTER SE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7E 30FC ; [.38E2.0020.0011.0002][.38D8.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7E FF70 ; [.38E2.0020.0011.0002][.38D8.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SE, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
305B 30FC ; [.38E2.0020.0011.0001][.38D8.0020.0007.0002] # <HIRAGANA LETTER SE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30BC 30FC ; [.38E2.0020.0011.0002][.0000.0037.0002][.38D8.0020.0007.0002] # <KATAKANA LETTER ZE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30BB 3099 30FC ; [.38E2.0020.0011.0002][.0000.0037.0002][.38D8.0020.0007.0002] # <KATAKANA LETTER SE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7E FF9E 30FC ; [.38E2.0020.0011.0002][.0000.0037.0002][.38D8.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7E FF9E FF70 ; [.38E2.0020.0011.0002][.0000.0037.0002][.38D8.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SE, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
305C 30FC ; [.38E2.0020.0011.0001][.0000.0037.0002][.38D8.0020.0007.0002] # <HIRAGANA LETTER ZE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
305B 3099 30FC ; [.38E2.0020.0011.0001][.0000.0037.0002][.38D8.0020.0007.0002] # <HIRAGANA LETTER SE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C6 30FC ; [.38E7.0020.0011.0002][.38D8.0020.0007.0002] # <KATAKANA LETTER TE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF83 30FC ; [.38E7.0020.0011.0002][.38D8.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER TE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF83 FF70 ; [.38E7.0020.0011.0002][.38D8.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER TE, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3066 30FC ; [.38E7.0020.0011.0001][.38D8.0020.0007.0002] # <HIRAGANA LETTER TE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C7 30FC ; [.38E7.0020.0011.0002][.0000.0037.0002][.38D8.0020.0007.0002] # <KATAKANA LETTER DE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C6 3099 30FC ; [.38E7.0020.0011.0002][.0000.0037.0002][.38D8.0020.0007.0002] # <KATAKANA LETTER TE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF83 FF9E 30FC ; [.38E7.0020.0011.0002][.0000.0037.0002][.38D8.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER TE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF83 FF9E FF70 ; [.38E7.0020.0011.0002][.0000.0037.0002][.38D8.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER TE, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3067 30FC ; [.38E7.0020.0011.0001][.0000.0037.0002][.38D8.0020.0007.0002] # <HIRAGANA LETTER DE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3066 3099 30FC ; [.38E7.0020.0011.0001][.0000.0037.0002][.38D8.0020.0007.0002] # <HIRAGANA LETTER TE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30CD 30FC ; [.38EC.0020.0011.0002][.38D8.0020.0007.0002] # <KATAKANA LETTER NE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF88 30FC ; [.38EC.0020.0011.0002][.38D8.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER NE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF88 FF70 ; [.38EC.0020.0011.0002][.38D8.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER NE, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
306D 30FC ; [.38EC.0020.0011.0001][.38D8.0020.0007.0002] # <HIRAGANA LETTER NE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D8 30FC ; [.38F1.0020.0011.0002][.38D8.0020.0007.0002] # <KATAKANA LETTER HE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8D 30FC ; [.38F1.0020.0011.0002][.38D8.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER HE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8D FF70 ; [.38F1.0020.0011.0002][.38D8.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER HE, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3078 30FC ; [.38F1.0020.0011.0001][.38D8.0020.0007.0002] # <HIRAGANA LETTER HE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D9 30FC ; [.38F1.0020.0011.0002][.0000.0037.0002][.38D8.0020.0007.0002] # <KATAKANA LETTER BE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D8 3099 30FC ; [.38F1.0020.0011.0002][.0000.0037.0002][.38D8.0020.0007.0002] # <KATAKANA LETTER HE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8D FF9E 30FC ; [.38F1.0020.0011.0002][.0000.0037.0002][.38D8.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER HE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8D FF9E FF70 ; [.38F1.0020.0011.0002][.0000.0037.0002][.38D8.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER HE, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3079 30FC ; [.38F1.0020.0011.0001][.0000.0037.0002][.38D8.0020.0007.0002] # <HIRAGANA LETTER BE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3078 3099 30FC ; [.38F1.0020.0011.0001][.0000.0037.0002][.38D8.0020.0007.0002] # <HIRAGANA LETTER HE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30DA 30FC ; [.38F1.0020.0011.0002][.0000.0038.0002][.38D8.0020.0007.0002] # <KATAKANA LETTER PE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30D8 309A 30FC ; [.38F1.0020.0011.0002][.0000.0038.0002][.38D8.0020.0007.0002] # <KATAKANA LETTER HE, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8D FF9F 30FC ; [.38F1.0020.0011.0002][.0000.0038.0002][.38D8.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER HE, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8D FF9F FF70 ; [.38F1.0020.0011.0002][.0000.0038.0002][.38D8.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER HE, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
307A 30FC ; [.38F1.0020.0011.0001][.0000.0038.0002][.38D8.0020.0007.0002] # <HIRAGANA LETTER PE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3078 309A 30FC ; [.38F1.0020.0011.0001][.0000.0038.0002][.38D8.0020.0007.0002] # <HIRAGANA LETTER HE, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30E1 30FC ; [.38F6.0020.0011.0002][.38D8.0020.0007.0002] # <KATAKANA LETTER ME, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF92 30FC ; [.38F6.0020.0011.0002][.38D8.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER ME, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF92 FF70 ; [.38F6.0020.0011.0002][.38D8.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER ME, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3081 30FC ; [.38F6.0020.0011.0001][.38D8.0020.0007.0002] # <HIRAGANA LETTER ME, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30EC 30FC ; [.38FF.0020.0011.0002][.38D8.0020.0007.0002] # <KATAKANA LETTER RE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF9A 30FC ; [.38FF.0020.0011.0002][.38D8.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER RE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF9A FF70 ; [.38FF.0020.0011.0002][.38D8.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER RE, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
308C 30FC ; [.38FF.0020.0011.0001][.38D8.0020.0007.0002] # <HIRAGANA LETTER RE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F1 30FC ; [.3903.0020.0011.0002][.38D8.0020.0007.0002] # <KATAKANA LETTER WE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3091 30FC ; [.3903.0020.0011.0001][.38D8.0020.0007.0002] # <HIRAGANA LETTER WE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F9 30FC ; [.3903.0020.0011.0002][.0000.0037.0002][.38D8.0020.0007.0002] # <KATAKANA LETTER VE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F1 3099 30FC ; [.3903.0020.0011.0002][.0000.0037.0002][.38D8.0020.0007.0002] # <KATAKANA LETTER WE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F6 30FC ; [.38DD.0020.000F.0002][.38D8.0020.0007.0002] # <KATAKANA LETTER SMALL KE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3096 30FC ; [.38DD.0020.000F.0001][.38D8.0020.0007.0002] # <HIRAGANA LETTER SMALL KE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31F8 30FC ; [.38F1.0020.000F][.38D8.0020.0007.0002] # <KATAKANA LETTER SMALL HE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31FE 30FC ; [.38FF.0020.000F][.38D8.0020.0007.0002] # <KATAKANA LETTER SMALL RE, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30A9 30FC ; [.38D9.0020.000F.0002][.38D9.0020.0007.0002] # <KATAKANA LETTER SMALL O, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6B 30FC ; [.38D9.0020.000F.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SMALL O, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6B FF70 ; [.38D9.0020.000F.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SMALL O, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3049 30FC ; [.38D9.0020.000F.0001][.38D9.0020.0007.0002] # <HIRAGANA LETTER SMALL O, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30AA 30FC ; [.38D9.0020.0011.0002][.38D9.0020.0007.0002] # <KATAKANA LETTER O, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF75 30FC ; [.38D9.0020.0011.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER O, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF75 FF70 ; [.38D9.0020.0011.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER O, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
304A 30FC ; [.38D9.0020.0011.0001][.38D9.0020.0007.0002] # <HIRAGANA LETTER O, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B3 30FC ; [.38DE.0020.0011.0002][.38D9.0020.0007.0002] # <KATAKANA LETTER KO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7A 30FC ; [.38DE.0020.0011.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER KO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7A FF70 ; [.38DE.0020.0011.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER KO, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3053 30FC ; [.38DE.0020.0011.0001][.38D9.0020.0007.0002] # <HIRAGANA LETTER KO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B4 30FC ; [.38DE.0020.0011.0002][.0000.0037.0002][.38D9.0020.0007.0002] # <KATAKANA LETTER GO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30B3 3099 30FC ; [.38DE.0020.0011.0002][.0000.0037.0002][.38D9.0020.0007.0002] # <KATAKANA LETTER KO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7A FF9E 30FC ; [.38DE.0020.0011.0002][.0000.0037.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER KO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7A FF9E FF70 ; [.38DE.0020.0011.0002][.0000.0037.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER KO, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3054 30FC ; [.38DE.0020.0011.0001][.0000.0037.0002][.38D9.0020.0007.0002] # <HIRAGANA LETTER GO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3053 3099 30FC ; [.38DE.0020.0011.0001][.0000.0037.0002][.38D9.0020.0007.0002] # <HIRAGANA LETTER KO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30BD 30FC ; [.38E3.0020.0011.0002][.38D9.0020.0007.0002] # <KATAKANA LETTER SO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7F 30FC ; [.38E3.0020.0011.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7F FF70 ; [.38E3.0020.0011.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SO, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
305D 30FC ; [.38E3.0020.0011.0001][.38D9.0020.0007.0002] # <HIRAGANA LETTER SO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30BE 30FC ; [.38E3.0020.0011.0002][.0000.0037.0002][.38D9.0020.0007.0002] # <KATAKANA LETTER ZO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30BD 3099 30FC ; [.38E3.0020.0011.0002][.0000.0037.0002][.38D9.0020.0007.0002] # <KATAKANA LETTER SO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7F FF9E 30FC ; [.38E3.0020.0011.0002][.0000.0037.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF7F FF9E FF70 ; [.38E3.0020.0011.0002][.0000.0037.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SO, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
305E 30FC ; [.38E3.0020.0011.0001][.0000.0037.0002][.38D9.0020.0007.0002] # <HIRAGANA LETTER ZO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
305D 3099 30FC ; [.38E3.0020.0011.0001][.0000.0037.0002][.38D9.0020.0007.0002] # <HIRAGANA LETTER SO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C8 30FC ; [.38E8.0020.0011.0002][.38D9.0020.0007.0002] # <KATAKANA LETTER TO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF84 30FC ; [.38E8.0020.0011.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER TO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF84 FF70 ; [.38E8.0020.0011.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER TO, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3068 30FC ; [.38E8.0020.0011.0001][.38D9.0020.0007.0002] # <HIRAGANA LETTER TO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C9 30FC ; [.38E8.0020.0011.0002][.0000.0037.0002][.38D9.0020.0007.0002] # <KATAKANA LETTER DO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30C8 3099 30FC ; [.38E8.0020.0011.0002][.0000.0037.0002][.38D9.0020.0007.0002] # <KATAKANA LETTER TO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF84 FF9E 30FC ; [.38E8.0020.0011.0002][.0000.0037.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER TO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF84 FF9E FF70 ; [.38E8.0020.0011.0002][.0000.0037.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER TO, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3069 30FC ; [.38E8.0020.0011.0001][.0000.0037.0002][.38D9.0020.0007.0002] # <HIRAGANA LETTER DO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3068 3099 30FC ; [.38E8.0020.0011.0001][.0000.0037.0002][.38D9.0020.0007.0002] # <HIRAGANA LETTER TO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30CE 30FC ; [.38ED.0020.0011.0002][.38D9.0020.0007.0002] # <KATAKANA LETTER NO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF89 30FC ; [.38ED.0020.0011.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER NO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF89 FF70 ; [.38ED.0020.0011.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER NO, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
306E 30FC ; [.38ED.0020.0011.0001][.38D9.0020.0007.0002] # <HIRAGANA LETTER NO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30DB 30FC ; [.38F2.0020.0011.0002][.38D9.0020.0007.0002] # <KATAKANA LETTER HO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8E 30FC ; [.38F2.0020.0011.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER HO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8E FF70 ; [.38F2.0020.0011.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER HO, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
307B 30FC ; [.38F2.0020.0011.0001][.38D9.0020.0007.0002] # <HIRAGANA LETTER HO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30DC 30FC ; [.38F2.0020.0011.0002][.0000.0037.0002][.38D9.0020.0007.0002] # <KATAKANA LETTER BO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30DB 3099 30FC ; [.38F2.0020.0011.0002][.0000.0037.0002][.38D9.0020.0007.0002] # <KATAKANA LETTER HO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8E FF9E 30FC ; [.38F2.0020.0011.0002][.0000.0037.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER HO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8E FF9E FF70 ; [.38F2.0020.0011.0002][.0000.0037.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER HO, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
307C 30FC ; [.38F2.0020.0011.0001][.0000.0037.0002][.38D9.0020.0007.0002] # <HIRAGANA LETTER BO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
307B 3099 30FC ; [.38F2.0020.0011.0001][.0000.0037.0002][.38D9.0020.0007.0002] # <HIRAGANA LETTER HO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30DD 30FC ; [.38F2.0020.0011.0002][.0000.0038.0002][.38D9.0020.0007.0002] # <KATAKANA LETTER PO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30DB 309A 30FC ; [.38F2.0020.0011.0002][.0000.0038.0002][.38D9.0020.0007.0002] # <KATAKANA LETTER HO, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8E FF9F 30FC ; [.38F2.0020.0011.0002][.0000.0038.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER HO, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF8E FF9F FF70 ; [.38F2.0020.0011.0002][.0000.0038.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER HO, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
307D 30FC ; [.38F2.0020.0011.0001][.0000.0038.0002][.38D9.0020.0007.0002] # <HIRAGANA LETTER PO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
307B 309A 30FC ; [.38F2.0020.0011.0001][.0000.0038.0002][.38D9.0020.0007.0002] # <HIRAGANA LETTER HO, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30E2 30FC ; [.38F7.0020.0011.0002][.38D9.0020.0007.0002] # <KATAKANA LETTER MO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF93 30FC ; [.38F7.0020.0011.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER MO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF93 FF70 ; [.38F7.0020.0011.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER MO, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3082 30FC ; [.38F7.0020.0011.0001][.38D9.0020.0007.0002] # <HIRAGANA LETTER MO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30E7 30FC ; [.38FB.0020.000F.0002][.38D9.0020.0007.0002] # <KATAKANA LETTER SMALL YO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6E 30FC ; [.38FB.0020.000F.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SMALL YO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF6E FF70 ; [.38FB.0020.000F.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER SMALL YO, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3087 30FC ; [.38FB.0020.000F.0001][.38D9.0020.0007.0002] # <HIRAGANA LETTER SMALL YO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30E8 30FC ; [.38FB.0020.0011.0002][.38D9.0020.0007.0002] # <KATAKANA LETTER YO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF96 30FC ; [.38FB.0020.0011.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER YO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF96 FF70 ; [.38FB.0020.0011.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER YO, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3088 30FC ; [.38FB.0020.0011.0001][.38D9.0020.0007.0002] # <HIRAGANA LETTER YO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30ED 30FC ; [.3900.0020.0011.0002][.38D9.0020.0007.0002] # <KATAKANA LETTER RO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF9B 30FC ; [.3900.0020.0011.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER RO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF9B FF70 ; [.3900.0020.0011.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER RO, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
308D 30FC ; [.3900.0020.0011.0001][.38D9.0020.0007.0002] # <HIRAGANA LETTER RO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F2 30FC ; [.3904.0020.0011.0002][.38D9.0020.0007.0002] # <KATAKANA LETTER WO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF66 30FC ; [.3904.0020.0011.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER WO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF66 FF70 ; [.3904.0020.0011.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER WO, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
3092 30FC ; [.3904.0020.0011.0001][.38D9.0020.0007.0002] # <HIRAGANA LETTER WO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30FA 30FC ; [.3904.0020.0011.0002][.0000.0037.0002][.38D9.0020.0007.0002] # <KATAKANA LETTER VO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30F2 3099 30FC ; [.3904.0020.0011.0002][.0000.0037.0002][.38D9.0020.0007.0002] # <KATAKANA LETTER WO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF66 FF9E 30FC ; [.3904.0020.0011.0002][.0000.0037.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER WO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
FF66 FF9E FF70 ; [.3904.0020.0011.0002][.0000.0037.0002][.38D9.0020.0007.0002] # <HALFWIDTH KATAKANA LETTER WO, HALFWIDTH KATAKANA VOICED SOUND MARK, HALFWIDTH KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31F3 30FC ; [.38E8.0020.000F][.38D9.0020.0007.0002] # <KATAKANA LETTER SMALL TO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31F9 30FC ; [.38F2.0020.000F][.38D9.0020.0007.0002] # <KATAKANA LETTER SMALL HO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
31FF 30FC ; [.3900.0020.000F][.38D9.0020.0007.0002] # <KATAKANA LETTER SMALL RO, KATAKANA-HIRAGANA PROLONGED SOUND MARK>
30A1 30FD ; [.38D4.0020.000F.0002][.38D4.0020.0010.0002] # <KATAKANA LETTER SMALL A, KATAKANA ITERATION MARK>
FF67 30FD ; [.38D4.0020.000F.0002][.38D4.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER SMALL A, KATAKANA ITERATION MARK>
3041 309D ; [.38D4.0020.000F.0001][.38D4.0020.0010.0002] # <HIRAGANA LETTER SMALL A, HIRAGANA ITERATION MARK>
30A2 30FD ; [.38D4.0020.0011.0002][.38D4.0020.0010.0002] # <KATAKANA LETTER A, KATAKANA ITERATION MARK>
FF71 30FD ; [.38D4.0020.0011.0002][.38D4.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER A, KATAKANA ITERATION MARK>
3042 309D ; [.38D4.0020.0011.0001][.38D4.0020.0010.0002] # <HIRAGANA LETTER A, HIRAGANA ITERATION MARK>
30A3 30FD ; [.38D5.0020.000F.0002][.38D5.0020.0010.0002] # <KATAKANA LETTER SMALL I, KATAKANA ITERATION MARK>
FF68 30FD ; [.38D5.0020.000F.0002][.38D5.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER SMALL I, KATAKANA ITERATION MARK>
3043 309D ; [.38D5.0020.000F.0001][.38D5.0020.0010.0002] # <HIRAGANA LETTER SMALL I, HIRAGANA ITERATION MARK>
30A4 30FD ; [.38D5.0020.0011.0002][.38D5.0020.0010.0002] # <KATAKANA LETTER I, KATAKANA ITERATION MARK>
FF72 30FD ; [.38D5.0020.0011.0002][.38D5.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER I, KATAKANA ITERATION MARK>
3044 309D ; [.38D5.0020.0011.0001][.38D5.0020.0010.0002] # <HIRAGANA LETTER I, HIRAGANA ITERATION MARK>
30A5 30FD ; [.38D6.0020.000F.0002][.38D6.0020.0010.0002] # <KATAKANA LETTER SMALL U, KATAKANA ITERATION MARK>
FF69 30FD ; [.38D6.0020.000F.0002][.38D6.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER SMALL U, KATAKANA ITERATION MARK>
3045 309D ; [.38D6.0020.000F.0001][.38D6.0020.0010.0002] # <HIRAGANA LETTER SMALL U, HIRAGANA ITERATION MARK>
30A5 30FE ; [.38D6.0020.000F.0002][.38D6.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER SMALL U, KATAKANA VOICED ITERATION MARK>
FF69 30FE ; [.38D6.0020.000F.0002][.38D6.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER SMALL U, KATAKANA VOICED ITERATION MARK>
3045 309E ; [.38D6.0020.000F.0001][.38D6.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER SMALL U, HIRAGANA VOICED ITERATION MARK>
30A6 30FD ; [.38D6.0020.0011.0002][.38D6.0020.0010.0002] # <KATAKANA LETTER U, KATAKANA ITERATION MARK>
FF73 30FD ; [.38D6.0020.0011.0002][.38D6.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER U, KATAKANA ITERATION MARK>
3046 309D ; [.38D6.0020.0011.0001][.38D6.0020.0010.0002] # <HIRAGANA LETTER U, HIRAGANA ITERATION MARK>
30A6 30FE ; [.38D6.0020.0011.0002][.38D6.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER U, KATAKANA VOICED ITERATION MARK>
FF73 30FE ; [.38D6.0020.0011.0002][.38D6.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER U, KATAKANA VOICED ITERATION MARK>
3046 309E ; [.38D6.0020.0011.0001][.38D6.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER U, HIRAGANA VOICED ITERATION MARK>
30A7 30FD ; [.38D8.0020.000F.0002][.38D8.0020.0010.0002] # <KATAKANA LETTER SMALL E, KATAKANA ITERATION MARK>
FF6A 30FD ; [.38D8.0020.000F.0002][.38D8.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER SMALL E, KATAKANA ITERATION MARK>
3047 309D ; [.38D8.0020.000F.0001][.38D8.0020.0010.0002] # <HIRAGANA LETTER SMALL E, HIRAGANA ITERATION MARK>
30A8 30FD ; [.38D8.0020.0011.0002][.38D8.0020.0010.0002] # <KATAKANA LETTER E, KATAKANA ITERATION MARK>
FF74 30FD ; [.38D8.0020.0011.0002][.38D8.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER E, KATAKANA ITERATION MARK>
3048 309D ; [.38D8.0020.0011.0001][.38D8.0020.0010.0002] # <HIRAGANA LETTER E, HIRAGANA ITERATION MARK>
30A9 30FD ; [.38D9.0020.000F.0002][.38D9.0020.0010.0002] # <KATAKANA LETTER SMALL O, KATAKANA ITERATION MARK>
FF6B 30FD ; [.38D9.0020.000F.0002][.38D9.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER SMALL O, KATAKANA ITERATION MARK>
3049 309D ; [.38D9.0020.000F.0001][.38D9.0020.0010.0002] # <HIRAGANA LETTER SMALL O, HIRAGANA ITERATION MARK>
30AA 30FD ; [.38D9.0020.0011.0002][.38D9.0020.0010.0002] # <KATAKANA LETTER O, KATAKANA ITERATION MARK>
FF75 30FD ; [.38D9.0020.0011.0002][.38D9.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER O, KATAKANA ITERATION MARK>
304A 309D ; [.38D9.0020.0011.0001][.38D9.0020.0010.0002] # <HIRAGANA LETTER O, HIRAGANA ITERATION MARK>
30AB 30FD ; [.38DA.0020.0011.0002][.38DA.0020.0010.0002] # <KATAKANA LETTER KA, KATAKANA ITERATION MARK>
FF76 30FD ; [.38DA.0020.0011.0002][.38DA.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER KA, KATAKANA ITERATION MARK>
304B 309D ; [.38DA.0020.0011.0001][.38DA.0020.0010.0002] # <HIRAGANA LETTER KA, HIRAGANA ITERATION MARK>
30AB 30FE ; [.38DA.0020.0011.0002][.38DA.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER KA, KATAKANA VOICED ITERATION MARK>
FF76 30FE ; [.38DA.0020.0011.0002][.38DA.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER KA, KATAKANA VOICED ITERATION MARK>
304B 309E ; [.38DA.0020.0011.0001][.38DA.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER KA, HIRAGANA VOICED ITERATION MARK>
30AC 30FD ; [.38DA.0020.0011.0002][.0000.0037.0002][.38DA.0020.0010.0002] # <KATAKANA LETTER GA, KATAKANA ITERATION MARK>
30AB 3099 30FD ; [.38DA.0020.0011.0002][.0000.0037.0002][.38DA.0020.0010.0002] # <KATAKANA LETTER KA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF76 FF9E 30FD ; [.38DA.0020.0011.0002][.0000.0037.0002][.38DA.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER KA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
304C 309D ; [.38DA.0020.0011.0001][.0000.0037.0002][.38DA.0020.0010.0002] # <HIRAGANA LETTER GA, HIRAGANA ITERATION MARK>
304B 3099 309D ; [.38DA.0020.0011.0001][.0000.0037.0002][.38DA.0020.0010.0002] # <HIRAGANA LETTER KA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30AC 30FE ; [.38DA.0020.0011.0002][.0000.0037.0002][.38DA.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER GA, KATAKANA VOICED ITERATION MARK>
30AB 3099 30FE ; [.38DA.0020.0011.0002][.0000.0037.0002][.38DA.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER KA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF76 FF9E 30FE ; [.38DA.0020.0011.0002][.0000.0037.0002][.38DA.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER KA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
304C 309E ; [.38DA.0020.0011.0001][.0000.0037.0002][.38DA.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER GA, HIRAGANA VOICED ITERATION MARK>
304B 3099 309E ; [.38DA.0020.0011.0001][.0000.0037.0002][.38DA.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER KA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30AD 30FD ; [.38DB.0020.0011.0002][.38DB.0020.0010.0002] # <KATAKANA LETTER KI, KATAKANA ITERATION MARK>
FF77 30FD ; [.38DB.0020.0011.0002][.38DB.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER KI, KATAKANA ITERATION MARK>
304D 309D ; [.38DB.0020.0011.0001][.38DB.0020.0010.0002] # <HIRAGANA LETTER KI, HIRAGANA ITERATION MARK>
30AD 30FE ; [.38DB.0020.0011.0002][.38DB.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER KI, KATAKANA VOICED ITERATION MARK>
FF77 30FE ; [.38DB.0020.0011.0002][.38DB.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER KI, KATAKANA VOICED ITERATION MARK>
304D 309E ; [.38DB.0020.0011.0001][.38DB.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER KI, HIRAGANA VOICED ITERATION MARK>
30AE 30FD ; [.38DB.0020.0011.0002][.0000.0037.0002][.38DB.0020.0010.0002] # <KATAKANA LETTER GI, KATAKANA ITERATION MARK>
30AD 3099 30FD ; [.38DB.0020.0011.0002][.0000.0037.0002][.38DB.0020.0010.0002] # <KATAKANA LETTER KI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF77 FF9E 30FD ; [.38DB.0020.0011.0002][.0000.0037.0002][.38DB.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER KI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
304E 309D ; [.38DB.0020.0011.0001][.0000.0037.0002][.38DB.0020.0010.0002] # <HIRAGANA LETTER GI, HIRAGANA ITERATION MARK>
304D 3099 309D ; [.38DB.0020.0011.0001][.0000.0037.0002][.38DB.0020.0010.0002] # <HIRAGANA LETTER KI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30AE 30FE ; [.38DB.0020.0011.0002][.0000.0037.0002][.38DB.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER GI, KATAKANA VOICED ITERATION MARK>
30AD 3099 30FE ; [.38DB.0020.0011.0002][.0000.0037.0002][.38DB.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER KI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF77 FF9E 30FE ; [.38DB.0020.0011.0002][.0000.0037.0002][.38DB.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER KI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
304E 309E ; [.38DB.0020.0011.0001][.0000.0037.0002][.38DB.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER GI, HIRAGANA VOICED ITERATION MARK>
304D 3099 309E ; [.38DB.0020.0011.0001][.0000.0037.0002][.38DB.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER KI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30AF 30FD ; [.38DC.0020.0011.0002][.38DC.0020.0010.0002] # <KATAKANA LETTER KU, KATAKANA ITERATION MARK>
FF78 30FD ; [.38DC.0020.0011.0002][.38DC.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER KU, KATAKANA ITERATION MARK>
304F 309D ; [.38DC.0020.0011.0001][.38DC.0020.0010.0002] # <HIRAGANA LETTER KU, HIRAGANA ITERATION MARK>
30AF 30FE ; [.38DC.0020.0011.0002][.38DC.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER KU, KATAKANA VOICED ITERATION MARK>
FF78 30FE ; [.38DC.0020.0011.0002][.38DC.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER KU, KATAKANA VOICED ITERATION MARK>
304F 309E ; [.38DC.0020.0011.0001][.38DC.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER KU, HIRAGANA VOICED ITERATION MARK>
30B0 30FD ; [.38DC.0020.0011.0002][.0000.0037.0002][.38DC.0020.0010.0002] # <KATAKANA LETTER GU, KATAKANA ITERATION MARK>
30AF 3099 30FD ; [.38DC.0020.0011.0002][.0000.0037.0002][.38DC.0020.0010.0002] # <KATAKANA LETTER KU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF78 FF9E 30FD ; [.38DC.0020.0011.0002][.0000.0037.0002][.38DC.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER KU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3050 309D ; [.38DC.0020.0011.0001][.0000.0037.0002][.38DC.0020.0010.0002] # <HIRAGANA LETTER GU, HIRAGANA ITERATION MARK>
304F 3099 309D ; [.38DC.0020.0011.0001][.0000.0037.0002][.38DC.0020.0010.0002] # <HIRAGANA LETTER KU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30B0 30FE ; [.38DC.0020.0011.0002][.0000.0037.0002][.38DC.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER GU, KATAKANA VOICED ITERATION MARK>
30AF 3099 30FE ; [.38DC.0020.0011.0002][.0000.0037.0002][.38DC.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER KU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF78 FF9E 30FE ; [.38DC.0020.0011.0002][.0000.0037.0002][.38DC.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER KU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3050 309E ; [.38DC.0020.0011.0001][.0000.0037.0002][.38DC.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER GU, HIRAGANA VOICED ITERATION MARK>
304F 3099 309E ; [.38DC.0020.0011.0001][.0000.0037.0002][.38DC.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER KU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30B1 30FD ; [.38DD.0020.0011.0002][.38DD.0020.0010.0002] # <KATAKANA LETTER KE, KATAKANA ITERATION MARK>
FF79 30FD ; [.38DD.0020.0011.0002][.38DD.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER KE, KATAKANA ITERATION MARK>
3051 309D ; [.38DD.0020.0011.0001][.38DD.0020.0010.0002] # <HIRAGANA LETTER KE, HIRAGANA ITERATION MARK>
30B1 30FE ; [.38DD.0020.0011.0002][.38DD.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER KE, KATAKANA VOICED ITERATION MARK>
FF79 30FE ; [.38DD.0020.0011.0002][.38DD.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER KE, KATAKANA VOICED ITERATION MARK>
3051 309E ; [.38DD.0020.0011.0001][.38DD.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER KE, HIRAGANA VOICED ITERATION MARK>
30B2 30FD ; [.38DD.0020.0011.0002][.0000.0037.0002][.38DD.0020.0010.0002] # <KATAKANA LETTER GE, KATAKANA ITERATION MARK>
30B1 3099 30FD ; [.38DD.0020.0011.0002][.0000.0037.0002][.38DD.0020.0010.0002] # <KATAKANA LETTER KE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF79 FF9E 30FD ; [.38DD.0020.0011.0002][.0000.0037.0002][.38DD.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER KE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3052 309D ; [.38DD.0020.0011.0001][.0000.0037.0002][.38DD.0020.0010.0002] # <HIRAGANA LETTER GE, HIRAGANA ITERATION MARK>
3051 3099 309D ; [.38DD.0020.0011.0001][.0000.0037.0002][.38DD.0020.0010.0002] # <HIRAGANA LETTER KE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30B2 30FE ; [.38DD.0020.0011.0002][.0000.0037.0002][.38DD.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER GE, KATAKANA VOICED ITERATION MARK>
30B1 3099 30FE ; [.38DD.0020.0011.0002][.0000.0037.0002][.38DD.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER KE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF79 FF9E 30FE ; [.38DD.0020.0011.0002][.0000.0037.0002][.38DD.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER KE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3052 309E ; [.38DD.0020.0011.0001][.0000.0037.0002][.38DD.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER GE, HIRAGANA VOICED ITERATION MARK>
3051 3099 309E ; [.38DD.0020.0011.0001][.0000.0037.0002][.38DD.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER KE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30B3 30FD ; [.38DE.0020.0011.0002][.38DE.0020.0010.0002] # <KATAKANA LETTER KO, KATAKANA ITERATION MARK>
FF7A 30FD ; [.38DE.0020.0011.0002][.38DE.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER KO, KATAKANA ITERATION MARK>
3053 309D ; [.38DE.0020.0011.0001][.38DE.0020.0010.0002] # <HIRAGANA LETTER KO, HIRAGANA ITERATION MARK>
30B3 30FE ; [.38DE.0020.0011.0002][.38DE.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER KO, KATAKANA VOICED ITERATION MARK>
FF7A 30FE ; [.38DE.0020.0011.0002][.38DE.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER KO, KATAKANA VOICED ITERATION MARK>
3053 309E ; [.38DE.0020.0011.0001][.38DE.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER KO, HIRAGANA VOICED ITERATION MARK>
30B4 30FD ; [.38DE.0020.0011.0002][.0000.0037.0002][.38DE.0020.0010.0002] # <KATAKANA LETTER GO, KATAKANA ITERATION MARK>
30B3 3099 30FD ; [.38DE.0020.0011.0002][.0000.0037.0002][.38DE.0020.0010.0002] # <KATAKANA LETTER KO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF7A FF9E 30FD ; [.38DE.0020.0011.0002][.0000.0037.0002][.38DE.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER KO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3054 309D ; [.38DE.0020.0011.0001][.0000.0037.0002][.38DE.0020.0010.0002] # <HIRAGANA LETTER GO, HIRAGANA ITERATION MARK>
3053 3099 309D ; [.38DE.0020.0011.0001][.0000.0037.0002][.38DE.0020.0010.0002] # <HIRAGANA LETTER KO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30B4 30FE ; [.38DE.0020.0011.0002][.0000.0037.0002][.38DE.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER GO, KATAKANA VOICED ITERATION MARK>
30B3 3099 30FE ; [.38DE.0020.0011.0002][.0000.0037.0002][.38DE.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER KO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF7A FF9E 30FE ; [.38DE.0020.0011.0002][.0000.0037.0002][.38DE.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER KO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3054 309E ; [.38DE.0020.0011.0001][.0000.0037.0002][.38DE.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER GO, HIRAGANA VOICED ITERATION MARK>
3053 3099 309E ; [.38DE.0020.0011.0001][.0000.0037.0002][.38DE.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER KO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30B5 30FD ; [.38DF.0020.0011.0002][.38DF.0020.0010.0002] # <KATAKANA LETTER SA, KATAKANA ITERATION MARK>
FF7B 30FD ; [.38DF.0020.0011.0002][.38DF.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER SA, KATAKANA ITERATION MARK>
3055 309D ; [.38DF.0020.0011.0001][.38DF.0020.0010.0002] # <HIRAGANA LETTER SA, HIRAGANA ITERATION MARK>
30B5 30FE ; [.38DF.0020.0011.0002][.38DF.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER SA, KATAKANA VOICED ITERATION MARK>
FF7B 30FE ; [.38DF.0020.0011.0002][.38DF.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER SA, KATAKANA VOICED ITERATION MARK>
3055 309E ; [.38DF.0020.0011.0001][.38DF.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER SA, HIRAGANA VOICED ITERATION MARK>
30B6 30FD ; [.38DF.0020.0011.0002][.0000.0037.0002][.38DF.0020.0010.0002] # <KATAKANA LETTER ZA, KATAKANA ITERATION MARK>
30B5 3099 30FD ; [.38DF.0020.0011.0002][.0000.0037.0002][.38DF.0020.0010.0002] # <KATAKANA LETTER SA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF7B FF9E 30FD ; [.38DF.0020.0011.0002][.0000.0037.0002][.38DF.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER SA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3056 309D ; [.38DF.0020.0011.0001][.0000.0037.0002][.38DF.0020.0010.0002] # <HIRAGANA LETTER ZA, HIRAGANA ITERATION MARK>
3055 3099 309D ; [.38DF.0020.0011.0001][.0000.0037.0002][.38DF.0020.0010.0002] # <HIRAGANA LETTER SA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30B6 30FE ; [.38DF.0020.0011.0002][.0000.0037.0002][.38DF.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER ZA, KATAKANA VOICED ITERATION MARK>
30B5 3099 30FE ; [.38DF.0020.0011.0002][.0000.0037.0002][.38DF.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER SA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF7B FF9E 30FE ; [.38DF.0020.0011.0002][.0000.0037.0002][.38DF.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER SA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3056 309E ; [.38DF.0020.0011.0001][.0000.0037.0002][.38DF.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER ZA, HIRAGANA VOICED ITERATION MARK>
3055 3099 309E ; [.38DF.0020.0011.0001][.0000.0037.0002][.38DF.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER SA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30B7 30FD ; [.38E0.0020.0011.0002][.38E0.0020.0010.0002] # <KATAKANA LETTER SI, KATAKANA ITERATION MARK>
FF7C 30FD ; [.38E0.0020.0011.0002][.38E0.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER SI, KATAKANA ITERATION MARK>
3057 309D ; [.38E0.0020.0011.0001][.38E0.0020.0010.0002] # <HIRAGANA LETTER SI, HIRAGANA ITERATION MARK>
30B7 30FE ; [.38E0.0020.0011.0002][.38E0.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER SI, KATAKANA VOICED ITERATION MARK>
FF7C 30FE ; [.38E0.0020.0011.0002][.38E0.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER SI, KATAKANA VOICED ITERATION MARK>
3057 309E ; [.38E0.0020.0011.0001][.38E0.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER SI, HIRAGANA VOICED ITERATION MARK>
30B8 30FD ; [.38E0.0020.0011.0002][.0000.0037.0002][.38E0.0020.0010.0002] # <KATAKANA LETTER ZI, KATAKANA ITERATION MARK>
30B7 3099 30FD ; [.38E0.0020.0011.0002][.0000.0037.0002][.38E0.0020.0010.0002] # <KATAKANA LETTER SI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF7C FF9E 30FD ; [.38E0.0020.0011.0002][.0000.0037.0002][.38E0.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER SI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3058 309D ; [.38E0.0020.0011.0001][.0000.0037.0002][.38E0.0020.0010.0002] # <HIRAGANA LETTER ZI, HIRAGANA ITERATION MARK>
3057 3099 309D ; [.38E0.0020.0011.0001][.0000.0037.0002][.38E0.0020.0010.0002] # <HIRAGANA LETTER SI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30B8 30FE ; [.38E0.0020.0011.0002][.0000.0037.0002][.38E0.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER ZI, KATAKANA VOICED ITERATION MARK>
30B7 3099 30FE ; [.38E0.0020.0011.0002][.0000.0037.0002][.38E0.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER SI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF7C FF9E 30FE ; [.38E0.0020.0011.0002][.0000.0037.0002][.38E0.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER SI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3058 309E ; [.38E0.0020.0011.0001][.0000.0037.0002][.38E0.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER ZI, HIRAGANA VOICED ITERATION MARK>
3057 3099 309E ; [.38E0.0020.0011.0001][.0000.0037.0002][.38E0.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER SI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30B9 30FD ; [.38E1.0020.0011.0002][.38E1.0020.0010.0002] # <KATAKANA LETTER SU, KATAKANA ITERATION MARK>
FF7D 30FD ; [.38E1.0020.0011.0002][.38E1.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER SU, KATAKANA ITERATION MARK>
3059 309D ; [.38E1.0020.0011.0001][.38E1.0020.0010.0002] # <HIRAGANA LETTER SU, HIRAGANA ITERATION MARK>
30B9 30FE ; [.38E1.0020.0011.0002][.38E1.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER SU, KATAKANA VOICED ITERATION MARK>
FF7D 30FE ; [.38E1.0020.0011.0002][.38E1.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER SU, KATAKANA VOICED ITERATION MARK>
3059 309E ; [.38E1.0020.0011.0001][.38E1.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER SU, HIRAGANA VOICED ITERATION MARK>
30BA 30FD ; [.38E1.0020.0011.0002][.0000.0037.0002][.38E1.0020.0010.0002] # <KATAKANA LETTER ZU, KATAKANA ITERATION MARK>
30B9 3099 30FD ; [.38E1.0020.0011.0002][.0000.0037.0002][.38E1.0020.0010.0002] # <KATAKANA LETTER SU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF7D FF9E 30FD ; [.38E1.0020.0011.0002][.0000.0037.0002][.38E1.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER SU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
305A 309D ; [.38E1.0020.0011.0001][.0000.0037.0002][.38E1.0020.0010.0002] # <HIRAGANA LETTER ZU, HIRAGANA ITERATION MARK>
3059 3099 309D ; [.38E1.0020.0011.0001][.0000.0037.0002][.38E1.0020.0010.0002] # <HIRAGANA LETTER SU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30BA 30FE ; [.38E1.0020.0011.0002][.0000.0037.0002][.38E1.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER ZU, KATAKANA VOICED ITERATION MARK>
30B9 3099 30FE ; [.38E1.0020.0011.0002][.0000.0037.0002][.38E1.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER SU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF7D FF9E 30FE ; [.38E1.0020.0011.0002][.0000.0037.0002][.38E1.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER SU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
305A 309E ; [.38E1.0020.0011.0001][.0000.0037.0002][.38E1.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER ZU, HIRAGANA VOICED ITERATION MARK>
3059 3099 309E ; [.38E1.0020.0011.0001][.0000.0037.0002][.38E1.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER SU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30BB 30FD ; [.38E2.0020.0011.0002][.38E2.0020.0010.0002] # <KATAKANA LETTER SE, KATAKANA ITERATION MARK>
FF7E 30FD ; [.38E2.0020.0011.0002][.38E2.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER SE, KATAKANA ITERATION MARK>
305B 309D ; [.38E2.0020.0011.0001][.38E2.0020.0010.0002] # <HIRAGANA LETTER SE, HIRAGANA ITERATION MARK>
30BB 30FE ; [.38E2.0020.0011.0002][.38E2.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER SE, KATAKANA VOICED ITERATION MARK>
FF7E 30FE ; [.38E2.0020.0011.0002][.38E2.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER SE, KATAKANA VOICED ITERATION MARK>
305B 309E ; [.38E2.0020.0011.0001][.38E2.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER SE, HIRAGANA VOICED ITERATION MARK>
30BC 30FD ; [.38E2.0020.0011.0002][.0000.0037.0002][.38E2.0020.0010.0002] # <KATAKANA LETTER ZE, KATAKANA ITERATION MARK>
30BB 3099 30FD ; [.38E2.0020.0011.0002][.0000.0037.0002][.38E2.0020.0010.0002] # <KATAKANA LETTER SE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF7E FF9E 30FD ; [.38E2.0020.0011.0002][.0000.0037.0002][.38E2.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER SE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
305C 309D ; [.38E2.0020.0011.0001][.0000.0037.0002][.38E2.0020.0010.0002] # <HIRAGANA LETTER ZE, HIRAGANA ITERATION MARK>
305B 3099 309D ; [.38E2.0020.0011.0001][.0000.0037.0002][.38E2.0020.0010.0002] # <HIRAGANA LETTER SE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30BC 30FE ; [.38E2.0020.0011.0002][.0000.0037.0002][.38E2.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER ZE, KATAKANA VOICED ITERATION MARK>
30BB 3099 30FE ; [.38E2.0020.0011.0002][.0000.0037.0002][.38E2.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER SE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF7E FF9E 30FE ; [.38E2.0020.0011.0002][.0000.0037.0002][.38E2.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER SE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
305C 309E ; [.38E2.0020.0011.0001][.0000.0037.0002][.38E2.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER ZE, HIRAGANA VOICED ITERATION MARK>
305B 3099 309E ; [.38E2.0020.0011.0001][.0000.0037.0002][.38E2.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER SE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30BD 30FD ; [.38E3.0020.0011.0002][.38E3.0020.0010.0002] # <KATAKANA LETTER SO, KATAKANA ITERATION MARK>
FF7F 30FD ; [.38E3.0020.0011.0002][.38E3.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER SO, KATAKANA ITERATION MARK>
305D 309D ; [.38E3.0020.0011.0001][.38E3.0020.0010.0002] # <HIRAGANA LETTER SO, HIRAGANA ITERATION MARK>
30BD 30FE ; [.38E3.0020.0011.0002][.38E3.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER SO, KATAKANA VOICED ITERATION MARK>
FF7F 30FE ; [.38E3.0020.0011.0002][.38E3.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER SO, KATAKANA VOICED ITERATION MARK>
305D 309E ; [.38E3.0020.0011.0001][.38E3.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER SO, HIRAGANA VOICED ITERATION MARK>
30BE 30FD ; [.38E3.0020.0011.0002][.0000.0037.0002][.38E3.0020.0010.0002] # <KATAKANA LETTER ZO, KATAKANA ITERATION MARK>
30BD 3099 30FD ; [.38E3.0020.0011.0002][.0000.0037.0002][.38E3.0020.0010.0002] # <KATAKANA LETTER SO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF7F FF9E 30FD ; [.38E3.0020.0011.0002][.0000.0037.0002][.38E3.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER SO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
305E 309D ; [.38E3.0020.0011.0001][.0000.0037.0002][.38E3.0020.0010.0002] # <HIRAGANA LETTER ZO, HIRAGANA ITERATION MARK>
305D 3099 309D ; [.38E3.0020.0011.0001][.0000.0037.0002][.38E3.0020.0010.0002] # <HIRAGANA LETTER SO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30BE 30FE ; [.38E3.0020.0011.0002][.0000.0037.0002][.38E3.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER ZO, KATAKANA VOICED ITERATION MARK>
30BD 3099 30FE ; [.38E3.0020.0011.0002][.0000.0037.0002][.38E3.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER SO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF7F FF9E 30FE ; [.38E3.0020.0011.0002][.0000.0037.0002][.38E3.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER SO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
305E 309E ; [.38E3.0020.0011.0001][.0000.0037.0002][.38E3.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER ZO, HIRAGANA VOICED ITERATION MARK>
305D 3099 309E ; [.38E3.0020.0011.0001][.0000.0037.0002][.38E3.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER SO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30BF 30FD ; [.38E4.0020.0011.0002][.38E4.0020.0010.0002] # <KATAKANA LETTER TA, KATAKANA ITERATION MARK>
FF80 30FD ; [.38E4.0020.0011.0002][.38E4.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER TA, KATAKANA ITERATION MARK>
305F 309D ; [.38E4.0020.0011.0001][.38E4.0020.0010.0002] # <HIRAGANA LETTER TA, HIRAGANA ITERATION MARK>
30BF 30FE ; [.38E4.0020.0011.0002][.38E4.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER TA, KATAKANA VOICED ITERATION MARK>
FF80 30FE ; [.38E4.0020.0011.0002][.38E4.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER TA, KATAKANA VOICED ITERATION MARK>
305F 309E ; [.38E4.0020.0011.0001][.38E4.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER TA, HIRAGANA VOICED ITERATION MARK>
30C0 30FD ; [.38E4.0020.0011.0002][.0000.0037.0002][.38E4.0020.0010.0002] # <KATAKANA LETTER DA, KATAKANA ITERATION MARK>
30BF 3099 30FD ; [.38E4.0020.0011.0002][.0000.0037.0002][.38E4.0020.0010.0002] # <KATAKANA LETTER TA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF80 FF9E 30FD ; [.38E4.0020.0011.0002][.0000.0037.0002][.38E4.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER TA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3060 309D ; [.38E4.0020.0011.0001][.0000.0037.0002][.38E4.0020.0010.0002] # <HIRAGANA LETTER DA, HIRAGANA ITERATION MARK>
305F 3099 309D ; [.38E4.0020.0011.0001][.0000.0037.0002][.38E4.0020.0010.0002] # <HIRAGANA LETTER TA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30C0 30FE ; [.38E4.0020.0011.0002][.0000.0037.0002][.38E4.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER DA, KATAKANA VOICED ITERATION MARK>
30BF 3099 30FE ; [.38E4.0020.0011.0002][.0000.0037.0002][.38E4.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER TA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF80 FF9E 30FE ; [.38E4.0020.0011.0002][.0000.0037.0002][.38E4.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER TA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3060 309E ; [.38E4.0020.0011.0001][.0000.0037.0002][.38E4.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER DA, HIRAGANA VOICED ITERATION MARK>
305F 3099 309E ; [.38E4.0020.0011.0001][.0000.0037.0002][.38E4.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER TA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30C1 30FD ; [.38E5.0020.0011.0002][.38E5.0020.0010.0002] # <KATAKANA LETTER TI, KATAKANA ITERATION MARK>
FF81 30FD ; [.38E5.0020.0011.0002][.38E5.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER TI, KATAKANA ITERATION MARK>
3061 309D ; [.38E5.0020.0011.0001][.38E5.0020.0010.0002] # <HIRAGANA LETTER TI, HIRAGANA ITERATION MARK>
30C1 30FE ; [.38E5.0020.0011.0002][.38E5.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER TI, KATAKANA VOICED ITERATION MARK>
FF81 30FE ; [.38E5.0020.0011.0002][.38E5.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER TI, KATAKANA VOICED ITERATION MARK>
3061 309E ; [.38E5.0020.0011.0001][.38E5.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER TI, HIRAGANA VOICED ITERATION MARK>
30C2 30FD ; [.38E5.0020.0011.0002][.0000.0037.0002][.38E5.0020.0010.0002] # <KATAKANA LETTER DI, KATAKANA ITERATION MARK>
30C1 3099 30FD ; [.38E5.0020.0011.0002][.0000.0037.0002][.38E5.0020.0010.0002] # <KATAKANA LETTER TI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF81 FF9E 30FD ; [.38E5.0020.0011.0002][.0000.0037.0002][.38E5.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER TI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3062 309D ; [.38E5.0020.0011.0001][.0000.0037.0002][.38E5.0020.0010.0002] # <HIRAGANA LETTER DI, HIRAGANA ITERATION MARK>
3061 3099 309D ; [.38E5.0020.0011.0001][.0000.0037.0002][.38E5.0020.0010.0002] # <HIRAGANA LETTER TI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30C2 30FE ; [.38E5.0020.0011.0002][.0000.0037.0002][.38E5.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER DI, KATAKANA VOICED ITERATION MARK>
30C1 3099 30FE ; [.38E5.0020.0011.0002][.0000.0037.0002][.38E5.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER TI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF81 FF9E 30FE ; [.38E5.0020.0011.0002][.0000.0037.0002][.38E5.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER TI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3062 309E ; [.38E5.0020.0011.0001][.0000.0037.0002][.38E5.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER DI, HIRAGANA VOICED ITERATION MARK>
3061 3099 309E ; [.38E5.0020.0011.0001][.0000.0037.0002][.38E5.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER TI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30C3 30FD ; [.38E6.0020.000F.0002][.38E6.0020.0010.0002] # <KATAKANA LETTER SMALL TU, KATAKANA ITERATION MARK>
FF6F 30FD ; [.38E6.0020.000F.0002][.38E6.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER SMALL TU, KATAKANA ITERATION MARK>
3063 309D ; [.38E6.0020.000F.0001][.38E6.0020.0010.0002] # <HIRAGANA LETTER SMALL TU, HIRAGANA ITERATION MARK>
30C3 30FE ; [.38E6.0020.000F.0002][.38E6.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER SMALL TU, KATAKANA VOICED ITERATION MARK>
FF6F 30FE ; [.38E6.0020.000F.0002][.38E6.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER SMALL TU, KATAKANA VOICED ITERATION MARK>
3063 309E ; [.38E6.0020.000F.0001][.38E6.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER SMALL TU, HIRAGANA VOICED ITERATION MARK>
30C4 30FD ; [.38E6.0020.0011.0002][.38E6.0020.0010.0002] # <KATAKANA LETTER TU, KATAKANA ITERATION MARK>
FF82 30FD ; [.38E6.0020.0011.0002][.38E6.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER TU, KATAKANA ITERATION MARK>
3064 309D ; [.38E6.0020.0011.0001][.38E6.0020.0010.0002] # <HIRAGANA LETTER TU, HIRAGANA ITERATION MARK>
30C4 30FE ; [.38E6.0020.0011.0002][.38E6.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER TU, KATAKANA VOICED ITERATION MARK>
FF82 30FE ; [.38E6.0020.0011.0002][.38E6.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER TU, KATAKANA VOICED ITERATION MARK>
3064 309E ; [.38E6.0020.0011.0001][.38E6.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER TU, HIRAGANA VOICED ITERATION MARK>
30C5 30FD ; [.38E6.0020.0011.0002][.0000.0037.0002][.38E6.0020.0010.0002] # <KATAKANA LETTER DU, KATAKANA ITERATION MARK>
30C4 3099 30FD ; [.38E6.0020.0011.0002][.0000.0037.0002][.38E6.0020.0010.0002] # <KATAKANA LETTER TU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF82 FF9E 30FD ; [.38E6.0020.0011.0002][.0000.0037.0002][.38E6.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER TU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3065 309D ; [.38E6.0020.0011.0001][.0000.0037.0002][.38E6.0020.0010.0002] # <HIRAGANA LETTER DU, HIRAGANA ITERATION MARK>
3064 3099 309D ; [.38E6.0020.0011.0001][.0000.0037.0002][.38E6.0020.0010.0002] # <HIRAGANA LETTER TU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30C5 30FE ; [.38E6.0020.0011.0002][.0000.0037.0002][.38E6.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER DU, KATAKANA VOICED ITERATION MARK>
30C4 3099 30FE ; [.38E6.0020.0011.0002][.0000.0037.0002][.38E6.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER TU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF82 FF9E 30FE ; [.38E6.0020.0011.0002][.0000.0037.0002][.38E6.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER TU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3065 309E ; [.38E6.0020.0011.0001][.0000.0037.0002][.38E6.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER DU, HIRAGANA VOICED ITERATION MARK>
3064 3099 309E ; [.38E6.0020.0011.0001][.0000.0037.0002][.38E6.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER TU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30C6 30FD ; [.38E7.0020.0011.0002][.38E7.0020.0010.0002] # <KATAKANA LETTER TE, KATAKANA ITERATION MARK>
FF83 30FD ; [.38E7.0020.0011.0002][.38E7.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER TE, KATAKANA ITERATION MARK>
3066 309D ; [.38E7.0020.0011.0001][.38E7.0020.0010.0002] # <HIRAGANA LETTER TE, HIRAGANA ITERATION MARK>
30C6 30FE ; [.38E7.0020.0011.0002][.38E7.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER TE, KATAKANA VOICED ITERATION MARK>
FF83 30FE ; [.38E7.0020.0011.0002][.38E7.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER TE, KATAKANA VOICED ITERATION MARK>
3066 309E ; [.38E7.0020.0011.0001][.38E7.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER TE, HIRAGANA VOICED ITERATION MARK>
30C7 30FD ; [.38E7.0020.0011.0002][.0000.0037.0002][.38E7.0020.0010.0002] # <KATAKANA LETTER DE, KATAKANA ITERATION MARK>
30C6 3099 30FD ; [.38E7.0020.0011.0002][.0000.0037.0002][.38E7.0020.0010.0002] # <KATAKANA LETTER TE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF83 FF9E 30FD ; [.38E7.0020.0011.0002][.0000.0037.0002][.38E7.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER TE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3067 309D ; [.38E7.0020.0011.0001][.0000.0037.0002][.38E7.0020.0010.0002] # <HIRAGANA LETTER DE, HIRAGANA ITERATION MARK>
3066 3099 309D ; [.38E7.0020.0011.0001][.0000.0037.0002][.38E7.0020.0010.0002] # <HIRAGANA LETTER TE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30C7 30FE ; [.38E7.0020.0011.0002][.0000.0037.0002][.38E7.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER DE, KATAKANA VOICED ITERATION MARK>
30C6 3099 30FE ; [.38E7.0020.0011.0002][.0000.0037.0002][.38E7.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER TE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF83 FF9E 30FE ; [.38E7.0020.0011.0002][.0000.0037.0002][.38E7.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER TE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3067 309E ; [.38E7.0020.0011.0001][.0000.0037.0002][.38E7.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER DE, HIRAGANA VOICED ITERATION MARK>
3066 3099 309E ; [.38E7.0020.0011.0001][.0000.0037.0002][.38E7.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER TE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30C8 30FD ; [.38E8.0020.0011.0002][.38E8.0020.0010.0002] # <KATAKANA LETTER TO, KATAKANA ITERATION MARK>
FF84 30FD ; [.38E8.0020.0011.0002][.38E8.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER TO, KATAKANA ITERATION MARK>
3068 309D ; [.38E8.0020.0011.0001][.38E8.0020.0010.0002] # <HIRAGANA LETTER TO, HIRAGANA ITERATION MARK>
30C8 30FE ; [.38E8.0020.0011.0002][.38E8.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER TO, KATAKANA VOICED ITERATION MARK>
FF84 30FE ; [.38E8.0020.0011.0002][.38E8.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER TO, KATAKANA VOICED ITERATION MARK>
3068 309E ; [.38E8.0020.0011.0001][.38E8.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER TO, HIRAGANA VOICED ITERATION MARK>
30C9 30FD ; [.38E8.0020.0011.0002][.0000.0037.0002][.38E8.0020.0010.0002] # <KATAKANA LETTER DO, KATAKANA ITERATION MARK>
30C8 3099 30FD ; [.38E8.0020.0011.0002][.0000.0037.0002][.38E8.0020.0010.0002] # <KATAKANA LETTER TO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF84 FF9E 30FD ; [.38E8.0020.0011.0002][.0000.0037.0002][.38E8.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER TO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3069 309D ; [.38E8.0020.0011.0001][.0000.0037.0002][.38E8.0020.0010.0002] # <HIRAGANA LETTER DO, HIRAGANA ITERATION MARK>
3068 3099 309D ; [.38E8.0020.0011.0001][.0000.0037.0002][.38E8.0020.0010.0002] # <HIRAGANA LETTER TO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30C9 30FE ; [.38E8.0020.0011.0002][.0000.0037.0002][.38E8.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER DO, KATAKANA VOICED ITERATION MARK>
30C8 3099 30FE ; [.38E8.0020.0011.0002][.0000.0037.0002][.38E8.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER TO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF84 FF9E 30FE ; [.38E8.0020.0011.0002][.0000.0037.0002][.38E8.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER TO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3069 309E ; [.38E8.0020.0011.0001][.0000.0037.0002][.38E8.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER DO, HIRAGANA VOICED ITERATION MARK>
3068 3099 309E ; [.38E8.0020.0011.0001][.0000.0037.0002][.38E8.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER TO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30CA 30FD ; [.38E9.0020.0011.0002][.38E9.0020.0010.0002] # <KATAKANA LETTER NA, KATAKANA ITERATION MARK>
FF85 30FD ; [.38E9.0020.0011.0002][.38E9.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER NA, KATAKANA ITERATION MARK>
306A 309D ; [.38E9.0020.0011.0001][.38E9.0020.0010.0002] # <HIRAGANA LETTER NA, HIRAGANA ITERATION MARK>
30CB 30FD ; [.38EA.0020.0011.0002][.38EA.0020.0010.0002] # <KATAKANA LETTER NI, KATAKANA ITERATION MARK>
FF86 30FD ; [.38EA.0020.0011.0002][.38EA.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER NI, KATAKANA ITERATION MARK>
306B 309D ; [.38EA.0020.0011.0001][.38EA.0020.0010.0002] # <HIRAGANA LETTER NI, HIRAGANA ITERATION MARK>
30CC 30FD ; [.38EB.0020.0011.0002][.38EB.0020.0010.0002] # <KATAKANA LETTER NU, KATAKANA ITERATION MARK>
FF87 30FD ; [.38EB.0020.0011.0002][.38EB.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER NU, KATAKANA ITERATION MARK>
306C 309D ; [.38EB.0020.0011.0001][.38EB.0020.0010.0002] # <HIRAGANA LETTER NU, HIRAGANA ITERATION MARK>
30CD 30FD ; [.38EC.0020.0011.0002][.38EC.0020.0010.0002] # <KATAKANA LETTER NE, KATAKANA ITERATION MARK>
FF88 30FD ; [.38EC.0020.0011.0002][.38EC.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER NE, KATAKANA ITERATION MARK>
306D 309D ; [.38EC.0020.0011.0001][.38EC.0020.0010.0002] # <HIRAGANA LETTER NE, HIRAGANA ITERATION MARK>
30CE 30FD ; [.38ED.0020.0011.0002][.38ED.0020.0010.0002] # <KATAKANA LETTER NO, KATAKANA ITERATION MARK>
FF89 30FD ; [.38ED.0020.0011.0002][.38ED.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER NO, KATAKANA ITERATION MARK>
306E 309D ; [.38ED.0020.0011.0001][.38ED.0020.0010.0002] # <HIRAGANA LETTER NO, HIRAGANA ITERATION MARK>
30CF 30FD ; [.38EE.0020.0011.0002][.38EE.0020.0010.0002] # <KATAKANA LETTER HA, KATAKANA ITERATION MARK>
FF8A 30FD ; [.38EE.0020.0011.0002][.38EE.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER HA, KATAKANA ITERATION MARK>
306F 309D ; [.38EE.0020.0011.0001][.38EE.0020.0010.0002] # <HIRAGANA LETTER HA, HIRAGANA ITERATION MARK>
30CF 30FE ; [.38EE.0020.0011.0002][.38EE.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER HA, KATAKANA VOICED ITERATION MARK>
FF8A 30FE ; [.38EE.0020.0011.0002][.38EE.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER HA, KATAKANA VOICED ITERATION MARK>
306F 309E ; [.38EE.0020.0011.0001][.38EE.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER HA, HIRAGANA VOICED ITERATION MARK>
30D0 30FD ; [.38EE.0020.0011.0002][.0000.0037.0002][.38EE.0020.0010.0002] # <KATAKANA LETTER BA, KATAKANA ITERATION MARK>
30CF 3099 30FD ; [.38EE.0020.0011.0002][.0000.0037.0002][.38EE.0020.0010.0002] # <KATAKANA LETTER HA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF8A FF9E 30FD ; [.38EE.0020.0011.0002][.0000.0037.0002][.38EE.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER HA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3070 309D ; [.38EE.0020.0011.0001][.0000.0037.0002][.38EE.0020.0010.0002] # <HIRAGANA LETTER BA, HIRAGANA ITERATION MARK>
306F 3099 309D ; [.38EE.0020.0011.0001][.0000.0037.0002][.38EE.0020.0010.0002] # <HIRAGANA LETTER HA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30D0 30FE ; [.38EE.0020.0011.0002][.0000.0037.0002][.38EE.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER BA, KATAKANA VOICED ITERATION MARK>
30CF 3099 30FE ; [.38EE.0020.0011.0002][.0000.0037.0002][.38EE.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER HA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF8A FF9E 30FE ; [.38EE.0020.0011.0002][.0000.0037.0002][.38EE.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER HA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3070 309E ; [.38EE.0020.0011.0001][.0000.0037.0002][.38EE.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER BA, HIRAGANA VOICED ITERATION MARK>
306F 3099 309E ; [.38EE.0020.0011.0001][.0000.0037.0002][.38EE.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER HA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30D1 30FD ; [.38EE.0020.0011.0002][.0000.0038.0002][.38EE.0020.0010.0002] # <KATAKANA LETTER PA, KATAKANA ITERATION MARK>
30CF 309A 30FD ; [.38EE.0020.0011.0002][.0000.0038.0002][.38EE.0020.0010.0002] # <KATAKANA LETTER HA, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF8A FF9F 30FD ; [.38EE.0020.0011.0002][.0000.0038.0002][.38EE.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER HA, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA ITERATION MARK>
3071 309D ; [.38EE.0020.0011.0001][.0000.0038.0002][.38EE.0020.0010.0002] # <HIRAGANA LETTER PA, HIRAGANA ITERATION MARK>
306F 309A 309D ; [.38EE.0020.0011.0001][.0000.0038.0002][.38EE.0020.0010.0002] # <HIRAGANA LETTER HA, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30D1 30FE ; [.38EE.0020.0011.0002][.0000.0038.0002][.38EE.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER PA, KATAKANA VOICED ITERATION MARK>
30CF 309A 30FE ; [.38EE.0020.0011.0002][.0000.0038.0002][.38EE.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER HA, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF8A FF9F 30FE ; [.38EE.0020.0011.0002][.0000.0038.0002][.38EE.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER HA, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3071 309E ; [.38EE.0020.0011.0001][.0000.0038.0002][.38EE.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER PA, HIRAGANA VOICED ITERATION MARK>
306F 309A 309E ; [.38EE.0020.0011.0001][.0000.0038.0002][.38EE.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER HA, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30D2 30FD ; [.38EF.0020.0011.0002][.38EF.0020.0010.0002] # <KATAKANA LETTER HI, KATAKANA ITERATION MARK>
FF8B 30FD ; [.38EF.0020.0011.0002][.38EF.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER HI, KATAKANA ITERATION MARK>
3072 309D ; [.38EF.0020.0011.0001][.38EF.0020.0010.0002] # <HIRAGANA LETTER HI, HIRAGANA ITERATION MARK>
30D2 30FE ; [.38EF.0020.0011.0002][.38EF.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER HI, KATAKANA VOICED ITERATION MARK>
FF8B 30FE ; [.38EF.0020.0011.0002][.38EF.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER HI, KATAKANA VOICED ITERATION MARK>
3072 309E ; [.38EF.0020.0011.0001][.38EF.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER HI, HIRAGANA VOICED ITERATION MARK>
30D3 30FD ; [.38EF.0020.0011.0002][.0000.0037.0002][.38EF.0020.0010.0002] # <KATAKANA LETTER BI, KATAKANA ITERATION MARK>
30D2 3099 30FD ; [.38EF.0020.0011.0002][.0000.0037.0002][.38EF.0020.0010.0002] # <KATAKANA LETTER HI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF8B FF9E 30FD ; [.38EF.0020.0011.0002][.0000.0037.0002][.38EF.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER HI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3073 309D ; [.38EF.0020.0011.0001][.0000.0037.0002][.38EF.0020.0010.0002] # <HIRAGANA LETTER BI, HIRAGANA ITERATION MARK>
3072 3099 309D ; [.38EF.0020.0011.0001][.0000.0037.0002][.38EF.0020.0010.0002] # <HIRAGANA LETTER HI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30D3 30FE ; [.38EF.0020.0011.0002][.0000.0037.0002][.38EF.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER BI, KATAKANA VOICED ITERATION MARK>
30D2 3099 30FE ; [.38EF.0020.0011.0002][.0000.0037.0002][.38EF.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER HI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF8B FF9E 30FE ; [.38EF.0020.0011.0002][.0000.0037.0002][.38EF.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER HI, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3073 309E ; [.38EF.0020.0011.0001][.0000.0037.0002][.38EF.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER BI, HIRAGANA VOICED ITERATION MARK>
3072 3099 309E ; [.38EF.0020.0011.0001][.0000.0037.0002][.38EF.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER HI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30D4 30FD ; [.38EF.0020.0011.0002][.0000.0038.0002][.38EF.0020.0010.0002] # <KATAKANA LETTER PI, KATAKANA ITERATION MARK>
30D2 309A 30FD ; [.38EF.0020.0011.0002][.0000.0038.0002][.38EF.0020.0010.0002] # <KATAKANA LETTER HI, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF8B FF9F 30FD ; [.38EF.0020.0011.0002][.0000.0038.0002][.38EF.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER HI, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA ITERATION MARK>
3074 309D ; [.38EF.0020.0011.0001][.0000.0038.0002][.38EF.0020.0010.0002] # <HIRAGANA LETTER PI, HIRAGANA ITERATION MARK>
3072 309A 309D ; [.38EF.0020.0011.0001][.0000.0038.0002][.38EF.0020.0010.0002] # <HIRAGANA LETTER HI, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30D4 30FE ; [.38EF.0020.0011.0002][.0000.0038.0002][.38EF.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER PI, KATAKANA VOICED ITERATION MARK>
30D2 309A 30FE ; [.38EF.0020.0011.0002][.0000.0038.0002][.38EF.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER HI, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF8B FF9F 30FE ; [.38EF.0020.0011.0002][.0000.0038.0002][.38EF.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER HI, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3074 309E ; [.38EF.0020.0011.0001][.0000.0038.0002][.38EF.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER PI, HIRAGANA VOICED ITERATION MARK>
3072 309A 309E ; [.38EF.0020.0011.0001][.0000.0038.0002][.38EF.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER HI, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30D5 30FD ; [.38F0.0020.0011.0002][.38F0.0020.0010.0002] # <KATAKANA LETTER HU, KATAKANA ITERATION MARK>
FF8C 30FD ; [.38F0.0020.0011.0002][.38F0.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER HU, KATAKANA ITERATION MARK>
3075 309D ; [.38F0.0020.0011.0001][.38F0.0020.0010.0002] # <HIRAGANA LETTER HU, HIRAGANA ITERATION MARK>
30D5 30FE ; [.38F0.0020.0011.0002][.38F0.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER HU, KATAKANA VOICED ITERATION MARK>
FF8C 30FE ; [.38F0.0020.0011.0002][.38F0.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER HU, KATAKANA VOICED ITERATION MARK>
3075 309E ; [.38F0.0020.0011.0001][.38F0.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER HU, HIRAGANA VOICED ITERATION MARK>
30D6 30FD ; [.38F0.0020.0011.0002][.0000.0037.0002][.38F0.0020.0010.0002] # <KATAKANA LETTER BU, KATAKANA ITERATION MARK>
30D5 3099 30FD ; [.38F0.0020.0011.0002][.0000.0037.0002][.38F0.0020.0010.0002] # <KATAKANA LETTER HU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF8C FF9E 30FD ; [.38F0.0020.0011.0002][.0000.0037.0002][.38F0.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER HU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3076 309D ; [.38F0.0020.0011.0001][.0000.0037.0002][.38F0.0020.0010.0002] # <HIRAGANA LETTER BU, HIRAGANA ITERATION MARK>
3075 3099 309D ; [.38F0.0020.0011.0001][.0000.0037.0002][.38F0.0020.0010.0002] # <HIRAGANA LETTER HU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30D6 30FE ; [.38F0.0020.0011.0002][.0000.0037.0002][.38F0.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER BU, KATAKANA VOICED ITERATION MARK>
30D5 3099 30FE ; [.38F0.0020.0011.0002][.0000.0037.0002][.38F0.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER HU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF8C FF9E 30FE ; [.38F0.0020.0011.0002][.0000.0037.0002][.38F0.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER HU, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3076 309E ; [.38F0.0020.0011.0001][.0000.0037.0002][.38F0.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER BU, HIRAGANA VOICED ITERATION MARK>
3075 3099 309E ; [.38F0.0020.0011.0001][.0000.0037.0002][.38F0.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER HU, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30D7 30FD ; [.38F0.0020.0011.0002][.0000.0038.0002][.38F0.0020.0010.0002] # <KATAKANA LETTER PU, KATAKANA ITERATION MARK>
30D5 309A 30FD ; [.38F0.0020.0011.0002][.0000.0038.0002][.38F0.0020.0010.0002] # <KATAKANA LETTER HU, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF8C FF9F 30FD ; [.38F0.0020.0011.0002][.0000.0038.0002][.38F0.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER HU, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA ITERATION MARK>
3077 309D ; [.38F0.0020.0011.0001][.0000.0038.0002][.38F0.0020.0010.0002] # <HIRAGANA LETTER PU, HIRAGANA ITERATION MARK>
3075 309A 309D ; [.38F0.0020.0011.0001][.0000.0038.0002][.38F0.0020.0010.0002] # <HIRAGANA LETTER HU, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30D7 30FE ; [.38F0.0020.0011.0002][.0000.0038.0002][.38F0.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER PU, KATAKANA VOICED ITERATION MARK>
30D5 309A 30FE ; [.38F0.0020.0011.0002][.0000.0038.0002][.38F0.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER HU, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF8C FF9F 30FE ; [.38F0.0020.0011.0002][.0000.0038.0002][.38F0.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER HU, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3077 309E ; [.38F0.0020.0011.0001][.0000.0038.0002][.38F0.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER PU, HIRAGANA VOICED ITERATION MARK>
3075 309A 309E ; [.38F0.0020.0011.0001][.0000.0038.0002][.38F0.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER HU, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30D8 30FD ; [.38F1.0020.0011.0002][.38F1.0020.0010.0002] # <KATAKANA LETTER HE, KATAKANA ITERATION MARK>
FF8D 30FD ; [.38F1.0020.0011.0002][.38F1.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER HE, KATAKANA ITERATION MARK>
3078 309D ; [.38F1.0020.0011.0001][.38F1.0020.0010.0002] # <HIRAGANA LETTER HE, HIRAGANA ITERATION MARK>
30D8 30FE ; [.38F1.0020.0011.0002][.38F1.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER HE, KATAKANA VOICED ITERATION MARK>
FF8D 30FE ; [.38F1.0020.0011.0002][.38F1.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER HE, KATAKANA VOICED ITERATION MARK>
3078 309E ; [.38F1.0020.0011.0001][.38F1.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER HE, HIRAGANA VOICED ITERATION MARK>
30D9 30FD ; [.38F1.0020.0011.0002][.0000.0037.0002][.38F1.0020.0010.0002] # <KATAKANA LETTER BE, KATAKANA ITERATION MARK>
30D8 3099 30FD ; [.38F1.0020.0011.0002][.0000.0037.0002][.38F1.0020.0010.0002] # <KATAKANA LETTER HE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF8D FF9E 30FD ; [.38F1.0020.0011.0002][.0000.0037.0002][.38F1.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER HE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3079 309D ; [.38F1.0020.0011.0001][.0000.0037.0002][.38F1.0020.0010.0002] # <HIRAGANA LETTER BE, HIRAGANA ITERATION MARK>
3078 3099 309D ; [.38F1.0020.0011.0001][.0000.0037.0002][.38F1.0020.0010.0002] # <HIRAGANA LETTER HE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30D9 30FE ; [.38F1.0020.0011.0002][.0000.0037.0002][.38F1.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER BE, KATAKANA VOICED ITERATION MARK>
30D8 3099 30FE ; [.38F1.0020.0011.0002][.0000.0037.0002][.38F1.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER HE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF8D FF9E 30FE ; [.38F1.0020.0011.0002][.0000.0037.0002][.38F1.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER HE, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3079 309E ; [.38F1.0020.0011.0001][.0000.0037.0002][.38F1.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER BE, HIRAGANA VOICED ITERATION MARK>
3078 3099 309E ; [.38F1.0020.0011.0001][.0000.0037.0002][.38F1.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER HE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30DA 30FD ; [.38F1.0020.0011.0002][.0000.0038.0002][.38F1.0020.0010.0002] # <KATAKANA LETTER PE, KATAKANA ITERATION MARK>
30D8 309A 30FD ; [.38F1.0020.0011.0002][.0000.0038.0002][.38F1.0020.0010.0002] # <KATAKANA LETTER HE, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF8D FF9F 30FD ; [.38F1.0020.0011.0002][.0000.0038.0002][.38F1.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER HE, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA ITERATION MARK>
307A 309D ; [.38F1.0020.0011.0001][.0000.0038.0002][.38F1.0020.0010.0002] # <HIRAGANA LETTER PE, HIRAGANA ITERATION MARK>
3078 309A 309D ; [.38F1.0020.0011.0001][.0000.0038.0002][.38F1.0020.0010.0002] # <HIRAGANA LETTER HE, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30DA 30FE ; [.38F1.0020.0011.0002][.0000.0038.0002][.38F1.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER PE, KATAKANA VOICED ITERATION MARK>
30D8 309A 30FE ; [.38F1.0020.0011.0002][.0000.0038.0002][.38F1.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER HE, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF8D FF9F 30FE ; [.38F1.0020.0011.0002][.0000.0038.0002][.38F1.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER HE, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
307A 309E ; [.38F1.0020.0011.0001][.0000.0038.0002][.38F1.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER PE, HIRAGANA VOICED ITERATION MARK>
3078 309A 309E ; [.38F1.0020.0011.0001][.0000.0038.0002][.38F1.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER HE, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30DB 30FD ; [.38F2.0020.0011.0002][.38F2.0020.0010.0002] # <KATAKANA LETTER HO, KATAKANA ITERATION MARK>
FF8E 30FD ; [.38F2.0020.0011.0002][.38F2.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER HO, KATAKANA ITERATION MARK>
307B 309D ; [.38F2.0020.0011.0001][.38F2.0020.0010.0002] # <HIRAGANA LETTER HO, HIRAGANA ITERATION MARK>
30DB 30FE ; [.38F2.0020.0011.0002][.38F2.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER HO, KATAKANA VOICED ITERATION MARK>
FF8E 30FE ; [.38F2.0020.0011.0002][.38F2.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER HO, KATAKANA VOICED ITERATION MARK>
307B 309E ; [.38F2.0020.0011.0001][.38F2.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER HO, HIRAGANA VOICED ITERATION MARK>
30DC 30FD ; [.38F2.0020.0011.0002][.0000.0037.0002][.38F2.0020.0010.0002] # <KATAKANA LETTER BO, KATAKANA ITERATION MARK>
30DB 3099 30FD ; [.38F2.0020.0011.0002][.0000.0037.0002][.38F2.0020.0010.0002] # <KATAKANA LETTER HO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF8E FF9E 30FD ; [.38F2.0020.0011.0002][.0000.0037.0002][.38F2.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER HO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
307C 309D ; [.38F2.0020.0011.0001][.0000.0037.0002][.38F2.0020.0010.0002] # <HIRAGANA LETTER BO, HIRAGANA ITERATION MARK>
307B 3099 309D ; [.38F2.0020.0011.0001][.0000.0037.0002][.38F2.0020.0010.0002] # <HIRAGANA LETTER HO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30DC 30FE ; [.38F2.0020.0011.0002][.0000.0037.0002][.38F2.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER BO, KATAKANA VOICED ITERATION MARK>
30DB 3099 30FE ; [.38F2.0020.0011.0002][.0000.0037.0002][.38F2.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER HO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF8E FF9E 30FE ; [.38F2.0020.0011.0002][.0000.0037.0002][.38F2.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER HO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
307C 309E ; [.38F2.0020.0011.0001][.0000.0037.0002][.38F2.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER BO, HIRAGANA VOICED ITERATION MARK>
307B 3099 309E ; [.38F2.0020.0011.0001][.0000.0037.0002][.38F2.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER HO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30DD 30FD ; [.38F2.0020.0011.0002][.0000.0038.0002][.38F2.0020.0010.0002] # <KATAKANA LETTER PO, KATAKANA ITERATION MARK>
30DB 309A 30FD ; [.38F2.0020.0011.0002][.0000.0038.0002][.38F2.0020.0010.0002] # <KATAKANA LETTER HO, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF8E FF9F 30FD ; [.38F2.0020.0011.0002][.0000.0038.0002][.38F2.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER HO, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA ITERATION MARK>
307D 309D ; [.38F2.0020.0011.0001][.0000.0038.0002][.38F2.0020.0010.0002] # <HIRAGANA LETTER PO, HIRAGANA ITERATION MARK>
307B 309A 309D ; [.38F2.0020.0011.0001][.0000.0038.0002][.38F2.0020.0010.0002] # <HIRAGANA LETTER HO, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30DD 30FE ; [.38F2.0020.0011.0002][.0000.0038.0002][.38F2.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER PO, KATAKANA VOICED ITERATION MARK>
30DB 309A 30FE ; [.38F2.0020.0011.0002][.0000.0038.0002][.38F2.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER HO, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF8E FF9F 30FE ; [.38F2.0020.0011.0002][.0000.0038.0002][.38F2.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER HO, HALFWIDTH KATAKANA SEMI-VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
307D 309E ; [.38F2.0020.0011.0001][.0000.0038.0002][.38F2.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER PO, HIRAGANA VOICED ITERATION MARK>
307B 309A 309E ; [.38F2.0020.0011.0001][.0000.0038.0002][.38F2.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER HO, COMBINING KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30DE 30FD ; [.38F3.0020.0011.0002][.38F3.0020.0010.0002] # <KATAKANA LETTER MA, KATAKANA ITERATION MARK>
FF8F 30FD ; [.38F3.0020.0011.0002][.38F3.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER MA, KATAKANA ITERATION MARK>
307E 309D ; [.38F3.0020.0011.0001][.38F3.0020.0010.0002] # <HIRAGANA LETTER MA, HIRAGANA ITERATION MARK>
30DF 30FD ; [.38F4.0020.0011.0002][.38F4.0020.0010.0002] # <KATAKANA LETTER MI, KATAKANA ITERATION MARK>
FF90 30FD ; [.38F4.0020.0011.0002][.38F4.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER MI, KATAKANA ITERATION MARK>
307F 309D ; [.38F4.0020.0011.0001][.38F4.0020.0010.0002] # <HIRAGANA LETTER MI, HIRAGANA ITERATION MARK>
30E0 30FD ; [.38F5.0020.0011.0002][.38F5.0020.0010.0002] # <KATAKANA LETTER MU, KATAKANA ITERATION MARK>
FF91 30FD ; [.38F5.0020.0011.0002][.38F5.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER MU, KATAKANA ITERATION MARK>
3080 309D ; [.38F5.0020.0011.0001][.38F5.0020.0010.0002] # <HIRAGANA LETTER MU, HIRAGANA ITERATION MARK>
30E1 30FD ; [.38F6.0020.0011.0002][.38F6.0020.0010.0002] # <KATAKANA LETTER ME, KATAKANA ITERATION MARK>
FF92 30FD ; [.38F6.0020.0011.0002][.38F6.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER ME, KATAKANA ITERATION MARK>
3081 309D ; [.38F6.0020.0011.0001][.38F6.0020.0010.0002] # <HIRAGANA LETTER ME, HIRAGANA ITERATION MARK>
30E2 30FD ; [.38F7.0020.0011.0002][.38F7.0020.0010.0002] # <KATAKANA LETTER MO, KATAKANA ITERATION MARK>
FF93 30FD ; [.38F7.0020.0011.0002][.38F7.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER MO, KATAKANA ITERATION MARK>
3082 309D ; [.38F7.0020.0011.0001][.38F7.0020.0010.0002] # <HIRAGANA LETTER MO, HIRAGANA ITERATION MARK>
30E3 30FD ; [.38F8.0020.000F.0002][.38F8.0020.0010.0002] # <KATAKANA LETTER SMALL YA, KATAKANA ITERATION MARK>
FF6C 30FD ; [.38F8.0020.000F.0002][.38F8.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER SMALL YA, KATAKANA ITERATION MARK>
3083 309D ; [.38F8.0020.000F.0001][.38F8.0020.0010.0002] # <HIRAGANA LETTER SMALL YA, HIRAGANA ITERATION MARK>
30E4 30FD ; [.38F8.0020.0011.0002][.38F8.0020.0010.0002] # <KATAKANA LETTER YA, KATAKANA ITERATION MARK>
FF94 30FD ; [.38F8.0020.0011.0002][.38F8.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER YA, KATAKANA ITERATION MARK>
3084 309D ; [.38F8.0020.0011.0001][.38F8.0020.0010.0002] # <HIRAGANA LETTER YA, HIRAGANA ITERATION MARK>
30E5 30FD ; [.38F9.0020.000F.0002][.38F9.0020.0010.0002] # <KATAKANA LETTER SMALL YU, KATAKANA ITERATION MARK>
FF6D 30FD ; [.38F9.0020.000F.0002][.38F9.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER SMALL YU, KATAKANA ITERATION MARK>
3085 309D ; [.38F9.0020.000F.0001][.38F9.0020.0010.0002] # <HIRAGANA LETTER SMALL YU, HIRAGANA ITERATION MARK>
30E6 30FD ; [.38F9.0020.0011.0002][.38F9.0020.0010.0002] # <KATAKANA LETTER YU, KATAKANA ITERATION MARK>
FF95 30FD ; [.38F9.0020.0011.0002][.38F9.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER YU, KATAKANA ITERATION MARK>
3086 309D ; [.38F9.0020.0011.0001][.38F9.0020.0010.0002] # <HIRAGANA LETTER YU, HIRAGANA ITERATION MARK>
30E7 30FD ; [.38FB.0020.000F.0002][.38FB.0020.0010.0002] # <KATAKANA LETTER SMALL YO, KATAKANA ITERATION MARK>
FF6E 30FD ; [.38FB.0020.000F.0002][.38FB.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER SMALL YO, KATAKANA ITERATION MARK>
3087 309D ; [.38FB.0020.000F.0001][.38FB.0020.0010.0002] # <HIRAGANA LETTER SMALL YO, HIRAGANA ITERATION MARK>
30E8 30FD ; [.38FB.0020.0011.0002][.38FB.0020.0010.0002] # <KATAKANA LETTER YO, KATAKANA ITERATION MARK>
FF96 30FD ; [.38FB.0020.0011.0002][.38FB.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER YO, KATAKANA ITERATION MARK>
3088 309D ; [.38FB.0020.0011.0001][.38FB.0020.0010.0002] # <HIRAGANA LETTER YO, HIRAGANA ITERATION MARK>
30E9 30FD ; [.38FC.0020.0011.0002][.38FC.0020.0010.0002] # <KATAKANA LETTER RA, KATAKANA ITERATION MARK>
FF97 30FD ; [.38FC.0020.0011.0002][.38FC.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER RA, KATAKANA ITERATION MARK>
3089 309D ; [.38FC.0020.0011.0001][.38FC.0020.0010.0002] # <HIRAGANA LETTER RA, HIRAGANA ITERATION MARK>
30EA 30FD ; [.38FD.0020.0011.0002][.38FD.0020.0010.0002] # <KATAKANA LETTER RI, KATAKANA ITERATION MARK>
FF98 30FD ; [.38FD.0020.0011.0002][.38FD.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER RI, KATAKANA ITERATION MARK>
308A 309D ; [.38FD.0020.0011.0001][.38FD.0020.0010.0002] # <HIRAGANA LETTER RI, HIRAGANA ITERATION MARK>
30EB 30FD ; [.38FE.0020.0011.0002][.38FE.0020.0010.0002] # <KATAKANA LETTER RU, KATAKANA ITERATION MARK>
FF99 30FD ; [.38FE.0020.0011.0002][.38FE.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER RU, KATAKANA ITERATION MARK>
308B 309D ; [.38FE.0020.0011.0001][.38FE.0020.0010.0002] # <HIRAGANA LETTER RU, HIRAGANA ITERATION MARK>
30EC 30FD ; [.38FF.0020.0011.0002][.38FF.0020.0010.0002] # <KATAKANA LETTER RE, KATAKANA ITERATION MARK>
FF9A 30FD ; [.38FF.0020.0011.0002][.38FF.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER RE, KATAKANA ITERATION MARK>
308C 309D ; [.38FF.0020.0011.0001][.38FF.0020.0010.0002] # <HIRAGANA LETTER RE, HIRAGANA ITERATION MARK>
30ED 30FD ; [.3900.0020.0011.0002][.3900.0020.0010.0002] # <KATAKANA LETTER RO, KATAKANA ITERATION MARK>
FF9B 30FD ; [.3900.0020.0011.0002][.3900.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER RO, KATAKANA ITERATION MARK>
308D 309D ; [.3900.0020.0011.0001][.3900.0020.0010.0002] # <HIRAGANA LETTER RO, HIRAGANA ITERATION MARK>
30EE 30FD ; [.3901.0020.000F.0002][.3901.0020.0010.0002] # <KATAKANA LETTER SMALL WA, KATAKANA ITERATION MARK>
308E 309D ; [.3901.0020.000F.0001][.3901.0020.0010.0002] # <HIRAGANA LETTER SMALL WA, HIRAGANA ITERATION MARK>
30EE 30FE ; [.3901.0020.000F.0002][.3901.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER SMALL WA, KATAKANA VOICED ITERATION MARK>
308E 309E ; [.3901.0020.000F.0001][.3901.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER SMALL WA, HIRAGANA VOICED ITERATION MARK>
30EF 30FD ; [.3901.0020.0011.0002][.3901.0020.0010.0002] # <KATAKANA LETTER WA, KATAKANA ITERATION MARK>
FF9C 30FD ; [.3901.0020.0011.0002][.3901.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER WA, KATAKANA ITERATION MARK>
308F 309D ; [.3901.0020.0011.0001][.3901.0020.0010.0002] # <HIRAGANA LETTER WA, HIRAGANA ITERATION MARK>
30EF 30FE ; [.3901.0020.0011.0002][.3901.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER WA, KATAKANA VOICED ITERATION MARK>
FF9C 30FE ; [.3901.0020.0011.0002][.3901.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER WA, KATAKANA VOICED ITERATION MARK>
308F 309E ; [.3901.0020.0011.0001][.3901.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER WA, HIRAGANA VOICED ITERATION MARK>
30F0 30FD ; [.3902.0020.0011.0002][.3902.0020.0010.0002] # <KATAKANA LETTER WI, KATAKANA ITERATION MARK>
3090 309D ; [.3902.0020.0011.0001][.3902.0020.0010.0002] # <HIRAGANA LETTER WI, HIRAGANA ITERATION MARK>
30F0 30FE ; [.3902.0020.0011.0002][.3902.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER WI, KATAKANA VOICED ITERATION MARK>
3090 309E ; [.3902.0020.0011.0001][.3902.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER WI, HIRAGANA VOICED ITERATION MARK>
30F1 30FD ; [.3903.0020.0011.0002][.3903.0020.0010.0002] # <KATAKANA LETTER WE, KATAKANA ITERATION MARK>
3091 309D ; [.3903.0020.0011.0001][.3903.0020.0010.0002] # <HIRAGANA LETTER WE, HIRAGANA ITERATION MARK>
30F1 30FE ; [.3903.0020.0011.0002][.3903.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER WE, KATAKANA VOICED ITERATION MARK>
3091 309E ; [.3903.0020.0011.0001][.3903.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER WE, HIRAGANA VOICED ITERATION MARK>
30F2 30FD ; [.3904.0020.0011.0002][.3904.0020.0010.0002] # <KATAKANA LETTER WO, KATAKANA ITERATION MARK>
FF66 30FD ; [.3904.0020.0011.0002][.3904.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER WO, KATAKANA ITERATION MARK>
3092 309D ; [.3904.0020.0011.0001][.3904.0020.0010.0002] # <HIRAGANA LETTER WO, HIRAGANA ITERATION MARK>
30F2 30FE ; [.3904.0020.0011.0002][.3904.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER WO, KATAKANA VOICED ITERATION MARK>
FF66 30FE ; [.3904.0020.0011.0002][.3904.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER WO, KATAKANA VOICED ITERATION MARK>
3092 309E ; [.3904.0020.0011.0001][.3904.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER WO, HIRAGANA VOICED ITERATION MARK>
30F3 30FD ; [.3905.0020.0011.0002][.3905.0020.0010.0002] # <KATAKANA LETTER N, KATAKANA ITERATION MARK>
FF9D 30FD ; [.3905.0020.0011.0002][.3905.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER N, KATAKANA ITERATION MARK>
3093 309D ; [.3905.0020.0011.0001][.3905.0020.0010.0002] # <HIRAGANA LETTER N, HIRAGANA ITERATION MARK>
30F4 30FD ; [.38D6.0020.0011.0002][.0000.0037.0002][.38D6.0020.0010.0002] # <KATAKANA LETTER VU, KATAKANA ITERATION MARK>
30A6 3099 30FD ; [.38D6.0020.0011.0002][.0000.0037.0002][.38D6.0020.0010.0002] # <KATAKANA LETTER U, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF73 FF9E 30FD ; [.38D6.0020.0011.0002][.0000.0037.0002][.38D6.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER U, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
3094 309D ; [.38D6.0020.0011.0001][.0000.0037.0002][.38D6.0020.0010.0002] # <HIRAGANA LETTER VU, HIRAGANA ITERATION MARK>
3046 3099 309D ; [.38D6.0020.0011.0001][.0000.0037.0002][.38D6.0020.0010.0002] # <HIRAGANA LETTER U, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA ITERATION MARK>
30F4 30FE ; [.38D6.0020.0011.0002][.0000.0037.0002][.38D6.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER VU, KATAKANA VOICED ITERATION MARK>
30A6 3099 30FE ; [.38D6.0020.0011.0002][.0000.0037.0002][.38D6.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER U, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF73 FF9E 30FE ; [.38D6.0020.0011.0002][.0000.0037.0002][.38D6.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER U, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
3094 309E ; [.38D6.0020.0011.0001][.0000.0037.0002][.38D6.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER VU, HIRAGANA VOICED ITERATION MARK>
3046 3099 309E ; [.38D6.0020.0011.0001][.0000.0037.0002][.38D6.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER U, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, HIRAGANA VOICED ITERATION MARK>
30F5 30FD ; [.38DA.0020.000F.0002][.38DA.0020.0010.0002] # <KATAKANA LETTER SMALL KA, KATAKANA ITERATION MARK>
3095 309D ; [.38DA.0020.000F.0001][.38DA.0020.0010.0002] # <HIRAGANA LETTER SMALL KA, HIRAGANA ITERATION MARK>
30F5 30FE ; [.38DA.0020.000F.0002][.38DA.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER SMALL KA, KATAKANA VOICED ITERATION MARK>
3095 309E ; [.38DA.0020.000F.0001][.38DA.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER SMALL KA, HIRAGANA VOICED ITERATION MARK>
30F6 30FD ; [.38DD.0020.000F.0002][.38DD.0020.0010.0002] # <KATAKANA LETTER SMALL KE, KATAKANA ITERATION MARK>
3096 309D ; [.38DD.0020.000F.0001][.38DD.0020.0010.0002] # <HIRAGANA LETTER SMALL KE, HIRAGANA ITERATION MARK>
30F6 30FE ; [.38DD.0020.000F.0002][.38DD.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER SMALL KE, KATAKANA VOICED ITERATION MARK>
3096 309E ; [.38DD.0020.000F.0001][.38DD.0020.0010.0002][.0000.0037.0002] # <HIRAGANA LETTER SMALL KE, HIRAGANA VOICED ITERATION MARK>
30F7 30FD ; [.3901.0020.0011.0002][.0000.0037.0002][.3901.0020.0010.0002] # <KATAKANA LETTER VA, KATAKANA ITERATION MARK>
30EF 3099 30FD ; [.3901.0020.0011.0002][.0000.0037.0002][.3901.0020.0010.0002] # <KATAKANA LETTER WA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF9C FF9E 30FD ; [.3901.0020.0011.0002][.0000.0037.0002][.3901.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER WA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
30F7 30FE ; [.3901.0020.0011.0002][.0000.0037.0002][.3901.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER VA, KATAKANA VOICED ITERATION MARK>
30EF 3099 30FE ; [.3901.0020.0011.0002][.0000.0037.0002][.3901.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER WA, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF9C FF9E 30FE ; [.3901.0020.0011.0002][.0000.0037.0002][.3901.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER WA, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
30F8 30FD ; [.3902.0020.0011.0002][.0000.0037.0002][.3902.0020.0010.0002] # <KATAKANA LETTER VI, KATAKANA ITERATION MARK>
30F0 3099 30FD ; [.3902.0020.0011.0002][.0000.0037.0002][.3902.0020.0010.0002] # <KATAKANA LETTER WI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
30F8 30FE ; [.3902.0020.0011.0002][.0000.0037.0002][.3902.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER VI, KATAKANA VOICED ITERATION MARK>
30F0 3099 30FE ; [.3902.0020.0011.0002][.0000.0037.0002][.3902.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER WI, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
30F9 30FD ; [.3903.0020.0011.0002][.0000.0037.0002][.3903.0020.0010.0002] # <KATAKANA LETTER VE, KATAKANA ITERATION MARK>
30F1 3099 30FD ; [.3903.0020.0011.0002][.0000.0037.0002][.3903.0020.0010.0002] # <KATAKANA LETTER WE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
30F9 30FE ; [.3903.0020.0011.0002][.0000.0037.0002][.3903.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER VE, KATAKANA VOICED ITERATION MARK>
30F1 3099 30FE ; [.3903.0020.0011.0002][.0000.0037.0002][.3903.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER WE, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
30FA 30FD ; [.3904.0020.0011.0002][.0000.0037.0002][.3904.0020.0010.0002] # <KATAKANA LETTER VO, KATAKANA ITERATION MARK>
30F2 3099 30FD ; [.3904.0020.0011.0002][.0000.0037.0002][.3904.0020.0010.0002] # <KATAKANA LETTER WO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
FF66 FF9E 30FD ; [.3904.0020.0011.0002][.0000.0037.0002][.3904.0020.0010.0002] # <HALFWIDTH KATAKANA LETTER WO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA ITERATION MARK>
30FA 30FE ; [.3904.0020.0011.0002][.0000.0037.0002][.3904.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER VO, KATAKANA VOICED ITERATION MARK>
30F2 3099 30FE ; [.3904.0020.0011.0002][.0000.0037.0002][.3904.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER WO, COMBINING KATAKANA-HIRAGANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
FF66 FF9E 30FE ; [.3904.0020.0011.0002][.0000.0037.0002][.3904.0020.0010.0002][.0000.0037.0002] # <HALFWIDTH KATAKANA LETTER WO, HALFWIDTH KATAKANA VOICED SOUND MARK, KATAKANA VOICED ITERATION MARK>
31F0 30FD ; [.38DC.0020.000F][.38DC.0020.0010.0002] # <KATAKANA LETTER SMALL KU, KATAKANA ITERATION MARK>
31F0 30FE ; [.38DC.0020.000F][.38DC.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER SMALL KU, KATAKANA VOICED ITERATION MARK>
31F1 30FD ; [.38E0.0020.000F][.38E0.0020.0010.0002] # <KATAKANA LETTER SMALL SI, KATAKANA ITERATION MARK>
31F1 30FE ; [.38E0.0020.000F][.38E0.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER SMALL SI, KATAKANA VOICED ITERATION MARK>
31F2 30FD ; [.38E1.0020.000F][.38E1.0020.0010.0002] # <KATAKANA LETTER SMALL SU, KATAKANA ITERATION MARK>
31F2 30FE ; [.38E1.0020.000F][.38E1.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER SMALL SU, KATAKANA VOICED ITERATION MARK>
31F3 30FD ; [.38E8.0020.000F][.38E8.0020.0010.0002] # <KATAKANA LETTER SMALL TO, KATAKANA ITERATION MARK>
31F3 30FE ; [.38E8.0020.000F][.38E8.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER SMALL TO, KATAKANA VOICED ITERATION MARK>
31F4 30FD ; [.38EB.0020.000F][.38EB.0020.0010.0002] # <KATAKANA LETTER SMALL NU, KATAKANA ITERATION MARK>
31F5 30FD ; [.38EE.0020.000F][.38EE.0020.0010.0002] # <KATAKANA LETTER SMALL HA, KATAKANA ITERATION MARK>
31F5 30FE ; [.38EE.0020.000F][.38EE.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER SMALL HA, KATAKANA VOICED ITERATION MARK>
31F6 30FD ; [.38EF.0020.000F][.38EF.0020.0010.0002] # <KATAKANA LETTER SMALL HI, KATAKANA ITERATION MARK>
31F6 30FE ; [.38EF.0020.000F][.38EF.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER SMALL HI, KATAKANA VOICED ITERATION MARK>
31F7 30FD ; [.38F0.0020.000F][.38F0.0020.0010.0002] # <KATAKANA LETTER SMALL HU, KATAKANA ITERATION MARK>
31F7 30FE ; [.38F0.0020.000F][.38F0.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER SMALL HU, KATAKANA VOICED ITERATION MARK>
31F8 30FD ; [.38F1.0020.000F][.38F1.0020.0010.0002] # <KATAKANA LETTER SMALL HE, KATAKANA ITERATION MARK>
31F8 30FE ; [.38F1.0020.000F][.38F1.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER SMALL HE, KATAKANA VOICED ITERATION MARK>
31F9 30FD ; [.38F2.0020.000F][.38F2.0020.0010.0002] # <KATAKANA LETTER SMALL HO, KATAKANA ITERATION MARK>
31F9 30FE ; [.38F2.0020.000F][.38F2.0020.0010.0002][.0000.0037.0002] # <KATAKANA LETTER SMALL HO, KATAKANA VOICED ITERATION MARK>
31FA 30FD ; [.38F5.0020.000F][.38F5.0020.0010.0002] # <KATAKANA LETTER SMALL MU, KATAKANA ITERATION MARK>
31FB 30FD ; [.38FC.0020.000F][.38FC.0020.0010.0002] # <KATAKANA LETTER SMALL RA, KATAKANA ITERATION MARK>
31FC 30FD ; [.38FD.0020.000F][.38FD.0020.0010.0002] # <KATAKANA LETTER SMALL RI, KATAKANA ITERATION MARK>
31FD 30FD ; [.38FE.0020.000F][.38FE.0020.0010.0002] # <KATAKANA LETTER SMALL RU, KATAKANA ITERATION MARK>
31FE 30FD ; [.38FF.0020.000F][.38FF.0020.0010.0002] # <KATAKANA LETTER SMALL RE, KATAKANA ITERATION MARK>
31FF 30FD ; [.3900.0020.000F][.3900.0020.0010.0002] # <KATAKANA LETTER SMALL RO, KATAKANA ITERATION MARK>
F967      ; [.8961.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F967
FA70      ; [.89AD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA70
F905      ; [.828D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F905
2F801     ; [.81B4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F801
F95E      ; [.8709.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95E
F91B      ; [.8BA0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91B
F9BA      ; [.8B1E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BA
F977      ; [.8B1F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F977
F9FD      ; [.84DF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FD
F9A8      ; [.8B44.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A8
F92D      ; [.8BC8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92D
F9B5      ; [.8B46.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B5
FA30      ; [.897B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA30
2F805     ; [.897B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F805
F965      ; [.89C3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F965
F9D4      ; [.8B34.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D4
2F809     ; [.8926.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F809
2F80B     ; [.8699.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80B
F9BB      ; [.8B20.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BB
FA31      ; [.866B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA31
2F80A     ; [.866B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80A
FA0C      ; [.8C0C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0C
FA74      ; [.84E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA74
FA32      ; [.8A6F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA32
2F80E     ; [.8A6F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80E
2F80F     ; [.8C0F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F80F
FA72      ; [.8651.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA72
F978      ; [.8C12.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F978
F9D1      ; [.8B7C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D1
2F811     ; [.8284.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F811
FA75      ; [.8C15.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA75
2F815     ; [.83D1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F815
2F8D2     ; [.8A0A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D2
2F8D3     ; [.8C1D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D3
2F817     ; [.856C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F817
2F818     ; [.8C1F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F818
2F81A     ; [.87F4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81A
FA71      ; [.8C29.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA71
2F81B     ; [.8C29.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81B
F92E      ; [.8B47.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92E
F979      ; [.8C2C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F979
F955      ; [.8B22.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F955
F954      ; [.98D1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F954
2F81D     ; [.8C33.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81D
2F81E     ; [.85B0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F81E
FA00      ; [.8619.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA00
2F850     ; [.8619.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F850
F99C      ; [.8B56.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99C
F9DD      ; [.8AFD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DD
F9FF      ; [.8432.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FF
2F820     ; [.839C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F820
2F822     ; [.815D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F822
F9C7      ; [.8B10.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C7
F98A      ; [.8B32.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98A
F99D      ; [.8B57.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99D
FA76      ; [.8AAB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA76
2F825     ; [.8AAB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F825
FA33      ; [.89C4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA33
2F826     ; [.89C4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F826
F952      ; [.9789.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F952
F92F      ; [.8C59.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92F
FA34      ; [.8263.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA34
2F827     ; [.8263.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F827
F97F      ; [.8C5F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97F
FA77      ; [.84A2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA77
2F828     ; [.84A2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F828
2F829     ; [.89DC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F829
2F82A     ; [.8C62.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82A
F963      ; [.8A15.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F963
2F82B     ; [.8A15.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82B
F9EB      ; [.8832.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EB
2F82C     ; [.8C73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82C
FA35      ; [.890B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA35
2F82D     ; [.890B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82D
2F82E     ; [.88BF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82E
2F82F     ; [.86A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F82F
F91C      ; [.8AF6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91C
2F831     ; [.823D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F831
2F832     ; [.823D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F832
2F833     ; [.823D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F833
F96B      ; [.8C84.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96B
2F836     ; [.820F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F836
2F837     ; [.8C87.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F837
F906      ; [.827A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F906
2F839     ; [.823E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F839
2F83A     ; [.847F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83A
F9DE      ; [.8AFE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DE
F9ED      ; [.8C97.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9ED
2F83D     ; [.8210.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83D
F980      ; [.8B65.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F980
2F83E     ; [.879F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83E
2F83F     ; [.84C5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F83F
2F840     ; [.8CA8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F840
F99E      ; [.8055.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99E
2F842     ; [.87F7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F842
2F843     ; [.82AD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F843
2F844     ; [.8CC0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F844
2F845     ; [.864E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F845
2F846     ; [.864E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F846
F90B      ; [.8CD7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90B
FA7A      ; [.8CCA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7A
2F847     ; [.8CCA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F847
FA36      ; [.815E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA36
FA78      ; [.815E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA78
2F848     ; [.81FF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F848
FA37      ; [.870B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA37
2F84C     ; [.870B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84C
FA38      ; [.81C6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA38
2F84F     ; [.8999.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84F
F9A9      ; [.8D08.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A9
2F84B     ; [.8D12.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F84B
2F855     ; [.82B0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F855
2F852     ; [.856E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F852
2F853     ; [.8580.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F853
2F857     ; [.89DE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F857
FA39      ; [.89A8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA39
FA10      ; [.8784.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA10
FA7C      ; [.8784.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7C
F96C      ; [.83D4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96C
FA3A      ; [.8A18.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3A
FA7D      ; [.899A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7D
F94A      ; [.8D4A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94A
F942      ; [.8D4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F942
2F851     ; [.8671.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F851
2F85A     ; [.88B5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85A
2F85B     ; [.8792.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85B
2F85D     ; [.86BA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85D
2F85E     ; [.8A5B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85E
FA7E      ; [.809F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7E
F90C      ; [.8853.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90C
F909      ; [.82B1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F909
FA7F      ; [.8A24.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA7F
2F85F     ; [.8D66.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F85F
F981      ; [.851C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F981
FA80      ; [.8D83.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA80
2F866     ; [.8965.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F866
2F86A     ; [.8D99.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86A
2F86B     ; [.8D99.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86B
FA04      ; [.86EB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA04
2F86D     ; [.8DAD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86D
F95F      ; [.887C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95F
F9AA      ; [.887C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AA
2F86F     ; [.887C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F86F
F9BC      ; [.8B23.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BC
2F870     ; [.8DBA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F870
2F872     ; [.84BE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F872
2F873     ; [.8530.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F873
2F875     ; [.8DC1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F875
F9BD      ; [.8873.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BD
2F877     ; [.87E0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F877
FA3B      ; [.8675.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3B
F9DF      ; [.8AFF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DF
FA3C      ; [.8DCD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3C
2F878     ; [.8DCD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F878
F9D5      ; [.8DEE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D5
F921      ; [.8AF7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F921
F9AB      ; [.8B49.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AB
2F881     ; [.8509.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F881
2F884     ; [.8700.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F884
2F886     ; [.8A02.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F886
F98E      ; [.8880.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98E
FA01      ; [.87EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA01
2F88D     ; [.8513.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88D
F9A2      ; [.8B5A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A2
F928      ; [.8B6E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F928
2F88E     ; [.8B6E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F88E
FA0B      ; [.8140.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0B
F982      ; [.8E30.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F982
2F890     ; [.8E36.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F890
F943      ; [.8B6F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F943
2F874     ; [.880B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F874
2F899     ; [.82B2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F899
FA84      ; [.83D7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA84
2F89A     ; [.875D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89A
F9D8      ; [.8B0A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D8
F966      ; [.8989.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F966
FA85      ; [.8E5A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA85
2F89D     ; [.8877.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89D
2F89E     ; [.843F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F89E
F9A3      ; [.8881.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A3
F960      ; [.87F1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F960
F9AC      ; [.8B4A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AC
FA6B      ; [.82B4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA6B
2F8A0     ; [.8E80.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A0
FA3D      ; [.8114.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3D
2F8A3     ; [.8114.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A3
2F8A5     ; [.884A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A5
FA86      ; [.8E95.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA86
F9B9      ; [.8E8C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B9
FA88      ; [.8AA3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA88
F9D9      ; [.8EAF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D9
2F8A6     ; [.8465.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A6
2F8A7     ; [.835F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A7
2F8A9     ; [.835F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A9
FA87      ; [.8596.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA87
2F8A8     ; [.8596.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8A8
FA3E      ; [.812D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3E
FA3F      ; [.869B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA3F
FA89      ; [.869B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA89
2F8AB     ; [.869B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AB
F98F      ; [.8B5C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98F
2F8AD     ; [.899B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AD
2F8AC     ; [.82EC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8AC
FA40      ; [.875F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA40
FA8B      ; [.875F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8B
2F8B0     ; [.875F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B0
F90D      ; [.8ED5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90D
2F8B1     ; [.8ED5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B1
F990      ; [.8EDC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F990
2F8B2     ; [.85ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B2
2F8B3     ; [.8EE2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B3
F9D2      ; [.8EE6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D2
FA8C      ; [.86D2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8C
2F8B5     ; [.89E5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B5
F925      ; [.8F09.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F925
F95B      ; [.8EFE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95B
FA02      ; [.86EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA02
2F8B6     ; [.8EF8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B6
F973      ; [.84CB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F973
2F8B9     ; [.8903.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B9
2F8B7     ; [.8F12.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8B7
2F8BB     ; [.8495.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BB
F9A4      ; [.8882.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A4
2F8BC     ; [.867A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8BC
F975      ; [.8B0E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F975
2F8C1     ; [.80A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C1
FA8D      ; [.8F2B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8D
FA8E      ; [.8F15.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA8E
2F8C3     ; [.8A29.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C3
F991      ; [.8883.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F991
FA41      ; [.895F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA41
2F8C8     ; [.895F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C8
FA90      ; [.8F64.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA90
2F8C9     ; [.82BA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8C9
F969      ; [.8F6B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F969
F9BE      ; [.8B24.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BE
F983      ; [.8B1C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F983
FA42      ; [.81D2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA42
F9E0      ; [.8036.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E0
2F8CD     ; [.8F89.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CD
FA12      ; [.85F1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA12
FA91      ; [.85F1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA91
F9C5      ; [.8F94.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C5
FA43      ; [.8510.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA43
2F8CF     ; [.8510.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CF
FA06      ; [.8A06.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA06
F901      ; [.8366.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F901
2F8CC     ; [.8516.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8CC
2F8D4     ; [.83D2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D4
F929      ; [.8B70.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F929
FA92      ; [.8B70.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA92
2F8D8     ; [.8B70.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D8
FA93      ; [.8A07.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA93
2F8D9     ; [.8A07.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D9
F9E1      ; [.8B00.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E1
2F8DC     ; [.84A4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DC
FA94      ; [.8576.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA94
2F8DB     ; [.8FB7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8DB
2F8E0     ; [.8FC5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E0
F9F4      ; [.8B36.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F4
F9C9      ; [.8A9F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C9
F9DA      ; [.829B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DA
F97A      ; [.8B25.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97A
FA44      ; [.88B0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA44
2F8E2     ; [.88B0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8E2
F9E2      ; [.8B01.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E2
F914      ; [.9037.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F914
F95C      ; [.9037.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95C
F9BF      ; [.9037.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9BF
F94C      ; [.9048.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94C
F931      ; [.8B67.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F931
2F8ED     ; [.828E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8ED
F91D      ; [.8AF8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91D
2F8EF     ; [.8468.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8EF
2F8F1     ; [.907B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F1
FA95      ; [.9080.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA95
F970      ; [.840F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F970
FA96      ; [.840F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA96
2F8F5     ; [.840F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F5
2F8F6     ; [.8145.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8F6
2F8FA     ; [.88F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FA
F972      ; [.8777.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F972
2F8FC     ; [.80A5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8FC
F968      ; [.8916.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F968
F9E3      ; [.87BA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E3
F915      ; [.8AF1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F915
FA05      ; [.8829.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA05
2F900     ; [.889A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F900
F9CA      ; [.8B11.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CA
FA97      ; [.8B11.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA97
2F902     ; [.8B11.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F902
2F903     ; [.836D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F903
F92A      ; [.8B73.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92A
FA45      ; [.811D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA45
2F901     ; [.811D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F901
2F904     ; [.859C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F904
2F905     ; [.90D2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F905
F9F5      ; [.8B37.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F5
F9D6      ; [.90E5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D6
2F90E     ; [.90D3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90E
FA46      ; [.8512.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA46
2F908     ; [.836E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F908
2F909     ; [.90E8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F909
F9CB      ; [.8B12.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CB
F9EC      ; [.87C3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EC
FA99      ; [.8469.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA99
2F90B     ; [.8469.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90B
F904      ; [.8163.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F904
F94E      ; [.8B74.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94E
FA47      ; [.8198.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA47
FA9A      ; [.8198.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9A
F992      ; [.8B5D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F992
2F90F     ; [.8763.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F90F
2F912     ; [.912F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F912
F922      ; [.8AF9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F922
F984      ; [.913F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F984
2F915     ; [.9140.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F915
FA9B      ; [.8847.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9B
2F914     ; [.8847.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F914
2F835     ; [.811E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F835
2F918     ; [.83DD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F918
F9FB      ; [.914B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FB
2F91A     ; [.8713.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F91A
F99F      ; [.8B58.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99F
F916      ; [.9156.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F916
F993      ; [.8B5E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F993
FA48      ; [.8498.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA48
FA9C      ; [.8498.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9C
F9C0      ; [.916F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C0
F9EE      ; [.8B38.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EE
F932      ; [.9178.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F932
F91E      ; [.9179.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91E
2F920     ; [.917A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F920
FA9E      ; [.84A6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9E
2F921     ; [.84A6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F921
F946      ; [.8B75.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F946
2F924     ; [.83DF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F924
FA9F      ; [.88F7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA9F
F92B      ; [.8B76.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92B
FA16      ; [.874F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA16
FAA0      ; [.874F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA0
F9A7      ; [.91AE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A7
2F928     ; [.91B0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F928
F961      ; [.8B0B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F961
F9DB      ; [.8B0B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DB
2F929     ; [.80C1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F929
F9AD      ; [.8B4B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AD
F917      ; [.91B8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F917
F9E4      ; [.8B02.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E4
F9CC      ; [.8B13.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CC
FA4A      ; [.86F1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4A
2F92F     ; [.91C5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F92F
F9AE      ; [.91C6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AE
2F932     ; [.91CF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F932
FAA3      ; [.8103.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA3
F9CD      ; [.8B14.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CD
F976      ; [.8B0F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F976
F962      ; [.803A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F962
2F938     ; [.803A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F938
F9E5      ; [.8B04.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E5
FAA5      ; [.921B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA5
F9C1      ; [.8B28.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C1
F90E      ; [.922C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90E
FA17      ; [.8094.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA17
FAA6      ; [.8094.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA6
FAA7      ; [.85F8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA7
F933      ; [.924A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F933
FAA8      ; [.8775.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAA8
2F940     ; [.8775.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F940
F96D      ; [.854D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96D
2F945     ; [.9253.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F945
2F946     ; [.85A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F946
2F947     ; [.85A0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F947
FAAA      ; [.873E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAA
2F94A     ; [.9263.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F94A
F9CE      ; [.8B15.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CE
F93B      ; [.9281.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93B
2F94F     ; [.9281.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F94F
FA4B      ; [.8919.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4B
F947      ; [.928D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F947
F985      ; [.927A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F985
FA18      ; [.8B4C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA18
FA4C      ; [.8499.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4C
FA4E      ; [.81DC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4E
FA4D      ; [.844C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4D
FA4F      ; [.8AB9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA4F
FA50      ; [.8661.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA50
2F953     ; [.8661.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F953
FA51      ; [.84F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA51
FA19      ; [.85A1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA19
FA1A      ; [.8550.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1A
F93C      ; [.92A1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93C
FA52      ; [.80ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA52
FA53      ; [.87AE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA53
FA1B      ; [.898C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1B
2F956     ; [.898C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F956
F9B6      ; [.92A7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B6
F956      ; [.8B2A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F956
FA54      ; [.839F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA54
2F959     ; [.839F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F959
2F95B     ; [.80D5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F95B
FA55      ; [.8840.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA55
F9F7      ; [.8B0C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F7
F9F8      ; [.8157.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F8
FA56      ; [.8620.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA56
FAAD      ; [.8620.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAD
2F962     ; [.930B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F962
2F963     ; [.8734.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F963
F9A6      ; [.8B5F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A6
F944      ; [.9312.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F944
F9F9      ; [.8B16.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F9
FA1D      ; [.85F9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1D
2F966     ; [.9341.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F966
FA03      ; [.8811.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA03
F97B      ; [.8B2B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97B
2F96A     ; [.81DF.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96A
F9CF      ; [.8940.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9CF
F96A      ; [.8402.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96A
F94F      ; [.8B42.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F94F
FAAF      ; [.9360.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAAF
2F96C     ; [.935D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96C
F957      ; [.801C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F957
2F96E     ; [.9368.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F96E
F996      ; [.8B60.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F996
FA57      ; [.8B60.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA57
FAB0      ; [.8B60.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB0
FA58      ; [.9380.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA58
F950      ; [.9389.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F950
FA59      ; [.88FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA59
FA5A      ; [.8515.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5A
F9E6      ; [.8ED1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E6
F90F      ; [.8AEA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90F
F9AF      ; [.93C1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9AF
FA1E      ; [.8066.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1E
F934      ; [.8B78.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F934
FA5B      ; [.849B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5B
FAB2      ; [.849B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB2
2F97A     ; [.849B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F97A
F9B0      ; [.93E1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B0
F997      ; [.8B61.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F997
2F97F     ; [.93EA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F97F
F945      ; [.8B79.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F945
F953      ; [.8B7F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F953
2F8D6     ; [.93F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F8D6
2F982     ; [.8048.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F982
2F985     ; [.9409.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F985
F926      ; [.942A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F926
F9F6      ; [.8B3A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F6
FA5C      ; [.84D2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5C
2F893     ; [.9433.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F893
2F98B     ; [.9433.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F98B
FA6D      ; [.81B3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA6D
F97C      ; [.8B2C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97C
2F990     ; [.8051.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F990
2F991     ; [.848E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F991
2F993     ; [.80F1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F993
2F994     ; [.89F0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F994
2F995     ; [.8105.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F995
F974      ; [.84AA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F974
2F998     ; [.84AA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F998
2F996     ; [.827F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F996
2F99C     ; [.9478.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99C
F9FE      ; [.873C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FE
FAB3      ; [.8380.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB3
2F99D     ; [.9493.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99D
2F9A1     ; [.81FB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A1
2F9A2     ; [.8270.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A2
2F9A3     ; [.83E5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9A3
FAB4      ; [.80F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB4
F958      ; [.8936.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F958
F918      ; [.8AF3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F918
F96E      ; [.8ADA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F96E
FA5F      ; [.8751.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA5F
2F99F     ; [.8751.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F99F
F999      ; [.8B62.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F999
F9C2      ; [.94BE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C2
F923      ; [.8AFA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F923
F9F0      ; [.94E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F0
F935      ; [.94E5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F935
F91F      ; [.8AFB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91F
F910      ; [.94E9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F910
2F9B3     ; [.8209.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B3
F936      ; [.8B1D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F936
2F9B4     ; [.8B1D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B4
2F9B5     ; [.94EE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B5
2F9B7     ; [.94F2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9B7
F911      ; [.8AEB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F911
FA08      ; [.8381.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA08
2F9C4     ; [.8040.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9C4
F9A0      ; [.8B59.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9A0
F9E7      ; [.8B05.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E7
F9E8      ; [.8B06.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E8
F912      ; [.8AEC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F912
FA60      ; [.8165.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA60
FAB6      ; [.9576.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB6
F924      ; [.9580.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F924
FAB7      ; [.898F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB7
FA0A      ; [.82FA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA0A
FA61      ; [.8454.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA61
FAB8      ; [.8454.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB8
2F9CF     ; [.85FE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9CF
FAB9      ; [.876B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAB9
FABB      ; [.8600.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABB
F97D      ; [.8B2D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97D
F941      ; [.8B81.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F941
FABE      ; [.8AA6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABE
2F9D0     ; [.8AA6.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D0
FA22      ; [.8519.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA22
FABA      ; [.8519.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABA
F95D      ; [.86F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95D
FABD      ; [.86F5.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABD
FA62      ; [.8097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA62
FABC      ; [.8097.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABC
FA63      ; [.8273.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA63
FABF      ; [.8273.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FABF
F9FC      ; [.8478.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9FC
F95A      ; [.95E2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F95A
FAC0      ; [.8F6E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC0
2F9D1     ; [.8F6E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D1
F900      ; [.95ED.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F900
2F9D2     ; [.95F1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D2
2F9D4     ; [.81AA.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D4
2F9D5     ; [.9608.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D5
F948      ; [.8B69.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F948
F903      ; [.9607.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F903
FA64      ; [.895D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA64
FA65      ; [.869E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA65
FAC1      ; [.869E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC1
2F9D7     ; [.81E4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9D7
2F9DA     ; [.9629.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DA
F937      ; [.8B6A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F937
F902      ; [.849D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F902
F998      ; [.966D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F998
F9D7      ; [.8B3B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D7
FAC2      ; [.8AA7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC2
2F9DF     ; [.8AA7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9DF
FA07      ; [.966F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA07
F98D      ; [.967A.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F98D
2F98D     ; [.8474.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F98D
F971      ; [.86FD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F971
F99A      ; [.8B63.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F99A
FA25      ; [.804E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA25
FA67      ; [.804E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA67
FAC3      ; [.96A7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC3
F9C3      ; [.8B2E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C3
F913      ; [.96AE.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F913
F92C      ; [.8B7B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F92C
FA26      ; [.87E9.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA26
F919      ; [.8AF4.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F919
F9B7      ; [.96CC.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B7
F9E9      ; [.8B07.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9E9
F97E      ; [.8B2F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F97E
F90A      ; [.8275.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F90A
F9B1      ; [.8B4E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B1
2F9EE     ; [.8124.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2F9EE
F986      ; [.9739.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F986
F9C6      ; [.974C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C6
F951      ; [.9751.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F951
FA09      ; [.838C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA09
F959      ; [.8B30.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F959
F9D3      ; [.8B09.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D3
F9DC      ; [.8B17.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9DC
F9F1      ; [.8B3C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F1
FA2F      ; [.8B4F.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2F
F9B8      ; [.9765.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B8
F9EA      ; [.8B08.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9EA
FA68      ; [.8864.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA68
FAC7      ; [.8864.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC7
F9B2      ; [.8B50.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B2
F949      ; [.8AF0.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F949
F938      ; [.8B6B.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F938
F9B3      ; [.9781.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B3
FA1C      ; [.8A9E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA1C
FAC8      ; [.8A9E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FAC8
FA69      ; [.8254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA69
FACA      ; [.8254.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACA
F9B4      ; [.8B31.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9B4
FA6A      ; [.895E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA6A
FACC      ; [.895E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACC
F9D0      ; [.8B43.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9D0
2FA02     ; [.81E7.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA02
FA2A      ; [.8902.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2A
FA2B      ; [.845D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2B
FA2C      ; [.81B2.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2C
F91A      ; [.97E3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F91A
F987      ; [.97FD.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F987
F939      ; [.8B66.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F939
F9F2      ; [.8B3D.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F2
FA2D      ; [.8798.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FA2D
F93A      ; [.83F8.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F93A
F920      ; [.9890.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F920
F940      ; [.8476.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F940
F988      ; [.8B52.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F988
F9F3      ; [.8B3E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9F3
2FA15     ; [.8A2C.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA15
F989      ; [.98A3.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F989
2FA17     ; [.98B1.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA17
2FA1C     ; [.892E.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-2FA1C
F9C4      ; [.8B19.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F9C4
F907      ; [.98CB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F907
F908      ; [.98CB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-F908
FACE      ; [.98CB.0020.0002] # CJK COMPATIBILITY IDEOGRAPH-FACE
ENTRY
};
