use strict;
use lib qw(lib ../lib);
use Template::Test;
use Template::Plugin::TruncateByWord;

test_expect(\*DATA);


__DATA__

-- test --
[% USE TruncateByWord 'euc-kr' -%]
[% 'abcdefg' | truncate_by_word(4) %]
-- expect --
abcd

-- test --
[% USE TruncateByWord 'euc-kr' -%]
[% 'α׷' | truncate_by_word(3) %]
-- expect --


-- test --
[% USE TruncateByWord 'euc-kr' -%]
[% 'ab׷cdefg' | truncate_by_word(3) %]
-- expect --
a

-- test --
[% USE TruncateByWord 'euc-kr' -%]
[% 'ab׷cdefg' | truncate_by_word %]
-- expect --
ab׷cdefg

-- test --
[% USE TruncateByWord 'euc-kr' -%]
[% 'ab׷cdefg' | truncate_by_word(5,'...') %]
-- expect --
a...

-- test --
[% USE TruncateByWord 'euc-kr' -%]
[% 'ab׷cdefg' | truncate_by_word(36,'...') %]
-- expect --
ab׷cdefg

-- test --
[% USE TruncateByWord('euc-kr', name='my_truncate') -%]
[% 'ab׷cdefg' | my_truncate(3) %]
-- expect --
a

-- test --
[% USE TruncateByWord 'euc-kr' name='my_truncate' -%]
[% FILTER my_truncate(5,'..') -%]
ab׷cdefg
[% END %]
-- expect --
a..

-- test --
[% USE TruncateByWord enc='euc-kr' name='my_truncate' -%]
[% FILTER my_truncate(5,'..') -%]
ab׷cdefg
[% END %]
-- expect --
a..
