# Generated by default/object.tt
package Paws::CodeArtifact::AssetSummary;
  use Moose;
  has Hashes => (is => 'ro', isa => 'Paws::CodeArtifact::AssetHashes', request_name => 'hashes', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest'], required => 1);
  has Size => (is => 'ro', isa => 'Int', request_name => 'size', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeArtifact::AssetSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeArtifact::AssetSummary object:

  $service_obj->Method(Att1 => { Hashes => $value, ..., Size => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeArtifact::AssetSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->Hashes

=head1 DESCRIPTION

Contains details about a package version asset.

=head1 ATTRIBUTES


=head2 Hashes => L<Paws::CodeArtifact::AssetHashes>

The hashes of the asset.


=head2 B<REQUIRED> Name => Str

The name of the asset.


=head2 Size => Int

The size of the asset.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeArtifact>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

