#!perl

use strict;
use warnings;
use Test::More tests => 7;
use Perl::Critic;
use Perl::Critic::Config;
use Perl::Critic::Policy::Variables::RequireHungarianNotation;

# import common P::C testing tools
use lib 't/lib';
use PerlCriticTestUtils 'pcritique';

PerlCriticTestUtils::block_perlcriticrc();

# testing vars samples from perl doc.
my @a_is_tests = (    # [ code, violation count ]
    [
        q{
package YourModule;
require Exporter;
@ISA = qw(Exporter);
@EXPORT_OK = qw(munge frobnicate);  # symbols to export on request
    }, 0
    ],
    [
        q{
@EXPORT_OK = qw(&bfunc %hash *typeglob); # explicit prefix on &bfunc
    }, 0
    ],
    [
        q/
%EXPORT_TAGS = (foo => [qw(aa bb cc)], bar => [qw(aa cc dd)]);
# add all the other ":class" tags to the ":all" class,
# deleting duplicates
{
my %h_seen;
push @{$EXPORT_TAGS{all}},
  grep {!$seen{$_}++} @{$EXPORT_TAGS{$_}} foreach keys %EXPORT_TAGS;
}
    /, 0
    ],
    [ q/use vars qw($frob @mung %seen); /,       1 ],
    [ q/use vars qw($s_frob @a_mung %h_seen); /, 0 ],
    [ q/use vars qw($s_frob @a_mung %a_seen); /, 1 ],
    [ q/use vars qw($s_frob @h_mung %h_seen); /, 1 ],
);
for (@a_is_tests) {
    my ( $s_perl, $nviol ) = @{$_};
    my $s_policy = 'Variables::RequireHungarianNotation';
    is( pcritique( $s_policy, \$s_perl ), $nviol, $s_perl );
}

exit 0;

__END__
