#!/usr/bin/perl

package eBay::API::XML::DataType::StoreType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. StoreType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::StoreType

=head1 DESCRIPTION

The configuration of an eBay Store.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::StoreType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::StoreCustomCategoryArrayType;
use eBay::API::XML::DataType::StoreCustomListingHeaderType;
use eBay::API::XML::DataType::StoreLogoType;
use eBay::API::XML::DataType::StoreThemeType;
use eBay::API::XML::DataType::Enum::MerchDisplayCodeType;
use eBay::API::XML::DataType::Enum::StoreCustomHeaderLayoutCodeType;
use eBay::API::XML::DataType::Enum::StoreHeaderStyleCodeType;
use eBay::API::XML::DataType::Enum::StoreItemListLayoutCodeType;
use eBay::API::XML::DataType::Enum::StoreItemListSortOrderCodeType;
use eBay::API::XML::DataType::Enum::StoreSubscriptionLevelCodeType;


my @gaProperties = ( [ 'CustomCategories', 'ns:StoreCustomCategoryArrayType', ''
	     ,'eBay::API::XML::DataType::StoreCustomCategoryArrayType', '1' ]
	, [ 'CustomHeader', 'xs:string', '', '', '' ]
	, [ 'CustomHeaderLayout', 'ns:StoreCustomHeaderLayoutCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::StoreCustomHeaderLayoutCodeType', '' ]
	, [ 'CustomListingHeader', 'ns:StoreCustomListingHeaderType', ''
	     ,'eBay::API::XML::DataType::StoreCustomListingHeaderType', '1' ]
	, [ 'Description', 'xs:string', '', '', '' ]
	, [ 'ExportListings', 'xs:boolean', '', '', '' ]
	, [ 'HeaderStyle', 'ns:StoreHeaderStyleCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::StoreHeaderStyleCodeType', '' ]
	, [ 'HomePage', 'xs:long', '', '', '' ]
	, [ 'ItemListLayout', 'ns:StoreItemListLayoutCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::StoreItemListLayoutCodeType', '' ]
	, [ 'ItemListSortOrder', 'ns:StoreItemListSortOrderCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::StoreItemListSortOrderCodeType', '' ]
	, [ 'LastOpenedTime', 'xs:dateTime', '', '', '' ]
	, [ 'Logo', 'ns:StoreLogoType', ''
	     ,'eBay::API::XML::DataType::StoreLogoType', '1' ]
	, [ 'MerchDisplay', 'ns:MerchDisplayCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::MerchDisplayCodeType', '' ]
	, [ 'Name', 'xs:string', '', '', '' ]
	, [ 'SubscriptionLevel', 'ns:StoreSubscriptionLevelCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::StoreSubscriptionLevelCodeType', '' ]
	, [ 'Theme', 'ns:StoreThemeType', ''
	     ,'eBay::API::XML::DataType::StoreThemeType', '1' ]
	, [ 'URL', 'xs:anyURI', '', '', '' ]
	, [ 'URLPath', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCustomCategories()

Custom categories for the Store. Deprecated (input ignored) for SetStore
with request version 449 or higher. Use SetStoreCategories with
request verison 449 or higher to modify store category structures.

#    Argument: 'ns:StoreCustomCategoryArrayType'

=cut

sub setCustomCategories {
  my $self = shift;
  $self->{'CustomCategories'} = shift
}

=head2 getCustomCategories()

  Calls: GetStore
  Returned: Always

#    Returns: 'ns:StoreCustomCategoryArrayType'

=cut

sub getCustomCategories {
  my $self = shift;
  return $self->_getDataTypeInstance( 'CustomCategories'
		,'eBay::API::XML::DataType::StoreCustomCategoryArrayType');
}


=head2 setCustomHeader()

Custom header text for the Store.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'xs:string'

=cut

sub setCustomHeader {
  my $self = shift;
  $self->{'CustomHeader'} = shift
}

=head2 getCustomHeader()

  Calls: GetStore
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getCustomHeader {
  my $self = shift;
  return $self->{'CustomHeader'};
}


=head2 setCustomHeaderLayout()

Layout for the Store's custom header.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'ns:StoreCustomHeaderLayoutCodeType'

=cut

sub setCustomHeaderLayout {
  my $self = shift;
  $self->{'CustomHeaderLayout'} = shift
}

=head2 getCustomHeaderLayout()

  Calls: GetStore
  Returned: Conditionally

#    Returns: 'ns:StoreCustomHeaderLayoutCodeType'

=cut

sub getCustomHeaderLayout {
  my $self = shift;
  return $self->{'CustomHeaderLayout'};
}


=head2 setCustomListingHeader()

Custom listing header for the Store.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'ns:StoreCustomListingHeaderType'

=cut

sub setCustomListingHeader {
  my $self = shift;
  $self->{'CustomListingHeader'} = shift
}

=head2 getCustomListingHeader()

  Calls: GetStore
  Returned: Conditionally

#    Returns: 'ns:StoreCustomListingHeaderType'

=cut

sub getCustomListingHeader {
  my $self = shift;
  return $self->_getDataTypeInstance( 'CustomListingHeader'
		,'eBay::API::XML::DataType::StoreCustomListingHeaderType');
}


=head2 setDescription()

Store description (300 characters maximum).

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'xs:string'

=cut

sub setDescription {
  my $self = shift;
  $self->{'Description'} = shift
}

=head2 getDescription()

  Calls: GetStore
  Returned: Always

#    Returns: 'xs:string'

=cut

sub getDescription {
  my $self = shift;
  return $self->{'Description'};
}


=head2 setExportListings()

Specifies whether to export the Store listings to comparison
shopping websites.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'xs:boolean'

=cut

sub setExportListings {
  my $self = shift;
  $self->{'ExportListings'} = shift
}

=head2 isExportListings()

  Calls: GetStore
  Returned: Conditionally

#    Returns: 'xs:boolean'

=cut

sub isExportListings {
  my $self = shift;
  return $self->{'ExportListings'};
}


=head2 setHeaderStyle()

Style for the Store header.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'ns:StoreHeaderStyleCodeType'

=cut

sub setHeaderStyle {
  my $self = shift;
  $self->{'HeaderStyle'} = shift
}

=head2 getHeaderStyle()

  Calls: GetStore
  Returned: Conditionally

#    Returns: 'ns:StoreHeaderStyleCodeType'

=cut

sub getHeaderStyle {
  my $self = shift;
  return $self->{'HeaderStyle'};
}


=head2 setHomePage()

Page to use as the Store's homepage (default is 0). To change the
homepage, specify the PageID of one of the Store's custom pages.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'xs:long'

=cut

sub setHomePage {
  my $self = shift;
  $self->{'HomePage'} = shift
}

=head2 getHomePage()

  Calls: GetStore
  Returned: Conditionally

#    Returns: 'xs:long'

=cut

sub getHomePage {
  my $self = shift;
  return $self->{'HomePage'};
}


=head2 setItemListLayout()

The default layout type to use for the Store items.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'ns:StoreItemListLayoutCodeType'

=cut

sub setItemListLayout {
  my $self = shift;
  $self->{'ItemListLayout'} = shift
}

=head2 getItemListLayout()

  Calls: GetStore
  Returned: Conditionally

#    Returns: 'ns:StoreItemListLayoutCodeType'

=cut

sub getItemListLayout {
  my $self = shift;
  return $self->{'ItemListLayout'};
}


=head2 setItemListSortOrder()

The default sort order to use for the items for sale in the Store.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'ns:StoreItemListSortOrderCodeType'

=cut

sub setItemListSortOrder {
  my $self = shift;
  $self->{'ItemListSortOrder'} = shift
}

=head2 getItemListSortOrder()

  Calls: GetStore
  Returned: Conditionally

#    Returns: 'ns:StoreItemListSortOrderCodeType'

=cut

sub getItemListSortOrder {
  my $self = shift;
  return $self->{'ItemListSortOrder'};
}


=head2 setLastOpenedTime()

Indicates the time the store was last opened or reopened.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'xs:dateTime'

=cut

sub setLastOpenedTime {
  my $self = shift;
  $self->{'LastOpenedTime'} = shift
}

=head2 getLastOpenedTime()

  Calls: GetStore
  Returned: Conditionally

#    Returns: 'xs:dateTime'

=cut

sub getLastOpenedTime {
  my $self = shift;
  return $self->{'LastOpenedTime'};
}


=head2 setLogo()

Store logo.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'ns:StoreLogoType'

=cut

sub setLogo {
  my $self = shift;
  $self->{'Logo'} = shift
}

=head2 getLogo()

  Calls: GetStore
  Returned: Conditionally

#    Returns: 'ns:StoreLogoType'

=cut

sub getLogo {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Logo'
		,'eBay::API::XML::DataType::StoreLogoType');
}


=head2 setMerchDisplay()

Specifies the chosen customization display scheme for this store's Merch Widgets.
See MerchDisplayCodeType for specific values.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'ns:MerchDisplayCodeType'

=cut

sub setMerchDisplay {
  my $self = shift;
  $self->{'MerchDisplay'} = shift
}

=head2 getMerchDisplay()

  Calls: GetStore
  Returned: Conditionally

#    Returns: 'ns:MerchDisplayCodeType'

=cut

sub getMerchDisplay {
  my $self = shift;
  return $self->{'MerchDisplay'};
}


=head2 setName()

Name of the eBay Store. The name is shown
at the top of the Store page.

MaxLength: 35

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'xs:string'

=cut

sub setName {
  my $self = shift;
  $self->{'Name'} = shift
}

=head2 getName()

  Calls: GetStore
  Returned: Always

#    Returns: 'xs:string'

=cut

sub getName {
  my $self = shift;
  return $self->{'Name'};
}


=head2 setSubscriptionLevel()

Subscription level (tier) for the user's eBay Store.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'ns:StoreSubscriptionLevelCodeType'

=cut

sub setSubscriptionLevel {
  my $self = shift;
  $self->{'SubscriptionLevel'} = shift
}

=head2 getSubscriptionLevel()

  Calls: GetStore
  Returned: Always
  OnlyTheseValues: Anchor, Basic, Featured

#    Returns: 'ns:StoreSubscriptionLevelCodeType'

=cut

sub getSubscriptionLevel {
  my $self = shift;
  return $self->{'SubscriptionLevel'};
}


=head2 setTheme()

Store theme.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'ns:StoreThemeType'

=cut

sub setTheme {
  my $self = shift;
  $self->{'Theme'} = shift
}

=head2 getTheme()

  Calls: GetStore
  Returned: Conditionally

#    Returns: 'ns:StoreThemeType'

=cut

sub getTheme {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Theme'
		,'eBay::API::XML::DataType::StoreThemeType');
}


=head2 setURL()

The complete URL of the user's Store. This field is only ever
returned, and does not need to be explicitly set.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'xs:anyURI'

=cut

sub setURL {
  my $self = shift;
  $self->{'URL'} = shift
}

=head2 getURL()

  Calls: GetStore
  Returned: Conditionally

#    Returns: 'xs:anyURI'

=cut

sub getURL {
  my $self = shift;
  return $self->{'URL'};
}


=head2 setURLPath()

The URL path of the Store (58 characters maximum). Only if you
are using Chinese characters in the Name property do you need to
use this field, such as if you are opening a Store on the Taiwan
site. The reason for this is that the URL path is normally derived
from the Store name, but it cannot be derived from the name of the
Store if it contains Chinese characters because URLs cannot
contain Chinese characters.

  Calls: SetStore
  RequiredInput: Conditionally

#    Argument: 'xs:string'

=cut

sub setURLPath {
  my $self = shift;
  $self->{'URLPath'} = shift
}

=head2 getURLPath()

  Calls: GetStore
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getURLPath {
  my $self = shift;
  return $self->{'URLPath'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
