package Acme::MetaSyntactic::swords;
use strict;
use Acme::MetaSyntactic::List;
our @ISA = qw( Acme::MetaSyntactic::List );
our $VERSION = '1.000';
__PACKAGE__->init();
1;

=head1 NAME

Acme::MetaSyntactic::swords - The swords theme

=head1 DESCRIPTION

This list gives the names of famous swords, 
historical as well as legendary and fictional.

Sources:

=over 4

=item * 

I<Dictionary of Phrase and Fable>,
written by E. Cobham Brewer, 1898, on line at
L<http://www.bartleby.com/81/16143.html>.

=item * 

L<http://pages.infinit.net/celte/epees.html>

=item * 

I<The Colour of Magic>, Terry Pratchett.

=back

=head1 CONTRIBUTOR

Jean Forget.

=head1 CHANGES

=over 4

=item *

2012-05-07 - v1.000

Received its own version number in Acme-MetaSyntactic-Themes version 1.000.

=item *

2006-07-03

Introduced in Acme-MetaSyntactic version 0.81.

=item *

2006-06-22

Submitted by Jean Forget.

=back

=head1 SEE ALSO

L<Acme::MetaSyntactic>, L<Acme::MetaSyntactic::List>.

=cut

__DATA__
# names
Al_Battar
Almace
Anduril
Angurvadel
Answerrer
Aroundight
Ascalon
Balmung
Baptism
Begallta
Balisarda
Blutgang
Brinning
Caladbolg
Calad_colg
Caliburn
Cat_s_claws
Chastiefol
Chrysaor
Claidheamh_Solius
Colada
Corrougue
Courtain
Crocea_Mors
Curtana
Dainsleif
Dhu_l_Fakar
Durandal
Dyrnwyn
Ekkisax
Excalibur
Flamberge
Flamborge
Florence
Fragarach
Fusberta
Galatyn
Glamdring
Glorieuse
Graban
Gram
Greysteel
Greywand
Grimtooth
Gurthang
Hauteclaire
Haute_Claire
Halef
Hadhafang
Herrugrim
Hofud
Hrotti
Hrunting
Joyeuse
Kring
Lagulf
Leochain
Licorne
Marmadoise
Medham
Merveilleuse
Mimung
Morglay
Murgleis
Naegling
Naglhring
Nagelring
Narsil
Noralltach
Nothung
Orcrist
Philippan
Precieuse
Quern_biter
Refil
Ridill
Ringwraith
Sacho
Samsamha
Sanglamore
Sauvagine
Scalpel
Schrit
Sting
Stormbringer
Szczerbiec
Tyrfing
Tizona
Tranchera
Waske
Welsung
Zulgafar
