################################################################################
#
#  PPPort_xs.PL -- generate RealPPPort.xs
#
################################################################################
#
#  $Revision: 16 $
#  $Author: mhx $
#  $Date: 2010/03/07 13:15:41 +0100 $
#
################################################################################
#
#  Version 3.x, Copyright (C) 2004-2010, Marcus Holland-Moritz.
#  Version 2.x, Copyright (C) 2001, Paul Marquess.
#  Version 1.x, Copyright (C) 1999, Kenneth Albanowski.
#
#  This program is free software; you can redistribute it and/or
#  modify it under the same terms as Perl itself.
#
################################################################################

use strict;
$^W = 1;
require "parts/ppptools.pl";

my %SECTION = (
  xshead => { code => '', header => "/* ---- code from __FILE__ ---- */" },
  xsinit => { code => '', header => "/* ---- code from __FILE__ ---- */" },
  xsmisc => { code => '', header => "/* ---- code from __FILE__ ---- */" },
  xsboot => { code => '', header => "/* ---- code from __FILE__ ---- */", indent => "\t" },
  xsubs  => { code => '', header => <<ENDHEADER },
##----------------------------------------------------------------------
##  XSUBs for testing the implementation in __FILE__
##----------------------------------------------------------------------
ENDHEADER
);

if (exists $ENV{PERL_NO_GET_CONTEXT} && $ENV{PERL_NO_GET_CONTEXT}) {
$SECTION{xshead}{code} .= <<END;
#define PERL_NO_GET_CONTEXT
END
}

my $file;
my $sec;

for $file (all_files_in_dir('parts/inc')) {
  my $spec = parse_partspec($file);

  my $msg = 0;
  for $sec (keys %SECTION) {
    if (exists $spec->{$sec}) {
      $msg++ or print "adding XS code from $file\n";
      if (exists $SECTION{$sec}{header}) {
        my $header = $SECTION{$sec}{header};
        $header =~ s/__FILE__/$file/g;
        $SECTION{$sec}{code} .= $header . "\n";
      }
      $SECTION{$sec}{code} .= $spec->{$sec} . "\n";
    }
  }
}

my $data = do { local $/; <DATA> };

for $sec (keys %SECTION) {
  my $code = $SECTION{$sec}{code};
  if (exists $SECTION{$sec}{indent}) {
    $code =~ s/^/$SECTION{$sec}{indent}/gm;
  }
  $code =~ s/[\r\n]+$//;
  $data =~ s/^__\U$sec\E__$/$code/m;
}

open FH, ">RealPPPort.xs" or die "RealPPPort.xs: $!\n";
print FH $data;
close FH;

exit 0;

__DATA__
/*******************************************************************************
*
*  !!!!! Do NOT edit this file directly! -- Edit PPPort_xs.PL instead. !!!!!
*
*  This file was automatically generated from the definition files in the
*  parts/inc/ subdirectory by PPPort_xs.PL. To learn more about how all this
*  works, please read the F<HACKERS> file that came with this distribution.
*
********************************************************************************
*
*  Perl/Pollution/Portability
*
********************************************************************************
*
*  $Revision: 16 $
*  $Author: mhx $
*  $Date: 2010/03/07 13:15:41 +0100 $
*
********************************************************************************
*
*  Version 3.x, Copyright (C) 2004-2010, Marcus Holland-Moritz.
*  Version 2.x, Copyright (C) 2001, Paul Marquess.
*  Version 1.x, Copyright (C) 1999, Kenneth Albanowski.
*
*  This program is free software; you can redistribute it and/or
*  modify it under the same terms as Perl itself.
*
*******************************************************************************/

/* ========== BEGIN XSHEAD ================================================== */

__XSHEAD__

/* =========== END XSHEAD =================================================== */

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

/* ========== BEGIN XSINIT ================================================== */

__XSINIT__

/* =========== END XSINIT =================================================== */

#include "ppport.h"

/* ========== BEGIN XSMISC ================================================== */

__XSMISC__

/* =========== END XSMISC =================================================== */

MODULE = Devel::PPPort		PACKAGE = Devel::PPPort

BOOT:
__XSBOOT__

__XSUBS__
