#!/usr/bin/perl

use strict;
use warnings;
use Test::More;
use Storable::Improved qw(freeze thaw);
plan tests => 1;

# this original worked with the packaged exploit, but that
# triggers virus scanners, so test for the behaviour instead
my $x = bless \(my $y = "mt-config.cgi"), "CGITempFile";

my $frozen = freeze($x);

{
    my $warnings = '';
    local $SIG{__WARN__} = sub { $warnings .= "@_" };
    thaw($frozen);
    like($warnings, qr/SECURITY: Movable-Type CVE-2015-1592 Storable metasploit attack/,
         'Detect CVE-2015-1592');
}
