package Locale::ID::Province;

use 5.010001;
use strict;
use warnings;
use Perinci::Sub::Gen::AccessTable qw(gen_read_table_func);

use Exporter qw(import);
our @EXPORT_OK = qw(
                       list_idn_provinces
               );

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-09-26'; # DATE
our $DIST = 'Locale-ID-Province'; # DIST
our $VERSION = '0.112'; # VERSION

our %SPEC;

# BEGIN FRAGMENT id=meta-idn_province
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/idn_province/meta.yaml
# src-revision: 656b0442bafab450af02afa899e331be7370f8a9 (Wed Sep 25 08:58:30 2024 +0700)
# generate-date: Thu Sep 26 06:18:25 2024 UTC
# generated-by: update-fragments-in-perl-module
our $meta = {
  "fields" => {
    bps_code => {
      "pos" => 0,
      "schema" => ["int*", { max => 99, min => 11 }],
      "sortable" => "Yes",
      "summary" => "BPS code",
      "summary.alt.lang.id_ID" => "Kode BPS",
      "unique" => "Yes",
    },
    eng_name => {
      "pos" => 4,
      "schema" => ["str*", {}],
      "sortable" => "Yes",
      "summary" => "Name (in English)",
      "summary.alt.lang.id_ID" => "Nama (bahasa Inggris)",
      "unique" => "Yes",
    },
    ind_abbrev => {
      "pos" => 2,
      "schema" => ["str*", {}],
      "sortable" => "Yes",
      "summary" => "Abbreviated name (in Indonesian)",
      "summary.alt.lang.id_ID" => "Kependekan (bahasa Indonesia)",
    },
    ind_capital_name => {
      "note" => "TODO link to locality_id",
      "pos" => 5,
      "schema" => ["str*"],
      "sortable" => "Yes",
      "summary" => "Capital name (Indonesian)",
      "summary.alt.lang.id_ID" => "Nama ibukota (bahasa Indonesia)",
    },
    ind_island_name => {
      "note" => "TODO link to island_id",
      "pos" => 6,
      "schema" => ["str*", {}],
      "summary" => "Island (Indonesian)",
      "summary.alt.lang.id_ID" => "Pulau",
    },
    ind_name => {
      "pos" => 3,
      "schema" => ["str*", {}],
      "sortable" => "Yes",
      "summary" => "Name (in Indonesian)",
      "summary.alt.lang.id_ID" => "Nama (bahasa Indonesia)",
      "unique" => "Yes",
    },
    iso3166_2_code => {
      "pos" => 1,
      "schema" => ["str*", { match => "^[A-Z]{2}-[A-Z]{2}\$" }],
      "sortable" => "Yes",
      "summary" => "ISO 3166-2 code",
      "summary.alt.lang.id_ID" => "Kode ISO 3166-2",
      "unique" => "Yes",
    },
    tags => {
      "pos" => 7,
      "schema" => ["str*"],
      "summary" => "Tag",
      "summary.alt.lang.id_ID" => "Tag",
    },
  },
  "pk" => "ind_name",
  "summary" => "Provinces in Indonesia",
  "summary.alt.lang.id_ID" => "Provinsi di Indonesia",
  "table_aliases.alt.lang.id_ID" => ["provinsi_idn"],
};
# END FRAGMENT id=meta-idn_province
# BEGIN FRAGMENT id=data-idn_province
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/idn_province/data.csv
# src-revision: 656b0442bafab450af02afa899e331be7370f8a9 (Wed Sep 25 08:58:30 2024 +0700)
# generate-date: Thu Sep 26 06:18:25 2024 UTC
# generated-by: update-fragments-in-perl-module
our $data = [
  [
    11,
    "ID-AC",
    "",
    "Aceh",
    "Aceh",
    "Banda Aceh",
    "Sumatera",
    "special territory",
  ],
  [
    12,
    "ID-SU",
    "Sumut",
    "Sumatera Utara",
    "North Sumatra",
    "Medan",
    "Sumatera",
    "",
  ],
  [
    13,
    "ID-SB",
    "Sumbar",
    "Sumatera Barat",
    "West Sumatra",
    "Padang",
    "Sumatera",
    "",
  ],
  [14, "ID-RI", "", "Riau", "Riau", "Pekanbaru", "Sumatera", ""],
  [15, "ID-JA", "", "Jambi", "Jambi", "Jambi", "Sumatera", ""],
  [
    16,
    "ID-SS",
    "Sumsel",
    "Sumatera Selatan",
    "South Sumatra",
    "Palembang",
    "Sumatera",
    "",
  ],
  [17, "ID-BE", "", "Bengkulu", "Bengkulu", "Bengkulu", "Sumatera", ""],
  [
    18,
    "ID-LA",
    "",
    "Lampung",
    "Lampung",
    "Bandar Lampung",
    "Sumatera",
    "",
  ],
  [
    19,
    "ID-BB",
    "Babel",
    "Kepulauan Bangka Belitung",
    "Bangka Belitung Islands",
    "Pangkal Pinang",
    "Sumatera",
    "",
  ],
  [
    21,
    "ID-KR",
    "Kepri",
    "Kepulauan Riau",
    "Riau Islands",
    "Tanjung Pinang",
    "Sumatera",
    "",
  ],
  [
    31,
    "ID-JK",
    "Jakarta",
    "Daerah Khusus Ibukota Jakarta",
    "Jakarta Special Capital Territory",
    "Jakarta Pusat",
    "Jawa",
    "special territory,special capital territory,capital",
  ],
  [
    32,
    "ID-JB",
    "Jabar",
    "Jawa Barat",
    "West Java",
    "Bandung",
    "Jawa",
    "",
  ],
  [
    33,
    "ID-JT",
    "Jateng",
    "Jawa Tengah",
    "Central Java",
    "Semarang",
    "Jawa",
    "",
  ],
  [
    34,
    "ID-YO",
    "DIY",
    "Daerah Istimewa Yogyakarta",
    "Yogyakarta Special Territory",
    "Yogyakarta",
    "Jawa",
    "special territory",
  ],
  [
    35,
    "ID-JI",
    "Jatim",
    "Jawa Timur",
    "East Java",
    "Surabaya",
    "Jawa",
    "",
  ],
  [36, "ID-BT", "", "Banten", "Banten", "Serang", "Jawa", ""],
  [51, "ID-BA", "", "Bali", "Bali", "Denpasar", "Bali", ""],
  [
    52,
    "ID-NB",
    "NTB",
    "Nusa Tenggara Barat",
    "West Nusa Tenggara",
    "Mataram",
    "Nusa Tenggara",
    "",
  ],
  [
    53,
    "ID-NT",
    "NTT",
    "Nusa Tenggara Timur",
    "East Nusa Tenggara",
    "Kupang",
    "Nusa Tenggara",
    "",
  ],
  [
    61,
    "ID-KB",
    "Kalbar",
    "Kalimantan Barat",
    "West Kalimantan",
    "Pontianak",
    "Kalimantan",
    "",
  ],
  [
    62,
    "ID-KT",
    "Kalteng",
    "Kalimantan Tengah",
    "Central Kalimantan",
    "Palangkaraya",
    "Kalimantan",
    "",
  ],
  [
    63,
    "ID-KS",
    "Kalsel",
    "Kalimantan Selatan",
    "South Kalimantan",
    "Banjarmasin",
    "Kalimantan",
    "",
  ],
  [
    64,
    "ID-KI",
    "Kaltim",
    "Kalimantan Timur",
    "East Kalimantan",
    "Samarinda",
    "Kalimantan",
    "",
  ],
  [
    65,
    "ID-KU",
    "Kaltara",
    "Kalimantan Utara",
    "North Kalimantan",
    "Tanjung Selor",
    "Kalimantan",
    "",
  ],
  [
    71,
    "ID-SA",
    "Sulut",
    "Sulawesi Utara",
    "North Sulawesi",
    "Manado",
    "Sulawesi",
    "",
  ],
  [
    72,
    "ID-ST",
    "Sulteng",
    "Sulawesi Tengah",
    "Central Sulawesi",
    "Palu",
    "Sulawesi",
    "",
  ],
  [
    73,
    "ID-SN",
    "Sulsel",
    "Sulawesi Selatan",
    "South Sulawesi",
    "Makassar",
    "Sulawesi",
    "",
  ],
  [
    74,
    "ID-SG",
    "Sultra",
    "Sulawesi Tenggara",
    "South East Sulawesi",
    "Kendari",
    "Sulawesi",
    "",
  ],
  [
    75,
    "ID-GO",
    "",
    "Gorontalo",
    "Gorontalo",
    "Gorontalo",
    "Sulawesi",
    "",
  ],
  [
    76,
    "ID-SR",
    "Sulbar",
    "Sulawesi Barat",
    "West Sulawesi",
    "Mamuju",
    "Sulawesi",
    "",
  ],
  [81, "ID-MA", "", "Maluku", "Maluku", "Ambon", "Maluku", ""],
  [
    82,
    "ID-MU",
    "Malut",
    "Maluku Utara",
    "North Maluku",
    "Sofifi",
    "Maluku",
    "",
  ],
  [
    92,
    "ID-PB",
    "Pabar",
    "Papua Barat",
    "West Papua",
    "Manokwari",
    "Papua",
    "special territory",
  ],
  [
    91,
    "ID-PA",
    "",
    "Papua",
    "Papua",
    "Jayapura",
    "Papua",
    "special territory",
  ],
  [
    93,
    "ID-PS",
    "Pasel",
    "Papua Selatan",
    "South Papua",
    "Merauke",
    "Papua",
    "special territory",
  ],
  [
    94,
    "ID-PT",
    "Pateng",
    "Papua Tengah",
    "Central Papua",
    "Wanggar",
    "special territory",
  ],
  [
    95,
    "ID-PE",
    "Papeng",
    "Papua Pegunungan",
    "Papua Mountain",
    "Jayawijaya",
    "special territory",
  ],
  [
    96,
    "ID-PD",
    "PBD",
    "Papua Barat Daya",
    "Southwest Papua",
    "Sorong",
    "special territory",
  ],
];
# END FRAGMENT id=data-idn_province

my $res = gen_read_table_func(
    name => 'list_idn_provinces',
    table_data => $data,
    table_spec => $meta,
    langs => ['en_US', 'id_ID'],
);
die "BUG: Can't generate func: $res->[0] - $res->[1]" unless $res->[0] == 200;

1;
# ABSTRACT: List of provinces in Indonesia

__END__

=pod

=encoding UTF-8

=head1 NAME

Locale::ID::Province - List of provinces in Indonesia

=head1 VERSION

This document describes version 0.112 of Locale::ID::Province (from Perl distribution Locale-ID-Province), released on 2024-09-26.

=head1 SYNOPSIS

 use Locale::ID::Province qw(list_idn_provinces);
 my $res = list_idn_provinces();

=head1 DESCRIPTION

=head1 FUNCTIONS


=head2 list_idn_provinces

Usage:

 list_idn_provinces(%args) -> [$status_code, $reason, $payload, \%result_meta]

Provinces in Indonesia.

REPLACE ME

This function is not exported by default, but exportable.

Arguments ('*' denotes required arguments):

=over 4

=item * B<bps_code> => I<int>

Only return records where the 'bps_code' field equals specified value.

=item * B<bps_code.in> => I<array[int]>

Only return records where the 'bps_code' field is in the specified values.

=item * B<bps_code.is> => I<int>

Only return records where the 'bps_code' field equals specified value.

=item * B<bps_code.isnt> => I<int>

Only return records where the 'bps_code' field does not equal specified value.

=item * B<bps_code.max> => I<int>

Only return records where the 'bps_code' field is less than or equal to specified value.

=item * B<bps_code.min> => I<int>

Only return records where the 'bps_code' field is greater than or equal to specified value.

=item * B<bps_code.not_in> => I<array[int]>

Only return records where the 'bps_code' field is not in the specified values.

=item * B<bps_code.xmax> => I<int>

Only return records where the 'bps_code' field is less than specified value.

=item * B<bps_code.xmin> => I<int>

Only return records where the 'bps_code' field is greater than specified value.

=item * B<detail> => I<bool> (default: 0)

Return array of full records instead of just ID fields.

By default, only the key (ID) field is returned per result entry.

=item * B<eng_name> => I<str>

Only return records where the 'eng_name' field equals specified value.

=item * B<eng_name.contains> => I<str>

Only return records where the 'eng_name' field contains specified text.

=item * B<eng_name.in> => I<array[str]>

Only return records where the 'eng_name' field is in the specified values.

=item * B<eng_name.is> => I<str>

Only return records where the 'eng_name' field equals specified value.

=item * B<eng_name.isnt> => I<str>

Only return records where the 'eng_name' field does not equal specified value.

=item * B<eng_name.max> => I<str>

Only return records where the 'eng_name' field is less than or equal to specified value.

=item * B<eng_name.min> => I<str>

Only return records where the 'eng_name' field is greater than or equal to specified value.

=item * B<eng_name.not_contains> => I<str>

Only return records where the 'eng_name' field does not contain specified text.

=item * B<eng_name.not_in> => I<array[str]>

Only return records where the 'eng_name' field is not in the specified values.

=item * B<eng_name.xmax> => I<str>

Only return records where the 'eng_name' field is less than specified value.

=item * B<eng_name.xmin> => I<str>

Only return records where the 'eng_name' field is greater than specified value.

=item * B<exclude_fields> => I<array[str]>

Select fields to return.

=item * B<fields> => I<array[str]>

Select fields to return.

=item * B<ind_abbrev> => I<str>

Only return records where the 'ind_abbrev' field equals specified value.

=item * B<ind_abbrev.contains> => I<str>

Only return records where the 'ind_abbrev' field contains specified text.

=item * B<ind_abbrev.in> => I<array[str]>

Only return records where the 'ind_abbrev' field is in the specified values.

=item * B<ind_abbrev.is> => I<str>

Only return records where the 'ind_abbrev' field equals specified value.

=item * B<ind_abbrev.isnt> => I<str>

Only return records where the 'ind_abbrev' field does not equal specified value.

=item * B<ind_abbrev.max> => I<str>

Only return records where the 'ind_abbrev' field is less than or equal to specified value.

=item * B<ind_abbrev.min> => I<str>

Only return records where the 'ind_abbrev' field is greater than or equal to specified value.

=item * B<ind_abbrev.not_contains> => I<str>

Only return records where the 'ind_abbrev' field does not contain specified text.

=item * B<ind_abbrev.not_in> => I<array[str]>

Only return records where the 'ind_abbrev' field is not in the specified values.

=item * B<ind_abbrev.xmax> => I<str>

Only return records where the 'ind_abbrev' field is less than specified value.

=item * B<ind_abbrev.xmin> => I<str>

Only return records where the 'ind_abbrev' field is greater than specified value.

=item * B<ind_capital_name> => I<str>

Only return records where the 'ind_capital_name' field equals specified value.

=item * B<ind_capital_name.contains> => I<str>

Only return records where the 'ind_capital_name' field contains specified text.

=item * B<ind_capital_name.in> => I<array[str]>

Only return records where the 'ind_capital_name' field is in the specified values.

=item * B<ind_capital_name.is> => I<str>

Only return records where the 'ind_capital_name' field equals specified value.

=item * B<ind_capital_name.isnt> => I<str>

Only return records where the 'ind_capital_name' field does not equal specified value.

=item * B<ind_capital_name.max> => I<str>

Only return records where the 'ind_capital_name' field is less than or equal to specified value.

=item * B<ind_capital_name.min> => I<str>

Only return records where the 'ind_capital_name' field is greater than or equal to specified value.

=item * B<ind_capital_name.not_contains> => I<str>

Only return records where the 'ind_capital_name' field does not contain specified text.

=item * B<ind_capital_name.not_in> => I<array[str]>

Only return records where the 'ind_capital_name' field is not in the specified values.

=item * B<ind_capital_name.xmax> => I<str>

Only return records where the 'ind_capital_name' field is less than specified value.

=item * B<ind_capital_name.xmin> => I<str>

Only return records where the 'ind_capital_name' field is greater than specified value.

=item * B<ind_island_name> => I<str>

Only return records where the 'ind_island_name' field equals specified value.

=item * B<ind_island_name.contains> => I<str>

Only return records where the 'ind_island_name' field contains specified text.

=item * B<ind_island_name.in> => I<array[str]>

Only return records where the 'ind_island_name' field is in the specified values.

=item * B<ind_island_name.is> => I<str>

Only return records where the 'ind_island_name' field equals specified value.

=item * B<ind_island_name.isnt> => I<str>

Only return records where the 'ind_island_name' field does not equal specified value.

=item * B<ind_island_name.max> => I<str>

Only return records where the 'ind_island_name' field is less than or equal to specified value.

=item * B<ind_island_name.min> => I<str>

Only return records where the 'ind_island_name' field is greater than or equal to specified value.

=item * B<ind_island_name.not_contains> => I<str>

Only return records where the 'ind_island_name' field does not contain specified text.

=item * B<ind_island_name.not_in> => I<array[str]>

Only return records where the 'ind_island_name' field is not in the specified values.

=item * B<ind_island_name.xmax> => I<str>

Only return records where the 'ind_island_name' field is less than specified value.

=item * B<ind_island_name.xmin> => I<str>

Only return records where the 'ind_island_name' field is greater than specified value.

=item * B<ind_name> => I<str>

Only return records where the 'ind_name' field equals specified value.

=item * B<ind_name.contains> => I<str>

Only return records where the 'ind_name' field contains specified text.

=item * B<ind_name.in> => I<array[str]>

Only return records where the 'ind_name' field is in the specified values.

=item * B<ind_name.is> => I<str>

Only return records where the 'ind_name' field equals specified value.

=item * B<ind_name.isnt> => I<str>

Only return records where the 'ind_name' field does not equal specified value.

=item * B<ind_name.max> => I<str>

Only return records where the 'ind_name' field is less than or equal to specified value.

=item * B<ind_name.min> => I<str>

Only return records where the 'ind_name' field is greater than or equal to specified value.

=item * B<ind_name.not_contains> => I<str>

Only return records where the 'ind_name' field does not contain specified text.

=item * B<ind_name.not_in> => I<array[str]>

Only return records where the 'ind_name' field is not in the specified values.

=item * B<ind_name.xmax> => I<str>

Only return records where the 'ind_name' field is less than specified value.

=item * B<ind_name.xmin> => I<str>

Only return records where the 'ind_name' field is greater than specified value.

=item * B<iso3166_2_code> => I<str>

Only return records where the 'iso3166_2_code' field equals specified value.

=item * B<iso3166_2_code.contains> => I<str>

Only return records where the 'iso3166_2_code' field contains specified text.

=item * B<iso3166_2_code.in> => I<array[str]>

Only return records where the 'iso3166_2_code' field is in the specified values.

=item * B<iso3166_2_code.is> => I<str>

Only return records where the 'iso3166_2_code' field equals specified value.

=item * B<iso3166_2_code.isnt> => I<str>

Only return records where the 'iso3166_2_code' field does not equal specified value.

=item * B<iso3166_2_code.max> => I<str>

Only return records where the 'iso3166_2_code' field is less than or equal to specified value.

=item * B<iso3166_2_code.min> => I<str>

Only return records where the 'iso3166_2_code' field is greater than or equal to specified value.

=item * B<iso3166_2_code.not_contains> => I<str>

Only return records where the 'iso3166_2_code' field does not contain specified text.

=item * B<iso3166_2_code.not_in> => I<array[str]>

Only return records where the 'iso3166_2_code' field is not in the specified values.

=item * B<iso3166_2_code.xmax> => I<str>

Only return records where the 'iso3166_2_code' field is less than specified value.

=item * B<iso3166_2_code.xmin> => I<str>

Only return records where the 'iso3166_2_code' field is greater than specified value.

=item * B<queries> => I<array[str]>

Search.

This will search all searchable fields with one or more specified queries. Each
query can be in the form of C<-FOO> (dash prefix notation) to require that the
fields do not contain specified string, or C</FOO/> to use regular expression.
All queries must match if the C<query_boolean> option is set to C<and>; only one
query should match if the C<query_boolean> option is set to C<or>.

=item * B<query_boolean> => I<str> (default: "and")

Whether records must match all search queries ('and') or just one ('or').

If set to C<and>, all queries must match; if set to C<or>, only one query should
match. See the C<queries> option for more details on searching.

=item * B<random> => I<bool> (default: 0)

Return records in random order.

=item * B<result_limit> => I<int>

Only return a certain number of records.

=item * B<result_start> => I<int> (default: 1)

Only return starting from the n'th record.

=item * B<sort> => I<array[str]>

Order records according to certain field(s).

A list of field names separated by comma. Each field can be prefixed with '-' to
specify descending order instead of the default ascending.

=item * B<tags> => I<str>

Only return records where the 'tags' field equals specified value.

=item * B<tags.contains> => I<str>

Only return records where the 'tags' field contains specified text.

=item * B<tags.in> => I<array[str]>

Only return records where the 'tags' field is in the specified values.

=item * B<tags.is> => I<str>

Only return records where the 'tags' field equals specified value.

=item * B<tags.isnt> => I<str>

Only return records where the 'tags' field does not equal specified value.

=item * B<tags.max> => I<str>

Only return records where the 'tags' field is less than or equal to specified value.

=item * B<tags.min> => I<str>

Only return records where the 'tags' field is greater than or equal to specified value.

=item * B<tags.not_contains> => I<str>

Only return records where the 'tags' field does not contain specified text.

=item * B<tags.not_in> => I<array[str]>

Only return records where the 'tags' field is not in the specified values.

=item * B<tags.xmax> => I<str>

Only return records where the 'tags' field is less than specified value.

=item * B<tags.xmin> => I<str>

Only return records where the 'tags' field is greater than specified value.

=item * B<with_field_names> => I<bool>

Return field names in each record (as hashE<sol>associative array).

When enabled, function will return each record as hash/associative array
(field name => value pairs). Otherwise, function will return each record
as list/array (field value, field value, ...).


=back

Returns an enveloped result (an array).

First element ($status_code) is an integer containing HTTP-like status code
(200 means OK, 4xx caller error, 5xx function error). Second element
($reason) is a string containing error message, or something like "OK" if status is
200. Third element ($payload) is the actual result, but usually not present when enveloped result is an error response ($status_code is not 2xx). Fourth
element (%result_meta) is called result metadata and is optional, a hash
that contains extra information, much like how HTTP response headers provide additional metadata.

Return value:  (any)

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Locale-ID-Province>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Locale-ID-Province>.

=head1 SEE ALSO

L<list-idn-provinces> (from L<App::IndonesianLocaleUtils>)

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTOR

=for stopwords Steven Haryanto

Steven Haryanto <stevenharyanto@gmail.com>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024, 2017, 2015, 2014, 2012 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Locale-ID-Province>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
