/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.LabeledScoredTreeNode;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;

public class LabeledScoredTreeLeaf
extends Tree {
    private static final long serialVersionUID = 7626389793561604973L;
    private Label label;
    private double score;

    public LabeledScoredTreeLeaf() {
    }

    public LabeledScoredTreeLeaf(Label label) {
        this.label = label;
    }

    public LabeledScoredTreeLeaf(Label label, double score) {
        this.label = label;
        this.score = score;
    }

    public boolean isLeaf() {
        return true;
    }

    public Tree[] children() {
        return EMPTY_TREE_ARRAY;
    }

    public void setChildren(Tree[] children) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return ((Object)this.label).toString();
    }

    public StringBuilder toStringBuilder(StringBuilder sb) {
        return sb.append(this.toString());
    }

    public Label label() {
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public double score() {
        return this.score;
    }

    public void setScore(double score) {
        this.score = score;
    }

    public void insertDtr(Tree dtr, int position) {
        throw new UnsupportedOperationException();
    }

    public void addChild(int i, Tree t) {
        throw new UnsupportedOperationException();
    }

    public void addChild(Tree t) {
        throw new UnsupportedOperationException();
    }

    public Tree setChild(int i, Tree t) {
        throw new UnsupportedOperationException();
    }

    public TreeFactory treeFactory() {
        LabelFactory lf = this.label() != null ? this.label().labelFactory() : StringLabel.factory();
        return new LabeledScoredTreeFactory(lf);
    }

    public static TreeFactory factory() {
        return LabeledScoredTreeNode.factory();
    }

    public static TreeFactory factory(LabelFactory lf) {
        return LabeledScoredTreeNode.factory(lf);
    }
}

