/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.loader;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.ClassFactory;

public final class ClassInspector {
    private static final String[] primTypeNames = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"};
    private static final String[] nonPrimTypeNames = new String[]{"java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double"};
    private final ClassFactory cf;
    static /* synthetic */ Class class$java$lang$Object;

    public ClassInspector(ClassFactory classFactory) {
        this.cf = classFactory;
    }

    public boolean instanceOf(String string, Object object) throws ClassNotFoundException {
        Class clazz = this.getClass(string);
        if (clazz == null) {
            return false;
        }
        return clazz.isInstance(object);
    }

    public boolean assignableTo(String string, String string2) {
        try {
            Class clazz = this.getClass(string2);
            if (clazz == null) {
                return false;
            }
            Class clazz2 = this.getClass(string);
            if (clazz2 == null) {
                return !clazz.isPrimitive() || clazz == Void.TYPE;
            }
            return clazz.isAssignableFrom(clazz2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public boolean accessible(String string) throws ClassNotFoundException {
        Class clazz = this.getClass(string);
        if (clazz == null) {
            return false;
        }
        return Modifier.isPublic(clazz.getModifiers());
    }

    public String getType(Member member) {
        Class<Object> clazz = member instanceof Method ? ((Method)member).getReturnType() : (member instanceof Field ? ((Field)member).getType() : (member instanceof Constructor ? ((Constructor)member).getDeclaringClass() : Void.TYPE));
        return ClassInspector.readableClassName(clazz);
    }

    public Member findPublicMethod(String string, String string2, String[] stringArray, String[] stringArray2, boolean[] blArray, boolean bl, boolean bl2) throws ClassNotFoundException, StandardException {
        Class[] classArray;
        Class[] classArray2;
        Class clazz;
        block13: {
            clazz = this.getClass(string);
            if (clazz == null) {
                return null;
            }
            if (clazz.isPrimitive()) {
                return null;
            }
            if (stringArray == null) {
                Method[] methodArray = clazz.getMethods();
                for (int i = 0; i < methodArray.length; ++i) {
                    if (bl && !Modifier.isStatic(methodArray[i].getModifiers()) || !string2.equals(methodArray[i].getName())) continue;
                    return methodArray[i];
                }
                return null;
            }
            classArray2 = new Class[stringArray.length];
            classArray = null;
            if (stringArray2 != null) {
                classArray = new Class[stringArray2.length];
            }
            for (int i = 0; i < classArray2.length; ++i) {
                classArray2[i] = this.getClass(stringArray[i]);
                if (stringArray2 == null) continue;
                classArray[i] = stringArray2[i].equals(stringArray[i]) ? null : this.getClass(stringArray2[i]);
            }
            if (classArray2.length == 0) {
                try {
                    Method method = clazz.getMethod(string2, classArray2);
                    if (bl && !Modifier.isStatic(method.getModifiers())) {
                        return null;
                    }
                    return method;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (clazz.isInterface()) break block13;
                    return null;
                }
            }
        }
        Member[] memberArray = clazz.getMethods();
        if (clazz.isInterface()) {
            Method[] methodArray = (class$java$lang$Object == null ? (class$java$lang$Object = ClassInspector.class$("java.lang.Object")) : class$java$lang$Object).getMethods();
            if (memberArray.length == 0) {
                memberArray = methodArray;
            } else {
                Member[] memberArray2 = new Member[memberArray.length + methodArray.length];
                System.arraycopy(memberArray, 0, memberArray2, 0, memberArray.length);
                System.arraycopy(methodArray, 0, memberArray2, memberArray.length, methodArray.length);
                memberArray = memberArray2;
            }
        }
        return this.resolveMethod(clazz, string2, classArray2, classArray, blArray, bl, bl2, memberArray);
    }

    public Member findPublicField(String string, String string2, boolean bl) throws StandardException {
        Exception exception;
        block9: {
            exception = null;
            try {
                Class clazz = this.getClass(string);
                if (clazz == null) {
                    return null;
                }
                if (clazz.isArray() || clazz.isPrimitive()) {
                    return null;
                }
                int n = bl ? 9 : 1;
                Field field = clazz.getField(string2);
                if ((field.getModifiers() & n) != n) break block9;
                if (clazz.isInterface() || field.getDeclaringClass().equals(clazz)) {
                    return field;
                }
                try {
                    Field field2 = clazz.getDeclaredField(string2);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    return field;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                exception = classNotFoundException;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                exception = noSuchFieldException;
            }
            catch (SecurityException securityException) {
                exception = securityException;
            }
        }
        throw StandardException.newException(bl ? "42X72" : "42X68", exception, (Object)string2, (Object)string);
    }

    public Member findPublicConstructor(String string, String[] stringArray, String[] stringArray2, boolean[] blArray) throws ClassNotFoundException, StandardException {
        Class[] classArray;
        Class[] classArray2;
        Class clazz;
        block8: {
            clazz = this.getClass(string);
            if (clazz == null) {
                return null;
            }
            if (clazz.isArray() || clazz.isPrimitive() || clazz.isInterface()) {
                return null;
            }
            classArray2 = new Class[stringArray.length];
            classArray = null;
            if (stringArray2 != null) {
                classArray = new Class[stringArray2.length];
            }
            boolean bl = false;
            for (int i = 0; i < classArray2.length; ++i) {
                classArray2[i] = this.getClass(stringArray[i]);
                if (classArray2[i] == null) {
                    bl = true;
                }
                if (stringArray2 == null) continue;
                classArray[i] = stringArray2[i].equals(stringArray[i]) ? null : this.getClass(stringArray2[i]);
            }
            try {
                if (!bl && stringArray2 == null) {
                    Constructor constructor = clazz.getConstructor(classArray2);
                    return constructor;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (classArray2.length != 0) break block8;
                return null;
            }
        }
        return this.resolveMethod(clazz, "<init>", classArray2, classArray, blArray, false, false, clazz.getConstructors());
    }

    public String[] getParameterTypes(Member member) {
        Class<?>[] classArray = member instanceof Method ? ((Method)member).getParameterTypes() : ((Constructor)member).getParameterTypes();
        String[] stringArray = new String[classArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ClassInspector.readableClassName(classArray[i]);
        }
        return stringArray;
    }

    public static boolean primitiveType(String string) {
        for (int i = 0; i < primTypeNames.length; ++i) {
            if (!string.equals(primTypeNames[i])) continue;
            return true;
        }
        return false;
    }

    private Member resolveMethod(Class clazz, String string, Class[] classArray, Class[] classArray2, boolean[] blArray, boolean bl, boolean bl2, Member[] memberArray) throws StandardException {
        boolean bl3;
        boolean bl4;
        int n = -1;
        boolean bl5 = true;
        do {
            bl4 = false;
            bl3 = false;
            block1: for (int i = 0; i < memberArray.length; ++i) {
                Class[] classArray3;
                Member member = memberArray[i];
                if (member == null || i == n) continue;
                Class[] classArray4 = classArray3 = member instanceof Method ? ((Method)member).getParameterTypes() : ((Constructor)member).getParameterTypes();
                if (bl5) {
                    if (bl2) {
                        if (classArray3.length < classArray.length) {
                            memberArray[i] = null;
                            continue;
                        }
                    } else if (classArray3.length != classArray.length) {
                        memberArray[i] = null;
                        continue;
                    }
                    if (bl && !Modifier.isStatic(member.getModifiers())) {
                        memberArray[i] = null;
                        continue;
                    }
                    if (!string.startsWith("<") && !string.equals(member.getName())) {
                        memberArray[i] = null;
                        continue;
                    }
                    if (bl2) {
                        for (int j = classArray.length - 1; j < classArray3.length; ++j) {
                            if (classArray3[j].equals(classArray[classArray.length - 1])) continue;
                            memberArray[i] = null;
                            continue block1;
                        }
                    }
                }
                if (!this.signatureConvertableFromTo(classArray, classArray2, classArray3, blArray, false)) {
                    memberArray[i] = null;
                    continue;
                }
                if (n == -1) {
                    n = i;
                    continue;
                }
                Member member2 = memberArray[n];
                boolean bl6 = this.isMethodMoreSpecificOrEqual(member2, member, blArray);
                boolean bl7 = this.isMethodMoreSpecificOrEqual(member, member2, blArray);
                if (bl6 && !bl7) {
                    memberArray[i] = null;
                    continue;
                }
                if (bl7 && !bl6) {
                    memberArray[n] = null;
                    n = i;
                    bl3 = true;
                    continue;
                }
                bl4 = true;
            }
            bl5 = false;
        } while (bl4 && bl3);
        if (bl4) {
            String string2 = "";
            for (int i = 0; i < classArray.length; ++i) {
                if (i != 0) {
                    string2 = string2 + ", ";
                }
                string2 = string2 + (classArray[i] == null ? "null" : classArray[i].getName());
                if (classArray2 == null || classArray2[i] == null) continue;
                string2 = string2 + "(" + classArray2[i].getName() + ")";
            }
            throw StandardException.newException("42X73", clazz.getName(), (Object)string, (Object)string2);
        }
        if (n == -1) {
            return null;
        }
        return memberArray[n];
    }

    public Class getClass(String string) throws ClassNotFoundException {
        if (string == null || string.length() == 0) {
            return null;
        }
        int n = 0;
        int n2 = string.length();
        int n3 = n2 - 2;
        while (n3 >= 0 && string.substring(n3, n3 + 2).equals("[]")) {
            ++n;
            n3 -= 2;
            n2 -= 2;
        }
        if (n2 <= 0) {
            return Class.forName(string);
        }
        if (n != 0) {
            string = string.substring(0, n2);
        }
        Class<Object> clazz = null;
        if (n2 >= 3 && n2 <= 7) {
            if ("int".equals(string)) {
                clazz = Integer.TYPE;
            } else if ("short".equals(string)) {
                clazz = Short.TYPE;
            } else if ("boolean".equals(string)) {
                clazz = Boolean.TYPE;
            } else if ("byte".equals(string)) {
                clazz = Byte.TYPE;
            } else if ("float".equals(string)) {
                clazz = Float.TYPE;
            } else if ("double".equals(string)) {
                clazz = Double.TYPE;
            } else if ("long".equals(string)) {
                clazz = Long.TYPE;
            } else if ("char".equals(string)) {
                clazz = Character.TYPE;
            } else if ("void".equals(string)) {
                clazz = Void.TYPE;
            }
        }
        if (clazz == null) {
            clazz = this.cf.loadApplicationClass(string);
        }
        if (n == 0) {
            return clazz;
        }
        if (n == 1) {
            return Array.newInstance(clazz, 0).getClass();
        }
        return Array.newInstance(clazz, new int[n]).getClass();
    }

    private boolean isMethodMoreSpecificOrEqual(Member member, Member member2, boolean[] blArray) {
        Class[] classArray;
        Class[] classArray2;
        if (member instanceof Method) {
            if (!this.classConvertableFromTo(member.getDeclaringClass(), member2.getDeclaringClass(), true)) {
                return false;
            }
            classArray2 = ((Method)member).getParameterTypes();
            classArray = ((Method)member2).getParameterTypes();
        } else {
            classArray2 = ((Constructor)member).getParameterTypes();
            classArray = ((Constructor)member2).getParameterTypes();
        }
        return this.signatureConvertableFromTo(classArray2, null, classArray, blArray, true);
    }

    private boolean signatureConvertableFromTo(Class[] classArray, Class[] classArray2, Class[] classArray3, boolean[] blArray, boolean bl) {
        int n = classArray.length;
        if (classArray3.length < n) {
            n = classArray3.length;
        }
        for (int i = 0; i < n; ++i) {
            Class clazz = classArray[i];
            Class clazz2 = classArray3[i];
            if (!(clazz == null ? clazz2.isPrimitive() && (classArray2 == null || blArray != null && !blArray[i]) : !this.classConvertableFromTo(clazz, clazz2, bl) && (classArray2 == null || classArray2[i] == null || !this.classConvertableFromTo(classArray2[i], clazz2, bl)))) continue;
            return false;
        }
        return true;
    }

    protected boolean classConvertableFromTo(Class clazz, Class clazz2, boolean bl) {
        if (clazz2.isAssignableFrom(clazz)) {
            return true;
        }
        if (!(clazz2.isPrimitive() && clazz.isPrimitive() || bl)) {
            return false;
        }
        String string = clazz.getName();
        String string2 = clazz2.getName();
        return clazz == Boolean.TYPE || string.equals(nonPrimTypeNames[0]) ? clazz2 == Boolean.TYPE || string2.equals(nonPrimTypeNames[0]) : (clazz == Byte.TYPE || string.equals(nonPrimTypeNames[1]) ? clazz2 == Byte.TYPE || string2.equals(nonPrimTypeNames[1]) || clazz2 == Short.TYPE || clazz2 == Integer.TYPE || clazz2 == Long.TYPE || clazz2 == Float.TYPE || clazz2 == Double.TYPE : (clazz == Character.TYPE || string.equals(nonPrimTypeNames[2]) ? clazz2 == Character.TYPE || string2.equals(nonPrimTypeNames[2]) || clazz2 == Integer.TYPE || clazz2 == Long.TYPE || clazz2 == Float.TYPE || clazz2 == Double.TYPE : (clazz == Short.TYPE || string.equals(nonPrimTypeNames[3]) ? clazz2 == Short.TYPE || string2.equals(nonPrimTypeNames[3]) || clazz2 == Integer.TYPE || clazz2 == Long.TYPE || clazz2 == Float.TYPE || clazz2 == Double.TYPE : (clazz == Integer.TYPE || string.equals(nonPrimTypeNames[4]) ? clazz2 == Integer.TYPE || string2.equals(nonPrimTypeNames[4]) || clazz2 == Long.TYPE || clazz2 == Float.TYPE || clazz2 == Double.TYPE : (clazz == Long.TYPE || string.equals(nonPrimTypeNames[5]) ? clazz2 == Long.TYPE || string2.equals(nonPrimTypeNames[5]) || clazz2 == Float.TYPE || clazz2 == Double.TYPE : (clazz == Float.TYPE || string.equals(nonPrimTypeNames[6]) ? clazz2 == Float.TYPE || string2.equals(nonPrimTypeNames[6]) || clazz2 == Double.TYPE : !(clazz != Double.TYPE && !string.equals(nonPrimTypeNames[7]) || clazz2 != Double.TYPE && !string2.equals(nonPrimTypeNames[7]))))))));
    }

    public static String readableClassName(Class clazz) {
        if (!clazz.isArray()) {
            return clazz.getName();
        }
        int n = 0;
        do {
            ++n;
        } while ((clazz = clazz.getComponentType()).isArray());
        StringBuffer stringBuffer = new StringBuffer(clazz.getName());
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("[]");
        }
        return stringBuffer.toString();
    }

    public String getDeclaringClass(Member member) {
        return member.getDeclaringClass().getName();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

