#!/usr/bin/env perl
use strict;
use Carp;
use Pod::Usage;
use Math::FixedPrecision;

BEGIN {
  use Test::More tests=>2;
  use_ok( 'InSilicoSpectro::Spectra::Filter::MSFilterCollection' );
 }

=head1 NAME

testMSFilterAlgorithm.pl

=head1 DESCRIPTION

test the class MSFilterCollection.pm

=head1 COPYRIGHT

Copyright (C) 2004-2005  Geneva Bioinformatics www.genebio.com

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

=head1 AUTHORS

Roman Mylonas, www.genebio.com

=cut


use Carp;
#use File::Compare;


eval{
  my $dataDir = "testData";
  my $xml_file= "$dataDir/test_collection.xml";
  my $file= "$dataDir/test_collection.mgf";
  my $format="mgf";


  my $sp=InSilicoSpectro::Spectra::MSSpectra->new(source=>$file, format=>$format);
  $sp->open();


  my $fc = new InSilicoSpectro::Spectra::Filter::MSFilterCollection();
  $fc->readXml($xml_file);
  $fc->filterSpectra($sp);

  my @result;

  foreach(@{$sp->spectra()}){
    foreach(@{$_->spectra()}){

      push @result, sprintf("%f\t%f", $_->[0],$_->[1]);
      
#      printf("%f\t%f\n", $_->[0],$_->[1]);
    }
  }

  my $ok=1;
  my $i=0;
  while(my $line= <DATA>){
    chomp $line;

    unless($line eq $result[$i]){
	    $ok=0;
	    fail("FilterCollection");
	    carp "#\tposition $i: expect \'".$line."\' instead of \'".$result[$i]."\'\n";
	    last;
	  }
    $i++;
  }
  pass("FilterCollection") if $ok;


};
if ($@){
  carp($@);
}


__DATA__
180.947000	69.000000
183.096000	107.000000
194.022000	67.000000
195.138000	74.000000
196.110000	101.000000
209.033000	119.000000
281.329000	85.000000
314.153000	68.000000
336.247000	63.000000
345.225000	101.000000
398.576000	207.000000
451.123000	450.000000
455.692000	3149.000000
477.283000	960.000000
499.298000	311.000000
502.301000	208.000000
543.309000	485.000000
548.323000	368.000000
554.102000	1099.000000
555.329000	659.000000
558.669000	270.000000
560.945000	202.000000
564.004000	215.000000
579.506000	177.000000
626.281000	403.000000
626.925000	103.000000
639.420000	111.000000
644.160000	172.000000
652.422000	107.000000
661.170000	119.000000
662.904000	165.000000
671.505000	85.000000
690.930000	99.000000
693.031000	125.000000
704.914000	230.000000
707.000000	141.000000
724.215000	87.000000
725.667000	72.000000
739.296000	110.000000
740.735000	82.000000
742.552000	314.000000
753.211000	118.000000
757.627000	85.000000
807.265000	113.000000
821.323000	68.000000
847.469000	87.000000
855.251000	64.000000
918.520000	66.000000
935.534000	74.000000
129.024000	101.000000
195.111000	70.000000
200.954000	50.000000
208.434000	55.000000
234.611000	92.000000
235.029000	54.000000
247.929000	88.000000
266.527000	51.000000
275.082000	120.000000
277.899000	75.000000
286.029000	55.000000
304.328000	88.000000
308.707000	103.000000
309.206000	72.000000
314.170000	89.000000
329.947000	94.000000
333.077000	119.000000
342.136000	78.000000
344.611000	290.000000
346.780000	73.000000
368.066000	112.000000
400.271000	112.000000
404.254000	106.000000
409.119000	144.000000
409.780000	93.000000
411.753000	94.000000
450.445000	323.000000
451.028000	226.000000
464.227000	177.000000
465.577000	266.000000
467.082000	113.000000
476.854000	345.000000
477.199000	438.000000
477.761000	238.000000
478.261000	157.000000
177.987000	646.000000
243.152000	339.000000
248.404000	424.000000
251.037000	1033.000000
251.885000	648.000000
259.318000	405.000000
262.044000	340.000000
277.109000	302.000000
278.030000	1952.000000
279.061000	301.000000
342.965000	439.000000
344.173000	314.000000
378.317000	489.000000
389.245000	3956.000000
407.154000	437.000000
409.169000	337.000000
423.082000	519.000000
457.518000	320.000000
477.469000	329.000000
478.249000	1589.000000
480.360000	532.000000
483.174000	595.000000
489.670000	602.000000
492.225000	421.000000
496.217000	399.000000
499.624000	559.000000
525.870000	382.000000
535.941000	376.000000
540.253000	719.000000
548.884000	1346.000000
568.657000	510.000000
570.786000	546.000000
582.375000	463.000000
588.972000	625.000000
593.225000	510.000000
600.388000	468.000000
601.367000	443.000000
602.264000	510.000000
607.408000	956.000000
611.426000	671.000000
618.460000	504.000000
619.103000	878.000000
637.434000	1379.000000
655.455000	626.000000
672.526000	493.000000
682.544000	559.000000
689.639000	813.000000
692.716000	1461.000000
706.787000	862.000000
708.431000	4893.000000
720.056000	449.000000
819.592000	2214.000000
836.902000	3379.000000
837.436000	6189.000000
864.490000	4594.000000
924.512000	602.000000
931.610000	510.000000
933.802000	441.000000
950.694000	482.000000
967.521000	598.000000
968.140000	489.000000
968.641000	961.000000
969.230000	424.000000
976.442000	510.000000
976.943000	674.000000
977.555000	1602.000000
129.071000	112.000000
130.071000	225.000000
146.884000	111.000000
153.926000	97.000000
155.858000	54.000000
218.135000	46.000000
218.940000	147.000000
224.841000	111.000000
235.817000	49.000000
242.352000	49.000000
245.418000	112.000000
246.912000	48.000000
265.032000	77.000000
274.969000	66.000000
303.868000	78.000000
314.033000	100.000000
321.943000	138.000000
326.254000	160.000000
327.447000	200.000000
336.941000	113.000000
344.157000	348.000000
349.855000	111.000000
353.227000	106.000000
353.848000	124.000000
354.354000	120.000000
371.192000	707.000000
380.836000	271.000000
412.886000	126.000000
413.008000	118.000000
442.268000	108.000000
454.364000	102.000000
465.617000	104.000000
471.973000	123.000000
475.149000	91.000000
477.524000	189.000000
494.264000	108.000000
497.224000	89.000000
502.984000	236.000000
504.068000	147.000000
512.123000	135.000000
512.924000	109.000000
515.130000	79.000000
544.725000	72.000000
546.970000	205.000000
556.342000	71.000000
566.439000	108.000000
617.843000	57.000000
625.623000	53.000000
634.496000	157.000000
637.064000	50.000000
652.322000	155.000000
652.966000	56.000000
703.375000	75.000000
724.217000	96.000000
759.343000	43.000000
773.864000	39.000000
774.464000	89.000000
134.205000	44.000000
155.927000	115.000000
156.928000	45.000000
162.144000	96.000000
174.948000	41.000000
182.978000	79.000000
207.945000	62.000000
210.495000	63.000000
211.180000	60.000000
235.465000	68.000000
241.944000	55.000000
242.749000	47.000000
244.540000	90.000000
275.193000	113.000000
285.402000	67.000000
300.052000	98.000000
310.820000	144.000000
320.257000	108.000000
326.305000	87.000000
327.195000	217.000000
332.974000	77.000000
344.687000	203.000000
350.532000	94.000000
359.423000	123.000000
360.189000	96.000000
371.299000	103.000000
380.334000	138.000000
386.109000	127.000000
402.148000	101.000000
409.221000	319.000000
442.135000	320.000000
442.658000	209.000000
447.288000	112.000000
454.167000	124.000000
461.177000	142.000000
465.804000	172.000000
473.724000	177.000000
486.376000	134.000000
488.273000	187.000000
500.212000	110.000000
502.076000	123.000000
502.668000	202.000000
511.451000	116.000000
512.952000	261.000000
519.027000	207.000000
521.602000	107.000000
541.678000	116.000000
548.299000	269.000000
578.749000	93.000000
585.714000	93.000000
593.995000	135.000000
595.058000	117.000000
611.874000	90.000000
612.783000	142.000000
618.458000	92.000000
621.953000	122.000000
626.476000	96.000000
633.662000	87.000000
651.426000	101.000000
652.438000	329.000000
671.521000	86.000000
679.289000	89.000000
681.763000	75.000000
688.525000	76.000000
688.912000	72.000000
691.432000	138.000000
720.546000	60.000000
740.433000	47.000000
742.431000	188.000000
771.426000	43.000000
780.342000	78.000000
789.970000	126.000000
802.449000	52.000000
817.822000	143.000000
850.357000	50.000000
884.675000	84.000000
893.102000	49.000000
893.785000	70.000000
895.448000	59.000000
912.268000	54.000000
929.666000	153.000000
931.515000	122.000000
936.628000	58.000000
444.708000	38.000000
449.064000	43.000000
462.419000	43.000000
525.472000	41.000000
544.112000	59.000000
561.908000	62.000000
615.119000	82.000000
626.426000	77.000000
646.921000	91.000000
681.876000	66.000000
736.226000	57.000000
745.942000	43.000000
810.222000	85.000000
156.012000	123.000000
162.925000	69.000000
167.024000	54.000000
183.062000	114.000000
209.123000	50.000000
225.266000	65.000000
240.140000	63.000000
266.515000	77.000000
274.893000	63.000000
282.585000	93.000000
286.100000	53.000000
312.146000	164.000000
323.098000	131.000000
333.247000	72.000000
337.669000	77.000000
341.813000	80.000000
353.131000	69.000000
355.123000	73.000000
373.241000	329.000000
373.830000	100.000000
374.074000	99.000000
386.206000	91.000000
402.217000	239.000000
403.186000	116.000000
405.049000	167.000000
422.655000	414.000000
423.252000	239.000000
424.332000	156.000000
442.252000	191.000000
445.295000	160.000000
451.619000	221.000000
454.230000	488.000000
455.780000	207.000000
456.025000	229.000000
457.309000	326.000000
487.263000	886.000000
488.324000	268.000000
491.077000	336.000000
491.709000	222.000000
506.017000	232.000000
506.443000	241.000000
507.348000	324.000000
510.810000	177.000000
529.778000	293.000000
534.762000	253.000000
536.205000	262.000000
543.242000	254.000000
543.829000	488.000000
544.229000	525.000000
544.842000	309.000000
547.921000	201.000000
555.184000	182.000000
559.389000	1187.000000
563.214000	226.000000
564.280000	216.000000
571.450000	169.000000
580.729000	190.000000
607.828000	324.000000
608.375000	169.000000
616.684000	236.000000
626.141000	219.000000
633.418000	111.000000
644.356000	166.000000
651.432000	111.000000
652.285000	134.000000
661.486000	169.000000
668.817000	125.000000
672.460000	82.000000
679.952000	139.000000
687.300000	92.000000
690.121000	81.000000
700.406000	94.000000
704.383000	90.000000
706.844000	122.000000
708.034000	90.000000
708.307000	88.000000
708.875000	70.000000
709.422000	107.000000
727.978000	87.000000
738.480000	72.000000
746.274000	65.000000
752.406000	182.000000
754.057000	100.000000
756.395000	54.000000
768.389000	93.000000
772.593000	55.000000
773.407000	193.000000
774.548000	90.000000
777.992000	63.000000
795.616000	128.000000
803.936000	50.000000
805.484000	68.000000
812.532000	148.000000
816.525000	55.000000
818.927000	52.000000
907.449000	188.000000
270.119000	673.000000
278.114000	888.000000
371.234000	217.000000
157.145000	82.000000
182.972000	186.000000
200.215000	37.000000
201.983000	39.000000
224.415000	44.000000
231.046000	60.000000
237.113000	75.000000
248.968000	50.000000
258.949000	63.000000
265.104000	102.000000
267.959000	56.000000
280.118000	115.000000
294.523000	85.000000
297.145000	70.000000
299.715000	143.000000
314.019000	139.000000
317.134000	98.000000
318.279000	268.000000
324.109000	111.000000
328.199000	71.000000
330.933000	130.000000
344.535000	138.000000
351.838000	76.000000
354.219000	88.000000
361.164000	99.000000
370.629000	130.000000
371.446000	138.000000
372.446000	96.000000
378.684000	123.000000
380.226000	95.000000
387.416000	93.000000
395.240000	126.000000
400.178000	131.000000
407.261000	111.000000
408.021000	128.000000
409.151000	315.000000
412.225000	126.000000
428.167000	117.000000
443.807000	138.000000
448.717000	184.000000
452.275000	102.000000
456.164000	200.000000
456.755000	520.000000
457.258000	243.000000
458.595000	135.000000
460.430000	163.000000
462.064000	210.000000
495.030000	167.000000
496.488000	118.000000
508.318000	160.000000
513.878000	103.000000
542.680000	114.000000
543.333000	475.000000
554.819000	383.000000
555.381000	333.000000
555.924000	292.000000
568.128000	205.000000
570.444000	98.000000
571.333000	273.000000
606.724000	89.000000
608.413000	132.000000
611.829000	158.000000
613.723000	154.000000
626.031000	77.000000
627.327000	75.000000
632.323000	75.000000
633.274000	108.000000
636.388000	110.000000
643.237000	129.000000
652.842000	77.000000
653.493000	75.000000
654.250000	75.000000
655.340000	78.000000
661.225000	178.000000
667.392000	112.000000
671.563000	139.000000
672.350000	91.000000
675.597000	74.000000
687.421000	92.000000
688.532000	93.000000
705.372000	88.000000
706.894000	97.000000
707.399000	113.000000
724.387000	84.000000
725.499000	116.000000
741.081000	87.000000
742.415000	870.000000
756.481000	121.000000
774.524000	265.000000
790.392000	333.000000
799.382000	83.000000
817.372000	177.000000
826.216000	74.000000
838.529000	48.000000
854.379000	98.000000
912.562000	46.000000
929.649000	77.000000
930.370000	156.000000
952.648000	95.000000
