# This file was created by configpm when Perl was built. Any changes
# made to this file will be lost the next time perl is built.

package Config;
use strict;
# use warnings; Pulls in Carp
# use vars pulls in Carp
@Config::EXPORT = qw(%Config);
@Config::EXPORT_OK = qw(myconfig config_sh config_vars config_re);

# Need to stub all the functions to make code such as print Config::config_sh
# keep working

sub myconfig;
sub config_sh;
sub config_vars;
sub config_re;

my %Export_Cache = map {($_ => 1)} (@Config::EXPORT, @Config::EXPORT_OK);

our %Config;

# Define our own import method to avoid pulling in the full Exporter:
sub import {
    my $pkg = shift;
    @_ = @Config::EXPORT unless @_;

    my @funcs = grep $_ ne '%Config', @_;
    my $export_Config = @funcs < @_ ? 1 : 0;

    no strict 'refs';
    my $callpkg = caller(0);
    foreach my $func (@funcs) {
	die sprintf qq{"%s" is not exported by the %s module\n},
	    $func, __PACKAGE__ unless $Export_Cache{$func};
	*{$callpkg.'::'.$func} = \&{$func};
    }

    *{"$callpkg\::Config"} = \%Config if $export_Config;
    return;
}

die "Perl lib version (5.10.0) doesn't match executable version ($])"
    unless $^V;

$^V eq 5.10.0
    or die "Perl lib version (5.10.0) doesn't match executable version (" .
	sprintf("v%vd",$^V) . ")";


sub FETCH {
    my($self, $key) = @_;

    # check for cached value (which may be undef so we use exists not defined)
    return $self->{$key} if exists $self->{$key};

    return $self->fetch_string($key);
}
sub TIEHASH {
    bless $_[1], $_[0];
}

sub DESTROY { }

sub AUTOLOAD {
    require 'Config_heavy.pl';
    goto \&launcher unless $Config::AUTOLOAD =~ /launcher$/;
    die "&Config::AUTOLOAD failed on $Config::AUTOLOAD";
}

# Locate $Config{perlpath} directly
our $perlpath = $^X;
unless ( -e $perlpath ) {
    die('Failed to auto-discover $Config{perlpath}');
}

# Derive $Config{bin} from $Config{perlpath}
our $bin = $perlpath;
$bin =~ s/(?:\\\\?|\/)perl\.exe$//;
unless ( $bin ne $perlpath and -d $bin ) {
    die('Failed to auto-discover $Config{bin}');
}

# Derive $Config{prefix} from $Config{bin}
our $prefix = $bin;
$prefix =~ s/(?:\\\\?|\/)bin$//;
unless ( $prefix ne $bin and -d $prefix ) {
    die('Failed to auto-discover $Config{prefix}');
}

# Derive the root from $Config{prefix}
our $root = $prefix;
$root =~ s/(?:\\\\?|\/)perl$//;
unless ( $root ne $prefix and -d $root ) {
    die('Failed to auto-discover the distribution root');
}

# tie returns the object, so the value returned to require will be true.
tie %Config, 'Config', {
    archlibexp => $prefix . '\\lib',
    archname => 'MSWin32-x86-multi-thread',
    cc => 'gcc',
    d_readlink => undef,
    d_symlink => undef,
    dlsrc => 'dl_win32.xs',
    dont_use_nlink => undef,
    exe_ext => '.exe',
    inc_version_list => '',
    intsize => '4',
    ldlibpthname => '',
    libpth => $root . '\\c\\lib',
    osname => 'MSWin32',
    osvers => '5.1',
    path_sep => ';',
    privlibexp => $prefix . '\\lib',
    scriptdir => $prefix . '\\bin',
    sitearchexp => $prefix . '\\site\\lib',
    sitelibexp => $prefix . '\\site\\lib',
    useithreads => 'define',
    usevendorprefix => undef,
    version => '5.10.0',
};
