/*                                                                
**  Copyright (C) 1996,2007,2010  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 3 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */

/* pargs.h
**/

#define EOARGV	0


typedef struct _ArgStream
{
  int ungotten;
  char unchar;
  char sep;
  char *here;
  int this;
  char **argv;
  int argc;
} *ArgStream;

#define ArgvChar(a)	( a->ungotten != 0 ? (a->ungotten = 0), a->unchar : \
			( ( a->this >= a->argc ) ? 0 :			    \
				( *a->here ? *a->here++ : 		    \
				   ((a->here = a->argv[++a->this]), a->sep ))))

#define ArgvUnChar(a, ch) ( a->unchar = ch, a->ungotten = 1 )

#define ArgvSep(a, ch)	a->sep = ch



ArgStream OpenArgv (int nth, char separator, char *argv[], int argc);
void CloseArgv (ArgStream a);
