# Generated by default/object.tt
package Paws::Prometheus::WorkspaceSummary;
  use Moose;
  has Alias => (is => 'ro', isa => 'Str', request_name => 'alias', traits => ['NameInRequest']);
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest'], required => 1);
  has CreatedAt => (is => 'ro', isa => 'Str', request_name => 'createdAt', traits => ['NameInRequest'], required => 1);
  has Status => (is => 'ro', isa => 'Paws::Prometheus::WorkspaceStatus', request_name => 'status', traits => ['NameInRequest'], required => 1);
  has WorkspaceId => (is => 'ro', isa => 'Str', request_name => 'workspaceId', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Prometheus::WorkspaceSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Prometheus::WorkspaceSummary object:

  $service_obj->Method(Att1 => { Alias => $value, ..., WorkspaceId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Prometheus::WorkspaceSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->Alias

=head1 DESCRIPTION

Represents a summary of the properties of a workspace.

=head1 ATTRIBUTES


=head2 Alias => Str

Alias of this workspace.


=head2 B<REQUIRED> Arn => Str

The AmazonResourceName of this workspace.


=head2 B<REQUIRED> CreatedAt => Str

The time when the workspace was created.


=head2 B<REQUIRED> Status => L<Paws::Prometheus::WorkspaceStatus>

The status of this workspace.


=head2 B<REQUIRED> WorkspaceId => Str

Unique string identifying this workspace.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Prometheus>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

