# Generated by default/object.tt
package Paws::MediaTailor::DefaultSegmentDeliveryConfiguration;
  use Moose;
  has BaseUrl => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaTailor::DefaultSegmentDeliveryConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaTailor::DefaultSegmentDeliveryConfiguration object:

  $service_obj->Method(Att1 => { BaseUrl => $value, ..., BaseUrl => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaTailor::DefaultSegmentDeliveryConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->BaseUrl

=head1 DESCRIPTION

The optional configuration for a server that serves segments. Use this
if you want the segment delivery server to be different from the source
location server. For example, you can configure your source location
server to be an origination server, such as MediaPackage, and the
segment delivery server to be a content delivery network (CDN), such as
CloudFront. If you don't specify a segment delivery server, then the
source location server is used.

=head1 ATTRIBUTES


=head2 BaseUrl => Str

The hostname of the server that will be used to serve segments. This
string must include the protocol, such as B<https://>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaTailor>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

