package WebService::Mattermost::V4::API::Object::Application;

# ABSTRACT: An application item.

use Moo;
use Types::Standard qw(ArrayRef Bool Maybe Str);

extends 'WebService::Mattermost::V4::API::Object';
with    qw(
    WebService::Mattermost::V4::API::Object::Role::Description
    WebService::Mattermost::V4::API::Object::Role::ID
    WebService::Mattermost::V4::API::Object::Role::Name
    WebService::Mattermost::V4::API::Object::Role::CreatedAt
    WebService::Mattermost::V4::API::Object::Role::UpdatedAt
);

################################################################################

has [ qw(
    client_secret
    icon_url
    homepage
) ]            => (is => 'ro', isa => Maybe[Str],  lazy => 1, builder => 1);
has is_trusted => (is => 'ro', isa => Maybe[Bool], lazy => 1, builder => 1);

################################################################################

sub _build_client_secret { shift->raw_data->{client_secret} }
sub _build_icon_url      { shift->raw_data->{icon_url}      }
sub _build_homepage      { shift->raw_data->{homepage}      }
sub _build_is_trusted    { shift->raw_data->{is_trusted}    }

################################################################################

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::Mattermost::V4::API::Object::Application - An application item.

=head1 VERSION

version 0.28

=head1 DESCRIPTION

Details a Mattermost Application object.

=head2 ATTRIBUTES

=over 4

=item C<client_secret>

=item C<icon_url>

=item C<homepage>

=item C<is_trusted>

=back

=head1 SEE ALSO

=over 4

=item L<WebService::Mattermost::V4::API::Object::Role::ID>

=back

=head1 AUTHOR

Mike Jones <mike@netsplit.org.uk>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2020 by Mike Jones.

This is free software, licensed under:

  The MIT (X11) License

=cut
