# Generated by default/object.tt
package Paws::SageMaker::MonitoringSchedule;
  use Moose;
  has CreationTime => (is => 'ro', isa => 'Str');
  has EndpointName => (is => 'ro', isa => 'Str');
  has FailureReason => (is => 'ro', isa => 'Str');
  has LastModifiedTime => (is => 'ro', isa => 'Str');
  has LastMonitoringExecutionSummary => (is => 'ro', isa => 'Paws::SageMaker::MonitoringExecutionSummary');
  has MonitoringScheduleArn => (is => 'ro', isa => 'Str');
  has MonitoringScheduleConfig => (is => 'ro', isa => 'Paws::SageMaker::MonitoringScheduleConfig');
  has MonitoringScheduleName => (is => 'ro', isa => 'Str');
  has MonitoringScheduleStatus => (is => 'ro', isa => 'Str');
  has MonitoringType => (is => 'ro', isa => 'Str');
  has Tags => (is => 'ro', isa => 'ArrayRef[Paws::SageMaker::Tag]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::MonitoringSchedule

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::MonitoringSchedule object:

  $service_obj->Method(Att1 => { CreationTime => $value, ..., Tags => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::MonitoringSchedule object:

  $result = $service_obj->Method(...);
  $result->Att1->CreationTime

=head1 DESCRIPTION

A schedule for a model monitoring job. For information about model
monitor, see Amazon SageMaker Model Monitor
(https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html).

=head1 ATTRIBUTES


=head2 CreationTime => Str

The time that the monitoring schedule was created.


=head2 EndpointName => Str

The endpoint that hosts the model being monitored.


=head2 FailureReason => Str

If the monitoring schedule failed, the reason it failed.


=head2 LastModifiedTime => Str

The last time the monitoring schedule was changed.


=head2 LastMonitoringExecutionSummary => L<Paws::SageMaker::MonitoringExecutionSummary>




=head2 MonitoringScheduleArn => Str

The Amazon Resource Name (ARN) of the monitoring schedule.


=head2 MonitoringScheduleConfig => L<Paws::SageMaker::MonitoringScheduleConfig>




=head2 MonitoringScheduleName => Str

The name of the monitoring schedule.


=head2 MonitoringScheduleStatus => Str

The status of the monitoring schedule. This can be one of the following
values.

=over

=item *

C<PENDING> - The schedule is pending being created.

=item *

C<FAILED> - The schedule failed.

=item *

C<SCHEDULED> - The schedule was successfully created.

=item *

C<STOPPED> - The schedule was stopped.

=back



=head2 MonitoringType => Str

The type of the monitoring job definition to schedule.


=head2 Tags => ArrayRef[L<Paws::SageMaker::Tag>]

A list of the tags associated with the monitoring schedlue. For more
information, see Tagging Amazon Web Services resources
(https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the
I<Amazon Web Services General Reference Guide>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

