# Generated by default/object.tt
package Paws::LexRuntime::PredictedIntent;
  use Moose;
  has IntentName => (is => 'ro', isa => 'Str', request_name => 'intentName', traits => ['NameInRequest']);
  has NluIntentConfidence => (is => 'ro', isa => 'Paws::LexRuntime::IntentConfidence', request_name => 'nluIntentConfidence', traits => ['NameInRequest']);
  has Slots => (is => 'ro', isa => 'Paws::LexRuntime::StringMap', request_name => 'slots', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexRuntime::PredictedIntent

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexRuntime::PredictedIntent object:

  $service_obj->Method(Att1 => { IntentName => $value, ..., Slots => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexRuntime::PredictedIntent object:

  $result = $service_obj->Method(...);
  $result->Att1->IntentName

=head1 DESCRIPTION

An intent that Amazon Lex suggests satisfies the user's intent.
Includes the name of the intent, the confidence that Amazon Lex has
that the user's intent is satisfied, and the slots defined for the
intent.

=head1 ATTRIBUTES


=head2 IntentName => Str

The name of the intent that Amazon Lex suggests satisfies the user's
intent.


=head2 NluIntentConfidence => L<Paws::LexRuntime::IntentConfidence>

Indicates how confident Amazon Lex is that an intent satisfies the
user's intent.


=head2 Slots => L<Paws::LexRuntime::StringMap>

The slot and slot values associated with the predicted intent.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexRuntime>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

