# Generated by default/object.tt
package Paws::Appflow::TriggerConfig;
  use Moose;
  has TriggerProperties => (is => 'ro', isa => 'Paws::Appflow::TriggerProperties', request_name => 'triggerProperties', traits => ['NameInRequest']);
  has TriggerType => (is => 'ro', isa => 'Str', request_name => 'triggerType', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Appflow::TriggerConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Appflow::TriggerConfig object:

  $service_obj->Method(Att1 => { TriggerProperties => $value, ..., TriggerType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Appflow::TriggerConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->TriggerProperties

=head1 DESCRIPTION

The trigger settings that determine how and when Amazon AppFlow runs
the specified flow.

=head1 ATTRIBUTES


=head2 TriggerProperties => L<Paws::Appflow::TriggerProperties>

Specifies the configuration details of a schedule-triggered flow as
defined by the user. Currently, these settings only apply to the
C<Scheduled> trigger type.


=head2 B<REQUIRED> TriggerType => Str

Specifies the type of flow trigger. This can be C<OnDemand>,
C<Scheduled>, or C<Event>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Appflow>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

