use warnings;
use strict;

use Test::More tests => 21*3 + 10*3;

my $test_input = "\x01\x02\x04\x08\x10\x20\x40\x80";
my $out;
my $f;

open($f, "<:bitswap(0)", \$test_input);
$/ = \1;
is tell($f), 0;
is scalar(<$f>), "\x01";
is tell($f), 1;
is scalar(<$f>), "\x02";
is tell($f), 2;
is scalar(<$f>), "\x04";
is tell($f), 3;
is scalar(<$f>), "\x08";
is tell($f), 4;
is scalar(<$f>), "\x10";
is tell($f), 5;
is scalar(<$f>), "\x20";
is tell($f), 6;
is scalar(<$f>), "\x40";
is tell($f), 7;
is scalar(<$f>), "\x80";
is tell($f), 8;
is scalar(<$f>), undef;
is tell($f), 8;
is scalar(<$f>), undef;
is tell($f), 8;
$f = undef;

open($f, "<:bitswap(4)", \$test_input);
$/ = \1;
is tell($f), 0;
is scalar(<$f>), "\x10";
is tell($f), 1;
is scalar(<$f>), "\x20";
is tell($f), 2;
is scalar(<$f>), "\x40";
is tell($f), 3;
is scalar(<$f>), "\x80";
is tell($f), 4;
is scalar(<$f>), "\x01";
is tell($f), 5;
is scalar(<$f>), "\x02";
is tell($f), 6;
is scalar(<$f>), "\x04";
is tell($f), 7;
is scalar(<$f>), "\x08";
is tell($f), 8;
is scalar(<$f>), undef;
is tell($f), 8;
is scalar(<$f>), undef;
is tell($f), 8;
$f = undef;

open($f, "<:bitswap(24)", \$test_input);
$/ = \1;
is tell($f), 0;
is scalar(<$f>), "\x08";
is tell($f), 1;
is scalar(<$f>), "\x04";
is tell($f), 2;
is scalar(<$f>), "\x02";
is tell($f), 3;
is scalar(<$f>), "\x01";
is tell($f), 4;
is scalar(<$f>), "\x80";
is tell($f), 5;
is scalar(<$f>), "\x40";
is tell($f), 6;
is scalar(<$f>), "\x20";
is tell($f), 7;
is scalar(<$f>), "\x10";
is tell($f), 8;
is scalar(<$f>), undef;
is tell($f), 8;
is scalar(<$f>), undef;
is tell($f), 8;
$f = undef;

$out = "";
open($f, ">:bitswap(0)", \$out);
is tell($f), 0;
print $f "\x01";
is tell($f), 1;
print $f "\x02";
is tell($f), 2;
print $f "\x04";
is tell($f), 3;
print $f "\x08";
is tell($f), 4;
print $f "\x10";
is tell($f), 5;
print $f "\x20";
is tell($f), 6;
print $f "\x40";
is tell($f), 7;
print $f "\x80";
is tell($f), 8;
$f = undef;
is $out, $test_input;

$out = "";
open($f, ">:bitswap(4)", \$out);
is tell($f), 0;
print $f "\x10";
is tell($f), 1;
print $f "\x20";
is tell($f), 2;
print $f "\x40";
is tell($f), 3;
print $f "\x80";
is tell($f), 4;
print $f "\x01";
is tell($f), 5;
print $f "\x02";
is tell($f), 6;
print $f "\x04";
is tell($f), 7;
print $f "\x08";
is tell($f), 8;
$f = undef;
is $out, $test_input;

$out = "";
open($f, ">:bitswap(24)", \$out);
is tell($f), 0;
print $f "\x08";
is tell($f), 1;
print $f "\x04";
is tell($f), 2;
print $f "\x02";
is tell($f), 3;
print $f "\x01";
is tell($f), 4;
print $f "\x80";
is tell($f), 5;
print $f "\x40";
is tell($f), 6;
print $f "\x20";
is tell($f), 7;
print $f "\x10";
is tell($f), 8;
$f = undef;
is $out, $test_input;

1;
