/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.TableName;

public class RenameNode
extends DDLStatementNode {
    protected TableName newTableName;
    protected String oldObjectName;
    protected String newObjectName;
    protected TableDescriptor td;
    private long conglomerateNumber;
    protected boolean usedAlterTable;
    protected int renamingWhat;

    public void init(Object object, Object object2, Object object3, Object object4, Object object5) throws StandardException {
        this.usedAlterTable = (Boolean)object4;
        this.renamingWhat = (Integer)object5;
        switch (this.renamingWhat) {
            case 1: {
                this.initAndCheck((TableName)object);
                this.newTableName = this.makeTableName(this.getObjectName().getSchemaName(), (String)object3);
                this.oldObjectName = null;
                this.newObjectName = this.newTableName.getTableName();
                break;
            }
            case 2: {
                TableName tableName = object instanceof TableName ? (TableName)object : this.makeTableName(null, (String)object);
                this.initAndCheck(tableName);
                this.oldObjectName = (String)object2;
                this.newObjectName = (String)object3;
                break;
            }
            case 3: {
                this.oldObjectName = (String)object2;
                this.newObjectName = (String)object3;
                break;
            }
        }
    }

    public String toString() {
        return "";
    }

    public String statementToString() {
        if (this.usedAlterTable) {
            return "ALTER TABLE";
        }
        switch (this.renamingWhat) {
            case 1: {
                return "RENAME TABLE";
            }
            case 2: {
                return "RENAME COLUMN";
            }
            case 3: {
                return "RENAME INDEX";
            }
        }
        return "UNKNOWN";
    }

    public QueryTreeNode bind() throws StandardException {
        TupleDescriptor tupleDescriptor;
        SchemaDescriptor schemaDescriptor;
        CompilerContext compilerContext = this.getCompilerContext();
        DataDictionary dataDictionary = this.getDataDictionary();
        if (this.renamingWhat == 3) {
            schemaDescriptor = this.getSchemaDescriptor(null);
            tupleDescriptor = dataDictionary.getConglomerateDescriptor(this.oldObjectName, schemaDescriptor, false);
            if (tupleDescriptor == null) {
                throw StandardException.newException("42X65", this.oldObjectName);
            }
            this.td = dataDictionary.getTableDescriptor(tupleDescriptor.getTableID());
            this.initAndCheck(this.makeTableName(this.td.getSchemaName(), this.td.getName()));
        } else {
            schemaDescriptor = this.getSchemaDescriptor();
        }
        this.td = this.getTableDescriptor();
        if (this.td.getTableType() == 3) {
            throw StandardException.newException("42995");
        }
        switch (this.renamingWhat) {
            case 1: {
                tupleDescriptor = this.getTableDescriptor(this.newObjectName, schemaDescriptor);
                if (tupleDescriptor != null) {
                    throw this.descriptorExistsException(tupleDescriptor, schemaDescriptor);
                }
                this.renameTableBind(dataDictionary);
                break;
            }
            case 2: {
                this.renameColumnBind(dataDictionary);
                break;
            }
            case 3: {
                ConglomerateDescriptor conglomerateDescriptor = dataDictionary.getConglomerateDescriptor(this.newObjectName, schemaDescriptor, false);
                if (conglomerateDescriptor == null) break;
                throw this.descriptorExistsException(conglomerateDescriptor, schemaDescriptor);
            }
        }
        this.conglomerateNumber = this.td.getHeapConglomerateId();
        ConglomerateDescriptor conglomerateDescriptor = this.td.getConglomerateDescriptor(this.conglomerateNumber);
        compilerContext.createDependency(this.td);
        compilerContext.createDependency(conglomerateDescriptor);
        return this;
    }

    public boolean referencesSessionSchema() throws StandardException {
        if (this.isSessionSchema(this.td.getSchemaName())) {
            return true;
        }
        return this.renamingWhat == 1 && this.isSessionSchema(this.getSchemaDescriptor());
    }

    private void renameTableBind(DataDictionary dataDictionary) throws StandardException {
        ConstraintDescriptorList constraintDescriptorList = dataDictionary.getConstraintDescriptors(this.td);
        int n = constraintDescriptorList == null ? 0 : constraintDescriptorList.size();
        for (int i = 0; i < n; ++i) {
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(i);
            if (constraintDescriptor.getConstraintType() != 4) continue;
            throw StandardException.newException("X0Y25.S", "RENAME", (Object)this.td.getName(), (Object)"CONSTRAINT", (Object)constraintDescriptor.getConstraintName());
        }
    }

    private void renameColumnBind(DataDictionary dataDictionary) throws StandardException {
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.oldObjectName);
        if (columnDescriptor == null) {
            throw StandardException.newException("42X14", this.oldObjectName, (Object)this.getFullName());
        }
        ColumnDescriptor columnDescriptor2 = this.td.getColumnDescriptor(this.newObjectName);
        if (columnDescriptor2 != null) {
            throw this.descriptorExistsException(columnDescriptor2, this.td);
        }
        ConstraintDescriptorList constraintDescriptorList = dataDictionary.getConstraintDescriptors(this.td);
        int n = constraintDescriptorList == null ? 0 : constraintDescriptorList.size();
        for (int i = 0; i < n; ++i) {
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(i);
            if (constraintDescriptor.getConstraintType() != 4) continue;
            ColumnDescriptorList columnDescriptorList = constraintDescriptor.getColumnDescriptors();
            int n2 = columnDescriptorList.size();
            for (int j = 0; j < n2; ++j) {
                if (columnDescriptorList.elementAt(j) != columnDescriptor) continue;
                throw StandardException.newException("42Z97", this.oldObjectName, (Object)constraintDescriptor.getConstraintName());
            }
        }
    }

    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getRenameConstantAction(this.getFullName(), this.getRelativeName(), this.oldObjectName, this.newObjectName, this.getSchemaDescriptor(), this.td.getUUID(), this.usedAlterTable, this.renamingWhat);
    }

    private StandardException descriptorExistsException(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2) {
        return StandardException.newException("X0Y32.S", tupleDescriptor.getDescriptorType(), (Object)tupleDescriptor.getDescriptorName(), (Object)tupleDescriptor2.getDescriptorType(), (Object)tupleDescriptor2.getDescriptorName());
    }
}

