/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.locks;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.locks.Latch;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.CheapDateFormatter;
import org.apache.derby.impl.services.locks.TableNameInfo;

public final class Timeout {
    public static final int TABLE_AND_ROWLOCK = 2;
    public static final int ALL = -1;
    public static final String newline = "\n";
    private TransactionController tc;
    private TableNameInfo tabInfo;
    private Latch currentLock;
    private char[] outputRow;
    private StringBuffer sb;
    private Hashtable currentRow;
    private final long currentTime;
    private final Enumeration lockTable;
    private static final String[] column = new String[9];
    private static final int LENGTHOFTABLE;
    private static final char LINE = '-';
    private static final char SEPARATOR = '|';

    private Timeout(Latch latch, Enumeration enumeration, long l) {
        this.currentLock = latch;
        this.lockTable = enumeration;
        this.currentTime = l;
    }

    private StandardException createException() {
        try {
            this.buildLockTableString();
        }
        catch (StandardException standardException) {
            return standardException;
        }
        StandardException standardException = StandardException.newException("40XL2", this.sb.toString());
        standardException.setReport(2);
        return standardException;
    }

    private String buildLockTableString() throws StandardException {
        int n;
        this.sb = new StringBuffer(8192);
        this.outputRow = new char[LENGTHOFTABLE];
        LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)ContextService.getContext("LanguageConnectionContext");
        if (languageConnectionContext != null) {
            this.tc = languageConnectionContext.getTransactionExecute();
        }
        try {
            this.tabInfo = new TableNameInfo(languageConnectionContext, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sb.append(newline);
        this.sb.append(CheapDateFormatter.formatDate(this.currentTime));
        this.sb.append(newline);
        for (n = 0; n < column.length; ++n) {
            this.sb.append(column[n]);
            this.sb.append('|');
        }
        this.sb.append(newline);
        for (n = 0; n < LENGTHOFTABLE; ++n) {
            this.sb.append('-');
        }
        this.sb.append(newline);
        if (this.currentLock != null) {
            this.dumpLock();
            if (this.timeoutInfoHash()) {
                this.sb.append("*** The following row is the victim ***");
                this.sb.append(newline);
                this.sb.append(this.outputRow);
                this.sb.append(newline);
                this.sb.append("*** The above row is the victim ***");
                this.sb.append(newline);
            } else {
                this.sb.append("*** A victim was chosen, but it cannot be printed because the lockable object, " + this.currentLock + ", does not want to participate ***");
                this.sb.append(newline);
            }
        }
        if (this.lockTable != null) {
            while (this.lockTable.hasMoreElements()) {
                this.currentLock = (Latch)this.lockTable.nextElement();
                this.dumpLock();
                if (this.timeoutInfoHash()) {
                    this.sb.append(this.outputRow);
                    this.sb.append(newline);
                    continue;
                }
                this.sb.append("*** A latch/lock, " + this.currentLock + ", exist in the lockTable that cannot be printed ***");
                this.sb.append(newline);
            }
            for (n = 0; n < LENGTHOFTABLE; ++n) {
                this.sb.append('-');
            }
            this.sb.append(newline);
        }
        return this.sb.toString();
    }

    static StandardException buildException(Latch latch, Enumeration enumeration, long l) {
        Timeout timeout = new Timeout(latch, enumeration, l);
        return timeout.createException();
    }

    public static String buildString(Enumeration enumeration, long l) throws StandardException {
        Timeout timeout = new Timeout(null, enumeration, l);
        return timeout.buildLockTableString();
    }

    private void dumpLock() throws StandardException {
        Long l;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>(17);
        Object object = this.currentLock.getQualifier();
        Lockable lockable = this.currentLock.getLockable();
        if (!lockable.lockAttributes(-1, hashtable)) {
            this.currentRow = null;
            return;
        }
        Long l2 = (Long)hashtable.get("CONGLOMID");
        if (l2 == null && hashtable.get("CONTAINERID") != null && this.tc != null) {
            l = (Long)hashtable.get("CONTAINERID");
            l2 = new Long(this.tc.findConglomid(l));
            hashtable.put("CONGLOMID", l2);
        }
        if ((l = (Long)hashtable.get("CONTAINERID")) == null && l2 != null && this.tc != null) {
            try {
                l = new Long(this.tc.findContainerid(l2));
                hashtable.put("CONTAINERID", l);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        hashtable.put("LOCKOBJ", this.currentLock);
        hashtable.put("XID", this.currentLock.getCompatabilitySpace().toString());
        hashtable.put("MODE", object.toString());
        hashtable.put("LOCKCOUNT", Integer.toString(this.currentLock.getCount()));
        hashtable.put("STATE", this.currentLock.getCount() != 0 ? "GRANT" : "WAIT");
        if (this.tabInfo != null && l2 != null) {
            String string;
            try {
                string = this.tabInfo.getTableName(l2);
                hashtable.put("TABLENAME", string);
            }
            catch (NullPointerException nullPointerException) {
                hashtable.put("TABLENAME", l2);
            }
            try {
                string = this.tabInfo.getIndexName(l2);
                if (string != null) {
                    hashtable.put("INDEXNAME", string);
                } else if (hashtable.get("TYPE").equals("LATCH")) {
                    hashtable.put("INDEXNAME", hashtable.get("MODE"));
                } else {
                    hashtable.put("INDEXNAME", "NULL");
                }
            }
            catch (Exception exception) {
                if ("CONTAINERID" != null) {
                    hashtable.put("INDEXNAME", "CONTAINERID");
                }
                hashtable.put("INDEXNAME", "NULL");
            }
            string = this.tabInfo.getTableType(l2);
            hashtable.put("TABLETYPE", string);
        } else {
            if (l2 != null) {
                hashtable.put("TABLENAME", "CONGLOMID");
            } else {
                hashtable.put("TABLENAME", "NULL");
            }
            if ("CONTAINERID" != null) {
                hashtable.put("INDEXNAME", "CONTAINERID");
            } else {
                hashtable.put("INDEXNAME", "NULL");
            }
            hashtable.put("TABLETYPE", this.currentLock.toString());
        }
        this.currentRow = hashtable;
    }

    private void cpArray(String string, int n, int n2) {
        int n3;
        int n4 = n2 - n;
        if (string != null) {
            for (n3 = 0; n3 < string.length() && n4 - n3 != 0; ++n3) {
                this.outputRow[n3 + n] = string.charAt(n3);
            }
        }
        while (n3 + n != n2) {
            this.outputRow[n3 + n] = 32;
            ++n3;
        }
        this.outputRow[n2] = 124;
    }

    private boolean timeoutInfoHash() {
        if (this.currentRow == null) {
            return false;
        }
        String[] stringArray = new String[]{"XID", "TYPE", "MODE", "LOCKCOUNT", "LOCKNAME", "STATE", "TABLETYPE", "INDEXNAME", "TABLENAME"};
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            this.cpArray(this.currentRow.get(stringArray[i]).toString(), n, n + column[i].length());
            n = n + column[i].length() + 1;
        }
        return true;
    }

    static {
        Timeout.column[0] = "XID       ";
        Timeout.column[1] = "TYPE         ";
        Timeout.column[2] = "MODE";
        Timeout.column[3] = "LOCKCOUNT";
        Timeout.column[4] = "LOCKNAME                                                                        ";
        Timeout.column[5] = "STATE";
        Timeout.column[6] = "TABLETYPE / LOCKOBJ                   ";
        Timeout.column[7] = "INDEXNAME / CONTAINER_ID / (MODE for LATCH only)  ";
        Timeout.column[8] = "TABLENAME / CONGLOM_ID                ";
        int n = 0;
        for (int i = 0; i < column.length; ++i) {
            n += column[i].length();
        }
        LENGTHOFTABLE = n += column.length;
    }
}

