package MyTypes::Address;
use strict;
use warnings;
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %Street_of :ATTR(:get<Street>);
my %ZIP_of :ATTR(:get<ZIP>);
my %City_of :ATTR(:get<City>);
my %Country_of :ATTR(:get<Country>);
my %PhoneNumber_of :ATTR(:get<PhoneNumber>);
my %MobilePhoneNumber_of :ATTR(:get<MobilePhoneNumber>);

__PACKAGE__->_factory(
    [ qw(
        Street
        ZIP
        City
        Country
        PhoneNumber
        MobilePhoneNumber
    ) ],
    {
        Street => \%Street_of,
        ZIP => \%ZIP_of,
        City => \%City_of,
        Country => \%Country_of,
        PhoneNumber => \%PhoneNumber_of,
        MobilePhoneNumber => \%MobilePhoneNumber_of,
    },
    {
        Street => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        ZIP => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        City => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        Country => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        PhoneNumber => 'MyTypes::PhoneNumber',
        MobilePhoneNumber => 'MyTypes::PhoneNumber',
    }
);

} # end BLOCK






1;

=pod

=head1 NAME

MyTypes::Address

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complextype
Address from the namespace http://www.example.org/benchmark/.

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

 Street
 ZIP
 City
 Country
 PhoneNumber
 MobilePhoneNumber


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # MyTypes::Address
   Street =>  $some_value, # string
   ZIP =>  $some_value, # string
   City =>  $some_value, # string
   Country =>  $some_value, # string
   PhoneNumber => $some_value, # PhoneNumber
   MobilePhoneNumber => $some_value, # PhoneNumber
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

