#!perl

use strict;
use utf8;

use Test::More  tests => 12;
use Geo::Names::Russian ':all';

use Encode::Locale;
use Encode;

my @tests = (
    [ 'ул. Иванова'             => 'ИВАНОВА  УЛИЦА' ],
    [ 'Новая Кузнецовская пл'   => 'Кузнецовская Нов ПЛОЩАДЬ' ],
    [ '2-й б-р Сидорова'        => 'СИДОРОВА  БУЛЬВАР 2' ],
    [ 'Лесная Нижн.'            => 'Лесная Ниж УЛИЦА' ],
    [ '7 Петровский'            => 'Петровский  ПЕРЕУЛОК 7' ],
    [ '8 Марта 5-й километр'    => '8 Марта  УЛИЦА  5км' ],
    [ '4-ая улица 8 Марта'      => '8 Марта  УЛИЦА 4' ],
    [ '9-й стрелковой дивизии'  => '9 стрелковой дивизии  УЛИЦА' ],
    [ 'Проезд № 777'            => '777  проезд' ],
    [ 'Адмирала Ш. М.Макарова'  => 'Макарова_Ш.М. адмирала улица' ],
    [ 'В.Красносельская 5 км'   => 'Красносельская Верх улица  5км' ],
    [ '1-я линия 2-й Конной Лахты' => '2 Конной Лахты  линия 1' ],
);


for my $test ( @tests ) {
    my $res = streetname_keystring( $test->[0] );
    is( $res, uc($test->[1]), encode( 'console_out', "hash $test->[0]" ) );
}

