/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class CtbDict {
    private static final String defaultFilename = "ctb_dict.txt";
    private static CtbDict ctbDictSingleton;
    public HashMap<String, Set<String>> ctb_pre_dict;
    public HashMap<String, Set<String>> ctb_suf_dict;

    private static synchronized CtbDict getInstance() {
        if (ctbDictSingleton == null) {
            ctbDictSingleton = new CtbDict();
        }
        return ctbDictSingleton;
    }

    private CtbDict() {
        try {
            this.readCtbDict("/u/nlp/data/pos-tagger/dictionary/ctb_dict.txt");
        }
        catch (IOException e) {
            throw new RuntimeException("can't open file: " + e.getMessage());
        }
    }

    private void readCtbDict(String filename) throws IOException {
        String ctbDetectorLine;
        BufferedReader ctbDetectorReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "GB18030"));
        this.ctb_pre_dict = new HashMap();
        this.ctb_suf_dict = new HashMap();
        while ((ctbDetectorLine = ctbDetectorReader.readLine()) != null) {
            String[] fields = ctbDetectorLine.split("\t");
            String tag = fields[0];
            Set<String> pres = this.ctb_pre_dict.get(tag);
            Set<String> sufs = this.ctb_suf_dict.get(tag);
            if (pres == null) {
                pres = new HashSet<String>();
                this.ctb_pre_dict.put(tag, pres);
            }
            pres.add(fields[1]);
            if (sufs == null) {
                sufs = new HashSet<String>();
                this.ctb_suf_dict.put(tag, sufs);
            }
            sufs.add(fields[2]);
        }
    }

    protected static String getTagPre(String a1, String a2) {
        CtbDict dict = CtbDict.getInstance();
        if (dict.getpre(a1) == null) {
            return "0";
        }
        if (dict.getpre(a1).contains(a2)) {
            return "1";
        }
        return "0";
    }

    protected static String getTagSuf(String a1, String a2) {
        CtbDict dict = CtbDict.getInstance();
        if (dict.getsuf(a1) == null) {
            return "0";
        }
        if (dict.getsuf(a1).contains(a2)) {
            return "1";
        }
        return "0";
    }

    private Set<String> getpre(String a) {
        return this.ctb_pre_dict.get(a);
    }

    private Set<String> getsuf(String a) {
        return this.ctb_suf_dict.get(a);
    }
}

