/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.http;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.couchbase.mock.Bucket;
import org.couchbase.mock.harakiri.HarakiriMonitor;
import org.couchbase.mock.http.StateGrabber;

class BucketsStreamingHandler
implements Observer {
    private final OutputStream output;
    private final Bucket bucket;
    private final HarakiriMonitor monitor;
    private final Lock updateHandlerLock = new ReentrantLock();
    private final Condition condHasUpdatedConfig = this.updateHandlerLock.newCondition();
    private volatile boolean hasUpdatedConfig = false;
    private volatile boolean shouldTerminate = false;
    private static final byte[] chunkedDelimiter = "\n\n\n\n".getBytes();

    public BucketsStreamingHandler(HarakiriMonitor monitor, Bucket bucket, OutputStream output) {
        this.output = output;
        this.bucket = bucket;
        this.monitor = monitor;
    }

    private byte[] getConfigBytes() {
        return StateGrabber.getBucketJSON(this.bucket).getBytes();
    }

    private void writeConfigBytes(byte[] payload) throws IOException {
        this.output.write(payload);
        this.output.flush();
        this.output.write(chunkedDelimiter);
        this.output.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable o, Object arg) {
        this.updateHandlerLock.lock();
        try {
            this.hasUpdatedConfig = true;
            this.condHasUpdatedConfig.signalAll();
        }
        finally {
            this.updateHandlerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean streamNewConfig() throws InterruptedException {
        this.updateHandlerLock.lock();
        boolean isLocked = true;
        try {
            while (!this.shouldTerminate && !this.hasUpdatedConfig) {
                this.condHasUpdatedConfig.await();
            }
            isLocked = false;
            this.updateHandlerLock.unlock();
            if (this.hasUpdatedConfig) {
                this.writeConfigBytes(this.getConfigBytes());
                this.hasUpdatedConfig = false;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            this.shouldTerminate = false;
            boolean bl = false;
            return bl;
        }
        finally {
            if (isLocked) {
                this.updateHandlerLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startStreaming() throws IOException, InterruptedException {
        this.bucket.configReadLock();
        byte[] configBytes = this.getConfigBytes();
        this.updateHandlerLock.lock();
        if (this.monitor != null) {
            this.monitor.addObserver(this);
        }
        this.bucket.configReadUnlock();
        try {
            this.writeConfigBytes(configBytes);
        }
        finally {
            this.updateHandlerLock.unlock();
        }
        while (this.streamNewConfig()) {
        }
        this.output.close();
    }
}

