#------------------------------------------------------------------------------
# $Id$
# Parser 'CPU::Z80::Assembler::Parser' generated by ParserGenerator.pm

package CPU::Z80::Assembler::Parser;

use strict;
use warnings;

use Data::Dump 'dump';
use Iterator::Simple::Lookahead;
use Asm::Preproc::Token;
use Carp;

use constant {
	ARGS => 0, PROG => 1, INPUT => 2,		# to decode args in parser functions
};


our $VERSION = '2.18';

use CPU::Z80::Assembler;
use CPU::Z80::Assembler::Expr;
use CPU::Z80::Assembler::Macro;
use CPU::Z80::Assembler::Opcode;
use CPU::Z80::Assembler::JumpOpcode;
use Asm::Preproc::Token;

use base "Exporter";
our @EXPORT = qw( z80parser );

#------------------------------------------------------------------------------

=head1 NAME

CPU::Z80::Assembler::Parser - Parser for the Z80 assembler

=head1 SYNOPSIS

  use CPU::Z80::Assembler::Parser;
  z80parser($input, $program);

=head1 DESCRIPTION

This module converts an input stream of tokens returned by the
L<CPU::Z80::Assembler|CPU::Z80::Assembler> C<z80lexer> to a binary object code
that is returned in the
passed L<CPU::Z80::Assembler::Program|CPU::Z80::Assembler::Program> object.

=head1 EXPORTS

By default the z80parser subroutines is exported.

=head1 FUNCTIONS

=head2 z80parser

This function is just a wrapper around the parse function.
It takes as parameter a stream of assembly tokens as returned by the 
lexer and a L<CPU::Z80::Assembler::Program|CPU::Z80::Assembler::Program> object to collect the 
object code.

The assembly program is parsed and loaded into L<CPU::Z80::Assembler::Program|CPU::Z80::Assembler::Program>.

=cut

#------------------------------------------------------------------------------



#------------------------------------------------------------------------------
# Parsing state machine
# Each state hash has:
# 	terminal => (state ID), for a shift
# 	terminal => [ (subrule ID), (next state ID) ], for a sub-rule followed by a shift
# 	terminal => [ (subrule ID), sub{} ], for a sub-rule followed by an accept
# 	terminal => sub{}, for an accept
# Each sub{} is called with $sub->($args, $user); 
# $args is [] of all parsed elements
# $user is the user pointer passed to parse()
our $start_state = 3903;
our @state_table = (
	# [0] 
	{ binop => 1, cont_expr_N => 2, def_label => 4, end => 9, expr => 10, expr2 => 12, expr_DIS => 14, expr_N => 15, expr_NDIS => 16, expr_NN => 17, expr_const => 18, expr_list => 19, expr_list_N => 21, expr_list_NN => 22, expr_list_text => 23, expr_list_text7 => 25, expr_list_textz => 27, expr_text => 29, expr_text2 => 32, expr_text7 => 34, expr_text7_2 => 35, expr_text_number => 37, expr_text_string => 38, expr_textz => 39, expr_textz_2 => 40, inline_const => 42, macro => 43, macro_arg => 47, macro_arg2 => 48, macro_args => 50, macro_args_optional => 52, macro_body => 53, opcode => 54, program => 3903, term => 3905, term2 => 3909, unop => 3911, },
	# [1] binop : 
	{ "!=" => \&_action_unop_1, "%" => \&_action_unop_1, "&" => \&_action_unop_1, "&&" => \&_action_unop_1, "*" => \&_action_unop_1, "+" => \&_action_unop_1, "-" => \&_action_unop_1, "/" => \&_action_unop_1, "<" => \&_action_unop_1, "<<" => \&_action_unop_1, "<=" => \&_action_unop_1, "==" => \&_action_unop_1, ">" => \&_action_unop_1, ">=" => \&_action_unop_1, ">>" => \&_action_unop_1, "^" => \&_action_unop_1, "|" => \&_action_unop_1, "||" => \&_action_unop_1, },
	# [2] cont_expr_N : 
	{ "!=" => [ 1, 3 ], "%" => [ 1, 3 ], "&" => [ 1, 3 ], "&&" => [ 1, 3 ], "*" => [ 1, 3 ], "+" => [ 1, 3 ], "-" => [ 1, 3 ], "/" => [ 1, 3 ], "<" => [ 1, 3 ], "<<" => [ 1, 3 ], "<=" => [ 1, 3 ], "==" => [ 1, 3 ], ">" => [ 1, 3 ], ">=" => [ 1, 3 ], ">>" => [ 1, 3 ], "^" => [ 1, 3 ], "|" => [ 1, 3 ], "||" => [ 1, 3 ], },
	# [3] cont_expr_N : "[binop]"
	{ "!" => [ 15, \&_action_term_2 ], "+" => [ 15, \&_action_term_2 ], "-" => [ 15, \&_action_term_2 ], __else__ => [ 15, \&_action_term_2 ], "~" => [ 15, \&_action_term_2 ], },
	# [4] def_label : 
	{ "=" => 5, equ => 7, },
	# [5] def_label : "="
	{ "!" => [ 17, 6 ], "+" => [ 17, 6 ], "-" => [ 17, 6 ], __else__ => [ 17, 6 ], "~" => [ 17, 6 ], },
	# [6] def_label : "=" "[expr_NN]"
	{ "\n" => [ 9, \&_action_expr2_6 ], ":" => [ 9, \&_action_expr2_6 ], },
	# [7] def_label : equ
	{ "!" => [ 17, 8 ], "+" => [ 17, 8 ], "-" => [ 17, 8 ], __else__ => [ 17, 8 ], "~" => [ 17, 8 ], },
	# [8] def_label : equ "[expr_NN]"
	{ "\n" => [ 9, \&_action_expr2_6 ], ":" => [ 9, \&_action_expr2_6 ], },
	# [9] end : 
	{ "\n" => \&_action_end_0, ":" => \&_action_end_0, },
	# [10] expr : 
	{ "!" => [ 3905, 11 ], "+" => [ 3905, 11 ], "-" => [ 3905, 11 ], __else__ => [ 3905, 11 ], "~" => [ 3905, 11 ], },
	# [11] expr : "[term]"
	{ "!=" => [ 3909, 11 ], "%" => [ 3909, 11 ], "&" => [ 3909, 11 ], "&&" => [ 3909, 11 ], "*" => [ 3909, 11 ], "+" => [ 3909, 11 ], "-" => [ 3909, 11 ], "/" => [ 3909, 11 ], "<" => [ 3909, 11 ], "<<" => [ 3909, 11 ], "<=" => [ 3909, 11 ], "==" => [ 3909, 11 ], ">" => [ 3909, 11 ], ">=" => [ 3909, 11 ], ">>" => [ 3909, 11 ], "^" => [ 3909, 11 ], __else__ => \&_action_expr_5, "|" => [ 3909, 11 ], "||" => [ 3909, 11 ], },
	# [12] expr2 : 
	{ "," => 13, },
	# [13] expr2 : ","
	{ "!" => [ 10, \&_action_expr2_6 ], "+" => [ 10, \&_action_expr2_6 ], "-" => [ 10, \&_action_expr2_6 ], __else__ => [ 10, \&_action_expr2_6 ], "~" => [ 10, \&_action_expr2_6 ], },
	# [14] expr_DIS : 
	{ "!" => [ 10, \&_action_expr_DIS_7 ], "+" => [ 10, \&_action_expr_DIS_7 ], "-" => [ 10, \&_action_expr_DIS_7 ], __else__ => [ 10, \&_action_expr_DIS_7 ], "~" => [ 10, \&_action_expr_DIS_7 ], },
	# [15] expr_N : 
	{ "!" => [ 10, \&_action_expr_N_9 ], "+" => [ 10, \&_action_expr_N_9 ], "-" => [ 10, \&_action_expr_N_9 ], __else__ => [ 10, \&_action_expr_N_9 ], "~" => [ 10, \&_action_expr_N_9 ], },
	# [16] expr_NDIS : 
	{ "!" => [ 14, \&_action_expr_NDIS_8 ], "+" => [ 14, \&_action_expr_NDIS_8 ], "-" => [ 14, \&_action_expr_NDIS_8 ], __else__ => [ 14, \&_action_expr_NDIS_8 ], "~" => [ 14, \&_action_expr_NDIS_8 ], },
	# [17] expr_NN : 
	{ "!" => [ 10, \&_action_expr_NN_11 ], "+" => [ 10, \&_action_expr_NN_11 ], "-" => [ 10, \&_action_expr_NN_11 ], __else__ => [ 10, \&_action_expr_NN_11 ], "~" => [ 10, \&_action_expr_NN_11 ], },
	# [18] expr_const : 
	{ "!" => [ 10, \&_action_expr_const_13 ], "+" => [ 10, \&_action_expr_const_13 ], "-" => [ 10, \&_action_expr_const_13 ], __else__ => [ 10, \&_action_expr_const_13 ], "~" => [ 10, \&_action_expr_const_13 ], },
	# [19] expr_list : 
	{ "!" => [ 10, 20 ], "+" => [ 10, 20 ], "-" => [ 10, 20 ], __else__ => [ 10, 20 ], "~" => [ 10, 20 ], },
	# [20] expr_list : "[expr]"
	{ "," => [ 12, 20 ], __else__ => \&_action_term_2, },
	# [21] expr_list_N : 
	{ "!" => [ 19, \&_action_expr_list_N_10 ], "+" => [ 19, \&_action_expr_list_N_10 ], "-" => [ 19, \&_action_expr_list_N_10 ], __else__ => [ 19, \&_action_expr_list_N_10 ], "~" => [ 19, \&_action_expr_list_N_10 ], },
	# [22] expr_list_NN : 
	{ "!" => [ 19, \&_action_expr_list_NN_12 ], "+" => [ 19, \&_action_expr_list_NN_12 ], "-" => [ 19, \&_action_expr_list_NN_12 ], __else__ => [ 19, \&_action_expr_list_NN_12 ], "~" => [ 19, \&_action_expr_list_NN_12 ], },
	# [23] expr_list_text : 
	{ NUMBER => [ 29, 24 ], STRING => [ 29, 24 ], },
	# [24] expr_list_text : "[expr_text]"
	{ "," => [ 32, 24 ], __else__ => \&_action_expr_list_text_20, },
	# [25] expr_list_text7 : 
	{ NUMBER => [ 34, 26 ], STRING => [ 34, 26 ], },
	# [26] expr_list_text7 : "[expr_text7]"
	{ "," => [ 35, 26 ], __else__ => \&_action_expr_list_text_20, },
	# [27] expr_list_textz : 
	{ NUMBER => [ 39, 28 ], STRING => [ 39, 28 ], },
	# [28] expr_list_textz : "[expr_textz]"
	{ "," => [ 40, 28 ], __else__ => \&_action_expr_list_text_20, },
	# [29] expr_text : 
	{ NUMBER => [ 37, 30 ], STRING => [ 38, 31 ], },
	# [30] expr_text : "[expr_text_number]"
	{ "!=" => [ 2, \&_action_expr_text_17 ], "%" => [ 2, \&_action_expr_text_17 ], "&" => [ 2, \&_action_expr_text_17 ], "&&" => [ 2, \&_action_expr_text_17 ], "*" => [ 2, \&_action_expr_text_17 ], "+" => [ 2, \&_action_expr_text_17 ], "-" => [ 2, \&_action_expr_text_17 ], "/" => [ 2, \&_action_expr_text_17 ], "<" => [ 2, \&_action_expr_text_17 ], "<<" => [ 2, \&_action_expr_text_17 ], "<=" => [ 2, \&_action_expr_text_17 ], "==" => [ 2, \&_action_expr_text_17 ], ">" => [ 2, \&_action_expr_text_17 ], ">=" => [ 2, \&_action_expr_text_17 ], ">>" => [ 2, \&_action_expr_text_17 ], "^" => [ 2, \&_action_expr_text_17 ], __else__ => \&_action_expr_text_17, "|" => [ 2, \&_action_expr_text_17 ], "||" => [ 2, \&_action_expr_text_17 ], },
	# [31] expr_text : "[expr_text_string]"
	{ "!=" => [ 2, \&_action_expr_text_17 ], "%" => [ 2, \&_action_expr_text_17 ], "&" => [ 2, \&_action_expr_text_17 ], "&&" => [ 2, \&_action_expr_text_17 ], "*" => [ 2, \&_action_expr_text_17 ], "+" => [ 2, \&_action_expr_text_17 ], "-" => [ 2, \&_action_expr_text_17 ], "/" => [ 2, \&_action_expr_text_17 ], "<" => [ 2, \&_action_expr_text_17 ], "<<" => [ 2, \&_action_expr_text_17 ], "<=" => [ 2, \&_action_expr_text_17 ], "==" => [ 2, \&_action_expr_text_17 ], ">" => [ 2, \&_action_expr_text_17 ], ">=" => [ 2, \&_action_expr_text_17 ], ">>" => [ 2, \&_action_expr_text_17 ], "^" => [ 2, \&_action_expr_text_17 ], __else__ => \&_action_expr_text_17, "|" => [ 2, \&_action_expr_text_17 ], "||" => [ 2, \&_action_expr_text_17 ], },
	# [32] expr_text2 : 
	{ "," => 33, },
	# [33] expr_text2 : ","
	{ NUMBER => [ 29, \&_action_expr2_6 ], STRING => [ 29, \&_action_expr2_6 ], },
	# [34] expr_text7 : 
	{ NUMBER => [ 29, \&_action_expr_text7_19 ], STRING => [ 29, \&_action_expr_text7_19 ], },
	# [35] expr_text7_2 : 
	{ "," => 36, },
	# [36] expr_text7_2 : ","
	{ NUMBER => [ 34, \&_action_expr2_6 ], STRING => [ 34, \&_action_expr2_6 ], },
	# [37] expr_text_number : 
	{ NUMBER => \&_action_expr_text_number_16, },
	# [38] expr_text_string : 
	{ STRING => \&_action_expr_text_string_15, },
	# [39] expr_textz : 
	{ NUMBER => [ 29, \&_action_expr_textz_18 ], STRING => [ 29, \&_action_expr_textz_18 ], },
	# [40] expr_textz_2 : 
	{ "," => 41, },
	# [41] expr_textz_2 : ","
	{ NUMBER => [ 39, \&_action_expr2_6 ], STRING => [ 39, \&_action_expr2_6 ], },
	# [42] inline_const : 
	{ "!" => [ 10, \&_action_inline_const_14 ], "+" => [ 10, \&_action_inline_const_14 ], "-" => [ 10, \&_action_inline_const_14 ], __else__ => [ 10, \&_action_inline_const_14 ], "~" => [ 10, \&_action_inline_const_14 ], },
	# [43] macro : 
	{ macro => 44, },
	# [44] macro : macro
	{ NAME => 45, },
	# [45] macro : macro NAME
	{ NAME => [ 52, 46 ], __else__ => [ 52, 46 ], },
	# [46] macro : macro NAME "[macro_args_optional]"
	{ "\n" => [ 53, \&_action_macro_28 ], ":" => [ 53, \&_action_macro_28 ], "{" => [ 53, \&_action_macro_28 ], },
	# [47] macro_arg : 
	{ NAME => \&_action_macro_arg_24, },
	# [48] macro_arg2 : 
	{ "," => 49, },
	# [49] macro_arg2 : ","
	{ NAME => \&_action_macro_arg2_25, },
	# [50] macro_args : 
	{ NAME => [ 47, 51 ], },
	# [51] macro_args : "[macro_arg]"
	{ "," => [ 48, 51 ], __else__ => \&_action_term_2, },
	# [52] macro_args_optional : 
	{ NAME => [ 50, \&_action_macro_args_optional_26 ], __else__ => \&_action_macro_args_optional_26, },
	# [53] macro_body : 
	{ "\n" => \&_action_macro_body_27, ":" => \&_action_macro_body_27, "{" => \&_action_macro_body_27, },
	# [54] opcode : 
	{ "\n" => [ 9, \&_action_end_0 ], ":" => [ 9, \&_action_end_0 ], NAME => 55, adc => 57, add => 97, and => 149, bit => 181, call => 407, ccf => 433, cp => 434, cpd => 466, cpdr => 467, cpi => 468, cpir => 469, cpl => 470, daa => 471, dec => 472, defb => 509, defm => 511, defm7 => 513, defmz => 515, deft => 517, defw => 519, di => 521, djnz => 522, ei => 524, ex => 525, exx => 539, halt => 540, im => 541, in => 546, inc => 589, ind => 626, indr => 627, ini => 628, inir => 629, jp => 630, jr => 663, ld => 689, ldd => 1203, lddr => 1445, ldi => 1446, ldir => 1769, macro => [ 43, 56 ], neg => 1770, nop => 1771, or => 1772, org => 1804, otdr => 1805, otir => 1806, out => 1807, outd => 1825, outi => 1826, pop => 1827, push => 1834, res => 1841, ret => 2451, reti => 2460, retn => 2461, rl => 2462, rla => 2540, rlc => 2541, rlca => 2616, rld => 2617, rr => 2618, rra => 2696, rrc => 2697, rrca => 2772, rrd => 2773, rst => 2774, sbc => 2791, scf => 2831, set => 2832, sla => 3442, sli => 3520, sll => 3598, sra => 3676, srl => 3754, stop => 3832, sub => 3833, xor => 3871, },
	# [55] opcode : NAME
	{ "=" => [ 4, \&_action_opcode_23 ], __else__ => \&_action_opcode_23, equ => [ 4, \&_action_opcode_23 ], },
	# [56] opcode : "[macro]"
	{ "\n" => [ 9, \&_action_end_0 ], ":" => [ 9, \&_action_end_0 ], },
	# [57] opcode : adc
	{ a => 58, hl => 91, },
	# [58] opcode : adc a
	{ "," => 59, },
	# [59] opcode : adc a ","
	{ "!" => [ 15, 79 ], "(" => 60, "+" => [ 15, 79 ], "-" => [ 15, 79 ], __else__ => [ 15, 79 ], a => 80, b => 81, c => 82, d => 83, e => 84, h => 85, ixh => 86, ixl => 87, iyh => 88, iyl => 89, l => 90, "~" => [ 15, 79 ], },
	# [60] opcode : adc a "," "("
	{ hl => 61, ix => 63, iy => 71, },
	# [61] opcode : adc a "," "(" hl
	{ ")" => 62, },
	# [62] opcode : adc a "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_29 ], ":" => [ 9, \&_action_opcode_29 ], },
	# [63] opcode : adc a "," "(" ix
	{ ")" => 64, "+" => 65, "-" => 68, },
	# [64] opcode : adc a "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_30 ], ":" => [ 9, \&_action_opcode_30 ], },
	# [65] opcode : adc a "," "(" ix "+"
	{ "!" => [ 14, 66 ], "+" => [ 14, 66 ], "-" => [ 14, 66 ], __else__ => [ 14, 66 ], "~" => [ 14, 66 ], },
	# [66] opcode : adc a "," "(" ix "+" "[expr_DIS]"
	{ ")" => 67, },
	# [67] opcode : adc a "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_31 ], ":" => [ 9, \&_action_opcode_31 ], },
	# [68] opcode : adc a "," "(" ix "-"
	{ "!" => [ 16, 69 ], "+" => [ 16, 69 ], "-" => [ 16, 69 ], __else__ => [ 16, 69 ], "~" => [ 16, 69 ], },
	# [69] opcode : adc a "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 70, },
	# [70] opcode : adc a "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_31 ], ":" => [ 9, \&_action_opcode_31 ], },
	# [71] opcode : adc a "," "(" iy
	{ ")" => 72, "+" => 73, "-" => 76, },
	# [72] opcode : adc a "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_32 ], ":" => [ 9, \&_action_opcode_32 ], },
	# [73] opcode : adc a "," "(" iy "+"
	{ "!" => [ 14, 74 ], "+" => [ 14, 74 ], "-" => [ 14, 74 ], __else__ => [ 14, 74 ], "~" => [ 14, 74 ], },
	# [74] opcode : adc a "," "(" iy "+" "[expr_DIS]"
	{ ")" => 75, },
	# [75] opcode : adc a "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_33 ], ":" => [ 9, \&_action_opcode_33 ], },
	# [76] opcode : adc a "," "(" iy "-"
	{ "!" => [ 16, 77 ], "+" => [ 16, 77 ], "-" => [ 16, 77 ], __else__ => [ 16, 77 ], "~" => [ 16, 77 ], },
	# [77] opcode : adc a "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 78, },
	# [78] opcode : adc a "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_33 ], ":" => [ 9, \&_action_opcode_33 ], },
	# [79] opcode : adc a "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_34 ], ":" => [ 9, \&_action_opcode_34 ], },
	# [80] opcode : adc a "," a
	{ "\n" => [ 9, \&_action_opcode_35 ], ":" => [ 9, \&_action_opcode_35 ], },
	# [81] opcode : adc a "," b
	{ "\n" => [ 9, \&_action_opcode_36 ], ":" => [ 9, \&_action_opcode_36 ], },
	# [82] opcode : adc a "," c
	{ "\n" => [ 9, \&_action_opcode_37 ], ":" => [ 9, \&_action_opcode_37 ], },
	# [83] opcode : adc a "," d
	{ "\n" => [ 9, \&_action_opcode_38 ], ":" => [ 9, \&_action_opcode_38 ], },
	# [84] opcode : adc a "," e
	{ "\n" => [ 9, \&_action_opcode_39 ], ":" => [ 9, \&_action_opcode_39 ], },
	# [85] opcode : adc a "," h
	{ "\n" => [ 9, \&_action_opcode_40 ], ":" => [ 9, \&_action_opcode_40 ], },
	# [86] opcode : adc a "," ixh
	{ "\n" => [ 9, \&_action_opcode_41 ], ":" => [ 9, \&_action_opcode_41 ], },
	# [87] opcode : adc a "," ixl
	{ "\n" => [ 9, \&_action_opcode_42 ], ":" => [ 9, \&_action_opcode_42 ], },
	# [88] opcode : adc a "," iyh
	{ "\n" => [ 9, \&_action_opcode_43 ], ":" => [ 9, \&_action_opcode_43 ], },
	# [89] opcode : adc a "," iyl
	{ "\n" => [ 9, \&_action_opcode_44 ], ":" => [ 9, \&_action_opcode_44 ], },
	# [90] opcode : adc a "," l
	{ "\n" => [ 9, \&_action_opcode_45 ], ":" => [ 9, \&_action_opcode_45 ], },
	# [91] opcode : adc hl
	{ "," => 92, },
	# [92] opcode : adc hl ","
	{ bc => 93, de => 94, hl => 95, sp => 96, },
	# [93] opcode : adc hl "," bc
	{ "\n" => [ 9, \&_action_opcode_46 ], ":" => [ 9, \&_action_opcode_46 ], },
	# [94] opcode : adc hl "," de
	{ "\n" => [ 9, \&_action_opcode_47 ], ":" => [ 9, \&_action_opcode_47 ], },
	# [95] opcode : adc hl "," hl
	{ "\n" => [ 9, \&_action_opcode_48 ], ":" => [ 9, \&_action_opcode_48 ], },
	# [96] opcode : adc hl "," sp
	{ "\n" => [ 9, \&_action_opcode_49 ], ":" => [ 9, \&_action_opcode_49 ], },
	# [97] opcode : add
	{ a => 98, hl => 131, ix => 137, iy => 143, },
	# [98] opcode : add a
	{ "," => 99, },
	# [99] opcode : add a ","
	{ "!" => [ 15, 119 ], "(" => 100, "+" => [ 15, 119 ], "-" => [ 15, 119 ], __else__ => [ 15, 119 ], a => 120, b => 121, c => 122, d => 123, e => 124, h => 125, ixh => 126, ixl => 127, iyh => 128, iyl => 129, l => 130, "~" => [ 15, 119 ], },
	# [100] opcode : add a "," "("
	{ hl => 101, ix => 103, iy => 111, },
	# [101] opcode : add a "," "(" hl
	{ ")" => 102, },
	# [102] opcode : add a "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_50 ], ":" => [ 9, \&_action_opcode_50 ], },
	# [103] opcode : add a "," "(" ix
	{ ")" => 104, "+" => 105, "-" => 108, },
	# [104] opcode : add a "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_51 ], ":" => [ 9, \&_action_opcode_51 ], },
	# [105] opcode : add a "," "(" ix "+"
	{ "!" => [ 14, 106 ], "+" => [ 14, 106 ], "-" => [ 14, 106 ], __else__ => [ 14, 106 ], "~" => [ 14, 106 ], },
	# [106] opcode : add a "," "(" ix "+" "[expr_DIS]"
	{ ")" => 107, },
	# [107] opcode : add a "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_52 ], ":" => [ 9, \&_action_opcode_52 ], },
	# [108] opcode : add a "," "(" ix "-"
	{ "!" => [ 16, 109 ], "+" => [ 16, 109 ], "-" => [ 16, 109 ], __else__ => [ 16, 109 ], "~" => [ 16, 109 ], },
	# [109] opcode : add a "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 110, },
	# [110] opcode : add a "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_52 ], ":" => [ 9, \&_action_opcode_52 ], },
	# [111] opcode : add a "," "(" iy
	{ ")" => 112, "+" => 113, "-" => 116, },
	# [112] opcode : add a "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_53 ], ":" => [ 9, \&_action_opcode_53 ], },
	# [113] opcode : add a "," "(" iy "+"
	{ "!" => [ 14, 114 ], "+" => [ 14, 114 ], "-" => [ 14, 114 ], __else__ => [ 14, 114 ], "~" => [ 14, 114 ], },
	# [114] opcode : add a "," "(" iy "+" "[expr_DIS]"
	{ ")" => 115, },
	# [115] opcode : add a "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_54 ], ":" => [ 9, \&_action_opcode_54 ], },
	# [116] opcode : add a "," "(" iy "-"
	{ "!" => [ 16, 117 ], "+" => [ 16, 117 ], "-" => [ 16, 117 ], __else__ => [ 16, 117 ], "~" => [ 16, 117 ], },
	# [117] opcode : add a "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 118, },
	# [118] opcode : add a "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_54 ], ":" => [ 9, \&_action_opcode_54 ], },
	# [119] opcode : add a "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_55 ], ":" => [ 9, \&_action_opcode_55 ], },
	# [120] opcode : add a "," a
	{ "\n" => [ 9, \&_action_opcode_56 ], ":" => [ 9, \&_action_opcode_56 ], },
	# [121] opcode : add a "," b
	{ "\n" => [ 9, \&_action_opcode_57 ], ":" => [ 9, \&_action_opcode_57 ], },
	# [122] opcode : add a "," c
	{ "\n" => [ 9, \&_action_opcode_58 ], ":" => [ 9, \&_action_opcode_58 ], },
	# [123] opcode : add a "," d
	{ "\n" => [ 9, \&_action_opcode_59 ], ":" => [ 9, \&_action_opcode_59 ], },
	# [124] opcode : add a "," e
	{ "\n" => [ 9, \&_action_opcode_60 ], ":" => [ 9, \&_action_opcode_60 ], },
	# [125] opcode : add a "," h
	{ "\n" => [ 9, \&_action_opcode_61 ], ":" => [ 9, \&_action_opcode_61 ], },
	# [126] opcode : add a "," ixh
	{ "\n" => [ 9, \&_action_opcode_62 ], ":" => [ 9, \&_action_opcode_62 ], },
	# [127] opcode : add a "," ixl
	{ "\n" => [ 9, \&_action_opcode_63 ], ":" => [ 9, \&_action_opcode_63 ], },
	# [128] opcode : add a "," iyh
	{ "\n" => [ 9, \&_action_opcode_64 ], ":" => [ 9, \&_action_opcode_64 ], },
	# [129] opcode : add a "," iyl
	{ "\n" => [ 9, \&_action_opcode_65 ], ":" => [ 9, \&_action_opcode_65 ], },
	# [130] opcode : add a "," l
	{ "\n" => [ 9, \&_action_opcode_66 ], ":" => [ 9, \&_action_opcode_66 ], },
	# [131] opcode : add hl
	{ "," => 132, },
	# [132] opcode : add hl ","
	{ bc => 133, de => 134, hl => 135, sp => 136, },
	# [133] opcode : add hl "," bc
	{ "\n" => [ 9, \&_action_opcode_67 ], ":" => [ 9, \&_action_opcode_67 ], },
	# [134] opcode : add hl "," de
	{ "\n" => [ 9, \&_action_opcode_68 ], ":" => [ 9, \&_action_opcode_68 ], },
	# [135] opcode : add hl "," hl
	{ "\n" => [ 9, \&_action_opcode_69 ], ":" => [ 9, \&_action_opcode_69 ], },
	# [136] opcode : add hl "," sp
	{ "\n" => [ 9, \&_action_opcode_70 ], ":" => [ 9, \&_action_opcode_70 ], },
	# [137] opcode : add ix
	{ "," => 138, },
	# [138] opcode : add ix ","
	{ bc => 139, de => 140, ix => 141, sp => 142, },
	# [139] opcode : add ix "," bc
	{ "\n" => [ 9, \&_action_opcode_71 ], ":" => [ 9, \&_action_opcode_71 ], },
	# [140] opcode : add ix "," de
	{ "\n" => [ 9, \&_action_opcode_72 ], ":" => [ 9, \&_action_opcode_72 ], },
	# [141] opcode : add ix "," ix
	{ "\n" => [ 9, \&_action_opcode_73 ], ":" => [ 9, \&_action_opcode_73 ], },
	# [142] opcode : add ix "," sp
	{ "\n" => [ 9, \&_action_opcode_74 ], ":" => [ 9, \&_action_opcode_74 ], },
	# [143] opcode : add iy
	{ "," => 144, },
	# [144] opcode : add iy ","
	{ bc => 145, de => 146, iy => 147, sp => 148, },
	# [145] opcode : add iy "," bc
	{ "\n" => [ 9, \&_action_opcode_75 ], ":" => [ 9, \&_action_opcode_75 ], },
	# [146] opcode : add iy "," de
	{ "\n" => [ 9, \&_action_opcode_76 ], ":" => [ 9, \&_action_opcode_76 ], },
	# [147] opcode : add iy "," iy
	{ "\n" => [ 9, \&_action_opcode_77 ], ":" => [ 9, \&_action_opcode_77 ], },
	# [148] opcode : add iy "," sp
	{ "\n" => [ 9, \&_action_opcode_78 ], ":" => [ 9, \&_action_opcode_78 ], },
	# [149] opcode : and
	{ "!" => [ 15, 169 ], "(" => 150, "+" => [ 15, 169 ], "-" => [ 15, 169 ], __else__ => [ 15, 169 ], a => 170, b => 171, c => 172, d => 173, e => 174, h => 175, ixh => 176, ixl => 177, iyh => 178, iyl => 179, l => 180, "~" => [ 15, 169 ], },
	# [150] opcode : and "("
	{ hl => 151, ix => 153, iy => 161, },
	# [151] opcode : and "(" hl
	{ ")" => 152, },
	# [152] opcode : and "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_79 ], ":" => [ 9, \&_action_opcode_79 ], },
	# [153] opcode : and "(" ix
	{ ")" => 154, "+" => 155, "-" => 158, },
	# [154] opcode : and "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_80 ], ":" => [ 9, \&_action_opcode_80 ], },
	# [155] opcode : and "(" ix "+"
	{ "!" => [ 14, 156 ], "+" => [ 14, 156 ], "-" => [ 14, 156 ], __else__ => [ 14, 156 ], "~" => [ 14, 156 ], },
	# [156] opcode : and "(" ix "+" "[expr_DIS]"
	{ ")" => 157, },
	# [157] opcode : and "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_81 ], ":" => [ 9, \&_action_opcode_81 ], },
	# [158] opcode : and "(" ix "-"
	{ "!" => [ 16, 159 ], "+" => [ 16, 159 ], "-" => [ 16, 159 ], __else__ => [ 16, 159 ], "~" => [ 16, 159 ], },
	# [159] opcode : and "(" ix "-" "[expr_NDIS]"
	{ ")" => 160, },
	# [160] opcode : and "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_81 ], ":" => [ 9, \&_action_opcode_81 ], },
	# [161] opcode : and "(" iy
	{ ")" => 162, "+" => 163, "-" => 166, },
	# [162] opcode : and "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_82 ], ":" => [ 9, \&_action_opcode_82 ], },
	# [163] opcode : and "(" iy "+"
	{ "!" => [ 14, 164 ], "+" => [ 14, 164 ], "-" => [ 14, 164 ], __else__ => [ 14, 164 ], "~" => [ 14, 164 ], },
	# [164] opcode : and "(" iy "+" "[expr_DIS]"
	{ ")" => 165, },
	# [165] opcode : and "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_83 ], ":" => [ 9, \&_action_opcode_83 ], },
	# [166] opcode : and "(" iy "-"
	{ "!" => [ 16, 167 ], "+" => [ 16, 167 ], "-" => [ 16, 167 ], __else__ => [ 16, 167 ], "~" => [ 16, 167 ], },
	# [167] opcode : and "(" iy "-" "[expr_NDIS]"
	{ ")" => 168, },
	# [168] opcode : and "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_83 ], ":" => [ 9, \&_action_opcode_83 ], },
	# [169] opcode : and "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_84 ], ":" => [ 9, \&_action_opcode_84 ], },
	# [170] opcode : and a
	{ "\n" => [ 9, \&_action_opcode_85 ], ":" => [ 9, \&_action_opcode_85 ], },
	# [171] opcode : and b
	{ "\n" => [ 9, \&_action_opcode_86 ], ":" => [ 9, \&_action_opcode_86 ], },
	# [172] opcode : and c
	{ "\n" => [ 9, \&_action_opcode_87 ], ":" => [ 9, \&_action_opcode_87 ], },
	# [173] opcode : and d
	{ "\n" => [ 9, \&_action_opcode_88 ], ":" => [ 9, \&_action_opcode_88 ], },
	# [174] opcode : and e
	{ "\n" => [ 9, \&_action_opcode_89 ], ":" => [ 9, \&_action_opcode_89 ], },
	# [175] opcode : and h
	{ "\n" => [ 9, \&_action_opcode_90 ], ":" => [ 9, \&_action_opcode_90 ], },
	# [176] opcode : and ixh
	{ "\n" => [ 9, \&_action_opcode_91 ], ":" => [ 9, \&_action_opcode_91 ], },
	# [177] opcode : and ixl
	{ "\n" => [ 9, \&_action_opcode_92 ], ":" => [ 9, \&_action_opcode_92 ], },
	# [178] opcode : and iyh
	{ "\n" => [ 9, \&_action_opcode_93 ], ":" => [ 9, \&_action_opcode_93 ], },
	# [179] opcode : and iyl
	{ "\n" => [ 9, \&_action_opcode_94 ], ":" => [ 9, \&_action_opcode_94 ], },
	# [180] opcode : and l
	{ "\n" => [ 9, \&_action_opcode_95 ], ":" => [ 9, \&_action_opcode_95 ], },
	# [181] opcode : bit
	{ "!" => [ 42, 182 ], "+" => [ 42, 182 ], "-" => [ 42, 182 ], __else__ => [ 42, 182 ], "~" => [ 42, 182 ], },
	# [182] opcode : bit "[inline_const]"
	{ 0 => 183, 1 => 211, 2 => 239, 3 => 267, 4 => 295, 5 => 323, 6 => 351, 7 => 379, },
	# [183] opcode : bit "[inline_const]" 0
	{ "," => 184, },
	# [184] opcode : bit "[inline_const]" 0 ","
	{ "(" => 185, a => 204, b => 205, c => 206, d => 207, e => 208, h => 209, l => 210, },
	# [185] opcode : bit "[inline_const]" 0 "," "("
	{ hl => 186, ix => 188, iy => 196, },
	# [186] opcode : bit "[inline_const]" 0 "," "(" hl
	{ ")" => 187, },
	# [187] opcode : bit "[inline_const]" 0 "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_96 ], ":" => [ 9, \&_action_opcode_96 ], },
	# [188] opcode : bit "[inline_const]" 0 "," "(" ix
	{ ")" => 189, "+" => 190, "-" => 193, },
	# [189] opcode : bit "[inline_const]" 0 "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_97 ], ":" => [ 9, \&_action_opcode_97 ], },
	# [190] opcode : bit "[inline_const]" 0 "," "(" ix "+"
	{ "!" => [ 14, 191 ], "+" => [ 14, 191 ], "-" => [ 14, 191 ], __else__ => [ 14, 191 ], "~" => [ 14, 191 ], },
	# [191] opcode : bit "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 192, },
	# [192] opcode : bit "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_98 ], ":" => [ 9, \&_action_opcode_98 ], },
	# [193] opcode : bit "[inline_const]" 0 "," "(" ix "-"
	{ "!" => [ 16, 194 ], "+" => [ 16, 194 ], "-" => [ 16, 194 ], __else__ => [ 16, 194 ], "~" => [ 16, 194 ], },
	# [194] opcode : bit "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 195, },
	# [195] opcode : bit "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_98 ], ":" => [ 9, \&_action_opcode_98 ], },
	# [196] opcode : bit "[inline_const]" 0 "," "(" iy
	{ ")" => 197, "+" => 198, "-" => 201, },
	# [197] opcode : bit "[inline_const]" 0 "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_99 ], ":" => [ 9, \&_action_opcode_99 ], },
	# [198] opcode : bit "[inline_const]" 0 "," "(" iy "+"
	{ "!" => [ 14, 199 ], "+" => [ 14, 199 ], "-" => [ 14, 199 ], __else__ => [ 14, 199 ], "~" => [ 14, 199 ], },
	# [199] opcode : bit "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 200, },
	# [200] opcode : bit "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_100 ], ":" => [ 9, \&_action_opcode_100 ], },
	# [201] opcode : bit "[inline_const]" 0 "," "(" iy "-"
	{ "!" => [ 16, 202 ], "+" => [ 16, 202 ], "-" => [ 16, 202 ], __else__ => [ 16, 202 ], "~" => [ 16, 202 ], },
	# [202] opcode : bit "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 203, },
	# [203] opcode : bit "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_100 ], ":" => [ 9, \&_action_opcode_100 ], },
	# [204] opcode : bit "[inline_const]" 0 "," a
	{ "\n" => [ 9, \&_action_opcode_101 ], ":" => [ 9, \&_action_opcode_101 ], },
	# [205] opcode : bit "[inline_const]" 0 "," b
	{ "\n" => [ 9, \&_action_opcode_102 ], ":" => [ 9, \&_action_opcode_102 ], },
	# [206] opcode : bit "[inline_const]" 0 "," c
	{ "\n" => [ 9, \&_action_opcode_103 ], ":" => [ 9, \&_action_opcode_103 ], },
	# [207] opcode : bit "[inline_const]" 0 "," d
	{ "\n" => [ 9, \&_action_opcode_104 ], ":" => [ 9, \&_action_opcode_104 ], },
	# [208] opcode : bit "[inline_const]" 0 "," e
	{ "\n" => [ 9, \&_action_opcode_105 ], ":" => [ 9, \&_action_opcode_105 ], },
	# [209] opcode : bit "[inline_const]" 0 "," h
	{ "\n" => [ 9, \&_action_opcode_106 ], ":" => [ 9, \&_action_opcode_106 ], },
	# [210] opcode : bit "[inline_const]" 0 "," l
	{ "\n" => [ 9, \&_action_opcode_107 ], ":" => [ 9, \&_action_opcode_107 ], },
	# [211] opcode : bit "[inline_const]" 1
	{ "," => 212, },
	# [212] opcode : bit "[inline_const]" 1 ","
	{ "(" => 213, a => 232, b => 233, c => 234, d => 235, e => 236, h => 237, l => 238, },
	# [213] opcode : bit "[inline_const]" 1 "," "("
	{ hl => 214, ix => 216, iy => 224, },
	# [214] opcode : bit "[inline_const]" 1 "," "(" hl
	{ ")" => 215, },
	# [215] opcode : bit "[inline_const]" 1 "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_108 ], ":" => [ 9, \&_action_opcode_108 ], },
	# [216] opcode : bit "[inline_const]" 1 "," "(" ix
	{ ")" => 217, "+" => 218, "-" => 221, },
	# [217] opcode : bit "[inline_const]" 1 "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_109 ], ":" => [ 9, \&_action_opcode_109 ], },
	# [218] opcode : bit "[inline_const]" 1 "," "(" ix "+"
	{ "!" => [ 14, 219 ], "+" => [ 14, 219 ], "-" => [ 14, 219 ], __else__ => [ 14, 219 ], "~" => [ 14, 219 ], },
	# [219] opcode : bit "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 220, },
	# [220] opcode : bit "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_110 ], ":" => [ 9, \&_action_opcode_110 ], },
	# [221] opcode : bit "[inline_const]" 1 "," "(" ix "-"
	{ "!" => [ 16, 222 ], "+" => [ 16, 222 ], "-" => [ 16, 222 ], __else__ => [ 16, 222 ], "~" => [ 16, 222 ], },
	# [222] opcode : bit "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 223, },
	# [223] opcode : bit "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_110 ], ":" => [ 9, \&_action_opcode_110 ], },
	# [224] opcode : bit "[inline_const]" 1 "," "(" iy
	{ ")" => 225, "+" => 226, "-" => 229, },
	# [225] opcode : bit "[inline_const]" 1 "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_111 ], ":" => [ 9, \&_action_opcode_111 ], },
	# [226] opcode : bit "[inline_const]" 1 "," "(" iy "+"
	{ "!" => [ 14, 227 ], "+" => [ 14, 227 ], "-" => [ 14, 227 ], __else__ => [ 14, 227 ], "~" => [ 14, 227 ], },
	# [227] opcode : bit "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 228, },
	# [228] opcode : bit "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_112 ], ":" => [ 9, \&_action_opcode_112 ], },
	# [229] opcode : bit "[inline_const]" 1 "," "(" iy "-"
	{ "!" => [ 16, 230 ], "+" => [ 16, 230 ], "-" => [ 16, 230 ], __else__ => [ 16, 230 ], "~" => [ 16, 230 ], },
	# [230] opcode : bit "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 231, },
	# [231] opcode : bit "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_112 ], ":" => [ 9, \&_action_opcode_112 ], },
	# [232] opcode : bit "[inline_const]" 1 "," a
	{ "\n" => [ 9, \&_action_opcode_113 ], ":" => [ 9, \&_action_opcode_113 ], },
	# [233] opcode : bit "[inline_const]" 1 "," b
	{ "\n" => [ 9, \&_action_opcode_114 ], ":" => [ 9, \&_action_opcode_114 ], },
	# [234] opcode : bit "[inline_const]" 1 "," c
	{ "\n" => [ 9, \&_action_opcode_115 ], ":" => [ 9, \&_action_opcode_115 ], },
	# [235] opcode : bit "[inline_const]" 1 "," d
	{ "\n" => [ 9, \&_action_opcode_116 ], ":" => [ 9, \&_action_opcode_116 ], },
	# [236] opcode : bit "[inline_const]" 1 "," e
	{ "\n" => [ 9, \&_action_opcode_117 ], ":" => [ 9, \&_action_opcode_117 ], },
	# [237] opcode : bit "[inline_const]" 1 "," h
	{ "\n" => [ 9, \&_action_opcode_118 ], ":" => [ 9, \&_action_opcode_118 ], },
	# [238] opcode : bit "[inline_const]" 1 "," l
	{ "\n" => [ 9, \&_action_opcode_119 ], ":" => [ 9, \&_action_opcode_119 ], },
	# [239] opcode : bit "[inline_const]" 2
	{ "," => 240, },
	# [240] opcode : bit "[inline_const]" 2 ","
	{ "(" => 241, a => 260, b => 261, c => 262, d => 263, e => 264, h => 265, l => 266, },
	# [241] opcode : bit "[inline_const]" 2 "," "("
	{ hl => 242, ix => 244, iy => 252, },
	# [242] opcode : bit "[inline_const]" 2 "," "(" hl
	{ ")" => 243, },
	# [243] opcode : bit "[inline_const]" 2 "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_120 ], ":" => [ 9, \&_action_opcode_120 ], },
	# [244] opcode : bit "[inline_const]" 2 "," "(" ix
	{ ")" => 245, "+" => 246, "-" => 249, },
	# [245] opcode : bit "[inline_const]" 2 "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_121 ], ":" => [ 9, \&_action_opcode_121 ], },
	# [246] opcode : bit "[inline_const]" 2 "," "(" ix "+"
	{ "!" => [ 14, 247 ], "+" => [ 14, 247 ], "-" => [ 14, 247 ], __else__ => [ 14, 247 ], "~" => [ 14, 247 ], },
	# [247] opcode : bit "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 248, },
	# [248] opcode : bit "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_122 ], ":" => [ 9, \&_action_opcode_122 ], },
	# [249] opcode : bit "[inline_const]" 2 "," "(" ix "-"
	{ "!" => [ 16, 250 ], "+" => [ 16, 250 ], "-" => [ 16, 250 ], __else__ => [ 16, 250 ], "~" => [ 16, 250 ], },
	# [250] opcode : bit "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 251, },
	# [251] opcode : bit "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_122 ], ":" => [ 9, \&_action_opcode_122 ], },
	# [252] opcode : bit "[inline_const]" 2 "," "(" iy
	{ ")" => 253, "+" => 254, "-" => 257, },
	# [253] opcode : bit "[inline_const]" 2 "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_123 ], ":" => [ 9, \&_action_opcode_123 ], },
	# [254] opcode : bit "[inline_const]" 2 "," "(" iy "+"
	{ "!" => [ 14, 255 ], "+" => [ 14, 255 ], "-" => [ 14, 255 ], __else__ => [ 14, 255 ], "~" => [ 14, 255 ], },
	# [255] opcode : bit "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 256, },
	# [256] opcode : bit "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_124 ], ":" => [ 9, \&_action_opcode_124 ], },
	# [257] opcode : bit "[inline_const]" 2 "," "(" iy "-"
	{ "!" => [ 16, 258 ], "+" => [ 16, 258 ], "-" => [ 16, 258 ], __else__ => [ 16, 258 ], "~" => [ 16, 258 ], },
	# [258] opcode : bit "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 259, },
	# [259] opcode : bit "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_124 ], ":" => [ 9, \&_action_opcode_124 ], },
	# [260] opcode : bit "[inline_const]" 2 "," a
	{ "\n" => [ 9, \&_action_opcode_125 ], ":" => [ 9, \&_action_opcode_125 ], },
	# [261] opcode : bit "[inline_const]" 2 "," b
	{ "\n" => [ 9, \&_action_opcode_126 ], ":" => [ 9, \&_action_opcode_126 ], },
	# [262] opcode : bit "[inline_const]" 2 "," c
	{ "\n" => [ 9, \&_action_opcode_127 ], ":" => [ 9, \&_action_opcode_127 ], },
	# [263] opcode : bit "[inline_const]" 2 "," d
	{ "\n" => [ 9, \&_action_opcode_128 ], ":" => [ 9, \&_action_opcode_128 ], },
	# [264] opcode : bit "[inline_const]" 2 "," e
	{ "\n" => [ 9, \&_action_opcode_129 ], ":" => [ 9, \&_action_opcode_129 ], },
	# [265] opcode : bit "[inline_const]" 2 "," h
	{ "\n" => [ 9, \&_action_opcode_130 ], ":" => [ 9, \&_action_opcode_130 ], },
	# [266] opcode : bit "[inline_const]" 2 "," l
	{ "\n" => [ 9, \&_action_opcode_131 ], ":" => [ 9, \&_action_opcode_131 ], },
	# [267] opcode : bit "[inline_const]" 3
	{ "," => 268, },
	# [268] opcode : bit "[inline_const]" 3 ","
	{ "(" => 269, a => 288, b => 289, c => 290, d => 291, e => 292, h => 293, l => 294, },
	# [269] opcode : bit "[inline_const]" 3 "," "("
	{ hl => 270, ix => 272, iy => 280, },
	# [270] opcode : bit "[inline_const]" 3 "," "(" hl
	{ ")" => 271, },
	# [271] opcode : bit "[inline_const]" 3 "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_132 ], ":" => [ 9, \&_action_opcode_132 ], },
	# [272] opcode : bit "[inline_const]" 3 "," "(" ix
	{ ")" => 273, "+" => 274, "-" => 277, },
	# [273] opcode : bit "[inline_const]" 3 "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_133 ], ":" => [ 9, \&_action_opcode_133 ], },
	# [274] opcode : bit "[inline_const]" 3 "," "(" ix "+"
	{ "!" => [ 14, 275 ], "+" => [ 14, 275 ], "-" => [ 14, 275 ], __else__ => [ 14, 275 ], "~" => [ 14, 275 ], },
	# [275] opcode : bit "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 276, },
	# [276] opcode : bit "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_134 ], ":" => [ 9, \&_action_opcode_134 ], },
	# [277] opcode : bit "[inline_const]" 3 "," "(" ix "-"
	{ "!" => [ 16, 278 ], "+" => [ 16, 278 ], "-" => [ 16, 278 ], __else__ => [ 16, 278 ], "~" => [ 16, 278 ], },
	# [278] opcode : bit "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 279, },
	# [279] opcode : bit "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_134 ], ":" => [ 9, \&_action_opcode_134 ], },
	# [280] opcode : bit "[inline_const]" 3 "," "(" iy
	{ ")" => 281, "+" => 282, "-" => 285, },
	# [281] opcode : bit "[inline_const]" 3 "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_135 ], ":" => [ 9, \&_action_opcode_135 ], },
	# [282] opcode : bit "[inline_const]" 3 "," "(" iy "+"
	{ "!" => [ 14, 283 ], "+" => [ 14, 283 ], "-" => [ 14, 283 ], __else__ => [ 14, 283 ], "~" => [ 14, 283 ], },
	# [283] opcode : bit "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 284, },
	# [284] opcode : bit "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_136 ], ":" => [ 9, \&_action_opcode_136 ], },
	# [285] opcode : bit "[inline_const]" 3 "," "(" iy "-"
	{ "!" => [ 16, 286 ], "+" => [ 16, 286 ], "-" => [ 16, 286 ], __else__ => [ 16, 286 ], "~" => [ 16, 286 ], },
	# [286] opcode : bit "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 287, },
	# [287] opcode : bit "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_136 ], ":" => [ 9, \&_action_opcode_136 ], },
	# [288] opcode : bit "[inline_const]" 3 "," a
	{ "\n" => [ 9, \&_action_opcode_137 ], ":" => [ 9, \&_action_opcode_137 ], },
	# [289] opcode : bit "[inline_const]" 3 "," b
	{ "\n" => [ 9, \&_action_opcode_138 ], ":" => [ 9, \&_action_opcode_138 ], },
	# [290] opcode : bit "[inline_const]" 3 "," c
	{ "\n" => [ 9, \&_action_opcode_139 ], ":" => [ 9, \&_action_opcode_139 ], },
	# [291] opcode : bit "[inline_const]" 3 "," d
	{ "\n" => [ 9, \&_action_opcode_140 ], ":" => [ 9, \&_action_opcode_140 ], },
	# [292] opcode : bit "[inline_const]" 3 "," e
	{ "\n" => [ 9, \&_action_opcode_141 ], ":" => [ 9, \&_action_opcode_141 ], },
	# [293] opcode : bit "[inline_const]" 3 "," h
	{ "\n" => [ 9, \&_action_opcode_142 ], ":" => [ 9, \&_action_opcode_142 ], },
	# [294] opcode : bit "[inline_const]" 3 "," l
	{ "\n" => [ 9, \&_action_opcode_143 ], ":" => [ 9, \&_action_opcode_143 ], },
	# [295] opcode : bit "[inline_const]" 4
	{ "," => 296, },
	# [296] opcode : bit "[inline_const]" 4 ","
	{ "(" => 297, a => 316, b => 317, c => 318, d => 319, e => 320, h => 321, l => 322, },
	# [297] opcode : bit "[inline_const]" 4 "," "("
	{ hl => 298, ix => 300, iy => 308, },
	# [298] opcode : bit "[inline_const]" 4 "," "(" hl
	{ ")" => 299, },
	# [299] opcode : bit "[inline_const]" 4 "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_144 ], ":" => [ 9, \&_action_opcode_144 ], },
	# [300] opcode : bit "[inline_const]" 4 "," "(" ix
	{ ")" => 301, "+" => 302, "-" => 305, },
	# [301] opcode : bit "[inline_const]" 4 "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_145 ], ":" => [ 9, \&_action_opcode_145 ], },
	# [302] opcode : bit "[inline_const]" 4 "," "(" ix "+"
	{ "!" => [ 14, 303 ], "+" => [ 14, 303 ], "-" => [ 14, 303 ], __else__ => [ 14, 303 ], "~" => [ 14, 303 ], },
	# [303] opcode : bit "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 304, },
	# [304] opcode : bit "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_146 ], ":" => [ 9, \&_action_opcode_146 ], },
	# [305] opcode : bit "[inline_const]" 4 "," "(" ix "-"
	{ "!" => [ 16, 306 ], "+" => [ 16, 306 ], "-" => [ 16, 306 ], __else__ => [ 16, 306 ], "~" => [ 16, 306 ], },
	# [306] opcode : bit "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 307, },
	# [307] opcode : bit "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_146 ], ":" => [ 9, \&_action_opcode_146 ], },
	# [308] opcode : bit "[inline_const]" 4 "," "(" iy
	{ ")" => 309, "+" => 310, "-" => 313, },
	# [309] opcode : bit "[inline_const]" 4 "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_147 ], ":" => [ 9, \&_action_opcode_147 ], },
	# [310] opcode : bit "[inline_const]" 4 "," "(" iy "+"
	{ "!" => [ 14, 311 ], "+" => [ 14, 311 ], "-" => [ 14, 311 ], __else__ => [ 14, 311 ], "~" => [ 14, 311 ], },
	# [311] opcode : bit "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 312, },
	# [312] opcode : bit "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_148 ], ":" => [ 9, \&_action_opcode_148 ], },
	# [313] opcode : bit "[inline_const]" 4 "," "(" iy "-"
	{ "!" => [ 16, 314 ], "+" => [ 16, 314 ], "-" => [ 16, 314 ], __else__ => [ 16, 314 ], "~" => [ 16, 314 ], },
	# [314] opcode : bit "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 315, },
	# [315] opcode : bit "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_148 ], ":" => [ 9, \&_action_opcode_148 ], },
	# [316] opcode : bit "[inline_const]" 4 "," a
	{ "\n" => [ 9, \&_action_opcode_149 ], ":" => [ 9, \&_action_opcode_149 ], },
	# [317] opcode : bit "[inline_const]" 4 "," b
	{ "\n" => [ 9, \&_action_opcode_150 ], ":" => [ 9, \&_action_opcode_150 ], },
	# [318] opcode : bit "[inline_const]" 4 "," c
	{ "\n" => [ 9, \&_action_opcode_151 ], ":" => [ 9, \&_action_opcode_151 ], },
	# [319] opcode : bit "[inline_const]" 4 "," d
	{ "\n" => [ 9, \&_action_opcode_152 ], ":" => [ 9, \&_action_opcode_152 ], },
	# [320] opcode : bit "[inline_const]" 4 "," e
	{ "\n" => [ 9, \&_action_opcode_153 ], ":" => [ 9, \&_action_opcode_153 ], },
	# [321] opcode : bit "[inline_const]" 4 "," h
	{ "\n" => [ 9, \&_action_opcode_154 ], ":" => [ 9, \&_action_opcode_154 ], },
	# [322] opcode : bit "[inline_const]" 4 "," l
	{ "\n" => [ 9, \&_action_opcode_155 ], ":" => [ 9, \&_action_opcode_155 ], },
	# [323] opcode : bit "[inline_const]" 5
	{ "," => 324, },
	# [324] opcode : bit "[inline_const]" 5 ","
	{ "(" => 325, a => 344, b => 345, c => 346, d => 347, e => 348, h => 349, l => 350, },
	# [325] opcode : bit "[inline_const]" 5 "," "("
	{ hl => 326, ix => 328, iy => 336, },
	# [326] opcode : bit "[inline_const]" 5 "," "(" hl
	{ ")" => 327, },
	# [327] opcode : bit "[inline_const]" 5 "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_156 ], ":" => [ 9, \&_action_opcode_156 ], },
	# [328] opcode : bit "[inline_const]" 5 "," "(" ix
	{ ")" => 329, "+" => 330, "-" => 333, },
	# [329] opcode : bit "[inline_const]" 5 "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_157 ], ":" => [ 9, \&_action_opcode_157 ], },
	# [330] opcode : bit "[inline_const]" 5 "," "(" ix "+"
	{ "!" => [ 14, 331 ], "+" => [ 14, 331 ], "-" => [ 14, 331 ], __else__ => [ 14, 331 ], "~" => [ 14, 331 ], },
	# [331] opcode : bit "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 332, },
	# [332] opcode : bit "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_158 ], ":" => [ 9, \&_action_opcode_158 ], },
	# [333] opcode : bit "[inline_const]" 5 "," "(" ix "-"
	{ "!" => [ 16, 334 ], "+" => [ 16, 334 ], "-" => [ 16, 334 ], __else__ => [ 16, 334 ], "~" => [ 16, 334 ], },
	# [334] opcode : bit "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 335, },
	# [335] opcode : bit "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_158 ], ":" => [ 9, \&_action_opcode_158 ], },
	# [336] opcode : bit "[inline_const]" 5 "," "(" iy
	{ ")" => 337, "+" => 338, "-" => 341, },
	# [337] opcode : bit "[inline_const]" 5 "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_159 ], ":" => [ 9, \&_action_opcode_159 ], },
	# [338] opcode : bit "[inline_const]" 5 "," "(" iy "+"
	{ "!" => [ 14, 339 ], "+" => [ 14, 339 ], "-" => [ 14, 339 ], __else__ => [ 14, 339 ], "~" => [ 14, 339 ], },
	# [339] opcode : bit "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 340, },
	# [340] opcode : bit "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_160 ], ":" => [ 9, \&_action_opcode_160 ], },
	# [341] opcode : bit "[inline_const]" 5 "," "(" iy "-"
	{ "!" => [ 16, 342 ], "+" => [ 16, 342 ], "-" => [ 16, 342 ], __else__ => [ 16, 342 ], "~" => [ 16, 342 ], },
	# [342] opcode : bit "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 343, },
	# [343] opcode : bit "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_160 ], ":" => [ 9, \&_action_opcode_160 ], },
	# [344] opcode : bit "[inline_const]" 5 "," a
	{ "\n" => [ 9, \&_action_opcode_161 ], ":" => [ 9, \&_action_opcode_161 ], },
	# [345] opcode : bit "[inline_const]" 5 "," b
	{ "\n" => [ 9, \&_action_opcode_162 ], ":" => [ 9, \&_action_opcode_162 ], },
	# [346] opcode : bit "[inline_const]" 5 "," c
	{ "\n" => [ 9, \&_action_opcode_163 ], ":" => [ 9, \&_action_opcode_163 ], },
	# [347] opcode : bit "[inline_const]" 5 "," d
	{ "\n" => [ 9, \&_action_opcode_164 ], ":" => [ 9, \&_action_opcode_164 ], },
	# [348] opcode : bit "[inline_const]" 5 "," e
	{ "\n" => [ 9, \&_action_opcode_165 ], ":" => [ 9, \&_action_opcode_165 ], },
	# [349] opcode : bit "[inline_const]" 5 "," h
	{ "\n" => [ 9, \&_action_opcode_166 ], ":" => [ 9, \&_action_opcode_166 ], },
	# [350] opcode : bit "[inline_const]" 5 "," l
	{ "\n" => [ 9, \&_action_opcode_167 ], ":" => [ 9, \&_action_opcode_167 ], },
	# [351] opcode : bit "[inline_const]" 6
	{ "," => 352, },
	# [352] opcode : bit "[inline_const]" 6 ","
	{ "(" => 353, a => 372, b => 373, c => 374, d => 375, e => 376, h => 377, l => 378, },
	# [353] opcode : bit "[inline_const]" 6 "," "("
	{ hl => 354, ix => 356, iy => 364, },
	# [354] opcode : bit "[inline_const]" 6 "," "(" hl
	{ ")" => 355, },
	# [355] opcode : bit "[inline_const]" 6 "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_168 ], ":" => [ 9, \&_action_opcode_168 ], },
	# [356] opcode : bit "[inline_const]" 6 "," "(" ix
	{ ")" => 357, "+" => 358, "-" => 361, },
	# [357] opcode : bit "[inline_const]" 6 "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_169 ], ":" => [ 9, \&_action_opcode_169 ], },
	# [358] opcode : bit "[inline_const]" 6 "," "(" ix "+"
	{ "!" => [ 14, 359 ], "+" => [ 14, 359 ], "-" => [ 14, 359 ], __else__ => [ 14, 359 ], "~" => [ 14, 359 ], },
	# [359] opcode : bit "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 360, },
	# [360] opcode : bit "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_170 ], ":" => [ 9, \&_action_opcode_170 ], },
	# [361] opcode : bit "[inline_const]" 6 "," "(" ix "-"
	{ "!" => [ 16, 362 ], "+" => [ 16, 362 ], "-" => [ 16, 362 ], __else__ => [ 16, 362 ], "~" => [ 16, 362 ], },
	# [362] opcode : bit "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 363, },
	# [363] opcode : bit "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_170 ], ":" => [ 9, \&_action_opcode_170 ], },
	# [364] opcode : bit "[inline_const]" 6 "," "(" iy
	{ ")" => 365, "+" => 366, "-" => 369, },
	# [365] opcode : bit "[inline_const]" 6 "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_171 ], ":" => [ 9, \&_action_opcode_171 ], },
	# [366] opcode : bit "[inline_const]" 6 "," "(" iy "+"
	{ "!" => [ 14, 367 ], "+" => [ 14, 367 ], "-" => [ 14, 367 ], __else__ => [ 14, 367 ], "~" => [ 14, 367 ], },
	# [367] opcode : bit "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 368, },
	# [368] opcode : bit "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_172 ], ":" => [ 9, \&_action_opcode_172 ], },
	# [369] opcode : bit "[inline_const]" 6 "," "(" iy "-"
	{ "!" => [ 16, 370 ], "+" => [ 16, 370 ], "-" => [ 16, 370 ], __else__ => [ 16, 370 ], "~" => [ 16, 370 ], },
	# [370] opcode : bit "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 371, },
	# [371] opcode : bit "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_172 ], ":" => [ 9, \&_action_opcode_172 ], },
	# [372] opcode : bit "[inline_const]" 6 "," a
	{ "\n" => [ 9, \&_action_opcode_173 ], ":" => [ 9, \&_action_opcode_173 ], },
	# [373] opcode : bit "[inline_const]" 6 "," b
	{ "\n" => [ 9, \&_action_opcode_174 ], ":" => [ 9, \&_action_opcode_174 ], },
	# [374] opcode : bit "[inline_const]" 6 "," c
	{ "\n" => [ 9, \&_action_opcode_175 ], ":" => [ 9, \&_action_opcode_175 ], },
	# [375] opcode : bit "[inline_const]" 6 "," d
	{ "\n" => [ 9, \&_action_opcode_176 ], ":" => [ 9, \&_action_opcode_176 ], },
	# [376] opcode : bit "[inline_const]" 6 "," e
	{ "\n" => [ 9, \&_action_opcode_177 ], ":" => [ 9, \&_action_opcode_177 ], },
	# [377] opcode : bit "[inline_const]" 6 "," h
	{ "\n" => [ 9, \&_action_opcode_178 ], ":" => [ 9, \&_action_opcode_178 ], },
	# [378] opcode : bit "[inline_const]" 6 "," l
	{ "\n" => [ 9, \&_action_opcode_179 ], ":" => [ 9, \&_action_opcode_179 ], },
	# [379] opcode : bit "[inline_const]" 7
	{ "," => 380, },
	# [380] opcode : bit "[inline_const]" 7 ","
	{ "(" => 381, a => 400, b => 401, c => 402, d => 403, e => 404, h => 405, l => 406, },
	# [381] opcode : bit "[inline_const]" 7 "," "("
	{ hl => 382, ix => 384, iy => 392, },
	# [382] opcode : bit "[inline_const]" 7 "," "(" hl
	{ ")" => 383, },
	# [383] opcode : bit "[inline_const]" 7 "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_180 ], ":" => [ 9, \&_action_opcode_180 ], },
	# [384] opcode : bit "[inline_const]" 7 "," "(" ix
	{ ")" => 385, "+" => 386, "-" => 389, },
	# [385] opcode : bit "[inline_const]" 7 "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_181 ], ":" => [ 9, \&_action_opcode_181 ], },
	# [386] opcode : bit "[inline_const]" 7 "," "(" ix "+"
	{ "!" => [ 14, 387 ], "+" => [ 14, 387 ], "-" => [ 14, 387 ], __else__ => [ 14, 387 ], "~" => [ 14, 387 ], },
	# [387] opcode : bit "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 388, },
	# [388] opcode : bit "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_182 ], ":" => [ 9, \&_action_opcode_182 ], },
	# [389] opcode : bit "[inline_const]" 7 "," "(" ix "-"
	{ "!" => [ 16, 390 ], "+" => [ 16, 390 ], "-" => [ 16, 390 ], __else__ => [ 16, 390 ], "~" => [ 16, 390 ], },
	# [390] opcode : bit "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 391, },
	# [391] opcode : bit "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_182 ], ":" => [ 9, \&_action_opcode_182 ], },
	# [392] opcode : bit "[inline_const]" 7 "," "(" iy
	{ ")" => 393, "+" => 394, "-" => 397, },
	# [393] opcode : bit "[inline_const]" 7 "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_183 ], ":" => [ 9, \&_action_opcode_183 ], },
	# [394] opcode : bit "[inline_const]" 7 "," "(" iy "+"
	{ "!" => [ 14, 395 ], "+" => [ 14, 395 ], "-" => [ 14, 395 ], __else__ => [ 14, 395 ], "~" => [ 14, 395 ], },
	# [395] opcode : bit "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 396, },
	# [396] opcode : bit "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_184 ], ":" => [ 9, \&_action_opcode_184 ], },
	# [397] opcode : bit "[inline_const]" 7 "," "(" iy "-"
	{ "!" => [ 16, 398 ], "+" => [ 16, 398 ], "-" => [ 16, 398 ], __else__ => [ 16, 398 ], "~" => [ 16, 398 ], },
	# [398] opcode : bit "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 399, },
	# [399] opcode : bit "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_184 ], ":" => [ 9, \&_action_opcode_184 ], },
	# [400] opcode : bit "[inline_const]" 7 "," a
	{ "\n" => [ 9, \&_action_opcode_185 ], ":" => [ 9, \&_action_opcode_185 ], },
	# [401] opcode : bit "[inline_const]" 7 "," b
	{ "\n" => [ 9, \&_action_opcode_186 ], ":" => [ 9, \&_action_opcode_186 ], },
	# [402] opcode : bit "[inline_const]" 7 "," c
	{ "\n" => [ 9, \&_action_opcode_187 ], ":" => [ 9, \&_action_opcode_187 ], },
	# [403] opcode : bit "[inline_const]" 7 "," d
	{ "\n" => [ 9, \&_action_opcode_188 ], ":" => [ 9, \&_action_opcode_188 ], },
	# [404] opcode : bit "[inline_const]" 7 "," e
	{ "\n" => [ 9, \&_action_opcode_189 ], ":" => [ 9, \&_action_opcode_189 ], },
	# [405] opcode : bit "[inline_const]" 7 "," h
	{ "\n" => [ 9, \&_action_opcode_190 ], ":" => [ 9, \&_action_opcode_190 ], },
	# [406] opcode : bit "[inline_const]" 7 "," l
	{ "\n" => [ 9, \&_action_opcode_191 ], ":" => [ 9, \&_action_opcode_191 ], },
	# [407] opcode : call
	{ "!" => [ 17, 408 ], "+" => [ 17, 408 ], "-" => [ 17, 408 ], __else__ => [ 17, 408 ], c => 409, m => 412, nc => 415, nz => 418, p => 421, pe => 424, po => 427, z => 430, "~" => [ 17, 408 ], },
	# [408] opcode : call "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_192 ], ":" => [ 9, \&_action_opcode_192 ], },
	# [409] opcode : call c
	{ "," => 410, },
	# [410] opcode : call c ","
	{ "!" => [ 17, 411 ], "+" => [ 17, 411 ], "-" => [ 17, 411 ], __else__ => [ 17, 411 ], "~" => [ 17, 411 ], },
	# [411] opcode : call c "," "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_193 ], ":" => [ 9, \&_action_opcode_193 ], },
	# [412] opcode : call m
	{ "," => 413, },
	# [413] opcode : call m ","
	{ "!" => [ 17, 414 ], "+" => [ 17, 414 ], "-" => [ 17, 414 ], __else__ => [ 17, 414 ], "~" => [ 17, 414 ], },
	# [414] opcode : call m "," "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_194 ], ":" => [ 9, \&_action_opcode_194 ], },
	# [415] opcode : call nc
	{ "," => 416, },
	# [416] opcode : call nc ","
	{ "!" => [ 17, 417 ], "+" => [ 17, 417 ], "-" => [ 17, 417 ], __else__ => [ 17, 417 ], "~" => [ 17, 417 ], },
	# [417] opcode : call nc "," "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_195 ], ":" => [ 9, \&_action_opcode_195 ], },
	# [418] opcode : call nz
	{ "," => 419, },
	# [419] opcode : call nz ","
	{ "!" => [ 17, 420 ], "+" => [ 17, 420 ], "-" => [ 17, 420 ], __else__ => [ 17, 420 ], "~" => [ 17, 420 ], },
	# [420] opcode : call nz "," "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_196 ], ":" => [ 9, \&_action_opcode_196 ], },
	# [421] opcode : call p
	{ "," => 422, },
	# [422] opcode : call p ","
	{ "!" => [ 17, 423 ], "+" => [ 17, 423 ], "-" => [ 17, 423 ], __else__ => [ 17, 423 ], "~" => [ 17, 423 ], },
	# [423] opcode : call p "," "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_197 ], ":" => [ 9, \&_action_opcode_197 ], },
	# [424] opcode : call pe
	{ "," => 425, },
	# [425] opcode : call pe ","
	{ "!" => [ 17, 426 ], "+" => [ 17, 426 ], "-" => [ 17, 426 ], __else__ => [ 17, 426 ], "~" => [ 17, 426 ], },
	# [426] opcode : call pe "," "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_198 ], ":" => [ 9, \&_action_opcode_198 ], },
	# [427] opcode : call po
	{ "," => 428, },
	# [428] opcode : call po ","
	{ "!" => [ 17, 429 ], "+" => [ 17, 429 ], "-" => [ 17, 429 ], __else__ => [ 17, 429 ], "~" => [ 17, 429 ], },
	# [429] opcode : call po "," "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_199 ], ":" => [ 9, \&_action_opcode_199 ], },
	# [430] opcode : call z
	{ "," => 431, },
	# [431] opcode : call z ","
	{ "!" => [ 17, 432 ], "+" => [ 17, 432 ], "-" => [ 17, 432 ], __else__ => [ 17, 432 ], "~" => [ 17, 432 ], },
	# [432] opcode : call z "," "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_200 ], ":" => [ 9, \&_action_opcode_200 ], },
	# [433] opcode : ccf
	{ "\n" => [ 9, \&_action_opcode_201 ], ":" => [ 9, \&_action_opcode_201 ], },
	# [434] opcode : cp
	{ "!" => [ 15, 454 ], "(" => 435, "+" => [ 15, 454 ], "-" => [ 15, 454 ], __else__ => [ 15, 454 ], a => 455, b => 456, c => 457, d => 458, e => 459, h => 460, ixh => 461, ixl => 462, iyh => 463, iyl => 464, l => 465, "~" => [ 15, 454 ], },
	# [435] opcode : cp "("
	{ hl => 436, ix => 438, iy => 446, },
	# [436] opcode : cp "(" hl
	{ ")" => 437, },
	# [437] opcode : cp "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_202 ], ":" => [ 9, \&_action_opcode_202 ], },
	# [438] opcode : cp "(" ix
	{ ")" => 439, "+" => 440, "-" => 443, },
	# [439] opcode : cp "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_203 ], ":" => [ 9, \&_action_opcode_203 ], },
	# [440] opcode : cp "(" ix "+"
	{ "!" => [ 14, 441 ], "+" => [ 14, 441 ], "-" => [ 14, 441 ], __else__ => [ 14, 441 ], "~" => [ 14, 441 ], },
	# [441] opcode : cp "(" ix "+" "[expr_DIS]"
	{ ")" => 442, },
	# [442] opcode : cp "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_204 ], ":" => [ 9, \&_action_opcode_204 ], },
	# [443] opcode : cp "(" ix "-"
	{ "!" => [ 16, 444 ], "+" => [ 16, 444 ], "-" => [ 16, 444 ], __else__ => [ 16, 444 ], "~" => [ 16, 444 ], },
	# [444] opcode : cp "(" ix "-" "[expr_NDIS]"
	{ ")" => 445, },
	# [445] opcode : cp "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_204 ], ":" => [ 9, \&_action_opcode_204 ], },
	# [446] opcode : cp "(" iy
	{ ")" => 447, "+" => 448, "-" => 451, },
	# [447] opcode : cp "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_205 ], ":" => [ 9, \&_action_opcode_205 ], },
	# [448] opcode : cp "(" iy "+"
	{ "!" => [ 14, 449 ], "+" => [ 14, 449 ], "-" => [ 14, 449 ], __else__ => [ 14, 449 ], "~" => [ 14, 449 ], },
	# [449] opcode : cp "(" iy "+" "[expr_DIS]"
	{ ")" => 450, },
	# [450] opcode : cp "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_206 ], ":" => [ 9, \&_action_opcode_206 ], },
	# [451] opcode : cp "(" iy "-"
	{ "!" => [ 16, 452 ], "+" => [ 16, 452 ], "-" => [ 16, 452 ], __else__ => [ 16, 452 ], "~" => [ 16, 452 ], },
	# [452] opcode : cp "(" iy "-" "[expr_NDIS]"
	{ ")" => 453, },
	# [453] opcode : cp "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_206 ], ":" => [ 9, \&_action_opcode_206 ], },
	# [454] opcode : cp "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_207 ], ":" => [ 9, \&_action_opcode_207 ], },
	# [455] opcode : cp a
	{ "\n" => [ 9, \&_action_opcode_208 ], ":" => [ 9, \&_action_opcode_208 ], },
	# [456] opcode : cp b
	{ "\n" => [ 9, \&_action_opcode_209 ], ":" => [ 9, \&_action_opcode_209 ], },
	# [457] opcode : cp c
	{ "\n" => [ 9, \&_action_opcode_210 ], ":" => [ 9, \&_action_opcode_210 ], },
	# [458] opcode : cp d
	{ "\n" => [ 9, \&_action_opcode_211 ], ":" => [ 9, \&_action_opcode_211 ], },
	# [459] opcode : cp e
	{ "\n" => [ 9, \&_action_opcode_212 ], ":" => [ 9, \&_action_opcode_212 ], },
	# [460] opcode : cp h
	{ "\n" => [ 9, \&_action_opcode_213 ], ":" => [ 9, \&_action_opcode_213 ], },
	# [461] opcode : cp ixh
	{ "\n" => [ 9, \&_action_opcode_214 ], ":" => [ 9, \&_action_opcode_214 ], },
	# [462] opcode : cp ixl
	{ "\n" => [ 9, \&_action_opcode_215 ], ":" => [ 9, \&_action_opcode_215 ], },
	# [463] opcode : cp iyh
	{ "\n" => [ 9, \&_action_opcode_216 ], ":" => [ 9, \&_action_opcode_216 ], },
	# [464] opcode : cp iyl
	{ "\n" => [ 9, \&_action_opcode_217 ], ":" => [ 9, \&_action_opcode_217 ], },
	# [465] opcode : cp l
	{ "\n" => [ 9, \&_action_opcode_218 ], ":" => [ 9, \&_action_opcode_218 ], },
	# [466] opcode : cpd
	{ "\n" => [ 9, \&_action_opcode_219 ], ":" => [ 9, \&_action_opcode_219 ], },
	# [467] opcode : cpdr
	{ "\n" => [ 9, \&_action_opcode_220 ], ":" => [ 9, \&_action_opcode_220 ], },
	# [468] opcode : cpi
	{ "\n" => [ 9, \&_action_opcode_221 ], ":" => [ 9, \&_action_opcode_221 ], },
	# [469] opcode : cpir
	{ "\n" => [ 9, \&_action_opcode_222 ], ":" => [ 9, \&_action_opcode_222 ], },
	# [470] opcode : cpl
	{ "\n" => [ 9, \&_action_opcode_223 ], ":" => [ 9, \&_action_opcode_223 ], },
	# [471] opcode : daa
	{ "\n" => [ 9, \&_action_opcode_224 ], ":" => [ 9, \&_action_opcode_224 ], },
	# [472] opcode : dec
	{ "(" => 473, a => 492, b => 493, bc => 494, c => 495, d => 496, de => 497, e => 498, h => 499, hl => 500, ix => 501, ixh => 502, ixl => 503, iy => 504, iyh => 505, iyl => 506, l => 507, sp => 508, },
	# [473] opcode : dec "("
	{ hl => 474, ix => 476, iy => 484, },
	# [474] opcode : dec "(" hl
	{ ")" => 475, },
	# [475] opcode : dec "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_225 ], ":" => [ 9, \&_action_opcode_225 ], },
	# [476] opcode : dec "(" ix
	{ ")" => 477, "+" => 478, "-" => 481, },
	# [477] opcode : dec "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_226 ], ":" => [ 9, \&_action_opcode_226 ], },
	# [478] opcode : dec "(" ix "+"
	{ "!" => [ 14, 479 ], "+" => [ 14, 479 ], "-" => [ 14, 479 ], __else__ => [ 14, 479 ], "~" => [ 14, 479 ], },
	# [479] opcode : dec "(" ix "+" "[expr_DIS]"
	{ ")" => 480, },
	# [480] opcode : dec "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_227 ], ":" => [ 9, \&_action_opcode_227 ], },
	# [481] opcode : dec "(" ix "-"
	{ "!" => [ 16, 482 ], "+" => [ 16, 482 ], "-" => [ 16, 482 ], __else__ => [ 16, 482 ], "~" => [ 16, 482 ], },
	# [482] opcode : dec "(" ix "-" "[expr_NDIS]"
	{ ")" => 483, },
	# [483] opcode : dec "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_227 ], ":" => [ 9, \&_action_opcode_227 ], },
	# [484] opcode : dec "(" iy
	{ ")" => 485, "+" => 486, "-" => 489, },
	# [485] opcode : dec "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_228 ], ":" => [ 9, \&_action_opcode_228 ], },
	# [486] opcode : dec "(" iy "+"
	{ "!" => [ 14, 487 ], "+" => [ 14, 487 ], "-" => [ 14, 487 ], __else__ => [ 14, 487 ], "~" => [ 14, 487 ], },
	# [487] opcode : dec "(" iy "+" "[expr_DIS]"
	{ ")" => 488, },
	# [488] opcode : dec "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_229 ], ":" => [ 9, \&_action_opcode_229 ], },
	# [489] opcode : dec "(" iy "-"
	{ "!" => [ 16, 490 ], "+" => [ 16, 490 ], "-" => [ 16, 490 ], __else__ => [ 16, 490 ], "~" => [ 16, 490 ], },
	# [490] opcode : dec "(" iy "-" "[expr_NDIS]"
	{ ")" => 491, },
	# [491] opcode : dec "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_229 ], ":" => [ 9, \&_action_opcode_229 ], },
	# [492] opcode : dec a
	{ "\n" => [ 9, \&_action_opcode_230 ], ":" => [ 9, \&_action_opcode_230 ], },
	# [493] opcode : dec b
	{ "\n" => [ 9, \&_action_opcode_231 ], ":" => [ 9, \&_action_opcode_231 ], },
	# [494] opcode : dec bc
	{ "\n" => [ 9, \&_action_opcode_232 ], ":" => [ 9, \&_action_opcode_232 ], },
	# [495] opcode : dec c
	{ "\n" => [ 9, \&_action_opcode_233 ], ":" => [ 9, \&_action_opcode_233 ], },
	# [496] opcode : dec d
	{ "\n" => [ 9, \&_action_opcode_234 ], ":" => [ 9, \&_action_opcode_234 ], },
	# [497] opcode : dec de
	{ "\n" => [ 9, \&_action_opcode_235 ], ":" => [ 9, \&_action_opcode_235 ], },
	# [498] opcode : dec e
	{ "\n" => [ 9, \&_action_opcode_236 ], ":" => [ 9, \&_action_opcode_236 ], },
	# [499] opcode : dec h
	{ "\n" => [ 9, \&_action_opcode_237 ], ":" => [ 9, \&_action_opcode_237 ], },
	# [500] opcode : dec hl
	{ "\n" => [ 9, \&_action_opcode_238 ], ":" => [ 9, \&_action_opcode_238 ], },
	# [501] opcode : dec ix
	{ "\n" => [ 9, \&_action_opcode_239 ], ":" => [ 9, \&_action_opcode_239 ], },
	# [502] opcode : dec ixh
	{ "\n" => [ 9, \&_action_opcode_240 ], ":" => [ 9, \&_action_opcode_240 ], },
	# [503] opcode : dec ixl
	{ "\n" => [ 9, \&_action_opcode_241 ], ":" => [ 9, \&_action_opcode_241 ], },
	# [504] opcode : dec iy
	{ "\n" => [ 9, \&_action_opcode_242 ], ":" => [ 9, \&_action_opcode_242 ], },
	# [505] opcode : dec iyh
	{ "\n" => [ 9, \&_action_opcode_243 ], ":" => [ 9, \&_action_opcode_243 ], },
	# [506] opcode : dec iyl
	{ "\n" => [ 9, \&_action_opcode_244 ], ":" => [ 9, \&_action_opcode_244 ], },
	# [507] opcode : dec l
	{ "\n" => [ 9, \&_action_opcode_245 ], ":" => [ 9, \&_action_opcode_245 ], },
	# [508] opcode : dec sp
	{ "\n" => [ 9, \&_action_opcode_246 ], ":" => [ 9, \&_action_opcode_246 ], },
	# [509] opcode : defb
	{ "!" => [ 21, 510 ], "+" => [ 21, 510 ], "-" => [ 21, 510 ], __else__ => [ 21, 510 ], "~" => [ 21, 510 ], },
	# [510] opcode : defb "[expr_list_N]"
	{ "\n" => [ 9, \&_action_opcode_21 ], ":" => [ 9, \&_action_opcode_21 ], },
	# [511] opcode : defm
	{ NUMBER => [ 23, 512 ], STRING => [ 23, 512 ], },
	# [512] opcode : defm "[expr_list_text]"
	{ "\n" => [ 9, \&_action_opcode_21 ], ":" => [ 9, \&_action_opcode_21 ], },
	# [513] opcode : defm7
	{ NUMBER => [ 25, 514 ], STRING => [ 25, 514 ], },
	# [514] opcode : defm7 "[expr_list_text7]"
	{ "\n" => [ 9, \&_action_opcode_21 ], ":" => [ 9, \&_action_opcode_21 ], },
	# [515] opcode : defmz
	{ NUMBER => [ 27, 516 ], STRING => [ 27, 516 ], },
	# [516] opcode : defmz "[expr_list_textz]"
	{ "\n" => [ 9, \&_action_opcode_21 ], ":" => [ 9, \&_action_opcode_21 ], },
	# [517] opcode : deft
	{ NUMBER => [ 23, 518 ], STRING => [ 23, 518 ], },
	# [518] opcode : deft "[expr_list_text]"
	{ "\n" => [ 9, \&_action_opcode_21 ], ":" => [ 9, \&_action_opcode_21 ], },
	# [519] opcode : defw
	{ "!" => [ 22, 520 ], "+" => [ 22, 520 ], "-" => [ 22, 520 ], __else__ => [ 22, 520 ], "~" => [ 22, 520 ], },
	# [520] opcode : defw "[expr_list_NN]"
	{ "\n" => [ 9, \&_action_opcode_21 ], ":" => [ 9, \&_action_opcode_21 ], },
	# [521] opcode : di
	{ "\n" => [ 9, \&_action_opcode_247 ], ":" => [ 9, \&_action_opcode_247 ], },
	# [522] opcode : djnz
	{ "!" => [ 17, 523 ], "+" => [ 17, 523 ], "-" => [ 17, 523 ], __else__ => [ 17, 523 ], "~" => [ 17, 523 ], },
	# [523] opcode : djnz "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_248 ], ":" => [ 9, \&_action_opcode_248 ], },
	# [524] opcode : ei
	{ "\n" => [ 9, \&_action_opcode_249 ], ":" => [ 9, \&_action_opcode_249 ], },
	# [525] opcode : ex
	{ "(" => 526, af => 533, de => 536, },
	# [526] opcode : ex "("
	{ sp => 527, },
	# [527] opcode : ex "(" sp
	{ ")" => 528, },
	# [528] opcode : ex "(" sp ")"
	{ "," => 529, },
	# [529] opcode : ex "(" sp ")" ","
	{ hl => 530, ix => 531, iy => 532, },
	# [530] opcode : ex "(" sp ")" "," hl
	{ "\n" => [ 9, \&_action_opcode_250 ], ":" => [ 9, \&_action_opcode_250 ], },
	# [531] opcode : ex "(" sp ")" "," ix
	{ "\n" => [ 9, \&_action_opcode_251 ], ":" => [ 9, \&_action_opcode_251 ], },
	# [532] opcode : ex "(" sp ")" "," iy
	{ "\n" => [ 9, \&_action_opcode_252 ], ":" => [ 9, \&_action_opcode_252 ], },
	# [533] opcode : ex af
	{ "," => 534, },
	# [534] opcode : ex af ","
	{ "af'" => 535, },
	# [535] opcode : ex af "," "af'"
	{ "\n" => [ 9, \&_action_opcode_253 ], ":" => [ 9, \&_action_opcode_253 ], },
	# [536] opcode : ex de
	{ "," => 537, },
	# [537] opcode : ex de ","
	{ hl => 538, },
	# [538] opcode : ex de "," hl
	{ "\n" => [ 9, \&_action_opcode_254 ], ":" => [ 9, \&_action_opcode_254 ], },
	# [539] opcode : exx
	{ "\n" => [ 9, \&_action_opcode_255 ], ":" => [ 9, \&_action_opcode_255 ], },
	# [540] opcode : halt
	{ "\n" => [ 9, \&_action_opcode_256 ], ":" => [ 9, \&_action_opcode_256 ], },
	# [541] opcode : im
	{ "!" => [ 42, 542 ], "+" => [ 42, 542 ], "-" => [ 42, 542 ], __else__ => [ 42, 542 ], "~" => [ 42, 542 ], },
	# [542] opcode : im "[inline_const]"
	{ 0 => 543, 1 => 544, 2 => 545, },
	# [543] opcode : im "[inline_const]" 0
	{ "\n" => [ 9, \&_action_opcode_257 ], ":" => [ 9, \&_action_opcode_257 ], },
	# [544] opcode : im "[inline_const]" 1
	{ "\n" => [ 9, \&_action_opcode_258 ], ":" => [ 9, \&_action_opcode_258 ], },
	# [545] opcode : im "[inline_const]" 2
	{ "\n" => [ 9, \&_action_opcode_259 ], ":" => [ 9, \&_action_opcode_259 ], },
	# [546] opcode : in
	{ a => 547, b => 554, c => 559, d => 564, e => 569, f => 574, h => 579, l => 584, },
	# [547] opcode : in a
	{ "," => 548, },
	# [548] opcode : in a ","
	{ "(" => 549, },
	# [549] opcode : in a "," "("
	{ "!" => [ 15, 550 ], "+" => [ 15, 550 ], "-" => [ 15, 550 ], __else__ => [ 15, 550 ], c => 552, "~" => [ 15, 550 ], },
	# [550] opcode : in a "," "(" "[expr_N]"
	{ ")" => 551, },
	# [551] opcode : in a "," "(" "[expr_N]" ")"
	{ "\n" => [ 9, \&_action_opcode_260 ], ":" => [ 9, \&_action_opcode_260 ], },
	# [552] opcode : in a "," "(" c
	{ ")" => 553, },
	# [553] opcode : in a "," "(" c ")"
	{ "\n" => [ 9, \&_action_opcode_261 ], ":" => [ 9, \&_action_opcode_261 ], },
	# [554] opcode : in b
	{ "," => 555, },
	# [555] opcode : in b ","
	{ "(" => 556, },
	# [556] opcode : in b "," "("
	{ c => 557, },
	# [557] opcode : in b "," "(" c
	{ ")" => 558, },
	# [558] opcode : in b "," "(" c ")"
	{ "\n" => [ 9, \&_action_opcode_262 ], ":" => [ 9, \&_action_opcode_262 ], },
	# [559] opcode : in c
	{ "," => 560, },
	# [560] opcode : in c ","
	{ "(" => 561, },
	# [561] opcode : in c "," "("
	{ c => 562, },
	# [562] opcode : in c "," "(" c
	{ ")" => 563, },
	# [563] opcode : in c "," "(" c ")"
	{ "\n" => [ 9, \&_action_opcode_263 ], ":" => [ 9, \&_action_opcode_263 ], },
	# [564] opcode : in d
	{ "," => 565, },
	# [565] opcode : in d ","
	{ "(" => 566, },
	# [566] opcode : in d "," "("
	{ c => 567, },
	# [567] opcode : in d "," "(" c
	{ ")" => 568, },
	# [568] opcode : in d "," "(" c ")"
	{ "\n" => [ 9, \&_action_opcode_264 ], ":" => [ 9, \&_action_opcode_264 ], },
	# [569] opcode : in e
	{ "," => 570, },
	# [570] opcode : in e ","
	{ "(" => 571, },
	# [571] opcode : in e "," "("
	{ c => 572, },
	# [572] opcode : in e "," "(" c
	{ ")" => 573, },
	# [573] opcode : in e "," "(" c ")"
	{ "\n" => [ 9, \&_action_opcode_265 ], ":" => [ 9, \&_action_opcode_265 ], },
	# [574] opcode : in f
	{ "," => 575, },
	# [575] opcode : in f ","
	{ "(" => 576, },
	# [576] opcode : in f "," "("
	{ c => 577, },
	# [577] opcode : in f "," "(" c
	{ ")" => 578, },
	# [578] opcode : in f "," "(" c ")"
	{ "\n" => [ 9, \&_action_opcode_266 ], ":" => [ 9, \&_action_opcode_266 ], },
	# [579] opcode : in h
	{ "," => 580, },
	# [580] opcode : in h ","
	{ "(" => 581, },
	# [581] opcode : in h "," "("
	{ c => 582, },
	# [582] opcode : in h "," "(" c
	{ ")" => 583, },
	# [583] opcode : in h "," "(" c ")"
	{ "\n" => [ 9, \&_action_opcode_267 ], ":" => [ 9, \&_action_opcode_267 ], },
	# [584] opcode : in l
	{ "," => 585, },
	# [585] opcode : in l ","
	{ "(" => 586, },
	# [586] opcode : in l "," "("
	{ c => 587, },
	# [587] opcode : in l "," "(" c
	{ ")" => 588, },
	# [588] opcode : in l "," "(" c ")"
	{ "\n" => [ 9, \&_action_opcode_268 ], ":" => [ 9, \&_action_opcode_268 ], },
	# [589] opcode : inc
	{ "(" => 590, a => 609, b => 610, bc => 611, c => 612, d => 613, de => 614, e => 615, h => 616, hl => 617, ix => 618, ixh => 619, ixl => 620, iy => 621, iyh => 622, iyl => 623, l => 624, sp => 625, },
	# [590] opcode : inc "("
	{ hl => 591, ix => 593, iy => 601, },
	# [591] opcode : inc "(" hl
	{ ")" => 592, },
	# [592] opcode : inc "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_269 ], ":" => [ 9, \&_action_opcode_269 ], },
	# [593] opcode : inc "(" ix
	{ ")" => 594, "+" => 595, "-" => 598, },
	# [594] opcode : inc "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_270 ], ":" => [ 9, \&_action_opcode_270 ], },
	# [595] opcode : inc "(" ix "+"
	{ "!" => [ 14, 596 ], "+" => [ 14, 596 ], "-" => [ 14, 596 ], __else__ => [ 14, 596 ], "~" => [ 14, 596 ], },
	# [596] opcode : inc "(" ix "+" "[expr_DIS]"
	{ ")" => 597, },
	# [597] opcode : inc "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_271 ], ":" => [ 9, \&_action_opcode_271 ], },
	# [598] opcode : inc "(" ix "-"
	{ "!" => [ 16, 599 ], "+" => [ 16, 599 ], "-" => [ 16, 599 ], __else__ => [ 16, 599 ], "~" => [ 16, 599 ], },
	# [599] opcode : inc "(" ix "-" "[expr_NDIS]"
	{ ")" => 600, },
	# [600] opcode : inc "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_271 ], ":" => [ 9, \&_action_opcode_271 ], },
	# [601] opcode : inc "(" iy
	{ ")" => 602, "+" => 603, "-" => 606, },
	# [602] opcode : inc "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_272 ], ":" => [ 9, \&_action_opcode_272 ], },
	# [603] opcode : inc "(" iy "+"
	{ "!" => [ 14, 604 ], "+" => [ 14, 604 ], "-" => [ 14, 604 ], __else__ => [ 14, 604 ], "~" => [ 14, 604 ], },
	# [604] opcode : inc "(" iy "+" "[expr_DIS]"
	{ ")" => 605, },
	# [605] opcode : inc "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_273 ], ":" => [ 9, \&_action_opcode_273 ], },
	# [606] opcode : inc "(" iy "-"
	{ "!" => [ 16, 607 ], "+" => [ 16, 607 ], "-" => [ 16, 607 ], __else__ => [ 16, 607 ], "~" => [ 16, 607 ], },
	# [607] opcode : inc "(" iy "-" "[expr_NDIS]"
	{ ")" => 608, },
	# [608] opcode : inc "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_273 ], ":" => [ 9, \&_action_opcode_273 ], },
	# [609] opcode : inc a
	{ "\n" => [ 9, \&_action_opcode_274 ], ":" => [ 9, \&_action_opcode_274 ], },
	# [610] opcode : inc b
	{ "\n" => [ 9, \&_action_opcode_275 ], ":" => [ 9, \&_action_opcode_275 ], },
	# [611] opcode : inc bc
	{ "\n" => [ 9, \&_action_opcode_276 ], ":" => [ 9, \&_action_opcode_276 ], },
	# [612] opcode : inc c
	{ "\n" => [ 9, \&_action_opcode_277 ], ":" => [ 9, \&_action_opcode_277 ], },
	# [613] opcode : inc d
	{ "\n" => [ 9, \&_action_opcode_278 ], ":" => [ 9, \&_action_opcode_278 ], },
	# [614] opcode : inc de
	{ "\n" => [ 9, \&_action_opcode_279 ], ":" => [ 9, \&_action_opcode_279 ], },
	# [615] opcode : inc e
	{ "\n" => [ 9, \&_action_opcode_280 ], ":" => [ 9, \&_action_opcode_280 ], },
	# [616] opcode : inc h
	{ "\n" => [ 9, \&_action_opcode_281 ], ":" => [ 9, \&_action_opcode_281 ], },
	# [617] opcode : inc hl
	{ "\n" => [ 9, \&_action_opcode_282 ], ":" => [ 9, \&_action_opcode_282 ], },
	# [618] opcode : inc ix
	{ "\n" => [ 9, \&_action_opcode_283 ], ":" => [ 9, \&_action_opcode_283 ], },
	# [619] opcode : inc ixh
	{ "\n" => [ 9, \&_action_opcode_284 ], ":" => [ 9, \&_action_opcode_284 ], },
	# [620] opcode : inc ixl
	{ "\n" => [ 9, \&_action_opcode_285 ], ":" => [ 9, \&_action_opcode_285 ], },
	# [621] opcode : inc iy
	{ "\n" => [ 9, \&_action_opcode_286 ], ":" => [ 9, \&_action_opcode_286 ], },
	# [622] opcode : inc iyh
	{ "\n" => [ 9, \&_action_opcode_287 ], ":" => [ 9, \&_action_opcode_287 ], },
	# [623] opcode : inc iyl
	{ "\n" => [ 9, \&_action_opcode_288 ], ":" => [ 9, \&_action_opcode_288 ], },
	# [624] opcode : inc l
	{ "\n" => [ 9, \&_action_opcode_289 ], ":" => [ 9, \&_action_opcode_289 ], },
	# [625] opcode : inc sp
	{ "\n" => [ 9, \&_action_opcode_290 ], ":" => [ 9, \&_action_opcode_290 ], },
	# [626] opcode : ind
	{ "\n" => [ 9, \&_action_opcode_291 ], ":" => [ 9, \&_action_opcode_291 ], },
	# [627] opcode : indr
	{ "\n" => [ 9, \&_action_opcode_292 ], ":" => [ 9, \&_action_opcode_292 ], },
	# [628] opcode : ini
	{ "\n" => [ 9, \&_action_opcode_293 ], ":" => [ 9, \&_action_opcode_293 ], },
	# [629] opcode : inir
	{ "\n" => [ 9, \&_action_opcode_294 ], ":" => [ 9, \&_action_opcode_294 ], },
	# [630] opcode : jp
	{ "!" => [ 17, 638 ], "(" => 631, "+" => [ 17, 638 ], "-" => [ 17, 638 ], __else__ => [ 17, 638 ], c => 639, m => 642, nc => 645, nz => 648, p => 651, pe => 654, po => 657, z => 660, "~" => [ 17, 638 ], },
	# [631] opcode : jp "("
	{ hl => 632, ix => 634, iy => 636, },
	# [632] opcode : jp "(" hl
	{ ")" => 633, },
	# [633] opcode : jp "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_295 ], ":" => [ 9, \&_action_opcode_295 ], },
	# [634] opcode : jp "(" ix
	{ ")" => 635, },
	# [635] opcode : jp "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_296 ], ":" => [ 9, \&_action_opcode_296 ], },
	# [636] opcode : jp "(" iy
	{ ")" => 637, },
	# [637] opcode : jp "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_297 ], ":" => [ 9, \&_action_opcode_297 ], },
	# [638] opcode : jp "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_298 ], ":" => [ 9, \&_action_opcode_298 ], },
	# [639] opcode : jp c
	{ "," => 640, },
	# [640] opcode : jp c ","
	{ "!" => [ 17, 641 ], "+" => [ 17, 641 ], "-" => [ 17, 641 ], __else__ => [ 17, 641 ], "~" => [ 17, 641 ], },
	# [641] opcode : jp c "," "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_299 ], ":" => [ 9, \&_action_opcode_299 ], },
	# [642] opcode : jp m
	{ "," => 643, },
	# [643] opcode : jp m ","
	{ "!" => [ 17, 644 ], "+" => [ 17, 644 ], "-" => [ 17, 644 ], __else__ => [ 17, 644 ], "~" => [ 17, 644 ], },
	# [644] opcode : jp m "," "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_300 ], ":" => [ 9, \&_action_opcode_300 ], },
	# [645] opcode : jp nc
	{ "," => 646, },
	# [646] opcode : jp nc ","
	{ "!" => [ 17, 647 ], "+" => [ 17, 647 ], "-" => [ 17, 647 ], __else__ => [ 17, 647 ], "~" => [ 17, 647 ], },
	# [647] opcode : jp nc "," "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_301 ], ":" => [ 9, \&_action_opcode_301 ], },
	# [648] opcode : jp nz
	{ "," => 649, },
	# [649] opcode : jp nz ","
	{ "!" => [ 17, 650 ], "+" => [ 17, 650 ], "-" => [ 17, 650 ], __else__ => [ 17, 650 ], "~" => [ 17, 650 ], },
	# [650] opcode : jp nz "," "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_302 ], ":" => [ 9, \&_action_opcode_302 ], },
	# [651] opcode : jp p
	{ "," => 652, },
	# [652] opcode : jp p ","
	{ "!" => [ 17, 653 ], "+" => [ 17, 653 ], "-" => [ 17, 653 ], __else__ => [ 17, 653 ], "~" => [ 17, 653 ], },
	# [653] opcode : jp p "," "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_303 ], ":" => [ 9, \&_action_opcode_303 ], },
	# [654] opcode : jp pe
	{ "," => 655, },
	# [655] opcode : jp pe ","
	{ "!" => [ 17, 656 ], "+" => [ 17, 656 ], "-" => [ 17, 656 ], __else__ => [ 17, 656 ], "~" => [ 17, 656 ], },
	# [656] opcode : jp pe "," "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_304 ], ":" => [ 9, \&_action_opcode_304 ], },
	# [657] opcode : jp po
	{ "," => 658, },
	# [658] opcode : jp po ","
	{ "!" => [ 17, 659 ], "+" => [ 17, 659 ], "-" => [ 17, 659 ], __else__ => [ 17, 659 ], "~" => [ 17, 659 ], },
	# [659] opcode : jp po "," "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_305 ], ":" => [ 9, \&_action_opcode_305 ], },
	# [660] opcode : jp z
	{ "," => 661, },
	# [661] opcode : jp z ","
	{ "!" => [ 17, 662 ], "+" => [ 17, 662 ], "-" => [ 17, 662 ], __else__ => [ 17, 662 ], "~" => [ 17, 662 ], },
	# [662] opcode : jp z "," "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_306 ], ":" => [ 9, \&_action_opcode_306 ], },
	# [663] opcode : jr
	{ "!" => [ 17, 664 ], "+" => [ 17, 664 ], "-" => [ 17, 664 ], __else__ => [ 17, 664 ], c => 665, m => 668, nc => 671, nz => 674, p => 677, pe => 680, po => 683, z => 686, "~" => [ 17, 664 ], },
	# [664] opcode : jr "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_307 ], ":" => [ 9, \&_action_opcode_307 ], },
	# [665] opcode : jr c
	{ "," => 666, },
	# [666] opcode : jr c ","
	{ "!" => [ 17, 667 ], "+" => [ 17, 667 ], "-" => [ 17, 667 ], __else__ => [ 17, 667 ], "~" => [ 17, 667 ], },
	# [667] opcode : jr c "," "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_308 ], ":" => [ 9, \&_action_opcode_308 ], },
	# [668] opcode : jr m
	{ "," => 669, },
	# [669] opcode : jr m ","
	{ "!" => [ 17, 670 ], "+" => [ 17, 670 ], "-" => [ 17, 670 ], __else__ => [ 17, 670 ], "~" => [ 17, 670 ], },
	# [670] opcode : jr m "," "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_309 ], ":" => [ 9, \&_action_opcode_309 ], },
	# [671] opcode : jr nc
	{ "," => 672, },
	# [672] opcode : jr nc ","
	{ "!" => [ 17, 673 ], "+" => [ 17, 673 ], "-" => [ 17, 673 ], __else__ => [ 17, 673 ], "~" => [ 17, 673 ], },
	# [673] opcode : jr nc "," "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_310 ], ":" => [ 9, \&_action_opcode_310 ], },
	# [674] opcode : jr nz
	{ "," => 675, },
	# [675] opcode : jr nz ","
	{ "!" => [ 17, 676 ], "+" => [ 17, 676 ], "-" => [ 17, 676 ], __else__ => [ 17, 676 ], "~" => [ 17, 676 ], },
	# [676] opcode : jr nz "," "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_311 ], ":" => [ 9, \&_action_opcode_311 ], },
	# [677] opcode : jr p
	{ "," => 678, },
	# [678] opcode : jr p ","
	{ "!" => [ 17, 679 ], "+" => [ 17, 679 ], "-" => [ 17, 679 ], __else__ => [ 17, 679 ], "~" => [ 17, 679 ], },
	# [679] opcode : jr p "," "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_312 ], ":" => [ 9, \&_action_opcode_312 ], },
	# [680] opcode : jr pe
	{ "," => 681, },
	# [681] opcode : jr pe ","
	{ "!" => [ 17, 682 ], "+" => [ 17, 682 ], "-" => [ 17, 682 ], __else__ => [ 17, 682 ], "~" => [ 17, 682 ], },
	# [682] opcode : jr pe "," "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_313 ], ":" => [ 9, \&_action_opcode_313 ], },
	# [683] opcode : jr po
	{ "," => 684, },
	# [684] opcode : jr po ","
	{ "!" => [ 17, 685 ], "+" => [ 17, 685 ], "-" => [ 17, 685 ], __else__ => [ 17, 685 ], "~" => [ 17, 685 ], },
	# [685] opcode : jr po "," "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_314 ], ":" => [ 9, \&_action_opcode_314 ], },
	# [686] opcode : jr z
	{ "," => 687, },
	# [687] opcode : jr z ","
	{ "!" => [ 17, 688 ], "+" => [ 17, 688 ], "-" => [ 17, 688 ], __else__ => [ 17, 688 ], "~" => [ 17, 688 ], },
	# [688] opcode : jr z "," "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_315 ], ":" => [ 9, \&_action_opcode_315 ], },
	# [689] opcode : ld
	{ "(" => 690, a => 810, b => 851, bc => 884, c => 913, d => 946, de => 979, e => 1008, h => 1041, hl => 1070, i => 1097, ix => 1100, ixh => 1111, ixl => 1121, iy => 1131, iyh => 1142, iyl => 1152, l => 1162, r => 1191, sp => 1194, },
	# [690] opcode : ld "("
	{ "!" => [ 17, 691 ], "+" => [ 17, 691 ], "-" => [ 17, 691 ], __else__ => [ 17, 691 ], bc => 701, de => 705, hl => 709, ix => 722, iy => 766, "~" => [ 17, 691 ], },
	# [691] opcode : ld "(" "[expr_NN]"
	{ ")" => 692, },
	# [692] opcode : ld "(" "[expr_NN]" ")"
	{ "," => 693, },
	# [693] opcode : ld "(" "[expr_NN]" ")" ","
	{ a => 694, bc => 695, de => 696, hl => 697, ix => 698, iy => 699, sp => 700, },
	# [694] opcode : ld "(" "[expr_NN]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_316 ], ":" => [ 9, \&_action_opcode_316 ], },
	# [695] opcode : ld "(" "[expr_NN]" ")" "," bc
	{ "\n" => [ 9, \&_action_opcode_317 ], ":" => [ 9, \&_action_opcode_317 ], },
	# [696] opcode : ld "(" "[expr_NN]" ")" "," de
	{ "\n" => [ 9, \&_action_opcode_318 ], ":" => [ 9, \&_action_opcode_318 ], },
	# [697] opcode : ld "(" "[expr_NN]" ")" "," hl
	{ "\n" => [ 9, \&_action_opcode_319 ], ":" => [ 9, \&_action_opcode_319 ], },
	# [698] opcode : ld "(" "[expr_NN]" ")" "," ix
	{ "\n" => [ 9, \&_action_opcode_320 ], ":" => [ 9, \&_action_opcode_320 ], },
	# [699] opcode : ld "(" "[expr_NN]" ")" "," iy
	{ "\n" => [ 9, \&_action_opcode_321 ], ":" => [ 9, \&_action_opcode_321 ], },
	# [700] opcode : ld "(" "[expr_NN]" ")" "," sp
	{ "\n" => [ 9, \&_action_opcode_322 ], ":" => [ 9, \&_action_opcode_322 ], },
	# [701] opcode : ld "(" bc
	{ ")" => 702, },
	# [702] opcode : ld "(" bc ")"
	{ "," => 703, },
	# [703] opcode : ld "(" bc ")" ","
	{ a => 704, },
	# [704] opcode : ld "(" bc ")" "," a
	{ "\n" => [ 9, \&_action_opcode_323 ], ":" => [ 9, \&_action_opcode_323 ], },
	# [705] opcode : ld "(" de
	{ ")" => 706, },
	# [706] opcode : ld "(" de ")"
	{ "," => 707, },
	# [707] opcode : ld "(" de ")" ","
	{ a => 708, },
	# [708] opcode : ld "(" de ")" "," a
	{ "\n" => [ 9, \&_action_opcode_324 ], ":" => [ 9, \&_action_opcode_324 ], },
	# [709] opcode : ld "(" hl
	{ ")" => 710, },
	# [710] opcode : ld "(" hl ")"
	{ "," => 711, },
	# [711] opcode : ld "(" hl ")" ","
	{ "!" => [ 15, 712 ], "+" => [ 15, 712 ], "-" => [ 15, 712 ], __else__ => [ 15, 712 ], a => 713, b => 714, bc => 715, c => 716, d => 717, de => 718, e => 719, h => 720, l => 721, "~" => [ 15, 712 ], },
	# [712] opcode : ld "(" hl ")" "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_325 ], ":" => [ 9, \&_action_opcode_325 ], },
	# [713] opcode : ld "(" hl ")" "," a
	{ "\n" => [ 9, \&_action_opcode_326 ], ":" => [ 9, \&_action_opcode_326 ], },
	# [714] opcode : ld "(" hl ")" "," b
	{ "\n" => [ 9, \&_action_opcode_327 ], ":" => [ 9, \&_action_opcode_327 ], },
	# [715] opcode : ld "(" hl ")" "," bc
	{ "\n" => [ 9, \&_action_opcode_328 ], ":" => [ 9, \&_action_opcode_328 ], },
	# [716] opcode : ld "(" hl ")" "," c
	{ "\n" => [ 9, \&_action_opcode_329 ], ":" => [ 9, \&_action_opcode_329 ], },
	# [717] opcode : ld "(" hl ")" "," d
	{ "\n" => [ 9, \&_action_opcode_330 ], ":" => [ 9, \&_action_opcode_330 ], },
	# [718] opcode : ld "(" hl ")" "," de
	{ "\n" => [ 9, \&_action_opcode_331 ], ":" => [ 9, \&_action_opcode_331 ], },
	# [719] opcode : ld "(" hl ")" "," e
	{ "\n" => [ 9, \&_action_opcode_332 ], ":" => [ 9, \&_action_opcode_332 ], },
	# [720] opcode : ld "(" hl ")" "," h
	{ "\n" => [ 9, \&_action_opcode_333 ], ":" => [ 9, \&_action_opcode_333 ], },
	# [721] opcode : ld "(" hl ")" "," l
	{ "\n" => [ 9, \&_action_opcode_334 ], ":" => [ 9, \&_action_opcode_334 ], },
	# [722] opcode : ld "(" ix
	{ ")" => 723, "+" => 736, "-" => 751, },
	# [723] opcode : ld "(" ix ")"
	{ "," => 724, },
	# [724] opcode : ld "(" ix ")" ","
	{ "!" => [ 15, 725 ], "+" => [ 15, 725 ], "-" => [ 15, 725 ], __else__ => [ 15, 725 ], a => 726, b => 727, bc => 728, c => 729, d => 730, de => 731, e => 732, h => 733, hl => 734, l => 735, "~" => [ 15, 725 ], },
	# [725] opcode : ld "(" ix ")" "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_335 ], ":" => [ 9, \&_action_opcode_335 ], },
	# [726] opcode : ld "(" ix ")" "," a
	{ "\n" => [ 9, \&_action_opcode_336 ], ":" => [ 9, \&_action_opcode_336 ], },
	# [727] opcode : ld "(" ix ")" "," b
	{ "\n" => [ 9, \&_action_opcode_337 ], ":" => [ 9, \&_action_opcode_337 ], },
	# [728] opcode : ld "(" ix ")" "," bc
	{ "\n" => [ 9, \&_action_opcode_338 ], ":" => [ 9, \&_action_opcode_338 ], },
	# [729] opcode : ld "(" ix ")" "," c
	{ "\n" => [ 9, \&_action_opcode_339 ], ":" => [ 9, \&_action_opcode_339 ], },
	# [730] opcode : ld "(" ix ")" "," d
	{ "\n" => [ 9, \&_action_opcode_340 ], ":" => [ 9, \&_action_opcode_340 ], },
	# [731] opcode : ld "(" ix ")" "," de
	{ "\n" => [ 9, \&_action_opcode_341 ], ":" => [ 9, \&_action_opcode_341 ], },
	# [732] opcode : ld "(" ix ")" "," e
	{ "\n" => [ 9, \&_action_opcode_342 ], ":" => [ 9, \&_action_opcode_342 ], },
	# [733] opcode : ld "(" ix ")" "," h
	{ "\n" => [ 9, \&_action_opcode_343 ], ":" => [ 9, \&_action_opcode_343 ], },
	# [734] opcode : ld "(" ix ")" "," hl
	{ "\n" => [ 9, \&_action_opcode_344 ], ":" => [ 9, \&_action_opcode_344 ], },
	# [735] opcode : ld "(" ix ")" "," l
	{ "\n" => [ 9, \&_action_opcode_345 ], ":" => [ 9, \&_action_opcode_345 ], },
	# [736] opcode : ld "(" ix "+"
	{ "!" => [ 14, 737 ], "+" => [ 14, 737 ], "-" => [ 14, 737 ], __else__ => [ 14, 737 ], "~" => [ 14, 737 ], },
	# [737] opcode : ld "(" ix "+" "[expr_DIS]"
	{ ")" => 738, },
	# [738] opcode : ld "(" ix "+" "[expr_DIS]" ")"
	{ "," => 739, },
	# [739] opcode : ld "(" ix "+" "[expr_DIS]" ")" ","
	{ "!" => [ 15, 740 ], "+" => [ 15, 740 ], "-" => [ 15, 740 ], __else__ => [ 15, 740 ], a => 741, b => 742, bc => 743, c => 744, d => 745, de => 746, e => 747, h => 748, hl => 749, l => 750, "~" => [ 15, 740 ], },
	# [740] opcode : ld "(" ix "+" "[expr_DIS]" ")" "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_346 ], ":" => [ 9, \&_action_opcode_346 ], },
	# [741] opcode : ld "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_347 ], ":" => [ 9, \&_action_opcode_347 ], },
	# [742] opcode : ld "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_348 ], ":" => [ 9, \&_action_opcode_348 ], },
	# [743] opcode : ld "(" ix "+" "[expr_DIS]" ")" "," bc
	{ "\n" => [ 9, \&_action_opcode_349 ], ":" => [ 9, \&_action_opcode_349 ], },
	# [744] opcode : ld "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_350 ], ":" => [ 9, \&_action_opcode_350 ], },
	# [745] opcode : ld "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_351 ], ":" => [ 9, \&_action_opcode_351 ], },
	# [746] opcode : ld "(" ix "+" "[expr_DIS]" ")" "," de
	{ "\n" => [ 9, \&_action_opcode_352 ], ":" => [ 9, \&_action_opcode_352 ], },
	# [747] opcode : ld "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_353 ], ":" => [ 9, \&_action_opcode_353 ], },
	# [748] opcode : ld "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_354 ], ":" => [ 9, \&_action_opcode_354 ], },
	# [749] opcode : ld "(" ix "+" "[expr_DIS]" ")" "," hl
	{ "\n" => [ 9, \&_action_opcode_355 ], ":" => [ 9, \&_action_opcode_355 ], },
	# [750] opcode : ld "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_356 ], ":" => [ 9, \&_action_opcode_356 ], },
	# [751] opcode : ld "(" ix "-"
	{ "!" => [ 16, 752 ], "+" => [ 16, 752 ], "-" => [ 16, 752 ], __else__ => [ 16, 752 ], "~" => [ 16, 752 ], },
	# [752] opcode : ld "(" ix "-" "[expr_NDIS]"
	{ ")" => 753, },
	# [753] opcode : ld "(" ix "-" "[expr_NDIS]" ")"
	{ "," => 754, },
	# [754] opcode : ld "(" ix "-" "[expr_NDIS]" ")" ","
	{ "!" => [ 15, 755 ], "+" => [ 15, 755 ], "-" => [ 15, 755 ], __else__ => [ 15, 755 ], a => 756, b => 757, bc => 758, c => 759, d => 760, de => 761, e => 762, h => 763, hl => 764, l => 765, "~" => [ 15, 755 ], },
	# [755] opcode : ld "(" ix "-" "[expr_NDIS]" ")" "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_346 ], ":" => [ 9, \&_action_opcode_346 ], },
	# [756] opcode : ld "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_347 ], ":" => [ 9, \&_action_opcode_347 ], },
	# [757] opcode : ld "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_348 ], ":" => [ 9, \&_action_opcode_348 ], },
	# [758] opcode : ld "(" ix "-" "[expr_NDIS]" ")" "," bc
	{ "\n" => [ 9, \&_action_opcode_349 ], ":" => [ 9, \&_action_opcode_349 ], },
	# [759] opcode : ld "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_350 ], ":" => [ 9, \&_action_opcode_350 ], },
	# [760] opcode : ld "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_351 ], ":" => [ 9, \&_action_opcode_351 ], },
	# [761] opcode : ld "(" ix "-" "[expr_NDIS]" ")" "," de
	{ "\n" => [ 9, \&_action_opcode_352 ], ":" => [ 9, \&_action_opcode_352 ], },
	# [762] opcode : ld "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_353 ], ":" => [ 9, \&_action_opcode_353 ], },
	# [763] opcode : ld "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_354 ], ":" => [ 9, \&_action_opcode_354 ], },
	# [764] opcode : ld "(" ix "-" "[expr_NDIS]" ")" "," hl
	{ "\n" => [ 9, \&_action_opcode_355 ], ":" => [ 9, \&_action_opcode_355 ], },
	# [765] opcode : ld "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_356 ], ":" => [ 9, \&_action_opcode_356 ], },
	# [766] opcode : ld "(" iy
	{ ")" => 767, "+" => 780, "-" => 795, },
	# [767] opcode : ld "(" iy ")"
	{ "," => 768, },
	# [768] opcode : ld "(" iy ")" ","
	{ "!" => [ 15, 769 ], "+" => [ 15, 769 ], "-" => [ 15, 769 ], __else__ => [ 15, 769 ], a => 770, b => 771, bc => 772, c => 773, d => 774, de => 775, e => 776, h => 777, hl => 778, l => 779, "~" => [ 15, 769 ], },
	# [769] opcode : ld "(" iy ")" "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_357 ], ":" => [ 9, \&_action_opcode_357 ], },
	# [770] opcode : ld "(" iy ")" "," a
	{ "\n" => [ 9, \&_action_opcode_358 ], ":" => [ 9, \&_action_opcode_358 ], },
	# [771] opcode : ld "(" iy ")" "," b
	{ "\n" => [ 9, \&_action_opcode_359 ], ":" => [ 9, \&_action_opcode_359 ], },
	# [772] opcode : ld "(" iy ")" "," bc
	{ "\n" => [ 9, \&_action_opcode_360 ], ":" => [ 9, \&_action_opcode_360 ], },
	# [773] opcode : ld "(" iy ")" "," c
	{ "\n" => [ 9, \&_action_opcode_361 ], ":" => [ 9, \&_action_opcode_361 ], },
	# [774] opcode : ld "(" iy ")" "," d
	{ "\n" => [ 9, \&_action_opcode_362 ], ":" => [ 9, \&_action_opcode_362 ], },
	# [775] opcode : ld "(" iy ")" "," de
	{ "\n" => [ 9, \&_action_opcode_363 ], ":" => [ 9, \&_action_opcode_363 ], },
	# [776] opcode : ld "(" iy ")" "," e
	{ "\n" => [ 9, \&_action_opcode_364 ], ":" => [ 9, \&_action_opcode_364 ], },
	# [777] opcode : ld "(" iy ")" "," h
	{ "\n" => [ 9, \&_action_opcode_365 ], ":" => [ 9, \&_action_opcode_365 ], },
	# [778] opcode : ld "(" iy ")" "," hl
	{ "\n" => [ 9, \&_action_opcode_366 ], ":" => [ 9, \&_action_opcode_366 ], },
	# [779] opcode : ld "(" iy ")" "," l
	{ "\n" => [ 9, \&_action_opcode_367 ], ":" => [ 9, \&_action_opcode_367 ], },
	# [780] opcode : ld "(" iy "+"
	{ "!" => [ 14, 781 ], "+" => [ 14, 781 ], "-" => [ 14, 781 ], __else__ => [ 14, 781 ], "~" => [ 14, 781 ], },
	# [781] opcode : ld "(" iy "+" "[expr_DIS]"
	{ ")" => 782, },
	# [782] opcode : ld "(" iy "+" "[expr_DIS]" ")"
	{ "," => 783, },
	# [783] opcode : ld "(" iy "+" "[expr_DIS]" ")" ","
	{ "!" => [ 15, 784 ], "+" => [ 15, 784 ], "-" => [ 15, 784 ], __else__ => [ 15, 784 ], a => 785, b => 786, bc => 787, c => 788, d => 789, de => 790, e => 791, h => 792, hl => 793, l => 794, "~" => [ 15, 784 ], },
	# [784] opcode : ld "(" iy "+" "[expr_DIS]" ")" "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_368 ], ":" => [ 9, \&_action_opcode_368 ], },
	# [785] opcode : ld "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_369 ], ":" => [ 9, \&_action_opcode_369 ], },
	# [786] opcode : ld "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_370 ], ":" => [ 9, \&_action_opcode_370 ], },
	# [787] opcode : ld "(" iy "+" "[expr_DIS]" ")" "," bc
	{ "\n" => [ 9, \&_action_opcode_371 ], ":" => [ 9, \&_action_opcode_371 ], },
	# [788] opcode : ld "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_372 ], ":" => [ 9, \&_action_opcode_372 ], },
	# [789] opcode : ld "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_373 ], ":" => [ 9, \&_action_opcode_373 ], },
	# [790] opcode : ld "(" iy "+" "[expr_DIS]" ")" "," de
	{ "\n" => [ 9, \&_action_opcode_374 ], ":" => [ 9, \&_action_opcode_374 ], },
	# [791] opcode : ld "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_375 ], ":" => [ 9, \&_action_opcode_375 ], },
	# [792] opcode : ld "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_376 ], ":" => [ 9, \&_action_opcode_376 ], },
	# [793] opcode : ld "(" iy "+" "[expr_DIS]" ")" "," hl
	{ "\n" => [ 9, \&_action_opcode_377 ], ":" => [ 9, \&_action_opcode_377 ], },
	# [794] opcode : ld "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_378 ], ":" => [ 9, \&_action_opcode_378 ], },
	# [795] opcode : ld "(" iy "-"
	{ "!" => [ 16, 796 ], "+" => [ 16, 796 ], "-" => [ 16, 796 ], __else__ => [ 16, 796 ], "~" => [ 16, 796 ], },
	# [796] opcode : ld "(" iy "-" "[expr_NDIS]"
	{ ")" => 797, },
	# [797] opcode : ld "(" iy "-" "[expr_NDIS]" ")"
	{ "," => 798, },
	# [798] opcode : ld "(" iy "-" "[expr_NDIS]" ")" ","
	{ "!" => [ 15, 799 ], "+" => [ 15, 799 ], "-" => [ 15, 799 ], __else__ => [ 15, 799 ], a => 800, b => 801, bc => 802, c => 803, d => 804, de => 805, e => 806, h => 807, hl => 808, l => 809, "~" => [ 15, 799 ], },
	# [799] opcode : ld "(" iy "-" "[expr_NDIS]" ")" "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_368 ], ":" => [ 9, \&_action_opcode_368 ], },
	# [800] opcode : ld "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_369 ], ":" => [ 9, \&_action_opcode_369 ], },
	# [801] opcode : ld "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_370 ], ":" => [ 9, \&_action_opcode_370 ], },
	# [802] opcode : ld "(" iy "-" "[expr_NDIS]" ")" "," bc
	{ "\n" => [ 9, \&_action_opcode_371 ], ":" => [ 9, \&_action_opcode_371 ], },
	# [803] opcode : ld "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_372 ], ":" => [ 9, \&_action_opcode_372 ], },
	# [804] opcode : ld "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_373 ], ":" => [ 9, \&_action_opcode_373 ], },
	# [805] opcode : ld "(" iy "-" "[expr_NDIS]" ")" "," de
	{ "\n" => [ 9, \&_action_opcode_374 ], ":" => [ 9, \&_action_opcode_374 ], },
	# [806] opcode : ld "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_375 ], ":" => [ 9, \&_action_opcode_375 ], },
	# [807] opcode : ld "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_376 ], ":" => [ 9, \&_action_opcode_376 ], },
	# [808] opcode : ld "(" iy "-" "[expr_NDIS]" ")" "," hl
	{ "\n" => [ 9, \&_action_opcode_377 ], ":" => [ 9, \&_action_opcode_377 ], },
	# [809] opcode : ld "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_378 ], ":" => [ 9, \&_action_opcode_378 ], },
	# [810] opcode : ld a
	{ "," => 811, },
	# [811] opcode : ld a ","
	{ "!" => [ 15, 837 ], "(" => 812, "+" => [ 15, 837 ], "-" => [ 15, 837 ], __else__ => [ 15, 837 ], a => 838, b => 839, c => 840, d => 841, e => 842, h => 843, i => 844, ixh => 845, ixl => 846, iyh => 847, iyl => 848, l => 849, r => 850, "~" => [ 15, 837 ], },
	# [812] opcode : ld a "," "("
	{ "!" => [ 17, 813 ], "+" => [ 17, 813 ], "-" => [ 17, 813 ], __else__ => [ 17, 813 ], bc => 815, de => 817, hl => 819, ix => 821, iy => 829, "~" => [ 17, 813 ], },
	# [813] opcode : ld a "," "(" "[expr_NN]"
	{ ")" => 814, },
	# [814] opcode : ld a "," "(" "[expr_NN]" ")"
	{ "\n" => [ 9, \&_action_opcode_379 ], ":" => [ 9, \&_action_opcode_379 ], },
	# [815] opcode : ld a "," "(" bc
	{ ")" => 816, },
	# [816] opcode : ld a "," "(" bc ")"
	{ "\n" => [ 9, \&_action_opcode_380 ], ":" => [ 9, \&_action_opcode_380 ], },
	# [817] opcode : ld a "," "(" de
	{ ")" => 818, },
	# [818] opcode : ld a "," "(" de ")"
	{ "\n" => [ 9, \&_action_opcode_381 ], ":" => [ 9, \&_action_opcode_381 ], },
	# [819] opcode : ld a "," "(" hl
	{ ")" => 820, },
	# [820] opcode : ld a "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_382 ], ":" => [ 9, \&_action_opcode_382 ], },
	# [821] opcode : ld a "," "(" ix
	{ ")" => 822, "+" => 823, "-" => 826, },
	# [822] opcode : ld a "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_383 ], ":" => [ 9, \&_action_opcode_383 ], },
	# [823] opcode : ld a "," "(" ix "+"
	{ "!" => [ 14, 824 ], "+" => [ 14, 824 ], "-" => [ 14, 824 ], __else__ => [ 14, 824 ], "~" => [ 14, 824 ], },
	# [824] opcode : ld a "," "(" ix "+" "[expr_DIS]"
	{ ")" => 825, },
	# [825] opcode : ld a "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_384 ], ":" => [ 9, \&_action_opcode_384 ], },
	# [826] opcode : ld a "," "(" ix "-"
	{ "!" => [ 16, 827 ], "+" => [ 16, 827 ], "-" => [ 16, 827 ], __else__ => [ 16, 827 ], "~" => [ 16, 827 ], },
	# [827] opcode : ld a "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 828, },
	# [828] opcode : ld a "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_384 ], ":" => [ 9, \&_action_opcode_384 ], },
	# [829] opcode : ld a "," "(" iy
	{ ")" => 830, "+" => 831, "-" => 834, },
	# [830] opcode : ld a "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_385 ], ":" => [ 9, \&_action_opcode_385 ], },
	# [831] opcode : ld a "," "(" iy "+"
	{ "!" => [ 14, 832 ], "+" => [ 14, 832 ], "-" => [ 14, 832 ], __else__ => [ 14, 832 ], "~" => [ 14, 832 ], },
	# [832] opcode : ld a "," "(" iy "+" "[expr_DIS]"
	{ ")" => 833, },
	# [833] opcode : ld a "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_386 ], ":" => [ 9, \&_action_opcode_386 ], },
	# [834] opcode : ld a "," "(" iy "-"
	{ "!" => [ 16, 835 ], "+" => [ 16, 835 ], "-" => [ 16, 835 ], __else__ => [ 16, 835 ], "~" => [ 16, 835 ], },
	# [835] opcode : ld a "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 836, },
	# [836] opcode : ld a "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_386 ], ":" => [ 9, \&_action_opcode_386 ], },
	# [837] opcode : ld a "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_387 ], ":" => [ 9, \&_action_opcode_387 ], },
	# [838] opcode : ld a "," a
	{ "\n" => [ 9, \&_action_opcode_388 ], ":" => [ 9, \&_action_opcode_388 ], },
	# [839] opcode : ld a "," b
	{ "\n" => [ 9, \&_action_opcode_389 ], ":" => [ 9, \&_action_opcode_389 ], },
	# [840] opcode : ld a "," c
	{ "\n" => [ 9, \&_action_opcode_390 ], ":" => [ 9, \&_action_opcode_390 ], },
	# [841] opcode : ld a "," d
	{ "\n" => [ 9, \&_action_opcode_391 ], ":" => [ 9, \&_action_opcode_391 ], },
	# [842] opcode : ld a "," e
	{ "\n" => [ 9, \&_action_opcode_392 ], ":" => [ 9, \&_action_opcode_392 ], },
	# [843] opcode : ld a "," h
	{ "\n" => [ 9, \&_action_opcode_393 ], ":" => [ 9, \&_action_opcode_393 ], },
	# [844] opcode : ld a "," i
	{ "\n" => [ 9, \&_action_opcode_394 ], ":" => [ 9, \&_action_opcode_394 ], },
	# [845] opcode : ld a "," ixh
	{ "\n" => [ 9, \&_action_opcode_395 ], ":" => [ 9, \&_action_opcode_395 ], },
	# [846] opcode : ld a "," ixl
	{ "\n" => [ 9, \&_action_opcode_396 ], ":" => [ 9, \&_action_opcode_396 ], },
	# [847] opcode : ld a "," iyh
	{ "\n" => [ 9, \&_action_opcode_397 ], ":" => [ 9, \&_action_opcode_397 ], },
	# [848] opcode : ld a "," iyl
	{ "\n" => [ 9, \&_action_opcode_398 ], ":" => [ 9, \&_action_opcode_398 ], },
	# [849] opcode : ld a "," l
	{ "\n" => [ 9, \&_action_opcode_399 ], ":" => [ 9, \&_action_opcode_399 ], },
	# [850] opcode : ld a "," r
	{ "\n" => [ 9, \&_action_opcode_400 ], ":" => [ 9, \&_action_opcode_400 ], },
	# [851] opcode : ld b
	{ "," => 852, },
	# [852] opcode : ld b ","
	{ "!" => [ 15, 872 ], "(" => 853, "+" => [ 15, 872 ], "-" => [ 15, 872 ], __else__ => [ 15, 872 ], a => 873, b => 874, c => 875, d => 876, e => 877, h => 878, ixh => 879, ixl => 880, iyh => 881, iyl => 882, l => 883, "~" => [ 15, 872 ], },
	# [853] opcode : ld b "," "("
	{ hl => 854, ix => 856, iy => 864, },
	# [854] opcode : ld b "," "(" hl
	{ ")" => 855, },
	# [855] opcode : ld b "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_401 ], ":" => [ 9, \&_action_opcode_401 ], },
	# [856] opcode : ld b "," "(" ix
	{ ")" => 857, "+" => 858, "-" => 861, },
	# [857] opcode : ld b "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_402 ], ":" => [ 9, \&_action_opcode_402 ], },
	# [858] opcode : ld b "," "(" ix "+"
	{ "!" => [ 14, 859 ], "+" => [ 14, 859 ], "-" => [ 14, 859 ], __else__ => [ 14, 859 ], "~" => [ 14, 859 ], },
	# [859] opcode : ld b "," "(" ix "+" "[expr_DIS]"
	{ ")" => 860, },
	# [860] opcode : ld b "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_403 ], ":" => [ 9, \&_action_opcode_403 ], },
	# [861] opcode : ld b "," "(" ix "-"
	{ "!" => [ 16, 862 ], "+" => [ 16, 862 ], "-" => [ 16, 862 ], __else__ => [ 16, 862 ], "~" => [ 16, 862 ], },
	# [862] opcode : ld b "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 863, },
	# [863] opcode : ld b "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_403 ], ":" => [ 9, \&_action_opcode_403 ], },
	# [864] opcode : ld b "," "(" iy
	{ ")" => 865, "+" => 866, "-" => 869, },
	# [865] opcode : ld b "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_404 ], ":" => [ 9, \&_action_opcode_404 ], },
	# [866] opcode : ld b "," "(" iy "+"
	{ "!" => [ 14, 867 ], "+" => [ 14, 867 ], "-" => [ 14, 867 ], __else__ => [ 14, 867 ], "~" => [ 14, 867 ], },
	# [867] opcode : ld b "," "(" iy "+" "[expr_DIS]"
	{ ")" => 868, },
	# [868] opcode : ld b "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_405 ], ":" => [ 9, \&_action_opcode_405 ], },
	# [869] opcode : ld b "," "(" iy "-"
	{ "!" => [ 16, 870 ], "+" => [ 16, 870 ], "-" => [ 16, 870 ], __else__ => [ 16, 870 ], "~" => [ 16, 870 ], },
	# [870] opcode : ld b "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 871, },
	# [871] opcode : ld b "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_405 ], ":" => [ 9, \&_action_opcode_405 ], },
	# [872] opcode : ld b "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_406 ], ":" => [ 9, \&_action_opcode_406 ], },
	# [873] opcode : ld b "," a
	{ "\n" => [ 9, \&_action_opcode_407 ], ":" => [ 9, \&_action_opcode_407 ], },
	# [874] opcode : ld b "," b
	{ "\n" => [ 9, \&_action_opcode_408 ], ":" => [ 9, \&_action_opcode_408 ], },
	# [875] opcode : ld b "," c
	{ "\n" => [ 9, \&_action_opcode_409 ], ":" => [ 9, \&_action_opcode_409 ], },
	# [876] opcode : ld b "," d
	{ "\n" => [ 9, \&_action_opcode_410 ], ":" => [ 9, \&_action_opcode_410 ], },
	# [877] opcode : ld b "," e
	{ "\n" => [ 9, \&_action_opcode_411 ], ":" => [ 9, \&_action_opcode_411 ], },
	# [878] opcode : ld b "," h
	{ "\n" => [ 9, \&_action_opcode_412 ], ":" => [ 9, \&_action_opcode_412 ], },
	# [879] opcode : ld b "," ixh
	{ "\n" => [ 9, \&_action_opcode_413 ], ":" => [ 9, \&_action_opcode_413 ], },
	# [880] opcode : ld b "," ixl
	{ "\n" => [ 9, \&_action_opcode_414 ], ":" => [ 9, \&_action_opcode_414 ], },
	# [881] opcode : ld b "," iyh
	{ "\n" => [ 9, \&_action_opcode_415 ], ":" => [ 9, \&_action_opcode_415 ], },
	# [882] opcode : ld b "," iyl
	{ "\n" => [ 9, \&_action_opcode_416 ], ":" => [ 9, \&_action_opcode_416 ], },
	# [883] opcode : ld b "," l
	{ "\n" => [ 9, \&_action_opcode_417 ], ":" => [ 9, \&_action_opcode_417 ], },
	# [884] opcode : ld bc
	{ "," => 885, },
	# [885] opcode : ld bc ","
	{ "!" => [ 17, 907 ], "(" => 886, "+" => [ 17, 907 ], "-" => [ 17, 907 ], __else__ => [ 17, 907 ], bc => 908, de => 909, hl => 910, ix => 911, iy => 912, "~" => [ 17, 907 ], },
	# [886] opcode : ld bc "," "("
	{ "!" => [ 17, 887 ], "+" => [ 17, 887 ], "-" => [ 17, 887 ], __else__ => [ 17, 887 ], hl => 889, ix => 891, iy => 899, "~" => [ 17, 887 ], },
	# [887] opcode : ld bc "," "(" "[expr_NN]"
	{ ")" => 888, },
	# [888] opcode : ld bc "," "(" "[expr_NN]" ")"
	{ "\n" => [ 9, \&_action_opcode_418 ], ":" => [ 9, \&_action_opcode_418 ], },
	# [889] opcode : ld bc "," "(" hl
	{ ")" => 890, },
	# [890] opcode : ld bc "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_419 ], ":" => [ 9, \&_action_opcode_419 ], },
	# [891] opcode : ld bc "," "(" ix
	{ ")" => 892, "+" => 893, "-" => 896, },
	# [892] opcode : ld bc "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_420 ], ":" => [ 9, \&_action_opcode_420 ], },
	# [893] opcode : ld bc "," "(" ix "+"
	{ "!" => [ 14, 894 ], "+" => [ 14, 894 ], "-" => [ 14, 894 ], __else__ => [ 14, 894 ], "~" => [ 14, 894 ], },
	# [894] opcode : ld bc "," "(" ix "+" "[expr_DIS]"
	{ ")" => 895, },
	# [895] opcode : ld bc "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_421 ], ":" => [ 9, \&_action_opcode_421 ], },
	# [896] opcode : ld bc "," "(" ix "-"
	{ "!" => [ 16, 897 ], "+" => [ 16, 897 ], "-" => [ 16, 897 ], __else__ => [ 16, 897 ], "~" => [ 16, 897 ], },
	# [897] opcode : ld bc "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 898, },
	# [898] opcode : ld bc "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_421 ], ":" => [ 9, \&_action_opcode_421 ], },
	# [899] opcode : ld bc "," "(" iy
	{ ")" => 900, "+" => 901, "-" => 904, },
	# [900] opcode : ld bc "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_422 ], ":" => [ 9, \&_action_opcode_422 ], },
	# [901] opcode : ld bc "," "(" iy "+"
	{ "!" => [ 14, 902 ], "+" => [ 14, 902 ], "-" => [ 14, 902 ], __else__ => [ 14, 902 ], "~" => [ 14, 902 ], },
	# [902] opcode : ld bc "," "(" iy "+" "[expr_DIS]"
	{ ")" => 903, },
	# [903] opcode : ld bc "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_423 ], ":" => [ 9, \&_action_opcode_423 ], },
	# [904] opcode : ld bc "," "(" iy "-"
	{ "!" => [ 16, 905 ], "+" => [ 16, 905 ], "-" => [ 16, 905 ], __else__ => [ 16, 905 ], "~" => [ 16, 905 ], },
	# [905] opcode : ld bc "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 906, },
	# [906] opcode : ld bc "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_423 ], ":" => [ 9, \&_action_opcode_423 ], },
	# [907] opcode : ld bc "," "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_424 ], ":" => [ 9, \&_action_opcode_424 ], },
	# [908] opcode : ld bc "," bc
	{ "\n" => [ 9, \&_action_opcode_425 ], ":" => [ 9, \&_action_opcode_425 ], },
	# [909] opcode : ld bc "," de
	{ "\n" => [ 9, \&_action_opcode_426 ], ":" => [ 9, \&_action_opcode_426 ], },
	# [910] opcode : ld bc "," hl
	{ "\n" => [ 9, \&_action_opcode_427 ], ":" => [ 9, \&_action_opcode_427 ], },
	# [911] opcode : ld bc "," ix
	{ "\n" => [ 9, \&_action_opcode_428 ], ":" => [ 9, \&_action_opcode_428 ], },
	# [912] opcode : ld bc "," iy
	{ "\n" => [ 9, \&_action_opcode_429 ], ":" => [ 9, \&_action_opcode_429 ], },
	# [913] opcode : ld c
	{ "," => 914, },
	# [914] opcode : ld c ","
	{ "!" => [ 15, 934 ], "(" => 915, "+" => [ 15, 934 ], "-" => [ 15, 934 ], __else__ => [ 15, 934 ], a => 935, b => 936, c => 937, d => 938, e => 939, h => 940, ixh => 941, ixl => 942, iyh => 943, iyl => 944, l => 945, "~" => [ 15, 934 ], },
	# [915] opcode : ld c "," "("
	{ hl => 916, ix => 918, iy => 926, },
	# [916] opcode : ld c "," "(" hl
	{ ")" => 917, },
	# [917] opcode : ld c "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_430 ], ":" => [ 9, \&_action_opcode_430 ], },
	# [918] opcode : ld c "," "(" ix
	{ ")" => 919, "+" => 920, "-" => 923, },
	# [919] opcode : ld c "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_431 ], ":" => [ 9, \&_action_opcode_431 ], },
	# [920] opcode : ld c "," "(" ix "+"
	{ "!" => [ 14, 921 ], "+" => [ 14, 921 ], "-" => [ 14, 921 ], __else__ => [ 14, 921 ], "~" => [ 14, 921 ], },
	# [921] opcode : ld c "," "(" ix "+" "[expr_DIS]"
	{ ")" => 922, },
	# [922] opcode : ld c "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_432 ], ":" => [ 9, \&_action_opcode_432 ], },
	# [923] opcode : ld c "," "(" ix "-"
	{ "!" => [ 16, 924 ], "+" => [ 16, 924 ], "-" => [ 16, 924 ], __else__ => [ 16, 924 ], "~" => [ 16, 924 ], },
	# [924] opcode : ld c "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 925, },
	# [925] opcode : ld c "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_432 ], ":" => [ 9, \&_action_opcode_432 ], },
	# [926] opcode : ld c "," "(" iy
	{ ")" => 927, "+" => 928, "-" => 931, },
	# [927] opcode : ld c "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_433 ], ":" => [ 9, \&_action_opcode_433 ], },
	# [928] opcode : ld c "," "(" iy "+"
	{ "!" => [ 14, 929 ], "+" => [ 14, 929 ], "-" => [ 14, 929 ], __else__ => [ 14, 929 ], "~" => [ 14, 929 ], },
	# [929] opcode : ld c "," "(" iy "+" "[expr_DIS]"
	{ ")" => 930, },
	# [930] opcode : ld c "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_434 ], ":" => [ 9, \&_action_opcode_434 ], },
	# [931] opcode : ld c "," "(" iy "-"
	{ "!" => [ 16, 932 ], "+" => [ 16, 932 ], "-" => [ 16, 932 ], __else__ => [ 16, 932 ], "~" => [ 16, 932 ], },
	# [932] opcode : ld c "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 933, },
	# [933] opcode : ld c "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_434 ], ":" => [ 9, \&_action_opcode_434 ], },
	# [934] opcode : ld c "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_435 ], ":" => [ 9, \&_action_opcode_435 ], },
	# [935] opcode : ld c "," a
	{ "\n" => [ 9, \&_action_opcode_436 ], ":" => [ 9, \&_action_opcode_436 ], },
	# [936] opcode : ld c "," b
	{ "\n" => [ 9, \&_action_opcode_437 ], ":" => [ 9, \&_action_opcode_437 ], },
	# [937] opcode : ld c "," c
	{ "\n" => [ 9, \&_action_opcode_438 ], ":" => [ 9, \&_action_opcode_438 ], },
	# [938] opcode : ld c "," d
	{ "\n" => [ 9, \&_action_opcode_439 ], ":" => [ 9, \&_action_opcode_439 ], },
	# [939] opcode : ld c "," e
	{ "\n" => [ 9, \&_action_opcode_440 ], ":" => [ 9, \&_action_opcode_440 ], },
	# [940] opcode : ld c "," h
	{ "\n" => [ 9, \&_action_opcode_441 ], ":" => [ 9, \&_action_opcode_441 ], },
	# [941] opcode : ld c "," ixh
	{ "\n" => [ 9, \&_action_opcode_442 ], ":" => [ 9, \&_action_opcode_442 ], },
	# [942] opcode : ld c "," ixl
	{ "\n" => [ 9, \&_action_opcode_443 ], ":" => [ 9, \&_action_opcode_443 ], },
	# [943] opcode : ld c "," iyh
	{ "\n" => [ 9, \&_action_opcode_444 ], ":" => [ 9, \&_action_opcode_444 ], },
	# [944] opcode : ld c "," iyl
	{ "\n" => [ 9, \&_action_opcode_445 ], ":" => [ 9, \&_action_opcode_445 ], },
	# [945] opcode : ld c "," l
	{ "\n" => [ 9, \&_action_opcode_446 ], ":" => [ 9, \&_action_opcode_446 ], },
	# [946] opcode : ld d
	{ "," => 947, },
	# [947] opcode : ld d ","
	{ "!" => [ 15, 967 ], "(" => 948, "+" => [ 15, 967 ], "-" => [ 15, 967 ], __else__ => [ 15, 967 ], a => 968, b => 969, c => 970, d => 971, e => 972, h => 973, ixh => 974, ixl => 975, iyh => 976, iyl => 977, l => 978, "~" => [ 15, 967 ], },
	# [948] opcode : ld d "," "("
	{ hl => 949, ix => 951, iy => 959, },
	# [949] opcode : ld d "," "(" hl
	{ ")" => 950, },
	# [950] opcode : ld d "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_447 ], ":" => [ 9, \&_action_opcode_447 ], },
	# [951] opcode : ld d "," "(" ix
	{ ")" => 952, "+" => 953, "-" => 956, },
	# [952] opcode : ld d "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_448 ], ":" => [ 9, \&_action_opcode_448 ], },
	# [953] opcode : ld d "," "(" ix "+"
	{ "!" => [ 14, 954 ], "+" => [ 14, 954 ], "-" => [ 14, 954 ], __else__ => [ 14, 954 ], "~" => [ 14, 954 ], },
	# [954] opcode : ld d "," "(" ix "+" "[expr_DIS]"
	{ ")" => 955, },
	# [955] opcode : ld d "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_449 ], ":" => [ 9, \&_action_opcode_449 ], },
	# [956] opcode : ld d "," "(" ix "-"
	{ "!" => [ 16, 957 ], "+" => [ 16, 957 ], "-" => [ 16, 957 ], __else__ => [ 16, 957 ], "~" => [ 16, 957 ], },
	# [957] opcode : ld d "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 958, },
	# [958] opcode : ld d "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_449 ], ":" => [ 9, \&_action_opcode_449 ], },
	# [959] opcode : ld d "," "(" iy
	{ ")" => 960, "+" => 961, "-" => 964, },
	# [960] opcode : ld d "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_450 ], ":" => [ 9, \&_action_opcode_450 ], },
	# [961] opcode : ld d "," "(" iy "+"
	{ "!" => [ 14, 962 ], "+" => [ 14, 962 ], "-" => [ 14, 962 ], __else__ => [ 14, 962 ], "~" => [ 14, 962 ], },
	# [962] opcode : ld d "," "(" iy "+" "[expr_DIS]"
	{ ")" => 963, },
	# [963] opcode : ld d "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_451 ], ":" => [ 9, \&_action_opcode_451 ], },
	# [964] opcode : ld d "," "(" iy "-"
	{ "!" => [ 16, 965 ], "+" => [ 16, 965 ], "-" => [ 16, 965 ], __else__ => [ 16, 965 ], "~" => [ 16, 965 ], },
	# [965] opcode : ld d "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 966, },
	# [966] opcode : ld d "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_451 ], ":" => [ 9, \&_action_opcode_451 ], },
	# [967] opcode : ld d "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_452 ], ":" => [ 9, \&_action_opcode_452 ], },
	# [968] opcode : ld d "," a
	{ "\n" => [ 9, \&_action_opcode_453 ], ":" => [ 9, \&_action_opcode_453 ], },
	# [969] opcode : ld d "," b
	{ "\n" => [ 9, \&_action_opcode_454 ], ":" => [ 9, \&_action_opcode_454 ], },
	# [970] opcode : ld d "," c
	{ "\n" => [ 9, \&_action_opcode_455 ], ":" => [ 9, \&_action_opcode_455 ], },
	# [971] opcode : ld d "," d
	{ "\n" => [ 9, \&_action_opcode_456 ], ":" => [ 9, \&_action_opcode_456 ], },
	# [972] opcode : ld d "," e
	{ "\n" => [ 9, \&_action_opcode_457 ], ":" => [ 9, \&_action_opcode_457 ], },
	# [973] opcode : ld d "," h
	{ "\n" => [ 9, \&_action_opcode_458 ], ":" => [ 9, \&_action_opcode_458 ], },
	# [974] opcode : ld d "," ixh
	{ "\n" => [ 9, \&_action_opcode_459 ], ":" => [ 9, \&_action_opcode_459 ], },
	# [975] opcode : ld d "," ixl
	{ "\n" => [ 9, \&_action_opcode_460 ], ":" => [ 9, \&_action_opcode_460 ], },
	# [976] opcode : ld d "," iyh
	{ "\n" => [ 9, \&_action_opcode_461 ], ":" => [ 9, \&_action_opcode_461 ], },
	# [977] opcode : ld d "," iyl
	{ "\n" => [ 9, \&_action_opcode_462 ], ":" => [ 9, \&_action_opcode_462 ], },
	# [978] opcode : ld d "," l
	{ "\n" => [ 9, \&_action_opcode_463 ], ":" => [ 9, \&_action_opcode_463 ], },
	# [979] opcode : ld de
	{ "," => 980, },
	# [980] opcode : ld de ","
	{ "!" => [ 17, 1002 ], "(" => 981, "+" => [ 17, 1002 ], "-" => [ 17, 1002 ], __else__ => [ 17, 1002 ], bc => 1003, de => 1004, hl => 1005, ix => 1006, iy => 1007, "~" => [ 17, 1002 ], },
	# [981] opcode : ld de "," "("
	{ "!" => [ 17, 982 ], "+" => [ 17, 982 ], "-" => [ 17, 982 ], __else__ => [ 17, 982 ], hl => 984, ix => 986, iy => 994, "~" => [ 17, 982 ], },
	# [982] opcode : ld de "," "(" "[expr_NN]"
	{ ")" => 983, },
	# [983] opcode : ld de "," "(" "[expr_NN]" ")"
	{ "\n" => [ 9, \&_action_opcode_464 ], ":" => [ 9, \&_action_opcode_464 ], },
	# [984] opcode : ld de "," "(" hl
	{ ")" => 985, },
	# [985] opcode : ld de "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_465 ], ":" => [ 9, \&_action_opcode_465 ], },
	# [986] opcode : ld de "," "(" ix
	{ ")" => 987, "+" => 988, "-" => 991, },
	# [987] opcode : ld de "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_466 ], ":" => [ 9, \&_action_opcode_466 ], },
	# [988] opcode : ld de "," "(" ix "+"
	{ "!" => [ 14, 989 ], "+" => [ 14, 989 ], "-" => [ 14, 989 ], __else__ => [ 14, 989 ], "~" => [ 14, 989 ], },
	# [989] opcode : ld de "," "(" ix "+" "[expr_DIS]"
	{ ")" => 990, },
	# [990] opcode : ld de "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_467 ], ":" => [ 9, \&_action_opcode_467 ], },
	# [991] opcode : ld de "," "(" ix "-"
	{ "!" => [ 16, 992 ], "+" => [ 16, 992 ], "-" => [ 16, 992 ], __else__ => [ 16, 992 ], "~" => [ 16, 992 ], },
	# [992] opcode : ld de "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 993, },
	# [993] opcode : ld de "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_467 ], ":" => [ 9, \&_action_opcode_467 ], },
	# [994] opcode : ld de "," "(" iy
	{ ")" => 995, "+" => 996, "-" => 999, },
	# [995] opcode : ld de "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_468 ], ":" => [ 9, \&_action_opcode_468 ], },
	# [996] opcode : ld de "," "(" iy "+"
	{ "!" => [ 14, 997 ], "+" => [ 14, 997 ], "-" => [ 14, 997 ], __else__ => [ 14, 997 ], "~" => [ 14, 997 ], },
	# [997] opcode : ld de "," "(" iy "+" "[expr_DIS]"
	{ ")" => 998, },
	# [998] opcode : ld de "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_469 ], ":" => [ 9, \&_action_opcode_469 ], },
	# [999] opcode : ld de "," "(" iy "-"
	{ "!" => [ 16, 1000 ], "+" => [ 16, 1000 ], "-" => [ 16, 1000 ], __else__ => [ 16, 1000 ], "~" => [ 16, 1000 ], },
	# [1000] opcode : ld de "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1001, },
	# [1001] opcode : ld de "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_469 ], ":" => [ 9, \&_action_opcode_469 ], },
	# [1002] opcode : ld de "," "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_470 ], ":" => [ 9, \&_action_opcode_470 ], },
	# [1003] opcode : ld de "," bc
	{ "\n" => [ 9, \&_action_opcode_471 ], ":" => [ 9, \&_action_opcode_471 ], },
	# [1004] opcode : ld de "," de
	{ "\n" => [ 9, \&_action_opcode_472 ], ":" => [ 9, \&_action_opcode_472 ], },
	# [1005] opcode : ld de "," hl
	{ "\n" => [ 9, \&_action_opcode_473 ], ":" => [ 9, \&_action_opcode_473 ], },
	# [1006] opcode : ld de "," ix
	{ "\n" => [ 9, \&_action_opcode_474 ], ":" => [ 9, \&_action_opcode_474 ], },
	# [1007] opcode : ld de "," iy
	{ "\n" => [ 9, \&_action_opcode_475 ], ":" => [ 9, \&_action_opcode_475 ], },
	# [1008] opcode : ld e
	{ "," => 1009, },
	# [1009] opcode : ld e ","
	{ "!" => [ 15, 1029 ], "(" => 1010, "+" => [ 15, 1029 ], "-" => [ 15, 1029 ], __else__ => [ 15, 1029 ], a => 1030, b => 1031, c => 1032, d => 1033, e => 1034, h => 1035, ixh => 1036, ixl => 1037, iyh => 1038, iyl => 1039, l => 1040, "~" => [ 15, 1029 ], },
	# [1010] opcode : ld e "," "("
	{ hl => 1011, ix => 1013, iy => 1021, },
	# [1011] opcode : ld e "," "(" hl
	{ ")" => 1012, },
	# [1012] opcode : ld e "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_476 ], ":" => [ 9, \&_action_opcode_476 ], },
	# [1013] opcode : ld e "," "(" ix
	{ ")" => 1014, "+" => 1015, "-" => 1018, },
	# [1014] opcode : ld e "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_477 ], ":" => [ 9, \&_action_opcode_477 ], },
	# [1015] opcode : ld e "," "(" ix "+"
	{ "!" => [ 14, 1016 ], "+" => [ 14, 1016 ], "-" => [ 14, 1016 ], __else__ => [ 14, 1016 ], "~" => [ 14, 1016 ], },
	# [1016] opcode : ld e "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1017, },
	# [1017] opcode : ld e "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_478 ], ":" => [ 9, \&_action_opcode_478 ], },
	# [1018] opcode : ld e "," "(" ix "-"
	{ "!" => [ 16, 1019 ], "+" => [ 16, 1019 ], "-" => [ 16, 1019 ], __else__ => [ 16, 1019 ], "~" => [ 16, 1019 ], },
	# [1019] opcode : ld e "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1020, },
	# [1020] opcode : ld e "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_478 ], ":" => [ 9, \&_action_opcode_478 ], },
	# [1021] opcode : ld e "," "(" iy
	{ ")" => 1022, "+" => 1023, "-" => 1026, },
	# [1022] opcode : ld e "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_479 ], ":" => [ 9, \&_action_opcode_479 ], },
	# [1023] opcode : ld e "," "(" iy "+"
	{ "!" => [ 14, 1024 ], "+" => [ 14, 1024 ], "-" => [ 14, 1024 ], __else__ => [ 14, 1024 ], "~" => [ 14, 1024 ], },
	# [1024] opcode : ld e "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1025, },
	# [1025] opcode : ld e "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_480 ], ":" => [ 9, \&_action_opcode_480 ], },
	# [1026] opcode : ld e "," "(" iy "-"
	{ "!" => [ 16, 1027 ], "+" => [ 16, 1027 ], "-" => [ 16, 1027 ], __else__ => [ 16, 1027 ], "~" => [ 16, 1027 ], },
	# [1027] opcode : ld e "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1028, },
	# [1028] opcode : ld e "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_480 ], ":" => [ 9, \&_action_opcode_480 ], },
	# [1029] opcode : ld e "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_481 ], ":" => [ 9, \&_action_opcode_481 ], },
	# [1030] opcode : ld e "," a
	{ "\n" => [ 9, \&_action_opcode_482 ], ":" => [ 9, \&_action_opcode_482 ], },
	# [1031] opcode : ld e "," b
	{ "\n" => [ 9, \&_action_opcode_483 ], ":" => [ 9, \&_action_opcode_483 ], },
	# [1032] opcode : ld e "," c
	{ "\n" => [ 9, \&_action_opcode_484 ], ":" => [ 9, \&_action_opcode_484 ], },
	# [1033] opcode : ld e "," d
	{ "\n" => [ 9, \&_action_opcode_485 ], ":" => [ 9, \&_action_opcode_485 ], },
	# [1034] opcode : ld e "," e
	{ "\n" => [ 9, \&_action_opcode_486 ], ":" => [ 9, \&_action_opcode_486 ], },
	# [1035] opcode : ld e "," h
	{ "\n" => [ 9, \&_action_opcode_487 ], ":" => [ 9, \&_action_opcode_487 ], },
	# [1036] opcode : ld e "," ixh
	{ "\n" => [ 9, \&_action_opcode_488 ], ":" => [ 9, \&_action_opcode_488 ], },
	# [1037] opcode : ld e "," ixl
	{ "\n" => [ 9, \&_action_opcode_489 ], ":" => [ 9, \&_action_opcode_489 ], },
	# [1038] opcode : ld e "," iyh
	{ "\n" => [ 9, \&_action_opcode_490 ], ":" => [ 9, \&_action_opcode_490 ], },
	# [1039] opcode : ld e "," iyl
	{ "\n" => [ 9, \&_action_opcode_491 ], ":" => [ 9, \&_action_opcode_491 ], },
	# [1040] opcode : ld e "," l
	{ "\n" => [ 9, \&_action_opcode_492 ], ":" => [ 9, \&_action_opcode_492 ], },
	# [1041] opcode : ld h
	{ "," => 1042, },
	# [1042] opcode : ld h ","
	{ "!" => [ 15, 1062 ], "(" => 1043, "+" => [ 15, 1062 ], "-" => [ 15, 1062 ], __else__ => [ 15, 1062 ], a => 1063, b => 1064, c => 1065, d => 1066, e => 1067, h => 1068, l => 1069, "~" => [ 15, 1062 ], },
	# [1043] opcode : ld h "," "("
	{ hl => 1044, ix => 1046, iy => 1054, },
	# [1044] opcode : ld h "," "(" hl
	{ ")" => 1045, },
	# [1045] opcode : ld h "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_493 ], ":" => [ 9, \&_action_opcode_493 ], },
	# [1046] opcode : ld h "," "(" ix
	{ ")" => 1047, "+" => 1048, "-" => 1051, },
	# [1047] opcode : ld h "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_494 ], ":" => [ 9, \&_action_opcode_494 ], },
	# [1048] opcode : ld h "," "(" ix "+"
	{ "!" => [ 14, 1049 ], "+" => [ 14, 1049 ], "-" => [ 14, 1049 ], __else__ => [ 14, 1049 ], "~" => [ 14, 1049 ], },
	# [1049] opcode : ld h "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1050, },
	# [1050] opcode : ld h "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_495 ], ":" => [ 9, \&_action_opcode_495 ], },
	# [1051] opcode : ld h "," "(" ix "-"
	{ "!" => [ 16, 1052 ], "+" => [ 16, 1052 ], "-" => [ 16, 1052 ], __else__ => [ 16, 1052 ], "~" => [ 16, 1052 ], },
	# [1052] opcode : ld h "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1053, },
	# [1053] opcode : ld h "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_495 ], ":" => [ 9, \&_action_opcode_495 ], },
	# [1054] opcode : ld h "," "(" iy
	{ ")" => 1055, "+" => 1056, "-" => 1059, },
	# [1055] opcode : ld h "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_496 ], ":" => [ 9, \&_action_opcode_496 ], },
	# [1056] opcode : ld h "," "(" iy "+"
	{ "!" => [ 14, 1057 ], "+" => [ 14, 1057 ], "-" => [ 14, 1057 ], __else__ => [ 14, 1057 ], "~" => [ 14, 1057 ], },
	# [1057] opcode : ld h "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1058, },
	# [1058] opcode : ld h "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_497 ], ":" => [ 9, \&_action_opcode_497 ], },
	# [1059] opcode : ld h "," "(" iy "-"
	{ "!" => [ 16, 1060 ], "+" => [ 16, 1060 ], "-" => [ 16, 1060 ], __else__ => [ 16, 1060 ], "~" => [ 16, 1060 ], },
	# [1060] opcode : ld h "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1061, },
	# [1061] opcode : ld h "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_497 ], ":" => [ 9, \&_action_opcode_497 ], },
	# [1062] opcode : ld h "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_498 ], ":" => [ 9, \&_action_opcode_498 ], },
	# [1063] opcode : ld h "," a
	{ "\n" => [ 9, \&_action_opcode_499 ], ":" => [ 9, \&_action_opcode_499 ], },
	# [1064] opcode : ld h "," b
	{ "\n" => [ 9, \&_action_opcode_500 ], ":" => [ 9, \&_action_opcode_500 ], },
	# [1065] opcode : ld h "," c
	{ "\n" => [ 9, \&_action_opcode_501 ], ":" => [ 9, \&_action_opcode_501 ], },
	# [1066] opcode : ld h "," d
	{ "\n" => [ 9, \&_action_opcode_502 ], ":" => [ 9, \&_action_opcode_502 ], },
	# [1067] opcode : ld h "," e
	{ "\n" => [ 9, \&_action_opcode_503 ], ":" => [ 9, \&_action_opcode_503 ], },
	# [1068] opcode : ld h "," h
	{ "\n" => [ 9, \&_action_opcode_504 ], ":" => [ 9, \&_action_opcode_504 ], },
	# [1069] opcode : ld h "," l
	{ "\n" => [ 9, \&_action_opcode_505 ], ":" => [ 9, \&_action_opcode_505 ], },
	# [1070] opcode : ld hl
	{ "," => 1071, },
	# [1071] opcode : ld hl ","
	{ "!" => [ 17, 1091 ], "(" => 1072, "+" => [ 17, 1091 ], "-" => [ 17, 1091 ], __else__ => [ 17, 1091 ], bc => 1092, de => 1093, hl => 1094, ix => 1095, iy => 1096, "~" => [ 17, 1091 ], },
	# [1072] opcode : ld hl "," "("
	{ "!" => [ 17, 1073 ], "+" => [ 17, 1073 ], "-" => [ 17, 1073 ], __else__ => [ 17, 1073 ], ix => 1075, iy => 1083, "~" => [ 17, 1073 ], },
	# [1073] opcode : ld hl "," "(" "[expr_NN]"
	{ ")" => 1074, },
	# [1074] opcode : ld hl "," "(" "[expr_NN]" ")"
	{ "\n" => [ 9, \&_action_opcode_506 ], ":" => [ 9, \&_action_opcode_506 ], },
	# [1075] opcode : ld hl "," "(" ix
	{ ")" => 1076, "+" => 1077, "-" => 1080, },
	# [1076] opcode : ld hl "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_507 ], ":" => [ 9, \&_action_opcode_507 ], },
	# [1077] opcode : ld hl "," "(" ix "+"
	{ "!" => [ 14, 1078 ], "+" => [ 14, 1078 ], "-" => [ 14, 1078 ], __else__ => [ 14, 1078 ], "~" => [ 14, 1078 ], },
	# [1078] opcode : ld hl "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1079, },
	# [1079] opcode : ld hl "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_508 ], ":" => [ 9, \&_action_opcode_508 ], },
	# [1080] opcode : ld hl "," "(" ix "-"
	{ "!" => [ 16, 1081 ], "+" => [ 16, 1081 ], "-" => [ 16, 1081 ], __else__ => [ 16, 1081 ], "~" => [ 16, 1081 ], },
	# [1081] opcode : ld hl "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1082, },
	# [1082] opcode : ld hl "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_508 ], ":" => [ 9, \&_action_opcode_508 ], },
	# [1083] opcode : ld hl "," "(" iy
	{ ")" => 1084, "+" => 1085, "-" => 1088, },
	# [1084] opcode : ld hl "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_509 ], ":" => [ 9, \&_action_opcode_509 ], },
	# [1085] opcode : ld hl "," "(" iy "+"
	{ "!" => [ 14, 1086 ], "+" => [ 14, 1086 ], "-" => [ 14, 1086 ], __else__ => [ 14, 1086 ], "~" => [ 14, 1086 ], },
	# [1086] opcode : ld hl "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1087, },
	# [1087] opcode : ld hl "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_510 ], ":" => [ 9, \&_action_opcode_510 ], },
	# [1088] opcode : ld hl "," "(" iy "-"
	{ "!" => [ 16, 1089 ], "+" => [ 16, 1089 ], "-" => [ 16, 1089 ], __else__ => [ 16, 1089 ], "~" => [ 16, 1089 ], },
	# [1089] opcode : ld hl "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1090, },
	# [1090] opcode : ld hl "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_510 ], ":" => [ 9, \&_action_opcode_510 ], },
	# [1091] opcode : ld hl "," "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_511 ], ":" => [ 9, \&_action_opcode_511 ], },
	# [1092] opcode : ld hl "," bc
	{ "\n" => [ 9, \&_action_opcode_512 ], ":" => [ 9, \&_action_opcode_512 ], },
	# [1093] opcode : ld hl "," de
	{ "\n" => [ 9, \&_action_opcode_513 ], ":" => [ 9, \&_action_opcode_513 ], },
	# [1094] opcode : ld hl "," hl
	{ "\n" => [ 9, \&_action_opcode_514 ], ":" => [ 9, \&_action_opcode_514 ], },
	# [1095] opcode : ld hl "," ix
	{ "\n" => [ 9, \&_action_opcode_515 ], ":" => [ 9, \&_action_opcode_515 ], },
	# [1096] opcode : ld hl "," iy
	{ "\n" => [ 9, \&_action_opcode_516 ], ":" => [ 9, \&_action_opcode_516 ], },
	# [1097] opcode : ld i
	{ "," => 1098, },
	# [1098] opcode : ld i ","
	{ a => 1099, },
	# [1099] opcode : ld i "," a
	{ "\n" => [ 9, \&_action_opcode_517 ], ":" => [ 9, \&_action_opcode_517 ], },
	# [1100] opcode : ld ix
	{ "," => 1101, },
	# [1101] opcode : ld ix ","
	{ "!" => [ 17, 1105 ], "(" => 1102, "+" => [ 17, 1105 ], "-" => [ 17, 1105 ], __else__ => [ 17, 1105 ], bc => 1106, de => 1107, hl => 1108, ix => 1109, iy => 1110, "~" => [ 17, 1105 ], },
	# [1102] opcode : ld ix "," "("
	{ "!" => [ 17, 1103 ], "+" => [ 17, 1103 ], "-" => [ 17, 1103 ], __else__ => [ 17, 1103 ], "~" => [ 17, 1103 ], },
	# [1103] opcode : ld ix "," "(" "[expr_NN]"
	{ ")" => 1104, },
	# [1104] opcode : ld ix "," "(" "[expr_NN]" ")"
	{ "\n" => [ 9, \&_action_opcode_518 ], ":" => [ 9, \&_action_opcode_518 ], },
	# [1105] opcode : ld ix "," "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_519 ], ":" => [ 9, \&_action_opcode_519 ], },
	# [1106] opcode : ld ix "," bc
	{ "\n" => [ 9, \&_action_opcode_520 ], ":" => [ 9, \&_action_opcode_520 ], },
	# [1107] opcode : ld ix "," de
	{ "\n" => [ 9, \&_action_opcode_521 ], ":" => [ 9, \&_action_opcode_521 ], },
	# [1108] opcode : ld ix "," hl
	{ "\n" => [ 9, \&_action_opcode_522 ], ":" => [ 9, \&_action_opcode_522 ], },
	# [1109] opcode : ld ix "," ix
	{ "\n" => [ 9, \&_action_opcode_523 ], ":" => [ 9, \&_action_opcode_523 ], },
	# [1110] opcode : ld ix "," iy
	{ "\n" => [ 9, \&_action_opcode_524 ], ":" => [ 9, \&_action_opcode_524 ], },
	# [1111] opcode : ld ixh
	{ "," => 1112, },
	# [1112] opcode : ld ixh ","
	{ "!" => [ 15, 1113 ], "+" => [ 15, 1113 ], "-" => [ 15, 1113 ], __else__ => [ 15, 1113 ], a => 1114, b => 1115, c => 1116, d => 1117, e => 1118, ixh => 1119, ixl => 1120, "~" => [ 15, 1113 ], },
	# [1113] opcode : ld ixh "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_525 ], ":" => [ 9, \&_action_opcode_525 ], },
	# [1114] opcode : ld ixh "," a
	{ "\n" => [ 9, \&_action_opcode_526 ], ":" => [ 9, \&_action_opcode_526 ], },
	# [1115] opcode : ld ixh "," b
	{ "\n" => [ 9, \&_action_opcode_527 ], ":" => [ 9, \&_action_opcode_527 ], },
	# [1116] opcode : ld ixh "," c
	{ "\n" => [ 9, \&_action_opcode_528 ], ":" => [ 9, \&_action_opcode_528 ], },
	# [1117] opcode : ld ixh "," d
	{ "\n" => [ 9, \&_action_opcode_529 ], ":" => [ 9, \&_action_opcode_529 ], },
	# [1118] opcode : ld ixh "," e
	{ "\n" => [ 9, \&_action_opcode_530 ], ":" => [ 9, \&_action_opcode_530 ], },
	# [1119] opcode : ld ixh "," ixh
	{ "\n" => [ 9, \&_action_opcode_531 ], ":" => [ 9, \&_action_opcode_531 ], },
	# [1120] opcode : ld ixh "," ixl
	{ "\n" => [ 9, \&_action_opcode_532 ], ":" => [ 9, \&_action_opcode_532 ], },
	# [1121] opcode : ld ixl
	{ "," => 1122, },
	# [1122] opcode : ld ixl ","
	{ "!" => [ 15, 1123 ], "+" => [ 15, 1123 ], "-" => [ 15, 1123 ], __else__ => [ 15, 1123 ], a => 1124, b => 1125, c => 1126, d => 1127, e => 1128, ixh => 1129, ixl => 1130, "~" => [ 15, 1123 ], },
	# [1123] opcode : ld ixl "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_533 ], ":" => [ 9, \&_action_opcode_533 ], },
	# [1124] opcode : ld ixl "," a
	{ "\n" => [ 9, \&_action_opcode_534 ], ":" => [ 9, \&_action_opcode_534 ], },
	# [1125] opcode : ld ixl "," b
	{ "\n" => [ 9, \&_action_opcode_535 ], ":" => [ 9, \&_action_opcode_535 ], },
	# [1126] opcode : ld ixl "," c
	{ "\n" => [ 9, \&_action_opcode_536 ], ":" => [ 9, \&_action_opcode_536 ], },
	# [1127] opcode : ld ixl "," d
	{ "\n" => [ 9, \&_action_opcode_537 ], ":" => [ 9, \&_action_opcode_537 ], },
	# [1128] opcode : ld ixl "," e
	{ "\n" => [ 9, \&_action_opcode_538 ], ":" => [ 9, \&_action_opcode_538 ], },
	# [1129] opcode : ld ixl "," ixh
	{ "\n" => [ 9, \&_action_opcode_539 ], ":" => [ 9, \&_action_opcode_539 ], },
	# [1130] opcode : ld ixl "," ixl
	{ "\n" => [ 9, \&_action_opcode_540 ], ":" => [ 9, \&_action_opcode_540 ], },
	# [1131] opcode : ld iy
	{ "," => 1132, },
	# [1132] opcode : ld iy ","
	{ "!" => [ 17, 1136 ], "(" => 1133, "+" => [ 17, 1136 ], "-" => [ 17, 1136 ], __else__ => [ 17, 1136 ], bc => 1137, de => 1138, hl => 1139, ix => 1140, iy => 1141, "~" => [ 17, 1136 ], },
	# [1133] opcode : ld iy "," "("
	{ "!" => [ 17, 1134 ], "+" => [ 17, 1134 ], "-" => [ 17, 1134 ], __else__ => [ 17, 1134 ], "~" => [ 17, 1134 ], },
	# [1134] opcode : ld iy "," "(" "[expr_NN]"
	{ ")" => 1135, },
	# [1135] opcode : ld iy "," "(" "[expr_NN]" ")"
	{ "\n" => [ 9, \&_action_opcode_541 ], ":" => [ 9, \&_action_opcode_541 ], },
	# [1136] opcode : ld iy "," "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_542 ], ":" => [ 9, \&_action_opcode_542 ], },
	# [1137] opcode : ld iy "," bc
	{ "\n" => [ 9, \&_action_opcode_543 ], ":" => [ 9, \&_action_opcode_543 ], },
	# [1138] opcode : ld iy "," de
	{ "\n" => [ 9, \&_action_opcode_544 ], ":" => [ 9, \&_action_opcode_544 ], },
	# [1139] opcode : ld iy "," hl
	{ "\n" => [ 9, \&_action_opcode_545 ], ":" => [ 9, \&_action_opcode_545 ], },
	# [1140] opcode : ld iy "," ix
	{ "\n" => [ 9, \&_action_opcode_546 ], ":" => [ 9, \&_action_opcode_546 ], },
	# [1141] opcode : ld iy "," iy
	{ "\n" => [ 9, \&_action_opcode_547 ], ":" => [ 9, \&_action_opcode_547 ], },
	# [1142] opcode : ld iyh
	{ "," => 1143, },
	# [1143] opcode : ld iyh ","
	{ "!" => [ 15, 1144 ], "+" => [ 15, 1144 ], "-" => [ 15, 1144 ], __else__ => [ 15, 1144 ], a => 1145, b => 1146, c => 1147, d => 1148, e => 1149, iyh => 1150, iyl => 1151, "~" => [ 15, 1144 ], },
	# [1144] opcode : ld iyh "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_548 ], ":" => [ 9, \&_action_opcode_548 ], },
	# [1145] opcode : ld iyh "," a
	{ "\n" => [ 9, \&_action_opcode_549 ], ":" => [ 9, \&_action_opcode_549 ], },
	# [1146] opcode : ld iyh "," b
	{ "\n" => [ 9, \&_action_opcode_550 ], ":" => [ 9, \&_action_opcode_550 ], },
	# [1147] opcode : ld iyh "," c
	{ "\n" => [ 9, \&_action_opcode_551 ], ":" => [ 9, \&_action_opcode_551 ], },
	# [1148] opcode : ld iyh "," d
	{ "\n" => [ 9, \&_action_opcode_552 ], ":" => [ 9, \&_action_opcode_552 ], },
	# [1149] opcode : ld iyh "," e
	{ "\n" => [ 9, \&_action_opcode_553 ], ":" => [ 9, \&_action_opcode_553 ], },
	# [1150] opcode : ld iyh "," iyh
	{ "\n" => [ 9, \&_action_opcode_554 ], ":" => [ 9, \&_action_opcode_554 ], },
	# [1151] opcode : ld iyh "," iyl
	{ "\n" => [ 9, \&_action_opcode_555 ], ":" => [ 9, \&_action_opcode_555 ], },
	# [1152] opcode : ld iyl
	{ "," => 1153, },
	# [1153] opcode : ld iyl ","
	{ "!" => [ 15, 1154 ], "+" => [ 15, 1154 ], "-" => [ 15, 1154 ], __else__ => [ 15, 1154 ], a => 1155, b => 1156, c => 1157, d => 1158, e => 1159, iyh => 1160, iyl => 1161, "~" => [ 15, 1154 ], },
	# [1154] opcode : ld iyl "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_556 ], ":" => [ 9, \&_action_opcode_556 ], },
	# [1155] opcode : ld iyl "," a
	{ "\n" => [ 9, \&_action_opcode_557 ], ":" => [ 9, \&_action_opcode_557 ], },
	# [1156] opcode : ld iyl "," b
	{ "\n" => [ 9, \&_action_opcode_558 ], ":" => [ 9, \&_action_opcode_558 ], },
	# [1157] opcode : ld iyl "," c
	{ "\n" => [ 9, \&_action_opcode_559 ], ":" => [ 9, \&_action_opcode_559 ], },
	# [1158] opcode : ld iyl "," d
	{ "\n" => [ 9, \&_action_opcode_560 ], ":" => [ 9, \&_action_opcode_560 ], },
	# [1159] opcode : ld iyl "," e
	{ "\n" => [ 9, \&_action_opcode_561 ], ":" => [ 9, \&_action_opcode_561 ], },
	# [1160] opcode : ld iyl "," iyh
	{ "\n" => [ 9, \&_action_opcode_562 ], ":" => [ 9, \&_action_opcode_562 ], },
	# [1161] opcode : ld iyl "," iyl
	{ "\n" => [ 9, \&_action_opcode_563 ], ":" => [ 9, \&_action_opcode_563 ], },
	# [1162] opcode : ld l
	{ "," => 1163, },
	# [1163] opcode : ld l ","
	{ "!" => [ 15, 1183 ], "(" => 1164, "+" => [ 15, 1183 ], "-" => [ 15, 1183 ], __else__ => [ 15, 1183 ], a => 1184, b => 1185, c => 1186, d => 1187, e => 1188, h => 1189, l => 1190, "~" => [ 15, 1183 ], },
	# [1164] opcode : ld l "," "("
	{ hl => 1165, ix => 1167, iy => 1175, },
	# [1165] opcode : ld l "," "(" hl
	{ ")" => 1166, },
	# [1166] opcode : ld l "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_564 ], ":" => [ 9, \&_action_opcode_564 ], },
	# [1167] opcode : ld l "," "(" ix
	{ ")" => 1168, "+" => 1169, "-" => 1172, },
	# [1168] opcode : ld l "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_565 ], ":" => [ 9, \&_action_opcode_565 ], },
	# [1169] opcode : ld l "," "(" ix "+"
	{ "!" => [ 14, 1170 ], "+" => [ 14, 1170 ], "-" => [ 14, 1170 ], __else__ => [ 14, 1170 ], "~" => [ 14, 1170 ], },
	# [1170] opcode : ld l "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1171, },
	# [1171] opcode : ld l "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_566 ], ":" => [ 9, \&_action_opcode_566 ], },
	# [1172] opcode : ld l "," "(" ix "-"
	{ "!" => [ 16, 1173 ], "+" => [ 16, 1173 ], "-" => [ 16, 1173 ], __else__ => [ 16, 1173 ], "~" => [ 16, 1173 ], },
	# [1173] opcode : ld l "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1174, },
	# [1174] opcode : ld l "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_566 ], ":" => [ 9, \&_action_opcode_566 ], },
	# [1175] opcode : ld l "," "(" iy
	{ ")" => 1176, "+" => 1177, "-" => 1180, },
	# [1176] opcode : ld l "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_567 ], ":" => [ 9, \&_action_opcode_567 ], },
	# [1177] opcode : ld l "," "(" iy "+"
	{ "!" => [ 14, 1178 ], "+" => [ 14, 1178 ], "-" => [ 14, 1178 ], __else__ => [ 14, 1178 ], "~" => [ 14, 1178 ], },
	# [1178] opcode : ld l "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1179, },
	# [1179] opcode : ld l "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_568 ], ":" => [ 9, \&_action_opcode_568 ], },
	# [1180] opcode : ld l "," "(" iy "-"
	{ "!" => [ 16, 1181 ], "+" => [ 16, 1181 ], "-" => [ 16, 1181 ], __else__ => [ 16, 1181 ], "~" => [ 16, 1181 ], },
	# [1181] opcode : ld l "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1182, },
	# [1182] opcode : ld l "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_568 ], ":" => [ 9, \&_action_opcode_568 ], },
	# [1183] opcode : ld l "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_569 ], ":" => [ 9, \&_action_opcode_569 ], },
	# [1184] opcode : ld l "," a
	{ "\n" => [ 9, \&_action_opcode_570 ], ":" => [ 9, \&_action_opcode_570 ], },
	# [1185] opcode : ld l "," b
	{ "\n" => [ 9, \&_action_opcode_571 ], ":" => [ 9, \&_action_opcode_571 ], },
	# [1186] opcode : ld l "," c
	{ "\n" => [ 9, \&_action_opcode_572 ], ":" => [ 9, \&_action_opcode_572 ], },
	# [1187] opcode : ld l "," d
	{ "\n" => [ 9, \&_action_opcode_573 ], ":" => [ 9, \&_action_opcode_573 ], },
	# [1188] opcode : ld l "," e
	{ "\n" => [ 9, \&_action_opcode_574 ], ":" => [ 9, \&_action_opcode_574 ], },
	# [1189] opcode : ld l "," h
	{ "\n" => [ 9, \&_action_opcode_575 ], ":" => [ 9, \&_action_opcode_575 ], },
	# [1190] opcode : ld l "," l
	{ "\n" => [ 9, \&_action_opcode_576 ], ":" => [ 9, \&_action_opcode_576 ], },
	# [1191] opcode : ld r
	{ "," => 1192, },
	# [1192] opcode : ld r ","
	{ a => 1193, },
	# [1193] opcode : ld r "," a
	{ "\n" => [ 9, \&_action_opcode_577 ], ":" => [ 9, \&_action_opcode_577 ], },
	# [1194] opcode : ld sp
	{ "," => 1195, },
	# [1195] opcode : ld sp ","
	{ "!" => [ 17, 1199 ], "(" => 1196, "+" => [ 17, 1199 ], "-" => [ 17, 1199 ], __else__ => [ 17, 1199 ], hl => 1200, ix => 1201, iy => 1202, "~" => [ 17, 1199 ], },
	# [1196] opcode : ld sp "," "("
	{ "!" => [ 17, 1197 ], "+" => [ 17, 1197 ], "-" => [ 17, 1197 ], __else__ => [ 17, 1197 ], "~" => [ 17, 1197 ], },
	# [1197] opcode : ld sp "," "(" "[expr_NN]"
	{ ")" => 1198, },
	# [1198] opcode : ld sp "," "(" "[expr_NN]" ")"
	{ "\n" => [ 9, \&_action_opcode_578 ], ":" => [ 9, \&_action_opcode_578 ], },
	# [1199] opcode : ld sp "," "[expr_NN]"
	{ "\n" => [ 9, \&_action_opcode_579 ], ":" => [ 9, \&_action_opcode_579 ], },
	# [1200] opcode : ld sp "," hl
	{ "\n" => [ 9, \&_action_opcode_580 ], ":" => [ 9, \&_action_opcode_580 ], },
	# [1201] opcode : ld sp "," ix
	{ "\n" => [ 9, \&_action_opcode_581 ], ":" => [ 9, \&_action_opcode_581 ], },
	# [1202] opcode : ld sp "," iy
	{ "\n" => [ 9, \&_action_opcode_582 ], ":" => [ 9, \&_action_opcode_582 ], },
	# [1203] opcode : ldd
	{ "\n" => [ 9, \&_action_opcode_583 ], "(" => 1204, ":" => [ 9, \&_action_opcode_583 ], a => 1294, b => 1319, c => 1340, d => 1361, e => 1382, h => 1403, l => 1424, },
	# [1204] opcode : ldd "("
	{ bc => 1205, de => 1209, hl => 1213, ix => 1224, iy => 1259, },
	# [1205] opcode : ldd "(" bc
	{ ")" => 1206, },
	# [1206] opcode : ldd "(" bc ")"
	{ "," => 1207, },
	# [1207] opcode : ldd "(" bc ")" ","
	{ a => 1208, },
	# [1208] opcode : ldd "(" bc ")" "," a
	{ "\n" => [ 9, \&_action_opcode_584 ], ":" => [ 9, \&_action_opcode_584 ], },
	# [1209] opcode : ldd "(" de
	{ ")" => 1210, },
	# [1210] opcode : ldd "(" de ")"
	{ "," => 1211, },
	# [1211] opcode : ldd "(" de ")" ","
	{ a => 1212, },
	# [1212] opcode : ldd "(" de ")" "," a
	{ "\n" => [ 9, \&_action_opcode_585 ], ":" => [ 9, \&_action_opcode_585 ], },
	# [1213] opcode : ldd "(" hl
	{ ")" => 1214, },
	# [1214] opcode : ldd "(" hl ")"
	{ "," => 1215, },
	# [1215] opcode : ldd "(" hl ")" ","
	{ "!" => [ 15, 1216 ], "+" => [ 15, 1216 ], "-" => [ 15, 1216 ], __else__ => [ 15, 1216 ], a => 1217, b => 1218, c => 1219, d => 1220, e => 1221, h => 1222, l => 1223, "~" => [ 15, 1216 ], },
	# [1216] opcode : ldd "(" hl ")" "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_586 ], ":" => [ 9, \&_action_opcode_586 ], },
	# [1217] opcode : ldd "(" hl ")" "," a
	{ "\n" => [ 9, \&_action_opcode_587 ], ":" => [ 9, \&_action_opcode_587 ], },
	# [1218] opcode : ldd "(" hl ")" "," b
	{ "\n" => [ 9, \&_action_opcode_588 ], ":" => [ 9, \&_action_opcode_588 ], },
	# [1219] opcode : ldd "(" hl ")" "," c
	{ "\n" => [ 9, \&_action_opcode_589 ], ":" => [ 9, \&_action_opcode_589 ], },
	# [1220] opcode : ldd "(" hl ")" "," d
	{ "\n" => [ 9, \&_action_opcode_590 ], ":" => [ 9, \&_action_opcode_590 ], },
	# [1221] opcode : ldd "(" hl ")" "," e
	{ "\n" => [ 9, \&_action_opcode_591 ], ":" => [ 9, \&_action_opcode_591 ], },
	# [1222] opcode : ldd "(" hl ")" "," h
	{ "\n" => [ 9, \&_action_opcode_592 ], ":" => [ 9, \&_action_opcode_592 ], },
	# [1223] opcode : ldd "(" hl ")" "," l
	{ "\n" => [ 9, \&_action_opcode_593 ], ":" => [ 9, \&_action_opcode_593 ], },
	# [1224] opcode : ldd "(" ix
	{ ")" => 1225, "+" => 1235, "-" => 1247, },
	# [1225] opcode : ldd "(" ix ")"
	{ "," => 1226, },
	# [1226] opcode : ldd "(" ix ")" ","
	{ "!" => [ 15, 1227 ], "+" => [ 15, 1227 ], "-" => [ 15, 1227 ], __else__ => [ 15, 1227 ], a => 1228, b => 1229, c => 1230, d => 1231, e => 1232, h => 1233, l => 1234, "~" => [ 15, 1227 ], },
	# [1227] opcode : ldd "(" ix ")" "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_594 ], ":" => [ 9, \&_action_opcode_594 ], },
	# [1228] opcode : ldd "(" ix ")" "," a
	{ "\n" => [ 9, \&_action_opcode_595 ], ":" => [ 9, \&_action_opcode_595 ], },
	# [1229] opcode : ldd "(" ix ")" "," b
	{ "\n" => [ 9, \&_action_opcode_596 ], ":" => [ 9, \&_action_opcode_596 ], },
	# [1230] opcode : ldd "(" ix ")" "," c
	{ "\n" => [ 9, \&_action_opcode_597 ], ":" => [ 9, \&_action_opcode_597 ], },
	# [1231] opcode : ldd "(" ix ")" "," d
	{ "\n" => [ 9, \&_action_opcode_598 ], ":" => [ 9, \&_action_opcode_598 ], },
	# [1232] opcode : ldd "(" ix ")" "," e
	{ "\n" => [ 9, \&_action_opcode_599 ], ":" => [ 9, \&_action_opcode_599 ], },
	# [1233] opcode : ldd "(" ix ")" "," h
	{ "\n" => [ 9, \&_action_opcode_600 ], ":" => [ 9, \&_action_opcode_600 ], },
	# [1234] opcode : ldd "(" ix ")" "," l
	{ "\n" => [ 9, \&_action_opcode_601 ], ":" => [ 9, \&_action_opcode_601 ], },
	# [1235] opcode : ldd "(" ix "+"
	{ "!" => [ 14, 1236 ], "+" => [ 14, 1236 ], "-" => [ 14, 1236 ], __else__ => [ 14, 1236 ], "~" => [ 14, 1236 ], },
	# [1236] opcode : ldd "(" ix "+" "[expr_DIS]"
	{ ")" => 1237, },
	# [1237] opcode : ldd "(" ix "+" "[expr_DIS]" ")"
	{ "," => 1238, },
	# [1238] opcode : ldd "(" ix "+" "[expr_DIS]" ")" ","
	{ "!" => [ 15, 1239 ], "+" => [ 15, 1239 ], "-" => [ 15, 1239 ], __else__ => [ 15, 1239 ], a => 1240, b => 1241, c => 1242, d => 1243, e => 1244, h => 1245, l => 1246, "~" => [ 15, 1239 ], },
	# [1239] opcode : ldd "(" ix "+" "[expr_DIS]" ")" "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_602 ], ":" => [ 9, \&_action_opcode_602 ], },
	# [1240] opcode : ldd "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_603 ], ":" => [ 9, \&_action_opcode_603 ], },
	# [1241] opcode : ldd "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_604 ], ":" => [ 9, \&_action_opcode_604 ], },
	# [1242] opcode : ldd "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_605 ], ":" => [ 9, \&_action_opcode_605 ], },
	# [1243] opcode : ldd "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_606 ], ":" => [ 9, \&_action_opcode_606 ], },
	# [1244] opcode : ldd "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_607 ], ":" => [ 9, \&_action_opcode_607 ], },
	# [1245] opcode : ldd "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_608 ], ":" => [ 9, \&_action_opcode_608 ], },
	# [1246] opcode : ldd "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_609 ], ":" => [ 9, \&_action_opcode_609 ], },
	# [1247] opcode : ldd "(" ix "-"
	{ "!" => [ 16, 1248 ], "+" => [ 16, 1248 ], "-" => [ 16, 1248 ], __else__ => [ 16, 1248 ], "~" => [ 16, 1248 ], },
	# [1248] opcode : ldd "(" ix "-" "[expr_NDIS]"
	{ ")" => 1249, },
	# [1249] opcode : ldd "(" ix "-" "[expr_NDIS]" ")"
	{ "," => 1250, },
	# [1250] opcode : ldd "(" ix "-" "[expr_NDIS]" ")" ","
	{ "!" => [ 15, 1251 ], "+" => [ 15, 1251 ], "-" => [ 15, 1251 ], __else__ => [ 15, 1251 ], a => 1252, b => 1253, c => 1254, d => 1255, e => 1256, h => 1257, l => 1258, "~" => [ 15, 1251 ], },
	# [1251] opcode : ldd "(" ix "-" "[expr_NDIS]" ")" "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_602 ], ":" => [ 9, \&_action_opcode_602 ], },
	# [1252] opcode : ldd "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_603 ], ":" => [ 9, \&_action_opcode_603 ], },
	# [1253] opcode : ldd "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_604 ], ":" => [ 9, \&_action_opcode_604 ], },
	# [1254] opcode : ldd "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_605 ], ":" => [ 9, \&_action_opcode_605 ], },
	# [1255] opcode : ldd "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_606 ], ":" => [ 9, \&_action_opcode_606 ], },
	# [1256] opcode : ldd "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_607 ], ":" => [ 9, \&_action_opcode_607 ], },
	# [1257] opcode : ldd "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_608 ], ":" => [ 9, \&_action_opcode_608 ], },
	# [1258] opcode : ldd "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_609 ], ":" => [ 9, \&_action_opcode_609 ], },
	# [1259] opcode : ldd "(" iy
	{ ")" => 1260, "+" => 1270, "-" => 1282, },
	# [1260] opcode : ldd "(" iy ")"
	{ "," => 1261, },
	# [1261] opcode : ldd "(" iy ")" ","
	{ "!" => [ 15, 1262 ], "+" => [ 15, 1262 ], "-" => [ 15, 1262 ], __else__ => [ 15, 1262 ], a => 1263, b => 1264, c => 1265, d => 1266, e => 1267, h => 1268, l => 1269, "~" => [ 15, 1262 ], },
	# [1262] opcode : ldd "(" iy ")" "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_610 ], ":" => [ 9, \&_action_opcode_610 ], },
	# [1263] opcode : ldd "(" iy ")" "," a
	{ "\n" => [ 9, \&_action_opcode_611 ], ":" => [ 9, \&_action_opcode_611 ], },
	# [1264] opcode : ldd "(" iy ")" "," b
	{ "\n" => [ 9, \&_action_opcode_612 ], ":" => [ 9, \&_action_opcode_612 ], },
	# [1265] opcode : ldd "(" iy ")" "," c
	{ "\n" => [ 9, \&_action_opcode_613 ], ":" => [ 9, \&_action_opcode_613 ], },
	# [1266] opcode : ldd "(" iy ")" "," d
	{ "\n" => [ 9, \&_action_opcode_614 ], ":" => [ 9, \&_action_opcode_614 ], },
	# [1267] opcode : ldd "(" iy ")" "," e
	{ "\n" => [ 9, \&_action_opcode_615 ], ":" => [ 9, \&_action_opcode_615 ], },
	# [1268] opcode : ldd "(" iy ")" "," h
	{ "\n" => [ 9, \&_action_opcode_616 ], ":" => [ 9, \&_action_opcode_616 ], },
	# [1269] opcode : ldd "(" iy ")" "," l
	{ "\n" => [ 9, \&_action_opcode_617 ], ":" => [ 9, \&_action_opcode_617 ], },
	# [1270] opcode : ldd "(" iy "+"
	{ "!" => [ 14, 1271 ], "+" => [ 14, 1271 ], "-" => [ 14, 1271 ], __else__ => [ 14, 1271 ], "~" => [ 14, 1271 ], },
	# [1271] opcode : ldd "(" iy "+" "[expr_DIS]"
	{ ")" => 1272, },
	# [1272] opcode : ldd "(" iy "+" "[expr_DIS]" ")"
	{ "," => 1273, },
	# [1273] opcode : ldd "(" iy "+" "[expr_DIS]" ")" ","
	{ "!" => [ 15, 1274 ], "+" => [ 15, 1274 ], "-" => [ 15, 1274 ], __else__ => [ 15, 1274 ], a => 1275, b => 1276, c => 1277, d => 1278, e => 1279, h => 1280, l => 1281, "~" => [ 15, 1274 ], },
	# [1274] opcode : ldd "(" iy "+" "[expr_DIS]" ")" "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_618 ], ":" => [ 9, \&_action_opcode_618 ], },
	# [1275] opcode : ldd "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_619 ], ":" => [ 9, \&_action_opcode_619 ], },
	# [1276] opcode : ldd "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_620 ], ":" => [ 9, \&_action_opcode_620 ], },
	# [1277] opcode : ldd "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_621 ], ":" => [ 9, \&_action_opcode_621 ], },
	# [1278] opcode : ldd "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_622 ], ":" => [ 9, \&_action_opcode_622 ], },
	# [1279] opcode : ldd "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_623 ], ":" => [ 9, \&_action_opcode_623 ], },
	# [1280] opcode : ldd "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_624 ], ":" => [ 9, \&_action_opcode_624 ], },
	# [1281] opcode : ldd "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_625 ], ":" => [ 9, \&_action_opcode_625 ], },
	# [1282] opcode : ldd "(" iy "-"
	{ "!" => [ 16, 1283 ], "+" => [ 16, 1283 ], "-" => [ 16, 1283 ], __else__ => [ 16, 1283 ], "~" => [ 16, 1283 ], },
	# [1283] opcode : ldd "(" iy "-" "[expr_NDIS]"
	{ ")" => 1284, },
	# [1284] opcode : ldd "(" iy "-" "[expr_NDIS]" ")"
	{ "," => 1285, },
	# [1285] opcode : ldd "(" iy "-" "[expr_NDIS]" ")" ","
	{ "!" => [ 15, 1286 ], "+" => [ 15, 1286 ], "-" => [ 15, 1286 ], __else__ => [ 15, 1286 ], a => 1287, b => 1288, c => 1289, d => 1290, e => 1291, h => 1292, l => 1293, "~" => [ 15, 1286 ], },
	# [1286] opcode : ldd "(" iy "-" "[expr_NDIS]" ")" "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_618 ], ":" => [ 9, \&_action_opcode_618 ], },
	# [1287] opcode : ldd "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_619 ], ":" => [ 9, \&_action_opcode_619 ], },
	# [1288] opcode : ldd "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_620 ], ":" => [ 9, \&_action_opcode_620 ], },
	# [1289] opcode : ldd "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_621 ], ":" => [ 9, \&_action_opcode_621 ], },
	# [1290] opcode : ldd "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_622 ], ":" => [ 9, \&_action_opcode_622 ], },
	# [1291] opcode : ldd "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_623 ], ":" => [ 9, \&_action_opcode_623 ], },
	# [1292] opcode : ldd "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_624 ], ":" => [ 9, \&_action_opcode_624 ], },
	# [1293] opcode : ldd "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_625 ], ":" => [ 9, \&_action_opcode_625 ], },
	# [1294] opcode : ldd a
	{ "," => 1295, },
	# [1295] opcode : ldd a ","
	{ "(" => 1296, },
	# [1296] opcode : ldd a "," "("
	{ bc => 1297, de => 1299, hl => 1301, ix => 1303, iy => 1311, },
	# [1297] opcode : ldd a "," "(" bc
	{ ")" => 1298, },
	# [1298] opcode : ldd a "," "(" bc ")"
	{ "\n" => [ 9, \&_action_opcode_626 ], ":" => [ 9, \&_action_opcode_626 ], },
	# [1299] opcode : ldd a "," "(" de
	{ ")" => 1300, },
	# [1300] opcode : ldd a "," "(" de ")"
	{ "\n" => [ 9, \&_action_opcode_627 ], ":" => [ 9, \&_action_opcode_627 ], },
	# [1301] opcode : ldd a "," "(" hl
	{ ")" => 1302, },
	# [1302] opcode : ldd a "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_628 ], ":" => [ 9, \&_action_opcode_628 ], },
	# [1303] opcode : ldd a "," "(" ix
	{ ")" => 1304, "+" => 1305, "-" => 1308, },
	# [1304] opcode : ldd a "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_629 ], ":" => [ 9, \&_action_opcode_629 ], },
	# [1305] opcode : ldd a "," "(" ix "+"
	{ "!" => [ 14, 1306 ], "+" => [ 14, 1306 ], "-" => [ 14, 1306 ], __else__ => [ 14, 1306 ], "~" => [ 14, 1306 ], },
	# [1306] opcode : ldd a "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1307, },
	# [1307] opcode : ldd a "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_630 ], ":" => [ 9, \&_action_opcode_630 ], },
	# [1308] opcode : ldd a "," "(" ix "-"
	{ "!" => [ 16, 1309 ], "+" => [ 16, 1309 ], "-" => [ 16, 1309 ], __else__ => [ 16, 1309 ], "~" => [ 16, 1309 ], },
	# [1309] opcode : ldd a "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1310, },
	# [1310] opcode : ldd a "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_630 ], ":" => [ 9, \&_action_opcode_630 ], },
	# [1311] opcode : ldd a "," "(" iy
	{ ")" => 1312, "+" => 1313, "-" => 1316, },
	# [1312] opcode : ldd a "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_631 ], ":" => [ 9, \&_action_opcode_631 ], },
	# [1313] opcode : ldd a "," "(" iy "+"
	{ "!" => [ 14, 1314 ], "+" => [ 14, 1314 ], "-" => [ 14, 1314 ], __else__ => [ 14, 1314 ], "~" => [ 14, 1314 ], },
	# [1314] opcode : ldd a "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1315, },
	# [1315] opcode : ldd a "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_632 ], ":" => [ 9, \&_action_opcode_632 ], },
	# [1316] opcode : ldd a "," "(" iy "-"
	{ "!" => [ 16, 1317 ], "+" => [ 16, 1317 ], "-" => [ 16, 1317 ], __else__ => [ 16, 1317 ], "~" => [ 16, 1317 ], },
	# [1317] opcode : ldd a "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1318, },
	# [1318] opcode : ldd a "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_632 ], ":" => [ 9, \&_action_opcode_632 ], },
	# [1319] opcode : ldd b
	{ "," => 1320, },
	# [1320] opcode : ldd b ","
	{ "(" => 1321, },
	# [1321] opcode : ldd b "," "("
	{ hl => 1322, ix => 1324, iy => 1332, },
	# [1322] opcode : ldd b "," "(" hl
	{ ")" => 1323, },
	# [1323] opcode : ldd b "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_633 ], ":" => [ 9, \&_action_opcode_633 ], },
	# [1324] opcode : ldd b "," "(" ix
	{ ")" => 1325, "+" => 1326, "-" => 1329, },
	# [1325] opcode : ldd b "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_634 ], ":" => [ 9, \&_action_opcode_634 ], },
	# [1326] opcode : ldd b "," "(" ix "+"
	{ "!" => [ 14, 1327 ], "+" => [ 14, 1327 ], "-" => [ 14, 1327 ], __else__ => [ 14, 1327 ], "~" => [ 14, 1327 ], },
	# [1327] opcode : ldd b "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1328, },
	# [1328] opcode : ldd b "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_635 ], ":" => [ 9, \&_action_opcode_635 ], },
	# [1329] opcode : ldd b "," "(" ix "-"
	{ "!" => [ 16, 1330 ], "+" => [ 16, 1330 ], "-" => [ 16, 1330 ], __else__ => [ 16, 1330 ], "~" => [ 16, 1330 ], },
	# [1330] opcode : ldd b "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1331, },
	# [1331] opcode : ldd b "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_635 ], ":" => [ 9, \&_action_opcode_635 ], },
	# [1332] opcode : ldd b "," "(" iy
	{ ")" => 1333, "+" => 1334, "-" => 1337, },
	# [1333] opcode : ldd b "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_636 ], ":" => [ 9, \&_action_opcode_636 ], },
	# [1334] opcode : ldd b "," "(" iy "+"
	{ "!" => [ 14, 1335 ], "+" => [ 14, 1335 ], "-" => [ 14, 1335 ], __else__ => [ 14, 1335 ], "~" => [ 14, 1335 ], },
	# [1335] opcode : ldd b "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1336, },
	# [1336] opcode : ldd b "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_637 ], ":" => [ 9, \&_action_opcode_637 ], },
	# [1337] opcode : ldd b "," "(" iy "-"
	{ "!" => [ 16, 1338 ], "+" => [ 16, 1338 ], "-" => [ 16, 1338 ], __else__ => [ 16, 1338 ], "~" => [ 16, 1338 ], },
	# [1338] opcode : ldd b "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1339, },
	# [1339] opcode : ldd b "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_637 ], ":" => [ 9, \&_action_opcode_637 ], },
	# [1340] opcode : ldd c
	{ "," => 1341, },
	# [1341] opcode : ldd c ","
	{ "(" => 1342, },
	# [1342] opcode : ldd c "," "("
	{ hl => 1343, ix => 1345, iy => 1353, },
	# [1343] opcode : ldd c "," "(" hl
	{ ")" => 1344, },
	# [1344] opcode : ldd c "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_638 ], ":" => [ 9, \&_action_opcode_638 ], },
	# [1345] opcode : ldd c "," "(" ix
	{ ")" => 1346, "+" => 1347, "-" => 1350, },
	# [1346] opcode : ldd c "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_639 ], ":" => [ 9, \&_action_opcode_639 ], },
	# [1347] opcode : ldd c "," "(" ix "+"
	{ "!" => [ 14, 1348 ], "+" => [ 14, 1348 ], "-" => [ 14, 1348 ], __else__ => [ 14, 1348 ], "~" => [ 14, 1348 ], },
	# [1348] opcode : ldd c "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1349, },
	# [1349] opcode : ldd c "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_640 ], ":" => [ 9, \&_action_opcode_640 ], },
	# [1350] opcode : ldd c "," "(" ix "-"
	{ "!" => [ 16, 1351 ], "+" => [ 16, 1351 ], "-" => [ 16, 1351 ], __else__ => [ 16, 1351 ], "~" => [ 16, 1351 ], },
	# [1351] opcode : ldd c "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1352, },
	# [1352] opcode : ldd c "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_640 ], ":" => [ 9, \&_action_opcode_640 ], },
	# [1353] opcode : ldd c "," "(" iy
	{ ")" => 1354, "+" => 1355, "-" => 1358, },
	# [1354] opcode : ldd c "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_641 ], ":" => [ 9, \&_action_opcode_641 ], },
	# [1355] opcode : ldd c "," "(" iy "+"
	{ "!" => [ 14, 1356 ], "+" => [ 14, 1356 ], "-" => [ 14, 1356 ], __else__ => [ 14, 1356 ], "~" => [ 14, 1356 ], },
	# [1356] opcode : ldd c "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1357, },
	# [1357] opcode : ldd c "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_642 ], ":" => [ 9, \&_action_opcode_642 ], },
	# [1358] opcode : ldd c "," "(" iy "-"
	{ "!" => [ 16, 1359 ], "+" => [ 16, 1359 ], "-" => [ 16, 1359 ], __else__ => [ 16, 1359 ], "~" => [ 16, 1359 ], },
	# [1359] opcode : ldd c "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1360, },
	# [1360] opcode : ldd c "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_642 ], ":" => [ 9, \&_action_opcode_642 ], },
	# [1361] opcode : ldd d
	{ "," => 1362, },
	# [1362] opcode : ldd d ","
	{ "(" => 1363, },
	# [1363] opcode : ldd d "," "("
	{ hl => 1364, ix => 1366, iy => 1374, },
	# [1364] opcode : ldd d "," "(" hl
	{ ")" => 1365, },
	# [1365] opcode : ldd d "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_643 ], ":" => [ 9, \&_action_opcode_643 ], },
	# [1366] opcode : ldd d "," "(" ix
	{ ")" => 1367, "+" => 1368, "-" => 1371, },
	# [1367] opcode : ldd d "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_644 ], ":" => [ 9, \&_action_opcode_644 ], },
	# [1368] opcode : ldd d "," "(" ix "+"
	{ "!" => [ 14, 1369 ], "+" => [ 14, 1369 ], "-" => [ 14, 1369 ], __else__ => [ 14, 1369 ], "~" => [ 14, 1369 ], },
	# [1369] opcode : ldd d "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1370, },
	# [1370] opcode : ldd d "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_645 ], ":" => [ 9, \&_action_opcode_645 ], },
	# [1371] opcode : ldd d "," "(" ix "-"
	{ "!" => [ 16, 1372 ], "+" => [ 16, 1372 ], "-" => [ 16, 1372 ], __else__ => [ 16, 1372 ], "~" => [ 16, 1372 ], },
	# [1372] opcode : ldd d "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1373, },
	# [1373] opcode : ldd d "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_645 ], ":" => [ 9, \&_action_opcode_645 ], },
	# [1374] opcode : ldd d "," "(" iy
	{ ")" => 1375, "+" => 1376, "-" => 1379, },
	# [1375] opcode : ldd d "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_646 ], ":" => [ 9, \&_action_opcode_646 ], },
	# [1376] opcode : ldd d "," "(" iy "+"
	{ "!" => [ 14, 1377 ], "+" => [ 14, 1377 ], "-" => [ 14, 1377 ], __else__ => [ 14, 1377 ], "~" => [ 14, 1377 ], },
	# [1377] opcode : ldd d "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1378, },
	# [1378] opcode : ldd d "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_647 ], ":" => [ 9, \&_action_opcode_647 ], },
	# [1379] opcode : ldd d "," "(" iy "-"
	{ "!" => [ 16, 1380 ], "+" => [ 16, 1380 ], "-" => [ 16, 1380 ], __else__ => [ 16, 1380 ], "~" => [ 16, 1380 ], },
	# [1380] opcode : ldd d "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1381, },
	# [1381] opcode : ldd d "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_647 ], ":" => [ 9, \&_action_opcode_647 ], },
	# [1382] opcode : ldd e
	{ "," => 1383, },
	# [1383] opcode : ldd e ","
	{ "(" => 1384, },
	# [1384] opcode : ldd e "," "("
	{ hl => 1385, ix => 1387, iy => 1395, },
	# [1385] opcode : ldd e "," "(" hl
	{ ")" => 1386, },
	# [1386] opcode : ldd e "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_648 ], ":" => [ 9, \&_action_opcode_648 ], },
	# [1387] opcode : ldd e "," "(" ix
	{ ")" => 1388, "+" => 1389, "-" => 1392, },
	# [1388] opcode : ldd e "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_649 ], ":" => [ 9, \&_action_opcode_649 ], },
	# [1389] opcode : ldd e "," "(" ix "+"
	{ "!" => [ 14, 1390 ], "+" => [ 14, 1390 ], "-" => [ 14, 1390 ], __else__ => [ 14, 1390 ], "~" => [ 14, 1390 ], },
	# [1390] opcode : ldd e "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1391, },
	# [1391] opcode : ldd e "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_650 ], ":" => [ 9, \&_action_opcode_650 ], },
	# [1392] opcode : ldd e "," "(" ix "-"
	{ "!" => [ 16, 1393 ], "+" => [ 16, 1393 ], "-" => [ 16, 1393 ], __else__ => [ 16, 1393 ], "~" => [ 16, 1393 ], },
	# [1393] opcode : ldd e "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1394, },
	# [1394] opcode : ldd e "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_650 ], ":" => [ 9, \&_action_opcode_650 ], },
	# [1395] opcode : ldd e "," "(" iy
	{ ")" => 1396, "+" => 1397, "-" => 1400, },
	# [1396] opcode : ldd e "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_651 ], ":" => [ 9, \&_action_opcode_651 ], },
	# [1397] opcode : ldd e "," "(" iy "+"
	{ "!" => [ 14, 1398 ], "+" => [ 14, 1398 ], "-" => [ 14, 1398 ], __else__ => [ 14, 1398 ], "~" => [ 14, 1398 ], },
	# [1398] opcode : ldd e "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1399, },
	# [1399] opcode : ldd e "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_652 ], ":" => [ 9, \&_action_opcode_652 ], },
	# [1400] opcode : ldd e "," "(" iy "-"
	{ "!" => [ 16, 1401 ], "+" => [ 16, 1401 ], "-" => [ 16, 1401 ], __else__ => [ 16, 1401 ], "~" => [ 16, 1401 ], },
	# [1401] opcode : ldd e "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1402, },
	# [1402] opcode : ldd e "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_652 ], ":" => [ 9, \&_action_opcode_652 ], },
	# [1403] opcode : ldd h
	{ "," => 1404, },
	# [1404] opcode : ldd h ","
	{ "(" => 1405, },
	# [1405] opcode : ldd h "," "("
	{ hl => 1406, ix => 1408, iy => 1416, },
	# [1406] opcode : ldd h "," "(" hl
	{ ")" => 1407, },
	# [1407] opcode : ldd h "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_653 ], ":" => [ 9, \&_action_opcode_653 ], },
	# [1408] opcode : ldd h "," "(" ix
	{ ")" => 1409, "+" => 1410, "-" => 1413, },
	# [1409] opcode : ldd h "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_654 ], ":" => [ 9, \&_action_opcode_654 ], },
	# [1410] opcode : ldd h "," "(" ix "+"
	{ "!" => [ 14, 1411 ], "+" => [ 14, 1411 ], "-" => [ 14, 1411 ], __else__ => [ 14, 1411 ], "~" => [ 14, 1411 ], },
	# [1411] opcode : ldd h "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1412, },
	# [1412] opcode : ldd h "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_655 ], ":" => [ 9, \&_action_opcode_655 ], },
	# [1413] opcode : ldd h "," "(" ix "-"
	{ "!" => [ 16, 1414 ], "+" => [ 16, 1414 ], "-" => [ 16, 1414 ], __else__ => [ 16, 1414 ], "~" => [ 16, 1414 ], },
	# [1414] opcode : ldd h "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1415, },
	# [1415] opcode : ldd h "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_655 ], ":" => [ 9, \&_action_opcode_655 ], },
	# [1416] opcode : ldd h "," "(" iy
	{ ")" => 1417, "+" => 1418, "-" => 1421, },
	# [1417] opcode : ldd h "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_656 ], ":" => [ 9, \&_action_opcode_656 ], },
	# [1418] opcode : ldd h "," "(" iy "+"
	{ "!" => [ 14, 1419 ], "+" => [ 14, 1419 ], "-" => [ 14, 1419 ], __else__ => [ 14, 1419 ], "~" => [ 14, 1419 ], },
	# [1419] opcode : ldd h "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1420, },
	# [1420] opcode : ldd h "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_657 ], ":" => [ 9, \&_action_opcode_657 ], },
	# [1421] opcode : ldd h "," "(" iy "-"
	{ "!" => [ 16, 1422 ], "+" => [ 16, 1422 ], "-" => [ 16, 1422 ], __else__ => [ 16, 1422 ], "~" => [ 16, 1422 ], },
	# [1422] opcode : ldd h "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1423, },
	# [1423] opcode : ldd h "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_657 ], ":" => [ 9, \&_action_opcode_657 ], },
	# [1424] opcode : ldd l
	{ "," => 1425, },
	# [1425] opcode : ldd l ","
	{ "(" => 1426, },
	# [1426] opcode : ldd l "," "("
	{ hl => 1427, ix => 1429, iy => 1437, },
	# [1427] opcode : ldd l "," "(" hl
	{ ")" => 1428, },
	# [1428] opcode : ldd l "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_658 ], ":" => [ 9, \&_action_opcode_658 ], },
	# [1429] opcode : ldd l "," "(" ix
	{ ")" => 1430, "+" => 1431, "-" => 1434, },
	# [1430] opcode : ldd l "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_659 ], ":" => [ 9, \&_action_opcode_659 ], },
	# [1431] opcode : ldd l "," "(" ix "+"
	{ "!" => [ 14, 1432 ], "+" => [ 14, 1432 ], "-" => [ 14, 1432 ], __else__ => [ 14, 1432 ], "~" => [ 14, 1432 ], },
	# [1432] opcode : ldd l "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1433, },
	# [1433] opcode : ldd l "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_660 ], ":" => [ 9, \&_action_opcode_660 ], },
	# [1434] opcode : ldd l "," "(" ix "-"
	{ "!" => [ 16, 1435 ], "+" => [ 16, 1435 ], "-" => [ 16, 1435 ], __else__ => [ 16, 1435 ], "~" => [ 16, 1435 ], },
	# [1435] opcode : ldd l "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1436, },
	# [1436] opcode : ldd l "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_660 ], ":" => [ 9, \&_action_opcode_660 ], },
	# [1437] opcode : ldd l "," "(" iy
	{ ")" => 1438, "+" => 1439, "-" => 1442, },
	# [1438] opcode : ldd l "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_661 ], ":" => [ 9, \&_action_opcode_661 ], },
	# [1439] opcode : ldd l "," "(" iy "+"
	{ "!" => [ 14, 1440 ], "+" => [ 14, 1440 ], "-" => [ 14, 1440 ], __else__ => [ 14, 1440 ], "~" => [ 14, 1440 ], },
	# [1440] opcode : ldd l "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1441, },
	# [1441] opcode : ldd l "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_662 ], ":" => [ 9, \&_action_opcode_662 ], },
	# [1442] opcode : ldd l "," "(" iy "-"
	{ "!" => [ 16, 1443 ], "+" => [ 16, 1443 ], "-" => [ 16, 1443 ], __else__ => [ 16, 1443 ], "~" => [ 16, 1443 ], },
	# [1443] opcode : ldd l "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1444, },
	# [1444] opcode : ldd l "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_662 ], ":" => [ 9, \&_action_opcode_662 ], },
	# [1445] opcode : lddr
	{ "\n" => [ 9, \&_action_opcode_663 ], ":" => [ 9, \&_action_opcode_663 ], },
	# [1446] opcode : ldi
	{ "\n" => [ 9, \&_action_opcode_664 ], "(" => 1447, ":" => [ 9, \&_action_opcode_664 ], a => 1557, b => 1582, bc => 1603, c => 1624, d => 1645, de => 1666, e => 1687, h => 1708, hl => 1729, l => 1748, },
	# [1447] opcode : ldi "("
	{ bc => 1448, de => 1452, hl => 1456, ix => 1469, iy => 1513, },
	# [1448] opcode : ldi "(" bc
	{ ")" => 1449, },
	# [1449] opcode : ldi "(" bc ")"
	{ "," => 1450, },
	# [1450] opcode : ldi "(" bc ")" ","
	{ a => 1451, },
	# [1451] opcode : ldi "(" bc ")" "," a
	{ "\n" => [ 9, \&_action_opcode_665 ], ":" => [ 9, \&_action_opcode_665 ], },
	# [1452] opcode : ldi "(" de
	{ ")" => 1453, },
	# [1453] opcode : ldi "(" de ")"
	{ "," => 1454, },
	# [1454] opcode : ldi "(" de ")" ","
	{ a => 1455, },
	# [1455] opcode : ldi "(" de ")" "," a
	{ "\n" => [ 9, \&_action_opcode_666 ], ":" => [ 9, \&_action_opcode_666 ], },
	# [1456] opcode : ldi "(" hl
	{ ")" => 1457, },
	# [1457] opcode : ldi "(" hl ")"
	{ "," => 1458, },
	# [1458] opcode : ldi "(" hl ")" ","
	{ "!" => [ 15, 1459 ], "+" => [ 15, 1459 ], "-" => [ 15, 1459 ], __else__ => [ 15, 1459 ], a => 1460, b => 1461, bc => 1462, c => 1463, d => 1464, de => 1465, e => 1466, h => 1467, l => 1468, "~" => [ 15, 1459 ], },
	# [1459] opcode : ldi "(" hl ")" "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_667 ], ":" => [ 9, \&_action_opcode_667 ], },
	# [1460] opcode : ldi "(" hl ")" "," a
	{ "\n" => [ 9, \&_action_opcode_668 ], ":" => [ 9, \&_action_opcode_668 ], },
	# [1461] opcode : ldi "(" hl ")" "," b
	{ "\n" => [ 9, \&_action_opcode_669 ], ":" => [ 9, \&_action_opcode_669 ], },
	# [1462] opcode : ldi "(" hl ")" "," bc
	{ "\n" => [ 9, \&_action_opcode_670 ], ":" => [ 9, \&_action_opcode_670 ], },
	# [1463] opcode : ldi "(" hl ")" "," c
	{ "\n" => [ 9, \&_action_opcode_671 ], ":" => [ 9, \&_action_opcode_671 ], },
	# [1464] opcode : ldi "(" hl ")" "," d
	{ "\n" => [ 9, \&_action_opcode_672 ], ":" => [ 9, \&_action_opcode_672 ], },
	# [1465] opcode : ldi "(" hl ")" "," de
	{ "\n" => [ 9, \&_action_opcode_673 ], ":" => [ 9, \&_action_opcode_673 ], },
	# [1466] opcode : ldi "(" hl ")" "," e
	{ "\n" => [ 9, \&_action_opcode_674 ], ":" => [ 9, \&_action_opcode_674 ], },
	# [1467] opcode : ldi "(" hl ")" "," h
	{ "\n" => [ 9, \&_action_opcode_675 ], ":" => [ 9, \&_action_opcode_675 ], },
	# [1468] opcode : ldi "(" hl ")" "," l
	{ "\n" => [ 9, \&_action_opcode_676 ], ":" => [ 9, \&_action_opcode_676 ], },
	# [1469] opcode : ldi "(" ix
	{ ")" => 1470, "+" => 1483, "-" => 1498, },
	# [1470] opcode : ldi "(" ix ")"
	{ "," => 1471, },
	# [1471] opcode : ldi "(" ix ")" ","
	{ "!" => [ 15, 1472 ], "+" => [ 15, 1472 ], "-" => [ 15, 1472 ], __else__ => [ 15, 1472 ], a => 1473, b => 1474, bc => 1475, c => 1476, d => 1477, de => 1478, e => 1479, h => 1480, hl => 1481, l => 1482, "~" => [ 15, 1472 ], },
	# [1472] opcode : ldi "(" ix ")" "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_677 ], ":" => [ 9, \&_action_opcode_677 ], },
	# [1473] opcode : ldi "(" ix ")" "," a
	{ "\n" => [ 9, \&_action_opcode_678 ], ":" => [ 9, \&_action_opcode_678 ], },
	# [1474] opcode : ldi "(" ix ")" "," b
	{ "\n" => [ 9, \&_action_opcode_679 ], ":" => [ 9, \&_action_opcode_679 ], },
	# [1475] opcode : ldi "(" ix ")" "," bc
	{ "\n" => [ 9, \&_action_opcode_680 ], ":" => [ 9, \&_action_opcode_680 ], },
	# [1476] opcode : ldi "(" ix ")" "," c
	{ "\n" => [ 9, \&_action_opcode_681 ], ":" => [ 9, \&_action_opcode_681 ], },
	# [1477] opcode : ldi "(" ix ")" "," d
	{ "\n" => [ 9, \&_action_opcode_682 ], ":" => [ 9, \&_action_opcode_682 ], },
	# [1478] opcode : ldi "(" ix ")" "," de
	{ "\n" => [ 9, \&_action_opcode_683 ], ":" => [ 9, \&_action_opcode_683 ], },
	# [1479] opcode : ldi "(" ix ")" "," e
	{ "\n" => [ 9, \&_action_opcode_684 ], ":" => [ 9, \&_action_opcode_684 ], },
	# [1480] opcode : ldi "(" ix ")" "," h
	{ "\n" => [ 9, \&_action_opcode_685 ], ":" => [ 9, \&_action_opcode_685 ], },
	# [1481] opcode : ldi "(" ix ")" "," hl
	{ "\n" => [ 9, \&_action_opcode_686 ], ":" => [ 9, \&_action_opcode_686 ], },
	# [1482] opcode : ldi "(" ix ")" "," l
	{ "\n" => [ 9, \&_action_opcode_687 ], ":" => [ 9, \&_action_opcode_687 ], },
	# [1483] opcode : ldi "(" ix "+"
	{ "!" => [ 14, 1484 ], "+" => [ 14, 1484 ], "-" => [ 14, 1484 ], __else__ => [ 14, 1484 ], "~" => [ 14, 1484 ], },
	# [1484] opcode : ldi "(" ix "+" "[expr_DIS]"
	{ ")" => 1485, },
	# [1485] opcode : ldi "(" ix "+" "[expr_DIS]" ")"
	{ "," => 1486, },
	# [1486] opcode : ldi "(" ix "+" "[expr_DIS]" ")" ","
	{ "!" => [ 15, 1487 ], "+" => [ 15, 1487 ], "-" => [ 15, 1487 ], __else__ => [ 15, 1487 ], a => 1488, b => 1489, bc => 1490, c => 1491, d => 1492, de => 1493, e => 1494, h => 1495, hl => 1496, l => 1497, "~" => [ 15, 1487 ], },
	# [1487] opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_688 ], ":" => [ 9, \&_action_opcode_688 ], },
	# [1488] opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_689 ], ":" => [ 9, \&_action_opcode_689 ], },
	# [1489] opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_690 ], ":" => [ 9, \&_action_opcode_690 ], },
	# [1490] opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," bc
	{ "\n" => [ 9, \&_action_opcode_691 ], ":" => [ 9, \&_action_opcode_691 ], },
	# [1491] opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_692 ], ":" => [ 9, \&_action_opcode_692 ], },
	# [1492] opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_693 ], ":" => [ 9, \&_action_opcode_693 ], },
	# [1493] opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," de
	{ "\n" => [ 9, \&_action_opcode_694 ], ":" => [ 9, \&_action_opcode_694 ], },
	# [1494] opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_695 ], ":" => [ 9, \&_action_opcode_695 ], },
	# [1495] opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_696 ], ":" => [ 9, \&_action_opcode_696 ], },
	# [1496] opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," hl
	{ "\n" => [ 9, \&_action_opcode_697 ], ":" => [ 9, \&_action_opcode_697 ], },
	# [1497] opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_698 ], ":" => [ 9, \&_action_opcode_698 ], },
	# [1498] opcode : ldi "(" ix "-"
	{ "!" => [ 16, 1499 ], "+" => [ 16, 1499 ], "-" => [ 16, 1499 ], __else__ => [ 16, 1499 ], "~" => [ 16, 1499 ], },
	# [1499] opcode : ldi "(" ix "-" "[expr_NDIS]"
	{ ")" => 1500, },
	# [1500] opcode : ldi "(" ix "-" "[expr_NDIS]" ")"
	{ "," => 1501, },
	# [1501] opcode : ldi "(" ix "-" "[expr_NDIS]" ")" ","
	{ "!" => [ 15, 1502 ], "+" => [ 15, 1502 ], "-" => [ 15, 1502 ], __else__ => [ 15, 1502 ], a => 1503, b => 1504, bc => 1505, c => 1506, d => 1507, de => 1508, e => 1509, h => 1510, hl => 1511, l => 1512, "~" => [ 15, 1502 ], },
	# [1502] opcode : ldi "(" ix "-" "[expr_NDIS]" ")" "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_688 ], ":" => [ 9, \&_action_opcode_688 ], },
	# [1503] opcode : ldi "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_689 ], ":" => [ 9, \&_action_opcode_689 ], },
	# [1504] opcode : ldi "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_690 ], ":" => [ 9, \&_action_opcode_690 ], },
	# [1505] opcode : ldi "(" ix "-" "[expr_NDIS]" ")" "," bc
	{ "\n" => [ 9, \&_action_opcode_691 ], ":" => [ 9, \&_action_opcode_691 ], },
	# [1506] opcode : ldi "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_692 ], ":" => [ 9, \&_action_opcode_692 ], },
	# [1507] opcode : ldi "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_693 ], ":" => [ 9, \&_action_opcode_693 ], },
	# [1508] opcode : ldi "(" ix "-" "[expr_NDIS]" ")" "," de
	{ "\n" => [ 9, \&_action_opcode_694 ], ":" => [ 9, \&_action_opcode_694 ], },
	# [1509] opcode : ldi "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_695 ], ":" => [ 9, \&_action_opcode_695 ], },
	# [1510] opcode : ldi "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_696 ], ":" => [ 9, \&_action_opcode_696 ], },
	# [1511] opcode : ldi "(" ix "-" "[expr_NDIS]" ")" "," hl
	{ "\n" => [ 9, \&_action_opcode_697 ], ":" => [ 9, \&_action_opcode_697 ], },
	# [1512] opcode : ldi "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_698 ], ":" => [ 9, \&_action_opcode_698 ], },
	# [1513] opcode : ldi "(" iy
	{ ")" => 1514, "+" => 1527, "-" => 1542, },
	# [1514] opcode : ldi "(" iy ")"
	{ "," => 1515, },
	# [1515] opcode : ldi "(" iy ")" ","
	{ "!" => [ 15, 1516 ], "+" => [ 15, 1516 ], "-" => [ 15, 1516 ], __else__ => [ 15, 1516 ], a => 1517, b => 1518, bc => 1519, c => 1520, d => 1521, de => 1522, e => 1523, h => 1524, hl => 1525, l => 1526, "~" => [ 15, 1516 ], },
	# [1516] opcode : ldi "(" iy ")" "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_699 ], ":" => [ 9, \&_action_opcode_699 ], },
	# [1517] opcode : ldi "(" iy ")" "," a
	{ "\n" => [ 9, \&_action_opcode_700 ], ":" => [ 9, \&_action_opcode_700 ], },
	# [1518] opcode : ldi "(" iy ")" "," b
	{ "\n" => [ 9, \&_action_opcode_701 ], ":" => [ 9, \&_action_opcode_701 ], },
	# [1519] opcode : ldi "(" iy ")" "," bc
	{ "\n" => [ 9, \&_action_opcode_702 ], ":" => [ 9, \&_action_opcode_702 ], },
	# [1520] opcode : ldi "(" iy ")" "," c
	{ "\n" => [ 9, \&_action_opcode_703 ], ":" => [ 9, \&_action_opcode_703 ], },
	# [1521] opcode : ldi "(" iy ")" "," d
	{ "\n" => [ 9, \&_action_opcode_704 ], ":" => [ 9, \&_action_opcode_704 ], },
	# [1522] opcode : ldi "(" iy ")" "," de
	{ "\n" => [ 9, \&_action_opcode_705 ], ":" => [ 9, \&_action_opcode_705 ], },
	# [1523] opcode : ldi "(" iy ")" "," e
	{ "\n" => [ 9, \&_action_opcode_706 ], ":" => [ 9, \&_action_opcode_706 ], },
	# [1524] opcode : ldi "(" iy ")" "," h
	{ "\n" => [ 9, \&_action_opcode_707 ], ":" => [ 9, \&_action_opcode_707 ], },
	# [1525] opcode : ldi "(" iy ")" "," hl
	{ "\n" => [ 9, \&_action_opcode_708 ], ":" => [ 9, \&_action_opcode_708 ], },
	# [1526] opcode : ldi "(" iy ")" "," l
	{ "\n" => [ 9, \&_action_opcode_709 ], ":" => [ 9, \&_action_opcode_709 ], },
	# [1527] opcode : ldi "(" iy "+"
	{ "!" => [ 14, 1528 ], "+" => [ 14, 1528 ], "-" => [ 14, 1528 ], __else__ => [ 14, 1528 ], "~" => [ 14, 1528 ], },
	# [1528] opcode : ldi "(" iy "+" "[expr_DIS]"
	{ ")" => 1529, },
	# [1529] opcode : ldi "(" iy "+" "[expr_DIS]" ")"
	{ "," => 1530, },
	# [1530] opcode : ldi "(" iy "+" "[expr_DIS]" ")" ","
	{ "!" => [ 15, 1531 ], "+" => [ 15, 1531 ], "-" => [ 15, 1531 ], __else__ => [ 15, 1531 ], a => 1532, b => 1533, bc => 1534, c => 1535, d => 1536, de => 1537, e => 1538, h => 1539, hl => 1540, l => 1541, "~" => [ 15, 1531 ], },
	# [1531] opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_710 ], ":" => [ 9, \&_action_opcode_710 ], },
	# [1532] opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_711 ], ":" => [ 9, \&_action_opcode_711 ], },
	# [1533] opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_712 ], ":" => [ 9, \&_action_opcode_712 ], },
	# [1534] opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," bc
	{ "\n" => [ 9, \&_action_opcode_713 ], ":" => [ 9, \&_action_opcode_713 ], },
	# [1535] opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_714 ], ":" => [ 9, \&_action_opcode_714 ], },
	# [1536] opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_715 ], ":" => [ 9, \&_action_opcode_715 ], },
	# [1537] opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," de
	{ "\n" => [ 9, \&_action_opcode_716 ], ":" => [ 9, \&_action_opcode_716 ], },
	# [1538] opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_717 ], ":" => [ 9, \&_action_opcode_717 ], },
	# [1539] opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_718 ], ":" => [ 9, \&_action_opcode_718 ], },
	# [1540] opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," hl
	{ "\n" => [ 9, \&_action_opcode_719 ], ":" => [ 9, \&_action_opcode_719 ], },
	# [1541] opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_720 ], ":" => [ 9, \&_action_opcode_720 ], },
	# [1542] opcode : ldi "(" iy "-"
	{ "!" => [ 16, 1543 ], "+" => [ 16, 1543 ], "-" => [ 16, 1543 ], __else__ => [ 16, 1543 ], "~" => [ 16, 1543 ], },
	# [1543] opcode : ldi "(" iy "-" "[expr_NDIS]"
	{ ")" => 1544, },
	# [1544] opcode : ldi "(" iy "-" "[expr_NDIS]" ")"
	{ "," => 1545, },
	# [1545] opcode : ldi "(" iy "-" "[expr_NDIS]" ")" ","
	{ "!" => [ 15, 1546 ], "+" => [ 15, 1546 ], "-" => [ 15, 1546 ], __else__ => [ 15, 1546 ], a => 1547, b => 1548, bc => 1549, c => 1550, d => 1551, de => 1552, e => 1553, h => 1554, hl => 1555, l => 1556, "~" => [ 15, 1546 ], },
	# [1546] opcode : ldi "(" iy "-" "[expr_NDIS]" ")" "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_710 ], ":" => [ 9, \&_action_opcode_710 ], },
	# [1547] opcode : ldi "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_711 ], ":" => [ 9, \&_action_opcode_711 ], },
	# [1548] opcode : ldi "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_712 ], ":" => [ 9, \&_action_opcode_712 ], },
	# [1549] opcode : ldi "(" iy "-" "[expr_NDIS]" ")" "," bc
	{ "\n" => [ 9, \&_action_opcode_713 ], ":" => [ 9, \&_action_opcode_713 ], },
	# [1550] opcode : ldi "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_714 ], ":" => [ 9, \&_action_opcode_714 ], },
	# [1551] opcode : ldi "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_715 ], ":" => [ 9, \&_action_opcode_715 ], },
	# [1552] opcode : ldi "(" iy "-" "[expr_NDIS]" ")" "," de
	{ "\n" => [ 9, \&_action_opcode_716 ], ":" => [ 9, \&_action_opcode_716 ], },
	# [1553] opcode : ldi "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_717 ], ":" => [ 9, \&_action_opcode_717 ], },
	# [1554] opcode : ldi "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_718 ], ":" => [ 9, \&_action_opcode_718 ], },
	# [1555] opcode : ldi "(" iy "-" "[expr_NDIS]" ")" "," hl
	{ "\n" => [ 9, \&_action_opcode_719 ], ":" => [ 9, \&_action_opcode_719 ], },
	# [1556] opcode : ldi "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_720 ], ":" => [ 9, \&_action_opcode_720 ], },
	# [1557] opcode : ldi a
	{ "," => 1558, },
	# [1558] opcode : ldi a ","
	{ "(" => 1559, },
	# [1559] opcode : ldi a "," "("
	{ bc => 1560, de => 1562, hl => 1564, ix => 1566, iy => 1574, },
	# [1560] opcode : ldi a "," "(" bc
	{ ")" => 1561, },
	# [1561] opcode : ldi a "," "(" bc ")"
	{ "\n" => [ 9, \&_action_opcode_721 ], ":" => [ 9, \&_action_opcode_721 ], },
	# [1562] opcode : ldi a "," "(" de
	{ ")" => 1563, },
	# [1563] opcode : ldi a "," "(" de ")"
	{ "\n" => [ 9, \&_action_opcode_722 ], ":" => [ 9, \&_action_opcode_722 ], },
	# [1564] opcode : ldi a "," "(" hl
	{ ")" => 1565, },
	# [1565] opcode : ldi a "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_723 ], ":" => [ 9, \&_action_opcode_723 ], },
	# [1566] opcode : ldi a "," "(" ix
	{ ")" => 1567, "+" => 1568, "-" => 1571, },
	# [1567] opcode : ldi a "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_724 ], ":" => [ 9, \&_action_opcode_724 ], },
	# [1568] opcode : ldi a "," "(" ix "+"
	{ "!" => [ 14, 1569 ], "+" => [ 14, 1569 ], "-" => [ 14, 1569 ], __else__ => [ 14, 1569 ], "~" => [ 14, 1569 ], },
	# [1569] opcode : ldi a "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1570, },
	# [1570] opcode : ldi a "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_725 ], ":" => [ 9, \&_action_opcode_725 ], },
	# [1571] opcode : ldi a "," "(" ix "-"
	{ "!" => [ 16, 1572 ], "+" => [ 16, 1572 ], "-" => [ 16, 1572 ], __else__ => [ 16, 1572 ], "~" => [ 16, 1572 ], },
	# [1572] opcode : ldi a "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1573, },
	# [1573] opcode : ldi a "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_725 ], ":" => [ 9, \&_action_opcode_725 ], },
	# [1574] opcode : ldi a "," "(" iy
	{ ")" => 1575, "+" => 1576, "-" => 1579, },
	# [1575] opcode : ldi a "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_726 ], ":" => [ 9, \&_action_opcode_726 ], },
	# [1576] opcode : ldi a "," "(" iy "+"
	{ "!" => [ 14, 1577 ], "+" => [ 14, 1577 ], "-" => [ 14, 1577 ], __else__ => [ 14, 1577 ], "~" => [ 14, 1577 ], },
	# [1577] opcode : ldi a "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1578, },
	# [1578] opcode : ldi a "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_727 ], ":" => [ 9, \&_action_opcode_727 ], },
	# [1579] opcode : ldi a "," "(" iy "-"
	{ "!" => [ 16, 1580 ], "+" => [ 16, 1580 ], "-" => [ 16, 1580 ], __else__ => [ 16, 1580 ], "~" => [ 16, 1580 ], },
	# [1580] opcode : ldi a "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1581, },
	# [1581] opcode : ldi a "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_727 ], ":" => [ 9, \&_action_opcode_727 ], },
	# [1582] opcode : ldi b
	{ "," => 1583, },
	# [1583] opcode : ldi b ","
	{ "(" => 1584, },
	# [1584] opcode : ldi b "," "("
	{ hl => 1585, ix => 1587, iy => 1595, },
	# [1585] opcode : ldi b "," "(" hl
	{ ")" => 1586, },
	# [1586] opcode : ldi b "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_728 ], ":" => [ 9, \&_action_opcode_728 ], },
	# [1587] opcode : ldi b "," "(" ix
	{ ")" => 1588, "+" => 1589, "-" => 1592, },
	# [1588] opcode : ldi b "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_729 ], ":" => [ 9, \&_action_opcode_729 ], },
	# [1589] opcode : ldi b "," "(" ix "+"
	{ "!" => [ 14, 1590 ], "+" => [ 14, 1590 ], "-" => [ 14, 1590 ], __else__ => [ 14, 1590 ], "~" => [ 14, 1590 ], },
	# [1590] opcode : ldi b "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1591, },
	# [1591] opcode : ldi b "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_730 ], ":" => [ 9, \&_action_opcode_730 ], },
	# [1592] opcode : ldi b "," "(" ix "-"
	{ "!" => [ 16, 1593 ], "+" => [ 16, 1593 ], "-" => [ 16, 1593 ], __else__ => [ 16, 1593 ], "~" => [ 16, 1593 ], },
	# [1593] opcode : ldi b "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1594, },
	# [1594] opcode : ldi b "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_730 ], ":" => [ 9, \&_action_opcode_730 ], },
	# [1595] opcode : ldi b "," "(" iy
	{ ")" => 1596, "+" => 1597, "-" => 1600, },
	# [1596] opcode : ldi b "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_731 ], ":" => [ 9, \&_action_opcode_731 ], },
	# [1597] opcode : ldi b "," "(" iy "+"
	{ "!" => [ 14, 1598 ], "+" => [ 14, 1598 ], "-" => [ 14, 1598 ], __else__ => [ 14, 1598 ], "~" => [ 14, 1598 ], },
	# [1598] opcode : ldi b "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1599, },
	# [1599] opcode : ldi b "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_732 ], ":" => [ 9, \&_action_opcode_732 ], },
	# [1600] opcode : ldi b "," "(" iy "-"
	{ "!" => [ 16, 1601 ], "+" => [ 16, 1601 ], "-" => [ 16, 1601 ], __else__ => [ 16, 1601 ], "~" => [ 16, 1601 ], },
	# [1601] opcode : ldi b "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1602, },
	# [1602] opcode : ldi b "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_732 ], ":" => [ 9, \&_action_opcode_732 ], },
	# [1603] opcode : ldi bc
	{ "," => 1604, },
	# [1604] opcode : ldi bc ","
	{ "(" => 1605, },
	# [1605] opcode : ldi bc "," "("
	{ hl => 1606, ix => 1608, iy => 1616, },
	# [1606] opcode : ldi bc "," "(" hl
	{ ")" => 1607, },
	# [1607] opcode : ldi bc "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_733 ], ":" => [ 9, \&_action_opcode_733 ], },
	# [1608] opcode : ldi bc "," "(" ix
	{ ")" => 1609, "+" => 1610, "-" => 1613, },
	# [1609] opcode : ldi bc "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_734 ], ":" => [ 9, \&_action_opcode_734 ], },
	# [1610] opcode : ldi bc "," "(" ix "+"
	{ "!" => [ 14, 1611 ], "+" => [ 14, 1611 ], "-" => [ 14, 1611 ], __else__ => [ 14, 1611 ], "~" => [ 14, 1611 ], },
	# [1611] opcode : ldi bc "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1612, },
	# [1612] opcode : ldi bc "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_735 ], ":" => [ 9, \&_action_opcode_735 ], },
	# [1613] opcode : ldi bc "," "(" ix "-"
	{ "!" => [ 16, 1614 ], "+" => [ 16, 1614 ], "-" => [ 16, 1614 ], __else__ => [ 16, 1614 ], "~" => [ 16, 1614 ], },
	# [1614] opcode : ldi bc "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1615, },
	# [1615] opcode : ldi bc "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_735 ], ":" => [ 9, \&_action_opcode_735 ], },
	# [1616] opcode : ldi bc "," "(" iy
	{ ")" => 1617, "+" => 1618, "-" => 1621, },
	# [1617] opcode : ldi bc "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_736 ], ":" => [ 9, \&_action_opcode_736 ], },
	# [1618] opcode : ldi bc "," "(" iy "+"
	{ "!" => [ 14, 1619 ], "+" => [ 14, 1619 ], "-" => [ 14, 1619 ], __else__ => [ 14, 1619 ], "~" => [ 14, 1619 ], },
	# [1619] opcode : ldi bc "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1620, },
	# [1620] opcode : ldi bc "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_737 ], ":" => [ 9, \&_action_opcode_737 ], },
	# [1621] opcode : ldi bc "," "(" iy "-"
	{ "!" => [ 16, 1622 ], "+" => [ 16, 1622 ], "-" => [ 16, 1622 ], __else__ => [ 16, 1622 ], "~" => [ 16, 1622 ], },
	# [1622] opcode : ldi bc "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1623, },
	# [1623] opcode : ldi bc "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_737 ], ":" => [ 9, \&_action_opcode_737 ], },
	# [1624] opcode : ldi c
	{ "," => 1625, },
	# [1625] opcode : ldi c ","
	{ "(" => 1626, },
	# [1626] opcode : ldi c "," "("
	{ hl => 1627, ix => 1629, iy => 1637, },
	# [1627] opcode : ldi c "," "(" hl
	{ ")" => 1628, },
	# [1628] opcode : ldi c "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_738 ], ":" => [ 9, \&_action_opcode_738 ], },
	# [1629] opcode : ldi c "," "(" ix
	{ ")" => 1630, "+" => 1631, "-" => 1634, },
	# [1630] opcode : ldi c "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_739 ], ":" => [ 9, \&_action_opcode_739 ], },
	# [1631] opcode : ldi c "," "(" ix "+"
	{ "!" => [ 14, 1632 ], "+" => [ 14, 1632 ], "-" => [ 14, 1632 ], __else__ => [ 14, 1632 ], "~" => [ 14, 1632 ], },
	# [1632] opcode : ldi c "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1633, },
	# [1633] opcode : ldi c "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_740 ], ":" => [ 9, \&_action_opcode_740 ], },
	# [1634] opcode : ldi c "," "(" ix "-"
	{ "!" => [ 16, 1635 ], "+" => [ 16, 1635 ], "-" => [ 16, 1635 ], __else__ => [ 16, 1635 ], "~" => [ 16, 1635 ], },
	# [1635] opcode : ldi c "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1636, },
	# [1636] opcode : ldi c "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_740 ], ":" => [ 9, \&_action_opcode_740 ], },
	# [1637] opcode : ldi c "," "(" iy
	{ ")" => 1638, "+" => 1639, "-" => 1642, },
	# [1638] opcode : ldi c "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_741 ], ":" => [ 9, \&_action_opcode_741 ], },
	# [1639] opcode : ldi c "," "(" iy "+"
	{ "!" => [ 14, 1640 ], "+" => [ 14, 1640 ], "-" => [ 14, 1640 ], __else__ => [ 14, 1640 ], "~" => [ 14, 1640 ], },
	# [1640] opcode : ldi c "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1641, },
	# [1641] opcode : ldi c "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_742 ], ":" => [ 9, \&_action_opcode_742 ], },
	# [1642] opcode : ldi c "," "(" iy "-"
	{ "!" => [ 16, 1643 ], "+" => [ 16, 1643 ], "-" => [ 16, 1643 ], __else__ => [ 16, 1643 ], "~" => [ 16, 1643 ], },
	# [1643] opcode : ldi c "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1644, },
	# [1644] opcode : ldi c "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_742 ], ":" => [ 9, \&_action_opcode_742 ], },
	# [1645] opcode : ldi d
	{ "," => 1646, },
	# [1646] opcode : ldi d ","
	{ "(" => 1647, },
	# [1647] opcode : ldi d "," "("
	{ hl => 1648, ix => 1650, iy => 1658, },
	# [1648] opcode : ldi d "," "(" hl
	{ ")" => 1649, },
	# [1649] opcode : ldi d "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_743 ], ":" => [ 9, \&_action_opcode_743 ], },
	# [1650] opcode : ldi d "," "(" ix
	{ ")" => 1651, "+" => 1652, "-" => 1655, },
	# [1651] opcode : ldi d "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_744 ], ":" => [ 9, \&_action_opcode_744 ], },
	# [1652] opcode : ldi d "," "(" ix "+"
	{ "!" => [ 14, 1653 ], "+" => [ 14, 1653 ], "-" => [ 14, 1653 ], __else__ => [ 14, 1653 ], "~" => [ 14, 1653 ], },
	# [1653] opcode : ldi d "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1654, },
	# [1654] opcode : ldi d "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_745 ], ":" => [ 9, \&_action_opcode_745 ], },
	# [1655] opcode : ldi d "," "(" ix "-"
	{ "!" => [ 16, 1656 ], "+" => [ 16, 1656 ], "-" => [ 16, 1656 ], __else__ => [ 16, 1656 ], "~" => [ 16, 1656 ], },
	# [1656] opcode : ldi d "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1657, },
	# [1657] opcode : ldi d "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_745 ], ":" => [ 9, \&_action_opcode_745 ], },
	# [1658] opcode : ldi d "," "(" iy
	{ ")" => 1659, "+" => 1660, "-" => 1663, },
	# [1659] opcode : ldi d "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_746 ], ":" => [ 9, \&_action_opcode_746 ], },
	# [1660] opcode : ldi d "," "(" iy "+"
	{ "!" => [ 14, 1661 ], "+" => [ 14, 1661 ], "-" => [ 14, 1661 ], __else__ => [ 14, 1661 ], "~" => [ 14, 1661 ], },
	# [1661] opcode : ldi d "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1662, },
	# [1662] opcode : ldi d "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_747 ], ":" => [ 9, \&_action_opcode_747 ], },
	# [1663] opcode : ldi d "," "(" iy "-"
	{ "!" => [ 16, 1664 ], "+" => [ 16, 1664 ], "-" => [ 16, 1664 ], __else__ => [ 16, 1664 ], "~" => [ 16, 1664 ], },
	# [1664] opcode : ldi d "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1665, },
	# [1665] opcode : ldi d "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_747 ], ":" => [ 9, \&_action_opcode_747 ], },
	# [1666] opcode : ldi de
	{ "," => 1667, },
	# [1667] opcode : ldi de ","
	{ "(" => 1668, },
	# [1668] opcode : ldi de "," "("
	{ hl => 1669, ix => 1671, iy => 1679, },
	# [1669] opcode : ldi de "," "(" hl
	{ ")" => 1670, },
	# [1670] opcode : ldi de "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_748 ], ":" => [ 9, \&_action_opcode_748 ], },
	# [1671] opcode : ldi de "," "(" ix
	{ ")" => 1672, "+" => 1673, "-" => 1676, },
	# [1672] opcode : ldi de "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_749 ], ":" => [ 9, \&_action_opcode_749 ], },
	# [1673] opcode : ldi de "," "(" ix "+"
	{ "!" => [ 14, 1674 ], "+" => [ 14, 1674 ], "-" => [ 14, 1674 ], __else__ => [ 14, 1674 ], "~" => [ 14, 1674 ], },
	# [1674] opcode : ldi de "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1675, },
	# [1675] opcode : ldi de "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_750 ], ":" => [ 9, \&_action_opcode_750 ], },
	# [1676] opcode : ldi de "," "(" ix "-"
	{ "!" => [ 16, 1677 ], "+" => [ 16, 1677 ], "-" => [ 16, 1677 ], __else__ => [ 16, 1677 ], "~" => [ 16, 1677 ], },
	# [1677] opcode : ldi de "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1678, },
	# [1678] opcode : ldi de "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_750 ], ":" => [ 9, \&_action_opcode_750 ], },
	# [1679] opcode : ldi de "," "(" iy
	{ ")" => 1680, "+" => 1681, "-" => 1684, },
	# [1680] opcode : ldi de "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_751 ], ":" => [ 9, \&_action_opcode_751 ], },
	# [1681] opcode : ldi de "," "(" iy "+"
	{ "!" => [ 14, 1682 ], "+" => [ 14, 1682 ], "-" => [ 14, 1682 ], __else__ => [ 14, 1682 ], "~" => [ 14, 1682 ], },
	# [1682] opcode : ldi de "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1683, },
	# [1683] opcode : ldi de "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_752 ], ":" => [ 9, \&_action_opcode_752 ], },
	# [1684] opcode : ldi de "," "(" iy "-"
	{ "!" => [ 16, 1685 ], "+" => [ 16, 1685 ], "-" => [ 16, 1685 ], __else__ => [ 16, 1685 ], "~" => [ 16, 1685 ], },
	# [1685] opcode : ldi de "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1686, },
	# [1686] opcode : ldi de "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_752 ], ":" => [ 9, \&_action_opcode_752 ], },
	# [1687] opcode : ldi e
	{ "," => 1688, },
	# [1688] opcode : ldi e ","
	{ "(" => 1689, },
	# [1689] opcode : ldi e "," "("
	{ hl => 1690, ix => 1692, iy => 1700, },
	# [1690] opcode : ldi e "," "(" hl
	{ ")" => 1691, },
	# [1691] opcode : ldi e "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_753 ], ":" => [ 9, \&_action_opcode_753 ], },
	# [1692] opcode : ldi e "," "(" ix
	{ ")" => 1693, "+" => 1694, "-" => 1697, },
	# [1693] opcode : ldi e "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_754 ], ":" => [ 9, \&_action_opcode_754 ], },
	# [1694] opcode : ldi e "," "(" ix "+"
	{ "!" => [ 14, 1695 ], "+" => [ 14, 1695 ], "-" => [ 14, 1695 ], __else__ => [ 14, 1695 ], "~" => [ 14, 1695 ], },
	# [1695] opcode : ldi e "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1696, },
	# [1696] opcode : ldi e "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_755 ], ":" => [ 9, \&_action_opcode_755 ], },
	# [1697] opcode : ldi e "," "(" ix "-"
	{ "!" => [ 16, 1698 ], "+" => [ 16, 1698 ], "-" => [ 16, 1698 ], __else__ => [ 16, 1698 ], "~" => [ 16, 1698 ], },
	# [1698] opcode : ldi e "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1699, },
	# [1699] opcode : ldi e "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_755 ], ":" => [ 9, \&_action_opcode_755 ], },
	# [1700] opcode : ldi e "," "(" iy
	{ ")" => 1701, "+" => 1702, "-" => 1705, },
	# [1701] opcode : ldi e "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_756 ], ":" => [ 9, \&_action_opcode_756 ], },
	# [1702] opcode : ldi e "," "(" iy "+"
	{ "!" => [ 14, 1703 ], "+" => [ 14, 1703 ], "-" => [ 14, 1703 ], __else__ => [ 14, 1703 ], "~" => [ 14, 1703 ], },
	# [1703] opcode : ldi e "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1704, },
	# [1704] opcode : ldi e "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_757 ], ":" => [ 9, \&_action_opcode_757 ], },
	# [1705] opcode : ldi e "," "(" iy "-"
	{ "!" => [ 16, 1706 ], "+" => [ 16, 1706 ], "-" => [ 16, 1706 ], __else__ => [ 16, 1706 ], "~" => [ 16, 1706 ], },
	# [1706] opcode : ldi e "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1707, },
	# [1707] opcode : ldi e "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_757 ], ":" => [ 9, \&_action_opcode_757 ], },
	# [1708] opcode : ldi h
	{ "," => 1709, },
	# [1709] opcode : ldi h ","
	{ "(" => 1710, },
	# [1710] opcode : ldi h "," "("
	{ hl => 1711, ix => 1713, iy => 1721, },
	# [1711] opcode : ldi h "," "(" hl
	{ ")" => 1712, },
	# [1712] opcode : ldi h "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_758 ], ":" => [ 9, \&_action_opcode_758 ], },
	# [1713] opcode : ldi h "," "(" ix
	{ ")" => 1714, "+" => 1715, "-" => 1718, },
	# [1714] opcode : ldi h "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_759 ], ":" => [ 9, \&_action_opcode_759 ], },
	# [1715] opcode : ldi h "," "(" ix "+"
	{ "!" => [ 14, 1716 ], "+" => [ 14, 1716 ], "-" => [ 14, 1716 ], __else__ => [ 14, 1716 ], "~" => [ 14, 1716 ], },
	# [1716] opcode : ldi h "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1717, },
	# [1717] opcode : ldi h "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_760 ], ":" => [ 9, \&_action_opcode_760 ], },
	# [1718] opcode : ldi h "," "(" ix "-"
	{ "!" => [ 16, 1719 ], "+" => [ 16, 1719 ], "-" => [ 16, 1719 ], __else__ => [ 16, 1719 ], "~" => [ 16, 1719 ], },
	# [1719] opcode : ldi h "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1720, },
	# [1720] opcode : ldi h "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_760 ], ":" => [ 9, \&_action_opcode_760 ], },
	# [1721] opcode : ldi h "," "(" iy
	{ ")" => 1722, "+" => 1723, "-" => 1726, },
	# [1722] opcode : ldi h "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_761 ], ":" => [ 9, \&_action_opcode_761 ], },
	# [1723] opcode : ldi h "," "(" iy "+"
	{ "!" => [ 14, 1724 ], "+" => [ 14, 1724 ], "-" => [ 14, 1724 ], __else__ => [ 14, 1724 ], "~" => [ 14, 1724 ], },
	# [1724] opcode : ldi h "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1725, },
	# [1725] opcode : ldi h "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_762 ], ":" => [ 9, \&_action_opcode_762 ], },
	# [1726] opcode : ldi h "," "(" iy "-"
	{ "!" => [ 16, 1727 ], "+" => [ 16, 1727 ], "-" => [ 16, 1727 ], __else__ => [ 16, 1727 ], "~" => [ 16, 1727 ], },
	# [1727] opcode : ldi h "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1728, },
	# [1728] opcode : ldi h "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_762 ], ":" => [ 9, \&_action_opcode_762 ], },
	# [1729] opcode : ldi hl
	{ "," => 1730, },
	# [1730] opcode : ldi hl ","
	{ "(" => 1731, },
	# [1731] opcode : ldi hl "," "("
	{ ix => 1732, iy => 1740, },
	# [1732] opcode : ldi hl "," "(" ix
	{ ")" => 1733, "+" => 1734, "-" => 1737, },
	# [1733] opcode : ldi hl "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_763 ], ":" => [ 9, \&_action_opcode_763 ], },
	# [1734] opcode : ldi hl "," "(" ix "+"
	{ "!" => [ 14, 1735 ], "+" => [ 14, 1735 ], "-" => [ 14, 1735 ], __else__ => [ 14, 1735 ], "~" => [ 14, 1735 ], },
	# [1735] opcode : ldi hl "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1736, },
	# [1736] opcode : ldi hl "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_764 ], ":" => [ 9, \&_action_opcode_764 ], },
	# [1737] opcode : ldi hl "," "(" ix "-"
	{ "!" => [ 16, 1738 ], "+" => [ 16, 1738 ], "-" => [ 16, 1738 ], __else__ => [ 16, 1738 ], "~" => [ 16, 1738 ], },
	# [1738] opcode : ldi hl "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1739, },
	# [1739] opcode : ldi hl "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_764 ], ":" => [ 9, \&_action_opcode_764 ], },
	# [1740] opcode : ldi hl "," "(" iy
	{ ")" => 1741, "+" => 1742, "-" => 1745, },
	# [1741] opcode : ldi hl "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_765 ], ":" => [ 9, \&_action_opcode_765 ], },
	# [1742] opcode : ldi hl "," "(" iy "+"
	{ "!" => [ 14, 1743 ], "+" => [ 14, 1743 ], "-" => [ 14, 1743 ], __else__ => [ 14, 1743 ], "~" => [ 14, 1743 ], },
	# [1743] opcode : ldi hl "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1744, },
	# [1744] opcode : ldi hl "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_766 ], ":" => [ 9, \&_action_opcode_766 ], },
	# [1745] opcode : ldi hl "," "(" iy "-"
	{ "!" => [ 16, 1746 ], "+" => [ 16, 1746 ], "-" => [ 16, 1746 ], __else__ => [ 16, 1746 ], "~" => [ 16, 1746 ], },
	# [1746] opcode : ldi hl "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1747, },
	# [1747] opcode : ldi hl "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_766 ], ":" => [ 9, \&_action_opcode_766 ], },
	# [1748] opcode : ldi l
	{ "," => 1749, },
	# [1749] opcode : ldi l ","
	{ "(" => 1750, },
	# [1750] opcode : ldi l "," "("
	{ hl => 1751, ix => 1753, iy => 1761, },
	# [1751] opcode : ldi l "," "(" hl
	{ ")" => 1752, },
	# [1752] opcode : ldi l "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_767 ], ":" => [ 9, \&_action_opcode_767 ], },
	# [1753] opcode : ldi l "," "(" ix
	{ ")" => 1754, "+" => 1755, "-" => 1758, },
	# [1754] opcode : ldi l "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_768 ], ":" => [ 9, \&_action_opcode_768 ], },
	# [1755] opcode : ldi l "," "(" ix "+"
	{ "!" => [ 14, 1756 ], "+" => [ 14, 1756 ], "-" => [ 14, 1756 ], __else__ => [ 14, 1756 ], "~" => [ 14, 1756 ], },
	# [1756] opcode : ldi l "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1757, },
	# [1757] opcode : ldi l "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_769 ], ":" => [ 9, \&_action_opcode_769 ], },
	# [1758] opcode : ldi l "," "(" ix "-"
	{ "!" => [ 16, 1759 ], "+" => [ 16, 1759 ], "-" => [ 16, 1759 ], __else__ => [ 16, 1759 ], "~" => [ 16, 1759 ], },
	# [1759] opcode : ldi l "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1760, },
	# [1760] opcode : ldi l "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_769 ], ":" => [ 9, \&_action_opcode_769 ], },
	# [1761] opcode : ldi l "," "(" iy
	{ ")" => 1762, "+" => 1763, "-" => 1766, },
	# [1762] opcode : ldi l "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_770 ], ":" => [ 9, \&_action_opcode_770 ], },
	# [1763] opcode : ldi l "," "(" iy "+"
	{ "!" => [ 14, 1764 ], "+" => [ 14, 1764 ], "-" => [ 14, 1764 ], __else__ => [ 14, 1764 ], "~" => [ 14, 1764 ], },
	# [1764] opcode : ldi l "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1765, },
	# [1765] opcode : ldi l "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_771 ], ":" => [ 9, \&_action_opcode_771 ], },
	# [1766] opcode : ldi l "," "(" iy "-"
	{ "!" => [ 16, 1767 ], "+" => [ 16, 1767 ], "-" => [ 16, 1767 ], __else__ => [ 16, 1767 ], "~" => [ 16, 1767 ], },
	# [1767] opcode : ldi l "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1768, },
	# [1768] opcode : ldi l "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_771 ], ":" => [ 9, \&_action_opcode_771 ], },
	# [1769] opcode : ldir
	{ "\n" => [ 9, \&_action_opcode_772 ], ":" => [ 9, \&_action_opcode_772 ], },
	# [1770] opcode : neg
	{ "\n" => [ 9, \&_action_opcode_773 ], ":" => [ 9, \&_action_opcode_773 ], },
	# [1771] opcode : nop
	{ "\n" => [ 9, \&_action_opcode_774 ], ":" => [ 9, \&_action_opcode_774 ], },
	# [1772] opcode : or
	{ "!" => [ 15, 1792 ], "(" => 1773, "+" => [ 15, 1792 ], "-" => [ 15, 1792 ], __else__ => [ 15, 1792 ], a => 1793, b => 1794, c => 1795, d => 1796, e => 1797, h => 1798, ixh => 1799, ixl => 1800, iyh => 1801, iyl => 1802, l => 1803, "~" => [ 15, 1792 ], },
	# [1773] opcode : or "("
	{ hl => 1774, ix => 1776, iy => 1784, },
	# [1774] opcode : or "(" hl
	{ ")" => 1775, },
	# [1775] opcode : or "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_775 ], ":" => [ 9, \&_action_opcode_775 ], },
	# [1776] opcode : or "(" ix
	{ ")" => 1777, "+" => 1778, "-" => 1781, },
	# [1777] opcode : or "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_776 ], ":" => [ 9, \&_action_opcode_776 ], },
	# [1778] opcode : or "(" ix "+"
	{ "!" => [ 14, 1779 ], "+" => [ 14, 1779 ], "-" => [ 14, 1779 ], __else__ => [ 14, 1779 ], "~" => [ 14, 1779 ], },
	# [1779] opcode : or "(" ix "+" "[expr_DIS]"
	{ ")" => 1780, },
	# [1780] opcode : or "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_777 ], ":" => [ 9, \&_action_opcode_777 ], },
	# [1781] opcode : or "(" ix "-"
	{ "!" => [ 16, 1782 ], "+" => [ 16, 1782 ], "-" => [ 16, 1782 ], __else__ => [ 16, 1782 ], "~" => [ 16, 1782 ], },
	# [1782] opcode : or "(" ix "-" "[expr_NDIS]"
	{ ")" => 1783, },
	# [1783] opcode : or "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_777 ], ":" => [ 9, \&_action_opcode_777 ], },
	# [1784] opcode : or "(" iy
	{ ")" => 1785, "+" => 1786, "-" => 1789, },
	# [1785] opcode : or "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_778 ], ":" => [ 9, \&_action_opcode_778 ], },
	# [1786] opcode : or "(" iy "+"
	{ "!" => [ 14, 1787 ], "+" => [ 14, 1787 ], "-" => [ 14, 1787 ], __else__ => [ 14, 1787 ], "~" => [ 14, 1787 ], },
	# [1787] opcode : or "(" iy "+" "[expr_DIS]"
	{ ")" => 1788, },
	# [1788] opcode : or "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_779 ], ":" => [ 9, \&_action_opcode_779 ], },
	# [1789] opcode : or "(" iy "-"
	{ "!" => [ 16, 1790 ], "+" => [ 16, 1790 ], "-" => [ 16, 1790 ], __else__ => [ 16, 1790 ], "~" => [ 16, 1790 ], },
	# [1790] opcode : or "(" iy "-" "[expr_NDIS]"
	{ ")" => 1791, },
	# [1791] opcode : or "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_779 ], ":" => [ 9, \&_action_opcode_779 ], },
	# [1792] opcode : or "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_780 ], ":" => [ 9, \&_action_opcode_780 ], },
	# [1793] opcode : or a
	{ "\n" => [ 9, \&_action_opcode_781 ], ":" => [ 9, \&_action_opcode_781 ], },
	# [1794] opcode : or b
	{ "\n" => [ 9, \&_action_opcode_782 ], ":" => [ 9, \&_action_opcode_782 ], },
	# [1795] opcode : or c
	{ "\n" => [ 9, \&_action_opcode_783 ], ":" => [ 9, \&_action_opcode_783 ], },
	# [1796] opcode : or d
	{ "\n" => [ 9, \&_action_opcode_784 ], ":" => [ 9, \&_action_opcode_784 ], },
	# [1797] opcode : or e
	{ "\n" => [ 9, \&_action_opcode_785 ], ":" => [ 9, \&_action_opcode_785 ], },
	# [1798] opcode : or h
	{ "\n" => [ 9, \&_action_opcode_786 ], ":" => [ 9, \&_action_opcode_786 ], },
	# [1799] opcode : or ixh
	{ "\n" => [ 9, \&_action_opcode_787 ], ":" => [ 9, \&_action_opcode_787 ], },
	# [1800] opcode : or ixl
	{ "\n" => [ 9, \&_action_opcode_788 ], ":" => [ 9, \&_action_opcode_788 ], },
	# [1801] opcode : or iyh
	{ "\n" => [ 9, \&_action_opcode_789 ], ":" => [ 9, \&_action_opcode_789 ], },
	# [1802] opcode : or iyl
	{ "\n" => [ 9, \&_action_opcode_790 ], ":" => [ 9, \&_action_opcode_790 ], },
	# [1803] opcode : or l
	{ "\n" => [ 9, \&_action_opcode_791 ], ":" => [ 9, \&_action_opcode_791 ], },
	# [1804] opcode : org
	{ "!" => [ 18, \&_action_opcode_22 ], "+" => [ 18, \&_action_opcode_22 ], "-" => [ 18, \&_action_opcode_22 ], __else__ => [ 18, \&_action_opcode_22 ], "~" => [ 18, \&_action_opcode_22 ], },
	# [1805] opcode : otdr
	{ "\n" => [ 9, \&_action_opcode_792 ], ":" => [ 9, \&_action_opcode_792 ], },
	# [1806] opcode : otir
	{ "\n" => [ 9, \&_action_opcode_793 ], ":" => [ 9, \&_action_opcode_793 ], },
	# [1807] opcode : out
	{ "(" => 1808, },
	# [1808] opcode : out "("
	{ "!" => [ 15, 1809 ], "+" => [ 15, 1809 ], "-" => [ 15, 1809 ], __else__ => [ 15, 1809 ], c => 1813, "~" => [ 15, 1809 ], },
	# [1809] opcode : out "(" "[expr_N]"
	{ ")" => 1810, },
	# [1810] opcode : out "(" "[expr_N]" ")"
	{ "," => 1811, },
	# [1811] opcode : out "(" "[expr_N]" ")" ","
	{ a => 1812, },
	# [1812] opcode : out "(" "[expr_N]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_794 ], ":" => [ 9, \&_action_opcode_794 ], },
	# [1813] opcode : out "(" c
	{ ")" => 1814, },
	# [1814] opcode : out "(" c ")"
	{ "," => 1815, },
	# [1815] opcode : out "(" c ")" ","
	{ "!" => [ 42, 1816 ], "+" => [ 42, 1816 ], "-" => [ 42, 1816 ], __else__ => [ 42, 1816 ], a => 1818, b => 1819, c => 1820, d => 1821, e => 1822, h => 1823, l => 1824, "~" => [ 42, 1816 ], },
	# [1816] opcode : out "(" c ")" "," "[inline_const]"
	{ 0 => 1817, },
	# [1817] opcode : out "(" c ")" "," "[inline_const]" 0
	{ "\n" => [ 9, \&_action_opcode_795 ], ":" => [ 9, \&_action_opcode_795 ], },
	# [1818] opcode : out "(" c ")" "," a
	{ "\n" => [ 9, \&_action_opcode_796 ], ":" => [ 9, \&_action_opcode_796 ], },
	# [1819] opcode : out "(" c ")" "," b
	{ "\n" => [ 9, \&_action_opcode_797 ], ":" => [ 9, \&_action_opcode_797 ], },
	# [1820] opcode : out "(" c ")" "," c
	{ "\n" => [ 9, \&_action_opcode_798 ], ":" => [ 9, \&_action_opcode_798 ], },
	# [1821] opcode : out "(" c ")" "," d
	{ "\n" => [ 9, \&_action_opcode_799 ], ":" => [ 9, \&_action_opcode_799 ], },
	# [1822] opcode : out "(" c ")" "," e
	{ "\n" => [ 9, \&_action_opcode_800 ], ":" => [ 9, \&_action_opcode_800 ], },
	# [1823] opcode : out "(" c ")" "," h
	{ "\n" => [ 9, \&_action_opcode_801 ], ":" => [ 9, \&_action_opcode_801 ], },
	# [1824] opcode : out "(" c ")" "," l
	{ "\n" => [ 9, \&_action_opcode_802 ], ":" => [ 9, \&_action_opcode_802 ], },
	# [1825] opcode : outd
	{ "\n" => [ 9, \&_action_opcode_803 ], ":" => [ 9, \&_action_opcode_803 ], },
	# [1826] opcode : outi
	{ "\n" => [ 9, \&_action_opcode_804 ], ":" => [ 9, \&_action_opcode_804 ], },
	# [1827] opcode : pop
	{ af => 1828, bc => 1829, de => 1830, hl => 1831, ix => 1832, iy => 1833, },
	# [1828] opcode : pop af
	{ "\n" => [ 9, \&_action_opcode_805 ], ":" => [ 9, \&_action_opcode_805 ], },
	# [1829] opcode : pop bc
	{ "\n" => [ 9, \&_action_opcode_806 ], ":" => [ 9, \&_action_opcode_806 ], },
	# [1830] opcode : pop de
	{ "\n" => [ 9, \&_action_opcode_807 ], ":" => [ 9, \&_action_opcode_807 ], },
	# [1831] opcode : pop hl
	{ "\n" => [ 9, \&_action_opcode_808 ], ":" => [ 9, \&_action_opcode_808 ], },
	# [1832] opcode : pop ix
	{ "\n" => [ 9, \&_action_opcode_809 ], ":" => [ 9, \&_action_opcode_809 ], },
	# [1833] opcode : pop iy
	{ "\n" => [ 9, \&_action_opcode_810 ], ":" => [ 9, \&_action_opcode_810 ], },
	# [1834] opcode : push
	{ af => 1835, bc => 1836, de => 1837, hl => 1838, ix => 1839, iy => 1840, },
	# [1835] opcode : push af
	{ "\n" => [ 9, \&_action_opcode_811 ], ":" => [ 9, \&_action_opcode_811 ], },
	# [1836] opcode : push bc
	{ "\n" => [ 9, \&_action_opcode_812 ], ":" => [ 9, \&_action_opcode_812 ], },
	# [1837] opcode : push de
	{ "\n" => [ 9, \&_action_opcode_813 ], ":" => [ 9, \&_action_opcode_813 ], },
	# [1838] opcode : push hl
	{ "\n" => [ 9, \&_action_opcode_814 ], ":" => [ 9, \&_action_opcode_814 ], },
	# [1839] opcode : push ix
	{ "\n" => [ 9, \&_action_opcode_815 ], ":" => [ 9, \&_action_opcode_815 ], },
	# [1840] opcode : push iy
	{ "\n" => [ 9, \&_action_opcode_816 ], ":" => [ 9, \&_action_opcode_816 ], },
	# [1841] opcode : res
	{ "!" => [ 42, 1842 ], "+" => [ 42, 1842 ], "-" => [ 42, 1842 ], __else__ => [ 42, 1842 ], "~" => [ 42, 1842 ], },
	# [1842] opcode : res "[inline_const]"
	{ 0 => 1843, 1 => 1919, 2 => 1995, 3 => 2071, 4 => 2147, 5 => 2223, 6 => 2299, 7 => 2375, },
	# [1843] opcode : res "[inline_const]" 0
	{ "," => 1844, },
	# [1844] opcode : res "[inline_const]" 0 ","
	{ "(" => 1845, a => 1912, b => 1913, c => 1914, d => 1915, e => 1916, h => 1917, l => 1918, },
	# [1845] opcode : res "[inline_const]" 0 "," "("
	{ hl => 1846, ix => 1848, iy => 1880, },
	# [1846] opcode : res "[inline_const]" 0 "," "(" hl
	{ ")" => 1847, },
	# [1847] opcode : res "[inline_const]" 0 "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_817 ], ":" => [ 9, \&_action_opcode_817 ], },
	# [1848] opcode : res "[inline_const]" 0 "," "(" ix
	{ ")" => 1849, "+" => 1858, "-" => 1869, },
	# [1849] opcode : res "[inline_const]" 0 "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_818 ], "," => 1850, ":" => [ 9, \&_action_opcode_818 ], },
	# [1850] opcode : res "[inline_const]" 0 "," "(" ix ")" ","
	{ a => 1851, b => 1852, c => 1853, d => 1854, e => 1855, h => 1856, l => 1857, },
	# [1851] opcode : res "[inline_const]" 0 "," "(" ix ")" "," a
	{ "\n" => [ 9, \&_action_opcode_819 ], ":" => [ 9, \&_action_opcode_819 ], },
	# [1852] opcode : res "[inline_const]" 0 "," "(" ix ")" "," b
	{ "\n" => [ 9, \&_action_opcode_820 ], ":" => [ 9, \&_action_opcode_820 ], },
	# [1853] opcode : res "[inline_const]" 0 "," "(" ix ")" "," c
	{ "\n" => [ 9, \&_action_opcode_821 ], ":" => [ 9, \&_action_opcode_821 ], },
	# [1854] opcode : res "[inline_const]" 0 "," "(" ix ")" "," d
	{ "\n" => [ 9, \&_action_opcode_822 ], ":" => [ 9, \&_action_opcode_822 ], },
	# [1855] opcode : res "[inline_const]" 0 "," "(" ix ")" "," e
	{ "\n" => [ 9, \&_action_opcode_823 ], ":" => [ 9, \&_action_opcode_823 ], },
	# [1856] opcode : res "[inline_const]" 0 "," "(" ix ")" "," h
	{ "\n" => [ 9, \&_action_opcode_824 ], ":" => [ 9, \&_action_opcode_824 ], },
	# [1857] opcode : res "[inline_const]" 0 "," "(" ix ")" "," l
	{ "\n" => [ 9, \&_action_opcode_825 ], ":" => [ 9, \&_action_opcode_825 ], },
	# [1858] opcode : res "[inline_const]" 0 "," "(" ix "+"
	{ "!" => [ 14, 1859 ], "+" => [ 14, 1859 ], "-" => [ 14, 1859 ], __else__ => [ 14, 1859 ], "~" => [ 14, 1859 ], },
	# [1859] opcode : res "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1860, },
	# [1860] opcode : res "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_826 ], "," => 1861, ":" => [ 9, \&_action_opcode_826 ], },
	# [1861] opcode : res "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 1862, b => 1863, c => 1864, d => 1865, e => 1866, h => 1867, l => 1868, },
	# [1862] opcode : res "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_827 ], ":" => [ 9, \&_action_opcode_827 ], },
	# [1863] opcode : res "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_828 ], ":" => [ 9, \&_action_opcode_828 ], },
	# [1864] opcode : res "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_829 ], ":" => [ 9, \&_action_opcode_829 ], },
	# [1865] opcode : res "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_830 ], ":" => [ 9, \&_action_opcode_830 ], },
	# [1866] opcode : res "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_831 ], ":" => [ 9, \&_action_opcode_831 ], },
	# [1867] opcode : res "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_832 ], ":" => [ 9, \&_action_opcode_832 ], },
	# [1868] opcode : res "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_833 ], ":" => [ 9, \&_action_opcode_833 ], },
	# [1869] opcode : res "[inline_const]" 0 "," "(" ix "-"
	{ "!" => [ 16, 1870 ], "+" => [ 16, 1870 ], "-" => [ 16, 1870 ], __else__ => [ 16, 1870 ], "~" => [ 16, 1870 ], },
	# [1870] opcode : res "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1871, },
	# [1871] opcode : res "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_826 ], "," => 1872, ":" => [ 9, \&_action_opcode_826 ], },
	# [1872] opcode : res "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 1873, b => 1874, c => 1875, d => 1876, e => 1877, h => 1878, l => 1879, },
	# [1873] opcode : res "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_827 ], ":" => [ 9, \&_action_opcode_827 ], },
	# [1874] opcode : res "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_828 ], ":" => [ 9, \&_action_opcode_828 ], },
	# [1875] opcode : res "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_829 ], ":" => [ 9, \&_action_opcode_829 ], },
	# [1876] opcode : res "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_830 ], ":" => [ 9, \&_action_opcode_830 ], },
	# [1877] opcode : res "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_831 ], ":" => [ 9, \&_action_opcode_831 ], },
	# [1878] opcode : res "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_832 ], ":" => [ 9, \&_action_opcode_832 ], },
	# [1879] opcode : res "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_833 ], ":" => [ 9, \&_action_opcode_833 ], },
	# [1880] opcode : res "[inline_const]" 0 "," "(" iy
	{ ")" => 1881, "+" => 1890, "-" => 1901, },
	# [1881] opcode : res "[inline_const]" 0 "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_834 ], "," => 1882, ":" => [ 9, \&_action_opcode_834 ], },
	# [1882] opcode : res "[inline_const]" 0 "," "(" iy ")" ","
	{ a => 1883, b => 1884, c => 1885, d => 1886, e => 1887, h => 1888, l => 1889, },
	# [1883] opcode : res "[inline_const]" 0 "," "(" iy ")" "," a
	{ "\n" => [ 9, \&_action_opcode_835 ], ":" => [ 9, \&_action_opcode_835 ], },
	# [1884] opcode : res "[inline_const]" 0 "," "(" iy ")" "," b
	{ "\n" => [ 9, \&_action_opcode_836 ], ":" => [ 9, \&_action_opcode_836 ], },
	# [1885] opcode : res "[inline_const]" 0 "," "(" iy ")" "," c
	{ "\n" => [ 9, \&_action_opcode_837 ], ":" => [ 9, \&_action_opcode_837 ], },
	# [1886] opcode : res "[inline_const]" 0 "," "(" iy ")" "," d
	{ "\n" => [ 9, \&_action_opcode_838 ], ":" => [ 9, \&_action_opcode_838 ], },
	# [1887] opcode : res "[inline_const]" 0 "," "(" iy ")" "," e
	{ "\n" => [ 9, \&_action_opcode_839 ], ":" => [ 9, \&_action_opcode_839 ], },
	# [1888] opcode : res "[inline_const]" 0 "," "(" iy ")" "," h
	{ "\n" => [ 9, \&_action_opcode_840 ], ":" => [ 9, \&_action_opcode_840 ], },
	# [1889] opcode : res "[inline_const]" 0 "," "(" iy ")" "," l
	{ "\n" => [ 9, \&_action_opcode_841 ], ":" => [ 9, \&_action_opcode_841 ], },
	# [1890] opcode : res "[inline_const]" 0 "," "(" iy "+"
	{ "!" => [ 14, 1891 ], "+" => [ 14, 1891 ], "-" => [ 14, 1891 ], __else__ => [ 14, 1891 ], "~" => [ 14, 1891 ], },
	# [1891] opcode : res "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1892, },
	# [1892] opcode : res "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_842 ], "," => 1893, ":" => [ 9, \&_action_opcode_842 ], },
	# [1893] opcode : res "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 1894, b => 1895, c => 1896, d => 1897, e => 1898, h => 1899, l => 1900, },
	# [1894] opcode : res "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_843 ], ":" => [ 9, \&_action_opcode_843 ], },
	# [1895] opcode : res "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_844 ], ":" => [ 9, \&_action_opcode_844 ], },
	# [1896] opcode : res "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_845 ], ":" => [ 9, \&_action_opcode_845 ], },
	# [1897] opcode : res "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_846 ], ":" => [ 9, \&_action_opcode_846 ], },
	# [1898] opcode : res "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_847 ], ":" => [ 9, \&_action_opcode_847 ], },
	# [1899] opcode : res "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_848 ], ":" => [ 9, \&_action_opcode_848 ], },
	# [1900] opcode : res "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_849 ], ":" => [ 9, \&_action_opcode_849 ], },
	# [1901] opcode : res "[inline_const]" 0 "," "(" iy "-"
	{ "!" => [ 16, 1902 ], "+" => [ 16, 1902 ], "-" => [ 16, 1902 ], __else__ => [ 16, 1902 ], "~" => [ 16, 1902 ], },
	# [1902] opcode : res "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1903, },
	# [1903] opcode : res "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_842 ], "," => 1904, ":" => [ 9, \&_action_opcode_842 ], },
	# [1904] opcode : res "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 1905, b => 1906, c => 1907, d => 1908, e => 1909, h => 1910, l => 1911, },
	# [1905] opcode : res "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_843 ], ":" => [ 9, \&_action_opcode_843 ], },
	# [1906] opcode : res "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_844 ], ":" => [ 9, \&_action_opcode_844 ], },
	# [1907] opcode : res "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_845 ], ":" => [ 9, \&_action_opcode_845 ], },
	# [1908] opcode : res "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_846 ], ":" => [ 9, \&_action_opcode_846 ], },
	# [1909] opcode : res "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_847 ], ":" => [ 9, \&_action_opcode_847 ], },
	# [1910] opcode : res "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_848 ], ":" => [ 9, \&_action_opcode_848 ], },
	# [1911] opcode : res "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_849 ], ":" => [ 9, \&_action_opcode_849 ], },
	# [1912] opcode : res "[inline_const]" 0 "," a
	{ "\n" => [ 9, \&_action_opcode_850 ], ":" => [ 9, \&_action_opcode_850 ], },
	# [1913] opcode : res "[inline_const]" 0 "," b
	{ "\n" => [ 9, \&_action_opcode_851 ], ":" => [ 9, \&_action_opcode_851 ], },
	# [1914] opcode : res "[inline_const]" 0 "," c
	{ "\n" => [ 9, \&_action_opcode_852 ], ":" => [ 9, \&_action_opcode_852 ], },
	# [1915] opcode : res "[inline_const]" 0 "," d
	{ "\n" => [ 9, \&_action_opcode_853 ], ":" => [ 9, \&_action_opcode_853 ], },
	# [1916] opcode : res "[inline_const]" 0 "," e
	{ "\n" => [ 9, \&_action_opcode_854 ], ":" => [ 9, \&_action_opcode_854 ], },
	# [1917] opcode : res "[inline_const]" 0 "," h
	{ "\n" => [ 9, \&_action_opcode_855 ], ":" => [ 9, \&_action_opcode_855 ], },
	# [1918] opcode : res "[inline_const]" 0 "," l
	{ "\n" => [ 9, \&_action_opcode_856 ], ":" => [ 9, \&_action_opcode_856 ], },
	# [1919] opcode : res "[inline_const]" 1
	{ "," => 1920, },
	# [1920] opcode : res "[inline_const]" 1 ","
	{ "(" => 1921, a => 1988, b => 1989, c => 1990, d => 1991, e => 1992, h => 1993, l => 1994, },
	# [1921] opcode : res "[inline_const]" 1 "," "("
	{ hl => 1922, ix => 1924, iy => 1956, },
	# [1922] opcode : res "[inline_const]" 1 "," "(" hl
	{ ")" => 1923, },
	# [1923] opcode : res "[inline_const]" 1 "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_857 ], ":" => [ 9, \&_action_opcode_857 ], },
	# [1924] opcode : res "[inline_const]" 1 "," "(" ix
	{ ")" => 1925, "+" => 1934, "-" => 1945, },
	# [1925] opcode : res "[inline_const]" 1 "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_858 ], "," => 1926, ":" => [ 9, \&_action_opcode_858 ], },
	# [1926] opcode : res "[inline_const]" 1 "," "(" ix ")" ","
	{ a => 1927, b => 1928, c => 1929, d => 1930, e => 1931, h => 1932, l => 1933, },
	# [1927] opcode : res "[inline_const]" 1 "," "(" ix ")" "," a
	{ "\n" => [ 9, \&_action_opcode_859 ], ":" => [ 9, \&_action_opcode_859 ], },
	# [1928] opcode : res "[inline_const]" 1 "," "(" ix ")" "," b
	{ "\n" => [ 9, \&_action_opcode_860 ], ":" => [ 9, \&_action_opcode_860 ], },
	# [1929] opcode : res "[inline_const]" 1 "," "(" ix ")" "," c
	{ "\n" => [ 9, \&_action_opcode_861 ], ":" => [ 9, \&_action_opcode_861 ], },
	# [1930] opcode : res "[inline_const]" 1 "," "(" ix ")" "," d
	{ "\n" => [ 9, \&_action_opcode_862 ], ":" => [ 9, \&_action_opcode_862 ], },
	# [1931] opcode : res "[inline_const]" 1 "," "(" ix ")" "," e
	{ "\n" => [ 9, \&_action_opcode_863 ], ":" => [ 9, \&_action_opcode_863 ], },
	# [1932] opcode : res "[inline_const]" 1 "," "(" ix ")" "," h
	{ "\n" => [ 9, \&_action_opcode_864 ], ":" => [ 9, \&_action_opcode_864 ], },
	# [1933] opcode : res "[inline_const]" 1 "," "(" ix ")" "," l
	{ "\n" => [ 9, \&_action_opcode_865 ], ":" => [ 9, \&_action_opcode_865 ], },
	# [1934] opcode : res "[inline_const]" 1 "," "(" ix "+"
	{ "!" => [ 14, 1935 ], "+" => [ 14, 1935 ], "-" => [ 14, 1935 ], __else__ => [ 14, 1935 ], "~" => [ 14, 1935 ], },
	# [1935] opcode : res "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 1936, },
	# [1936] opcode : res "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_866 ], "," => 1937, ":" => [ 9, \&_action_opcode_866 ], },
	# [1937] opcode : res "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 1938, b => 1939, c => 1940, d => 1941, e => 1942, h => 1943, l => 1944, },
	# [1938] opcode : res "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_867 ], ":" => [ 9, \&_action_opcode_867 ], },
	# [1939] opcode : res "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_868 ], ":" => [ 9, \&_action_opcode_868 ], },
	# [1940] opcode : res "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_869 ], ":" => [ 9, \&_action_opcode_869 ], },
	# [1941] opcode : res "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_870 ], ":" => [ 9, \&_action_opcode_870 ], },
	# [1942] opcode : res "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_871 ], ":" => [ 9, \&_action_opcode_871 ], },
	# [1943] opcode : res "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_872 ], ":" => [ 9, \&_action_opcode_872 ], },
	# [1944] opcode : res "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_873 ], ":" => [ 9, \&_action_opcode_873 ], },
	# [1945] opcode : res "[inline_const]" 1 "," "(" ix "-"
	{ "!" => [ 16, 1946 ], "+" => [ 16, 1946 ], "-" => [ 16, 1946 ], __else__ => [ 16, 1946 ], "~" => [ 16, 1946 ], },
	# [1946] opcode : res "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 1947, },
	# [1947] opcode : res "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_866 ], "," => 1948, ":" => [ 9, \&_action_opcode_866 ], },
	# [1948] opcode : res "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 1949, b => 1950, c => 1951, d => 1952, e => 1953, h => 1954, l => 1955, },
	# [1949] opcode : res "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_867 ], ":" => [ 9, \&_action_opcode_867 ], },
	# [1950] opcode : res "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_868 ], ":" => [ 9, \&_action_opcode_868 ], },
	# [1951] opcode : res "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_869 ], ":" => [ 9, \&_action_opcode_869 ], },
	# [1952] opcode : res "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_870 ], ":" => [ 9, \&_action_opcode_870 ], },
	# [1953] opcode : res "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_871 ], ":" => [ 9, \&_action_opcode_871 ], },
	# [1954] opcode : res "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_872 ], ":" => [ 9, \&_action_opcode_872 ], },
	# [1955] opcode : res "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_873 ], ":" => [ 9, \&_action_opcode_873 ], },
	# [1956] opcode : res "[inline_const]" 1 "," "(" iy
	{ ")" => 1957, "+" => 1966, "-" => 1977, },
	# [1957] opcode : res "[inline_const]" 1 "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_874 ], "," => 1958, ":" => [ 9, \&_action_opcode_874 ], },
	# [1958] opcode : res "[inline_const]" 1 "," "(" iy ")" ","
	{ a => 1959, b => 1960, c => 1961, d => 1962, e => 1963, h => 1964, l => 1965, },
	# [1959] opcode : res "[inline_const]" 1 "," "(" iy ")" "," a
	{ "\n" => [ 9, \&_action_opcode_875 ], ":" => [ 9, \&_action_opcode_875 ], },
	# [1960] opcode : res "[inline_const]" 1 "," "(" iy ")" "," b
	{ "\n" => [ 9, \&_action_opcode_876 ], ":" => [ 9, \&_action_opcode_876 ], },
	# [1961] opcode : res "[inline_const]" 1 "," "(" iy ")" "," c
	{ "\n" => [ 9, \&_action_opcode_877 ], ":" => [ 9, \&_action_opcode_877 ], },
	# [1962] opcode : res "[inline_const]" 1 "," "(" iy ")" "," d
	{ "\n" => [ 9, \&_action_opcode_878 ], ":" => [ 9, \&_action_opcode_878 ], },
	# [1963] opcode : res "[inline_const]" 1 "," "(" iy ")" "," e
	{ "\n" => [ 9, \&_action_opcode_879 ], ":" => [ 9, \&_action_opcode_879 ], },
	# [1964] opcode : res "[inline_const]" 1 "," "(" iy ")" "," h
	{ "\n" => [ 9, \&_action_opcode_880 ], ":" => [ 9, \&_action_opcode_880 ], },
	# [1965] opcode : res "[inline_const]" 1 "," "(" iy ")" "," l
	{ "\n" => [ 9, \&_action_opcode_881 ], ":" => [ 9, \&_action_opcode_881 ], },
	# [1966] opcode : res "[inline_const]" 1 "," "(" iy "+"
	{ "!" => [ 14, 1967 ], "+" => [ 14, 1967 ], "-" => [ 14, 1967 ], __else__ => [ 14, 1967 ], "~" => [ 14, 1967 ], },
	# [1967] opcode : res "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 1968, },
	# [1968] opcode : res "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_882 ], "," => 1969, ":" => [ 9, \&_action_opcode_882 ], },
	# [1969] opcode : res "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 1970, b => 1971, c => 1972, d => 1973, e => 1974, h => 1975, l => 1976, },
	# [1970] opcode : res "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_883 ], ":" => [ 9, \&_action_opcode_883 ], },
	# [1971] opcode : res "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_884 ], ":" => [ 9, \&_action_opcode_884 ], },
	# [1972] opcode : res "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_885 ], ":" => [ 9, \&_action_opcode_885 ], },
	# [1973] opcode : res "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_886 ], ":" => [ 9, \&_action_opcode_886 ], },
	# [1974] opcode : res "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_887 ], ":" => [ 9, \&_action_opcode_887 ], },
	# [1975] opcode : res "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_888 ], ":" => [ 9, \&_action_opcode_888 ], },
	# [1976] opcode : res "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_889 ], ":" => [ 9, \&_action_opcode_889 ], },
	# [1977] opcode : res "[inline_const]" 1 "," "(" iy "-"
	{ "!" => [ 16, 1978 ], "+" => [ 16, 1978 ], "-" => [ 16, 1978 ], __else__ => [ 16, 1978 ], "~" => [ 16, 1978 ], },
	# [1978] opcode : res "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 1979, },
	# [1979] opcode : res "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_882 ], "," => 1980, ":" => [ 9, \&_action_opcode_882 ], },
	# [1980] opcode : res "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 1981, b => 1982, c => 1983, d => 1984, e => 1985, h => 1986, l => 1987, },
	# [1981] opcode : res "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_883 ], ":" => [ 9, \&_action_opcode_883 ], },
	# [1982] opcode : res "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_884 ], ":" => [ 9, \&_action_opcode_884 ], },
	# [1983] opcode : res "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_885 ], ":" => [ 9, \&_action_opcode_885 ], },
	# [1984] opcode : res "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_886 ], ":" => [ 9, \&_action_opcode_886 ], },
	# [1985] opcode : res "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_887 ], ":" => [ 9, \&_action_opcode_887 ], },
	# [1986] opcode : res "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_888 ], ":" => [ 9, \&_action_opcode_888 ], },
	# [1987] opcode : res "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_889 ], ":" => [ 9, \&_action_opcode_889 ], },
	# [1988] opcode : res "[inline_const]" 1 "," a
	{ "\n" => [ 9, \&_action_opcode_890 ], ":" => [ 9, \&_action_opcode_890 ], },
	# [1989] opcode : res "[inline_const]" 1 "," b
	{ "\n" => [ 9, \&_action_opcode_891 ], ":" => [ 9, \&_action_opcode_891 ], },
	# [1990] opcode : res "[inline_const]" 1 "," c
	{ "\n" => [ 9, \&_action_opcode_892 ], ":" => [ 9, \&_action_opcode_892 ], },
	# [1991] opcode : res "[inline_const]" 1 "," d
	{ "\n" => [ 9, \&_action_opcode_893 ], ":" => [ 9, \&_action_opcode_893 ], },
	# [1992] opcode : res "[inline_const]" 1 "," e
	{ "\n" => [ 9, \&_action_opcode_894 ], ":" => [ 9, \&_action_opcode_894 ], },
	# [1993] opcode : res "[inline_const]" 1 "," h
	{ "\n" => [ 9, \&_action_opcode_895 ], ":" => [ 9, \&_action_opcode_895 ], },
	# [1994] opcode : res "[inline_const]" 1 "," l
	{ "\n" => [ 9, \&_action_opcode_896 ], ":" => [ 9, \&_action_opcode_896 ], },
	# [1995] opcode : res "[inline_const]" 2
	{ "," => 1996, },
	# [1996] opcode : res "[inline_const]" 2 ","
	{ "(" => 1997, a => 2064, b => 2065, c => 2066, d => 2067, e => 2068, h => 2069, l => 2070, },
	# [1997] opcode : res "[inline_const]" 2 "," "("
	{ hl => 1998, ix => 2000, iy => 2032, },
	# [1998] opcode : res "[inline_const]" 2 "," "(" hl
	{ ")" => 1999, },
	# [1999] opcode : res "[inline_const]" 2 "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_897 ], ":" => [ 9, \&_action_opcode_897 ], },
	# [2000] opcode : res "[inline_const]" 2 "," "(" ix
	{ ")" => 2001, "+" => 2010, "-" => 2021, },
	# [2001] opcode : res "[inline_const]" 2 "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_898 ], "," => 2002, ":" => [ 9, \&_action_opcode_898 ], },
	# [2002] opcode : res "[inline_const]" 2 "," "(" ix ")" ","
	{ a => 2003, b => 2004, c => 2005, d => 2006, e => 2007, h => 2008, l => 2009, },
	# [2003] opcode : res "[inline_const]" 2 "," "(" ix ")" "," a
	{ "\n" => [ 9, \&_action_opcode_899 ], ":" => [ 9, \&_action_opcode_899 ], },
	# [2004] opcode : res "[inline_const]" 2 "," "(" ix ")" "," b
	{ "\n" => [ 9, \&_action_opcode_900 ], ":" => [ 9, \&_action_opcode_900 ], },
	# [2005] opcode : res "[inline_const]" 2 "," "(" ix ")" "," c
	{ "\n" => [ 9, \&_action_opcode_901 ], ":" => [ 9, \&_action_opcode_901 ], },
	# [2006] opcode : res "[inline_const]" 2 "," "(" ix ")" "," d
	{ "\n" => [ 9, \&_action_opcode_902 ], ":" => [ 9, \&_action_opcode_902 ], },
	# [2007] opcode : res "[inline_const]" 2 "," "(" ix ")" "," e
	{ "\n" => [ 9, \&_action_opcode_903 ], ":" => [ 9, \&_action_opcode_903 ], },
	# [2008] opcode : res "[inline_const]" 2 "," "(" ix ")" "," h
	{ "\n" => [ 9, \&_action_opcode_904 ], ":" => [ 9, \&_action_opcode_904 ], },
	# [2009] opcode : res "[inline_const]" 2 "," "(" ix ")" "," l
	{ "\n" => [ 9, \&_action_opcode_905 ], ":" => [ 9, \&_action_opcode_905 ], },
	# [2010] opcode : res "[inline_const]" 2 "," "(" ix "+"
	{ "!" => [ 14, 2011 ], "+" => [ 14, 2011 ], "-" => [ 14, 2011 ], __else__ => [ 14, 2011 ], "~" => [ 14, 2011 ], },
	# [2011] opcode : res "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 2012, },
	# [2012] opcode : res "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_906 ], "," => 2013, ":" => [ 9, \&_action_opcode_906 ], },
	# [2013] opcode : res "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 2014, b => 2015, c => 2016, d => 2017, e => 2018, h => 2019, l => 2020, },
	# [2014] opcode : res "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_907 ], ":" => [ 9, \&_action_opcode_907 ], },
	# [2015] opcode : res "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_908 ], ":" => [ 9, \&_action_opcode_908 ], },
	# [2016] opcode : res "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_909 ], ":" => [ 9, \&_action_opcode_909 ], },
	# [2017] opcode : res "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_910 ], ":" => [ 9, \&_action_opcode_910 ], },
	# [2018] opcode : res "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_911 ], ":" => [ 9, \&_action_opcode_911 ], },
	# [2019] opcode : res "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_912 ], ":" => [ 9, \&_action_opcode_912 ], },
	# [2020] opcode : res "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_913 ], ":" => [ 9, \&_action_opcode_913 ], },
	# [2021] opcode : res "[inline_const]" 2 "," "(" ix "-"
	{ "!" => [ 16, 2022 ], "+" => [ 16, 2022 ], "-" => [ 16, 2022 ], __else__ => [ 16, 2022 ], "~" => [ 16, 2022 ], },
	# [2022] opcode : res "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 2023, },
	# [2023] opcode : res "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_906 ], "," => 2024, ":" => [ 9, \&_action_opcode_906 ], },
	# [2024] opcode : res "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 2025, b => 2026, c => 2027, d => 2028, e => 2029, h => 2030, l => 2031, },
	# [2025] opcode : res "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_907 ], ":" => [ 9, \&_action_opcode_907 ], },
	# [2026] opcode : res "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_908 ], ":" => [ 9, \&_action_opcode_908 ], },
	# [2027] opcode : res "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_909 ], ":" => [ 9, \&_action_opcode_909 ], },
	# [2028] opcode : res "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_910 ], ":" => [ 9, \&_action_opcode_910 ], },
	# [2029] opcode : res "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_911 ], ":" => [ 9, \&_action_opcode_911 ], },
	# [2030] opcode : res "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_912 ], ":" => [ 9, \&_action_opcode_912 ], },
	# [2031] opcode : res "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_913 ], ":" => [ 9, \&_action_opcode_913 ], },
	# [2032] opcode : res "[inline_const]" 2 "," "(" iy
	{ ")" => 2033, "+" => 2042, "-" => 2053, },
	# [2033] opcode : res "[inline_const]" 2 "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_914 ], "," => 2034, ":" => [ 9, \&_action_opcode_914 ], },
	# [2034] opcode : res "[inline_const]" 2 "," "(" iy ")" ","
	{ a => 2035, b => 2036, c => 2037, d => 2038, e => 2039, h => 2040, l => 2041, },
	# [2035] opcode : res "[inline_const]" 2 "," "(" iy ")" "," a
	{ "\n" => [ 9, \&_action_opcode_915 ], ":" => [ 9, \&_action_opcode_915 ], },
	# [2036] opcode : res "[inline_const]" 2 "," "(" iy ")" "," b
	{ "\n" => [ 9, \&_action_opcode_916 ], ":" => [ 9, \&_action_opcode_916 ], },
	# [2037] opcode : res "[inline_const]" 2 "," "(" iy ")" "," c
	{ "\n" => [ 9, \&_action_opcode_917 ], ":" => [ 9, \&_action_opcode_917 ], },
	# [2038] opcode : res "[inline_const]" 2 "," "(" iy ")" "," d
	{ "\n" => [ 9, \&_action_opcode_918 ], ":" => [ 9, \&_action_opcode_918 ], },
	# [2039] opcode : res "[inline_const]" 2 "," "(" iy ")" "," e
	{ "\n" => [ 9, \&_action_opcode_919 ], ":" => [ 9, \&_action_opcode_919 ], },
	# [2040] opcode : res "[inline_const]" 2 "," "(" iy ")" "," h
	{ "\n" => [ 9, \&_action_opcode_920 ], ":" => [ 9, \&_action_opcode_920 ], },
	# [2041] opcode : res "[inline_const]" 2 "," "(" iy ")" "," l
	{ "\n" => [ 9, \&_action_opcode_921 ], ":" => [ 9, \&_action_opcode_921 ], },
	# [2042] opcode : res "[inline_const]" 2 "," "(" iy "+"
	{ "!" => [ 14, 2043 ], "+" => [ 14, 2043 ], "-" => [ 14, 2043 ], __else__ => [ 14, 2043 ], "~" => [ 14, 2043 ], },
	# [2043] opcode : res "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 2044, },
	# [2044] opcode : res "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_922 ], "," => 2045, ":" => [ 9, \&_action_opcode_922 ], },
	# [2045] opcode : res "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 2046, b => 2047, c => 2048, d => 2049, e => 2050, h => 2051, l => 2052, },
	# [2046] opcode : res "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_923 ], ":" => [ 9, \&_action_opcode_923 ], },
	# [2047] opcode : res "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_924 ], ":" => [ 9, \&_action_opcode_924 ], },
	# [2048] opcode : res "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_925 ], ":" => [ 9, \&_action_opcode_925 ], },
	# [2049] opcode : res "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_926 ], ":" => [ 9, \&_action_opcode_926 ], },
	# [2050] opcode : res "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_927 ], ":" => [ 9, \&_action_opcode_927 ], },
	# [2051] opcode : res "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_928 ], ":" => [ 9, \&_action_opcode_928 ], },
	# [2052] opcode : res "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_929 ], ":" => [ 9, \&_action_opcode_929 ], },
	# [2053] opcode : res "[inline_const]" 2 "," "(" iy "-"
	{ "!" => [ 16, 2054 ], "+" => [ 16, 2054 ], "-" => [ 16, 2054 ], __else__ => [ 16, 2054 ], "~" => [ 16, 2054 ], },
	# [2054] opcode : res "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 2055, },
	# [2055] opcode : res "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_922 ], "," => 2056, ":" => [ 9, \&_action_opcode_922 ], },
	# [2056] opcode : res "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 2057, b => 2058, c => 2059, d => 2060, e => 2061, h => 2062, l => 2063, },
	# [2057] opcode : res "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_923 ], ":" => [ 9, \&_action_opcode_923 ], },
	# [2058] opcode : res "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_924 ], ":" => [ 9, \&_action_opcode_924 ], },
	# [2059] opcode : res "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_925 ], ":" => [ 9, \&_action_opcode_925 ], },
	# [2060] opcode : res "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_926 ], ":" => [ 9, \&_action_opcode_926 ], },
	# [2061] opcode : res "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_927 ], ":" => [ 9, \&_action_opcode_927 ], },
	# [2062] opcode : res "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_928 ], ":" => [ 9, \&_action_opcode_928 ], },
	# [2063] opcode : res "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_929 ], ":" => [ 9, \&_action_opcode_929 ], },
	# [2064] opcode : res "[inline_const]" 2 "," a
	{ "\n" => [ 9, \&_action_opcode_930 ], ":" => [ 9, \&_action_opcode_930 ], },
	# [2065] opcode : res "[inline_const]" 2 "," b
	{ "\n" => [ 9, \&_action_opcode_931 ], ":" => [ 9, \&_action_opcode_931 ], },
	# [2066] opcode : res "[inline_const]" 2 "," c
	{ "\n" => [ 9, \&_action_opcode_932 ], ":" => [ 9, \&_action_opcode_932 ], },
	# [2067] opcode : res "[inline_const]" 2 "," d
	{ "\n" => [ 9, \&_action_opcode_933 ], ":" => [ 9, \&_action_opcode_933 ], },
	# [2068] opcode : res "[inline_const]" 2 "," e
	{ "\n" => [ 9, \&_action_opcode_934 ], ":" => [ 9, \&_action_opcode_934 ], },
	# [2069] opcode : res "[inline_const]" 2 "," h
	{ "\n" => [ 9, \&_action_opcode_935 ], ":" => [ 9, \&_action_opcode_935 ], },
	# [2070] opcode : res "[inline_const]" 2 "," l
	{ "\n" => [ 9, \&_action_opcode_936 ], ":" => [ 9, \&_action_opcode_936 ], },
	# [2071] opcode : res "[inline_const]" 3
	{ "," => 2072, },
	# [2072] opcode : res "[inline_const]" 3 ","
	{ "(" => 2073, a => 2140, b => 2141, c => 2142, d => 2143, e => 2144, h => 2145, l => 2146, },
	# [2073] opcode : res "[inline_const]" 3 "," "("
	{ hl => 2074, ix => 2076, iy => 2108, },
	# [2074] opcode : res "[inline_const]" 3 "," "(" hl
	{ ")" => 2075, },
	# [2075] opcode : res "[inline_const]" 3 "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_937 ], ":" => [ 9, \&_action_opcode_937 ], },
	# [2076] opcode : res "[inline_const]" 3 "," "(" ix
	{ ")" => 2077, "+" => 2086, "-" => 2097, },
	# [2077] opcode : res "[inline_const]" 3 "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_938 ], "," => 2078, ":" => [ 9, \&_action_opcode_938 ], },
	# [2078] opcode : res "[inline_const]" 3 "," "(" ix ")" ","
	{ a => 2079, b => 2080, c => 2081, d => 2082, e => 2083, h => 2084, l => 2085, },
	# [2079] opcode : res "[inline_const]" 3 "," "(" ix ")" "," a
	{ "\n" => [ 9, \&_action_opcode_939 ], ":" => [ 9, \&_action_opcode_939 ], },
	# [2080] opcode : res "[inline_const]" 3 "," "(" ix ")" "," b
	{ "\n" => [ 9, \&_action_opcode_940 ], ":" => [ 9, \&_action_opcode_940 ], },
	# [2081] opcode : res "[inline_const]" 3 "," "(" ix ")" "," c
	{ "\n" => [ 9, \&_action_opcode_941 ], ":" => [ 9, \&_action_opcode_941 ], },
	# [2082] opcode : res "[inline_const]" 3 "," "(" ix ")" "," d
	{ "\n" => [ 9, \&_action_opcode_942 ], ":" => [ 9, \&_action_opcode_942 ], },
	# [2083] opcode : res "[inline_const]" 3 "," "(" ix ")" "," e
	{ "\n" => [ 9, \&_action_opcode_943 ], ":" => [ 9, \&_action_opcode_943 ], },
	# [2084] opcode : res "[inline_const]" 3 "," "(" ix ")" "," h
	{ "\n" => [ 9, \&_action_opcode_944 ], ":" => [ 9, \&_action_opcode_944 ], },
	# [2085] opcode : res "[inline_const]" 3 "," "(" ix ")" "," l
	{ "\n" => [ 9, \&_action_opcode_945 ], ":" => [ 9, \&_action_opcode_945 ], },
	# [2086] opcode : res "[inline_const]" 3 "," "(" ix "+"
	{ "!" => [ 14, 2087 ], "+" => [ 14, 2087 ], "-" => [ 14, 2087 ], __else__ => [ 14, 2087 ], "~" => [ 14, 2087 ], },
	# [2087] opcode : res "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 2088, },
	# [2088] opcode : res "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_946 ], "," => 2089, ":" => [ 9, \&_action_opcode_946 ], },
	# [2089] opcode : res "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 2090, b => 2091, c => 2092, d => 2093, e => 2094, h => 2095, l => 2096, },
	# [2090] opcode : res "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_947 ], ":" => [ 9, \&_action_opcode_947 ], },
	# [2091] opcode : res "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_948 ], ":" => [ 9, \&_action_opcode_948 ], },
	# [2092] opcode : res "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_949 ], ":" => [ 9, \&_action_opcode_949 ], },
	# [2093] opcode : res "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_950 ], ":" => [ 9, \&_action_opcode_950 ], },
	# [2094] opcode : res "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_951 ], ":" => [ 9, \&_action_opcode_951 ], },
	# [2095] opcode : res "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_952 ], ":" => [ 9, \&_action_opcode_952 ], },
	# [2096] opcode : res "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_953 ], ":" => [ 9, \&_action_opcode_953 ], },
	# [2097] opcode : res "[inline_const]" 3 "," "(" ix "-"
	{ "!" => [ 16, 2098 ], "+" => [ 16, 2098 ], "-" => [ 16, 2098 ], __else__ => [ 16, 2098 ], "~" => [ 16, 2098 ], },
	# [2098] opcode : res "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 2099, },
	# [2099] opcode : res "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_946 ], "," => 2100, ":" => [ 9, \&_action_opcode_946 ], },
	# [2100] opcode : res "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 2101, b => 2102, c => 2103, d => 2104, e => 2105, h => 2106, l => 2107, },
	# [2101] opcode : res "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_947 ], ":" => [ 9, \&_action_opcode_947 ], },
	# [2102] opcode : res "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_948 ], ":" => [ 9, \&_action_opcode_948 ], },
	# [2103] opcode : res "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_949 ], ":" => [ 9, \&_action_opcode_949 ], },
	# [2104] opcode : res "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_950 ], ":" => [ 9, \&_action_opcode_950 ], },
	# [2105] opcode : res "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_951 ], ":" => [ 9, \&_action_opcode_951 ], },
	# [2106] opcode : res "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_952 ], ":" => [ 9, \&_action_opcode_952 ], },
	# [2107] opcode : res "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_953 ], ":" => [ 9, \&_action_opcode_953 ], },
	# [2108] opcode : res "[inline_const]" 3 "," "(" iy
	{ ")" => 2109, "+" => 2118, "-" => 2129, },
	# [2109] opcode : res "[inline_const]" 3 "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_954 ], "," => 2110, ":" => [ 9, \&_action_opcode_954 ], },
	# [2110] opcode : res "[inline_const]" 3 "," "(" iy ")" ","
	{ a => 2111, b => 2112, c => 2113, d => 2114, e => 2115, h => 2116, l => 2117, },
	# [2111] opcode : res "[inline_const]" 3 "," "(" iy ")" "," a
	{ "\n" => [ 9, \&_action_opcode_955 ], ":" => [ 9, \&_action_opcode_955 ], },
	# [2112] opcode : res "[inline_const]" 3 "," "(" iy ")" "," b
	{ "\n" => [ 9, \&_action_opcode_956 ], ":" => [ 9, \&_action_opcode_956 ], },
	# [2113] opcode : res "[inline_const]" 3 "," "(" iy ")" "," c
	{ "\n" => [ 9, \&_action_opcode_957 ], ":" => [ 9, \&_action_opcode_957 ], },
	# [2114] opcode : res "[inline_const]" 3 "," "(" iy ")" "," d
	{ "\n" => [ 9, \&_action_opcode_958 ], ":" => [ 9, \&_action_opcode_958 ], },
	# [2115] opcode : res "[inline_const]" 3 "," "(" iy ")" "," e
	{ "\n" => [ 9, \&_action_opcode_959 ], ":" => [ 9, \&_action_opcode_959 ], },
	# [2116] opcode : res "[inline_const]" 3 "," "(" iy ")" "," h
	{ "\n" => [ 9, \&_action_opcode_960 ], ":" => [ 9, \&_action_opcode_960 ], },
	# [2117] opcode : res "[inline_const]" 3 "," "(" iy ")" "," l
	{ "\n" => [ 9, \&_action_opcode_961 ], ":" => [ 9, \&_action_opcode_961 ], },
	# [2118] opcode : res "[inline_const]" 3 "," "(" iy "+"
	{ "!" => [ 14, 2119 ], "+" => [ 14, 2119 ], "-" => [ 14, 2119 ], __else__ => [ 14, 2119 ], "~" => [ 14, 2119 ], },
	# [2119] opcode : res "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 2120, },
	# [2120] opcode : res "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_962 ], "," => 2121, ":" => [ 9, \&_action_opcode_962 ], },
	# [2121] opcode : res "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 2122, b => 2123, c => 2124, d => 2125, e => 2126, h => 2127, l => 2128, },
	# [2122] opcode : res "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_963 ], ":" => [ 9, \&_action_opcode_963 ], },
	# [2123] opcode : res "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_964 ], ":" => [ 9, \&_action_opcode_964 ], },
	# [2124] opcode : res "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_965 ], ":" => [ 9, \&_action_opcode_965 ], },
	# [2125] opcode : res "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_966 ], ":" => [ 9, \&_action_opcode_966 ], },
	# [2126] opcode : res "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_967 ], ":" => [ 9, \&_action_opcode_967 ], },
	# [2127] opcode : res "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_968 ], ":" => [ 9, \&_action_opcode_968 ], },
	# [2128] opcode : res "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_969 ], ":" => [ 9, \&_action_opcode_969 ], },
	# [2129] opcode : res "[inline_const]" 3 "," "(" iy "-"
	{ "!" => [ 16, 2130 ], "+" => [ 16, 2130 ], "-" => [ 16, 2130 ], __else__ => [ 16, 2130 ], "~" => [ 16, 2130 ], },
	# [2130] opcode : res "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 2131, },
	# [2131] opcode : res "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_962 ], "," => 2132, ":" => [ 9, \&_action_opcode_962 ], },
	# [2132] opcode : res "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 2133, b => 2134, c => 2135, d => 2136, e => 2137, h => 2138, l => 2139, },
	# [2133] opcode : res "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_963 ], ":" => [ 9, \&_action_opcode_963 ], },
	# [2134] opcode : res "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_964 ], ":" => [ 9, \&_action_opcode_964 ], },
	# [2135] opcode : res "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_965 ], ":" => [ 9, \&_action_opcode_965 ], },
	# [2136] opcode : res "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_966 ], ":" => [ 9, \&_action_opcode_966 ], },
	# [2137] opcode : res "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_967 ], ":" => [ 9, \&_action_opcode_967 ], },
	# [2138] opcode : res "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_968 ], ":" => [ 9, \&_action_opcode_968 ], },
	# [2139] opcode : res "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_969 ], ":" => [ 9, \&_action_opcode_969 ], },
	# [2140] opcode : res "[inline_const]" 3 "," a
	{ "\n" => [ 9, \&_action_opcode_970 ], ":" => [ 9, \&_action_opcode_970 ], },
	# [2141] opcode : res "[inline_const]" 3 "," b
	{ "\n" => [ 9, \&_action_opcode_971 ], ":" => [ 9, \&_action_opcode_971 ], },
	# [2142] opcode : res "[inline_const]" 3 "," c
	{ "\n" => [ 9, \&_action_opcode_972 ], ":" => [ 9, \&_action_opcode_972 ], },
	# [2143] opcode : res "[inline_const]" 3 "," d
	{ "\n" => [ 9, \&_action_opcode_973 ], ":" => [ 9, \&_action_opcode_973 ], },
	# [2144] opcode : res "[inline_const]" 3 "," e
	{ "\n" => [ 9, \&_action_opcode_974 ], ":" => [ 9, \&_action_opcode_974 ], },
	# [2145] opcode : res "[inline_const]" 3 "," h
	{ "\n" => [ 9, \&_action_opcode_975 ], ":" => [ 9, \&_action_opcode_975 ], },
	# [2146] opcode : res "[inline_const]" 3 "," l
	{ "\n" => [ 9, \&_action_opcode_976 ], ":" => [ 9, \&_action_opcode_976 ], },
	# [2147] opcode : res "[inline_const]" 4
	{ "," => 2148, },
	# [2148] opcode : res "[inline_const]" 4 ","
	{ "(" => 2149, a => 2216, b => 2217, c => 2218, d => 2219, e => 2220, h => 2221, l => 2222, },
	# [2149] opcode : res "[inline_const]" 4 "," "("
	{ hl => 2150, ix => 2152, iy => 2184, },
	# [2150] opcode : res "[inline_const]" 4 "," "(" hl
	{ ")" => 2151, },
	# [2151] opcode : res "[inline_const]" 4 "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_977 ], ":" => [ 9, \&_action_opcode_977 ], },
	# [2152] opcode : res "[inline_const]" 4 "," "(" ix
	{ ")" => 2153, "+" => 2162, "-" => 2173, },
	# [2153] opcode : res "[inline_const]" 4 "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_978 ], "," => 2154, ":" => [ 9, \&_action_opcode_978 ], },
	# [2154] opcode : res "[inline_const]" 4 "," "(" ix ")" ","
	{ a => 2155, b => 2156, c => 2157, d => 2158, e => 2159, h => 2160, l => 2161, },
	# [2155] opcode : res "[inline_const]" 4 "," "(" ix ")" "," a
	{ "\n" => [ 9, \&_action_opcode_979 ], ":" => [ 9, \&_action_opcode_979 ], },
	# [2156] opcode : res "[inline_const]" 4 "," "(" ix ")" "," b
	{ "\n" => [ 9, \&_action_opcode_980 ], ":" => [ 9, \&_action_opcode_980 ], },
	# [2157] opcode : res "[inline_const]" 4 "," "(" ix ")" "," c
	{ "\n" => [ 9, \&_action_opcode_981 ], ":" => [ 9, \&_action_opcode_981 ], },
	# [2158] opcode : res "[inline_const]" 4 "," "(" ix ")" "," d
	{ "\n" => [ 9, \&_action_opcode_982 ], ":" => [ 9, \&_action_opcode_982 ], },
	# [2159] opcode : res "[inline_const]" 4 "," "(" ix ")" "," e
	{ "\n" => [ 9, \&_action_opcode_983 ], ":" => [ 9, \&_action_opcode_983 ], },
	# [2160] opcode : res "[inline_const]" 4 "," "(" ix ")" "," h
	{ "\n" => [ 9, \&_action_opcode_984 ], ":" => [ 9, \&_action_opcode_984 ], },
	# [2161] opcode : res "[inline_const]" 4 "," "(" ix ")" "," l
	{ "\n" => [ 9, \&_action_opcode_985 ], ":" => [ 9, \&_action_opcode_985 ], },
	# [2162] opcode : res "[inline_const]" 4 "," "(" ix "+"
	{ "!" => [ 14, 2163 ], "+" => [ 14, 2163 ], "-" => [ 14, 2163 ], __else__ => [ 14, 2163 ], "~" => [ 14, 2163 ], },
	# [2163] opcode : res "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 2164, },
	# [2164] opcode : res "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_986 ], "," => 2165, ":" => [ 9, \&_action_opcode_986 ], },
	# [2165] opcode : res "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 2166, b => 2167, c => 2168, d => 2169, e => 2170, h => 2171, l => 2172, },
	# [2166] opcode : res "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_987 ], ":" => [ 9, \&_action_opcode_987 ], },
	# [2167] opcode : res "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_988 ], ":" => [ 9, \&_action_opcode_988 ], },
	# [2168] opcode : res "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_989 ], ":" => [ 9, \&_action_opcode_989 ], },
	# [2169] opcode : res "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_990 ], ":" => [ 9, \&_action_opcode_990 ], },
	# [2170] opcode : res "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_991 ], ":" => [ 9, \&_action_opcode_991 ], },
	# [2171] opcode : res "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_992 ], ":" => [ 9, \&_action_opcode_992 ], },
	# [2172] opcode : res "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_993 ], ":" => [ 9, \&_action_opcode_993 ], },
	# [2173] opcode : res "[inline_const]" 4 "," "(" ix "-"
	{ "!" => [ 16, 2174 ], "+" => [ 16, 2174 ], "-" => [ 16, 2174 ], __else__ => [ 16, 2174 ], "~" => [ 16, 2174 ], },
	# [2174] opcode : res "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 2175, },
	# [2175] opcode : res "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_986 ], "," => 2176, ":" => [ 9, \&_action_opcode_986 ], },
	# [2176] opcode : res "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 2177, b => 2178, c => 2179, d => 2180, e => 2181, h => 2182, l => 2183, },
	# [2177] opcode : res "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_987 ], ":" => [ 9, \&_action_opcode_987 ], },
	# [2178] opcode : res "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_988 ], ":" => [ 9, \&_action_opcode_988 ], },
	# [2179] opcode : res "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_989 ], ":" => [ 9, \&_action_opcode_989 ], },
	# [2180] opcode : res "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_990 ], ":" => [ 9, \&_action_opcode_990 ], },
	# [2181] opcode : res "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_991 ], ":" => [ 9, \&_action_opcode_991 ], },
	# [2182] opcode : res "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_992 ], ":" => [ 9, \&_action_opcode_992 ], },
	# [2183] opcode : res "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_993 ], ":" => [ 9, \&_action_opcode_993 ], },
	# [2184] opcode : res "[inline_const]" 4 "," "(" iy
	{ ")" => 2185, "+" => 2194, "-" => 2205, },
	# [2185] opcode : res "[inline_const]" 4 "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_994 ], "," => 2186, ":" => [ 9, \&_action_opcode_994 ], },
	# [2186] opcode : res "[inline_const]" 4 "," "(" iy ")" ","
	{ a => 2187, b => 2188, c => 2189, d => 2190, e => 2191, h => 2192, l => 2193, },
	# [2187] opcode : res "[inline_const]" 4 "," "(" iy ")" "," a
	{ "\n" => [ 9, \&_action_opcode_995 ], ":" => [ 9, \&_action_opcode_995 ], },
	# [2188] opcode : res "[inline_const]" 4 "," "(" iy ")" "," b
	{ "\n" => [ 9, \&_action_opcode_996 ], ":" => [ 9, \&_action_opcode_996 ], },
	# [2189] opcode : res "[inline_const]" 4 "," "(" iy ")" "," c
	{ "\n" => [ 9, \&_action_opcode_997 ], ":" => [ 9, \&_action_opcode_997 ], },
	# [2190] opcode : res "[inline_const]" 4 "," "(" iy ")" "," d
	{ "\n" => [ 9, \&_action_opcode_998 ], ":" => [ 9, \&_action_opcode_998 ], },
	# [2191] opcode : res "[inline_const]" 4 "," "(" iy ")" "," e
	{ "\n" => [ 9, \&_action_opcode_999 ], ":" => [ 9, \&_action_opcode_999 ], },
	# [2192] opcode : res "[inline_const]" 4 "," "(" iy ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1000 ], ":" => [ 9, \&_action_opcode_1000 ], },
	# [2193] opcode : res "[inline_const]" 4 "," "(" iy ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1001 ], ":" => [ 9, \&_action_opcode_1001 ], },
	# [2194] opcode : res "[inline_const]" 4 "," "(" iy "+"
	{ "!" => [ 14, 2195 ], "+" => [ 14, 2195 ], "-" => [ 14, 2195 ], __else__ => [ 14, 2195 ], "~" => [ 14, 2195 ], },
	# [2195] opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 2196, },
	# [2196] opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1002 ], "," => 2197, ":" => [ 9, \&_action_opcode_1002 ], },
	# [2197] opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 2198, b => 2199, c => 2200, d => 2201, e => 2202, h => 2203, l => 2204, },
	# [2198] opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1003 ], ":" => [ 9, \&_action_opcode_1003 ], },
	# [2199] opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1004 ], ":" => [ 9, \&_action_opcode_1004 ], },
	# [2200] opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1005 ], ":" => [ 9, \&_action_opcode_1005 ], },
	# [2201] opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1006 ], ":" => [ 9, \&_action_opcode_1006 ], },
	# [2202] opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1007 ], ":" => [ 9, \&_action_opcode_1007 ], },
	# [2203] opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1008 ], ":" => [ 9, \&_action_opcode_1008 ], },
	# [2204] opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1009 ], ":" => [ 9, \&_action_opcode_1009 ], },
	# [2205] opcode : res "[inline_const]" 4 "," "(" iy "-"
	{ "!" => [ 16, 2206 ], "+" => [ 16, 2206 ], "-" => [ 16, 2206 ], __else__ => [ 16, 2206 ], "~" => [ 16, 2206 ], },
	# [2206] opcode : res "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 2207, },
	# [2207] opcode : res "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1002 ], "," => 2208, ":" => [ 9, \&_action_opcode_1002 ], },
	# [2208] opcode : res "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 2209, b => 2210, c => 2211, d => 2212, e => 2213, h => 2214, l => 2215, },
	# [2209] opcode : res "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1003 ], ":" => [ 9, \&_action_opcode_1003 ], },
	# [2210] opcode : res "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1004 ], ":" => [ 9, \&_action_opcode_1004 ], },
	# [2211] opcode : res "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1005 ], ":" => [ 9, \&_action_opcode_1005 ], },
	# [2212] opcode : res "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1006 ], ":" => [ 9, \&_action_opcode_1006 ], },
	# [2213] opcode : res "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1007 ], ":" => [ 9, \&_action_opcode_1007 ], },
	# [2214] opcode : res "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1008 ], ":" => [ 9, \&_action_opcode_1008 ], },
	# [2215] opcode : res "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1009 ], ":" => [ 9, \&_action_opcode_1009 ], },
	# [2216] opcode : res "[inline_const]" 4 "," a
	{ "\n" => [ 9, \&_action_opcode_1010 ], ":" => [ 9, \&_action_opcode_1010 ], },
	# [2217] opcode : res "[inline_const]" 4 "," b
	{ "\n" => [ 9, \&_action_opcode_1011 ], ":" => [ 9, \&_action_opcode_1011 ], },
	# [2218] opcode : res "[inline_const]" 4 "," c
	{ "\n" => [ 9, \&_action_opcode_1012 ], ":" => [ 9, \&_action_opcode_1012 ], },
	# [2219] opcode : res "[inline_const]" 4 "," d
	{ "\n" => [ 9, \&_action_opcode_1013 ], ":" => [ 9, \&_action_opcode_1013 ], },
	# [2220] opcode : res "[inline_const]" 4 "," e
	{ "\n" => [ 9, \&_action_opcode_1014 ], ":" => [ 9, \&_action_opcode_1014 ], },
	# [2221] opcode : res "[inline_const]" 4 "," h
	{ "\n" => [ 9, \&_action_opcode_1015 ], ":" => [ 9, \&_action_opcode_1015 ], },
	# [2222] opcode : res "[inline_const]" 4 "," l
	{ "\n" => [ 9, \&_action_opcode_1016 ], ":" => [ 9, \&_action_opcode_1016 ], },
	# [2223] opcode : res "[inline_const]" 5
	{ "," => 2224, },
	# [2224] opcode : res "[inline_const]" 5 ","
	{ "(" => 2225, a => 2292, b => 2293, c => 2294, d => 2295, e => 2296, h => 2297, l => 2298, },
	# [2225] opcode : res "[inline_const]" 5 "," "("
	{ hl => 2226, ix => 2228, iy => 2260, },
	# [2226] opcode : res "[inline_const]" 5 "," "(" hl
	{ ")" => 2227, },
	# [2227] opcode : res "[inline_const]" 5 "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_1017 ], ":" => [ 9, \&_action_opcode_1017 ], },
	# [2228] opcode : res "[inline_const]" 5 "," "(" ix
	{ ")" => 2229, "+" => 2238, "-" => 2249, },
	# [2229] opcode : res "[inline_const]" 5 "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_1018 ], "," => 2230, ":" => [ 9, \&_action_opcode_1018 ], },
	# [2230] opcode : res "[inline_const]" 5 "," "(" ix ")" ","
	{ a => 2231, b => 2232, c => 2233, d => 2234, e => 2235, h => 2236, l => 2237, },
	# [2231] opcode : res "[inline_const]" 5 "," "(" ix ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1019 ], ":" => [ 9, \&_action_opcode_1019 ], },
	# [2232] opcode : res "[inline_const]" 5 "," "(" ix ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1020 ], ":" => [ 9, \&_action_opcode_1020 ], },
	# [2233] opcode : res "[inline_const]" 5 "," "(" ix ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1021 ], ":" => [ 9, \&_action_opcode_1021 ], },
	# [2234] opcode : res "[inline_const]" 5 "," "(" ix ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1022 ], ":" => [ 9, \&_action_opcode_1022 ], },
	# [2235] opcode : res "[inline_const]" 5 "," "(" ix ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1023 ], ":" => [ 9, \&_action_opcode_1023 ], },
	# [2236] opcode : res "[inline_const]" 5 "," "(" ix ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1024 ], ":" => [ 9, \&_action_opcode_1024 ], },
	# [2237] opcode : res "[inline_const]" 5 "," "(" ix ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1025 ], ":" => [ 9, \&_action_opcode_1025 ], },
	# [2238] opcode : res "[inline_const]" 5 "," "(" ix "+"
	{ "!" => [ 14, 2239 ], "+" => [ 14, 2239 ], "-" => [ 14, 2239 ], __else__ => [ 14, 2239 ], "~" => [ 14, 2239 ], },
	# [2239] opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 2240, },
	# [2240] opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1026 ], "," => 2241, ":" => [ 9, \&_action_opcode_1026 ], },
	# [2241] opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 2242, b => 2243, c => 2244, d => 2245, e => 2246, h => 2247, l => 2248, },
	# [2242] opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1027 ], ":" => [ 9, \&_action_opcode_1027 ], },
	# [2243] opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1028 ], ":" => [ 9, \&_action_opcode_1028 ], },
	# [2244] opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1029 ], ":" => [ 9, \&_action_opcode_1029 ], },
	# [2245] opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1030 ], ":" => [ 9, \&_action_opcode_1030 ], },
	# [2246] opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1031 ], ":" => [ 9, \&_action_opcode_1031 ], },
	# [2247] opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1032 ], ":" => [ 9, \&_action_opcode_1032 ], },
	# [2248] opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1033 ], ":" => [ 9, \&_action_opcode_1033 ], },
	# [2249] opcode : res "[inline_const]" 5 "," "(" ix "-"
	{ "!" => [ 16, 2250 ], "+" => [ 16, 2250 ], "-" => [ 16, 2250 ], __else__ => [ 16, 2250 ], "~" => [ 16, 2250 ], },
	# [2250] opcode : res "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 2251, },
	# [2251] opcode : res "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1026 ], "," => 2252, ":" => [ 9, \&_action_opcode_1026 ], },
	# [2252] opcode : res "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 2253, b => 2254, c => 2255, d => 2256, e => 2257, h => 2258, l => 2259, },
	# [2253] opcode : res "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1027 ], ":" => [ 9, \&_action_opcode_1027 ], },
	# [2254] opcode : res "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1028 ], ":" => [ 9, \&_action_opcode_1028 ], },
	# [2255] opcode : res "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1029 ], ":" => [ 9, \&_action_opcode_1029 ], },
	# [2256] opcode : res "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1030 ], ":" => [ 9, \&_action_opcode_1030 ], },
	# [2257] opcode : res "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1031 ], ":" => [ 9, \&_action_opcode_1031 ], },
	# [2258] opcode : res "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1032 ], ":" => [ 9, \&_action_opcode_1032 ], },
	# [2259] opcode : res "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1033 ], ":" => [ 9, \&_action_opcode_1033 ], },
	# [2260] opcode : res "[inline_const]" 5 "," "(" iy
	{ ")" => 2261, "+" => 2270, "-" => 2281, },
	# [2261] opcode : res "[inline_const]" 5 "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_1034 ], "," => 2262, ":" => [ 9, \&_action_opcode_1034 ], },
	# [2262] opcode : res "[inline_const]" 5 "," "(" iy ")" ","
	{ a => 2263, b => 2264, c => 2265, d => 2266, e => 2267, h => 2268, l => 2269, },
	# [2263] opcode : res "[inline_const]" 5 "," "(" iy ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1035 ], ":" => [ 9, \&_action_opcode_1035 ], },
	# [2264] opcode : res "[inline_const]" 5 "," "(" iy ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1036 ], ":" => [ 9, \&_action_opcode_1036 ], },
	# [2265] opcode : res "[inline_const]" 5 "," "(" iy ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1037 ], ":" => [ 9, \&_action_opcode_1037 ], },
	# [2266] opcode : res "[inline_const]" 5 "," "(" iy ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1038 ], ":" => [ 9, \&_action_opcode_1038 ], },
	# [2267] opcode : res "[inline_const]" 5 "," "(" iy ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1039 ], ":" => [ 9, \&_action_opcode_1039 ], },
	# [2268] opcode : res "[inline_const]" 5 "," "(" iy ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1040 ], ":" => [ 9, \&_action_opcode_1040 ], },
	# [2269] opcode : res "[inline_const]" 5 "," "(" iy ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1041 ], ":" => [ 9, \&_action_opcode_1041 ], },
	# [2270] opcode : res "[inline_const]" 5 "," "(" iy "+"
	{ "!" => [ 14, 2271 ], "+" => [ 14, 2271 ], "-" => [ 14, 2271 ], __else__ => [ 14, 2271 ], "~" => [ 14, 2271 ], },
	# [2271] opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 2272, },
	# [2272] opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1042 ], "," => 2273, ":" => [ 9, \&_action_opcode_1042 ], },
	# [2273] opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 2274, b => 2275, c => 2276, d => 2277, e => 2278, h => 2279, l => 2280, },
	# [2274] opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1043 ], ":" => [ 9, \&_action_opcode_1043 ], },
	# [2275] opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1044 ], ":" => [ 9, \&_action_opcode_1044 ], },
	# [2276] opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1045 ], ":" => [ 9, \&_action_opcode_1045 ], },
	# [2277] opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1046 ], ":" => [ 9, \&_action_opcode_1046 ], },
	# [2278] opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1047 ], ":" => [ 9, \&_action_opcode_1047 ], },
	# [2279] opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1048 ], ":" => [ 9, \&_action_opcode_1048 ], },
	# [2280] opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1049 ], ":" => [ 9, \&_action_opcode_1049 ], },
	# [2281] opcode : res "[inline_const]" 5 "," "(" iy "-"
	{ "!" => [ 16, 2282 ], "+" => [ 16, 2282 ], "-" => [ 16, 2282 ], __else__ => [ 16, 2282 ], "~" => [ 16, 2282 ], },
	# [2282] opcode : res "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 2283, },
	# [2283] opcode : res "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1042 ], "," => 2284, ":" => [ 9, \&_action_opcode_1042 ], },
	# [2284] opcode : res "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 2285, b => 2286, c => 2287, d => 2288, e => 2289, h => 2290, l => 2291, },
	# [2285] opcode : res "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1043 ], ":" => [ 9, \&_action_opcode_1043 ], },
	# [2286] opcode : res "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1044 ], ":" => [ 9, \&_action_opcode_1044 ], },
	# [2287] opcode : res "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1045 ], ":" => [ 9, \&_action_opcode_1045 ], },
	# [2288] opcode : res "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1046 ], ":" => [ 9, \&_action_opcode_1046 ], },
	# [2289] opcode : res "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1047 ], ":" => [ 9, \&_action_opcode_1047 ], },
	# [2290] opcode : res "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1048 ], ":" => [ 9, \&_action_opcode_1048 ], },
	# [2291] opcode : res "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1049 ], ":" => [ 9, \&_action_opcode_1049 ], },
	# [2292] opcode : res "[inline_const]" 5 "," a
	{ "\n" => [ 9, \&_action_opcode_1050 ], ":" => [ 9, \&_action_opcode_1050 ], },
	# [2293] opcode : res "[inline_const]" 5 "," b
	{ "\n" => [ 9, \&_action_opcode_1051 ], ":" => [ 9, \&_action_opcode_1051 ], },
	# [2294] opcode : res "[inline_const]" 5 "," c
	{ "\n" => [ 9, \&_action_opcode_1052 ], ":" => [ 9, \&_action_opcode_1052 ], },
	# [2295] opcode : res "[inline_const]" 5 "," d
	{ "\n" => [ 9, \&_action_opcode_1053 ], ":" => [ 9, \&_action_opcode_1053 ], },
	# [2296] opcode : res "[inline_const]" 5 "," e
	{ "\n" => [ 9, \&_action_opcode_1054 ], ":" => [ 9, \&_action_opcode_1054 ], },
	# [2297] opcode : res "[inline_const]" 5 "," h
	{ "\n" => [ 9, \&_action_opcode_1055 ], ":" => [ 9, \&_action_opcode_1055 ], },
	# [2298] opcode : res "[inline_const]" 5 "," l
	{ "\n" => [ 9, \&_action_opcode_1056 ], ":" => [ 9, \&_action_opcode_1056 ], },
	# [2299] opcode : res "[inline_const]" 6
	{ "," => 2300, },
	# [2300] opcode : res "[inline_const]" 6 ","
	{ "(" => 2301, a => 2368, b => 2369, c => 2370, d => 2371, e => 2372, h => 2373, l => 2374, },
	# [2301] opcode : res "[inline_const]" 6 "," "("
	{ hl => 2302, ix => 2304, iy => 2336, },
	# [2302] opcode : res "[inline_const]" 6 "," "(" hl
	{ ")" => 2303, },
	# [2303] opcode : res "[inline_const]" 6 "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_1057 ], ":" => [ 9, \&_action_opcode_1057 ], },
	# [2304] opcode : res "[inline_const]" 6 "," "(" ix
	{ ")" => 2305, "+" => 2314, "-" => 2325, },
	# [2305] opcode : res "[inline_const]" 6 "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_1058 ], "," => 2306, ":" => [ 9, \&_action_opcode_1058 ], },
	# [2306] opcode : res "[inline_const]" 6 "," "(" ix ")" ","
	{ a => 2307, b => 2308, c => 2309, d => 2310, e => 2311, h => 2312, l => 2313, },
	# [2307] opcode : res "[inline_const]" 6 "," "(" ix ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1059 ], ":" => [ 9, \&_action_opcode_1059 ], },
	# [2308] opcode : res "[inline_const]" 6 "," "(" ix ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1060 ], ":" => [ 9, \&_action_opcode_1060 ], },
	# [2309] opcode : res "[inline_const]" 6 "," "(" ix ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1061 ], ":" => [ 9, \&_action_opcode_1061 ], },
	# [2310] opcode : res "[inline_const]" 6 "," "(" ix ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1062 ], ":" => [ 9, \&_action_opcode_1062 ], },
	# [2311] opcode : res "[inline_const]" 6 "," "(" ix ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1063 ], ":" => [ 9, \&_action_opcode_1063 ], },
	# [2312] opcode : res "[inline_const]" 6 "," "(" ix ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1064 ], ":" => [ 9, \&_action_opcode_1064 ], },
	# [2313] opcode : res "[inline_const]" 6 "," "(" ix ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1065 ], ":" => [ 9, \&_action_opcode_1065 ], },
	# [2314] opcode : res "[inline_const]" 6 "," "(" ix "+"
	{ "!" => [ 14, 2315 ], "+" => [ 14, 2315 ], "-" => [ 14, 2315 ], __else__ => [ 14, 2315 ], "~" => [ 14, 2315 ], },
	# [2315] opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 2316, },
	# [2316] opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1066 ], "," => 2317, ":" => [ 9, \&_action_opcode_1066 ], },
	# [2317] opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 2318, b => 2319, c => 2320, d => 2321, e => 2322, h => 2323, l => 2324, },
	# [2318] opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1067 ], ":" => [ 9, \&_action_opcode_1067 ], },
	# [2319] opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1068 ], ":" => [ 9, \&_action_opcode_1068 ], },
	# [2320] opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1069 ], ":" => [ 9, \&_action_opcode_1069 ], },
	# [2321] opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1070 ], ":" => [ 9, \&_action_opcode_1070 ], },
	# [2322] opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1071 ], ":" => [ 9, \&_action_opcode_1071 ], },
	# [2323] opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1072 ], ":" => [ 9, \&_action_opcode_1072 ], },
	# [2324] opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1073 ], ":" => [ 9, \&_action_opcode_1073 ], },
	# [2325] opcode : res "[inline_const]" 6 "," "(" ix "-"
	{ "!" => [ 16, 2326 ], "+" => [ 16, 2326 ], "-" => [ 16, 2326 ], __else__ => [ 16, 2326 ], "~" => [ 16, 2326 ], },
	# [2326] opcode : res "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 2327, },
	# [2327] opcode : res "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1066 ], "," => 2328, ":" => [ 9, \&_action_opcode_1066 ], },
	# [2328] opcode : res "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 2329, b => 2330, c => 2331, d => 2332, e => 2333, h => 2334, l => 2335, },
	# [2329] opcode : res "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1067 ], ":" => [ 9, \&_action_opcode_1067 ], },
	# [2330] opcode : res "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1068 ], ":" => [ 9, \&_action_opcode_1068 ], },
	# [2331] opcode : res "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1069 ], ":" => [ 9, \&_action_opcode_1069 ], },
	# [2332] opcode : res "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1070 ], ":" => [ 9, \&_action_opcode_1070 ], },
	# [2333] opcode : res "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1071 ], ":" => [ 9, \&_action_opcode_1071 ], },
	# [2334] opcode : res "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1072 ], ":" => [ 9, \&_action_opcode_1072 ], },
	# [2335] opcode : res "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1073 ], ":" => [ 9, \&_action_opcode_1073 ], },
	# [2336] opcode : res "[inline_const]" 6 "," "(" iy
	{ ")" => 2337, "+" => 2346, "-" => 2357, },
	# [2337] opcode : res "[inline_const]" 6 "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_1074 ], "," => 2338, ":" => [ 9, \&_action_opcode_1074 ], },
	# [2338] opcode : res "[inline_const]" 6 "," "(" iy ")" ","
	{ a => 2339, b => 2340, c => 2341, d => 2342, e => 2343, h => 2344, l => 2345, },
	# [2339] opcode : res "[inline_const]" 6 "," "(" iy ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1075 ], ":" => [ 9, \&_action_opcode_1075 ], },
	# [2340] opcode : res "[inline_const]" 6 "," "(" iy ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1076 ], ":" => [ 9, \&_action_opcode_1076 ], },
	# [2341] opcode : res "[inline_const]" 6 "," "(" iy ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1077 ], ":" => [ 9, \&_action_opcode_1077 ], },
	# [2342] opcode : res "[inline_const]" 6 "," "(" iy ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1078 ], ":" => [ 9, \&_action_opcode_1078 ], },
	# [2343] opcode : res "[inline_const]" 6 "," "(" iy ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1079 ], ":" => [ 9, \&_action_opcode_1079 ], },
	# [2344] opcode : res "[inline_const]" 6 "," "(" iy ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1080 ], ":" => [ 9, \&_action_opcode_1080 ], },
	# [2345] opcode : res "[inline_const]" 6 "," "(" iy ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1081 ], ":" => [ 9, \&_action_opcode_1081 ], },
	# [2346] opcode : res "[inline_const]" 6 "," "(" iy "+"
	{ "!" => [ 14, 2347 ], "+" => [ 14, 2347 ], "-" => [ 14, 2347 ], __else__ => [ 14, 2347 ], "~" => [ 14, 2347 ], },
	# [2347] opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 2348, },
	# [2348] opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1082 ], "," => 2349, ":" => [ 9, \&_action_opcode_1082 ], },
	# [2349] opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 2350, b => 2351, c => 2352, d => 2353, e => 2354, h => 2355, l => 2356, },
	# [2350] opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1083 ], ":" => [ 9, \&_action_opcode_1083 ], },
	# [2351] opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1084 ], ":" => [ 9, \&_action_opcode_1084 ], },
	# [2352] opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1085 ], ":" => [ 9, \&_action_opcode_1085 ], },
	# [2353] opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1086 ], ":" => [ 9, \&_action_opcode_1086 ], },
	# [2354] opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1087 ], ":" => [ 9, \&_action_opcode_1087 ], },
	# [2355] opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1088 ], ":" => [ 9, \&_action_opcode_1088 ], },
	# [2356] opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1089 ], ":" => [ 9, \&_action_opcode_1089 ], },
	# [2357] opcode : res "[inline_const]" 6 "," "(" iy "-"
	{ "!" => [ 16, 2358 ], "+" => [ 16, 2358 ], "-" => [ 16, 2358 ], __else__ => [ 16, 2358 ], "~" => [ 16, 2358 ], },
	# [2358] opcode : res "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 2359, },
	# [2359] opcode : res "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1082 ], "," => 2360, ":" => [ 9, \&_action_opcode_1082 ], },
	# [2360] opcode : res "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 2361, b => 2362, c => 2363, d => 2364, e => 2365, h => 2366, l => 2367, },
	# [2361] opcode : res "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1083 ], ":" => [ 9, \&_action_opcode_1083 ], },
	# [2362] opcode : res "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1084 ], ":" => [ 9, \&_action_opcode_1084 ], },
	# [2363] opcode : res "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1085 ], ":" => [ 9, \&_action_opcode_1085 ], },
	# [2364] opcode : res "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1086 ], ":" => [ 9, \&_action_opcode_1086 ], },
	# [2365] opcode : res "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1087 ], ":" => [ 9, \&_action_opcode_1087 ], },
	# [2366] opcode : res "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1088 ], ":" => [ 9, \&_action_opcode_1088 ], },
	# [2367] opcode : res "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1089 ], ":" => [ 9, \&_action_opcode_1089 ], },
	# [2368] opcode : res "[inline_const]" 6 "," a
	{ "\n" => [ 9, \&_action_opcode_1090 ], ":" => [ 9, \&_action_opcode_1090 ], },
	# [2369] opcode : res "[inline_const]" 6 "," b
	{ "\n" => [ 9, \&_action_opcode_1091 ], ":" => [ 9, \&_action_opcode_1091 ], },
	# [2370] opcode : res "[inline_const]" 6 "," c
	{ "\n" => [ 9, \&_action_opcode_1092 ], ":" => [ 9, \&_action_opcode_1092 ], },
	# [2371] opcode : res "[inline_const]" 6 "," d
	{ "\n" => [ 9, \&_action_opcode_1093 ], ":" => [ 9, \&_action_opcode_1093 ], },
	# [2372] opcode : res "[inline_const]" 6 "," e
	{ "\n" => [ 9, \&_action_opcode_1094 ], ":" => [ 9, \&_action_opcode_1094 ], },
	# [2373] opcode : res "[inline_const]" 6 "," h
	{ "\n" => [ 9, \&_action_opcode_1095 ], ":" => [ 9, \&_action_opcode_1095 ], },
	# [2374] opcode : res "[inline_const]" 6 "," l
	{ "\n" => [ 9, \&_action_opcode_1096 ], ":" => [ 9, \&_action_opcode_1096 ], },
	# [2375] opcode : res "[inline_const]" 7
	{ "," => 2376, },
	# [2376] opcode : res "[inline_const]" 7 ","
	{ "(" => 2377, a => 2444, b => 2445, c => 2446, d => 2447, e => 2448, h => 2449, l => 2450, },
	# [2377] opcode : res "[inline_const]" 7 "," "("
	{ hl => 2378, ix => 2380, iy => 2412, },
	# [2378] opcode : res "[inline_const]" 7 "," "(" hl
	{ ")" => 2379, },
	# [2379] opcode : res "[inline_const]" 7 "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_1097 ], ":" => [ 9, \&_action_opcode_1097 ], },
	# [2380] opcode : res "[inline_const]" 7 "," "(" ix
	{ ")" => 2381, "+" => 2390, "-" => 2401, },
	# [2381] opcode : res "[inline_const]" 7 "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_1098 ], "," => 2382, ":" => [ 9, \&_action_opcode_1098 ], },
	# [2382] opcode : res "[inline_const]" 7 "," "(" ix ")" ","
	{ a => 2383, b => 2384, c => 2385, d => 2386, e => 2387, h => 2388, l => 2389, },
	# [2383] opcode : res "[inline_const]" 7 "," "(" ix ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1099 ], ":" => [ 9, \&_action_opcode_1099 ], },
	# [2384] opcode : res "[inline_const]" 7 "," "(" ix ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1100 ], ":" => [ 9, \&_action_opcode_1100 ], },
	# [2385] opcode : res "[inline_const]" 7 "," "(" ix ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1101 ], ":" => [ 9, \&_action_opcode_1101 ], },
	# [2386] opcode : res "[inline_const]" 7 "," "(" ix ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1102 ], ":" => [ 9, \&_action_opcode_1102 ], },
	# [2387] opcode : res "[inline_const]" 7 "," "(" ix ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1103 ], ":" => [ 9, \&_action_opcode_1103 ], },
	# [2388] opcode : res "[inline_const]" 7 "," "(" ix ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1104 ], ":" => [ 9, \&_action_opcode_1104 ], },
	# [2389] opcode : res "[inline_const]" 7 "," "(" ix ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1105 ], ":" => [ 9, \&_action_opcode_1105 ], },
	# [2390] opcode : res "[inline_const]" 7 "," "(" ix "+"
	{ "!" => [ 14, 2391 ], "+" => [ 14, 2391 ], "-" => [ 14, 2391 ], __else__ => [ 14, 2391 ], "~" => [ 14, 2391 ], },
	# [2391] opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 2392, },
	# [2392] opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1106 ], "," => 2393, ":" => [ 9, \&_action_opcode_1106 ], },
	# [2393] opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 2394, b => 2395, c => 2396, d => 2397, e => 2398, h => 2399, l => 2400, },
	# [2394] opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1107 ], ":" => [ 9, \&_action_opcode_1107 ], },
	# [2395] opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1108 ], ":" => [ 9, \&_action_opcode_1108 ], },
	# [2396] opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1109 ], ":" => [ 9, \&_action_opcode_1109 ], },
	# [2397] opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1110 ], ":" => [ 9, \&_action_opcode_1110 ], },
	# [2398] opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1111 ], ":" => [ 9, \&_action_opcode_1111 ], },
	# [2399] opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1112 ], ":" => [ 9, \&_action_opcode_1112 ], },
	# [2400] opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1113 ], ":" => [ 9, \&_action_opcode_1113 ], },
	# [2401] opcode : res "[inline_const]" 7 "," "(" ix "-"
	{ "!" => [ 16, 2402 ], "+" => [ 16, 2402 ], "-" => [ 16, 2402 ], __else__ => [ 16, 2402 ], "~" => [ 16, 2402 ], },
	# [2402] opcode : res "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 2403, },
	# [2403] opcode : res "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1106 ], "," => 2404, ":" => [ 9, \&_action_opcode_1106 ], },
	# [2404] opcode : res "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 2405, b => 2406, c => 2407, d => 2408, e => 2409, h => 2410, l => 2411, },
	# [2405] opcode : res "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1107 ], ":" => [ 9, \&_action_opcode_1107 ], },
	# [2406] opcode : res "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1108 ], ":" => [ 9, \&_action_opcode_1108 ], },
	# [2407] opcode : res "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1109 ], ":" => [ 9, \&_action_opcode_1109 ], },
	# [2408] opcode : res "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1110 ], ":" => [ 9, \&_action_opcode_1110 ], },
	# [2409] opcode : res "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1111 ], ":" => [ 9, \&_action_opcode_1111 ], },
	# [2410] opcode : res "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1112 ], ":" => [ 9, \&_action_opcode_1112 ], },
	# [2411] opcode : res "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1113 ], ":" => [ 9, \&_action_opcode_1113 ], },
	# [2412] opcode : res "[inline_const]" 7 "," "(" iy
	{ ")" => 2413, "+" => 2422, "-" => 2433, },
	# [2413] opcode : res "[inline_const]" 7 "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_1114 ], "," => 2414, ":" => [ 9, \&_action_opcode_1114 ], },
	# [2414] opcode : res "[inline_const]" 7 "," "(" iy ")" ","
	{ a => 2415, b => 2416, c => 2417, d => 2418, e => 2419, h => 2420, l => 2421, },
	# [2415] opcode : res "[inline_const]" 7 "," "(" iy ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1115 ], ":" => [ 9, \&_action_opcode_1115 ], },
	# [2416] opcode : res "[inline_const]" 7 "," "(" iy ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1116 ], ":" => [ 9, \&_action_opcode_1116 ], },
	# [2417] opcode : res "[inline_const]" 7 "," "(" iy ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1117 ], ":" => [ 9, \&_action_opcode_1117 ], },
	# [2418] opcode : res "[inline_const]" 7 "," "(" iy ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1118 ], ":" => [ 9, \&_action_opcode_1118 ], },
	# [2419] opcode : res "[inline_const]" 7 "," "(" iy ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1119 ], ":" => [ 9, \&_action_opcode_1119 ], },
	# [2420] opcode : res "[inline_const]" 7 "," "(" iy ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1120 ], ":" => [ 9, \&_action_opcode_1120 ], },
	# [2421] opcode : res "[inline_const]" 7 "," "(" iy ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1121 ], ":" => [ 9, \&_action_opcode_1121 ], },
	# [2422] opcode : res "[inline_const]" 7 "," "(" iy "+"
	{ "!" => [ 14, 2423 ], "+" => [ 14, 2423 ], "-" => [ 14, 2423 ], __else__ => [ 14, 2423 ], "~" => [ 14, 2423 ], },
	# [2423] opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 2424, },
	# [2424] opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1122 ], "," => 2425, ":" => [ 9, \&_action_opcode_1122 ], },
	# [2425] opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 2426, b => 2427, c => 2428, d => 2429, e => 2430, h => 2431, l => 2432, },
	# [2426] opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1123 ], ":" => [ 9, \&_action_opcode_1123 ], },
	# [2427] opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1124 ], ":" => [ 9, \&_action_opcode_1124 ], },
	# [2428] opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1125 ], ":" => [ 9, \&_action_opcode_1125 ], },
	# [2429] opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1126 ], ":" => [ 9, \&_action_opcode_1126 ], },
	# [2430] opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1127 ], ":" => [ 9, \&_action_opcode_1127 ], },
	# [2431] opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1128 ], ":" => [ 9, \&_action_opcode_1128 ], },
	# [2432] opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1129 ], ":" => [ 9, \&_action_opcode_1129 ], },
	# [2433] opcode : res "[inline_const]" 7 "," "(" iy "-"
	{ "!" => [ 16, 2434 ], "+" => [ 16, 2434 ], "-" => [ 16, 2434 ], __else__ => [ 16, 2434 ], "~" => [ 16, 2434 ], },
	# [2434] opcode : res "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 2435, },
	# [2435] opcode : res "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1122 ], "," => 2436, ":" => [ 9, \&_action_opcode_1122 ], },
	# [2436] opcode : res "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 2437, b => 2438, c => 2439, d => 2440, e => 2441, h => 2442, l => 2443, },
	# [2437] opcode : res "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1123 ], ":" => [ 9, \&_action_opcode_1123 ], },
	# [2438] opcode : res "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1124 ], ":" => [ 9, \&_action_opcode_1124 ], },
	# [2439] opcode : res "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1125 ], ":" => [ 9, \&_action_opcode_1125 ], },
	# [2440] opcode : res "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1126 ], ":" => [ 9, \&_action_opcode_1126 ], },
	# [2441] opcode : res "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1127 ], ":" => [ 9, \&_action_opcode_1127 ], },
	# [2442] opcode : res "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1128 ], ":" => [ 9, \&_action_opcode_1128 ], },
	# [2443] opcode : res "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1129 ], ":" => [ 9, \&_action_opcode_1129 ], },
	# [2444] opcode : res "[inline_const]" 7 "," a
	{ "\n" => [ 9, \&_action_opcode_1130 ], ":" => [ 9, \&_action_opcode_1130 ], },
	# [2445] opcode : res "[inline_const]" 7 "," b
	{ "\n" => [ 9, \&_action_opcode_1131 ], ":" => [ 9, \&_action_opcode_1131 ], },
	# [2446] opcode : res "[inline_const]" 7 "," c
	{ "\n" => [ 9, \&_action_opcode_1132 ], ":" => [ 9, \&_action_opcode_1132 ], },
	# [2447] opcode : res "[inline_const]" 7 "," d
	{ "\n" => [ 9, \&_action_opcode_1133 ], ":" => [ 9, \&_action_opcode_1133 ], },
	# [2448] opcode : res "[inline_const]" 7 "," e
	{ "\n" => [ 9, \&_action_opcode_1134 ], ":" => [ 9, \&_action_opcode_1134 ], },
	# [2449] opcode : res "[inline_const]" 7 "," h
	{ "\n" => [ 9, \&_action_opcode_1135 ], ":" => [ 9, \&_action_opcode_1135 ], },
	# [2450] opcode : res "[inline_const]" 7 "," l
	{ "\n" => [ 9, \&_action_opcode_1136 ], ":" => [ 9, \&_action_opcode_1136 ], },
	# [2451] opcode : ret
	{ "\n" => [ 9, \&_action_opcode_1137 ], ":" => [ 9, \&_action_opcode_1137 ], c => 2452, m => 2453, nc => 2454, nz => 2455, p => 2456, pe => 2457, po => 2458, z => 2459, },
	# [2452] opcode : ret c
	{ "\n" => [ 9, \&_action_opcode_1138 ], ":" => [ 9, \&_action_opcode_1138 ], },
	# [2453] opcode : ret m
	{ "\n" => [ 9, \&_action_opcode_1139 ], ":" => [ 9, \&_action_opcode_1139 ], },
	# [2454] opcode : ret nc
	{ "\n" => [ 9, \&_action_opcode_1140 ], ":" => [ 9, \&_action_opcode_1140 ], },
	# [2455] opcode : ret nz
	{ "\n" => [ 9, \&_action_opcode_1141 ], ":" => [ 9, \&_action_opcode_1141 ], },
	# [2456] opcode : ret p
	{ "\n" => [ 9, \&_action_opcode_1142 ], ":" => [ 9, \&_action_opcode_1142 ], },
	# [2457] opcode : ret pe
	{ "\n" => [ 9, \&_action_opcode_1143 ], ":" => [ 9, \&_action_opcode_1143 ], },
	# [2458] opcode : ret po
	{ "\n" => [ 9, \&_action_opcode_1144 ], ":" => [ 9, \&_action_opcode_1144 ], },
	# [2459] opcode : ret z
	{ "\n" => [ 9, \&_action_opcode_1145 ], ":" => [ 9, \&_action_opcode_1145 ], },
	# [2460] opcode : reti
	{ "\n" => [ 9, \&_action_opcode_1146 ], ":" => [ 9, \&_action_opcode_1146 ], },
	# [2461] opcode : retn
	{ "\n" => [ 9, \&_action_opcode_1147 ], ":" => [ 9, \&_action_opcode_1147 ], },
	# [2462] opcode : rl
	{ "(" => 2463, a => 2530, b => 2531, bc => 2532, c => 2533, d => 2534, de => 2535, e => 2536, h => 2537, hl => 2538, l => 2539, },
	# [2463] opcode : rl "("
	{ hl => 2464, ix => 2466, iy => 2498, },
	# [2464] opcode : rl "(" hl
	{ ")" => 2465, },
	# [2465] opcode : rl "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_1148 ], ":" => [ 9, \&_action_opcode_1148 ], },
	# [2466] opcode : rl "(" ix
	{ ")" => 2467, "+" => 2476, "-" => 2487, },
	# [2467] opcode : rl "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_1149 ], "," => 2468, ":" => [ 9, \&_action_opcode_1149 ], },
	# [2468] opcode : rl "(" ix ")" ","
	{ a => 2469, b => 2470, c => 2471, d => 2472, e => 2473, h => 2474, l => 2475, },
	# [2469] opcode : rl "(" ix ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1150 ], ":" => [ 9, \&_action_opcode_1150 ], },
	# [2470] opcode : rl "(" ix ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1151 ], ":" => [ 9, \&_action_opcode_1151 ], },
	# [2471] opcode : rl "(" ix ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1152 ], ":" => [ 9, \&_action_opcode_1152 ], },
	# [2472] opcode : rl "(" ix ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1153 ], ":" => [ 9, \&_action_opcode_1153 ], },
	# [2473] opcode : rl "(" ix ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1154 ], ":" => [ 9, \&_action_opcode_1154 ], },
	# [2474] opcode : rl "(" ix ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1155 ], ":" => [ 9, \&_action_opcode_1155 ], },
	# [2475] opcode : rl "(" ix ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1156 ], ":" => [ 9, \&_action_opcode_1156 ], },
	# [2476] opcode : rl "(" ix "+"
	{ "!" => [ 14, 2477 ], "+" => [ 14, 2477 ], "-" => [ 14, 2477 ], __else__ => [ 14, 2477 ], "~" => [ 14, 2477 ], },
	# [2477] opcode : rl "(" ix "+" "[expr_DIS]"
	{ ")" => 2478, },
	# [2478] opcode : rl "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1157 ], "," => 2479, ":" => [ 9, \&_action_opcode_1157 ], },
	# [2479] opcode : rl "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 2480, b => 2481, c => 2482, d => 2483, e => 2484, h => 2485, l => 2486, },
	# [2480] opcode : rl "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1158 ], ":" => [ 9, \&_action_opcode_1158 ], },
	# [2481] opcode : rl "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1159 ], ":" => [ 9, \&_action_opcode_1159 ], },
	# [2482] opcode : rl "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1160 ], ":" => [ 9, \&_action_opcode_1160 ], },
	# [2483] opcode : rl "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1161 ], ":" => [ 9, \&_action_opcode_1161 ], },
	# [2484] opcode : rl "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1162 ], ":" => [ 9, \&_action_opcode_1162 ], },
	# [2485] opcode : rl "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1163 ], ":" => [ 9, \&_action_opcode_1163 ], },
	# [2486] opcode : rl "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1164 ], ":" => [ 9, \&_action_opcode_1164 ], },
	# [2487] opcode : rl "(" ix "-"
	{ "!" => [ 16, 2488 ], "+" => [ 16, 2488 ], "-" => [ 16, 2488 ], __else__ => [ 16, 2488 ], "~" => [ 16, 2488 ], },
	# [2488] opcode : rl "(" ix "-" "[expr_NDIS]"
	{ ")" => 2489, },
	# [2489] opcode : rl "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1157 ], "," => 2490, ":" => [ 9, \&_action_opcode_1157 ], },
	# [2490] opcode : rl "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 2491, b => 2492, c => 2493, d => 2494, e => 2495, h => 2496, l => 2497, },
	# [2491] opcode : rl "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1158 ], ":" => [ 9, \&_action_opcode_1158 ], },
	# [2492] opcode : rl "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1159 ], ":" => [ 9, \&_action_opcode_1159 ], },
	# [2493] opcode : rl "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1160 ], ":" => [ 9, \&_action_opcode_1160 ], },
	# [2494] opcode : rl "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1161 ], ":" => [ 9, \&_action_opcode_1161 ], },
	# [2495] opcode : rl "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1162 ], ":" => [ 9, \&_action_opcode_1162 ], },
	# [2496] opcode : rl "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1163 ], ":" => [ 9, \&_action_opcode_1163 ], },
	# [2497] opcode : rl "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1164 ], ":" => [ 9, \&_action_opcode_1164 ], },
	# [2498] opcode : rl "(" iy
	{ ")" => 2499, "+" => 2508, "-" => 2519, },
	# [2499] opcode : rl "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_1165 ], "," => 2500, ":" => [ 9, \&_action_opcode_1165 ], },
	# [2500] opcode : rl "(" iy ")" ","
	{ a => 2501, b => 2502, c => 2503, d => 2504, e => 2505, h => 2506, l => 2507, },
	# [2501] opcode : rl "(" iy ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1166 ], ":" => [ 9, \&_action_opcode_1166 ], },
	# [2502] opcode : rl "(" iy ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1167 ], ":" => [ 9, \&_action_opcode_1167 ], },
	# [2503] opcode : rl "(" iy ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1168 ], ":" => [ 9, \&_action_opcode_1168 ], },
	# [2504] opcode : rl "(" iy ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1169 ], ":" => [ 9, \&_action_opcode_1169 ], },
	# [2505] opcode : rl "(" iy ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1170 ], ":" => [ 9, \&_action_opcode_1170 ], },
	# [2506] opcode : rl "(" iy ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1171 ], ":" => [ 9, \&_action_opcode_1171 ], },
	# [2507] opcode : rl "(" iy ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1172 ], ":" => [ 9, \&_action_opcode_1172 ], },
	# [2508] opcode : rl "(" iy "+"
	{ "!" => [ 14, 2509 ], "+" => [ 14, 2509 ], "-" => [ 14, 2509 ], __else__ => [ 14, 2509 ], "~" => [ 14, 2509 ], },
	# [2509] opcode : rl "(" iy "+" "[expr_DIS]"
	{ ")" => 2510, },
	# [2510] opcode : rl "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1173 ], "," => 2511, ":" => [ 9, \&_action_opcode_1173 ], },
	# [2511] opcode : rl "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 2512, b => 2513, c => 2514, d => 2515, e => 2516, h => 2517, l => 2518, },
	# [2512] opcode : rl "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1174 ], ":" => [ 9, \&_action_opcode_1174 ], },
	# [2513] opcode : rl "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1175 ], ":" => [ 9, \&_action_opcode_1175 ], },
	# [2514] opcode : rl "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1176 ], ":" => [ 9, \&_action_opcode_1176 ], },
	# [2515] opcode : rl "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1177 ], ":" => [ 9, \&_action_opcode_1177 ], },
	# [2516] opcode : rl "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1178 ], ":" => [ 9, \&_action_opcode_1178 ], },
	# [2517] opcode : rl "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1179 ], ":" => [ 9, \&_action_opcode_1179 ], },
	# [2518] opcode : rl "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1180 ], ":" => [ 9, \&_action_opcode_1180 ], },
	# [2519] opcode : rl "(" iy "-"
	{ "!" => [ 16, 2520 ], "+" => [ 16, 2520 ], "-" => [ 16, 2520 ], __else__ => [ 16, 2520 ], "~" => [ 16, 2520 ], },
	# [2520] opcode : rl "(" iy "-" "[expr_NDIS]"
	{ ")" => 2521, },
	# [2521] opcode : rl "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1173 ], "," => 2522, ":" => [ 9, \&_action_opcode_1173 ], },
	# [2522] opcode : rl "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 2523, b => 2524, c => 2525, d => 2526, e => 2527, h => 2528, l => 2529, },
	# [2523] opcode : rl "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1174 ], ":" => [ 9, \&_action_opcode_1174 ], },
	# [2524] opcode : rl "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1175 ], ":" => [ 9, \&_action_opcode_1175 ], },
	# [2525] opcode : rl "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1176 ], ":" => [ 9, \&_action_opcode_1176 ], },
	# [2526] opcode : rl "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1177 ], ":" => [ 9, \&_action_opcode_1177 ], },
	# [2527] opcode : rl "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1178 ], ":" => [ 9, \&_action_opcode_1178 ], },
	# [2528] opcode : rl "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1179 ], ":" => [ 9, \&_action_opcode_1179 ], },
	# [2529] opcode : rl "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1180 ], ":" => [ 9, \&_action_opcode_1180 ], },
	# [2530] opcode : rl a
	{ "\n" => [ 9, \&_action_opcode_1181 ], ":" => [ 9, \&_action_opcode_1181 ], },
	# [2531] opcode : rl b
	{ "\n" => [ 9, \&_action_opcode_1182 ], ":" => [ 9, \&_action_opcode_1182 ], },
	# [2532] opcode : rl bc
	{ "\n" => [ 9, \&_action_opcode_1183 ], ":" => [ 9, \&_action_opcode_1183 ], },
	# [2533] opcode : rl c
	{ "\n" => [ 9, \&_action_opcode_1184 ], ":" => [ 9, \&_action_opcode_1184 ], },
	# [2534] opcode : rl d
	{ "\n" => [ 9, \&_action_opcode_1185 ], ":" => [ 9, \&_action_opcode_1185 ], },
	# [2535] opcode : rl de
	{ "\n" => [ 9, \&_action_opcode_1186 ], ":" => [ 9, \&_action_opcode_1186 ], },
	# [2536] opcode : rl e
	{ "\n" => [ 9, \&_action_opcode_1187 ], ":" => [ 9, \&_action_opcode_1187 ], },
	# [2537] opcode : rl h
	{ "\n" => [ 9, \&_action_opcode_1188 ], ":" => [ 9, \&_action_opcode_1188 ], },
	# [2538] opcode : rl hl
	{ "\n" => [ 9, \&_action_opcode_1189 ], ":" => [ 9, \&_action_opcode_1189 ], },
	# [2539] opcode : rl l
	{ "\n" => [ 9, \&_action_opcode_1190 ], ":" => [ 9, \&_action_opcode_1190 ], },
	# [2540] opcode : rla
	{ "\n" => [ 9, \&_action_opcode_1191 ], ":" => [ 9, \&_action_opcode_1191 ], },
	# [2541] opcode : rlc
	{ "(" => 2542, a => 2609, b => 2610, c => 2611, d => 2612, e => 2613, h => 2614, l => 2615, },
	# [2542] opcode : rlc "("
	{ hl => 2543, ix => 2545, iy => 2577, },
	# [2543] opcode : rlc "(" hl
	{ ")" => 2544, },
	# [2544] opcode : rlc "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_1192 ], ":" => [ 9, \&_action_opcode_1192 ], },
	# [2545] opcode : rlc "(" ix
	{ ")" => 2546, "+" => 2555, "-" => 2566, },
	# [2546] opcode : rlc "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_1193 ], "," => 2547, ":" => [ 9, \&_action_opcode_1193 ], },
	# [2547] opcode : rlc "(" ix ")" ","
	{ a => 2548, b => 2549, c => 2550, d => 2551, e => 2552, h => 2553, l => 2554, },
	# [2548] opcode : rlc "(" ix ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1194 ], ":" => [ 9, \&_action_opcode_1194 ], },
	# [2549] opcode : rlc "(" ix ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1195 ], ":" => [ 9, \&_action_opcode_1195 ], },
	# [2550] opcode : rlc "(" ix ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1196 ], ":" => [ 9, \&_action_opcode_1196 ], },
	# [2551] opcode : rlc "(" ix ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1197 ], ":" => [ 9, \&_action_opcode_1197 ], },
	# [2552] opcode : rlc "(" ix ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1198 ], ":" => [ 9, \&_action_opcode_1198 ], },
	# [2553] opcode : rlc "(" ix ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1199 ], ":" => [ 9, \&_action_opcode_1199 ], },
	# [2554] opcode : rlc "(" ix ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1200 ], ":" => [ 9, \&_action_opcode_1200 ], },
	# [2555] opcode : rlc "(" ix "+"
	{ "!" => [ 14, 2556 ], "+" => [ 14, 2556 ], "-" => [ 14, 2556 ], __else__ => [ 14, 2556 ], "~" => [ 14, 2556 ], },
	# [2556] opcode : rlc "(" ix "+" "[expr_DIS]"
	{ ")" => 2557, },
	# [2557] opcode : rlc "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1201 ], "," => 2558, ":" => [ 9, \&_action_opcode_1201 ], },
	# [2558] opcode : rlc "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 2559, b => 2560, c => 2561, d => 2562, e => 2563, h => 2564, l => 2565, },
	# [2559] opcode : rlc "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1202 ], ":" => [ 9, \&_action_opcode_1202 ], },
	# [2560] opcode : rlc "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1203 ], ":" => [ 9, \&_action_opcode_1203 ], },
	# [2561] opcode : rlc "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1204 ], ":" => [ 9, \&_action_opcode_1204 ], },
	# [2562] opcode : rlc "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1205 ], ":" => [ 9, \&_action_opcode_1205 ], },
	# [2563] opcode : rlc "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1206 ], ":" => [ 9, \&_action_opcode_1206 ], },
	# [2564] opcode : rlc "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1207 ], ":" => [ 9, \&_action_opcode_1207 ], },
	# [2565] opcode : rlc "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1208 ], ":" => [ 9, \&_action_opcode_1208 ], },
	# [2566] opcode : rlc "(" ix "-"
	{ "!" => [ 16, 2567 ], "+" => [ 16, 2567 ], "-" => [ 16, 2567 ], __else__ => [ 16, 2567 ], "~" => [ 16, 2567 ], },
	# [2567] opcode : rlc "(" ix "-" "[expr_NDIS]"
	{ ")" => 2568, },
	# [2568] opcode : rlc "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1201 ], "," => 2569, ":" => [ 9, \&_action_opcode_1201 ], },
	# [2569] opcode : rlc "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 2570, b => 2571, c => 2572, d => 2573, e => 2574, h => 2575, l => 2576, },
	# [2570] opcode : rlc "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1202 ], ":" => [ 9, \&_action_opcode_1202 ], },
	# [2571] opcode : rlc "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1203 ], ":" => [ 9, \&_action_opcode_1203 ], },
	# [2572] opcode : rlc "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1204 ], ":" => [ 9, \&_action_opcode_1204 ], },
	# [2573] opcode : rlc "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1205 ], ":" => [ 9, \&_action_opcode_1205 ], },
	# [2574] opcode : rlc "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1206 ], ":" => [ 9, \&_action_opcode_1206 ], },
	# [2575] opcode : rlc "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1207 ], ":" => [ 9, \&_action_opcode_1207 ], },
	# [2576] opcode : rlc "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1208 ], ":" => [ 9, \&_action_opcode_1208 ], },
	# [2577] opcode : rlc "(" iy
	{ ")" => 2578, "+" => 2587, "-" => 2598, },
	# [2578] opcode : rlc "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_1209 ], "," => 2579, ":" => [ 9, \&_action_opcode_1209 ], },
	# [2579] opcode : rlc "(" iy ")" ","
	{ a => 2580, b => 2581, c => 2582, d => 2583, e => 2584, h => 2585, l => 2586, },
	# [2580] opcode : rlc "(" iy ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1210 ], ":" => [ 9, \&_action_opcode_1210 ], },
	# [2581] opcode : rlc "(" iy ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1211 ], ":" => [ 9, \&_action_opcode_1211 ], },
	# [2582] opcode : rlc "(" iy ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1212 ], ":" => [ 9, \&_action_opcode_1212 ], },
	# [2583] opcode : rlc "(" iy ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1213 ], ":" => [ 9, \&_action_opcode_1213 ], },
	# [2584] opcode : rlc "(" iy ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1214 ], ":" => [ 9, \&_action_opcode_1214 ], },
	# [2585] opcode : rlc "(" iy ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1215 ], ":" => [ 9, \&_action_opcode_1215 ], },
	# [2586] opcode : rlc "(" iy ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1216 ], ":" => [ 9, \&_action_opcode_1216 ], },
	# [2587] opcode : rlc "(" iy "+"
	{ "!" => [ 14, 2588 ], "+" => [ 14, 2588 ], "-" => [ 14, 2588 ], __else__ => [ 14, 2588 ], "~" => [ 14, 2588 ], },
	# [2588] opcode : rlc "(" iy "+" "[expr_DIS]"
	{ ")" => 2589, },
	# [2589] opcode : rlc "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1217 ], "," => 2590, ":" => [ 9, \&_action_opcode_1217 ], },
	# [2590] opcode : rlc "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 2591, b => 2592, c => 2593, d => 2594, e => 2595, h => 2596, l => 2597, },
	# [2591] opcode : rlc "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1218 ], ":" => [ 9, \&_action_opcode_1218 ], },
	# [2592] opcode : rlc "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1219 ], ":" => [ 9, \&_action_opcode_1219 ], },
	# [2593] opcode : rlc "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1220 ], ":" => [ 9, \&_action_opcode_1220 ], },
	# [2594] opcode : rlc "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1221 ], ":" => [ 9, \&_action_opcode_1221 ], },
	# [2595] opcode : rlc "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1222 ], ":" => [ 9, \&_action_opcode_1222 ], },
	# [2596] opcode : rlc "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1223 ], ":" => [ 9, \&_action_opcode_1223 ], },
	# [2597] opcode : rlc "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1224 ], ":" => [ 9, \&_action_opcode_1224 ], },
	# [2598] opcode : rlc "(" iy "-"
	{ "!" => [ 16, 2599 ], "+" => [ 16, 2599 ], "-" => [ 16, 2599 ], __else__ => [ 16, 2599 ], "~" => [ 16, 2599 ], },
	# [2599] opcode : rlc "(" iy "-" "[expr_NDIS]"
	{ ")" => 2600, },
	# [2600] opcode : rlc "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1217 ], "," => 2601, ":" => [ 9, \&_action_opcode_1217 ], },
	# [2601] opcode : rlc "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 2602, b => 2603, c => 2604, d => 2605, e => 2606, h => 2607, l => 2608, },
	# [2602] opcode : rlc "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1218 ], ":" => [ 9, \&_action_opcode_1218 ], },
	# [2603] opcode : rlc "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1219 ], ":" => [ 9, \&_action_opcode_1219 ], },
	# [2604] opcode : rlc "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1220 ], ":" => [ 9, \&_action_opcode_1220 ], },
	# [2605] opcode : rlc "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1221 ], ":" => [ 9, \&_action_opcode_1221 ], },
	# [2606] opcode : rlc "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1222 ], ":" => [ 9, \&_action_opcode_1222 ], },
	# [2607] opcode : rlc "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1223 ], ":" => [ 9, \&_action_opcode_1223 ], },
	# [2608] opcode : rlc "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1224 ], ":" => [ 9, \&_action_opcode_1224 ], },
	# [2609] opcode : rlc a
	{ "\n" => [ 9, \&_action_opcode_1225 ], ":" => [ 9, \&_action_opcode_1225 ], },
	# [2610] opcode : rlc b
	{ "\n" => [ 9, \&_action_opcode_1226 ], ":" => [ 9, \&_action_opcode_1226 ], },
	# [2611] opcode : rlc c
	{ "\n" => [ 9, \&_action_opcode_1227 ], ":" => [ 9, \&_action_opcode_1227 ], },
	# [2612] opcode : rlc d
	{ "\n" => [ 9, \&_action_opcode_1228 ], ":" => [ 9, \&_action_opcode_1228 ], },
	# [2613] opcode : rlc e
	{ "\n" => [ 9, \&_action_opcode_1229 ], ":" => [ 9, \&_action_opcode_1229 ], },
	# [2614] opcode : rlc h
	{ "\n" => [ 9, \&_action_opcode_1230 ], ":" => [ 9, \&_action_opcode_1230 ], },
	# [2615] opcode : rlc l
	{ "\n" => [ 9, \&_action_opcode_1231 ], ":" => [ 9, \&_action_opcode_1231 ], },
	# [2616] opcode : rlca
	{ "\n" => [ 9, \&_action_opcode_1232 ], ":" => [ 9, \&_action_opcode_1232 ], },
	# [2617] opcode : rld
	{ "\n" => [ 9, \&_action_opcode_1233 ], ":" => [ 9, \&_action_opcode_1233 ], },
	# [2618] opcode : rr
	{ "(" => 2619, a => 2686, b => 2687, bc => 2688, c => 2689, d => 2690, de => 2691, e => 2692, h => 2693, hl => 2694, l => 2695, },
	# [2619] opcode : rr "("
	{ hl => 2620, ix => 2622, iy => 2654, },
	# [2620] opcode : rr "(" hl
	{ ")" => 2621, },
	# [2621] opcode : rr "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_1234 ], ":" => [ 9, \&_action_opcode_1234 ], },
	# [2622] opcode : rr "(" ix
	{ ")" => 2623, "+" => 2632, "-" => 2643, },
	# [2623] opcode : rr "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_1235 ], "," => 2624, ":" => [ 9, \&_action_opcode_1235 ], },
	# [2624] opcode : rr "(" ix ")" ","
	{ a => 2625, b => 2626, c => 2627, d => 2628, e => 2629, h => 2630, l => 2631, },
	# [2625] opcode : rr "(" ix ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1236 ], ":" => [ 9, \&_action_opcode_1236 ], },
	# [2626] opcode : rr "(" ix ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1237 ], ":" => [ 9, \&_action_opcode_1237 ], },
	# [2627] opcode : rr "(" ix ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1238 ], ":" => [ 9, \&_action_opcode_1238 ], },
	# [2628] opcode : rr "(" ix ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1239 ], ":" => [ 9, \&_action_opcode_1239 ], },
	# [2629] opcode : rr "(" ix ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1240 ], ":" => [ 9, \&_action_opcode_1240 ], },
	# [2630] opcode : rr "(" ix ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1241 ], ":" => [ 9, \&_action_opcode_1241 ], },
	# [2631] opcode : rr "(" ix ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1242 ], ":" => [ 9, \&_action_opcode_1242 ], },
	# [2632] opcode : rr "(" ix "+"
	{ "!" => [ 14, 2633 ], "+" => [ 14, 2633 ], "-" => [ 14, 2633 ], __else__ => [ 14, 2633 ], "~" => [ 14, 2633 ], },
	# [2633] opcode : rr "(" ix "+" "[expr_DIS]"
	{ ")" => 2634, },
	# [2634] opcode : rr "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1243 ], "," => 2635, ":" => [ 9, \&_action_opcode_1243 ], },
	# [2635] opcode : rr "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 2636, b => 2637, c => 2638, d => 2639, e => 2640, h => 2641, l => 2642, },
	# [2636] opcode : rr "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1244 ], ":" => [ 9, \&_action_opcode_1244 ], },
	# [2637] opcode : rr "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1245 ], ":" => [ 9, \&_action_opcode_1245 ], },
	# [2638] opcode : rr "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1246 ], ":" => [ 9, \&_action_opcode_1246 ], },
	# [2639] opcode : rr "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1247 ], ":" => [ 9, \&_action_opcode_1247 ], },
	# [2640] opcode : rr "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1248 ], ":" => [ 9, \&_action_opcode_1248 ], },
	# [2641] opcode : rr "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1249 ], ":" => [ 9, \&_action_opcode_1249 ], },
	# [2642] opcode : rr "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1250 ], ":" => [ 9, \&_action_opcode_1250 ], },
	# [2643] opcode : rr "(" ix "-"
	{ "!" => [ 16, 2644 ], "+" => [ 16, 2644 ], "-" => [ 16, 2644 ], __else__ => [ 16, 2644 ], "~" => [ 16, 2644 ], },
	# [2644] opcode : rr "(" ix "-" "[expr_NDIS]"
	{ ")" => 2645, },
	# [2645] opcode : rr "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1243 ], "," => 2646, ":" => [ 9, \&_action_opcode_1243 ], },
	# [2646] opcode : rr "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 2647, b => 2648, c => 2649, d => 2650, e => 2651, h => 2652, l => 2653, },
	# [2647] opcode : rr "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1244 ], ":" => [ 9, \&_action_opcode_1244 ], },
	# [2648] opcode : rr "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1245 ], ":" => [ 9, \&_action_opcode_1245 ], },
	# [2649] opcode : rr "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1246 ], ":" => [ 9, \&_action_opcode_1246 ], },
	# [2650] opcode : rr "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1247 ], ":" => [ 9, \&_action_opcode_1247 ], },
	# [2651] opcode : rr "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1248 ], ":" => [ 9, \&_action_opcode_1248 ], },
	# [2652] opcode : rr "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1249 ], ":" => [ 9, \&_action_opcode_1249 ], },
	# [2653] opcode : rr "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1250 ], ":" => [ 9, \&_action_opcode_1250 ], },
	# [2654] opcode : rr "(" iy
	{ ")" => 2655, "+" => 2664, "-" => 2675, },
	# [2655] opcode : rr "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_1251 ], "," => 2656, ":" => [ 9, \&_action_opcode_1251 ], },
	# [2656] opcode : rr "(" iy ")" ","
	{ a => 2657, b => 2658, c => 2659, d => 2660, e => 2661, h => 2662, l => 2663, },
	# [2657] opcode : rr "(" iy ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1252 ], ":" => [ 9, \&_action_opcode_1252 ], },
	# [2658] opcode : rr "(" iy ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1253 ], ":" => [ 9, \&_action_opcode_1253 ], },
	# [2659] opcode : rr "(" iy ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1254 ], ":" => [ 9, \&_action_opcode_1254 ], },
	# [2660] opcode : rr "(" iy ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1255 ], ":" => [ 9, \&_action_opcode_1255 ], },
	# [2661] opcode : rr "(" iy ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1256 ], ":" => [ 9, \&_action_opcode_1256 ], },
	# [2662] opcode : rr "(" iy ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1257 ], ":" => [ 9, \&_action_opcode_1257 ], },
	# [2663] opcode : rr "(" iy ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1258 ], ":" => [ 9, \&_action_opcode_1258 ], },
	# [2664] opcode : rr "(" iy "+"
	{ "!" => [ 14, 2665 ], "+" => [ 14, 2665 ], "-" => [ 14, 2665 ], __else__ => [ 14, 2665 ], "~" => [ 14, 2665 ], },
	# [2665] opcode : rr "(" iy "+" "[expr_DIS]"
	{ ")" => 2666, },
	# [2666] opcode : rr "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1259 ], "," => 2667, ":" => [ 9, \&_action_opcode_1259 ], },
	# [2667] opcode : rr "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 2668, b => 2669, c => 2670, d => 2671, e => 2672, h => 2673, l => 2674, },
	# [2668] opcode : rr "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1260 ], ":" => [ 9, \&_action_opcode_1260 ], },
	# [2669] opcode : rr "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1261 ], ":" => [ 9, \&_action_opcode_1261 ], },
	# [2670] opcode : rr "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1262 ], ":" => [ 9, \&_action_opcode_1262 ], },
	# [2671] opcode : rr "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1263 ], ":" => [ 9, \&_action_opcode_1263 ], },
	# [2672] opcode : rr "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1264 ], ":" => [ 9, \&_action_opcode_1264 ], },
	# [2673] opcode : rr "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1265 ], ":" => [ 9, \&_action_opcode_1265 ], },
	# [2674] opcode : rr "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1266 ], ":" => [ 9, \&_action_opcode_1266 ], },
	# [2675] opcode : rr "(" iy "-"
	{ "!" => [ 16, 2676 ], "+" => [ 16, 2676 ], "-" => [ 16, 2676 ], __else__ => [ 16, 2676 ], "~" => [ 16, 2676 ], },
	# [2676] opcode : rr "(" iy "-" "[expr_NDIS]"
	{ ")" => 2677, },
	# [2677] opcode : rr "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1259 ], "," => 2678, ":" => [ 9, \&_action_opcode_1259 ], },
	# [2678] opcode : rr "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 2679, b => 2680, c => 2681, d => 2682, e => 2683, h => 2684, l => 2685, },
	# [2679] opcode : rr "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1260 ], ":" => [ 9, \&_action_opcode_1260 ], },
	# [2680] opcode : rr "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1261 ], ":" => [ 9, \&_action_opcode_1261 ], },
	# [2681] opcode : rr "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1262 ], ":" => [ 9, \&_action_opcode_1262 ], },
	# [2682] opcode : rr "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1263 ], ":" => [ 9, \&_action_opcode_1263 ], },
	# [2683] opcode : rr "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1264 ], ":" => [ 9, \&_action_opcode_1264 ], },
	# [2684] opcode : rr "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1265 ], ":" => [ 9, \&_action_opcode_1265 ], },
	# [2685] opcode : rr "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1266 ], ":" => [ 9, \&_action_opcode_1266 ], },
	# [2686] opcode : rr a
	{ "\n" => [ 9, \&_action_opcode_1267 ], ":" => [ 9, \&_action_opcode_1267 ], },
	# [2687] opcode : rr b
	{ "\n" => [ 9, \&_action_opcode_1268 ], ":" => [ 9, \&_action_opcode_1268 ], },
	# [2688] opcode : rr bc
	{ "\n" => [ 9, \&_action_opcode_1269 ], ":" => [ 9, \&_action_opcode_1269 ], },
	# [2689] opcode : rr c
	{ "\n" => [ 9, \&_action_opcode_1270 ], ":" => [ 9, \&_action_opcode_1270 ], },
	# [2690] opcode : rr d
	{ "\n" => [ 9, \&_action_opcode_1271 ], ":" => [ 9, \&_action_opcode_1271 ], },
	# [2691] opcode : rr de
	{ "\n" => [ 9, \&_action_opcode_1272 ], ":" => [ 9, \&_action_opcode_1272 ], },
	# [2692] opcode : rr e
	{ "\n" => [ 9, \&_action_opcode_1273 ], ":" => [ 9, \&_action_opcode_1273 ], },
	# [2693] opcode : rr h
	{ "\n" => [ 9, \&_action_opcode_1274 ], ":" => [ 9, \&_action_opcode_1274 ], },
	# [2694] opcode : rr hl
	{ "\n" => [ 9, \&_action_opcode_1275 ], ":" => [ 9, \&_action_opcode_1275 ], },
	# [2695] opcode : rr l
	{ "\n" => [ 9, \&_action_opcode_1276 ], ":" => [ 9, \&_action_opcode_1276 ], },
	# [2696] opcode : rra
	{ "\n" => [ 9, \&_action_opcode_1277 ], ":" => [ 9, \&_action_opcode_1277 ], },
	# [2697] opcode : rrc
	{ "(" => 2698, a => 2765, b => 2766, c => 2767, d => 2768, e => 2769, h => 2770, l => 2771, },
	# [2698] opcode : rrc "("
	{ hl => 2699, ix => 2701, iy => 2733, },
	# [2699] opcode : rrc "(" hl
	{ ")" => 2700, },
	# [2700] opcode : rrc "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_1278 ], ":" => [ 9, \&_action_opcode_1278 ], },
	# [2701] opcode : rrc "(" ix
	{ ")" => 2702, "+" => 2711, "-" => 2722, },
	# [2702] opcode : rrc "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_1279 ], "," => 2703, ":" => [ 9, \&_action_opcode_1279 ], },
	# [2703] opcode : rrc "(" ix ")" ","
	{ a => 2704, b => 2705, c => 2706, d => 2707, e => 2708, h => 2709, l => 2710, },
	# [2704] opcode : rrc "(" ix ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1280 ], ":" => [ 9, \&_action_opcode_1280 ], },
	# [2705] opcode : rrc "(" ix ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1281 ], ":" => [ 9, \&_action_opcode_1281 ], },
	# [2706] opcode : rrc "(" ix ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1282 ], ":" => [ 9, \&_action_opcode_1282 ], },
	# [2707] opcode : rrc "(" ix ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1283 ], ":" => [ 9, \&_action_opcode_1283 ], },
	# [2708] opcode : rrc "(" ix ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1284 ], ":" => [ 9, \&_action_opcode_1284 ], },
	# [2709] opcode : rrc "(" ix ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1285 ], ":" => [ 9, \&_action_opcode_1285 ], },
	# [2710] opcode : rrc "(" ix ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1286 ], ":" => [ 9, \&_action_opcode_1286 ], },
	# [2711] opcode : rrc "(" ix "+"
	{ "!" => [ 14, 2712 ], "+" => [ 14, 2712 ], "-" => [ 14, 2712 ], __else__ => [ 14, 2712 ], "~" => [ 14, 2712 ], },
	# [2712] opcode : rrc "(" ix "+" "[expr_DIS]"
	{ ")" => 2713, },
	# [2713] opcode : rrc "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1287 ], "," => 2714, ":" => [ 9, \&_action_opcode_1287 ], },
	# [2714] opcode : rrc "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 2715, b => 2716, c => 2717, d => 2718, e => 2719, h => 2720, l => 2721, },
	# [2715] opcode : rrc "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1288 ], ":" => [ 9, \&_action_opcode_1288 ], },
	# [2716] opcode : rrc "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1289 ], ":" => [ 9, \&_action_opcode_1289 ], },
	# [2717] opcode : rrc "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1290 ], ":" => [ 9, \&_action_opcode_1290 ], },
	# [2718] opcode : rrc "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1291 ], ":" => [ 9, \&_action_opcode_1291 ], },
	# [2719] opcode : rrc "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1292 ], ":" => [ 9, \&_action_opcode_1292 ], },
	# [2720] opcode : rrc "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1293 ], ":" => [ 9, \&_action_opcode_1293 ], },
	# [2721] opcode : rrc "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1294 ], ":" => [ 9, \&_action_opcode_1294 ], },
	# [2722] opcode : rrc "(" ix "-"
	{ "!" => [ 16, 2723 ], "+" => [ 16, 2723 ], "-" => [ 16, 2723 ], __else__ => [ 16, 2723 ], "~" => [ 16, 2723 ], },
	# [2723] opcode : rrc "(" ix "-" "[expr_NDIS]"
	{ ")" => 2724, },
	# [2724] opcode : rrc "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1287 ], "," => 2725, ":" => [ 9, \&_action_opcode_1287 ], },
	# [2725] opcode : rrc "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 2726, b => 2727, c => 2728, d => 2729, e => 2730, h => 2731, l => 2732, },
	# [2726] opcode : rrc "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1288 ], ":" => [ 9, \&_action_opcode_1288 ], },
	# [2727] opcode : rrc "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1289 ], ":" => [ 9, \&_action_opcode_1289 ], },
	# [2728] opcode : rrc "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1290 ], ":" => [ 9, \&_action_opcode_1290 ], },
	# [2729] opcode : rrc "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1291 ], ":" => [ 9, \&_action_opcode_1291 ], },
	# [2730] opcode : rrc "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1292 ], ":" => [ 9, \&_action_opcode_1292 ], },
	# [2731] opcode : rrc "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1293 ], ":" => [ 9, \&_action_opcode_1293 ], },
	# [2732] opcode : rrc "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1294 ], ":" => [ 9, \&_action_opcode_1294 ], },
	# [2733] opcode : rrc "(" iy
	{ ")" => 2734, "+" => 2743, "-" => 2754, },
	# [2734] opcode : rrc "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_1295 ], "," => 2735, ":" => [ 9, \&_action_opcode_1295 ], },
	# [2735] opcode : rrc "(" iy ")" ","
	{ a => 2736, b => 2737, c => 2738, d => 2739, e => 2740, h => 2741, l => 2742, },
	# [2736] opcode : rrc "(" iy ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1296 ], ":" => [ 9, \&_action_opcode_1296 ], },
	# [2737] opcode : rrc "(" iy ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1297 ], ":" => [ 9, \&_action_opcode_1297 ], },
	# [2738] opcode : rrc "(" iy ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1298 ], ":" => [ 9, \&_action_opcode_1298 ], },
	# [2739] opcode : rrc "(" iy ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1299 ], ":" => [ 9, \&_action_opcode_1299 ], },
	# [2740] opcode : rrc "(" iy ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1300 ], ":" => [ 9, \&_action_opcode_1300 ], },
	# [2741] opcode : rrc "(" iy ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1301 ], ":" => [ 9, \&_action_opcode_1301 ], },
	# [2742] opcode : rrc "(" iy ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1302 ], ":" => [ 9, \&_action_opcode_1302 ], },
	# [2743] opcode : rrc "(" iy "+"
	{ "!" => [ 14, 2744 ], "+" => [ 14, 2744 ], "-" => [ 14, 2744 ], __else__ => [ 14, 2744 ], "~" => [ 14, 2744 ], },
	# [2744] opcode : rrc "(" iy "+" "[expr_DIS]"
	{ ")" => 2745, },
	# [2745] opcode : rrc "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1303 ], "," => 2746, ":" => [ 9, \&_action_opcode_1303 ], },
	# [2746] opcode : rrc "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 2747, b => 2748, c => 2749, d => 2750, e => 2751, h => 2752, l => 2753, },
	# [2747] opcode : rrc "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1304 ], ":" => [ 9, \&_action_opcode_1304 ], },
	# [2748] opcode : rrc "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1305 ], ":" => [ 9, \&_action_opcode_1305 ], },
	# [2749] opcode : rrc "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1306 ], ":" => [ 9, \&_action_opcode_1306 ], },
	# [2750] opcode : rrc "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1307 ], ":" => [ 9, \&_action_opcode_1307 ], },
	# [2751] opcode : rrc "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1308 ], ":" => [ 9, \&_action_opcode_1308 ], },
	# [2752] opcode : rrc "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1309 ], ":" => [ 9, \&_action_opcode_1309 ], },
	# [2753] opcode : rrc "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1310 ], ":" => [ 9, \&_action_opcode_1310 ], },
	# [2754] opcode : rrc "(" iy "-"
	{ "!" => [ 16, 2755 ], "+" => [ 16, 2755 ], "-" => [ 16, 2755 ], __else__ => [ 16, 2755 ], "~" => [ 16, 2755 ], },
	# [2755] opcode : rrc "(" iy "-" "[expr_NDIS]"
	{ ")" => 2756, },
	# [2756] opcode : rrc "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1303 ], "," => 2757, ":" => [ 9, \&_action_opcode_1303 ], },
	# [2757] opcode : rrc "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 2758, b => 2759, c => 2760, d => 2761, e => 2762, h => 2763, l => 2764, },
	# [2758] opcode : rrc "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1304 ], ":" => [ 9, \&_action_opcode_1304 ], },
	# [2759] opcode : rrc "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1305 ], ":" => [ 9, \&_action_opcode_1305 ], },
	# [2760] opcode : rrc "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1306 ], ":" => [ 9, \&_action_opcode_1306 ], },
	# [2761] opcode : rrc "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1307 ], ":" => [ 9, \&_action_opcode_1307 ], },
	# [2762] opcode : rrc "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1308 ], ":" => [ 9, \&_action_opcode_1308 ], },
	# [2763] opcode : rrc "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1309 ], ":" => [ 9, \&_action_opcode_1309 ], },
	# [2764] opcode : rrc "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1310 ], ":" => [ 9, \&_action_opcode_1310 ], },
	# [2765] opcode : rrc a
	{ "\n" => [ 9, \&_action_opcode_1311 ], ":" => [ 9, \&_action_opcode_1311 ], },
	# [2766] opcode : rrc b
	{ "\n" => [ 9, \&_action_opcode_1312 ], ":" => [ 9, \&_action_opcode_1312 ], },
	# [2767] opcode : rrc c
	{ "\n" => [ 9, \&_action_opcode_1313 ], ":" => [ 9, \&_action_opcode_1313 ], },
	# [2768] opcode : rrc d
	{ "\n" => [ 9, \&_action_opcode_1314 ], ":" => [ 9, \&_action_opcode_1314 ], },
	# [2769] opcode : rrc e
	{ "\n" => [ 9, \&_action_opcode_1315 ], ":" => [ 9, \&_action_opcode_1315 ], },
	# [2770] opcode : rrc h
	{ "\n" => [ 9, \&_action_opcode_1316 ], ":" => [ 9, \&_action_opcode_1316 ], },
	# [2771] opcode : rrc l
	{ "\n" => [ 9, \&_action_opcode_1317 ], ":" => [ 9, \&_action_opcode_1317 ], },
	# [2772] opcode : rrca
	{ "\n" => [ 9, \&_action_opcode_1318 ], ":" => [ 9, \&_action_opcode_1318 ], },
	# [2773] opcode : rrd
	{ "\n" => [ 9, \&_action_opcode_1319 ], ":" => [ 9, \&_action_opcode_1319 ], },
	# [2774] opcode : rst
	{ "!" => [ 42, 2775 ], "+" => [ 42, 2775 ], "-" => [ 42, 2775 ], __else__ => [ 42, 2775 ], "~" => [ 42, 2775 ], },
	# [2775] opcode : rst "[inline_const]"
	{ 0 => 2776, 1 => 2777, 16 => 2778, 2 => 2779, 24 => 2780, 3 => 2781, 32 => 2782, 4 => 2783, 40 => 2784, 48 => 2785, 5 => 2786, 56 => 2787, 6 => 2788, 7 => 2789, 8 => 2790, },
	# [2776] opcode : rst "[inline_const]" 0
	{ "\n" => [ 9, \&_action_opcode_1320 ], ":" => [ 9, \&_action_opcode_1320 ], },
	# [2777] opcode : rst "[inline_const]" 1
	{ "\n" => [ 9, \&_action_opcode_1321 ], ":" => [ 9, \&_action_opcode_1321 ], },
	# [2778] opcode : rst "[inline_const]" 16
	{ "\n" => [ 9, \&_action_opcode_1322 ], ":" => [ 9, \&_action_opcode_1322 ], },
	# [2779] opcode : rst "[inline_const]" 2
	{ "\n" => [ 9, \&_action_opcode_1322 ], ":" => [ 9, \&_action_opcode_1322 ], },
	# [2780] opcode : rst "[inline_const]" 24
	{ "\n" => [ 9, \&_action_opcode_1323 ], ":" => [ 9, \&_action_opcode_1323 ], },
	# [2781] opcode : rst "[inline_const]" 3
	{ "\n" => [ 9, \&_action_opcode_1323 ], ":" => [ 9, \&_action_opcode_1323 ], },
	# [2782] opcode : rst "[inline_const]" 32
	{ "\n" => [ 9, \&_action_opcode_1324 ], ":" => [ 9, \&_action_opcode_1324 ], },
	# [2783] opcode : rst "[inline_const]" 4
	{ "\n" => [ 9, \&_action_opcode_1324 ], ":" => [ 9, \&_action_opcode_1324 ], },
	# [2784] opcode : rst "[inline_const]" 40
	{ "\n" => [ 9, \&_action_opcode_1325 ], ":" => [ 9, \&_action_opcode_1325 ], },
	# [2785] opcode : rst "[inline_const]" 48
	{ "\n" => [ 9, \&_action_opcode_1326 ], ":" => [ 9, \&_action_opcode_1326 ], },
	# [2786] opcode : rst "[inline_const]" 5
	{ "\n" => [ 9, \&_action_opcode_1325 ], ":" => [ 9, \&_action_opcode_1325 ], },
	# [2787] opcode : rst "[inline_const]" 56
	{ "\n" => [ 9, \&_action_opcode_1327 ], ":" => [ 9, \&_action_opcode_1327 ], },
	# [2788] opcode : rst "[inline_const]" 6
	{ "\n" => [ 9, \&_action_opcode_1326 ], ":" => [ 9, \&_action_opcode_1326 ], },
	# [2789] opcode : rst "[inline_const]" 7
	{ "\n" => [ 9, \&_action_opcode_1327 ], ":" => [ 9, \&_action_opcode_1327 ], },
	# [2790] opcode : rst "[inline_const]" 8
	{ "\n" => [ 9, \&_action_opcode_1321 ], ":" => [ 9, \&_action_opcode_1321 ], },
	# [2791] opcode : sbc
	{ a => 2792, hl => 2825, },
	# [2792] opcode : sbc a
	{ "," => 2793, },
	# [2793] opcode : sbc a ","
	{ "!" => [ 15, 2813 ], "(" => 2794, "+" => [ 15, 2813 ], "-" => [ 15, 2813 ], __else__ => [ 15, 2813 ], a => 2814, b => 2815, c => 2816, d => 2817, e => 2818, h => 2819, ixh => 2820, ixl => 2821, iyh => 2822, iyl => 2823, l => 2824, "~" => [ 15, 2813 ], },
	# [2794] opcode : sbc a "," "("
	{ hl => 2795, ix => 2797, iy => 2805, },
	# [2795] opcode : sbc a "," "(" hl
	{ ")" => 2796, },
	# [2796] opcode : sbc a "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_1328 ], ":" => [ 9, \&_action_opcode_1328 ], },
	# [2797] opcode : sbc a "," "(" ix
	{ ")" => 2798, "+" => 2799, "-" => 2802, },
	# [2798] opcode : sbc a "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_1329 ], ":" => [ 9, \&_action_opcode_1329 ], },
	# [2799] opcode : sbc a "," "(" ix "+"
	{ "!" => [ 14, 2800 ], "+" => [ 14, 2800 ], "-" => [ 14, 2800 ], __else__ => [ 14, 2800 ], "~" => [ 14, 2800 ], },
	# [2800] opcode : sbc a "," "(" ix "+" "[expr_DIS]"
	{ ")" => 2801, },
	# [2801] opcode : sbc a "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1330 ], ":" => [ 9, \&_action_opcode_1330 ], },
	# [2802] opcode : sbc a "," "(" ix "-"
	{ "!" => [ 16, 2803 ], "+" => [ 16, 2803 ], "-" => [ 16, 2803 ], __else__ => [ 16, 2803 ], "~" => [ 16, 2803 ], },
	# [2803] opcode : sbc a "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 2804, },
	# [2804] opcode : sbc a "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1330 ], ":" => [ 9, \&_action_opcode_1330 ], },
	# [2805] opcode : sbc a "," "(" iy
	{ ")" => 2806, "+" => 2807, "-" => 2810, },
	# [2806] opcode : sbc a "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_1331 ], ":" => [ 9, \&_action_opcode_1331 ], },
	# [2807] opcode : sbc a "," "(" iy "+"
	{ "!" => [ 14, 2808 ], "+" => [ 14, 2808 ], "-" => [ 14, 2808 ], __else__ => [ 14, 2808 ], "~" => [ 14, 2808 ], },
	# [2808] opcode : sbc a "," "(" iy "+" "[expr_DIS]"
	{ ")" => 2809, },
	# [2809] opcode : sbc a "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1332 ], ":" => [ 9, \&_action_opcode_1332 ], },
	# [2810] opcode : sbc a "," "(" iy "-"
	{ "!" => [ 16, 2811 ], "+" => [ 16, 2811 ], "-" => [ 16, 2811 ], __else__ => [ 16, 2811 ], "~" => [ 16, 2811 ], },
	# [2811] opcode : sbc a "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 2812, },
	# [2812] opcode : sbc a "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1332 ], ":" => [ 9, \&_action_opcode_1332 ], },
	# [2813] opcode : sbc a "," "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_1333 ], ":" => [ 9, \&_action_opcode_1333 ], },
	# [2814] opcode : sbc a "," a
	{ "\n" => [ 9, \&_action_opcode_1334 ], ":" => [ 9, \&_action_opcode_1334 ], },
	# [2815] opcode : sbc a "," b
	{ "\n" => [ 9, \&_action_opcode_1335 ], ":" => [ 9, \&_action_opcode_1335 ], },
	# [2816] opcode : sbc a "," c
	{ "\n" => [ 9, \&_action_opcode_1336 ], ":" => [ 9, \&_action_opcode_1336 ], },
	# [2817] opcode : sbc a "," d
	{ "\n" => [ 9, \&_action_opcode_1337 ], ":" => [ 9, \&_action_opcode_1337 ], },
	# [2818] opcode : sbc a "," e
	{ "\n" => [ 9, \&_action_opcode_1338 ], ":" => [ 9, \&_action_opcode_1338 ], },
	# [2819] opcode : sbc a "," h
	{ "\n" => [ 9, \&_action_opcode_1339 ], ":" => [ 9, \&_action_opcode_1339 ], },
	# [2820] opcode : sbc a "," ixh
	{ "\n" => [ 9, \&_action_opcode_1340 ], ":" => [ 9, \&_action_opcode_1340 ], },
	# [2821] opcode : sbc a "," ixl
	{ "\n" => [ 9, \&_action_opcode_1341 ], ":" => [ 9, \&_action_opcode_1341 ], },
	# [2822] opcode : sbc a "," iyh
	{ "\n" => [ 9, \&_action_opcode_1342 ], ":" => [ 9, \&_action_opcode_1342 ], },
	# [2823] opcode : sbc a "," iyl
	{ "\n" => [ 9, \&_action_opcode_1343 ], ":" => [ 9, \&_action_opcode_1343 ], },
	# [2824] opcode : sbc a "," l
	{ "\n" => [ 9, \&_action_opcode_1344 ], ":" => [ 9, \&_action_opcode_1344 ], },
	# [2825] opcode : sbc hl
	{ "," => 2826, },
	# [2826] opcode : sbc hl ","
	{ bc => 2827, de => 2828, hl => 2829, sp => 2830, },
	# [2827] opcode : sbc hl "," bc
	{ "\n" => [ 9, \&_action_opcode_1345 ], ":" => [ 9, \&_action_opcode_1345 ], },
	# [2828] opcode : sbc hl "," de
	{ "\n" => [ 9, \&_action_opcode_1346 ], ":" => [ 9, \&_action_opcode_1346 ], },
	# [2829] opcode : sbc hl "," hl
	{ "\n" => [ 9, \&_action_opcode_1347 ], ":" => [ 9, \&_action_opcode_1347 ], },
	# [2830] opcode : sbc hl "," sp
	{ "\n" => [ 9, \&_action_opcode_1348 ], ":" => [ 9, \&_action_opcode_1348 ], },
	# [2831] opcode : scf
	{ "\n" => [ 9, \&_action_opcode_1349 ], ":" => [ 9, \&_action_opcode_1349 ], },
	# [2832] opcode : set
	{ "!" => [ 42, 2833 ], "+" => [ 42, 2833 ], "-" => [ 42, 2833 ], __else__ => [ 42, 2833 ], "~" => [ 42, 2833 ], },
	# [2833] opcode : set "[inline_const]"
	{ 0 => 2834, 1 => 2910, 2 => 2986, 3 => 3062, 4 => 3138, 5 => 3214, 6 => 3290, 7 => 3366, },
	# [2834] opcode : set "[inline_const]" 0
	{ "," => 2835, },
	# [2835] opcode : set "[inline_const]" 0 ","
	{ "(" => 2836, a => 2903, b => 2904, c => 2905, d => 2906, e => 2907, h => 2908, l => 2909, },
	# [2836] opcode : set "[inline_const]" 0 "," "("
	{ hl => 2837, ix => 2839, iy => 2871, },
	# [2837] opcode : set "[inline_const]" 0 "," "(" hl
	{ ")" => 2838, },
	# [2838] opcode : set "[inline_const]" 0 "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_1350 ], ":" => [ 9, \&_action_opcode_1350 ], },
	# [2839] opcode : set "[inline_const]" 0 "," "(" ix
	{ ")" => 2840, "+" => 2849, "-" => 2860, },
	# [2840] opcode : set "[inline_const]" 0 "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_1351 ], "," => 2841, ":" => [ 9, \&_action_opcode_1351 ], },
	# [2841] opcode : set "[inline_const]" 0 "," "(" ix ")" ","
	{ a => 2842, b => 2843, c => 2844, d => 2845, e => 2846, h => 2847, l => 2848, },
	# [2842] opcode : set "[inline_const]" 0 "," "(" ix ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1352 ], ":" => [ 9, \&_action_opcode_1352 ], },
	# [2843] opcode : set "[inline_const]" 0 "," "(" ix ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1353 ], ":" => [ 9, \&_action_opcode_1353 ], },
	# [2844] opcode : set "[inline_const]" 0 "," "(" ix ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1354 ], ":" => [ 9, \&_action_opcode_1354 ], },
	# [2845] opcode : set "[inline_const]" 0 "," "(" ix ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1355 ], ":" => [ 9, \&_action_opcode_1355 ], },
	# [2846] opcode : set "[inline_const]" 0 "," "(" ix ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1356 ], ":" => [ 9, \&_action_opcode_1356 ], },
	# [2847] opcode : set "[inline_const]" 0 "," "(" ix ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1357 ], ":" => [ 9, \&_action_opcode_1357 ], },
	# [2848] opcode : set "[inline_const]" 0 "," "(" ix ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1358 ], ":" => [ 9, \&_action_opcode_1358 ], },
	# [2849] opcode : set "[inline_const]" 0 "," "(" ix "+"
	{ "!" => [ 14, 2850 ], "+" => [ 14, 2850 ], "-" => [ 14, 2850 ], __else__ => [ 14, 2850 ], "~" => [ 14, 2850 ], },
	# [2850] opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 2851, },
	# [2851] opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1359 ], "," => 2852, ":" => [ 9, \&_action_opcode_1359 ], },
	# [2852] opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 2853, b => 2854, c => 2855, d => 2856, e => 2857, h => 2858, l => 2859, },
	# [2853] opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1360 ], ":" => [ 9, \&_action_opcode_1360 ], },
	# [2854] opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1361 ], ":" => [ 9, \&_action_opcode_1361 ], },
	# [2855] opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1362 ], ":" => [ 9, \&_action_opcode_1362 ], },
	# [2856] opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1363 ], ":" => [ 9, \&_action_opcode_1363 ], },
	# [2857] opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1364 ], ":" => [ 9, \&_action_opcode_1364 ], },
	# [2858] opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1365 ], ":" => [ 9, \&_action_opcode_1365 ], },
	# [2859] opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1366 ], ":" => [ 9, \&_action_opcode_1366 ], },
	# [2860] opcode : set "[inline_const]" 0 "," "(" ix "-"
	{ "!" => [ 16, 2861 ], "+" => [ 16, 2861 ], "-" => [ 16, 2861 ], __else__ => [ 16, 2861 ], "~" => [ 16, 2861 ], },
	# [2861] opcode : set "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 2862, },
	# [2862] opcode : set "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1359 ], "," => 2863, ":" => [ 9, \&_action_opcode_1359 ], },
	# [2863] opcode : set "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 2864, b => 2865, c => 2866, d => 2867, e => 2868, h => 2869, l => 2870, },
	# [2864] opcode : set "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1360 ], ":" => [ 9, \&_action_opcode_1360 ], },
	# [2865] opcode : set "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1361 ], ":" => [ 9, \&_action_opcode_1361 ], },
	# [2866] opcode : set "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1362 ], ":" => [ 9, \&_action_opcode_1362 ], },
	# [2867] opcode : set "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1363 ], ":" => [ 9, \&_action_opcode_1363 ], },
	# [2868] opcode : set "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1364 ], ":" => [ 9, \&_action_opcode_1364 ], },
	# [2869] opcode : set "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1365 ], ":" => [ 9, \&_action_opcode_1365 ], },
	# [2870] opcode : set "[inline_const]" 0 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1366 ], ":" => [ 9, \&_action_opcode_1366 ], },
	# [2871] opcode : set "[inline_const]" 0 "," "(" iy
	{ ")" => 2872, "+" => 2881, "-" => 2892, },
	# [2872] opcode : set "[inline_const]" 0 "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_1367 ], "," => 2873, ":" => [ 9, \&_action_opcode_1367 ], },
	# [2873] opcode : set "[inline_const]" 0 "," "(" iy ")" ","
	{ a => 2874, b => 2875, c => 2876, d => 2877, e => 2878, h => 2879, l => 2880, },
	# [2874] opcode : set "[inline_const]" 0 "," "(" iy ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1368 ], ":" => [ 9, \&_action_opcode_1368 ], },
	# [2875] opcode : set "[inline_const]" 0 "," "(" iy ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1369 ], ":" => [ 9, \&_action_opcode_1369 ], },
	# [2876] opcode : set "[inline_const]" 0 "," "(" iy ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1370 ], ":" => [ 9, \&_action_opcode_1370 ], },
	# [2877] opcode : set "[inline_const]" 0 "," "(" iy ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1371 ], ":" => [ 9, \&_action_opcode_1371 ], },
	# [2878] opcode : set "[inline_const]" 0 "," "(" iy ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1372 ], ":" => [ 9, \&_action_opcode_1372 ], },
	# [2879] opcode : set "[inline_const]" 0 "," "(" iy ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1373 ], ":" => [ 9, \&_action_opcode_1373 ], },
	# [2880] opcode : set "[inline_const]" 0 "," "(" iy ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1374 ], ":" => [ 9, \&_action_opcode_1374 ], },
	# [2881] opcode : set "[inline_const]" 0 "," "(" iy "+"
	{ "!" => [ 14, 2882 ], "+" => [ 14, 2882 ], "-" => [ 14, 2882 ], __else__ => [ 14, 2882 ], "~" => [ 14, 2882 ], },
	# [2882] opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 2883, },
	# [2883] opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1375 ], "," => 2884, ":" => [ 9, \&_action_opcode_1375 ], },
	# [2884] opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 2885, b => 2886, c => 2887, d => 2888, e => 2889, h => 2890, l => 2891, },
	# [2885] opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1376 ], ":" => [ 9, \&_action_opcode_1376 ], },
	# [2886] opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1377 ], ":" => [ 9, \&_action_opcode_1377 ], },
	# [2887] opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1378 ], ":" => [ 9, \&_action_opcode_1378 ], },
	# [2888] opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1379 ], ":" => [ 9, \&_action_opcode_1379 ], },
	# [2889] opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1380 ], ":" => [ 9, \&_action_opcode_1380 ], },
	# [2890] opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1381 ], ":" => [ 9, \&_action_opcode_1381 ], },
	# [2891] opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1382 ], ":" => [ 9, \&_action_opcode_1382 ], },
	# [2892] opcode : set "[inline_const]" 0 "," "(" iy "-"
	{ "!" => [ 16, 2893 ], "+" => [ 16, 2893 ], "-" => [ 16, 2893 ], __else__ => [ 16, 2893 ], "~" => [ 16, 2893 ], },
	# [2893] opcode : set "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 2894, },
	# [2894] opcode : set "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1375 ], "," => 2895, ":" => [ 9, \&_action_opcode_1375 ], },
	# [2895] opcode : set "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 2896, b => 2897, c => 2898, d => 2899, e => 2900, h => 2901, l => 2902, },
	# [2896] opcode : set "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1376 ], ":" => [ 9, \&_action_opcode_1376 ], },
	# [2897] opcode : set "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1377 ], ":" => [ 9, \&_action_opcode_1377 ], },
	# [2898] opcode : set "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1378 ], ":" => [ 9, \&_action_opcode_1378 ], },
	# [2899] opcode : set "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1379 ], ":" => [ 9, \&_action_opcode_1379 ], },
	# [2900] opcode : set "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1380 ], ":" => [ 9, \&_action_opcode_1380 ], },
	# [2901] opcode : set "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1381 ], ":" => [ 9, \&_action_opcode_1381 ], },
	# [2902] opcode : set "[inline_const]" 0 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1382 ], ":" => [ 9, \&_action_opcode_1382 ], },
	# [2903] opcode : set "[inline_const]" 0 "," a
	{ "\n" => [ 9, \&_action_opcode_1383 ], ":" => [ 9, \&_action_opcode_1383 ], },
	# [2904] opcode : set "[inline_const]" 0 "," b
	{ "\n" => [ 9, \&_action_opcode_1384 ], ":" => [ 9, \&_action_opcode_1384 ], },
	# [2905] opcode : set "[inline_const]" 0 "," c
	{ "\n" => [ 9, \&_action_opcode_1385 ], ":" => [ 9, \&_action_opcode_1385 ], },
	# [2906] opcode : set "[inline_const]" 0 "," d
	{ "\n" => [ 9, \&_action_opcode_1386 ], ":" => [ 9, \&_action_opcode_1386 ], },
	# [2907] opcode : set "[inline_const]" 0 "," e
	{ "\n" => [ 9, \&_action_opcode_1387 ], ":" => [ 9, \&_action_opcode_1387 ], },
	# [2908] opcode : set "[inline_const]" 0 "," h
	{ "\n" => [ 9, \&_action_opcode_1388 ], ":" => [ 9, \&_action_opcode_1388 ], },
	# [2909] opcode : set "[inline_const]" 0 "," l
	{ "\n" => [ 9, \&_action_opcode_1389 ], ":" => [ 9, \&_action_opcode_1389 ], },
	# [2910] opcode : set "[inline_const]" 1
	{ "," => 2911, },
	# [2911] opcode : set "[inline_const]" 1 ","
	{ "(" => 2912, a => 2979, b => 2980, c => 2981, d => 2982, e => 2983, h => 2984, l => 2985, },
	# [2912] opcode : set "[inline_const]" 1 "," "("
	{ hl => 2913, ix => 2915, iy => 2947, },
	# [2913] opcode : set "[inline_const]" 1 "," "(" hl
	{ ")" => 2914, },
	# [2914] opcode : set "[inline_const]" 1 "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_1390 ], ":" => [ 9, \&_action_opcode_1390 ], },
	# [2915] opcode : set "[inline_const]" 1 "," "(" ix
	{ ")" => 2916, "+" => 2925, "-" => 2936, },
	# [2916] opcode : set "[inline_const]" 1 "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_1391 ], "," => 2917, ":" => [ 9, \&_action_opcode_1391 ], },
	# [2917] opcode : set "[inline_const]" 1 "," "(" ix ")" ","
	{ a => 2918, b => 2919, c => 2920, d => 2921, e => 2922, h => 2923, l => 2924, },
	# [2918] opcode : set "[inline_const]" 1 "," "(" ix ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1392 ], ":" => [ 9, \&_action_opcode_1392 ], },
	# [2919] opcode : set "[inline_const]" 1 "," "(" ix ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1393 ], ":" => [ 9, \&_action_opcode_1393 ], },
	# [2920] opcode : set "[inline_const]" 1 "," "(" ix ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1394 ], ":" => [ 9, \&_action_opcode_1394 ], },
	# [2921] opcode : set "[inline_const]" 1 "," "(" ix ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1395 ], ":" => [ 9, \&_action_opcode_1395 ], },
	# [2922] opcode : set "[inline_const]" 1 "," "(" ix ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1396 ], ":" => [ 9, \&_action_opcode_1396 ], },
	# [2923] opcode : set "[inline_const]" 1 "," "(" ix ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1397 ], ":" => [ 9, \&_action_opcode_1397 ], },
	# [2924] opcode : set "[inline_const]" 1 "," "(" ix ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1398 ], ":" => [ 9, \&_action_opcode_1398 ], },
	# [2925] opcode : set "[inline_const]" 1 "," "(" ix "+"
	{ "!" => [ 14, 2926 ], "+" => [ 14, 2926 ], "-" => [ 14, 2926 ], __else__ => [ 14, 2926 ], "~" => [ 14, 2926 ], },
	# [2926] opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 2927, },
	# [2927] opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1399 ], "," => 2928, ":" => [ 9, \&_action_opcode_1399 ], },
	# [2928] opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 2929, b => 2930, c => 2931, d => 2932, e => 2933, h => 2934, l => 2935, },
	# [2929] opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1400 ], ":" => [ 9, \&_action_opcode_1400 ], },
	# [2930] opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1401 ], ":" => [ 9, \&_action_opcode_1401 ], },
	# [2931] opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1402 ], ":" => [ 9, \&_action_opcode_1402 ], },
	# [2932] opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1403 ], ":" => [ 9, \&_action_opcode_1403 ], },
	# [2933] opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1404 ], ":" => [ 9, \&_action_opcode_1404 ], },
	# [2934] opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1405 ], ":" => [ 9, \&_action_opcode_1405 ], },
	# [2935] opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1406 ], ":" => [ 9, \&_action_opcode_1406 ], },
	# [2936] opcode : set "[inline_const]" 1 "," "(" ix "-"
	{ "!" => [ 16, 2937 ], "+" => [ 16, 2937 ], "-" => [ 16, 2937 ], __else__ => [ 16, 2937 ], "~" => [ 16, 2937 ], },
	# [2937] opcode : set "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 2938, },
	# [2938] opcode : set "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1399 ], "," => 2939, ":" => [ 9, \&_action_opcode_1399 ], },
	# [2939] opcode : set "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 2940, b => 2941, c => 2942, d => 2943, e => 2944, h => 2945, l => 2946, },
	# [2940] opcode : set "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1400 ], ":" => [ 9, \&_action_opcode_1400 ], },
	# [2941] opcode : set "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1401 ], ":" => [ 9, \&_action_opcode_1401 ], },
	# [2942] opcode : set "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1402 ], ":" => [ 9, \&_action_opcode_1402 ], },
	# [2943] opcode : set "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1403 ], ":" => [ 9, \&_action_opcode_1403 ], },
	# [2944] opcode : set "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1404 ], ":" => [ 9, \&_action_opcode_1404 ], },
	# [2945] opcode : set "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1405 ], ":" => [ 9, \&_action_opcode_1405 ], },
	# [2946] opcode : set "[inline_const]" 1 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1406 ], ":" => [ 9, \&_action_opcode_1406 ], },
	# [2947] opcode : set "[inline_const]" 1 "," "(" iy
	{ ")" => 2948, "+" => 2957, "-" => 2968, },
	# [2948] opcode : set "[inline_const]" 1 "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_1407 ], "," => 2949, ":" => [ 9, \&_action_opcode_1407 ], },
	# [2949] opcode : set "[inline_const]" 1 "," "(" iy ")" ","
	{ a => 2950, b => 2951, c => 2952, d => 2953, e => 2954, h => 2955, l => 2956, },
	# [2950] opcode : set "[inline_const]" 1 "," "(" iy ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1408 ], ":" => [ 9, \&_action_opcode_1408 ], },
	# [2951] opcode : set "[inline_const]" 1 "," "(" iy ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1409 ], ":" => [ 9, \&_action_opcode_1409 ], },
	# [2952] opcode : set "[inline_const]" 1 "," "(" iy ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1410 ], ":" => [ 9, \&_action_opcode_1410 ], },
	# [2953] opcode : set "[inline_const]" 1 "," "(" iy ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1411 ], ":" => [ 9, \&_action_opcode_1411 ], },
	# [2954] opcode : set "[inline_const]" 1 "," "(" iy ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1412 ], ":" => [ 9, \&_action_opcode_1412 ], },
	# [2955] opcode : set "[inline_const]" 1 "," "(" iy ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1413 ], ":" => [ 9, \&_action_opcode_1413 ], },
	# [2956] opcode : set "[inline_const]" 1 "," "(" iy ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1414 ], ":" => [ 9, \&_action_opcode_1414 ], },
	# [2957] opcode : set "[inline_const]" 1 "," "(" iy "+"
	{ "!" => [ 14, 2958 ], "+" => [ 14, 2958 ], "-" => [ 14, 2958 ], __else__ => [ 14, 2958 ], "~" => [ 14, 2958 ], },
	# [2958] opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 2959, },
	# [2959] opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1415 ], "," => 2960, ":" => [ 9, \&_action_opcode_1415 ], },
	# [2960] opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 2961, b => 2962, c => 2963, d => 2964, e => 2965, h => 2966, l => 2967, },
	# [2961] opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1416 ], ":" => [ 9, \&_action_opcode_1416 ], },
	# [2962] opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1417 ], ":" => [ 9, \&_action_opcode_1417 ], },
	# [2963] opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1418 ], ":" => [ 9, \&_action_opcode_1418 ], },
	# [2964] opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1419 ], ":" => [ 9, \&_action_opcode_1419 ], },
	# [2965] opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1420 ], ":" => [ 9, \&_action_opcode_1420 ], },
	# [2966] opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1421 ], ":" => [ 9, \&_action_opcode_1421 ], },
	# [2967] opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1422 ], ":" => [ 9, \&_action_opcode_1422 ], },
	# [2968] opcode : set "[inline_const]" 1 "," "(" iy "-"
	{ "!" => [ 16, 2969 ], "+" => [ 16, 2969 ], "-" => [ 16, 2969 ], __else__ => [ 16, 2969 ], "~" => [ 16, 2969 ], },
	# [2969] opcode : set "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 2970, },
	# [2970] opcode : set "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1415 ], "," => 2971, ":" => [ 9, \&_action_opcode_1415 ], },
	# [2971] opcode : set "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 2972, b => 2973, c => 2974, d => 2975, e => 2976, h => 2977, l => 2978, },
	# [2972] opcode : set "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1416 ], ":" => [ 9, \&_action_opcode_1416 ], },
	# [2973] opcode : set "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1417 ], ":" => [ 9, \&_action_opcode_1417 ], },
	# [2974] opcode : set "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1418 ], ":" => [ 9, \&_action_opcode_1418 ], },
	# [2975] opcode : set "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1419 ], ":" => [ 9, \&_action_opcode_1419 ], },
	# [2976] opcode : set "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1420 ], ":" => [ 9, \&_action_opcode_1420 ], },
	# [2977] opcode : set "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1421 ], ":" => [ 9, \&_action_opcode_1421 ], },
	# [2978] opcode : set "[inline_const]" 1 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1422 ], ":" => [ 9, \&_action_opcode_1422 ], },
	# [2979] opcode : set "[inline_const]" 1 "," a
	{ "\n" => [ 9, \&_action_opcode_1423 ], ":" => [ 9, \&_action_opcode_1423 ], },
	# [2980] opcode : set "[inline_const]" 1 "," b
	{ "\n" => [ 9, \&_action_opcode_1424 ], ":" => [ 9, \&_action_opcode_1424 ], },
	# [2981] opcode : set "[inline_const]" 1 "," c
	{ "\n" => [ 9, \&_action_opcode_1425 ], ":" => [ 9, \&_action_opcode_1425 ], },
	# [2982] opcode : set "[inline_const]" 1 "," d
	{ "\n" => [ 9, \&_action_opcode_1426 ], ":" => [ 9, \&_action_opcode_1426 ], },
	# [2983] opcode : set "[inline_const]" 1 "," e
	{ "\n" => [ 9, \&_action_opcode_1427 ], ":" => [ 9, \&_action_opcode_1427 ], },
	# [2984] opcode : set "[inline_const]" 1 "," h
	{ "\n" => [ 9, \&_action_opcode_1428 ], ":" => [ 9, \&_action_opcode_1428 ], },
	# [2985] opcode : set "[inline_const]" 1 "," l
	{ "\n" => [ 9, \&_action_opcode_1429 ], ":" => [ 9, \&_action_opcode_1429 ], },
	# [2986] opcode : set "[inline_const]" 2
	{ "," => 2987, },
	# [2987] opcode : set "[inline_const]" 2 ","
	{ "(" => 2988, a => 3055, b => 3056, c => 3057, d => 3058, e => 3059, h => 3060, l => 3061, },
	# [2988] opcode : set "[inline_const]" 2 "," "("
	{ hl => 2989, ix => 2991, iy => 3023, },
	# [2989] opcode : set "[inline_const]" 2 "," "(" hl
	{ ")" => 2990, },
	# [2990] opcode : set "[inline_const]" 2 "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_1430 ], ":" => [ 9, \&_action_opcode_1430 ], },
	# [2991] opcode : set "[inline_const]" 2 "," "(" ix
	{ ")" => 2992, "+" => 3001, "-" => 3012, },
	# [2992] opcode : set "[inline_const]" 2 "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_1431 ], "," => 2993, ":" => [ 9, \&_action_opcode_1431 ], },
	# [2993] opcode : set "[inline_const]" 2 "," "(" ix ")" ","
	{ a => 2994, b => 2995, c => 2996, d => 2997, e => 2998, h => 2999, l => 3000, },
	# [2994] opcode : set "[inline_const]" 2 "," "(" ix ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1432 ], ":" => [ 9, \&_action_opcode_1432 ], },
	# [2995] opcode : set "[inline_const]" 2 "," "(" ix ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1433 ], ":" => [ 9, \&_action_opcode_1433 ], },
	# [2996] opcode : set "[inline_const]" 2 "," "(" ix ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1434 ], ":" => [ 9, \&_action_opcode_1434 ], },
	# [2997] opcode : set "[inline_const]" 2 "," "(" ix ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1435 ], ":" => [ 9, \&_action_opcode_1435 ], },
	# [2998] opcode : set "[inline_const]" 2 "," "(" ix ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1436 ], ":" => [ 9, \&_action_opcode_1436 ], },
	# [2999] opcode : set "[inline_const]" 2 "," "(" ix ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1437 ], ":" => [ 9, \&_action_opcode_1437 ], },
	# [3000] opcode : set "[inline_const]" 2 "," "(" ix ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1438 ], ":" => [ 9, \&_action_opcode_1438 ], },
	# [3001] opcode : set "[inline_const]" 2 "," "(" ix "+"
	{ "!" => [ 14, 3002 ], "+" => [ 14, 3002 ], "-" => [ 14, 3002 ], __else__ => [ 14, 3002 ], "~" => [ 14, 3002 ], },
	# [3002] opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 3003, },
	# [3003] opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1439 ], "," => 3004, ":" => [ 9, \&_action_opcode_1439 ], },
	# [3004] opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 3005, b => 3006, c => 3007, d => 3008, e => 3009, h => 3010, l => 3011, },
	# [3005] opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1440 ], ":" => [ 9, \&_action_opcode_1440 ], },
	# [3006] opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1441 ], ":" => [ 9, \&_action_opcode_1441 ], },
	# [3007] opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1442 ], ":" => [ 9, \&_action_opcode_1442 ], },
	# [3008] opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1443 ], ":" => [ 9, \&_action_opcode_1443 ], },
	# [3009] opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1444 ], ":" => [ 9, \&_action_opcode_1444 ], },
	# [3010] opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1445 ], ":" => [ 9, \&_action_opcode_1445 ], },
	# [3011] opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1446 ], ":" => [ 9, \&_action_opcode_1446 ], },
	# [3012] opcode : set "[inline_const]" 2 "," "(" ix "-"
	{ "!" => [ 16, 3013 ], "+" => [ 16, 3013 ], "-" => [ 16, 3013 ], __else__ => [ 16, 3013 ], "~" => [ 16, 3013 ], },
	# [3013] opcode : set "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 3014, },
	# [3014] opcode : set "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1439 ], "," => 3015, ":" => [ 9, \&_action_opcode_1439 ], },
	# [3015] opcode : set "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 3016, b => 3017, c => 3018, d => 3019, e => 3020, h => 3021, l => 3022, },
	# [3016] opcode : set "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1440 ], ":" => [ 9, \&_action_opcode_1440 ], },
	# [3017] opcode : set "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1441 ], ":" => [ 9, \&_action_opcode_1441 ], },
	# [3018] opcode : set "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1442 ], ":" => [ 9, \&_action_opcode_1442 ], },
	# [3019] opcode : set "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1443 ], ":" => [ 9, \&_action_opcode_1443 ], },
	# [3020] opcode : set "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1444 ], ":" => [ 9, \&_action_opcode_1444 ], },
	# [3021] opcode : set "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1445 ], ":" => [ 9, \&_action_opcode_1445 ], },
	# [3022] opcode : set "[inline_const]" 2 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1446 ], ":" => [ 9, \&_action_opcode_1446 ], },
	# [3023] opcode : set "[inline_const]" 2 "," "(" iy
	{ ")" => 3024, "+" => 3033, "-" => 3044, },
	# [3024] opcode : set "[inline_const]" 2 "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_1447 ], "," => 3025, ":" => [ 9, \&_action_opcode_1447 ], },
	# [3025] opcode : set "[inline_const]" 2 "," "(" iy ")" ","
	{ a => 3026, b => 3027, c => 3028, d => 3029, e => 3030, h => 3031, l => 3032, },
	# [3026] opcode : set "[inline_const]" 2 "," "(" iy ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1448 ], ":" => [ 9, \&_action_opcode_1448 ], },
	# [3027] opcode : set "[inline_const]" 2 "," "(" iy ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1449 ], ":" => [ 9, \&_action_opcode_1449 ], },
	# [3028] opcode : set "[inline_const]" 2 "," "(" iy ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1450 ], ":" => [ 9, \&_action_opcode_1450 ], },
	# [3029] opcode : set "[inline_const]" 2 "," "(" iy ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1451 ], ":" => [ 9, \&_action_opcode_1451 ], },
	# [3030] opcode : set "[inline_const]" 2 "," "(" iy ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1452 ], ":" => [ 9, \&_action_opcode_1452 ], },
	# [3031] opcode : set "[inline_const]" 2 "," "(" iy ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1453 ], ":" => [ 9, \&_action_opcode_1453 ], },
	# [3032] opcode : set "[inline_const]" 2 "," "(" iy ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1454 ], ":" => [ 9, \&_action_opcode_1454 ], },
	# [3033] opcode : set "[inline_const]" 2 "," "(" iy "+"
	{ "!" => [ 14, 3034 ], "+" => [ 14, 3034 ], "-" => [ 14, 3034 ], __else__ => [ 14, 3034 ], "~" => [ 14, 3034 ], },
	# [3034] opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 3035, },
	# [3035] opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1455 ], "," => 3036, ":" => [ 9, \&_action_opcode_1455 ], },
	# [3036] opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 3037, b => 3038, c => 3039, d => 3040, e => 3041, h => 3042, l => 3043, },
	# [3037] opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1456 ], ":" => [ 9, \&_action_opcode_1456 ], },
	# [3038] opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1457 ], ":" => [ 9, \&_action_opcode_1457 ], },
	# [3039] opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1458 ], ":" => [ 9, \&_action_opcode_1458 ], },
	# [3040] opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1459 ], ":" => [ 9, \&_action_opcode_1459 ], },
	# [3041] opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1460 ], ":" => [ 9, \&_action_opcode_1460 ], },
	# [3042] opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1461 ], ":" => [ 9, \&_action_opcode_1461 ], },
	# [3043] opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1462 ], ":" => [ 9, \&_action_opcode_1462 ], },
	# [3044] opcode : set "[inline_const]" 2 "," "(" iy "-"
	{ "!" => [ 16, 3045 ], "+" => [ 16, 3045 ], "-" => [ 16, 3045 ], __else__ => [ 16, 3045 ], "~" => [ 16, 3045 ], },
	# [3045] opcode : set "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 3046, },
	# [3046] opcode : set "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1455 ], "," => 3047, ":" => [ 9, \&_action_opcode_1455 ], },
	# [3047] opcode : set "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 3048, b => 3049, c => 3050, d => 3051, e => 3052, h => 3053, l => 3054, },
	# [3048] opcode : set "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1456 ], ":" => [ 9, \&_action_opcode_1456 ], },
	# [3049] opcode : set "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1457 ], ":" => [ 9, \&_action_opcode_1457 ], },
	# [3050] opcode : set "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1458 ], ":" => [ 9, \&_action_opcode_1458 ], },
	# [3051] opcode : set "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1459 ], ":" => [ 9, \&_action_opcode_1459 ], },
	# [3052] opcode : set "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1460 ], ":" => [ 9, \&_action_opcode_1460 ], },
	# [3053] opcode : set "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1461 ], ":" => [ 9, \&_action_opcode_1461 ], },
	# [3054] opcode : set "[inline_const]" 2 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1462 ], ":" => [ 9, \&_action_opcode_1462 ], },
	# [3055] opcode : set "[inline_const]" 2 "," a
	{ "\n" => [ 9, \&_action_opcode_1463 ], ":" => [ 9, \&_action_opcode_1463 ], },
	# [3056] opcode : set "[inline_const]" 2 "," b
	{ "\n" => [ 9, \&_action_opcode_1464 ], ":" => [ 9, \&_action_opcode_1464 ], },
	# [3057] opcode : set "[inline_const]" 2 "," c
	{ "\n" => [ 9, \&_action_opcode_1465 ], ":" => [ 9, \&_action_opcode_1465 ], },
	# [3058] opcode : set "[inline_const]" 2 "," d
	{ "\n" => [ 9, \&_action_opcode_1466 ], ":" => [ 9, \&_action_opcode_1466 ], },
	# [3059] opcode : set "[inline_const]" 2 "," e
	{ "\n" => [ 9, \&_action_opcode_1467 ], ":" => [ 9, \&_action_opcode_1467 ], },
	# [3060] opcode : set "[inline_const]" 2 "," h
	{ "\n" => [ 9, \&_action_opcode_1468 ], ":" => [ 9, \&_action_opcode_1468 ], },
	# [3061] opcode : set "[inline_const]" 2 "," l
	{ "\n" => [ 9, \&_action_opcode_1469 ], ":" => [ 9, \&_action_opcode_1469 ], },
	# [3062] opcode : set "[inline_const]" 3
	{ "," => 3063, },
	# [3063] opcode : set "[inline_const]" 3 ","
	{ "(" => 3064, a => 3131, b => 3132, c => 3133, d => 3134, e => 3135, h => 3136, l => 3137, },
	# [3064] opcode : set "[inline_const]" 3 "," "("
	{ hl => 3065, ix => 3067, iy => 3099, },
	# [3065] opcode : set "[inline_const]" 3 "," "(" hl
	{ ")" => 3066, },
	# [3066] opcode : set "[inline_const]" 3 "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_1470 ], ":" => [ 9, \&_action_opcode_1470 ], },
	# [3067] opcode : set "[inline_const]" 3 "," "(" ix
	{ ")" => 3068, "+" => 3077, "-" => 3088, },
	# [3068] opcode : set "[inline_const]" 3 "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_1471 ], "," => 3069, ":" => [ 9, \&_action_opcode_1471 ], },
	# [3069] opcode : set "[inline_const]" 3 "," "(" ix ")" ","
	{ a => 3070, b => 3071, c => 3072, d => 3073, e => 3074, h => 3075, l => 3076, },
	# [3070] opcode : set "[inline_const]" 3 "," "(" ix ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1472 ], ":" => [ 9, \&_action_opcode_1472 ], },
	# [3071] opcode : set "[inline_const]" 3 "," "(" ix ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1473 ], ":" => [ 9, \&_action_opcode_1473 ], },
	# [3072] opcode : set "[inline_const]" 3 "," "(" ix ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1474 ], ":" => [ 9, \&_action_opcode_1474 ], },
	# [3073] opcode : set "[inline_const]" 3 "," "(" ix ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1475 ], ":" => [ 9, \&_action_opcode_1475 ], },
	# [3074] opcode : set "[inline_const]" 3 "," "(" ix ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1476 ], ":" => [ 9, \&_action_opcode_1476 ], },
	# [3075] opcode : set "[inline_const]" 3 "," "(" ix ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1477 ], ":" => [ 9, \&_action_opcode_1477 ], },
	# [3076] opcode : set "[inline_const]" 3 "," "(" ix ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1478 ], ":" => [ 9, \&_action_opcode_1478 ], },
	# [3077] opcode : set "[inline_const]" 3 "," "(" ix "+"
	{ "!" => [ 14, 3078 ], "+" => [ 14, 3078 ], "-" => [ 14, 3078 ], __else__ => [ 14, 3078 ], "~" => [ 14, 3078 ], },
	# [3078] opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 3079, },
	# [3079] opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1479 ], "," => 3080, ":" => [ 9, \&_action_opcode_1479 ], },
	# [3080] opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 3081, b => 3082, c => 3083, d => 3084, e => 3085, h => 3086, l => 3087, },
	# [3081] opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1480 ], ":" => [ 9, \&_action_opcode_1480 ], },
	# [3082] opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1481 ], ":" => [ 9, \&_action_opcode_1481 ], },
	# [3083] opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1482 ], ":" => [ 9, \&_action_opcode_1482 ], },
	# [3084] opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1483 ], ":" => [ 9, \&_action_opcode_1483 ], },
	# [3085] opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1484 ], ":" => [ 9, \&_action_opcode_1484 ], },
	# [3086] opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1485 ], ":" => [ 9, \&_action_opcode_1485 ], },
	# [3087] opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1486 ], ":" => [ 9, \&_action_opcode_1486 ], },
	# [3088] opcode : set "[inline_const]" 3 "," "(" ix "-"
	{ "!" => [ 16, 3089 ], "+" => [ 16, 3089 ], "-" => [ 16, 3089 ], __else__ => [ 16, 3089 ], "~" => [ 16, 3089 ], },
	# [3089] opcode : set "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 3090, },
	# [3090] opcode : set "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1479 ], "," => 3091, ":" => [ 9, \&_action_opcode_1479 ], },
	# [3091] opcode : set "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 3092, b => 3093, c => 3094, d => 3095, e => 3096, h => 3097, l => 3098, },
	# [3092] opcode : set "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1480 ], ":" => [ 9, \&_action_opcode_1480 ], },
	# [3093] opcode : set "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1481 ], ":" => [ 9, \&_action_opcode_1481 ], },
	# [3094] opcode : set "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1482 ], ":" => [ 9, \&_action_opcode_1482 ], },
	# [3095] opcode : set "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1483 ], ":" => [ 9, \&_action_opcode_1483 ], },
	# [3096] opcode : set "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1484 ], ":" => [ 9, \&_action_opcode_1484 ], },
	# [3097] opcode : set "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1485 ], ":" => [ 9, \&_action_opcode_1485 ], },
	# [3098] opcode : set "[inline_const]" 3 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1486 ], ":" => [ 9, \&_action_opcode_1486 ], },
	# [3099] opcode : set "[inline_const]" 3 "," "(" iy
	{ ")" => 3100, "+" => 3109, "-" => 3120, },
	# [3100] opcode : set "[inline_const]" 3 "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_1487 ], "," => 3101, ":" => [ 9, \&_action_opcode_1487 ], },
	# [3101] opcode : set "[inline_const]" 3 "," "(" iy ")" ","
	{ a => 3102, b => 3103, c => 3104, d => 3105, e => 3106, h => 3107, l => 3108, },
	# [3102] opcode : set "[inline_const]" 3 "," "(" iy ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1488 ], ":" => [ 9, \&_action_opcode_1488 ], },
	# [3103] opcode : set "[inline_const]" 3 "," "(" iy ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1489 ], ":" => [ 9, \&_action_opcode_1489 ], },
	# [3104] opcode : set "[inline_const]" 3 "," "(" iy ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1490 ], ":" => [ 9, \&_action_opcode_1490 ], },
	# [3105] opcode : set "[inline_const]" 3 "," "(" iy ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1491 ], ":" => [ 9, \&_action_opcode_1491 ], },
	# [3106] opcode : set "[inline_const]" 3 "," "(" iy ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1492 ], ":" => [ 9, \&_action_opcode_1492 ], },
	# [3107] opcode : set "[inline_const]" 3 "," "(" iy ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1493 ], ":" => [ 9, \&_action_opcode_1493 ], },
	# [3108] opcode : set "[inline_const]" 3 "," "(" iy ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1494 ], ":" => [ 9, \&_action_opcode_1494 ], },
	# [3109] opcode : set "[inline_const]" 3 "," "(" iy "+"
	{ "!" => [ 14, 3110 ], "+" => [ 14, 3110 ], "-" => [ 14, 3110 ], __else__ => [ 14, 3110 ], "~" => [ 14, 3110 ], },
	# [3110] opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 3111, },
	# [3111] opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1495 ], "," => 3112, ":" => [ 9, \&_action_opcode_1495 ], },
	# [3112] opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 3113, b => 3114, c => 3115, d => 3116, e => 3117, h => 3118, l => 3119, },
	# [3113] opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1496 ], ":" => [ 9, \&_action_opcode_1496 ], },
	# [3114] opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1497 ], ":" => [ 9, \&_action_opcode_1497 ], },
	# [3115] opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1498 ], ":" => [ 9, \&_action_opcode_1498 ], },
	# [3116] opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1499 ], ":" => [ 9, \&_action_opcode_1499 ], },
	# [3117] opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1500 ], ":" => [ 9, \&_action_opcode_1500 ], },
	# [3118] opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1501 ], ":" => [ 9, \&_action_opcode_1501 ], },
	# [3119] opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1502 ], ":" => [ 9, \&_action_opcode_1502 ], },
	# [3120] opcode : set "[inline_const]" 3 "," "(" iy "-"
	{ "!" => [ 16, 3121 ], "+" => [ 16, 3121 ], "-" => [ 16, 3121 ], __else__ => [ 16, 3121 ], "~" => [ 16, 3121 ], },
	# [3121] opcode : set "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 3122, },
	# [3122] opcode : set "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1495 ], "," => 3123, ":" => [ 9, \&_action_opcode_1495 ], },
	# [3123] opcode : set "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 3124, b => 3125, c => 3126, d => 3127, e => 3128, h => 3129, l => 3130, },
	# [3124] opcode : set "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1496 ], ":" => [ 9, \&_action_opcode_1496 ], },
	# [3125] opcode : set "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1497 ], ":" => [ 9, \&_action_opcode_1497 ], },
	# [3126] opcode : set "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1498 ], ":" => [ 9, \&_action_opcode_1498 ], },
	# [3127] opcode : set "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1499 ], ":" => [ 9, \&_action_opcode_1499 ], },
	# [3128] opcode : set "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1500 ], ":" => [ 9, \&_action_opcode_1500 ], },
	# [3129] opcode : set "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1501 ], ":" => [ 9, \&_action_opcode_1501 ], },
	# [3130] opcode : set "[inline_const]" 3 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1502 ], ":" => [ 9, \&_action_opcode_1502 ], },
	# [3131] opcode : set "[inline_const]" 3 "," a
	{ "\n" => [ 9, \&_action_opcode_1503 ], ":" => [ 9, \&_action_opcode_1503 ], },
	# [3132] opcode : set "[inline_const]" 3 "," b
	{ "\n" => [ 9, \&_action_opcode_1504 ], ":" => [ 9, \&_action_opcode_1504 ], },
	# [3133] opcode : set "[inline_const]" 3 "," c
	{ "\n" => [ 9, \&_action_opcode_1505 ], ":" => [ 9, \&_action_opcode_1505 ], },
	# [3134] opcode : set "[inline_const]" 3 "," d
	{ "\n" => [ 9, \&_action_opcode_1506 ], ":" => [ 9, \&_action_opcode_1506 ], },
	# [3135] opcode : set "[inline_const]" 3 "," e
	{ "\n" => [ 9, \&_action_opcode_1507 ], ":" => [ 9, \&_action_opcode_1507 ], },
	# [3136] opcode : set "[inline_const]" 3 "," h
	{ "\n" => [ 9, \&_action_opcode_1508 ], ":" => [ 9, \&_action_opcode_1508 ], },
	# [3137] opcode : set "[inline_const]" 3 "," l
	{ "\n" => [ 9, \&_action_opcode_1509 ], ":" => [ 9, \&_action_opcode_1509 ], },
	# [3138] opcode : set "[inline_const]" 4
	{ "," => 3139, },
	# [3139] opcode : set "[inline_const]" 4 ","
	{ "(" => 3140, a => 3207, b => 3208, c => 3209, d => 3210, e => 3211, h => 3212, l => 3213, },
	# [3140] opcode : set "[inline_const]" 4 "," "("
	{ hl => 3141, ix => 3143, iy => 3175, },
	# [3141] opcode : set "[inline_const]" 4 "," "(" hl
	{ ")" => 3142, },
	# [3142] opcode : set "[inline_const]" 4 "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_1510 ], ":" => [ 9, \&_action_opcode_1510 ], },
	# [3143] opcode : set "[inline_const]" 4 "," "(" ix
	{ ")" => 3144, "+" => 3153, "-" => 3164, },
	# [3144] opcode : set "[inline_const]" 4 "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_1511 ], "," => 3145, ":" => [ 9, \&_action_opcode_1511 ], },
	# [3145] opcode : set "[inline_const]" 4 "," "(" ix ")" ","
	{ a => 3146, b => 3147, c => 3148, d => 3149, e => 3150, h => 3151, l => 3152, },
	# [3146] opcode : set "[inline_const]" 4 "," "(" ix ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1512 ], ":" => [ 9, \&_action_opcode_1512 ], },
	# [3147] opcode : set "[inline_const]" 4 "," "(" ix ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1513 ], ":" => [ 9, \&_action_opcode_1513 ], },
	# [3148] opcode : set "[inline_const]" 4 "," "(" ix ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1514 ], ":" => [ 9, \&_action_opcode_1514 ], },
	# [3149] opcode : set "[inline_const]" 4 "," "(" ix ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1515 ], ":" => [ 9, \&_action_opcode_1515 ], },
	# [3150] opcode : set "[inline_const]" 4 "," "(" ix ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1516 ], ":" => [ 9, \&_action_opcode_1516 ], },
	# [3151] opcode : set "[inline_const]" 4 "," "(" ix ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1517 ], ":" => [ 9, \&_action_opcode_1517 ], },
	# [3152] opcode : set "[inline_const]" 4 "," "(" ix ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1518 ], ":" => [ 9, \&_action_opcode_1518 ], },
	# [3153] opcode : set "[inline_const]" 4 "," "(" ix "+"
	{ "!" => [ 14, 3154 ], "+" => [ 14, 3154 ], "-" => [ 14, 3154 ], __else__ => [ 14, 3154 ], "~" => [ 14, 3154 ], },
	# [3154] opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 3155, },
	# [3155] opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1519 ], "," => 3156, ":" => [ 9, \&_action_opcode_1519 ], },
	# [3156] opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 3157, b => 3158, c => 3159, d => 3160, e => 3161, h => 3162, l => 3163, },
	# [3157] opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1520 ], ":" => [ 9, \&_action_opcode_1520 ], },
	# [3158] opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1521 ], ":" => [ 9, \&_action_opcode_1521 ], },
	# [3159] opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1522 ], ":" => [ 9, \&_action_opcode_1522 ], },
	# [3160] opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1523 ], ":" => [ 9, \&_action_opcode_1523 ], },
	# [3161] opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1524 ], ":" => [ 9, \&_action_opcode_1524 ], },
	# [3162] opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1525 ], ":" => [ 9, \&_action_opcode_1525 ], },
	# [3163] opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1526 ], ":" => [ 9, \&_action_opcode_1526 ], },
	# [3164] opcode : set "[inline_const]" 4 "," "(" ix "-"
	{ "!" => [ 16, 3165 ], "+" => [ 16, 3165 ], "-" => [ 16, 3165 ], __else__ => [ 16, 3165 ], "~" => [ 16, 3165 ], },
	# [3165] opcode : set "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 3166, },
	# [3166] opcode : set "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1519 ], "," => 3167, ":" => [ 9, \&_action_opcode_1519 ], },
	# [3167] opcode : set "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 3168, b => 3169, c => 3170, d => 3171, e => 3172, h => 3173, l => 3174, },
	# [3168] opcode : set "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1520 ], ":" => [ 9, \&_action_opcode_1520 ], },
	# [3169] opcode : set "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1521 ], ":" => [ 9, \&_action_opcode_1521 ], },
	# [3170] opcode : set "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1522 ], ":" => [ 9, \&_action_opcode_1522 ], },
	# [3171] opcode : set "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1523 ], ":" => [ 9, \&_action_opcode_1523 ], },
	# [3172] opcode : set "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1524 ], ":" => [ 9, \&_action_opcode_1524 ], },
	# [3173] opcode : set "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1525 ], ":" => [ 9, \&_action_opcode_1525 ], },
	# [3174] opcode : set "[inline_const]" 4 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1526 ], ":" => [ 9, \&_action_opcode_1526 ], },
	# [3175] opcode : set "[inline_const]" 4 "," "(" iy
	{ ")" => 3176, "+" => 3185, "-" => 3196, },
	# [3176] opcode : set "[inline_const]" 4 "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_1527 ], "," => 3177, ":" => [ 9, \&_action_opcode_1527 ], },
	# [3177] opcode : set "[inline_const]" 4 "," "(" iy ")" ","
	{ a => 3178, b => 3179, c => 3180, d => 3181, e => 3182, h => 3183, l => 3184, },
	# [3178] opcode : set "[inline_const]" 4 "," "(" iy ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1528 ], ":" => [ 9, \&_action_opcode_1528 ], },
	# [3179] opcode : set "[inline_const]" 4 "," "(" iy ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1529 ], ":" => [ 9, \&_action_opcode_1529 ], },
	# [3180] opcode : set "[inline_const]" 4 "," "(" iy ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1530 ], ":" => [ 9, \&_action_opcode_1530 ], },
	# [3181] opcode : set "[inline_const]" 4 "," "(" iy ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1531 ], ":" => [ 9, \&_action_opcode_1531 ], },
	# [3182] opcode : set "[inline_const]" 4 "," "(" iy ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1532 ], ":" => [ 9, \&_action_opcode_1532 ], },
	# [3183] opcode : set "[inline_const]" 4 "," "(" iy ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1533 ], ":" => [ 9, \&_action_opcode_1533 ], },
	# [3184] opcode : set "[inline_const]" 4 "," "(" iy ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1534 ], ":" => [ 9, \&_action_opcode_1534 ], },
	# [3185] opcode : set "[inline_const]" 4 "," "(" iy "+"
	{ "!" => [ 14, 3186 ], "+" => [ 14, 3186 ], "-" => [ 14, 3186 ], __else__ => [ 14, 3186 ], "~" => [ 14, 3186 ], },
	# [3186] opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 3187, },
	# [3187] opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1535 ], "," => 3188, ":" => [ 9, \&_action_opcode_1535 ], },
	# [3188] opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 3189, b => 3190, c => 3191, d => 3192, e => 3193, h => 3194, l => 3195, },
	# [3189] opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1536 ], ":" => [ 9, \&_action_opcode_1536 ], },
	# [3190] opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1537 ], ":" => [ 9, \&_action_opcode_1537 ], },
	# [3191] opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1538 ], ":" => [ 9, \&_action_opcode_1538 ], },
	# [3192] opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1539 ], ":" => [ 9, \&_action_opcode_1539 ], },
	# [3193] opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1540 ], ":" => [ 9, \&_action_opcode_1540 ], },
	# [3194] opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1541 ], ":" => [ 9, \&_action_opcode_1541 ], },
	# [3195] opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1542 ], ":" => [ 9, \&_action_opcode_1542 ], },
	# [3196] opcode : set "[inline_const]" 4 "," "(" iy "-"
	{ "!" => [ 16, 3197 ], "+" => [ 16, 3197 ], "-" => [ 16, 3197 ], __else__ => [ 16, 3197 ], "~" => [ 16, 3197 ], },
	# [3197] opcode : set "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 3198, },
	# [3198] opcode : set "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1535 ], "," => 3199, ":" => [ 9, \&_action_opcode_1535 ], },
	# [3199] opcode : set "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 3200, b => 3201, c => 3202, d => 3203, e => 3204, h => 3205, l => 3206, },
	# [3200] opcode : set "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1536 ], ":" => [ 9, \&_action_opcode_1536 ], },
	# [3201] opcode : set "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1537 ], ":" => [ 9, \&_action_opcode_1537 ], },
	# [3202] opcode : set "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1538 ], ":" => [ 9, \&_action_opcode_1538 ], },
	# [3203] opcode : set "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1539 ], ":" => [ 9, \&_action_opcode_1539 ], },
	# [3204] opcode : set "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1540 ], ":" => [ 9, \&_action_opcode_1540 ], },
	# [3205] opcode : set "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1541 ], ":" => [ 9, \&_action_opcode_1541 ], },
	# [3206] opcode : set "[inline_const]" 4 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1542 ], ":" => [ 9, \&_action_opcode_1542 ], },
	# [3207] opcode : set "[inline_const]" 4 "," a
	{ "\n" => [ 9, \&_action_opcode_1543 ], ":" => [ 9, \&_action_opcode_1543 ], },
	# [3208] opcode : set "[inline_const]" 4 "," b
	{ "\n" => [ 9, \&_action_opcode_1544 ], ":" => [ 9, \&_action_opcode_1544 ], },
	# [3209] opcode : set "[inline_const]" 4 "," c
	{ "\n" => [ 9, \&_action_opcode_1545 ], ":" => [ 9, \&_action_opcode_1545 ], },
	# [3210] opcode : set "[inline_const]" 4 "," d
	{ "\n" => [ 9, \&_action_opcode_1546 ], ":" => [ 9, \&_action_opcode_1546 ], },
	# [3211] opcode : set "[inline_const]" 4 "," e
	{ "\n" => [ 9, \&_action_opcode_1547 ], ":" => [ 9, \&_action_opcode_1547 ], },
	# [3212] opcode : set "[inline_const]" 4 "," h
	{ "\n" => [ 9, \&_action_opcode_1548 ], ":" => [ 9, \&_action_opcode_1548 ], },
	# [3213] opcode : set "[inline_const]" 4 "," l
	{ "\n" => [ 9, \&_action_opcode_1549 ], ":" => [ 9, \&_action_opcode_1549 ], },
	# [3214] opcode : set "[inline_const]" 5
	{ "," => 3215, },
	# [3215] opcode : set "[inline_const]" 5 ","
	{ "(" => 3216, a => 3283, b => 3284, c => 3285, d => 3286, e => 3287, h => 3288, l => 3289, },
	# [3216] opcode : set "[inline_const]" 5 "," "("
	{ hl => 3217, ix => 3219, iy => 3251, },
	# [3217] opcode : set "[inline_const]" 5 "," "(" hl
	{ ")" => 3218, },
	# [3218] opcode : set "[inline_const]" 5 "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_1550 ], ":" => [ 9, \&_action_opcode_1550 ], },
	# [3219] opcode : set "[inline_const]" 5 "," "(" ix
	{ ")" => 3220, "+" => 3229, "-" => 3240, },
	# [3220] opcode : set "[inline_const]" 5 "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_1551 ], "," => 3221, ":" => [ 9, \&_action_opcode_1551 ], },
	# [3221] opcode : set "[inline_const]" 5 "," "(" ix ")" ","
	{ a => 3222, b => 3223, c => 3224, d => 3225, e => 3226, h => 3227, l => 3228, },
	# [3222] opcode : set "[inline_const]" 5 "," "(" ix ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1552 ], ":" => [ 9, \&_action_opcode_1552 ], },
	# [3223] opcode : set "[inline_const]" 5 "," "(" ix ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1553 ], ":" => [ 9, \&_action_opcode_1553 ], },
	# [3224] opcode : set "[inline_const]" 5 "," "(" ix ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1554 ], ":" => [ 9, \&_action_opcode_1554 ], },
	# [3225] opcode : set "[inline_const]" 5 "," "(" ix ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1555 ], ":" => [ 9, \&_action_opcode_1555 ], },
	# [3226] opcode : set "[inline_const]" 5 "," "(" ix ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1556 ], ":" => [ 9, \&_action_opcode_1556 ], },
	# [3227] opcode : set "[inline_const]" 5 "," "(" ix ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1557 ], ":" => [ 9, \&_action_opcode_1557 ], },
	# [3228] opcode : set "[inline_const]" 5 "," "(" ix ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1558 ], ":" => [ 9, \&_action_opcode_1558 ], },
	# [3229] opcode : set "[inline_const]" 5 "," "(" ix "+"
	{ "!" => [ 14, 3230 ], "+" => [ 14, 3230 ], "-" => [ 14, 3230 ], __else__ => [ 14, 3230 ], "~" => [ 14, 3230 ], },
	# [3230] opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 3231, },
	# [3231] opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1559 ], "," => 3232, ":" => [ 9, \&_action_opcode_1559 ], },
	# [3232] opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 3233, b => 3234, c => 3235, d => 3236, e => 3237, h => 3238, l => 3239, },
	# [3233] opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1560 ], ":" => [ 9, \&_action_opcode_1560 ], },
	# [3234] opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1561 ], ":" => [ 9, \&_action_opcode_1561 ], },
	# [3235] opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1562 ], ":" => [ 9, \&_action_opcode_1562 ], },
	# [3236] opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1563 ], ":" => [ 9, \&_action_opcode_1563 ], },
	# [3237] opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1564 ], ":" => [ 9, \&_action_opcode_1564 ], },
	# [3238] opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1565 ], ":" => [ 9, \&_action_opcode_1565 ], },
	# [3239] opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1566 ], ":" => [ 9, \&_action_opcode_1566 ], },
	# [3240] opcode : set "[inline_const]" 5 "," "(" ix "-"
	{ "!" => [ 16, 3241 ], "+" => [ 16, 3241 ], "-" => [ 16, 3241 ], __else__ => [ 16, 3241 ], "~" => [ 16, 3241 ], },
	# [3241] opcode : set "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 3242, },
	# [3242] opcode : set "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1559 ], "," => 3243, ":" => [ 9, \&_action_opcode_1559 ], },
	# [3243] opcode : set "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 3244, b => 3245, c => 3246, d => 3247, e => 3248, h => 3249, l => 3250, },
	# [3244] opcode : set "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1560 ], ":" => [ 9, \&_action_opcode_1560 ], },
	# [3245] opcode : set "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1561 ], ":" => [ 9, \&_action_opcode_1561 ], },
	# [3246] opcode : set "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1562 ], ":" => [ 9, \&_action_opcode_1562 ], },
	# [3247] opcode : set "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1563 ], ":" => [ 9, \&_action_opcode_1563 ], },
	# [3248] opcode : set "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1564 ], ":" => [ 9, \&_action_opcode_1564 ], },
	# [3249] opcode : set "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1565 ], ":" => [ 9, \&_action_opcode_1565 ], },
	# [3250] opcode : set "[inline_const]" 5 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1566 ], ":" => [ 9, \&_action_opcode_1566 ], },
	# [3251] opcode : set "[inline_const]" 5 "," "(" iy
	{ ")" => 3252, "+" => 3261, "-" => 3272, },
	# [3252] opcode : set "[inline_const]" 5 "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_1567 ], "," => 3253, ":" => [ 9, \&_action_opcode_1567 ], },
	# [3253] opcode : set "[inline_const]" 5 "," "(" iy ")" ","
	{ a => 3254, b => 3255, c => 3256, d => 3257, e => 3258, h => 3259, l => 3260, },
	# [3254] opcode : set "[inline_const]" 5 "," "(" iy ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1568 ], ":" => [ 9, \&_action_opcode_1568 ], },
	# [3255] opcode : set "[inline_const]" 5 "," "(" iy ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1569 ], ":" => [ 9, \&_action_opcode_1569 ], },
	# [3256] opcode : set "[inline_const]" 5 "," "(" iy ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1570 ], ":" => [ 9, \&_action_opcode_1570 ], },
	# [3257] opcode : set "[inline_const]" 5 "," "(" iy ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1571 ], ":" => [ 9, \&_action_opcode_1571 ], },
	# [3258] opcode : set "[inline_const]" 5 "," "(" iy ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1572 ], ":" => [ 9, \&_action_opcode_1572 ], },
	# [3259] opcode : set "[inline_const]" 5 "," "(" iy ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1573 ], ":" => [ 9, \&_action_opcode_1573 ], },
	# [3260] opcode : set "[inline_const]" 5 "," "(" iy ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1574 ], ":" => [ 9, \&_action_opcode_1574 ], },
	# [3261] opcode : set "[inline_const]" 5 "," "(" iy "+"
	{ "!" => [ 14, 3262 ], "+" => [ 14, 3262 ], "-" => [ 14, 3262 ], __else__ => [ 14, 3262 ], "~" => [ 14, 3262 ], },
	# [3262] opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 3263, },
	# [3263] opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1575 ], "," => 3264, ":" => [ 9, \&_action_opcode_1575 ], },
	# [3264] opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 3265, b => 3266, c => 3267, d => 3268, e => 3269, h => 3270, l => 3271, },
	# [3265] opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1576 ], ":" => [ 9, \&_action_opcode_1576 ], },
	# [3266] opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1577 ], ":" => [ 9, \&_action_opcode_1577 ], },
	# [3267] opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1578 ], ":" => [ 9, \&_action_opcode_1578 ], },
	# [3268] opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1579 ], ":" => [ 9, \&_action_opcode_1579 ], },
	# [3269] opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1580 ], ":" => [ 9, \&_action_opcode_1580 ], },
	# [3270] opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1581 ], ":" => [ 9, \&_action_opcode_1581 ], },
	# [3271] opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1582 ], ":" => [ 9, \&_action_opcode_1582 ], },
	# [3272] opcode : set "[inline_const]" 5 "," "(" iy "-"
	{ "!" => [ 16, 3273 ], "+" => [ 16, 3273 ], "-" => [ 16, 3273 ], __else__ => [ 16, 3273 ], "~" => [ 16, 3273 ], },
	# [3273] opcode : set "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 3274, },
	# [3274] opcode : set "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1575 ], "," => 3275, ":" => [ 9, \&_action_opcode_1575 ], },
	# [3275] opcode : set "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 3276, b => 3277, c => 3278, d => 3279, e => 3280, h => 3281, l => 3282, },
	# [3276] opcode : set "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1576 ], ":" => [ 9, \&_action_opcode_1576 ], },
	# [3277] opcode : set "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1577 ], ":" => [ 9, \&_action_opcode_1577 ], },
	# [3278] opcode : set "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1578 ], ":" => [ 9, \&_action_opcode_1578 ], },
	# [3279] opcode : set "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1579 ], ":" => [ 9, \&_action_opcode_1579 ], },
	# [3280] opcode : set "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1580 ], ":" => [ 9, \&_action_opcode_1580 ], },
	# [3281] opcode : set "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1581 ], ":" => [ 9, \&_action_opcode_1581 ], },
	# [3282] opcode : set "[inline_const]" 5 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1582 ], ":" => [ 9, \&_action_opcode_1582 ], },
	# [3283] opcode : set "[inline_const]" 5 "," a
	{ "\n" => [ 9, \&_action_opcode_1583 ], ":" => [ 9, \&_action_opcode_1583 ], },
	# [3284] opcode : set "[inline_const]" 5 "," b
	{ "\n" => [ 9, \&_action_opcode_1584 ], ":" => [ 9, \&_action_opcode_1584 ], },
	# [3285] opcode : set "[inline_const]" 5 "," c
	{ "\n" => [ 9, \&_action_opcode_1585 ], ":" => [ 9, \&_action_opcode_1585 ], },
	# [3286] opcode : set "[inline_const]" 5 "," d
	{ "\n" => [ 9, \&_action_opcode_1586 ], ":" => [ 9, \&_action_opcode_1586 ], },
	# [3287] opcode : set "[inline_const]" 5 "," e
	{ "\n" => [ 9, \&_action_opcode_1587 ], ":" => [ 9, \&_action_opcode_1587 ], },
	# [3288] opcode : set "[inline_const]" 5 "," h
	{ "\n" => [ 9, \&_action_opcode_1588 ], ":" => [ 9, \&_action_opcode_1588 ], },
	# [3289] opcode : set "[inline_const]" 5 "," l
	{ "\n" => [ 9, \&_action_opcode_1589 ], ":" => [ 9, \&_action_opcode_1589 ], },
	# [3290] opcode : set "[inline_const]" 6
	{ "," => 3291, },
	# [3291] opcode : set "[inline_const]" 6 ","
	{ "(" => 3292, a => 3359, b => 3360, c => 3361, d => 3362, e => 3363, h => 3364, l => 3365, },
	# [3292] opcode : set "[inline_const]" 6 "," "("
	{ hl => 3293, ix => 3295, iy => 3327, },
	# [3293] opcode : set "[inline_const]" 6 "," "(" hl
	{ ")" => 3294, },
	# [3294] opcode : set "[inline_const]" 6 "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_1590 ], ":" => [ 9, \&_action_opcode_1590 ], },
	# [3295] opcode : set "[inline_const]" 6 "," "(" ix
	{ ")" => 3296, "+" => 3305, "-" => 3316, },
	# [3296] opcode : set "[inline_const]" 6 "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_1591 ], "," => 3297, ":" => [ 9, \&_action_opcode_1591 ], },
	# [3297] opcode : set "[inline_const]" 6 "," "(" ix ")" ","
	{ a => 3298, b => 3299, c => 3300, d => 3301, e => 3302, h => 3303, l => 3304, },
	# [3298] opcode : set "[inline_const]" 6 "," "(" ix ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1592 ], ":" => [ 9, \&_action_opcode_1592 ], },
	# [3299] opcode : set "[inline_const]" 6 "," "(" ix ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1593 ], ":" => [ 9, \&_action_opcode_1593 ], },
	# [3300] opcode : set "[inline_const]" 6 "," "(" ix ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1594 ], ":" => [ 9, \&_action_opcode_1594 ], },
	# [3301] opcode : set "[inline_const]" 6 "," "(" ix ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1595 ], ":" => [ 9, \&_action_opcode_1595 ], },
	# [3302] opcode : set "[inline_const]" 6 "," "(" ix ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1596 ], ":" => [ 9, \&_action_opcode_1596 ], },
	# [3303] opcode : set "[inline_const]" 6 "," "(" ix ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1597 ], ":" => [ 9, \&_action_opcode_1597 ], },
	# [3304] opcode : set "[inline_const]" 6 "," "(" ix ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1598 ], ":" => [ 9, \&_action_opcode_1598 ], },
	# [3305] opcode : set "[inline_const]" 6 "," "(" ix "+"
	{ "!" => [ 14, 3306 ], "+" => [ 14, 3306 ], "-" => [ 14, 3306 ], __else__ => [ 14, 3306 ], "~" => [ 14, 3306 ], },
	# [3306] opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 3307, },
	# [3307] opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1599 ], "," => 3308, ":" => [ 9, \&_action_opcode_1599 ], },
	# [3308] opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 3309, b => 3310, c => 3311, d => 3312, e => 3313, h => 3314, l => 3315, },
	# [3309] opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1600 ], ":" => [ 9, \&_action_opcode_1600 ], },
	# [3310] opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1601 ], ":" => [ 9, \&_action_opcode_1601 ], },
	# [3311] opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1602 ], ":" => [ 9, \&_action_opcode_1602 ], },
	# [3312] opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1603 ], ":" => [ 9, \&_action_opcode_1603 ], },
	# [3313] opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1604 ], ":" => [ 9, \&_action_opcode_1604 ], },
	# [3314] opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1605 ], ":" => [ 9, \&_action_opcode_1605 ], },
	# [3315] opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1606 ], ":" => [ 9, \&_action_opcode_1606 ], },
	# [3316] opcode : set "[inline_const]" 6 "," "(" ix "-"
	{ "!" => [ 16, 3317 ], "+" => [ 16, 3317 ], "-" => [ 16, 3317 ], __else__ => [ 16, 3317 ], "~" => [ 16, 3317 ], },
	# [3317] opcode : set "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 3318, },
	# [3318] opcode : set "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1599 ], "," => 3319, ":" => [ 9, \&_action_opcode_1599 ], },
	# [3319] opcode : set "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 3320, b => 3321, c => 3322, d => 3323, e => 3324, h => 3325, l => 3326, },
	# [3320] opcode : set "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1600 ], ":" => [ 9, \&_action_opcode_1600 ], },
	# [3321] opcode : set "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1601 ], ":" => [ 9, \&_action_opcode_1601 ], },
	# [3322] opcode : set "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1602 ], ":" => [ 9, \&_action_opcode_1602 ], },
	# [3323] opcode : set "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1603 ], ":" => [ 9, \&_action_opcode_1603 ], },
	# [3324] opcode : set "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1604 ], ":" => [ 9, \&_action_opcode_1604 ], },
	# [3325] opcode : set "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1605 ], ":" => [ 9, \&_action_opcode_1605 ], },
	# [3326] opcode : set "[inline_const]" 6 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1606 ], ":" => [ 9, \&_action_opcode_1606 ], },
	# [3327] opcode : set "[inline_const]" 6 "," "(" iy
	{ ")" => 3328, "+" => 3337, "-" => 3348, },
	# [3328] opcode : set "[inline_const]" 6 "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_1607 ], "," => 3329, ":" => [ 9, \&_action_opcode_1607 ], },
	# [3329] opcode : set "[inline_const]" 6 "," "(" iy ")" ","
	{ a => 3330, b => 3331, c => 3332, d => 3333, e => 3334, h => 3335, l => 3336, },
	# [3330] opcode : set "[inline_const]" 6 "," "(" iy ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1608 ], ":" => [ 9, \&_action_opcode_1608 ], },
	# [3331] opcode : set "[inline_const]" 6 "," "(" iy ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1609 ], ":" => [ 9, \&_action_opcode_1609 ], },
	# [3332] opcode : set "[inline_const]" 6 "," "(" iy ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1610 ], ":" => [ 9, \&_action_opcode_1610 ], },
	# [3333] opcode : set "[inline_const]" 6 "," "(" iy ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1611 ], ":" => [ 9, \&_action_opcode_1611 ], },
	# [3334] opcode : set "[inline_const]" 6 "," "(" iy ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1612 ], ":" => [ 9, \&_action_opcode_1612 ], },
	# [3335] opcode : set "[inline_const]" 6 "," "(" iy ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1613 ], ":" => [ 9, \&_action_opcode_1613 ], },
	# [3336] opcode : set "[inline_const]" 6 "," "(" iy ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1614 ], ":" => [ 9, \&_action_opcode_1614 ], },
	# [3337] opcode : set "[inline_const]" 6 "," "(" iy "+"
	{ "!" => [ 14, 3338 ], "+" => [ 14, 3338 ], "-" => [ 14, 3338 ], __else__ => [ 14, 3338 ], "~" => [ 14, 3338 ], },
	# [3338] opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 3339, },
	# [3339] opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1615 ], "," => 3340, ":" => [ 9, \&_action_opcode_1615 ], },
	# [3340] opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 3341, b => 3342, c => 3343, d => 3344, e => 3345, h => 3346, l => 3347, },
	# [3341] opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1616 ], ":" => [ 9, \&_action_opcode_1616 ], },
	# [3342] opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1617 ], ":" => [ 9, \&_action_opcode_1617 ], },
	# [3343] opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1618 ], ":" => [ 9, \&_action_opcode_1618 ], },
	# [3344] opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1619 ], ":" => [ 9, \&_action_opcode_1619 ], },
	# [3345] opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1620 ], ":" => [ 9, \&_action_opcode_1620 ], },
	# [3346] opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1621 ], ":" => [ 9, \&_action_opcode_1621 ], },
	# [3347] opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1622 ], ":" => [ 9, \&_action_opcode_1622 ], },
	# [3348] opcode : set "[inline_const]" 6 "," "(" iy "-"
	{ "!" => [ 16, 3349 ], "+" => [ 16, 3349 ], "-" => [ 16, 3349 ], __else__ => [ 16, 3349 ], "~" => [ 16, 3349 ], },
	# [3349] opcode : set "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 3350, },
	# [3350] opcode : set "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1615 ], "," => 3351, ":" => [ 9, \&_action_opcode_1615 ], },
	# [3351] opcode : set "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 3352, b => 3353, c => 3354, d => 3355, e => 3356, h => 3357, l => 3358, },
	# [3352] opcode : set "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1616 ], ":" => [ 9, \&_action_opcode_1616 ], },
	# [3353] opcode : set "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1617 ], ":" => [ 9, \&_action_opcode_1617 ], },
	# [3354] opcode : set "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1618 ], ":" => [ 9, \&_action_opcode_1618 ], },
	# [3355] opcode : set "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1619 ], ":" => [ 9, \&_action_opcode_1619 ], },
	# [3356] opcode : set "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1620 ], ":" => [ 9, \&_action_opcode_1620 ], },
	# [3357] opcode : set "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1621 ], ":" => [ 9, \&_action_opcode_1621 ], },
	# [3358] opcode : set "[inline_const]" 6 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1622 ], ":" => [ 9, \&_action_opcode_1622 ], },
	# [3359] opcode : set "[inline_const]" 6 "," a
	{ "\n" => [ 9, \&_action_opcode_1623 ], ":" => [ 9, \&_action_opcode_1623 ], },
	# [3360] opcode : set "[inline_const]" 6 "," b
	{ "\n" => [ 9, \&_action_opcode_1624 ], ":" => [ 9, \&_action_opcode_1624 ], },
	# [3361] opcode : set "[inline_const]" 6 "," c
	{ "\n" => [ 9, \&_action_opcode_1625 ], ":" => [ 9, \&_action_opcode_1625 ], },
	# [3362] opcode : set "[inline_const]" 6 "," d
	{ "\n" => [ 9, \&_action_opcode_1626 ], ":" => [ 9, \&_action_opcode_1626 ], },
	# [3363] opcode : set "[inline_const]" 6 "," e
	{ "\n" => [ 9, \&_action_opcode_1627 ], ":" => [ 9, \&_action_opcode_1627 ], },
	# [3364] opcode : set "[inline_const]" 6 "," h
	{ "\n" => [ 9, \&_action_opcode_1628 ], ":" => [ 9, \&_action_opcode_1628 ], },
	# [3365] opcode : set "[inline_const]" 6 "," l
	{ "\n" => [ 9, \&_action_opcode_1629 ], ":" => [ 9, \&_action_opcode_1629 ], },
	# [3366] opcode : set "[inline_const]" 7
	{ "," => 3367, },
	# [3367] opcode : set "[inline_const]" 7 ","
	{ "(" => 3368, a => 3435, b => 3436, c => 3437, d => 3438, e => 3439, h => 3440, l => 3441, },
	# [3368] opcode : set "[inline_const]" 7 "," "("
	{ hl => 3369, ix => 3371, iy => 3403, },
	# [3369] opcode : set "[inline_const]" 7 "," "(" hl
	{ ")" => 3370, },
	# [3370] opcode : set "[inline_const]" 7 "," "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_1630 ], ":" => [ 9, \&_action_opcode_1630 ], },
	# [3371] opcode : set "[inline_const]" 7 "," "(" ix
	{ ")" => 3372, "+" => 3381, "-" => 3392, },
	# [3372] opcode : set "[inline_const]" 7 "," "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_1631 ], "," => 3373, ":" => [ 9, \&_action_opcode_1631 ], },
	# [3373] opcode : set "[inline_const]" 7 "," "(" ix ")" ","
	{ a => 3374, b => 3375, c => 3376, d => 3377, e => 3378, h => 3379, l => 3380, },
	# [3374] opcode : set "[inline_const]" 7 "," "(" ix ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1632 ], ":" => [ 9, \&_action_opcode_1632 ], },
	# [3375] opcode : set "[inline_const]" 7 "," "(" ix ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1633 ], ":" => [ 9, \&_action_opcode_1633 ], },
	# [3376] opcode : set "[inline_const]" 7 "," "(" ix ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1634 ], ":" => [ 9, \&_action_opcode_1634 ], },
	# [3377] opcode : set "[inline_const]" 7 "," "(" ix ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1635 ], ":" => [ 9, \&_action_opcode_1635 ], },
	# [3378] opcode : set "[inline_const]" 7 "," "(" ix ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1636 ], ":" => [ 9, \&_action_opcode_1636 ], },
	# [3379] opcode : set "[inline_const]" 7 "," "(" ix ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1637 ], ":" => [ 9, \&_action_opcode_1637 ], },
	# [3380] opcode : set "[inline_const]" 7 "," "(" ix ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1638 ], ":" => [ 9, \&_action_opcode_1638 ], },
	# [3381] opcode : set "[inline_const]" 7 "," "(" ix "+"
	{ "!" => [ 14, 3382 ], "+" => [ 14, 3382 ], "-" => [ 14, 3382 ], __else__ => [ 14, 3382 ], "~" => [ 14, 3382 ], },
	# [3382] opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]"
	{ ")" => 3383, },
	# [3383] opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1639 ], "," => 3384, ":" => [ 9, \&_action_opcode_1639 ], },
	# [3384] opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 3385, b => 3386, c => 3387, d => 3388, e => 3389, h => 3390, l => 3391, },
	# [3385] opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1640 ], ":" => [ 9, \&_action_opcode_1640 ], },
	# [3386] opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1641 ], ":" => [ 9, \&_action_opcode_1641 ], },
	# [3387] opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1642 ], ":" => [ 9, \&_action_opcode_1642 ], },
	# [3388] opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1643 ], ":" => [ 9, \&_action_opcode_1643 ], },
	# [3389] opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1644 ], ":" => [ 9, \&_action_opcode_1644 ], },
	# [3390] opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1645 ], ":" => [ 9, \&_action_opcode_1645 ], },
	# [3391] opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1646 ], ":" => [ 9, \&_action_opcode_1646 ], },
	# [3392] opcode : set "[inline_const]" 7 "," "(" ix "-"
	{ "!" => [ 16, 3393 ], "+" => [ 16, 3393 ], "-" => [ 16, 3393 ], __else__ => [ 16, 3393 ], "~" => [ 16, 3393 ], },
	# [3393] opcode : set "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]"
	{ ")" => 3394, },
	# [3394] opcode : set "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1639 ], "," => 3395, ":" => [ 9, \&_action_opcode_1639 ], },
	# [3395] opcode : set "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 3396, b => 3397, c => 3398, d => 3399, e => 3400, h => 3401, l => 3402, },
	# [3396] opcode : set "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1640 ], ":" => [ 9, \&_action_opcode_1640 ], },
	# [3397] opcode : set "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1641 ], ":" => [ 9, \&_action_opcode_1641 ], },
	# [3398] opcode : set "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1642 ], ":" => [ 9, \&_action_opcode_1642 ], },
	# [3399] opcode : set "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1643 ], ":" => [ 9, \&_action_opcode_1643 ], },
	# [3400] opcode : set "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1644 ], ":" => [ 9, \&_action_opcode_1644 ], },
	# [3401] opcode : set "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1645 ], ":" => [ 9, \&_action_opcode_1645 ], },
	# [3402] opcode : set "[inline_const]" 7 "," "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1646 ], ":" => [ 9, \&_action_opcode_1646 ], },
	# [3403] opcode : set "[inline_const]" 7 "," "(" iy
	{ ")" => 3404, "+" => 3413, "-" => 3424, },
	# [3404] opcode : set "[inline_const]" 7 "," "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_1647 ], "," => 3405, ":" => [ 9, \&_action_opcode_1647 ], },
	# [3405] opcode : set "[inline_const]" 7 "," "(" iy ")" ","
	{ a => 3406, b => 3407, c => 3408, d => 3409, e => 3410, h => 3411, l => 3412, },
	# [3406] opcode : set "[inline_const]" 7 "," "(" iy ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1648 ], ":" => [ 9, \&_action_opcode_1648 ], },
	# [3407] opcode : set "[inline_const]" 7 "," "(" iy ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1649 ], ":" => [ 9, \&_action_opcode_1649 ], },
	# [3408] opcode : set "[inline_const]" 7 "," "(" iy ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1650 ], ":" => [ 9, \&_action_opcode_1650 ], },
	# [3409] opcode : set "[inline_const]" 7 "," "(" iy ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1651 ], ":" => [ 9, \&_action_opcode_1651 ], },
	# [3410] opcode : set "[inline_const]" 7 "," "(" iy ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1652 ], ":" => [ 9, \&_action_opcode_1652 ], },
	# [3411] opcode : set "[inline_const]" 7 "," "(" iy ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1653 ], ":" => [ 9, \&_action_opcode_1653 ], },
	# [3412] opcode : set "[inline_const]" 7 "," "(" iy ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1654 ], ":" => [ 9, \&_action_opcode_1654 ], },
	# [3413] opcode : set "[inline_const]" 7 "," "(" iy "+"
	{ "!" => [ 14, 3414 ], "+" => [ 14, 3414 ], "-" => [ 14, 3414 ], __else__ => [ 14, 3414 ], "~" => [ 14, 3414 ], },
	# [3414] opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]"
	{ ")" => 3415, },
	# [3415] opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1655 ], "," => 3416, ":" => [ 9, \&_action_opcode_1655 ], },
	# [3416] opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 3417, b => 3418, c => 3419, d => 3420, e => 3421, h => 3422, l => 3423, },
	# [3417] opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1656 ], ":" => [ 9, \&_action_opcode_1656 ], },
	# [3418] opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1657 ], ":" => [ 9, \&_action_opcode_1657 ], },
	# [3419] opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1658 ], ":" => [ 9, \&_action_opcode_1658 ], },
	# [3420] opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1659 ], ":" => [ 9, \&_action_opcode_1659 ], },
	# [3421] opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1660 ], ":" => [ 9, \&_action_opcode_1660 ], },
	# [3422] opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1661 ], ":" => [ 9, \&_action_opcode_1661 ], },
	# [3423] opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1662 ], ":" => [ 9, \&_action_opcode_1662 ], },
	# [3424] opcode : set "[inline_const]" 7 "," "(" iy "-"
	{ "!" => [ 16, 3425 ], "+" => [ 16, 3425 ], "-" => [ 16, 3425 ], __else__ => [ 16, 3425 ], "~" => [ 16, 3425 ], },
	# [3425] opcode : set "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]"
	{ ")" => 3426, },
	# [3426] opcode : set "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1655 ], "," => 3427, ":" => [ 9, \&_action_opcode_1655 ], },
	# [3427] opcode : set "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 3428, b => 3429, c => 3430, d => 3431, e => 3432, h => 3433, l => 3434, },
	# [3428] opcode : set "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1656 ], ":" => [ 9, \&_action_opcode_1656 ], },
	# [3429] opcode : set "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1657 ], ":" => [ 9, \&_action_opcode_1657 ], },
	# [3430] opcode : set "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1658 ], ":" => [ 9, \&_action_opcode_1658 ], },
	# [3431] opcode : set "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1659 ], ":" => [ 9, \&_action_opcode_1659 ], },
	# [3432] opcode : set "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1660 ], ":" => [ 9, \&_action_opcode_1660 ], },
	# [3433] opcode : set "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1661 ], ":" => [ 9, \&_action_opcode_1661 ], },
	# [3434] opcode : set "[inline_const]" 7 "," "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1662 ], ":" => [ 9, \&_action_opcode_1662 ], },
	# [3435] opcode : set "[inline_const]" 7 "," a
	{ "\n" => [ 9, \&_action_opcode_1663 ], ":" => [ 9, \&_action_opcode_1663 ], },
	# [3436] opcode : set "[inline_const]" 7 "," b
	{ "\n" => [ 9, \&_action_opcode_1664 ], ":" => [ 9, \&_action_opcode_1664 ], },
	# [3437] opcode : set "[inline_const]" 7 "," c
	{ "\n" => [ 9, \&_action_opcode_1665 ], ":" => [ 9, \&_action_opcode_1665 ], },
	# [3438] opcode : set "[inline_const]" 7 "," d
	{ "\n" => [ 9, \&_action_opcode_1666 ], ":" => [ 9, \&_action_opcode_1666 ], },
	# [3439] opcode : set "[inline_const]" 7 "," e
	{ "\n" => [ 9, \&_action_opcode_1667 ], ":" => [ 9, \&_action_opcode_1667 ], },
	# [3440] opcode : set "[inline_const]" 7 "," h
	{ "\n" => [ 9, \&_action_opcode_1668 ], ":" => [ 9, \&_action_opcode_1668 ], },
	# [3441] opcode : set "[inline_const]" 7 "," l
	{ "\n" => [ 9, \&_action_opcode_1669 ], ":" => [ 9, \&_action_opcode_1669 ], },
	# [3442] opcode : sla
	{ "(" => 3443, a => 3510, b => 3511, bc => 3512, c => 3513, d => 3514, de => 3515, e => 3516, h => 3517, hl => 3518, l => 3519, },
	# [3443] opcode : sla "("
	{ hl => 3444, ix => 3446, iy => 3478, },
	# [3444] opcode : sla "(" hl
	{ ")" => 3445, },
	# [3445] opcode : sla "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_1670 ], ":" => [ 9, \&_action_opcode_1670 ], },
	# [3446] opcode : sla "(" ix
	{ ")" => 3447, "+" => 3456, "-" => 3467, },
	# [3447] opcode : sla "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_1671 ], "," => 3448, ":" => [ 9, \&_action_opcode_1671 ], },
	# [3448] opcode : sla "(" ix ")" ","
	{ a => 3449, b => 3450, c => 3451, d => 3452, e => 3453, h => 3454, l => 3455, },
	# [3449] opcode : sla "(" ix ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1672 ], ":" => [ 9, \&_action_opcode_1672 ], },
	# [3450] opcode : sla "(" ix ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1673 ], ":" => [ 9, \&_action_opcode_1673 ], },
	# [3451] opcode : sla "(" ix ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1674 ], ":" => [ 9, \&_action_opcode_1674 ], },
	# [3452] opcode : sla "(" ix ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1675 ], ":" => [ 9, \&_action_opcode_1675 ], },
	# [3453] opcode : sla "(" ix ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1676 ], ":" => [ 9, \&_action_opcode_1676 ], },
	# [3454] opcode : sla "(" ix ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1677 ], ":" => [ 9, \&_action_opcode_1677 ], },
	# [3455] opcode : sla "(" ix ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1678 ], ":" => [ 9, \&_action_opcode_1678 ], },
	# [3456] opcode : sla "(" ix "+"
	{ "!" => [ 14, 3457 ], "+" => [ 14, 3457 ], "-" => [ 14, 3457 ], __else__ => [ 14, 3457 ], "~" => [ 14, 3457 ], },
	# [3457] opcode : sla "(" ix "+" "[expr_DIS]"
	{ ")" => 3458, },
	# [3458] opcode : sla "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1679 ], "," => 3459, ":" => [ 9, \&_action_opcode_1679 ], },
	# [3459] opcode : sla "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 3460, b => 3461, c => 3462, d => 3463, e => 3464, h => 3465, l => 3466, },
	# [3460] opcode : sla "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1680 ], ":" => [ 9, \&_action_opcode_1680 ], },
	# [3461] opcode : sla "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1681 ], ":" => [ 9, \&_action_opcode_1681 ], },
	# [3462] opcode : sla "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1682 ], ":" => [ 9, \&_action_opcode_1682 ], },
	# [3463] opcode : sla "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1683 ], ":" => [ 9, \&_action_opcode_1683 ], },
	# [3464] opcode : sla "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1684 ], ":" => [ 9, \&_action_opcode_1684 ], },
	# [3465] opcode : sla "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1685 ], ":" => [ 9, \&_action_opcode_1685 ], },
	# [3466] opcode : sla "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1686 ], ":" => [ 9, \&_action_opcode_1686 ], },
	# [3467] opcode : sla "(" ix "-"
	{ "!" => [ 16, 3468 ], "+" => [ 16, 3468 ], "-" => [ 16, 3468 ], __else__ => [ 16, 3468 ], "~" => [ 16, 3468 ], },
	# [3468] opcode : sla "(" ix "-" "[expr_NDIS]"
	{ ")" => 3469, },
	# [3469] opcode : sla "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1679 ], "," => 3470, ":" => [ 9, \&_action_opcode_1679 ], },
	# [3470] opcode : sla "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 3471, b => 3472, c => 3473, d => 3474, e => 3475, h => 3476, l => 3477, },
	# [3471] opcode : sla "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1680 ], ":" => [ 9, \&_action_opcode_1680 ], },
	# [3472] opcode : sla "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1681 ], ":" => [ 9, \&_action_opcode_1681 ], },
	# [3473] opcode : sla "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1682 ], ":" => [ 9, \&_action_opcode_1682 ], },
	# [3474] opcode : sla "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1683 ], ":" => [ 9, \&_action_opcode_1683 ], },
	# [3475] opcode : sla "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1684 ], ":" => [ 9, \&_action_opcode_1684 ], },
	# [3476] opcode : sla "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1685 ], ":" => [ 9, \&_action_opcode_1685 ], },
	# [3477] opcode : sla "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1686 ], ":" => [ 9, \&_action_opcode_1686 ], },
	# [3478] opcode : sla "(" iy
	{ ")" => 3479, "+" => 3488, "-" => 3499, },
	# [3479] opcode : sla "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_1687 ], "," => 3480, ":" => [ 9, \&_action_opcode_1687 ], },
	# [3480] opcode : sla "(" iy ")" ","
	{ a => 3481, b => 3482, c => 3483, d => 3484, e => 3485, h => 3486, l => 3487, },
	# [3481] opcode : sla "(" iy ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1688 ], ":" => [ 9, \&_action_opcode_1688 ], },
	# [3482] opcode : sla "(" iy ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1689 ], ":" => [ 9, \&_action_opcode_1689 ], },
	# [3483] opcode : sla "(" iy ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1690 ], ":" => [ 9, \&_action_opcode_1690 ], },
	# [3484] opcode : sla "(" iy ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1691 ], ":" => [ 9, \&_action_opcode_1691 ], },
	# [3485] opcode : sla "(" iy ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1692 ], ":" => [ 9, \&_action_opcode_1692 ], },
	# [3486] opcode : sla "(" iy ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1693 ], ":" => [ 9, \&_action_opcode_1693 ], },
	# [3487] opcode : sla "(" iy ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1694 ], ":" => [ 9, \&_action_opcode_1694 ], },
	# [3488] opcode : sla "(" iy "+"
	{ "!" => [ 14, 3489 ], "+" => [ 14, 3489 ], "-" => [ 14, 3489 ], __else__ => [ 14, 3489 ], "~" => [ 14, 3489 ], },
	# [3489] opcode : sla "(" iy "+" "[expr_DIS]"
	{ ")" => 3490, },
	# [3490] opcode : sla "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1695 ], "," => 3491, ":" => [ 9, \&_action_opcode_1695 ], },
	# [3491] opcode : sla "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 3492, b => 3493, c => 3494, d => 3495, e => 3496, h => 3497, l => 3498, },
	# [3492] opcode : sla "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1696 ], ":" => [ 9, \&_action_opcode_1696 ], },
	# [3493] opcode : sla "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1697 ], ":" => [ 9, \&_action_opcode_1697 ], },
	# [3494] opcode : sla "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1698 ], ":" => [ 9, \&_action_opcode_1698 ], },
	# [3495] opcode : sla "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1699 ], ":" => [ 9, \&_action_opcode_1699 ], },
	# [3496] opcode : sla "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1700 ], ":" => [ 9, \&_action_opcode_1700 ], },
	# [3497] opcode : sla "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1701 ], ":" => [ 9, \&_action_opcode_1701 ], },
	# [3498] opcode : sla "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1702 ], ":" => [ 9, \&_action_opcode_1702 ], },
	# [3499] opcode : sla "(" iy "-"
	{ "!" => [ 16, 3500 ], "+" => [ 16, 3500 ], "-" => [ 16, 3500 ], __else__ => [ 16, 3500 ], "~" => [ 16, 3500 ], },
	# [3500] opcode : sla "(" iy "-" "[expr_NDIS]"
	{ ")" => 3501, },
	# [3501] opcode : sla "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1695 ], "," => 3502, ":" => [ 9, \&_action_opcode_1695 ], },
	# [3502] opcode : sla "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 3503, b => 3504, c => 3505, d => 3506, e => 3507, h => 3508, l => 3509, },
	# [3503] opcode : sla "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1696 ], ":" => [ 9, \&_action_opcode_1696 ], },
	# [3504] opcode : sla "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1697 ], ":" => [ 9, \&_action_opcode_1697 ], },
	# [3505] opcode : sla "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1698 ], ":" => [ 9, \&_action_opcode_1698 ], },
	# [3506] opcode : sla "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1699 ], ":" => [ 9, \&_action_opcode_1699 ], },
	# [3507] opcode : sla "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1700 ], ":" => [ 9, \&_action_opcode_1700 ], },
	# [3508] opcode : sla "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1701 ], ":" => [ 9, \&_action_opcode_1701 ], },
	# [3509] opcode : sla "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1702 ], ":" => [ 9, \&_action_opcode_1702 ], },
	# [3510] opcode : sla a
	{ "\n" => [ 9, \&_action_opcode_1703 ], ":" => [ 9, \&_action_opcode_1703 ], },
	# [3511] opcode : sla b
	{ "\n" => [ 9, \&_action_opcode_1704 ], ":" => [ 9, \&_action_opcode_1704 ], },
	# [3512] opcode : sla bc
	{ "\n" => [ 9, \&_action_opcode_1705 ], ":" => [ 9, \&_action_opcode_1705 ], },
	# [3513] opcode : sla c
	{ "\n" => [ 9, \&_action_opcode_1706 ], ":" => [ 9, \&_action_opcode_1706 ], },
	# [3514] opcode : sla d
	{ "\n" => [ 9, \&_action_opcode_1707 ], ":" => [ 9, \&_action_opcode_1707 ], },
	# [3515] opcode : sla de
	{ "\n" => [ 9, \&_action_opcode_1708 ], ":" => [ 9, \&_action_opcode_1708 ], },
	# [3516] opcode : sla e
	{ "\n" => [ 9, \&_action_opcode_1709 ], ":" => [ 9, \&_action_opcode_1709 ], },
	# [3517] opcode : sla h
	{ "\n" => [ 9, \&_action_opcode_1710 ], ":" => [ 9, \&_action_opcode_1710 ], },
	# [3518] opcode : sla hl
	{ "\n" => [ 9, \&_action_opcode_69 ], ":" => [ 9, \&_action_opcode_69 ], },
	# [3519] opcode : sla l
	{ "\n" => [ 9, \&_action_opcode_1711 ], ":" => [ 9, \&_action_opcode_1711 ], },
	# [3520] opcode : sli
	{ "(" => 3521, a => 3588, b => 3589, bc => 3590, c => 3591, d => 3592, de => 3593, e => 3594, h => 3595, hl => 3596, l => 3597, },
	# [3521] opcode : sli "("
	{ hl => 3522, ix => 3524, iy => 3556, },
	# [3522] opcode : sli "(" hl
	{ ")" => 3523, },
	# [3523] opcode : sli "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_1712 ], ":" => [ 9, \&_action_opcode_1712 ], },
	# [3524] opcode : sli "(" ix
	{ ")" => 3525, "+" => 3534, "-" => 3545, },
	# [3525] opcode : sli "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_1713 ], "," => 3526, ":" => [ 9, \&_action_opcode_1713 ], },
	# [3526] opcode : sli "(" ix ")" ","
	{ a => 3527, b => 3528, c => 3529, d => 3530, e => 3531, h => 3532, l => 3533, },
	# [3527] opcode : sli "(" ix ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1714 ], ":" => [ 9, \&_action_opcode_1714 ], },
	# [3528] opcode : sli "(" ix ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1715 ], ":" => [ 9, \&_action_opcode_1715 ], },
	# [3529] opcode : sli "(" ix ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1716 ], ":" => [ 9, \&_action_opcode_1716 ], },
	# [3530] opcode : sli "(" ix ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1717 ], ":" => [ 9, \&_action_opcode_1717 ], },
	# [3531] opcode : sli "(" ix ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1718 ], ":" => [ 9, \&_action_opcode_1718 ], },
	# [3532] opcode : sli "(" ix ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1719 ], ":" => [ 9, \&_action_opcode_1719 ], },
	# [3533] opcode : sli "(" ix ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1720 ], ":" => [ 9, \&_action_opcode_1720 ], },
	# [3534] opcode : sli "(" ix "+"
	{ "!" => [ 14, 3535 ], "+" => [ 14, 3535 ], "-" => [ 14, 3535 ], __else__ => [ 14, 3535 ], "~" => [ 14, 3535 ], },
	# [3535] opcode : sli "(" ix "+" "[expr_DIS]"
	{ ")" => 3536, },
	# [3536] opcode : sli "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1721 ], "," => 3537, ":" => [ 9, \&_action_opcode_1721 ], },
	# [3537] opcode : sli "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 3538, b => 3539, c => 3540, d => 3541, e => 3542, h => 3543, l => 3544, },
	# [3538] opcode : sli "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1722 ], ":" => [ 9, \&_action_opcode_1722 ], },
	# [3539] opcode : sli "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1723 ], ":" => [ 9, \&_action_opcode_1723 ], },
	# [3540] opcode : sli "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1724 ], ":" => [ 9, \&_action_opcode_1724 ], },
	# [3541] opcode : sli "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1725 ], ":" => [ 9, \&_action_opcode_1725 ], },
	# [3542] opcode : sli "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1726 ], ":" => [ 9, \&_action_opcode_1726 ], },
	# [3543] opcode : sli "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1727 ], ":" => [ 9, \&_action_opcode_1727 ], },
	# [3544] opcode : sli "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1728 ], ":" => [ 9, \&_action_opcode_1728 ], },
	# [3545] opcode : sli "(" ix "-"
	{ "!" => [ 16, 3546 ], "+" => [ 16, 3546 ], "-" => [ 16, 3546 ], __else__ => [ 16, 3546 ], "~" => [ 16, 3546 ], },
	# [3546] opcode : sli "(" ix "-" "[expr_NDIS]"
	{ ")" => 3547, },
	# [3547] opcode : sli "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1721 ], "," => 3548, ":" => [ 9, \&_action_opcode_1721 ], },
	# [3548] opcode : sli "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 3549, b => 3550, c => 3551, d => 3552, e => 3553, h => 3554, l => 3555, },
	# [3549] opcode : sli "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1722 ], ":" => [ 9, \&_action_opcode_1722 ], },
	# [3550] opcode : sli "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1723 ], ":" => [ 9, \&_action_opcode_1723 ], },
	# [3551] opcode : sli "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1724 ], ":" => [ 9, \&_action_opcode_1724 ], },
	# [3552] opcode : sli "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1725 ], ":" => [ 9, \&_action_opcode_1725 ], },
	# [3553] opcode : sli "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1726 ], ":" => [ 9, \&_action_opcode_1726 ], },
	# [3554] opcode : sli "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1727 ], ":" => [ 9, \&_action_opcode_1727 ], },
	# [3555] opcode : sli "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1728 ], ":" => [ 9, \&_action_opcode_1728 ], },
	# [3556] opcode : sli "(" iy
	{ ")" => 3557, "+" => 3566, "-" => 3577, },
	# [3557] opcode : sli "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_1729 ], "," => 3558, ":" => [ 9, \&_action_opcode_1729 ], },
	# [3558] opcode : sli "(" iy ")" ","
	{ a => 3559, b => 3560, c => 3561, d => 3562, e => 3563, h => 3564, l => 3565, },
	# [3559] opcode : sli "(" iy ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1730 ], ":" => [ 9, \&_action_opcode_1730 ], },
	# [3560] opcode : sli "(" iy ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1731 ], ":" => [ 9, \&_action_opcode_1731 ], },
	# [3561] opcode : sli "(" iy ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1732 ], ":" => [ 9, \&_action_opcode_1732 ], },
	# [3562] opcode : sli "(" iy ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1733 ], ":" => [ 9, \&_action_opcode_1733 ], },
	# [3563] opcode : sli "(" iy ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1734 ], ":" => [ 9, \&_action_opcode_1734 ], },
	# [3564] opcode : sli "(" iy ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1735 ], ":" => [ 9, \&_action_opcode_1735 ], },
	# [3565] opcode : sli "(" iy ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1736 ], ":" => [ 9, \&_action_opcode_1736 ], },
	# [3566] opcode : sli "(" iy "+"
	{ "!" => [ 14, 3567 ], "+" => [ 14, 3567 ], "-" => [ 14, 3567 ], __else__ => [ 14, 3567 ], "~" => [ 14, 3567 ], },
	# [3567] opcode : sli "(" iy "+" "[expr_DIS]"
	{ ")" => 3568, },
	# [3568] opcode : sli "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1737 ], "," => 3569, ":" => [ 9, \&_action_opcode_1737 ], },
	# [3569] opcode : sli "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 3570, b => 3571, c => 3572, d => 3573, e => 3574, h => 3575, l => 3576, },
	# [3570] opcode : sli "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1738 ], ":" => [ 9, \&_action_opcode_1738 ], },
	# [3571] opcode : sli "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1739 ], ":" => [ 9, \&_action_opcode_1739 ], },
	# [3572] opcode : sli "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1740 ], ":" => [ 9, \&_action_opcode_1740 ], },
	# [3573] opcode : sli "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1741 ], ":" => [ 9, \&_action_opcode_1741 ], },
	# [3574] opcode : sli "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1742 ], ":" => [ 9, \&_action_opcode_1742 ], },
	# [3575] opcode : sli "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1743 ], ":" => [ 9, \&_action_opcode_1743 ], },
	# [3576] opcode : sli "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1744 ], ":" => [ 9, \&_action_opcode_1744 ], },
	# [3577] opcode : sli "(" iy "-"
	{ "!" => [ 16, 3578 ], "+" => [ 16, 3578 ], "-" => [ 16, 3578 ], __else__ => [ 16, 3578 ], "~" => [ 16, 3578 ], },
	# [3578] opcode : sli "(" iy "-" "[expr_NDIS]"
	{ ")" => 3579, },
	# [3579] opcode : sli "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1737 ], "," => 3580, ":" => [ 9, \&_action_opcode_1737 ], },
	# [3580] opcode : sli "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 3581, b => 3582, c => 3583, d => 3584, e => 3585, h => 3586, l => 3587, },
	# [3581] opcode : sli "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1738 ], ":" => [ 9, \&_action_opcode_1738 ], },
	# [3582] opcode : sli "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1739 ], ":" => [ 9, \&_action_opcode_1739 ], },
	# [3583] opcode : sli "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1740 ], ":" => [ 9, \&_action_opcode_1740 ], },
	# [3584] opcode : sli "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1741 ], ":" => [ 9, \&_action_opcode_1741 ], },
	# [3585] opcode : sli "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1742 ], ":" => [ 9, \&_action_opcode_1742 ], },
	# [3586] opcode : sli "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1743 ], ":" => [ 9, \&_action_opcode_1743 ], },
	# [3587] opcode : sli "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1744 ], ":" => [ 9, \&_action_opcode_1744 ], },
	# [3588] opcode : sli a
	{ "\n" => [ 9, \&_action_opcode_1745 ], ":" => [ 9, \&_action_opcode_1745 ], },
	# [3589] opcode : sli b
	{ "\n" => [ 9, \&_action_opcode_1746 ], ":" => [ 9, \&_action_opcode_1746 ], },
	# [3590] opcode : sli bc
	{ "\n" => [ 9, \&_action_opcode_1747 ], ":" => [ 9, \&_action_opcode_1747 ], },
	# [3591] opcode : sli c
	{ "\n" => [ 9, \&_action_opcode_1748 ], ":" => [ 9, \&_action_opcode_1748 ], },
	# [3592] opcode : sli d
	{ "\n" => [ 9, \&_action_opcode_1749 ], ":" => [ 9, \&_action_opcode_1749 ], },
	# [3593] opcode : sli de
	{ "\n" => [ 9, \&_action_opcode_1750 ], ":" => [ 9, \&_action_opcode_1750 ], },
	# [3594] opcode : sli e
	{ "\n" => [ 9, \&_action_opcode_1751 ], ":" => [ 9, \&_action_opcode_1751 ], },
	# [3595] opcode : sli h
	{ "\n" => [ 9, \&_action_opcode_1752 ], ":" => [ 9, \&_action_opcode_1752 ], },
	# [3596] opcode : sli hl
	{ "\n" => [ 9, \&_action_opcode_1753 ], ":" => [ 9, \&_action_opcode_1753 ], },
	# [3597] opcode : sli l
	{ "\n" => [ 9, \&_action_opcode_1754 ], ":" => [ 9, \&_action_opcode_1754 ], },
	# [3598] opcode : sll
	{ "(" => 3599, a => 3666, b => 3667, bc => 3668, c => 3669, d => 3670, de => 3671, e => 3672, h => 3673, hl => 3674, l => 3675, },
	# [3599] opcode : sll "("
	{ hl => 3600, ix => 3602, iy => 3634, },
	# [3600] opcode : sll "(" hl
	{ ")" => 3601, },
	# [3601] opcode : sll "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_1712 ], ":" => [ 9, \&_action_opcode_1712 ], },
	# [3602] opcode : sll "(" ix
	{ ")" => 3603, "+" => 3612, "-" => 3623, },
	# [3603] opcode : sll "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_1713 ], "," => 3604, ":" => [ 9, \&_action_opcode_1713 ], },
	# [3604] opcode : sll "(" ix ")" ","
	{ a => 3605, b => 3606, c => 3607, d => 3608, e => 3609, h => 3610, l => 3611, },
	# [3605] opcode : sll "(" ix ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1714 ], ":" => [ 9, \&_action_opcode_1714 ], },
	# [3606] opcode : sll "(" ix ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1715 ], ":" => [ 9, \&_action_opcode_1715 ], },
	# [3607] opcode : sll "(" ix ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1716 ], ":" => [ 9, \&_action_opcode_1716 ], },
	# [3608] opcode : sll "(" ix ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1717 ], ":" => [ 9, \&_action_opcode_1717 ], },
	# [3609] opcode : sll "(" ix ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1718 ], ":" => [ 9, \&_action_opcode_1718 ], },
	# [3610] opcode : sll "(" ix ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1719 ], ":" => [ 9, \&_action_opcode_1719 ], },
	# [3611] opcode : sll "(" ix ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1720 ], ":" => [ 9, \&_action_opcode_1720 ], },
	# [3612] opcode : sll "(" ix "+"
	{ "!" => [ 14, 3613 ], "+" => [ 14, 3613 ], "-" => [ 14, 3613 ], __else__ => [ 14, 3613 ], "~" => [ 14, 3613 ], },
	# [3613] opcode : sll "(" ix "+" "[expr_DIS]"
	{ ")" => 3614, },
	# [3614] opcode : sll "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1721 ], "," => 3615, ":" => [ 9, \&_action_opcode_1721 ], },
	# [3615] opcode : sll "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 3616, b => 3617, c => 3618, d => 3619, e => 3620, h => 3621, l => 3622, },
	# [3616] opcode : sll "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1722 ], ":" => [ 9, \&_action_opcode_1722 ], },
	# [3617] opcode : sll "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1723 ], ":" => [ 9, \&_action_opcode_1723 ], },
	# [3618] opcode : sll "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1724 ], ":" => [ 9, \&_action_opcode_1724 ], },
	# [3619] opcode : sll "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1725 ], ":" => [ 9, \&_action_opcode_1725 ], },
	# [3620] opcode : sll "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1726 ], ":" => [ 9, \&_action_opcode_1726 ], },
	# [3621] opcode : sll "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1727 ], ":" => [ 9, \&_action_opcode_1727 ], },
	# [3622] opcode : sll "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1728 ], ":" => [ 9, \&_action_opcode_1728 ], },
	# [3623] opcode : sll "(" ix "-"
	{ "!" => [ 16, 3624 ], "+" => [ 16, 3624 ], "-" => [ 16, 3624 ], __else__ => [ 16, 3624 ], "~" => [ 16, 3624 ], },
	# [3624] opcode : sll "(" ix "-" "[expr_NDIS]"
	{ ")" => 3625, },
	# [3625] opcode : sll "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1721 ], "," => 3626, ":" => [ 9, \&_action_opcode_1721 ], },
	# [3626] opcode : sll "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 3627, b => 3628, c => 3629, d => 3630, e => 3631, h => 3632, l => 3633, },
	# [3627] opcode : sll "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1722 ], ":" => [ 9, \&_action_opcode_1722 ], },
	# [3628] opcode : sll "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1723 ], ":" => [ 9, \&_action_opcode_1723 ], },
	# [3629] opcode : sll "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1724 ], ":" => [ 9, \&_action_opcode_1724 ], },
	# [3630] opcode : sll "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1725 ], ":" => [ 9, \&_action_opcode_1725 ], },
	# [3631] opcode : sll "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1726 ], ":" => [ 9, \&_action_opcode_1726 ], },
	# [3632] opcode : sll "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1727 ], ":" => [ 9, \&_action_opcode_1727 ], },
	# [3633] opcode : sll "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1728 ], ":" => [ 9, \&_action_opcode_1728 ], },
	# [3634] opcode : sll "(" iy
	{ ")" => 3635, "+" => 3644, "-" => 3655, },
	# [3635] opcode : sll "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_1729 ], "," => 3636, ":" => [ 9, \&_action_opcode_1729 ], },
	# [3636] opcode : sll "(" iy ")" ","
	{ a => 3637, b => 3638, c => 3639, d => 3640, e => 3641, h => 3642, l => 3643, },
	# [3637] opcode : sll "(" iy ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1730 ], ":" => [ 9, \&_action_opcode_1730 ], },
	# [3638] opcode : sll "(" iy ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1731 ], ":" => [ 9, \&_action_opcode_1731 ], },
	# [3639] opcode : sll "(" iy ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1732 ], ":" => [ 9, \&_action_opcode_1732 ], },
	# [3640] opcode : sll "(" iy ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1733 ], ":" => [ 9, \&_action_opcode_1733 ], },
	# [3641] opcode : sll "(" iy ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1734 ], ":" => [ 9, \&_action_opcode_1734 ], },
	# [3642] opcode : sll "(" iy ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1735 ], ":" => [ 9, \&_action_opcode_1735 ], },
	# [3643] opcode : sll "(" iy ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1736 ], ":" => [ 9, \&_action_opcode_1736 ], },
	# [3644] opcode : sll "(" iy "+"
	{ "!" => [ 14, 3645 ], "+" => [ 14, 3645 ], "-" => [ 14, 3645 ], __else__ => [ 14, 3645 ], "~" => [ 14, 3645 ], },
	# [3645] opcode : sll "(" iy "+" "[expr_DIS]"
	{ ")" => 3646, },
	# [3646] opcode : sll "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1737 ], "," => 3647, ":" => [ 9, \&_action_opcode_1737 ], },
	# [3647] opcode : sll "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 3648, b => 3649, c => 3650, d => 3651, e => 3652, h => 3653, l => 3654, },
	# [3648] opcode : sll "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1738 ], ":" => [ 9, \&_action_opcode_1738 ], },
	# [3649] opcode : sll "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1739 ], ":" => [ 9, \&_action_opcode_1739 ], },
	# [3650] opcode : sll "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1740 ], ":" => [ 9, \&_action_opcode_1740 ], },
	# [3651] opcode : sll "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1741 ], ":" => [ 9, \&_action_opcode_1741 ], },
	# [3652] opcode : sll "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1742 ], ":" => [ 9, \&_action_opcode_1742 ], },
	# [3653] opcode : sll "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1743 ], ":" => [ 9, \&_action_opcode_1743 ], },
	# [3654] opcode : sll "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1744 ], ":" => [ 9, \&_action_opcode_1744 ], },
	# [3655] opcode : sll "(" iy "-"
	{ "!" => [ 16, 3656 ], "+" => [ 16, 3656 ], "-" => [ 16, 3656 ], __else__ => [ 16, 3656 ], "~" => [ 16, 3656 ], },
	# [3656] opcode : sll "(" iy "-" "[expr_NDIS]"
	{ ")" => 3657, },
	# [3657] opcode : sll "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1737 ], "," => 3658, ":" => [ 9, \&_action_opcode_1737 ], },
	# [3658] opcode : sll "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 3659, b => 3660, c => 3661, d => 3662, e => 3663, h => 3664, l => 3665, },
	# [3659] opcode : sll "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1738 ], ":" => [ 9, \&_action_opcode_1738 ], },
	# [3660] opcode : sll "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1739 ], ":" => [ 9, \&_action_opcode_1739 ], },
	# [3661] opcode : sll "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1740 ], ":" => [ 9, \&_action_opcode_1740 ], },
	# [3662] opcode : sll "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1741 ], ":" => [ 9, \&_action_opcode_1741 ], },
	# [3663] opcode : sll "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1742 ], ":" => [ 9, \&_action_opcode_1742 ], },
	# [3664] opcode : sll "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1743 ], ":" => [ 9, \&_action_opcode_1743 ], },
	# [3665] opcode : sll "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1744 ], ":" => [ 9, \&_action_opcode_1744 ], },
	# [3666] opcode : sll a
	{ "\n" => [ 9, \&_action_opcode_1745 ], ":" => [ 9, \&_action_opcode_1745 ], },
	# [3667] opcode : sll b
	{ "\n" => [ 9, \&_action_opcode_1746 ], ":" => [ 9, \&_action_opcode_1746 ], },
	# [3668] opcode : sll bc
	{ "\n" => [ 9, \&_action_opcode_1747 ], ":" => [ 9, \&_action_opcode_1747 ], },
	# [3669] opcode : sll c
	{ "\n" => [ 9, \&_action_opcode_1748 ], ":" => [ 9, \&_action_opcode_1748 ], },
	# [3670] opcode : sll d
	{ "\n" => [ 9, \&_action_opcode_1749 ], ":" => [ 9, \&_action_opcode_1749 ], },
	# [3671] opcode : sll de
	{ "\n" => [ 9, \&_action_opcode_1750 ], ":" => [ 9, \&_action_opcode_1750 ], },
	# [3672] opcode : sll e
	{ "\n" => [ 9, \&_action_opcode_1751 ], ":" => [ 9, \&_action_opcode_1751 ], },
	# [3673] opcode : sll h
	{ "\n" => [ 9, \&_action_opcode_1752 ], ":" => [ 9, \&_action_opcode_1752 ], },
	# [3674] opcode : sll hl
	{ "\n" => [ 9, \&_action_opcode_1753 ], ":" => [ 9, \&_action_opcode_1753 ], },
	# [3675] opcode : sll l
	{ "\n" => [ 9, \&_action_opcode_1754 ], ":" => [ 9, \&_action_opcode_1754 ], },
	# [3676] opcode : sra
	{ "(" => 3677, a => 3744, b => 3745, bc => 3746, c => 3747, d => 3748, de => 3749, e => 3750, h => 3751, hl => 3752, l => 3753, },
	# [3677] opcode : sra "("
	{ hl => 3678, ix => 3680, iy => 3712, },
	# [3678] opcode : sra "(" hl
	{ ")" => 3679, },
	# [3679] opcode : sra "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_1755 ], ":" => [ 9, \&_action_opcode_1755 ], },
	# [3680] opcode : sra "(" ix
	{ ")" => 3681, "+" => 3690, "-" => 3701, },
	# [3681] opcode : sra "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_1756 ], "," => 3682, ":" => [ 9, \&_action_opcode_1756 ], },
	# [3682] opcode : sra "(" ix ")" ","
	{ a => 3683, b => 3684, c => 3685, d => 3686, e => 3687, h => 3688, l => 3689, },
	# [3683] opcode : sra "(" ix ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1757 ], ":" => [ 9, \&_action_opcode_1757 ], },
	# [3684] opcode : sra "(" ix ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1758 ], ":" => [ 9, \&_action_opcode_1758 ], },
	# [3685] opcode : sra "(" ix ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1759 ], ":" => [ 9, \&_action_opcode_1759 ], },
	# [3686] opcode : sra "(" ix ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1760 ], ":" => [ 9, \&_action_opcode_1760 ], },
	# [3687] opcode : sra "(" ix ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1761 ], ":" => [ 9, \&_action_opcode_1761 ], },
	# [3688] opcode : sra "(" ix ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1762 ], ":" => [ 9, \&_action_opcode_1762 ], },
	# [3689] opcode : sra "(" ix ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1763 ], ":" => [ 9, \&_action_opcode_1763 ], },
	# [3690] opcode : sra "(" ix "+"
	{ "!" => [ 14, 3691 ], "+" => [ 14, 3691 ], "-" => [ 14, 3691 ], __else__ => [ 14, 3691 ], "~" => [ 14, 3691 ], },
	# [3691] opcode : sra "(" ix "+" "[expr_DIS]"
	{ ")" => 3692, },
	# [3692] opcode : sra "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1764 ], "," => 3693, ":" => [ 9, \&_action_opcode_1764 ], },
	# [3693] opcode : sra "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 3694, b => 3695, c => 3696, d => 3697, e => 3698, h => 3699, l => 3700, },
	# [3694] opcode : sra "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1765 ], ":" => [ 9, \&_action_opcode_1765 ], },
	# [3695] opcode : sra "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1766 ], ":" => [ 9, \&_action_opcode_1766 ], },
	# [3696] opcode : sra "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1767 ], ":" => [ 9, \&_action_opcode_1767 ], },
	# [3697] opcode : sra "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1768 ], ":" => [ 9, \&_action_opcode_1768 ], },
	# [3698] opcode : sra "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1769 ], ":" => [ 9, \&_action_opcode_1769 ], },
	# [3699] opcode : sra "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1770 ], ":" => [ 9, \&_action_opcode_1770 ], },
	# [3700] opcode : sra "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1771 ], ":" => [ 9, \&_action_opcode_1771 ], },
	# [3701] opcode : sra "(" ix "-"
	{ "!" => [ 16, 3702 ], "+" => [ 16, 3702 ], "-" => [ 16, 3702 ], __else__ => [ 16, 3702 ], "~" => [ 16, 3702 ], },
	# [3702] opcode : sra "(" ix "-" "[expr_NDIS]"
	{ ")" => 3703, },
	# [3703] opcode : sra "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1764 ], "," => 3704, ":" => [ 9, \&_action_opcode_1764 ], },
	# [3704] opcode : sra "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 3705, b => 3706, c => 3707, d => 3708, e => 3709, h => 3710, l => 3711, },
	# [3705] opcode : sra "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1765 ], ":" => [ 9, \&_action_opcode_1765 ], },
	# [3706] opcode : sra "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1766 ], ":" => [ 9, \&_action_opcode_1766 ], },
	# [3707] opcode : sra "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1767 ], ":" => [ 9, \&_action_opcode_1767 ], },
	# [3708] opcode : sra "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1768 ], ":" => [ 9, \&_action_opcode_1768 ], },
	# [3709] opcode : sra "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1769 ], ":" => [ 9, \&_action_opcode_1769 ], },
	# [3710] opcode : sra "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1770 ], ":" => [ 9, \&_action_opcode_1770 ], },
	# [3711] opcode : sra "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1771 ], ":" => [ 9, \&_action_opcode_1771 ], },
	# [3712] opcode : sra "(" iy
	{ ")" => 3713, "+" => 3722, "-" => 3733, },
	# [3713] opcode : sra "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_1772 ], "," => 3714, ":" => [ 9, \&_action_opcode_1772 ], },
	# [3714] opcode : sra "(" iy ")" ","
	{ a => 3715, b => 3716, c => 3717, d => 3718, e => 3719, h => 3720, l => 3721, },
	# [3715] opcode : sra "(" iy ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1773 ], ":" => [ 9, \&_action_opcode_1773 ], },
	# [3716] opcode : sra "(" iy ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1774 ], ":" => [ 9, \&_action_opcode_1774 ], },
	# [3717] opcode : sra "(" iy ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1775 ], ":" => [ 9, \&_action_opcode_1775 ], },
	# [3718] opcode : sra "(" iy ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1776 ], ":" => [ 9, \&_action_opcode_1776 ], },
	# [3719] opcode : sra "(" iy ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1777 ], ":" => [ 9, \&_action_opcode_1777 ], },
	# [3720] opcode : sra "(" iy ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1778 ], ":" => [ 9, \&_action_opcode_1778 ], },
	# [3721] opcode : sra "(" iy ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1779 ], ":" => [ 9, \&_action_opcode_1779 ], },
	# [3722] opcode : sra "(" iy "+"
	{ "!" => [ 14, 3723 ], "+" => [ 14, 3723 ], "-" => [ 14, 3723 ], __else__ => [ 14, 3723 ], "~" => [ 14, 3723 ], },
	# [3723] opcode : sra "(" iy "+" "[expr_DIS]"
	{ ")" => 3724, },
	# [3724] opcode : sra "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1780 ], "," => 3725, ":" => [ 9, \&_action_opcode_1780 ], },
	# [3725] opcode : sra "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 3726, b => 3727, c => 3728, d => 3729, e => 3730, h => 3731, l => 3732, },
	# [3726] opcode : sra "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1781 ], ":" => [ 9, \&_action_opcode_1781 ], },
	# [3727] opcode : sra "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1782 ], ":" => [ 9, \&_action_opcode_1782 ], },
	# [3728] opcode : sra "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1783 ], ":" => [ 9, \&_action_opcode_1783 ], },
	# [3729] opcode : sra "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1784 ], ":" => [ 9, \&_action_opcode_1784 ], },
	# [3730] opcode : sra "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1785 ], ":" => [ 9, \&_action_opcode_1785 ], },
	# [3731] opcode : sra "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1786 ], ":" => [ 9, \&_action_opcode_1786 ], },
	# [3732] opcode : sra "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1787 ], ":" => [ 9, \&_action_opcode_1787 ], },
	# [3733] opcode : sra "(" iy "-"
	{ "!" => [ 16, 3734 ], "+" => [ 16, 3734 ], "-" => [ 16, 3734 ], __else__ => [ 16, 3734 ], "~" => [ 16, 3734 ], },
	# [3734] opcode : sra "(" iy "-" "[expr_NDIS]"
	{ ")" => 3735, },
	# [3735] opcode : sra "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1780 ], "," => 3736, ":" => [ 9, \&_action_opcode_1780 ], },
	# [3736] opcode : sra "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 3737, b => 3738, c => 3739, d => 3740, e => 3741, h => 3742, l => 3743, },
	# [3737] opcode : sra "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1781 ], ":" => [ 9, \&_action_opcode_1781 ], },
	# [3738] opcode : sra "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1782 ], ":" => [ 9, \&_action_opcode_1782 ], },
	# [3739] opcode : sra "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1783 ], ":" => [ 9, \&_action_opcode_1783 ], },
	# [3740] opcode : sra "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1784 ], ":" => [ 9, \&_action_opcode_1784 ], },
	# [3741] opcode : sra "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1785 ], ":" => [ 9, \&_action_opcode_1785 ], },
	# [3742] opcode : sra "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1786 ], ":" => [ 9, \&_action_opcode_1786 ], },
	# [3743] opcode : sra "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1787 ], ":" => [ 9, \&_action_opcode_1787 ], },
	# [3744] opcode : sra a
	{ "\n" => [ 9, \&_action_opcode_1788 ], ":" => [ 9, \&_action_opcode_1788 ], },
	# [3745] opcode : sra b
	{ "\n" => [ 9, \&_action_opcode_1789 ], ":" => [ 9, \&_action_opcode_1789 ], },
	# [3746] opcode : sra bc
	{ "\n" => [ 9, \&_action_opcode_1790 ], ":" => [ 9, \&_action_opcode_1790 ], },
	# [3747] opcode : sra c
	{ "\n" => [ 9, \&_action_opcode_1791 ], ":" => [ 9, \&_action_opcode_1791 ], },
	# [3748] opcode : sra d
	{ "\n" => [ 9, \&_action_opcode_1792 ], ":" => [ 9, \&_action_opcode_1792 ], },
	# [3749] opcode : sra de
	{ "\n" => [ 9, \&_action_opcode_1793 ], ":" => [ 9, \&_action_opcode_1793 ], },
	# [3750] opcode : sra e
	{ "\n" => [ 9, \&_action_opcode_1794 ], ":" => [ 9, \&_action_opcode_1794 ], },
	# [3751] opcode : sra h
	{ "\n" => [ 9, \&_action_opcode_1795 ], ":" => [ 9, \&_action_opcode_1795 ], },
	# [3752] opcode : sra hl
	{ "\n" => [ 9, \&_action_opcode_1796 ], ":" => [ 9, \&_action_opcode_1796 ], },
	# [3753] opcode : sra l
	{ "\n" => [ 9, \&_action_opcode_1797 ], ":" => [ 9, \&_action_opcode_1797 ], },
	# [3754] opcode : srl
	{ "(" => 3755, a => 3822, b => 3823, bc => 3824, c => 3825, d => 3826, de => 3827, e => 3828, h => 3829, hl => 3830, l => 3831, },
	# [3755] opcode : srl "("
	{ hl => 3756, ix => 3758, iy => 3790, },
	# [3756] opcode : srl "(" hl
	{ ")" => 3757, },
	# [3757] opcode : srl "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_1798 ], ":" => [ 9, \&_action_opcode_1798 ], },
	# [3758] opcode : srl "(" ix
	{ ")" => 3759, "+" => 3768, "-" => 3779, },
	# [3759] opcode : srl "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_1799 ], "," => 3760, ":" => [ 9, \&_action_opcode_1799 ], },
	# [3760] opcode : srl "(" ix ")" ","
	{ a => 3761, b => 3762, c => 3763, d => 3764, e => 3765, h => 3766, l => 3767, },
	# [3761] opcode : srl "(" ix ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1800 ], ":" => [ 9, \&_action_opcode_1800 ], },
	# [3762] opcode : srl "(" ix ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1801 ], ":" => [ 9, \&_action_opcode_1801 ], },
	# [3763] opcode : srl "(" ix ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1802 ], ":" => [ 9, \&_action_opcode_1802 ], },
	# [3764] opcode : srl "(" ix ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1803 ], ":" => [ 9, \&_action_opcode_1803 ], },
	# [3765] opcode : srl "(" ix ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1804 ], ":" => [ 9, \&_action_opcode_1804 ], },
	# [3766] opcode : srl "(" ix ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1805 ], ":" => [ 9, \&_action_opcode_1805 ], },
	# [3767] opcode : srl "(" ix ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1806 ], ":" => [ 9, \&_action_opcode_1806 ], },
	# [3768] opcode : srl "(" ix "+"
	{ "!" => [ 14, 3769 ], "+" => [ 14, 3769 ], "-" => [ 14, 3769 ], __else__ => [ 14, 3769 ], "~" => [ 14, 3769 ], },
	# [3769] opcode : srl "(" ix "+" "[expr_DIS]"
	{ ")" => 3770, },
	# [3770] opcode : srl "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1807 ], "," => 3771, ":" => [ 9, \&_action_opcode_1807 ], },
	# [3771] opcode : srl "(" ix "+" "[expr_DIS]" ")" ","
	{ a => 3772, b => 3773, c => 3774, d => 3775, e => 3776, h => 3777, l => 3778, },
	# [3772] opcode : srl "(" ix "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1808 ], ":" => [ 9, \&_action_opcode_1808 ], },
	# [3773] opcode : srl "(" ix "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1809 ], ":" => [ 9, \&_action_opcode_1809 ], },
	# [3774] opcode : srl "(" ix "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1810 ], ":" => [ 9, \&_action_opcode_1810 ], },
	# [3775] opcode : srl "(" ix "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1811 ], ":" => [ 9, \&_action_opcode_1811 ], },
	# [3776] opcode : srl "(" ix "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1812 ], ":" => [ 9, \&_action_opcode_1812 ], },
	# [3777] opcode : srl "(" ix "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1813 ], ":" => [ 9, \&_action_opcode_1813 ], },
	# [3778] opcode : srl "(" ix "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1814 ], ":" => [ 9, \&_action_opcode_1814 ], },
	# [3779] opcode : srl "(" ix "-"
	{ "!" => [ 16, 3780 ], "+" => [ 16, 3780 ], "-" => [ 16, 3780 ], __else__ => [ 16, 3780 ], "~" => [ 16, 3780 ], },
	# [3780] opcode : srl "(" ix "-" "[expr_NDIS]"
	{ ")" => 3781, },
	# [3781] opcode : srl "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1807 ], "," => 3782, ":" => [ 9, \&_action_opcode_1807 ], },
	# [3782] opcode : srl "(" ix "-" "[expr_NDIS]" ")" ","
	{ a => 3783, b => 3784, c => 3785, d => 3786, e => 3787, h => 3788, l => 3789, },
	# [3783] opcode : srl "(" ix "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1808 ], ":" => [ 9, \&_action_opcode_1808 ], },
	# [3784] opcode : srl "(" ix "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1809 ], ":" => [ 9, \&_action_opcode_1809 ], },
	# [3785] opcode : srl "(" ix "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1810 ], ":" => [ 9, \&_action_opcode_1810 ], },
	# [3786] opcode : srl "(" ix "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1811 ], ":" => [ 9, \&_action_opcode_1811 ], },
	# [3787] opcode : srl "(" ix "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1812 ], ":" => [ 9, \&_action_opcode_1812 ], },
	# [3788] opcode : srl "(" ix "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1813 ], ":" => [ 9, \&_action_opcode_1813 ], },
	# [3789] opcode : srl "(" ix "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1814 ], ":" => [ 9, \&_action_opcode_1814 ], },
	# [3790] opcode : srl "(" iy
	{ ")" => 3791, "+" => 3800, "-" => 3811, },
	# [3791] opcode : srl "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_1815 ], "," => 3792, ":" => [ 9, \&_action_opcode_1815 ], },
	# [3792] opcode : srl "(" iy ")" ","
	{ a => 3793, b => 3794, c => 3795, d => 3796, e => 3797, h => 3798, l => 3799, },
	# [3793] opcode : srl "(" iy ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1816 ], ":" => [ 9, \&_action_opcode_1816 ], },
	# [3794] opcode : srl "(" iy ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1817 ], ":" => [ 9, \&_action_opcode_1817 ], },
	# [3795] opcode : srl "(" iy ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1818 ], ":" => [ 9, \&_action_opcode_1818 ], },
	# [3796] opcode : srl "(" iy ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1819 ], ":" => [ 9, \&_action_opcode_1819 ], },
	# [3797] opcode : srl "(" iy ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1820 ], ":" => [ 9, \&_action_opcode_1820 ], },
	# [3798] opcode : srl "(" iy ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1821 ], ":" => [ 9, \&_action_opcode_1821 ], },
	# [3799] opcode : srl "(" iy ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1822 ], ":" => [ 9, \&_action_opcode_1822 ], },
	# [3800] opcode : srl "(" iy "+"
	{ "!" => [ 14, 3801 ], "+" => [ 14, 3801 ], "-" => [ 14, 3801 ], __else__ => [ 14, 3801 ], "~" => [ 14, 3801 ], },
	# [3801] opcode : srl "(" iy "+" "[expr_DIS]"
	{ ")" => 3802, },
	# [3802] opcode : srl "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1823 ], "," => 3803, ":" => [ 9, \&_action_opcode_1823 ], },
	# [3803] opcode : srl "(" iy "+" "[expr_DIS]" ")" ","
	{ a => 3804, b => 3805, c => 3806, d => 3807, e => 3808, h => 3809, l => 3810, },
	# [3804] opcode : srl "(" iy "+" "[expr_DIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1824 ], ":" => [ 9, \&_action_opcode_1824 ], },
	# [3805] opcode : srl "(" iy "+" "[expr_DIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1825 ], ":" => [ 9, \&_action_opcode_1825 ], },
	# [3806] opcode : srl "(" iy "+" "[expr_DIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1826 ], ":" => [ 9, \&_action_opcode_1826 ], },
	# [3807] opcode : srl "(" iy "+" "[expr_DIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1827 ], ":" => [ 9, \&_action_opcode_1827 ], },
	# [3808] opcode : srl "(" iy "+" "[expr_DIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1828 ], ":" => [ 9, \&_action_opcode_1828 ], },
	# [3809] opcode : srl "(" iy "+" "[expr_DIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1829 ], ":" => [ 9, \&_action_opcode_1829 ], },
	# [3810] opcode : srl "(" iy "+" "[expr_DIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1830 ], ":" => [ 9, \&_action_opcode_1830 ], },
	# [3811] opcode : srl "(" iy "-"
	{ "!" => [ 16, 3812 ], "+" => [ 16, 3812 ], "-" => [ 16, 3812 ], __else__ => [ 16, 3812 ], "~" => [ 16, 3812 ], },
	# [3812] opcode : srl "(" iy "-" "[expr_NDIS]"
	{ ")" => 3813, },
	# [3813] opcode : srl "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1823 ], "," => 3814, ":" => [ 9, \&_action_opcode_1823 ], },
	# [3814] opcode : srl "(" iy "-" "[expr_NDIS]" ")" ","
	{ a => 3815, b => 3816, c => 3817, d => 3818, e => 3819, h => 3820, l => 3821, },
	# [3815] opcode : srl "(" iy "-" "[expr_NDIS]" ")" "," a
	{ "\n" => [ 9, \&_action_opcode_1824 ], ":" => [ 9, \&_action_opcode_1824 ], },
	# [3816] opcode : srl "(" iy "-" "[expr_NDIS]" ")" "," b
	{ "\n" => [ 9, \&_action_opcode_1825 ], ":" => [ 9, \&_action_opcode_1825 ], },
	# [3817] opcode : srl "(" iy "-" "[expr_NDIS]" ")" "," c
	{ "\n" => [ 9, \&_action_opcode_1826 ], ":" => [ 9, \&_action_opcode_1826 ], },
	# [3818] opcode : srl "(" iy "-" "[expr_NDIS]" ")" "," d
	{ "\n" => [ 9, \&_action_opcode_1827 ], ":" => [ 9, \&_action_opcode_1827 ], },
	# [3819] opcode : srl "(" iy "-" "[expr_NDIS]" ")" "," e
	{ "\n" => [ 9, \&_action_opcode_1828 ], ":" => [ 9, \&_action_opcode_1828 ], },
	# [3820] opcode : srl "(" iy "-" "[expr_NDIS]" ")" "," h
	{ "\n" => [ 9, \&_action_opcode_1829 ], ":" => [ 9, \&_action_opcode_1829 ], },
	# [3821] opcode : srl "(" iy "-" "[expr_NDIS]" ")" "," l
	{ "\n" => [ 9, \&_action_opcode_1830 ], ":" => [ 9, \&_action_opcode_1830 ], },
	# [3822] opcode : srl a
	{ "\n" => [ 9, \&_action_opcode_1831 ], ":" => [ 9, \&_action_opcode_1831 ], },
	# [3823] opcode : srl b
	{ "\n" => [ 9, \&_action_opcode_1832 ], ":" => [ 9, \&_action_opcode_1832 ], },
	# [3824] opcode : srl bc
	{ "\n" => [ 9, \&_action_opcode_1833 ], ":" => [ 9, \&_action_opcode_1833 ], },
	# [3825] opcode : srl c
	{ "\n" => [ 9, \&_action_opcode_1834 ], ":" => [ 9, \&_action_opcode_1834 ], },
	# [3826] opcode : srl d
	{ "\n" => [ 9, \&_action_opcode_1835 ], ":" => [ 9, \&_action_opcode_1835 ], },
	# [3827] opcode : srl de
	{ "\n" => [ 9, \&_action_opcode_1836 ], ":" => [ 9, \&_action_opcode_1836 ], },
	# [3828] opcode : srl e
	{ "\n" => [ 9, \&_action_opcode_1837 ], ":" => [ 9, \&_action_opcode_1837 ], },
	# [3829] opcode : srl h
	{ "\n" => [ 9, \&_action_opcode_1838 ], ":" => [ 9, \&_action_opcode_1838 ], },
	# [3830] opcode : srl hl
	{ "\n" => [ 9, \&_action_opcode_1839 ], ":" => [ 9, \&_action_opcode_1839 ], },
	# [3831] opcode : srl l
	{ "\n" => [ 9, \&_action_opcode_1840 ], ":" => [ 9, \&_action_opcode_1840 ], },
	# [3832] opcode : stop
	{ "\n" => [ 9, \&_action_opcode_1841 ], ":" => [ 9, \&_action_opcode_1841 ], },
	# [3833] opcode : sub
	{ "!" => [ 15, 3853 ], "(" => 3834, "+" => [ 15, 3853 ], "-" => [ 15, 3853 ], __else__ => [ 15, 3853 ], a => 3854, b => 3855, c => 3856, d => 3857, e => 3858, h => 3859, hl => 3860, ixh => 3866, ixl => 3867, iyh => 3868, iyl => 3869, l => 3870, "~" => [ 15, 3853 ], },
	# [3834] opcode : sub "("
	{ hl => 3835, ix => 3837, iy => 3845, },
	# [3835] opcode : sub "(" hl
	{ ")" => 3836, },
	# [3836] opcode : sub "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_1842 ], ":" => [ 9, \&_action_opcode_1842 ], },
	# [3837] opcode : sub "(" ix
	{ ")" => 3838, "+" => 3839, "-" => 3842, },
	# [3838] opcode : sub "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_1843 ], ":" => [ 9, \&_action_opcode_1843 ], },
	# [3839] opcode : sub "(" ix "+"
	{ "!" => [ 14, 3840 ], "+" => [ 14, 3840 ], "-" => [ 14, 3840 ], __else__ => [ 14, 3840 ], "~" => [ 14, 3840 ], },
	# [3840] opcode : sub "(" ix "+" "[expr_DIS]"
	{ ")" => 3841, },
	# [3841] opcode : sub "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1844 ], ":" => [ 9, \&_action_opcode_1844 ], },
	# [3842] opcode : sub "(" ix "-"
	{ "!" => [ 16, 3843 ], "+" => [ 16, 3843 ], "-" => [ 16, 3843 ], __else__ => [ 16, 3843 ], "~" => [ 16, 3843 ], },
	# [3843] opcode : sub "(" ix "-" "[expr_NDIS]"
	{ ")" => 3844, },
	# [3844] opcode : sub "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1844 ], ":" => [ 9, \&_action_opcode_1844 ], },
	# [3845] opcode : sub "(" iy
	{ ")" => 3846, "+" => 3847, "-" => 3850, },
	# [3846] opcode : sub "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_1845 ], ":" => [ 9, \&_action_opcode_1845 ], },
	# [3847] opcode : sub "(" iy "+"
	{ "!" => [ 14, 3848 ], "+" => [ 14, 3848 ], "-" => [ 14, 3848 ], __else__ => [ 14, 3848 ], "~" => [ 14, 3848 ], },
	# [3848] opcode : sub "(" iy "+" "[expr_DIS]"
	{ ")" => 3849, },
	# [3849] opcode : sub "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1846 ], ":" => [ 9, \&_action_opcode_1846 ], },
	# [3850] opcode : sub "(" iy "-"
	{ "!" => [ 16, 3851 ], "+" => [ 16, 3851 ], "-" => [ 16, 3851 ], __else__ => [ 16, 3851 ], "~" => [ 16, 3851 ], },
	# [3851] opcode : sub "(" iy "-" "[expr_NDIS]"
	{ ")" => 3852, },
	# [3852] opcode : sub "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1846 ], ":" => [ 9, \&_action_opcode_1846 ], },
	# [3853] opcode : sub "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_1847 ], ":" => [ 9, \&_action_opcode_1847 ], },
	# [3854] opcode : sub a
	{ "\n" => [ 9, \&_action_opcode_1848 ], ":" => [ 9, \&_action_opcode_1848 ], },
	# [3855] opcode : sub b
	{ "\n" => [ 9, \&_action_opcode_1849 ], ":" => [ 9, \&_action_opcode_1849 ], },
	# [3856] opcode : sub c
	{ "\n" => [ 9, \&_action_opcode_1850 ], ":" => [ 9, \&_action_opcode_1850 ], },
	# [3857] opcode : sub d
	{ "\n" => [ 9, \&_action_opcode_1851 ], ":" => [ 9, \&_action_opcode_1851 ], },
	# [3858] opcode : sub e
	{ "\n" => [ 9, \&_action_opcode_1852 ], ":" => [ 9, \&_action_opcode_1852 ], },
	# [3859] opcode : sub h
	{ "\n" => [ 9, \&_action_opcode_1853 ], ":" => [ 9, \&_action_opcode_1853 ], },
	# [3860] opcode : sub hl
	{ "," => 3861, },
	# [3861] opcode : sub hl ","
	{ bc => 3862, de => 3863, hl => 3864, sp => 3865, },
	# [3862] opcode : sub hl "," bc
	{ "\n" => [ 9, \&_action_opcode_1854 ], ":" => [ 9, \&_action_opcode_1854 ], },
	# [3863] opcode : sub hl "," de
	{ "\n" => [ 9, \&_action_opcode_1855 ], ":" => [ 9, \&_action_opcode_1855 ], },
	# [3864] opcode : sub hl "," hl
	{ "\n" => [ 9, \&_action_opcode_1856 ], ":" => [ 9, \&_action_opcode_1856 ], },
	# [3865] opcode : sub hl "," sp
	{ "\n" => [ 9, \&_action_opcode_1857 ], ":" => [ 9, \&_action_opcode_1857 ], },
	# [3866] opcode : sub ixh
	{ "\n" => [ 9, \&_action_opcode_1858 ], ":" => [ 9, \&_action_opcode_1858 ], },
	# [3867] opcode : sub ixl
	{ "\n" => [ 9, \&_action_opcode_1859 ], ":" => [ 9, \&_action_opcode_1859 ], },
	# [3868] opcode : sub iyh
	{ "\n" => [ 9, \&_action_opcode_1860 ], ":" => [ 9, \&_action_opcode_1860 ], },
	# [3869] opcode : sub iyl
	{ "\n" => [ 9, \&_action_opcode_1861 ], ":" => [ 9, \&_action_opcode_1861 ], },
	# [3870] opcode : sub l
	{ "\n" => [ 9, \&_action_opcode_1862 ], ":" => [ 9, \&_action_opcode_1862 ], },
	# [3871] opcode : xor
	{ "!" => [ 15, 3891 ], "(" => 3872, "+" => [ 15, 3891 ], "-" => [ 15, 3891 ], __else__ => [ 15, 3891 ], a => 3892, b => 3893, c => 3894, d => 3895, e => 3896, h => 3897, ixh => 3898, ixl => 3899, iyh => 3900, iyl => 3901, l => 3902, "~" => [ 15, 3891 ], },
	# [3872] opcode : xor "("
	{ hl => 3873, ix => 3875, iy => 3883, },
	# [3873] opcode : xor "(" hl
	{ ")" => 3874, },
	# [3874] opcode : xor "(" hl ")"
	{ "\n" => [ 9, \&_action_opcode_1863 ], ":" => [ 9, \&_action_opcode_1863 ], },
	# [3875] opcode : xor "(" ix
	{ ")" => 3876, "+" => 3877, "-" => 3880, },
	# [3876] opcode : xor "(" ix ")"
	{ "\n" => [ 9, \&_action_opcode_1864 ], ":" => [ 9, \&_action_opcode_1864 ], },
	# [3877] opcode : xor "(" ix "+"
	{ "!" => [ 14, 3878 ], "+" => [ 14, 3878 ], "-" => [ 14, 3878 ], __else__ => [ 14, 3878 ], "~" => [ 14, 3878 ], },
	# [3878] opcode : xor "(" ix "+" "[expr_DIS]"
	{ ")" => 3879, },
	# [3879] opcode : xor "(" ix "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1865 ], ":" => [ 9, \&_action_opcode_1865 ], },
	# [3880] opcode : xor "(" ix "-"
	{ "!" => [ 16, 3881 ], "+" => [ 16, 3881 ], "-" => [ 16, 3881 ], __else__ => [ 16, 3881 ], "~" => [ 16, 3881 ], },
	# [3881] opcode : xor "(" ix "-" "[expr_NDIS]"
	{ ")" => 3882, },
	# [3882] opcode : xor "(" ix "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1865 ], ":" => [ 9, \&_action_opcode_1865 ], },
	# [3883] opcode : xor "(" iy
	{ ")" => 3884, "+" => 3885, "-" => 3888, },
	# [3884] opcode : xor "(" iy ")"
	{ "\n" => [ 9, \&_action_opcode_1866 ], ":" => [ 9, \&_action_opcode_1866 ], },
	# [3885] opcode : xor "(" iy "+"
	{ "!" => [ 14, 3886 ], "+" => [ 14, 3886 ], "-" => [ 14, 3886 ], __else__ => [ 14, 3886 ], "~" => [ 14, 3886 ], },
	# [3886] opcode : xor "(" iy "+" "[expr_DIS]"
	{ ")" => 3887, },
	# [3887] opcode : xor "(" iy "+" "[expr_DIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1867 ], ":" => [ 9, \&_action_opcode_1867 ], },
	# [3888] opcode : xor "(" iy "-"
	{ "!" => [ 16, 3889 ], "+" => [ 16, 3889 ], "-" => [ 16, 3889 ], __else__ => [ 16, 3889 ], "~" => [ 16, 3889 ], },
	# [3889] opcode : xor "(" iy "-" "[expr_NDIS]"
	{ ")" => 3890, },
	# [3890] opcode : xor "(" iy "-" "[expr_NDIS]" ")"
	{ "\n" => [ 9, \&_action_opcode_1867 ], ":" => [ 9, \&_action_opcode_1867 ], },
	# [3891] opcode : xor "[expr_N]"
	{ "\n" => [ 9, \&_action_opcode_1868 ], ":" => [ 9, \&_action_opcode_1868 ], },
	# [3892] opcode : xor a
	{ "\n" => [ 9, \&_action_opcode_1869 ], ":" => [ 9, \&_action_opcode_1869 ], },
	# [3893] opcode : xor b
	{ "\n" => [ 9, \&_action_opcode_1870 ], ":" => [ 9, \&_action_opcode_1870 ], },
	# [3894] opcode : xor c
	{ "\n" => [ 9, \&_action_opcode_1871 ], ":" => [ 9, \&_action_opcode_1871 ], },
	# [3895] opcode : xor d
	{ "\n" => [ 9, \&_action_opcode_1872 ], ":" => [ 9, \&_action_opcode_1872 ], },
	# [3896] opcode : xor e
	{ "\n" => [ 9, \&_action_opcode_1873 ], ":" => [ 9, \&_action_opcode_1873 ], },
	# [3897] opcode : xor h
	{ "\n" => [ 9, \&_action_opcode_1874 ], ":" => [ 9, \&_action_opcode_1874 ], },
	# [3898] opcode : xor ixh
	{ "\n" => [ 9, \&_action_opcode_1875 ], ":" => [ 9, \&_action_opcode_1875 ], },
	# [3899] opcode : xor ixl
	{ "\n" => [ 9, \&_action_opcode_1876 ], ":" => [ 9, \&_action_opcode_1876 ], },
	# [3900] opcode : xor iyh
	{ "\n" => [ 9, \&_action_opcode_1877 ], ":" => [ 9, \&_action_opcode_1877 ], },
	# [3901] opcode : xor iyl
	{ "\n" => [ 9, \&_action_opcode_1878 ], ":" => [ 9, \&_action_opcode_1878 ], },
	# [3902] opcode : xor l
	{ "\n" => [ 9, \&_action_opcode_1879 ], ":" => [ 9, \&_action_opcode_1879 ], },
	# [3903] program : 
	{ "\n" => [ 54, 3903 ], ":" => [ 54, 3903 ], NAME => [ 54, 3903 ], __else__ => 3904, adc => [ 54, 3903 ], add => [ 54, 3903 ], and => [ 54, 3903 ], bit => [ 54, 3903 ], call => [ 54, 3903 ], ccf => [ 54, 3903 ], cp => [ 54, 3903 ], cpd => [ 54, 3903 ], cpdr => [ 54, 3903 ], cpi => [ 54, 3903 ], cpir => [ 54, 3903 ], cpl => [ 54, 3903 ], daa => [ 54, 3903 ], dec => [ 54, 3903 ], defb => [ 54, 3903 ], defm => [ 54, 3903 ], defm7 => [ 54, 3903 ], defmz => [ 54, 3903 ], deft => [ 54, 3903 ], defw => [ 54, 3903 ], di => [ 54, 3903 ], djnz => [ 54, 3903 ], ei => [ 54, 3903 ], ex => [ 54, 3903 ], exx => [ 54, 3903 ], halt => [ 54, 3903 ], im => [ 54, 3903 ], in => [ 54, 3903 ], inc => [ 54, 3903 ], ind => [ 54, 3903 ], indr => [ 54, 3903 ], ini => [ 54, 3903 ], inir => [ 54, 3903 ], jp => [ 54, 3903 ], jr => [ 54, 3903 ], ld => [ 54, 3903 ], ldd => [ 54, 3903 ], lddr => [ 54, 3903 ], ldi => [ 54, 3903 ], ldir => [ 54, 3903 ], macro => [ 54, 3903 ], neg => [ 54, 3903 ], nop => [ 54, 3903 ], or => [ 54, 3903 ], org => [ 54, 3903 ], otdr => [ 54, 3903 ], otir => [ 54, 3903 ], out => [ 54, 3903 ], outd => [ 54, 3903 ], outi => [ 54, 3903 ], pop => [ 54, 3903 ], push => [ 54, 3903 ], res => [ 54, 3903 ], ret => [ 54, 3903 ], reti => [ 54, 3903 ], retn => [ 54, 3903 ], rl => [ 54, 3903 ], rla => [ 54, 3903 ], rlc => [ 54, 3903 ], rlca => [ 54, 3903 ], rld => [ 54, 3903 ], rr => [ 54, 3903 ], rra => [ 54, 3903 ], rrc => [ 54, 3903 ], rrca => [ 54, 3903 ], rrd => [ 54, 3903 ], rst => [ 54, 3903 ], sbc => [ 54, 3903 ], scf => [ 54, 3903 ], set => [ 54, 3903 ], sla => [ 54, 3903 ], sli => [ 54, 3903 ], sll => [ 54, 3903 ], sra => [ 54, 3903 ], srl => [ 54, 3903 ], stop => [ 54, 3903 ], sub => [ 54, 3903 ], xor => [ 54, 3903 ], },
	# [3904] program : "[opcode]*"
	{ "" => \&_action_end_0, },
	# [3905] term : 
	{ "!" => [ 3911, 3905 ], "+" => [ 3911, 3905 ], "-" => [ 3911, 3905 ], __else__ => 3906, "~" => [ 3911, 3905 ], },
	# [3906] term : "[unop]*"
	{ "(" => 3907, NAME => \&_action_term_2, NUMBER => \&_action_term_2, STRING => \&_action_term_2, },
	# [3907] term : "[unop]*" "("
	{ "!" => [ 10, 3908 ], "+" => [ 10, 3908 ], "-" => [ 10, 3908 ], __else__ => [ 10, 3908 ], "~" => [ 10, 3908 ], },
	# [3908] term : "[unop]*" "(" "[expr]"
	{ ")" => \&_action_term_3, },
	# [3909] term2 : 
	{ "!=" => [ 1, 3910 ], "%" => [ 1, 3910 ], "&" => [ 1, 3910 ], "&&" => [ 1, 3910 ], "*" => [ 1, 3910 ], "+" => [ 1, 3910 ], "-" => [ 1, 3910 ], "/" => [ 1, 3910 ], "<" => [ 1, 3910 ], "<<" => [ 1, 3910 ], "<=" => [ 1, 3910 ], "==" => [ 1, 3910 ], ">" => [ 1, 3910 ], ">=" => [ 1, 3910 ], ">>" => [ 1, 3910 ], "^" => [ 1, 3910 ], "|" => [ 1, 3910 ], "||" => [ 1, 3910 ], },
	# [3910] term2 : "[binop]"
	{ "!" => [ 3905, \&_action_term2_4 ], "+" => [ 3905, \&_action_term2_4 ], "-" => [ 3905, \&_action_term2_4 ], __else__ => [ 3905, \&_action_term2_4 ], "~" => [ 3905, \&_action_term2_4 ], },
	# [3911] unop : 
	{ "!" => \&_action_unop_1, "+" => \&_action_unop_1, "-" => \&_action_unop_1, "~" => \&_action_unop_1, },
);
# end : ":"
sub _action_end_0 {
	undef
}
# expr2 : "," "[expr]"
sub _action_expr2_6 {
	$_[ARGS][1]
}
# expr : "[term]" "[term2]*"
sub _action_expr_5 {
	# flat the input lists
	my @ret;
	for (@{$_[ARGS]}) {
		push(@ret, @$_);
	}
	\@ret;
}
# expr_DIS : "[expr]"
sub _action_expr_DIS_7 {
	return CPU::Z80::Assembler::Expr->new(
				child 	=> $_[ARGS][0],
				line	=> $_[ARGS][0][0]->line,
				type	=> "sb");
}
# expr_NDIS : "[expr_DIS]"
sub _action_expr_NDIS_8 {
	return $_[ARGS][0]->build("-{}");
}
# expr_NN : "[expr]"
sub _action_expr_NN_11 {
	return CPU::Z80::Assembler::Expr->new(
				child 	=> $_[ARGS][0],
				line	=> $_[ARGS][0][0]->line,
				type	=> "w");
}
# expr_N : "[expr]"
sub _action_expr_N_9 {
	return CPU::Z80::Assembler::Expr->new(
				child 	=> $_[ARGS][0],
				line	=> $_[ARGS][0][0]->line,
				type	=> "ub");
}
# expr_const : "[expr]"
sub _action_expr_const_13 {
	my $expr = CPU::Z80::Assembler::Expr->new(
				child 	=> $_[ARGS][0],
				line	=> $_[ARGS][0][0]->line);
	return $expr->evaluate();
}
# expr_list_NN : "[expr_list]"
sub _action_expr_list_NN_12 {
	# return list of NN expressions
	my @ret;
	for (@{$_[ARGS][0]}) {
		push(@ret, 
				CPU::Z80::Assembler::Expr->new(
							child 	=> $_,
							line	=> $_[ARGS][0][0][0]->line,
							type	=> "w"),
				undef,		# placeholder for second byte
			);
	}
	\@ret;
}
# expr_list_N : "[expr_list]"
sub _action_expr_list_N_10 {
	# return list of N expressions
	my @ret;
	for (@{$_[ARGS][0]}) {
		push(@ret, CPU::Z80::Assembler::Expr->new(
				child 	=> $_,
				line	=> $_[ARGS][0][0][0]->line,
				type	=> "ub"));
	}
	\@ret;
}
# expr_list_text : "[expr_text]" "[expr_text2]*"
sub _action_expr_list_text_20 {
	my @bytes;
	for (@{$_[ARGS]}) {
		push @bytes, @$_;
	}
	return \@bytes;
}
# expr_text7 : "[expr_text]"
sub _action_expr_text7_19 {
	my @bytes = ( @{ $_[ARGS][0] } );
	my $last = pop(@bytes) || 0;
	
	if (ref $last) {		# is expression
		push @bytes, $last->build("{} | 0x80");
	}
	else {					# is literal
		push @bytes, $last | 0x80;
	}
	
	return \@bytes;
}
# expr_text : "[expr_text_string]" "[cont_expr_N]?"
sub _action_expr_text_17 {
	my @bytes = @{ $_[ARGS][0] };
	
	if ( @{ $_[ARGS] } > 1 ) {
		my $last = pop(@bytes) || 0;			# last byte
		
		my $binop = $_[ARGS][1][0]->type;		# operator
		my $expr =  $_[ARGS][1][1]->build("$last $binop {}");
		
		return [ @bytes, $expr ];					
	}
	else {
		return \@bytes;
	}
}
# expr_text_number : NUMBER
sub _action_expr_text_number_16 {
	my @bytes;
	my $value = eval($_[ARGS][0]->value); $@ and die $@; # ASSERT
	while ($value) {
		unshift(@bytes, $value & 0xFF);
		$value >>= 8;
	}
	return \@bytes;
}
# expr_text_string : STRING
sub _action_expr_text_string_15 {
	my @bytes = map {ord($_)} split(//, $_[ARGS][0]->value);
	return \@bytes;
}
# expr_textz : "[expr_text]"
sub _action_expr_textz_18 {
	my @bytes = ( @{ $_[ARGS][0] }, 0 );
	return \@bytes;
}
# inline_const : "[expr]"
sub _action_inline_const_14 {
	my $expr = CPU::Z80::Assembler::Expr->new(
				child 	=> $_[ARGS][0],
				line	=> $_[ARGS][0][0]->line);
	my $value = $expr->evaluate();
	$_[INPUT]->unget(Asm::Preproc::Token->new($value,
											  $value,
											  $expr->line));
	return 0;	# return dummy value to keep index into values correct
}
# macro : macro NAME "[macro_args_optional]" "[macro_body]"
sub _action_macro_28 {
	my $name = $_[ARGS][1]->value;
	exists $_[PROG]->macros->{$name}
		and $_[ARGS][1]->error("macro $name redefined");

	my $macro = $_[ARGS][3];
	$macro->name(   $name );
	$macro->params( $_[ARGS][2] );
	$_[PROG]->macros->{$name} = $macro;
}
# macro_arg2 : "," NAME
sub _action_macro_arg2_25 {
	$_[ARGS][1]->value
}
# macro_arg : NAME
sub _action_macro_arg_24 {
	$_[ARGS][0]->value
}
# macro_args_optional : "[macro_args]?"
sub _action_macro_args_optional_26 {
	defined($_[ARGS][0]) ? $_[ARGS][0] : []
}
# macro_body : "{"
sub _action_macro_body_27 {
	$_[INPUT]->unget($_[ARGS][0]);		# push back starting token
	my $macro = CPU::Z80::Assembler::Macro->new();
	$macro->parse_body($_[INPUT]);
	return $macro;
}
# opcode : bit "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_100 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x46);
}
# opcode : res "[inline_const]" 4 "," "(" iy ")" "," h "[end]"
sub _action_opcode_1000 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xA4);
}
# opcode : res "[inline_const]" 4 "," "(" iy ")" "," l "[end]"
sub _action_opcode_1001 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xA5);
}
# opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1002 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xA6);
}
# opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1003 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xA7);
}
# opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1004 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xA0);
}
# opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1005 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xA1);
}
# opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1006 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xA2);
}
# opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1007 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xA3);
}
# opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1008 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xA4);
}
# opcode : res "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1009 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xA5);
}
# opcode : bit "[inline_const]" 0 "," a "[end]"
sub _action_opcode_101 {
	_add_opcode(@_, 0xCB, 0x47);
}
# opcode : res "[inline_const]" 4 "," a "[end]"
sub _action_opcode_1010 {
	_add_opcode(@_, 0xCB, 0xA7);
}
# opcode : res "[inline_const]" 4 "," b "[end]"
sub _action_opcode_1011 {
	_add_opcode(@_, 0xCB, 0xA0);
}
# opcode : res "[inline_const]" 4 "," c "[end]"
sub _action_opcode_1012 {
	_add_opcode(@_, 0xCB, 0xA1);
}
# opcode : res "[inline_const]" 4 "," d "[end]"
sub _action_opcode_1013 {
	_add_opcode(@_, 0xCB, 0xA2);
}
# opcode : res "[inline_const]" 4 "," e "[end]"
sub _action_opcode_1014 {
	_add_opcode(@_, 0xCB, 0xA3);
}
# opcode : res "[inline_const]" 4 "," h "[end]"
sub _action_opcode_1015 {
	_add_opcode(@_, 0xCB, 0xA4);
}
# opcode : res "[inline_const]" 4 "," l "[end]"
sub _action_opcode_1016 {
	_add_opcode(@_, 0xCB, 0xA5);
}
# opcode : res "[inline_const]" 5 "," "(" hl ")" "[end]"
sub _action_opcode_1017 {
	_add_opcode(@_, 0xCB, 0xAE);
}
# opcode : res "[inline_const]" 5 "," "(" ix ")" "[end]"
sub _action_opcode_1018 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xAE);
}
# opcode : res "[inline_const]" 5 "," "(" ix ")" "," a "[end]"
sub _action_opcode_1019 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xAF);
}
# opcode : bit "[inline_const]" 0 "," b "[end]"
sub _action_opcode_102 {
	_add_opcode(@_, 0xCB, 0x40);
}
# opcode : res "[inline_const]" 5 "," "(" ix ")" "," b "[end]"
sub _action_opcode_1020 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xA8);
}
# opcode : res "[inline_const]" 5 "," "(" ix ")" "," c "[end]"
sub _action_opcode_1021 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xA9);
}
# opcode : res "[inline_const]" 5 "," "(" ix ")" "," d "[end]"
sub _action_opcode_1022 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xAA);
}
# opcode : res "[inline_const]" 5 "," "(" ix ")" "," e "[end]"
sub _action_opcode_1023 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xAB);
}
# opcode : res "[inline_const]" 5 "," "(" ix ")" "," h "[end]"
sub _action_opcode_1024 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xAC);
}
# opcode : res "[inline_const]" 5 "," "(" ix ")" "," l "[end]"
sub _action_opcode_1025 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xAD);
}
# opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1026 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xAE);
}
# opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1027 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xAF);
}
# opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1028 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xA8);
}
# opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1029 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xA9);
}
# opcode : bit "[inline_const]" 0 "," c "[end]"
sub _action_opcode_103 {
	_add_opcode(@_, 0xCB, 0x41);
}
# opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1030 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xAA);
}
# opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1031 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xAB);
}
# opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1032 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xAC);
}
# opcode : res "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1033 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xAD);
}
# opcode : res "[inline_const]" 5 "," "(" iy ")" "[end]"
sub _action_opcode_1034 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xAE);
}
# opcode : res "[inline_const]" 5 "," "(" iy ")" "," a "[end]"
sub _action_opcode_1035 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xAF);
}
# opcode : res "[inline_const]" 5 "," "(" iy ")" "," b "[end]"
sub _action_opcode_1036 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xA8);
}
# opcode : res "[inline_const]" 5 "," "(" iy ")" "," c "[end]"
sub _action_opcode_1037 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xA9);
}
# opcode : res "[inline_const]" 5 "," "(" iy ")" "," d "[end]"
sub _action_opcode_1038 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xAA);
}
# opcode : res "[inline_const]" 5 "," "(" iy ")" "," e "[end]"
sub _action_opcode_1039 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xAB);
}
# opcode : bit "[inline_const]" 0 "," d "[end]"
sub _action_opcode_104 {
	_add_opcode(@_, 0xCB, 0x42);
}
# opcode : res "[inline_const]" 5 "," "(" iy ")" "," h "[end]"
sub _action_opcode_1040 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xAC);
}
# opcode : res "[inline_const]" 5 "," "(" iy ")" "," l "[end]"
sub _action_opcode_1041 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xAD);
}
# opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1042 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xAE);
}
# opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1043 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xAF);
}
# opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1044 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xA8);
}
# opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1045 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xA9);
}
# opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1046 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xAA);
}
# opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1047 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xAB);
}
# opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1048 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xAC);
}
# opcode : res "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1049 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xAD);
}
# opcode : bit "[inline_const]" 0 "," e "[end]"
sub _action_opcode_105 {
	_add_opcode(@_, 0xCB, 0x43);
}
# opcode : res "[inline_const]" 5 "," a "[end]"
sub _action_opcode_1050 {
	_add_opcode(@_, 0xCB, 0xAF);
}
# opcode : res "[inline_const]" 5 "," b "[end]"
sub _action_opcode_1051 {
	_add_opcode(@_, 0xCB, 0xA8);
}
# opcode : res "[inline_const]" 5 "," c "[end]"
sub _action_opcode_1052 {
	_add_opcode(@_, 0xCB, 0xA9);
}
# opcode : res "[inline_const]" 5 "," d "[end]"
sub _action_opcode_1053 {
	_add_opcode(@_, 0xCB, 0xAA);
}
# opcode : res "[inline_const]" 5 "," e "[end]"
sub _action_opcode_1054 {
	_add_opcode(@_, 0xCB, 0xAB);
}
# opcode : res "[inline_const]" 5 "," h "[end]"
sub _action_opcode_1055 {
	_add_opcode(@_, 0xCB, 0xAC);
}
# opcode : res "[inline_const]" 5 "," l "[end]"
sub _action_opcode_1056 {
	_add_opcode(@_, 0xCB, 0xAD);
}
# opcode : res "[inline_const]" 6 "," "(" hl ")" "[end]"
sub _action_opcode_1057 {
	_add_opcode(@_, 0xCB, 0xB6);
}
# opcode : res "[inline_const]" 6 "," "(" ix ")" "[end]"
sub _action_opcode_1058 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xB6);
}
# opcode : res "[inline_const]" 6 "," "(" ix ")" "," a "[end]"
sub _action_opcode_1059 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xB7);
}
# opcode : bit "[inline_const]" 0 "," h "[end]"
sub _action_opcode_106 {
	_add_opcode(@_, 0xCB, 0x44);
}
# opcode : res "[inline_const]" 6 "," "(" ix ")" "," b "[end]"
sub _action_opcode_1060 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xB0);
}
# opcode : res "[inline_const]" 6 "," "(" ix ")" "," c "[end]"
sub _action_opcode_1061 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xB1);
}
# opcode : res "[inline_const]" 6 "," "(" ix ")" "," d "[end]"
sub _action_opcode_1062 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xB2);
}
# opcode : res "[inline_const]" 6 "," "(" ix ")" "," e "[end]"
sub _action_opcode_1063 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xB3);
}
# opcode : res "[inline_const]" 6 "," "(" ix ")" "," h "[end]"
sub _action_opcode_1064 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xB4);
}
# opcode : res "[inline_const]" 6 "," "(" ix ")" "," l "[end]"
sub _action_opcode_1065 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xB5);
}
# opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1066 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xB6);
}
# opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1067 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xB7);
}
# opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1068 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xB0);
}
# opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1069 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xB1);
}
# opcode : bit "[inline_const]" 0 "," l "[end]"
sub _action_opcode_107 {
	_add_opcode(@_, 0xCB, 0x45);
}
# opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1070 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xB2);
}
# opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1071 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xB3);
}
# opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1072 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xB4);
}
# opcode : res "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1073 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xB5);
}
# opcode : res "[inline_const]" 6 "," "(" iy ")" "[end]"
sub _action_opcode_1074 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xB6);
}
# opcode : res "[inline_const]" 6 "," "(" iy ")" "," a "[end]"
sub _action_opcode_1075 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xB7);
}
# opcode : res "[inline_const]" 6 "," "(" iy ")" "," b "[end]"
sub _action_opcode_1076 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xB0);
}
# opcode : res "[inline_const]" 6 "," "(" iy ")" "," c "[end]"
sub _action_opcode_1077 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xB1);
}
# opcode : res "[inline_const]" 6 "," "(" iy ")" "," d "[end]"
sub _action_opcode_1078 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xB2);
}
# opcode : res "[inline_const]" 6 "," "(" iy ")" "," e "[end]"
sub _action_opcode_1079 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xB3);
}
# opcode : bit "[inline_const]" 1 "," "(" hl ")" "[end]"
sub _action_opcode_108 {
	_add_opcode(@_, 0xCB, 0x4E);
}
# opcode : res "[inline_const]" 6 "," "(" iy ")" "," h "[end]"
sub _action_opcode_1080 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xB4);
}
# opcode : res "[inline_const]" 6 "," "(" iy ")" "," l "[end]"
sub _action_opcode_1081 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xB5);
}
# opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1082 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xB6);
}
# opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1083 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xB7);
}
# opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1084 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xB0);
}
# opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1085 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xB1);
}
# opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1086 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xB2);
}
# opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1087 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xB3);
}
# opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1088 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xB4);
}
# opcode : res "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1089 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xB5);
}
# opcode : bit "[inline_const]" 1 "," "(" ix ")" "[end]"
sub _action_opcode_109 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x4E);
}
# opcode : res "[inline_const]" 6 "," a "[end]"
sub _action_opcode_1090 {
	_add_opcode(@_, 0xCB, 0xB7);
}
# opcode : res "[inline_const]" 6 "," b "[end]"
sub _action_opcode_1091 {
	_add_opcode(@_, 0xCB, 0xB0);
}
# opcode : res "[inline_const]" 6 "," c "[end]"
sub _action_opcode_1092 {
	_add_opcode(@_, 0xCB, 0xB1);
}
# opcode : res "[inline_const]" 6 "," d "[end]"
sub _action_opcode_1093 {
	_add_opcode(@_, 0xCB, 0xB2);
}
# opcode : res "[inline_const]" 6 "," e "[end]"
sub _action_opcode_1094 {
	_add_opcode(@_, 0xCB, 0xB3);
}
# opcode : res "[inline_const]" 6 "," h "[end]"
sub _action_opcode_1095 {
	_add_opcode(@_, 0xCB, 0xB4);
}
# opcode : res "[inline_const]" 6 "," l "[end]"
sub _action_opcode_1096 {
	_add_opcode(@_, 0xCB, 0xB5);
}
# opcode : res "[inline_const]" 7 "," "(" hl ")" "[end]"
sub _action_opcode_1097 {
	_add_opcode(@_, 0xCB, 0xBE);
}
# opcode : res "[inline_const]" 7 "," "(" ix ")" "[end]"
sub _action_opcode_1098 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xBE);
}
# opcode : res "[inline_const]" 7 "," "(" ix ")" "," a "[end]"
sub _action_opcode_1099 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xBF);
}
# opcode : bit "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_110 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x4E);
}
# opcode : res "[inline_const]" 7 "," "(" ix ")" "," b "[end]"
sub _action_opcode_1100 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xB8);
}
# opcode : res "[inline_const]" 7 "," "(" ix ")" "," c "[end]"
sub _action_opcode_1101 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xB9);
}
# opcode : res "[inline_const]" 7 "," "(" ix ")" "," d "[end]"
sub _action_opcode_1102 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xBA);
}
# opcode : res "[inline_const]" 7 "," "(" ix ")" "," e "[end]"
sub _action_opcode_1103 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xBB);
}
# opcode : res "[inline_const]" 7 "," "(" ix ")" "," h "[end]"
sub _action_opcode_1104 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xBC);
}
# opcode : res "[inline_const]" 7 "," "(" ix ")" "," l "[end]"
sub _action_opcode_1105 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xBD);
}
# opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1106 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xBE);
}
# opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1107 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xBF);
}
# opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1108 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xB8);
}
# opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1109 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xB9);
}
# opcode : bit "[inline_const]" 1 "," "(" iy ")" "[end]"
sub _action_opcode_111 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x4E);
}
# opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1110 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xBA);
}
# opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1111 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xBB);
}
# opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1112 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xBC);
}
# opcode : res "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1113 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xBD);
}
# opcode : res "[inline_const]" 7 "," "(" iy ")" "[end]"
sub _action_opcode_1114 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xBE);
}
# opcode : res "[inline_const]" 7 "," "(" iy ")" "," a "[end]"
sub _action_opcode_1115 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xBF);
}
# opcode : res "[inline_const]" 7 "," "(" iy ")" "," b "[end]"
sub _action_opcode_1116 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xB8);
}
# opcode : res "[inline_const]" 7 "," "(" iy ")" "," c "[end]"
sub _action_opcode_1117 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xB9);
}
# opcode : res "[inline_const]" 7 "," "(" iy ")" "," d "[end]"
sub _action_opcode_1118 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xBA);
}
# opcode : res "[inline_const]" 7 "," "(" iy ")" "," e "[end]"
sub _action_opcode_1119 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xBB);
}
# opcode : bit "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_112 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x4E);
}
# opcode : res "[inline_const]" 7 "," "(" iy ")" "," h "[end]"
sub _action_opcode_1120 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xBC);
}
# opcode : res "[inline_const]" 7 "," "(" iy ")" "," l "[end]"
sub _action_opcode_1121 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xBD);
}
# opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1122 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xBE);
}
# opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1123 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xBF);
}
# opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1124 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xB8);
}
# opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1125 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xB9);
}
# opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1126 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xBA);
}
# opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1127 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xBB);
}
# opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1128 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xBC);
}
# opcode : res "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1129 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xBD);
}
# opcode : bit "[inline_const]" 1 "," a "[end]"
sub _action_opcode_113 {
	_add_opcode(@_, 0xCB, 0x4F);
}
# opcode : res "[inline_const]" 7 "," a "[end]"
sub _action_opcode_1130 {
	_add_opcode(@_, 0xCB, 0xBF);
}
# opcode : res "[inline_const]" 7 "," b "[end]"
sub _action_opcode_1131 {
	_add_opcode(@_, 0xCB, 0xB8);
}
# opcode : res "[inline_const]" 7 "," c "[end]"
sub _action_opcode_1132 {
	_add_opcode(@_, 0xCB, 0xB9);
}
# opcode : res "[inline_const]" 7 "," d "[end]"
sub _action_opcode_1133 {
	_add_opcode(@_, 0xCB, 0xBA);
}
# opcode : res "[inline_const]" 7 "," e "[end]"
sub _action_opcode_1134 {
	_add_opcode(@_, 0xCB, 0xBB);
}
# opcode : res "[inline_const]" 7 "," h "[end]"
sub _action_opcode_1135 {
	_add_opcode(@_, 0xCB, 0xBC);
}
# opcode : res "[inline_const]" 7 "," l "[end]"
sub _action_opcode_1136 {
	_add_opcode(@_, 0xCB, 0xBD);
}
# opcode : ret "[end]"
sub _action_opcode_1137 {
	_add_opcode(@_, 0xC9);
}
# opcode : ret c "[end]"
sub _action_opcode_1138 {
	_add_opcode(@_, 0xD8);
}
# opcode : ret m "[end]"
sub _action_opcode_1139 {
	_add_opcode(@_, 0xF8);
}
# opcode : bit "[inline_const]" 1 "," b "[end]"
sub _action_opcode_114 {
	_add_opcode(@_, 0xCB, 0x48);
}
# opcode : ret nc "[end]"
sub _action_opcode_1140 {
	_add_opcode(@_, 0xD0);
}
# opcode : ret nz "[end]"
sub _action_opcode_1141 {
	_add_opcode(@_, 0xC0);
}
# opcode : ret p "[end]"
sub _action_opcode_1142 {
	_add_opcode(@_, 0xF0);
}
# opcode : ret pe "[end]"
sub _action_opcode_1143 {
	_add_opcode(@_, 0xE8);
}
# opcode : ret po "[end]"
sub _action_opcode_1144 {
	_add_opcode(@_, 0xE0);
}
# opcode : ret z "[end]"
sub _action_opcode_1145 {
	_add_opcode(@_, 0xC8);
}
# opcode : reti "[end]"
sub _action_opcode_1146 {
	_add_opcode(@_, 0xED, 0x4D);
}
# opcode : retn "[end]"
sub _action_opcode_1147 {
	_add_opcode(@_, 0xED, 0x45);
}
# opcode : rl "(" hl ")" "[end]"
sub _action_opcode_1148 {
	_add_opcode(@_, 0xCB, 0x16);
}
# opcode : rl "(" ix ")" "[end]"
sub _action_opcode_1149 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x16);
}
# opcode : bit "[inline_const]" 1 "," c "[end]"
sub _action_opcode_115 {
	_add_opcode(@_, 0xCB, 0x49);
}
# opcode : rl "(" ix ")" "," a "[end]"
sub _action_opcode_1150 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x17);
}
# opcode : rl "(" ix ")" "," b "[end]"
sub _action_opcode_1151 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x10);
}
# opcode : rl "(" ix ")" "," c "[end]"
sub _action_opcode_1152 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x11);
}
# opcode : rl "(" ix ")" "," d "[end]"
sub _action_opcode_1153 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x12);
}
# opcode : rl "(" ix ")" "," e "[end]"
sub _action_opcode_1154 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x13);
}
# opcode : rl "(" ix ")" "," h "[end]"
sub _action_opcode_1155 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x14);
}
# opcode : rl "(" ix ")" "," l "[end]"
sub _action_opcode_1156 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x15);
}
# opcode : rl "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1157 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x16);
}
# opcode : rl "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1158 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x17);
}
# opcode : rl "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1159 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x10);
}
# opcode : bit "[inline_const]" 1 "," d "[end]"
sub _action_opcode_116 {
	_add_opcode(@_, 0xCB, 0x4A);
}
# opcode : rl "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1160 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x11);
}
# opcode : rl "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1161 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x12);
}
# opcode : rl "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1162 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x13);
}
# opcode : rl "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1163 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x14);
}
# opcode : rl "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1164 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x15);
}
# opcode : rl "(" iy ")" "[end]"
sub _action_opcode_1165 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x16);
}
# opcode : rl "(" iy ")" "," a "[end]"
sub _action_opcode_1166 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x17);
}
# opcode : rl "(" iy ")" "," b "[end]"
sub _action_opcode_1167 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x10);
}
# opcode : rl "(" iy ")" "," c "[end]"
sub _action_opcode_1168 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x11);
}
# opcode : rl "(" iy ")" "," d "[end]"
sub _action_opcode_1169 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x12);
}
# opcode : bit "[inline_const]" 1 "," e "[end]"
sub _action_opcode_117 {
	_add_opcode(@_, 0xCB, 0x4B);
}
# opcode : rl "(" iy ")" "," e "[end]"
sub _action_opcode_1170 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x13);
}
# opcode : rl "(" iy ")" "," h "[end]"
sub _action_opcode_1171 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x14);
}
# opcode : rl "(" iy ")" "," l "[end]"
sub _action_opcode_1172 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x15);
}
# opcode : rl "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1173 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x16);
}
# opcode : rl "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1174 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x17);
}
# opcode : rl "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1175 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x10);
}
# opcode : rl "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1176 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x11);
}
# opcode : rl "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1177 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x12);
}
# opcode : rl "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1178 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x13);
}
# opcode : rl "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1179 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x14);
}
# opcode : bit "[inline_const]" 1 "," h "[end]"
sub _action_opcode_118 {
	_add_opcode(@_, 0xCB, 0x4C);
}
# opcode : rl "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1180 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x15);
}
# opcode : rl a "[end]"
sub _action_opcode_1181 {
	_add_opcode(@_, 0xCB, 0x17);
}
# opcode : rl b "[end]"
sub _action_opcode_1182 {
	_add_opcode(@_, 0xCB, 0x10);
}
# opcode : rl bc "[end]"
sub _action_opcode_1183 {
	_add_opcode(@_, 0xCB, 0x11, 0xCB, 0x10);
}
# opcode : rl c "[end]"
sub _action_opcode_1184 {
	_add_opcode(@_, 0xCB, 0x11);
}
# opcode : rl d "[end]"
sub _action_opcode_1185 {
	_add_opcode(@_, 0xCB, 0x12);
}
# opcode : rl de "[end]"
sub _action_opcode_1186 {
	_add_opcode(@_, 0xCB, 0x13, 0xCB, 0x12);
}
# opcode : rl e "[end]"
sub _action_opcode_1187 {
	_add_opcode(@_, 0xCB, 0x13);
}
# opcode : rl h "[end]"
sub _action_opcode_1188 {
	_add_opcode(@_, 0xCB, 0x14);
}
# opcode : rl hl "[end]"
sub _action_opcode_1189 {
	_add_opcode(@_, 0xCB, 0x15, 0xCB, 0x14);
}
# opcode : bit "[inline_const]" 1 "," l "[end]"
sub _action_opcode_119 {
	_add_opcode(@_, 0xCB, 0x4D);
}
# opcode : rl l "[end]"
sub _action_opcode_1190 {
	_add_opcode(@_, 0xCB, 0x15);
}
# opcode : rla "[end]"
sub _action_opcode_1191 {
	_add_opcode(@_, 0x17);
}
# opcode : rlc "(" hl ")" "[end]"
sub _action_opcode_1192 {
	_add_opcode(@_, 0xCB, 0x06);
}
# opcode : rlc "(" ix ")" "[end]"
sub _action_opcode_1193 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x06);
}
# opcode : rlc "(" ix ")" "," a "[end]"
sub _action_opcode_1194 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x07);
}
# opcode : rlc "(" ix ")" "," b "[end]"
sub _action_opcode_1195 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x00);
}
# opcode : rlc "(" ix ")" "," c "[end]"
sub _action_opcode_1196 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x01);
}
# opcode : rlc "(" ix ")" "," d "[end]"
sub _action_opcode_1197 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x02);
}
# opcode : rlc "(" ix ")" "," e "[end]"
sub _action_opcode_1198 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x03);
}
# opcode : rlc "(" ix ")" "," h "[end]"
sub _action_opcode_1199 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x04);
}
# opcode : bit "[inline_const]" 2 "," "(" hl ")" "[end]"
sub _action_opcode_120 {
	_add_opcode(@_, 0xCB, 0x56);
}
# opcode : rlc "(" ix ")" "," l "[end]"
sub _action_opcode_1200 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x05);
}
# opcode : rlc "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1201 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x06);
}
# opcode : rlc "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1202 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x07);
}
# opcode : rlc "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1203 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x00);
}
# opcode : rlc "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1204 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x01);
}
# opcode : rlc "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1205 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x02);
}
# opcode : rlc "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1206 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x03);
}
# opcode : rlc "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1207 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x04);
}
# opcode : rlc "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1208 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x05);
}
# opcode : rlc "(" iy ")" "[end]"
sub _action_opcode_1209 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x06);
}
# opcode : bit "[inline_const]" 2 "," "(" ix ")" "[end]"
sub _action_opcode_121 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x56);
}
# opcode : rlc "(" iy ")" "," a "[end]"
sub _action_opcode_1210 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x07);
}
# opcode : rlc "(" iy ")" "," b "[end]"
sub _action_opcode_1211 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x00);
}
# opcode : rlc "(" iy ")" "," c "[end]"
sub _action_opcode_1212 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x01);
}
# opcode : rlc "(" iy ")" "," d "[end]"
sub _action_opcode_1213 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x02);
}
# opcode : rlc "(" iy ")" "," e "[end]"
sub _action_opcode_1214 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x03);
}
# opcode : rlc "(" iy ")" "," h "[end]"
sub _action_opcode_1215 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x04);
}
# opcode : rlc "(" iy ")" "," l "[end]"
sub _action_opcode_1216 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x05);
}
# opcode : rlc "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1217 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x06);
}
# opcode : rlc "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1218 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x07);
}
# opcode : rlc "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1219 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x00);
}
# opcode : bit "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_122 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x56);
}
# opcode : rlc "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1220 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x01);
}
# opcode : rlc "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1221 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x02);
}
# opcode : rlc "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1222 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x03);
}
# opcode : rlc "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1223 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x04);
}
# opcode : rlc "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1224 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x05);
}
# opcode : rlc a "[end]"
sub _action_opcode_1225 {
	_add_opcode(@_, 0xCB, 0x07);
}
# opcode : rlc b "[end]"
sub _action_opcode_1226 {
	_add_opcode(@_, 0xCB, 0x00);
}
# opcode : rlc c "[end]"
sub _action_opcode_1227 {
	_add_opcode(@_, 0xCB, 0x01);
}
# opcode : rlc d "[end]"
sub _action_opcode_1228 {
	_add_opcode(@_, 0xCB, 0x02);
}
# opcode : rlc e "[end]"
sub _action_opcode_1229 {
	_add_opcode(@_, 0xCB, 0x03);
}
# opcode : bit "[inline_const]" 2 "," "(" iy ")" "[end]"
sub _action_opcode_123 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x56);
}
# opcode : rlc h "[end]"
sub _action_opcode_1230 {
	_add_opcode(@_, 0xCB, 0x04);
}
# opcode : rlc l "[end]"
sub _action_opcode_1231 {
	_add_opcode(@_, 0xCB, 0x05);
}
# opcode : rlca "[end]"
sub _action_opcode_1232 {
	_add_opcode(@_, 0x07);
}
# opcode : rld "[end]"
sub _action_opcode_1233 {
	_add_opcode(@_, 0xED, 0x6F);
}
# opcode : rr "(" hl ")" "[end]"
sub _action_opcode_1234 {
	_add_opcode(@_, 0xCB, 0x1E);
}
# opcode : rr "(" ix ")" "[end]"
sub _action_opcode_1235 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x1E);
}
# opcode : rr "(" ix ")" "," a "[end]"
sub _action_opcode_1236 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x1F);
}
# opcode : rr "(" ix ")" "," b "[end]"
sub _action_opcode_1237 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x18);
}
# opcode : rr "(" ix ")" "," c "[end]"
sub _action_opcode_1238 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x19);
}
# opcode : rr "(" ix ")" "," d "[end]"
sub _action_opcode_1239 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x1A);
}
# opcode : bit "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_124 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x56);
}
# opcode : rr "(" ix ")" "," e "[end]"
sub _action_opcode_1240 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x1B);
}
# opcode : rr "(" ix ")" "," h "[end]"
sub _action_opcode_1241 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x1C);
}
# opcode : rr "(" ix ")" "," l "[end]"
sub _action_opcode_1242 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x1D);
}
# opcode : rr "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1243 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x1E);
}
# opcode : rr "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1244 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x1F);
}
# opcode : rr "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1245 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x18);
}
# opcode : rr "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1246 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x19);
}
# opcode : rr "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1247 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x1A);
}
# opcode : rr "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1248 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x1B);
}
# opcode : rr "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1249 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x1C);
}
# opcode : bit "[inline_const]" 2 "," a "[end]"
sub _action_opcode_125 {
	_add_opcode(@_, 0xCB, 0x57);
}
# opcode : rr "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1250 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x1D);
}
# opcode : rr "(" iy ")" "[end]"
sub _action_opcode_1251 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x1E);
}
# opcode : rr "(" iy ")" "," a "[end]"
sub _action_opcode_1252 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x1F);
}
# opcode : rr "(" iy ")" "," b "[end]"
sub _action_opcode_1253 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x18);
}
# opcode : rr "(" iy ")" "," c "[end]"
sub _action_opcode_1254 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x19);
}
# opcode : rr "(" iy ")" "," d "[end]"
sub _action_opcode_1255 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x1A);
}
# opcode : rr "(" iy ")" "," e "[end]"
sub _action_opcode_1256 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x1B);
}
# opcode : rr "(" iy ")" "," h "[end]"
sub _action_opcode_1257 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x1C);
}
# opcode : rr "(" iy ")" "," l "[end]"
sub _action_opcode_1258 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x1D);
}
# opcode : rr "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1259 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x1E);
}
# opcode : bit "[inline_const]" 2 "," b "[end]"
sub _action_opcode_126 {
	_add_opcode(@_, 0xCB, 0x50);
}
# opcode : rr "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1260 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x1F);
}
# opcode : rr "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1261 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x18);
}
# opcode : rr "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1262 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x19);
}
# opcode : rr "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1263 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x1A);
}
# opcode : rr "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1264 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x1B);
}
# opcode : rr "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1265 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x1C);
}
# opcode : rr "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1266 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x1D);
}
# opcode : rr a "[end]"
sub _action_opcode_1267 {
	_add_opcode(@_, 0xCB, 0x1F);
}
# opcode : rr b "[end]"
sub _action_opcode_1268 {
	_add_opcode(@_, 0xCB, 0x18);
}
# opcode : rr bc "[end]"
sub _action_opcode_1269 {
	_add_opcode(@_, 0xCB, 0x18, 0xCB, 0x19);
}
# opcode : bit "[inline_const]" 2 "," c "[end]"
sub _action_opcode_127 {
	_add_opcode(@_, 0xCB, 0x51);
}
# opcode : rr c "[end]"
sub _action_opcode_1270 {
	_add_opcode(@_, 0xCB, 0x19);
}
# opcode : rr d "[end]"
sub _action_opcode_1271 {
	_add_opcode(@_, 0xCB, 0x1A);
}
# opcode : rr de "[end]"
sub _action_opcode_1272 {
	_add_opcode(@_, 0xCB, 0x1A, 0xCB, 0x1B);
}
# opcode : rr e "[end]"
sub _action_opcode_1273 {
	_add_opcode(@_, 0xCB, 0x1B);
}
# opcode : rr h "[end]"
sub _action_opcode_1274 {
	_add_opcode(@_, 0xCB, 0x1C);
}
# opcode : rr hl "[end]"
sub _action_opcode_1275 {
	_add_opcode(@_, 0xCB, 0x1C, 0xCB, 0x1D);
}
# opcode : rr l "[end]"
sub _action_opcode_1276 {
	_add_opcode(@_, 0xCB, 0x1D);
}
# opcode : rra "[end]"
sub _action_opcode_1277 {
	_add_opcode(@_, 0x1F);
}
# opcode : rrc "(" hl ")" "[end]"
sub _action_opcode_1278 {
	_add_opcode(@_, 0xCB, 0x0E);
}
# opcode : rrc "(" ix ")" "[end]"
sub _action_opcode_1279 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x0E);
}
# opcode : bit "[inline_const]" 2 "," d "[end]"
sub _action_opcode_128 {
	_add_opcode(@_, 0xCB, 0x52);
}
# opcode : rrc "(" ix ")" "," a "[end]"
sub _action_opcode_1280 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x0F);
}
# opcode : rrc "(" ix ")" "," b "[end]"
sub _action_opcode_1281 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x08);
}
# opcode : rrc "(" ix ")" "," c "[end]"
sub _action_opcode_1282 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x09);
}
# opcode : rrc "(" ix ")" "," d "[end]"
sub _action_opcode_1283 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x0A);
}
# opcode : rrc "(" ix ")" "," e "[end]"
sub _action_opcode_1284 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x0B);
}
# opcode : rrc "(" ix ")" "," h "[end]"
sub _action_opcode_1285 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x0C);
}
# opcode : rrc "(" ix ")" "," l "[end]"
sub _action_opcode_1286 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x0D);
}
# opcode : rrc "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1287 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x0E);
}
# opcode : rrc "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1288 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x0F);
}
# opcode : rrc "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1289 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x08);
}
# opcode : bit "[inline_const]" 2 "," e "[end]"
sub _action_opcode_129 {
	_add_opcode(@_, 0xCB, 0x53);
}
# opcode : rrc "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1290 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x09);
}
# opcode : rrc "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1291 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x0A);
}
# opcode : rrc "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1292 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x0B);
}
# opcode : rrc "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1293 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x0C);
}
# opcode : rrc "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1294 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x0D);
}
# opcode : rrc "(" iy ")" "[end]"
sub _action_opcode_1295 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x0E);
}
# opcode : rrc "(" iy ")" "," a "[end]"
sub _action_opcode_1296 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x0F);
}
# opcode : rrc "(" iy ")" "," b "[end]"
sub _action_opcode_1297 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x08);
}
# opcode : rrc "(" iy ")" "," c "[end]"
sub _action_opcode_1298 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x09);
}
# opcode : rrc "(" iy ")" "," d "[end]"
sub _action_opcode_1299 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x0A);
}
# opcode : bit "[inline_const]" 2 "," h "[end]"
sub _action_opcode_130 {
	_add_opcode(@_, 0xCB, 0x54);
}
# opcode : rrc "(" iy ")" "," e "[end]"
sub _action_opcode_1300 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x0B);
}
# opcode : rrc "(" iy ")" "," h "[end]"
sub _action_opcode_1301 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x0C);
}
# opcode : rrc "(" iy ")" "," l "[end]"
sub _action_opcode_1302 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x0D);
}
# opcode : rrc "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1303 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x0E);
}
# opcode : rrc "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1304 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x0F);
}
# opcode : rrc "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1305 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x08);
}
# opcode : rrc "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1306 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x09);
}
# opcode : rrc "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1307 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x0A);
}
# opcode : rrc "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1308 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x0B);
}
# opcode : rrc "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1309 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x0C);
}
# opcode : bit "[inline_const]" 2 "," l "[end]"
sub _action_opcode_131 {
	_add_opcode(@_, 0xCB, 0x55);
}
# opcode : rrc "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1310 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x0D);
}
# opcode : rrc a "[end]"
sub _action_opcode_1311 {
	_add_opcode(@_, 0xCB, 0x0F);
}
# opcode : rrc b "[end]"
sub _action_opcode_1312 {
	_add_opcode(@_, 0xCB, 0x08);
}
# opcode : rrc c "[end]"
sub _action_opcode_1313 {
	_add_opcode(@_, 0xCB, 0x09);
}
# opcode : rrc d "[end]"
sub _action_opcode_1314 {
	_add_opcode(@_, 0xCB, 0x0A);
}
# opcode : rrc e "[end]"
sub _action_opcode_1315 {
	_add_opcode(@_, 0xCB, 0x0B);
}
# opcode : rrc h "[end]"
sub _action_opcode_1316 {
	_add_opcode(@_, 0xCB, 0x0C);
}
# opcode : rrc l "[end]"
sub _action_opcode_1317 {
	_add_opcode(@_, 0xCB, 0x0D);
}
# opcode : rrca "[end]"
sub _action_opcode_1318 {
	_add_opcode(@_, 0x0F);
}
# opcode : rrd "[end]"
sub _action_opcode_1319 {
	_add_opcode(@_, 0xED, 0x67);
}
# opcode : bit "[inline_const]" 3 "," "(" hl ")" "[end]"
sub _action_opcode_132 {
	_add_opcode(@_, 0xCB, 0x5E);
}
# opcode : rst "[inline_const]" 0 "[end]"
sub _action_opcode_1320 {
	_add_opcode(@_, 0xC7);
}
# opcode : rst "[inline_const]" 1 "[end]"
sub _action_opcode_1321 {
	_add_opcode(@_, 0xCF);
}
# opcode : rst "[inline_const]" 16 "[end]"
sub _action_opcode_1322 {
	_add_opcode(@_, 0xD7);
}
# opcode : rst "[inline_const]" 24 "[end]"
sub _action_opcode_1323 {
	_add_opcode(@_, 0xDF);
}
# opcode : rst "[inline_const]" 32 "[end]"
sub _action_opcode_1324 {
	_add_opcode(@_, 0xE7);
}
# opcode : rst "[inline_const]" 40 "[end]"
sub _action_opcode_1325 {
	_add_opcode(@_, 0xEF);
}
# opcode : rst "[inline_const]" 48 "[end]"
sub _action_opcode_1326 {
	_add_opcode(@_, 0xF7);
}
# opcode : rst "[inline_const]" 56 "[end]"
sub _action_opcode_1327 {
	_add_opcode(@_, 0xFF);
}
# opcode : sbc a "," "(" hl ")" "[end]"
sub _action_opcode_1328 {
	_add_opcode(@_, 0x9E);
}
# opcode : sbc a "," "(" ix ")" "[end]"
sub _action_opcode_1329 {
	_add_opcode(@_, 0xDD, 0x9E, 0x00);
}
# opcode : bit "[inline_const]" 3 "," "(" ix ")" "[end]"
sub _action_opcode_133 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x5E);
}
# opcode : sbc a "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1330 {
	_add_opcode(@_, 0xDD, 0x9E, $_[ARGS][6]);
}
# opcode : sbc a "," "(" iy ")" "[end]"
sub _action_opcode_1331 {
	_add_opcode(@_, 0xFD, 0x9E, 0x00);
}
# opcode : sbc a "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1332 {
	_add_opcode(@_, 0xFD, 0x9E, $_[ARGS][6]);
}
# opcode : sbc a "," "[expr_N]" "[end]"
sub _action_opcode_1333 {
	_add_opcode(@_, 0xDE, $_[ARGS][3]);
}
# opcode : sbc a "," a "[end]"
sub _action_opcode_1334 {
	_add_opcode(@_, 0x9F);
}
# opcode : sbc a "," b "[end]"
sub _action_opcode_1335 {
	_add_opcode(@_, 0x98);
}
# opcode : sbc a "," c "[end]"
sub _action_opcode_1336 {
	_add_opcode(@_, 0x99);
}
# opcode : sbc a "," d "[end]"
sub _action_opcode_1337 {
	_add_opcode(@_, 0x9A);
}
# opcode : sbc a "," e "[end]"
sub _action_opcode_1338 {
	_add_opcode(@_, 0x9B);
}
# opcode : sbc a "," h "[end]"
sub _action_opcode_1339 {
	_add_opcode(@_, 0x9C);
}
# opcode : bit "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_134 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x5E);
}
# opcode : sbc a "," ixh "[end]"
sub _action_opcode_1340 {
	_add_opcode(@_, 0xDD, 0x9C);
}
# opcode : sbc a "," ixl "[end]"
sub _action_opcode_1341 {
	_add_opcode(@_, 0xDD, 0x9D);
}
# opcode : sbc a "," iyh "[end]"
sub _action_opcode_1342 {
	_add_opcode(@_, 0xFD, 0x9C);
}
# opcode : sbc a "," iyl "[end]"
sub _action_opcode_1343 {
	_add_opcode(@_, 0xFD, 0x9D);
}
# opcode : sbc a "," l "[end]"
sub _action_opcode_1344 {
	_add_opcode(@_, 0x9D);
}
# opcode : sbc hl "," bc "[end]"
sub _action_opcode_1345 {
	_add_opcode(@_, 0xED, 0x42);
}
# opcode : sbc hl "," de "[end]"
sub _action_opcode_1346 {
	_add_opcode(@_, 0xED, 0x52);
}
# opcode : sbc hl "," hl "[end]"
sub _action_opcode_1347 {
	_add_opcode(@_, 0xED, 0x62);
}
# opcode : sbc hl "," sp "[end]"
sub _action_opcode_1348 {
	_add_opcode(@_, 0xED, 0x72);
}
# opcode : scf "[end]"
sub _action_opcode_1349 {
	_add_opcode(@_, 0x37);
}
# opcode : bit "[inline_const]" 3 "," "(" iy ")" "[end]"
sub _action_opcode_135 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x5E);
}
# opcode : set "[inline_const]" 0 "," "(" hl ")" "[end]"
sub _action_opcode_1350 {
	_add_opcode(@_, 0xCB, 0xC6);
}
# opcode : set "[inline_const]" 0 "," "(" ix ")" "[end]"
sub _action_opcode_1351 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xC6);
}
# opcode : set "[inline_const]" 0 "," "(" ix ")" "," a "[end]"
sub _action_opcode_1352 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xC7);
}
# opcode : set "[inline_const]" 0 "," "(" ix ")" "," b "[end]"
sub _action_opcode_1353 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xC0);
}
# opcode : set "[inline_const]" 0 "," "(" ix ")" "," c "[end]"
sub _action_opcode_1354 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xC1);
}
# opcode : set "[inline_const]" 0 "," "(" ix ")" "," d "[end]"
sub _action_opcode_1355 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xC2);
}
# opcode : set "[inline_const]" 0 "," "(" ix ")" "," e "[end]"
sub _action_opcode_1356 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xC3);
}
# opcode : set "[inline_const]" 0 "," "(" ix ")" "," h "[end]"
sub _action_opcode_1357 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xC4);
}
# opcode : set "[inline_const]" 0 "," "(" ix ")" "," l "[end]"
sub _action_opcode_1358 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xC5);
}
# opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1359 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xC6);
}
# opcode : bit "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_136 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x5E);
}
# opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1360 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xC7);
}
# opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1361 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xC0);
}
# opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1362 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xC1);
}
# opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1363 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xC2);
}
# opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1364 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xC3);
}
# opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1365 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xC4);
}
# opcode : set "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1366 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xC5);
}
# opcode : set "[inline_const]" 0 "," "(" iy ")" "[end]"
sub _action_opcode_1367 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xC6);
}
# opcode : set "[inline_const]" 0 "," "(" iy ")" "," a "[end]"
sub _action_opcode_1368 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xC7);
}
# opcode : set "[inline_const]" 0 "," "(" iy ")" "," b "[end]"
sub _action_opcode_1369 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xC0);
}
# opcode : bit "[inline_const]" 3 "," a "[end]"
sub _action_opcode_137 {
	_add_opcode(@_, 0xCB, 0x5F);
}
# opcode : set "[inline_const]" 0 "," "(" iy ")" "," c "[end]"
sub _action_opcode_1370 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xC1);
}
# opcode : set "[inline_const]" 0 "," "(" iy ")" "," d "[end]"
sub _action_opcode_1371 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xC2);
}
# opcode : set "[inline_const]" 0 "," "(" iy ")" "," e "[end]"
sub _action_opcode_1372 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xC3);
}
# opcode : set "[inline_const]" 0 "," "(" iy ")" "," h "[end]"
sub _action_opcode_1373 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xC4);
}
# opcode : set "[inline_const]" 0 "," "(" iy ")" "," l "[end]"
sub _action_opcode_1374 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xC5);
}
# opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1375 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xC6);
}
# opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1376 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xC7);
}
# opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1377 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xC0);
}
# opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1378 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xC1);
}
# opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1379 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xC2);
}
# opcode : bit "[inline_const]" 3 "," b "[end]"
sub _action_opcode_138 {
	_add_opcode(@_, 0xCB, 0x58);
}
# opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1380 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xC3);
}
# opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1381 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xC4);
}
# opcode : set "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1382 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xC5);
}
# opcode : set "[inline_const]" 0 "," a "[end]"
sub _action_opcode_1383 {
	_add_opcode(@_, 0xCB, 0xC7);
}
# opcode : set "[inline_const]" 0 "," b "[end]"
sub _action_opcode_1384 {
	_add_opcode(@_, 0xCB, 0xC0);
}
# opcode : set "[inline_const]" 0 "," c "[end]"
sub _action_opcode_1385 {
	_add_opcode(@_, 0xCB, 0xC1);
}
# opcode : set "[inline_const]" 0 "," d "[end]"
sub _action_opcode_1386 {
	_add_opcode(@_, 0xCB, 0xC2);
}
# opcode : set "[inline_const]" 0 "," e "[end]"
sub _action_opcode_1387 {
	_add_opcode(@_, 0xCB, 0xC3);
}
# opcode : set "[inline_const]" 0 "," h "[end]"
sub _action_opcode_1388 {
	_add_opcode(@_, 0xCB, 0xC4);
}
# opcode : set "[inline_const]" 0 "," l "[end]"
sub _action_opcode_1389 {
	_add_opcode(@_, 0xCB, 0xC5);
}
# opcode : bit "[inline_const]" 3 "," c "[end]"
sub _action_opcode_139 {
	_add_opcode(@_, 0xCB, 0x59);
}
# opcode : set "[inline_const]" 1 "," "(" hl ")" "[end]"
sub _action_opcode_1390 {
	_add_opcode(@_, 0xCB, 0xCE);
}
# opcode : set "[inline_const]" 1 "," "(" ix ")" "[end]"
sub _action_opcode_1391 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xCE);
}
# opcode : set "[inline_const]" 1 "," "(" ix ")" "," a "[end]"
sub _action_opcode_1392 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xCF);
}
# opcode : set "[inline_const]" 1 "," "(" ix ")" "," b "[end]"
sub _action_opcode_1393 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xC8);
}
# opcode : set "[inline_const]" 1 "," "(" ix ")" "," c "[end]"
sub _action_opcode_1394 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xC9);
}
# opcode : set "[inline_const]" 1 "," "(" ix ")" "," d "[end]"
sub _action_opcode_1395 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xCA);
}
# opcode : set "[inline_const]" 1 "," "(" ix ")" "," e "[end]"
sub _action_opcode_1396 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xCB);
}
# opcode : set "[inline_const]" 1 "," "(" ix ")" "," h "[end]"
sub _action_opcode_1397 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xCC);
}
# opcode : set "[inline_const]" 1 "," "(" ix ")" "," l "[end]"
sub _action_opcode_1398 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xCD);
}
# opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1399 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xCE);
}
# opcode : bit "[inline_const]" 3 "," d "[end]"
sub _action_opcode_140 {
	_add_opcode(@_, 0xCB, 0x5A);
}
# opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1400 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xCF);
}
# opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1401 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xC8);
}
# opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1402 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xC9);
}
# opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1403 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xCA);
}
# opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1404 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xCB);
}
# opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1405 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xCC);
}
# opcode : set "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1406 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xCD);
}
# opcode : set "[inline_const]" 1 "," "(" iy ")" "[end]"
sub _action_opcode_1407 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xCE);
}
# opcode : set "[inline_const]" 1 "," "(" iy ")" "," a "[end]"
sub _action_opcode_1408 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xCF);
}
# opcode : set "[inline_const]" 1 "," "(" iy ")" "," b "[end]"
sub _action_opcode_1409 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xC8);
}
# opcode : bit "[inline_const]" 3 "," e "[end]"
sub _action_opcode_141 {
	_add_opcode(@_, 0xCB, 0x5B);
}
# opcode : set "[inline_const]" 1 "," "(" iy ")" "," c "[end]"
sub _action_opcode_1410 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xC9);
}
# opcode : set "[inline_const]" 1 "," "(" iy ")" "," d "[end]"
sub _action_opcode_1411 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xCA);
}
# opcode : set "[inline_const]" 1 "," "(" iy ")" "," e "[end]"
sub _action_opcode_1412 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xCB);
}
# opcode : set "[inline_const]" 1 "," "(" iy ")" "," h "[end]"
sub _action_opcode_1413 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xCC);
}
# opcode : set "[inline_const]" 1 "," "(" iy ")" "," l "[end]"
sub _action_opcode_1414 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xCD);
}
# opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1415 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xCE);
}
# opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1416 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xCF);
}
# opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1417 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xC8);
}
# opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1418 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xC9);
}
# opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1419 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xCA);
}
# opcode : bit "[inline_const]" 3 "," h "[end]"
sub _action_opcode_142 {
	_add_opcode(@_, 0xCB, 0x5C);
}
# opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1420 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xCB);
}
# opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1421 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xCC);
}
# opcode : set "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1422 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xCD);
}
# opcode : set "[inline_const]" 1 "," a "[end]"
sub _action_opcode_1423 {
	_add_opcode(@_, 0xCB, 0xCF);
}
# opcode : set "[inline_const]" 1 "," b "[end]"
sub _action_opcode_1424 {
	_add_opcode(@_, 0xCB, 0xC8);
}
# opcode : set "[inline_const]" 1 "," c "[end]"
sub _action_opcode_1425 {
	_add_opcode(@_, 0xCB, 0xC9);
}
# opcode : set "[inline_const]" 1 "," d "[end]"
sub _action_opcode_1426 {
	_add_opcode(@_, 0xCB, 0xCA);
}
# opcode : set "[inline_const]" 1 "," e "[end]"
sub _action_opcode_1427 {
	_add_opcode(@_, 0xCB, 0xCB);
}
# opcode : set "[inline_const]" 1 "," h "[end]"
sub _action_opcode_1428 {
	_add_opcode(@_, 0xCB, 0xCC);
}
# opcode : set "[inline_const]" 1 "," l "[end]"
sub _action_opcode_1429 {
	_add_opcode(@_, 0xCB, 0xCD);
}
# opcode : bit "[inline_const]" 3 "," l "[end]"
sub _action_opcode_143 {
	_add_opcode(@_, 0xCB, 0x5D);
}
# opcode : set "[inline_const]" 2 "," "(" hl ")" "[end]"
sub _action_opcode_1430 {
	_add_opcode(@_, 0xCB, 0xD6);
}
# opcode : set "[inline_const]" 2 "," "(" ix ")" "[end]"
sub _action_opcode_1431 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xD6);
}
# opcode : set "[inline_const]" 2 "," "(" ix ")" "," a "[end]"
sub _action_opcode_1432 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xD7);
}
# opcode : set "[inline_const]" 2 "," "(" ix ")" "," b "[end]"
sub _action_opcode_1433 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xD0);
}
# opcode : set "[inline_const]" 2 "," "(" ix ")" "," c "[end]"
sub _action_opcode_1434 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xD1);
}
# opcode : set "[inline_const]" 2 "," "(" ix ")" "," d "[end]"
sub _action_opcode_1435 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xD2);
}
# opcode : set "[inline_const]" 2 "," "(" ix ")" "," e "[end]"
sub _action_opcode_1436 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xD3);
}
# opcode : set "[inline_const]" 2 "," "(" ix ")" "," h "[end]"
sub _action_opcode_1437 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xD4);
}
# opcode : set "[inline_const]" 2 "," "(" ix ")" "," l "[end]"
sub _action_opcode_1438 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xD5);
}
# opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1439 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xD6);
}
# opcode : bit "[inline_const]" 4 "," "(" hl ")" "[end]"
sub _action_opcode_144 {
	_add_opcode(@_, 0xCB, 0x66);
}
# opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1440 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xD7);
}
# opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1441 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xD0);
}
# opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1442 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xD1);
}
# opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1443 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xD2);
}
# opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1444 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xD3);
}
# opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1445 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xD4);
}
# opcode : set "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1446 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xD5);
}
# opcode : set "[inline_const]" 2 "," "(" iy ")" "[end]"
sub _action_opcode_1447 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xD6);
}
# opcode : set "[inline_const]" 2 "," "(" iy ")" "," a "[end]"
sub _action_opcode_1448 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xD7);
}
# opcode : set "[inline_const]" 2 "," "(" iy ")" "," b "[end]"
sub _action_opcode_1449 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xD0);
}
# opcode : bit "[inline_const]" 4 "," "(" ix ")" "[end]"
sub _action_opcode_145 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x66);
}
# opcode : set "[inline_const]" 2 "," "(" iy ")" "," c "[end]"
sub _action_opcode_1450 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xD1);
}
# opcode : set "[inline_const]" 2 "," "(" iy ")" "," d "[end]"
sub _action_opcode_1451 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xD2);
}
# opcode : set "[inline_const]" 2 "," "(" iy ")" "," e "[end]"
sub _action_opcode_1452 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xD3);
}
# opcode : set "[inline_const]" 2 "," "(" iy ")" "," h "[end]"
sub _action_opcode_1453 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xD4);
}
# opcode : set "[inline_const]" 2 "," "(" iy ")" "," l "[end]"
sub _action_opcode_1454 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xD5);
}
# opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1455 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xD6);
}
# opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1456 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xD7);
}
# opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1457 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xD0);
}
# opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1458 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xD1);
}
# opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1459 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xD2);
}
# opcode : bit "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_146 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x66);
}
# opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1460 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xD3);
}
# opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1461 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xD4);
}
# opcode : set "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1462 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xD5);
}
# opcode : set "[inline_const]" 2 "," a "[end]"
sub _action_opcode_1463 {
	_add_opcode(@_, 0xCB, 0xD7);
}
# opcode : set "[inline_const]" 2 "," b "[end]"
sub _action_opcode_1464 {
	_add_opcode(@_, 0xCB, 0xD0);
}
# opcode : set "[inline_const]" 2 "," c "[end]"
sub _action_opcode_1465 {
	_add_opcode(@_, 0xCB, 0xD1);
}
# opcode : set "[inline_const]" 2 "," d "[end]"
sub _action_opcode_1466 {
	_add_opcode(@_, 0xCB, 0xD2);
}
# opcode : set "[inline_const]" 2 "," e "[end]"
sub _action_opcode_1467 {
	_add_opcode(@_, 0xCB, 0xD3);
}
# opcode : set "[inline_const]" 2 "," h "[end]"
sub _action_opcode_1468 {
	_add_opcode(@_, 0xCB, 0xD4);
}
# opcode : set "[inline_const]" 2 "," l "[end]"
sub _action_opcode_1469 {
	_add_opcode(@_, 0xCB, 0xD5);
}
# opcode : bit "[inline_const]" 4 "," "(" iy ")" "[end]"
sub _action_opcode_147 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x66);
}
# opcode : set "[inline_const]" 3 "," "(" hl ")" "[end]"
sub _action_opcode_1470 {
	_add_opcode(@_, 0xCB, 0xDE);
}
# opcode : set "[inline_const]" 3 "," "(" ix ")" "[end]"
sub _action_opcode_1471 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xDE);
}
# opcode : set "[inline_const]" 3 "," "(" ix ")" "," a "[end]"
sub _action_opcode_1472 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xDF);
}
# opcode : set "[inline_const]" 3 "," "(" ix ")" "," b "[end]"
sub _action_opcode_1473 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xD8);
}
# opcode : set "[inline_const]" 3 "," "(" ix ")" "," c "[end]"
sub _action_opcode_1474 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xD9);
}
# opcode : set "[inline_const]" 3 "," "(" ix ")" "," d "[end]"
sub _action_opcode_1475 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xDA);
}
# opcode : set "[inline_const]" 3 "," "(" ix ")" "," e "[end]"
sub _action_opcode_1476 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xDB);
}
# opcode : set "[inline_const]" 3 "," "(" ix ")" "," h "[end]"
sub _action_opcode_1477 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xDC);
}
# opcode : set "[inline_const]" 3 "," "(" ix ")" "," l "[end]"
sub _action_opcode_1478 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xDD);
}
# opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1479 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xDE);
}
# opcode : bit "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_148 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x66);
}
# opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1480 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xDF);
}
# opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1481 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xD8);
}
# opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1482 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xD9);
}
# opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1483 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xDA);
}
# opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1484 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xDB);
}
# opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1485 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xDC);
}
# opcode : set "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1486 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xDD);
}
# opcode : set "[inline_const]" 3 "," "(" iy ")" "[end]"
sub _action_opcode_1487 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xDE);
}
# opcode : set "[inline_const]" 3 "," "(" iy ")" "," a "[end]"
sub _action_opcode_1488 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xDF);
}
# opcode : set "[inline_const]" 3 "," "(" iy ")" "," b "[end]"
sub _action_opcode_1489 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xD8);
}
# opcode : bit "[inline_const]" 4 "," a "[end]"
sub _action_opcode_149 {
	_add_opcode(@_, 0xCB, 0x67);
}
# opcode : set "[inline_const]" 3 "," "(" iy ")" "," c "[end]"
sub _action_opcode_1490 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xD9);
}
# opcode : set "[inline_const]" 3 "," "(" iy ")" "," d "[end]"
sub _action_opcode_1491 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xDA);
}
# opcode : set "[inline_const]" 3 "," "(" iy ")" "," e "[end]"
sub _action_opcode_1492 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xDB);
}
# opcode : set "[inline_const]" 3 "," "(" iy ")" "," h "[end]"
sub _action_opcode_1493 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xDC);
}
# opcode : set "[inline_const]" 3 "," "(" iy ")" "," l "[end]"
sub _action_opcode_1494 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xDD);
}
# opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1495 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xDE);
}
# opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1496 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xDF);
}
# opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1497 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xD8);
}
# opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1498 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xD9);
}
# opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1499 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xDA);
}
# opcode : bit "[inline_const]" 4 "," b "[end]"
sub _action_opcode_150 {
	_add_opcode(@_, 0xCB, 0x60);
}
# opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1500 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xDB);
}
# opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1501 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xDC);
}
# opcode : set "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1502 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xDD);
}
# opcode : set "[inline_const]" 3 "," a "[end]"
sub _action_opcode_1503 {
	_add_opcode(@_, 0xCB, 0xDF);
}
# opcode : set "[inline_const]" 3 "," b "[end]"
sub _action_opcode_1504 {
	_add_opcode(@_, 0xCB, 0xD8);
}
# opcode : set "[inline_const]" 3 "," c "[end]"
sub _action_opcode_1505 {
	_add_opcode(@_, 0xCB, 0xD9);
}
# opcode : set "[inline_const]" 3 "," d "[end]"
sub _action_opcode_1506 {
	_add_opcode(@_, 0xCB, 0xDA);
}
# opcode : set "[inline_const]" 3 "," e "[end]"
sub _action_opcode_1507 {
	_add_opcode(@_, 0xCB, 0xDB);
}
# opcode : set "[inline_const]" 3 "," h "[end]"
sub _action_opcode_1508 {
	_add_opcode(@_, 0xCB, 0xDC);
}
# opcode : set "[inline_const]" 3 "," l "[end]"
sub _action_opcode_1509 {
	_add_opcode(@_, 0xCB, 0xDD);
}
# opcode : bit "[inline_const]" 4 "," c "[end]"
sub _action_opcode_151 {
	_add_opcode(@_, 0xCB, 0x61);
}
# opcode : set "[inline_const]" 4 "," "(" hl ")" "[end]"
sub _action_opcode_1510 {
	_add_opcode(@_, 0xCB, 0xE6);
}
# opcode : set "[inline_const]" 4 "," "(" ix ")" "[end]"
sub _action_opcode_1511 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xE6);
}
# opcode : set "[inline_const]" 4 "," "(" ix ")" "," a "[end]"
sub _action_opcode_1512 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xE7);
}
# opcode : set "[inline_const]" 4 "," "(" ix ")" "," b "[end]"
sub _action_opcode_1513 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xE0);
}
# opcode : set "[inline_const]" 4 "," "(" ix ")" "," c "[end]"
sub _action_opcode_1514 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xE1);
}
# opcode : set "[inline_const]" 4 "," "(" ix ")" "," d "[end]"
sub _action_opcode_1515 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xE2);
}
# opcode : set "[inline_const]" 4 "," "(" ix ")" "," e "[end]"
sub _action_opcode_1516 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xE3);
}
# opcode : set "[inline_const]" 4 "," "(" ix ")" "," h "[end]"
sub _action_opcode_1517 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xE4);
}
# opcode : set "[inline_const]" 4 "," "(" ix ")" "," l "[end]"
sub _action_opcode_1518 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xE5);
}
# opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1519 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xE6);
}
# opcode : bit "[inline_const]" 4 "," d "[end]"
sub _action_opcode_152 {
	_add_opcode(@_, 0xCB, 0x62);
}
# opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1520 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xE7);
}
# opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1521 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xE0);
}
# opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1522 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xE1);
}
# opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1523 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xE2);
}
# opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1524 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xE3);
}
# opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1525 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xE4);
}
# opcode : set "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1526 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xE5);
}
# opcode : set "[inline_const]" 4 "," "(" iy ")" "[end]"
sub _action_opcode_1527 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xE6);
}
# opcode : set "[inline_const]" 4 "," "(" iy ")" "," a "[end]"
sub _action_opcode_1528 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xE7);
}
# opcode : set "[inline_const]" 4 "," "(" iy ")" "," b "[end]"
sub _action_opcode_1529 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xE0);
}
# opcode : bit "[inline_const]" 4 "," e "[end]"
sub _action_opcode_153 {
	_add_opcode(@_, 0xCB, 0x63);
}
# opcode : set "[inline_const]" 4 "," "(" iy ")" "," c "[end]"
sub _action_opcode_1530 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xE1);
}
# opcode : set "[inline_const]" 4 "," "(" iy ")" "," d "[end]"
sub _action_opcode_1531 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xE2);
}
# opcode : set "[inline_const]" 4 "," "(" iy ")" "," e "[end]"
sub _action_opcode_1532 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xE3);
}
# opcode : set "[inline_const]" 4 "," "(" iy ")" "," h "[end]"
sub _action_opcode_1533 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xE4);
}
# opcode : set "[inline_const]" 4 "," "(" iy ")" "," l "[end]"
sub _action_opcode_1534 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xE5);
}
# opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1535 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xE6);
}
# opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1536 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xE7);
}
# opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1537 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xE0);
}
# opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1538 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xE1);
}
# opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1539 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xE2);
}
# opcode : bit "[inline_const]" 4 "," h "[end]"
sub _action_opcode_154 {
	_add_opcode(@_, 0xCB, 0x64);
}
# opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1540 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xE3);
}
# opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1541 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xE4);
}
# opcode : set "[inline_const]" 4 "," "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1542 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xE5);
}
# opcode : set "[inline_const]" 4 "," a "[end]"
sub _action_opcode_1543 {
	_add_opcode(@_, 0xCB, 0xE7);
}
# opcode : set "[inline_const]" 4 "," b "[end]"
sub _action_opcode_1544 {
	_add_opcode(@_, 0xCB, 0xE0);
}
# opcode : set "[inline_const]" 4 "," c "[end]"
sub _action_opcode_1545 {
	_add_opcode(@_, 0xCB, 0xE1);
}
# opcode : set "[inline_const]" 4 "," d "[end]"
sub _action_opcode_1546 {
	_add_opcode(@_, 0xCB, 0xE2);
}
# opcode : set "[inline_const]" 4 "," e "[end]"
sub _action_opcode_1547 {
	_add_opcode(@_, 0xCB, 0xE3);
}
# opcode : set "[inline_const]" 4 "," h "[end]"
sub _action_opcode_1548 {
	_add_opcode(@_, 0xCB, 0xE4);
}
# opcode : set "[inline_const]" 4 "," l "[end]"
sub _action_opcode_1549 {
	_add_opcode(@_, 0xCB, 0xE5);
}
# opcode : bit "[inline_const]" 4 "," l "[end]"
sub _action_opcode_155 {
	_add_opcode(@_, 0xCB, 0x65);
}
# opcode : set "[inline_const]" 5 "," "(" hl ")" "[end]"
sub _action_opcode_1550 {
	_add_opcode(@_, 0xCB, 0xEE);
}
# opcode : set "[inline_const]" 5 "," "(" ix ")" "[end]"
sub _action_opcode_1551 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xEE);
}
# opcode : set "[inline_const]" 5 "," "(" ix ")" "," a "[end]"
sub _action_opcode_1552 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xEF);
}
# opcode : set "[inline_const]" 5 "," "(" ix ")" "," b "[end]"
sub _action_opcode_1553 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xE8);
}
# opcode : set "[inline_const]" 5 "," "(" ix ")" "," c "[end]"
sub _action_opcode_1554 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xE9);
}
# opcode : set "[inline_const]" 5 "," "(" ix ")" "," d "[end]"
sub _action_opcode_1555 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xEA);
}
# opcode : set "[inline_const]" 5 "," "(" ix ")" "," e "[end]"
sub _action_opcode_1556 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xEB);
}
# opcode : set "[inline_const]" 5 "," "(" ix ")" "," h "[end]"
sub _action_opcode_1557 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xEC);
}
# opcode : set "[inline_const]" 5 "," "(" ix ")" "," l "[end]"
sub _action_opcode_1558 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xED);
}
# opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1559 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xEE);
}
# opcode : bit "[inline_const]" 5 "," "(" hl ")" "[end]"
sub _action_opcode_156 {
	_add_opcode(@_, 0xCB, 0x6E);
}
# opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1560 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xEF);
}
# opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1561 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xE8);
}
# opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1562 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xE9);
}
# opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1563 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xEA);
}
# opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1564 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xEB);
}
# opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1565 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xEC);
}
# opcode : set "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1566 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xED);
}
# opcode : set "[inline_const]" 5 "," "(" iy ")" "[end]"
sub _action_opcode_1567 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xEE);
}
# opcode : set "[inline_const]" 5 "," "(" iy ")" "," a "[end]"
sub _action_opcode_1568 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xEF);
}
# opcode : set "[inline_const]" 5 "," "(" iy ")" "," b "[end]"
sub _action_opcode_1569 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xE8);
}
# opcode : bit "[inline_const]" 5 "," "(" ix ")" "[end]"
sub _action_opcode_157 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x6E);
}
# opcode : set "[inline_const]" 5 "," "(" iy ")" "," c "[end]"
sub _action_opcode_1570 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xE9);
}
# opcode : set "[inline_const]" 5 "," "(" iy ")" "," d "[end]"
sub _action_opcode_1571 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xEA);
}
# opcode : set "[inline_const]" 5 "," "(" iy ")" "," e "[end]"
sub _action_opcode_1572 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xEB);
}
# opcode : set "[inline_const]" 5 "," "(" iy ")" "," h "[end]"
sub _action_opcode_1573 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xEC);
}
# opcode : set "[inline_const]" 5 "," "(" iy ")" "," l "[end]"
sub _action_opcode_1574 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xED);
}
# opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1575 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xEE);
}
# opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1576 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xEF);
}
# opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1577 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xE8);
}
# opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1578 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xE9);
}
# opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1579 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xEA);
}
# opcode : bit "[inline_const]" 5 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_158 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x6E);
}
# opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1580 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xEB);
}
# opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1581 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xEC);
}
# opcode : set "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1582 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xED);
}
# opcode : set "[inline_const]" 5 "," a "[end]"
sub _action_opcode_1583 {
	_add_opcode(@_, 0xCB, 0xEF);
}
# opcode : set "[inline_const]" 5 "," b "[end]"
sub _action_opcode_1584 {
	_add_opcode(@_, 0xCB, 0xE8);
}
# opcode : set "[inline_const]" 5 "," c "[end]"
sub _action_opcode_1585 {
	_add_opcode(@_, 0xCB, 0xE9);
}
# opcode : set "[inline_const]" 5 "," d "[end]"
sub _action_opcode_1586 {
	_add_opcode(@_, 0xCB, 0xEA);
}
# opcode : set "[inline_const]" 5 "," e "[end]"
sub _action_opcode_1587 {
	_add_opcode(@_, 0xCB, 0xEB);
}
# opcode : set "[inline_const]" 5 "," h "[end]"
sub _action_opcode_1588 {
	_add_opcode(@_, 0xCB, 0xEC);
}
# opcode : set "[inline_const]" 5 "," l "[end]"
sub _action_opcode_1589 {
	_add_opcode(@_, 0xCB, 0xED);
}
# opcode : bit "[inline_const]" 5 "," "(" iy ")" "[end]"
sub _action_opcode_159 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x6E);
}
# opcode : set "[inline_const]" 6 "," "(" hl ")" "[end]"
sub _action_opcode_1590 {
	_add_opcode(@_, 0xCB, 0xF6);
}
# opcode : set "[inline_const]" 6 "," "(" ix ")" "[end]"
sub _action_opcode_1591 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xF6);
}
# opcode : set "[inline_const]" 6 "," "(" ix ")" "," a "[end]"
sub _action_opcode_1592 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xF7);
}
# opcode : set "[inline_const]" 6 "," "(" ix ")" "," b "[end]"
sub _action_opcode_1593 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xF0);
}
# opcode : set "[inline_const]" 6 "," "(" ix ")" "," c "[end]"
sub _action_opcode_1594 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xF1);
}
# opcode : set "[inline_const]" 6 "," "(" ix ")" "," d "[end]"
sub _action_opcode_1595 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xF2);
}
# opcode : set "[inline_const]" 6 "," "(" ix ")" "," e "[end]"
sub _action_opcode_1596 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xF3);
}
# opcode : set "[inline_const]" 6 "," "(" ix ")" "," h "[end]"
sub _action_opcode_1597 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xF4);
}
# opcode : set "[inline_const]" 6 "," "(" ix ")" "," l "[end]"
sub _action_opcode_1598 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xF5);
}
# opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1599 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xF6);
}
# opcode : bit "[inline_const]" 5 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_160 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x6E);
}
# opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1600 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xF7);
}
# opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1601 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xF0);
}
# opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1602 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xF1);
}
# opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1603 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xF2);
}
# opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1604 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xF3);
}
# opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1605 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xF4);
}
# opcode : set "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1606 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xF5);
}
# opcode : set "[inline_const]" 6 "," "(" iy ")" "[end]"
sub _action_opcode_1607 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xF6);
}
# opcode : set "[inline_const]" 6 "," "(" iy ")" "," a "[end]"
sub _action_opcode_1608 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xF7);
}
# opcode : set "[inline_const]" 6 "," "(" iy ")" "," b "[end]"
sub _action_opcode_1609 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xF0);
}
# opcode : bit "[inline_const]" 5 "," a "[end]"
sub _action_opcode_161 {
	_add_opcode(@_, 0xCB, 0x6F);
}
# opcode : set "[inline_const]" 6 "," "(" iy ")" "," c "[end]"
sub _action_opcode_1610 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xF1);
}
# opcode : set "[inline_const]" 6 "," "(" iy ")" "," d "[end]"
sub _action_opcode_1611 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xF2);
}
# opcode : set "[inline_const]" 6 "," "(" iy ")" "," e "[end]"
sub _action_opcode_1612 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xF3);
}
# opcode : set "[inline_const]" 6 "," "(" iy ")" "," h "[end]"
sub _action_opcode_1613 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xF4);
}
# opcode : set "[inline_const]" 6 "," "(" iy ")" "," l "[end]"
sub _action_opcode_1614 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xF5);
}
# opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1615 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xF6);
}
# opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1616 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xF7);
}
# opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1617 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xF0);
}
# opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1618 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xF1);
}
# opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1619 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xF2);
}
# opcode : bit "[inline_const]" 5 "," b "[end]"
sub _action_opcode_162 {
	_add_opcode(@_, 0xCB, 0x68);
}
# opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1620 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xF3);
}
# opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1621 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xF4);
}
# opcode : set "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1622 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xF5);
}
# opcode : set "[inline_const]" 6 "," a "[end]"
sub _action_opcode_1623 {
	_add_opcode(@_, 0xCB, 0xF7);
}
# opcode : set "[inline_const]" 6 "," b "[end]"
sub _action_opcode_1624 {
	_add_opcode(@_, 0xCB, 0xF0);
}
# opcode : set "[inline_const]" 6 "," c "[end]"
sub _action_opcode_1625 {
	_add_opcode(@_, 0xCB, 0xF1);
}
# opcode : set "[inline_const]" 6 "," d "[end]"
sub _action_opcode_1626 {
	_add_opcode(@_, 0xCB, 0xF2);
}
# opcode : set "[inline_const]" 6 "," e "[end]"
sub _action_opcode_1627 {
	_add_opcode(@_, 0xCB, 0xF3);
}
# opcode : set "[inline_const]" 6 "," h "[end]"
sub _action_opcode_1628 {
	_add_opcode(@_, 0xCB, 0xF4);
}
# opcode : set "[inline_const]" 6 "," l "[end]"
sub _action_opcode_1629 {
	_add_opcode(@_, 0xCB, 0xF5);
}
# opcode : bit "[inline_const]" 5 "," c "[end]"
sub _action_opcode_163 {
	_add_opcode(@_, 0xCB, 0x69);
}
# opcode : set "[inline_const]" 7 "," "(" hl ")" "[end]"
sub _action_opcode_1630 {
	_add_opcode(@_, 0xCB, 0xFE);
}
# opcode : set "[inline_const]" 7 "," "(" ix ")" "[end]"
sub _action_opcode_1631 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xFE);
}
# opcode : set "[inline_const]" 7 "," "(" ix ")" "," a "[end]"
sub _action_opcode_1632 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xFF);
}
# opcode : set "[inline_const]" 7 "," "(" ix ")" "," b "[end]"
sub _action_opcode_1633 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xF8);
}
# opcode : set "[inline_const]" 7 "," "(" ix ")" "," c "[end]"
sub _action_opcode_1634 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xF9);
}
# opcode : set "[inline_const]" 7 "," "(" ix ")" "," d "[end]"
sub _action_opcode_1635 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xFA);
}
# opcode : set "[inline_const]" 7 "," "(" ix ")" "," e "[end]"
sub _action_opcode_1636 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xFB);
}
# opcode : set "[inline_const]" 7 "," "(" ix ")" "," h "[end]"
sub _action_opcode_1637 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xFC);
}
# opcode : set "[inline_const]" 7 "," "(" ix ")" "," l "[end]"
sub _action_opcode_1638 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xFD);
}
# opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1639 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xFE);
}
# opcode : bit "[inline_const]" 5 "," d "[end]"
sub _action_opcode_164 {
	_add_opcode(@_, 0xCB, 0x6A);
}
# opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1640 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xFF);
}
# opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1641 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xF8);
}
# opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1642 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xF9);
}
# opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1643 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xFA);
}
# opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1644 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xFB);
}
# opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1645 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xFC);
}
# opcode : set "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1646 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xFD);
}
# opcode : set "[inline_const]" 7 "," "(" iy ")" "[end]"
sub _action_opcode_1647 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xFE);
}
# opcode : set "[inline_const]" 7 "," "(" iy ")" "," a "[end]"
sub _action_opcode_1648 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xFF);
}
# opcode : set "[inline_const]" 7 "," "(" iy ")" "," b "[end]"
sub _action_opcode_1649 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xF8);
}
# opcode : bit "[inline_const]" 5 "," e "[end]"
sub _action_opcode_165 {
	_add_opcode(@_, 0xCB, 0x6B);
}
# opcode : set "[inline_const]" 7 "," "(" iy ")" "," c "[end]"
sub _action_opcode_1650 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xF9);
}
# opcode : set "[inline_const]" 7 "," "(" iy ")" "," d "[end]"
sub _action_opcode_1651 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xFA);
}
# opcode : set "[inline_const]" 7 "," "(" iy ")" "," e "[end]"
sub _action_opcode_1652 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xFB);
}
# opcode : set "[inline_const]" 7 "," "(" iy ")" "," h "[end]"
sub _action_opcode_1653 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xFC);
}
# opcode : set "[inline_const]" 7 "," "(" iy ")" "," l "[end]"
sub _action_opcode_1654 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xFD);
}
# opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1655 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xFE);
}
# opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1656 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xFF);
}
# opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1657 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xF8);
}
# opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1658 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xF9);
}
# opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1659 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xFA);
}
# opcode : bit "[inline_const]" 5 "," h "[end]"
sub _action_opcode_166 {
	_add_opcode(@_, 0xCB, 0x6C);
}
# opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1660 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xFB);
}
# opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1661 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xFC);
}
# opcode : set "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1662 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0xFD);
}
# opcode : set "[inline_const]" 7 "," a "[end]"
sub _action_opcode_1663 {
	_add_opcode(@_, 0xCB, 0xFF);
}
# opcode : set "[inline_const]" 7 "," b "[end]"
sub _action_opcode_1664 {
	_add_opcode(@_, 0xCB, 0xF8);
}
# opcode : set "[inline_const]" 7 "," c "[end]"
sub _action_opcode_1665 {
	_add_opcode(@_, 0xCB, 0xF9);
}
# opcode : set "[inline_const]" 7 "," d "[end]"
sub _action_opcode_1666 {
	_add_opcode(@_, 0xCB, 0xFA);
}
# opcode : set "[inline_const]" 7 "," e "[end]"
sub _action_opcode_1667 {
	_add_opcode(@_, 0xCB, 0xFB);
}
# opcode : set "[inline_const]" 7 "," h "[end]"
sub _action_opcode_1668 {
	_add_opcode(@_, 0xCB, 0xFC);
}
# opcode : set "[inline_const]" 7 "," l "[end]"
sub _action_opcode_1669 {
	_add_opcode(@_, 0xCB, 0xFD);
}
# opcode : bit "[inline_const]" 5 "," l "[end]"
sub _action_opcode_167 {
	_add_opcode(@_, 0xCB, 0x6D);
}
# opcode : sla "(" hl ")" "[end]"
sub _action_opcode_1670 {
	_add_opcode(@_, 0xCB, 0x26);
}
# opcode : sla "(" ix ")" "[end]"
sub _action_opcode_1671 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x26);
}
# opcode : sla "(" ix ")" "," a "[end]"
sub _action_opcode_1672 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x27);
}
# opcode : sla "(" ix ")" "," b "[end]"
sub _action_opcode_1673 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x20);
}
# opcode : sla "(" ix ")" "," c "[end]"
sub _action_opcode_1674 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x21);
}
# opcode : sla "(" ix ")" "," d "[end]"
sub _action_opcode_1675 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x22);
}
# opcode : sla "(" ix ")" "," e "[end]"
sub _action_opcode_1676 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x23);
}
# opcode : sla "(" ix ")" "," h "[end]"
sub _action_opcode_1677 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x24);
}
# opcode : sla "(" ix ")" "," l "[end]"
sub _action_opcode_1678 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x25);
}
# opcode : sla "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1679 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x26);
}
# opcode : bit "[inline_const]" 6 "," "(" hl ")" "[end]"
sub _action_opcode_168 {
	_add_opcode(@_, 0xCB, 0x76);
}
# opcode : sla "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1680 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x27);
}
# opcode : sla "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1681 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x20);
}
# opcode : sla "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1682 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x21);
}
# opcode : sla "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1683 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x22);
}
# opcode : sla "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1684 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x23);
}
# opcode : sla "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1685 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x24);
}
# opcode : sla "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1686 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x25);
}
# opcode : sla "(" iy ")" "[end]"
sub _action_opcode_1687 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x26);
}
# opcode : sla "(" iy ")" "," a "[end]"
sub _action_opcode_1688 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x27);
}
# opcode : sla "(" iy ")" "," b "[end]"
sub _action_opcode_1689 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x20);
}
# opcode : bit "[inline_const]" 6 "," "(" ix ")" "[end]"
sub _action_opcode_169 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x76);
}
# opcode : sla "(" iy ")" "," c "[end]"
sub _action_opcode_1690 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x21);
}
# opcode : sla "(" iy ")" "," d "[end]"
sub _action_opcode_1691 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x22);
}
# opcode : sla "(" iy ")" "," e "[end]"
sub _action_opcode_1692 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x23);
}
# opcode : sla "(" iy ")" "," h "[end]"
sub _action_opcode_1693 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x24);
}
# opcode : sla "(" iy ")" "," l "[end]"
sub _action_opcode_1694 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x25);
}
# opcode : sla "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1695 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x26);
}
# opcode : sla "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1696 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x27);
}
# opcode : sla "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1697 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x20);
}
# opcode : sla "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1698 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x21);
}
# opcode : sla "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1699 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x22);
}
# opcode : bit "[inline_const]" 6 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_170 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x76);
}
# opcode : sla "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1700 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x23);
}
# opcode : sla "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1701 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x24);
}
# opcode : sla "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1702 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x25);
}
# opcode : sla a "[end]"
sub _action_opcode_1703 {
	_add_opcode(@_, 0xCB, 0x27);
}
# opcode : sla b "[end]"
sub _action_opcode_1704 {
	_add_opcode(@_, 0xCB, 0x20);
}
# opcode : sla bc "[end]"
sub _action_opcode_1705 {
	_add_opcode(@_, 0xCB, 0x21, 0xCB, 0x10);
}
# opcode : sla c "[end]"
sub _action_opcode_1706 {
	_add_opcode(@_, 0xCB, 0x21);
}
# opcode : sla d "[end]"
sub _action_opcode_1707 {
	_add_opcode(@_, 0xCB, 0x22);
}
# opcode : sla de "[end]"
sub _action_opcode_1708 {
	_add_opcode(@_, 0xCB, 0x23, 0xCB, 0x12);
}
# opcode : sla e "[end]"
sub _action_opcode_1709 {
	_add_opcode(@_, 0xCB, 0x23);
}
# opcode : bit "[inline_const]" 6 "," "(" iy ")" "[end]"
sub _action_opcode_171 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x76);
}
# opcode : sla h "[end]"
sub _action_opcode_1710 {
	_add_opcode(@_, 0xCB, 0x24);
}
# opcode : sla l "[end]"
sub _action_opcode_1711 {
	_add_opcode(@_, 0xCB, 0x25);
}
# opcode : sli "(" hl ")" "[end]"
sub _action_opcode_1712 {
	_add_opcode(@_, 0xCB, 0x36);
}
# opcode : sli "(" ix ")" "[end]"
sub _action_opcode_1713 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x36);
}
# opcode : sli "(" ix ")" "," a "[end]"
sub _action_opcode_1714 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x37);
}
# opcode : sli "(" ix ")" "," b "[end]"
sub _action_opcode_1715 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x30);
}
# opcode : sli "(" ix ")" "," c "[end]"
sub _action_opcode_1716 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x31);
}
# opcode : sli "(" ix ")" "," d "[end]"
sub _action_opcode_1717 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x32);
}
# opcode : sli "(" ix ")" "," e "[end]"
sub _action_opcode_1718 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x33);
}
# opcode : sli "(" ix ")" "," h "[end]"
sub _action_opcode_1719 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x34);
}
# opcode : bit "[inline_const]" 6 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_172 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x76);
}
# opcode : sli "(" ix ")" "," l "[end]"
sub _action_opcode_1720 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x35);
}
# opcode : sli "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1721 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x36);
}
# opcode : sli "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1722 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x37);
}
# opcode : sli "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1723 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x30);
}
# opcode : sli "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1724 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x31);
}
# opcode : sli "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1725 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x32);
}
# opcode : sli "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1726 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x33);
}
# opcode : sli "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1727 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x34);
}
# opcode : sli "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1728 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x35);
}
# opcode : sli "(" iy ")" "[end]"
sub _action_opcode_1729 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x36);
}
# opcode : bit "[inline_const]" 6 "," a "[end]"
sub _action_opcode_173 {
	_add_opcode(@_, 0xCB, 0x77);
}
# opcode : sli "(" iy ")" "," a "[end]"
sub _action_opcode_1730 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x37);
}
# opcode : sli "(" iy ")" "," b "[end]"
sub _action_opcode_1731 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x30);
}
# opcode : sli "(" iy ")" "," c "[end]"
sub _action_opcode_1732 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x31);
}
# opcode : sli "(" iy ")" "," d "[end]"
sub _action_opcode_1733 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x32);
}
# opcode : sli "(" iy ")" "," e "[end]"
sub _action_opcode_1734 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x33);
}
# opcode : sli "(" iy ")" "," h "[end]"
sub _action_opcode_1735 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x34);
}
# opcode : sli "(" iy ")" "," l "[end]"
sub _action_opcode_1736 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x35);
}
# opcode : sli "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1737 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x36);
}
# opcode : sli "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1738 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x37);
}
# opcode : sli "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1739 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x30);
}
# opcode : bit "[inline_const]" 6 "," b "[end]"
sub _action_opcode_174 {
	_add_opcode(@_, 0xCB, 0x70);
}
# opcode : sli "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1740 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x31);
}
# opcode : sli "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1741 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x32);
}
# opcode : sli "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1742 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x33);
}
# opcode : sli "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1743 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x34);
}
# opcode : sli "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1744 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x35);
}
# opcode : sli a "[end]"
sub _action_opcode_1745 {
	_add_opcode(@_, 0xCB, 0x37);
}
# opcode : sli b "[end]"
sub _action_opcode_1746 {
	_add_opcode(@_, 0xCB, 0x30);
}
# opcode : sli bc "[end]"
sub _action_opcode_1747 {
	_add_opcode(@_, 0xCB, 0x31, 0xCB, 0x10);
}
# opcode : sli c "[end]"
sub _action_opcode_1748 {
	_add_opcode(@_, 0xCB, 0x31);
}
# opcode : sli d "[end]"
sub _action_opcode_1749 {
	_add_opcode(@_, 0xCB, 0x32);
}
# opcode : bit "[inline_const]" 6 "," c "[end]"
sub _action_opcode_175 {
	_add_opcode(@_, 0xCB, 0x71);
}
# opcode : sli de "[end]"
sub _action_opcode_1750 {
	_add_opcode(@_, 0xCB, 0x33, 0xCB, 0x12);
}
# opcode : sli e "[end]"
sub _action_opcode_1751 {
	_add_opcode(@_, 0xCB, 0x33);
}
# opcode : sli h "[end]"
sub _action_opcode_1752 {
	_add_opcode(@_, 0xCB, 0x34);
}
# opcode : sli hl "[end]"
sub _action_opcode_1753 {
	_add_opcode(@_, 0xCB, 0x35, 0xCB, 0x14);
}
# opcode : sli l "[end]"
sub _action_opcode_1754 {
	_add_opcode(@_, 0xCB, 0x35);
}
# opcode : sra "(" hl ")" "[end]"
sub _action_opcode_1755 {
	_add_opcode(@_, 0xCB, 0x2E);
}
# opcode : sra "(" ix ")" "[end]"
sub _action_opcode_1756 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x2E);
}
# opcode : sra "(" ix ")" "," a "[end]"
sub _action_opcode_1757 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x2F);
}
# opcode : sra "(" ix ")" "," b "[end]"
sub _action_opcode_1758 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x28);
}
# opcode : sra "(" ix ")" "," c "[end]"
sub _action_opcode_1759 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x29);
}
# opcode : bit "[inline_const]" 6 "," d "[end]"
sub _action_opcode_176 {
	_add_opcode(@_, 0xCB, 0x72);
}
# opcode : sra "(" ix ")" "," d "[end]"
sub _action_opcode_1760 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x2A);
}
# opcode : sra "(" ix ")" "," e "[end]"
sub _action_opcode_1761 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x2B);
}
# opcode : sra "(" ix ")" "," h "[end]"
sub _action_opcode_1762 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x2C);
}
# opcode : sra "(" ix ")" "," l "[end]"
sub _action_opcode_1763 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x2D);
}
# opcode : sra "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1764 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x2E);
}
# opcode : sra "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1765 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x2F);
}
# opcode : sra "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1766 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x28);
}
# opcode : sra "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1767 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x29);
}
# opcode : sra "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1768 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x2A);
}
# opcode : sra "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1769 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x2B);
}
# opcode : bit "[inline_const]" 6 "," e "[end]"
sub _action_opcode_177 {
	_add_opcode(@_, 0xCB, 0x73);
}
# opcode : sra "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1770 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x2C);
}
# opcode : sra "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1771 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x2D);
}
# opcode : sra "(" iy ")" "[end]"
sub _action_opcode_1772 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x2E);
}
# opcode : sra "(" iy ")" "," a "[end]"
sub _action_opcode_1773 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x2F);
}
# opcode : sra "(" iy ")" "," b "[end]"
sub _action_opcode_1774 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x28);
}
# opcode : sra "(" iy ")" "," c "[end]"
sub _action_opcode_1775 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x29);
}
# opcode : sra "(" iy ")" "," d "[end]"
sub _action_opcode_1776 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x2A);
}
# opcode : sra "(" iy ")" "," e "[end]"
sub _action_opcode_1777 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x2B);
}
# opcode : sra "(" iy ")" "," h "[end]"
sub _action_opcode_1778 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x2C);
}
# opcode : sra "(" iy ")" "," l "[end]"
sub _action_opcode_1779 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x2D);
}
# opcode : bit "[inline_const]" 6 "," h "[end]"
sub _action_opcode_178 {
	_add_opcode(@_, 0xCB, 0x74);
}
# opcode : sra "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1780 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x2E);
}
# opcode : sra "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1781 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x2F);
}
# opcode : sra "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1782 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x28);
}
# opcode : sra "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1783 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x29);
}
# opcode : sra "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1784 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x2A);
}
# opcode : sra "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1785 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x2B);
}
# opcode : sra "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1786 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x2C);
}
# opcode : sra "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1787 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x2D);
}
# opcode : sra a "[end]"
sub _action_opcode_1788 {
	_add_opcode(@_, 0xCB, 0x2F);
}
# opcode : sra b "[end]"
sub _action_opcode_1789 {
	_add_opcode(@_, 0xCB, 0x28);
}
# opcode : bit "[inline_const]" 6 "," l "[end]"
sub _action_opcode_179 {
	_add_opcode(@_, 0xCB, 0x75);
}
# opcode : sra bc "[end]"
sub _action_opcode_1790 {
	_add_opcode(@_, 0xCB, 0x28, 0xCB, 0x19);
}
# opcode : sra c "[end]"
sub _action_opcode_1791 {
	_add_opcode(@_, 0xCB, 0x29);
}
# opcode : sra d "[end]"
sub _action_opcode_1792 {
	_add_opcode(@_, 0xCB, 0x2A);
}
# opcode : sra de "[end]"
sub _action_opcode_1793 {
	_add_opcode(@_, 0xCB, 0x2A, 0xCB, 0x1B);
}
# opcode : sra e "[end]"
sub _action_opcode_1794 {
	_add_opcode(@_, 0xCB, 0x2B);
}
# opcode : sra h "[end]"
sub _action_opcode_1795 {
	_add_opcode(@_, 0xCB, 0x2C);
}
# opcode : sra hl "[end]"
sub _action_opcode_1796 {
	_add_opcode(@_, 0xCB, 0x2C, 0xCB, 0x1D);
}
# opcode : sra l "[end]"
sub _action_opcode_1797 {
	_add_opcode(@_, 0xCB, 0x2D);
}
# opcode : srl "(" hl ")" "[end]"
sub _action_opcode_1798 {
	_add_opcode(@_, 0xCB, 0x3E);
}
# opcode : srl "(" ix ")" "[end]"
sub _action_opcode_1799 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x3E);
}
# opcode : bit "[inline_const]" 7 "," "(" hl ")" "[end]"
sub _action_opcode_180 {
	_add_opcode(@_, 0xCB, 0x7E);
}
# opcode : srl "(" ix ")" "," a "[end]"
sub _action_opcode_1800 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x3F);
}
# opcode : srl "(" ix ")" "," b "[end]"
sub _action_opcode_1801 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x38);
}
# opcode : srl "(" ix ")" "," c "[end]"
sub _action_opcode_1802 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x39);
}
# opcode : srl "(" ix ")" "," d "[end]"
sub _action_opcode_1803 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x3A);
}
# opcode : srl "(" ix ")" "," e "[end]"
sub _action_opcode_1804 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x3B);
}
# opcode : srl "(" ix ")" "," h "[end]"
sub _action_opcode_1805 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x3C);
}
# opcode : srl "(" ix ")" "," l "[end]"
sub _action_opcode_1806 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x3D);
}
# opcode : srl "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1807 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x3E);
}
# opcode : srl "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1808 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x3F);
}
# opcode : srl "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1809 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x38);
}
# opcode : bit "[inline_const]" 7 "," "(" ix ")" "[end]"
sub _action_opcode_181 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x7E);
}
# opcode : srl "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1810 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x39);
}
# opcode : srl "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1811 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x3A);
}
# opcode : srl "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1812 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x3B);
}
# opcode : srl "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1813 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x3C);
}
# opcode : srl "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1814 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][4], 0x3D);
}
# opcode : srl "(" iy ")" "[end]"
sub _action_opcode_1815 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x3E);
}
# opcode : srl "(" iy ")" "," a "[end]"
sub _action_opcode_1816 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x3F);
}
# opcode : srl "(" iy ")" "," b "[end]"
sub _action_opcode_1817 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x38);
}
# opcode : srl "(" iy ")" "," c "[end]"
sub _action_opcode_1818 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x39);
}
# opcode : srl "(" iy ")" "," d "[end]"
sub _action_opcode_1819 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x3A);
}
# opcode : bit "[inline_const]" 7 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_182 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x7E);
}
# opcode : srl "(" iy ")" "," e "[end]"
sub _action_opcode_1820 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x3B);
}
# opcode : srl "(" iy ")" "," h "[end]"
sub _action_opcode_1821 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x3C);
}
# opcode : srl "(" iy ")" "," l "[end]"
sub _action_opcode_1822 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x3D);
}
# opcode : srl "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1823 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x3E);
}
# opcode : srl "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_1824 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x3F);
}
# opcode : srl "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_1825 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x38);
}
# opcode : srl "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_1826 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x39);
}
# opcode : srl "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_1827 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x3A);
}
# opcode : srl "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_1828 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x3B);
}
# opcode : srl "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_1829 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x3C);
}
# opcode : bit "[inline_const]" 7 "," "(" iy ")" "[end]"
sub _action_opcode_183 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x7E);
}
# opcode : srl "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_1830 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][4], 0x3D);
}
# opcode : srl a "[end]"
sub _action_opcode_1831 {
	_add_opcode(@_, 0xCB, 0x3F);
}
# opcode : srl b "[end]"
sub _action_opcode_1832 {
	_add_opcode(@_, 0xCB, 0x38);
}
# opcode : srl bc "[end]"
sub _action_opcode_1833 {
	_add_opcode(@_, 0xCB, 0x38, 0xCB, 0x19);
}
# opcode : srl c "[end]"
sub _action_opcode_1834 {
	_add_opcode(@_, 0xCB, 0x39);
}
# opcode : srl d "[end]"
sub _action_opcode_1835 {
	_add_opcode(@_, 0xCB, 0x3A);
}
# opcode : srl de "[end]"
sub _action_opcode_1836 {
	_add_opcode(@_, 0xCB, 0x3A, 0xCB, 0x1B);
}
# opcode : srl e "[end]"
sub _action_opcode_1837 {
	_add_opcode(@_, 0xCB, 0x3B);
}
# opcode : srl h "[end]"
sub _action_opcode_1838 {
	_add_opcode(@_, 0xCB, 0x3C);
}
# opcode : srl hl "[end]"
sub _action_opcode_1839 {
	_add_opcode(@_, 0xCB, 0x3C, 0xCB, 0x1D);
}
# opcode : bit "[inline_const]" 7 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_184 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x7E);
}
# opcode : srl l "[end]"
sub _action_opcode_1840 {
	_add_opcode(@_, 0xCB, 0x3D);
}
# opcode : stop "[end]"
sub _action_opcode_1841 {
	_add_opcode(@_, 0xDD, 0xDD, 0x00);
}
# opcode : sub "(" hl ")" "[end]"
sub _action_opcode_1842 {
	_add_opcode(@_, 0x96);
}
# opcode : sub "(" ix ")" "[end]"
sub _action_opcode_1843 {
	_add_opcode(@_, 0xDD, 0x96, 0x00);
}
# opcode : sub "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1844 {
	_add_opcode(@_, 0xDD, 0x96, $_[ARGS][4]);
}
# opcode : sub "(" iy ")" "[end]"
sub _action_opcode_1845 {
	_add_opcode(@_, 0xFD, 0x96, 0x00);
}
# opcode : sub "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1846 {
	_add_opcode(@_, 0xFD, 0x96, $_[ARGS][4]);
}
# opcode : sub "[expr_N]" "[end]"
sub _action_opcode_1847 {
	_add_opcode(@_, 0xD6, $_[ARGS][1]);
}
# opcode : sub a "[end]"
sub _action_opcode_1848 {
	_add_opcode(@_, 0x97);
}
# opcode : sub b "[end]"
sub _action_opcode_1849 {
	_add_opcode(@_, 0x90);
}
# opcode : bit "[inline_const]" 7 "," a "[end]"
sub _action_opcode_185 {
	_add_opcode(@_, 0xCB, 0x7F);
}
# opcode : sub c "[end]"
sub _action_opcode_1850 {
	_add_opcode(@_, 0x91);
}
# opcode : sub d "[end]"
sub _action_opcode_1851 {
	_add_opcode(@_, 0x92);
}
# opcode : sub e "[end]"
sub _action_opcode_1852 {
	_add_opcode(@_, 0x93);
}
# opcode : sub h "[end]"
sub _action_opcode_1853 {
	_add_opcode(@_, 0x94);
}
# opcode : sub hl "," bc "[end]"
sub _action_opcode_1854 {
	_add_opcode(@_, 0xB7, 0xED, 0x42);
}
# opcode : sub hl "," de "[end]"
sub _action_opcode_1855 {
	_add_opcode(@_, 0xB7, 0xED, 0x52);
}
# opcode : sub hl "," hl "[end]"
sub _action_opcode_1856 {
	_add_opcode(@_, 0xB7, 0xED, 0x62);
}
# opcode : sub hl "," sp "[end]"
sub _action_opcode_1857 {
	_add_opcode(@_, 0xB7, 0xED, 0x72);
}
# opcode : sub ixh "[end]"
sub _action_opcode_1858 {
	_add_opcode(@_, 0xDD, 0x94);
}
# opcode : sub ixl "[end]"
sub _action_opcode_1859 {
	_add_opcode(@_, 0xDD, 0x95);
}
# opcode : bit "[inline_const]" 7 "," b "[end]"
sub _action_opcode_186 {
	_add_opcode(@_, 0xCB, 0x78);
}
# opcode : sub iyh "[end]"
sub _action_opcode_1860 {
	_add_opcode(@_, 0xFD, 0x94);
}
# opcode : sub iyl "[end]"
sub _action_opcode_1861 {
	_add_opcode(@_, 0xFD, 0x95);
}
# opcode : sub l "[end]"
sub _action_opcode_1862 {
	_add_opcode(@_, 0x95);
}
# opcode : xor "(" hl ")" "[end]"
sub _action_opcode_1863 {
	_add_opcode(@_, 0xAE);
}
# opcode : xor "(" ix ")" "[end]"
sub _action_opcode_1864 {
	_add_opcode(@_, 0xDD, 0xAE, 0x00);
}
# opcode : xor "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1865 {
	_add_opcode(@_, 0xDD, 0xAE, $_[ARGS][4]);
}
# opcode : xor "(" iy ")" "[end]"
sub _action_opcode_1866 {
	_add_opcode(@_, 0xFD, 0xAE, 0x00);
}
# opcode : xor "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_1867 {
	_add_opcode(@_, 0xFD, 0xAE, $_[ARGS][4]);
}
# opcode : xor "[expr_N]" "[end]"
sub _action_opcode_1868 {
	_add_opcode(@_, 0xEE, $_[ARGS][1]);
}
# opcode : xor a "[end]"
sub _action_opcode_1869 {
	_add_opcode(@_, 0xAF);
}
# opcode : bit "[inline_const]" 7 "," c "[end]"
sub _action_opcode_187 {
	_add_opcode(@_, 0xCB, 0x79);
}
# opcode : xor b "[end]"
sub _action_opcode_1870 {
	_add_opcode(@_, 0xA8);
}
# opcode : xor c "[end]"
sub _action_opcode_1871 {
	_add_opcode(@_, 0xA9);
}
# opcode : xor d "[end]"
sub _action_opcode_1872 {
	_add_opcode(@_, 0xAA);
}
# opcode : xor e "[end]"
sub _action_opcode_1873 {
	_add_opcode(@_, 0xAB);
}
# opcode : xor h "[end]"
sub _action_opcode_1874 {
	_add_opcode(@_, 0xAC);
}
# opcode : xor ixh "[end]"
sub _action_opcode_1875 {
	_add_opcode(@_, 0xDD, 0xAC);
}
# opcode : xor ixl "[end]"
sub _action_opcode_1876 {
	_add_opcode(@_, 0xDD, 0xAD);
}
# opcode : xor iyh "[end]"
sub _action_opcode_1877 {
	_add_opcode(@_, 0xFD, 0xAC);
}
# opcode : xor iyl "[end]"
sub _action_opcode_1878 {
	_add_opcode(@_, 0xFD, 0xAD);
}
# opcode : xor l "[end]"
sub _action_opcode_1879 {
	_add_opcode(@_, 0xAD);
}
# opcode : bit "[inline_const]" 7 "," d "[end]"
sub _action_opcode_188 {
	_add_opcode(@_, 0xCB, 0x7A);
}
# opcode : bit "[inline_const]" 7 "," e "[end]"
sub _action_opcode_189 {
	_add_opcode(@_, 0xCB, 0x7B);
}
# opcode : bit "[inline_const]" 7 "," h "[end]"
sub _action_opcode_190 {
	_add_opcode(@_, 0xCB, 0x7C);
}
# opcode : bit "[inline_const]" 7 "," l "[end]"
sub _action_opcode_191 {
	_add_opcode(@_, 0xCB, 0x7D);
}
# opcode : call "[expr_NN]" "[end]"
sub _action_opcode_192 {
	_add_opcode(@_, 0xCD, $_[ARGS][1], undef);
}
# opcode : call c "," "[expr_NN]" "[end]"
sub _action_opcode_193 {
	_add_opcode(@_, 0xDC, $_[ARGS][3], undef);
}
# opcode : call m "," "[expr_NN]" "[end]"
sub _action_opcode_194 {
	_add_opcode(@_, 0xFC, $_[ARGS][3], undef);
}
# opcode : call nc "," "[expr_NN]" "[end]"
sub _action_opcode_195 {
	_add_opcode(@_, 0xD4, $_[ARGS][3], undef);
}
# opcode : call nz "," "[expr_NN]" "[end]"
sub _action_opcode_196 {
	_add_opcode(@_, 0xC4, $_[ARGS][3], undef);
}
# opcode : call p "," "[expr_NN]" "[end]"
sub _action_opcode_197 {
	_add_opcode(@_, 0xF4, $_[ARGS][3], undef);
}
# opcode : call pe "," "[expr_NN]" "[end]"
sub _action_opcode_198 {
	_add_opcode(@_, 0xEC, $_[ARGS][3], undef);
}
# opcode : call po "," "[expr_NN]" "[end]"
sub _action_opcode_199 {
	_add_opcode(@_, 0xE4, $_[ARGS][3], undef);
}
# opcode : call z "," "[expr_NN]" "[end]"
sub _action_opcode_200 {
	_add_opcode(@_, 0xCC, $_[ARGS][3], undef);
}
# opcode : ccf "[end]"
sub _action_opcode_201 {
	_add_opcode(@_, 0x3F);
}
# opcode : cp "(" hl ")" "[end]"
sub _action_opcode_202 {
	_add_opcode(@_, 0xBE);
}
# opcode : cp "(" ix ")" "[end]"
sub _action_opcode_203 {
	_add_opcode(@_, 0xDD, 0xBE, 0x00);
}
# opcode : cp "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_204 {
	_add_opcode(@_, 0xDD, 0xBE, $_[ARGS][4]);
}
# opcode : cp "(" iy ")" "[end]"
sub _action_opcode_205 {
	_add_opcode(@_, 0xFD, 0xBE, 0x00);
}
# opcode : cp "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_206 {
	_add_opcode(@_, 0xFD, 0xBE, $_[ARGS][4]);
}
# opcode : cp "[expr_N]" "[end]"
sub _action_opcode_207 {
	_add_opcode(@_, 0xFE, $_[ARGS][1]);
}
# opcode : cp a "[end]"
sub _action_opcode_208 {
	_add_opcode(@_, 0xBF);
}
# opcode : cp b "[end]"
sub _action_opcode_209 {
	_add_opcode(@_, 0xB8);
}
# opcode : defb "[expr_list_N]" "[end]"
sub _action_opcode_21 {
	_add_opcode(@_, @{$_[ARGS][1]});
}
# opcode : cp c "[end]"
sub _action_opcode_210 {
	_add_opcode(@_, 0xB9);
}
# opcode : cp d "[end]"
sub _action_opcode_211 {
	_add_opcode(@_, 0xBA);
}
# opcode : cp e "[end]"
sub _action_opcode_212 {
	_add_opcode(@_, 0xBB);
}
# opcode : cp h "[end]"
sub _action_opcode_213 {
	_add_opcode(@_, 0xBC);
}
# opcode : cp ixh "[end]"
sub _action_opcode_214 {
	_add_opcode(@_, 0xDD, 0xBC);
}
# opcode : cp ixl "[end]"
sub _action_opcode_215 {
	_add_opcode(@_, 0xDD, 0xBD);
}
# opcode : cp iyh "[end]"
sub _action_opcode_216 {
	_add_opcode(@_, 0xFD, 0xBC);
}
# opcode : cp iyl "[end]"
sub _action_opcode_217 {
	_add_opcode(@_, 0xFD, 0xBD);
}
# opcode : cp l "[end]"
sub _action_opcode_218 {
	_add_opcode(@_, 0xBD);
}
# opcode : cpd "[end]"
sub _action_opcode_219 {
	_add_opcode(@_, 0xED, 0xA9);
}
# opcode : org "[expr_const]"
sub _action_opcode_22 {
	$_[PROG]->org($_[ARGS][1])
}
# opcode : cpdr "[end]"
sub _action_opcode_220 {
	_add_opcode(@_, 0xED, 0xB9);
}
# opcode : cpi "[end]"
sub _action_opcode_221 {
	_add_opcode(@_, 0xED, 0xA1);
}
# opcode : cpir "[end]"
sub _action_opcode_222 {
	_add_opcode(@_, 0xED, 0xB1);
}
# opcode : cpl "[end]"
sub _action_opcode_223 {
	_add_opcode(@_, 0x2F);
}
# opcode : daa "[end]"
sub _action_opcode_224 {
	_add_opcode(@_, 0x27);
}
# opcode : dec "(" hl ")" "[end]"
sub _action_opcode_225 {
	_add_opcode(@_, 0x35);
}
# opcode : dec "(" ix ")" "[end]"
sub _action_opcode_226 {
	_add_opcode(@_, 0xDD, 0x35, 0x00);
}
# opcode : dec "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_227 {
	_add_opcode(@_, 0xDD, 0x35, $_[ARGS][4]);
}
# opcode : dec "(" iy ")" "[end]"
sub _action_opcode_228 {
	_add_opcode(@_, 0xFD, 0x35, 0x00);
}
# opcode : dec "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_229 {
	_add_opcode(@_, 0xFD, 0x35, $_[ARGS][4]);
}
# opcode : NAME "[def_label]?"
sub _action_opcode_23 {
	my $name = $_[ARGS][0]->value;
	if ( @{$_[ARGS]} > 1 ) {	# NAME = expr
		my $expr = $_[ARGS][1];
		$_[PROG]->symbols->{$name} = $expr;
	}
	elsif (exists $_[PROG]->macros->{$name}) {
								# MACRO call
		$_[PROG]->macros->{$name}->expand_macro($_[INPUT]);
	}
	else {						# NAME label
		$_[PROG]->add_label($name, $_[ARGS][0]->line);
	}
	undef;
}
# opcode : dec a "[end]"
sub _action_opcode_230 {
	_add_opcode(@_, 0x3D);
}
# opcode : dec b "[end]"
sub _action_opcode_231 {
	_add_opcode(@_, 0x05);
}
# opcode : dec bc "[end]"
sub _action_opcode_232 {
	_add_opcode(@_, 0x0B);
}
# opcode : dec c "[end]"
sub _action_opcode_233 {
	_add_opcode(@_, 0x0D);
}
# opcode : dec d "[end]"
sub _action_opcode_234 {
	_add_opcode(@_, 0x15);
}
# opcode : dec de "[end]"
sub _action_opcode_235 {
	_add_opcode(@_, 0x1B);
}
# opcode : dec e "[end]"
sub _action_opcode_236 {
	_add_opcode(@_, 0x1D);
}
# opcode : dec h "[end]"
sub _action_opcode_237 {
	_add_opcode(@_, 0x25);
}
# opcode : dec hl "[end]"
sub _action_opcode_238 {
	_add_opcode(@_, 0x2B);
}
# opcode : dec ix "[end]"
sub _action_opcode_239 {
	_add_opcode(@_, 0xDD, 0x2B);
}
# opcode : dec ixh "[end]"
sub _action_opcode_240 {
	_add_opcode(@_, 0xDD, 0x25);
}
# opcode : dec ixl "[end]"
sub _action_opcode_241 {
	_add_opcode(@_, 0xDD, 0x2D);
}
# opcode : dec iy "[end]"
sub _action_opcode_242 {
	_add_opcode(@_, 0xFD, 0x2B);
}
# opcode : dec iyh "[end]"
sub _action_opcode_243 {
	_add_opcode(@_, 0xFD, 0x25);
}
# opcode : dec iyl "[end]"
sub _action_opcode_244 {
	_add_opcode(@_, 0xFD, 0x2D);
}
# opcode : dec l "[end]"
sub _action_opcode_245 {
	_add_opcode(@_, 0x2D);
}
# opcode : dec sp "[end]"
sub _action_opcode_246 {
	_add_opcode(@_, 0x3B);
}
# opcode : di "[end]"
sub _action_opcode_247 {
	_add_opcode(@_, 0xF3);
}
# opcode : djnz "[expr_NN]" "[end]"
sub _action_opcode_248 {
	_add_jump_opcode(@_, [0x10, $_[ARGS][1]->build('{}-$-2', type => "sb")], [0x05, 0xC2, $_[ARGS][1], undef]);
}
# opcode : ei "[end]"
sub _action_opcode_249 {
	_add_opcode(@_, 0xFB);
}
# opcode : ex "(" sp ")" "," hl "[end]"
sub _action_opcode_250 {
	_add_opcode(@_, 0xE3);
}
# opcode : ex "(" sp ")" "," ix "[end]"
sub _action_opcode_251 {
	_add_opcode(@_, 0xDD, 0xE3);
}
# opcode : ex "(" sp ")" "," iy "[end]"
sub _action_opcode_252 {
	_add_opcode(@_, 0xFD, 0xE3);
}
# opcode : ex af "," "af'" "[end]"
sub _action_opcode_253 {
	_add_opcode(@_, 0x08);
}
# opcode : ex de "," hl "[end]"
sub _action_opcode_254 {
	_add_opcode(@_, 0xEB);
}
# opcode : exx "[end]"
sub _action_opcode_255 {
	_add_opcode(@_, 0xD9);
}
# opcode : halt "[end]"
sub _action_opcode_256 {
	_add_opcode(@_, 0x76);
}
# opcode : im "[inline_const]" 0 "[end]"
sub _action_opcode_257 {
	_add_opcode(@_, 0xED, 0x46);
}
# opcode : im "[inline_const]" 1 "[end]"
sub _action_opcode_258 {
	_add_opcode(@_, 0xED, 0x56);
}
# opcode : im "[inline_const]" 2 "[end]"
sub _action_opcode_259 {
	_add_opcode(@_, 0xED, 0x5E);
}
# opcode : in a "," "(" "[expr_N]" ")" "[end]"
sub _action_opcode_260 {
	_add_opcode(@_, 0xDB, $_[ARGS][4]);
}
# opcode : in a "," "(" c ")" "[end]"
sub _action_opcode_261 {
	_add_opcode(@_, 0xED, 0x78);
}
# opcode : in b "," "(" c ")" "[end]"
sub _action_opcode_262 {
	_add_opcode(@_, 0xED, 0x40);
}
# opcode : in c "," "(" c ")" "[end]"
sub _action_opcode_263 {
	_add_opcode(@_, 0xED, 0x48);
}
# opcode : in d "," "(" c ")" "[end]"
sub _action_opcode_264 {
	_add_opcode(@_, 0xED, 0x50);
}
# opcode : in e "," "(" c ")" "[end]"
sub _action_opcode_265 {
	_add_opcode(@_, 0xED, 0x58);
}
# opcode : in f "," "(" c ")" "[end]"
sub _action_opcode_266 {
	_add_opcode(@_, 0xED, 0x70);
}
# opcode : in h "," "(" c ")" "[end]"
sub _action_opcode_267 {
	_add_opcode(@_, 0xED, 0x60);
}
# opcode : in l "," "(" c ")" "[end]"
sub _action_opcode_268 {
	_add_opcode(@_, 0xED, 0x68);
}
# opcode : inc "(" hl ")" "[end]"
sub _action_opcode_269 {
	_add_opcode(@_, 0x34);
}
# opcode : inc "(" ix ")" "[end]"
sub _action_opcode_270 {
	_add_opcode(@_, 0xDD, 0x34, 0x00);
}
# opcode : inc "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_271 {
	_add_opcode(@_, 0xDD, 0x34, $_[ARGS][4]);
}
# opcode : inc "(" iy ")" "[end]"
sub _action_opcode_272 {
	_add_opcode(@_, 0xFD, 0x34, 0x00);
}
# opcode : inc "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_273 {
	_add_opcode(@_, 0xFD, 0x34, $_[ARGS][4]);
}
# opcode : inc a "[end]"
sub _action_opcode_274 {
	_add_opcode(@_, 0x3C);
}
# opcode : inc b "[end]"
sub _action_opcode_275 {
	_add_opcode(@_, 0x04);
}
# opcode : inc bc "[end]"
sub _action_opcode_276 {
	_add_opcode(@_, 0x03);
}
# opcode : inc c "[end]"
sub _action_opcode_277 {
	_add_opcode(@_, 0x0C);
}
# opcode : inc d "[end]"
sub _action_opcode_278 {
	_add_opcode(@_, 0x14);
}
# opcode : inc de "[end]"
sub _action_opcode_279 {
	_add_opcode(@_, 0x13);
}
# opcode : inc e "[end]"
sub _action_opcode_280 {
	_add_opcode(@_, 0x1C);
}
# opcode : inc h "[end]"
sub _action_opcode_281 {
	_add_opcode(@_, 0x24);
}
# opcode : inc hl "[end]"
sub _action_opcode_282 {
	_add_opcode(@_, 0x23);
}
# opcode : inc ix "[end]"
sub _action_opcode_283 {
	_add_opcode(@_, 0xDD, 0x23);
}
# opcode : inc ixh "[end]"
sub _action_opcode_284 {
	_add_opcode(@_, 0xDD, 0x24);
}
# opcode : inc ixl "[end]"
sub _action_opcode_285 {
	_add_opcode(@_, 0xDD, 0x2C);
}
# opcode : inc iy "[end]"
sub _action_opcode_286 {
	_add_opcode(@_, 0xFD, 0x23);
}
# opcode : inc iyh "[end]"
sub _action_opcode_287 {
	_add_opcode(@_, 0xFD, 0x24);
}
# opcode : inc iyl "[end]"
sub _action_opcode_288 {
	_add_opcode(@_, 0xFD, 0x2C);
}
# opcode : inc l "[end]"
sub _action_opcode_289 {
	_add_opcode(@_, 0x2C);
}
# opcode : adc a "," "(" hl ")" "[end]"
sub _action_opcode_29 {
	_add_opcode(@_, 0x8E);
}
# opcode : inc sp "[end]"
sub _action_opcode_290 {
	_add_opcode(@_, 0x33);
}
# opcode : ind "[end]"
sub _action_opcode_291 {
	_add_opcode(@_, 0xED, 0xAA);
}
# opcode : indr "[end]"
sub _action_opcode_292 {
	_add_opcode(@_, 0xED, 0xBA);
}
# opcode : ini "[end]"
sub _action_opcode_293 {
	_add_opcode(@_, 0xED, 0xA2);
}
# opcode : inir "[end]"
sub _action_opcode_294 {
	_add_opcode(@_, 0xED, 0xB2);
}
# opcode : jp "(" hl ")" "[end]"
sub _action_opcode_295 {
	_add_opcode(@_, 0xE9);
}
# opcode : jp "(" ix ")" "[end]"
sub _action_opcode_296 {
	_add_opcode(@_, 0xDD, 0xE9);
}
# opcode : jp "(" iy ")" "[end]"
sub _action_opcode_297 {
	_add_opcode(@_, 0xFD, 0xE9);
}
# opcode : jp "[expr_NN]" "[end]"
sub _action_opcode_298 {
	_add_opcode(@_, 0xC3, $_[ARGS][1], undef);
}
# opcode : jp c "," "[expr_NN]" "[end]"
sub _action_opcode_299 {
	_add_opcode(@_, 0xDA, $_[ARGS][3], undef);
}
# opcode : adc a "," "(" ix ")" "[end]"
sub _action_opcode_30 {
	_add_opcode(@_, 0xDD, 0x8E, 0x00);
}
# opcode : jp m "," "[expr_NN]" "[end]"
sub _action_opcode_300 {
	_add_opcode(@_, 0xFA, $_[ARGS][3], undef);
}
# opcode : jp nc "," "[expr_NN]" "[end]"
sub _action_opcode_301 {
	_add_opcode(@_, 0xD2, $_[ARGS][3], undef);
}
# opcode : jp nz "," "[expr_NN]" "[end]"
sub _action_opcode_302 {
	_add_opcode(@_, 0xC2, $_[ARGS][3], undef);
}
# opcode : jp p "," "[expr_NN]" "[end]"
sub _action_opcode_303 {
	_add_opcode(@_, 0xF2, $_[ARGS][3], undef);
}
# opcode : jp pe "," "[expr_NN]" "[end]"
sub _action_opcode_304 {
	_add_opcode(@_, 0xEA, $_[ARGS][3], undef);
}
# opcode : jp po "," "[expr_NN]" "[end]"
sub _action_opcode_305 {
	_add_opcode(@_, 0xE2, $_[ARGS][3], undef);
}
# opcode : jp z "," "[expr_NN]" "[end]"
sub _action_opcode_306 {
	_add_opcode(@_, 0xCA, $_[ARGS][3], undef);
}
# opcode : jr "[expr_NN]" "[end]"
sub _action_opcode_307 {
	_add_jump_opcode(@_, [0x18, $_[ARGS][1]->build('{}-$-2', type => "sb")], [0xC3, $_[ARGS][1], undef]);
}
# opcode : jr c "," "[expr_NN]" "[end]"
sub _action_opcode_308 {
	_add_jump_opcode(@_, [0x38, $_[ARGS][3]->build('{}-$-2', type => "sb")], [0xDA, $_[ARGS][3], undef]);
}
# opcode : jr m "," "[expr_NN]" "[end]"
sub _action_opcode_309 {
	_add_jump_opcode(@_, [0xFA, $_[ARGS][3], undef], [0xFA, $_[ARGS][3], undef]);
}
# opcode : adc a "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_31 {
	_add_opcode(@_, 0xDD, 0x8E, $_[ARGS][6]);
}
# opcode : jr nc "," "[expr_NN]" "[end]"
sub _action_opcode_310 {
	_add_jump_opcode(@_, [0x30, $_[ARGS][3]->build('{}-$-2', type => "sb")], [0xD2, $_[ARGS][3], undef]);
}
# opcode : jr nz "," "[expr_NN]" "[end]"
sub _action_opcode_311 {
	_add_jump_opcode(@_, [0x20, $_[ARGS][3]->build('{}-$-2', type => "sb")], [0xC2, $_[ARGS][3], undef]);
}
# opcode : jr p "," "[expr_NN]" "[end]"
sub _action_opcode_312 {
	_add_jump_opcode(@_, [0xF2, $_[ARGS][3], undef], [0xF2, $_[ARGS][3], undef]);
}
# opcode : jr pe "," "[expr_NN]" "[end]"
sub _action_opcode_313 {
	_add_jump_opcode(@_, [0xEA, $_[ARGS][3], undef], [0xEA, $_[ARGS][3], undef]);
}
# opcode : jr po "," "[expr_NN]" "[end]"
sub _action_opcode_314 {
	_add_jump_opcode(@_, [0xE2, $_[ARGS][3], undef], [0xE2, $_[ARGS][3], undef]);
}
# opcode : jr z "," "[expr_NN]" "[end]"
sub _action_opcode_315 {
	_add_jump_opcode(@_, [0x28, $_[ARGS][3]->build('{}-$-2', type => "sb")], [0xCA, $_[ARGS][3], undef]);
}
# opcode : ld "(" "[expr_NN]" ")" "," a "[end]"
sub _action_opcode_316 {
	_add_opcode(@_, 0x32, $_[ARGS][2], undef);
}
# opcode : ld "(" "[expr_NN]" ")" "," bc "[end]"
sub _action_opcode_317 {
	_add_opcode(@_, 0xED, 0x43, $_[ARGS][2], undef);
}
# opcode : ld "(" "[expr_NN]" ")" "," de "[end]"
sub _action_opcode_318 {
	_add_opcode(@_, 0xED, 0x53, $_[ARGS][2], undef);
}
# opcode : ld "(" "[expr_NN]" ")" "," hl "[end]"
sub _action_opcode_319 {
	_add_opcode(@_, 0x22, $_[ARGS][2], undef);
}
# opcode : adc a "," "(" iy ")" "[end]"
sub _action_opcode_32 {
	_add_opcode(@_, 0xFD, 0x8E, 0x00);
}
# opcode : ld "(" "[expr_NN]" ")" "," ix "[end]"
sub _action_opcode_320 {
	_add_opcode(@_, 0xDD, 0x22, $_[ARGS][2], undef);
}
# opcode : ld "(" "[expr_NN]" ")" "," iy "[end]"
sub _action_opcode_321 {
	_add_opcode(@_, 0xFD, 0x22, $_[ARGS][2], undef);
}
# opcode : ld "(" "[expr_NN]" ")" "," sp "[end]"
sub _action_opcode_322 {
	_add_opcode(@_, 0xED, 0x73, $_[ARGS][2], undef);
}
# opcode : ld "(" bc ")" "," a "[end]"
sub _action_opcode_323 {
	_add_opcode(@_, 0x02);
}
# opcode : ld "(" de ")" "," a "[end]"
sub _action_opcode_324 {
	_add_opcode(@_, 0x12);
}
# opcode : ld "(" hl ")" "," "[expr_N]" "[end]"
sub _action_opcode_325 {
	_add_opcode(@_, 0x36, $_[ARGS][5]);
}
# opcode : ld "(" hl ")" "," a "[end]"
sub _action_opcode_326 {
	_add_opcode(@_, 0x77);
}
# opcode : ld "(" hl ")" "," b "[end]"
sub _action_opcode_327 {
	_add_opcode(@_, 0x70);
}
# opcode : ld "(" hl ")" "," bc "[end]"
sub _action_opcode_328 {
	_add_opcode(@_, 0x71, 0x23, 0x70, 0x2B);
}
# opcode : ld "(" hl ")" "," c "[end]"
sub _action_opcode_329 {
	_add_opcode(@_, 0x71);
}
# opcode : adc a "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_33 {
	_add_opcode(@_, 0xFD, 0x8E, $_[ARGS][6]);
}
# opcode : ld "(" hl ")" "," d "[end]"
sub _action_opcode_330 {
	_add_opcode(@_, 0x72);
}
# opcode : ld "(" hl ")" "," de "[end]"
sub _action_opcode_331 {
	_add_opcode(@_, 0x73, 0x23, 0x72, 0x2B);
}
# opcode : ld "(" hl ")" "," e "[end]"
sub _action_opcode_332 {
	_add_opcode(@_, 0x73);
}
# opcode : ld "(" hl ")" "," h "[end]"
sub _action_opcode_333 {
	_add_opcode(@_, 0x74);
}
# opcode : ld "(" hl ")" "," l "[end]"
sub _action_opcode_334 {
	_add_opcode(@_, 0x75);
}
# opcode : ld "(" ix ")" "," "[expr_N]" "[end]"
sub _action_opcode_335 {
	_add_opcode(@_, 0xDD, 0x36, 0x00, $_[ARGS][5]);
}
# opcode : ld "(" ix ")" "," a "[end]"
sub _action_opcode_336 {
	_add_opcode(@_, 0xDD, 0x77, 0x00);
}
# opcode : ld "(" ix ")" "," b "[end]"
sub _action_opcode_337 {
	_add_opcode(@_, 0xDD, 0x70, 0x00);
}
# opcode : ld "(" ix ")" "," bc "[end]"
sub _action_opcode_338 {
	_add_opcode(@_, 0xDD, 0x71, 0x00, 0xDD, 0x70, 0x01);
}
# opcode : ld "(" ix ")" "," c "[end]"
sub _action_opcode_339 {
	_add_opcode(@_, 0xDD, 0x71, 0x00);
}
# opcode : adc a "," "[expr_N]" "[end]"
sub _action_opcode_34 {
	_add_opcode(@_, 0xCE, $_[ARGS][3]);
}
# opcode : ld "(" ix ")" "," d "[end]"
sub _action_opcode_340 {
	_add_opcode(@_, 0xDD, 0x72, 0x00);
}
# opcode : ld "(" ix ")" "," de "[end]"
sub _action_opcode_341 {
	_add_opcode(@_, 0xDD, 0x73, 0x00, 0xDD, 0x72, 0x01);
}
# opcode : ld "(" ix ")" "," e "[end]"
sub _action_opcode_342 {
	_add_opcode(@_, 0xDD, 0x73, 0x00);
}
# opcode : ld "(" ix ")" "," h "[end]"
sub _action_opcode_343 {
	_add_opcode(@_, 0xDD, 0x74, 0x00);
}
# opcode : ld "(" ix ")" "," hl "[end]"
sub _action_opcode_344 {
	_add_opcode(@_, 0xDD, 0x75, 0x00, 0xDD, 0x74, 0x01);
}
# opcode : ld "(" ix ")" "," l "[end]"
sub _action_opcode_345 {
	_add_opcode(@_, 0xDD, 0x75, 0x00);
}
# opcode : ld "(" ix "+" "[expr_DIS]" ")" "," "[expr_N]" "[end]"
sub _action_opcode_346 {
	_add_opcode(@_, 0xDD, 0x36, $_[ARGS][4], $_[ARGS][7]);
}
# opcode : ld "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_347 {
	_add_opcode(@_, 0xDD, 0x77, $_[ARGS][4]);
}
# opcode : ld "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_348 {
	_add_opcode(@_, 0xDD, 0x70, $_[ARGS][4]);
}
# opcode : ld "(" ix "+" "[expr_DIS]" ")" "," bc "[end]"
sub _action_opcode_349 {
	_add_opcode(@_, 0xDD, 0x71, $_[ARGS][4], 0xDD, 0x70, $_[ARGS][4]->build('{}+1'));
}
# opcode : adc a "," a "[end]"
sub _action_opcode_35 {
	_add_opcode(@_, 0x8F);
}
# opcode : ld "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_350 {
	_add_opcode(@_, 0xDD, 0x71, $_[ARGS][4]);
}
# opcode : ld "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_351 {
	_add_opcode(@_, 0xDD, 0x72, $_[ARGS][4]);
}
# opcode : ld "(" ix "+" "[expr_DIS]" ")" "," de "[end]"
sub _action_opcode_352 {
	_add_opcode(@_, 0xDD, 0x73, $_[ARGS][4], 0xDD, 0x72, $_[ARGS][4]->build('{}+1'));
}
# opcode : ld "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_353 {
	_add_opcode(@_, 0xDD, 0x73, $_[ARGS][4]);
}
# opcode : ld "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_354 {
	_add_opcode(@_, 0xDD, 0x74, $_[ARGS][4]);
}
# opcode : ld "(" ix "+" "[expr_DIS]" ")" "," hl "[end]"
sub _action_opcode_355 {
	_add_opcode(@_, 0xDD, 0x75, $_[ARGS][4], 0xDD, 0x74, $_[ARGS][4]->build('{}+1'));
}
# opcode : ld "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_356 {
	_add_opcode(@_, 0xDD, 0x75, $_[ARGS][4]);
}
# opcode : ld "(" iy ")" "," "[expr_N]" "[end]"
sub _action_opcode_357 {
	_add_opcode(@_, 0xFD, 0x36, 0x00, $_[ARGS][5]);
}
# opcode : ld "(" iy ")" "," a "[end]"
sub _action_opcode_358 {
	_add_opcode(@_, 0xFD, 0x77, 0x00);
}
# opcode : ld "(" iy ")" "," b "[end]"
sub _action_opcode_359 {
	_add_opcode(@_, 0xFD, 0x70, 0x00);
}
# opcode : adc a "," b "[end]"
sub _action_opcode_36 {
	_add_opcode(@_, 0x88);
}
# opcode : ld "(" iy ")" "," bc "[end]"
sub _action_opcode_360 {
	_add_opcode(@_, 0xFD, 0x71, 0x00, 0xFD, 0x70, 0x01);
}
# opcode : ld "(" iy ")" "," c "[end]"
sub _action_opcode_361 {
	_add_opcode(@_, 0xFD, 0x71, 0x00);
}
# opcode : ld "(" iy ")" "," d "[end]"
sub _action_opcode_362 {
	_add_opcode(@_, 0xFD, 0x72, 0x00);
}
# opcode : ld "(" iy ")" "," de "[end]"
sub _action_opcode_363 {
	_add_opcode(@_, 0xFD, 0x73, 0x00, 0xFD, 0x72, 0x01);
}
# opcode : ld "(" iy ")" "," e "[end]"
sub _action_opcode_364 {
	_add_opcode(@_, 0xFD, 0x73, 0x00);
}
# opcode : ld "(" iy ")" "," h "[end]"
sub _action_opcode_365 {
	_add_opcode(@_, 0xFD, 0x74, 0x00);
}
# opcode : ld "(" iy ")" "," hl "[end]"
sub _action_opcode_366 {
	_add_opcode(@_, 0xFD, 0x75, 0x00, 0xFD, 0x74, 0x01);
}
# opcode : ld "(" iy ")" "," l "[end]"
sub _action_opcode_367 {
	_add_opcode(@_, 0xFD, 0x75, 0x00);
}
# opcode : ld "(" iy "+" "[expr_DIS]" ")" "," "[expr_N]" "[end]"
sub _action_opcode_368 {
	_add_opcode(@_, 0xFD, 0x36, $_[ARGS][4], $_[ARGS][7]);
}
# opcode : ld "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_369 {
	_add_opcode(@_, 0xFD, 0x77, $_[ARGS][4]);
}
# opcode : adc a "," c "[end]"
sub _action_opcode_37 {
	_add_opcode(@_, 0x89);
}
# opcode : ld "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_370 {
	_add_opcode(@_, 0xFD, 0x70, $_[ARGS][4]);
}
# opcode : ld "(" iy "+" "[expr_DIS]" ")" "," bc "[end]"
sub _action_opcode_371 {
	_add_opcode(@_, 0xFD, 0x71, $_[ARGS][4], 0xFD, 0x70, $_[ARGS][4]->build('{}+1'));
}
# opcode : ld "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_372 {
	_add_opcode(@_, 0xFD, 0x71, $_[ARGS][4]);
}
# opcode : ld "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_373 {
	_add_opcode(@_, 0xFD, 0x72, $_[ARGS][4]);
}
# opcode : ld "(" iy "+" "[expr_DIS]" ")" "," de "[end]"
sub _action_opcode_374 {
	_add_opcode(@_, 0xFD, 0x73, $_[ARGS][4], 0xFD, 0x72, $_[ARGS][4]->build('{}+1'));
}
# opcode : ld "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_375 {
	_add_opcode(@_, 0xFD, 0x73, $_[ARGS][4]);
}
# opcode : ld "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_376 {
	_add_opcode(@_, 0xFD, 0x74, $_[ARGS][4]);
}
# opcode : ld "(" iy "+" "[expr_DIS]" ")" "," hl "[end]"
sub _action_opcode_377 {
	_add_opcode(@_, 0xFD, 0x75, $_[ARGS][4], 0xFD, 0x74, $_[ARGS][4]->build('{}+1'));
}
# opcode : ld "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_378 {
	_add_opcode(@_, 0xFD, 0x75, $_[ARGS][4]);
}
# opcode : ld a "," "(" "[expr_NN]" ")" "[end]"
sub _action_opcode_379 {
	_add_opcode(@_, 0x3A, $_[ARGS][4], undef);
}
# opcode : adc a "," d "[end]"
sub _action_opcode_38 {
	_add_opcode(@_, 0x8A);
}
# opcode : ld a "," "(" bc ")" "[end]"
sub _action_opcode_380 {
	_add_opcode(@_, 0x0A);
}
# opcode : ld a "," "(" de ")" "[end]"
sub _action_opcode_381 {
	_add_opcode(@_, 0x1A);
}
# opcode : ld a "," "(" hl ")" "[end]"
sub _action_opcode_382 {
	_add_opcode(@_, 0x7E);
}
# opcode : ld a "," "(" ix ")" "[end]"
sub _action_opcode_383 {
	_add_opcode(@_, 0xDD, 0x7E, 0x00);
}
# opcode : ld a "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_384 {
	_add_opcode(@_, 0xDD, 0x7E, $_[ARGS][6]);
}
# opcode : ld a "," "(" iy ")" "[end]"
sub _action_opcode_385 {
	_add_opcode(@_, 0xFD, 0x7E, 0x00);
}
# opcode : ld a "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_386 {
	_add_opcode(@_, 0xFD, 0x7E, $_[ARGS][6]);
}
# opcode : ld a "," "[expr_N]" "[end]"
sub _action_opcode_387 {
	_add_opcode(@_, 0x3E, $_[ARGS][3]);
}
# opcode : ld a "," a "[end]"
sub _action_opcode_388 {
	_add_opcode(@_, 0x7F);
}
# opcode : ld a "," b "[end]"
sub _action_opcode_389 {
	_add_opcode(@_, 0x78);
}
# opcode : adc a "," e "[end]"
sub _action_opcode_39 {
	_add_opcode(@_, 0x8B);
}
# opcode : ld a "," c "[end]"
sub _action_opcode_390 {
	_add_opcode(@_, 0x79);
}
# opcode : ld a "," d "[end]"
sub _action_opcode_391 {
	_add_opcode(@_, 0x7A);
}
# opcode : ld a "," e "[end]"
sub _action_opcode_392 {
	_add_opcode(@_, 0x7B);
}
# opcode : ld a "," h "[end]"
sub _action_opcode_393 {
	_add_opcode(@_, 0x7C);
}
# opcode : ld a "," i "[end]"
sub _action_opcode_394 {
	_add_opcode(@_, 0xED, 0x57);
}
# opcode : ld a "," ixh "[end]"
sub _action_opcode_395 {
	_add_opcode(@_, 0xDD, 0x7C);
}
# opcode : ld a "," ixl "[end]"
sub _action_opcode_396 {
	_add_opcode(@_, 0xDD, 0x7D);
}
# opcode : ld a "," iyh "[end]"
sub _action_opcode_397 {
	_add_opcode(@_, 0xFD, 0x7C);
}
# opcode : ld a "," iyl "[end]"
sub _action_opcode_398 {
	_add_opcode(@_, 0xFD, 0x7D);
}
# opcode : ld a "," l "[end]"
sub _action_opcode_399 {
	_add_opcode(@_, 0x7D);
}
# opcode : adc a "," h "[end]"
sub _action_opcode_40 {
	_add_opcode(@_, 0x8C);
}
# opcode : ld a "," r "[end]"
sub _action_opcode_400 {
	_add_opcode(@_, 0xED, 0x5F);
}
# opcode : ld b "," "(" hl ")" "[end]"
sub _action_opcode_401 {
	_add_opcode(@_, 0x46);
}
# opcode : ld b "," "(" ix ")" "[end]"
sub _action_opcode_402 {
	_add_opcode(@_, 0xDD, 0x46, 0x00);
}
# opcode : ld b "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_403 {
	_add_opcode(@_, 0xDD, 0x46, $_[ARGS][6]);
}
# opcode : ld b "," "(" iy ")" "[end]"
sub _action_opcode_404 {
	_add_opcode(@_, 0xFD, 0x46, 0x00);
}
# opcode : ld b "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_405 {
	_add_opcode(@_, 0xFD, 0x46, $_[ARGS][6]);
}
# opcode : ld b "," "[expr_N]" "[end]"
sub _action_opcode_406 {
	_add_opcode(@_, 0x06, $_[ARGS][3]);
}
# opcode : ld b "," a "[end]"
sub _action_opcode_407 {
	_add_opcode(@_, 0x47);
}
# opcode : ld b "," b "[end]"
sub _action_opcode_408 {
	_add_opcode(@_, 0x40);
}
# opcode : ld b "," c "[end]"
sub _action_opcode_409 {
	_add_opcode(@_, 0x41);
}
# opcode : adc a "," ixh "[end]"
sub _action_opcode_41 {
	_add_opcode(@_, 0xDD, 0x8C);
}
# opcode : ld b "," d "[end]"
sub _action_opcode_410 {
	_add_opcode(@_, 0x42);
}
# opcode : ld b "," e "[end]"
sub _action_opcode_411 {
	_add_opcode(@_, 0x43);
}
# opcode : ld b "," h "[end]"
sub _action_opcode_412 {
	_add_opcode(@_, 0x44);
}
# opcode : ld b "," ixh "[end]"
sub _action_opcode_413 {
	_add_opcode(@_, 0xDD, 0x44);
}
# opcode : ld b "," ixl "[end]"
sub _action_opcode_414 {
	_add_opcode(@_, 0xDD, 0x45);
}
# opcode : ld b "," iyh "[end]"
sub _action_opcode_415 {
	_add_opcode(@_, 0xFD, 0x44);
}
# opcode : ld b "," iyl "[end]"
sub _action_opcode_416 {
	_add_opcode(@_, 0xFD, 0x45);
}
# opcode : ld b "," l "[end]"
sub _action_opcode_417 {
	_add_opcode(@_, 0x45);
}
# opcode : ld bc "," "(" "[expr_NN]" ")" "[end]"
sub _action_opcode_418 {
	_add_opcode(@_, 0xED, 0x4B, $_[ARGS][4], undef);
}
# opcode : ld bc "," "(" hl ")" "[end]"
sub _action_opcode_419 {
	_add_opcode(@_, 0x4E, 0x23, 0x46, 0x2B);
}
# opcode : adc a "," ixl "[end]"
sub _action_opcode_42 {
	_add_opcode(@_, 0xDD, 0x8D);
}
# opcode : ld bc "," "(" ix ")" "[end]"
sub _action_opcode_420 {
	_add_opcode(@_, 0xDD, 0x4E, 0x00, 0xDD, 0x46, 0x01);
}
# opcode : ld bc "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_421 {
	_add_opcode(@_, 0xDD, 0x4E, $_[ARGS][6], 0xDD, 0x46, $_[ARGS][6]->build('{}+1'));
}
# opcode : ld bc "," "(" iy ")" "[end]"
sub _action_opcode_422 {
	_add_opcode(@_, 0xFD, 0x4E, 0x00, 0xFD, 0x46, 0x01);
}
# opcode : ld bc "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_423 {
	_add_opcode(@_, 0xFD, 0x4E, $_[ARGS][6], 0xFD, 0x46, $_[ARGS][6]->build('{}+1'));
}
# opcode : ld bc "," "[expr_NN]" "[end]"
sub _action_opcode_424 {
	_add_opcode(@_, 0x01, $_[ARGS][3], undef);
}
# opcode : ld bc "," bc "[end]"
sub _action_opcode_425 {
	_add_opcode(@_, 0x40, 0x49);
}
# opcode : ld bc "," de "[end]"
sub _action_opcode_426 {
	_add_opcode(@_, 0x42, 0x4B);
}
# opcode : ld bc "," hl "[end]"
sub _action_opcode_427 {
	_add_opcode(@_, 0x44, 0x4D);
}
# opcode : ld bc "," ix "[end]"
sub _action_opcode_428 {
	_add_opcode(@_, 0xDD, 0x44, 0xDD, 0x4D);
}
# opcode : ld bc "," iy "[end]"
sub _action_opcode_429 {
	_add_opcode(@_, 0xFD, 0x44, 0xFD, 0x4D);
}
# opcode : adc a "," iyh "[end]"
sub _action_opcode_43 {
	_add_opcode(@_, 0xFD, 0x8C);
}
# opcode : ld c "," "(" hl ")" "[end]"
sub _action_opcode_430 {
	_add_opcode(@_, 0x4E);
}
# opcode : ld c "," "(" ix ")" "[end]"
sub _action_opcode_431 {
	_add_opcode(@_, 0xDD, 0x4E, 0x00);
}
# opcode : ld c "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_432 {
	_add_opcode(@_, 0xDD, 0x4E, $_[ARGS][6]);
}
# opcode : ld c "," "(" iy ")" "[end]"
sub _action_opcode_433 {
	_add_opcode(@_, 0xFD, 0x4E, 0x00);
}
# opcode : ld c "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_434 {
	_add_opcode(@_, 0xFD, 0x4E, $_[ARGS][6]);
}
# opcode : ld c "," "[expr_N]" "[end]"
sub _action_opcode_435 {
	_add_opcode(@_, 0x0E, $_[ARGS][3]);
}
# opcode : ld c "," a "[end]"
sub _action_opcode_436 {
	_add_opcode(@_, 0x4F);
}
# opcode : ld c "," b "[end]"
sub _action_opcode_437 {
	_add_opcode(@_, 0x48);
}
# opcode : ld c "," c "[end]"
sub _action_opcode_438 {
	_add_opcode(@_, 0x49);
}
# opcode : ld c "," d "[end]"
sub _action_opcode_439 {
	_add_opcode(@_, 0x4A);
}
# opcode : adc a "," iyl "[end]"
sub _action_opcode_44 {
	_add_opcode(@_, 0xFD, 0x8D);
}
# opcode : ld c "," e "[end]"
sub _action_opcode_440 {
	_add_opcode(@_, 0x4B);
}
# opcode : ld c "," h "[end]"
sub _action_opcode_441 {
	_add_opcode(@_, 0x4C);
}
# opcode : ld c "," ixh "[end]"
sub _action_opcode_442 {
	_add_opcode(@_, 0xDD, 0x4C);
}
# opcode : ld c "," ixl "[end]"
sub _action_opcode_443 {
	_add_opcode(@_, 0xDD, 0x4D);
}
# opcode : ld c "," iyh "[end]"
sub _action_opcode_444 {
	_add_opcode(@_, 0xFD, 0x4C);
}
# opcode : ld c "," iyl "[end]"
sub _action_opcode_445 {
	_add_opcode(@_, 0xFD, 0x4D);
}
# opcode : ld c "," l "[end]"
sub _action_opcode_446 {
	_add_opcode(@_, 0x4D);
}
# opcode : ld d "," "(" hl ")" "[end]"
sub _action_opcode_447 {
	_add_opcode(@_, 0x56);
}
# opcode : ld d "," "(" ix ")" "[end]"
sub _action_opcode_448 {
	_add_opcode(@_, 0xDD, 0x56, 0x00);
}
# opcode : ld d "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_449 {
	_add_opcode(@_, 0xDD, 0x56, $_[ARGS][6]);
}
# opcode : adc a "," l "[end]"
sub _action_opcode_45 {
	_add_opcode(@_, 0x8D);
}
# opcode : ld d "," "(" iy ")" "[end]"
sub _action_opcode_450 {
	_add_opcode(@_, 0xFD, 0x56, 0x00);
}
# opcode : ld d "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_451 {
	_add_opcode(@_, 0xFD, 0x56, $_[ARGS][6]);
}
# opcode : ld d "," "[expr_N]" "[end]"
sub _action_opcode_452 {
	_add_opcode(@_, 0x16, $_[ARGS][3]);
}
# opcode : ld d "," a "[end]"
sub _action_opcode_453 {
	_add_opcode(@_, 0x57);
}
# opcode : ld d "," b "[end]"
sub _action_opcode_454 {
	_add_opcode(@_, 0x50);
}
# opcode : ld d "," c "[end]"
sub _action_opcode_455 {
	_add_opcode(@_, 0x51);
}
# opcode : ld d "," d "[end]"
sub _action_opcode_456 {
	_add_opcode(@_, 0x52);
}
# opcode : ld d "," e "[end]"
sub _action_opcode_457 {
	_add_opcode(@_, 0x53);
}
# opcode : ld d "," h "[end]"
sub _action_opcode_458 {
	_add_opcode(@_, 0x54);
}
# opcode : ld d "," ixh "[end]"
sub _action_opcode_459 {
	_add_opcode(@_, 0xDD, 0x54);
}
# opcode : adc hl "," bc "[end]"
sub _action_opcode_46 {
	_add_opcode(@_, 0xED, 0x4A);
}
# opcode : ld d "," ixl "[end]"
sub _action_opcode_460 {
	_add_opcode(@_, 0xDD, 0x55);
}
# opcode : ld d "," iyh "[end]"
sub _action_opcode_461 {
	_add_opcode(@_, 0xFD, 0x54);
}
# opcode : ld d "," iyl "[end]"
sub _action_opcode_462 {
	_add_opcode(@_, 0xFD, 0x55);
}
# opcode : ld d "," l "[end]"
sub _action_opcode_463 {
	_add_opcode(@_, 0x55);
}
# opcode : ld de "," "(" "[expr_NN]" ")" "[end]"
sub _action_opcode_464 {
	_add_opcode(@_, 0xED, 0x5B, $_[ARGS][4], undef);
}
# opcode : ld de "," "(" hl ")" "[end]"
sub _action_opcode_465 {
	_add_opcode(@_, 0x5E, 0x23, 0x56, 0x2B);
}
# opcode : ld de "," "(" ix ")" "[end]"
sub _action_opcode_466 {
	_add_opcode(@_, 0xDD, 0x5E, 0x00, 0xDD, 0x56, 0x01);
}
# opcode : ld de "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_467 {
	_add_opcode(@_, 0xDD, 0x5E, $_[ARGS][6], 0xDD, 0x56, $_[ARGS][6]->build('{}+1'));
}
# opcode : ld de "," "(" iy ")" "[end]"
sub _action_opcode_468 {
	_add_opcode(@_, 0xFD, 0x5E, 0x00, 0xFD, 0x56, 0x01);
}
# opcode : ld de "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_469 {
	_add_opcode(@_, 0xFD, 0x5E, $_[ARGS][6], 0xFD, 0x56, $_[ARGS][6]->build('{}+1'));
}
# opcode : adc hl "," de "[end]"
sub _action_opcode_47 {
	_add_opcode(@_, 0xED, 0x5A);
}
# opcode : ld de "," "[expr_NN]" "[end]"
sub _action_opcode_470 {
	_add_opcode(@_, 0x11, $_[ARGS][3], undef);
}
# opcode : ld de "," bc "[end]"
sub _action_opcode_471 {
	_add_opcode(@_, 0x50, 0x59);
}
# opcode : ld de "," de "[end]"
sub _action_opcode_472 {
	_add_opcode(@_, 0x52, 0x5B);
}
# opcode : ld de "," hl "[end]"
sub _action_opcode_473 {
	_add_opcode(@_, 0x54, 0x5D);
}
# opcode : ld de "," ix "[end]"
sub _action_opcode_474 {
	_add_opcode(@_, 0xDD, 0x54, 0xDD, 0x5D);
}
# opcode : ld de "," iy "[end]"
sub _action_opcode_475 {
	_add_opcode(@_, 0xFD, 0x54, 0xFD, 0x5D);
}
# opcode : ld e "," "(" hl ")" "[end]"
sub _action_opcode_476 {
	_add_opcode(@_, 0x5E);
}
# opcode : ld e "," "(" ix ")" "[end]"
sub _action_opcode_477 {
	_add_opcode(@_, 0xDD, 0x5E, 0x00);
}
# opcode : ld e "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_478 {
	_add_opcode(@_, 0xDD, 0x5E, $_[ARGS][6]);
}
# opcode : ld e "," "(" iy ")" "[end]"
sub _action_opcode_479 {
	_add_opcode(@_, 0xFD, 0x5E, 0x00);
}
# opcode : adc hl "," hl "[end]"
sub _action_opcode_48 {
	_add_opcode(@_, 0xED, 0x6A);
}
# opcode : ld e "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_480 {
	_add_opcode(@_, 0xFD, 0x5E, $_[ARGS][6]);
}
# opcode : ld e "," "[expr_N]" "[end]"
sub _action_opcode_481 {
	_add_opcode(@_, 0x1E, $_[ARGS][3]);
}
# opcode : ld e "," a "[end]"
sub _action_opcode_482 {
	_add_opcode(@_, 0x5F);
}
# opcode : ld e "," b "[end]"
sub _action_opcode_483 {
	_add_opcode(@_, 0x58);
}
# opcode : ld e "," c "[end]"
sub _action_opcode_484 {
	_add_opcode(@_, 0x59);
}
# opcode : ld e "," d "[end]"
sub _action_opcode_485 {
	_add_opcode(@_, 0x5A);
}
# opcode : ld e "," e "[end]"
sub _action_opcode_486 {
	_add_opcode(@_, 0x5B);
}
# opcode : ld e "," h "[end]"
sub _action_opcode_487 {
	_add_opcode(@_, 0x5C);
}
# opcode : ld e "," ixh "[end]"
sub _action_opcode_488 {
	_add_opcode(@_, 0xDD, 0x5C);
}
# opcode : ld e "," ixl "[end]"
sub _action_opcode_489 {
	_add_opcode(@_, 0xDD, 0x5D);
}
# opcode : adc hl "," sp "[end]"
sub _action_opcode_49 {
	_add_opcode(@_, 0xED, 0x7A);
}
# opcode : ld e "," iyh "[end]"
sub _action_opcode_490 {
	_add_opcode(@_, 0xFD, 0x5C);
}
# opcode : ld e "," iyl "[end]"
sub _action_opcode_491 {
	_add_opcode(@_, 0xFD, 0x5D);
}
# opcode : ld e "," l "[end]"
sub _action_opcode_492 {
	_add_opcode(@_, 0x5D);
}
# opcode : ld h "," "(" hl ")" "[end]"
sub _action_opcode_493 {
	_add_opcode(@_, 0x66);
}
# opcode : ld h "," "(" ix ")" "[end]"
sub _action_opcode_494 {
	_add_opcode(@_, 0xDD, 0x66, 0x00);
}
# opcode : ld h "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_495 {
	_add_opcode(@_, 0xDD, 0x66, $_[ARGS][6]);
}
# opcode : ld h "," "(" iy ")" "[end]"
sub _action_opcode_496 {
	_add_opcode(@_, 0xFD, 0x66, 0x00);
}
# opcode : ld h "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_497 {
	_add_opcode(@_, 0xFD, 0x66, $_[ARGS][6]);
}
# opcode : ld h "," "[expr_N]" "[end]"
sub _action_opcode_498 {
	_add_opcode(@_, 0x26, $_[ARGS][3]);
}
# opcode : ld h "," a "[end]"
sub _action_opcode_499 {
	_add_opcode(@_, 0x67);
}
# opcode : add a "," "(" hl ")" "[end]"
sub _action_opcode_50 {
	_add_opcode(@_, 0x86);
}
# opcode : ld h "," b "[end]"
sub _action_opcode_500 {
	_add_opcode(@_, 0x60);
}
# opcode : ld h "," c "[end]"
sub _action_opcode_501 {
	_add_opcode(@_, 0x61);
}
# opcode : ld h "," d "[end]"
sub _action_opcode_502 {
	_add_opcode(@_, 0x62);
}
# opcode : ld h "," e "[end]"
sub _action_opcode_503 {
	_add_opcode(@_, 0x63);
}
# opcode : ld h "," h "[end]"
sub _action_opcode_504 {
	_add_opcode(@_, 0x64);
}
# opcode : ld h "," l "[end]"
sub _action_opcode_505 {
	_add_opcode(@_, 0x65);
}
# opcode : ld hl "," "(" "[expr_NN]" ")" "[end]"
sub _action_opcode_506 {
	_add_opcode(@_, 0x2A, $_[ARGS][4], undef);
}
# opcode : ld hl "," "(" ix ")" "[end]"
sub _action_opcode_507 {
	_add_opcode(@_, 0xDD, 0x6E, 0x00, 0xDD, 0x66, 0x01);
}
# opcode : ld hl "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_508 {
	_add_opcode(@_, 0xDD, 0x6E, $_[ARGS][6], 0xDD, 0x66, $_[ARGS][6]->build('{}+1'));
}
# opcode : ld hl "," "(" iy ")" "[end]"
sub _action_opcode_509 {
	_add_opcode(@_, 0xFD, 0x6E, 0x00, 0xFD, 0x66, 0x01);
}
# opcode : add a "," "(" ix ")" "[end]"
sub _action_opcode_51 {
	_add_opcode(@_, 0xDD, 0x86, 0x00);
}
# opcode : ld hl "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_510 {
	_add_opcode(@_, 0xFD, 0x6E, $_[ARGS][6], 0xFD, 0x66, $_[ARGS][6]->build('{}+1'));
}
# opcode : ld hl "," "[expr_NN]" "[end]"
sub _action_opcode_511 {
	_add_opcode(@_, 0x21, $_[ARGS][3], undef);
}
# opcode : ld hl "," bc "[end]"
sub _action_opcode_512 {
	_add_opcode(@_, 0x60, 0x69);
}
# opcode : ld hl "," de "[end]"
sub _action_opcode_513 {
	_add_opcode(@_, 0x62, 0x6B);
}
# opcode : ld hl "," hl "[end]"
sub _action_opcode_514 {
	_add_opcode(@_, 0x64, 0x6D);
}
# opcode : ld hl "," ix "[end]"
sub _action_opcode_515 {
	_add_opcode(@_, 0xDD, 0xE5, 0xE1);
}
# opcode : ld hl "," iy "[end]"
sub _action_opcode_516 {
	_add_opcode(@_, 0xFD, 0xE5, 0xE1);
}
# opcode : ld i "," a "[end]"
sub _action_opcode_517 {
	_add_opcode(@_, 0xED, 0x47);
}
# opcode : ld ix "," "(" "[expr_NN]" ")" "[end]"
sub _action_opcode_518 {
	_add_opcode(@_, 0xDD, 0x2A, $_[ARGS][4], undef);
}
# opcode : ld ix "," "[expr_NN]" "[end]"
sub _action_opcode_519 {
	_add_opcode(@_, 0xDD, 0x21, $_[ARGS][3], undef);
}
# opcode : add a "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_52 {
	_add_opcode(@_, 0xDD, 0x86, $_[ARGS][6]);
}
# opcode : ld ix "," bc "[end]"
sub _action_opcode_520 {
	_add_opcode(@_, 0xDD, 0x69, 0xDD, 0x60);
}
# opcode : ld ix "," de "[end]"
sub _action_opcode_521 {
	_add_opcode(@_, 0xDD, 0x6B, 0xDD, 0x62);
}
# opcode : ld ix "," hl "[end]"
sub _action_opcode_522 {
	_add_opcode(@_, 0xE5, 0xDD, 0xE1);
}
# opcode : ld ix "," ix "[end]"
sub _action_opcode_523 {
	_add_opcode(@_, 0xDD, 0x6D, 0xDD, 0x64);
}
# opcode : ld ix "," iy "[end]"
sub _action_opcode_524 {
	_add_opcode(@_, 0xFD, 0xE5, 0xDD, 0xE1);
}
# opcode : ld ixh "," "[expr_N]" "[end]"
sub _action_opcode_525 {
	_add_opcode(@_, 0xDD, 0x26, $_[ARGS][3]);
}
# opcode : ld ixh "," a "[end]"
sub _action_opcode_526 {
	_add_opcode(@_, 0xDD, 0x67);
}
# opcode : ld ixh "," b "[end]"
sub _action_opcode_527 {
	_add_opcode(@_, 0xDD, 0x60);
}
# opcode : ld ixh "," c "[end]"
sub _action_opcode_528 {
	_add_opcode(@_, 0xDD, 0x61);
}
# opcode : ld ixh "," d "[end]"
sub _action_opcode_529 {
	_add_opcode(@_, 0xDD, 0x62);
}
# opcode : add a "," "(" iy ")" "[end]"
sub _action_opcode_53 {
	_add_opcode(@_, 0xFD, 0x86, 0x00);
}
# opcode : ld ixh "," e "[end]"
sub _action_opcode_530 {
	_add_opcode(@_, 0xDD, 0x63);
}
# opcode : ld ixh "," ixh "[end]"
sub _action_opcode_531 {
	_add_opcode(@_, 0xDD, 0x64);
}
# opcode : ld ixh "," ixl "[end]"
sub _action_opcode_532 {
	_add_opcode(@_, 0xDD, 0x65);
}
# opcode : ld ixl "," "[expr_N]" "[end]"
sub _action_opcode_533 {
	_add_opcode(@_, 0xDD, 0x2E, $_[ARGS][3]);
}
# opcode : ld ixl "," a "[end]"
sub _action_opcode_534 {
	_add_opcode(@_, 0xDD, 0x6F);
}
# opcode : ld ixl "," b "[end]"
sub _action_opcode_535 {
	_add_opcode(@_, 0xDD, 0x68);
}
# opcode : ld ixl "," c "[end]"
sub _action_opcode_536 {
	_add_opcode(@_, 0xDD, 0x69);
}
# opcode : ld ixl "," d "[end]"
sub _action_opcode_537 {
	_add_opcode(@_, 0xDD, 0x6A);
}
# opcode : ld ixl "," e "[end]"
sub _action_opcode_538 {
	_add_opcode(@_, 0xDD, 0x6B);
}
# opcode : ld ixl "," ixh "[end]"
sub _action_opcode_539 {
	_add_opcode(@_, 0xDD, 0x6C);
}
# opcode : add a "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_54 {
	_add_opcode(@_, 0xFD, 0x86, $_[ARGS][6]);
}
# opcode : ld ixl "," ixl "[end]"
sub _action_opcode_540 {
	_add_opcode(@_, 0xDD, 0x6D);
}
# opcode : ld iy "," "(" "[expr_NN]" ")" "[end]"
sub _action_opcode_541 {
	_add_opcode(@_, 0xFD, 0x2A, $_[ARGS][4], undef);
}
# opcode : ld iy "," "[expr_NN]" "[end]"
sub _action_opcode_542 {
	_add_opcode(@_, 0xFD, 0x21, $_[ARGS][3], undef);
}
# opcode : ld iy "," bc "[end]"
sub _action_opcode_543 {
	_add_opcode(@_, 0xFD, 0x69, 0xFD, 0x60);
}
# opcode : ld iy "," de "[end]"
sub _action_opcode_544 {
	_add_opcode(@_, 0xFD, 0x6B, 0xFD, 0x62);
}
# opcode : ld iy "," hl "[end]"
sub _action_opcode_545 {
	_add_opcode(@_, 0xE5, 0xFD, 0xE1);
}
# opcode : ld iy "," ix "[end]"
sub _action_opcode_546 {
	_add_opcode(@_, 0xDD, 0xE5, 0xFD, 0xE1);
}
# opcode : ld iy "," iy "[end]"
sub _action_opcode_547 {
	_add_opcode(@_, 0xFD, 0x6D, 0xFD, 0x64);
}
# opcode : ld iyh "," "[expr_N]" "[end]"
sub _action_opcode_548 {
	_add_opcode(@_, 0xFD, 0x26, $_[ARGS][3]);
}
# opcode : ld iyh "," a "[end]"
sub _action_opcode_549 {
	_add_opcode(@_, 0xFD, 0x67);
}
# opcode : add a "," "[expr_N]" "[end]"
sub _action_opcode_55 {
	_add_opcode(@_, 0xC6, $_[ARGS][3]);
}
# opcode : ld iyh "," b "[end]"
sub _action_opcode_550 {
	_add_opcode(@_, 0xFD, 0x60);
}
# opcode : ld iyh "," c "[end]"
sub _action_opcode_551 {
	_add_opcode(@_, 0xFD, 0x61);
}
# opcode : ld iyh "," d "[end]"
sub _action_opcode_552 {
	_add_opcode(@_, 0xFD, 0x62);
}
# opcode : ld iyh "," e "[end]"
sub _action_opcode_553 {
	_add_opcode(@_, 0xFD, 0x63);
}
# opcode : ld iyh "," iyh "[end]"
sub _action_opcode_554 {
	_add_opcode(@_, 0xFD, 0x64);
}
# opcode : ld iyh "," iyl "[end]"
sub _action_opcode_555 {
	_add_opcode(@_, 0xFD, 0x65);
}
# opcode : ld iyl "," "[expr_N]" "[end]"
sub _action_opcode_556 {
	_add_opcode(@_, 0xFD, 0x2E, $_[ARGS][3]);
}
# opcode : ld iyl "," a "[end]"
sub _action_opcode_557 {
	_add_opcode(@_, 0xFD, 0x6F);
}
# opcode : ld iyl "," b "[end]"
sub _action_opcode_558 {
	_add_opcode(@_, 0xFD, 0x68);
}
# opcode : ld iyl "," c "[end]"
sub _action_opcode_559 {
	_add_opcode(@_, 0xFD, 0x69);
}
# opcode : add a "," a "[end]"
sub _action_opcode_56 {
	_add_opcode(@_, 0x87);
}
# opcode : ld iyl "," d "[end]"
sub _action_opcode_560 {
	_add_opcode(@_, 0xFD, 0x6A);
}
# opcode : ld iyl "," e "[end]"
sub _action_opcode_561 {
	_add_opcode(@_, 0xFD, 0x6B);
}
# opcode : ld iyl "," iyh "[end]"
sub _action_opcode_562 {
	_add_opcode(@_, 0xFD, 0x6C);
}
# opcode : ld iyl "," iyl "[end]"
sub _action_opcode_563 {
	_add_opcode(@_, 0xFD, 0x6D);
}
# opcode : ld l "," "(" hl ")" "[end]"
sub _action_opcode_564 {
	_add_opcode(@_, 0x6E);
}
# opcode : ld l "," "(" ix ")" "[end]"
sub _action_opcode_565 {
	_add_opcode(@_, 0xDD, 0x6E, 0x00);
}
# opcode : ld l "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_566 {
	_add_opcode(@_, 0xDD, 0x6E, $_[ARGS][6]);
}
# opcode : ld l "," "(" iy ")" "[end]"
sub _action_opcode_567 {
	_add_opcode(@_, 0xFD, 0x6E, 0x00);
}
# opcode : ld l "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_568 {
	_add_opcode(@_, 0xFD, 0x6E, $_[ARGS][6]);
}
# opcode : ld l "," "[expr_N]" "[end]"
sub _action_opcode_569 {
	_add_opcode(@_, 0x2E, $_[ARGS][3]);
}
# opcode : add a "," b "[end]"
sub _action_opcode_57 {
	_add_opcode(@_, 0x80);
}
# opcode : ld l "," a "[end]"
sub _action_opcode_570 {
	_add_opcode(@_, 0x6F);
}
# opcode : ld l "," b "[end]"
sub _action_opcode_571 {
	_add_opcode(@_, 0x68);
}
# opcode : ld l "," c "[end]"
sub _action_opcode_572 {
	_add_opcode(@_, 0x69);
}
# opcode : ld l "," d "[end]"
sub _action_opcode_573 {
	_add_opcode(@_, 0x6A);
}
# opcode : ld l "," e "[end]"
sub _action_opcode_574 {
	_add_opcode(@_, 0x6B);
}
# opcode : ld l "," h "[end]"
sub _action_opcode_575 {
	_add_opcode(@_, 0x6C);
}
# opcode : ld l "," l "[end]"
sub _action_opcode_576 {
	_add_opcode(@_, 0x6D);
}
# opcode : ld r "," a "[end]"
sub _action_opcode_577 {
	_add_opcode(@_, 0xED, 0x4F);
}
# opcode : ld sp "," "(" "[expr_NN]" ")" "[end]"
sub _action_opcode_578 {
	_add_opcode(@_, 0xED, 0x7B, $_[ARGS][4], undef);
}
# opcode : ld sp "," "[expr_NN]" "[end]"
sub _action_opcode_579 {
	_add_opcode(@_, 0x31, $_[ARGS][3], undef);
}
# opcode : add a "," c "[end]"
sub _action_opcode_58 {
	_add_opcode(@_, 0x81);
}
# opcode : ld sp "," hl "[end]"
sub _action_opcode_580 {
	_add_opcode(@_, 0xF9);
}
# opcode : ld sp "," ix "[end]"
sub _action_opcode_581 {
	_add_opcode(@_, 0xDD, 0xF9);
}
# opcode : ld sp "," iy "[end]"
sub _action_opcode_582 {
	_add_opcode(@_, 0xFD, 0xF9);
}
# opcode : ldd "[end]"
sub _action_opcode_583 {
	_add_opcode(@_, 0xED, 0xA8);
}
# opcode : ldd "(" bc ")" "," a "[end]"
sub _action_opcode_584 {
	_add_opcode(@_, 0x02, 0x0B);
}
# opcode : ldd "(" de ")" "," a "[end]"
sub _action_opcode_585 {
	_add_opcode(@_, 0x12, 0x1B);
}
# opcode : ldd "(" hl ")" "," "[expr_N]" "[end]"
sub _action_opcode_586 {
	_add_opcode(@_, 0x36, $_[ARGS][5], 0x2B);
}
# opcode : ldd "(" hl ")" "," a "[end]"
sub _action_opcode_587 {
	_add_opcode(@_, 0x77, 0x2B);
}
# opcode : ldd "(" hl ")" "," b "[end]"
sub _action_opcode_588 {
	_add_opcode(@_, 0x70, 0x2B);
}
# opcode : ldd "(" hl ")" "," c "[end]"
sub _action_opcode_589 {
	_add_opcode(@_, 0x71, 0x2B);
}
# opcode : add a "," d "[end]"
sub _action_opcode_59 {
	_add_opcode(@_, 0x82);
}
# opcode : ldd "(" hl ")" "," d "[end]"
sub _action_opcode_590 {
	_add_opcode(@_, 0x72, 0x2B);
}
# opcode : ldd "(" hl ")" "," e "[end]"
sub _action_opcode_591 {
	_add_opcode(@_, 0x73, 0x2B);
}
# opcode : ldd "(" hl ")" "," h "[end]"
sub _action_opcode_592 {
	_add_opcode(@_, 0x74, 0x2B);
}
# opcode : ldd "(" hl ")" "," l "[end]"
sub _action_opcode_593 {
	_add_opcode(@_, 0x75, 0x2B);
}
# opcode : ldd "(" ix ")" "," "[expr_N]" "[end]"
sub _action_opcode_594 {
	_add_opcode(@_, 0xDD, 0x36, 0x00, $_[ARGS][5], 0xDD, 0x2B);
}
# opcode : ldd "(" ix ")" "," a "[end]"
sub _action_opcode_595 {
	_add_opcode(@_, 0xDD, 0x77, 0x00, 0xDD, 0x2B);
}
# opcode : ldd "(" ix ")" "," b "[end]"
sub _action_opcode_596 {
	_add_opcode(@_, 0xDD, 0x70, 0x00, 0xDD, 0x2B);
}
# opcode : ldd "(" ix ")" "," c "[end]"
sub _action_opcode_597 {
	_add_opcode(@_, 0xDD, 0x71, 0x00, 0xDD, 0x2B);
}
# opcode : ldd "(" ix ")" "," d "[end]"
sub _action_opcode_598 {
	_add_opcode(@_, 0xDD, 0x72, 0x00, 0xDD, 0x2B);
}
# opcode : ldd "(" ix ")" "," e "[end]"
sub _action_opcode_599 {
	_add_opcode(@_, 0xDD, 0x73, 0x00, 0xDD, 0x2B);
}
# opcode : add a "," e "[end]"
sub _action_opcode_60 {
	_add_opcode(@_, 0x83);
}
# opcode : ldd "(" ix ")" "," h "[end]"
sub _action_opcode_600 {
	_add_opcode(@_, 0xDD, 0x74, 0x00, 0xDD, 0x2B);
}
# opcode : ldd "(" ix ")" "," l "[end]"
sub _action_opcode_601 {
	_add_opcode(@_, 0xDD, 0x75, 0x00, 0xDD, 0x2B);
}
# opcode : ldd "(" ix "+" "[expr_DIS]" ")" "," "[expr_N]" "[end]"
sub _action_opcode_602 {
	_add_opcode(@_, 0xDD, 0x36, $_[ARGS][4], $_[ARGS][7], 0xDD, 0x2B);
}
# opcode : ldd "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_603 {
	_add_opcode(@_, 0xDD, 0x77, $_[ARGS][4], 0xDD, 0x2B);
}
# opcode : ldd "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_604 {
	_add_opcode(@_, 0xDD, 0x70, $_[ARGS][4], 0xDD, 0x2B);
}
# opcode : ldd "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_605 {
	_add_opcode(@_, 0xDD, 0x71, $_[ARGS][4], 0xDD, 0x2B);
}
# opcode : ldd "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_606 {
	_add_opcode(@_, 0xDD, 0x72, $_[ARGS][4], 0xDD, 0x2B);
}
# opcode : ldd "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_607 {
	_add_opcode(@_, 0xDD, 0x73, $_[ARGS][4], 0xDD, 0x2B);
}
# opcode : ldd "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_608 {
	_add_opcode(@_, 0xDD, 0x74, $_[ARGS][4], 0xDD, 0x2B);
}
# opcode : ldd "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_609 {
	_add_opcode(@_, 0xDD, 0x75, $_[ARGS][4], 0xDD, 0x2B);
}
# opcode : add a "," h "[end]"
sub _action_opcode_61 {
	_add_opcode(@_, 0x84);
}
# opcode : ldd "(" iy ")" "," "[expr_N]" "[end]"
sub _action_opcode_610 {
	_add_opcode(@_, 0xFD, 0x36, 0x00, $_[ARGS][5], 0xFD, 0x2B);
}
# opcode : ldd "(" iy ")" "," a "[end]"
sub _action_opcode_611 {
	_add_opcode(@_, 0xFD, 0x77, 0x00, 0xFD, 0x2B);
}
# opcode : ldd "(" iy ")" "," b "[end]"
sub _action_opcode_612 {
	_add_opcode(@_, 0xFD, 0x70, 0x00, 0xFD, 0x2B);
}
# opcode : ldd "(" iy ")" "," c "[end]"
sub _action_opcode_613 {
	_add_opcode(@_, 0xFD, 0x71, 0x00, 0xFD, 0x2B);
}
# opcode : ldd "(" iy ")" "," d "[end]"
sub _action_opcode_614 {
	_add_opcode(@_, 0xFD, 0x72, 0x00, 0xFD, 0x2B);
}
# opcode : ldd "(" iy ")" "," e "[end]"
sub _action_opcode_615 {
	_add_opcode(@_, 0xFD, 0x73, 0x00, 0xFD, 0x2B);
}
# opcode : ldd "(" iy ")" "," h "[end]"
sub _action_opcode_616 {
	_add_opcode(@_, 0xFD, 0x74, 0x00, 0xFD, 0x2B);
}
# opcode : ldd "(" iy ")" "," l "[end]"
sub _action_opcode_617 {
	_add_opcode(@_, 0xFD, 0x75, 0x00, 0xFD, 0x2B);
}
# opcode : ldd "(" iy "+" "[expr_DIS]" ")" "," "[expr_N]" "[end]"
sub _action_opcode_618 {
	_add_opcode(@_, 0xFD, 0x36, $_[ARGS][4], $_[ARGS][7], 0xFD, 0x2B);
}
# opcode : ldd "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_619 {
	_add_opcode(@_, 0xFD, 0x77, $_[ARGS][4], 0xFD, 0x2B);
}
# opcode : add a "," ixh "[end]"
sub _action_opcode_62 {
	_add_opcode(@_, 0xDD, 0x84);
}
# opcode : ldd "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_620 {
	_add_opcode(@_, 0xFD, 0x70, $_[ARGS][4], 0xFD, 0x2B);
}
# opcode : ldd "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_621 {
	_add_opcode(@_, 0xFD, 0x71, $_[ARGS][4], 0xFD, 0x2B);
}
# opcode : ldd "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_622 {
	_add_opcode(@_, 0xFD, 0x72, $_[ARGS][4], 0xFD, 0x2B);
}
# opcode : ldd "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_623 {
	_add_opcode(@_, 0xFD, 0x73, $_[ARGS][4], 0xFD, 0x2B);
}
# opcode : ldd "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_624 {
	_add_opcode(@_, 0xFD, 0x74, $_[ARGS][4], 0xFD, 0x2B);
}
# opcode : ldd "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_625 {
	_add_opcode(@_, 0xFD, 0x75, $_[ARGS][4], 0xFD, 0x2B);
}
# opcode : ldd a "," "(" bc ")" "[end]"
sub _action_opcode_626 {
	_add_opcode(@_, 0x0A, 0x0B);
}
# opcode : ldd a "," "(" de ")" "[end]"
sub _action_opcode_627 {
	_add_opcode(@_, 0x1A, 0x1B);
}
# opcode : ldd a "," "(" hl ")" "[end]"
sub _action_opcode_628 {
	_add_opcode(@_, 0x7E, 0x2B);
}
# opcode : ldd a "," "(" ix ")" "[end]"
sub _action_opcode_629 {
	_add_opcode(@_, 0xDD, 0x7E, 0x00, 0xDD, 0x2B);
}
# opcode : add a "," ixl "[end]"
sub _action_opcode_63 {
	_add_opcode(@_, 0xDD, 0x85);
}
# opcode : ldd a "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_630 {
	_add_opcode(@_, 0xDD, 0x7E, $_[ARGS][6], 0xDD, 0x2B);
}
# opcode : ldd a "," "(" iy ")" "[end]"
sub _action_opcode_631 {
	_add_opcode(@_, 0xFD, 0x7E, 0x00, 0xFD, 0x2B);
}
# opcode : ldd a "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_632 {
	_add_opcode(@_, 0xFD, 0x7E, $_[ARGS][6], 0xFD, 0x2B);
}
# opcode : ldd b "," "(" hl ")" "[end]"
sub _action_opcode_633 {
	_add_opcode(@_, 0x46, 0x2B);
}
# opcode : ldd b "," "(" ix ")" "[end]"
sub _action_opcode_634 {
	_add_opcode(@_, 0xDD, 0x46, 0x00, 0xDD, 0x2B);
}
# opcode : ldd b "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_635 {
	_add_opcode(@_, 0xDD, 0x46, $_[ARGS][6], 0xDD, 0x2B);
}
# opcode : ldd b "," "(" iy ")" "[end]"
sub _action_opcode_636 {
	_add_opcode(@_, 0xFD, 0x46, 0x00, 0xFD, 0x2B);
}
# opcode : ldd b "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_637 {
	_add_opcode(@_, 0xFD, 0x46, $_[ARGS][6], 0xFD, 0x2B);
}
# opcode : ldd c "," "(" hl ")" "[end]"
sub _action_opcode_638 {
	_add_opcode(@_, 0x4E, 0x2B);
}
# opcode : ldd c "," "(" ix ")" "[end]"
sub _action_opcode_639 {
	_add_opcode(@_, 0xDD, 0x4E, 0x00, 0xDD, 0x2B);
}
# opcode : add a "," iyh "[end]"
sub _action_opcode_64 {
	_add_opcode(@_, 0xFD, 0x84);
}
# opcode : ldd c "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_640 {
	_add_opcode(@_, 0xDD, 0x4E, $_[ARGS][6], 0xDD, 0x2B);
}
# opcode : ldd c "," "(" iy ")" "[end]"
sub _action_opcode_641 {
	_add_opcode(@_, 0xFD, 0x4E, 0x00, 0xFD, 0x2B);
}
# opcode : ldd c "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_642 {
	_add_opcode(@_, 0xFD, 0x4E, $_[ARGS][6], 0xFD, 0x2B);
}
# opcode : ldd d "," "(" hl ")" "[end]"
sub _action_opcode_643 {
	_add_opcode(@_, 0x56, 0x2B);
}
# opcode : ldd d "," "(" ix ")" "[end]"
sub _action_opcode_644 {
	_add_opcode(@_, 0xDD, 0x56, 0x00, 0xDD, 0x2B);
}
# opcode : ldd d "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_645 {
	_add_opcode(@_, 0xDD, 0x56, $_[ARGS][6], 0xDD, 0x2B);
}
# opcode : ldd d "," "(" iy ")" "[end]"
sub _action_opcode_646 {
	_add_opcode(@_, 0xFD, 0x56, 0x00, 0xFD, 0x2B);
}
# opcode : ldd d "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_647 {
	_add_opcode(@_, 0xFD, 0x56, $_[ARGS][6], 0xFD, 0x2B);
}
# opcode : ldd e "," "(" hl ")" "[end]"
sub _action_opcode_648 {
	_add_opcode(@_, 0x5E, 0x2B);
}
# opcode : ldd e "," "(" ix ")" "[end]"
sub _action_opcode_649 {
	_add_opcode(@_, 0xDD, 0x5E, 0x00, 0xDD, 0x2B);
}
# opcode : add a "," iyl "[end]"
sub _action_opcode_65 {
	_add_opcode(@_, 0xFD, 0x85);
}
# opcode : ldd e "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_650 {
	_add_opcode(@_, 0xDD, 0x5E, $_[ARGS][6], 0xDD, 0x2B);
}
# opcode : ldd e "," "(" iy ")" "[end]"
sub _action_opcode_651 {
	_add_opcode(@_, 0xFD, 0x5E, 0x00, 0xFD, 0x2B);
}
# opcode : ldd e "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_652 {
	_add_opcode(@_, 0xFD, 0x5E, $_[ARGS][6], 0xFD, 0x2B);
}
# opcode : ldd h "," "(" hl ")" "[end]"
sub _action_opcode_653 {
	_add_opcode(@_, 0x66, 0x2B);
}
# opcode : ldd h "," "(" ix ")" "[end]"
sub _action_opcode_654 {
	_add_opcode(@_, 0xDD, 0x66, 0x00, 0xDD, 0x2B);
}
# opcode : ldd h "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_655 {
	_add_opcode(@_, 0xDD, 0x66, $_[ARGS][6], 0xDD, 0x2B);
}
# opcode : ldd h "," "(" iy ")" "[end]"
sub _action_opcode_656 {
	_add_opcode(@_, 0xFD, 0x66, 0x00, 0xFD, 0x2B);
}
# opcode : ldd h "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_657 {
	_add_opcode(@_, 0xFD, 0x66, $_[ARGS][6], 0xFD, 0x2B);
}
# opcode : ldd l "," "(" hl ")" "[end]"
sub _action_opcode_658 {
	_add_opcode(@_, 0x6E, 0x2B);
}
# opcode : ldd l "," "(" ix ")" "[end]"
sub _action_opcode_659 {
	_add_opcode(@_, 0xDD, 0x6E, 0x00, 0xDD, 0x2B);
}
# opcode : add a "," l "[end]"
sub _action_opcode_66 {
	_add_opcode(@_, 0x85);
}
# opcode : ldd l "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_660 {
	_add_opcode(@_, 0xDD, 0x6E, $_[ARGS][6], 0xDD, 0x2B);
}
# opcode : ldd l "," "(" iy ")" "[end]"
sub _action_opcode_661 {
	_add_opcode(@_, 0xFD, 0x6E, 0x00, 0xFD, 0x2B);
}
# opcode : ldd l "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_662 {
	_add_opcode(@_, 0xFD, 0x6E, $_[ARGS][6], 0xFD, 0x2B);
}
# opcode : lddr "[end]"
sub _action_opcode_663 {
	_add_opcode(@_, 0xED, 0xB8);
}
# opcode : ldi "[end]"
sub _action_opcode_664 {
	_add_opcode(@_, 0xED, 0xA0);
}
# opcode : ldi "(" bc ")" "," a "[end]"
sub _action_opcode_665 {
	_add_opcode(@_, 0x02, 0x03);
}
# opcode : ldi "(" de ")" "," a "[end]"
sub _action_opcode_666 {
	_add_opcode(@_, 0x12, 0x13);
}
# opcode : ldi "(" hl ")" "," "[expr_N]" "[end]"
sub _action_opcode_667 {
	_add_opcode(@_, 0x36, $_[ARGS][5], 0x23);
}
# opcode : ldi "(" hl ")" "," a "[end]"
sub _action_opcode_668 {
	_add_opcode(@_, 0x77, 0x23);
}
# opcode : ldi "(" hl ")" "," b "[end]"
sub _action_opcode_669 {
	_add_opcode(@_, 0x70, 0x23);
}
# opcode : add hl "," bc "[end]"
sub _action_opcode_67 {
	_add_opcode(@_, 0x09);
}
# opcode : ldi "(" hl ")" "," bc "[end]"
sub _action_opcode_670 {
	_add_opcode(@_, 0x71, 0x23, 0x70, 0x23);
}
# opcode : ldi "(" hl ")" "," c "[end]"
sub _action_opcode_671 {
	_add_opcode(@_, 0x71, 0x23);
}
# opcode : ldi "(" hl ")" "," d "[end]"
sub _action_opcode_672 {
	_add_opcode(@_, 0x72, 0x23);
}
# opcode : ldi "(" hl ")" "," de "[end]"
sub _action_opcode_673 {
	_add_opcode(@_, 0x73, 0x23, 0x72, 0x23);
}
# opcode : ldi "(" hl ")" "," e "[end]"
sub _action_opcode_674 {
	_add_opcode(@_, 0x73, 0x23);
}
# opcode : ldi "(" hl ")" "," h "[end]"
sub _action_opcode_675 {
	_add_opcode(@_, 0x74, 0x23);
}
# opcode : ldi "(" hl ")" "," l "[end]"
sub _action_opcode_676 {
	_add_opcode(@_, 0x75, 0x23);
}
# opcode : ldi "(" ix ")" "," "[expr_N]" "[end]"
sub _action_opcode_677 {
	_add_opcode(@_, 0xDD, 0x36, 0x00, $_[ARGS][5], 0xDD, 0x23);
}
# opcode : ldi "(" ix ")" "," a "[end]"
sub _action_opcode_678 {
	_add_opcode(@_, 0xDD, 0x77, 0x00, 0xDD, 0x23);
}
# opcode : ldi "(" ix ")" "," b "[end]"
sub _action_opcode_679 {
	_add_opcode(@_, 0xDD, 0x70, 0x00, 0xDD, 0x23);
}
# opcode : add hl "," de "[end]"
sub _action_opcode_68 {
	_add_opcode(@_, 0x19);
}
# opcode : ldi "(" ix ")" "," bc "[end]"
sub _action_opcode_680 {
	_add_opcode(@_, 0xDD, 0x71, 0x00, 0xDD, 0x23, 0xDD, 0x70, 0x00, 0xDD, 0x23);
}
# opcode : ldi "(" ix ")" "," c "[end]"
sub _action_opcode_681 {
	_add_opcode(@_, 0xDD, 0x71, 0x00, 0xDD, 0x23);
}
# opcode : ldi "(" ix ")" "," d "[end]"
sub _action_opcode_682 {
	_add_opcode(@_, 0xDD, 0x72, 0x00, 0xDD, 0x23);
}
# opcode : ldi "(" ix ")" "," de "[end]"
sub _action_opcode_683 {
	_add_opcode(@_, 0xDD, 0x73, 0x00, 0xDD, 0x23, 0xDD, 0x72, 0x00, 0xDD, 0x23);
}
# opcode : ldi "(" ix ")" "," e "[end]"
sub _action_opcode_684 {
	_add_opcode(@_, 0xDD, 0x73, 0x00, 0xDD, 0x23);
}
# opcode : ldi "(" ix ")" "," h "[end]"
sub _action_opcode_685 {
	_add_opcode(@_, 0xDD, 0x74, 0x00, 0xDD, 0x23);
}
# opcode : ldi "(" ix ")" "," hl "[end]"
sub _action_opcode_686 {
	_add_opcode(@_, 0xDD, 0x75, 0x00, 0xDD, 0x23, 0xDD, 0x74, 0x00, 0xDD, 0x23);
}
# opcode : ldi "(" ix ")" "," l "[end]"
sub _action_opcode_687 {
	_add_opcode(@_, 0xDD, 0x75, 0x00, 0xDD, 0x23);
}
# opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," "[expr_N]" "[end]"
sub _action_opcode_688 {
	_add_opcode(@_, 0xDD, 0x36, $_[ARGS][4], $_[ARGS][7], 0xDD, 0x23);
}
# opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_689 {
	_add_opcode(@_, 0xDD, 0x77, $_[ARGS][4], 0xDD, 0x23);
}
# opcode : add hl "," hl "[end]"
sub _action_opcode_69 {
	_add_opcode(@_, 0x29);
}
# opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_690 {
	_add_opcode(@_, 0xDD, 0x70, $_[ARGS][4], 0xDD, 0x23);
}
# opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," bc "[end]"
sub _action_opcode_691 {
	_add_opcode(@_, 0xDD, 0x71, $_[ARGS][4], 0xDD, 0x23, 0xDD, 0x70, $_[ARGS][4], 0xDD, 0x23);
}
# opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_692 {
	_add_opcode(@_, 0xDD, 0x71, $_[ARGS][4], 0xDD, 0x23);
}
# opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_693 {
	_add_opcode(@_, 0xDD, 0x72, $_[ARGS][4], 0xDD, 0x23);
}
# opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," de "[end]"
sub _action_opcode_694 {
	_add_opcode(@_, 0xDD, 0x73, $_[ARGS][4], 0xDD, 0x23, 0xDD, 0x72, $_[ARGS][4], 0xDD, 0x23);
}
# opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_695 {
	_add_opcode(@_, 0xDD, 0x73, $_[ARGS][4], 0xDD, 0x23);
}
# opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_696 {
	_add_opcode(@_, 0xDD, 0x74, $_[ARGS][4], 0xDD, 0x23);
}
# opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," hl "[end]"
sub _action_opcode_697 {
	_add_opcode(@_, 0xDD, 0x75, $_[ARGS][4], 0xDD, 0x23, 0xDD, 0x74, $_[ARGS][4], 0xDD, 0x23);
}
# opcode : ldi "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_698 {
	_add_opcode(@_, 0xDD, 0x75, $_[ARGS][4], 0xDD, 0x23);
}
# opcode : ldi "(" iy ")" "," "[expr_N]" "[end]"
sub _action_opcode_699 {
	_add_opcode(@_, 0xFD, 0x36, 0x00, $_[ARGS][5], 0xFD, 0x23);
}
# opcode : add hl "," sp "[end]"
sub _action_opcode_70 {
	_add_opcode(@_, 0x39);
}
# opcode : ldi "(" iy ")" "," a "[end]"
sub _action_opcode_700 {
	_add_opcode(@_, 0xFD, 0x77, 0x00, 0xFD, 0x23);
}
# opcode : ldi "(" iy ")" "," b "[end]"
sub _action_opcode_701 {
	_add_opcode(@_, 0xFD, 0x70, 0x00, 0xFD, 0x23);
}
# opcode : ldi "(" iy ")" "," bc "[end]"
sub _action_opcode_702 {
	_add_opcode(@_, 0xFD, 0x71, 0x00, 0xFD, 0x23, 0xFD, 0x70, 0x00, 0xFD, 0x23);
}
# opcode : ldi "(" iy ")" "," c "[end]"
sub _action_opcode_703 {
	_add_opcode(@_, 0xFD, 0x71, 0x00, 0xFD, 0x23);
}
# opcode : ldi "(" iy ")" "," d "[end]"
sub _action_opcode_704 {
	_add_opcode(@_, 0xFD, 0x72, 0x00, 0xFD, 0x23);
}
# opcode : ldi "(" iy ")" "," de "[end]"
sub _action_opcode_705 {
	_add_opcode(@_, 0xFD, 0x73, 0x00, 0xFD, 0x23, 0xFD, 0x72, 0x00, 0xFD, 0x23);
}
# opcode : ldi "(" iy ")" "," e "[end]"
sub _action_opcode_706 {
	_add_opcode(@_, 0xFD, 0x73, 0x00, 0xFD, 0x23);
}
# opcode : ldi "(" iy ")" "," h "[end]"
sub _action_opcode_707 {
	_add_opcode(@_, 0xFD, 0x74, 0x00, 0xFD, 0x23);
}
# opcode : ldi "(" iy ")" "," hl "[end]"
sub _action_opcode_708 {
	_add_opcode(@_, 0xFD, 0x75, 0x00, 0xFD, 0x23, 0xFD, 0x74, 0x00, 0xFD, 0x23);
}
# opcode : ldi "(" iy ")" "," l "[end]"
sub _action_opcode_709 {
	_add_opcode(@_, 0xFD, 0x75, 0x00, 0xFD, 0x23);
}
# opcode : add ix "," bc "[end]"
sub _action_opcode_71 {
	_add_opcode(@_, 0xDD, 0x09);
}
# opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," "[expr_N]" "[end]"
sub _action_opcode_710 {
	_add_opcode(@_, 0xFD, 0x36, $_[ARGS][4], $_[ARGS][7], 0xFD, 0x23);
}
# opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_711 {
	_add_opcode(@_, 0xFD, 0x77, $_[ARGS][4], 0xFD, 0x23);
}
# opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_712 {
	_add_opcode(@_, 0xFD, 0x70, $_[ARGS][4], 0xFD, 0x23);
}
# opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," bc "[end]"
sub _action_opcode_713 {
	_add_opcode(@_, 0xFD, 0x71, $_[ARGS][4], 0xFD, 0x23, 0xFD, 0x70, $_[ARGS][4], 0xFD, 0x23);
}
# opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_714 {
	_add_opcode(@_, 0xFD, 0x71, $_[ARGS][4], 0xFD, 0x23);
}
# opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_715 {
	_add_opcode(@_, 0xFD, 0x72, $_[ARGS][4], 0xFD, 0x23);
}
# opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," de "[end]"
sub _action_opcode_716 {
	_add_opcode(@_, 0xFD, 0x73, $_[ARGS][4], 0xFD, 0x23, 0xFD, 0x72, $_[ARGS][4], 0xFD, 0x23);
}
# opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_717 {
	_add_opcode(@_, 0xFD, 0x73, $_[ARGS][4], 0xFD, 0x23);
}
# opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_718 {
	_add_opcode(@_, 0xFD, 0x74, $_[ARGS][4], 0xFD, 0x23);
}
# opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," hl "[end]"
sub _action_opcode_719 {
	_add_opcode(@_, 0xFD, 0x75, $_[ARGS][4], 0xFD, 0x23, 0xFD, 0x74, $_[ARGS][4], 0xFD, 0x23);
}
# opcode : add ix "," de "[end]"
sub _action_opcode_72 {
	_add_opcode(@_, 0xDD, 0x19);
}
# opcode : ldi "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_720 {
	_add_opcode(@_, 0xFD, 0x75, $_[ARGS][4], 0xFD, 0x23);
}
# opcode : ldi a "," "(" bc ")" "[end]"
sub _action_opcode_721 {
	_add_opcode(@_, 0x0A, 0x03);
}
# opcode : ldi a "," "(" de ")" "[end]"
sub _action_opcode_722 {
	_add_opcode(@_, 0x1A, 0x13);
}
# opcode : ldi a "," "(" hl ")" "[end]"
sub _action_opcode_723 {
	_add_opcode(@_, 0x7E, 0x23);
}
# opcode : ldi a "," "(" ix ")" "[end]"
sub _action_opcode_724 {
	_add_opcode(@_, 0xDD, 0x7E, 0x00, 0xDD, 0x23);
}
# opcode : ldi a "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_725 {
	_add_opcode(@_, 0xDD, 0x7E, $_[ARGS][6], 0xDD, 0x23);
}
# opcode : ldi a "," "(" iy ")" "[end]"
sub _action_opcode_726 {
	_add_opcode(@_, 0xFD, 0x7E, 0x00, 0xFD, 0x23);
}
# opcode : ldi a "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_727 {
	_add_opcode(@_, 0xFD, 0x7E, $_[ARGS][6], 0xFD, 0x23);
}
# opcode : ldi b "," "(" hl ")" "[end]"
sub _action_opcode_728 {
	_add_opcode(@_, 0x46, 0x23);
}
# opcode : ldi b "," "(" ix ")" "[end]"
sub _action_opcode_729 {
	_add_opcode(@_, 0xDD, 0x46, 0x00, 0xDD, 0x23);
}
# opcode : add ix "," ix "[end]"
sub _action_opcode_73 {
	_add_opcode(@_, 0xDD, 0x29);
}
# opcode : ldi b "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_730 {
	_add_opcode(@_, 0xDD, 0x46, $_[ARGS][6], 0xDD, 0x23);
}
# opcode : ldi b "," "(" iy ")" "[end]"
sub _action_opcode_731 {
	_add_opcode(@_, 0xFD, 0x46, 0x00, 0xFD, 0x23);
}
# opcode : ldi b "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_732 {
	_add_opcode(@_, 0xFD, 0x46, $_[ARGS][6], 0xFD, 0x23);
}
# opcode : ldi bc "," "(" hl ")" "[end]"
sub _action_opcode_733 {
	_add_opcode(@_, 0x4E, 0x23, 0x46, 0x23);
}
# opcode : ldi bc "," "(" ix ")" "[end]"
sub _action_opcode_734 {
	_add_opcode(@_, 0xDD, 0x4E, 0x00, 0xDD, 0x23, 0xDD, 0x46, 0x00, 0xDD, 0x23);
}
# opcode : ldi bc "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_735 {
	_add_opcode(@_, 0xDD, 0x4E, $_[ARGS][6], 0xDD, 0x23, 0xDD, 0x46, $_[ARGS][6], 0xDD, 0x23);
}
# opcode : ldi bc "," "(" iy ")" "[end]"
sub _action_opcode_736 {
	_add_opcode(@_, 0xFD, 0x4E, 0x00, 0xFD, 0x23, 0xFD, 0x46, 0x00, 0xFD, 0x23);
}
# opcode : ldi bc "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_737 {
	_add_opcode(@_, 0xFD, 0x4E, $_[ARGS][6], 0xFD, 0x23, 0xFD, 0x46, $_[ARGS][6], 0xFD, 0x23);
}
# opcode : ldi c "," "(" hl ")" "[end]"
sub _action_opcode_738 {
	_add_opcode(@_, 0x4E, 0x23);
}
# opcode : ldi c "," "(" ix ")" "[end]"
sub _action_opcode_739 {
	_add_opcode(@_, 0xDD, 0x4E, 0x00, 0xDD, 0x23);
}
# opcode : add ix "," sp "[end]"
sub _action_opcode_74 {
	_add_opcode(@_, 0xDD, 0x39);
}
# opcode : ldi c "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_740 {
	_add_opcode(@_, 0xDD, 0x4E, $_[ARGS][6], 0xDD, 0x23);
}
# opcode : ldi c "," "(" iy ")" "[end]"
sub _action_opcode_741 {
	_add_opcode(@_, 0xFD, 0x4E, 0x00, 0xFD, 0x23);
}
# opcode : ldi c "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_742 {
	_add_opcode(@_, 0xFD, 0x4E, $_[ARGS][6], 0xFD, 0x23);
}
# opcode : ldi d "," "(" hl ")" "[end]"
sub _action_opcode_743 {
	_add_opcode(@_, 0x56, 0x23);
}
# opcode : ldi d "," "(" ix ")" "[end]"
sub _action_opcode_744 {
	_add_opcode(@_, 0xDD, 0x56, 0x00, 0xDD, 0x23);
}
# opcode : ldi d "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_745 {
	_add_opcode(@_, 0xDD, 0x56, $_[ARGS][6], 0xDD, 0x23);
}
# opcode : ldi d "," "(" iy ")" "[end]"
sub _action_opcode_746 {
	_add_opcode(@_, 0xFD, 0x56, 0x00, 0xFD, 0x23);
}
# opcode : ldi d "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_747 {
	_add_opcode(@_, 0xFD, 0x56, $_[ARGS][6], 0xFD, 0x23);
}
# opcode : ldi de "," "(" hl ")" "[end]"
sub _action_opcode_748 {
	_add_opcode(@_, 0x5E, 0x23, 0x56, 0x23);
}
# opcode : ldi de "," "(" ix ")" "[end]"
sub _action_opcode_749 {
	_add_opcode(@_, 0xDD, 0x5E, 0x00, 0xDD, 0x23, 0xDD, 0x56, 0x00, 0xDD, 0x23);
}
# opcode : add iy "," bc "[end]"
sub _action_opcode_75 {
	_add_opcode(@_, 0xFD, 0x09);
}
# opcode : ldi de "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_750 {
	_add_opcode(@_, 0xDD, 0x5E, $_[ARGS][6], 0xDD, 0x23, 0xDD, 0x56, $_[ARGS][6], 0xDD, 0x23);
}
# opcode : ldi de "," "(" iy ")" "[end]"
sub _action_opcode_751 {
	_add_opcode(@_, 0xFD, 0x5E, 0x00, 0xFD, 0x23, 0xFD, 0x56, 0x00, 0xFD, 0x23);
}
# opcode : ldi de "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_752 {
	_add_opcode(@_, 0xFD, 0x5E, $_[ARGS][6], 0xFD, 0x23, 0xFD, 0x56, $_[ARGS][6], 0xFD, 0x23);
}
# opcode : ldi e "," "(" hl ")" "[end]"
sub _action_opcode_753 {
	_add_opcode(@_, 0x5E, 0x23);
}
# opcode : ldi e "," "(" ix ")" "[end]"
sub _action_opcode_754 {
	_add_opcode(@_, 0xDD, 0x5E, 0x00, 0xDD, 0x23);
}
# opcode : ldi e "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_755 {
	_add_opcode(@_, 0xDD, 0x5E, $_[ARGS][6], 0xDD, 0x23);
}
# opcode : ldi e "," "(" iy ")" "[end]"
sub _action_opcode_756 {
	_add_opcode(@_, 0xFD, 0x5E, 0x00, 0xFD, 0x23);
}
# opcode : ldi e "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_757 {
	_add_opcode(@_, 0xFD, 0x5E, $_[ARGS][6], 0xFD, 0x23);
}
# opcode : ldi h "," "(" hl ")" "[end]"
sub _action_opcode_758 {
	_add_opcode(@_, 0x66, 0x23);
}
# opcode : ldi h "," "(" ix ")" "[end]"
sub _action_opcode_759 {
	_add_opcode(@_, 0xDD, 0x66, 0x00, 0xDD, 0x23);
}
# opcode : add iy "," de "[end]"
sub _action_opcode_76 {
	_add_opcode(@_, 0xFD, 0x19);
}
# opcode : ldi h "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_760 {
	_add_opcode(@_, 0xDD, 0x66, $_[ARGS][6], 0xDD, 0x23);
}
# opcode : ldi h "," "(" iy ")" "[end]"
sub _action_opcode_761 {
	_add_opcode(@_, 0xFD, 0x66, 0x00, 0xFD, 0x23);
}
# opcode : ldi h "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_762 {
	_add_opcode(@_, 0xFD, 0x66, $_[ARGS][6], 0xFD, 0x23);
}
# opcode : ldi hl "," "(" ix ")" "[end]"
sub _action_opcode_763 {
	_add_opcode(@_, 0xDD, 0x6E, 0x00, 0xDD, 0x23, 0xDD, 0x66, 0x00, 0xDD, 0x23);
}
# opcode : ldi hl "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_764 {
	_add_opcode(@_, 0xDD, 0x6E, $_[ARGS][6], 0xDD, 0x23, 0xDD, 0x66, $_[ARGS][6], 0xDD, 0x23);
}
# opcode : ldi hl "," "(" iy ")" "[end]"
sub _action_opcode_765 {
	_add_opcode(@_, 0xFD, 0x6E, 0x00, 0xFD, 0x23, 0xFD, 0x66, 0x00, 0xFD, 0x23);
}
# opcode : ldi hl "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_766 {
	_add_opcode(@_, 0xFD, 0x6E, $_[ARGS][6], 0xFD, 0x23, 0xFD, 0x66, $_[ARGS][6], 0xFD, 0x23);
}
# opcode : ldi l "," "(" hl ")" "[end]"
sub _action_opcode_767 {
	_add_opcode(@_, 0x6E, 0x23);
}
# opcode : ldi l "," "(" ix ")" "[end]"
sub _action_opcode_768 {
	_add_opcode(@_, 0xDD, 0x6E, 0x00, 0xDD, 0x23);
}
# opcode : ldi l "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_769 {
	_add_opcode(@_, 0xDD, 0x6E, $_[ARGS][6], 0xDD, 0x23);
}
# opcode : add iy "," iy "[end]"
sub _action_opcode_77 {
	_add_opcode(@_, 0xFD, 0x29);
}
# opcode : ldi l "," "(" iy ")" "[end]"
sub _action_opcode_770 {
	_add_opcode(@_, 0xFD, 0x6E, 0x00, 0xFD, 0x23);
}
# opcode : ldi l "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_771 {
	_add_opcode(@_, 0xFD, 0x6E, $_[ARGS][6], 0xFD, 0x23);
}
# opcode : ldir "[end]"
sub _action_opcode_772 {
	_add_opcode(@_, 0xED, 0xB0);
}
# opcode : neg "[end]"
sub _action_opcode_773 {
	_add_opcode(@_, 0xED, 0x44);
}
# opcode : nop "[end]"
sub _action_opcode_774 {
	_add_opcode(@_, 0x00);
}
# opcode : or "(" hl ")" "[end]"
sub _action_opcode_775 {
	_add_opcode(@_, 0xB6);
}
# opcode : or "(" ix ")" "[end]"
sub _action_opcode_776 {
	_add_opcode(@_, 0xDD, 0xB6, 0x00);
}
# opcode : or "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_777 {
	_add_opcode(@_, 0xDD, 0xB6, $_[ARGS][4]);
}
# opcode : or "(" iy ")" "[end]"
sub _action_opcode_778 {
	_add_opcode(@_, 0xFD, 0xB6, 0x00);
}
# opcode : or "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_779 {
	_add_opcode(@_, 0xFD, 0xB6, $_[ARGS][4]);
}
# opcode : add iy "," sp "[end]"
sub _action_opcode_78 {
	_add_opcode(@_, 0xFD, 0x39);
}
# opcode : or "[expr_N]" "[end]"
sub _action_opcode_780 {
	_add_opcode(@_, 0xF6, $_[ARGS][1]);
}
# opcode : or a "[end]"
sub _action_opcode_781 {
	_add_opcode(@_, 0xB7);
}
# opcode : or b "[end]"
sub _action_opcode_782 {
	_add_opcode(@_, 0xB0);
}
# opcode : or c "[end]"
sub _action_opcode_783 {
	_add_opcode(@_, 0xB1);
}
# opcode : or d "[end]"
sub _action_opcode_784 {
	_add_opcode(@_, 0xB2);
}
# opcode : or e "[end]"
sub _action_opcode_785 {
	_add_opcode(@_, 0xB3);
}
# opcode : or h "[end]"
sub _action_opcode_786 {
	_add_opcode(@_, 0xB4);
}
# opcode : or ixh "[end]"
sub _action_opcode_787 {
	_add_opcode(@_, 0xDD, 0xB4);
}
# opcode : or ixl "[end]"
sub _action_opcode_788 {
	_add_opcode(@_, 0xDD, 0xB5);
}
# opcode : or iyh "[end]"
sub _action_opcode_789 {
	_add_opcode(@_, 0xFD, 0xB4);
}
# opcode : and "(" hl ")" "[end]"
sub _action_opcode_79 {
	_add_opcode(@_, 0xA6);
}
# opcode : or iyl "[end]"
sub _action_opcode_790 {
	_add_opcode(@_, 0xFD, 0xB5);
}
# opcode : or l "[end]"
sub _action_opcode_791 {
	_add_opcode(@_, 0xB5);
}
# opcode : otdr "[end]"
sub _action_opcode_792 {
	_add_opcode(@_, 0xED, 0xBB);
}
# opcode : otir "[end]"
sub _action_opcode_793 {
	_add_opcode(@_, 0xED, 0xB3);
}
# opcode : out "(" "[expr_N]" ")" "," a "[end]"
sub _action_opcode_794 {
	_add_opcode(@_, 0xD3, $_[ARGS][2]);
}
# opcode : out "(" c ")" "," "[inline_const]" 0 "[end]"
sub _action_opcode_795 {
	_add_opcode(@_, 0xED, 0x71);
}
# opcode : out "(" c ")" "," a "[end]"
sub _action_opcode_796 {
	_add_opcode(@_, 0xED, 0x79);
}
# opcode : out "(" c ")" "," b "[end]"
sub _action_opcode_797 {
	_add_opcode(@_, 0xED, 0x41);
}
# opcode : out "(" c ")" "," c "[end]"
sub _action_opcode_798 {
	_add_opcode(@_, 0xED, 0x49);
}
# opcode : out "(" c ")" "," d "[end]"
sub _action_opcode_799 {
	_add_opcode(@_, 0xED, 0x51);
}
# opcode : and "(" ix ")" "[end]"
sub _action_opcode_80 {
	_add_opcode(@_, 0xDD, 0xA6, 0x00);
}
# opcode : out "(" c ")" "," e "[end]"
sub _action_opcode_800 {
	_add_opcode(@_, 0xED, 0x59);
}
# opcode : out "(" c ")" "," h "[end]"
sub _action_opcode_801 {
	_add_opcode(@_, 0xED, 0x61);
}
# opcode : out "(" c ")" "," l "[end]"
sub _action_opcode_802 {
	_add_opcode(@_, 0xED, 0x69);
}
# opcode : outd "[end]"
sub _action_opcode_803 {
	_add_opcode(@_, 0xED, 0xAB);
}
# opcode : outi "[end]"
sub _action_opcode_804 {
	_add_opcode(@_, 0xED, 0xA3);
}
# opcode : pop af "[end]"
sub _action_opcode_805 {
	_add_opcode(@_, 0xF1);
}
# opcode : pop bc "[end]"
sub _action_opcode_806 {
	_add_opcode(@_, 0xC1);
}
# opcode : pop de "[end]"
sub _action_opcode_807 {
	_add_opcode(@_, 0xD1);
}
# opcode : pop hl "[end]"
sub _action_opcode_808 {
	_add_opcode(@_, 0xE1);
}
# opcode : pop ix "[end]"
sub _action_opcode_809 {
	_add_opcode(@_, 0xDD, 0xE1);
}
# opcode : and "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_81 {
	_add_opcode(@_, 0xDD, 0xA6, $_[ARGS][4]);
}
# opcode : pop iy "[end]"
sub _action_opcode_810 {
	_add_opcode(@_, 0xFD, 0xE1);
}
# opcode : push af "[end]"
sub _action_opcode_811 {
	_add_opcode(@_, 0xF5);
}
# opcode : push bc "[end]"
sub _action_opcode_812 {
	_add_opcode(@_, 0xC5);
}
# opcode : push de "[end]"
sub _action_opcode_813 {
	_add_opcode(@_, 0xD5);
}
# opcode : push hl "[end]"
sub _action_opcode_814 {
	_add_opcode(@_, 0xE5);
}
# opcode : push ix "[end]"
sub _action_opcode_815 {
	_add_opcode(@_, 0xDD, 0xE5);
}
# opcode : push iy "[end]"
sub _action_opcode_816 {
	_add_opcode(@_, 0xFD, 0xE5);
}
# opcode : res "[inline_const]" 0 "," "(" hl ")" "[end]"
sub _action_opcode_817 {
	_add_opcode(@_, 0xCB, 0x86);
}
# opcode : res "[inline_const]" 0 "," "(" ix ")" "[end]"
sub _action_opcode_818 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x86);
}
# opcode : res "[inline_const]" 0 "," "(" ix ")" "," a "[end]"
sub _action_opcode_819 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x87);
}
# opcode : and "(" iy ")" "[end]"
sub _action_opcode_82 {
	_add_opcode(@_, 0xFD, 0xA6, 0x00);
}
# opcode : res "[inline_const]" 0 "," "(" ix ")" "," b "[end]"
sub _action_opcode_820 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x80);
}
# opcode : res "[inline_const]" 0 "," "(" ix ")" "," c "[end]"
sub _action_opcode_821 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x81);
}
# opcode : res "[inline_const]" 0 "," "(" ix ")" "," d "[end]"
sub _action_opcode_822 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x82);
}
# opcode : res "[inline_const]" 0 "," "(" ix ")" "," e "[end]"
sub _action_opcode_823 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x83);
}
# opcode : res "[inline_const]" 0 "," "(" ix ")" "," h "[end]"
sub _action_opcode_824 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x84);
}
# opcode : res "[inline_const]" 0 "," "(" ix ")" "," l "[end]"
sub _action_opcode_825 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x85);
}
# opcode : res "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_826 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x86);
}
# opcode : res "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_827 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x87);
}
# opcode : res "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_828 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x80);
}
# opcode : res "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_829 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x81);
}
# opcode : and "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_83 {
	_add_opcode(@_, 0xFD, 0xA6, $_[ARGS][4]);
}
# opcode : res "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_830 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x82);
}
# opcode : res "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_831 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x83);
}
# opcode : res "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_832 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x84);
}
# opcode : res "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_833 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x85);
}
# opcode : res "[inline_const]" 0 "," "(" iy ")" "[end]"
sub _action_opcode_834 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x86);
}
# opcode : res "[inline_const]" 0 "," "(" iy ")" "," a "[end]"
sub _action_opcode_835 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x87);
}
# opcode : res "[inline_const]" 0 "," "(" iy ")" "," b "[end]"
sub _action_opcode_836 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x80);
}
# opcode : res "[inline_const]" 0 "," "(" iy ")" "," c "[end]"
sub _action_opcode_837 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x81);
}
# opcode : res "[inline_const]" 0 "," "(" iy ")" "," d "[end]"
sub _action_opcode_838 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x82);
}
# opcode : res "[inline_const]" 0 "," "(" iy ")" "," e "[end]"
sub _action_opcode_839 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x83);
}
# opcode : and "[expr_N]" "[end]"
sub _action_opcode_84 {
	_add_opcode(@_, 0xE6, $_[ARGS][1]);
}
# opcode : res "[inline_const]" 0 "," "(" iy ")" "," h "[end]"
sub _action_opcode_840 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x84);
}
# opcode : res "[inline_const]" 0 "," "(" iy ")" "," l "[end]"
sub _action_opcode_841 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x85);
}
# opcode : res "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_842 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x86);
}
# opcode : res "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_843 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x87);
}
# opcode : res "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_844 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x80);
}
# opcode : res "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_845 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x81);
}
# opcode : res "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_846 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x82);
}
# opcode : res "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_847 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x83);
}
# opcode : res "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_848 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x84);
}
# opcode : res "[inline_const]" 0 "," "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_849 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x85);
}
# opcode : and a "[end]"
sub _action_opcode_85 {
	_add_opcode(@_, 0xA7);
}
# opcode : res "[inline_const]" 0 "," a "[end]"
sub _action_opcode_850 {
	_add_opcode(@_, 0xCB, 0x87);
}
# opcode : res "[inline_const]" 0 "," b "[end]"
sub _action_opcode_851 {
	_add_opcode(@_, 0xCB, 0x80);
}
# opcode : res "[inline_const]" 0 "," c "[end]"
sub _action_opcode_852 {
	_add_opcode(@_, 0xCB, 0x81);
}
# opcode : res "[inline_const]" 0 "," d "[end]"
sub _action_opcode_853 {
	_add_opcode(@_, 0xCB, 0x82);
}
# opcode : res "[inline_const]" 0 "," e "[end]"
sub _action_opcode_854 {
	_add_opcode(@_, 0xCB, 0x83);
}
# opcode : res "[inline_const]" 0 "," h "[end]"
sub _action_opcode_855 {
	_add_opcode(@_, 0xCB, 0x84);
}
# opcode : res "[inline_const]" 0 "," l "[end]"
sub _action_opcode_856 {
	_add_opcode(@_, 0xCB, 0x85);
}
# opcode : res "[inline_const]" 1 "," "(" hl ")" "[end]"
sub _action_opcode_857 {
	_add_opcode(@_, 0xCB, 0x8E);
}
# opcode : res "[inline_const]" 1 "," "(" ix ")" "[end]"
sub _action_opcode_858 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x8E);
}
# opcode : res "[inline_const]" 1 "," "(" ix ")" "," a "[end]"
sub _action_opcode_859 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x8F);
}
# opcode : and b "[end]"
sub _action_opcode_86 {
	_add_opcode(@_, 0xA0);
}
# opcode : res "[inline_const]" 1 "," "(" ix ")" "," b "[end]"
sub _action_opcode_860 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x88);
}
# opcode : res "[inline_const]" 1 "," "(" ix ")" "," c "[end]"
sub _action_opcode_861 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x89);
}
# opcode : res "[inline_const]" 1 "," "(" ix ")" "," d "[end]"
sub _action_opcode_862 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x8A);
}
# opcode : res "[inline_const]" 1 "," "(" ix ")" "," e "[end]"
sub _action_opcode_863 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x8B);
}
# opcode : res "[inline_const]" 1 "," "(" ix ")" "," h "[end]"
sub _action_opcode_864 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x8C);
}
# opcode : res "[inline_const]" 1 "," "(" ix ")" "," l "[end]"
sub _action_opcode_865 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x8D);
}
# opcode : res "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_866 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x8E);
}
# opcode : res "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_867 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x8F);
}
# opcode : res "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_868 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x88);
}
# opcode : res "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_869 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x89);
}
# opcode : and c "[end]"
sub _action_opcode_87 {
	_add_opcode(@_, 0xA1);
}
# opcode : res "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_870 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x8A);
}
# opcode : res "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_871 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x8B);
}
# opcode : res "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_872 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x8C);
}
# opcode : res "[inline_const]" 1 "," "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_873 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x8D);
}
# opcode : res "[inline_const]" 1 "," "(" iy ")" "[end]"
sub _action_opcode_874 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x8E);
}
# opcode : res "[inline_const]" 1 "," "(" iy ")" "," a "[end]"
sub _action_opcode_875 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x8F);
}
# opcode : res "[inline_const]" 1 "," "(" iy ")" "," b "[end]"
sub _action_opcode_876 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x88);
}
# opcode : res "[inline_const]" 1 "," "(" iy ")" "," c "[end]"
sub _action_opcode_877 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x89);
}
# opcode : res "[inline_const]" 1 "," "(" iy ")" "," d "[end]"
sub _action_opcode_878 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x8A);
}
# opcode : res "[inline_const]" 1 "," "(" iy ")" "," e "[end]"
sub _action_opcode_879 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x8B);
}
# opcode : and d "[end]"
sub _action_opcode_88 {
	_add_opcode(@_, 0xA2);
}
# opcode : res "[inline_const]" 1 "," "(" iy ")" "," h "[end]"
sub _action_opcode_880 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x8C);
}
# opcode : res "[inline_const]" 1 "," "(" iy ")" "," l "[end]"
sub _action_opcode_881 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x8D);
}
# opcode : res "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_882 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x8E);
}
# opcode : res "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_883 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x8F);
}
# opcode : res "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_884 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x88);
}
# opcode : res "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_885 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x89);
}
# opcode : res "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_886 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x8A);
}
# opcode : res "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_887 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x8B);
}
# opcode : res "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_888 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x8C);
}
# opcode : res "[inline_const]" 1 "," "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_889 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x8D);
}
# opcode : and e "[end]"
sub _action_opcode_89 {
	_add_opcode(@_, 0xA3);
}
# opcode : res "[inline_const]" 1 "," a "[end]"
sub _action_opcode_890 {
	_add_opcode(@_, 0xCB, 0x8F);
}
# opcode : res "[inline_const]" 1 "," b "[end]"
sub _action_opcode_891 {
	_add_opcode(@_, 0xCB, 0x88);
}
# opcode : res "[inline_const]" 1 "," c "[end]"
sub _action_opcode_892 {
	_add_opcode(@_, 0xCB, 0x89);
}
# opcode : res "[inline_const]" 1 "," d "[end]"
sub _action_opcode_893 {
	_add_opcode(@_, 0xCB, 0x8A);
}
# opcode : res "[inline_const]" 1 "," e "[end]"
sub _action_opcode_894 {
	_add_opcode(@_, 0xCB, 0x8B);
}
# opcode : res "[inline_const]" 1 "," h "[end]"
sub _action_opcode_895 {
	_add_opcode(@_, 0xCB, 0x8C);
}
# opcode : res "[inline_const]" 1 "," l "[end]"
sub _action_opcode_896 {
	_add_opcode(@_, 0xCB, 0x8D);
}
# opcode : res "[inline_const]" 2 "," "(" hl ")" "[end]"
sub _action_opcode_897 {
	_add_opcode(@_, 0xCB, 0x96);
}
# opcode : res "[inline_const]" 2 "," "(" ix ")" "[end]"
sub _action_opcode_898 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x96);
}
# opcode : res "[inline_const]" 2 "," "(" ix ")" "," a "[end]"
sub _action_opcode_899 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x97);
}
# opcode : and h "[end]"
sub _action_opcode_90 {
	_add_opcode(@_, 0xA4);
}
# opcode : res "[inline_const]" 2 "," "(" ix ")" "," b "[end]"
sub _action_opcode_900 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x90);
}
# opcode : res "[inline_const]" 2 "," "(" ix ")" "," c "[end]"
sub _action_opcode_901 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x91);
}
# opcode : res "[inline_const]" 2 "," "(" ix ")" "," d "[end]"
sub _action_opcode_902 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x92);
}
# opcode : res "[inline_const]" 2 "," "(" ix ")" "," e "[end]"
sub _action_opcode_903 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x93);
}
# opcode : res "[inline_const]" 2 "," "(" ix ")" "," h "[end]"
sub _action_opcode_904 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x94);
}
# opcode : res "[inline_const]" 2 "," "(" ix ")" "," l "[end]"
sub _action_opcode_905 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x95);
}
# opcode : res "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_906 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x96);
}
# opcode : res "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_907 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x97);
}
# opcode : res "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_908 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x90);
}
# opcode : res "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_909 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x91);
}
# opcode : and ixh "[end]"
sub _action_opcode_91 {
	_add_opcode(@_, 0xDD, 0xA4);
}
# opcode : res "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_910 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x92);
}
# opcode : res "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_911 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x93);
}
# opcode : res "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_912 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x94);
}
# opcode : res "[inline_const]" 2 "," "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_913 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x95);
}
# opcode : res "[inline_const]" 2 "," "(" iy ")" "[end]"
sub _action_opcode_914 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x96);
}
# opcode : res "[inline_const]" 2 "," "(" iy ")" "," a "[end]"
sub _action_opcode_915 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x97);
}
# opcode : res "[inline_const]" 2 "," "(" iy ")" "," b "[end]"
sub _action_opcode_916 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x90);
}
# opcode : res "[inline_const]" 2 "," "(" iy ")" "," c "[end]"
sub _action_opcode_917 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x91);
}
# opcode : res "[inline_const]" 2 "," "(" iy ")" "," d "[end]"
sub _action_opcode_918 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x92);
}
# opcode : res "[inline_const]" 2 "," "(" iy ")" "," e "[end]"
sub _action_opcode_919 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x93);
}
# opcode : and ixl "[end]"
sub _action_opcode_92 {
	_add_opcode(@_, 0xDD, 0xA5);
}
# opcode : res "[inline_const]" 2 "," "(" iy ")" "," h "[end]"
sub _action_opcode_920 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x94);
}
# opcode : res "[inline_const]" 2 "," "(" iy ")" "," l "[end]"
sub _action_opcode_921 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x95);
}
# opcode : res "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_922 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x96);
}
# opcode : res "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_923 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x97);
}
# opcode : res "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_924 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x90);
}
# opcode : res "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_925 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x91);
}
# opcode : res "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_926 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x92);
}
# opcode : res "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_927 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x93);
}
# opcode : res "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_928 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x94);
}
# opcode : res "[inline_const]" 2 "," "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_929 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x95);
}
# opcode : and iyh "[end]"
sub _action_opcode_93 {
	_add_opcode(@_, 0xFD, 0xA4);
}
# opcode : res "[inline_const]" 2 "," a "[end]"
sub _action_opcode_930 {
	_add_opcode(@_, 0xCB, 0x97);
}
# opcode : res "[inline_const]" 2 "," b "[end]"
sub _action_opcode_931 {
	_add_opcode(@_, 0xCB, 0x90);
}
# opcode : res "[inline_const]" 2 "," c "[end]"
sub _action_opcode_932 {
	_add_opcode(@_, 0xCB, 0x91);
}
# opcode : res "[inline_const]" 2 "," d "[end]"
sub _action_opcode_933 {
	_add_opcode(@_, 0xCB, 0x92);
}
# opcode : res "[inline_const]" 2 "," e "[end]"
sub _action_opcode_934 {
	_add_opcode(@_, 0xCB, 0x93);
}
# opcode : res "[inline_const]" 2 "," h "[end]"
sub _action_opcode_935 {
	_add_opcode(@_, 0xCB, 0x94);
}
# opcode : res "[inline_const]" 2 "," l "[end]"
sub _action_opcode_936 {
	_add_opcode(@_, 0xCB, 0x95);
}
# opcode : res "[inline_const]" 3 "," "(" hl ")" "[end]"
sub _action_opcode_937 {
	_add_opcode(@_, 0xCB, 0x9E);
}
# opcode : res "[inline_const]" 3 "," "(" ix ")" "[end]"
sub _action_opcode_938 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x9E);
}
# opcode : res "[inline_const]" 3 "," "(" ix ")" "," a "[end]"
sub _action_opcode_939 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x9F);
}
# opcode : and iyl "[end]"
sub _action_opcode_94 {
	_add_opcode(@_, 0xFD, 0xA5);
}
# opcode : res "[inline_const]" 3 "," "(" ix ")" "," b "[end]"
sub _action_opcode_940 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x98);
}
# opcode : res "[inline_const]" 3 "," "(" ix ")" "," c "[end]"
sub _action_opcode_941 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x99);
}
# opcode : res "[inline_const]" 3 "," "(" ix ")" "," d "[end]"
sub _action_opcode_942 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x9A);
}
# opcode : res "[inline_const]" 3 "," "(" ix ")" "," e "[end]"
sub _action_opcode_943 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x9B);
}
# opcode : res "[inline_const]" 3 "," "(" ix ")" "," h "[end]"
sub _action_opcode_944 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x9C);
}
# opcode : res "[inline_const]" 3 "," "(" ix ")" "," l "[end]"
sub _action_opcode_945 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x9D);
}
# opcode : res "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_946 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x9E);
}
# opcode : res "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_947 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x9F);
}
# opcode : res "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_948 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x98);
}
# opcode : res "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_949 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x99);
}
# opcode : and l "[end]"
sub _action_opcode_95 {
	_add_opcode(@_, 0xA5);
}
# opcode : res "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_950 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x9A);
}
# opcode : res "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_951 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x9B);
}
# opcode : res "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_952 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x9C);
}
# opcode : res "[inline_const]" 3 "," "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_953 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x9D);
}
# opcode : res "[inline_const]" 3 "," "(" iy ")" "[end]"
sub _action_opcode_954 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x9E);
}
# opcode : res "[inline_const]" 3 "," "(" iy ")" "," a "[end]"
sub _action_opcode_955 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x9F);
}
# opcode : res "[inline_const]" 3 "," "(" iy ")" "," b "[end]"
sub _action_opcode_956 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x98);
}
# opcode : res "[inline_const]" 3 "," "(" iy ")" "," c "[end]"
sub _action_opcode_957 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x99);
}
# opcode : res "[inline_const]" 3 "," "(" iy ")" "," d "[end]"
sub _action_opcode_958 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x9A);
}
# opcode : res "[inline_const]" 3 "," "(" iy ")" "," e "[end]"
sub _action_opcode_959 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x9B);
}
# opcode : bit "[inline_const]" 0 "," "(" hl ")" "[end]"
sub _action_opcode_96 {
	_add_opcode(@_, 0xCB, 0x46);
}
# opcode : res "[inline_const]" 3 "," "(" iy ")" "," h "[end]"
sub _action_opcode_960 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x9C);
}
# opcode : res "[inline_const]" 3 "," "(" iy ")" "," l "[end]"
sub _action_opcode_961 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x9D);
}
# opcode : res "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_962 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x9E);
}
# opcode : res "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_963 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x9F);
}
# opcode : res "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_964 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x98);
}
# opcode : res "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_965 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x99);
}
# opcode : res "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_966 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x9A);
}
# opcode : res "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_967 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x9B);
}
# opcode : res "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_968 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x9C);
}
# opcode : res "[inline_const]" 3 "," "(" iy "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_969 {
	_add_opcode(@_, 0xFD, 0xCB, $_[ARGS][7], 0x9D);
}
# opcode : bit "[inline_const]" 0 "," "(" ix ")" "[end]"
sub _action_opcode_97 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0x46);
}
# opcode : res "[inline_const]" 3 "," a "[end]"
sub _action_opcode_970 {
	_add_opcode(@_, 0xCB, 0x9F);
}
# opcode : res "[inline_const]" 3 "," b "[end]"
sub _action_opcode_971 {
	_add_opcode(@_, 0xCB, 0x98);
}
# opcode : res "[inline_const]" 3 "," c "[end]"
sub _action_opcode_972 {
	_add_opcode(@_, 0xCB, 0x99);
}
# opcode : res "[inline_const]" 3 "," d "[end]"
sub _action_opcode_973 {
	_add_opcode(@_, 0xCB, 0x9A);
}
# opcode : res "[inline_const]" 3 "," e "[end]"
sub _action_opcode_974 {
	_add_opcode(@_, 0xCB, 0x9B);
}
# opcode : res "[inline_const]" 3 "," h "[end]"
sub _action_opcode_975 {
	_add_opcode(@_, 0xCB, 0x9C);
}
# opcode : res "[inline_const]" 3 "," l "[end]"
sub _action_opcode_976 {
	_add_opcode(@_, 0xCB, 0x9D);
}
# opcode : res "[inline_const]" 4 "," "(" hl ")" "[end]"
sub _action_opcode_977 {
	_add_opcode(@_, 0xCB, 0xA6);
}
# opcode : res "[inline_const]" 4 "," "(" ix ")" "[end]"
sub _action_opcode_978 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xA6);
}
# opcode : res "[inline_const]" 4 "," "(" ix ")" "," a "[end]"
sub _action_opcode_979 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xA7);
}
# opcode : bit "[inline_const]" 0 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_98 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0x46);
}
# opcode : res "[inline_const]" 4 "," "(" ix ")" "," b "[end]"
sub _action_opcode_980 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xA0);
}
# opcode : res "[inline_const]" 4 "," "(" ix ")" "," c "[end]"
sub _action_opcode_981 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xA1);
}
# opcode : res "[inline_const]" 4 "," "(" ix ")" "," d "[end]"
sub _action_opcode_982 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xA2);
}
# opcode : res "[inline_const]" 4 "," "(" ix ")" "," e "[end]"
sub _action_opcode_983 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xA3);
}
# opcode : res "[inline_const]" 4 "," "(" ix ")" "," h "[end]"
sub _action_opcode_984 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xA4);
}
# opcode : res "[inline_const]" 4 "," "(" ix ")" "," l "[end]"
sub _action_opcode_985 {
	_add_opcode(@_, 0xDD, 0xCB, 0x00, 0xA5);
}
# opcode : res "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "[end]"
sub _action_opcode_986 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xA6);
}
# opcode : res "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," a "[end]"
sub _action_opcode_987 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xA7);
}
# opcode : res "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," b "[end]"
sub _action_opcode_988 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xA0);
}
# opcode : res "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," c "[end]"
sub _action_opcode_989 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xA1);
}
# opcode : bit "[inline_const]" 0 "," "(" iy ")" "[end]"
sub _action_opcode_99 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0x46);
}
# opcode : res "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," d "[end]"
sub _action_opcode_990 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xA2);
}
# opcode : res "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," e "[end]"
sub _action_opcode_991 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xA3);
}
# opcode : res "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," h "[end]"
sub _action_opcode_992 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xA4);
}
# opcode : res "[inline_const]" 4 "," "(" ix "+" "[expr_DIS]" ")" "," l "[end]"
sub _action_opcode_993 {
	_add_opcode(@_, 0xDD, 0xCB, $_[ARGS][7], 0xA5);
}
# opcode : res "[inline_const]" 4 "," "(" iy ")" "[end]"
sub _action_opcode_994 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xA6);
}
# opcode : res "[inline_const]" 4 "," "(" iy ")" "," a "[end]"
sub _action_opcode_995 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xA7);
}
# opcode : res "[inline_const]" 4 "," "(" iy ")" "," b "[end]"
sub _action_opcode_996 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xA0);
}
# opcode : res "[inline_const]" 4 "," "(" iy ")" "," c "[end]"
sub _action_opcode_997 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xA1);
}
# opcode : res "[inline_const]" 4 "," "(" iy ")" "," d "[end]"
sub _action_opcode_998 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xA2);
}
# opcode : res "[inline_const]" 4 "," "(" iy ")" "," e "[end]"
sub _action_opcode_999 {
	_add_opcode(@_, 0xFD, 0xCB, 0x00, 0xA3);
}
# term2 : "[binop]" "[term]"
sub _action_term2_4 {
	[$_[ARGS][0], @{$_[ARGS][1]}]
}
# term : "[unop]*" NUMBER
sub _action_term_2 {
	$_[ARGS]
}
# term : "[unop]*" "(" "[expr]" ")"
sub _action_term_3 {
	[ @{$_[ARGS]}[0 .. $#{$_[ARGS]} - 3], 	# unop*
	  $_[ARGS][-3],							# (
	  @{$_[ARGS][-2]},						# [expr]
	  $_[ARGS][-1],							# )
	]
}
# unop : "-"
sub _action_unop_1 {
	$_[ARGS][0]
}


#------------------------------------------------------------------------------

=head2 parse

  $result = parse($input, $user, $start_rule)

This function receives the input token stream (L<Iterator::Simple::Lookahead|Iterator::Simple::Lookahead>), 
a user pointer and an optional start rule number. 

It parses the input stream, leaving the stream at the first unparsed
token, and returns the parse value - the result of the action function for the 
start rule.

The function dies with an error message indicating the input that cannot be parsed in 
case of a parse error.

$input is a stream of tokens, each token is a L<Asm::Preproc::Token|Asm::Preproc::Token> with 
the token type, the token value and the input source line
where the token was read.

The input source line is a L<Asm::Preproc::Line|Asm::Preproc::Line> with the text of the 
whole input source line, the line number and the source file name. 
This is used at error messages.

$user is a user pointer that is passed back at each action function.

$start_rule is an optional alternative start rule ID.

=cut

#------------------------------------------------------------------------------

sub parse {
	my($input, $user, $start_rule) = @_;

	# current state
	my $state;
	if (defined($start_rule)) {
		$state = $state_table[0]{$start_rule}
					or croak "rule '$start_rule' not found";
	}
	else {
		$state = $start_state
					or croak "start state not found";
	}
	my @values = ();
	
	# return stack of states
	my @stack = ();					# store: [$state, @values]

	# fetch token only after drop and after calling parser rules
	my $token = $input->peek;
	for(;;) {
		my($entry, $found_else);
		if ($entry =  $state_table[$state]{($token ? $token->type : "")}) {
			# entry exists, found token
		}
		elsif ($entry = $state_table[$state]{__else__}) {
			$found_else++;
		}
		else {
			_expected_error_at($token, $state);
		}
		
		if (ref($entry) eq 'ARRAY') {					# call sub-rule
			my($next_state, $return_state) = @$entry;
			push(@stack, [ $return_state, @values ]);	# return data
			($state, @values) = ($next_state);			# call
		}
		else {											# accept token
			$state = $entry;
			
			if (!$found_else) {
				push(@values, $token) if $token;		# add token to values
				$input->next;							# drop value
				$token = $input->peek;					# and get next token
			}

			while (ref($state) eq 'CODE') {				# return from sub-rules 
				my $value = $state->([@values], $user, $input);
				$token = $input->peek;					# in case $input was changed

				if ( ! @stack ) {						# END OF PARSE
					return $value;
				}
				
				my $top = pop(@stack);
				($state, @values) = @$top;
				push(@values, $value) if defined($value);
			}
		}
	}
}

#------------------------------------------------------------------------------
# expected error at given stream position
sub _expected_error_at { 
	my($token, $state) = @_;
	
	my @expected = sort map {_format_token($_)} keys %{$state_table[$state]};
	Asm::Preproc::Token->error_at(
			$token,
			"expected ".
			(scalar(@expected) == 1 ? "@expected" : "one of (@expected)")
		);
}

#------------------------------------------------------------------------------
# format a token 
sub _format_token {
	my($token) = @_;
	return "EOF" if $token eq "";
	return dump($token) if $token =~ /\W/;
	return $token;
}



sub z80parser { parse(@_) }

#------------------------------------------------------------------------------
# add opcode
sub _add_opcode {
	my($args, $program, $input, @bytes) = @_;
	if (@bytes) {
		my $opcode = CPU::Z80::Assembler::Opcode->new(
									child 	=> \@bytes,
									line	=> $args->[0]->line);
		$program->add_opcodes($opcode);
	}
	return undef;
}

sub _add_jump_opcode {
	my($args, $program, $input, @opcodes) = @_;
	if (@opcodes) {
		my $opcode_short = CPU::Z80::Assembler::Opcode->new(
									child 	=> $opcodes[0],
									line	=> $args->[0]->line);
		my $opcode_long = CPU::Z80::Assembler::Opcode->new(
									child 	=> $opcodes[1],
									line	=> $args->[0]->line);
		my $opcode = CPU::Z80::Assembler::JumpOpcode->new(
									short_jump	=> $opcode_short,
									long_jump	=> $opcode_long);
		$program->add_opcodes($opcode);
	}
	return undef;
}

#------------------------------------------------------------------------------

=head1 BUGS and FEEDBACK

See L<CPU::Z80::Assembler|CPU::Z80::Assembler>.

=head1 SEE ALSO

L<CPU::Z80::Assembler|CPU::Z80::Assembler>
L<CPU::Z80::Assembler::Program|CPU::Z80::Assembler::Program>

=head1 AUTHORS, COPYRIGHT and LICENCE

See L<CPU::Z80::Assembler|CPU::Z80::Assembler>.

=cut



1;
