package Dancer2::Plugin::MarkdownParser ;

use strict;
use warnings;
#use lib '.';
use Data::Dumper 'Dumper';
use Markdent::Parser;
#use Params::ValidationCompiler qw( validation_for );
use Moose;
extends 'Markdent::Handler::HTMLStream::Fragment';

has 'event_stash' => (is => 'rw', isa => 'ArrayRef', default => sub { [] }, writer => '_set_stash');
has 'event_chain' => (traits => [ 'Array' ], is => 'ro', isa => 'ArrayRef',
                      builder => '_get_event_chain', lazy => 1,
                      writer => '_set_event_chain',
                      handles => { shift_chain => 'shift', chain_empty => 'is_empty' } );
has 'add_class'        => (is => 'rw', isa => 'Bool', default => 0, writer => '_set_add_class');
has 'linkable_headers' => (is => 'ro', isa => 'Bool', default => 0);
has 'header_class'     => (is => 'ro', isa => 'Str', default => '');
has 'dialect'          => (is => 'ro', isa => 'Str', default => 'GitHub');
has 'header_count'     => (is => 'rw', isa => 'Int', default => 0, writer => '_set_header_count');


sub _inc_header_count {
  my $s = shift;
  $s->_set_header_count($s->header_count + 1);
}

# shift the next event off the event_chain
sub _get_next_event {
  my $s = shift;
  $s->shift_chain;
}

# reset the event chain back to original
sub _reset_event_chain {
  my $s = shift;
  $s->_set_event_chain($s->_get_event_chain);
}

# look for events in the following order
sub _get_event_chain {
  return [ qw ( start_paragraph start_code text end_code text ) ];
}

sub handle_event {
    my ($self, $event)  = @_;
    my $meth = $event->event_name();
    my $next = $self->_get_next_event;

    if ($self->chain_empty) {
      if ($meth eq $next && $event->text =~ /^\s+$/) {
        $self->_set_add_class(1);
      }
    } elsif ($meth eq $next) {
      push @{$self->event_stash}, $event;
      return;
    }

    $self->unravel_stash;
    $self->$meth( $event->kv_pairs_for_attributes() );
}

sub unravel_stash {
  my $s = shift;
  my @events = @{$s->event_stash};
  foreach my $event (@events) {
    my $meth = $event->event_name();
    $s->$meth( $event->kv_pairs_for_attributes() );
  }
  $s->_reset_event_chain;
  $s->_set_stash( [ ] );
}

sub start_code {
  my $s = shift;
  if ($s->add_class) {
    $s->_stream_start_tag( 'code', { class => 'single-line' });
  } else {
    $s->_stream_start_tag( 'code' );
  }
  $s->_set_add_class(0);
}

sub parse {
	my $s = shift;
  my $markdown = shift;

	my $parser = Markdent::Parser->new( dialects => $s->dialect, handler => $s );
	$parser->parse( markdown => $$markdown );
}

sub start_header {
  my $s = shift;
  my $level = $_[1];

  my %attributes = ();
  if ($s->header_class) {
    $attributes{class} = $s->header_class;
  }
  if ($s->linkable_headers) {
    $attributes{id} = "header_${level}_" . $s->header_count;
    $s->_inc_header_count;
  }

  $s->_stream_start_tag( 'h' . $level, \%attributes );
}



1;
