package Net::Amazon::EMR::InstanceStatus;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;
use Moose::Util::TypeConstraints;
use Net::Amazon::EMR::InstanceStateChangeReason;
use Net::Amazon::EMR::InstanceTimeline;

subtype 'Net::Amazon::EMR::Type::InstanceStatus::State' => as 'Str' => where { m/^(?:AWAITING_FULFILLMENT | PROVISIONING | BOOTSTRAPPING | RUNNING | TERMINATED)$/x };

has 'State' => ( is => 'ro',
                isa => 'Net::Amazon::EMR::Type::InstanceStatus::State',
);

has 'StateChangeReason' => ( is => 'ro', 
                             isa => 'Net::Amazon::EMR::Type::InstanceStateChangeReason',
                             coerce => 1,
                         );

has 'Timeline' => ( is => 'ro', 
                    isa => 'Net::Amazon::EMR::Type::InstanceTimeline',
                    coerce => 1,
                );


__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::InstanceStatus

=head1 DESCRIPTION

Implements the InstanceStatus data type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/APIReference/API_InstanceStatus.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
