use strict;
use warnings;

package Task::MapMetro::Maps;

# ABSTRACT: Map::Metro maps in a bundle
our $AUTHORITY = 'cpan:CSSON'; # AUTHORITY
our $VERSION = '0.1302'; # VERSION

1;

__END__

=pod

=encoding utf-8

=head1 NAME

Task::MapMetro::Maps - Map::Metro maps in a bundle



=begin html

<p>
<img src="https://img.shields.io/badge/perl-5.10+-blue.svg" alt="Requires Perl 5.10+" />
<a href="https://travis-ci.org/Csson/p5-Task-MapMetro-Maps"><img src="https://api.travis-ci.org/Csson/p5-Task-MapMetro-Maps.svg?branch=master" alt="Travis status" /></a>
<a href="http://cpants.cpanauthors.org/dist/Task-MapMetro-Maps-0.1302"><img src="https://badgedepot.code301.com/badge/kwalitee/Task-MapMetro-Maps/0.1302" alt="Distribution kwalitee" /></a>
<a href="http://matrix.cpantesters.org/?dist=Task-MapMetro-Maps%200.1302"><img src="https://badgedepot.code301.com/badge/cpantesters/Task-MapMetro-Maps/0.1302" alt="CPAN Testers result" /></a>
</p>

=end html

=head1 VERSION

Version 0.1302, released 2016-05-14.

=head1 TASK CONTENTS

=head2 Map::Metro

=head3 L<Map::Metro> 0.2404

=head2 Available maps

=head3 L<Map::Metro::Plugin::Map::Amsterdam>

=head3 L<Map::Metro::Plugin::Map::Athens>

=head3 L<Map::Metro::Plugin::Map::Barcelona>

=head3 L<Map::Metro::Plugin::Map::Berlin>

=head3 L<Map::Metro::Plugin::Map::Brussels>

=head3 L<Map::Metro::Plugin::Map::Budapest>

=head3 L<Map::Metro::Plugin::Map::Copenhagen>

=head3 L<Map::Metro::Plugin::Map::Gothenburg>

=head3 L<Map::Metro::Plugin::Map::Helsinki>

=head3 L<Map::Metro::Plugin::Map::Lille>

=head3 L<Map::Metro::Plugin::Map::Lyon>

=head3 L<Map::Metro::Plugin::Map::Madrid>

=head3 L<Map::Metro::Plugin::Map::Oslo>

=head3 L<Map::Metro::Plugin::Map::Stockholm>

=head1 SYNOPSIS

    $ cpanm Task::MapMetro::Maps

=head1 SEE ALSO

L<Map::Metro>

L<Task::MapMetro::Dev>

=head1 AUTHOR

Erik Carlsson E<lt>info@code301.comE<gt>

=head1 COPYRIGHT

Copyright 2015 - Erik Carlsson

=head1 LICENSE

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 SOURCE

L<https://github.com/Csson/p5-Task-MapMetro-Maps>

=head1 HOMEPAGE

L<https://metacpan.org/release/Task-MapMetro-Maps>

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Erik Carlsson.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
