# Generated by default/object.tt
package Paws::Connect::QuickConnectConfig;
  use Moose;
  has PhoneConfig => (is => 'ro', isa => 'Paws::Connect::PhoneNumberQuickConnectConfig');
  has QueueConfig => (is => 'ro', isa => 'Paws::Connect::QueueQuickConnectConfig');
  has QuickConnectType => (is => 'ro', isa => 'Str', required => 1);
  has UserConfig => (is => 'ro', isa => 'Paws::Connect::UserQuickConnectConfig');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Connect::QuickConnectConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Connect::QuickConnectConfig object:

  $service_obj->Method(Att1 => { PhoneConfig => $value, ..., UserConfig => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Connect::QuickConnectConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->PhoneConfig

=head1 DESCRIPTION

Contains configuration settings for a quick connect.

=head1 ATTRIBUTES


=head2 PhoneConfig => L<Paws::Connect::PhoneNumberQuickConnectConfig>

The phone configuration. This is required only if QuickConnectType is
PHONE_NUMBER.


=head2 QueueConfig => L<Paws::Connect::QueueQuickConnectConfig>

The queue configuration. This is required only if QuickConnectType is
QUEUE.


=head2 B<REQUIRED> QuickConnectType => Str

The type of quick connect. In the Amazon Connect console, when you
create a quick connect, you are prompted to assign one of the following
types: Agent (USER), External (PHONE_NUMBER), or Queue (QUEUE).


=head2 UserConfig => L<Paws::Connect::UserQuickConnectConfig>

The user configuration. This is required only if QuickConnectType is
USER.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Connect>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

