use strict;
use warnings;
use Test::More;

# generated by Dist::Zilla::Plugin::Test::PodSpelling 2.007005
use Test::Spelling 0.12;
use Pod::Wordlist;


add_stopwords(<DATA>);
all_pod_files_spelling_ok( qw( bin lib ) );
__DATA__
%-d
%-d-%-m-%y
%-d-%-m-08
%-d-%-m-10
%-d-%-m-95
%-d-%m-%y
%-d-02-08
%-d-09-10
%-d-12-95
%-d.%-m.%Y
%-d.%-m.%y
%-d.%-m.-10
%-d.%-m.08
%-d.%-m.10
%-d.%-m.1995
%-d.%-m.2008
%-d.%-m.95
%-d/%-m/%y
%-d/%-m/08
%-d/%-m/10
%-d/%-m/95
%-e
%-m/%-d/%y
%-m/%-d/08
%-m/%-d/10
%-m/%-d/95
%A
%A፡
%A፣
%A፥%B፡%e፡መዓልት፡%Y፡%r፡%Z
%B
%Bta
%Ey
%H
%H.%M
%H.%M.%S
%H:%M:%S
%H時%M分%S秒
%H시
%I.%M.%S
%I:%M:%S
%I:%M:%S.%p
%M
%M분
%OC%Oy
%OH:%OM:%OS
%OH:%OM:%OS‬
%OI:%OM:%OS
%Od
%Od-%Om-%Oy
%Oe
%Op
%Oy
%Oy/%Om/%Od
%Oy،
%R
%S
%S초
%T
%X
%Y
%Y-%m-%d
%Y-%m-%dT%T
%Y.%d.%m
%Y.%m.%d
%Y.eko
%Y/%m/%d
%Y年%m月%d日
%Y년
%Z
%a
%a،
%b
%bren
%c
%d
%d-%b-%Y
%d-%m-%Y
%d-%m-%Y،
%d-%m-%y
%d.%m.%Y
%d.%m.%y
%d/%m-%Y
%d/%m/%Ey
%d/%m/%Y
%d/%m/%y
%da
%d일
%e
%e-%m-%Y
%e.%b
%e.%m.%Y
%e،
%k:%M:%S
%l:%M:%S
%l:%M:%S፡%p
%m
%m/%d/%Y
%m/%d/%y
%m월
%p
%p%I.%M.%S
%p%I:%M:%S
%r
%x
%y
%y-%m-%d
%y/%-m/%-d
%z
+J.C
-0010-09-15T04:44:23
-10(e)ko
-10-09-15T04:44:23
-10-Sep-15
-10-Septembro-15
-10-ж
-10-жылдын
-10-ӕм
-10-ലെ
-10.eko
-10/9/15(土
-10/9/15周六
-10/9/15土曜日
-10/9/15（星期六）
-10/9/15（週六）
-10/Q3
-10BCE
-10an
-10ৰ
-10లో
-10 аз
-10 г
-10 ел
-10 ж
-10 оны
-10 р
-10 с
-10 сыл
-10 ҫ
-10年
-10年09月15日
-10年9月
-10年9月15日
-10年9月15日(土
-10年9月15日周六
-10年9月15日土曜日
-10年9月15日星期六
-10年9月15日週六
-10年9月15日，周六
-10年Q3
-10年的第37週
-10年第37个星期
-10年第37個星期
-10年第37周
-10年第37週
-10年第3四半期
-10年第3季
-10年第3季度
-10년
-ஆம்
/M
02.2008 г
02월
02초
04:44:23.p.d
04:44:23 AM
04:44:23 priešpiet
04:44:23 priešpiet;
04:44:23 vm
04:44 AM
04:44 priešpiet
04:44 priešpiet;
04:44 vm
04h
04h44
04 AM
04 priešpiet
04時44分23秒
04시
05-02-б.з
05-Feb-2008
05-Gur-2008
05-feb
05-лют.-2008
05.02.2008 г
05.02.2008 ҫ
05.feb
05.феб
05/02/%Ey
05a
05 a.m
05분
05일
06:30:30.m.d
06:30:30 PM
06:30:30 nm
06:30:30 popiet
06:30:30 popiet;
06:30 PM
06:30 nm
06:30 popiet
06:30 popiet;
06 PM
06 popiet
08/%-m/%-d
09.-10 г
09:05:02.p.d
09:05:02 AM
09:05:02 priešpiet
09:05:02 priešpiet;
09:05:02 vm
09:05 AM
09:05 priešpiet
09:05 priešpiet;
09:05 vm
09h
09h05
09 AM
09 priešpiet
09時05分02秒
09시
09월
1-Kysã
1-ch
1-chorak
1-ci
1-hafta
1-il
1-nji
1-rë
1-аг
1-аптасы
1-гӀа
1-й
1-кы
1-мӗш
1-р
1-ч
1-чей
1-чейрек
1-чорак
1-шы
1-я
1-ҳафта
1-ҹи
1-ին
1-րդ
1-پەسىل
1-ھەپتە
1.Q
1.Q.2008
1.er
1. cet
1.ª
1.º
1/4분기
10-Kysã
10-р
10/%-m/%-d
10K
10Ky
10月
10월
11-Kysã
11-р
11K
11Ky
11᠊ᠷ
11月
11월
12-22周五
12-Kysã
12-р
12.1995 г
12/22(金
12/22周五
12/22金曜日
12/22（星期五）
12/22（週五）
12K
12Ky
12᠊ᠷ
12月
12月22日
12月22日(金
12月22日周五
12月22日週五
12月22日金曜日
12月的第3週
12月第3个星期
12月第3個星期
12月第3週
12월
15(a
15-09-б.з.д
15-Ful--10
15-Seb--10
15-Sept--10
15-a
15-sen
15-sentabr
15-sep
15-sept
15-set
15-вер.--10
15-сен
15-сентябрь
15-سېنتەبىر
15-سېنتەبىر،
15-सप्टेंबर--10
15-सेप
15.09.-10 г
15.09.-10 ҫ
15.sep
15.sept
15.сеп
15.септ
15/09/%Ey
15/9/-10（周六）
15/9/-10（週六）
15/9/ਈ.ਪੂ
15/9/ก่อน
15/9/ກ່ອນ
15/9（週六）
15a
15mh
15ê
15טן
15ھەم
15ی
15日
15日(土
15日周六
15日土曜日
15일
18.30:30 UTC
18h
18h30
18时
18時
18時30分30秒
18시
1995(e)ko
1995-12-22T09:05:02
1995-Dec-22
1995-Decembro-22
1995-ж
1995-жылдын
1995-ӕм
1995-ലെ
1995.eko
1995/12/22(金
1995/12/22周五
1995/12/22金曜日
1995/12/22（星期五）
1995/12/22（週五）
1995/Q4
1995CE
1995an
1995ৰ
1995లో
1995 аз
1995 г
1995 ел
1995 ж
1995 оны
1995 р
1995 с
1995 сыл
1995 ҫ
1995年
1995年12月
1995年12月22日
1995年12月22日(金
1995年12月22日周五
1995年12月22日星期五
1995年12月22日週五
1995年12月22日金曜日
1995年12月22日，周五
1995年Q4
1995年的第51週
1995年第4四半期
1995年第4季
1995年第4季度
1995年第51个星期
1995年第51個星期
1995年第51周
1995年第51週
1995년
1:a
1Hh
1K
1Ky
1Q
1T
1aad
1af
1añ
1d
1e
1el
1em
1er
1kv
1me
1r
1ro
1st
1ste
1u
1ª
1º
1Ç
1ú
1ο
1م
1लें
1য়
1લો
1ମ
1వ
1ನೇ
1ኛው
1ይ
1 ᠊ᠷ
1ⁿ
1季度
1月
1번째
1분기
1월
1𐑅𐐻
1𐑕𐑑
2-5周二
2-Kysã
2-ch
2-chorak
2-ci
2-hafta
2-il
2-nji
2-të
2-аг
2-аптасы
2-гі
2-гӀа
2-й
2-мӗш
2-р
2-с
2-ч
2-чей
2-чейрек
2-чорак
2-я
2-ҳафта
2-ҹи
2-ին
2-րդ
2-پەسىل
2-ھەپتە
2.Q
2. cet
2.ª
2.º
2/4분기
2/5(火
2/5周二
2/5火曜日
2/5（星期二）
2/5（週二）
2008(e)ko
2008-02-05T18:30:30
2008-Feb-05
2008-Februaro-05
2008-ж
2008-жылдын
2008-ӕм
2008-ലെ
2008.eko
2008/2/5(火
2008/2/5周二
2008/2/5火曜日
2008/2/5（星期二）
2008/2/5（週二）
2008/Q1
2008CE
2008an
2008ৰ
2008లో
2008 аз
2008 г
2008 ел
2008 ж
2008 оны
2008 р
2008 с
2008 сыл
2008 ҫ
2008年
2008年02月05日
2008年2月
2008年2月5日
2008年2月5日(火
2008年2月5日周二
2008年2月5日星期二
2008年2月5日火曜日
2008年2月5日週二
2008年2月5日，周二
2008年Q1
2008年的第6週
2008年第1四半期
2008年第1季
2008年第1季度
2008年第6个星期
2008年第6個星期
2008年第6周
2008年第6週
2008년
22(a
22-12-б.з
22-Dec-1995
22-Dis-1995
22-Mud-1995
22-a
22-dek
22-dekabr
22-dic
22-груд.-1995
22-дек
22-декабрь
22-دېكابىر
22-دېكابىر،
22-डिसे
22-डिसेंबर-1995
22.12.1995 г
22.12.1995 ҫ
22.12.95 г
22.dec
22.des
22.дец
22/12/%Ey
22/12/1995（周五）
22/12/1995（週五）
22/12/ਸੰਨ
22/12/ค.ศ
22/12/ຄ.ສ
22/12（週五）
22a
22mh
22ê
22טן
22ھەم
22ی
22日
22日(金
22日周五
22日金曜日
22일
23초
2:a
2Hh
2K
2Ky
2Q
2T
2aad
2de
2do
2e
2em
2il
2kv
2l
2n
2na
2nd
2nde
2ni
2u
2yem
2ª
2º
2Ç
2ème
2ú
2ǁî
2ο
2م
2रें
2য়
2જો
2ୟ
2వ
2ನೇ
2ኛው
2ይ
2ᵍᵉ
2 ᠊ᠷ
2季度
2月
2月5日
2月5日(火
2月5日周二
2月5日火曜日
2月5日週二
2月的第1週
2月第1个星期
2月第1個星期
2月第1週
2번째
2분기
2월
2초
2𐑌𐐼
2𐑯𐑛
3-Kysã
3-ch
3-chorak
3-cü
3-hafta
3-il
3-nji
3-të
3-аг
3-аптасы
3-гӀа
3-й
3-мӗш
3-р
3-с
3-ці
3-ч
3-чей
3-чейрек
3-чорак
3-я
3-ҳафта
3-ҹү
3-ին
3-րդ
3-پەسىل
3-ھەپتە
3.Q
3.Q.-10
3.er
3. cet
3.ª
3.º
3/4분기
30 p.m
30분
30초
37-hafta
37-il
37-аптасы
37-й
37-мӗш
37-р
37-я
37-ҳафта
37-ին
37-րդ
37-ھەپتە
37.ª
37em
37ª
37º
37م
37তম
37వ
37번째
3:e
3Hh
3K
3Ky
3Q
3T
3aad
3de
3e
3em
3er
3et
3kv
3r
3rd
3s
3tie
3u
3ydd
3yem
3ª
3º
3Ç
3ème
3ú
3ǁî
3ο
3م
3रें
3য়
3જો
3ୟ
3వ
3ನೇ
3ኛው
3ይ
3᠊ᠷ
3 ᠊ᠷ
3ⁿʰ
3季度
3月
3번째
3분기
3월
3𐑉𐐼
3𐑻𐑛
4-Kysã
4-ch
4-chorak
4-cü
4-nji
4-t
4-гӀа
4-й
4-мӗш
4-р
4-с
4-ты
4-ч
4-чей
4-чейрек
4-чорак
4-ҹү
4-ӕм
4-ին
4-րդ
4-پەسىل
4.44.23 AM
4.44.23 PG
4.44.23 am
4.44.23 ap
4.44.23 fm
4.44.23 ip
4.44:23 AM
4.44:23 AM UTC
4.44:23 UTC
4.44 AM
4.44 PG
4.44 am
4.44 ap
4.44 fm
4.44 ip
4.Q
4.Q.1995
4. cet
4.º
4/4분기
44 a.m
44분
4:44-ին
4:44:23B
4:44:23ê
4:44:23፡AM
4:44:23 A.M
4:44:23 AM
4:44:23 AM;
4:44:23 AN
4:44:23 Dinda
4:44:23 FM
4:44:23 GH
4:44:23 HH
4:44:23 Isuk
4:44:23 I bikɛ̂glà
4:44:23 Lwamilawu
4:44:23 PG
4:44:23 RW
4:44:23 SA
4:44:23 SF
4:44:23 Sub
4:44:23 Subbaahi
4:44:23 TO
4:44:23 WD
4:44:23 Z.MU
4:44:23 a.g
4:44:23 a.m
4:44:23 a. m
4:44:23 am
4:44:23 comme
4:44:23 de
4:44:23 dop
4:44:23 f.h
4:44:23 f.m
4:44:23 fm
4:44:23 go.öň
4:44:23 i.b
4:44:23 ib
4:44:23 idiɓa
4:44:23 kiɛmɛ́ɛm
4:44:23 kíkíríg
4:44:23 m
4:44:23 maná
4:44:23 moies
4:44:23 ntɔ́ngɔ́
4:44:23 n tufat
4:44:23 p.d
4:44:23 priekšp
4:44:23 prije podne
4:44:23 r.n
4:44:23 subaka
4:44:23 sárúwá
4:44:23 uluchelo
4:44:23 v.M
4:44:23 vm
4:44:23 wichishu
4:44:23 Àárɔ̀
4:44:23 Àárọ̀
4:44:23 ÖÖ
4:44:23 ǁgoagas
4:44:23 π.μ
4:44:23 ТО
4:44:23 ЭИ
4:44:23 дп
4:44:23 претпл
4:44:23 прије подне
4:44:23 тң
4:44:23 ү.ө
4:44B
4:44m
4:44ê
4:44 A.M
4:44 AM
4:44 AN
4:44 Dinda
4:44 FM
4:44 GH
4:44 HH
4:44 Isuk
4:44 I bikɛ̂glà
4:44 KI
4:44 Kiroko
4:44 Luma lwa K
4:44 Lwamilawu
4:44 Ma
4:44 Muhi
4:44 Munkyo
4:44 OD
4:44 PG
4:44 RW
4:44 RŨ
4:44 SA
4:44 SF
4:44 Sub
4:44 Subbaahi
4:44 TO
4:44 TOO
4:44 Taparachu
4:44 Tesiran
4:44 WD
4:44 Z.MU
4:44 Zdat azal
4:44 a.g
4:44 a.m
4:44 a. m
4:44 am
4:44 comme
4:44 de
4:44 dop
4:44 f.h
4:44 f.m
4:44 fm
4:44 go.öň
4:44 i.b
4:44 ib
4:44 icheheavo
4:44 idiɓa
4:44 kang’ama
4:44 kiɛmɛ́ɛm
4:44 krn
4:44 kíkíríg
4:44 makeo
4:44 maná
4:44 moies
4:44 ntɔ́ngɔ́
4:44 n tufat
4:44 p.d
4:44 pamilau
4:44 priekšp
4:44 prije podne
4:44 r.n
4:44 subaka
4:44 sárúwá
4:44 uluchelo
4:44 utuko
4:44 v.M
4:44 vm
4:44 wichishu
4:44 Àárɔ̀
4:44 Àárọ̀
4:44 ÖÖ
4:44 Ĩyakwakya
4:44 Ɛnkakɛnyá
4:44 ǁgoagas
4:44 π.μ
4:44 ТО
4:44 ЭИ
4:44 дп
4:44 претпл
4:44 прије подне
4:44 тң
4:44 ү.ө
4:e
4B
4Hh
4K
4Ky
4Q
4T
4aad
4ba’
4de
4e
4em
4h44:23 AM
4h44 AM
4kv
4m
4mh
4t
4te
4th
4to
4u
4ydd
4º
4Ç
4ème
4ê
4ú
4ǁî
4ο
4ی
4थें
4થો
4ର୍ଥ
4వ
4ನೇ
4ኛው
4ይ
4 A.M
4 AM
4 FM
4 HH
4 Isuk
4 PG
4 SA
4 Sub
4 TO
4 WD
4 a.m
4 a. m
4 am
4 ap
4 dop
4 f.h
4 f.m
4 fm
4 go.öň
4 i.b
4 ib
4 ip
4 moies
4 p.d
4 priekšp
4 prije podne
4 r.n
4 vm
4 Àárɔ̀
4 Àárọ̀
4 π.μ
4 ТО
4 ЭИ
4 дп
4 претпл
4 прије подне
4 тң
4 ᠊ᠷ
4ⁿ
4季度
4时
4時
4時44分23秒
4月
4분기
4시
4월
4𐑉𐑃
4𐑹𐑔
5(a
5-Kysã
5-a
5-fev
5-fevral
5-р
5-фев
5-февраль
5-فېۋرال
5-فېۋرال،
5-फेब
5-फेब्रुवारी-2008
5.02.08 г
5.02.2008 г
5.feb
5. februára 2008, 18:30:30
5/2/2008（周二）
5/2/2008（週二）
5/2/ਸੰਨ
5/2/ค.ศ
5/2/ຄ.ສ
5/2（週二）
51-hafta
51-il
51-аптасы
51-й
51-мӗш
51-р
51-я
51-ҳафта
51-ին
51-րդ
51-ھەپتە
51.ª
51em
51ª
51º
51م
51তম
51వ
51번째
5K
5Ky
5mh
5ê
5טן
5ھەم
5ی
5፡መዓልት፡2008፡06:30:30
5 ᠊ᠷ
5日
5日(火
5日周二
5日火曜日
5月
5분
5월
5일
6-Kysã
6-hafta
6-il
6-аптасы
6-й
6-мӗш
6-р
6-я
6-ҳафта
6-ին
6-րդ
6-ھەپتە
6.30.30 PM
6.30.30 PTG
6.30.30 em
6.30.30 ep
6.30.30 ip
6.30.30 pm
6.30:30 PM
6.30:30 PM UTC
6.30 PM
6.30 PTG
6.30 em
6.30 ep
6.30 ip
6.30 pm
6.ª
6:30-ին
6:30:30B
6:30:30ê
6:30:30፡PM
6:30:30 CH
6:30:30 Dilolo
6:30:30 EA
6:30:30 EW
6:30:30 FI
6:30:30 G.M
6:30:30 GD
6:30:30 I ɓugajɔp
6:30:30 Ngo
6:30:30 PM
6:30:30 PM;
6:30:30 PTG
6:30:30 Pashamihe
6:30:30 TK
6:30:30 TŊ
6:30:30 WB
6:30:30 Wengi
6:30:30 YM
6:30:30 Z.MW
6:30:30 Zaarikay b
6:30:30 a.k
6:30:30 akasuba
6:30:30 cɛɛ́nko
6:30:30 du
6:30:30 e.b
6:30:30 e.h
6:30:30 e.m
6:30:30 eb
6:30:30 ebyámu
6:30:30 em
6:30:30 f
6:30:30 go.soň
6:30:30 i.n
6:30:30 kikiiɗe
6:30:30 kisɛ́ndɛ
6:30:30 kugú
6:30:30 lilli
6:30:30 m.d
6:30:30 mchochil’l
6:30:30 mpókwa
6:30:30 n.M
6:30:30 ngəgógəle
6:30:30 nm
6:30:30 nomëttes
6:30:30 n tmeddit
6:30:30 odp
6:30:30 p.m
6:30:30 p. m
6:30:30 pm
6:30:30 pop
6:30:30 po podne
6:30:30 pēcp
6:30:30 wótp
6:30:30 ÖS
6:30:30 Ɔ̀sán
6:30:30 ǃuias
6:30:30 μ.μ
6:30:30 ТК
6:30:30 ЭК
6:30:30 попл
6:30:30 по подне
6:30:30 пп
6:30:30 тк
6:30:30 ү.х
6:30:30 Ọ̀sán
6:30B
6:30f
6:30ê
6:30 CH
6:30 Chilo
6:30 Dilolo
6:30 EA
6:30 EW
6:30 Ebongi
6:30 Eigulo
6:30 FI
6:30 G.M
6:30 GD
6:30 Hwaĩ-inĩ
6:30 I ɓugajɔp
6:30 MUU
6:30 Mo
6:30 Ngo
6:30 OT
6:30 PM
6:30 PTG
6:30 Pashamihe
6:30 TK
6:30 Teipa
6:30 TŊ
6:30 UT
6:30 WB
6:30 Wengi
6:30 YM
6:30 Z.MW
6:30 Zaarikay b
6:30 a.k
6:30 akasuba
6:30 cɛɛ́nko
6:30 du
6:30 e.b
6:30 e.h
6:30 e.m
6:30 eb
6:30 ebyámu
6:30 em
6:30 go.soň
6:30 i.n
6:30 ichamthi
6:30 kikiiɗe
6:30 kingoto
6:30 kisɛ́ndɛ
6:30 koosk
6:30 kugú
6:30 kyiukonyi
6:30 lilli
6:30 luma lwa p
6:30 m.d
6:30 mchochil’l
6:30 mpókwa
6:30 n.M
6:30 ngəgógəle
6:30 nm
6:30 nomëttes
6:30 nyiaghuo
6:30 n tmeddit
6:30 odp
6:30 p.m
6:30 p. m
6:30 pamunyi
6:30 pm
6:30 pop
6:30 po podne
6:30 pēcp
6:30 wótp
6:30 ÖS
6:30 Ĩyawĩoo
6:30 ŨG
6:30 Ɔ̀sán
6:30 Ɛndámâ
6:30 ǃuias
6:30 μ.μ
6:30 ТК
6:30 ЭК
6:30 попл
6:30 по подне
6:30 пп
6:30 тк
6:30 ү.х
6:30 Ḍeffir aza
6:30 Ọ̀sán
6B
6K
6Ky
6em
6f
6h30:30 PM
6h30 PM
6ª
6º
6ê
6م
6ی
6তম
6వ
6 CH
6 EA
6 FI
6 G.M
6 Ngo
6 PM
6 PTG
6 TK
6 WB
6 Wengi
6 e.b
6 e.h
6 e.m
6 eb
6 em
6 ep
6 go.soň
6 i.n
6 ip
6 m.d
6 nm
6 nomëttes
6 odp
6 p.m
6 p. m
6 pm
6 pop
6 po podne
6 pēcp
6 wótp
6 Ɔ̀sán
6 μ.μ
6 ТК
6 ЭК
6 попл
6 по подне
6 пп
6 тк
6 ᠊ᠷ
6 Ọ̀sán
6月
6번째
6시
6월
7-Kysã
7-р
7K
7Ky
7 ᠊ᠷ
7月
7월
8-Kysã
8-р
8K
8Ky
8᠊ᠷ
8 ᠊ᠷ
8月
8월
9-15周六
9-Kysã
9-р
9-ին
9.05.02 AM
9.05.02 PG
9.05.02 am
9.05.02 ap
9.05.02 fm
9.05.02 ip
9.05:02 AM
9.05:02 AM UTC
9.05:02 UTC
9.05 AM
9.05 PG
9.05 am
9.05 ap
9.05 fm
9.05 ip
9/15(土
9/15周六
9/15土曜日
9/15（星期六）
9/15（週六）
95/%-m/%-d
9:05-ին
9:05:02B
9:05:02ê
9:05:02፡AM
9:05:02 A.M
9:05:02 AM
9:05:02 AM;
9:05:02 AN
9:05:02 Dinda
9:05:02 FM
9:05:02 GH
9:05:02 HH
9:05:02 Isuk
9:05:02 I bikɛ̂glà
9:05:02 Lwamilawu
9:05:02 PG
9:05:02 RW
9:05:02 SA
9:05:02 SF
9:05:02 Sub
9:05:02 Subbaahi
9:05:02 TO
9:05:02 WD
9:05:02 Z.MU
9:05:02 a.g
9:05:02 a.m
9:05:02 a. m
9:05:02 am
9:05:02 comme
9:05:02 de
9:05:02 dop
9:05:02 f.h
9:05:02 f.m
9:05:02 fm
9:05:02 go.öň
9:05:02 i.b
9:05:02 ib
9:05:02 idiɓa
9:05:02 kiɛmɛ́ɛm
9:05:02 kíkíríg
9:05:02 m
9:05:02 maná
9:05:02 moies
9:05:02 ntɔ́ngɔ́
9:05:02 n tufat
9:05:02 p.d
9:05:02 priekšp
9:05:02 prije podne
9:05:02 r.n
9:05:02 subaka
9:05:02 sárúwá
9:05:02 uluchelo
9:05:02 v.M
9:05:02 vm
9:05:02 wichishu
9:05:02 Àárɔ̀
9:05:02 Àárọ̀
9:05:02 ÖÖ
9:05:02 ǁgoagas
9:05:02 π.μ
9:05:02 ТО
9:05:02 ЭИ
9:05:02 дп
9:05:02 претпл
9:05:02 прије подне
9:05:02 тң
9:05:02 ү.ө
9:05B
9:05m
9:05ê
9:05 A.M
9:05 AM
9:05 AN
9:05 Dinda
9:05 FM
9:05 GH
9:05 HH
9:05 Isuk
9:05 I bikɛ̂glà
9:05 KI
9:05 Kiroko
9:05 Luma lwa K
9:05 Lwamilawu
9:05 Ma
9:05 Muhi
9:05 Munkyo
9:05 OD
9:05 PG
9:05 RW
9:05 RŨ
9:05 SA
9:05 SF
9:05 Sub
9:05 Subbaahi
9:05 TO
9:05 TOO
9:05 Taparachu
9:05 Tesiran
9:05 WD
9:05 Z.MU
9:05 Zdat azal
9:05 a.g
9:05 a.m
9:05 a. m
9:05 am
9:05 comme
9:05 de
9:05 dop
9:05 f.h
9:05 f.m
9:05 fm
9:05 go.öň
9:05 i.b
9:05 ib
9:05 icheheavo
9:05 idiɓa
9:05 kang’ama
9:05 kiɛmɛ́ɛm
9:05 krn
9:05 kíkíríg
9:05 makeo
9:05 maná
9:05 moies
9:05 ntɔ́ngɔ́
9:05 n tufat
9:05 p.d
9:05 pamilau
9:05 priekšp
9:05 prije podne
9:05 r.n
9:05 subaka
9:05 sárúwá
9:05 uluchelo
9:05 utuko
9:05 v.M
9:05 vm
9:05 wichishu
9:05 Àárɔ̀
9:05 Àárọ̀
9:05 ÖÖ
9:05 Ĩyakwakya
9:05 Ɛnkakɛnyá
9:05 ǁgoagas
9:05 π.μ
9:05 ТО
9:05 ЭИ
9:05 дп
9:05 претпл
9:05 прије подне
9:05 тң
9:05 ү.ө
9B
9K
9Ky
9h05:02 AM
9h05 AM
9m
9ê
9ی
9 A.M
9 AM
9 FM
9 HH
9 Isuk
9 PG
9 SA
9 Sub
9 TO
9 WD
9 a.m
9 a. m
9 am
9 ap
9 dop
9 f.h
9 f.m
9 fm
9 go.öň
9 i.b
9 ib
9 ip
9 moies
9 p.d
9 priekšp
9 prije podne
9 r.n
9 vm
9 Àárɔ̀
9 Àárọ̀
9 π.μ
9 ТО
9 ЭИ
9 дп
9 претпл
9 прије подне
9 тң
9 ᠊ᠷ
9时
9時
9時05分02秒
9月
9月15日
9月15日(土
9月15日周六
9月15日土曜日
9月15日週六
9月的第2週
9月第2个星期
9月第2個星期
9月第2週
9시
9월
A
A-K
A.K
A.M
A1
A2
A3
A4
A5
A6
A7
AB
AC
AD
AF
AG
AGA
AK
AM
AM04.44.23
AM09.05.02
AM፡UTC
AN
ART
AY
AZ
Aaktopaʼ
Aane
Aar
Ab
Abbreviated
Abich
Abiriyo
Abkhazian
Aboro
Abr
Abriil
Abril
Abrille
Abrëll
Aburil
Achiel
Adduha
Adek
Adlam
Ado
Adooleessa
Afar
Afghanistan
Afi
Afirilu
Afraad
Africa
African
Afrikaans
After
Afọ
Ag
Aga
Agasti
Aghem
Ago
Agosti
Agosto
Agostu
Ags
Agt
Agu
Agusito
Agusta
Agusti
Agustus
Agɛ
Agɛmɔ
Agẹ
Agẹmọ
Ahad
Ahd
Aib
Aibreán
Aj
Ajé
Akaas
Akan
Akanapawa
Aketseaba-Kɔtɔnimba
Akoose
Akr
Akras
Akw
Akwas
Akwota
Al
Ala
Alah
Alahady
Alahamisi
Alak
Alakamisy
Alamíisi
Alar
Alarba
Alarbay
Alarobia
Alats
Alatsinainy
Alaámisi
Albania
Albanian
Alexander
Algeria
Alh
Alhadi
Alhamiisa
Alhamis
Alhamisi
Alj
Aljuma
Alm
Alohan’i
Alt
Altine
Aluula
Alx
Alxamis
Alz
Alzuma
Am
Ama
Amait
Amajjii
America
American
Amharic
Ammoʼnaʼ
An
Andorra
Aneg
Angola
Anguilla
Ang’wen
Ann
Anna
Anno
Ansa
Antes
Antigua
Anwar
Aog
Aogositra
Aoine
Aorian’i
Aoǁkhuumûǁkhâb
Ap
Apar
Apiriri
Aplili
Apr
Aprel
Aprell
April
Aprili
Aprilo
Aprily
Aprilyi
Apu
Apuli
ArY
Ara
Araapy
Arab
Arabia
Arabic
Aragonese
Arahamisi
Arakõi
Aralık
Aramisay
Aramisi
Aramithi
Arapo
Arapokõi
Arapoteĩ
Ararundy
Arateĩ
Arbaco
Arbc
Are
Argentina
Ariyo
Ariŋuu
Arj
Arjuma
Arm
Armenia
Armenian
Arrubu
Ars
Aruba
Ará
Arát
Asa
Asab
Asabar
Asabotsy
Asamas
Ase
Aseer
Ashanali
Asi
Asibti
Asimwas
Asinas
Asiḍyas
Asm
Asn
Ass
Assabdu
Assamese
Asturian
Asu
Asḍ
AtY
Ata
Atakaijire
Atalaata
Atalata
Ati
Atini
Atinni
Atlas
Atochchíʼnaʼ
Atokloʼ
Atooŋe
Atsam
Auchiel
Auer
Aug
Auguscht
August
Augusto
Augustus
Aung’on
Australia
Austria
Available
Averil
Avg
Avgust
Avi
Avo
Avost
Avr
Avrril
Avrîl
Aw
Awg
Awgust
Awi
Awiril
Awr
Awril
Awst
Aww
Awwissu
Axad
Axd
Ayn
Aynas
Ayɛwoho-Kitawonsa
Azaal
Azerbaijan
Azerbaijani
Ağu
Ağustos
Aŋpétunuŋpa
Aŋpétutopa
Aŋpétuwakȟaŋ
Aŋpétuwaŋži
Aŋpétuyamni
Aŋpétuzaptaŋ
Aŭg
Aŭgusto
B
B.E
B.e
B.e.öň
B4:44
B4:44:23
B4时
B4時
B6:30
B6:30:30
B6时
B6時
B9:05
B9:05:02
B9时
B9時
BC
BCE
BHAI
BK
BK:mm
BK:mm:ss
BK時
BL
BM
BN
BZ
Ba
Baada
Bafia
Bahamas
Bahrain
Bal
Bala
Balaza
Balochi
Baluchi
Bambara
Bangla
Bangladesh
Bar
Barbados
Barbuda
Barthélemy
Basaa
Base
Bashkir
Basque
Bayan
Beal
Bealtaine
Bed
Before
Belarus
Belarusian
Belgium
Belize
Bemba
Ben
Bena
Benada
Benin
Bermuda
Bh
Bh:mm
Bh:mm:ss
Bhm
Bhms
Bhojpuri
Bhutan
Bh时
Bh時
Bifọ́
Bikua-ôko
Bil
Bin
Bir
Bisha
Bit
Bitooteessa
Biy
Biyernes
Bk1
Bk2
Bk3
Bk4
Bk5
Blin
Boaldyn
Bodo
Bokmål
Bolivia
Bosnia
Bosnian
Botswana
Brazil
Brazzaville
Breiddal
Breton
British
Brunei
Brá
Bráčet
Bu
Budh
Budhwaar
Bukya
Bulgaria
Bulgarian
Bur
Bureet
Burkina
Burma
Burmese
Burundi
Burī
Bäkɛl
Bäkɛl،
Bé
Bél
Bélú
Bêl
Bêläwü
Bìòôm
Bít
Bïkua-okü
Bïkua-ptâ
Bïkua-usïö
Bïkua-ûse
Bó
Bǎa
Bɔ́r
Bảy
C
C-I
C.A
C.a
C.j
C.kk
C1
C2
C3
C4
CC
CD
CE
CKI
CLA
CLDR
CN
Caamsa
Caddo
Caggal
Caicos
Cakcuse
Cako
Caledonia
Cam
Cambodia
Cameroon
Can
Canada
Canary
Cantonese
Cape
Caribbean
Catalan
Catalog
Caw
Cawe
Cayman
Cebuano
Central
Ceturtd
Ceturtdiena
Ceuta
Cga
Ch
Ch1
Ch2
Ch3
Ch4
Chad
Chakma
Chanuari
Che
Chechen
Cherokee
Chg
Chickasaw
Chiga
Chiini
Chiki
Chikumi
Chikunguru
Chile
Chilo
China
Chinai
Chinese
Chipiri
Chiposi
Chishanu
Chitatu
Chivabvu
Chk
Chn
Choctaw
Choola
Choon
Chor
Chostiʼ
Chp
Chr
Chr.n
Christ
Christmas
Christo
Christus
Chrištmánet
Chrystowym
Chrìosta
Chríost
Chs
Cht
Chulai
Chumaine
Chumapiri
Chumatano
Chumatato
Church
Chuvash
Chv
Chw
Chwef
Chwefror
Cháykáhday
Cháykáhdaytiˀtiˀ
Chèitean
Chúa
Chủ
Ciise
Cio
Ciongo
Cis
Ciswà
City
Cka
Cko
Cla
Cmn
Cmt
Cocos
Cokcwaklaŋne
Cokcwaklii
Colognian
Colombia
Comgaisuu
Comkaldǝɓlii
Comkolle
Comlaaɗii
Comoros
Comzyeɓsuu
Comzyiiɗii
Com’yakke
Conflicts
Congo
Cook
Cornish
Corsican
Costa
Cpr
Cr
Crist
Cristo
Cristu
Cristus
Croatia
Croatian
Cs
Cte
Ctembeṛ
Ctt
Cuart
Cuba
Cul
Cum
Cuma
Cumartesi
Curaçao
Cuse
Cut
Cutanbir
Cya
Cyn
Cyprus
Cyrillic
Cze
Czech
Czechia
Czi
Cäŋ
Cèit
Cèitean
Céad
Céadaoin
Công
Côte
Cʼhwe
Cʼhwevrer
D
D-Ɔ
DAB
DAC
DAD
DAG
DAH
DAN
DAO
DAP
DAR
DAU
DEC
DESCRIPTION
DFómh
DGI
DIT
DK
DOC
DROLSKY
DROLSKY's
DS
Dabadii
Dahó
Dahósikah
Dal
Dam
Danish
Dat
Data
Date
DateTime
DateTime::Locale
DateTime::Locale::aa
DateTime::Locale::aa_DJ
DateTime::Locale::aa_ER
DateTime::Locale::aa_ET
DateTime::Locale::ab
DateTime::Locale::ab_GE
DateTime::Locale::af
DateTime::Locale::af_NA
DateTime::Locale::af_ZA
DateTime::Locale::agq
DateTime::Locale::agq_CM
DateTime::Locale::ak
DateTime::Locale::ak_GH
DateTime::Locale::am
DateTime::Locale::am_ET
DateTime::Locale::an
DateTime::Locale::an_ES
DateTime::Locale::ann
DateTime::Locale::ann_NG
DateTime::Locale::apc_SY
DateTime::Locale::ar
DateTime::Locale::ar_001
DateTime::Locale::ar_AE
DateTime::Locale::ar_BH
DateTime::Locale::ar_DJ
DateTime::Locale::ar_DZ
DateTime::Locale::ar_EG
DateTime::Locale::ar_EH
DateTime::Locale::ar_ER
DateTime::Locale::ar_IL
DateTime::Locale::ar_IQ
DateTime::Locale::ar_JO
DateTime::Locale::ar_KM
DateTime::Locale::ar_KW
DateTime::Locale::ar_LB
DateTime::Locale::ar_LY
DateTime::Locale::ar_MA
DateTime::Locale::ar_MR
DateTime::Locale::ar_OM
DateTime::Locale::ar_PS
DateTime::Locale::ar_QA
DateTime::Locale::ar_SA
DateTime::Locale::ar_SD
DateTime::Locale::ar_SO
DateTime::Locale::ar_SS
DateTime::Locale::ar_SY
DateTime::Locale::ar_TD
DateTime::Locale::ar_TN
DateTime::Locale::ar_YE
DateTime::Locale::arn
DateTime::Locale::arn_CL
DateTime::Locale::as
DateTime::Locale::as_IN
DateTime::Locale::asa
DateTime::Locale::asa_TZ
DateTime::Locale::ast
DateTime::Locale::ast_ES
DateTime::Locale::az
DateTime::Locale::az_Arab
DateTime::Locale::az_Arab_IQ
DateTime::Locale::az_Arab_IR
DateTime::Locale::az_Arab_TR
DateTime::Locale::az_Cyrl
DateTime::Locale::az_Cyrl_AZ
DateTime::Locale::az_Latn
DateTime::Locale::az_Latn_AZ
DateTime::Locale::ba
DateTime::Locale::ba_RU
DateTime::Locale::bal
DateTime::Locale::bal_Arab
DateTime::Locale::bal_Arab_PK
DateTime::Locale::bal_Latn
DateTime::Locale::bal_Latn_PK
DateTime::Locale::bas
DateTime::Locale::bas_CM
DateTime::Locale::be
DateTime::Locale::be_BY
DateTime::Locale::be_tarask
DateTime::Locale::bem
DateTime::Locale::bem_ZM
DateTime::Locale::bez
DateTime::Locale::bez_TZ
DateTime::Locale::bg
DateTime::Locale::bg_BG
DateTime::Locale::bgc
DateTime::Locale::bgc_IN
DateTime::Locale::bgn
DateTime::Locale::bgn_AE
DateTime::Locale::bgn_AF
DateTime::Locale::bgn_IR
DateTime::Locale::bgn_OM
DateTime::Locale::bgn_PK
DateTime::Locale::bho
DateTime::Locale::bho_IN
DateTime::Locale::blt
DateTime::Locale::blt_VN
DateTime::Locale::bm
DateTime::Locale::bm_ML
DateTime::Locale::bm_Nkoo
DateTime::Locale::bm_Nkoo_ML
DateTime::Locale::bn
DateTime::Locale::bn_BD
DateTime::Locale::bn_IN
DateTime::Locale::bo
DateTime::Locale::bo_CN
DateTime::Locale::bo_IN
DateTime::Locale::br
DateTime::Locale::br_FR
DateTime::Locale::brx
DateTime::Locale::brx_IN
DateTime::Locale::bs
DateTime::Locale::bs_Cyrl
DateTime::Locale::bs_Cyrl_BA
DateTime::Locale::bs_Latn
DateTime::Locale::bs_Latn_BA
DateTime::Locale::bss
DateTime::Locale::bss_CM
DateTime::Locale::byn
DateTime::Locale::byn_ER
DateTime::Locale::ca
DateTime::Locale::ca_AD
DateTime::Locale::ca_ES
DateTime::Locale::ca_ES_valencia
DateTime::Locale::ca_FR
DateTime::Locale::ca_IT
DateTime::Locale::cad
DateTime::Locale::cad_US
DateTime::Locale::cch
DateTime::Locale::cch_NG
DateTime::Locale::ccp
DateTime::Locale::ccp_BD
DateTime::Locale::ccp_IN
DateTime::Locale::ce
DateTime::Locale::ce_RU
DateTime::Locale::ceb
DateTime::Locale::ceb_PH
DateTime::Locale::cgg
DateTime::Locale::cgg_UG
DateTime::Locale::cho
DateTime::Locale::cho_US
DateTime::Locale::chr
DateTime::Locale::chr_US
DateTime::Locale::cic
DateTime::Locale::cic_US
DateTime::Locale::ckb
DateTime::Locale::ckb_IQ
DateTime::Locale::ckb_IR
DateTime::Locale::co
DateTime::Locale::co_FR
DateTime::Locale::cs
DateTime::Locale::cs_CZ
DateTime::Locale::cu
DateTime::Locale::cu_RU
DateTime::Locale::cv
DateTime::Locale::cv_RU
DateTime::Locale::cy
DateTime::Locale::cy_GB
DateTime::Locale::da
DateTime::Locale::da_DK
DateTime::Locale::da_GL
DateTime::Locale::dav
DateTime::Locale::dav_KE
DateTime::Locale::de
DateTime::Locale::de_AT
DateTime::Locale::de_BE
DateTime::Locale::de_CH
DateTime::Locale::de_DE
DateTime::Locale::de_IT
DateTime::Locale::de_LI
DateTime::Locale::de_LU
DateTime::Locale::dje
DateTime::Locale::dje_NE
DateTime::Locale::doi
DateTime::Locale::doi_IN
DateTime::Locale::dsb
DateTime::Locale::dsb_DE
DateTime::Locale::dua
DateTime::Locale::dua_CM
DateTime::Locale::dv
DateTime::Locale::dv_MV
DateTime::Locale::dyo
DateTime::Locale::dyo_SN
DateTime::Locale::dz
DateTime::Locale::dz_BT
DateTime::Locale::ebu
DateTime::Locale::ebu_KE
DateTime::Locale::ee
DateTime::Locale::ee_GH
DateTime::Locale::ee_TG
DateTime::Locale::el
DateTime::Locale::el_CY
DateTime::Locale::el_GR
DateTime::Locale::el_polyton
DateTime::Locale::en
DateTime::Locale::en_001
DateTime::Locale::en_150
DateTime::Locale::en_AE
DateTime::Locale::en_AG
DateTime::Locale::en_AI
DateTime::Locale::en_AS
DateTime::Locale::en_AT
DateTime::Locale::en_AU
DateTime::Locale::en_BB
DateTime::Locale::en_BE
DateTime::Locale::en_BI
DateTime::Locale::en_BM
DateTime::Locale::en_BS
DateTime::Locale::en_BW
DateTime::Locale::en_BZ
DateTime::Locale::en_CA
DateTime::Locale::en_CC
DateTime::Locale::en_CH
DateTime::Locale::en_CK
DateTime::Locale::en_CM
DateTime::Locale::en_CX
DateTime::Locale::en_CY
DateTime::Locale::en_DE
DateTime::Locale::en_DG
DateTime::Locale::en_DK
DateTime::Locale::en_DM
DateTime::Locale::en_Dsrt
DateTime::Locale::en_Dsrt_US
DateTime::Locale::en_ER
DateTime::Locale::en_FI
DateTime::Locale::en_FJ
DateTime::Locale::en_FK
DateTime::Locale::en_FM
DateTime::Locale::en_GB
DateTime::Locale::en_GD
DateTime::Locale::en_GG
DateTime::Locale::en_GH
DateTime::Locale::en_GI
DateTime::Locale::en_GM
DateTime::Locale::en_GU
DateTime::Locale::en_GY
DateTime::Locale::en_HK
DateTime::Locale::en_IE
DateTime::Locale::en_IL
DateTime::Locale::en_IM
DateTime::Locale::en_IN
DateTime::Locale::en_IO
DateTime::Locale::en_JE
DateTime::Locale::en_JM
DateTime::Locale::en_KE
DateTime::Locale::en_KI
DateTime::Locale::en_KN
DateTime::Locale::en_KY
DateTime::Locale::en_LC
DateTime::Locale::en_LR
DateTime::Locale::en_LS
DateTime::Locale::en_MG
DateTime::Locale::en_MH
DateTime::Locale::en_MO
DateTime::Locale::en_MP
DateTime::Locale::en_MS
DateTime::Locale::en_MT
DateTime::Locale::en_MU
DateTime::Locale::en_MV
DateTime::Locale::en_MW
DateTime::Locale::en_MY
DateTime::Locale::en_NA
DateTime::Locale::en_NF
DateTime::Locale::en_NG
DateTime::Locale::en_NL
DateTime::Locale::en_NR
DateTime::Locale::en_NU
DateTime::Locale::en_NZ
DateTime::Locale::en_PG
DateTime::Locale::en_PH
DateTime::Locale::en_PK
DateTime::Locale::en_PN
DateTime::Locale::en_PR
DateTime::Locale::en_PW
DateTime::Locale::en_RW
DateTime::Locale::en_SB
DateTime::Locale::en_SC
DateTime::Locale::en_SD
DateTime::Locale::en_SE
DateTime::Locale::en_SG
DateTime::Locale::en_SH
DateTime::Locale::en_SI
DateTime::Locale::en_SL
DateTime::Locale::en_SS
DateTime::Locale::en_SX
DateTime::Locale::en_SZ
DateTime::Locale::en_Shaw
DateTime::Locale::en_Shaw_GB
DateTime::Locale::en_TC
DateTime::Locale::en_TK
DateTime::Locale::en_TO
DateTime::Locale::en_TT
DateTime::Locale::en_TV
DateTime::Locale::en_TZ
DateTime::Locale::en_UG
DateTime::Locale::en_UM
DateTime::Locale::en_US
DateTime::Locale::en_VC
DateTime::Locale::en_VG
DateTime::Locale::en_VI
DateTime::Locale::en_VU
DateTime::Locale::en_WS
DateTime::Locale::en_ZA
DateTime::Locale::en_ZM
DateTime::Locale::en_ZW
DateTime::Locale::eo
DateTime::Locale::eo_001
DateTime::Locale::es
DateTime::Locale::es_419
DateTime::Locale::es_AR
DateTime::Locale::es_BO
DateTime::Locale::es_BR
DateTime::Locale::es_BZ
DateTime::Locale::es_CL
DateTime::Locale::es_CO
DateTime::Locale::es_CR
DateTime::Locale::es_CU
DateTime::Locale::es_DO
DateTime::Locale::es_EA
DateTime::Locale::es_EC
DateTime::Locale::es_ES
DateTime::Locale::es_GQ
DateTime::Locale::es_GT
DateTime::Locale::es_HN
DateTime::Locale::es_IC
DateTime::Locale::es_MX
DateTime::Locale::es_NI
DateTime::Locale::es_PA
DateTime::Locale::es_PE
DateTime::Locale::es_PH
DateTime::Locale::es_PR
DateTime::Locale::es_PY
DateTime::Locale::es_SV
DateTime::Locale::es_US
DateTime::Locale::es_UY
DateTime::Locale::es_VE
DateTime::Locale::et
DateTime::Locale::et_EE
DateTime::Locale::eu
DateTime::Locale::eu_ES
DateTime::Locale::ewo
DateTime::Locale::ewo_CM
DateTime::Locale::fa
DateTime::Locale::fa_AF
DateTime::Locale::fa_IR
DateTime::Locale::ff
DateTime::Locale::ff_Adlm
DateTime::Locale::ff_Adlm_BF
DateTime::Locale::ff_Adlm_CM
DateTime::Locale::ff_Adlm_GH
DateTime::Locale::ff_Adlm_GM
DateTime::Locale::ff_Adlm_GN
DateTime::Locale::ff_Adlm_GW
DateTime::Locale::ff_Adlm_LR
DateTime::Locale::ff_Adlm_MR
DateTime::Locale::ff_Adlm_NE
DateTime::Locale::ff_Adlm_NG
DateTime::Locale::ff_Adlm_SL
DateTime::Locale::ff_Adlm_SN
DateTime::Locale::ff_Latn
DateTime::Locale::ff_Latn_BF
DateTime::Locale::ff_Latn_CM
DateTime::Locale::ff_Latn_GH
DateTime::Locale::ff_Latn_GM
DateTime::Locale::ff_Latn_GN
DateTime::Locale::ff_Latn_GW
DateTime::Locale::ff_Latn_LR
DateTime::Locale::ff_Latn_MR
DateTime::Locale::ff_Latn_NE
DateTime::Locale::ff_Latn_NG
DateTime::Locale::ff_Latn_SL
DateTime::Locale::ff_Latn_SN
DateTime::Locale::fi
DateTime::Locale::fi_FI
DateTime::Locale::fil
DateTime::Locale::fil_PH
DateTime::Locale::fo
DateTime::Locale::fo_DK
DateTime::Locale::fo_FO
DateTime::Locale::fr
DateTime::Locale::fr_BE
DateTime::Locale::fr_BF
DateTime::Locale::fr_BI
DateTime::Locale::fr_BJ
DateTime::Locale::fr_BL
DateTime::Locale::fr_CA
DateTime::Locale::fr_CD
DateTime::Locale::fr_CF
DateTime::Locale::fr_CG
DateTime::Locale::fr_CH
DateTime::Locale::fr_CI
DateTime::Locale::fr_CM
DateTime::Locale::fr_DJ
DateTime::Locale::fr_DZ
DateTime::Locale::fr_FR
DateTime::Locale::fr_GA
DateTime::Locale::fr_GF
DateTime::Locale::fr_GN
DateTime::Locale::fr_GP
DateTime::Locale::fr_GQ
DateTime::Locale::fr_HT
DateTime::Locale::fr_KM
DateTime::Locale::fr_LU
DateTime::Locale::fr_MA
DateTime::Locale::fr_MC
DateTime::Locale::fr_MF
DateTime::Locale::fr_MG
DateTime::Locale::fr_ML
DateTime::Locale::fr_MQ
DateTime::Locale::fr_MR
DateTime::Locale::fr_MU
DateTime::Locale::fr_NC
DateTime::Locale::fr_NE
DateTime::Locale::fr_PF
DateTime::Locale::fr_PM
DateTime::Locale::fr_RE
DateTime::Locale::fr_RW
DateTime::Locale::fr_SC
DateTime::Locale::fr_SN
DateTime::Locale::fr_SY
DateTime::Locale::fr_TD
DateTime::Locale::fr_TG
DateTime::Locale::fr_TN
DateTime::Locale::fr_VU
DateTime::Locale::fr_WF
DateTime::Locale::fr_YT
DateTime::Locale::frr
DateTime::Locale::frr_DE
DateTime::Locale::fur
DateTime::Locale::fur_IT
DateTime::Locale::fy
DateTime::Locale::fy_NL
DateTime::Locale::ga
DateTime::Locale::ga_GB
DateTime::Locale::ga_IE
DateTime::Locale::gaa
DateTime::Locale::gaa_GH
DateTime::Locale::gd
DateTime::Locale::gd_GB
DateTime::Locale::gez
DateTime::Locale::gez_ER
DateTime::Locale::gez_ET
DateTime::Locale::gl
DateTime::Locale::gl_ES
DateTime::Locale::gn
DateTime::Locale::gn_PY
DateTime::Locale::gsw
DateTime::Locale::gsw_CH
DateTime::Locale::gsw_FR
DateTime::Locale::gsw_LI
DateTime::Locale::gu
DateTime::Locale::gu_IN
DateTime::Locale::guz
DateTime::Locale::guz_KE
DateTime::Locale::gv
DateTime::Locale::gv_IM
DateTime::Locale::ha
DateTime::Locale::ha_Arab
DateTime::Locale::ha_Arab_NG
DateTime::Locale::ha_Arab_SD
DateTime::Locale::ha_GH
DateTime::Locale::ha_NE
DateTime::Locale::ha_NG
DateTime::Locale::haw
DateTime::Locale::haw_US
DateTime::Locale::he
DateTime::Locale::he_IL
DateTime::Locale::hi
DateTime::Locale::hi_IN
DateTime::Locale::hi_Latn
DateTime::Locale::hi_Latn_IN
DateTime::Locale::hnj
DateTime::Locale::hnj_Hmnp
DateTime::Locale::hnj_Hmnp_US
DateTime::Locale::hr
DateTime::Locale::hr_BA
DateTime::Locale::hr_HR
DateTime::Locale::hsb
DateTime::Locale::hsb_DE
DateTime::Locale::hu
DateTime::Locale::hu_HU
DateTime::Locale::hy
DateTime::Locale::hy_AM
DateTime::Locale::ia
DateTime::Locale::ia_001
DateTime::Locale::id
DateTime::Locale::id_ID
DateTime::Locale::ig
DateTime::Locale::ig_NG
DateTime::Locale::ii
DateTime::Locale::ii_CN
DateTime::Locale::io
DateTime::Locale::io_001
DateTime::Locale::is
DateTime::Locale::is_IS
DateTime::Locale::it
DateTime::Locale::it_CH
DateTime::Locale::it_IT
DateTime::Locale::it_SM
DateTime::Locale::it_VA
DateTime::Locale::iu
DateTime::Locale::iu_CA
DateTime::Locale::iu_Latn
DateTime::Locale::iu_Latn_CA
DateTime::Locale::ja
DateTime::Locale::ja_JP
DateTime::Locale::jbo
DateTime::Locale::jbo_001
DateTime::Locale::jgo
DateTime::Locale::jgo_CM
DateTime::Locale::jmc
DateTime::Locale::jmc_TZ
DateTime::Locale::jv
DateTime::Locale::jv_ID
DateTime::Locale::ka
DateTime::Locale::ka_GE
DateTime::Locale::kab
DateTime::Locale::kab_DZ
DateTime::Locale::kaj
DateTime::Locale::kaj_NG
DateTime::Locale::kam
DateTime::Locale::kam_KE
DateTime::Locale::kcg
DateTime::Locale::kcg_NG
DateTime::Locale::kde
DateTime::Locale::kde_TZ
DateTime::Locale::kea
DateTime::Locale::kea_CV
DateTime::Locale::ken
DateTime::Locale::ken_CM
DateTime::Locale::kgp
DateTime::Locale::kgp_BR
DateTime::Locale::khq
DateTime::Locale::khq_ML
DateTime::Locale::ki
DateTime::Locale::ki_KE
DateTime::Locale::kk
DateTime::Locale::kk_KZ
DateTime::Locale::kkj
DateTime::Locale::kkj_CM
DateTime::Locale::kl
DateTime::Locale::kl_GL
DateTime::Locale::kln
DateTime::Locale::kln_KE
DateTime::Locale::km
DateTime::Locale::km_KH
DateTime::Locale::kn
DateTime::Locale::kn_IN
DateTime::Locale::ko
DateTime::Locale::ko_KP
DateTime::Locale::ko_KR
DateTime::Locale::kok
DateTime::Locale::kok_IN
DateTime::Locale::kpe
DateTime::Locale::kpe_GN
DateTime::Locale::kpe_LR
DateTime::Locale::ks
DateTime::Locale::ks_Arab
DateTime::Locale::ks_Arab_IN
DateTime::Locale::ks_Deva
DateTime::Locale::ks_Deva_IN
DateTime::Locale::ksb
DateTime::Locale::ksb_TZ
DateTime::Locale::ksf
DateTime::Locale::ksf_CM
DateTime::Locale::ksh
DateTime::Locale::ksh_DE
DateTime::Locale::ku
DateTime::Locale::ku_TR
DateTime::Locale::kw
DateTime::Locale::kw_GB
DateTime::Locale::ky
DateTime::Locale::ky_KG
DateTime::Locale::la
DateTime::Locale::la_VA
DateTime::Locale::lag
DateTime::Locale::lag_TZ
DateTime::Locale::lb
DateTime::Locale::lb_LU
DateTime::Locale::lg
DateTime::Locale::lg_UG
DateTime::Locale::lij
DateTime::Locale::lij_IT
DateTime::Locale::lkt
DateTime::Locale::lkt_US
DateTime::Locale::lmo
DateTime::Locale::lmo_IT
DateTime::Locale::ln
DateTime::Locale::ln_AO
DateTime::Locale::ln_CD
DateTime::Locale::ln_CF
DateTime::Locale::ln_CG
DateTime::Locale::lo
DateTime::Locale::lo_LA
DateTime::Locale::lrc
DateTime::Locale::lrc_IQ
DateTime::Locale::lrc_IR
DateTime::Locale::lt
DateTime::Locale::lt_LT
DateTime::Locale::lu
DateTime::Locale::lu_CD
DateTime::Locale::luo
DateTime::Locale::luo_KE
DateTime::Locale::luy
DateTime::Locale::luy_KE
DateTime::Locale::lv
DateTime::Locale::lv_LV
DateTime::Locale::mai
DateTime::Locale::mai_IN
DateTime::Locale::mas
DateTime::Locale::mas_KE
DateTime::Locale::mas_TZ
DateTime::Locale::mdf
DateTime::Locale::mdf_RU
DateTime::Locale::mer
DateTime::Locale::mer_KE
DateTime::Locale::mfe
DateTime::Locale::mfe_MU
DateTime::Locale::mg
DateTime::Locale::mg_MG
DateTime::Locale::mgh
DateTime::Locale::mgh_MZ
DateTime::Locale::mgo
DateTime::Locale::mgo_CM
DateTime::Locale::mi
DateTime::Locale::mi_NZ
DateTime::Locale::mk
DateTime::Locale::mk_MK
DateTime::Locale::ml
DateTime::Locale::ml_IN
DateTime::Locale::mn
DateTime::Locale::mn_MN
DateTime::Locale::mn_Mong
DateTime::Locale::mn_Mong_CN
DateTime::Locale::mn_Mong_MN
DateTime::Locale::mni
DateTime::Locale::mni_Beng
DateTime::Locale::mni_Beng_IN
DateTime::Locale::mni_Mtei
DateTime::Locale::mni_Mtei_IN
DateTime::Locale::moh
DateTime::Locale::moh_CA
DateTime::Locale::mr
DateTime::Locale::mr_IN
DateTime::Locale::ms
DateTime::Locale::ms_Arab
DateTime::Locale::ms_Arab_BN
DateTime::Locale::ms_Arab_MY
DateTime::Locale::ms_BN
DateTime::Locale::ms_ID
DateTime::Locale::ms_MY
DateTime::Locale::ms_SG
DateTime::Locale::mt
DateTime::Locale::mt_MT
DateTime::Locale::mua
DateTime::Locale::mua_CM
DateTime::Locale::mus
DateTime::Locale::mus_US
DateTime::Locale::my
DateTime::Locale::my_MM
DateTime::Locale::myv
DateTime::Locale::myv_RU
DateTime::Locale::mzn
DateTime::Locale::mzn_IR
DateTime::Locale::naq
DateTime::Locale::naq_NA
DateTime::Locale::nb
DateTime::Locale::nb_NO
DateTime::Locale::nb_SJ
DateTime::Locale::nd
DateTime::Locale::nd_ZW
DateTime::Locale::nds
DateTime::Locale::nds_DE
DateTime::Locale::nds_NL
DateTime::Locale::ne
DateTime::Locale::ne_IN
DateTime::Locale::ne_NP
DateTime::Locale::nl
DateTime::Locale::nl_AW
DateTime::Locale::nl_BE
DateTime::Locale::nl_BQ
DateTime::Locale::nl_CW
DateTime::Locale::nl_NL
DateTime::Locale::nl_SR
DateTime::Locale::nl_SX
DateTime::Locale::nmg
DateTime::Locale::nmg_CM
DateTime::Locale::nn
DateTime::Locale::nn_NO
DateTime::Locale::nnh
DateTime::Locale::nnh_CM
DateTime::Locale::no
DateTime::Locale::nqo
DateTime::Locale::nqo_GN
DateTime::Locale::nr
DateTime::Locale::nr_ZA
DateTime::Locale::nso
DateTime::Locale::nso_ZA
DateTime::Locale::nus
DateTime::Locale::nus_SS
DateTime::Locale::nv
DateTime::Locale::nv_US
DateTime::Locale::ny
DateTime::Locale::ny_MW
DateTime::Locale::nyn
DateTime::Locale::nyn_UG
DateTime::Locale::oc
DateTime::Locale::oc_ES
DateTime::Locale::oc_FR
DateTime::Locale::om
DateTime::Locale::om_ET
DateTime::Locale::om_KE
DateTime::Locale::or
DateTime::Locale::or_IN
DateTime::Locale::os
DateTime::Locale::os_GE
DateTime::Locale::os_RU
DateTime::Locale::osa
DateTime::Locale::osa_US
DateTime::Locale::pa
DateTime::Locale::pa_Arab
DateTime::Locale::pa_Arab_PK
DateTime::Locale::pa_Guru
DateTime::Locale::pa_Guru_IN
DateTime::Locale::pap
DateTime::Locale::pap_AW
DateTime::Locale::pap_CW
DateTime::Locale::pcm
DateTime::Locale::pcm_NG
DateTime::Locale::pis
DateTime::Locale::pis_SB
DateTime::Locale::pl
DateTime::Locale::pl_PL
DateTime::Locale::prg
DateTime::Locale::prg_001
DateTime::Locale::ps
DateTime::Locale::ps_AF
DateTime::Locale::ps_PK
DateTime::Locale::pt
DateTime::Locale::pt_AO
DateTime::Locale::pt_BR
DateTime::Locale::pt_CH
DateTime::Locale::pt_CV
DateTime::Locale::pt_GQ
DateTime::Locale::pt_GW
DateTime::Locale::pt_LU
DateTime::Locale::pt_MO
DateTime::Locale::pt_MZ
DateTime::Locale::pt_PT
DateTime::Locale::pt_ST
DateTime::Locale::pt_TL
DateTime::Locale::qu
DateTime::Locale::qu_BO
DateTime::Locale::qu_EC
DateTime::Locale::qu_PE
DateTime::Locale::quc
DateTime::Locale::quc_GT
DateTime::Locale::raj
DateTime::Locale::raj_IN
DateTime::Locale::rhg
DateTime::Locale::rhg_Rohg
DateTime::Locale::rhg_Rohg_BD
DateTime::Locale::rhg_Rohg_MM
DateTime::Locale::rif
DateTime::Locale::rif_MA
DateTime::Locale::rm
DateTime::Locale::rm_CH
DateTime::Locale::rn
DateTime::Locale::rn_BI
DateTime::Locale::ro
DateTime::Locale::ro_MD
DateTime::Locale::ro_RO
DateTime::Locale::rof
DateTime::Locale::rof_TZ
DateTime::Locale::ru
DateTime::Locale::ru_BY
DateTime::Locale::ru_KG
DateTime::Locale::ru_KZ
DateTime::Locale::ru_MD
DateTime::Locale::ru_RU
DateTime::Locale::ru_UA
DateTime::Locale::rw
DateTime::Locale::rw_RW
DateTime::Locale::rwk
DateTime::Locale::rwk_TZ
DateTime::Locale::sa
DateTime::Locale::sa_IN
DateTime::Locale::sah
DateTime::Locale::sah_RU
DateTime::Locale::saq
DateTime::Locale::saq_KE
DateTime::Locale::sat
DateTime::Locale::sat_Deva
DateTime::Locale::sat_Deva_IN
DateTime::Locale::sat_Olck
DateTime::Locale::sat_Olck_IN
DateTime::Locale::sbp
DateTime::Locale::sbp_TZ
DateTime::Locale::sc
DateTime::Locale::sc_IT
DateTime::Locale::scn
DateTime::Locale::scn_IT
DateTime::Locale::sd
DateTime::Locale::sd_Arab
DateTime::Locale::sd_Arab_PK
DateTime::Locale::sd_Deva
DateTime::Locale::sd_Deva_IN
DateTime::Locale::sdh
DateTime::Locale::sdh_IQ
DateTime::Locale::sdh_IR
DateTime::Locale::se
DateTime::Locale::se_FI
DateTime::Locale::se_NO
DateTime::Locale::se_SE
DateTime::Locale::seh
DateTime::Locale::seh_MZ
DateTime::Locale::ses
DateTime::Locale::ses_ML
DateTime::Locale::sg
DateTime::Locale::sg_CF
DateTime::Locale::shi
DateTime::Locale::shi_Latn
DateTime::Locale::shi_Latn_MA
DateTime::Locale::shi_Tfng
DateTime::Locale::shi_Tfng_MA
DateTime::Locale::shn
DateTime::Locale::shn_MM
DateTime::Locale::shn_TH
DateTime::Locale::si
DateTime::Locale::si_LK
DateTime::Locale::sid
DateTime::Locale::sid_ET
DateTime::Locale::sk
DateTime::Locale::sk_SK
DateTime::Locale::sl
DateTime::Locale::sl_SI
DateTime::Locale::sma
DateTime::Locale::sma_NO
DateTime::Locale::sma_SE
DateTime::Locale::smj
DateTime::Locale::smj_NO
DateTime::Locale::smj_SE
DateTime::Locale::smn
DateTime::Locale::smn_FI
DateTime::Locale::sms
DateTime::Locale::sms_FI
DateTime::Locale::sn
DateTime::Locale::sn_ZW
DateTime::Locale::so
DateTime::Locale::so_DJ
DateTime::Locale::so_ET
DateTime::Locale::so_KE
DateTime::Locale::so_SO
DateTime::Locale::sq
DateTime::Locale::sq_AL
DateTime::Locale::sq_MK
DateTime::Locale::sq_XK
DateTime::Locale::sr
DateTime::Locale::sr_Cyrl
DateTime::Locale::sr_Cyrl_BA
DateTime::Locale::sr_Cyrl_ME
DateTime::Locale::sr_Cyrl_RS
DateTime::Locale::sr_Cyrl_XK
DateTime::Locale::sr_Latn
DateTime::Locale::sr_Latn_BA
DateTime::Locale::sr_Latn_ME
DateTime::Locale::sr_Latn_RS
DateTime::Locale::sr_Latn_XK
DateTime::Locale::ss
DateTime::Locale::ss_SZ
DateTime::Locale::ss_ZA
DateTime::Locale::ssy
DateTime::Locale::ssy_ER
DateTime::Locale::st
DateTime::Locale::st_LS
DateTime::Locale::st_ZA
DateTime::Locale::su
DateTime::Locale::su_Latn
DateTime::Locale::su_Latn_ID
DateTime::Locale::sv
DateTime::Locale::sv_AX
DateTime::Locale::sv_FI
DateTime::Locale::sv_SE
DateTime::Locale::sw
DateTime::Locale::sw_CD
DateTime::Locale::sw_KE
DateTime::Locale::sw_TZ
DateTime::Locale::sw_UG
DateTime::Locale::syr
DateTime::Locale::syr_IQ
DateTime::Locale::syr_SY
DateTime::Locale::szl
DateTime::Locale::szl_PL
DateTime::Locale::ta
DateTime::Locale::ta_IN
DateTime::Locale::ta_LK
DateTime::Locale::ta_MY
DateTime::Locale::ta_SG
DateTime::Locale::te
DateTime::Locale::te_IN
DateTime::Locale::teo
DateTime::Locale::teo_KE
DateTime::Locale::teo_UG
DateTime::Locale::tg
DateTime::Locale::tg_TJ
DateTime::Locale::th
DateTime::Locale::th_TH
DateTime::Locale::ti
DateTime::Locale::ti_ER
DateTime::Locale::ti_ET
DateTime::Locale::tig
DateTime::Locale::tig_ER
DateTime::Locale::tk
DateTime::Locale::tk_TM
DateTime::Locale::tn
DateTime::Locale::tn_BW
DateTime::Locale::tn_ZA
DateTime::Locale::to
DateTime::Locale::to_TO
DateTime::Locale::tok
DateTime::Locale::tok_001
DateTime::Locale::tpi
DateTime::Locale::tpi_PG
DateTime::Locale::tr
DateTime::Locale::tr_CY
DateTime::Locale::tr_TR
DateTime::Locale::trv
DateTime::Locale::trv_TW
DateTime::Locale::trw
DateTime::Locale::trw_PK
DateTime::Locale::ts
DateTime::Locale::ts_ZA
DateTime::Locale::tt
DateTime::Locale::tt_RU
DateTime::Locale::twq
DateTime::Locale::twq_NE
DateTime::Locale::tzm
DateTime::Locale::tzm_MA
DateTime::Locale::ug
DateTime::Locale::ug_CN
DateTime::Locale::uk
DateTime::Locale::uk_UA
DateTime::Locale::und
DateTime::Locale::ur
DateTime::Locale::ur_IN
DateTime::Locale::ur_PK
DateTime::Locale::uz
DateTime::Locale::uz_Arab
DateTime::Locale::uz_Arab_AF
DateTime::Locale::uz_Cyrl
DateTime::Locale::uz_Cyrl_UZ
DateTime::Locale::uz_Latn
DateTime::Locale::uz_Latn_UZ
DateTime::Locale::vai
DateTime::Locale::vai_Latn
DateTime::Locale::vai_Latn_LR
DateTime::Locale::vai_Vaii
DateTime::Locale::vai_Vaii_LR
DateTime::Locale::ve
DateTime::Locale::ve_ZA
DateTime::Locale::vec
DateTime::Locale::vec_IT
DateTime::Locale::vi
DateTime::Locale::vi_VN
DateTime::Locale::vo
DateTime::Locale::vo_001
DateTime::Locale::vun
DateTime::Locale::vun_TZ
DateTime::Locale::wa
DateTime::Locale::wa_BE
DateTime::Locale::wae
DateTime::Locale::wae_CH
DateTime::Locale::wal
DateTime::Locale::wal_ET
DateTime::Locale::wbp
DateTime::Locale::wbp_AU
DateTime::Locale::wo
DateTime::Locale::wo_SN
DateTime::Locale::xh
DateTime::Locale::xh_ZA
DateTime::Locale::xog
DateTime::Locale::xog_UG
DateTime::Locale::yav
DateTime::Locale::yav_CM
DateTime::Locale::yi
DateTime::Locale::yi_001
DateTime::Locale::yo
DateTime::Locale::yo_BJ
DateTime::Locale::yo_NG
DateTime::Locale::yrl
DateTime::Locale::yrl_BR
DateTime::Locale::yrl_CO
DateTime::Locale::yrl_VE
DateTime::Locale::yue
DateTime::Locale::yue_Hans
DateTime::Locale::yue_Hans_CN
DateTime::Locale::yue_Hant
DateTime::Locale::yue_Hant_HK
DateTime::Locale::zgh
DateTime::Locale::zgh_MA
DateTime::Locale::zh
DateTime::Locale::zh_Hans
DateTime::Locale::zh_Hans_CN
DateTime::Locale::zh_Hans_HK
DateTime::Locale::zh_Hans_MO
DateTime::Locale::zh_Hans_SG
DateTime::Locale::zh_Hant
DateTime::Locale::zh_Hant_HK
DateTime::Locale::zh_Hant_MO
DateTime::Locale::zh_Hant_TW
DateTime::Locale::zu
DateTime::Locale::zu_ZA
Datetime
Dave
Days
De
Dec
Dec,1995
December
Decembro
Dee
Deesanbur
Deireadh
Dek
Dekabr
Denmark
Denstaxtsees
Des
Desambra
Desemba
Desember
Deseret
Desimber
Desàmbar
Desèmber
Devanagari
Dez
Dezember
Dezämber
Dheengadda
Dhieec
Dhieec،
Di
DiC
DiCiadain
DiD
DiDòmhnaich
DiL
DiLuain
DiM
DiMàirt
DiS
DiSathairne
Dia
DiarDaoin
Dib
Diba
Dibatsela
Dibo
Dibokwane
Dibéer
Dic
Dicemba
Dicembar
Diciembre
Diego
Dienstag
Difuu-Ɔsandaa
Dih
DihAoine
Dil
Dilbata
Dilolo
Dim
Dimas
Dimingu
Dinda
Dingsdag
Dinnsdaach
Dinsdag
Dip
Dipha
Diphalane
Dis
Disamba
Disambar
Diseembar
Disemba
Disember
Dissik’an
Disyembre
Disẹ́mba
Divehi
Diz
Dizenbru
Diċ
Diċembru
Diɔ̱k
Djibouti
Do
Dogri
Dom
Domh
Domhnaigh
Domingo
Domini
Dominica
Dominican
Don
Donderdag
Dondertaxtsees
Donnerstag
Donneschdeg
Doy
Drugi
Du
Duala
Duj
Dujanbir
Dum
Dun
Dunnersdaach
Dunnersdag
Dunschtig
Dush
Dutch
Duä
Duät
Duş
Duşenbe
Duǧ
Duǧembeṛ
Duɔ̱ɔ̱
Duɔ̱ɔ̱ŋ
Dwe
Dwo
Dwowda
Dydd
Dzi
Dzivamisoko
Dzongkha
Dàmh
Dàmhair
Dé
Déar
Déardaoin
Dés
Désémber
Dën
Dënschdeg
Dìpɔ̀s
Dùbh
Dùbhlachd
Dċ
Dǝɓlii
Dʼar
E
E-K
E-O
E-Ɔ
E1
E2
E3
E4
EA
EBh:mm
EBh:mm:ss
EBhm
EBhms
EEE
EEEE
EEEEd
EEEE،
EEEEที่
EHH:mm
EHH:mm:ss
EHm
EHms
EW
EY
Eah:mm
Eah:mm:ss
Ean
Eanáir
Ebisera
Ebongi
Ebr
Ebrel
Ebrill
Ebɔbira-Oforisuo
Ebɔw-Ɔbenem
Ecuador
Ed
Eg
Egypt
Ehm
Ehm-alt-ascii
Ehms
Ehms-alt-ascii
Ehole
Eigulo
Eki
Ekim
Ekyiri
El
Elb
Elba
Embu
Emirates
Ene
Enero
English
Enhvteceskv
Enhvyvtke
Ennvrkvpv
Eost
Epe
Epeeso
Eph
Ephreli
Epr
Epreel
Eprel
Epreli
Epreo
Epril
Equatorial
Er
Eras
Erb
Eritrea
Erobo
Erzya
Esabato
Esperanto
Est
Estonia
Estonian
Esusow
Eswatini
Etheridge
Ethiopia
Europe
Ewe
Ewondo
Eyl
Eylül
Eínō
E،
E፣
E⹁
F
F-Ɛ
F1
F2
F3
F4
F4–1
F4–2
F4–3
F4–4
F5
FB
FDE
FEB
FGW
FLO
FMF
FMU
FYU
Fab
Faburairu
Fal
Falaite
Falkland
Fankwa-Ɛbɔ
Faoi
Faoilleach
Faroe
Faroese
Faso
Fe
Feabh
Feabhra
Feb
Feb,2008
Febluali
Febraayo
Febrero
Febreru
Febrewaris
Febroary
Februaar
Februar
Februari
Februarie
Februaro
February
Februeri
Februwari
Febrüari
Febrụwarị
Febuare
Feburari
Feburuarĩ
Febwaliyo
Fee
Feewiriye
Fer
Ferikgong
Fev
Fevral
Fevreiro
Fevrâr
Few
Fewral
Fewriyee
Fhaoilleach
Fia
Fida
Fiji
Filipino
Finland
Finnish
Foar
Fonde
Formats
Fr
Fra
Fraede
Fraide
Fraitaxtsees
France
Frar
Fraí
Fraídè
Fraị
Fraịdee
Fre
Freedag
Freideg
Freitag
French
Fri
Friday
Friidaach
Friitig
Frisian
Fritag
Friulian
Fri،
Fri፡
Fri፣
Fri፥M12፡22፡መዓልት፡1995፡09:05:02
FromData
Fró
Fróntag
Ful
Fula
Full
Fulundïgi
Fur
Futuna
Fuulbana
Fuṛar
Fângbisïö
Fäb
Fäbrowa
Fébirie
Fómhair
Fön
Föndo
Fúngatɨ
Fēp
Fēpueli
Fĩi
Fɛ
Fɛlâyɛdɛ
Fẹ́b
Fẹ́búári
Fẹ́st
Fọ́t
G
GD
GGGG
GGGGG
GH
GN
Ga
Gabon
Gaelic
Galician
Gamaǀaeb
Gambia
Gan
Ganda
Garcia
Gas
Gashyantare
Gat
Gearr
Gearran
Geez
Gen
Genver
Georgia
Georgian
German
Germany
Ghana
Ghearran
Ghiblean
Gibl
Giblean
Gibraltar
Gic
Gicurasi
Gitugutu
Giáng
Gor
Gorff
Gorffennaf
Gortheren
Goue
Gouere
Greece
Greek
Greenland
Grenada
Grenadines
Gu
Guadeloupe
Guak
Guam
Guarani
Guatemala
Guernsey
Guiana
Guinea
Guinea-Bissau
Gujarati
Gum
Gumiguru
Gun
Gunyana
Gur
Guraandhala
Gurmukhi
Guru
Guruwaar
Gusii
Guyana
Gwahlle
Gwe
Gwen
Gwener
Gwengolo
Gwn
Gwynngala
Gy
Gy/M/d
GyM
GyMMM
GyMMMEEEEd
GyMMMEd
GyMMMM
GyMMMMEd
GyMMMMd
GyMMMd
GyMd
Gy年
Gy年M月
Gy年M月d日
Gy年M月d日(E
Gy年M月d日E
Gy年M月d日EEEE
Gís
H
H-I
H.mm
H.mm.ss
H.mm:ss
H:mm
H:mm:ss
HH
HH'h
HH'h'mm
HH.mm
HH.mm.ss
HH:mm
HH:mm:ss
HH:mm:ss;
HH:mm;
HHmm
HHmmZ
HHmmss
HW1
HW2
HW3
HW4
HY
HYV
Hade
Hafi
Hag
Hagayya
Hai
Haiti
Han
Hanifi
Hant
Har
Haryanvi
Hashiʼ
Hausa
Hauwhā
Hawaiian
Haz
Haziran
Haˀimay
Hebrew
Hed
Hedra
Hei
Heiwet
Helena
Hep
Hepetema
Her
Herbštmánet
Here
Herzegovina
Hid
Hih
Hinapiya
Hindi
Hit
Hiv
Hiwí
Hiyo
Hiyuce
Hl
Hla
Hlak
Hlakola
Hlakubele
Hm
Hmm
Hmong
Hms
Hmsv
Hmsvvvv
Hmv
Hmvvvv
Holloʼ
Honduras
Hong
Hor
Hornig
Hortii
Hotvle
Houney
Hristos
Huk
Hukuri
Hul
Hulyo
Hun
Hune
Hungarian
Hungary
Hunyo
Hut
Huw
Huwebes
Hvse
Hwaĩ-inĩ
Hwe
Hwevrer
Hyd
Hydref
Háshnih
Háshnihtiˀtiˀ
Háshnihtsiˀ
Hìkaŋ
Hìlòndɛ̀
Híisikah
Hôasoreǁkhâb
Hān
Hānuere
Hūr
Hūrae
H时
H時
H시
I
I1
I2
I3
I4
I6
I8
IA1
IA2
IA3
IA4
II
II-lea
II/05
III
III-lea
IJ
ISonto
IV
IV-lea
IX
IX/15
IY
IZ
Ian
Ianuali
Iau
Ibr
Ibrir
Iceland
Icelandic
Ichuma
Icm
Ido
Idwaata
Igbo
Igi
Igice
Iiplal
Iisa
Ij
Ijm
Ijn
Ijp
Ijt
Ijtn
Iju
Ijumaa
Ijumamosi
Ijumanne
Ijumapili
Ijumatano
Ijumatatu
Ijumáa
Ijĩrĩ
Ike
Iku
Ikúmi
Il-Ġimgħa
Il-Ħadd
Il-Ħamis
Ile
Im
Imb
Imberi
Ime
Imir
Imw
Inari
India
Indian
Indonesia
Indonesian
Ine
Inikuˀ
Inikuˀtiˀtiˀ
Interlingua
Inuktitut
Inya
Inyambala
Inyi
Ion
Ionawr
Iran
Iraq
Ireland
Irish
Is-Sibt
Isaa
Isadan
Isi
Island
Islands
Isle
Isn
Isniin
Isnin
Israel
It-Tlieta
It-Tnejn
Italian
Italy
Ithatũ
Ituku
Iuch
Iuchar
Iul
Iulai
Iun
Iune
Iwi
Iwo
Iwootkuut
Iyl
Iyn
Iyul
Iyun
Izu
Iúil
Iýul
Iýun
Ištáwičhayazaŋ
I bikɛ̂glà
I ɓugajɔp
J
J-fouyir
J-guer
J-souree
J.-C
J.K
J1
J2
J3
J4
J5
JAN
JC
JEN
JK
JL
JMP
JN
JUM
Jahres
Jamaica
James
Jan
Janairu
Janeiro
Janeru
Jannaayo
Jannar
Jannewa
Jannewaris
Janoary
Januaar
Januali
Januar
Januare
Januari
Januarie
Januaro
January
Januarĩ
Janueri
Januwari
Janwaliyo
Janyuwari
Japan
Japanese
Jasyapy
Jasykõi
Jasypa
Jasypakõi
Jasypateĩ
Jasypo
Jasypoapy
Jasypokõi
Jasyporundy
Jasypoteĩ
Jasyrundy
Jasyteĩ
Javanese
Jed
Jedoonee
Jeesu
Jeh
Jeheiney
Jel
Jelhein
Jem
Jemayrt
Jen
Jenner
Jenụwarị
Jerc
Jercean
Jerd
Jerdein
Jerrey-fouyir
Jerrey-geuree
Jerrey-souree
Jersey
Jes
Jesarn
Jeso
Jesu
Jezuz-Krist
Jiec
Jim
Jimaata
Jimco
Jju
Jmc
Jmn
Jmo
Jn
Jnn
Joi
Jol
Jola-Fonyi
Jolay
Jon
Jona
Jordan
Jpi
Jtn
Jtt
Jue
Jueves
Jug
Jugn
Jul
Julaayi
Julae
Julai
Julayi
Julaị
Julho
Julhu
Juli
Julie
Julio
July
Julyai
Jum
Jumaah
Jumaamosi
Jumaane
Jumaapii
Jumaat
Jumaatano
Jumaatatu
Jumamosi
Jumamóosi
Jumamósi
Jumane
Jumanne
Jumapil
Jumapili
Jumapilyi
Jumapiri
Jumapíiri
Jumapílí
Jumat
Jumatano
Jumatanu
Jumatatu
Jumatatuu
Jumatáano
Jumatánɔ
Jumatátu
Jumaíne
Jummaʼa
Jumáa
Jun
June
Junho
Junhu
Juni
Junie
Junio
Juny
Junyi
Juu
Juuli
Juun
Juuni
Jän
Jänner
Jén
Jénúári
Jésus-Christ
K
K-Ɔ
K.H
K.a
K.o
K.s
K1
K1s3
K2
K2s3
K3
K3s3
K4
K4s3
K9
KA
KBR
KBZ
KD
KE
KI
KIU
KIY
KK
KKM
KKN
KM
KMA
KMK
KMN
KMS
KMW
KNB
KNK
KO
KS1
KS2
KS3
KS4
KSA
KST
KTN
KV1
KV2
KV3
KV4
KW1
KW2
KW3
KW4
KWOTA
Ka
Kab
Kabla
Kabuverdianu
Kabyle
Kabàlàshìpù
Kad
Kafin
Kai
Kaingang
Kak
Kakauka
Kako
Kala
Kalaallisut
Kalenjin
Kam
Kamba
Kamena
Kamiisa
Kamis
Kan
Kanama
Kannada
Kanne
Kapok
Kar
Karen
Kas
Kashmiri
Kaswèkèsè
Kasım
Kat
Katano
Kavaga
Kaviri
Kaw
Kazakh
Kazakhstan
Kaĩrĩ
Ke
Ke-2
Ke-3
Ke-4
Keeling
Keenda
Kejì
Kek
Kekemapa
Kel
Kem
Kemis
Ken
Kenya
Kenyang
Kep
Kepakemapa
Kerzu
Kev
Kevardhu
Kh
Kha
Khamiis
Khamis
Khmer
Khms
Kho
Khotavuxika
Kifula
Kigarama
Kikuyu
Kilisto
Kimu
Kingdom
Kinshasa
Kinyarwanda
Kipsuunde
Kiptaamo
Kiribati
Kiristu
Kiroko
Kirís
Kitts
Kiumia
Kl
Kli
Klisto
Klock
Kma
Kmb
Kmj
KnK
Knd
Knn
Koa
Koaeng’
Koang’wan
Kokakesich
Kol
Kolo
Kom
Komuut
Kong
Konkani
Koo
Koobaad
Kor
Korea
Korean
Kornyoot
Kos
Kosomok
Kosovo
Kot
Kota
Kotaai
Kotara
Kotisap
Kow
Koyra
Koyraboro
Kpa
Kpelle
Kpt
Kr
Kraist
Kraḍ
Kraḍass
Kraịst
Krestos
Krishtit
Krist
Krista
Kristaus
Kristi
Kristo
Kristom
Kristovi
Kristtusa
Kristu
Kristuksen
Kristus
Kristusa
Kristusom
Kristusowem
Kristusowym
Kristust
Kristusu
Kristũ
Kristų
Krisztus
Krís
Krîstu
Krǐstò
Ktn
Kts
Ktũ
Ku
Kuartal
Kub
Kubi
Kubvumbi
Kuk
Kukadzi
Kul
Kulisito
Kulisto
Kum
Kumpala
Kun
Kuna
Kunyima
Kuota
Kur
Kuramuka
Kurdish
Kurisito
Kurmaana
Kurume
Kusa
Kuta
Kuuza
Kuvita
Kuwa
Kuwait
Kuẓ
Kuẓass
Kvco
Kwa
Kwakwar-Ɔgyefuo
Kwasio
Kwata
Kwe
Kwesida
Kwiidwaata
Kwiikumi
Kwiinyambála
Kwiinyi
Kwọ́ta
Kya1
Kya2
Kya3
Kya4
Kyakuna
Kyrgyz
Kyrgyzstan
Kzu
Kèk
Kôzo
Kújúɔrɔk
Kús
Kúshîn
Kük
Kükürü
KǝPel
Kɔndɔŋ
Kɛin
Kɛlísɛtɔ
Kɛr
Kɛrin
Kɛt
Kɛta
Kɨrɨsitʉ
Kɨ̀lesto
Kʉfúngatɨ
Kʉkeenda
Kʉmʉʉnchɨ
Kʉnaanɨ
Kʉsaano
Kʉsaatʉ
Kʉsasatʉ
Kʉvɨɨrɨ
Kʼicheʼ
Kḍg1
Kḍg2
Kḍg3
Kḍg4
Kṭu
Kṭuber
Kẹin
Kẹr
Kẹrin
Kẹt
Kẹta
L
L-Erbgħa
L.y
L/y
L1
L2
L3
L4
LK
LL
LL-y
LL/y
LLL
LLLL
LLLL'n
LLLLL
LP
Laa
Laath
Lab
Laba
Labaad
Labb
Labn
Labobedi
Labohlane
Labohlano
Labone
Laboraro
Laboraru
Labotlhano
Labr
Labt
Lah
Lahadi
Lahlɛ̄
Lakota
Lam
Lamorena
Langi
Lanka
Lao
Laos
Lapa
Lar
Laraba
Latin
Latvia
Latvian
Lebanon
Lehin
Lem
Len
Lengua
Leo
Leone
Leotshe
Leschenko
Leso
Lesotho
Lewe
Lewedi
Li
Liberia
Libya
Liduva
Liechtenstein
Ligurian
Lin
Lingala
Linggo
Lit
Lithuania
Lithuanian
Litinin
Lixaad
Lj
Ll
Ll1
Ll2
Ll3
Ll4
Ll5
Ll6
Ll7
Llun
Lobo
Local
Locale
Lojban
Lombard
Long
Loo
Lovo
Low
Lower
Luain
Luan
Luanistyn
Lub
Luba-Katanga
Lubingu
Lucia
Luf
Lufuimi
Lui
Lul
Lule
Lulju
Lum
Luma lwa K
Lumingu
Lumùngùlù
Lun
Lunes
Lungùdi
Luo
Luri
Lus
Lush
Lusòlo
Lut
Lutongolo
Luuliyo
Luxembourg
Luxembourgish
Luyia
Lw2
Lw3
Lw4
Lw5
Lw6
Lwakubiri
Lwakuna
Lwakusatu
Lwakutaano
Lwamilawu
Lwamukaaga
Lwe
Lwesb
Lwesibini
Lwesihlanu
Lwesine
Lwesithathu
Lwetse
Lwezi
Lâp
Lâpôsö
Lây
Lâyenga
Lép
Lìbuy
Lùishi
Lùna
Lùnastal
Lùshìkà
Lún
Lúnasa
Lāpule
M
M-Houney
M-Nollick
M-d
M-dE
M-fouyir
M-souree
M-y
M-Ɔ
M.d.y
M.y
M/d
M/d(E
M/d/y
M/dE
M/dEEEE
M/d（E）
M/y
M01
M02
M03
M04
M05
M06
M07
M08
M09
M1
M10
M11
M12
M2
M3
M4
M5
M6
M7
M8
M9
MAC
MAD
MAM
MBI
MEEEEd
MEd
MEd-alt-variant
MFómh
MG
MK
MLI
MM
MM-d
MM-dd
MM-y
MM.y
MM/Y
MM/dd
MM/dd/y
MM/y
MMM
MMM'a
MMM'ê
MMM'ын
MMMEEEEd
MMMEd
MMMM
MMMM'a
MMMM'ren
MMMM'ê
MMMM'ын
MMMM:
MMMM:'a
MMMMEEEEd
MMMMEd
MMMMM
MMMMM/dd
MMMMW-count-few
MMMMW-count-many
MMMMW-count-one
MMMMW-count-other
MMMMW-count-two
MMMMW-count-zero
MMMMd
MMMMdd
MMMM،
MMMMৰ
MMMMના
MMMMలో
MMMMའི་ཚེས་d
MMMMს
MMMM的第W週
MMMM第W周
MMMd
MMMdd
MMM،
MMMی
MMMཚེས་d
MMM⹁
MMd
MMdd
MMdd-alt-variant
MM‏/y
MRA
MS
MUU
MY
Ma
Maa
Maachị
Maaie
Maandag
Maarso
Maart
Maarten
Maayi
Mab
Mabasa
Mac
Macao
Macedonia
Macedonian
Mach
Machame
Machi
Madagascar
Madǝmbii
Madǝǝuutǝbijaŋ
Mae
Mag
Magali
Mai
Maio
Maithili
Maiu
Maj
Majo
Makhuwa-Meetto
Makonde
Mal
Malagasy
Malaki
Malawi
Malay
Malayalam
Malaysia
Maldives
Mali
Malta
Maltese
Mam
Mamuut
Mamǝŋgwãafahbii
Mamǝŋgwãalii
Man
Mande
Mane
Mangal
Mangalwaar
Manipuri
Mantaxtsees
Manth
Manthole
Mantiʼ
Manx
Mapuche
Mar
Marathi
March
Marco
Maret
Marfoo
Mariana
Marino
Maris
Marisi
Mars
Marshall
Marsi
Marso
Marsu
Mart
Martes
Martin
Martinique
Marto
Martsa
Marzo
Marzu
Març
Mas
Masai
Masehi
Mashi
Mat
Mata
Matlhatso
Matshi
Mauritania
Mauritius
Maw
Mawrth
Mawuwani
May
Mayek
Mayen
Mayesu
Mayo
Mayotte
Mayrnt
Mayu
Mayyu
Mayıs
Mazanderani
Maý
Maʻa
Maʻasi
Mb.Y
Mbe
Mbee
Mbere
Mbi
Mbimbitho
Mbu
Mbudzi
Mbä
Mbängü
Mc
Md
Md-alt-variant
Mdd
Mderot
Me
Mean-fouyir
Mean-souree
Medi
Medium
Mee
Meh
Mehefin
Mei
Meije
Meitei
Meith
Meitheamh
Mej
Mejju
Melilla
Mem
Memeneda
Mer
Mercher
Mercʼher
Merher
Meru
Met
Metaʼ
Metheven
Metwoch
Meu
Meur
Meurth
Meurzh
Mexico
Mey
Meyi
Mezh
Mezheven
Meán
Meínō
Meɣ
Meɣres
Mfu
Mfumfu
Mgq
Mgqibelo
Mha
Mhawuri
Mhr
Mhàrt
Mi
Micronesia
Middeweken
Mie
Mih
Milattan
Min
Minggu
Miquelon
Miscellaneous
Mit
Mitatu
Mittwoch
Mittwuch
Mittwuč
Mivili
Miy
Miyerkules
Mié
Miércoles
Mj
Mma
Mmantaha
Mme
Mmese
Mng
Mo
Moc
Mod
Mohammad
Mohawk
Mohndaach
Moj
Mok
Mokhu
Mokibelo
Moksha
Moldova
Mon
Monaco
Monday
Mongolia
Mongolian
Montag
Montenegro
Months
Montserrat
Moo
Mop
Mopi
Mopitlo
Moq
Moqebelo
Mor
Mora
Morago
Moranang
Morena
Mori
Morisyen
Moroccan
Morocco
Mos
Mose
Mosegemanye
Mosopulogo
Mot
Motsheanong
Motsheganang
Mozambique
Mpal
Mpalakazi
Mpan
Mpandula
Mpg
Mph
Mphalane
Mrt
Msh
Mso
Msp
Mth
Mtwaa
Mud
Muddee
Mudyaxihi
Mueji
Mug
Mugovera
Mugqivela
Muh
Muhaano
Muhi
Muhiga
Muj
Mujimbi
Muk
Muka
Mukakaro
Mul
Mulgul
Mulungu
Mumu-Ɔpɛnimba
Mun
Mundang
Mundaŋ
Munkyo
Munyense
Munyi
Munyonyo
Mup
Mupalangulwa
Mupuguto
Muramuko
Murwa
Mus
Muscogee
Mushende
Mushipepo
Musongandembwe
Musopologo
Musumbhunuku
Mut
Mutarama
Muu
Muv
Muvhuro
Mvu
Mvuka
Mvulo
Mwai
Mwedi
Mwere
Mweri
Mwi
Mwitope
Myanmar
Mye
Mz
MÇ
MÖ
Màcɛ̂l
Màrt
Màtop
Màtùmb
Màyɛsèp
Máirt
Márta
Mä
Mäe
Mäerz
Män
Mäntag
Mär
März
Märze
Mäz
Määntig
Määz
Méi
Méindeg
Mët
Mëttwoch
Móosi
Mórusásin
Mùuyà
Māe
Māehe
Māori
Mē
MĨĨ
Mĩĩ
Mōn
Mōnite
Mɔnɔ
Mɔ́
Mɔ́ndi
Mʉʉnchɨ
M̀puyɛ
Mọn
Mọnde
Mọ́n
Mọ́ndè
M‏/y
M月
M月d日
M月d日(E
M月d日E
M月d日EEEE
M月第W个星期
M月第W個星期
M月第W週
M월
N
N4
NAME
ND
NGS
NJ
NJR
NJU
NJumamothii
NK
NMA
NMM
NMN
NMN1
NMN2
NMN3
NMN4
NMT
NOV
NTT
NV
NY
Na
Naanɨ
Nab
Nabändüru
Nai
Nak
Nakaare
Nakaebarasa
Nakaejuma
Nakakany
Nakasabiti
Nakaung’on
Nakauni
Nakfish
Nama
Namibia
Nan
Nankuida
Nannalhchifaʼ
Narrow
Nauru
Navajo
Nchechi
Ncho
Ncholo
Ncw
Ncwabakazi
Ndamukiza
Ndangù
Ndebele
Ndg
Ndi
Ndira
Ndithemba
Nduŋmbi
Ndy
Ndz
Ndzhati
Ndàayà
Ne
Nepal
Nepali
Netherlands
Nettv
Nevis
New
Ngat
Ngb
Ngberere
Nge
Ngeso
Ngiemboon
Ngomba
Ngu
Ngubùe
Nguyên
Ngv
Ngw
Ngwanatsele
Ngòvya
Ng’atyaato
Ng’eiyeet
Nheengatu
Nhl
Nhla
Nhlangula
Nhlo
Nhlolanja
Nhật
Nicaragua
Niger
Nigeria
Nigerian
Nis
Nisan
Nittak
Niue
Njenuarĩ
Njua
Njumaa
Njumaine
Njumamothi
Njumatana
Njumatano
Njumatatu
Njumatatũ
Njuni
Njuraĩ
Njw
Njèbà
Njòwa
Nko
Nkodya
Nkw
Nkwenkwezi
Nnyano
No
Nob
Nobemba
Nobyembre
Noe
Noema
Nof
Nofimpaʼ
Noll
Nollaig
Nollick
Noo
Noofeembar
Noowanbur
Nop
Nopémber
Norfolk
North
Northern
Norway
Norwegian
Nov
Novambra
Novemba
Novembar
November
Novembro
Novembru
Noviembre
Novimber
Novämber
Novèmber
Now
Nowemapa
Nowàmbar
Noy
Noyabr
Noý
Noýabr
NpK
Nsima
Ntandi
Ntsɔ̌pmɔ́
Ntsɔ̌ppá
Ntu
Ntulikazi
Ntwarante
Ntʉ́
Ntʉ́ŋʉ́s
Nuer
Nun
Nunembeṛ
Nuv
Nuvenbru
Nuw
Nuwamba
Nv
Nwa
Nwanbir
Ny.Y
Nya
Nyakanga
Nyamavhuvhu
Nyandagaro
Nyanja
Nyankole
Nyaŋgwɛ
Nye
Nyenyankulu
Nyenye
Nyenyenyani
Nyiakeng
Nynorsk
Nyuma
Nyɔlɔmbɔŋgɔ
Nze
Nzeli
Nzero
Násˀahˀatsus
Nípbaa
Nípbaatiˀtiˀ
Năm
Nōv
Nōvema
Nɛgɛ́m
Nọv
Nọvẹ́mba
N’Ko
N’w
N’wendzamhala
O
O-A
OC
OD
OKB
OKN
OKS
OKT
OMK
ORK
OT
Ob
Obirade-Ayɛwohomumu
Obo
Obolo
Oca
Ocak
Occitan
Ocean
Och
Ochiko
Oct
October
Octubre
Odia
Odung’el
Oed
Oga
Ogas
Ogasti
Ogo
Ogos
Ogosto
Ogs
Ogus
Ojola
Ok
Oke
Oketopa
Oki
Okitoba
Okitobba
Okkoskv
Okt
Oktabr
Okthoba
Okthobha
Oktoba
Oktobar
Oktober
Oktobra
Oktobro
Oktohber
Oktoobar
Oktoober
Oktoobur
Oktover
Oktubre
Oktýabr
Oktũba
Oku
Okwaikumi
Okwakabiri
Okwakana
Okwakashatu
Okwakataana
Okwamg’
Okwamukaaga
Okwamunaana
Okwamushanju
Okwamwenda
Okwokubanza
Ol
Olabor
Oladalʉ́
Olgísan
Olodoyíóríê
Oloilépūnyīē
Olokuna
Olokutaanu
Olomukaaga
Oman
Omaruk
Omodok’king’ol
Omuk
Ong
Onk
Onkololeessa
Opedel
Opoo
Orara
Oromo
Orwakabiri
Orwakana
Orwakashatu
Orwakataano
Orwamukaaga
Orwokubanza
Osage
Oshù
Osokosokoma
Ossetic
Otibar
Otowoskuce
Otowoskv
Otrd
Otrdiena
Ott
Ottubru
Otu
Otubar
Otubro
Otubru
Ougùstùs
Ouj
Oujoß
Outlying
Ovdil
Ow
Owe
Owewe
Owokubili
Owokusatu
Owáŋgyužažapi
Oṣù
P
P.M
P1
P2
P3
P4
P5
P6
PB
PG
PK
PM
PM06.30.30
PM፡UTC
PN
PTG
PZ
Pa
Paa
Paagi
Pachibelushi
Pakistan
Palau
Palestinian
Palichibuli
Palichimo
Palichine
Palichisano
Palichitatu
Pamwandi
Panama
Pankoff
Papiamento
Papua
Par
Paraguay
Paraire
Pashamihe
Pashto
Pataa
Patterns
Pay
PayPal
Paz
Pazar
Pazartesi
Peb
Pebrero
Ped
Pel
Pele
Pen
Penşenbe
Pep
Pepeluali
Per
Persian
Peru
Perşembe
Pfiɛ
Pha
Phata
Phato
Phatwe
Phe
Phere
Pherekgong
Phesekgong
Philippines
Phu
Phukwi
Phupjane
Phupu
Pidgin
Piektd
Piektdiena
Pierre
Pijin
Pili
Pir
Pirmd
Pirmdiena
Pisin
Pitcairn
Poland
Polish
Polynesia
Polytonic
Pona
Poo
Portugal
Portuguese
Pos
Poʻahā
Poʻakahi
Poʻakolu
Poʻalima
Poʻalua
Poʻaono
Prefers
Prin
Prussian
Prvi
Príncipe
Puachue
Puerto
Pul
Pulelulu
Pun
Pundungwane
Punjabi
Pzt
Päth
Péb
Pébruari
Píili
Pēp
Pēpuere
Pȟežítȟo
Pɛsaŋ
Pɛt
Pɛ́nɛ́fɔm
Pɛ́nɛ́kwa
Pɛ́nɛ́ntúkú
Pɛ́nɛ́pfúꞋú
Pɛ́pá
Pɛ́tát
Pʉshʉ́ka
Q
Q1
Q2
Q3
Q4
Q5
QK
QQQ
QQQ'em
QQQQ
QQQy
Qabel
Qatar
Qib
Qibxata
Quartal
Quarters
Quattahl
Quechua
Quý
R
R1
R2
R3
R4
RC
RW
Ra
Rab
Rabu
Rajasthani
Rakko
Rar
Raspass
Ravi
Raviwaar
Ravumbirhi
Ravumune
Ravunharhu
Ravuntlhanu
Reb
Rebo
Republic
Rh
Rhag
Rhagfyr
Rica
Rico
Riffian
Ro
Rob
Robo
Rohingya
Roimh
Rok
Rolsky
Rolsky's
Romania
Romanian
Romansh
Rombo
Roo
Roobii
Rooptui
Rt
Rubaca
Ruheshi
Ruhuhuma
Rundi
Rusama
Russia
Russian
Rvfo
Rwa
Rwanda
Ryley
Réunion
Rāh
Rāhoroi
Rāt
Rātapu
RŨ
Rɛw
Rɛw،
S
S-Ɔ
S.M
S1
S2
S3
S4
SAN
SAR
SCN
SF
SK
SM
SM1
SM2
SM3
SM4
SPT
ST
SUPPORT
Sa
Saa
Saambá
Saano
Saatʉ
Sab
Sabado
Sabato
Sabbiiti
Sabi
Sabiiti
Sabti
Sabtu
Sabudu
Sad
Sadaasa
Saddexaad
Sadorn
Sadwrn
Sagaalaad
Sahara
Saho
Saju
Sakdurunge
Sal
Salasa
Salvador
Salı
Sam
Samass
Samburu
Samh
Samhain
Sami
Samoa
Samschdeg
Samschtig
Samsdaach
Samstag
Samwiyee
Samštag
San
Sanass
Sanbata
Sanda-Ɔpɛpɔn
Sande
Sango
Sangu
Sanskrit
Santali
Sanvie
Sap
Saptu
Sardinian
Sarere
Sasatʉ
Sat
Satade
Saterdag
Satertaxtsees
Sath
Sathairn
Satumba
Saturday
Sat،
Sat፡
Sat፣
Sat፥M09፡15፡መዓልት፡-10፡04:44:23
Satọdee
Sau
Saudi
Say
Sayass
Saŋ
Sb
Sbti
Scottish
Se
Seb
Sebelum
Sebteembar
Sebuttemba
Secont
Sed
Sedimonthole
See
Seetebosigo
Sek
Sektanbur
Sel
Selasa
Sen
Sena
Senegal
Senin
Senni
Sentabr
Sentýabr
Senén
Sep
Sephatlho
Sepitema
Sept
Sept,-10
Septambra
Septemba
September
Septembro
Septhemba
Septimber
Septiyembre
Septämber
Serbia
Serbian
Sergey
Sesh
Sestd
Sestdiena
Set
Setembar
Setembro
Setenbru
Setiembre
Settembar
Settembru
Setyembre
Seychelles
Sh
Sha
Shambala
Shan
Shanaad
Shani
Shaniwaar
Shavian
Shona
Short
Shukra
Shukrawaar
Shɛ́
Shɛ́r
Shɛ́rɛ́
Shʉ́
Si
Sib
Sibili
Sibiti
Sichuan
Sicilian
Sidamo
Sideedaad
Sierra
Sih
Sihlanu
Silesian
Simplified
Sin
Sindhi
Sine
Singapore
Sinh
Sinhala
Sint
Siptimpaʼ
Sit
Sithathu
Siu
Siulai
Siş
Sişenbe
Skolt
Slavic
Slovak
Slovakia
Slovenia
Slovenian
So
Soga
Soistiʼ
Sok
Solomon
Som
Somali
Somalia
Somwaar
Son
Sondag
Sonndeg
Sonntag
Sonra
Sonta
Sontaha
Sontaxtsees
Sonto
Sorbian
Sotho
South
Southern
Spain
Spanish
Sri
St
Standard
Starman
States
Strftime
Su
Subbaahi
Sudan
Sueŋ
Suku
Sul
Sulet
Sult
Sun
Sundanese
Sunday
Sune
Sunguti
Sunndaach
Sunntag
Sunntig
Suriname
Suw
Suwe
Svalbard
Svo
Svondo
Svētd
Svētdiena
Swahili
Swati
Sweden
Swedish
Swiss
Switzerland
Syria
Syriac
Sz
Sze
Szo
Sàt
Sàttumbar
Sá
Sábado
Sás
Sásidɛ
Sát
Sátọdè
Sáu
Sâm
São
Säp
Sèptèmber
Sép
Séptémber
Sú
Súuyee
Sünnavend
Sünndag
Sān
Sānuali
Sāp
Sāpate
Sēp
Sēpitema
Sěe
Sīsū
Sɔ́
Sɔ́ndi
Sḍis
Sḍisass
Sẹp
Sẹptẹ́mba
Sẹ́kọ́n
Sọn
Sọndee
Sọ́n
Sọ́ndè
T
T-arree
T.K
T.Ɛ
T1
T2
T3
T4
T5
T6
T7
TAB
TAD
TAN
TAR
TAƔ
TCN
TK
TM
TOO
TS
TW1
TW2
TW3
TW4
Taa
Tach
Tachelhit
Tachwedd
Tai
Taita
Taiwan
Tajik
Tajikistan
Tal
Talaado
Talaata
Talata
Tamazight
Tamil
Tan
Tanzania
Taparachu
Taraskievica
Taraǀkhuumûǁkhâb
Taroko
Tasahce
Tasahcuce
Tasawaq
Tat
Tatar
Tatu
Te
Teipa
Telovolana
Telugu
Tem
Temmuz
Ten
Teneŋ
Termes
Territories
Territory
Tesiran
Teso
Th
Tha
Thai
Thailand
This
Thiyóȟeyuŋka
Thoo
Tho̱o̱r
Tht
Thu
Thursday
Thutha
Tháng
Thứ
Tib
Tibetan
Tich
Tid
Tierç
Tifinagh
Tigre
Tigrinya
Tiisimpaʼ
Time
Timor-Leste
Tindɛ
Tiop
Tio̱p
Tis
Tiu
Tiusde
Tiuzdee
Tiú
Tiúzdè
Tl
Tldo
Tlh
Tlhakole
Tli
Tn
Tne
Tob
Tobago
Tobnaad
Todobaad
Togo
Tok
Tokelau
Toki
Tokonaki
Tom
Tomé
Tonga
Tongan
Torwali
Tosde
Toshiaght-arree
Tow
Traditional
Tremujori
Treći
Trešd
Trešdiena
Tri
Trim
Trimestar
Trimestrul
Trinde
Trinidad
Trước
Tsahkápbiˀ
Tsh
Tshipi
Tshitwe
Tsonga
Tswana
Tu
Tub
Tubeṛ
Tue
Tuesday
Tue،
Tue፡
Tue፣
Tue፥M02፡
Tunde
Tunisia
Tupu
Turkish
Turkmen
Turkmenistan
Turks
Tuvalu
Tuʻa
Tuʻapulelulu
Tyap
Táano
Táatu
Türkiye
Tāi
Tāite
Tīh
Tīhema
Tīs
Tīsema
TŊ
Tūr
Tūrei
Tūs
Tūsite
Tư
Tȟahékapšuŋ
Tɔ́
Tɔ́sɛdɛ
Tɛɛ
Tɛɛr
Tọ́d
Tọ́z
Tọ́zdè
Tọọ
Tọọzdee
U
U.S
UKristo
ULwesibili
ULwesihlanu
ULwesine
ULwesithathu
UMgqibelo
UMsombuluko
UT
UTC
UTC(y)ê
Ube
Uganda
Ugu
Ugushyingo
Uhr
Ukraine
Ukrainian
Ukristo
Uku
Ukuboza
Ukw
Ukwakira
Umo
Una
Ung
Uni
United
Unknown
Upper
Upu
Urdu
Uruguay
Ut
Util
Uyghur
Uzbek
Uzbekistan
V
VI
VII
VIII
Va
Vai
Valencian
Vanuatu
Vatican
Venda
Venetian
Venezuela
Verde
Vie
Viernes
Vietnam
Vietnamese
Vil
Vin
Vincent
Virgin
Volapük
Vr
Vrydag
Vunjo
Vɨɨrɨ
W
W'em
W'ª
W'º
W-'hafta
W-'il
W-'аптасы
W-'й
W-'мӗш
W-'р
W-'я
W-'ҳафта
W-ին
W-րդ
W-ھەپتە
W.'ª
WAI
WB
WD
WEN
WET
WGT
WIK
WK
WKD
WKN
WKR
WMJ
WMW
WNN
WTD
WTN
WUT
Wa
Waa
Wairi
Wala
Wallis
Walloon
Walser
Waníyetu
Wara
Warlpiri
Wasútȟuŋ
Wax
Waxabajjii
Wed
Wednesday
Welsh
Wen
Wena
Wenerei
Wenesde
Wenezdee
Wer
Werurwe
Western
Wetano
Wethatu
Wide
Wiik
Wiixata
Wik
Win
Winstiʼ
Wintermánet
Wix
Wiótheȟika
Wkl
Wkn
Wkw
Wky
Wo
Woche
Woensdag
Wolaytta
Wolof
Wth
Wtn
Wtũ
Wu
Wuk
Wukuda
Wun
Wunstaxtsees
Wuok
Wánit
Wí
Wím
Wímánet
Wípazukȟa-wašté
Wísts’i
Wɛ́
Wɛ́nɛsɛdɛ
Wم
Wয়
Wవ
Wẹ́n
Wẹ́nẹ́zdè
W번째
X
XI
XII
XII/22
Xhosa
Xin
Xnt
Xristub
Xun
Y
Y'an
Y-'жылдын
Y-MM
Y-ലെ
Y.K
YA
YK
YM
YY
Yaijire
Yak
Yakut
Yambo
Yan
Yanass
Yangben
Yanvar
Yanüari
Yaou
Yaw
Yawda
Yeb
Yebrayer
Yebrir
Yecu
Yeesu
Yel
Yemen
Yen
Yennayer
Yes
Yeso
Yesu
Yesù
Yesũ
Yethu
Yezu
Yi
Yiddish
Yiẹ
Yopia
Yoruba
Yow
Yul
Yuli
Yulyu
Yulyuz
Yun
Yuni
Yunyu
Yuru
Yés
Yésus
Yésuse
Yézu
Yüli
Yüni
Yěsô
Yŋ
Yɛ́sus
Yɛ́sʉ
Y،
Yৰ
Yలో
Y年的第w週
Y年第w个星期
Y年第w個星期
Y年第w周
Y年第w週
Y년
Z
Z-K
Z.MU
Z.MW
Zaarikay b
Zambia
Zarma
Zdat
Zdat azal
Zealand
Zen
Zenâr
Zezi-Krist
Zi
Zib
Zibandlela
Ziischtig
Zimbabwe
Ziš
Zištag
Zom
Zoma
Zulu
Zvi
Zvita
ZƐ
[UTC]
[v]
a
a-raok
a.C
a.Chr
a.d
a.g
a.k
a.m
a.n.e
a;
aC
aK:mm
aK:mm:ss
aK時
aa
aa-DJ
aa-ER
aa-ET
aa_DJ
aa_ER
aa_ET
aaɓ
aaɓnde
ab
ab-GE
ab_GE
abans
abe
abe.ren
abendua
abenduaren
abr
abril
abrile
abu
abuztua
achiel
adamsan
adar
ade
adeɛmekpɔxe
adr
aeng’
af
af-NA
af-ZA
af_NA
af_ZA
affile
afɔ
afɔfĩe
ag
aggusti
aggustip
ago
agost
agosto
agostu
agq
agq-CM
agq_CM
agt
ah:mm
ah:mm:ss
ah时
ah時
ai
aijima
aimisa
aiǃâ
ak
ak-GH
ak_GH
akasuba
akavyaalwe
akraḍaggur
akw
akwas
aká
akǝ
akṛ
akṛas
akṛaḍyur
al
ala
alaba
alamisa
am
am-ET
am04:44:23
am09:05:02
am_ET
amenzu
an
an-ES
an_ES
anavyaal
angakabuyi
ang’wan
ann
ann-NG
ann_NG
anna
annab
antaŭ
ante
antes
antis
antradienis
any
anyɔnyɔ
août
ap
apc-SY
apc_SY
api
apirila
apl
apr
apre
aprel
apriili
apriilip
april
aprile
aprilie
aprill
apryl
apryla
après
apríl
apríla
aprīlis
ar
ar-001
ar-AE
ar-BH
ar-DJ
ar-DZ
ar-EG
ar-EH
ar-ER
ar-IL
ar-IQ
ar-JO
ar-KM
ar-KW
ar-LB
ar-LY
ar-MA
ar-MR
ar-OM
ar-PS
ar-QA
ar-SA
ar-SD
ar-SO
ar-SS
ar-SY
ar-TD
ar-TN
ar-YE
ar_001
ar_AE
ar_BH
ar_DJ
ar_DZ
ar_EG
ar_EH
ar_ER
ar_IL
ar_IQ
ar_JO
ar_KM
ar_KW
ar_LB
ar_LY
ar_MA
ar_MR
ar_OM
ar_PS
ar_QA
ar_SA
ar_SD
ar_SO
ar_SS
ar_SY
ar_TD
ar_TN
ar_YE
ara
araba
are
arf
arfininngorneq
ariré
ariyo
arn
arn-CL
arn_CL
as
as-IN
as_IN
asa
asa-TZ
asa_TZ
asamas
asati
asi
asim
asimwas
asinas
asiḍ
asiḍyas
ast
ast-ES
ast_ES
astea
asteartea
asteazkena
astelehena
asú
ata
ataasinngorneq
ataiborwa
atm
aug
august
augusta
augusti
augusto
augusts
augustus
augusztus
auni
aus
austu
autarch
auya
av
available
avan
avant
avanti
avg
avgust
avi
avientu
avost
avq
avqust
avr
avrigl
avril
avust
avvalgi
awg
awgust
awgusta
awi
awirili
awóm
axşamı
ayk
ayn
aynas
ayının
az
az-Arab
az-Arab-IQ
az-Arab-IR
az-Arab-TR
az-Cyrl
az-Cyrl-AZ
az-Latn
az-Latn-AZ
az_Arab
az_Arab_IQ
az_Arab_IR
az_Arab_TR
az_Cyrl
az_Cyrl_AZ
az_Latn
az_Latn_AZ
aza
azaroa
azilawo
aɖabaƒoƒo
b
b.Y.K
ba
ba-RU
ba_RU
bal
bal-Arab
bal-Arab-PK
bal-Latn
bal-Latn-PK
bal_Arab
bal_Arab_PK
bal_Latn
bal_Latn_PK
balandis
balandžio
bas
bas-CM
bas_CM
bazar
be
be-BY
be-tarask
be_BY
be_tarask
bear
bearjadat
before
beke
bem
bem-ZM
bem_ZM
berfanbar
berfanbara
berfanbarê
berî
bez
bez-TZ
bez_TZ
bg
bg-BG
bg_BG
bgc
bgc-IN
bgc_IN
bgn
bgn-AE
bgn-AF
bgn-IR
bgn-OM
bgn-PK
bgn_AE
bgn_AF
bgn_IR
bgn_OM
bgn_PK
bho
bho-IN
bho_IN
bi
biaâ
binâ
bio
birž
birželio
birželis
bisu
bisū
biyu
biɓaà
bla
blaɖa
blt
blt-VN
blt_VN
bm
bm-ML
bm-Nkoo
bm-Nkoo-ML
bm_ML
bm_Nkoo
bm_Nkoo_ML
bn
bn-BD
bn-IN
bn_BD
bn_IN
bo
bo-CN
bo-IN
bo_CN
bo_IN
bobedi
bone
boraro
borg
borgemánnu
bosi
bow
bowte
br
br-FR
br_FR
brf
brfa
brfê
brx
brx-IN
brx_IN
bs
bs-Cyrl
bs-Cyrl-BA
bs-Latn
bs-Latn-BA
bs_Cyrl
bs_Cyrl_BA
bs_Latn
bs_Latn_BA
bss
bss-CM
bss_CM
byn
byn-ER
byn_ER
bře
březen
března
bɔ́k
bɛ́ɛ
bɛ̌
bṛa
bṛayṛ
c
ca
ca-AD
ca-ES
ca-ES-valencia
ca-FR
ca-IT
ca_AD
ca_ES
ca_ES_valencia
ca_FR
ca_IT
cab
cabudanni
cad
cad-US
cad_US
cairteal
ccc
cccc
cch
cch-NG
cch_NG
ccntrq
ccp
ccp-BD
ccp-IN
ccp_BD
ccp_IN
ce
ce-RU
ce_RU
ceb
ceb-PH
ceb_PH
ceturksnis
ceturtd
ceturtdiena
cgg
cgg-UG
cgg_UG
cha
chairteal
chanta
che
chenàbura
chida
cho
cho-US
cho_US
chorshanba
chr
chr-US
chr_US
chwarter
cic
cic-US
cic_US
cikin
ckb
ckb-IQ
ckb-IR
ckb_IQ
ckb_IR
co
co-FR
co_FR
col
colte
comme
contains
coo
cot
cotmeh
cristu
cs
cs-CZ
cs_CZ
csütörtök
cu
cu-RU
cu_RU
cuo
cuoŋ
cuoŋománnu
cut
cutanbir
cuáŋui
cuáŋuimáánu
cv
cv-RU
cv_RU
cy
cy-GB
cy_GB
cya
cyu
cyumweru
cze
czerwca
czerwiec
czw
czwartek
czyrwca
cámɛɛn
cümə
cÿó
cɛɛ́nko
của
c’umwaka
d
d'mh
d'ê
d('a
d,y
d-M
d-M-y
d-MMM
d-MMMM
d-MMM،
d-M،
d.C
d.Hr
d.M
d.M.y
d.MM
d.MM.y
d.Y
d/M
d/M/GGGGG
d/M/y
d/M/y၊
d/M/y（E）
d/MM
d/MM/y
d/M၊
d/M（E）
dC
da
da-DK
da-GL
da_DK
da_GL
daggis
dal
dam
dama
dap
daspò
dat
data
date
dav
dav-KE
dav_KE
day
daɛ
dc
dd
dd-MM
dd-MM-GGGGG
dd-MM-y
dd-MMM
dd.MM
dd.MM.y
dd.MMM
dd/MM
dd/MM/y
ddC
dd‏/MM
de
de''l
de'l
de-AT
de-BE
de-CH
de-DE
de-IT
de-LI
de-LU
de. 4
de. 4:44
de. 4:44:23
de. 9
de. 9:05
de. 9:05:02
de_AT
de_BE
de_CH
de_DE
de_IT
de_LI
de_LU
dea
deasiamime
dec
decembar
decembari
decembarip
december
december:
decembra
decembre
decembrie
decembris
decembro
dek
dekabr
del
dema
den
depois
des
desam
desanburu
desember
desembre
desenbre
despois
després
después
dets
detsember
dew
dewo
dexembre
dez
dezembro
dffir
dfɛ
dg
dh
dhe
dhen
dhj
dhjetor
di
dic
dicember
dicembre
diciembre
die
diel
dijous
dijòus
dilluns
diluns
dim
dimanche
dimans
dimanĉo
dimars
dimarts
dimecres
dimenge
dimècres
dimɔ́di
din
dinsdag
dip
disdat
dispos
dissabte
diumenge
divendres
diŋ
diŋgindi
diɓ
diɓáɓá
diɔk
di̱i̱t
dj
djabièrnè
djadumingu
djaluna
djamars
djarason
djasabra
djaweps
dje
dje-NE
dje_NE
dl
do
doi
doi-IN
doi_IN
dom
domenega
domenica
domenie
domingo
domingu
dominica
doménega
domìniga
donderdag
dop
dopo
do połedniŏ
drolsky
drugi
ds
dsb
dsb-DE
dsb_DE
dt
du
du. 6
du. 6:30
du. 6:30:30
dua
dua-CM
dua_CM
dub
duben
dubna
duj
dujanbir
dum
dumengia
dumingu
duminică
duor
duorasdat
duorastat
după
dushanba
duu
duujal
duş
duşem
duşenbe
dv
dv-MV
dv_MV
dy
dyo
dyo-SN
dyo_SN
dytë
dz
dz-BT
dz_BT
dzd
dziá
dzk
dzm
dzo
dzodze
dzome
dzove
dzoɖa
dzu
dzv
dä
dèidh
déc
décembre
dşm
dטן
dھەم
dی
d၊
d‏/M
d‏/M‏/y
d’Ivoire
d’abr
d’abril
d’ag
d’agost
d’agosto
d’agostu
d’arvî
d’avientu
d’avrigl
d’avust
d’ochobre
d’oct
d’october
d’octubre
d’octòbre
d’ottobre
d日
d日(E
d日E
d日EEEE
d일
e
e.C
e.Kr
e.k
e.ə
eKr
ebisoka
ebu
ebu-KE
ebu_KE
ebulú
ebuyile
ebyokubiri
ebyokuna
ebyokusatu
ebyomwaka
ebyámu
ee
ee-GH
ee-TG
ee_GH
ee_TG
efter
eftir
efute
eka
ekaina
el
el-CY
el-GR
el-polyton
el_CY
el_GR
el_polyton
elo
elok
elokuu
elokuuta
elá
eláŋgɛ́
előtt
emi
emiasele
emna
en
en-001
en-150
en-AE
en-AG
en-AI
en-AS
en-AT
en-AU
en-BB
en-BE
en-BI
en-BM
en-BS
en-BW
en-BZ
en-CA
en-CC
en-CH
en-CK
en-CM
en-CX
en-CY
en-DE
en-DG
en-DK
en-DM
en-Dsrt
en-Dsrt-US
en-ER
en-FI
en-FJ
en-FK
en-FM
en-GB
en-GD
en-GG
en-GH
en-GI
en-GM
en-GU
en-GY
en-HK
en-IE
en-IL
en-IM
en-IN
en-IO
en-JE
en-JM
en-KE
en-KI
en-KN
en-KY
en-LC
en-LR
en-LS
en-MG
en-MH
en-MO
en-MP
en-MS
en-MT
en-MU
en-MV
en-MW
en-MY
en-NA
en-NF
en-NG
en-NL
en-NR
en-NU
en-NZ
en-PG
en-PH
en-PK
en-PN
en-PR
en-PW
en-RW
en-SB
en-SC
en-SD
en-SE
en-SG
en-SH
en-SI
en-SL
en-SS
en-SX
en-SZ
en-Shaw
en-Shaw-GB
en-TC
en-TK
en-TO
en-TT
en-TV
en-TZ
en-UG
en-UM
en-US
en-VC
en-VG
en-VI
en-VU
en-WS
en-ZA
en-ZM
en-ZW
en_001
en_150
en_AE
en_AG
en_AI
en_AS
en_AT
en_AU
en_BB
en_BE
en_BI
en_BM
en_BS
en_BW
en_BZ
en_CA
en_CC
en_CH
en_CK
en_CM
en_CX
en_CY
en_DE
en_DG
en_DK
en_DM
en_Dsrt
en_Dsrt_US
en_ER
en_FI
en_FJ
en_FK
en_FM
en_GB
en_GD
en_GG
en_GH
en_GI
en_GM
en_GU
en_GY
en_HK
en_IE
en_IL
en_IM
en_IN
en_IO
en_JE
en_JM
en_KE
en_KI
en_KN
en_KY
en_LC
en_LR
en_LS
en_MG
en_MH
en_MO
en_MP
en_MS
en_MT
en_MU
en_MV
en_MW
en_MY
en_NA
en_NF
en_NG
en_NL
en_NR
en_NU
en_NZ
en_PG
en_PH
en_PK
en_PN
en_PR
en_PW
en_RW
en_SB
en_SC
en_SD
en_SE
en_SG
en_SH
en_SI
en_SL
en_SS
en_SX
en_SZ
en_Shaw
en_Shaw_GB
en_TC
en_TK
en_TO
en_TT
en_TV
en_TZ
en_UG
en_UM
en_US
en_VC
en_VG
en_VI
en_VU
en_WS
en_ZA
en_ZM
en_ZW
enantes
ene
enelia
enero
enj
enjte
enne
ennen
ensil
entang’ani
eo
eo-001
eo_001
era
eramızdan
erao
ere
ertəsi
ery
erą
es
es-419
es-AR
es-BO
es-BR
es-BZ
es-CL
es-CO
es-CR
es-CU
es-DO
es-EA
es-EC
es-ES
es-GQ
es-GT
es-HN
es-IC
es-MX
es-NI
es-PA
es-PE
es-PH
es-PR
es-PY
es-SV
es-US
es-UY
es-VE
es_419
es_AR
es_BO
es_BR
es_BZ
es_CL
es_CO
es_CR
es_CU
es_DO
es_EA
es_EC
es_ES
es_GQ
es_GT
es_HN
es_IC
es_MX
es_NI
es_PA
es_PE
es_PH
es_PR
es_PY
es_SV
es_US
es_UY
es_VE
esa
esaɓasú
esmaspäev
esun
esɔ
esɔpɛsɔpɛ
et
et-EE
et_EE
ether
etter
etɔ̃lia
eu
eu-ES
eu_ES
evelia
ewo
ewo-CM
ewo_CM
examples
eye
eyenga
f
f.K
f.Kr
f.k
fKr
fa
fa-AF
fa-IR
fa_AF
fa_IR
faharoa
fahatelo
fahefatra
fan
fanadur
favr
favrer
fbl
fearnsjier
feb
febbraio
febr
febraro
febreiro
febrer
febrero
febreru
febrièr
februaari
februaarip
februar
februar:
februara
februari
februarie
februario
február
februára
februāris
febrúar
feburuye
feléte
fev
fevereiro
fevral
fevrer
fevriye
few
fewral
ff
ff-Adlm
ff-Adlm-BF
ff-Adlm-CM
ff-Adlm-GH
ff-Adlm-GM
ff-Adlm-GN
ff-Adlm-GW
ff-Adlm-LR
ff-Adlm-MR
ff-Adlm-NE
ff-Adlm-NG
ff-Adlm-SL
ff-Adlm-SN
ff-Latn
ff-Latn-BF
ff-Latn-CM
ff-Latn-GH
ff-Latn-GM
ff-Latn-GN
ff-Latn-GW
ff-Latn-LR
ff-Latn-MR
ff-Latn-NE
ff-Latn-NG
ff-Latn-SL
ff-Latn-SN
ff_Adlm
ff_Adlm_BF
ff_Adlm_CM
ff_Adlm_GH
ff_Adlm_GM
ff_Adlm_GN
ff_Adlm_GW
ff_Adlm_LR
ff_Adlm_MR
ff_Adlm_NE
ff_Adlm_NG
ff_Adlm_SL
ff_Adlm_SN
ff_Latn
ff_Latn_BF
ff_Latn_CM
ff_Latn_GH
ff_Latn_GM
ff_Latn_GN
ff_Latn_GW
ff_Latn_LR
ff_Latn_MR
ff_Latn_NE
ff_Latn_NG
ff_Latn_SL
ff_Latn_SN
fi
fi-FI
fi_FI
fil
fil-PH
fil_PH
filanan
file
fim
fimmtudagur
first
fiɖ
fiɖa
fjórðungur
fl
fo
fo-DK
fo-FO
fo_DK
fo_FO
fog
for
format
fr
fr-BE
fr-BF
fr-BI
fr-BJ
fr-BL
fr-CA
fr-CD
fr-CF
fr-CG
fr-CH
fr-CI
fr-CM
fr-DJ
fr-DZ
fr-FR
fr-GA
fr-GF
fr-GN
fr-GP
fr-GQ
fr-HT
fr-KM
fr-LU
fr-MA
fr-MC
fr-MF
fr-MG
fr-ML
fr-MQ
fr-MR
fr-MU
fr-NC
fr-NE
fr-PF
fr-PM
fr-RE
fr-RW
fr-SC
fr-SN
fr-SY
fr-TD
fr-TG
fr-TN
fr-VU
fr-WF
fr-YT
fr_BE
fr_BF
fr_BI
fr_BJ
fr_BL
fr_CA
fr_CD
fr_CF
fr_CG
fr_CH
fr_CI
fr_CM
fr_DJ
fr_DZ
fr_FR
fr_GA
fr_GF
fr_GN
fr_GP
fr_GQ
fr_HT
fr_KM
fr_LU
fr_MA
fr_MC
fr_MF
fr_MG
fr_ML
fr_MQ
fr_MR
fr_MU
fr_NC
fr_NE
fr_PF
fr_PM
fr_RE
fr_RW
fr_SC
fr_SN
fr_SY
fr_TD
fr_TG
fr_TN
fr_VU
fr_WF
fr_YT
fre
fredag
freed
frevâ
freàrgiu
frr
frr-DE
frr_DE
frí
fríggjadagur
fur
fur-IT
fur_IT
fwo
fy
fy-NL
fy_NL
fyri
fyrir
fév
févr
février
före
fös
föstudagur
før
fúl
fúladé
fúnɛ
fā
fĩi
fɔe
fɔlɔ
fɛ
fọ
g
ga
ga-GB
ga-IE
ga_GB
ga_IE
gaa
gaa-GH
gaa_GH
gada
gas
gask
gaskavahkku
gatandatu
gatandatũ
gatano
gatantatũ
gatanu
gatatu
gatatũ
gbãtɔ
gd
gd-GB
gd_GB
geas
geassemánnu
geg
gegužė
gegužės
gen
gener
genièr
gennaio
gez
gez-ER
gez-ET
gez_ER
gez_ET
ghe
ghennàrgiu
ghwa
ghɔ
ghɨ
gi
gic
gie
gievgia
gio
giovedì
giu
giugno
giò
giòbia
giờ
gl
gl-ES
gl_ES
gli
glindesdi
gln
gn
gn-PY
gn_PY
gnd
gnu
golg
golggotmánnu
goude
gru
grudnia
grudzień
gruod
gruodis
gruodžio
gsw
gsw-CH
gsw-FR
gsw-LI
gsw_CH
gsw_FR
gsw_LI
gtu
gu
gu-IN
gu_IN
gulan
guov
guovvamánnu
guovvamánnu:a
gush
gusht
guurɛ
guz
guz-KE
guz_KE
gv
gv-IM
gv_IM
gwa
gÿo
gɔ
h
h'h'mm
h'h'mm:ss
h'ê
h-alt-ascii
h-ին
h.mm
h.mm.ss
h.mm:ss
h:mm
h:mm'ê
h:mm-ին
h:mm:ss
h:mm:ss'ê
h:mm:ssB
h:mmB
h:mma
hAoine
hB
ha
ha-Arab
ha-Arab-NG
ha-Arab-SD
ha-GH
ha-NE
ha-NG
ha_Arab
ha_Arab_NG
ha_Arab_SD
ha_GH
ha_NE
ha_NG
haftası
haihuwar
haw
haw-US
haw_US
hayashuh
hbi
he
he-IL
he_IL
hefteya
heinä
heinäk
heinäkuu
heinäkuuta
helmi
helmik
helmikuu
helmikuun
helmikuuta
helmikuutata
hepde
hete
hezîran
hh
hh:mm
hh:mm:ss
hi
hi-IN
hi-Latn
hi-Latn-IN
hi_IN
hi_Latn
hi_Latn_IN
hidatu
hihanu
hik
hil
hiruhilekoa
hitayi
hivili
hm
hm-alt-ascii
hms
hms-alt-ascii
hmsv
hmsv-alt-ascii
hmsvvvv
hmv
hmv-alt-ascii
hmvvvv
hnj
hnj-Hmnp
hnj-Hmnp-US
hnj_Hmnp
hnj_Hmnp_US
hodź
hono
hoore-biir
hour
hr
hr-BA
hr-HR
hr_BA
hr_HR
hsb
hsb-DE
hsb_DE
hu
hu-HU
hu_HU
huhti
huhtik
huhtikuu
huhtikuuta
hutala
huɗu
hy
hy-AM
hy_AM
hzr
hétfő
hën
hënë
hós
hósdagur
həftə
hɛmbuɛrí
hی
h시
i
i1
i2
i3
i4
ia
ia-001
ia_001
ian
ianuarie
iaâ
ibiri
ibr
ibrir
ichamthi
icheheavo
ichiibɔd
ichika
id
id-ID
id_ID
idiɓa
időszámításunk
idɛ́n
id́ɛ́n
ie
ig
ig-NG
ig_NG
igandea
igihembwe
ii
ii-CN
ii_CN
ika'-W
ika'-w
ika-1
ika-2
ika-3
ika-37
ika-4
ika-51
ika-6
ikenda
ikota
ikumi
ikũmi
ile
ils
ilĩ
im
imbiri
ime
imeg
imet
imweri
iməg
imɛŋ
in
inet
ing
inkókúâ
inn
innayr
inya
io
io-001
io_001
ira
ira.ren
iraila
irailaren
irũdisawa
irũdí
is
is-IS
is_IS
isiet
isz
it
it-CH
it-IT
it-SM
it-VA
it_CH
it_IT
it_SM
it_VA
iu
iu-CA
iu-Latn
iu-Latn-CA
iu_CA
iu_Latn
iu_Latn_CA
iul
iulie
iun
iunie
iwi
iyl
iyn
iyo
iyul
iyun
iýul
iýun
j
jKr
ja
ja-JP
ja_JP
jaan
jaanuar
jamanoo
jan
janar
janeiro
januaari
januaarip
januar
januara
januari
januario
január
januára
janv
janvier
janvāris
janúar
java
jbo
jbo-001
jbo_001
jen
jenaro
jeu
jeudi
jezu
jgo
jgo-CM
jgo_CM
jimweri
jine
jiɔakdiɛn
jmc
jmc-TZ
jmc_TZ
jo
joi
joibe
jol
jolal
jon
joulu
jouluk
joulukuu
joulukuun
joulukuuta
joulukuutata
jov
jovedi
jraspass
jue
jueves
jug
jugno
jui
juil
juill
juillet
juin
juk
juko
jul
julhet
julho
juli
julij
julija
julio
juliol
jum
juma
jumwa
jun
junh
junho
juni
junij
junija
junio
juny
juov
juovlamánnu
juovlamánnu:a
juovlâ
juovlâmáánu
juuli
juulip
juuni
juunip
jv
jv-ID
jv_ID
jälkeen
jôn
júl
júla
július
júlí
júm
júmbá
jún
júna
június
júní
jūl
jūlijs
jūn
jūnijs
jǝǝ
jǝǝdí
k
k.Y
k1
k2
k3
k4
ka
ka-1
ka-2
ka-3
ka-4
ka-GE
ka_GE
kaa
kaana
kab
kab-DZ
kab_DZ
kabiri
kadadu
kaiboirwe
kaili
kaj
kaj-NG
kaj_NG
kalo
kam
kam-KE
kam_KE
kan
kana
kanana
kane
kang’ama
kaping
kar
karandadu
kari
kasanu
katano
katatu
katatũ
kathatu
kathatũ
katikupíen
katërt
kawi
kaĩri
ka̱n
kcg
kcg-NG
kcg_NG
kde
kde-TZ
kde_TZ
ke
ke'-W
ke'-w
ke-1
ke-2
ke-3
ke-37
ke-4
ke-51
ke-6
kea
kea-CV
kea_CV
kedd
kee
kel
kele
kelĩ
ken
ken-CM
ken_CM
kenda
kerĩ
kesi
kesich
kesimáánu
keskiviikko
keskiviikkona
kesä
kesäk
kesäkuu
kesäkuuta
ketv
ketvirtadienis
ketvirtis
ketwirtiks
kgp
kgp-BR
kgp_BR
khaoǃgâ
khq
khq-ML
khq_ML
ki
ki-KE
ki_KE
kikiiɗe
killapa
kin
kingoto
kinta-fera
kiri
kisɛ́ndɛ
kiɛmɛ́ɛm
kk
kk-KZ
kk_KZ
kkj
kkj-CM
kkj_CM
kl
kl-GL
kl_GL
kln
kln-KE
kln_KE
km
km-KH
km_KH
kmp
kn
kn-IN
kn_IN
kny
ko
ko-KP
ko-KR
ko_KP
ko_KR
kok
kok-IN
kok_IN
kol
kolmapäev
kolovoz
kolovoza
koosk
kor
korr
korrik
korse
kos
koskoho
koskokko
kov
kovas
kovo
kpa
kpe
kpe-GN
kpe-LR
kpe_GN
kpe_LR
kris
krisiti
krizmed
krn
krísimin
ks
ks-Arab
ks-Arab-IN
ks-Deva
ks-Deva-IN
ks_Arab
ks_Arab_IN
ks_Deva
ks_Deva_IN
ksb
ksb-TZ
ksb_TZ
ksf
ksf-CM
ksf_CM
ksh
ksh-DE
ksh_DE
kt
ktu
ktubr
ku
ku-TR
ku_TR
kua
kuarta-fera
kuartal
kuartal-ka
kuata
kud
kugú
kumi
kumwe
kuni
kuovâ
kuovâmáánu
kutúan
kuŋgwɛ
kuɔth
kuɖ
kuɖa
kv
kvartal
kvartalet
kvt
kvě
květen
května
kw
kw-GB
kw1
kw2
kw3
kw4
kw_GB
kwa
kwambĩlĩlya
kwanza
kwart
kwartaal
kwartal
kwartals
kwartał
kwasú
kwe
kwi
kwiecień
kwietnia
kwédi
ky
ky-KG
ky_KG
kyiukonyi
kysã-tẽgtũ
kyumwa
kàg
kándíɛ
kátánuɛ
kátátúɛ
kátíɛ
kénie
kí
kíkíríg
kíní
kúpélimetúkpiapɛ
kĩrĩ
kǝ
kǝbǝk
kǝbɔpka
kǝbɛ́ɛ
kǝnin
kǝráá
kɔn
kɔs
kɔsiɖa
kɔta
kɔɔ
kɔɔriɛn
kɨ
kɨbâ
kɨz
kỹ
l
la
la-VA
la_VA
lag
lag-TZ
lag_TZ
lahadi
language
lapkr
lapkritis
lapkričio
lapkrūtis
larunbata
lau
lauantai
lauantaina
laugardagur
laupäev
laurdag
la̱t
lb
lb-LU
lb_LU
le
led
leden
ledna
lepyè
leta
letopočtem
letopočtu
ley
leygardagur
lg
lg-UG
lg_UG
li
lia
lib
libwa
libóso
liep
liepa
liepos
lij
lij-IT
lij_IT
lilli
lin
lindi
linggo
linji
lip
lipanj
lipca
lipiec
lipnja
lis
listopad
listopada
listopadu
litandi
liɓ
lkt
lkt-US
lkt_US
llu
llunes
lmo
lmo-IT
lmo_IT
ln
ln-AO
ln-CD
ln-CF
ln-CG
ln_AO
ln_CD
ln_CF
ln_CG
lo
lo-LA
lo_LA
locale
loka
lokak
lokakuu
lokakuuta
lon
loro
lr
lrc
lrc-IQ
lrc-IR
lrc_IQ
lrc_IR
lt
lt-LT
lt_LT
lu
lu-CD
lu_CD
lug
luggio
luglio
luj
lujo
luma lwa p
lun
lundi
lundo
lundì
lunedi
lunedì
lunes
lunesdì
luni
lunis
luns
luo
luo-KE
luo_KE
lut
lutego
luty
luy
luy-KE
luy_KE
lv
lv-LV
lv_LV
lyanchechi
lyannyano
lyapili
lyatatu
lyɛ'̌ʼ
lyɛʼɛ́
lyɛ̌ʼ
làm
làmpadas
lá
lála
láv
lávurduv
lávurdâh
lávvardat
lávvordat
lätni
lóndɛ́
lör
lördag
lør
lørdag
lùm
lěta
līpa
lǝn
lǝndí
lɔm
lɔmbi
lɛɛnɛ
m
m.Kr
m.Y.K
m.a
m.g.n.Y
m.ss
m.z.Y
m.ē
m:ss
mKr
ma
maa
maadí
maaji
maajip
maalis
maalisk
maaliskuu
maaliskuuta
maanantai
maanantaina
maandag
maart
mabágá
mac
mad
madiɓɛ́díɓɛ́
mafú
mag
maggio
mai
mai-IN
mai_IN
maiatza
maig
maijs
maio
maj
maja
majebaargâ
majebargâ
majo
maju
makandikɛ
makeo
man
mandag
maná
mar
marca
mardi
mardo
mardì
marec
marisi
marlunngorneq
marras
marrask
marraskuu
marraskuuta
mars
marsi
marsip
marso
mart
martars
martedi
martedì
martes
marti
martie
martio
martis
marts
martxoa
martzu
martë
marz
marzec
marzo
marzu
març
março
marți
mas
mas-KE
mas-TZ
mas_KE
mas_TZ
masa
masg
mat
matg
matáhra
mavili
maw
mawbaare
mawnde
may
mayo
mayu
mayyu
mayésɛ́
mazzo
maí
maý
maŋ
maŋa
maŋŋebárga
maŋŋel
maṛ
maṛṣ
mb.K
mb.Ys
mbas
mbaʼámbaʼ
mbaꞌmbaꞌ
mbe
mbee
mbegtug
mbere
mbii
mbili
mbiyɔ
mbl
mbo
mbooy
mbs
mbúsa
mbÿɛ
mbūs
mbɔ
mbɔk
mbɔ́ɔntè
mbəŋchubi
mbʉ̀ŋ
mchochil’l
md
mdf
mdf-RU
mdf_RU
me
mei
mej
meja
meje
mejwoŋó
mem
memleɖa
mer
mer-KE
mer_KE
mercoldì
mercoledì
mercredi
mercuridi
merkredi
merkredo
mesemna
mesiŋ
metúkpíápɛ
mfe
mfe-MU
mfe_MU
mfungade
mg
mg-MG
mg_MG
mgh
mgh-MZ
mgh_MZ
mgo
mgo-CM
mgo_CM
mi
mi-NZ
mi_NZ
mie
miercuri
miercus
mies
miessemánnu
mijdar
mik
mikudagur
miloddan
milodiy
min
minggu
minkɛ
mis
mit
mituú
miz
mié
miércoles
mið
miðvikudagur
mjd
mjesec
mk
mk-MK
mk_MK
ml
ml-IN
ml_IN
mm
mm.ss
mm:ss
mmk
mms
mmss
mn
mn-MN
mn-Mong
mn-Mong-CN
mn-Mong-MN
mn_MN
mn_Mong
mn_Mong_CN
mn_Mong_MN
mni
mni-Beng
mni-Beng-IN
mni-Mtei
mni-Mtei-IN
mni_Beng
mni_Beng_IN
mni_Mtei
mni_Mtei_IN
mo
moandei
mocha
moh
moh-CA
moh_CA
mohammad
moies
moja
mokɔlɔ
mor
morso
motóbá
mps
mpu
mpókwa
mpɔ́sɔ
mr
mr-IN
mr_IN
mrt
ms
ms-Arab
ms-Arab-BN
ms-Arab-MY
ms-BN
ms-ID
ms-MY
ms-SG
ms_Arab
ms_Arab_BN
ms_Arab_MY
ms_BN
ms_ID
ms_MY
ms_SG
msi
mst
mt
mt-MT
mt_MT
mtn
mto
mua
mua-CM
mua_CM
mugore
muk
mukũi
mukũisawa
mukɔ́sú
mulungu
mun
muonza
mur
murakipí
murakí-mukũi
murakí-musapíri
mus
mus-US
mus_US
musapíri
musapíri-yasí
musapírisawa
mut
muányáŋmóndie
muʻa
mvfò
mw
mwa
mwambe
mwd
mwedzi
mwom
my
my-MM
my_MM
myv
myv-RU
myv_RU
mzn
mzn-IR
mzn_IR
màga
má
mába
máj
mája
május
málal
mán
mána
mánadagur
mánnodat
mánudagur
márc
március
mäcordì
märts
mätesdì
må
mån
måndag
mèr
mèrcore
mèrcuris
mé
mér
mércores
mër
mërkurë
míbalé
mínei
mínéi
mísáto
mítáno
móndie
měr
měrc
měrca
mũgwanja
mūsu
mɔnɔ
mɔ́
mɔ́n
mɔ́ndi
mɔ́ndɔ
mɔ́s
mɔ́sú
mɔ̌kɔ́
məlú
mə́bɛ̌
mə́lɛ́
mə́nyi
mɛ
mɛk
mɛkrɛdí
mɛndoŋgɔ
mɛrkɛrɛdi
mɛŋguꞌ
m분
n
n'‘'ime
n.C
n.Chr
n.K
n.Kr
n.M
n.e
n.l
n.év
nC
na
naa
naaninan
naasaande
nad
nadale
nadīli
nakayamayasuhiro1986
nam
nane
naq
naq-NA
naq_NA
narodźenjom
narodźenju
naroźenim
naroźenju
naszej
naszą
navǔr
našeho
naším
nb
nb-NO
nb-SJ
nb_NO
nb_SJ
ncwònzém
nd
nd-ZW
nd_ZW
nds
nds-DE
nds-NL
nds_DE
nds_NL
ndu1
ndu2
ndu3
ndu4
ndzɔ̀ŋèfwòo
ndzɔ̀ŋèsèe
ndzɔ̀ŋɔ̀chwaʔàkaa
ndzɔ̀ŋɔ̀dùmlo
ndzɔ̀ŋɔ̀ghǔuwelɔ̀m
ndzɔ̀ŋɔ̀kwîfɔ̀e
ndzɔ̀ŋɔ̀kƗ̀zùʔ
ndzɔ̀ŋɔ̀nzùghò
ndzɔ̀ŋɔ̀nùm
ndzɔ̀ŋɔ̀tƗ̀dʉ̀ghà
ndzɔ̀ŋɔ̀tƗ̀fʉ̀ghàdzughù
ndzɔ̀ŋɔ̀tǎafʉ̄ghā
ndátúɛ
ndúmbū
ne
ne-IN
ne-NP
ne_IN
ne_NP
nebo
ned
nedelja
nedeľa
nedjelja
nedēļa
neděle
negyedév
nei
nelj
neljapäev
neljännes
netai
ng
ng1
ng10
ng11
ng2
ng3
ng4
ng5
ng6
ng7
ng8
ng9
nga
ngab
ngad
ngb
nge
ngl
ngm
ngn
ngo
ngs
ngt
nguwo
ngwaga
ngwóŋ
ngwɔ̀ʼ
ngwə̀t
ngwɛn
ngz
ngày
ngɔn
ngəgógəle
nhiam
ni
nia
niedz
niedziela
nin
nish
niydziela
niälj
niäljádâs
nja
njapi
njaŋgumba
nje
njealjádas
njedźela
njeslaare
njeźela
njuhčâ
njuhčâmáánu
njuk
njukčamánnu
njÿoláʼ
nl
nl-AW
nl-BE
nl-BQ
nl-CW
nl-NL
nl-SR
nl-SX
nl_AW
nl_BE
nl_BQ
nl_CW
nl_NL
nl_SR
nl_SX
nmg
nmg-CM
nmg_CM
nn
nn-NO
nn_NO
nnb
nnd’atu
nne
nnh
nnh-CM
nnh_CM
nnl
nnny
nno
no
noh
noiembrie
nomëttes
nov
novam
nove
novembar
novembari
novembarip
november
novembra
novembre
novembris
novembro
novenbre
noviembre
now
nowanburu
nowember
nowembra
noy
noyabr
noý
noýabr
nqo
nqo-GN
nqo_GN
nr
nr-ZA
nr_ZA
nsambo
nsima
nsn
nso
nso-ZA
nso_ZA
nsámbá
ntlha
nts
ntɔ́ngɔ́
ntɔ́ntɔ
ntɔ́ntɔ́
ntɛ
ntɛk
ntɛnɛ
num
numĩggu
nus
nus-SS
nus_SS
nuw
nuwanbir
nv
nv-US
nv_US
nvb
nvúr
ny
ny-MW
ny_MW
nya
nyaanya
nyiaghuo
nyina
nyn
nyn-UG
nyn_UG
nyukul
nyá
nyɛt
nyɛtɛki
nze
nzu
nädal
nën
nëntor
ní
nîsan
nóv
nóvember
nùm
năm
nɔy
nɔ̂y
n‘ime
n tmeddit
n tufat
o
o.1
o.10
o.11
o.12
o.2
o.3
o.4
o.5
o.6
o.7
o.8
o.9
o.Kr
oKr
obiro
obo
oc
oc-ES
oc-FR
oc_ES
oc_FR
och
ochobre
oct
october
octobre
octombrie
octubre
of
og
okko
okt
oktabr
oktob
oktobar
oktobari
oktobarip
oktober
oktobra
oktobris
oktoober
oktyabr
október
októbra
oktýabr
okuni
om
om-ET
om-KE
om_ET
om_KE
on
ondoren
ong’wan
ons
onsdag
or
or-IN
or_IN
orthography
os
os-GE
os-RU
os_GE
os_RU
osa
osa-US
osa_US
osebiro
osteguna
ostirala
osú
osúsúa
oto
otobre
otover
otrd
otrdiena
ots
ots.ren
otsaila
otsailaren
ott
ottobre
otâ
out
outubro
ovdal
oyk
oóli
oólí
ođđajagemánnu
ođđj
ožu
ožujak
ožujka
oṣù
p
p.C
p.Chr
p.K
p.m
p.m.ē
p.n.e
pKr
pa
pa-Arab
pa-Arab-PK
pa-Guru
pa-Guru-IN
pa_Arab
pa_Arab_PK
pa_Guru
pa_Guru_IN
pamba
pamilau
pamunyi
panadīli
pap
pap-AW
pap-CW
pap_AW
pap_CW
papat
para
parë
pas
pasepeeivi
pasepeivi
pay
payares
payshanba
paź
październik
października
pcm
pcm-NG
pcm_NG
pdC
pe
pekan
pekô
pen
penktadienis
penşenbe
perjantai
perjantaina
pertama
pet
petak
petek
pi
piatok
piektd
piektdiena
pikítíkítie
pilɔndɔ́
pin
pingasunngorneq
pir
pir-kurã-há
pirmadienis
pirmd
pirmdiena
pirms
pis
pis-SB
pis_SB
pisan
pisuyú
pi 22. decembra 1995, 09:05:02
piątek
piōntek
piştî
pja
pjatk
pl
pl-PL
pl_PL
pm
pm06:30:30
pn
po
pod
pon
pondelok
pondělí
ponedeljak
ponedeljek
ponedjeljak
poniedziałek
pop
porge
porgemáánu
poslije
post
po połedniu
pr
pr.n.e
pre
pred
premte
prg
prg-001
prg_001
pri
prieš
prije
prill
pro
prosinac
prosinca
prosince
prosinec
prvi
przed
ps
ps-AF
ps-PK
ps_AF
ps_PK
pt
pt-AO
pt-BR
pt-CH
pt-CV
pt-GQ
pt-GW
pt-LU
pt-MO
pt-MZ
pt-PT
pt-ST
pt-TL
pt_AO
pt_BR
pt_CH
pt_CV
pt_GQ
pt_GW
pt_LU
pt_MO
pt_MZ
pt_PT
pt_ST
pt_TL
ptm
pu
pussisawaiti
pustis
putúk,oóli
puɔs
py
pyńdziałek
pá
pátek
pá %-d. prosince 1995, 09:05:02
pärast
pén
pénkar-kurã-há
péntek
pêncşem
pó
pón
póndźela
pónjeźele
pú
pú-irũdí
pú-mukũi
pú-musapíri
pú-yepé
pühapäev
pēntniks
pět
pětk
př
př.Chr.n
př.n.l
před
pś.Chr.n
pśed
pşm
pūlis
pɛt
q
qer
qershor
qu
qu-BO
qu-EC
qu-PE
qu_BO
qu_EC
qu_PE
qua
quarta
quarta-feira
quartal
quarter
quc
quc-GT
quc_GT
qui
quinta
quinta-feira
quý
rags
raj
raj-IN
raj_IN
ramambo
ranar
rbn
rbreiddal
reede
rhg
rhg-Rohg
rhg-Rohg-BD
rhg-Rohg-MM
rhg_Rohg
rhg_Rohg_BD
rhg_Rohg_MM
rif
rif-MA
rif_MA
rm
rm-CH
rm_CH
rn
rn-BI
rn_BI
ro
ro-MD
ro-RO
ro_MD
ro_RO
rof
rof-TZ
rof_TZ
roka
roku
roovvâd
roovvâdmáánu
ru
ru-BY
ru-KG
ru-KZ
ru-MD
ru-RU
ru-UA
ru_BY
ru_KG
ru_KZ
ru_MD
ru_RU
ru_UA
rugp
rugpjūtis
rugpjūčio
rugs
rugsėjis
rugsėjo
ruj
rujan
rujna
rw
rw-RW
rw_RW
rwk
rwk-TZ
rwk_TZ
ráithe
ráá
rég
régre-kurã-há
rêbendan
rɛbvuâ
s
sa
sa-IN
sa_IN
saal
sab
saba
sabanan
sabato
sabattika
sabbato
sabbo
sabet
sabide
sabo
sah
sah-RU
sah_RU
sai
sakkis
sallaws
sam
samdi
samdí
samedi
saməna
santandria
santugaine
sap
sapa
sapaat
saq
saq-KE
saq_KE
sas
sat
sat-Deva
sat-Deva-IN
sat-Olck
sat-Olck-IN
sat_Deva
sat_Deva_IN
sat_Olck
sat_Olck_IN
sati
satin
sau
saurú
saus
sausio
sausis
sav
savnu
saŋ
sbp
sbp-TZ
sbp_TZ
sbt
sbta
sbtê
sc
sc-IT
sc_IT
schan
schaner
scn
scn-IT
scn_IT
sd
sd-Arab
sd-Arab-PK
sd-Deva
sd-Deva-IN
sd_Arab
sd_Arab_PK
sd_Deva
sd_Deva_IN
sdh
sdh-IQ
sdh-IR
sdh_IQ
sdh_IR
se
se-FI
se-NO
se-SE
se_FI
se_NO
se_SE
seachdain
seachtain
sedmica
see
seeɗto
seg
segunda
segunda-feira
seh
seh-MZ
seh_MZ
sekmadienis
seld
selmana
semaine
semana
sen
send
sentabr
sentyabr
sentýabr
senũdé
sep
sept
septam
septembar
septembari
septembarip
september
september:
septembra
septembre
septembrie
septembris
septiembre
septimana
ses
ses-ML
ses_ML
seshanba
sesta-fera
sestd
sestdiena
set
setemana
setember
setembre
setembro
setenbre
setiembre
setmana
sett
settember
settembre
settimana
sex
sexta
sexta-feira
sg
sg-CF
sg_CF
sginer
sgiovedì
sgiugn
sh
shahulembela
shahuviluha
shanba
shi
shi-Latn
shi-Latn-MA
shi-Tfng
shi-Tfng-MA
shi_Latn
shi_Latn_MA
shi_Tfng
shi_Tfng_MA
shk
shkurt
shn
shn-MM
shn-TH
shn_MM
shn_TH
sht
shtator
shtunë
shúm
si
si-LK
si_LK
sia
siamlɔm
sib
sibat
sibata
sibatê
sibiri
sid
sid-ET
sid_ET
sie
sierpień
sierpnia
sig
sigunda-fera
sii
siilo
siilto
sij
siječanj
siječnja
sike
sillins
simana
simỹnỹ
sis
sisamanngorneq
sita
siyrpnia
sizhun
siş
sişenbe
siɓiti
siɛyɛ́
sjedmica
sk
sk-SK
sk_SK
skammâ
skammâmáánu
skáb
skábmamánnu
sl
sl-SI
sl_SI
sld
slt
sma
sma-NO
sma-SE
sma_NO
sma_SE
smb
smj
smj-NO
smj-SE
smj_NO
smj_SE
sml
smn
smn-FI
smn_FI
sms
sms-FI
sms_FI
sn
sn-ZW
sn_ZW
snd
snein
sneon
so
so-DJ
so-ET
so-KE
so-SO
so_DJ
so_ET
so_KE
so_SO
sob
sobota
somok
sonda
sotn
sotnabeaivi
so %-d. září -10, 04:44:23
so 15. septembra -10, 04:44:23
soň
soŋ
spal
spalio
spalis
spallins
sq
sq-AL
sq-MK
sq-XK
sq_AL
sq_MK
sq_XK
sr
sr-Cyrl
sr-Cyrl-BA
sr-Cyrl-ME
sr-Cyrl-RS
sr-Cyrl-XK
sr-Latn
sr-Latn-BA
sr-Latn-ME
sr-Latn-RS
sr-Latn-XK
sr_Cyrl
sr_Cyrl_BA
sr_Cyrl_ME
sr_Cyrl_RS
sr_Cyrl_XK
sr_Latn
sr_Latn_BA
sr_Latn_ME
sr_Latn_RS
sr_Latn_XK
sre
sreda
sri
srijeda
srj
srjeda
srjoda
srp
srpanj
srpen
srpna
srpnja
ss
ss-SZ
ss-ZA
ss_SZ
ss_ZA
ssy
ssy-ER
ssy_ER
st
st-LS
st-ZA
stA
stG
st_LS
st_ZA
stand-alone
stb
streda
strzoda
stu
studeni
studenoga
stw
stwórtk
sty
styczeń
stycznia
středa
su
su-Latn
su-Latn-ID
su_Latn
su_Latn_ID
sub
subaka
subota
suenter
sukul
sun
sungula
sunnudagur
sunnuntai
sunnuntaina
suno
suoi
suoidnemánnu
sup
supapá
sv
sv-AX
sv-FI
sv-SE
sv_AX
sv_FI
sv_SE
svi
svibanj
svibnja
svētd
svētdiena
sw
sw-CD
sw-KE
sw-TZ
sw-UG
sw_CD
sw_KE
sw_TZ
sw_UG
syeini
syeinimáánu
syntymän
syntymää
syr
syr-IQ
syr-SY
syr_IQ
syr_SY
syys
syysk
syyskuu
syyskuun
syyskuuta
syyskuutata
sz
szept
szeptember
szerda
szerint
szl
szl-PL
szl_PL
szombat
sztwortek
sàb
sàbadu
sáb
sábado
sábadu
sánzá
sárúwá
sásadi
sâm
sâmbătă
sér
séradé
séselé
sêşem
sön
söndag
sø
søn
søndag
săptămâna
sīmenis
sşm
sɔndi
sɔŋ
sɔŋɛ
sɔ́n
sɔ́ndiɛ
sɔ́ndǝ
sɔ́ndɔ
sɛt
sɛtanburu
sɨ
sẅíŋtè
sẽmãna
s초
t
t-Iuchar
t-Samhain
t-Sultain
t-Ògmhios
ta
ta'’
ta-IN
ta-LK
ta-MY
ta-SG
ta_IN
ta_LK
ta_MY
ta_SG
taa
taai
tadggʷat
tal
talalit
talata
tallimanngorneq
tammi
tammik
tammikuu
tammikuuta
tannaza
tanu
tar
tarata
taʻu
ta’
tbx
te
te-IN
te_IN
tebax
ted
teden
tedoxe
teisipäev
telu
teo
teo-KE
teo-UG
teo_KE
teo_UG
ter
tersa-fera
terça
terça-feira
tet
tetor
tg
tg-TJ
tg_TJ
th
th-TH
th_TH
thanthatũ
thanu
thar
the
thg
tháng
ti
ti-ER
ti-ET
ti_ER
ti_ET
tifawt
tig
tig-ER
tig_ER
tiisdei
tiistai
tiistaina
time
time?
tin
tiníní
tir
tirs
tirsdag
tis
tisa
tisdag
tjedan
tk
tk-TM
tk_TM
tn
tn-BW
tn-ZA
tn_BW
tn_ZA
to
to-TO
to_TO
toddobaadka
tok
tok-001
tok_001
tolu
tomon
tongersdei
tor
torek
tors
torsdag
torstai
torstaina
touko
toukok
toukokuu
toukokuuta
tpi
tpi-PG
tpi_PG
tr
tr-CY
tr-TR
tr_CY
tr_TR
tra
travanj
travnja
tremujori
tretë
treći
trečiadienis
trešd
trešdiena
trim
trimes
trimestre
trimestri
trimestrul
trimiziad
triwulan
trm
trv
trv-TW
trv_TW
trw
trw-PK
trw_PK
trì
trìulas
ts
ts-ZA
ts_ZA
tsalo
tsetsáʼ
tsetsɛ̀ɛ
tsuʔndzɨkɔʔɔ
tsuʔntsɨ
tsuʔughɔe
tsuʔughɨ̂m
tsuʔukpà
tsuʔumè
tsuʔutɔ̀mlò
tsètsɛ̀ɛ
tsɛttsɛt
tsɛ̀ɛ
tt
tt-RU
tt_RU
tuarua
tuatahi
tuatoru
tuawhā
tuo
tuorâstuv
tuorâstâh
tuần
twq
twq-NE
twq_NE
ty
tydz
tydźeń
tys
tysdag
tyźeń
tyɛ̀b
tzm
tzm-MA
tzm_MA
tàŋa
táabɛɛ
táafɔk
táan
táanin
táaraa
tána
tèsiʼe
tî
tîrmeh
týden
týs
týsdagur
týždeň
tǝn
tɔm
tɔ́
tɛɛnɛɛ
tɨd
tẽg
tẽgtũ-kurã-há
u
uKilisito
ua
ug
ug-CN
ug_CN
ugbâ
uge
ugu
uike
uk
uk-UA
uk_UA
uke
uken
uku
ukw
uluchelo
ume
unang
unayeli
und
unecheshe
uneraru
unethanu
ur
ur-IN
ur-PK
ur_IN
ur_PK
urr
urria
urt
urtarrila
urteko
usïö
ut
uti
uto
utorak
utorok
utuko
uum
uz
uz-Arab
uz-Arab-AF
uz-Cyrl
uz-Cyrl-UZ
uz-Latn
uz-Latn-UZ
uz_Arab
uz_Arab_AF
uz_Cyrl
uz_Cyrl_UZ
uz_Latn
uz_Latn_UZ
uzt
uztaila
uđiv
uđđâivemáánu
v
v('y')'ê
v.C
v.Chr
v.M
vC
va
vahkku
vai
vai-Latn
vai-Latn-LR
vai-Vaii
vai-Vaii-LR
vai_Latn
vai_Latn_LR
vai_Vaii
vai_Vaii_LR
van
vandredi
vanti
vas
vasario
vasaris
vasárnap
vaŋdɛrɛdi
ve
ve-ZA
ve_ZA
vec
vec-IT
vec_IT
vecka
vedu
veebr
veebruar
veke
velj
veljača
veljače
ven
venardì
venderdi
vendredi
vendredo
venerdi
venerdì
venres
vi
vi-VN
vi_VN
vie
vienres
viernes
viikko
vika
viku
vin
vinars
vineri
viz
vo
vo-001
vo_001
voalohany
voor
vorm
vr
vrijdag
vumbirhi
vumune
vun
vun-TZ
vun_TZ
vunharhu
vuo
vuoden
vuos
vuossaargâ
vuossargâ
vuossárga
vvvv
vyesi
vyesimáánu
vás
vástuppeeivi
vástuppeivi
vèn
vènare
vür
vẽn
vẽnhkãgra-kurã-há
w
w'em
w'ª
w'º
w-'hafta
w-'il
w-'аптасы
w-'й
w-'мӗш
w-'р
w-'я
w-'ҳафта
w-ին
w-րդ
w-ھەپتە
w.'ª
wa
wa-BE
wa_BE
waare
wae
wae-CH
wae_CH
wal
wal-ET
wal_ET
wanja
wassarins
watapa
wał
wałtora
wbp
wbp-AU
wbp_AU
week
wer
wichishu
wike
wiki
wis-kraḍ
wis-kuẓ
wis-sin
wisasīdis
wo
wo-SN
wo_SN
woansdei
woensdag
world
wrz
wrzesień
września
wt
wtorek
wudatu
wuhanu
wum
wunyanya
wut
wutai
wutora
wuvili
wythnos
wä
wótp
wم
wতম
wవ
w’indwi
w번째
x
xan
xaneiro
xh
xh-ZA
xh_ZA
xin
xineru
xnt
xog
xog-UG
xog_UG
xov
xoves
xue
xueves
xul
xullo
xun
xunetu
xunu
xuño
y
y'an
y('e')'ko
y-'ж
y-'ӕм
y-M
y-M-d
y-MM
y-MM-dd
y-d-M
y-d-M،
y-dd-MM
y.MM.dd
y.e
y/M
y/M/d
y/M/d(E
y/M/dE
y/M/dEEEE
y/M/d（E）
y/MM
y/MM/dd
y/QQQ
yG
yM
yMEEEEd
yMEd
yMEd-alt-variant
yMM
yMMM
yMMMEEEEd
yMMMEd
yMMMM
yMMMMEEEEd
yMMMMEd
yMMMMccccd
yMMMMd
yMMMd
yMMdd
yMd
yMd-alt-variant
yQ
yQQQ
yQQQQ
ya
yagatato
yakabere
yakane
yakshanba
yakwe
yambo
yan
yanvar
yar
yarkomaa
yasu47b
yav
yav-CM
yav_CM
yaw
yawoɖa
ybo
ye
yedi
yekşem
yel’li
yeni
yepé
yepé-mukũi
yepé-putimaã
yepé-yepé
yepésáwa
yesi-1
yesi-2
yesi-3
yesi-4
yesu
yi
yi-001
yi_001
yie̱tni
ym
yo
yo-BJ
yo-NG
yo_BJ
yo_NG
yoku-1
yp
yrl
yrl-BR
yrl-CO
yrl-VE
yrl_BR
yrl_CO
yrl_VE
yue
yue-Hans
yue-Hans-CN
yue-Hant
yue-Hant-HK
yue_Hans
yue_Hans_CN
yue_Hant
yue_Hant_HK
yuk
yukuakú
yul
yulyuz
yun
yunyu
yw-count-few
yw-count-many
yw-count-one
yw-count-other
yw-count-two
yw-count-zero
yy
yyyyMM
yálɛ
yáɓe
yılının
yşm
y၊
y年
y年M月
y年M月d日
y年M月d日(E
y年M月d日E
y年M月d日EEEE
y年M月d日，E
y年QQQ
y年QQQQ
y年第Q季度
y년
z
za
zah
zallaws
zamanoo
zamgbála
zan
zanvie
zanwuye
zaterdag
zayînê
ze
zedi
zeg
zenâ
zercl
zercladur
zeuggia
zgh
zgh-MA
zgh_MA
zh
zh-Hans
zh-Hans-CN
zh-Hans-HK
zh-Hans-MO
zh-Hans-SG
zh-Hant
zh-Hant-HK
zh-Hant-MO
zh-Hant-TW
zh_Hans
zh_Hans_CN
zh_Hans_HK
zh_Hans_MO
zh_Hans_SG
zh_Hant
zh_Hant_HK
zh_Hant_MO
zh_Hant_TW
zil
zilye
zin
zo
zob
zoba
zondag
zu
zu-ZA
zu_ZA
zugno
zul
zuluye
zuw
zuwɛn
zyé
zář
září
zò
zómi
·𐑑𐑵
·𐑑𐑵𐑟𐑛𐑱
·𐑒𐑮𐑲𐑕𐑑
·𐑓𐑧
·𐑓𐑧𐑚𐑘𐑵𐑢𐑺𐑰
·𐑓𐑮
·𐑓𐑮𐑲𐑛𐑱
·𐑔𐑻
·𐑔𐑻𐑟𐑛𐑱
·𐑕𐑧
·𐑕𐑧𐑐𐑑𐑧𐑥𐑚𐑸
·𐑕𐑨
·𐑕𐑨𐑛𐑻𐑛𐑱
·𐑕𐑭
·𐑕𐑭𐑙𐑛𐑱
·𐑛𐑭
·𐑛𐑭𐑕𐑧𐑥𐑚𐑸
·𐑡𐑨
·𐑡𐑨𐑙𐑘𐑭𐑢𐑺𐑰
·𐑡𐑫
·𐑡𐑫𐑤𐑲
·𐑡𐑵
·𐑡𐑵𐑯
·𐑢𐑧
·𐑢𐑧𐑙𐑟𐑛𐑱
·𐑥𐑭
·𐑥𐑭𐑙𐑛𐑱
·𐑥𐑱
·𐑥𐑸
·𐑥𐑸𐑗
·𐑪𐑜
·𐑪𐑜𐑭𐑕𐑑
·𐑯𐑴
·𐑯𐑴𐑝𐑧𐑥𐑚𐑸
·𐑱𐑐
·𐑱𐑐𐑮𐑭𐑤
·𐑷𐑒
·𐑷𐑒𐑑𐑴𐑚𐑸
À
Àbám
Àbámɛ́ta
Àbámẹ́ta
Àjj
Àjjuma
Àla
Àlarba
Àárọ̀
Àìk
Àìkú
Á
ÁM
Ápta
Åland
Ç
Ç.A
Ç.a
Ç1
Ç1em
Ç2
Ç3
Ç3em
Ç4
Ç4em
Çar
Çarşamba
Çarşenbe
È
Èr
Èrèl
Èrèlè
Épr
Éprel
Ì
Ìdámɛ́rin
Ìdámẹ́rin
Ìg
Ìgb
Ìgbé
Ìsɛ́g
Ìsɛ́gun
Ìsẹ́g
Ìsẹ́gun
Íne
Î
Ò
Òg
Ògmh
Ògmhios
Ògú
Ògún
Òk
Òktober
Òkú
Òkúdu
Ö
ÖS 6
ÖS 6:30
ÖS 6:30:30
Öig
Öigšte
Önce
ÖÖ 4
ÖÖ 4:44
ÖÖ 4:44:23
ÖÖ 9
ÖÖ 9:05
ÖÖ 9:05:02
Ú
Ý
Ýan
Ýanwar
Ýek
Ýekşenbe
Þ
àbùbì
àdùmbə̀ŋ
ágú
ágúst
ámvus
ápr
április
ársfj
ársfjórðingur
çar
çaryeka
çarşem
çarşenbe
çeyrek
çärýek
çşm
çərşənbə
ékélémkúnupíén
ét
éti
í
ílálo
ínɛ́y
íɓaá
î.Hr
îln
îlna
îlnê
îlon
îlona
îlonê
înainte
înî
ñawpa
ôko
öň
ú
úno
únor
února
út
úterý
út %-d. února 2008, 18:30:30
ûm
ûse
ýan
ýanwar
ýek
ýekşenbe
þri
þriðjudagur
Ā
Āku
Ākuhata
Āpe
Āpereira
Āperira
Č
Četvrti
Čhaŋpȟásapa
Čhaŋwápe-kasná
Čhaŋwápetȟo
Čhaŋwápeǧi
č
čakč
čakčamánnu
čakčamánnu:a
červen
července
červenec
června
čet
četrtek
četrtletje
četvrtak
četvrti
čohčâ
čohčâmáánu
čt
čtvrtek
čtvrtletí
čvc
čvn
ēras
ērā
Ġ
Ġim
Ġm
Ġn
Ġun
Ġunju
ġimgħa
ġimgħat
ġimgħatejn
Ħad
Ħam
Ħd
Ħm
Ĩ
ĨPU
Ĩkl
Ĩkm
Ĩku
Ĩmwe
Ĩpurũ
Ĩtina
Ĩyakwakya
Ĩyawĩoo
ĩkumi
ĩmwe
ĵa
ĵaŭdo
ńlal
ńmba
ńna
ńtan
ńtuó
ńyonos
ńyèe
ńzyé
ńɔ́
Ŋ
Ŋuaan
ŋ
ŋ1
ŋ10
ŋ11
ŋ12
ŋ2
ŋ3
ŋ4
ŋ5
ŋ6
ŋ7
ŋ8
ŋ9
ŋdi
ŋgbanja
ŋge
ŋgi
ŋgisú
ŋgwà
ŋgê
ŋgɔn
ŋgɔndɛ
ŋka mbɔ́t nji
ŋwíí
ŋɔli
říj
říjen
října
Ś
ś
śr
środa
Ş
Şen
Şenbe
Şub
Şubat
şem
şemî
şen
şenbe
şənbə
Š
š
šeštadienis
šoddâm
št
štvrtok
štvrťrok
štw
štwórtk
ŨG
ũmwe
Ž
Žan
Žanwiye
Žuw
Žuweŋ
Žuy
Žuyye
Ɔ
Ɔ-A
Ɔ-O
Ɔberɛfɛw-Obubuo
Ɔbɛsɛ-Ahinime
Ɔjɔ́
Ɔjɔ́b
Ɔjɔ́bɔ
Ɔjɔ́r
Ɔjɔ́rú
Ɔlɔ́ɨ́bɔ́rárɛ
Ɔɛn
Ɔɛnɨ́ɔɨŋɔk
Ɔ̀
Ɔ̀p
Ɔ̀pɛ
Ɔ̀pɛ̀
Ɔ̀w
Ɔ̀wà
Ɔ̀wàrà
Ɛ
ƐY
Ɛisa
Ɛndámâ
Ɛnkakɛnyá
Ɛr
Ɛrɛ̀n
Ɛrɛ̀nà
Ɛt
Ɛtì
Ɛ̀
Ɛ̀b
Ɛ̀bi
Ɛ̀bibi
ƒe
Ɣ
Ɣuc
Ɣuct
ǀHooǂgaeb
ǀKhuuǁkhâb
ǁgoagas
ǂKhoesaob
ǂNûǁnâiseb
ǃHôaǂkhaib
ǃKhaitsâb
ǃKhanni
ǃKhanǀgôab
ǃuias
ɓ.Ys
ɓoso
ɓosó
ɓulɓusɛ
ɓwá
ɔ
ɔku
ɔkutɔburu
ɔnsúmbɔl
ɔsɔn
ɔtb
ɗ
ɗaya
ɗón
ɗónɛsú
əvvəl
ɛisa
ɛ́
ɣ
ɣetrɔ
ɣuc
ɣuct
ɲɛ
ʻ'o
ʻA
ʻAok
ʻAokosi
ʻAp
ʻApelila
ʻAu
ʻAukake
ʻE
ʻEpe
ʻEpeleli
ʻO
ʻOk
ʻOka
ʻOkakopa
ʻOkatopa
ʻo
ʻuluaki
Α
Απρ
Απρίλιος
Απριλίου
Αυγ
Αυγούστου
Αύγ
Αύγουστος
Αὐγ
Αὐγούστου
Αὔγουστος
Δ
Δεκ
Δεκέμβριος
Δεκεμβρίου
Δευ
Δευτέρα
Ι
Ιαν
Ιανουάριος
Ιανουαρίου
Ιουλ
Ιουλίου
Ιουν
Ιουνίου
Ιούλ
Ιούλιος
Ιούν
Ιούνιος
Κ
Κυρ
Κυριακή
Μ
Μάι
Μάιος
Μάρ
Μάρτιος
Μαΐ
Μαΐου
Μαρ
Μαρτίου
Ν
Νοέ
Νοέμβριος
Νοε
Νοεμβρίου
Ο
Οκτ
Οκτωβρίου
Οκτώβριος
Π
Πέμ
Πέμπτη
Παρ
Παρασκευή
Σ
Σάβ
Σάββατο
Σεπ
Σεπτέμβριος
Σεπτεμβρίου
Τ
Τ1
Τ2
Τ3
Τ4
Τετ
Τετάρτη
Τρί
Τρίτη
Φ
Φεβ
Φεβρουάριος
Φεβρουαρίου
Χριστού
Χριστόν
εβδομάδα
μ.Χ
μ.μ
μετά
π.Χ
π.μ
προ
του
τρίμηνο
І
ІІ
ІІІ
Јанвар
А
АМ
Авг
Август
Алт
Алтынньы
Апр
Апрел
Апрель
Аравдугаар
Арван
Атр
Атырдьых
Ахс
Ақпан
Б
Б.Е
Ба
Баасан
Балаҕан
Блҕ
Бэс
Бээтиҥсэ
Бя
Бямба
Біздің
В
Г
Гуравдугаар
Д
Да
Даваа
Дек
Декабр
Декабрь
Долоодугаар
Друго
Душанбе
Дцг
Дшб
Дыццӕг
Дөрөвдүгээр
Есдүгээр
Ж
Желтоқсан
Зургаадугаар
И
Июл
Июль
Июн
Июнь
Ијул
Ијун
К
К1
К2
К3
К4
Клн
Крс
Кулун
Къуырисӕр
Л
Лх
Лхагва
М
МЭ
МЭӨ
Май
Майрӕмбон
Мамыр
Мар
Март
Мартъи
Маусым
Мрб
Мсу
Муус
Мя
Мягмар
Н
Наймдугаар
Наурыз
Ноя
Нояб
Ноябр
Ноябрь
Нојабр
Нэгдүгээр
Ня
Ням
О
Окт
Октябр
Октябрь
Октјабр
Олун
Олунньу
От
Отй
П
ПМ
ПаМ
Панҷшанбе
Пас
ПеМ
Пеш
Прво
Пшб
Пү
Пүрэв
Р
Рождества
С
Сабат
Сбт
Сен
Сент
Сентябр
Сентябрь
Сентјабр
Сешанбе
Сшб
Сэт
Сэтинньи
Сәуір
Т
Тавдугаар
Тамыз
Тохс
Тохсунньу
Треће
У
Ф
Фев
Февр
Феврал
Февраль
Х
Хоёрдугаар
Христа
Христова
Христос
Хрыстова
Хуыцаубон
Хцб
Ц
Цпр
Цыппӕрӕм
Ч
Ч.А
Ч1
Ч2
Ч3
Ч4
Четврто
Чоршанбе
Чшб
Ш
Шанбе
Шнб
Шілде
Ы
Ыам
Э
Ю
Я
Якшанбе
Янв
Январ
Январь
Яшб
а
аввалги
авг
август
августа
августы
авӑн
ад
аеның
аз
азы
айынын
айының
ака
алтынньы
апр
апрел
апрелы
апрель
апреля
април
аравдугаар
арван
атнасы
атырдьых
ауг
аугуст
ахсынньы
ахшамы
аў
аўторак
ақп
ақпан
б
б.з
б.з.д
б.з.ч
б.э.к
баасан
базар
балаҕан
баскыһыанньа
безнең
бейсенбі
бейш
бейшемби
бер
березень
березня
биздин
бн
бс
бэ
бэнидиэнньик
бэс
бямба
біздің
в
вер
верасень
верасня
вересень
вересня
вина
воскресенье
вс
вт
вто
вторник
второ
выр
вырсарникун
вівторок
г
гараг
година
груд
грудень
грудня
гуравдугаар
гыйн
гыйнвар
д
да
даваа
де
дейін
дек
декабр
декабры
декабрь
декабря
декември
дец
децембар
дийнахь
до
долоо
долоодугаар
други
дс
душ
душанба
дуьйна
дцг
дыццӕг
дүй
дүйсенбі
дүйшөмбү
дүш
дүшәмбе
дөрөвдүгээр
е
е.ә
еа
еара
ел
елның
ера
ерамыздан
ере
ери
ертәси
есдүгээр
ж
жек
жексенбі
жекшемби
жел
желтоқсан
жм
жні
жнівень
жніўня
жовт
жовтень
жовтня
жс
жум
жума
жылдың
жұма
заман
заманга
заманымыз
заманымызға
зургаадугаар
и
ишемби
ишм
июл
июлы
июль
июля
июн
июны
июнь
июня
ијл
ијн
ијул
ијун
йил
к
кадәр
кас
кастрычнік
кастрычніка
кб
кв
квартал
квіт
квітень
квітня
кра
красавік
красавіка
крс
кулун
кунран
кунччен
кх
кха
кхаара
кхачале
къуырисӕр
кыбаартал
күнэ
кӀ
кӀи
кӀира
кӑр
кӑрлач
кӗҫ
кӗҫнерникун
л
лип
липень
липня
лист
листопад
листопада
лхагва
лют
лютага
лютий
лютого
люты
ліп
ліпень
ліпеня
ліс
лістапад
лістапада
м
м.а
май
майрӕмбон
майы
мам
мамыр
манай
мар
март
марта
мартъийы
мау
маусым
мая
мај
милади
милод
милоддан
милодий
мрб
муус
мягмар
мјесец
н
н.д
н.д.а
н.е
н.э
наймдугаар
нар
нараджэння
нарӑс
нау
наурыз
нашата
нашої
нд
нед
недела
неделя
недеља
неділю
неділя
недјеља
нов
нове
новембар
ное
ноември
ноя
нояб
ноябр
ноябры
ноябрь
ноября
ној
нојабр
нче
нэгдүгээр
нэдиэлэтэ
нядзеля
ням
о
од
окт
октобар
октомври
октябр
октябры
октябрь
октября
октјабр
олунньу
оны
оп
оптуорунньук
ор
оршот
от
п
п.н.е
пʼятницю
пʼятниця
пай
пайхамар
пайшанба
панядзелак
пет
петак
петок
петък
пн
пон
понеделник
понедельник
понедељак
понеділок
понедјељак
поподне
пр.Хр
први
прво
пре
пред
преди
пре подне
прије
пт
пуш
пятница
пятніца
пүрэв
пӀ
пӀе
пӀераска
пәнҗ
пәнҗешәмбе
р
раш
раштав
с
саб
сабат
сабота
сак
сакавік
сакавіка
сар
сарын
сб
сбт
седмица
сейсенбі
сен
сенбі
сент
сентябр
сентябры
сентябрь
сентября
сентјабр
сеп
септ
септембар
септември
серада
середа
середу
серп
серпень
серпня
сеш
сешанба
сиш
сишәмбе
сл.Хр
след
сне
снежань
снежня
ср
сре
среда
сри
сриједа
сряда
сс
сту
студзень
студзеня
суб
суббота
субота
суботу
субуота
събота
сыл
сэ
сэрэдэ
сэтинньи
січ
січень
січня
сједмица
сәрсенбі
сәу
сәуір
т
тавдугаар
там
тамыз
тиж
тохсунньу
тоқсан
трав
травень
травня
трето
трећи
трим
тримесечие
тримесечје
тромесечје
тун
тунтикун
тутар
тыдзень
тқс
тӀ
у
улирал
устар
уто
уторак
утӑ
ф
феб
фебруар
фев
февр
феврал
февралы
февраль
февраля
февруари
х
хоног
хоёрдугаар
хуыцаубон
хцб
ц
цпр
цыппӕрӕм
ч
чацвер
чейин
черв
червень
червня
чет
четвер
четверг
четвртак
четврти
четврто
четврток
четвъртък
чор
чоршанба
чп
чт
чц
чэппиэр
чэр
чэрвень
чэрвеня
чәр
чәршәмбе
чәршәнбә
чӳк
ш
шан
шанба
шарш
шаршемби
шейш
шейшемби
ши
шим
шимбә
шинара
шуо
шуот
шіл
шілде
шӑм
шӑматкун
шәнбә
ыам
ыйа
ыйын
ытл
ытларикун
э
эр
эрага
эриний
эрнекун
эрни
ю
юли
юн
юни
юнкун
юпа
я
якш
якшанба
якшәмбе
янв
январ
январы
январь
января
яну
януари
ј
ј.е
јан
јанвар
јануар
јануари
јени
јул
јули
јун
јуни
Җ
җом
җомга
Қ
Қазан
Қараша
Қаңтар
Қыркүйек
қаз
қазан
қар
қараша
қаң
қаңтар
қыр
қыркүйек
Ҫ
ҫ
ҫу
ҫур
ҫуралнӑ
ҫурла
ҫӗр
ҫӗртме
ү.х
ү.ө
ҳафтаи
Ҷ
Ҷмъ
Ҷумъа
Ҹ
Ҹ.А
ҹүмә
һәфтә
Ӏийса
Ӕ
Ӕрт
Ӕртыццӕг
ӕрт
ӕртыццӕг
әввәл
өмнөх
Ա
Դ
Ե
Կ
Հ
Մ
Ն
Շ
Ո
Չ
Ս
Փ
Քրիստոսից
Օ
ապր
ապրիլ
ապրիլի
առաջ
դեկ
դեկտեմբեր
դեկտեմբերի
եռամսյակ
եռմս
երեքշաբթի
երկ
երկուշաբթի
երք
թ
թ․
կիր
կիրակի
հետո
հինգշաբթի
հլս
հնգ
հնս
հնվ
հոկ
հոկտեմբեր
հոկտեմբերի
հուլիս
հուլիսի
հունիս
հունիսի
հունվար
հունվարի
մ.թ
մ.թ.ա
մայիս
մայիսի
մարտ
մարտի
մյս
մրտ
նոյ
նոյեմբեր
նոյեմբերի
շաբաթ
շբթ
ուր
ուրբաթ
չորեքշաբթի
չրք
սեպ
սեպտեմբեր
սեպտեմբերի
փետրվար
փետրվարի
փտվ
օգոստոս
օգոստոսի
օգս
אַפּר
אַפּריל
אוגוסט
אוג׳
אויג
אויגוסט
אוקטובר
אוק׳
אחה״צ
אחריי
אפריל
אפר׳
אקט
אקטאבער
א׳
בMMM
בMMMM
בדצמבר
בדצמ׳
בספטמבר
בספט׳
בפברואר
בפבר׳
בשנת
ב׳
ג׳
דאנערשטיק
דינסטיק
דעם
דעצ
דעצעמבער
דצמבר
דצמ׳
ד׳
ה-15
ה-22
ה-5
ה-d
הספירה
ה׳
ו׳
זונטיק
חמישי
יאַנ
יאַנואַר
יולי
יום
יוני
ינואר
ינו׳
לספירה
לפנה״ס
לפנה״צ
לפני
מאָנטיק
מאי
מיטוואך
מיי
מערץ
מרץ
נאָכמיטאָג
נאוו
נאוועמבער
נובמבר
נוב׳
סעפּ
סעפּטעמבער
ספטמבר
ספט׳
פֿאַרמיטאָג
פֿעב
פֿעברואַר
פֿרײַטיק
פברואר
פבר׳
ראשון
רביעי
רבעון
שבוע
שבת
שישי
שלישי
שני
ש׳
آ
آب
آتھوار
آذار
آوریل
آچر
آڤریل
آڪٽوبر
آگسٽ
آگوست
أ
أبريل
أغسطس
أغشت
أفريل
أكتوبر
أوت
أيار
أيلول
أڤأل
إ
إبريل
ئ
ئاب
ئازار
ئاپرېل
ئاۋغۇست
ئایار
ئوکتوڤر
ئىككىنچى
ئىيۇل
ئىيۇن
ئۆكتەبىر
ئۈچىنچى
ئەیلوول
ئەیلوولی
ا
اتوار
اربع
از
الأحد
الأربعاء
الأسبوع
الأول
الاثنين
الثالث
الثاني
الثلاثاء
الثلاثاء،
الجمعة
الجمعة،
الخميس
الرابع
الربع
السبت
السبت،
الميلاد
اوت
اول
اونۍ
ايساپورو
اَتھوار
اپر
اپريل
اپریل
اکت
اکتبر
اکتوبر
اکتوٗبر
اګست
اگس
اگست
اڱارو
اینو
اے
ب
ب.ظ
ب.ن
بدھ
برؠسوار
بعد
بودوار
بىرىنچى
بُدھ
بٹوار
بۆموار
بۇرۇن
بی
ت
تریِم
تشرين
تشرين الأول
تشرینی
تموز
تيجا
تۆتىنچى
تیسری
تەمووز
ث
ج
جانفي
جانڤیە
جمعرات
جمعه
جمعو
جمعہ
جمعہ،
جنؤری
جنو
جنوري
جنوری
جو
جوان
جول
جولاءِ
جولائی
جولای
جون
جويلية
جوٗلایی
جوٗن
جوٙأن
جوٙلا
جُلَے
جُمہ
جۈ
جۈ،
جۈمە
ح
حزيران
حوزەیران
خ
خم
خميس
د
د.ن
دئسامر
دجمبر
دجنبر
درېنۍ
دسامبر
دسم
دسمبر
دسمبر،
دوجا
دوسری
دوشنبه
دوم
دونۍ
دووشەممە
دووەم
دویوم
ديسمبر
دَسَمبَر
دۆیِم
دۈ
دۈشەنبە
دېكابىر
دېكابىر،
ر
ربع
ربعه
ر۱
ر۲
ر۳
ر۴
زایین
زایینی
س
سئپتامر
سئیوم
ساعت
سبتمبر
ستمبر
ستمبر،
سنة
سه‌شنبه
سه‌ماههٔ
سو
سوم
سومر
سيپٽمبر
سپت
سپتامبر
سپتمبر
سں
سہ
سی
سێشەممە
سێشەممە،
سێەم
سېنتەبىر
سېنتەبىر،
سېپتمبر
سە
سە،
سەيشەنبە
س‌م۱
س‌م۲
س‌م۳
س‌م۴
ش
شام، منجهند
شباط
شتمبر
شتنبر
شنبه
شوبات
شوباتی
شە
شە،
شەممە
شەممە،
شەنبە
ص
صبح، منجهند
عيسوي
عیسوی
غ
غشت
ف
فئڤریە
فبر
فبراير
فبروري
فبروری
فرؤری
فروری
فروری،
فوریه
فوریهٔ
فيبروري
فيفري
فېبروري
فېۋرال
فېۋرال،
ق
ق.ظ
ق.م
قبل
قبٕل
ك
كانون
ل
له
لومړۍ
م
مئ
مئي
مئی
مار
مارت
مارس
مارٕچ
مارچ
ماهي
ماي
مايو
ماہی
مسيح
مسیح
مسیٖح
من
منگل
منگل،
مه
مهٔ
مىلادىيە
مىلادىيەدىن
ميلادي
می
میلاد
میلادی
مۍ
ن
نوامبر
نوفمبر
نوم
نومبر
نونبر
نويابىر
نوڤامر
نيسان
نیسان
هفتهٔ
هەفتەی
و
وروسته
وړاندې
ي
يانۋار
يناير
يوليو
يوليوز
يونيو
يونۍ
يە
يەكشەنبە
ٻين
ٽي
ٽين
پ
پ.م
پنجشنبه
پهرين
پينځنۍ
پہلاں
پہلی
پیر
پێش
پێنجشەممە
پە
پەسىل
پەيشەنبە
څخه
څلرنۍ
چ
چ.ب
چ.ك
چا
چارأک
چارشەنبە
چاروم
چارەکی
چهارشنبه
چهارم
چوارشەممە
چوارەم
چوتهی
چوتھا
چوتھاي
چوٿين
چ١
چ٢
چ٣
چ٤
ڇنڇر
ڈومنی
ڈی
ڊسمبر
ژ
ژانویه
ژانویهٔ
ژوئن
ژوئیه
ژوئیهٔ
ژوٗرِم
ژٔندرٕروار
ژٔندٕروار
ژۄباگ
ک
کا
کان
کانونی
کانوونی
کیو
گۄڑنیُک
ھ
ھفتو
ھەینی
ھەینی،
ہفتہ
ہفتہ،
ی
یکشنبه
یەکشەممە
یەکەم
یەکەمی
۲مه
۳مه
۴مه
܏ܒܛ‌
܏ܩܛ‌
܏ܩܡ‌
܏ܫܡ‌
ܐ
ܐܒ
ܐܕܪ
ܐܚܪܝܐ
ܐܝܠܘܠ
ܐܝܪ
ܐܪܒܥ
ܐܪܒܥܒܫܒܐ
ܒ
ܒMMM
ܒMMMM
ܒܐܝܠܘܠ
ܒܟܢܘܢ
ܒܫܒܛ
ܕܫܢܬܐ
ܚ
ܚܕ
ܚܕܒܫܒܐ
ܚܙܝܪܢ
ܚܡܫ
ܚܡܫܒܫܒܐ
ܟ
ܟܢܘܢ
ܡܪܢܝܬܐ
ܡܫܝܚܐ
ܢ
ܢܝܣܢ
ܥ
ܥܪܘ
ܥܪܘ،
ܥܪܘܒܬܐ
ܥܪܘܒܬܐ،
ܩܕܡ
ܩܕܡܝܐ
ܪܒܝܥܝܐ
ܪܘܒܥܐ
ܫ
ܫܒܘܥܐ
ܫܒܛ
ܫܒܬܐ
ܫܒܬܐ،
ܫܢܬܐ
ܬ
ܬܠܝܬܝܐ
ܬܠܬ
ܬܠܬ،
ܬܠܬܒܫܒܐ
ܬܠܬܒܫܒܐ،
ܬܡܘܙ
ܬܪܝܢ
ܬܪܝܢܐ
ܬܪܝܢܒܫܒܐ
ܬܫܪܝܢ
ߌߛ
ߌߛߊ߫
ߓ
ߓߌߟ
ߓߌߟߏ߲
ߓߌ߲ߠ
ߓߌ߲ߠߊߥߎߟߋ߲
ߕ
ߕߎߟߊߝߌ߲
ߕߙߊ
ߕߙߊߓߊ
ߘ
ߘߓߊ߬ߓ
ߘߓߊ߬ߓߌߟߊ
ߘߓߊ߬ߕ
ߘߓߊ߬ߕߊ
ߛ
ߛߌ߬ߣ
ߛߌ߬ߣߌ߲߬ߟߏ߲
ߞ
ߞߊߙߏߛߓߊ߫
ߞߊ߬ߙ
ߞߊ߬ߙߌߝߐ߭
ߞߊ߯ߙ
ߞߊ߯ߙߌߟߏ߲
ߞߍ߲ߘ
ߞߍ߲ߘߍߟߏ߲
ߞߎߣ
ߞߎߣߎ߲ߟߏ߲
ߞߏߟ
ߞߏߟߌ߲ߞߏߟߌ߲
ߞߏ߲ߓ
ߞߏ߲ߓߌߕߌ߮
ߞߏ߲ߘ
ߞߏ߲ߞ
ߞߏ߲ߞߏߘߌ߬ߓߌ
ߞߏ߲ߞߏߜߍ
ߞߐ߫
ߞߐ߬ߓ
ߞߐ߬ߓߊ߬ߟߏ߲
ߞߐ߬ߟ
ߞߐ߬ߟߏ߲
ߞߛ߁
ߞߛ߂
ߞߛ߃
ߞߛ߄
ߡ
ߡߏߦߌ
ߢߍ߫
ߣ
ߣߍߣ
ߣߍߣߍߓߊ
ߥ
ߥߊ߬ߛ
ߥߊ߬ߛߌ߬ߥߙߊ
अ
अकतुम्बर
अक्टूबर
अक्टो
अक्टोबर
अक्ट’
अक्ट’बर
अक्तू
अक्तूबर
अक्तूबर:
अक्तूबरमासः
अक्तू॰
अग
अगस्ट
अगस्त
अगस्त:
अगस्तमासः
अग॰
अपराह्न
अप्र
अप्रिल
अप्रै
अप्रैल
अप्रैल:
अप्रैलमासः
आ
आइत
आइतबार
आग
आगष्ट
आठवडा
आथवार
आन्न’
आयतार
आर्त
आर्तवार
इ
ई
ई.पू
ईसवी
ईसवीसन
ईसवीसनपूर्व
ईसा
ईसा-पूर्व
ईस्वी
ए
ए.दि
ए.दि1995
ए.दि2008
एडी
एप्रि
एप्रिल
एप्री
एप्रील
ऐ
ऐत
ऐतबार
ऐतवार
ऑ
ऑक्टो
ऑक्टोबर
ऑग
ऑगस्ट
ओ
ओक्टोबर
का
किउ
को
क्रि.श
क्रिस्तपूर्व
क्रिस्तशक
खोन्दो
ख्राइष्तनि
गु
गुरु
गुरुवार
गुरुवासर:
च
चंदिरवार
चतुर्थ
च़ंदिरवार
चा
चारिम
चोथीं
चौथी
चौथो
छं
छंछ
छंछर
ज
जन
जनवरी
जनवरी:
जनवरीमासः
जन॰
जा
जान
जानुवारी
जाने
जानेवारी
जु
जुन
जुम
जुमा
जुमो
जुम्मा
जुल
जुलय
जुला
जुलाई
जुलाई:
जुलाईमासः
जुलै
जुल॰
जू
जून
जून:
जूनमासः
टिमाही
टीं
ड
डि
डिसं
डिसंबर
डिसे
डिसें
डिसेंबर
डिसेम्बर
ति1
ति2
ति3
ति4
तिमाही
ति१
ति२
ति३
ति४
तीसरी
तृतीय
तेसर
तेस्रो
त्र.1
त्र.2
त्र.3
त्र.4
त्रमाही
त्री
त्रैमासिक
त्रैमासिक1
त्रैमासिक2
त्रैमासिक3
त्रैमासिक4
त्रैमासीक
थामथि
द
दसमबर
दसूमबर
दा
दामिनि
दि
दिन
दिस
दिसंबर
दिसंबर:
दिसंबरमासः
दिस॰
दूई
दूसरी
दोसर
दोस्रो
द्वितीय
न
नव
नवं
नवंबर
नवंबर:
नवंबरमासः
नवमबर
नवम्बर
नवूमबर
नवे
नवेम्बर
नव॰
नि
नैथि
नो
नोभे
नोभेम्बर
नोव्हें
नोव्हेंबर
पहली
पहिंरी
पहिरीं
पहिल
पहिलो
पू
पूर्व
पूर्वाह्न
पैहली
प्रथम
फ
फर
फरवरी
फरवरी:
फरवरीमासः
फर॰
फ़
फ़रवरी
फ़र॰
फुं
फे
फेब
फेब्रु
फेब्रुअरी
फेब्रुवारी
फेब्रूवारी
फेेब
ब
बटवार
बाहागोनि
बि
बि.सि
बि.सि.-10
बिरेस्तार
बिस्थि
बिस्थिबार
बिहि
बिहिबार
बी
बीं॒
बीर
बीरबार
बीसी
बु
बुध
बुधबार
बुधवार
बुधवासरः
बुवार
बु॒
बु॒ध
बु॒धर
बृहस्पतवार
बृहस्पति
बृहस्पतिबार
बेलासे
बोदवार
बोमवार
ब्रेसवार
ब्रै
ब्रैथि
ब्रोंठ
भोर
म
मं
मंग
मंगल
मंगलबार
मंगलवार
मंगलवासरः
मंगलु
मंगळ
मंगळवार
मंगळार
मई
मईमासः
मङ्गल
मङ्गलबार
मा
मार्च
मार्च:
मार्चमासः
मार्चु
माह
मे
मेई
र
रबि
रबिबार
रबीबार
रवि
रविवार
रविवासरः
रा
वा
वि
विस
विस्पत
श
शनि
शनिबार
शनिवार
शनिवासरः
शु
शुक्र
शुक्रबार
शुक्रवार
शुक्रवासरः
शुक्रार
शे
शेनवार
स
सतमबर
सतुंबर
सन
सनि
सनिबार
सनीचर
सन्
सप्टे
सप्टें
सप्टेंबर
सप्ताह
सम
समबार
सवेर
सह
सांझ
सि
सिगां
सित
सितंबर
सितंबर:
सितंबरमासः
सितम्बर
सित॰
सु
सुखुर
सुखुरबार
सुुखुरबार
सू
सूमर
सेथि
सेप
सेप्टेम्बर
सेप्थेम्बर
सो
सोम
सोमबार
सोमवार
सोमवासरः
सोमार
स’ञ
हप्ता
हफ्ता
অ
অক্টো
অক্টোঃ
অক্টোবর
অক্টোবৰ
অনীশুবা
অপৰাহ্ন
অহানবা
অহুমশুবা
আ
আগ
আগষ্ট
আগস্ট
ইরা
ইরাই
এ
এপ
এপ্রি
এপ্রিল
এপ্ৰিল
এর
ও
ওক
ওক্টো
ওক্টোবর
ওগ
ওগষ্ট
খৃ:
খৃষ্টাব্দ
খ্রিঃ
খ্রিঃপূঃ
খ্রিষ্টাব্দ
খ্রিস্টপূর্ব
খ্রীষ্টাব্দ
খ্ৰীঃ
খ্ৰীষ্টপূৰ্ব
খ্ৰীষ্টাব্দ
চতুর্থ
চতুৰ্থ
ছ
ছেপ্তে
ছেপ্তেম্বৰ
ছেপ্তেম্বৰৰ
জ
জন
জনুৱারী
জা
জানু
জানুয়ারী
জানুৱারি
জানুৱাৰী
জু
জুন
জুল
জুলা
জুলাই
ড
ডি
ডিচে
ডিচেম্বৰ
ডিচেম্বৰৰ
ডিসে
ডিসেঃ
ডিসেম্বর
তিঃ
তিনিমাহ
তৃতীয়
ত্রৈমাসিক
থাং
থাংজ
দ
দেও
দেওবাৰ
দ্বিতীয়
ন
নব
নবেম্বর
নভে
নভেঃ
নভেম্বর
নম্বর
নিং
নিংথৌকাবা
নুমাং
নো
নোং
নোংমাইজিং
নৱে
নৱেম্বৰ
পূঃ
পূৰ্বাহ্ন
প্ৰথম
ফ
ফে
ফেব
ফেব্রু
ফেব্রুয়ারী
ফেব্রুৱারি
ফেব্ৰু
ফেব্ৰুৱাৰী
ফেব্ৰুৱাৰীৰ
ব
বু
বুধ
বুধবার
বুধবাৰ
বৃ
বৃহ
বৃহস্পতি
বৃহস্পতিবার
বৃহস্পতিবাৰ
ম
মঙ্গল
মঙ্গলবার
মঙ্গলবাৰ
মতুং
মমাং
মরীশুবা
মসুং
মা
মার
মার্চ
মাৰ্চ
মে
মে’
য়ুম
য়ুমশকৈশা
র
রবি
রবিবার
লৈ
লৈবা
লৈবাকপোকপা
শ
শগ
শগো
শগোলশেন
শনি
শনিবার
শনিবাৰ
শু
শুক্র
শুক্রবার
শুক্ৰ
শুক্ৰবাৰ
স
সপ্তাহ
সে
সেপ
সেপ্ট
সেপ্টেঃ
সেপ্টেম্বর
সো
সোম
সোমবার
সোমবাৰ
১মঃ
২য়ঃ
৩য়ঃ
৪ৰ্থঃ
ਅ
ਅਕਤੂ
ਅਕਤੂਬਰ
ਅਗ
ਅਗਸਤ
ਅਪ੍ਰੈ
ਅਪ੍ਰੈਲ
ਈ
ਈ.ਪੂ
ਈਸਵੀ
ਐ
ਐਤ
ਐਤਵਾਰ
ਚੌਥੀ
ਜ
ਜਨ
ਜਨਵਰੀ
ਜੁ
ਜੁਲਾ
ਜੁਲਾਈ
ਜੂ
ਜੂਨ
ਤਿਮਾਹੀ
ਤਿਮਾਹੀ1
ਤਿਮਾਹੀ2
ਤਿਮਾਹੀ3
ਤਿਮਾਹੀ4
ਤੀਜੀ
ਦ
ਦਸੰ
ਦਸੰਬਰ
ਦਾ
ਦੂਜੀ
ਨ
ਨਵੰ
ਨਵੰਬਰ
ਪਹਿਲੀ
ਪੂ
ਪੂ.ਦੁ
ਪੂਰਵ
ਫ਼
ਫ਼ਰ
ਫ਼ਰਵਰੀ
ਬਾ.ਦੁ
ਬੁੱ
ਬੁੱਧ
ਬੁੱਧਵਾਰ
ਮ
ਮਈ
ਮਾ
ਮਾਰਚ
ਮੰ
ਮੰਗਲ
ਮੰਗਲਵਾਰ
ਵੀ
ਵੀਰ
ਵੀਰਵਾਰ
ਸ
ਸਤੰ
ਸਤੰਬਰ
ਸ਼
ਸ਼ਨਿੱਚਰ
ਸ਼ਨਿੱਚਰਵਾਰ
ਸ਼ੁੱ
ਸ਼ੁੱਕਰ
ਸ਼ੁੱਕਰਵਾਰ
ਸੋ
ਸੋਮ
ਸੋਮਵਾਰ
ਸੰਨ
ਹਫ਼ਤਾ
અઠવાડિયા
ઇ
ઇસ
ઇસવીસન
ઈ.સ
ઈ.સ.પૂર્વે
ઈસવીસન
એ
એપ્રિલ
ઑ
ઑક્ટો
ઑક્ટોબર
ઑગસ્ટ
ગુ
ગુરુ
ગુરુવાર
જા
જાન્યુ
જાન્યુઆરી
જુ
જુલાઈ
જૂ
જૂન
ડિ
ડિસે
ડિસેમ્બર
ડિસેમ્બરના
ત્રિમાસ
ન
નવે
નવેમ્બર
ના
પુ
પૂર્વે
ફે
ફેબ્રુ
ફેબ્રુઆરી
ફેબ્રુઆરીના
બુ
બુધ
બુધવાર
મં
મંગળ
મંગળવાર
મા
માર્ચ
મે
ર
રવિ
રવિવાર
શ
શનિ
શનિવાર
શુ
શુક્ર
શુક્રવાર
સ
સપ્ટે
સપ્ટેમ્બર
સપ્ટેમ્બરના
સો
સોમ
સોમવાર
ଅ
ଅକ୍ଟୋବର
ଅଗଷ୍ଟ
ଅପ୍ରେଲ
ଖ୍ରୀଷ୍ଟପୂର୍ବ
ଖ୍ରୀଷ୍ଟାବ୍ଦ
ଗୁ
ଗୁରୁ
ଗୁରୁବାର
ଜା
ଜାନୁଆରୀ
ଜୁ
ଜୁନ
ଜୁଲାଇ
ଡି
ଡିସେମ୍ବର
ତ୍ରୟମାସ
ନ
ନଭେମ୍ବର
ଫେ
ଫେବୃଆରୀ
ବୁ
ବୁଧ
ବୁଧବାର
ମ
ମଇ
ମଙ୍ଗଳ
ମଙ୍ଗଳବାର
ମା
ମାର୍ଚ୍ଚ
ର
ରବି
ରବିବାର
ଶ
ଶନି
ଶନିବାର
ଶୁ
ଶୁକ୍ର
ଶୁକ୍ରବାର
ସପ୍ତାହ
ସେ
ସେପ୍ଟେମ୍ବର
ସୋ
ସୋମ
ସୋମବାର
அ
அக்
அக்டோபர்
அன்னோ
ஆ
ஆக
ஆகஸ்ட்
ஆண்டின்
ஆம்
இரண்டாம்
ஏ
ஏப்
ஏப்ரல்
ஒன்றாம்
காலா.1
காலா.2
காலா.3
காலா.4
காலாண்டு
கி.பி
கி.மு
கிறிஸ்துவுக்கு
ச
சனி
செ
செப்
செப்டம்பர்
செவ்
செவ்வாய்
ஜ
ஜன
ஜனவரி
ஜூ
ஜூன்
ஜூலை
ஞா
ஞாயி
ஞாயிறு
டி
டிச
டிசம்பர்
டோமினி
தி
திங்
திங்கள்
ந
நவ
நவம்பர்
நான்காம்
பி
பிப்
பிப்ரவரி
பிற்பகல்
பு
புத
புதன்
மா
மார்
மார்ச்
முன்
மூன்றாம்
மே
வாரம்
வி
வியா
வியாழன்
வெ
வெள்
வெள்ளி
అ
అక్టో
అక్టోబర్
ఆ
ఆగ
ఆగస్టు
ఆది
ఆదివారం
ఏ
ఏప్రి
ఏప్రిల్
క్రీపూ
క్రీశ
క్రీస్తు
గు
గురు
గురువారం
జ
జన
జనవరి
జు
జులై
జూ
జూన్
డి
డిసెం
డిసెంబర్
డిసెంబర్లో
త్రై1
త్రై2
త్రై3
త్రై4
త్రైమాసికం
న
నవం
నవంబర్
పూర్వం
ఫి
ఫిబ్ర
ఫిబ్రవరి
ఫిబ్రవరిలో
బు
బుధ
బుధవారం
మ
మంగళ
మంగళవారం
మా
మార్చి
మే
వారం
శ
శకం
శని
శనివారం
శు
శుక్ర
శుక్రవారం
సె
సెప్టెం
సెప్టెంబర్
సెప్టెంబర్లో
సో
సోమ
సోమవారం
ಅ
ಅಕ್ಟೋ
ಅಕ್ಟೋಬರ್
ಅಪರಾಹ್ನ
ಆ
ಆಗ
ಆಗಸ್ಟ್
ಏ
ಏಪ್ರಿ
ಏಪ್ರಿಲ್
ಕ್ರಿ.ಪೂ
ಕ್ರಿ.ಶ
ಕ್ರಿಸ್ತ
ಗು
ಗುರು
ಗುರುವಾರ
ಜ
ಜನ
ಜನವರಿ
ಜು
ಜುಲೈ
ಜೂ
ಜೂನ್
ಡಿ
ಡಿಸೆಂ
ಡಿಸೆಂಬರ್
ತ್ರೈ
ತ್ರೈಮಾಸಿಕ
ನ
ನವೆಂ
ನವೆಂಬರ್
ಪೂರ್ವ
ಪೂರ್ವಾಹ್ನ
ಫೆ
ಫೆಬ್ರ
ಫೆಬ್ರವರಿ
ಬು
ಬುಧ
ಬುಧವಾರ
ಭಾ
ಭಾನು
ಭಾನುವಾರ
ಮಂ
ಮಂಗಳ
ಮಂಗಳವಾರ
ಮಾ
ಮಾರ್ಚ್
ಮೇ
ಶ
ಶಕ
ಶನಿ
ಶನಿವಾರ
ಶು
ಶುಕ್ರ
ಶುಕ್ರವಾರ
ಸೆ
ಸೆಪ್ಟೆಂ
ಸೆಪ್ಟೆಂಬರ್
ಸೋ
ಸೋಮ
ಸೋಮವಾರ
ആന്നോ
ആഴ്ച
എഡി
ഏ
ഏപ്രി
ഏപ്രിൽ
ഒ
ഒക്ടോ
ഒക്‌ടോബർ
ഒന്നാം
ഓ
ഓഗ
ഓഗസ്റ്റ്
ക്രി.മു
ക്രിസ്‌തുവിന്
ചൊ
ചൊവ്വ
ചൊവ്വാഴ്ച
ചൊവ്വാഴ്‌ച
ജ
ജനു
ജനുവരി
ജൂ
ജൂലൈ
ജൂൺ
ഞ
ഞാ
ഞായറാഴ്‌ച
ഞായർ
ഡി
ഡിസം
ഡിസംബർ
ഡൊമിനി
തി
തിങ്കളാഴ്‌ച
തിങ്കൾ
ന
നവം
നവംബർ
നാലാം
പാദം
ഫെ
ഫെബ്രു
ഫെബ്രുവരി
ബു
ബുധനാഴ്‌ച
ബുധൻ
മാ
മാർ
മാർച്ച്
മുമ്പ്
മൂന്നാം
മെ
മേയ്
രണ്ടാം
വെ
വെള്ളി
വെള്ളിയാഴ്‌ച
വ്യാ
വ്യാഴം
വ്യാഴാഴ്‌ച
ശ
ശനി
ശനിയാഴ്‌ച
സെ
സെപ്റ്റം
സെപ്റ്റംബർ
අ
අගෝ
අගෝස්තු
අඟහ
අඟහරුවාදා
අප්‍රේල්
ඉ
ඉරිදා
ඔ
ඔක්
ඔක්තෝබර්
ක්‍රි.පූ
ක්‍රි.ව
ක්‍රිස්තු
කාර්:1
කාර්:2
කාර්:3
කාර්:4
කාර්තුව
ජ
ජන
ජනවාරි
ජූ
ජූනි
ජූලි
දෙ
දෙසැ
දෙසැම්බර්
නෙ
නොවැ
නොවැම්බර්
ප.ව
පූර්ව
පෙ
පෙ.ව
පෙබ
පෙබරවාරි
බ
බදාදා
බ්‍ර
බ්‍රහස්
බ්‍රහස්පතින්දා
මා
මාර්
මාර්තු
මැ
මැයි
වන
වර්ෂ
ස
සතිය
සඳුදා
සැ
සැප්
සැප්තැම්බර්
සි
සිකු
සිකුරාදා
සෙ
සෙන
සෙනසුරාදා
ก.ค
ก.พ
ก.ย
กรกฎาคม
กันยายน
กุมภาพันธ์
ก่อน
ของปี
ของเดือนMMMM
ของเดือนกันยายน
ของเดือนกุมภาพันธ์
ของเดือนธันวาคม
ค.ศ
คริสต์ศักราช
จ
ต.ค
ตุลาคม
ธ.ค
ธันวาคม
น
นาที
นาฬิกา
ปีก่อนคริสตกาล
พ
พ.ค
พ.ย
พฤ
พฤศจิกายน
พฤษภาคม
ม.ค
มกราคม
มิ.ย
มิถุนายน
มี.ค
มีนาคม
วันจันทร์
วันพฤหัสบดี
วันพุธ
วันศุกร์
วันศุกร์ที่
วันอังคาร
วันอังคารที่
วันอาทิตย์
วันเสาร์
วันเสาร์ที่
วินาที
ศ
ส
ส.ค
สัปดาห์ที่
สิงหาคม
อ
อา
เม.ย
เมษายน
ไตรมาส
ກ.ຍ
ກ.ພ
ກ.ລ
ກັນຍາ
ກຸມພາ
ກ່ອນ
ກ່ອນຄຣິດສັກກະລາດ
ກ່ອນທ່ຽງ
ກໍລະກົດ
ຂອງປີ
ຂອງເດືອນ
ຄ.ສ
ຄຣິດສັກກະລາດ
ຈ
ຈັນ
ຕ.ລ
ຕ1
ຕ2
ຕ3
ຕ4
ຕມ1
ຕມ2
ຕມ3
ຕມ4
ຕຸລາ
ທ.ວ
ທັນວາ
ທີ
ນາທີ
ພ
ພ.ຈ
ພ.ພ
ພຫ
ພະຈິກ
ພະຫັດ
ພຶດສະພາ
ພຸດ
ມ.ກ
ມ.ນ
ມ.ສ
ມັງກອນ
ມິ.ຖ
ມິຖຸນາ
ມີນາ
ວັນຈັນ
ວັນພະຫັດ
ວັນພຸດ
ວັນສຸກ
ວັນອັງຄານ
ວັນອາທິດ
ວັນເສົາ
ວິນາທີ
ສ
ສ.ຫ
ສິງຫາ
ສຸ
ສຸກ
ຫຼັງທ່ຽງ
ອ
ອັງຄານ
ອາ
ອາທິດ
ອາທິດທີ່
ເມສາ
ເສົາ
ໂມງ
ໂມງa
ໂມງກ່ອນທ່ຽງ
ໂມງຫຼັງທ່ຽງ
ໄຕຣມາດ
གཟའ་E
གཟའ་ཉི་
གཟའ་ཉི་མ་
གཟའ་པ་སངས་
གཟའ་ཕུར་བུ་
གཟའ་མིག་དམར་
གཟའ་ཟླ་བ་
གཟའ་ལྷག་
གཟའ་ལྷག་པ་
གཟའ་སྤེན་
གཟའ་སྤེན་པ་
ཆུ་ཚོད%Hཀསར་མ%Mཀསར་ཆ%S
ཆུ་ཚོད04ཀསར་མ44ཀསར་ཆ23
ཆུ་ཚོད09ཀསར་མ05ཀསར་ཆ02
ཆུ་ཚོད18ཀསར་མ30ཀསར་ཆ30
ཆུ་ཚོད་
ཆུ་ཚོད་04
ཆུ་ཚོད་09
ཆུ་ཚོད་18
ཆུ་ཚོད་4
ཆུ་ཚོད་4:44:23
ཆུ་ཚོད་6
ཆུ་ཚོད་6:30:30
ཆུ་ཚོད་9
ཆུ་ཚོད་9:05:02
ཆུ་ཚོད་HH
ཆུ་ཚོད་h
ཉི
ཉི་
ཉི་མ་
དུས་ཚིགས་གཉིས་པ།
དུས་ཚིགས་གསུམ་པ།
དུས་ཚིགས་དང་པོ།
དུས་ཚིགས་བཞི་པ།
པ་སངས་
པསྱི་ལོ%yཟལ%mཚེས%d
པསྱི་ལོ%yཟལ%mཚེས%dཆུ་ཚོད%Hཀསར་མ%Mཀསར་ཆ%S
པསྱི་ལོ08ཟལ02ཚེས05
པསྱི་ལོ08ཟལ02ཚེས05ཆུ་ཚོད18ཀསར་མ30ཀསར་ཆ30
པསྱི་ལོ10ཟལ09ཚེས15
པསྱི་ལོ10ཟལ09ཚེས15ཆུ་ཚོད04ཀསར་མ44ཀསར་ཆ23
པསྱི་ལོ95ཟལ12ཚེས22
པསྱི་ལོ95ཟལ12ཚེས22ཆུ་ཚོད09ཀསར་མ05ཀསར་ཆ02
ཕུར
ཕུར་
ཕུར་བུ་
ཕྱི་ཆ་
ཕྱི་དྲོ་
བཞི་དཔྱ་༡
བཞི་དཔྱ་༢
བཞི་དཔྱ་༣
བཞི་དཔྱ་༤
བཞི་དཔྱ་གཉིས་པ་
བཞི་དཔྱ་གསུམ་པ་
བཞི་དཔྱ་དང་པ་
བཞི་དཔྱ་བཞི་པ་
མིག
མིག་དམར་
མིར
མིར་
ཚེ་15
ཚེ་22
ཚེ་5
ཚེ་d
ཚེས་
ཚེས་05
ཚེས་15
ཚེས་22
ཟླ
ཟླ་
ཟླ་12
ཟླ་MMM
ཟླ་༡
ཟླ་༡༠
ཟླ་༡༡
ཟླ་༡༢
ཟླ་༡༢ཚེས་22
ཟླ་༢
ཟླ་༢ཚེས་5
ཟླ་༣
ཟླ་༤
ཟླ་༥
ཟླ་༦
ཟླ་༧
ཟླ་༨
ཟླ་༩
ཟླ་༩ཚེས་15
ཟླ་གཉིས་པ་
ཟླ་གསུམ་པ་
ཟླ་དགུ་པ་
ཟླ་དངཔ་
ཟླ་དྲུག་པ
ཟླ་བ་
ཟླ་བ་གཉིས་པ
ཟླ་བ་གཉིས་པ་
ཟླ་བ་གཉིས་པའི་ཚེས་5
ཟླ་བ་གསུམ་པ
ཟླ་བ་གསུམ་པ་
ཟླ་བ་དགུ་པ
ཟླ་བ་དགུ་པ་
ཟླ་བ་དགུ་པའི་ཚེས་15
ཟླ་བ་དང་པོ
ཟླ་བ་དང་པོ་
ཟླ་བ་དྲུག་པ
ཟླ་བ་དྲུག་པ་
ཟླ་བ་བཅུ་གཅིག་པ
ཟླ་བ་བཅུ་གཅིག་པ་
ཟླ་བ་བཅུ་གཉིས་པ
ཟླ་བ་བཅུ་གཉིས་པ་
ཟླ་བ་བཅུ་གཉིས་པའི་ཚེས་22
ཟླ་བ་བཅུ་པ
ཟླ་བ་བཅུ་པ་
ཟླ་བ་བདུན་པ
ཟླ་བ་བདུན་པ་
ཟླ་བ་བཞི་པ
ཟླ་བ་བཞི་པ་
ཟླ་བ་བརྒྱད་པ
ཟླ་བ་བརྒྱད་པ་
ཟླ་བ་ལྔ་པ
ཟླ་བ་ལྔ་པ་
ཟླ་བཅུ་གཅིག་པ་
ཟླ་བཅུ་གཉིས་པ་
ཟླ་བཅུ་པ་
ཟླ་བདུན་པ་
ཟླ་བཞི་པ་
ཟླ་བརྒྱད་པ་
ཟླ་ལྔ་པ་
ལོ-10
ལོ1995
ལོ2008
ལོy
ལོའི་MMMཚེས་d
ལོའི་ཟླ་༡༢ཚེས་22
ལོའི་ཟླ་༢ཚེས་5
ལོའི་ཟླ་༩ཚེས་15
ལྷག
ལྷག་
ལྷག་པ་
སངས
སངས་
སངྶ
སྐར་མ་
སྔ་ཆ་
སྔ་དྲོ་
སྤེན
སྤེན་
སྤེན་པ་
སྤྱི་LLL
སྤྱི་ཟླ་12
སྤྱི་ཟླ་MMM
སྤྱི་ཟླ་༡༢
སྤྱི་ཟླ་༢
སྤྱི་ཟླ་༩
སྤྱི་ཟླ་གཉིས་པ་
སྤྱི་ཟླ་གསུམ་པ་
སྤྱི་ཟླ་དགུ་པ་
སྤྱི་ཟླ་དངཔ་
སྤྱི་ཟླ་དྲུག་པ
སྤྱི་ཟླ་བཅུ་གཅིག་པ་
སྤྱི་ཟླ་བཅུ་གཉིས་པ་
སྤྱི་ཟླ་བཅུ་པ་
སྤྱི་ཟླ་བདུན་པ་
སྤྱི་ཟླ་བཞི་པ
སྤྱི་ཟླ་བརྒྱད་པ་
སྤྱི་ཟླ་ལྔ་པ་
སྤྱི་ལོ་
སྤྱི་ལོ་-10
སྤྱི་ལོ་1995
སྤྱི་ལོ་2008
སྤྱི་ལོ་y
སྤྱི་ལོ་སྔོན་
က
ကြာသပတေး
ခရစ်တော်
ခရစ်နှစ်
ခု
စ
စက်
စက်တင်ဘာ
စတုတ္ထ
စနေ
ဇ
ဇန်
ဇန်နဝါရီ
ဇူ
ဇူလိုင်
ဇွန်
ညနေ
တ
တတိယ
တနင်္ဂနွေ
တနင်္လာ
ဒ
ဒီ
ဒီဇင်ဘာ
ဒု
ဒုတိယ
န
နို
နိုဝင်ဘာ
နံနက်
ပ
ပတ်မြောက်
ပထမ
ဖ
ဖေ
ဖေဖော်ဝါရီ
ဗ
ဗုဒ္ဓဟူး
ဘီစီ
မ
မတ်
မပေါ်မီနှစ်
မေ
ရက်
လ
သ
သုံးလပတ်
သောကြာ
အ
အင်္ဂါ
အဒေီ
အောက်
အောက်တိုဘာ
ဧ
ဧပြီ
ဩ
ဩဂုတ်
ა
აგვ
აგვისტო
აპრ
აპრილი
ახ
ახალი
დ
დეკ
დეკემბერი
დეკემბერის
თ
თებ
თებერვალი
თებერვალის
ი
იან
იანვარი
ივლ
ივლისი
ივნ
ივნისი
კ
კვ
კვარტალი
კვი
კვირა
მ
მაი
მაისი
მარ
მარტი
ნ
ნოე
ნოემბერი
ო
ოთხ
ოთხშაბათი
ორშ
ორშაბათი
ოქტ
ოქტომბერი
პ
პარ
პარასკევი
ს
სამ
სამშაბათი
სექ
სექტემბერი
სექტემბერის
შ
შაბ
შაბათი
ძვ
ძველი
წ
წელთაღრიცხვით
წლის
ხ
ხუთ
ხუთშაბათი
ለ
ለካ
ለካቲት
ሐ
ሐሙስ
ሓ
ሓሙ
ሓሙስ
ሓም
ሓምለ
ሕ
ሕዳ
ሕዳር
መ
መስ
መስከረም
መዓልቲ
መጋ
መጋቢት
ሚ
ሚያ
ሚያዝያ
ማ
ማርች
ማክሰ
ማክሰኞ
ማክሰኞ፣
ማክሰ፣
ሜ
ሜይ
ምሕረት
ረ
ረቡ
ረቡዕ
ሩብ
ሩብ1
ሩብ2
ሩብ3
ሩብ4
ር1
ር2
ር3
ር4
ርብዒ
ሰ
ሰሉ
ሰሉስ
ሰሉስ፡
ሰሉስ፣
ሰሉ፣
ሰሙን
ሰነ
ሰኑ
ሰኑይ
ሰን
ሰንበት
ሰኞ
ሳምንት
ሴ
ሴፕቴ
ሴፕቴምበር
ቀ
ቀን
ቀዳ
ቀዳም
ቀዳም፡
ቀዳም፣
ቀዳ፣
ቅ
ቅ.ቀ
ቅዳሜ
ቅዳሜ፣
ቅድመ
ታ
ታሕ
ታሕሳስ
ነ
ነሓ
ነሓሰ
ናይ
ኖ
ኖቬም
ኖቬምበር
ኤ
ኤፕሪ
ኤፕሪል
እ
እሑድ
ኦ
ኦክቶ
ኦክቶበር
ኦገስ
ኦገስት
ከሰዓት
ክርስቶስ
ዓ
ዓ/ም
ዓ/ዓ
ዓለም
ዓመተ
ዓር
ዓርቢ
ዓርቢ፡
ዓርቢ፣
ዓርብ
ዓርብ፣
ዓር፣
የ
ዮም
ዲ
ዲሴም
ዲሴምበር
ድ.ቀ
ጁ
ጁላይ
ጁን
ጃ
ጃን
ጃንዋሪ
ጋላሳ
ግ
ግርጋ
ግን
ግንቦት
ጥ
ጥሪ
ጥቅ
ጥቅምቲ
ጥዋት
ፌ
ፌብ
ፌብሩዋሪ
Ꭰ
ᎠᏂ
ᎠᏂᏍᎬᏘ
ᎠᏃ
ᎠᏅ
ᎠᏅᏱ
Ꭴ
ᎤᎷᎯᏍᏗ
ᎤᎾᏙᏓᏆᏍᎬ
ᎤᎾᏙᏓᏈᏕᎾ
ᎤᎾᏙᏓᏉᏅᎯ
ᎤᏃ
ᎤᏃᎸᏔᏅ
Ꭵ
ᎥᏍ
ᎥᏍᎩᏱ
Ꭶ
ᎦᎶ
ᎦᎶᏁᏛ
ᎦᎶᏂ
Ꭷ
ᎧᎦ
ᎧᎦᎵ
ᎧᏬ
ᎧᏬᏂ
ᎩᏄᏙᏗ
Ꭻ
ᎫᏰ
ᎫᏰᏉᏂ
ᎾᎿ
Ꮕ
ᏅᎩᏁ
ᏅᎩᏁᎢᎦ
ᏅᏓ
ᏅᏓᏕᏆ
Ꮖ
ᏆᏍᎬ
ᏈᏕᎾ
Ꮙ
ᏉᏅᎯ
ᏌᎾᎴ
ᏒᎯᏱᎢ
ᏒᎾᏙᏓᏆᏍᏗ
Ꮤ
ᏔᎵᏁ
ᏔᎵᏁᎢᎦ
Ꮥ
ᏕᎭ
ᏕᎭᎷᏱ
ᏙᎻᏂ
Ꮪ
ᏚᎵ
ᏚᎵᏍᏗ
ᏚᏂ
ᏚᏂᏅᏗ
Ꮶ
ᏦᎢᏁ
ᏦᎢᏁᎢᎦ
Ꮷ
ᏧᎾᎩ
ᏧᎾᎩᎶᏍᏗ
ᏧᏓᎷᎸ
ក
កក្កដា
កញ្ញា
កុម្ភៈ
ខែ
គ.ស
គ្រិស្តសករាជ
ច
ចន្ទ
ច័ន្ទ
ឆ្នាំ
ត
តុលា
ត្រីមាសទី
ថ្ងៃ
ធ
ធ្នូ
នាទី
នៃខែ
នៃឆ្នាំ
ព
ពុធ
ព្រហ
ព្រហស្បតិ៍
ម
មករា
មិថុនា
មីនា
មុន
មុន​គ្រិស្តសករាជ
មេសា
ម៉ោង
វ
វិច្ឆិកា
វិនាទី​
ស
សប្តាហ៍ទី
សីហា
សុក្រ
សៅរ៍
អ
អង្គារ
អាទិត្យ
ឧ
ឧសភា
᠊ᠷ
᠋ᠣᠨ
᠋ᠭᠠᠷᠠᠭ
᠎᠎᠎ᠤ
ᠠᠷᠪᠠᠨ
ᠠᠷᠪᠠᠳᠣᠭᠠᠷ
ᠡ
ᠡᠡ᠂
ᠣᠨ
ᠣᠯᠠᠷᠢᠯ
ᠤᠠᠷᠪᠠᠨ
ᠤᠩ
ᠤᠬᠣᠶᠠᠳᠣᠭᠠᠷ
ᠤᠶᠢᠰᠥᠳᠥᠭᠡᠷ
ᠦ
ᠨᠠᠢᠮᠠᠳᠥᠭᠠᠷ
ᠨᠢ
ᠨᠢᠭᠡᠳᠥᠭᠡᠷ
ᠨᠢᠮ᠎ᠠ
ᠪᠠ
ᠪᠠᠰᠠᠩ
ᠪᠢ
ᠪᠢᠮ
ᠪᠢᠮᠪᠠ
ᠫᠥᠷ
ᠫᠦᠷ
ᠫᠦᠷᠪᠦ
ᠬᠣᠶᠠᠳᠣᠭᠠᠷ
ᠭᠣᠷᠪᠡᠳᠣᠭᠠᠷ
ᠮ᠂
ᠮᠢᠠᠠᠮᠠᠷ
ᠮᠢᠭ
ᠰᠠᠷ᠎ᠠ
ᠰᠠᠷ᠎ᠠ᠎᠎
ᠰᠠᠷ᠎ᠠ᠎᠎ᠢᠢᠨ15
ᠰᠠᠷ᠎ᠠ᠎᠎ᠢᠢᠨ22
ᠰᠠᠷ ᠠ
ᠰᠠᠷ ᠠ᠎᠎
ᠰᠠᠷ ᠠ᠎᠎ᠢᠢᠨ5
ᠲᠠ
ᠲᠠᠪᠣᠳᠣᠭᠠᠷ
ᠲᠣᠯᠣᠭᠠᠳᠣᠭᠠᠷ
ᠳᠠ
ᠳᠠᠸᠠ
ᠳᠥᠷᠪᠡᠳᠥᠭᠡᠷ
ᠵᠢᠷᠭᠣᠭᠠᠳᠣᠭᠠᠷ
ᠶᠢᠰᠥᠳᠥᠭᠡᠷ
ᡀᠠ
ᡀᠠᠭᠪᠠ
᱑ᱟᱜ
᱒ᱟᱜ
᱓ᱭᱟᱜ
᱔ᱟᱜ
ᱚ
ᱚᱛ
ᱚᱛᱮ
ᱚᱠᱴ
ᱚᱠᱴᱚᱵᱟᱨ
ᱞᱟᱦᱟ
ᱟ
ᱟᱜᱟ
ᱟᱜᱟᱥᱛ
ᱟᱯᱨ
ᱟᱯᱨᱮᱞ
ᱡ
ᱡᱟᱱ
ᱡᱟᱱᱣᱟᱨᱤ
ᱡᱟᱹ
ᱡᱟᱹᱨᱩᱢ
ᱡᱩᱞ
ᱡᱩᱞᱟᱭ
ᱡᱩᱱ
ᱢ
ᱢᱟᱨ
ᱢᱟᱨᱪ
ᱢᱮ
ᱤᱥᱣᱤ
ᱥ
ᱥᱟᱹ
ᱥᱟᱹᱜᱩᱱ
ᱥᱟᱹᱨ
ᱥᱟᱹᱨᱫᱤ
ᱥᱤᱸ
ᱥᱤᱸᱜᱮ
ᱥᱮᱨᱢᱟ
ᱥᱮᱯ
ᱥᱮᱯᱴᱮᱢᱵᱟᱨ
ᱧ
ᱧᱩ
ᱧᱩᱦᱩᱢ
ᱪᱟᱸᱫᱚᱠᱤᱭᱟᱹ
ᱫ
ᱫᱤᱥ
ᱫᱤᱥᱟᱢᱵᱟᱨ
ᱯ
ᱯᱮ
ᱯᱷᱟ
ᱯᱷᱟᱨᱣᱟᱨᱤ
ᱱ
ᱱᱟᱣ
ᱱᱟᱣᱟᱢᱵᱟᱨ
ᱵ
ᱵᱟ
ᱵᱟᱞᱮ
Ḍeffir
Ḍeffir aza
ḌƐ
Ṣẹ́
Ṣẹ́r
Ṣẹ́rẹ́
Ẹ
Ẹr
Ẹrẹ̀n
Ẹrẹ̀nà
Ẹt
Ẹtì
Ẹ̀
Ẹ̀b
Ẹ̀bi
Ẹ̀bibi
Ọ
Ọ1
Ọ2
Ọ3
Ọ4
Ọgọ
Ọgọst
Ọgọọst
Ọjọ́
Ọjọ́b
Ọjọ́bọ
Ọjọ́r
Ọjọ́rú
Ọkara
Ọkt
Ọktoba
Ọktóba
Ọ̀
Ọ̀p
Ọ̀pẹ
Ọ̀pẹ̀
Ọ̀sán
Ọ̀w
Ọ̀wà
Ọ̀wàrà
Ọ́gọ
ọdún
ọjọ́
Ὀκτ
Ὀκτωβρίου
Ὀκτώβριος
‌ওগষ্ট
‏h
‘na
’ᎾᎿ’
’ᏒᎾᏙᏓᏆᏍᏗ’
‫%A
‫جمعه
‫سه‌شنبه
‫شنبه
ⴰⴽ
ⴰⴽⵕ
ⴰⴽⵕⴰⴹⵢⵓⵔ
ⴰⴽⵕⴰⵙ
ⴰⴽⵡ
ⴰⴽⵡⴰⵙ
ⴰⵙⴰ
ⴰⵙⴰⵎⴰⵙ
ⴰⵙⵉ
ⴰⵙⵉⴹ
ⴰⵙⵉⴹⵢⴰⵙ
ⴰⵙⵉⵎ
ⴰⵙⵉⵎⵡⴰⵙ
ⴰⵙⵉⵏⴰⵙ
ⴰⵢⵏ
ⴰⵢⵏⴰⵙ
ⴱ
ⴱⵕⴰ
ⴱⵕⴰⵢⵕ
ⴷ
ⴷⴰⵄ
ⴷⴰⵜ
ⴷⴼⴼⵉⵔ
ⴷⴼⵄ
ⴷⵓⵊ
ⴷⵓⵊⴰⵏⴱⵉⵔ
ⴽ
ⴽⵜⵓ
ⴽⵜⵓⴱⵔ
ⵄⵉⵙⴰ
ⵉ
ⵉⴱⵔ
ⵉⴱⵔⵉⵔ
ⵉⵏⵏ
ⵉⵏⵏⴰⵢⵔ
ⵎ
ⵎⴰⵕ
ⵎⴰⵕⵚ
ⵎⴰⵢ
ⵎⴰⵢⵢⵓ
ⵏ
ⵏⵓⵡ
ⵏⵓⵡⴰⵏⴱⵉⵔ
ⵖ
ⵖⵓⵛ
ⵖⵓⵛⵜ
ⵙⵉⵎⵡⴰⵙ
ⵛ
ⵛⵓⵜ
ⵛⵓⵜⴰⵏⴱⵉⵔ
ⵜⴰⴷⴳⴳⵯⴰⵜ
ⵜⵉⴼⴰⵡⵜ
ⵢ
ⵢⵓⵍ
ⵢⵓⵍⵢⵓⵣ
ⵢⵓⵏ
ⵢⵓⵏⵢⵓ
一
一月
七月
三
三月
上午4:44
上午4:44:23
上午4时
上午4時
上午9:05
上午9:05:02
上午9时
上午9時
下午6:30
下午6:30:30
下午6时
下午6時
九月
九月第2周
二
二月
二月第1周
五
五月
八月
公元
公元1995年
公元1995年12月
公元1995年12月22日
公元1995年12月22日周五
公元1995年12月22日週五
公元2008年
公元2008年2月
公元2008年2月5日
公元2008年2月5日周二
公元2008年2月5日週二
公元前
公元前-10年
公元前-10年9月
公元前-10年9月15日
公元前-10年9月15日周六
公元前-10年9月15日週六
六
六月
十一月
十二月
十二月第3周
十月
午前4:44
午前4:44:23
午前4時
午前9:05
午前9:05:02
午前9時
午後6:30
午後6:30:30
午後6時
周一
周三
周二
周二18:30
周二18:30:30
周二B6:30
周二B6:30:30
周二下午6:30
周二下午6:30:30
周五
周五09:05
周五09:05:02
周五B9:05
周五B9:05:02
周五上午9:05
周五上午9:05:02
周六
周六04:44
周六04:44:23
周六B4:44
周六B4:44:23
周六上午4:44
周六上午4:44:23
周四
周日
四
四月
土
土曜日
日
日曜日
星期一
星期三
星期二
星期五
星期六
星期四
星期日
月
月曜日
木
木曜日
水
水曜日
火
火曜日
第1四半期
第1季
第2四半期
第2季
第3四半期
第3季
第4四半期
第4季
第一季度
第三季度
第二季度
第四季度
紀元前
紀元前-10/9/15
紀元前-10年
紀元前-10年9月
紀元前-10年9月15日
紀元前-10年9月15日(土
紀元前-10年9月15日土曜日
西元
西元1995年
西元1995年12月
西元1995年12月22日
西元1995年12月22日周五
西元2008年
西元2008年2月
西元2008年2月5日
西元2008年2月5日周二
西元前
西元前-10年
西元前-10年9月
西元前-10年9月15日
西元前-10年9月15日周六
西暦
西暦1995/12/22
西暦1995年
西暦1995年12月
西暦1995年12月22日
西暦1995年12月22日(金
西暦1995年12月22日金曜日
西暦2008/2/5
西暦2008年
西暦2008年2月
西暦2008年2月5日
西暦2008年2月5日(火
西暦2008年2月5日火曜日
週一
週三
週二
週五
週六
週四
週日
金
金曜日
ꁯꋒ
ꃅꋆ
ꃅꋊꂿ
ꃅꋊꊂ
ꃅꍵ
ꃅꎸ
ꃅꑌ
ꃘ
ꃘꆪ
ꆏ
ꆏꃘ
ꆏꇖ
ꆏꉬ
ꆏꊂꃘ
ꆏꊂꇖ
ꆏꊂꉬ
ꆏꊂꋍ
ꆏꊂꌕ
ꆏꊂꑍ
ꆏꋍ
ꆏꌕ
ꆏꑍ
ꇖ
ꇖꆪ
ꈬꆪ
ꉆꆪ
ꉬ
ꉬꆪ
ꊰꆪ
ꊰꊪꆪ
ꊰꑋꆪ
ꋍ
ꋍꆪ
ꌕ
ꌕꆪ
ꎸꄑ
ꏃꆪ
ꑍ
ꑍꆪ
ꑭꆏ
ꑭꆏꑍ
ꔞꔀꕮꕊ
ꔞꘋ
ꔞꘋꕔꕿ
ꔻꔬꔳ
ꕉꔤꕀꕮ
ꕉꔤꕆꕢ
ꕉꕞꕒ
ꕒꕡ
ꕒꕡꖝꖕ
ꕚꕞꕚ
ꕞꕌꔵ
ꕢꕌ
ꕪꕴ
ꕭꖃ
ꕸꖃꗏ
ꕾꖺ
ꖑꕱ
ꖢꖕ
ꖨꖕ
ꖨꖕꔞ
ꖨꖕꗏ
ꖱꕞ
ꖱꕞꔤ
ꖱꘋ
ꗏꖺꕮꕊ
ꗛꔕ
ꗳꗡꘉ
금
금요일
기원전
목
목요일
서기
수
수요일
월
월요일
일
일요일
제
주
토
토요일
화
화요일
𐐁
𐐁𐐹𐑉
𐐁𐐹𐑉𐐮𐑊
𐐂
𐐂𐑀
𐐂𐑀𐐲𐑅𐐻
𐐈
𐐈𐐔
𐐈𐐣
𐐈𐑌𐐬
𐐉
𐐉𐐿𐐻
𐐉𐐿𐐻𐐬𐐺𐐲𐑉
𐐎
𐐎𐐯𐑌
𐐎𐐯𐑌𐑆𐐼𐐩
𐐑𐐣
𐐒
𐐒𐐗
𐐒𐐲𐑁𐐬𐑉
𐐓
𐐓𐐭𐑆
𐐓𐐭𐑆𐐼𐐩
𐐔
𐐔𐐨𐑅
𐐔𐐨𐑅𐐯𐑋𐐺𐐲𐑉
𐐔𐐱𐑋𐐮𐑌𐐨
𐐖
𐐖𐐭𐑊
𐐖𐐭𐑊𐐴
𐐖𐐭𐑌
𐐖𐐰𐑌
𐐖𐐰𐑌𐐷𐐭𐐯𐑉𐐨
𐐗1
𐐗2
𐐗3
𐐗4
𐐗𐑉𐐴𐑅𐐻
𐐙
𐐙𐐯𐐺
𐐙𐐯𐐺𐑉𐐭𐐯𐑉𐐨
𐐙𐑉𐐴
𐐙𐑉𐐴𐐼𐐩
𐐛
𐐛𐐲𐑉
𐐛𐐲𐑉𐑆𐐼𐐩
𐐝
𐐝𐐯𐐹
𐐝𐐯𐐹𐐻𐐯𐑋𐐺𐐲𐑉
𐐝𐐰𐐻
𐐝𐐰𐐻𐐲𐑉𐐼𐐩
𐐝𐐲𐑌
𐐝𐐲𐑌𐐼𐐩
𐐣
𐐣𐐩
𐐣𐐪𐑉
𐐣𐐪𐑉𐐽
𐐣𐐲𐑌
𐐣𐐲𐑌𐐼𐐩
𐐤
𐐤𐐬𐑂
𐐤𐐬𐑂𐐯𐑋𐐺𐐲𐑉
𐐿𐐶𐐪𐑉𐐻𐐲𐑉
𐑐𐑥
𐑑
𐑒1
𐑒2
𐑒3
𐑒4
𐑒𐑢𐑸𐑛𐑸
𐑓
𐑔
𐑕
𐑚
𐑚·𐑒
𐑚𐑰𐑓𐑪𐑮
𐑛
𐑛𐑪𐑥𐑦𐑙𐑰
𐑡
𐑢
𐑥
𐑨
𐑨𐑙𐑴
𐑨𐑛
𐑨𐑥
𐑪
𐑯
𐑱
𐑷
𐒰𐓧𐓣
𐒴
𐒹𐓘͘𐓬𐓘
𐒼𐓣𐓟𐓰𐓪𐓬𐓘
𐒿𐓟𐓜𐓛
𐒿𐓟𐓜𐓛𐓲𐓟𐓷𐓣͘𐓤𐓟
𐓀𐓣͘𐓪͘𐓬𐓘
𐓂𐓤𐓘𐓸𐓟
𐓄
𐓄𐓘𐓡𐓛͘𐓧𐓟
𐓄𐓘𐓡𐓛͘𐓧𐓣
𐓄𐓟𐓵𐓪͘𐓬𐓘
𐓈
𐓈𐓘
𐓊
𐓍
𐓍𐓪͘𐓬𐓘
𐓏
𐓏𐓘𐓤𐓘͘𐓰𐓘𐓤𐓣
𐓏𐓟𐓮𐓘𐓰𐓘
𐓏𐓟𐓯𐓘𐓬𐓟
𐓏𐓟𐓰𐓪𐓬𐓘
𐓏𐓟𐓵𐓘𐓜𐓣
𐓏𐓟𐓵𐓪͘𐓬𐓘
𐓏𐓣͘𐓸𐓲𐓣
𐓣͘𐓤𐓟
𐓮𐓘𐓰𐓘
𐓯𐓘𐓬𐓟
𐓰𐓪𐓬𐓘
𐓵𐓘𐓜𐓣
𐓵𐓘𐓲𐓘
𐓵𐓪͘𐓬𐓘
𐓸
𐓻𐓣͘
𑄃
𑄃𑄉𑄧𑄌𑄴𑄑𑄴
𑄃𑄧
𑄃𑄧𑄇𑄴𑄑𑄬𑄝𑄧𑄢𑄴
𑄃𑄧𑄇𑄴𑄑𑄮𑄝𑄧𑄢𑄴
𑄃𑄬
𑄃𑄬𑄛𑄳𑄢𑄨𑄣𑄴
𑄃𑄬𑄢𑄴
𑄈𑄳𑄢𑄨𑄌𑄴𑄑𑄛𑄴𑄘𑄧
𑄈𑄳𑄢𑄨𑄌𑄴𑄑𑄴𑄛𑄫𑄢𑄴𑄝𑄧
𑄌𑄳𑄆𑄬𑄢𑄴
𑄎
𑄎𑄚𑄪
𑄎𑄚𑄪𑄠𑄢𑄨
𑄎𑄪
𑄎𑄪𑄚𑄴
𑄎𑄪𑄣𑄭
𑄓𑄨
𑄓𑄨𑄥𑄬𑄟𑄴𑄝𑄢𑄴
𑄓𑄨𑄥𑄬𑄟𑄴𑄝𑄧𑄢𑄴
𑄖𑄧𑄟𑄴
𑄖𑄨𑄚𑄴
𑄖𑄨𑄚𑄴𑄟𑄎𑄧𑄢𑄴
𑄘𑄨
𑄚𑄧
𑄚𑄧𑄞𑄬𑄟𑄴𑄝𑄧𑄢𑄴
𑄛𑄳𑄆𑄘𑄳𑄠𑄬
𑄜𑄬
𑄜𑄬𑄛𑄴
𑄜𑄬𑄛𑄴𑄝𑄳𑄢𑄪𑄠𑄢𑄨
𑄝𑄪
𑄝𑄪𑄖𑄴
𑄝𑄪𑄖𑄴𑄝𑄢𑄴
𑄝𑄳𑄢𑄨
𑄝𑄳𑄢𑄨𑄥𑄪𑄛𑄴
𑄝𑄳𑄢𑄨𑄥𑄪𑄛𑄴𑄝𑄢𑄴
𑄟
𑄟𑄢𑄴𑄌𑄧
𑄟𑄧
𑄟𑄧𑄁𑄉𑄧𑄣𑄴
𑄟𑄧𑄁𑄉𑄧𑄣𑄴𑄝𑄢𑄴
𑄟𑄬
𑄠𑄴
𑄢𑄧
𑄢𑄧𑄝𑄨
𑄢𑄧𑄝𑄨𑄝𑄢𑄴
𑄥𑄛𑄴𑄖
𑄥𑄧
𑄥𑄧𑄚𑄨
𑄥𑄧𑄚𑄨𑄝𑄢𑄴
𑄥𑄧𑄟𑄴
𑄥𑄧𑄟𑄴𑄝𑄢𑄴
𑄥𑄪
𑄥𑄪𑄇𑄴𑄇𑄮𑄢𑄴
𑄥𑄪𑄇𑄴𑄇𑄮𑄢𑄴𑄝𑄢𑄴
𑄥𑄬
𑄥𑄬𑄛𑄴𑄑𑄬𑄟𑄴𑄝𑄧𑄢𑄴
𞄀𞄪𞄴
𞄆𞄨𞄰
𞄆𞄬
𞄈𞄦
𞄊𞄧𞄳
𞄎𞄤𞄲
𞄑𞄤𞄱𞄨
𞄒𞄩𞄱𞄔𞄬𞄴
𞄒𞄫𞄰𞄒𞄪𞄱
𞄔𞄩𞄴𞄆𞄨𞄰
𞄕𞄩𞄲𞄔𞄄𞄰𞄤
𞄗𞄄𞄤𞄰𞄦
𞄙𞄤𞄱𞄨
𞄚𞄦𞄲𞄤𞄚𞄄𞄰𞄫
𞄛𞄤𞄱𞄒𞄤𞄰
𞄛𞄤𞄱𞄞𞄤𞄦
𞄛𞄨𞄱𞄄𞄤𞄲𞄨
𞄜𞄆𞄪
𞄤𞄨𞄱
𞄪𞄱𞄀𞄤𞄴
𞤀𞤀𞤋
𞤀𞤎
𞤀𞤣𞤮
𞤀𞤲𞥆𞤢𞤦𞤭
𞤀𞥄
𞤀𞥄𞤩𞤵
𞤀𞥄𞤩𞤵𞤲𞥋𞤣𞤫
𞤁
𞤁𞤵𞥅𞤶
𞤁𞤵𞥅𞤶𞤮
𞤃
𞤃𞤢𞤣
𞤃𞤢𞤣⹁
𞤃𞤢𞤦
𞤃𞤢𞤦⹁
𞤃𞤢𞤱𞤦𞤢𞥄𞤪𞤫
𞤃𞤢𞤱𞤲𞤣𞤫
𞤃𞤮𞤪
𞤃𞤮𞤪𞤧𞤮
𞤄
𞤄𞤮𞤱
𞤄𞤮𞤱𞤼𞤮
𞤄𞤮𞤱𞤼𞤮⹁
𞤅
𞤅𞤫𞥅𞤼
𞤅𞤫𞥅𞤼𞤮
𞤅𞤭𞤤
𞤅𞤭𞤤𞤼𞤮
𞤅𞤭𞤤𞤼𞤮⹁
𞤅𞤭𞥅𞤤
𞤅𞤭𞥅𞤤𞤮
𞤇𞤀𞤋
𞤇𞤎
𞤇𞤢𞥄𞤱𞤮
𞤈
𞤈𞤫𞤬
𞤈𞤫𞤬𞤦𞤭𞤪𞥆𞤫
𞤋𞥅𞤧𞤢𞥄
𞤐
𞤐𞤢𞤴𞤩𞤭𞥅𞤪𞤫
𞤐𞤢𞥄𞤧
𞤐𞤢𞥄𞤧𞤢𞥄𞤲𞤣𞤫
𞤐𞤦𞤮𞥅𞤴
𞤐𞤦𞤮𞥅𞤴𞤮
𞤐𞤶𞤫𞤧𞤤𞤢𞥄𞤪𞤫
𞤐𞥑
𞤐𞥒
𞤐𞥓
𞤐𞥔
𞤑
𞤑𞤮𞤪
𞤑𞤮𞤪𞤧𞤮
𞤒
𞤒𞤢𞤪
𞤒𞤢𞤪𞤳𞤮
𞤔
𞤔𞤫𞤧
𞤔𞤮𞤤
𞤔𞤮𞤤𞤮
𞤔𞤵𞤳
𞤔𞤵𞤳𞤮
𞤕
𞤕𞤮𞤤
𞤕𞤮𞤤𞤼𞤮
𞤕𞤮𞤤𞤼𞤮⹁
𞤖
𞤖𞤮𞤪
𞤖𞤮𞤪⹁
𞤖𞤮𞤪𞤦𞤭𞤪𞥆𞤫
𞤲𞤣𞤫𞤪
𞤴𞤮𞤲𞤼𞤫𞤪𞤫
𞥑𞤪𞤫
𞥒𞤪𞤫
𞥓𞤪𞤫
𞥔𞤪𞤫
