#!/usr/bin/perl -w

my @ciphers =
(
	'Blowfish',
	'Blowfish_PP',
	'Camellia',
	'Camellia_PP',
	'CAST5',
	'CAST5_PP',
	'DES',
	'DES_EDE3',
	'DES_EEE3',
	'DES_PP',
	'IDEA',
	'NULL',
	'RC6',
	'Rijndael',
	'Rijndael_PP',
	'Skip32',
	'Twofish',
	'Twofish2',
	'XTEA',
	'XTEA_PP',
);

my $custom = sub
{
	my ($data, $bs, $mode) = @_;

	$data .= 'X' x ($bs - length($data) % $bs)	if ($mode eq 'e');
	$data =~ s/X+$//s				if ($mode eq 'd');

	return $data;
};

use Test::More tests => 2*20 + 1;

BEGIN { use_ok (Crypt::ECB) }

my $text = "This is just some dummy text!\n";
my $key  = "This is an at least 56 Byte long test key!!! It really is.";

my $ecb = Crypt::ECB->new;

foreach my $cipher (@ciphers)
{
	eval { $ecb->cipher($cipher) };

	SKIP: {	skip "$cipher not installed", 2 if $@;

		my $ks = $ecb->keysize || 56;
		$ecb->key( substr($key, 0, $ks) );

		$ecb->padding($custom);
		my $enc = $ecb->encrypt($text);
		ok($ecb->decrypt($enc) eq $text,	"$cipher, custom padding: en-/decrypting");

		$ecb->padding('none');
		ok($ecb->decrypt($enc) eq $text."XX",	"$cipher, custom padding: padded bytes");
	}
}

#done_testing( 2*@ciphers + 1 );
