package Graphics::ColorNames::FamousLogo;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2023-12-05'; # DATE
our $DIST = 'Graphics-ColorNames-FamousLogo'; # DIST
our $VERSION = '0.002'; # VERSION

sub NamesRgbTable() {
    use integer;
    return {

        airbnb_red => 0xfd5c63,

        alibaba_orange => 0xff6a00,

        amazon_orange => 0xff9900,
        amazon_blue   => 0x146eb4,

        americanexpress_blue => 0x002663,
        americanexpress_grey => 0x4d4f53,

        android_green => 0xa4c639,

        apple1980_blue   => 0x009ddc,
        apple1980_green  => 0x61bb46,
        apple1980_orange => 0xf5821f,
        apple1980_purple => 0x963d97,
        apple1980_red    => 0xe03a3e,
        apple1980_yellow => 0xfdb827,

        att_blue => 0x00a8e0,

        baidu_red => 0xde0f17,
        baidu_blue => 0x2529d8,

        ballpark_black  => 0x1a1716,
        ballpark_blue   => 0x1d3f99,
        ballpark_red1   => 0xb2171d,
        ballpark_red2   => 0xec0f20,
        ballpark_white  => 0xffffff,
        ballpark_yellow => 0xf1d408,

        barclays_blue1 => 0x00aeef,
        barclays_blue2 => 0x00395d,

        bestbuy_blue   => 0x003b64,
        bestbuy_yellow => 0xfff200,

        bing_yellow => 0xffb900,
        bing_grey1 => 0x505050,
        bing_grey2 => 0xa3a3a3,

        boeing_blue => 0x0033a1,

        burgerking_red => 0xec1c24,
        burgerking_yellow => 0xfdbd10,
        burgerking_blue => 0x0066b2,
        burgerking_orange => 0xed7902,

        cadbury_purple => 0x472f92,

        canon_red => 0xbc0024,
        canon_black => 0x000000,

        cartoonnetwork_blue => 0x00aeef,
        cartoonnetwork_pink => 0xed008c,
        cartoonnetwork_yellow => 0xfff000,
        cartoonnetwork_black => 0x000000,

        cnn_red => 0xcc0000,
        cnn_black => 0x000000,
        cnn_grey1 => 0x282828,
        cnn_grey2 => 0x464646,

        cocacola_red => 0xed1c16,

        deltaairlines_red1 => 0xc8102e,
        deltaairlines_red2 => 0x862633,
        deltaairlines_blue => 0x003a70,

        dhl_red => 0xba0c2f,
        dhl_yellow => 0xffcd00,
        dhl_grey => 0xc9c9c9,

        dominos_blue => 0x0b648f,
        dominos_red => 0xe21737,

        dropbox_blue => 0x007ee5,
        dropbox_grey1 => 0x7b8994,
        dropbox_grey2 => 0x47525d,
        dropbox_grey3 => 0x3d464d,

        ebay_red => 0xe53238,
        ebay_blue => 0x0064d2,
        ebay_yellow => 0xf5af02,
        ebay_green => 0x86b817,

        ericsson_blue => 0x002561,

        espn_red => 0xff0033,

        facebook_blue => 0x3b5998,

        fedex_purple => 0x4d148c,
        fedex_orange => 0xff6600,

        fendi_yellow => 0xf9b949,

        ferrari_red => 0xe32119,

        fiat_red1 => 0x96172e,
        fiat_red2 => 0x6d2d41,

        flipboard_red => 0xe12828,

        ford_blue => 0x1c396d,

        godaddy_green => 0x7db701,
        godaddy_orange => 0xff8a00,

        google_blue   => 0x3369e8,
        google_green  => 0x009925,
        google_red    => 0xd50f25,
        google_yellow => 0xeeb211,

        # another version
        google_blue => 0x4285f4,
        google_green => 0x34a853,
        google_yellow => 0xfbbc05,
        google_red => 0xea4335,

        heineken_green1 => 0x008200,
        heineken_green2 => 0x205527,
        heineken_red => 0xff2b00,
        heineken_grey => 0xc3c3c3,

        homedepot_orange => 0xf96302,

        hp_blue => 0x0096d6,
        bp_orange => 0xd7410b,

        hsbc_red => 0xdb0011,

        ibm_blue => 0x006699,

        ikea_yellow => 0xffcc00,
        ikea_blue => 0x003399,

        intel_blue => 0x0f7dc2,

        jbl_orange => 0xff6600,

        kickstarter_green => 0x2bde73,
        kickstarter_black => 0x0f2105,

        kitkat_red => 0xd70021,

        klm_blue => 0x00a1e4,

        lamborghini_yellow => 0xddb321,

        lego_yellow => 0xf6ec35,
        lego_red => 0xd11013,
        lego_black => 0x000000,

        londonunderground_blue => 0x000099,
        londonunderground_red => 0xcc3333,

        mastercard_red => 0xcc0000,
        mastercard_orange => 0xff9900,
        mastercard_purple => 0x000066,

        microsoft_red => 0xf65314,
        microsoft_green => 0x7cbb00,
        microsoft_blue => 0x00a1f1,
        microsoft_yellow => 0xffbb00,

        motorola_blue => 0x5c92fa,

        nasa_red => 0xfc3d21,
        nasa_blue => 0x0b3d91,

        nascar_blue   => 0x02549e,
        nascar_purple => 0x88166d,
        nascar_red    => 0xbc2021,
        nascar_yellow => 0xedc240,

        nationalgeographic_yellow => 0xffcc00,
        nationalgeographic_black => 0x000000,

        nbc_blue   => 0x0089d0,
        nbc_green  => 0x0db14b,
        nbc_orange => 0xf37021,
        nbc_purple => 0x6460aa,
        nbc_red    => 0xcc004c,
        nbc_yellow => 0xfcb711,

        netflix_red => 0xe50914,
        netflix_black => 0x221f1f,

        nfl_blue  => 0x003a73,
        nfl_red   => 0xda2127,
        nfl_white => 0xffffff,

        nokia_blue => 0x124191,

        nvidia_green => 0x76b900,

        olympus_blue => 0x08107b,
        olympus_yellow => 0xdfb226,
        olympus_grey => 0x777777,

        opera_red => 0xcc0f16,
        opera_grey => 0x9c9e9f,

        oracle_red => 0xff0000,
        oracle_black => 0x000000,
        oracle_grey => 0x7f7f7f,

        panasonic_blue => 0x0f58a8,
        panasonic_black => 0x000000,

        paypal_blue1 => 0x003087,
        paypal_blue2 => 0x009cde,
        paypal_blue3 => 0x012169,

        pepsi_red => 0xe32934,
        pepsi_blue => 0x004883,

        philips_blue => 0x0e5fd8,

        pinterest_red => 0xbd081c,

        pizzahut_red => 0xee3124,
        pizzahut_green => 0x00a160,
        pizzahut_yellow => 0xffc425,

        playstation_blue => 0x003087,

        qantasairways_red => 0xe0001b,

        reddit_red => 0xff4500,
        reddit_blue1 => 0x5f99cf,
        reddit_blue2 => 0xcee3f8,

        rollsroyce_red => 0x680021,
        rollsroyce_white => 0xfffaec,
        rollsroyce_grey => 0x939598,
        rollsroyce_black => 0x000000,

        skype_blue => 0x00aff0,

        snapchat_yellow => 0xfffc00,

        spotify_green => 0x1db954,
        spotify_black => 0x191414,

        starbucks_green => 0x00704a,

        subway_green => 0x489e3b,
        subway_yellow => 0xfabd42,
        subway_red => 0xcd0a20,

        tmobile_pink => 0xe20074,

        target_red => 0xcc0000,

        ted_red => 0xe62b1e,

        tesla_red => 0xcc0000,

        uber_black => 0x09091a,
        uber_grey => 0xc0c0c8,
        uber_cyan => 0x1fbad6,

        ups_brown => 0x351c15,
        ups_yellow => 0xffb500,
        ups_green => 0x64a70b,

        verizon_red => 0xff0000,
        verizon_white => 0xf2f2f2,
        verizon_blue => 0x3285dc,

        vimeo_black => 0x162221,
        vimeo_blue => 0x1ab7ea,

        virginmedia_red => 0xc3092d,
        virginmedia_black => 0x222221,

        visa_blue => 0x1a1f71,
        visa_orange => 0xf7b600,

        xbox_green => 0x52b043,

        yahoo_purple => 0x410093,

        yelp_red => 0xaf0606,

        youtube_red => 0xff0000,
        youtube_black => 0x282828,

        zomato_red => 0xcb202d,
        zomato_black => 0x2d2d2d,
        zomato_white => 0xf4f4f2,
    };
}

1;
# ABSTRACT: Colors used in famous logos

__END__

=pod

=encoding UTF-8

=head1 NAME

Graphics::ColorNames::FamousLogo - Colors used in famous logos

=head1 VERSION

This document describes version 0.002 of Graphics::ColorNames::FamousLogo (from Perl distribution Graphics-ColorNames-FamousLogo), released on 2023-12-05.

=head1 SYNOPSIS

  require Graphics::ColorNames::FamousLogo;

  $NameTable = Graphics::ColorNames::FoodColor->NamesRgbTable();
  $google_blue  = $NameTable->{"google_blue"};

=head1 DESCRIPTION

=for Pod::Coverage ^(.+)$

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Graphics-ColorNames-FamousLogo>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Graphics-ColorNames-FamousLogo>.

=head1 SEE ALSO

L<Graphics::ColorNames>

L<https://digitalsynopsis.com/design/brand-colors/>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Graphics-ColorNames-FamousLogo>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
