use utf8;
use strict;

use Test::More 'no_plan';
use File::stat;
use lib 't/lib';

use TreePath::Graph::Test;

my $simpletree = {
             'Page_1' => {
                    id => '1',
                    source => 'Page',
                    parent => '',
                    name => '/',},
             'Page_2'=> {
                    id => '2',
                    source => 'Page',
                    parent =>  { 'Page_1' },
                    name => 'A'},
             'Page_3'=> {
                    id => '3',
                    source => 'Page',
                    parent =>  { 'Page_2' },
                    name => 'B'},
             'Page_4'=> {
                    id => '4',
                    source => 'Page',
                    parent =>  { 'Page_3' },
                    name => 'C'},
             'Page_5'=> {
                    id => '5',
                    source => 'Page',
                    parent =>  { 'Page_4' },
                    name => 'D'},
             'Page_6'=> {
                    id => '6',
                    source => 'Page',
                    parent =>  { 'Page_4' },
                    name => 'E'},
             'Page_7'=> {
                    id => '7',
                    source => 'Page',
                    parent =>  { 'Page_2' },
                    name => '♥'},
             'Page_8'=> {
                    id => '8',
                    source => 'Page',
                    parent =>  { 'Page_7' },
                    name => 'G'},
             'Page_9'=> {
                    id => '9',
                    source => 'Page',
                    parent => { 'Page_7' },
                    name => 'E'},
             'Page_10'=> {
                    id => '10',
                    source => 'Page',
                     parent =>  { 'Page_9' },
                     name => 'I'},
             'Page_11'=> {
                     id => '11',
                     source => 'Page',
                     parent => { 'Page_9' },
                     name => 'J'},
             'Comment_1' => {
                    id => '1',
                    source => 'Comment',
                    parent => { 'Page_1' }},
             'Comment_2' => {
                    id => '2',
                    source => 'Comment',
                    parent => { 'Page_1' }},
             'Comment_3' => {
                    id => '3',
                    source => 'Comment',
                    parent => { 'Page_2' }},
             'Comment_4' => {
                    id => '4',
                    source => 'Comment',
                    parent => { 'Page_2' }},
             'Comment_5' => {
                    id => '5',
                    source => 'Comment',
                    parent => { 'Page_1' }},
             'Comment_6' => {
                    id => '6',
                    source => 'Comment',
                    parent => { 'Page_7' }},
             'Comment_7' => {
                    id => '7',
                    source => 'Comment',
                    parent => { 'Page_11' }},
             'Comment_8' => {
                    id => '8',
                    source => 'Comment',
                    parent => { 'Page_11' }},
            };


my $colors_source = {
    'Page' => { fg => 'blue'},
    'Comment' => { fg => 'magenta'},
};


ok( my $tp = TreePath::Graph::Test->new(  conf   => $simpletree,
                                          colors => $colors_source,
                                          output => 't/test.png',
                                          ),
    "New TreePath ( conf => $simpletree) with TreePath::Role::Graph");

$tp->graph;

my $sb = stat($tp->output);
ok( $sb->size > 0, "png size is not nulle");

unlink $tp->output;
