package TAEB::Spoilers::Monster;
use TAEB::OO;
use TAEB::Util ':colors';

class_has synonyms => (
    is      => 'ro',
    isa     => 'HashRef',
    lazy    => 1,
    default => sub {
        my $synonyms = {
            # Player-monsters are renamed by the game according to their
            # level; this means that there are a lot of synonyms of them
            # to consider.
            "digger"            => "archeologist",
            "field worker"      => "archeologist",
            "investigator"      => "archeologist",
            "exhumer"           => "archeologist",
            "excavator"         => "archeologist",
            "spelunker"         => "archeologist",
            "speleologist"      => "archeologist",
            "collector"         => "archeologist",
            "curator"           => "archeologist",
            "plunderer"         => "barbarian",
            "plunderess"        => "barbarian",
            "pillager"          => "barbarian",
            "bandit"            => "barbarian",
            "brigand"           => "barbarian",
            "raider"            => "barbarian",
            "reaver"            => "barbarian",
            "slayer"            => "barbarian",
            "chieftain"         => "barbarian",
            "chieftainess"      => "barbarian",
            "conqueror"         => "barbarian",
            "conqueress"        => "barbarian",
            "troglodyte"        => "caveman",
            "aborigine"         => "caveman",
            "wanderer"          => "caveman",
            "vagrant"           => "caveman",
            "wayfarer"          => "caveman",
            "roamer"            => "caveman",
            "nomad"             => "caveman",
            "rover"             => "caveman",
            "pioneer"           => "caveman",
            "rhizotomist"       => "healer",
            "empiric"           => "healer",
            "embalmer"          => "healer",
            "dresser"           => "healer",
            "medicus ossium"    => "healer",
            "medica ossium"     => "healer",
            "herbalist"         => "healer",
            "magister"          => "healer",
            "magistra"          => "healer",
            "physician"         => "healer",
            "chirurgeon"        => "healer",
            "gallant"           => "knight",
            "esquire"           => "knight",
            "bachelor"          => "knight",
            "sergeant"          => "knight",
            "banneret"          => "knight",
            "chevalier"         => "knight",
            "chevaliere"        => "knight",
            "seignieur"         => "knight",
            "dame"              => "knight",
            "paladin"           => "knight",
            "candidate"         => "monk",
            "novice"            => "monk",
            "initiate"          => "monk",
            "student of stones" => "monk",
            "student of waters" => "monk",
            "student of metals" => "monk",
            "student of winds"  => "monk",
            "student of fire"   => "monk",
            "master"            => "monk",
            "aspirant"          => "priest",
            "acolyte"           => "priest",
            "adept"             => "priest",
            "priestess"         => "priest",
            "curate"            => "priest",
            "canon"             => "priest",
            "canoness"          => "priest",
            "lama"              => "priest",
            "patriarch"         => "priest",
            "matriarch"         => "priest",
           #"high priest"      => "priest",
           #"high priestess"   => "priest",
            "footpad"           => "rogue",
            "cutpurse"          => "rogue",
            "pilferer"          => "rogue",
            "robber"            => "rogue",
            "burglar"           => "rogue",
            "filcher"           => "rogue",
            "magsman"           => "rogue",
            "magswoman"         => "rogue",
            "thief"             => "rogue",
            "tenderfoot"        => "ranger",
            "lookout"           => "ranger",
            "trailblazer"       => "ranger",
            "reconnoiterer"     => "ranger",
            "reconnoiteress"    => "ranger",
            "scout"             => "ranger",
            "arbalester"        => "ranger",
            "archer"            => "ranger",
            "sharpshooter"      => "ranger",
            "marksman"          => "ranger",
            "markswoman"        => "ranger",
            "hatamoto"          => "samurai",
            "ronin"             => "samurai",
            "ninja"             => "samurai",
            "kunoichi"          => "samurai",
            "joshu"             => "samurai",
            "ryoshu"            => "samurai",
            "kokushu"           => "samurai",
            "daimyo"            => "samurai",
            "kuge"              => "samurai",
            "shogun"            => "samurai",
            "rambler"           => "tourist",
            "sightseer"         => "tourist",
            "excursionist"      => "tourist",
            "peregrinator"      => "tourist",
            "peregrinatrix"     => "tourist",
            "traveler"          => "tourist",
            "journeyer"         => "tourist",
            "voyager"           => "tourist",
            "explorer"          => "tourist",
            "adventurer"        => "tourist",
            "stripling"         => "valkyrie",
            "skirmisher"        => "valkyrie",
            "fighter"           => "valkyrie",
            "man-at-arms"       => "valkyrie",
            "woman-at-arms"     => "valkyrie",
            "warrior"           => "valkyrie",
            "swashbuckler"      => "valkyrie",
            "hero"              => "valkyrie",
            "heroine"           => "valkyrie",
            "champion"          => "valkyrie",
            "lord"              => "valkyrie",
            "lady"              => "valkyrie",
            "evoker"            => "wizard",
            "conjurer"          => "wizard",
            "thaumaturge"       => "wizard",
            "magician"          => "wizard",
            "enchanter"         => "wizard",
            "enchantress"       => "wizard",
            "sorcerer"          => "wizard",
            "sorceress"         => "wizard",
            "necromancer"       => "wizard",
            "mage"              => "wizard"
        };
    }
);

class_has list => (
    is      => 'ro',
    isa     => 'HashRef',
    lazy    => 1,
    default => sub {
        my $self = shift;

        my $monsters = {
            'Aleax' => {
                'alignment'   => 7,
                'ac'          => 0,
                'attacks'     => 'W1d6 W1d6 1d4',
                'elbereth'    => 0,
                'level'       => 10,
                'mr'          => 30,
                'resistances' => "csep",
                'speed'       => 8,
                'glyph'       => "A",
                'color'       => COLOR_YELLOW,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 0,
                }
            },
            'Angel' => {
                'alignment'   => 12,
                'ac'          => -4,
                'attacks'     => 'W1d6 W1d6 1d4 M2d6M',
                'elbereth'    => 0,
                'level'       => 14,
                'mr'          => 55,
                'resistances' => "csep",
                'speed'       => 10,
                'glyph'       => "A",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 0,
                }
            },
            'Arch Priest' => {
                'alignment'   => 0,
                'peaceful'    => 1,
                'ac'          => 7,
                'attacks'     => 'W4d10 2d8 M2d8+ M2d8+',
                'elbereth'    => 0,
                'level'       => 25,
                'mr'          => 70,
                'resistances' => "fsep",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'Archon' => {
                'alignment'   => 15,
                'ac'          => -6,
                'attacks'     => 'W2d4 W2d4 G2d6b 1d8 M4d6+',
                'elbereth'    => 0,
                'level'       => 19,
                'mr'          => 80,
                'resistances' => "fcsep",
                'speed'       => 16,
                'glyph'       => "A",
                'color'       => COLOR_MAGENTA,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 0,
                }
            },
            'Ashikaga Takauji' => {
                'alignment'   => -13,
                'hostile'     => 1,
                'ac'          => 0,
                'attacks'     => 'W2d6 W2d6 2d6-',
                'elbereth'    => 0,
                'level'       => 15,
                'mr'          => 40,
                'resistances' => "*",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_MAGENTA,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 0,
                }
            },
            'Asmodeus' => {
                'alignment'   => 20,
                'hostile'     => 1,
                'ac'          => -7,
                'attacks'     => '4d4 M6d6C',
                'elbereth'    => 1,
                'level'       => 105,
                'mr'          => 90,
                'resistances' => "fcp",
                'speed'       => 12,
                'glyph'       => "&",
                'color'       => COLOR_MAGENTA,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1500,
                    'nutrition' => 0,
                }
            },
            'Baalzebub' => {
                'alignment'   => 20,
                'hostile'     => 1,
                'ac'          => -5,
                'attacks'     => '2d6P G2d6s',
                'elbereth'    => 1,
                'level'       => 89,
                'mr'          => 85,
                'resistances' => "fp",
                'speed'       => 9,
                'glyph'       => "&",
                'color'       => COLOR_MAGENTA,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1500,
                    'nutrition' => 0,
                }
            },
            'Chromatic Dragon' => {
                'alignment'   => -14,
                'hostile'     => 1,
                'ac'          => 0,
                'attacks'     => 'B6d8z M0d0+ 2d8- 4d8 4d8 1d6',
                'elbereth'    => 1,
                'level'       => 16,
                'mr'          => 30,
                'resistances' => "FCSDEPa*",
                'speed'       => 12,
                'glyph'       => "D",
                'color'       => COLOR_MAGENTA,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 4500,
                    'nutrition' => 1700,
                    'cold_resistance' => '17%',
                    'disintegration_resistance' => '17%',
                    'fire_resistance' => '17%',
                    'poison_resistance' => '17%',
                    'poisonous' => '100%',
                    'shock_resistance' => '17%',
                    'sleep_resistance' => '17%',
                }
            },
            'Croesus' => {
                'alignment'   => 15,
                'hostile'     => 1,
                'ac'          => 0,
                'attacks'     => 'W4d10',
                'elbereth'    => 0,
                'level'       => 20,
                'mr'          => 40,
                'resistances' => " ",
                'speed'       => 15,
                'glyph'       => "@",
                'color'       => COLOR_MAGENTA,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'Cyclops' => {
                'alignment'   => -15,
                'hostile'     => 1,
                'ac'          => 0,
                'attacks'     => 'W4d8 W4d8 2d6-',
                'elbereth'    => 1,
                'level'       => 18,
                'mr'          => 0,
                'resistances' => "*",
                'speed'       => 12,
                'glyph'       => "H",
                'color'       => COLOR_GRAY,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1900,
                    'nutrition' => 700,
                    'strength'  => '100%',
                }
            },
            'Dark One' => {
                'alignment'   => -10,
                'hostile'     => 1,
                'ac'          => 0,
                'attacks'     => 'W1d6 W1d6 1d4- M0d0+',
                'elbereth'    => 0,
                'level'       => 15,
                'mr'          => 80,
                'resistances' => "*",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_BLACK,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 0,
                }
            },
            'Death' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => -5,
                'attacks'     => '8d8z 8d8z',
                'elbereth'    => 0,
                'level'       => 30,
                'mr'          => 100,
                'resistances' => "fcsep*",
                'speed'       => 12,
                'glyph'       => "&",
                'color'       => COLOR_MAGENTA,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 1,
                    'die'       => '100%',
                }
            },
            'Demogorgon' => {
                'alignment'   => -20,
                'hostile'     => 1,
                'ac'          => -8,
                'attacks'     => 'M8d6+ 1d4V 1d6# 1d6#',
                'elbereth'    => 1,
                'level'       => 106,
                'mr'          => 95,
                'resistances' => "fp",
                'speed'       => 15,
                'glyph'       => "&",
                'color'       => COLOR_MAGENTA,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1500,
                    'nutrition' => 0,
                }
            },
            'Dispater' => {
                'alignment'   => 15,
                'hostile'     => 1,
                'ac'          => -2,
                'attacks'     => 'W4d6 M6d6+',
                'elbereth'    => 1,
                'level'       => 78,
                'mr'          => 80,
                'resistances' => "fp",
                'speed'       => 15,
                'glyph'       => "&",
                'color'       => COLOR_MAGENTA,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1500,
                    'nutrition' => 0,
                }
            },
            'Elvenking' => {
                'alignment'   => -10,
                'ac'          => 10,
                'attacks'     => 'W2d4 W2d4',
                'elbereth'    => 0,
                'level'       => 9,
                'mr'          => 25,
                'resistances' => "S",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_MAGENTA,
                'corpse'      => {
                    'cannibal'  => "Elf",
                    'weight'    => 800,
                    'nutrition' => 350,
                    'sleep_resistance' => '60%',
                }
            },
            'Famine' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => -5,
                'attacks'     => '8d8z 8d8z',
                'elbereth'    => 0,
                'level'       => 30,
                'mr'          => 100,
                'resistances' => "fcsep*",
                'speed'       => 12,
                'glyph'       => "&",
                'color'       => COLOR_MAGENTA,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 1,
                    'die'       => '100%',
                }
            },
            'Geryon' => {
                'alignment'   => 15,
                'hostile'     => 1,
                'ac'          => -3,
                'attacks'     => '3d6 3d6 2d4P',
                'elbereth'    => 1,
                'level'       => 72,
                'mr'          => 75,
                'resistances' => "fp",
                'speed'       => 3,
                'glyph'       => "&",
                'color'       => COLOR_MAGENTA,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1500,
                    'nutrition' => 0,
                }
            },
            'Grand Master' => {
                'alignment'   => 0,
                'peaceful'    => 1,
                'ac'          => 0,
                'attacks'     => '4d10 2d8 M2d8+ M2d8+',
                'elbereth'    => 0,
                'level'       => 25,
                'mr'          => 70,
                'resistances' => "fsep",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_BLACK,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'Green-elf' => {
                'alignment'   => -6,
                'ac'          => 10,
                'attacks'     => 'W2d4',
                'elbereth'    => 0,
                'level'       => 5,
                'mr'          => 10,
                'resistances' => "S",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_BRIGHT_GREEN,
                'corpse'      => {
                    'cannibal'  => "Elf",
                    'weight'    => 800,
                    'nutrition' => 350,
                    'sleep_resistance' => '33%',
                }
            },
            'Grey-elf' => {
                'alignment'   => -7,
                'ac'          => 10,
                'attacks'     => 'W2d4',
                'elbereth'    => 0,
                'level'       => 6,
                'mr'          => 10,
                'resistances' => "S",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_GRAY,
                'corpse'      => {
                    'cannibal'  => "Elf",
                    'weight'    => 800,
                    'nutrition' => 350,
                    'sleep_resistance' => '40%',
                }
            },
            'Hippocrates' => {
                'alignment'   => 0,
                'peaceful'    => 1,
                'ac'          => 0,
                'attacks'     => 'W1d6',
                'elbereth'    => 0,
                'level'       => 20,
                'mr'          => 40,
                'resistances' => "p",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_MAGENTA,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'Ixoth' => {
                'alignment'   => -14,
                'hostile'     => 1,
                'ac'          => -1,
                'attacks'     => 'B8d6F 4d8 M0d0+ 2d4 2d4-',
                'elbereth'    => 1,
                'level'       => 15,
                'mr'          => 20,
                'resistances' => "F*",
                'speed'       => 12,
                'glyph'       => "D",
                'color'       => COLOR_RED,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 4500,
                    'nutrition' => 1600,
                    'fire_resistance' => '100%',
                }
            },
            'Juiblex' => {
                'alignment'   => -15,
                'hostile'     => 1,
                'ac'          => -7,
                'attacks'     => 'E4d10# S3d6A',
                'elbereth'    => 1,
                'level'       => 50,
                'mr'          => 65,
                'resistances' => "fpa*",
                'speed'       => 3,
                'glyph'       => "&",
                'color'       => COLOR_BRIGHT_GREEN,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1500,
                    'nutrition' => 0,
                }
            },
            'Keystone Kop' => {
                'alignment'   => 9,
                'hostile'     => 1,
                'ac'          => 10,
                'attacks'     => 'W1d4',
                'elbereth'    => 1,
                'level'       => 1,
                'mr'          => 10,
                'resistances' => " ",
                'speed'       => 6,
                'glyph'       => "K",
                'color'       => COLOR_BLUE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 200,
                }
            },
            'King Arthur' => {
                'alignment'   => 20,
                'peaceful'    => 1,
                'ac'          => 0,
                'attacks'     => 'W1d6 W1d6',
                'elbereth'    => 0,
                'level'       => 20,
                'mr'          => 40,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_MAGENTA,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'Kop Kaptain' => {
                'alignment'   => 12,
                'hostile'     => 1,
                'ac'          => 10,
                'attacks'     => 'W2d6',
                'elbereth'    => 1,
                'level'       => 4,
                'mr'          => 20,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "K",
                'color'       => COLOR_MAGENTA,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 200,
                }
            },
            'Kop Lieutenant' => {
                'alignment'   => 11,
                'hostile'     => 1,
                'ac'          => 10,
                'attacks'     => 'W1d8',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 20,
                'resistances' => " ",
                'speed'       => 10,
                'glyph'       => "K",
                'color'       => COLOR_CYAN,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 200,
                }
            },
            'Kop Sergeant' => {
                'alignment'   => 10,
                'hostile'     => 1,
                'ac'          => 10,
                'attacks'     => 'W1d6',
                'elbereth'    => 1,
                'level'       => 2,
                'mr'          => 10,
                'resistances' => " ",
                'speed'       => 8,
                'glyph'       => "K",
                'color'       => COLOR_BLUE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 200,
                }
            },
            'Lord Carnarvon' => {
                'alignment'   => 20,
                'peaceful'    => 1,
                'ac'          => 0,
                'attacks'     => 'W1d6',
                'elbereth'    => 0,
                'level'       => 20,
                'mr'          => 30,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_MAGENTA,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'Lord Sato' => {
                'alignment'   => 20,
                'peaceful'    => 1,
                'ac'          => 0,
                'attacks'     => 'W1d8 W1d6',
                'elbereth'    => 0,
                'level'       => 20,
                'mr'          => 30,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_MAGENTA,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'Lord Surtur' => {
                'alignment'   => 12,
                'hostile'     => 1,
                'ac'          => 2,
                'attacks'     => 'W2d10 W2d10 2d6-',
                'elbereth'    => 1,
                'level'       => 15,
                'mr'          => 50,
                'resistances' => "F*",
                'speed'       => 12,
                'glyph'       => "H",
                'color'       => COLOR_MAGENTA,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 2250,
                    'nutrition' => 850,
                    'fire_resistance' => '50%',
                    'strength'  => '100%',
                }
            },
            'Master Assassin' => {
                'alignment'   => 18,
                'hostile'     => 1,
                'ac'          => 0,
                'attacks'     => 'W2d6P W2d8 2d6-',
                'elbereth'    => 0,
                'level'       => 15,
                'mr'          => 30,
                'resistances' => "*",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_MAGENTA,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'Master Kaen' => {
                'alignment'   => -20,
                'hostile'     => 1,
                'ac'          => -10,
                'attacks'     => '16d2 16d2 M0d0+ 1d4-',
                'elbereth'    => 0,
                'level'       => 25,
                'mr'          => 10,
                'resistances' => "P*",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_MAGENTA,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                    'poison_resistance' => '100%',
                }
            },
            'Master of Thieves' => {
                'alignment'   => -20,
                'peaceful'    => 1,
                'ac'          => 0,
                'attacks'     => 'W2d6 W2d6 2d4-',
                'elbereth'    => 0,
                'level'       => 20,
                'mr'          => 30,
                'resistances' => "*",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_MAGENTA,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'Medusa' => {
                'alignment'   => -15,
                'hostile'     => 1,
                'ac'          => 2,
                'attacks'     => 'W2d4 1d8 G0d0* 1d6P',
                'elbereth'    => 0,
                'level'       => 20,
                'mr'          => 50,
                'resistances' => "P*",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_BRIGHT_GREEN,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 400,
                    'petrify' => '100%',
                    'poison_resistance' => '100%',
                    'poisonous' => '100%',
                }
            },
            'Minion of Huhetotl' => {
                'alignment'   => -14,
                'hostile'     => 1,
                'ac'          => -2,
                'attacks'     => 'W8d4 W4d6 M0d0+ 2d6-',
                'elbereth'    => 1,
                'level'       => 16,
                'mr'          => 75,
                'resistances' => "fp*",
                'speed'       => 12,
                'glyph'       => "&",
                'color'       => COLOR_RED,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 0,
                }
            },
            'Mordor orc' => {
                'alignment'   => -5,
                'ac'          => 10,
                'attacks'     => 'W1d6',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 5,
                'glyph'       => "o",
                'color'       => COLOR_BLUE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1200,
                    'nutrition' => 200,
                }
            },
            'Nalzok' => {
                'alignment'   => -127,
                'hostile'     => 1,
                'ac'          => -2,
                'attacks'     => 'W8d4 W4d6 M0d0+ 2d6-',
                'elbereth'    => 1,
                'level'       => 16,
                'mr'          => 85,
                'resistances' => "fp*",
                'speed'       => 12,
                'glyph'       => "&",
                'color'       => COLOR_RED,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 0,
                }
            },
            'Nazgul' => {
                'alignment'   => -17,
                'hostile'     => 1,
                'ac'          => 0,
                'attacks'     => 'W1d4V B2d25S',
                'elbereth'    => 1,
                'level'       => 13,
                'mr'          => 25,
                'resistances' => "csp",
                'speed'       => 12,
                'glyph'       => "W",
                'color'       => COLOR_MAGENTA,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 0,
                }
            },
            'Neferet the Green' => {
                'alignment'   => 0,
                'peaceful'    => 1,
                'ac'          => 0,
                'attacks'     => 'W1d6 M2d8+',
                'elbereth'    => 0,
                'level'       => 20,
                'mr'          => 60,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_GREEN,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'Norn' => {
                'alignment'   => 0,
                'peaceful'    => 1,
                'ac'          => 0,
                'attacks'     => 'W1d8 W1d6',
                'elbereth'    => 0,
                'level'       => 20,
                'mr'          => 80,
                'resistances' => "c",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_MAGENTA,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'Olog-hai' => {
                'alignment'   => -7,
                'hostile'     => 1,
                'ac'          => -4,
                'attacks'     => 'W3d6 2d8 2d6',
                'elbereth'    => 1,
                'level'       => 13,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "T",
                'color'       => COLOR_MAGENTA,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1500,
                    'nutrition' => 400,
                }
            },
            'Oracle' => {
                'alignment'   => 0,
                'peaceful'    => 1,
                'ac'          => 0,
                'attacks'     => '(0d4M)',
                'elbereth'    => 0,
                'level'       => 12,
                'mr'          => 50,
                'resistances' => " ",
                'speed'       => 0,
                'glyph'       => "@",
                'color'       => COLOR_BRIGHT_BLUE,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'Orcus' => {
                'alignment'   => -20,
                'hostile'     => 1,
                'ac'          => -6,
                'attacks'     => 'W3d6 3d4 3d4 M8d6+ 2d4P',
                'elbereth'    => 1,
                'level'       => 66,
                'mr'          => 85,
                'resistances' => "fp",
                'speed'       => 9,
                'glyph'       => "&",
                'color'       => COLOR_MAGENTA,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1500,
                    'nutrition' => 0,
                }
            },
            'Orion' => {
                'alignment'   => 0,
                'peaceful'    => 1,
                'ac'          => 0,
                'attacks'     => 'W1d6',
                'elbereth'    => 0,
                'level'       => 20,
                'mr'          => 30,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_MAGENTA,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'Pelias' => {
                'alignment'   => 0,
                'peaceful'    => 1,
                'ac'          => 0,
                'attacks'     => 'W1d6',
                'elbereth'    => 0,
                'level'       => 20,
                'mr'          => 30,
                'resistances' => "p",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_MAGENTA,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'Pestilence' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => -5,
                'attacks'     => '8d8z 8d8z',
                'elbereth'    => 0,
                'level'       => 30,
                'mr'          => 100,
                'resistances' => "fcsep*",
                'speed'       => 12,
                'glyph'       => "&",
                'color'       => COLOR_MAGENTA,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 1,
                    'die'       => '100%',
                }
            },
            'Scorpius' => {
                'alignment'   => -15,
                'hostile'     => 1,
                'ac'          => 10,
                'attacks'     => '2d6 2d6- 1d4#',
                'elbereth'    => 1,
                'level'       => 15,
                'mr'          => 0,
                'resistances' => "P*",
                'speed'       => 12,
                'glyph'       => "s",
                'color'       => COLOR_MAGENTA,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 750,
                    'nutrition' => 350,
                    'poison_resistance' => '100%',
                    'poisonous' => '100%',
                }
            },
            'Shaman Karnov' => {
                'alignment'   => 20,
                'peaceful'    => 1,
                'ac'          => 0,
                'attacks'     => 'W2d4',
                'elbereth'    => 0,
                'level'       => 20,
                'mr'          => 30,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_MAGENTA,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'Thoth Amon' => {
                'alignment'   => -14,
                'hostile'     => 1,
                'ac'          => 0,
                'attacks'     => 'W1d6 M0d0+ M0d0+ 1d4-',
                'elbereth'    => 0,
                'level'       => 16,
                'mr'          => 10,
                'resistances' => "p*",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_MAGENTA,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 0,
                }
            },
            'Twoflower' => {
                'alignment'   => 0,
                'peaceful'    => 1,
                'ac'          => 10,
                'attacks'     => 'W1d6 W1d6',
                'elbereth'    => 0,
                'level'       => 20,
                'mr'          => 20,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'Uruk-hai' => {
                'alignment'   => -4,
                'ac'          => 10,
                'attacks'     => 'W1d8',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 7,
                'glyph'       => "o",
                'color'       => COLOR_BLACK,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1300,
                    'nutrition' => 300,
                }
            },
            'Vlad the Impaler' => {
                'alignment'   => -10,
                'hostile'     => 1,
                'ac'          => -3,
                'attacks'     => 'W1d10 1d10V',
                'elbereth'    => 1,
                'level'       => 14,
                'mr'          => 80,
                'resistances' => "sp",
                'speed'       => 18,
                'glyph'       => "V",
                'color'       => COLOR_MAGENTA,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 0,
                }
            },
            'Wizard of Yendor' => {
                'hostile'     => 1,
                'ac'          => -8,
                'attacks'     => '2d12- M0d0+',
                'elbereth'    => 0,
                'level'       => 30,
                'mr'          => 100,
                'resistances' => "FP",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_MAGENTA,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                    'fire_resistance' => '25%',
                    'poison_resistance' => '25%',
                    'teleport_control' => '25%',
                    'teleportitis' => '25%',
                }
            },
            'Woodland-elf' => {
                'alignment'   => -5,
                'ac'          => 10,
                'attacks'     => 'W2d4',
                'elbereth'    => 0,
                'level'       => 4,
                'mr'          => 10,
                'resistances' => "S",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_GREEN,
                'corpse'      => {
                    'cannibal'  => "Elf",
                    'weight'    => 800,
                    'nutrition' => 350,
                    'sleep_resistance' => '27%',
                }
            },
            'Yeenoghu' => {
                'alignment'   => -15,
                'hostile'     => 1,
                'ac'          => -5,
                'attacks'     => 'W3d6 W2d8c W1d6. M2d6M',
                'elbereth'    => 1,
                'level'       => 56,
                'mr'          => 80,
                'resistances' => "fp",
                'speed'       => 18,
                'glyph'       => "&",
                'color'       => COLOR_MAGENTA,
                'unique'      => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 900,
                    'nutrition' => 0,
                }
            },
            'abbot' => {
                'alignment'   => 0,
                'peaceful'    => 1,
                'ac'          => 10,
                'attacks'     => '8d2 3d2s M0d0+',
                'elbereth'    => 0,
                'level'       => 5,
                'mr'          => 20,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                    'hallucination' => '100%',
                }
            },
            'acid blob' => {
                'alignment'   => 0,
                'ac'          => 8,
                'attacks'     => '(1d8A)',
                'elbereth'    => 1,
                'level'       => 1,
                'mr'          => 0,
                'resistances' => "spa*",
                'speed'       => 3,
                'glyph'       => "b",
                'color'       => COLOR_GREEN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 30,
                    'nutrition' => 10,
                    'acidic'    => '100%',
                    vegetarian  => 1,
                    vegan       => 1,
                }
            },
            'acolyte' => {
                'alignment'   => 0,
                'peaceful'    => 1,
                'ac'          => 10,
                'attacks'     => 'W1d6 M0d0+',
                'elbereth'    => 0,
                'level'       => 5,
                'mr'          => 20,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'air elemental' => {
                'alignment'   => 0,
                'ac'          => 2,
                'attacks'     => 'E1d10',
                'elbereth'    => 1,
                'level'       => 8,
                'mr'          => 30,
                'resistances' => "p*",
                'speed'       => 36,
                'glyph'       => "E",
                'color'       => COLOR_CYAN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 0,
                    'nutrition' => 0,
                    vegetarian  => 1,
                    vegan       => 1,
                }
            },
            'aligned priest' => {
                'alignment'   => 0,
                'peaceful'    => 1,
                'ac'          => 10,
                'attacks'     => 'W4d10 1d4 M0d0+',
                'elbereth'    => 0,
                'level'       => 12,
                'mr'          => 50,
                'resistances' => "e",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'ape' => {
                'alignment'   => 0,
                'ac'          => 6,
                'attacks'     => '1d3 1d3 1d6',
                'elbereth'    => 1,
                'level'       => 4,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "Y",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1100,
                    'nutrition' => 500,
                }
            },
            'apprentice' => {
                'alignment'   => 0,
                'peaceful'    => 1,
                'ac'          => 10,
                'attacks'     => 'W1d6 M0d0+',
                'elbereth'    => 0,
                'level'       => 5,
                'mr'          => 30,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'arch-lich' => {
                'alignment'   => -15,
                'hostile'     => 1,
                'ac'          => -6,
                'attacks'     => '5d6C M0d0+',
                'elbereth'    => 1,
                'level'       => 25,
                'mr'          => 90,
                'resistances' => "FCsep",
                'speed'       => 9,
                'glyph'       => "L",
                'color'       => COLOR_MAGENTA,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1200,
                    'nutrition' => 0,
                }
            },
            'archeologist' => {
                'alignment'   => 3,
                'ac'          => 10,
                'attacks'     => 'W1d6 W1d6',
                'elbereth'    => 0,
                'level'       => 10,
                'mr'          => 1,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'attendant' => {
                'alignment'   => 3,
                'peaceful'    => 1,
                'ac'          => 10,
                'attacks'     => 'W1d6',
                'elbereth'    => 0,
                'level'       => 5,
                'mr'          => 10,
                'resistances' => "p",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'baby black dragon' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 2,
                'attacks'     => '2d6',
                'elbereth'    => 1,
                'level'       => 12,
                'mr'          => 10,
                'resistances' => "d",
                'speed'       => 9,
                'glyph'       => "D",
                'color'       => COLOR_BLACK,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1500,
                    'nutrition' => 500,
                }
            },
            'baby blue dragon' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 2,
                'attacks'     => '2d6',
                'elbereth'    => 1,
                'level'       => 12,
                'mr'          => 10,
                'resistances' => "e",
                'speed'       => 9,
                'glyph'       => "D",
                'color'       => COLOR_BLUE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1500,
                    'nutrition' => 500,
                }
            },
            'baby crocodile' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 7,
                'attacks'     => '1d4',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 6,
                'glyph'       => ":",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 200,
                    'nutrition' => 200,
                }
            },
            'baby gray dragon' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 2,
                'attacks'     => '2d6',
                'elbereth'    => 1,
                'level'       => 12,
                'mr'          => 10,
                'resistances' => " ",
                'speed'       => 9,
                'glyph'       => "D",
                'color'       => COLOR_GRAY,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1500,
                    'nutrition' => 500,
                }
            },
            'baby green dragon' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 2,
                'attacks'     => '2d6',
                'elbereth'    => 1,
                'level'       => 12,
                'mr'          => 10,
                'resistances' => "p",
                'speed'       => 9,
                'glyph'       => "D",
                'color'       => COLOR_GREEN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1500,
                    'nutrition' => 500,
                    'poisonous' => '100%',
                }
            },
            'baby long worm' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 5,
                'attacks'     => '1d6',
                'elbereth'    => 1,
                'level'       => 8,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 3,
                'glyph'       => "w",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 600,
                    'nutrition' => 250,
                }
            },
            'baby orange dragon' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 2,
                'attacks'     => '2d6',
                'elbereth'    => 1,
                'level'       => 12,
                'mr'          => 10,
                'resistances' => "s",
                'speed'       => 9,
                'glyph'       => "D",
                'color'       => COLOR_ORANGE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1500,
                    'nutrition' => 500,
                }
            },
            'baby purple worm' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 5,
                'attacks'     => '1d6',
                'elbereth'    => 1,
                'level'       => 8,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 3,
                'glyph'       => "w",
                'color'       => COLOR_MAGENTA,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 600,
                    'nutrition' => 250,
                }
            },
            'baby red dragon' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 2,
                'attacks'     => '2d6',
                'elbereth'    => 1,
                'level'       => 12,
                'mr'          => 10,
                'resistances' => "f",
                'speed'       => 9,
                'glyph'       => "D",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1500,
                    'nutrition' => 500,
                }
            },
            'baby silver dragon' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 2,
                'attacks'     => '2d6',
                'elbereth'    => 1,
                'level'       => 12,
                'mr'          => 10,
                'resistances' => " ",
                'speed'       => 9,
                'glyph'       => "D",
                'color'       => COLOR_BRIGHT_CYAN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1500,
                    'nutrition' => 500,
                }
            },
            'baby white dragon' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 2,
                'attacks'     => '2d6',
                'elbereth'    => 1,
                'level'       => 12,
                'mr'          => 10,
                'resistances' => "c",
                'speed'       => 9,
                'glyph'       => "D",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1500,
                    'nutrition' => 500,
                }
            },
            'baby yellow dragon' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 2,
                'attacks'     => '2d6',
                'elbereth'    => 1,
                'level'       => 12,
                'mr'          => 10,
                'resistances' => "a*",
                'speed'       => 9,
                'glyph'       => "D",
                'color'       => COLOR_YELLOW,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1500,
                    'nutrition' => 500,
                    'acidic'    => '100%',
                }
            },
            'balrog' => {
                'alignment'   => -14,
                'hostile'     => 1,
                'ac'          => -2,
                'attacks'     => 'W8d4 W4d6',
                'elbereth'    => 1,
                'level'       => 16,
                'mr'          => 75,
                'resistances' => "fp",
                'speed'       => 5,
                'glyph'       => "&",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 0,
                }
            },
            'baluchitherium' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 5,
                'attacks'     => '5d4 5d4',
                'elbereth'    => 1,
                'level'       => 14,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "q",
                'color'       => COLOR_GRAY,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 3800,
                    'nutrition' => 800,
                }
            },
            'barbarian' => {
                'alignment'   => 0,
                'ac'          => 10,
                'attacks'     => 'W1d6 W1d6',
                'elbereth'    => 0,
                'level'       => 10,
                'mr'          => 1,
                'resistances' => "p",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'barbed devil' => {
                'alignment'   => 8,
                'hostile'     => 1,
                'ac'          => 0,
                'attacks'     => '2d4 2d4 3d4',
                'elbereth'    => 1,
                'level'       => 8,
                'mr'          => 35,
                'resistances' => "fp",
                'speed'       => 12,
                'glyph'       => "&",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 0,
                }
            },
            'barrow wight' => {
                'alignment'   => -3,
                'hostile'     => 1,
                'ac'          => 5,
                'attacks'     => 'W0d0V M0d0+ 1d4',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 5,
                'resistances' => "csp",
                'speed'       => 12,
                'glyph'       => "W",
                'color'       => COLOR_GRAY,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1200,
                    'nutrition' => 0,
                }
            },
            'bat' => {
                'alignment'   => 0,
                'ac'          => 8,
                'attacks'     => '1d4',
                'elbereth'    => 1,
                'level'       => 0,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 22,
                'glyph'       => "B",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 20,
                    'nutrition' => 20,
                    'stun' => '30',
                }
            },
            'black dragon' => {
                'alignment'   => -6,
                'hostile'     => 1,
                'ac'          => -1,
                'attacks'     => 'B4d10D 3d8 1d4 1d4',
                'elbereth'    => 1,
                'level'       => 15,
                'mr'          => 20,
                'resistances' => "D",
                'speed'       => 9,
                'glyph'       => "D",
                'color'       => COLOR_BLACK,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 4500,
                    'nutrition' => 1500,
                    'disintegration_resistance' => '100%',
                }
            },
            'black light' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 0,
                'attacks'     => 'X10d12h',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 0,
                'resistances' => "fcsdepa*",
                'speed'       => 15,
                'glyph'       => "y",
                'color'       => COLOR_BLACK,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 0,
                    'nutrition' => 0,
                    vegetarian  => 1,
                    vegan       => 1,
                }
            },
            'black naga' => {
                'alignment'   => 4,
                'ac'          => 2,
                'attacks'     => '2d6 S0d0A',
                'elbereth'    => 1,
                'level'       => 8,
                'mr'          => 10,
                'resistances' => "Pa*",
                'speed'       => 14,
                'glyph'       => "N",
                'color'       => COLOR_BLACK,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 2600,
                    'nutrition' => 400,
                    'acidic'    => '100%',
                    'poison_resistance' => '53%',
                }
            },
            'black naga hatchling' => {
                'alignment'   => 0,
                'ac'          => 6,
                'attacks'     => '1d4',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 0,
                'resistances' => "Pa*",
                'speed'       => 10,
                'glyph'       => "N",
                'color'       => COLOR_BLACK,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 500,
                    'nutrition' => 100,
                    'acidic'    => '100%',
                    'poison_resistance' => '20%',
                }
            },
            'black pudding' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 6,
                'attacks'     => '3d8R (0d0R)',
                'elbereth'    => 1,
                'level'       => 10,
                'mr'          => 0,
                'resistances' => "CEPa*",
                'speed'       => 6,
                'glyph'       => "P",
                'color'       => COLOR_BLACK,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 900,
                    'nutrition' => 250,
                    'acidic'    => '100%',
                    'cold_resistance' => '22%',
                    'poison_resistance' => '22%',
                    'shock_resistance' => '22%',
                }
            },
            'black unicorn' => {
                'alignment'   => -7,
                'ac'          => 2,
                'attacks'     => '1d12 1d6',
                'elbereth'    => 1,
                'level'       => 4,
                'mr'          => 70,
                'resistances' => "P",
                'speed'       => 24,
                'glyph'       => "u",
                'color'       => COLOR_BLACK,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1300,
                    'nutrition' => 300,
                    'poison_resistance' => '27%',
                }
            },
            'blue dragon' => {
                'alignment'   => -7,
                'hostile'     => 1,
                'ac'          => -1,
                'attacks'     => 'B4d6E 3d8 1d4 1d4',
                'elbereth'    => 1,
                'level'       => 15,
                'mr'          => 20,
                'resistances' => "E",
                'speed'       => 9,
                'glyph'       => "D",
                'color'       => COLOR_BLUE,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 4500,
                    'nutrition' => 1500,
                    'shock_resistance' => '100%',
                }
            },
            'blue jelly' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 8,
                'attacks'     => '(0d6C)',
                'elbereth'    => 1,
                'level'       => 4,
                'mr'          => 10,
                'resistances' => "CP",
                'speed'       => 0,
                'glyph'       => "j",
                'color'       => COLOR_BLUE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 50,
                    'nutrition' => 20,
                    'cold_resistance' => '13%',
                    'poison_resistance' => '13%',
                    vegetarian  => 1,
                    vegan       => 1,
                }
            },
            'bone devil' => {
                'alignment'   => -9,
                'hostile'     => 1,
                'ac'          => -1,
                'attacks'     => 'W3d4 2d4P',
                'elbereth'    => 1,
                'level'       => 9,
                'mr'          => 40,
                'resistances' => "fp",
                'speed'       => 15,
                'glyph'       => "&",
                'color'       => COLOR_GRAY,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 0,
                }
            },
            'brown mold' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 9,
                'attacks'     => '(0d6C)',
                'elbereth'    => 1,
                'level'       => 1,
                'mr'          => 0,
                'resistances' => "CP",
                'speed'       => 0,
                'glyph'       => "F",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 50,
                    'nutrition' => 30,
                    'cold_resistance' => '3%',
                    'poison_resistance' => '3%',
                    vegetarian  => 1,
                    vegan       => 1,
                }
            },
            'brown pudding' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 8,
                'attacks'     => '0d0r',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 0,
                'resistances' => "CEPa*",
                'speed'       => 3,
                'glyph'       => "P",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 500,
                    'nutrition' => 250,
                    'acidic'    => '100%',
                    'cold_resistance' => '11%',
                    'poison_resistance' => '11%',
                    'shock_resistance' => '11%',
                    vegetarian  => 1,
                }
            },
            'bugbear' => {
                'alignment'   => -6,
                'ac'          => 5,
                'attacks'     => 'W2d4',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 9,
                'glyph'       => "h",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1250,
                    'nutrition' => 250,
                }
            },
            'captain' => {
                'alignment'   => -5,
                'hostile'     => 1,
                'ac'          => 10,
                'attacks'     => 'W4d4 W4d4',
                'elbereth'    => 0,
                'level'       => 12,
                'mr'          => 15,
                'resistances' => " ",
                'speed'       => 10,
                'glyph'       => "@",
                'color'       => COLOR_BLUE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'carnivorous ape' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 6,
                'attacks'     => '1d4 1d4 H1d8',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "Y",
                'color'       => COLOR_BLACK,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1250,
                    'nutrition' => 550,
                }
            },
            'cave spider' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 3,
                'attacks'     => '1d2',
                'elbereth'    => 1,
                'level'       => 1,
                'mr'          => 0,
                'resistances' => "P",
                'speed'       => 12,
                'glyph'       => "s",
                'color'       => COLOR_GRAY,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 50,
                    'nutrition' => 50,
                    'poison_resistance' => '7%',
                }
            },
            'caveman' => {
                'alignment'   => 1,
                'ac'          => 10,
                'attacks'     => 'W2d4',
                'elbereth'    => 0,
                'level'       => 10,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'cavewoman' => {
                'alignment'   => 1,
                'ac'          => 10,
                'attacks'     => 'W2d4',
                'elbereth'    => 0,
                'level'       => 10,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'centipede' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 3,
                'attacks'     => '1d3P',
                'elbereth'    => 1,
                'level'       => 2,
                'mr'          => 0,
                'resistances' => "P",
                'speed'       => 4,
                'glyph'       => "s",
                'color'       => COLOR_YELLOW,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 50,
                    'nutrition' => 50,
                    'poison_resistance' => '13%',
                }
            },
            'chameleon' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 6,
                'attacks'     => '4d2',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 10,
                'resistances' => " ",
                'speed'       => 5,
                'glyph'       => ":",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 100,
                    'nutrition' => 100,
                    'polymorph' => '100%',
                }
            },
            'chickatrice' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 8,
                'attacks'     => '1d2 0d0* (0d0*)',
                'elbereth'    => 1,
                'level'       => 4,
                'mr'          => 30,
                'resistances' => "P*",
                'speed'       => 4,
                'glyph'       => "c",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 10,
                    'nutrition' => 10,
                    'petrify' => '100%',
                    'poison_resistance' => '27%',
                }
            },
            'chieftain' => {
                'alignment'   => 0,
                'peaceful'    => 1,
                'ac'          => 10,
                'attacks'     => 'W1d6',
                'elbereth'    => 0,
                'level'       => 5,
                'mr'          => 10,
                'resistances' => "p",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'clay golem' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 7,
                'attacks'     => '3d10',
                'elbereth'    => 1,
                'level'       => 11,
                'mr'          => 40,
                'resistances' => "sp",
                'speed'       => 7,
                'glyph'       => "'",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1550,
                    'nutrition' => 0,
                }
            },
            'cobra' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 2,
                'attacks'     => '2d4P S0d0b',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 0,
                'resistances' => "P",
                'speed'       => 18,
                'glyph'       => "S",
                'color'       => COLOR_BLUE,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 250,
                    'nutrition' => 100,
                    'poison_resistance' => '40%',
                    'poisonous' => '100%',
                }
            },
            'cockatrice' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 6,
                'attacks'     => '1d3 0d0* (0d0*)',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 30,
                'resistances' => "P*",
                'speed'       => 6,
                'glyph'       => "c",
                'color'       => COLOR_YELLOW,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 30,
                    'nutrition' => 30,
                    'petrify' => '100%',
                    'poison_resistance' => '33%',
                }
            },
            'couatl' => {
                'alignment'   => 7,
                'ac'          => 5,
                'attacks'     => '2d4P 1d3 H2d4w',
                'elbereth'    => 0,
                'level'       => 8,
                'mr'          => 30,
                'resistances' => "p",
                'speed'       => 10,
                'glyph'       => "A",
                'color'       => COLOR_GREEN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 900,
                    'nutrition' => 0,
                }
            },
            'coyote' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 7,
                'attacks'     => '1d4',
                'elbereth'    => 1,
                'level'       => 1,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "d",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 300,
                    'nutrition' => 250,
                }
            },
            'crocodile' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 5,
                'attacks'     => '4d2 1d12',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 9,
                'glyph'       => ":",
                'color'       => COLOR_BROWN,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'demilich' => {
                'alignment'   => -12,
                'hostile'     => 1,
                'ac'          => -2,
                'attacks'     => '3d4C M0d0+',
                'elbereth'    => 1,
                'level'       => 14,
                'mr'          => 60,
                'resistances' => "Csp",
                'speed'       => 9,
                'glyph'       => "L",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1200,
                    'nutrition' => 0,
                }
            },
            'dingo' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 5,
                'attacks'     => '1d6',
                'elbereth'    => 1,
                'level'       => 4,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 16,
                'glyph'       => "d",
                'color'       => COLOR_YELLOW,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 400,
                    'nutrition' => 200,
                }
            },
            'disenchanter' => {
                'alignment'   => -3,
                'hostile'     => 1,
                'ac'          => -10,
                'attacks'     => '4d4" (0d0")',
                'elbereth'    => 1,
                'level'       => 12,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "R",
                'color'       => COLOR_BLUE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 750,
                    'nutrition' => 200,
                }
            },
            'djinni' => {
                'alignment'   => 0,
                'ac'          => 4,
                'attacks'     => 'W2d8',
                'elbereth'    => 1,
                'level'       => 7,
                'mr'          => 30,
                'resistances' => "p*",
                'speed'       => 12,
                'glyph'       => "&",
                'color'       => COLOR_YELLOW,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1500,
                    'nutrition' => 0,
                }
            },
            'dog' => {
                'alignment'   => 0,
                'ac'          => 5,
                'attacks'     => '1d6',
                'elbereth'    => 1,
                'level'       => 4,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 16,
                'glyph'       => "d",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 400,
                    'nutrition' => 200,
                    'aggravate' => '100%',
                }
            },
            'doppelganger' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 5,
                'attacks'     => 'W1d12',
                'elbereth'    => 0,
                'level'       => 9,
                'mr'          => 20,
                'resistances' => "s",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                    'polymorph' => '100%',
                }
            },
            'dust vortex' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 2,
                'attacks'     => 'E2d8b',
                'elbereth'    => 1,
                'level'       => 4,
                'mr'          => 30,
                'resistances' => "sp*",
                'speed'       => 20,
                'glyph'       => "v",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 0,
                    'nutrition' => 0,
                    vegetarian  => 1,
                    vegan       => 1,
                }
            },
            'dwarf' => {
                'alignment'   => 4,
                'ac'          => 10,
                'attacks'     => 'W1d8',
                'elbereth'    => 1,
                'level'       => 2,
                'mr'          => 10,
                'resistances' => " ",
                'speed'       => 6,
                'glyph'       => "h",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => "Dwa",
                    'weight'    => 900,
                    'nutrition' => 300,
                }
            },
            'dwarf king' => {
                'alignment'   => 6,
                'ac'          => 10,
                'attacks'     => 'W2d6 W2d6',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 20,
                'resistances' => " ",
                'speed'       => 6,
                'glyph'       => "h",
                'color'       => COLOR_MAGENTA,
                'corpse'      => {
                    'cannibal'  => "Dwa",
                    'weight'    => 900,
                    'nutrition' => 300,
                }
            },
            'dwarf lord' => {
                'alignment'   => 5,
                'ac'          => 10,
                'attacks'     => 'W2d4 W2d4',
                'elbereth'    => 1,
                'level'       => 4,
                'mr'          => 10,
                'resistances' => " ",
                'speed'       => 6,
                'glyph'       => "h",
                'color'       => COLOR_BLUE,
                'corpse'      => {
                    'cannibal'  => "Dwa",
                    'weight'    => 900,
                    'nutrition' => 300,
                }
            },
            'dwarf mummy' => {
                'alignment'   => -4,
                'hostile'     => 1,
                'ac'          => 5,
                'attacks'     => '1d6',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 20,
                'resistances' => "csp",
                'speed'       => 10,
                'glyph'       => "M",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 900,
                    'nutrition' => 150,
                    'undead'    => 'dwarf',
                }
            },
            'dwarf zombie' => {
                'alignment'   => -3,
                'hostile'     => 1,
                'ac'          => 9,
                'attacks'     => '1d6',
                'elbereth'    => 1,
                'level'       => 2,
                'mr'          => 0,
                'resistances' => "csp",
                'speed'       => 6,
                'glyph'       => "Z",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 900,
                    'nutrition' => 150,
                    'undead'    => 'dwarf',
                }
            },
            'earth elemental' => {
                'alignment'   => 0,
                'ac'          => 2,
                'attacks'     => '4d6',
                'elbereth'    => 1,
                'level'       => 8,
                'mr'          => 30,
                'resistances' => "fcp*",
                'speed'       => 6,
                'glyph'       => "E",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 2500,
                    'nutrition' => 0,
                    vegetarian  => 1,
                    vegan       => 1,
                }
            },
            'electric eel' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => -3,
                'attacks'     => '4d6E 0d0w',
                'elbereth'    => 1,
                'level'       => 7,
                'mr'          => 0,
                'resistances' => "E",
                'speed'       => 10,
                'glyph'       => ";",
                'color'       => COLOR_BRIGHT_BLUE,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 200,
                    'nutrition' => 250,
                    'shock_resistance' => '47%',
                }
            },
            'elf' => {
                'alignment'   => -3,
                'ac'          => 10,
                'attacks'     => 'W1d8',
                'elbereth'    => 0,
                'level'       => 10,
                'mr'          => 2,
                'resistances' => "S",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Elf",
                    'weight'    => 800,
                    'nutrition' => 350,
                    'sleep_resistance' => '67%',
                }
            },
            'elf mummy' => {
                'alignment'   => -5,
                'hostile'     => 1,
                'ac'          => 4,
                'attacks'     => '2d4',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 30,
                'resistances' => "csp",
                'speed'       => 12,
                'glyph'       => "M",
                'color'       => COLOR_GREEN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 800,
                    'nutrition' => 175,
                    'undead'    => 'elf',
                }
            },
            'elf zombie' => {
                'alignment'   => -3,
                'hostile'     => 1,
                'ac'          => 9,
                'attacks'     => '1d7',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 0,
                'resistances' => "csp",
                'speed'       => 6,
                'glyph'       => "Z",
                'color'       => COLOR_GREEN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 800,
                    'nutrition' => 175,
                    'undead'    => 'elf',
                }
            },
            'elf-lord' => {
                'alignment'   => -9,
                'ac'          => 10,
                'attacks'     => 'W2d4 W2d4',
                'elbereth'    => 0,
                'level'       => 8,
                'mr'          => 20,
                'resistances' => "S",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_BRIGHT_BLUE,
                'corpse'      => {
                    'cannibal'  => "Elf",
                    'weight'    => 800,
                    'nutrition' => 350,
                    'sleep_resistance' => '53%',
                }
            },
            'energy vortex' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 2,
                'attacks'     => 'E1d6E E0d0e (0d4E)',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 30,
                'resistances' => "sdep*",
                'speed'       => 20,
                'glyph'       => "v",
                'color'       => COLOR_BRIGHT_BLUE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 0,
                    'nutrition' => 0,
                    vegetarian  => 1,
                    vegan       => 1,
                }
            },
            'erinys' => {
                'alignment'   => 10,
                'hostile'     => 1,
                'ac'          => 2,
                'attacks'     => 'W2d4P',
                'elbereth'    => 1,
                'level'       => 7,
                'mr'          => 30,
                'resistances' => "fp",
                'speed'       => 12,
                'glyph'       => "&",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 0,
                }
            },
            'ettin' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 3,
                'attacks'     => 'W2d8 W3d6',
                'elbereth'    => 1,
                'level'       => 10,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "H",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1700,
                    'nutrition' => 500,
                }
            },
            'ettin mummy' => {
                'alignment'   => -6,
                'hostile'     => 1,
                'ac'          => 4,
                'attacks'     => '2d6 2d6',
                'elbereth'    => 1,
                'level'       => 7,
                'mr'          => 30,
                'resistances' => "csp",
                'speed'       => 12,
                'glyph'       => "M",
                'color'       => COLOR_BLUE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1700,
                    'nutrition' => 250,
                    'undead'    => 'ettin',
                }
            },
            'ettin zombie' => {
                'alignment'   => -4,
                'hostile'     => 1,
                'ac'          => 6,
                'attacks'     => '1d10 1d10',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 0,
                'resistances' => "csp",
                'speed'       => 8,
                'glyph'       => "Z",
                'color'       => COLOR_BLUE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1700,
                    'nutrition' => 250,
                    'undead'    => 'ettin',
                }
            },
            'fire ant' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 3,
                'attacks'     => '2d4 2d4F',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 10,
                'resistances' => "F",
                'speed'       => 18,
                'glyph'       => "a",
                'color'       => COLOR_RED,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 30,
                    'nutrition' => 10,
                    'fire_resistance' => '20%',
                }
            },
            'fire elemental' => {
                'alignment'   => 0,
                'ac'          => 2,
                'attacks'     => '3d6F (0d4F)',
                'elbereth'    => 1,
                'level'       => 8,
                'mr'          => 30,
                'resistances' => "fp*",
                'speed'       => 12,
                'glyph'       => "E",
                'color'       => COLOR_YELLOW,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 0,
                    'nutrition' => 0,
                    vegetarian  => 1,
                    vegan       => 1,
                }
            },
            'fire giant' => {
                'alignment'   => 2,
                'ac'          => 4,
                'attacks'     => 'W2d10',
                'elbereth'    => 1,
                'level'       => 9,
                'mr'          => 5,
                'resistances' => "F",
                'speed'       => 12,
                'glyph'       => "H",
                'color'       => COLOR_YELLOW,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 2250,
                    'nutrition' => 750,
                    'fire_resistance' => '30%',
                    'strength'  => '100%',
                }
            },
            'fire vortex' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 2,
                'attacks'     => 'E1d10F (0d4F)',
                'elbereth'    => 1,
                'level'       => 8,
                'mr'          => 30,
                'resistances' => "fsp*",
                'speed'       => 22,
                'glyph'       => "v",
                'color'       => COLOR_YELLOW,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 0,
                    'nutrition' => 0,
                    vegetarian  => 1,
                    vegan       => 1,
                }
            },
            'flaming sphere' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 4,
                'attacks'     => 'X4d6F',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 0,
                'resistances' => "F",
                'speed'       => 13,
                'glyph'       => "e",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 10,
                    'nutrition' => 0,
                }
            },
            'flesh golem' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 9,
                'attacks'     => '2d8 2d8',
                'elbereth'    => 1,
                'level'       => 9,
                'mr'          => 30,
                'resistances' => "FCSEP",
                'speed'       => 8,
                'glyph'       => "'",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1400,
                    'nutrition' => 600,
                    'cold_resistance' => '12%',
                    'fire_resistance' => '12%',
                    'poison_resistance' => '12%',
                    'shock_resistance' => '12%',
                    'sleep_resistance' => '12%',
                }
            },
            'floating eye' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 9,
                'attacks'     => '(0d70.)',
                'elbereth'    => 1,
                'level'       => 2,
                'mr'          => 10,
                'resistances' => " ",
                'speed'       => 1,
                'glyph'       => "e",
                'color'       => COLOR_BLUE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 10,
                    'nutrition' => 10,
                    'telepathy' => '100%',
                }
            },
            'fog cloud' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 0,
                'attacks'     => 'E1d6',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 0,
                'resistances' => "sp*",
                'speed'       => 1,
                'glyph'       => "v",
                'color'       => COLOR_GRAY,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 0,
                    'nutrition' => 0,
                    vegetarian  => 1,
                    vegan       => 1,
                }
            },
            'forest centaur' => {
                'alignment'   => -1,
                'ac'          => 3,
                'attacks'     => 'W1d8 1d6',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 10,
                'resistances' => " ",
                'speed'       => 18,
                'glyph'       => "C",
                'color'       => COLOR_GREEN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 2550,
                    'nutrition' => 600,
                }
            },
            'fox' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 7,
                'attacks'     => '1d3',
                'elbereth'    => 1,
                'level'       => 0,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 15,
                'glyph'       => "d",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 300,
                    'nutrition' => 250,
                }
            },
            'freezing sphere' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 4,
                'attacks'     => 'X4d6C',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 0,
                'resistances' => "C",
                'speed'       => 13,
                'glyph'       => "e",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 10,
                    'nutrition' => 0,
                }
            },
            'frost giant' => {
                'alignment'   => -3,
                'ac'          => 3,
                'attacks'     => 'W2d12',
                'elbereth'    => 1,
                'level'       => 10,
                'mr'          => 10,
                'resistances' => "C",
                'speed'       => 12,
                'glyph'       => "H",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 2250,
                    'nutrition' => 750,
                    'cold_resistance' => '33%',
                    'strength'  => '100%',
                }
            },
            'gargoyle' => {
                'alignment'   => -9,
                'hostile'     => 1,
                'ac'          => -4,
                'attacks'     => '2d6 2d6 2d4',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 0,
                'resistances' => "*",
                'speed'       => 10,
                'glyph'       => "g",
                'color'       => COLOR_BROWN,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1000,
                    'nutrition' => 200,
                }
            },
            'garter snake' => {
                'alignment'   => 0,
                'ac'          => 8,
                'attacks'     => '1d2',
                'elbereth'    => 1,
                'level'       => 1,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 8,
                'glyph'       => "S",
                'color'       => COLOR_GREEN,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 50,
                    'nutrition' => 60,
                }
            },
            'gas spore' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 10,
                'attacks'     => '[X4d6]',
                'elbereth'    => 1,
                'level'       => 1,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 3,
                'glyph'       => "e",
                'color'       => COLOR_GRAY,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 10,
                    'nutrition' => 0,
                }
            },
            'gecko' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 8,
                'attacks'     => '1d3',
                'elbereth'    => 1,
                'level'       => 1,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 6,
                'glyph'       => ":",
                'color'       => COLOR_GREEN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 10,
                    'nutrition' => 20,
                }
            },
            'gelatinous cube' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 8,
                'attacks'     => '2d4. (1d4.)',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 0,
                'resistances' => "FCSEpa*",
                'speed'       => 6,
                'glyph'       => "b",
                'color'       => COLOR_CYAN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 600,
                    'nutrition' => 150,
                    'acidic'    => '100%',
                    'cold_resistance' => '10%',
                    'fire_resistance' => '10%',
                    'shock_resistance' => '10%',
                    'sleep_resistance' => '10%',
                    vegetarian  => 1,
                    vegan       => 1,
                }
            },
            'ghost' => {
                'alignment'   => -5,
                'hostile'     => 1,
                'ac'          => -5,
                'attacks'     => '1d1',
                'elbereth'    => 1,
                'level'       => 10,
                'mr'          => 50,
                'resistances' => "csdp*",
                'speed'       => 3,
                'glyph'       => "X",
                'color'       => COLOR_GRAY,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 0,
                    vegetarian  => 1,
                    vegan       => 1,
                }
            },
            'ghoul' => {
                'alignment'   => -2,
                'hostile'     => 1,
                'ac'          => 10,
                'attacks'     => '1d2. 1d3',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 0,
                'resistances' => "csp",
                'speed'       => 6,
                'glyph'       => "Z",
                'color'       => COLOR_BLACK,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 400,
                    'nutrition' => 0,
                }
            },
            'giant' => {
                'alignment'   => 2,
                'ac'          => 0,
                'attacks'     => 'W2d10',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 6,
                'glyph'       => "H",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 2250,
                    'nutrition' => 750,
                    'strength'  => '100%',
                }
            },
            'giant ant' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 3,
                'attacks'     => '1d4',
                'elbereth'    => 1,
                'level'       => 2,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 18,
                'glyph'       => "a",
                'color'       => COLOR_BROWN,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 10,
                    'nutrition' => 10,
                }
            },
            'giant bat' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 7,
                'attacks'     => '1d6',
                'elbereth'    => 1,
                'level'       => 2,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 22,
                'glyph'       => "B",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 30,
                    'nutrition' => 30,
                    'stun' => '60',
                }
            },
            'giant beetle' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 4,
                'attacks'     => '3d6',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 0,
                'resistances' => "P",
                'speed'       => 6,
                'glyph'       => "a",
                'color'       => COLOR_BLACK,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 10,
                    'nutrition' => 10,
                    'poison_resistance' => '33%',
                    'poisonous' => '100%',
                }
            },
            'giant eel' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => -1,
                'attacks'     => '3d6 0d0w',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 9,
                'glyph'       => ";",
                'color'       => COLOR_CYAN,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 200,
                    'nutrition' => 250,
                }
            },
            'giant mimic' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 7,
                'attacks'     => '3d6m 3d6m',
                'elbereth'    => 1,
                'level'       => 9,
                'mr'          => 20,
                'resistances' => "a",
                'speed'       => 3,
                'glyph'       => "m",
                'color'       => COLOR_MAGENTA,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 800,
                    'nutrition' => 500,
                    'mimic' => '50',
                }
            },
            'giant mummy' => {
                'alignment'   => -7,
                'hostile'     => 1,
                'ac'          => 3,
                'attacks'     => '3d4 3d4',
                'elbereth'    => 1,
                'level'       => 8,
                'mr'          => 30,
                'resistances' => "csp",
                'speed'       => 14,
                'glyph'       => "M",
                'color'       => COLOR_CYAN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 2050,
                    'nutrition' => 375,
                    'undead'    => 'giant',
                }
            },
            'giant rat' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 7,
                'attacks'     => '1d3',
                'elbereth'    => 1,
                'level'       => 1,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 10,
                'glyph'       => "r",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 30,
                    'nutrition' => 30,
                }
            },
            'giant spider' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 4,
                'attacks'     => '2d4P',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 0,
                'resistances' => "P",
                'speed'       => 15,
                'glyph'       => "s",
                'color'       => COLOR_MAGENTA,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 100,
                    'nutrition' => 100,
                    'poison_resistance' => '33%',
                    'poisonous' => '100%',
                }
            },
            'giant zombie' => {
                'alignment'   => -4,
                'hostile'     => 1,
                'ac'          => 6,
                'attacks'     => '2d8 2d8',
                'elbereth'    => 1,
                'level'       => 8,
                'mr'          => 0,
                'resistances' => "csp",
                'speed'       => 8,
                'glyph'       => "Z",
                'color'       => COLOR_CYAN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 2050,
                    'nutrition' => 375,
                    'undead'    => 'giant',
                }
            },
            'glass golem' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 1,
                'attacks'     => '2d8 2d8',
                'elbereth'    => 1,
                'level'       => 16,
                'mr'          => 50,
                'resistances' => "spa",
                'speed'       => 6,
                'glyph'       => "'",
                'color'       => COLOR_CYAN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1800,
                    'nutrition' => 0,
                    vegetarian  => 1,
                    vegan       => 1,
                }
            },
            'glass piercer' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 0,
                'attacks'     => '4d6',
                'elbereth'    => 1,
                'level'       => 7,
                'mr'          => 0,
                'resistances' => "a",
                'speed'       => 1,
                'glyph'       => "p",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 400,
                    'nutrition' => 300,
                }
            },
            'gnome' => {
                'alignment'   => 0,
                'ac'          => 10,
                'attacks'     => 'W1d6',
                'elbereth'    => 1,
                'level'       => 1,
                'mr'          => 4,
                'resistances' => " ",
                'speed'       => 6,
                'glyph'       => "G",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => "Gno",
                    'weight'    => 650,
                    'nutrition' => 100,
                }
            },
            'gnome king' => {
                'alignment'   => 0,
                'ac'          => 10,
                'attacks'     => 'W2d6',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 20,
                'resistances' => " ",
                'speed'       => 10,
                'glyph'       => "G",
                'color'       => COLOR_MAGENTA,
                'corpse'      => {
                    'cannibal'  => "Gno",
                    'weight'    => 750,
                    'nutrition' => 150,
                }
            },
            'gnome lord' => {
                'alignment'   => 0,
                'ac'          => 10,
                'attacks'     => 'W1d8',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 4,
                'resistances' => " ",
                'speed'       => 8,
                'glyph'       => "G",
                'color'       => COLOR_BLUE,
                'corpse'      => {
                    'cannibal'  => "Gno",
                    'weight'    => 700,
                    'nutrition' => 120,
                }
            },
            'gnome mummy' => {
                'alignment'   => -3,
                'hostile'     => 1,
                'ac'          => 6,
                'attacks'     => '1d6',
                'elbereth'    => 1,
                'level'       => 4,
                'mr'          => 20,
                'resistances' => "csp",
                'speed'       => 10,
                'glyph'       => "M",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 650,
                    'nutrition' => 50,
                    'undead'    => 'gnome',
                }
            },
            'gnome zombie' => {
                'alignment'   => -2,
                'hostile'     => 1,
                'ac'          => 10,
                'attacks'     => '1d5',
                'elbereth'    => 1,
                'level'       => 1,
                'mr'          => 0,
                'resistances' => "csp",
                'speed'       => 6,
                'glyph'       => "Z",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 650,
                    'nutrition' => 50,
                    'undead'    => 'gnome',
                }
            },
            'gnomish wizard' => {
                'alignment'   => 0,
                'ac'          => 4,
                'attacks'     => 'M0d0+',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 10,
                'resistances' => " ",
                'speed'       => 10,
                'glyph'       => "G",
                'color'       => COLOR_BRIGHT_BLUE,
                'corpse'      => {
                    'cannibal'  => "Gno",
                    'weight'    => 700,
                    'nutrition' => 120,
                }
            },
            'goblin' => {
                'alignment'   => -3,
                'ac'          => 10,
                'attacks'     => 'W1d4',
                'elbereth'    => 1,
                'level'       => 0,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 6,
                'glyph'       => "o",
                'color'       => COLOR_GRAY,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 400,
                    'nutrition' => 100,
                }
            },
            'gold golem' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 6,
                'attacks'     => '2d3 2d3',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 0,
                'resistances' => "spa",
                'speed'       => 9,
                'glyph'       => "'",
                'color'       => COLOR_YELLOW,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 450,
                    'nutrition' => 0,
                    vegetarian  => 1,
                    vegan       => 1,
                }
            },
            'golden naga' => {
                'alignment'   => 5,
                'ac'          => 2,
                'attacks'     => '2d6 M4d6+',
                'elbereth'    => 1,
                'level'       => 10,
                'mr'          => 70,
                'resistances' => "P",
                'speed'       => 14,
                'glyph'       => "N",
                'color'       => COLOR_YELLOW,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 2600,
                    'nutrition' => 400,
                    'poison_resistance' => '67%',
                }
            },
            'golden naga hatchling' => {
                'alignment'   => 0,
                'ac'          => 6,
                'attacks'     => '1d4',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 0,
                'resistances' => "P",
                'speed'       => 10,
                'glyph'       => "N",
                'color'       => COLOR_YELLOW,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 500,
                    'nutrition' => 100,
                    'poison_resistance' => '20%',
                }
            },
            'gray dragon' => {
                'alignment'   => 4,
                'hostile'     => 1,
                'ac'          => -1,
                'attacks'     => 'B4d6M 3d8 1d4 1d4',
                'elbereth'    => 1,
                'level'       => 15,
                'mr'          => 20,
                'resistances' => " ",
                'speed'       => 9,
                'glyph'       => "D",
                'color'       => COLOR_GRAY,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 4500,
                    'nutrition' => 1500,
                }
            },
            'gray ooze' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 8,
                'attacks'     => '2d8R',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 0,
                'resistances' => "FCPa*",
                'speed'       => 1,
                'glyph'       => "P",
                'color'       => COLOR_GRAY,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 500,
                    'nutrition' => 250,
                    'acidic'    => '100%',
                    'cold_resistance' => '7%',
                    'fire_resistance' => '7%',
                    'poison_resistance' => '7%',
                    vegetarian  => 1,
                }
            },
            'gray unicorn' => {
                'alignment'   => 0,
                'ac'          => 2,
                'attacks'     => '1d12 1d6',
                'elbereth'    => 1,
                'level'       => 4,
                'mr'          => 70,
                'resistances' => "P",
                'speed'       => 24,
                'glyph'       => "u",
                'color'       => COLOR_GRAY,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1300,
                    'nutrition' => 300,
                    'poison_resistance' => '27%',
                }
            },
            'green dragon' => {
                'alignment'   => 6,
                'hostile'     => 1,
                'ac'          => -1,
                'attacks'     => 'B4d6P 3d8 1d4 1d4',
                'elbereth'    => 1,
                'level'       => 15,
                'mr'          => 20,
                'resistances' => "P",
                'speed'       => 9,
                'glyph'       => "D",
                'color'       => COLOR_GREEN,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 4500,
                    'nutrition' => 1500,
                    'poison_resistance' => '100%',
                    'poisonous' => '100%',
                }
            },
            'green mold' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 9,
                'attacks'     => '(0d4A)',
                'elbereth'    => 1,
                'level'       => 1,
                'mr'          => 0,
                'resistances' => "a*",
                'speed'       => 0,
                'glyph'       => "F",
                'color'       => COLOR_GREEN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 50,
                    'nutrition' => 30,
                    'acidic'    => '100%',
                    vegetarian  => 1,
                    vegan       => 1,
                }
            },
            'green slime' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 6,
                'attacks'     => '1d4@ (0d0@)',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 0,
                'resistances' => "cepa*",
                'speed'       => 6,
                'glyph'       => "P",
                'color'       => COLOR_GREEN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 400,
                    'nutrition' => 150,
                    'acidic'    => '100%',
                    'poisonous' => '100%',
                    'slime'     => '100%',
                    vegetarian  => 1,
                }
            },
            'gremlin' => {
                'alignment'   => -9,
                'ac'          => 2,
                'attacks'     => '1d6 1d6 1d4 0d0i',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 25,
                'resistances' => "P",
                'speed'       => 12,
                'glyph'       => "g",
                'color'       => COLOR_GREEN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 100,
                    'nutrition' => 20,
                    'poison_resistance' => '33%',
                    'poisonous' => '100%',
                }
            },
            'grid bug' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 9,
                'attacks'     => '1d1E',
                'elbereth'    => 1,
                'level'       => 0,
                'mr'          => 0,
                'resistances' => "ep",
                'speed'       => 12,
                'glyph'       => "x",
                'color'       => COLOR_MAGENTA,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 15,
                    'nutrition' => 0,
                }
            },
            'guard' => {
                'alignment'   => 10,
                'peaceful'    => 1,
                'ac'          => 10,
                'attacks'     => 'W4d10',
                'elbereth'    => 0,
                'level'       => 12,
                'mr'          => 40,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_BLUE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'guardian naga' => {
                'alignment'   => 7,
                'ac'          => 0,
                'attacks'     => '1d6. S1d6P H2d4',
                'elbereth'    => 0,
                'level'       => 12,
                'mr'          => 50,
                'resistances' => "P",
                'speed'       => 16,
                'glyph'       => "N",
                'color'       => COLOR_GREEN,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 2600,
                    'nutrition' => 400,
                    'poison_resistance' => '80%',
                    'poisonous' => '100%',
                }
            },
            'guardian naga hatchling' => {
                'alignment'   => 0,
                'ac'          => 6,
                'attacks'     => '1d4',
                'elbereth'    => 0,
                'level'       => 3,
                'mr'          => 0,
                'resistances' => "P",
                'speed'       => 10,
                'glyph'       => "N",
                'color'       => COLOR_GREEN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 500,
                    'nutrition' => 100,
                    'poison_resistance' => '20%',
                }
            },
            'guide' => {
                'alignment'   => 0,
                'peaceful'    => 1,
                'ac'          => 10,
                'attacks'     => 'W1d6 M0d0+',
                'elbereth'    => 0,
                'level'       => 5,
                'mr'          => 20,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'healer' => {
                'alignment'   => 0,
                'ac'          => 10,
                'attacks'     => 'W1d6',
                'elbereth'    => 0,
                'level'       => 10,
                'mr'          => 1,
                'resistances' => "p",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'hell hound' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 2,
                'attacks'     => '3d6 B3d6F',
                'elbereth'    => 1,
                'level'       => 12,
                'mr'          => 20,
                'resistances' => "F",
                'speed'       => 14,
                'glyph'       => "d",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 600,
                    'nutrition' => 300,
                    'fire_resistance' => '80%',
                }
            },
            'hell hound pup' => {
                'alignment'   => -5,
                'hostile'     => 1,
                'ac'          => 4,
                'attacks'     => '2d6 B2d6F',
                'elbereth'    => 1,
                'level'       => 7,
                'mr'          => 20,
                'resistances' => "F",
                'speed'       => 12,
                'glyph'       => "d",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 200,
                    'nutrition' => 200,
                    'fire_resistance' => '47%',
                }
            },
            'hezrou' => {
                'alignment'   => -10,
                'hostile'     => 1,
                'ac'          => -2,
                'attacks'     => '1d3 1d3 4d4',
                'elbereth'    => 1,
                'level'       => 9,
                'mr'          => 55,
                'resistances' => "fp",
                'speed'       => 6,
                'glyph'       => "&",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 0,
                }
            },
            'high priest' => {
                'alignment'   => 0,
                'ac'          => 7,
                'attacks'     => 'W4d10 2d8 M2d8+ M2d8+',
                'elbereth'    => 0,
                'level'       => 25,
                'mr'          => 70,
                'resistances' => "fsep",
                'speed'       => 15,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'hill giant' => {
                'alignment'   => -2,
                'ac'          => 6,
                'attacks'     => 'W2d8',
                'elbereth'    => 1,
                'level'       => 8,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 10,
                'glyph'       => "H",
                'color'       => COLOR_CYAN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 2200,
                    'nutrition' => 700,
                    'strength'  => '100%',
                }
            },
            'hill orc' => {
                'alignment'   => -4,
                'ac'          => 10,
                'attacks'     => 'W1d6',
                'elbereth'    => 1,
                'level'       => 2,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 9,
                'glyph'       => "o",
                'color'       => COLOR_YELLOW,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1000,
                    'nutrition' => 200,
                }
            },
            'hobbit' => {
                'alignment'   => 6,
                'ac'          => 10,
                'attacks'     => 'W1d6',
                'elbereth'    => 1,
                'level'       => 1,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 9,
                'glyph'       => "h",
                'color'       => COLOR_GREEN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 500,
                    'nutrition' => 200,
                }
            },
            'hobgoblin' => {
                'alignment'   => -4,
                'ac'          => 10,
                'attacks'     => 'W1d6',
                'elbereth'    => 1,
                'level'       => 1,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 9,
                'glyph'       => "o",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1000,
                    'nutrition' => 200,
                }
            },
            'homunculus' => {
                'alignment'   => -7,
                'ac'          => 6,
                'attacks'     => '1d3S',
                'elbereth'    => 1,
                'level'       => 2,
                'mr'          => 10,
                'resistances' => "SP",
                'speed'       => 12,
                'glyph'       => "i",
                'color'       => COLOR_GREEN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 60,
                    'nutrition' => 100,
                    'poison_resistance' => '7%',
                    'poisonous' => '100%',
                    'sleep_resistance' => '7%',
                }
            },
            'horned devil' => {
                'alignment'   => 11,
                'hostile'     => 1,
                'ac'          => -5,
                'attacks'     => 'W1d4 1d4 2d3 1d3',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 50,
                'resistances' => "fp",
                'speed'       => 9,
                'glyph'       => "&",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 0,
                }
            },
            'horse' => {
                'alignment'   => 0,
                'ac'          => 5,
                'attacks'     => '1d8 1d3',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 20,
                'glyph'       => "u",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1500,
                    'nutrition' => 300,
                }
            },
            'housecat' => {
                'alignment'   => 0,
                'ac'          => 5,
                'attacks'     => '1d6',
                'elbereth'    => 1,
                'level'       => 4,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 16,
                'glyph'       => "f",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 200,
                    'nutrition' => 200,
                    'aggravate' => '100%',
                }
            },
            'human' => {
                'alignment'   => 0,
                'ac'          => 10,
                'attacks'     => 'W1d6',
                'elbereth'    => 0,
                'level'       => 0,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'human mummy' => {
                'alignment'   => -5,
                'hostile'     => 1,
                'ac'          => 4,
                'attacks'     => '2d4 2d4',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 30,
                'resistances' => "csp",
                'speed'       => 12,
                'glyph'       => "M",
                'color'       => COLOR_GRAY,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 200,
                    'undead'    => 'human',
                }
            },
            'human zombie' => {
                'alignment'   => -3,
                'hostile'     => 1,
                'ac'          => 8,
                'attacks'     => '1d8',
                'elbereth'    => 1,
                'level'       => 4,
                'mr'          => 0,
                'resistances' => "csp",
                'speed'       => 6,
                'glyph'       => "Z",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 200,
                    'undead'    => 'human',
                }
            },
            'hunter' => {
                'alignment'   => -7,
                'peaceful'    => 1,
                'ac'          => 10,
                'attacks'     => 'W1d4',
                'elbereth'    => 0,
                'level'       => 5,
                'mr'          => 10,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'ice devil' => {
                'alignment'   => -12,
                'hostile'     => 1,
                'ac'          => -4,
                'attacks'     => '1d4 1d4 2d4 3d4C',
                'elbereth'    => 1,
                'level'       => 11,
                'mr'          => 55,
                'resistances' => "fcp",
                'speed'       => 6,
                'glyph'       => "&",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 0,
                }
            },
            'ice troll' => {
                'alignment'   => -3,
                'hostile'     => 1,
                'ac'          => 2,
                'attacks'     => 'W2d6 2d6C 2d6',
                'elbereth'    => 1,
                'level'       => 9,
                'mr'          => 20,
                'resistances' => "C",
                'speed'       => 10,
                'glyph'       => "T",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1000,
                    'nutrition' => 300,
                    'cold_resistance' => '60%',
                    'reanimates' => 1,
                }
            },
            'ice vortex' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 2,
                'attacks'     => 'E1d6C',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 30,
                'resistances' => "csp*",
                'speed'       => 20,
                'glyph'       => "v",
                'color'       => COLOR_CYAN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 0,
                    'nutrition' => 0,
                    vegetarian  => 1,
                    vegan       => 1,
                }
            },
            'iguana' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 7,
                'attacks'     => '1d4',
                'elbereth'    => 1,
                'level'       => 2,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 6,
                'glyph'       => ":",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 30,
                    'nutrition' => 30,
                }
            },
            'imp' => {
                'alignment'   => -7,
                'ac'          => 2,
                'attacks'     => '1d4',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 20,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "i",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 20,
                    'nutrition' => 10,
                }
            },
            'incubus' => {
                'alignment'   => -9,
                'hostile'     => 1,
                'ac'          => 0,
                'attacks'     => '0d0&amp; 1d3 1d3',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 70,
                'resistances' => "fp",
                'speed'       => 12,
                'glyph'       => "&",
                'color'       => COLOR_GRAY,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 0,
                }
            },
            'iron golem' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 3,
                'attacks'     => 'W4d10 B4d6P',
                'elbereth'    => 1,
                'level'       => 18,
                'mr'          => 60,
                'resistances' => "fcsep",
                'speed'       => 6,
                'glyph'       => "'",
                'color'       => COLOR_CYAN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 2000,
                    'nutrition' => 0,
                    vegetarian  => 1,
                    vegan       => 1,
                }
            },
            'iron piercer' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 0,
                'attacks'     => '3d6',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 1,
                'glyph'       => "p",
                'color'       => COLOR_CYAN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 400,
                    'nutrition' => 300,
                }
            },
            'jabberwock' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => -2,
                'attacks'     => '2d10 2d10 2d10 2d10',
                'elbereth'    => 1,
                'level'       => 15,
                'mr'          => 50,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "J",
                'color'       => COLOR_ORANGE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1300,
                    'nutrition' => 600,
                }
            },
            'jackal' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 7,
                'attacks'     => '1d2',
                'elbereth'    => 1,
                'level'       => 0,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "d",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 300,
                    'nutrition' => 250,
                }
            },
            'jaguar' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 6,
                'attacks'     => '1d4 1d4 1d8',
                'elbereth'    => 1,
                'level'       => 4,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 15,
                'glyph'       => "f",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 600,
                    'nutrition' => 300,
                }
            },
            'jellyfish' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 6,
                'attacks'     => '3d3P',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 0,
                'resistances' => "P",
                'speed'       => 3,
                'glyph'       => ";",
                'color'       => COLOR_BLUE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 80,
                    'nutrition' => 20,
                    'poison_resistance' => '20%',
                    'poisonous' => '100%',
                }
            },
            'ki-rin' => {
                'alignment'   => 15,
                'ac'          => -5,
                'attacks'     => '2d4 2d4 3d6 M2d6+',
                'elbereth'    => 0,
                'level'       => 16,
                'mr'          => 90,
                'resistances' => " ",
                'speed'       => 18,
                'glyph'       => "A",
                'color'       => COLOR_YELLOW,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 0,
                }
            },
            'killer bee' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => -1,
                'attacks'     => '1d3P',
                'elbereth'    => 1,
                'level'       => 1,
                'mr'          => 0,
                'resistances' => "P",
                'speed'       => 18,
                'glyph'       => "a",
                'color'       => COLOR_YELLOW,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1,
                    'nutrition' => 5,
                    'poison_resistance' => '30%',
                    'poisonous' => '100%',
                }
            },
            'kitten' => {
                'alignment'   => 0,
                'ac'          => 6,
                'attacks'     => '1d6',
                'elbereth'    => 1,
                'level'       => 2,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 18,
                'glyph'       => "f",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 150,
                    'nutrition' => 150,
                    'aggravate' => '100%',
                }
            },
            'knight' => {
                'alignment'   => 3,
                'ac'          => 10,
                'attacks'     => 'W1d6 W1d6',
                'elbereth'    => 0,
                'level'       => 10,
                'mr'          => 1,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'kobold' => {
                'alignment'   => -2,
                'hostile'     => 1,
                'ac'          => 10,
                'attacks'     => 'W1d4',
                'elbereth'    => 1,
                'level'       => 0,
                'mr'          => 0,
                'resistances' => "p",
                'speed'       => 6,
                'glyph'       => "k",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 400,
                    'nutrition' => 100,
                    'poisonous' => '100%',
                }
            },
            'kobold lord' => {
                'alignment'   => -4,
                'hostile'     => 1,
                'ac'          => 10,
                'attacks'     => 'W2d4',
                'elbereth'    => 1,
                'level'       => 2,
                'mr'          => 0,
                'resistances' => "p",
                'speed'       => 6,
                'glyph'       => "k",
                'color'       => COLOR_MAGENTA,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 500,
                    'nutrition' => 200,
                    'poisonous' => '100%',
                }
            },
            'kobold mummy' => {
                'alignment'   => -2,
                'hostile'     => 1,
                'ac'          => 6,
                'attacks'     => '1d4',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 20,
                'resistances' => "csp",
                'speed'       => 8,
                'glyph'       => "M",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 400,
                    'nutrition' => 50,
                    'undead'    => 'kobold',
                }
            },
            'kobold shaman' => {
                'alignment'   => -4,
                'hostile'     => 1,
                'ac'          => 6,
                'attacks'     => 'M0d0+',
                'elbereth'    => 1,
                'level'       => 2,
                'mr'          => 10,
                'resistances' => "p",
                'speed'       => 6,
                'glyph'       => "k",
                'color'       => COLOR_BRIGHT_BLUE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 450,
                    'nutrition' => 150,
                    'poisonous' => '100%',
                }
            },
            'kobold zombie' => {
                'alignment'   => -2,
                'hostile'     => 1,
                'ac'          => 10,
                'attacks'     => '1d4',
                'elbereth'    => 1,
                'level'       => 0,
                'mr'          => 0,
                'resistances' => "csp",
                'speed'       => 6,
                'glyph'       => "Z",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 400,
                    'nutrition' => 50,
                    'undead'    => 'kobold',
                }
            },
            'kraken' => {
                'alignment'   => -3,
                'hostile'     => 1,
                'ac'          => 6,
                'attacks'     => '2d4 2d4 H2d6w 5d4',
                'elbereth'    => 1,
                'level'       => 20,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 3,
                'glyph'       => ";",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1800,
                    'nutrition' => 1000,
                }
            },
            'large cat' => {
                'alignment'   => 0,
                'ac'          => 4,
                'attacks'     => '2d4',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 15,
                'glyph'       => "f",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 250,
                    'nutrition' => 250,
                    'aggravate' => '100%',
                }
            },
            'large dog' => {
                'alignment'   => 0,
                'ac'          => 4,
                'attacks'     => '2d4',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 15,
                'glyph'       => "d",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 800,
                    'nutrition' => 250,
                    'aggravate' => '100%',
                }
            },
            'large kobold' => {
                'alignment'   => -3,
                'hostile'     => 1,
                'ac'          => 10,
                'attacks'     => 'W1d6',
                'elbereth'    => 1,
                'level'       => 1,
                'mr'          => 0,
                'resistances' => "p",
                'speed'       => 6,
                'glyph'       => "k",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 450,
                    'nutrition' => 150,
                    'poisonous' => '100%',
                }
            },
            'large mimic' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 7,
                'attacks'     => '3d4m',
                'elbereth'    => 1,
                'level'       => 8,
                'mr'          => 10,
                'resistances' => "a",
                'speed'       => 3,
                'glyph'       => "m",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 600,
                    'nutrition' => 400,
                    'mimic' => '40',
                }
            },
            'leather golem' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 6,
                'attacks'     => '1d6 1d6',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 0,
                'resistances' => "sp",
                'speed'       => 6,
                'glyph'       => "'",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 800,
                    'nutrition' => 0,
                }
            },
            'lemure' => {
                'alignment'   => -7,
                'hostile'     => 1,
                'ac'          => 7,
                'attacks'     => '1d3',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 0,
                'resistances' => "Sp",
                'speed'       => 3,
                'glyph'       => "i",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 150,
                    'nutrition' => 0,
                }
            },
            'leocrotta' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 4,
                'attacks'     => '2d6 2d6 2d6',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 10,
                'resistances' => " ",
                'speed'       => 18,
                'glyph'       => "q",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1200,
                    'nutrition' => 500,
                }
            },
            'leprechaun' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 8,
                'attacks'     => '1d2$',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 20,
                'resistances' => " ",
                'speed'       => 15,
                'glyph'       => "l",
                'color'       => COLOR_GREEN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 60,
                    'nutrition' => 30,
                    'teleportitis' => '50%',
                }
            },
            'lich' => {
                'alignment'   => -9,
                'hostile'     => 1,
                'ac'          => 0,
                'attacks'     => '1d10C M0d0+',
                'elbereth'    => 1,
                'level'       => 11,
                'mr'          => 30,
                'resistances' => "Csp",
                'speed'       => 6,
                'glyph'       => "L",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1200,
                    'nutrition' => 0,
                }
            },
            'lichen' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 9,
                'attacks'     => '0d0m',
                'elbereth'    => 1,
                'level'       => 0,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 1,
                'glyph'       => "F",
                'color'       => COLOR_BRIGHT_GREEN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 20,
                    'nutrition' => 200,
                    vegetarian  => 1,
                    vegan       => 1,
                    'permanent' => 1,
                }
            },
            'lieutenant' => {
                'alignment'   => -4,
                'hostile'     => 1,
                'ac'          => 10,
                'attacks'     => 'W3d4 W3d4',
                'elbereth'    => 0,
                'level'       => 10,
                'mr'          => 15,
                'resistances' => " ",
                'speed'       => 10,
                'glyph'       => "@",
                'color'       => COLOR_GREEN,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'little dog' => {
                'alignment'   => 0,
                'ac'          => 6,
                'attacks'     => '1d6',
                'elbereth'    => 1,
                'level'       => 2,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 18,
                'glyph'       => "d",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 150,
                    'nutrition' => 150,
                    'aggravate' => '100%',
                }
            },
            'lizard' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 6,
                'attacks'     => '1d6',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 10,
                'resistances' => "*",
                'speed'       => 6,
                'glyph'       => ":",
                'color'       => COLOR_GREEN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 10,
                    'nutrition' => 40,
                    'cure_confusion' => '100%',
                    'cure_stoning' => '100%',
                    'reduce_stunning' => '100%',
                    'permanent' => 1,
                }
            },
            'long worm' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 5,
                'attacks'     => '1d4',
                'elbereth'    => 1,
                'level'       => 8,
                'mr'          => 10,
                'resistances' => " ",
                'speed'       => 3,
                'glyph'       => "w",
                'color'       => COLOR_BROWN,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1500,
                    'nutrition' => 500,
                }
            },
            'lurker above' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 3,
                'attacks'     => 'E1d8d',
                'elbereth'    => 1,
                'level'       => 10,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 3,
                'glyph'       => "t",
                'color'       => COLOR_GRAY,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 800,
                    'nutrition' => 350,
                }
            },
            'lynx' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 6,
                'attacks'     => '1d4 1d4 1d10',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 15,
                'glyph'       => "f",
                'color'       => COLOR_CYAN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 600,
                    'nutrition' => 300,
                }
            },
            'manes' => {
                'alignment'   => -7,
                'hostile'     => 1,
                'ac'          => 7,
                'attacks'     => '1d3 1d3 1d4',
                'elbereth'    => 1,
                'level'       => 1,
                'mr'          => 0,
                'resistances' => "sp",
                'speed'       => 3,
                'glyph'       => "i",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 100,
                    'nutrition' => 0,
                }
            },
            'marilith' => {
                'alignment'   => -12,
                'hostile'     => 1,
                'ac'          => -6,
                'attacks'     => 'W2d4 W2d4 2d4 2d4 2d4 2d4',
                'elbereth'    => 1,
                'level'       => 7,
                'mr'          => 80,
                'resistances' => "fp",
                'speed'       => 12,
                'glyph'       => "&",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 0,
                }
            },
            'master lich' => {
                'alignment'   => -15,
                'hostile'     => 1,
                'ac'          => -4,
                'attacks'     => '3d6C M0d0+',
                'elbereth'    => 1,
                'level'       => 17,
                'mr'          => 90,
                'resistances' => "FCsp",
                'speed'       => 9,
                'glyph'       => "L",
                'color'       => COLOR_MAGENTA,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1200,
                    'nutrition' => 0,
                }
            },
            'master mind flayer' => {
                'alignment'   => -8,
                'hostile'     => 1,
                'ac'          => 0,
                'attacks'     => 'W1d8 2!I 2!I 2!I 2!I 2!I',
                'elbereth'    => 1,
                'level'       => 13,
                'mr'          => 90,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "h",
                'color'       => COLOR_MAGENTA,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 400,
                    'telepathy' => '50%',
                    'intelligence' => '50%',
                }
            },
            'mastodon' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 5,
                'attacks'     => '4d8 4d8',
                'elbereth'    => 1,
                'level'       => 20,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "q",
                'color'       => COLOR_BLACK,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 3800,
                    'nutrition' => 800,
                }
            },
            'mind flayer' => {
                'alignment'   => -8,
                'hostile'     => 1,
                'ac'          => 5,
                'attacks'     => 'W1d4 2!I 2!I 2!I',
                'elbereth'    => 1,
                'level'       => 9,
                'mr'          => 90,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "h",
                'color'       => COLOR_MAGENTA,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 400,
                    'telepathy' => '50%',
                    'intelligence' => '50%',
                }
            },
            'minotaur' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 6,
                'attacks'     => '3d10 3d10 2d8',
                'elbereth'    => 0,
                'level'       => 15,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 15,
                'glyph'       => "H",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1500,
                    'nutrition' => 700,
                }
            },
            'monk' => {
                'alignment'   => 0,
                'ac'          => 10,
                'attacks'     => '1d8 1d8',
                'elbereth'    => 0,
                'level'       => 10,
                'mr'          => 2,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'monkey' => {
                'alignment'   => 0,
                'ac'          => 6,
                'attacks'     => '0d0- 1d3',
                'elbereth'    => 1,
                'level'       => 2,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "Y",
                'color'       => COLOR_GRAY,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 100,
                    'nutrition' => 50,
                }
            },
            'mountain centaur' => {
                'alignment'   => -3,
                'ac'          => 2,
                'attacks'     => 'W1d10 1d6 1d6',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 10,
                'resistances' => " ",
                'speed'       => 20,
                'glyph'       => "C",
                'color'       => COLOR_CYAN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 2550,
                    'nutrition' => 500,
                }
            },
            'mountain nymph' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 9,
                'attacks'     => '0d0- 0d0-',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 20,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "n",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 600,
                    'nutrition' => 300,
                    'teleportitis' => '30%',
                }
            },
            'mumak' => {
                'alignment'   => -2,
                'hostile'     => 1,
                'ac'          => 0,
                'attacks'     => '4d12 2d6',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 9,
                'glyph'       => "q",
                'color'       => COLOR_GRAY,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 2500,
                    'nutrition' => 500,
                }
            },
            'nalfeshnee' => {
                'alignment'   => -11,
                'hostile'     => 1,
                'ac'          => -1,
                'attacks'     => '1d4 1d4 2d4 M0d0+',
                'elbereth'    => 1,
                'level'       => 11,
                'mr'          => 65,
                'resistances' => "fp",
                'speed'       => 9,
                'glyph'       => "&",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 0,
                }
            },
            'neanderthal' => {
                'alignment'   => 1,
                'peaceful'    => 1,
                'ac'          => 10,
                'attacks'     => 'W2d4',
                'elbereth'    => 0,
                'level'       => 5,
                'mr'          => 10,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'newt' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 8,
                'attacks'     => '1d2',
                'elbereth'    => 1,
                'level'       => 0,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 6,
                'glyph'       => ":",
                'color'       => COLOR_YELLOW,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 10,
                    'nutrition' => 20,
                    'energy' => '67%',
                }
            },
            'ninja' => {
                'alignment'   => 3,
                'hostile'     => 1,
                'ac'          => 10,
                'attacks'     => 'W1d8 W1d8',
                'elbereth'    => 0,
                'level'       => 5,
                'mr'          => 10,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'nurse' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 0,
                'attacks'     => '2d6H',
                'elbereth'    => 0,
                'level'       => 11,
                'mr'          => 0,
                'resistances' => "P",
                'speed'       => 6,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                    'heal' => '100%',
                    'poison_resistance' => '73%',
                }
            },
            'ochre jelly' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 8,
                'attacks'     => 'E3d6A (3d6A)',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 20,
                'resistances' => "a*",
                'speed'       => 3,
                'glyph'       => "j",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 50,
                    'nutrition' => 20,
                    'acidic'    => '100%',
                    vegetarian  => 1,
                    vegan       => 1,
                }
            },
            'ogre' => {
                'alignment'   => -3,
                'ac'          => 5,
                'attacks'     => 'W2d5',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 10,
                'glyph'       => "O",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1600,
                    'nutrition' => 500,
                }
            },
            'ogre king' => {
                'alignment'   => -7,
                'ac'          => 4,
                'attacks'     => 'W3d5',
                'elbereth'    => 1,
                'level'       => 9,
                'mr'          => 60,
                'resistances' => " ",
                'speed'       => 14,
                'glyph'       => "O",
                'color'       => COLOR_MAGENTA,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1700,
                    'nutrition' => 750,
                }
            },
            'ogre lord' => {
                'alignment'   => -5,
                'ac'          => 3,
                'attacks'     => 'W2d6',
                'elbereth'    => 1,
                'level'       => 7,
                'mr'          => 30,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "O",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1700,
                    'nutrition' => 700,
                }
            },
            'orange dragon' => {
                'alignment'   => 5,
                'hostile'     => 1,
                'ac'          => -1,
                'attacks'     => 'B4d25S 3d8 1d4 1d4',
                'elbereth'    => 1,
                'level'       => 15,
                'mr'          => 20,
                'resistances' => "S",
                'speed'       => 9,
                'glyph'       => "D",
                'color'       => COLOR_ORANGE,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 4500,
                    'nutrition' => 1500,
                    'sleep_resistance' => '100%',
                }
            },
            'orc' => {
                'alignment'   => -3,
                'ac'          => 10,
                'attacks'     => 'W1d8',
                'elbereth'    => 1,
                'level'       => 1,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 9,
                'glyph'       => "o",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 850,
                    'nutrition' => 150,
                }
            },
            'orc mummy' => {
                'alignment'   => -4,
                'hostile'     => 1,
                'ac'          => 5,
                'attacks'     => '1d6',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 20,
                'resistances' => "csp",
                'speed'       => 10,
                'glyph'       => "M",
                'color'       => COLOR_GRAY,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 850,
                    'nutrition' => 75,
                    'undead'    => 'orc',
                }
            },
            'orc shaman' => {
                'alignment'   => -5,
                'ac'          => 5,
                'attacks'     => 'M0d0+',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 10,
                'resistances' => " ",
                'speed'       => 9,
                'glyph'       => "o",
                'color'       => COLOR_BRIGHT_BLUE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1000,
                    'nutrition' => 300,
                }
            },
            'orc zombie' => {
                'alignment'   => -3,
                'hostile'     => 1,
                'ac'          => 9,
                'attacks'     => '1d6',
                'elbereth'    => 1,
                'level'       => 2,
                'mr'          => 0,
                'resistances' => "csp",
                'speed'       => 6,
                'glyph'       => "Z",
                'color'       => COLOR_GRAY,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 850,
                    'nutrition' => 75,
                    'undead'    => 'orc',
                }
            },
            'orc-captain' => {
                'alignment'   => -5,
                'ac'          => 10,
                'attacks'     => 'W2d4 W2d4',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 5,
                'glyph'       => "o",
                'color'       => COLOR_MAGENTA,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1350,
                    'nutrition' => 350,
                }
            },
            'owlbear' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 5,
                'attacks'     => '1d6 1d6 H2d8',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "Y",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1700,
                    'nutrition' => 700,
                }
            },
            'page' => {
                'alignment'   => 3,
                'peaceful'    => 1,
                'ac'          => 10,
                'attacks'     => 'W1d6 W1d6',
                'elbereth'    => 0,
                'level'       => 5,
                'mr'          => 10,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'panther' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 6,
                'attacks'     => '1d6 1d6 1d10',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 15,
                'glyph'       => "f",
                'color'       => COLOR_BLACK,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 600,
                    'nutrition' => 300,
                }
            },
            'paper golem' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 10,
                'attacks'     => '1d3',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 0,
                'resistances' => "sp",
                'speed'       => 12,
                'glyph'       => "'",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 400,
                    'nutrition' => 0,
                }
            },
            'piranha' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 4,
                'attacks'     => '2d6',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => ";",
                'color'       => COLOR_RED,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 60,
                    'nutrition' => 30,
                }
            },
            'pit fiend' => {
                'alignment'   => -13,
                'hostile'     => 1,
                'ac'          => -3,
                'attacks'     => 'W4d2 W4d2 H2d4',
                'elbereth'    => 1,
                'level'       => 13,
                'mr'          => 65,
                'resistances' => "fp",
                'speed'       => 6,
                'glyph'       => "&",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 0,
                }
            },
            'pit viper' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 2,
                'attacks'     => '1d4P 1d4P',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 0,
                'resistances' => "P",
                'speed'       => 15,
                'glyph'       => "S",
                'color'       => COLOR_BLUE,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 100,
                    'nutrition' => 60,
                    'poison_resistance' => '40%',
                    'poisonous' => '100%',
                }
            },
            'plains centaur' => {
                'alignment'   => 0,
                'ac'          => 4,
                'attacks'     => 'W1d6 1d6',
                'elbereth'    => 1,
                'level'       => 4,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 18,
                'glyph'       => "C",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 2500,
                    'nutrition' => 500,
                }
            },
            'pony' => {
                'alignment'   => 0,
                'ac'          => 6,
                'attacks'     => '1d6 1d2',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 16,
                'glyph'       => "u",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1300,
                    'nutrition' => 250,
                }
            },
            'priest' => {
                'alignment'   => 0,
                'ac'          => 10,
                'attacks'     => 'W1d6',
                'elbereth'    => 0,
                'level'       => 10,
                'mr'          => 2,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'priestess' => {
                'alignment'   => 0,
                'ac'          => 10,
                'attacks'     => 'W1d6',
                'elbereth'    => 0,
                'level'       => 10,
                'mr'          => 2,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'prisoner' => {
                'alignment'   => 0,
                'peaceful'    => 1,
                'ac'          => 10,
                'attacks'     => 'W1d6',
                'elbereth'    => 0,
                'level'       => 12,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'purple worm' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 6,
                'attacks'     => '2d8 E1d10d',
                'elbereth'    => 1,
                'level'       => 15,
                'mr'          => 20,
                'resistances' => " ",
                'speed'       => 9,
                'glyph'       => "w",
                'color'       => COLOR_MAGENTA,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 2700,
                    'nutrition' => 700,
                }
            },
            'pyrolisk' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 6,
                'attacks'     => 'G2d6F',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 30,
                'resistances' => "FP",
                'speed'       => 6,
                'glyph'       => "c",
                'color'       => COLOR_RED,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 30,
                    'nutrition' => 30,
                    'fire_resistance' => '20%',
                    'poison_resistance' => '20%',
                }
            },
            'python' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 5,
                'attacks'     => '1d4 0d0 H1d4w H2d4',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 3,
                'glyph'       => "S",
                'color'       => COLOR_MAGENTA,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 250,
                    'nutrition' => 100,
                }
            },
            'quantum mechanic' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 3,
                'attacks'     => '1d4t',
                'elbereth'    => 1,
                'level'       => 7,
                'mr'          => 10,
                'resistances' => "p",
                'speed'       => 12,
                'glyph'       => "Q",
                'color'       => COLOR_CYAN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 20,
                    'poisonous' => '100%',
                    'speed_toggle' => '100%',
                }
            },
            'quasit' => {
                'alignment'   => -7,
                'ac'          => 2,
                'attacks'     => '1d2!D 1d2!D 1d4',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 20,
                'resistances' => "P",
                'speed'       => 15,
                'glyph'       => "i",
                'color'       => COLOR_BLUE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 200,
                    'nutrition' => 200,
                    'poison_resistance' => '20%',
                }
            },
            'queen bee' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => -4,
                'attacks'     => '1d8P',
                'elbereth'    => 1,
                'level'       => 9,
                'mr'          => 0,
                'resistances' => "P",
                'speed'       => 24,
                'glyph'       => "a",
                'color'       => COLOR_MAGENTA,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1,
                    'nutrition' => 5,
                    'poison_resistance' => '60%',
                    'poisonous' => '100%',
                }
            },
            'quivering blob' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 8,
                'attacks'     => '1d8',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 0,
                'resistances' => "sP",
                'speed'       => 1,
                'glyph'       => "b",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 200,
                    'nutrition' => 100,
                    'poison_resistance' => '33%',
                    vegetarian  => 1,
                    vegan       => 1,
                }
            },
            'rabid rat' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 6,
                'attacks'     => '2d4!C',
                'elbereth'    => 1,
                'level'       => 2,
                'mr'          => 0,
                'resistances' => "p",
                'speed'       => 12,
                'glyph'       => "r",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 30,
                    'nutrition' => 5,
                    'poisonous' => '100%',
                }
            },
            'ranger' => {
                'alignment'   => -3,
                'ac'          => 10,
                'attacks'     => 'W1d4',
                'elbereth'    => 0,
                'level'       => 10,
                'mr'          => 2,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'raven' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 6,
                'attacks'     => '1d6 1d6b',
                'elbereth'    => 1,
                'level'       => 4,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 20,
                'glyph'       => "B",
                'color'       => COLOR_BLACK,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 40,
                    'nutrition' => 20,
                }
            },
            'red dragon' => {
                'alignment'   => -4,
                'hostile'     => 1,
                'ac'          => -1,
                'attacks'     => 'B6d6F 3d8 1d4 1d4',
                'elbereth'    => 1,
                'level'       => 15,
                'mr'          => 20,
                'resistances' => "F",
                'speed'       => 9,
                'glyph'       => "D",
                'color'       => COLOR_RED,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 4500,
                    'nutrition' => 1500,
                    'fire_resistance' => '100%',
                }
            },
            'red mold' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 9,
                'attacks'     => '(0d4F)',
                'elbereth'    => 1,
                'level'       => 1,
                'mr'          => 0,
                'resistances' => "FP",
                'speed'       => 0,
                'glyph'       => "F",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 50,
                    'nutrition' => 30,
                    'fire_resistance' => '3%',
                    'poison_resistance' => '3%',
                    vegetarian  => 1,
                    vegan       => 1,
                }
            },
            'red naga' => {
                'alignment'   => -4,
                'ac'          => 4,
                'attacks'     => '2d4 B2d6F',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 0,
                'resistances' => "FP",
                'speed'       => 12,
                'glyph'       => "N",
                'color'       => COLOR_RED,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 2600,
                    'nutrition' => 400,
                    'fire_resistance' => '20%',
                    'poison_resistance' => '20%',
                }
            },
            'red naga hatchling' => {
                'alignment'   => 0,
                'ac'          => 6,
                'attacks'     => '1d4',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 0,
                'resistances' => "FP",
                'speed'       => 10,
                'glyph'       => "N",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 500,
                    'nutrition' => 100,
                    'fire_resistance' => '10%',
                    'poison_resistance' => '10%',
                }
            },
            'rock mole' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 0,
                'attacks'     => '1d6',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 20,
                'resistances' => " ",
                'speed'       => 3,
                'glyph'       => "r",
                'color'       => COLOR_GRAY,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 30,
                    'nutrition' => 30,
                }
            },
            'rock piercer' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 3,
                'attacks'     => '2d6',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 1,
                'glyph'       => "p",
                'color'       => COLOR_GRAY,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 200,
                    'nutrition' => 200,
                }
            },
            'rock troll' => {
                'alignment'   => -3,
                'hostile'     => 1,
                'ac'          => 0,
                'attacks'     => 'W3d6 2d8 2d6',
                'elbereth'    => 1,
                'level'       => 9,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "T",
                'color'       => COLOR_CYAN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1200,
                    'nutrition' => 300,
                    'reanimates' => 1,
                }
            },
            'rogue' => {
                'alignment'   => -3,
                'ac'          => 10,
                'attacks'     => 'W1d6 W1d6',
                'elbereth'    => 0,
                'level'       => 10,
                'mr'          => 1,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'rope golem' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 8,
                'attacks'     => '1d4 1d4 H6d1',
                'elbereth'    => 1,
                'level'       => 4,
                'mr'          => 0,
                'resistances' => "sp",
                'speed'       => 9,
                'glyph'       => "'",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 450,
                    'nutrition' => 0,
                }
            },
            'roshi' => {
                'alignment'   => 3,
                'peaceful'    => 1,
                'ac'          => 10,
                'attacks'     => 'W1d8 W1d8',
                'elbereth'    => 0,
                'level'       => 5,
                'mr'          => 10,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'rothe' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 7,
                'attacks'     => '1d3 1d3 1d8',
                'elbereth'    => 1,
                'level'       => 2,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 9,
                'glyph'       => "q",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 400,
                    'nutrition' => 100,
                }
            },
            'rust monster' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 2,
                'attacks'     => '0d0R 0d0R (0d0R)',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 18,
                'glyph'       => "R",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1000,
                    'nutrition' => 250,
                }
            },
            'salamander' => {
                'alignment'   => -9,
                'hostile'     => 1,
                'ac'          => -1,
                'attacks'     => 'W2d8 1d6F H2d6 H3d6F',
                'elbereth'    => 1,
                'level'       => 8,
                'mr'          => 0,
                'resistances' => "Fs",
                'speed'       => 12,
                'glyph'       => ":",
                'color'       => COLOR_ORANGE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1500,
                    'nutrition' => 400,
                    'fire_resistance' => '53%',
                    'poisonous' => '100%',
                }
            },
            'samurai' => {
                'alignment'   => 3,
                'ac'          => 10,
                'attacks'     => 'W1d8 W1d8',
                'elbereth'    => 0,
                'level'       => 10,
                'mr'          => 1,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'sandestin' => {
                'alignment'   => -5,
                'ac'          => 4,
                'attacks'     => 'W2d6 W2d6',
                'elbereth'    => 1,
                'level'       => 13,
                'mr'          => 60,
                'resistances' => "*",
                'speed'       => 12,
                'glyph'       => "&",
                'color'       => COLOR_GRAY,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1500,
                    'nutrition' => 0,
                }
            },
            'sasquatch' => {
                'alignment'   => 2,
                'ac'          => 6,
                'attacks'     => '1d6 1d6 1d8',
                'elbereth'    => 1,
                'level'       => 7,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 15,
                'glyph'       => "Y",
                'color'       => COLOR_GRAY,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1550,
                    'nutrition' => 750,
                }
            },
            'scorpion' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 3,
                'attacks'     => '1d2 1d2 1d4P',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 0,
                'resistances' => "P",
                'speed'       => 15,
                'glyph'       => "s",
                'color'       => COLOR_RED,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 50,
                    'nutrition' => 100,
                    'poison_resistance' => '50%',
                    'poisonous' => '100%',
                }
            },
            'sergeant' => {
                'alignment'   => -3,
                'hostile'     => 1,
                'ac'          => 10,
                'attacks'     => 'W2d6',
                'elbereth'    => 0,
                'level'       => 8,
                'mr'          => 5,
                'resistances' => " ",
                'speed'       => 10,
                'glyph'       => "@",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'sewer rat' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 7,
                'attacks'     => '1d3',
                'elbereth'    => 1,
                'level'       => 0,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "r",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 20,
                    'nutrition' => 12,
                }
            },
            'shade' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 10,
                'attacks'     => '2d6. 1d6&lt;',
                'elbereth'    => 1,
                'level'       => 12,
                'mr'          => 0,
                'resistances' => "csdp*",
                'speed'       => 10,
                'glyph'       => "X",
                'color'       => COLOR_BLACK,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 0,
                }
            },
            'shark' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 2,
                'attacks'     => '5d6',
                'elbereth'    => 1,
                'level'       => 7,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => ";",
                'color'       => COLOR_GRAY,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 500,
                    'nutrition' => 350,
                }
            },
            'shocking sphere' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 4,
                'attacks'     => 'X4d6E',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 0,
                'resistances' => "E",
                'speed'       => 13,
                'glyph'       => "e",
                'color'       => COLOR_BRIGHT_BLUE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 10,
                    'nutrition' => 0,
                }
            },
            'shopkeeper' => {
                'alignment'   => 0,
                'peaceful'    => 1,
                'ac'          => 0,
                'attacks'     => 'W4d4 W4d4',
                'elbereth'    => 0,
                'level'       => 12,
                'mr'          => 50,
                'resistances' => " ",
                'speed'       => 18,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'shrieker' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 7,
                'attacks'     => '',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 0,
                'resistances' => "P",
                'speed'       => 1,
                'glyph'       => "F",
                'color'       => COLOR_MAGENTA,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 100,
                    'nutrition' => 100,
                    'poison_resistance' => '20%',
                    vegetarian  => 1,
                    vegan       => 1,
                }
            },
            'silver dragon' => {
                'alignment'   => 4,
                'hostile'     => 1,
                'ac'          => -1,
                'attacks'     => 'B4d6C 3d8 1d4 1d4',
                'elbereth'    => 1,
                'level'       => 15,
                'mr'          => 20,
                'resistances' => "c",
                'speed'       => 9,
                'glyph'       => "D",
                'color'       => COLOR_BRIGHT_CYAN,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 4500,
                    'nutrition' => 1500,
                }
            },
            'skeleton' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 4,
                'attacks'     => 'W2d6 1d6&lt;',
                'elbereth'    => 1,
                'level'       => 12,
                'mr'          => 0,
                'resistances' => "csp*",
                'speed'       => 8,
                'glyph'       => "Z",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 300,
                    'nutrition' => 0,
                }
            },
            'small mimic' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 7,
                'attacks'     => '3d4',
                'elbereth'    => 1,
                'level'       => 7,
                'mr'          => 0,
                'resistances' => "a",
                'speed'       => 3,
                'glyph'       => "m",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 300,
                    'nutrition' => 200,
                    'mimic' => '20',
                }
            },
            'snake' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 3,
                'attacks'     => '1d6P',
                'elbereth'    => 1,
                'level'       => 4,
                'mr'          => 0,
                'resistances' => "P",
                'speed'       => 15,
                'glyph'       => "S",
                'color'       => COLOR_BROWN,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 100,
                    'nutrition' => 80,
                    'poison_resistance' => '27%',
                    'poisonous' => '100%',
                }
            },
            'soldier' => {
                'alignment'   => -2,
                'hostile'     => 1,
                'ac'          => 10,
                'attacks'     => 'W1d8',
                'elbereth'    => 0,
                'level'       => 6,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 10,
                'glyph'       => "@",
                'color'       => COLOR_GRAY,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'soldier ant' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 3,
                'attacks'     => '2d4 3d4P',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 0,
                'resistances' => "P",
                'speed'       => 18,
                'glyph'       => "a",
                'color'       => COLOR_BLUE,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 20,
                    'nutrition' => 5,
                    'poison_resistance' => '20%',
                    'poisonous' => '100%',
                }
            },
            'spotted jelly' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 8,
                'attacks'     => '(0d6A)',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 10,
                'resistances' => "a*",
                'speed'       => 0,
                'glyph'       => "j",
                'color'       => COLOR_GREEN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 50,
                    'nutrition' => 20,
                    'acidic'    => '100%',
                    vegetarian  => 1,
                    vegan       => 1,
                }
            },
            'stalker' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 3,
                'attacks'     => '4d4',
                'elbereth'    => 1,
                'level'       => 8,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "E",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 900,
                    'nutrition' => 400,
                    'invisibility' => '100%',
                    'stun' => '60',
                }
            },
            'steam vortex' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 2,
                'attacks'     => 'E1d8F',
                'elbereth'    => 1,
                'level'       => 7,
                'mr'          => 30,
                'resistances' => "fsp*",
                'speed'       => 22,
                'glyph'       => "v",
                'color'       => COLOR_BLUE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 0,
                    'nutrition' => 0,
                    vegetarian  => 1,
                    vegan       => 1,
                }
            },
            'stone giant' => {
                'alignment'   => 2,
                'ac'          => 0,
                'attacks'     => 'W2d10',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 6,
                'glyph'       => "H",
                'color'       => COLOR_GRAY,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 2250,
                    'nutrition' => 750,
                    'strength'  => '100%',
                }
            },
            'stone golem' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 5,
                'attacks'     => '3d8',
                'elbereth'    => 1,
                'level'       => 14,
                'mr'          => 50,
                'resistances' => "sp*",
                'speed'       => 6,
                'glyph'       => "'",
                'color'       => COLOR_GRAY,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1900,
                    'nutrition' => 0,
                }
            },
            'storm giant' => {
                'alignment'   => -3,
                'ac'          => 3,
                'attacks'     => 'W2d12',
                'elbereth'    => 1,
                'level'       => 16,
                'mr'          => 10,
                'resistances' => "E",
                'speed'       => 12,
                'glyph'       => "H",
                'color'       => COLOR_BLUE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 2250,
                    'nutrition' => 750,
                    'shock_resistance' => '50%',
                    'strength'  => '100%',
                }
            },
            'straw golem' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 10,
                'attacks'     => '1d2 1d2',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 0,
                'resistances' => "sp",
                'speed'       => 12,
                'glyph'       => "'",
                'color'       => COLOR_YELLOW,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 400,
                    'nutrition' => 0,
                }
            },
            'student' => {
                'alignment'   => 3,
                'peaceful'    => 1,
                'ac'          => 10,
                'attacks'     => 'W1d6',
                'elbereth'    => 0,
                'level'       => 5,
                'mr'          => 10,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'succubus' => {
                'alignment'   => -9,
                'hostile'     => 1,
                'ac'          => 0,
                'attacks'     => '0d0&amp; 1d3 1d3',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 70,
                'resistances' => "fp",
                'speed'       => 12,
                'glyph'       => "&",
                'color'       => COLOR_GRAY,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 0,
                }
            },
            'tengu' => {
                'alignment'   => 7,
                'ac'          => 5,
                'attacks'     => '1d7',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 30,
                'resistances' => "P",
                'speed'       => 13,
                'glyph'       => "i",
                'color'       => COLOR_CYAN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 300,
                    'nutrition' => 200,
                    'poison_resistance' => '13%',
                    'teleport_control' => '17%',
                    'teleportitis' => '20%',
                }
            },
            'thug' => {
                'alignment'   => -3,
                'peaceful'    => 1,
                'ac'          => 10,
                'attacks'     => 'W1d6 W1d6',
                'elbereth'    => 0,
                'level'       => 5,
                'mr'          => 10,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'tiger' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 6,
                'attacks'     => '2d4 2d4 1d10',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "f",
                'color'       => COLOR_YELLOW,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 600,
                    'nutrition' => 300,
                }
            },
            'titan' => {
                'alignment'   => 9,
                'ac'          => -3,
                'attacks'     => 'W2d8 M0d0+',
                'elbereth'    => 1,
                'level'       => 16,
                'mr'          => 70,
                'resistances' => " ",
                'speed'       => 18,
                'glyph'       => "H",
                'color'       => COLOR_MAGENTA,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 2300,
                    'nutrition' => 900,
                }
            },
            'titanothere' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 6,
                'attacks'     => '2d8',
                'elbereth'    => 1,
                'level'       => 12,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "q",
                'color'       => COLOR_GRAY,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 2650,
                    'nutrition' => 650,
                }
            },
            'tourist' => {
                'alignment'   => 0,
                'ac'          => 10,
                'attacks'     => 'W1d6 W1d6',
                'elbereth'    => 0,
                'level'       => 10,
                'mr'          => 1,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'trapper' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 3,
                'attacks'     => 'E1d10d',
                'elbereth'    => 1,
                'level'       => 12,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 3,
                'glyph'       => "t",
                'color'       => COLOR_GREEN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 800,
                    'nutrition' => 350,
                }
            },
            'troll' => {
                'alignment'   => -3,
                'hostile'     => 1,
                'ac'          => 4,
                'attacks'     => 'W4d2 4d2 2d6',
                'elbereth'    => 1,
                'level'       => 7,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "T",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 800,
                    'nutrition' => 350,
                    'reanimates' => 1,
                }
            },
            'umber hulk' => {
                'alignment'   => 0,
                'ac'          => 2,
                'attacks'     => '3d4 3d4 2d5 G0d0c',
                'elbereth'    => 1,
                'level'       => 9,
                'mr'          => 25,
                'resistances' => " ",
                'speed'       => 6,
                'glyph'       => "U",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1200,
                    'nutrition' => 500,
                }
            },
            'valkyrie' => {
                'alignment'   => -1,
                'ac'          => 10,
                'attacks'     => 'W1d8 W1d8',
                'elbereth'    => 0,
                'level'       => 10,
                'mr'          => 1,
                'resistances' => "c",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'vampire' => {
                'alignment'   => -8,
                'hostile'     => 1,
                'ac'          => 1,
                'attacks'     => '1d6 1d6V',
                'elbereth'    => 1,
                'level'       => 10,
                'mr'          => 25,
                'resistances' => "sp",
                'speed'       => 12,
                'glyph'       => "V",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 400,
                    'undead'    => 'human',
                }
            },
            'vampire bat' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 6,
                'attacks'     => '1d6 0d0P',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 0,
                'resistances' => "sp",
                'speed'       => 20,
                'glyph'       => "B",
                'color'       => COLOR_BLACK,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 30,
                    'nutrition' => 20,
                    'poisonous' => '100%',
                }
            },
            'vampire lord' => {
                'alignment'   => -9,
                'hostile'     => 1,
                'ac'          => 0,
                'attacks'     => '1d8 1d8V',
                'elbereth'    => 1,
                'level'       => 12,
                'mr'          => 50,
                'resistances' => "sp",
                'speed'       => 14,
                'glyph'       => "V",
                'color'       => COLOR_BLUE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 400,
                    'undead'    => 'human'
                }
            },
            'violet fungus' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 7,
                'attacks'     => '1d4 0d0m',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 0,
                'resistances' => "P",
                'speed'       => 1,
                'glyph'       => "F",
                'color'       => COLOR_MAGENTA,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 100,
                    'nutrition' => 100,
                    'hallucination' => '100%',
                    'poison_resistance' => '20%',
                    vegetarian  => 1,
                    vegan       => 1,
                }
            },
            'vrock' => {
                'alignment'   => -9,
                'hostile'     => 1,
                'ac'          => 0,
                'attacks'     => '1d4 1d4 1d8 1d8 1d6',
                'elbereth'    => 1,
                'level'       => 8,
                'mr'          => 50,
                'resistances' => "fp",
                'speed'       => 12,
                'glyph'       => "&",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 0,
                }
            },
            'warg' => {
                'alignment'   => -5,
                'hostile'     => 1,
                'ac'          => 4,
                'attacks'     => '2d6',
                'elbereth'    => 1,
                'level'       => 7,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "d",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 850,
                    'nutrition' => 350,
                }
            },
            'warhorse' => {
                'alignment'   => 0,
                'ac'          => 4,
                'attacks'     => '1d10 1d4',
                'elbereth'    => 1,
                'level'       => 7,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 24,
                'glyph'       => "u",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1800,
                    'nutrition' => 350,
                }
            },
            'warrior' => {
                'alignment'   => -1,
                'peaceful'    => 1,
                'ac'          => 10,
                'attacks'     => 'W1d8 W1d8',
                'elbereth'    => 0,
                'level'       => 5,
                'mr'          => 10,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'watch captain' => {
                'alignment'   => -4,
                'peaceful'    => 1,
                'ac'          => 10,
                'attacks'     => 'W3d4 W3d4',
                'elbereth'    => 0,
                'level'       => 10,
                'mr'          => 15,
                'resistances' => " ",
                'speed'       => 10,
                'glyph'       => "@",
                'color'       => COLOR_GREEN,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'watchman' => {
                'alignment'   => -2,
                'peaceful'    => 1,
                'ac'          => 10,
                'attacks'     => 'W1d8',
                'elbereth'    => 0,
                'level'       => 6,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 10,
                'glyph'       => "@",
                'color'       => COLOR_GRAY,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'water demon' => {
                'alignment'   => -7,
                'hostile'     => 1,
                'ac'          => -4,
                'attacks'     => 'W1d3 1d3 1d3',
                'elbereth'    => 1,
                'level'       => 8,
                'mr'          => 30,
                'resistances' => "fp",
                'speed'       => 12,
                'glyph'       => "&",
                'color'       => COLOR_BLUE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1450,
                    'nutrition' => 0,
                }
            },
            'water elemental' => {
                'alignment'   => 0,
                'ac'          => 2,
                'attacks'     => '5d6',
                'elbereth'    => 1,
                'level'       => 8,
                'mr'          => 30,
                'resistances' => "p*",
                'speed'       => 6,
                'glyph'       => "E",
                'color'       => COLOR_BLUE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 2500,
                    'nutrition' => 0,
                    vegetarian  => 1,
                    vegan       => 1,
                }
            },
            'water moccasin' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 3,
                'attacks'     => '1d6P',
                'elbereth'    => 1,
                'level'       => 4,
                'mr'          => 0,
                'resistances' => "P",
                'speed'       => 15,
                'glyph'       => "S",
                'color'       => COLOR_RED,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 150,
                    'nutrition' => 80,
                    'poison_resistance' => '27%',
                    'poisonous' => '100%',
                }
            },
            'water nymph' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 9,
                'attacks'     => '0d0- 0d0-',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 20,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "n",
                'color'       => COLOR_BLUE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 600,
                    'nutrition' => 300,
                    'teleportitis' => '30%',
                }
            },
            'water troll' => {
                'alignment'   => -3,
                'hostile'     => 1,
                'ac'          => 4,
                'attacks'     => '2W2d8 2d8 2d6',
                'elbereth'    => 1,
                'level'       => 11,
                'mr'          => 40,
                'resistances' => " ",
                'speed'       => 14,
                'glyph'       => "T",
                'color'       => COLOR_BLUE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1200,
                    'nutrition' => 350,
                    'reanimates' => 1,
                }
            },
            'werejackal' => {
                'alignment'   => -7,
                'hostile'     => 1,
                'ac'          => 10,
                'attacks'     => 'W2d4',
                'elbereth'    => 0,
                'level'       => 2,
                'mr'          => 10,
                'resistances' => "p",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                    'lycanthropy' => '100%',
                    'poisonous' => '100%',
                }
            },
            'wererat' => {
                'alignment'   => -7,
                'hostile'     => 1,
                'ac'          => 10,
                'attacks'     => 'W2d4',
                'elbereth'    => 0,
                'level'       => 2,
                'mr'          => 10,
                'resistances' => "p",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                    'lycanthropy' => '100%',
                    'poisonous' => '100%',
                }
            },
            'werewolf' => {
                'alignment'   => -7,
                'hostile'     => 1,
                'ac'          => 10,
                'attacks'     => 'W2d4',
                'elbereth'    => 0,
                'level'       => 5,
                'mr'          => 20,
                'resistances' => "p",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_ORANGE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                    'lycanthropy' => '100%',
                    'poisonous' => '100%',
                }
            },
            'white dragon' => {
                'alignment'   => -5,
                'hostile'     => 1,
                'ac'          => -1,
                'attacks'     => 'B4d6C 3d8 1d4 1d4',
                'elbereth'    => 1,
                'level'       => 15,
                'mr'          => 20,
                'resistances' => "C",
                'speed'       => 9,
                'glyph'       => "D",
                'color'       => COLOR_WHITE,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 4500,
                    'nutrition' => 1500,
                    'cold_resistance' => '100%',
                }
            },
            'white unicorn' => {
                'alignment'   => 7,
                'ac'          => 2,
                'attacks'     => '1d12 1d6',
                'elbereth'    => 1,
                'level'       => 4,
                'mr'          => 70,
                'resistances' => "P",
                'speed'       => 24,
                'glyph'       => "u",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1300,
                    'nutrition' => 300,
                    'poison_resistance' => '27%',
                }
            },
            'winged gargoyle' => {
                'alignment'   => -12,
                'hostile'     => 1,
                'ac'          => -2,
                'attacks'     => '3d6 3d6 3d4',
                'elbereth'    => 1,
                'level'       => 9,
                'mr'          => 0,
                'resistances' => "*",
                'speed'       => 15,
                'glyph'       => "g",
                'color'       => COLOR_MAGENTA,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1200,
                    'nutrition' => 300,
                }
            },
            'winter wolf' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 4,
                'attacks'     => '2d6 B2d6C',
                'elbereth'    => 1,
                'level'       => 7,
                'mr'          => 20,
                'resistances' => "C",
                'speed'       => 12,
                'glyph'       => "d",
                'color'       => COLOR_CYAN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 700,
                    'nutrition' => 300,
                    'cold_resistance' => '47%',
                }
            },
            'winter wolf cub' => {
                'alignment'   => -5,
                'hostile'     => 1,
                'ac'          => 4,
                'attacks'     => '1d8 B1d8C',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 0,
                'resistances' => "C",
                'speed'       => 12,
                'glyph'       => "d",
                'color'       => COLOR_CYAN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 250,
                    'nutrition' => 200,
                    'cold_resistance' => '33%',
                }
            },
            'wizard' => {
                'alignment'   => 0,
                'ac'          => 10,
                'attacks'     => 'W1d6',
                'elbereth'    => 0,
                'level'       => 10,
                'mr'          => 3,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "@",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => "Hum",
                    'weight'    => 1450,
                    'nutrition' => 400,
                }
            },
            'wolf' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 4,
                'attacks'     => '2d4',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "d",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 500,
                    'nutrition' => 250,
                }
            },
            'wood golem' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 4,
                'attacks'     => '3d4',
                'elbereth'    => 1,
                'level'       => 7,
                'mr'          => 0,
                'resistances' => "sp",
                'speed'       => 3,
                'glyph'       => "'",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 900,
                    'nutrition' => 0,
                }
            },
            'wood nymph' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 9,
                'attacks'     => '0d0- 0d0-',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 20,
                'resistances' => " ",
                'speed'       => 12,
                'glyph'       => "n",
                'color'       => COLOR_GREEN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 600,
                    'nutrition' => 300,
                    'teleportitis' => '30%',
                }
            },
            'woodchuck' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 0,
                'attacks'     => '1d6',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 20,
                'resistances' => " ",
                'speed'       => 3,
                'glyph'       => "r",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 30,
                    'nutrition' => 30,
                }
            },
            'wraith' => {
                'alignment'   => -6,
                'hostile'     => 1,
                'ac'          => 4,
                'attacks'     => '1d6V',
                'elbereth'    => 1,
                'level'       => 6,
                'mr'          => 15,
                'resistances' => "csp*",
                'speed'       => 12,
                'glyph'       => "W",
                'color'       => COLOR_BLACK,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 0,
                    'nutrition' => 0,
                    'gain_level' => '100%',
                }
            },
            'wumpus' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 2,
                'attacks'     => '3d6',
                'elbereth'    => 1,
                'level'       => 8,
                'mr'          => 10,
                'resistances' => " ",
                'speed'       => 3,
                'glyph'       => "q",
                'color'       => COLOR_CYAN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 2500,
                    'nutrition' => 500,
                }
            },
            'xan' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => -4,
                'attacks'     => '1d4x',
                'elbereth'    => 1,
                'level'       => 7,
                'mr'          => 0,
                'resistances' => "P",
                'speed'       => 18,
                'glyph'       => "x",
                'color'       => COLOR_RED,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 300,
                    'nutrition' => 300,
                    'poison_resistance' => '47%',
                    'poisonous' => '100%',
                }
            },
            'xorn' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => -2,
                'attacks'     => '1d3 1d3 1d3 4d6',
                'elbereth'    => 1,
                'level'       => 8,
                'mr'          => 20,
                'resistances' => "fc*",
                'speed'       => 9,
                'glyph'       => "X",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1200,
                    'nutrition' => 700,
                }
            },
            'yellow dragon' => {
                'alignment'   => 7,
                'hostile'     => 1,
                'ac'          => -1,
                'attacks'     => 'B4d6A 3d8 1d4 1d4',
                'elbereth'    => 1,
                'level'       => 15,
                'mr'          => 20,
                'resistances' => "a*",
                'speed'       => 9,
                'glyph'       => "D",
                'color'       => COLOR_YELLOW,
                has_egg       => 1,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 4500,
                    'nutrition' => 1500,
                    'acidic'    => '100%',
                }
            },
            'yellow light' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 0,
                'attacks'     => 'X10d20b',
                'elbereth'    => 1,
                'level'       => 3,
                'mr'          => 0,
                'resistances' => "fcsdepa*",
                'speed'       => 15,
                'glyph'       => "y",
                'color'       => COLOR_YELLOW,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 0,
                    'nutrition' => 0,
                    vegetarian  => 1,
                    vegan       => 1,
                }
            },
            'yellow mold' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 9,
                'attacks'     => '(0d4s)',
                'elbereth'    => 1,
                'level'       => 1,
                'mr'          => 0,
                'resistances' => "P",
                'speed'       => 0,
                'glyph'       => "F",
                'color'       => COLOR_YELLOW,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 50,
                    'nutrition' => 30,
                    'hallucination' => '100%',
                    'poison_resistance' => '7%',
                    'poisonous' => '100%',
                    vegetarian  => 1,
                    vegan       => 1,
                }
            },
            'yeti' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 6,
                'attacks'     => '1d6 1d6 1d4',
                'elbereth'    => 1,
                'level'       => 5,
                'mr'          => 0,
                'resistances' => "C",
                'speed'       => 15,
                'glyph'       => "Y",
                'color'       => COLOR_WHITE,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1600,
                    'nutrition' => 700,
                    'cold_resistance' => '33%',
                }
            },
            'zruty' => {
                'alignment'   => 0,
                'hostile'     => 1,
                'ac'          => 3,
                'attacks'     => '3d4 3d4 3d6',
                'elbereth'    => 1,
                'level'       => 9,
                'mr'          => 0,
                'resistances' => " ",
                'speed'       => 8,
                'glyph'       => "z",
                'color'       => COLOR_BROWN,
                'corpse'      => {
                    'cannibal'  => 0,
                    'weight'    => 1200,
                    'nutrition' => 600,
                }
            },
        };

        # process synonyms for monsters
        my %synonyms = %{ __PACKAGE__->synonyms };
        for my $name (keys %synonyms) {
            $monsters->{$name} = $monsters->{$synonyms{$name}};
        }

        # tag each monster with whether it uses "a" or "an"
        # whether it's unique or not and its name
        for my $name (keys %$monsters) {
            my $stats = $monsters->{$name};
            my $an = $name =~ /^[aeiou]/i ? 'an' : 'a';
            $stats->{an} ||= $an;
            $stats->{name} = $name;
            $stats->{unique} = 0 unless $stats->{unique};
        }

        return $monsters;
    },
);

sub monster {
    my $self = shift;
    my $arg  = shift;
    return $self->list->{$arg};
}

sub search {
    my $self = shift;
    my %args = @_;

    my %ret;
    MONSTER: for my $mon (keys %{ $self->list }) {
        for my $key (keys %args) {
            my $ref = ref $args{$key};
            if ($ref eq 'Regexp') {
                next MONSTER if $self->list->{$mon}->{$key} !~ $args{$key};
            }
            elsif (!$ref) {
                next MONSTER if $self->list->{$mon}->{$key} ne $args{$key};
            }
        }
        $ret{$mon} = $self->list->{$mon};
    }
    return %ret;
}

__PACKAGE__->meta->make_immutable;
no TAEB::OO;

1;

