package Parallel::Scoreboard::PSGI::App;

use Class::Accessor::Lite;
use HTML::Entities;
use Parallel::Scoreboard;

use strict;
use warnings;

Class::Accessor::Lite->mk_accessors(qw(scoreboard));

sub new {
    my $klass = shift;
    my %args = @_;
    die "mandatory parameter:scoreboard is missing"
        unless $args{scoreboard};
    # build object
    my $self = bless {
        %args,
    }, $klass;
    return $self;
}

sub to_app {
    my $self = shift;
    return sub {
        my $status = $self->scoreboard->read_all;
        return [
            200,
            [ 'Content-Type' => 'text/html; charset=utf-8' ],
            [
                sprintf(
                    << 'EOT',
<html>
  <head>
    <title>Status of %s</title>
    <meta http-equiv="content-type" content="text/html; charset=utf-8" />
  </head>
  <body>
    <h1>Status of %s</h1>
    <hr />
    <table>
      <tr><th>PID</th><th>Status</th></tr>
EOT
                    encode_entities($self->scoreboard->base_dir),
                    encode_entities($self->scoreboard->base_dir),
                ),
                (map {
                    sprintf(
                        '<tr><td>%s</td><td>%s</td>',
                        encode_entities($_),
                        encode_entities($status->{$_}),
                    )
                } sort { $a <=> $b } keys %$status),
                sprintf(
                    << 'EOT',
    </table>
    <hr />
    Generated by <a href="http://search.cpan.org/dist/Parallel-Scoreboard/">Parallel::Scoreboard</a> %s
  </body>
</html>
EOT
                    encode_entities($Parallel::Scoreboard::VERSION),
                ),
            ],
        ];
    };
}

1;
__END__

=head1 NAME

Parallel::Scoreboard::PSGI::App - a simple PSGI app for monitoring the output of Parallel::Scoreboard

=head1 SYNOPSIS

  use Parallel::Scoreboard;
  use Parallel::Scoreboard::PSGI::App;
  
  my $scoreboard = Parallel::Scoreboard->new(
      base_dir => '/tmp/my_scorebooard',
  );
  # return psgi app
  Parallel::Scoreboard::PSGI::App->new(
      scoreboard => $scoreboard,
  )->to_app;

=head1 SEE ALSO

L<Parallel::Scoreboard>
L<Parallel::Scoreboard::PSGI::App::JSON>
L<PSGI>

=head1 AUTHOR

Kazuho Oku E<lt>kazuhooku gmail.comE<gt>

=head1 LICENSE

This program is free software, you can redistribute it and/or modify it under the same terms as Perl 5.10.

=cut
