/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.websocket.Extension;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketGenerator;
import org.eclipse.jetty.websocket.WebSocketParser;

public class AbstractExtension
implements Extension {
    private static final int[] __mask = new int[]{-1, 4, 2, 1};
    private final String _name;
    private final Map<String, String> _parameters = new HashMap<String, String>();
    private WebSocketParser.FrameHandler _inbound;
    private WebSocketGenerator _outbound;
    private WebSocket.FrameConnection _connection;

    public AbstractExtension(String name) {
        this._name = name;
    }

    public WebSocket.FrameConnection getConnection() {
        return this._connection;
    }

    @Override
    public boolean init(Map<String, String> parameters) {
        this._parameters.putAll(parameters);
        return true;
    }

    public String getInitParameter(String name) {
        return this._parameters.get(name);
    }

    public String getInitParameter(String name, String dft) {
        if (!this._parameters.containsKey(name)) {
            return dft;
        }
        return this._parameters.get(name);
    }

    public int getInitParameter(String name, int dft) {
        String v = this._parameters.get(name);
        if (v == null) {
            return dft;
        }
        return Integer.valueOf(v);
    }

    @Override
    public void bind(WebSocket.FrameConnection connection, WebSocketParser.FrameHandler incoming, WebSocketGenerator outgoing) {
        this._connection = connection;
        this._inbound = incoming;
        this._outbound = outgoing;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public String getParameterizedName() {
        StringBuilder name = new StringBuilder();
        name.append(this._name);
        for (String param : this._parameters.keySet()) {
            name.append(';').append(param).append('=').append(QuotedStringTokenizer.quoteIfNeeded((String)this._parameters.get(param), (String)";="));
        }
        return name.toString();
    }

    @Override
    public void onFrame(byte flags, byte opcode, Buffer buffer) {
        this._inbound.onFrame(flags, opcode, buffer);
    }

    @Override
    public void close(int code, String message) {
        this._inbound.close(code, message);
    }

    @Override
    public int flush() throws IOException {
        return this._outbound.flush();
    }

    @Override
    public boolean isBufferEmpty() {
        return this._outbound.isBufferEmpty();
    }

    @Override
    public void addFrame(byte flags, byte opcode, byte[] content, int offset, int length) throws IOException {
        this._outbound.addFrame(flags, opcode, content, offset, length);
    }

    public byte setFlag(byte flags, int rsv) {
        if (rsv < 1 || rsv > 3) {
            throw new IllegalArgumentException("rsv" + rsv);
        }
        byte b = (byte)(flags | __mask[rsv]);
        return b;
    }

    public byte clearFlag(byte flags, int rsv) {
        if (rsv < 1 || rsv > 3) {
            throw new IllegalArgumentException("rsv" + rsv);
        }
        return (byte)(flags & ~__mask[rsv]);
    }

    public boolean isFlag(byte flags, int rsv) {
        if (rsv < 1 || rsv > 3) {
            throw new IllegalArgumentException("rsv" + rsv);
        }
        return (flags & __mask[rsv]) != 0;
    }

    public String toString() {
        return this.getParameterizedName();
    }
}

