/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached;

import org.couchbase.mock.memcached.CommandExecutor;
import org.couchbase.mock.memcached.DataStore;
import org.couchbase.mock.memcached.Item;
import org.couchbase.mock.memcached.MemcachedConnection;
import org.couchbase.mock.memcached.MemcachedServer;
import org.couchbase.mock.memcached.protocol.BinaryCommand;
import org.couchbase.mock.memcached.protocol.BinaryGetCommand;
import org.couchbase.mock.memcached.protocol.BinaryGetResponse;
import org.couchbase.mock.memcached.protocol.ComCode;
import org.couchbase.mock.memcached.protocol.ErrorCode;

public class GetCommandExecutor
implements CommandExecutor {
    @Override
    public void execute(BinaryCommand command, MemcachedServer server, MemcachedConnection client) {
        BinaryGetCommand cmd = (BinaryGetCommand)command;
        DataStore datastore = server.getDatastore();
        Item item = datastore.get(server, cmd.getVBucketId(), cmd.getKey());
        ComCode cc = cmd.getComCode();
        if (item == null) {
            if (cc != ComCode.GETKQ && cc != ComCode.GETQ && cc != ComCode.GATQ) {
                client.sendResponse(new BinaryGetResponse((BinaryCommand)cmd, ErrorCode.KEY_ENOENT));
            }
        } else {
            if (cc == ComCode.TOUCH || cc == ComCode.GAT || cc == ComCode.GATQ) {
                item.setExptime(cmd.getExpiration());
            }
            if (cc == ComCode.TOUCH) {
                client.sendResponse(new BinaryGetResponse((BinaryCommand)cmd, ErrorCode.SUCCESS));
            } else {
                client.sendResponse(new BinaryGetResponse((BinaryCommand)cmd, item));
            }
        }
    }
}

