/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.posimo;

import net.sourceforge.plantuml.posimo.Block;
import net.sourceforge.plantuml.posimo.DotPath;
import net.sourceforge.plantuml.posimo.Label;

public class Path {
    private final Label label;
    private final Block start;
    private final Block end;
    private final int length;
    private DotPath dotPath;

    public Path(Block block, Block block2, Label label) {
        this(block, block2, label, 2);
    }

    public Path(Block block, Block block2, Label label, int n) {
        if (block == null || block2 == null) {
            throw new IllegalArgumentException();
        }
        if (n < 1) {
            throw new IllegalArgumentException("length=" + n);
        }
        this.start = block;
        this.end = block2;
        this.label = label;
        this.length = n;
    }

    public final Label getLabel() {
        return this.label;
    }

    public final Block getStart() {
        return this.start;
    }

    public final Block getEnd() {
        return this.end;
    }

    public void setLabelPositionCenter(double d, double d2) {
        this.label.setCenterX(d);
        this.label.setCenterY(d2);
    }

    public void setLabelPosition(double d, double d2) {
        this.label.setX(d);
        this.label.setY(d2);
    }

    public void setDotPath(DotPath dotPath) {
        this.dotPath = dotPath;
    }

    public final DotPath getDotPath() {
        return this.dotPath;
    }

    public int getLength() {
        return this.length;
    }
}

