#!/usr/bin/perl -w

# $Id: 210version.t,v 1.2 2001/08/23 11:24:22 rich Exp $

use strict;
use Test;
use POSIX qw(dup2);
use IO::Handle;
use FileHandle;

BEGIN {
  plan tests => 3;
}

use Net::FTPServer::InMem::Server;

pipe INFD0, OUTFD0 or die "pipe: $!";
pipe INFD1, OUTFD1 or die "pipe: $!";
my $pid = fork ();
die unless defined $pid;
unless ($pid) {			# Child process (the server).
  POSIX::dup2 (fileno INFD0, 0);
  POSIX::dup2 (fileno OUTFD1, 1);
  close INFD0;
  close OUTFD0;
  close INFD1;
  close OUTFD1;
  my $ftps = Net::FTPServer::InMem::Server->run
    (['--test', '-d', '-C', '/dev/null']);
  exit;
}

# Parent process (the test script).
close INFD0;
close OUTFD1;
OUTFD0->autoflush (1);

$_ = <INFD1>;
print OUTFD0 "USER rich\r\n";
$_ = <INFD1>;
ok (/^331/);

print OUTFD0 "PASS 123456\r\n";
$_ = <INFD1>;
ok (/^230 Welcome rich\./);

# Get the version number from SITE VERSION.
print OUTFD0 "SITE VERSION\r\n";
$_ = <INFD1>;
ok (/^200 Net::FTPServer\/$Net::FTPServer::VERSION-$Net::FTPServer::RELEASE Net::FTPServer::InMem\/$Net::FTPServer::InMem::Server::VERSION/);

print OUTFD0 "QUIT\r\n";
$_ = <INFD1>;
