/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.StringWebResponse;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.BaseFrameElement;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.FrameWindow;
import com.gargoylesoftware.htmlunit.html.HtmlApplet;
import com.gargoylesoftware.htmlunit.html.HtmlAttributeChangeEvent;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlImage;
import com.gargoylesoftware.htmlunit.html.HtmlInlineFrame;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlScript;
import com.gargoylesoftware.htmlunit.javascript.PostponedAction;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.CanSetReadOnly;
import com.gargoylesoftware.htmlunit.javascript.configuration.CanSetReadOnlyStatus;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.dom.AbstractList;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Attr;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Document;
import com.gargoylesoftware.htmlunit.javascript.host.dom.Selection;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.html.DocumentProxy;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLAllCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLBodyElement;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLCollection;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import com.gargoylesoftware.htmlunit.util.Cookie;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@JsxClass
public class HTMLDocument
extends Document {
    private static final Log LOG = LogFactory.getLog(HTMLDocument.class);
    private HTMLElement activeElement_;
    private final StringBuilder writeBuilder_ = new StringBuilder();
    private boolean writeInCurrentDocument_ = true;
    private boolean closePostponedAction_;
    private boolean executionExternalPostponed_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.FF, SupportedBrowser.EDGE})
    public HTMLDocument() {
    }

    @Override
    public DomNode getDomNodeOrDie() {
        try {
            return super.getDomNodeOrDie();
        }
        catch (IllegalStateException e) {
            throw Context.reportRuntimeError("No node attached to this object");
        }
    }

    @Override
    public HtmlPage getPage() {
        return (HtmlPage)this.getDomNodeOrDie();
    }

    @Override
    @JsxGetter(value={SupportedBrowser.FF})
    public Object getForms() {
        return super.getForms();
    }

    @Override
    @JsxGetter(value={SupportedBrowser.FF})
    public Object getEmbeds() {
        return super.getEmbeds();
    }

    @Override
    @JsxGetter(value={SupportedBrowser.FF})
    public Object getPlugins() {
        return super.getPlugins();
    }

    @Override
    @JsxGetter(value={SupportedBrowser.FF})
    public Object getLinks() {
        return super.getLinks();
    }

    @Override
    @JsxGetter(value={SupportedBrowser.FF})
    public Object getAnchors() {
        return super.getAnchors();
    }

    @Override
    @JsxGetter(value={SupportedBrowser.FF})
    public Object getApplets() {
        return super.getApplets();
    }

    @JsxFunction
    public static void write(Context context, Scriptable thisObj, Object[] args, Function function) {
        HTMLDocument thisAsDocument = HTMLDocument.getDocument(thisObj);
        thisAsDocument.write(HTMLDocument.concatArgsAsString(args));
    }

    private static String concatArgsAsString(Object[] args) {
        StringBuilder builder = new StringBuilder();
        for (Object arg : args) {
            builder.append(Context.toString(arg));
        }
        return builder.toString();
    }

    @JsxFunction
    public static void writeln(Context context, Scriptable thisObj, Object[] args, Function function) {
        HTMLDocument thisAsDocument = HTMLDocument.getDocument(thisObj);
        thisAsDocument.write(HTMLDocument.concatArgsAsString(args) + "\n");
    }

    private static HTMLDocument getDocument(Scriptable thisObj) {
        if (thisObj instanceof HTMLDocument && thisObj.getPrototype() instanceof HTMLDocument) {
            return (HTMLDocument)thisObj;
        }
        if (thisObj instanceof DocumentProxy && thisObj.getPrototype() instanceof HTMLDocument) {
            return (HTMLDocument)((DocumentProxy)thisObj).getDelegee();
        }
        Window window = HTMLDocument.getWindow(thisObj);
        if (window.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_FUNCTION_DETACHED)) {
            return (HTMLDocument)window.getDocument();
        }
        throw Context.reportRuntimeError("Function can't be used detached from document");
    }

    public void setExecutingDynamicExternalPosponed(boolean executing) {
        this.executionExternalPostponed_ = executing;
    }

    protected void write(String content) {
        HtmlPage page;
        if (this.executionExternalPostponed_) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("skipping write for external posponed: " + content);
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("write: " + content);
        }
        if (!(page = (HtmlPage)this.getDomNodeOrDie()).isBeingParsed()) {
            this.writeInCurrentDocument_ = false;
        }
        this.writeBuilder_.append(content);
        if (!this.writeInCurrentDocument_) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("wrote content to buffer");
            }
            this.scheduleImplicitClose();
            return;
        }
        String bufferedContent = this.writeBuilder_.toString();
        if (!HTMLDocument.canAlreadyBeParsed(bufferedContent)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("write: not enough content to parse it now");
            }
            return;
        }
        this.writeBuilder_.setLength(0);
        page.writeInParsedStream(bufferedContent);
    }

    private void scheduleImplicitClose() {
        if (!this.closePostponedAction_) {
            this.closePostponedAction_ = true;
            HtmlPage page = (HtmlPage)this.getDomNodeOrDie();
            final WebWindow enclosingWindow = page.getEnclosingWindow();
            page.getWebClient().getJavaScriptEngine().addPostponedAction(new PostponedAction(page){

                @Override
                public void execute() throws Exception {
                    if (HTMLDocument.this.writeBuilder_.length() != 0) {
                        HTMLDocument.this.close();
                    }
                    HTMLDocument.this.closePostponedAction_ = false;
                }

                @Override
                public boolean isStillAlive() {
                    return !enclosingWindow.isClosed();
                }
            });
        }
    }

    static boolean canAlreadyBeParsed(String content) {
        ParsingStatus tagState = ParsingStatus.OUTSIDE;
        int tagNameBeginIndex = 0;
        int scriptTagCount = 0;
        boolean tagIsOpen = true;
        char stringBoundary = '\u0000';
        boolean stringSkipNextChar = false;
        int index = 0;
        char openingQuote = '\u0000';
        for (char currentChar : content.toCharArray()) {
            switch (tagState) {
                case OUTSIDE: {
                    if (currentChar == '<') {
                        tagState = ParsingStatus.START;
                        tagIsOpen = true;
                        break;
                    }
                    if (scriptTagCount <= 0 || currentChar != '\'' && currentChar != '\"') break;
                    tagState = ParsingStatus.IN_STRING;
                    stringBoundary = currentChar;
                    stringSkipNextChar = false;
                    break;
                }
                case START: {
                    if (currentChar == '/') {
                        tagIsOpen = false;
                        tagNameBeginIndex = index + 1;
                    } else {
                        tagNameBeginIndex = index;
                    }
                    tagState = ParsingStatus.IN_NAME;
                    break;
                }
                case IN_NAME: {
                    if (Character.isWhitespace(currentChar) || currentChar == '>') {
                        String tagName = content.substring(tagNameBeginIndex, index);
                        if ("script".equalsIgnoreCase(tagName)) {
                            if (tagIsOpen) {
                                ++scriptTagCount;
                            } else if (scriptTagCount > 0) {
                                --scriptTagCount;
                            }
                        }
                        if (currentChar == '>') {
                            tagState = ParsingStatus.OUTSIDE;
                            break;
                        }
                        tagState = ParsingStatus.INSIDE;
                        break;
                    }
                    if (Character.isLetter(currentChar)) break;
                    tagState = ParsingStatus.OUTSIDE;
                    break;
                }
                case INSIDE: {
                    if (currentChar == openingQuote) {
                        openingQuote = '\u0000';
                        break;
                    }
                    if (openingQuote != '\u0000') break;
                    if (currentChar == '\'' || currentChar == '\"') {
                        openingQuote = currentChar;
                        break;
                    }
                    if (currentChar != '>' || openingQuote != '\u0000') break;
                    tagState = ParsingStatus.OUTSIDE;
                    break;
                }
                case IN_STRING: {
                    if (stringSkipNextChar) {
                        stringSkipNextChar = false;
                        break;
                    }
                    if (currentChar == stringBoundary) {
                        tagState = ParsingStatus.OUTSIDE;
                        break;
                    }
                    if (currentChar != '\\') break;
                    stringSkipNextChar = true;
                    break;
                }
            }
            ++index;
        }
        if (scriptTagCount > 0 || tagState != ParsingStatus.OUTSIDE) {
            if (LOG.isDebugEnabled()) {
                StringBuilder message = new StringBuilder();
                message.append("canAlreadyBeParsed() retruns false for content: '");
                message.append(StringUtils.abbreviateMiddle(content, ".", 100));
                message.append("' (scriptTagCount: " + scriptTagCount);
                message.append(" tagState: " + (Object)((Object)tagState));
                message.append(")");
                LOG.debug(message.toString());
            }
            return false;
        }
        return true;
    }

    HtmlElement getLastHtmlElement(HtmlElement node) {
        DomNode lastChild = node.getLastChild();
        if (lastChild == null || !(lastChild instanceof HtmlElement) || lastChild instanceof HtmlScript) {
            return node;
        }
        return this.getLastHtmlElement((HtmlElement)lastChild);
    }

    @Override
    @JsxGetter
    public String getCookie() {
        HtmlPage page = this.getPage();
        URL url = page.getUrl();
        StringBuilder builder = new StringBuilder();
        Set<Cookie> cookies = page.getWebClient().getCookies(url);
        for (Cookie cookie : cookies) {
            if (cookie.isHttpOnly()) continue;
            if (builder.length() != 0) {
                builder.append("; ");
            }
            if (!"HTMLUNIT_EMPTY_COOKIE".equals(cookie.getName())) {
                builder.append(cookie.getName());
                builder.append("=");
            }
            builder.append(cookie.getValue());
        }
        return builder.toString();
    }

    @JsxSetter
    public void setCookie(String newCookie) {
        HtmlPage page = this.getPage();
        WebClient client = page.getWebClient();
        client.addCookie(newCookie, this.getPage().getUrl(), this);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.FF})
    public Object getImages() {
        return super.getImages();
    }

    @JsxGetter
    public HTMLCollection getAll() {
        return new HTMLAllCollection(this.getDomNodeOrDie()){

            @Override
            protected boolean isMatching(DomNode node) {
                return true;
            }

            @Override
            public boolean avoidObjectDetection() {
                return true;
            }
        };
    }

    @JsxFunction
    public Object open(Object url, Object name, Object features, Object replace) {
        HtmlPage page = this.getPage();
        if (page.isBeingParsed()) {
            LOG.warn("Ignoring call to open() during the parsing stage.");
            return null;
        }
        if (!this.writeInCurrentDocument_) {
            LOG.warn("Function open() called when document is already open.");
        }
        this.writeInCurrentDocument_ = false;
        if (this.getWindow().getWebWindow() instanceof FrameWindow && "about:blank".equals(this.getPage().getUrl().toExternalForm())) {
            URL enclosingUrl = ((FrameWindow)this.getWindow().getWebWindow()).getEnclosingPage().getUrl();
            this.getPage().getWebResponse().getWebRequest().setUrl(enclosingUrl);
        }
        return this;
    }

    @Override
    @JsxFunction(value={SupportedBrowser.FF})
    public void close() throws IOException {
        if (this.writeInCurrentDocument_) {
            LOG.warn("close() called when document is not open.");
        } else {
            HtmlPage page = this.getPage();
            URL url = page.getUrl();
            StringWebResponse webResponse = new StringWebResponse(this.writeBuilder_.toString(), url);
            webResponse.setFromJavascript(true);
            this.writeInCurrentDocument_ = true;
            this.writeBuilder_.setLength(0);
            WebClient webClient = page.getWebClient();
            WebWindow window = page.getEnclosingWindow();
            webClient.loadWebResponseInto(webResponse, window);
        }
    }

    @Override
    @JsxFunction(value={SupportedBrowser.FF})
    public boolean execCommand(String cmd, boolean userInterface, Object value) {
        return super.execCommand(cmd, userInterface, value);
    }

    @Override
    @JsxFunction(value={SupportedBrowser.FF})
    public boolean queryCommandEnabled(String cmd) {
        return super.queryCommandEnabled(cmd);
    }

    @Override
    @JsxFunction(value={SupportedBrowser.FF})
    public boolean queryCommandSupported(String cmd) {
        return super.queryCommandSupported(cmd);
    }

    private void implicitCloseIfNecessary() {
        if (!this.writeInCurrentDocument_) {
            try {
                this.close();
            }
            catch (IOException e) {
                throw Context.throwAsScriptRuntimeEx(e);
            }
        }
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public Object getParentWindow() {
        return this.getWindow();
    }

    @Override
    public Object appendChild(Object childObject) {
        throw Context.reportRuntimeError("Node cannot be inserted at the specified point in the hierarchy.");
    }

    @JsxFunction
    public Object getElementById(String id) {
        this.implicitCloseIfNecessary();
        SimpleScriptable result = null;
        DomElement domElement = this.getPage().getElementById(id);
        if (null == domElement) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getElementById(" + id + "): no DOM node found with this id");
            }
        } else {
            SimpleScriptable jsElement = this.getScriptableFor(domElement);
            if (jsElement == NOT_FOUND) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getElementById(" + id + ") cannot return a result as there isn't a JavaScript object for the HTML element " + domElement.getClass().getName());
                }
            } else {
                result = jsElement;
            }
        }
        return result;
    }

    @Override
    public HTMLCollection getElementsByClassName(String className) {
        return ((HTMLElement)this.getDocumentElement()).getElementsByClassName(className);
    }

    @Override
    @JsxFunction(value={SupportedBrowser.FF})
    public HTMLCollection getElementsByName(String elementName) {
        this.implicitCloseIfNecessary();
        if ("null".equals(elementName)) {
            return HTMLCollection.emptyCollection(this.getWindow().getDomNodeOrDie());
        }
        final String expElementName = "null".equals(elementName) ? "" : elementName;
        final HtmlPage page = this.getPage();
        HTMLCollection collection = new HTMLCollection(page, true){

            @Override
            protected List<DomNode> computeElements() {
                return new ArrayList<DomNode>(page.getElementsByName(expElementName));
            }

            @Override
            protected AbstractList.EffectOnCache getEffectOnCache(HtmlAttributeChangeEvent event) {
                if ("name".equals(event.getName())) {
                    return AbstractList.EffectOnCache.RESET;
                }
                return AbstractList.EffectOnCache.NONE;
            }
        };
        return collection;
    }

    @Override
    protected Object getWithPreemption(String name) {
        Object response;
        HtmlPage page = (HtmlPage)this.getDomNodeOrNull();
        if ((page == null || this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_GET_PREFERS_STANDARD_FUNCTIONS)) && (response = this.getPrototype().get(name, (Scriptable)this)) != NOT_FOUND) {
            return response;
        }
        return this.getIt(name);
    }

    private Object getIt(String name) {
        boolean alsoFrames;
        boolean forIDAndOrName;
        HtmlPage page = (HtmlPage)this.getDomNodeOrNull();
        HTMLCollection collection = new HTMLCollection(page, true, forIDAndOrName = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_GET_FOR_ID_AND_OR_NAME), page, name, alsoFrames = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_GET_ALSO_FRAMES)){
            final /* synthetic */ boolean val$forIDAndOrName;
            final /* synthetic */ HtmlPage val$page;
            final /* synthetic */ String val$name;
            final /* synthetic */ boolean val$alsoFrames;
            {
                this.val$forIDAndOrName = bl;
                this.val$page = htmlPage;
                this.val$name = string;
                this.val$alsoFrames = bl2;
                super(domNode, attributeChangeSensitive);
            }

            @Override
            protected List<DomNode> computeElements() {
                List<DomElement> elements = this.val$forIDAndOrName ? this.val$page.getElementsByIdAndOrName(this.val$name) : this.val$page.getElementsByName(this.val$name);
                ArrayList<DomNode> matchingElements = new ArrayList<DomNode>();
                for (DomElement elt : elements) {
                    if (!(elt instanceof HtmlForm) && !(elt instanceof HtmlImage) && !(elt instanceof HtmlApplet) && (!this.val$alsoFrames || !(elt instanceof BaseFrameElement))) continue;
                    matchingElements.add(elt);
                }
                return matchingElements;
            }

            @Override
            protected AbstractList.EffectOnCache getEffectOnCache(HtmlAttributeChangeEvent event) {
                String attributeName = event.getName();
                if ("name".equals(attributeName)) {
                    return AbstractList.EffectOnCache.RESET;
                }
                if (this.val$forIDAndOrName && "id".equals(attributeName)) {
                    return AbstractList.EffectOnCache.RESET;
                }
                return AbstractList.EffectOnCache.NONE;
            }

            @Override
            protected SimpleScriptable getScriptableFor(Object object) {
                if (this.val$alsoFrames && object instanceof BaseFrameElement) {
                    return (SimpleScriptable)((BaseFrameElement)object).getEnclosedWindow().getScriptableObject();
                }
                return super.getScriptableFor(object);
            }
        };
        int length = collection.getLength();
        if (length == 0) {
            return NOT_FOUND;
        }
        if (length == 1) {
            return collection.item(0);
        }
        return collection;
    }

    @Override
    @JsxGetter
    public HTMLElement getHead() {
        HtmlElement head = this.getPage().getHead();
        if (head != null) {
            return (HTMLElement)head.getScriptableObject();
        }
        return null;
    }

    @Override
    @JsxGetter(value={SupportedBrowser.FF})
    @CanSetReadOnly(value=CanSetReadOnlyStatus.EXCEPTION)
    public HTMLElement getBody() {
        return super.getBody();
    }

    @Override
    public String getTitle() {
        return this.getPage().getTitleText();
    }

    @Override
    public void setTitle(String title) {
        this.getPage().setTitleText(title);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF})
    public String getBgColor() {
        String color = this.getPage().getBody().getAttribute("bgColor");
        if (color == DomElement.ATTRIBUTE_NOT_DEFINED && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_COLOR)) {
            color = "#ffffff";
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTML_COLOR_EXPAND_ZERO) && "#0".equals(color)) {
            color = "#000000";
        }
        return color;
    }

    @Override
    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF})
    public void setBgColor(String color) {
        HTMLBodyElement body = (HTMLBodyElement)this.getPage().getBody().getScriptableObject();
        body.setBgColor(color);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF})
    public String getAlinkColor() {
        String color = this.getPage().getBody().getAttribute("aLink");
        if (color == DomElement.ATTRIBUTE_NOT_DEFINED && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_COLOR)) {
            color = "#0000ff";
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTML_COLOR_EXPAND_ZERO) && "#0".equals(color)) {
            color = "#000000";
        }
        return color;
    }

    @Override
    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF})
    public void setAlinkColor(String color) {
        HTMLBodyElement body = (HTMLBodyElement)this.getPage().getBody().getScriptableObject();
        body.setALink(color);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF})
    public String getLinkColor() {
        String color = this.getPage().getBody().getAttribute("link");
        if (color == DomElement.ATTRIBUTE_NOT_DEFINED && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_COLOR)) {
            color = "#0000ff";
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTML_COLOR_EXPAND_ZERO) && "#0".equals(color)) {
            color = "#000000";
        }
        return color;
    }

    @Override
    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF})
    public void setLinkColor(String color) {
        HTMLBodyElement body = (HTMLBodyElement)this.getPage().getBody().getScriptableObject();
        body.setLink(color);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF})
    public String getVlinkColor() {
        String color = this.getPage().getBody().getAttribute("vLink");
        if (color == DomElement.ATTRIBUTE_NOT_DEFINED && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_COLOR)) {
            color = "#800080";
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTML_COLOR_EXPAND_ZERO) && "#0".equals(color)) {
            color = "#000000";
        }
        return color;
    }

    @Override
    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF})
    public void setVlinkColor(String color) {
        HTMLBodyElement body = (HTMLBodyElement)this.getPage().getBody().getScriptableObject();
        body.setVLink(color);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF})
    public String getFgColor() {
        String color = this.getPage().getBody().getAttribute("text");
        if (color == DomElement.ATTRIBUTE_NOT_DEFINED && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTMLDOCUMENT_COLOR)) {
            color = "#000000";
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.HTML_COLOR_EXPAND_ZERO) && "#0".equals(color)) {
            color = "#000000";
        }
        return color;
    }

    @Override
    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.FF})
    public void setFgColor(String color) {
        HTMLBodyElement body = (HTMLBodyElement)this.getPage().getBody().getScriptableObject();
        body.setText(color);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.FF})
    public String getDomain() {
        return super.getDomain();
    }

    @Override
    @JsxSetter(value={SupportedBrowser.FF})
    public void setDomain(String newDomain) {
        super.setDomain(newDomain);
    }

    @Override
    @JsxGetter(value={SupportedBrowser.FF})
    public Object getScripts() {
        return super.getScripts();
    }

    @Override
    public HTMLElement getActiveElement() {
        HtmlElement body;
        if (this.activeElement_ == null && (body = this.getPage().getBody()) != null) {
            this.activeElement_ = (HTMLElement)this.getScriptableFor(body);
        }
        return this.activeElement_;
    }

    @Override
    public boolean hasFocus() {
        return this.activeElement_ != null && this.getPage().getFocusedElement() == this.activeElement_.getDomNodeOrDie();
    }

    public void setActiveElement(HTMLElement element) {
        BaseFrameElement frame;
        WebWindow window;
        this.activeElement_ = element;
        if (element != null && (window = element.getDomNodeOrDie().getPage().getEnclosingWindow()) instanceof FrameWindow && (frame = ((FrameWindow)window).getFrameElement()) instanceof HtmlInlineFrame) {
            Window winWithFrame = (Window)frame.getPage().getEnclosingWindow().getScriptableObject();
            ((HTMLDocument)winWithFrame.getDocument()).setActiveElement((HTMLElement)frame.getScriptableObject());
        }
    }

    @Override
    @JsxFunction
    public boolean dispatchEvent(Event event) {
        event.setTarget(this);
        ScriptResult result = this.fireEvent(event);
        return !event.isAborted(result);
    }

    @JsxFunction
    public void clear() {
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.IE})
    public void setHead(ScriptableObject head) {
    }

    @Override
    @JsxFunction
    public Selection getSelection() {
        return this.getWindow().getSelectionImpl();
    }

    @Override
    public Attr createAttribute(String attributeName) {
        String name = attributeName;
        if (StringUtils.isNotEmpty(name) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOCUMENT_CREATE_ATTRUBUTE_LOWER_CASE)) {
            name = name.toLowerCase(Locale.ROOT);
        }
        return super.createAttribute(name);
    }

    @Override
    public String getBaseURI() {
        return this.getPage().getBaseURL().toString();
    }

    @Override
    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.FF})
    public void captureEvents(String type) {
    }

    @Override
    @JsxFunction(value={SupportedBrowser.CHROME, SupportedBrowser.FF})
    public void releaseEvents(String type) {
    }

    @Override
    @JsxGetter(value={SupportedBrowser.FF})
    public String getDesignMode() {
        return super.getDesignMode();
    }

    @Override
    @JsxSetter(value={SupportedBrowser.FF})
    public void setDesignMode(String mode) {
        super.setDesignMode(mode);
    }

    @Override
    public Object elementFromPoint(int x, int y) {
        HtmlElement element = this.getPage().getElementFromPoint(x, y);
        return element == null ? null : element.getScriptableObject();
    }

    private static enum ParsingStatus {
        OUTSIDE,
        START,
        IN_NAME,
        INSIDE,
        IN_STRING;

    }
}

