# Generated by default/object.tt
package Paws::CustomerProfiles::ObjectTypeField;
  use Moose;
  has ContentType => (is => 'ro', isa => 'Str');
  has Source => (is => 'ro', isa => 'Str');
  has Target => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CustomerProfiles::ObjectTypeField

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CustomerProfiles::ObjectTypeField object:

  $service_obj->Method(Att1 => { ContentType => $value, ..., Target => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CustomerProfiles::ObjectTypeField object:

  $result = $service_obj->Method(...);
  $result->Att1->ContentType

=head1 DESCRIPTION

Represents a field in a ProfileObjectType.

=head1 ATTRIBUTES


=head2 ContentType => Str

The content type of the field. Used for determining equality when
searching.


=head2 Source => Str

A field of a ProfileObject. For example: _source.FirstName, where
E<ldquo>_sourceE<rdquo> is a ProfileObjectType of a Zendesk user and
E<ldquo>FirstNameE<rdquo> is a field in that ObjectType.


=head2 Target => Str

The location of the data in the standard ProfileObject model. For
example: _profile.Address.PostalCode.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CustomerProfiles>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

