/************************************************************************\
 * shark.aff.c                                                          *
 *                                                                      *
 * reference implementation of SHARK                                    *
 * (to be presented at the Cambridge Workshop on                        *
 *   Fast Software Encryption                                           *
 * version A-1.0: nm-bit roundkeys (`affine transform`)                 *
 *                                                                      *
 * Vincent Rijmen                                                       *
 * December 1995                                                        *
 * Copyright (C): Kuleuven                                              *
 * Copyright (C): Kuleuven.    All rights reserved.                     *
 * KULeuven  makes no representations concerning either the             *
 * merchantability of this software or the suitability of this          *
 * software for any particular purpose. It is provided "as is"          *
 * without express or implied warranty of any kind.                     *
 *                                                                      *
 * Slight modification by jcd 2003 06 26 Thursday                       *
\************************************************************************/
#include <stdio.h>
#include <string.h>

typedef unsigned short word;
typedef unsigned long dword;
typedef long sdword;

#ifdef __alpha
typedef unsigned long ddword;
typedef long sddword;
#else
typedef unsigned long long ddword;
typedef long long sddword;
#endif

#define ROUNDS 6
#define KEYLENGTH 16
#define ROOT 0x1f5
#define ROUNDKEYS (2*ROUNDS+2)

unsigned char sbox_enc[256] = {
    177, 206, 195, 149,  90, 173, 231,   2,  77,  68, 251, 145,  12,
    135, 161,  80, 203, 103,  84, 221,  70, 143, 225,  78, 240, 253,
    252, 235, 249, 196,  26, 110,  94, 245, 204, 141,  28,  86,  67,
    254,   7,  97, 248, 117,  89, 255,   3,  34, 138, 209,  19, 238,
    136,   0,  14,  52,  21, 128, 148, 227, 237, 181,  83,  35,  75,
     71,  23, 167, 144,  53, 171, 216, 184, 223,  79,  87, 154, 146,
    219,  27,  60, 200, 153,   4, 142, 224, 215, 125, 133, 187,  64,
     44,  58,  69, 241,  66, 101,  32,  65,  24, 114,  37, 147, 112,
     54,   5, 242,  11, 163, 121, 236,   8,  39,  49,  50, 182, 124,
    176,  10, 115,  91, 123, 183, 129, 210,  13, 106,  38, 158,  88,
    156, 131, 116, 179, 172,  48, 122, 105, 119,  15, 174,  33, 222,
    208,  46, 151,  16, 164, 152, 168, 212, 104,  45,  98,  41, 109,
     22,  73, 118, 199, 232, 193, 150,  55, 229, 202, 244, 233,  99,
     18, 194, 166,  20, 188, 211,  40, 175,  47, 230,  36,  82, 198,
    160,   9, 189, 140, 207,  93,  17,  95,   1, 197, 159,  61, 162,
    155, 201,  59, 190,  81,  25,  31,  63,  92, 178, 239,  74, 205,
    191, 186, 111, 100, 217, 243,  62, 180, 170, 220, 213,   6, 192,
    126, 246, 102, 108, 132, 113,  56, 185,  29, 127, 157,  72, 139,
     42, 218, 165,  51, 130,  57, 214, 120, 134, 250, 228,  43, 169,
     30, 137,  96, 107, 234,  85,  76, 247, 226
};

unsigned char sbox_dec[256] = {
    53, 190,   7,  46,  83, 105, 219,  40, 111, 183, 118, 107, 12,  125,
    54, 139, 146, 188, 169,  50, 172,  56, 156,  66,  99, 200, 30,   79,
    36, 229, 247, 201,  97, 141,  47,  63, 179, 101, 127, 112, 175, 154,
   234, 245,  91, 152, 144, 177, 135, 113, 114, 237,  55,  69, 104, 163,
   227, 239,  92, 197,  80, 193, 214, 202,  90,  98,  95,  38,   9,  93,
    20,  65, 232, 157, 206,  64, 253,   8,  23,  74,  15, 199, 180,  62,
    18, 252,  37,  75, 129,  44,   4, 120, 203, 187,  32, 189, 249,  41,
   153, 168, 211,  96, 223,  17, 151, 137, 126, 250, 224, 155,  31, 210,
   103, 226, 100, 119, 132,  43, 158, 138, 241, 109, 136, 121, 116,  87,
   221, 230,  57, 123, 238, 131, 225,  88, 242,  13,  52, 248,  48, 233,
   185,  35,  84,  21,  68,  11,  77, 102,  58,   3, 162, 145, 148,  82,
    76, 195, 130, 231, 128, 192, 182,  14, 194, 108, 147, 236, 171,  67,
   149, 246, 216,  70, 134,   5, 140, 176, 117,   0, 204, 133, 215,  61,
   115, 122,  72, 228, 209,  89, 173, 184, 198, 208, 220, 161, 170,   2,
    29, 191, 181, 159,  81, 196, 165,  16,  34, 207,   1, 186, 143,  49,
   124, 174, 150, 218, 240,  86,  71, 212, 235,  78, 217,  19, 142,  73,
    85,  22, 255,  59, 244, 164, 178,   6, 160, 167, 251,  27, 110,  60,
    51, 205,  24,  94, 106, 213, 166,  33, 222, 254,  42,  28, 243,  10,
    26,  25,  39,  45
};

unsigned char G[8][8] = {
    {0xce, 0x95, 0x57, 0x82, 0x8a, 0x19, 0xb0, 0x01},
    {0xe7, 0xfe, 0x05, 0xd2, 0x52, 0xc1, 0x88, 0xf1},
    {0xb9, 0xda, 0x4d, 0xd1, 0x9e, 0x17, 0x83, 0x86},
    {0xd0, 0x9d, 0x26, 0x2c, 0x5d, 0x9f, 0x6d, 0x75},
    {0x52, 0xa9, 0x07, 0x6c, 0xb9, 0x8f, 0x70, 0x17},
    {0x87, 0x28, 0x3a, 0x5a, 0xf4, 0x33, 0x0b, 0x6c},
    {0x74, 0x51, 0x15, 0xcf, 0x09, 0xa4, 0x62, 0x09},
    {0x0b, 0x31, 0x7f, 0x86, 0xbe, 0x05, 0x83, 0x34}
};

unsigned char iG[8][8] = {
    {0xe7, 0x30, 0x90, 0x85, 0xd0, 0x4b, 0x91, 0x41},
    {0x53, 0x95, 0x9b, 0xa5, 0x96, 0xbc, 0xa1, 0x68},
    {0x02, 0x45, 0xf7, 0x65, 0x5c, 0x1f, 0xb6, 0x52},
    {0xa2, 0xca, 0x22, 0x94, 0x44, 0x63, 0x2a, 0xa2},
    {0xfc, 0x67, 0x8e, 0x10, 0x29, 0x75, 0x85, 0x71},
    {0x24, 0x45, 0xa2, 0xcf, 0x2f, 0x22, 0xc1, 0x0e},
    {0xa1, 0xf1, 0x71, 0x40, 0x91, 0x27, 0x18, 0xa5},
    {0x56, 0xf4, 0xaf, 0x32, 0xd2, 0xa4, 0xdc, 0x71}
};

ddword cbox_enc[8][256] = {
   {0x060d838f16f3a365LL, 0xa68857ee5cae56f6LL, 0xebf516353c2c4d89LL,
    0x652174be88e85bdcLL, 0x0d4e9a8086c17921LL, 0x27ba7d33cffa58a1LL,
    0x88d9e104a237b530LL, 0x693b8755a4fbe816LL, 0xdac9591826b254a0LL,
    0x45c2e369fb336af3LL, 0xa96e1fb87b3e4ef4LL, 0xb7578f1435eb7ef0LL,
    0x839af80b32056f74LL, 0xae37f55cc71f277aLL, 0xa4208538fdff37d5LL,
    0x35991e74ad3cdb6fLL, 0xba191594b32a07d1LL, 0x5344d1772e572b7bLL,
    0xe7efe5de103ffe43LL, 0xa3796fdc41de5e5bLL, 0x2cf9643c5fc882e5LL,
    0xffdbf6fd48196d22LL, 0x33949dfbbbcf780aLL, 0x7d15679dd0cec8bdLL,
    0x5f5e229c024498b1LL, 0x1223634762c683ceLL, 0xdcc4da973041f7c5LL,
    0x0b43190f9032da44LL, 0xc05598eddfc5a6e2LL, 0x9e5fd31a7753f4b8LL,
    0x9afa8243c0f136feLL, 0xcc4f6b06f3d61528LL, 0xdf38612a3bc25c0dLL,
    0x43cf60e6edc0c996LL, 0xcfb3d0bbf855bee0LL, 0x96e071a8ece28534LL,
    0x21b7febcd909fbc4LL, 0x8ed4628bb4c41655LL, 0x30682646b04cd3c2LL,
    0xb5ff5dc294ba1fd3LL, 0x75aac52f4b7fb931LL, 0xe809ad8837afe641LL,
    0x0eb2213d8d42d2e9LL, 0x9852509561a057ddLL, 0xaa92a40570bde53cLL,
    0x7b18e412c63d6bd8LL, 0xa7dc3e85f67c9c1dLL, 0xd8618bce87e33583LL,
    0xe34ab487a79d3c05LL, 0x20e397d773db312fLL, 0x05f138321d7008adLL,
    0x17d25b757fb68b63LL, 0x8a7133d20366d413LL, 0x0000000000000000LL,
    0xeaa17f5e96fe8762LL, 0xc101f18675176c09LL, 0xbebc44cd0488c597LL,
    0xdb9d30738c609e4bLL, 0xabc6cd6eda6f2fd7LL, 0x5aaf1aae1f34901cLL,
    0xb00e65f089ca177eLL, 0xd47b7825abf08649LL, 0x924520f15b404772LL,
    0x1686321ed5644188LL, 0x618425e73f4a999aLL, 0xe21eddec0d4ff6eeLL,
    0xd787c398a0732d81LL, 0x1f6df9c7e407faefLL, 0x79b036c4676c0afbLL,
    0x0fe6485627901802LL, 0x9cf701ccd602959bLL, 0xbfe82da6ae5a0f7cLL,
    0x990639fecb729d36LL, 0xca42e889e525b64dLL, 0xb3f2de4d8249bcb6LL,
    0x4033db5be643625eLL, 0x4167b2304c91a8b5LL, 0x108bb191c397e2edLL,
    0x1834132358269361LL, 0x541d3b93927642f5LL, 0x90edf227fa112651LL,
    0x1dc52b1145569bccLL, 0xe6bb8cb5baed34a8LL, 0xd276fbaabd03252cLL,
    0x313c4f2d1a9e1929LL, 0xfd73242be9480c01LL, 0x9baeeb286a23fc15LL,
    0xc9be5334eea61d85LL, 0xc70c720963e4cf6cLL, 0x3eda077b3d0e012bLL,
    0x97b418c346304fdfLL, 0x32c0f490111db2e1LL, 0x2ba08ed8e3e9eb6bLL,
    0x8b255ab9a9b41ef8LL, 0x91b99b4c50c3ecbaLL, 0xfe8f9f96e2cba7c9LL,
    0x3a7f56228aacc36dLL, 0xb15a0c9b2318dd95LL, 0x5953a11314b73bd4LL,
    0xf3c10516640adee8LL, 0xedf895ba2adfeeecLL, 0xadcb4ee1cc9c8cb2LL,
    0xde6c0841911096e6LL, 0x84c312ef8e2406faLL, 0xa83a76d3d1ec841fLL,
    0x1c91427aef845127LL, 0x3665a5c9a6bf70a7LL, 0xf6303d24797ad645LL,
    0xcd1b026d5904dfc3LL, 0x1bc8a89e53a538a9LL, 0x7ee9dc20db4d6375LL,
    0x51ec03a18f064a58LL, 0xc4f0c9b4686764a4LL, 0xdd90b3fc9a933d2eLL,
    0x7a4c8d796cefa133LL, 0x73a746a05d8c1a54LL, 0x0759eae4bc21698eLL,
    0xc8ea3a5f4474d76eLL, 0x38d784f42bfda24eLL, 0x231f2c6a78589ae7LL,
    0xc3a92350d4460d2aLL, 0x72f32fcbf75ed0bfLL, 0xbd40ff700f0b6e5fLL,
    0x157a89a3dee7ea40LL, 0x873fa95285a7ad32LL, 0x4d7d41db60821b7fLL,
    0x1e3990ac4ed53004LL, 0x0a1770643ae010afLL, 0x9311499af1928d99LL,
    0x64751dd5223a9137LL, 0xfa2acecf5569658fLL, 0x7c410ef67a1c0256LL,
    0x56b5e945332723d6LL, 0x6f3604dab2084b73LL, 0xe95dc4e39d7d2caaLL,
    0x13770a2cc8144925LL, 0xbc14961ba5d9a4b4LL, 0xb9e5ae29b8a9ac19LL,
    0xf169d7c0c55bbfcbLL, 0x2446c68ec479f369LL, 0x806643b63986c4bcLL,
    0x7fbdb54b719fa99eLL, 0x04a55159b7a2c246LL, 0xee042e07215c4524LL,
    0x5bfb73c5b5e65af7LL, 0x0c1af3eb2c13b3caLL, 0xa22d06b7eb0c94b0LL,
    0xb8b1c742127b66f2LL, 0x285c3565e86a40a3LL, 0x3b2b3f49207e0986LL,
    0x3c72d5ad9c5f6008LL, 0x770217f9ea2ed812LL, 0xfc274d40439ac6eaLL,
    0x4fd5930dc1d37a5cLL, 0x2e51b6eafe99e3c6LL, 0x6b93558305aa8935LL,
    0x19607a48f2f4598aLL, 0x08bfa2b29bb1718cLL, 0x3f8e6e1097dccbc0LL,
    0x3983ed9f812f68a5LL, 0xac9f278a664e4659LL, 0x82ce916098d7a59fLL,
    0xc2fd4a3b7e94c7c1LL, 0x66ddcf03836bf014LL, 0xe1e2665106cc5d26LL,
    0x74feac44e1ad73daLL, 0x8d28d936bf47bd9dLL, 0x62789e5a34c93252LL,
    0x81322add93540e57LL, 0xcb1681e24ff77ca6LL, 0x2512afe56eab3982LL,
    0xd18a4017b6808ee4LL, 0x705bfd1d560fb19cLL, 0x4b70c2547671b81aLL,
    0x49d81082d720d939LL, 0xe0b60f3aac1e97cdLL, 0x4e81fa666b01b0b7LL,
    0x951cca15e7612efcLL, 0x463e58d4f0b0c13bLL, 0x632cf7319e1bf8b9LL,
    0x5ca2992109c73379LL, 0xf764544fd3a81caeLL, 0x6ac73ce8af7843deLL,
    0x9f0bba71dd813e53LL, 0x85977b8424f6cc11LL, 0x5807c878be65f13fLL,
    0x686fee3e0e2922fdLL, 0x78e45fafcdbec010LL, 0x6ccabf67b98be0bbLL,
    0x11dfd8fa69452806LL, 0xcee7b9d05287740bLL, 0x50b86aca25d480b3LL,
    0x5df6f04aa315f992LL, 0x5e0a4bf7a896525aLL, 0x03fcbbbd0b83abc8LL,
    0x8f800be01e16dcbeLL, 0xd32292c117d1efc7LL, 0xe5473708b16e9f60LL,
    0x224b4501d28a500cLL, 0xfb7ea7a4ffbbaf64LL, 0x3d26bcc6368daae3LL,
    0x866bc0392f7567d9LL, 0x3731cca20c6dba4cLL, 0xb603e67f9f39b41bLL,
    0xa1d1bd0ae08f3f78LL, 0xd935e2a52d31ff68LL, 0xaf639c376dcded91LL,
    0x0154696baad2caebLL, 0xecacfcd1800d2407LL, 0xf03dbeab6f897520LL,
    0x02a8d2d6a1516123LL, 0xf498eff2d82bb766LL, 0x710f9476fcdd7b77LL,
    0xf8821c19f43804acLL, 0xf9d675725eeace47LL, 0x1a9cc1f5f977f242LL,
    0x5210b81c8485e190LL, 0x6d9ed60c13592a50LL, 0xf2956c7dced81403LL,
    0xbb4d7cff19f8cd3aLL, 0x4c2928b0ca50d194LL, 0x6e626db118da8198LL,
    0xe4135e631bbc558bLL, 0x9da368a77cd05f70LL, 0xa574ec53572dfd3eLL,
    0x09ebcbd93163bb67LL, 0x4a24ab3fdca372f1LL, 0x429b098d4712037dLL,
    0x57e1802e99f5e93dLL, 0xef50476c8b8e8fcfLL, 0xa085d4614a5df593LL,
    0x34cd771f07ee1184LL, 0xc6581b62c9360587LL, 0x2dad0d57f51a480eLL,
    0x898d886f08e57fdbLL, 0xd6d3aaf30aa1e76aLL, 0x76567e9240fc12f9LL,
    0xb4ab34a93e68d538LL, 0xb2a6b726289b765dLL, 0x8c7cb05d15957776LL,
    0x554952f838a4881eLL, 0xd52f114e01224ca2LL, 0x60d04c8c95985371LL,
    0x6789a66829b93affLL, 0x2f05df81544b292dLL, 0x476a31bf5a620bd0LL,
    0xf5cc869972f97d8dLL, 0x488c79e97df213d2LL, 0x44968a0251e1a018LL,
    0x26ee14586528924aLL, 0xd0de297c1c52440fLL, 0xc5a4a0dfc2b5ae4fLL,
    0x29085c0e42b88a48LL, 0x142ee0c8743520abLL, 0x2af4e7b3493b2180LL,
    0x9448a37e4db3e417LL},

   {0xe2795ba105ba30ceLL, 0x65b5d634f5e0fbddLL,
    0x2d7d7f1464dd8c55LL, 0xeefbf778add1c20bLL, 0x1eb0fbd1f11968e7LL,
    0xe6073f45ce30cd8dLL, 0x21ffd3cdccb67e90LL, 0xdf0941cfa750a262LL,
    0xc61df5b1b75ef18aLL, 0xc5c7defa9dc337c6LL, 0x2581b729073c83d3LL,
    0xa5e97513167173cfLL, 0xdd3673bd381526b9LL, 0xe8baa1eef91ebb93LL,
    0x3b314cf8f625eb34LL, 0x579d4bc8d5fc5df8LL, 0xbb598ec2e7681b28LL,
    0xc8a06b1a80708794LL, 0x1c8fc9a36e5cec3cLL, 0xf60a5a3f0807d374LL,
    0x1ace9f353a9395a4LL, 0x7e9e50387aab2ceeLL, 0xb5e41069d0466d36LL,
    0x8cea6ee3b92602d9LL, 0xf952ddad8af1e7fdLL, 0xb19a748d1bcc9075LL,
    0x2464ae10b2e4c144LL, 0xfcc9a070f4a35829LL, 0xfa88f6e6a06c21b1LL,
    0x2c98662dd105cec2LL, 0x9065a740d77aeee5LL, 0xcb7a4051aaed41d8LL,
    0x55a279ba4ab9d923LL, 0x27be855b98790708LL, 0xbabc97fb52b059bfLL,
    0xa19711f7ddfb8e8cLL, 0x047e64e4cb8afd43LL, 0xc386886cc90c4e5eLL,
    0xc422c7c3281b7551LL, 0xfb6defdf15b46326LL, 0x01e51939b5d84297LL,
    0x5cbba8be9c809432LL, 0x6f762c7b09447080LL, 0xcee13d8cd4bffe0cLL,
    0x54476083ff619bb4LL, 0x6e933542bc9c3217LL, 0x4af79b520e78f353LL,
    0x98996f7db49be163LL, 0xa07208ce6823cc1bLL, 0x2b3c29823012f5cdLL,
    0x93bf8c0bfde728a9LL, 0x2225f886e62bb8dcLL, 0x7f7b4901cf736e79LL,
    0x0000000000000000LL, 0x023f32729f4584dbLL, 0xd5cabb805bf4293fLL,
    0x07a44fafe1173b0fLL, 0xe95fb8d74cc6f904LL, 0x7b052de504f9933aLL,
    0x6aed51a67716cf54LL, 0x68d263d4e8534b8fLL, 0xa96bd9cabe1a810aLL,
    0x1d6ad09adb84aeabLL, 0x0d67b5e01db3b052LL, 0x52063615abaee22cLL,
    0x8f3045a893bbc495LL, 0xd8ad0e604647996dLL, 0xaf2a8f5cead5f892LL,
    0x3017af8ebf5922feLL, 0x4034611df2dc780eLL, 0x721cfce1d2c0de2bLL,
    0x28e602c91a8f3381LL, 0xe1a370ea2f27f682LL, 0x29031bf0af577116LL,
    0x1914b47e100e53e8LL, 0x567852f160241f6fLL, 0x793a1f979bbc17e1LL,
    0xef1eee411809809cLL, 0x6211999b14f7c0d2LL, 0x059b7ddd7e52bfd4LL,
    0x43ee4a56d841be42LL, 0xf1ae1590e910e87bLL, 0x33cd84c595c4e4b2LL,
    0x4b12826bbba0b1c4LL, 0xeb608aa5d3837ddfLL, 0x201acaf4796e3c07LL,
    0xbf27ea262ce2e66bLL, 0x58c5cc5a570a6971LL, 0x37b3e0215e4e19f1LL,
    0xab54ebb8215f05d1LL, 0x8ed55c9126638602LL, 0x9aa65d0f2bde65b8LL,
    0xd7f589f2c4b1ade4LL, 0x5039046734eb66f7LL, 0x6cac073023d9b6ccLL,
    0x51dc1d5e81332460LL, 0x17a92ad5272025f6LL, 0x47902eb213cb4301LL,
    0x1b2b860c8f4bd733LL, 0x4f6ce68f702a4c87LL, 0xcf0424b56167bc9bLL,
    0x997c76440143a3f4LL, 0x7ae034dcb121d1adLL, 0x100d657ac6371ef9LL,
    0x0ac3fa4ffca48b5dLL, 0xdeec58f61288e0f5LL, 0x265b9c622da1459fLL,
    0xdcd36a848dcd642eLL, 0xe4380d3751754956LL, 0x13d74e31ecaad8b5LL,
    0xfd2cb949417b1abeLL, 0x9624f1d683b5977dLL, 0x4675378ba6130196LL,
    0x0b26e376497cc9caLL, 0x41d1782447043a99LL, 0xe39c4298b0627259LL,
    0xcd3b16c7fe223840LL, 0x7787813cac9261ffLL, 0x492db01924e5351fLL,
    0x5afafe28c84fedaaLL, 0x8b4e214c583139d6LL, 0xccde0ffe4bfa7ad7LL,
    0x76629805194a2368LL, 0x7ca1624ae5eea835LL, 0x61cbb2d03e6a069eLL,
    0x48c8a920913d7788LL, 0x8068c23a114df01cLL, 0xd38bed160f3b50a7LL,
    0x32289dfc201ca625LL, 0xc1b9ba1e5649ca85LL, 0xed21dc33874c0447LL,
    0xa3a8238542be0a57LL, 0x5b1fe7117d97af3dLL, 0x3d701a6ea2ea92acLL,
    0x73f9e5d867189cbcLL, 0x9ed839ebe05498fbLL, 0x5920d563e2d22be6LL,
    0xca9f59681f35034fLL, 0x11e87c4373ef5c6eLL, 0x97c1e8ef366dd5eaLL,
    0xacf0a417c0483edeLL, 0xd26ef42fbae31230LL, 0xbcfdc16d067f2027LL,
    0xbec2f31f993aa4fcLL, 0x45af1cc08c8ec7daLL, 0x31f2b6b70a816069LL,
    0xd9481759f39fdbfaLL, 0xe5dd140ee4ad0bc1LL, 0xa6335e583cecb583LL,
    0x38eb67b3dcb82d78LL, 0xf5d07174229a1538LL, 0x5f6183f5b61d527eLL,
    0x0f58879282f63489LL, 0x164c33ec92f86761LL, 0x444a05f93956854dLL,
    0x818ddb03a495b28bLL, 0x4d53d4fdef6fc85cLL, 0x8d0f77da0cfe404eLL,
    0x8416a6dedac70d5fLL, 0x666ffd7fdf7d3d91LL, 0xb63e3b22fadbab7aLL,
    0xf2743edbc38d2e37LL, 0xa40c6c2aa3a93158LL, 0x9f3d20d2558cda6cLL,
    0xfef692026be6dcf2LL, 0x2ea7545f4e404a19LL, 0xb2405fc631515639LL,
    0x23c0e1bf53f3fa4bLL, 0x83b2e9713bd03650LL, 0x0641569654cf7998LL,
    0xb883a589cdf5dd64LL, 0x3ad455c143fda9a3LL, 0x925a9532483f6a3eLL,
    0xaab1f28194874746LL, 0xf435684d974257afLL, 0xd1b4df64907ed47cLL,
    0x390e7e8a69606fefLL, 0xd051c65d25a696ebLL, 0xb4010950659e2fa1LL,
    0x0c82acd9a86bf2c5LL, 0x88940a0772acff9aLL, 0xf39127e276556ca0LL,
    0xaecf96655f0dba05LL, 0x03da2b4b2a9dc64cLL, 0x3f4f281c3daf1677LL,
    0x3469cb6a74d3dfbdLL, 0xf04b0ca95cc8aaecLL, 0x1f55e2e844c12a70LL,
    0x4cb6cdc45ab78acbLL, 0xc05ca327e3918812LL, 0x95feda9da9285131LL,
    0xb966bcb0782d9ff3LL, 0xa7d647618934f714LL, 0xd61090cb7169ef73LL,
    0x71c6d7aaf85d1867LL, 0xecc4c50a329446d0LL, 0x6450cf0d4038b94aLL,
    0x420b536f6d99fcd5LL, 0x75b8b34e33d7e524LL, 0xc26391557cd40cc9LL,
    0xda923c12d9021db6LL, 0x4e89ffb6c5f20e10LL, 0x0919d104d6394d11LL,
    0x8aab3875ede97b41LL, 0xa88ec0f30bc2c39dLL, 0xb7db221b4f03e9edLL,
    0xc7f8ec880286b31dLL, 0x2f424d66fb98088eLL, 0xe04669d39affb415LL,
    0x3eaa3125887754e0LL, 0x5e849acc03c510e9LL, 0x8257f0488e0874c7LL,
    0xbd18d854b3a762b0LL, 0xb3a546ff848914aeLL, 0x9ce70b997f111c20LL,
    0x3c9503571732d03bLL, 0xe7e2267c7be88f1aLL, 0x63f480a2a12f8245LL,
    0x602eabe98bb24409LL, 0x941bc3a41cf013a6LL, 0x678ae4466aa57f06LL,
    0x1232570859729a22LL, 0x6d491e099601f45bLL, 0x5d5eb1872958d6a5LL,
    0x1473019e0dbde3baLL, 0xa24d3abcf76648c0LL, 0x85f3bfe76f1f4fc8LL,
    0x08fcc83d63e10f86LL, 0x745daa77860fa7b3LL, 0x9180be7962a2ac72LL,
    0x87cc8d95f05acb13LL, 0x78df06ae2e645576LL, 0x18f1ad47a5d6117fLL,
    0x358cd253c10b9d2aLL, 0x0ebd9eab372e761eLL, 0xf7ef4306bddf91e3LL,
    0x7023ce934d855af0LL, 0xd42fa2b9ee2c6ba8LL, 0x3656f918eb965b66LL,
    0x9d0212a0cac95eb7LL, 0x2ad930bb85cab75aLL, 0x862994ac45828984LL,
    0x7d447b735036eaa2LL, 0xb07f6db4ae14d2e2LL, 0x6b08489fc2ce8dc3LL,
    0x9b4344369e06272fLL, 0xad15bd2e75907c49LL, 0xdb77252b6cda5f21LL,
    0xea85939c665b3f48LL, 0xc945722335a8c503LL, 0x159618a7b865a12dLL,
    0x69377aed5d8b0918LL, 0x8971133ec774bd0dLL, 0x53e32f2c1e76a0bbLL,
    0xf8b7c4943f29a56aLL, 0xff138b3bde3e9e65LL},

   {0x7c6a2eb5fdabecc6LL,
    0x401cda0a752bbea0LL, 0x1925217156dc57c4LL, 0x56dec6d301d70787LL,
    0x41c751ff73c6ac58LL, 0xc9067697a92cb5f9LL, 0x3391c917aaa0bc85LL,
    0xae0a9a4c0e742afeLL, 0xaa8ca972162a62f4LL, 0x5aa193912935df99LL,
    0x86fd9135fe27e5baLL, 0xffca074b1d3f538eLL, 0x0e3cb65d24cdfc1bLL,
    0x4384b2e07fe9885dLL, 0xc73ac0ca8de149e2LL, 0x48e5bc7645972eb4LL,
    0xbe0d56b46ef9ffd6LL, 0x200e6d05c0ef5f50LL, 0xe1f17dee597f7abdLL,
    0x0243e31f0c2f2405LL, 0xf4ab09dd2741f567LL, 0xe4acc52547cc204fLL,
    0x348f92c3b83cc272LL, 0x53837e181f645d75LL, 0xd8da319acf4c7229LL,
    0x81e3cae1ecbb9b4dLL, 0xd6e687c7eb818e32LL, 0x3dad7f4a8e6d409eLL,
    0x28f70b79f053cf44LL, 0x493e3783437a3c4cLL, 0xb27203f6461b27c8LL,
    0xd02357e6fff0e23dLL, 0xe8d390676f2ef851LL, 0x26cbbd24d49e335fLL,
    0xee1640467b5f945eLL, 0x4aa65f6949b80ab1LL, 0xb56c58225487593fLL,
    0x4ffbe7a2570b5043LL, 0x0aba85633c93b411LL, 0x78ec1d8be5f5a4ccLL,
    0x501b16f215a66b88LL, 0x271036d1d27321a7LL, 0x7ff2465ff769da3bLL,
    0x35541936bed1d08aLL, 0xb8c886957a8893d9LL, 0x2fe950ade2cfb1b3LL,
    0xf90fd76a094e3f81LL, 0x2daab3b2eee095b6LL, 0x1abd499b5c1e6139LL,
    0x0c7f554228e2d81eLL, 0x425f391579049aa5LL, 0xc3bcf3f495bf01e8LL,
    0xb4b7d3d7526a4bc7LL, 0x0000000000000000LL, 0xa0362c112ab9d6e5LL,
    0x91e406198c364e65LL, 0x454162c16b98e452LL, 0x139fa4126a4fe3d5LL,
    0x01db8bf506ed12f8LL, 0x9a85088fb648e88cLL, 0x3ab3249e9cf13e69LL,
    0xd57eef2de143b8cfLL, 0xb1ea6b1c4cd91135LL, 0x7aaffe94e9da80c9LL,
    0xad92f2a604b61c03LL, 0xa3ae44fb207be018LL, 0xeb4bf88d65ecceacLL,
    0xc0249b1e9f7d3715LL, 0xa8cf4a6d1a0546f1LL, 0xc6e14b3f8b0c5b1aLL,
    0xce182d43bbb0cb0eLL, 0xfc526fa117fd6573LL, 0x8c471456c2b451abLL,
    0xac497953025b0efbLL, 0x0486333e185e480aLL, 0x18feaa845031453cLL,
    0xa1eda7e42c54c41dLL, 0x06c5d02114716c0fLL, 0x055db8cb1eb35af2LL,
    0xe5774ed0412132b7LL, 0x36cc71dcb413e677LL, 0x470281de67b7c057LL,
    0x58e2708e251afb9cLL, 0xa914c1981ce85409LL, 0xb3a9880340f63530LL,
    0x638adfe5bf06d70dLL, 0x0b610e963a7ea6e9LL, 0x927c6ef386f47898LL,
    0xed8e28ac719da2a3LL, 0x7548c33ccbfa6e2aLL, 0xf3b5520935dd8b90LL,
    0x8d9c9fa3c4594353LL, 0x31d22a08a68f9880LL, 0x0da4deb72e0fcae6LL,
    0x8fdf7cbcc8766756LL, 0x5dbfc8453ba9a16eLL, 0x8e04f749ce9b75aeLL,
    0x83a029fee094bf48LL, 0xa4b01f2f32e79eefLL, 0x1c7899ba486f0d36LL,
    0x654f0fc4ab77bb02LL, 0x7db1a540fb46fe3eLL, 0x51c09d07134b7970LL,
    0xcb459588a50391fcLL, 0x3fee9c558242649bLL, 0xfe118cbe1bd24176LL,
    0x76d0abd6c13858d7LL, 0x5e27a0af316b9793LL, 0x69305a868395631cLL,
    0x3b68af6b9a1c2c91LL, 0x6db669b89bcb2b16LL, 0xa72877c53825a812LL,
    0xd3bb3f0cf532d4c0LL, 0x6ff58aa797e40f13LL, 0x96fa5dcd9eaa3092LL,
    0x2c713847e80d874eLL, 0xc57923d581ce6de7LL, 0x2b6f6393fa91f9b9LL,
    0x0922ed89365182ecLL, 0x324a42e2ac4dae7dLL, 0x16c21cd974fcb927LL,
    0x956235279468066fLL, 0x7b747561ef379231LL, 0x449ae9346d75f6aaLL,
    0xf570822821ace79fLL, 0x5939fb7b23f7e964LL, 0x7937967ee318b634LL,
    0x84be722af208c1bfLL, 0x08f9667c30bc9014LL, 0xefcdcbb37db286a6LL,
    0xa6f3fc303ec8baeaLL, 0xea9073786301dc54LL, 0x62515410b9ebc5f5LL,
    0xd260b4f9f3dfc638LL, 0x9e033bb1ae16a086LL, 0x38f0c78190de1a6cLL,
    0xc267780193521310LL, 0x80384114ea5689b5LL, 0x9b5e837ab0a5fa74LL,
    0xf73361372d83c39aLL, 0x3009a1fda0628a78LL, 0xd4a564d8e7aeaa37LL,
    0xfb4c347505611b84LL, 0x5b7a18642fd8cd61LL, 0x239605efca2d69adLL,
    0xf8d45c9f0fa32d79LL, 0xbb50ee7f704aa524LL, 0x392b4c7496330894LL,
    0x0fe73da82220eee3LL, 0x3717fa29b2fef48fLL, 0xf26ed9fc33309968LL,
    0xd73d0c32ed6c9ccaLL, 0xda99d285c363562cLL, 0xde1fe1bbdb3d1e26LL,
    0x738d131ddf8b0225LL, 0x292c808cf6beddbcLL, 0xbc4eb5ab62d6dbd3LL,
    0x039868ea0ac236fdLL, 0xcc5bce5cb79fef0bLL, 0xb031e0e94a3403cdLL,
    0xc4a2a82087237f1fLL, 0xb72fbb3d58a87d3aLL, 0xafd111b908993806LL,
    0x68ebd173857871e4LL, 0x9d9b535ba4d4967bLL, 0xe9081b9269c3eaa9LL,
    0x71cef002d3a42620LL, 0x93a7e50680196a60LL, 0x891aac9ddc070b59LL,
    0x155a74337e3e8fdaLL, 0x4e206c5751e642bbLL, 0x9721d6389847226aLL,
    0x12442fe76ca2f12dLL, 0x2553d5cede5c05a2LL, 0xa275cf0e2696f2e0LL,
    0x24885e3bd8b1175aLL, 0x670cecdba7589f07LL, 0x749348c9cd177cd2LL,
    0x64948431ad9aa9faLL, 0x2ab4e866fc7ceb41LL, 0xe6ef263a4be3044aLL,
    0xe734adcf4d0e16b2LL, 0x903f8dec8adb5c9dLL, 0xf02d3ae33f1fbd6dLL,
    0x725698e8d96610ddLL, 0x1da3124f4e821fceLL, 0x1719972c7211abdfLL,
    0x11dc470d6660c7d0LL, 0xec55a3597770b05bLL, 0xbfd6dd416814ed2eLL,
    0x57054d26073a157fLL, 0x1e3b7aa544402933LL, 0x5ffc2b5a3786856bLL,
    0x61c93cfab329f308LL, 0x3e3517a084af7663LL, 0xf6e8eac22b6ed162LL,
    0x1007ccf8608dd528LL, 0x66d7672ea1b58dffLL, 0x8b594f82d0282f5cLL,
    0x1fe0f15042ad3bcbLL, 0x4b7dd49c4f551849LL, 0x4c638f485dc966beLL,
    0xcfc3a6b6bd5dd9f6LL, 0x46d90a2b615ad2afLL, 0x8565f9dff4e5d347LL,
    0x94b9bed292851497LL, 0xfa97bf80038c097cLL, 0xb9130d607c658121LL,
    0xdc5c02a4d7123a23LL, 0x224d8e1accc07b55LL, 0x87261ac0f8caf742LL,
    0xd901ba6fc9a160d1LL, 0xab57228710c7700cLL, 0x21d5e6f0c6024da8LL,
    0x98c6eb90ba67cc89LL, 0x827ba20be679adb0LL, 0x991d6065bc8ade71LL,
    0x5546ae390b15317aLL, 0xa56b94da340a8c17LL, 0x071e5bd4129c7ef7LL,
    0xe02af61b5f926845LL, 0x6b73b9998fba4719LL, 0xdfc46a4eddd00cdeLL,
    0x770b2023c7d54a2fLL, 0x7e29cdaaf184c8c3LL, 0xba8b658a76a7b7dcLL,
    0x9c40d8aea2398483LL, 0x9fd8b044a8fbb27eLL, 0xdb425970c58e44d4LL,
    0xe269150453bd4c40LL, 0x3c76f4bf88805266LL, 0xf1f6b11639f2af95LL,
    0x549d25cc0df82382LL, 0x4db804bd5b247446LL, 0x8a82c477d6c53da4LL,
    0x5258f5ed19894f8dLL, 0x6e2e015291091debLL, 0xc1ff10eb999025edLL,
    0xbd953e5e643bc92bLL, 0xc8ddfd62afc1a701LL, 0x5c6443b03d44b396LL,
    0x6c6de24d9d2639eeLL, 0x1481ffc678d39d22LL, 0xd1f8dc13f91df0c5LL,
    0xca9e1e7da3ee8304LL, 0xdd878951d1ff28dbLL, 0x6012b70fb5c4e1f0LL,
    0x1b66c26e5af373c1LL, 0xe3b29ef155505eb8LL, 0x70157bf7d54934d8LL,
    0x2e32db58e422a34bLL, 0x6aa8326c895755e1LL, 0xb6f430c85e456fc2LL,
    0xfd89e4541110778bLL, 0x88c12768daea19a1LL, 0xcd8045a9b172fdf3LL},

   {0x99183e616655b742LL, 0xb2872032a50d6860LL, 0x0946f63b060528efLL,
    0x36612b9a141ef07dLL, 0x0634da84dd49579bLL, 0xfc9c9e9b486c8a57LL,
    0xa63fe3c0744e6fd0LL, 0xf1515758d8b46bf9LL, 0x3e82559fcd5197ffLL,
    0x92e12d262bc40177LL, 0xc3bb433a5a7752c5LL, 0x21c3852a5183267aLL,
    0x39130725cf528f09LL, 0x9ba7db1d2dc12998LL, 0xc58f99be873e055eLL,
    0xd9d424498f32656cLL, 0x27f75fae8cca71e1LL, 0x59b91019a8fc3430LL,
    0xce768af9caafb36bLL, 0x9d930199f0887e03LL, 0x63b07a7ef3706a8eLL,
    0xb5167288a70e7096LL, 0x40cc1a28e967d22eLL, 0x4d01d3eb79bf3380LL,
    0x9e896cdb6456afb4LL, 0x2548bad2c75eef3bLL, 0xa79a6bfeab0420bdLL,
    0x9f2ce4e5bb1ce0d9LL, 0x32ea146282c3393cLL, 0x6d67defff7765a97LL,
    0x83775912b31080ebLL, 0xf5da68a04e69a2b8LL, 0x1196743498d4819cLL,
    0x0bf913474d91b635LL, 0x43d6776a7db90399LL, 0x444725d07fba1b6fLL,
    0x6584a0fa2e393d15LL, 0x3f27dda1121bd892LL, 0xf6c005e2dab7730fLL,
    0x56cb3ca673b04b44LL, 0x642128c4f1737278LL, 0xbf4ae9f135d589ceLL,
    0xb038c54eee99f6baLL, 0xf47fe09e9123edd5LL, 0x75b75cf069a7f3e4LL,
    0xd419ed8a1fea84c2LL, 0x73838674b4eea47fLL, 0x498aec13ef62fac1LL,
    0x20660d148ec96917LL, 0xa48006bc3fdaf10aLL, 0x2f1421ab55851663LL,
    0x0a5c9b7992dbf958LL, 0xd1375a4c567d02eeLL, 0x0000000000000000LL,
    0xc842507d17e6e4f0LL, 0xf3eeb2249320f523LL, 0xc9e7d843c8acab9dLL,
    0xff86f3d9dcb25be0LL, 0xb4b3fab678443ffbLL, 0xb19d4d7031d3b9d7LL,
    0x79df1d0d26355d27LL, 0x8eba90d123c86145LL, 0xaa57a23d3bdcc113LL,
    0xcb583d3f83383547LL, 0xd871ac7750782a01LL, 0xe162ab529f2aa508LL,
    0x38b68f1b1018c064LL, 0x237c60561a17b8a0LL, 0xa31154063dd9e9fcLL,
    0x713c6308ff7a3aa5LL, 0x1a6f6773d54537a9LL, 0x08e37e05d94f6782LL,
    0x357b46d880c021caLL, 0x6cc256c1283c15faLL, 0xcfd302c715e5fc06LL,
    0xbdf50c8d7e411714LL, 0x7cf1aacb6fa2db0bLL, 0x5240035ee56d8205LL,
    0x7b60f8716da1c3fdLL, 0x01a5883edf4a4f6dLL, 0xdd5f1bb119efac2dLL,
    0x5474d9da3824d59eLL, 0x0f722cbfdb4c7f74LL, 0x17a2aeb0459dd607LL,
    0x37c4a3a4cb54bf10LL, 0xc21ecb04853d1da8LL, 0x4273ff54a2f34cf4LL,
    0xdace490b1becb4dbLL, 0x6af68c45f5754261LL, 0x46f8c0ac342e85b5LL,
    0x854383966e59d770LL, 0x81c8bc6ef8841e31LL, 0x3bace25984c611d3LL,
    0x1033fc0a479ecef1LL, 0x1c5bbdf7080c6032LL, 0x7412d4ceb6edbc89LL,
    0xa8e8474170485fc9LL, 0xb8dbbb4b37d69138LL, 0x079152ba020318f6LL,
    0x72260e4a6ba4eb12LL, 0x905ec85a60509fadLL, 0x2dabc4d71e1188b9LL,
    0xd092d27289374d83LL, 0x610f9f02b8e4f454LL, 0x02bfe57c4b949edaLL,
    0x95707f9c29c71981LL, 0x6fd83b83bce2c44dLL, 0x5d322fe13e21fd71LL,
    0x34decee65f8a6ea7LL, 0xcd6ce7bb5e7162dcLL, 0xfb0dcc214a6f92a1LL,
    0x2eb1a9958acf590eLL, 0xdcfa938fc6a5e340LL, 0x669ecdb8bae7eca2LL,
    0x151d4bcc0e0948ddLL, 0xfd3916a59726c53aLL, 0x581c982777b67b5dLL,
    0x1bcaef4d0a0f78c4LL, 0xdfe0fecd527b32f7LL, 0x128c19760c0a502bLL,
    0x84e60ba8b113981dLL, 0x3c3db0e386c50925LL, 0x7febc789fb7c0abcLL,
    0x7d5422f5b0e89466LL, 0xd70380c88b345575LL, 0xbbc1d609a308408fLL,
    0xe278c6100bf474bfLL, 0x5e2842a3aaff2cc6LL, 0x6b53047b2a3f0d0cLL,
    0xf7658ddc05fd3c62LL, 0x9a025323f28b66f5LL, 0x8c0575ad685cff9fLL,
    0x76ad31b2fd792253LL, 0x68496939bee1dcbbLL, 0x7e4e4fb7243645d1LL,
    0xe44c1c94d6bd2324LL, 0xbeef61cfea9fc6a3LL, 0x91fb4064bf1ad0c0LL,
    0x052eb7c64997862cLL, 0x4a9081517bbc2b76LL, 0x8f1f18effc822e28LL,
    0x3a096a675b8c5ebeLL, 0xee1087ed4466da7cLL, 0x2652d79053803e8cLL,
    0x7099eb36203075c8LL, 0xc7307cc2ccaa9b84LL, 0x5c97a7dfe16bb21cLL,
    0x50ffe622aef91cdfLL, 0x8da0fd93b716b0f2LL, 0x69ece10761ab93d6LL,
    0x31f07920161de88bLL, 0x13299148d3401f46LL, 0x031a6d4294ded1b7LL,
    0xccc96f85813b2db1LL, 0x14b8c3f2d14307b0LL, 0x8659eed4fa8706c7LL,
    0xba645e377c420fe2LL, 0x2920fb2f88cc41f8LL, 0x87fc66ea25cd49aaLL,
    0x1ee4588b4398fee8LL, 0xecaf62910ff244a6LL, 0xf817a163deb14316LL,
    0x45e2adeea0f05402LL, 0x806d345027ce515cLL, 0x576eb498acfa0429LL,
    0xa5258e82e090be67LL, 0x892bc26b21cb79b3LL, 0x6e7db3bd63a88b20LL,
    0x4e1bbea9ed61e237LL, 0xadc6f08739dfd9e5LL, 0x8b9427176a5fe769LL,
    0xa1aeb17a764d7726LL, 0x4b35096fa4f6641bLL, 0x22d9e868c55df7cdLL,
    0x55d151e4e76e9af3LL, 0x966a12debd19c836LL, 0x0dcdc9c390d8e1aeLL,
    0xf24b3a1a4c6aba4eLL, 0x24ed32ec1814a056LL, 0xaf7915fb724b473fLL,
    0x2885731157860e95LL, 0x9c3689a72fc2316eLL, 0x475d4892eb64cad8LL,
    0xac6378b9e6959688LL, 0xa00b3944a907384bLL, 0xc695f4fc13e0d4e9LL,
    0x3055f11ec957a7e6LL, 0x6215f2402c3a25e3LL, 0xde4576f38d317d9aLL,
    0x9344a518f48e4e1aLL, 0x82d2d12c6c5acf86LL, 0xefb50fd39b2c9511LL,
    0xe981d5574665c28aLL, 0x5f8dca9d75b563abLL, 0xb60c1fca33d0a121LL,
    0xfe237be703f8148dLL, 0xd6a608f6547e1a18LL, 0xb97e3375e89cde55LL,
    0xd388bf301de99c34LL, 0x5b06f565e368aaeaLL, 0xf0f4df6607fe2494LL,
    0x1607268e9ad7996aLL, 0xaedc9dc5ad010852LL, 0xe0c7236c4060ea65LL,
    0xea9bb815d2bb133dLL, 0x888e4a55fe8136deLL, 0x5aa37d5b3c22e587LL,
    0xc104a64611e3cc1fLL, 0x515a6e1c71b353b2LL, 0xc42a118058744a33LL,
    0x7708b98c22336d3eLL, 0x2a3a966d1c12904fLL, 0x8a31af29b515a804LL,
    0xed0aeaafd0b80bcbLL, 0x2c0e4ce9c15bc7d4LL, 0x0c6841fd4f92aec3LL,
    0x98bdb65fb91ff82fLL, 0x1f41d0b59cd2b185LL, 0xb322a80c7a47270dLL,
    0xe6f3f9e89d29bdfeLL, 0x7ac5704fb2eb8c90LL, 0xa94dcf7faf0210a4LL,
    0x787a9533f97f124aLL, 0xdb6bc135c4a6fbb6LL, 0x048b3ff896ddc941LL,
    0xe8245d69992f8de7LL, 0xe3dd4e2ed4be3bd2LL, 0xcafdb5015c727a2aLL,
    0xb7a997f4ec9aee4cLL, 0xe75671d64263f293LL, 0x2b9f1e53c358df22LL,
    0x18d0820f9ed1a973LL, 0xabf22a03e4968e7eLL, 0xa2b4dc38e293a691LL,
    0x673b458665ada3cfLL, 0xf9b2295d01fb0c7bLL, 0xd22d370ec2a3d359LL,
    0x97cf9ae06253875bLL, 0x0ed7a48104063019LL, 0x482f642d3028b5acLL,
    0xc0a12e78cea98372LL, 0x4fbe3697322bad5aLL, 0x19750a31419be61eLL,
    0x41699216362d9d43LL, 0xd5bc65b4c0a0cbafLL, 0xe5e994aa09f76c49LL,
    0xeb3e302b0df15c50LL, 0x94d5f7a2f68d56ecLL, 0x53e58b603a27cd68LL,
    0x3d9838dd598f4648LL, 0x60aa173c67aebb39LL, 0x1dfe35c9d7462f5fLL,
    0x4ca45bd5a6f57cedLL, 0xbc5084b3a10b5879LL, 0xfaa8441f9525ddccLL,
    0x334f9c5c5d897651LL},

   {0xda1687a883adf27eLL, 0xe35c9378578d9f22LL,
    0x303ca4531637fa40LL, 0xa088321f74b20375LL, 0xc9863f3a9acb95e9LL,
    0x5fcf47c57d0b0ed4LL, 0x4aa211e4e1280b4bLL, 0xe1a4c9ba871d1289LL,
    0x4926664759f03a4fLL, 0xadfb36ede3707bcaLL, 0xcf7bd1891f8ef7e1LL,
    0x9735559e8f882792LL, 0x5932a976f84e6cdcLL, 0x9dc792bef547818aLL,
    0x06fdeeb385456208LL, 0x46ad38771ea2cf5bLL, 0x5eb36aa41543b27bLL,
    0x8b2eb33cd1bcb511LL, 0x71105ff6e598ebbcLL, 0x5441ad846f8c1463LL,
    0x4c5fff57646d6943LL, 0xf3485c49f633c9b1LL, 0x9cbbbfdf9d0f3d25LL,
    0x22d031a067192178LL, 0xca0248992213a4edLL, 0x19627fb263a9c18fLL,
    0x9330e1efda5dc831LL, 0x1390b89219666797LL, 0x2edf18339893e568LL,
    0x6c779435d3e4c590LL, 0x53c06e568281cac4LL, 0x6ff3e3966b3cf494LL,
    0xfe3b58bb61f1b10eLL, 0x77edb14560dd89b4LL, 0x02f85ac2d0908dabLL,
    0x12ec95f3712edb38LL, 0x85d9c06dfea6fcaaLL, 0x90b4964c6285f935LL,
    0xf1b0068b26a3441aLL, 0x729428555d40dab8LL, 0x5c4b3066c5d33fd0LL,
    0x5d371d07ad9b837fLL, 0xa48d866e2167ecd6LL, 0xb661139d504937eeLL,
    0xa27068dda4228edeLL, 0xf8c6b608e4b4d306LL, 0x6bf657e73ee91b37LL,
    0xac871b8c8b38c765LL, 0x4ea7a595b4fde4e8LL, 0x0d7304f297c278bfLL,
    0xb71d3efc38018b41LL, 0xae7f414e5ba84aceLL, 0xaf036c2f33e0f661LL,
    0x0000000000000000LL, 0xb89660cc7f537e55LL, 0xa675dcacf1f7617dLL,
    0x610490c74426bd2fLL, 0xc18ca2d83094be5aLL, 0x2adaac42cd460acbLL,
    0x7d1f76651a122facLL, 0xc58916a9654151f9LL, 0xedabe0297897d699LL,
    0x2d5b6f90204bd46cLL, 0x26d585d132cccedbLL, 0x9f3fc87c25d70c21LL,
    0xc60d610add9960fdLL, 0x80a0597dc33bafa6LL, 0xd0e44088f9625466LL,
    0x1d67cbc3367c2e2cLL, 0x2c2742f1480368c3LL, 0x89d6e9fe012c38baLL,
    0xe9ae54582d42393aLL, 0x3ecbd702392db3fbLL, 0xb5e5643ee89106eaLL,
    0xa882affddeed28c6LL, 0x1ae60811db71f08bLL, 0x924ccc8eb215749eLL,
    0xfcc30279b1613ca5LL, 0x825803bf13ab220dLL, 0xd992f00b3b75c37aLL,
    0xc8fa125bf2832946LL, 0x35453d432baaa94cLL, 0xf9ba9b698cfc6fa9LL,
    0x37bd6781fb3a24e7LL, 0x791ac2144fc7c00fLL, 0x16e9218224fb349bLL,
    0xdb6aaac9ebe54ed1LL, 0xd8eedd6a533d7fd5LL, 0x7c635b04725a9303LL,
    0x553d80e507c4a8ccLL, 0x9a46516c184a5f2dLL, 0x14117b40f46bb930LL,
    0x1ee3bc608ea41f28LL, 0x27a9a8b05a847274LL, 0x4050d6c49be7ad53LL,
    0x7be298d69f574da4LL, 0x6a8a7a8656a1a798LL, 0x4d23d2360c25d5ecLL,
    0x1014cf31a1be5693LL, 0xb264a7ec059cd84dLL, 0xea2a23fb959a083eLL,
    0xf0cc2bea4eebf8b5LL, 0x76919c240895351bLL, 0x0b8eea4112871ab7LL,
    0x47d1151676ea73f4LL, 0xbdeff9dc42ce2d59LL, 0x2ba68123a50eb664LL,
    0x057999103d9d530cLL, 0xe759270902587081LL, 0xef53baeba8075b32LL,
    0x4fdb88f4dcb55847LL, 0x6e8fcef70374483bLL, 0x1168e250c9f6ea3cLL,
    0x1b9a2570b3394c24LL, 0x706c72978dd05713LL, 0x865db7ce467ecdaeLL,
    0x52bc4337eac9766bLL, 0x504419f53a59fbc0LL, 0x8f2b074d84695ab2LL,
    0x6078bda62c6e0180LL, 0x43d4a167233f9c57LL, 0x0ef773512f1a49bbLL,
    0x0c0f2993ff8ac410LL, 0x4bde3c858960b7e4LL, 0x66855315a92b6388LL,
    0xd360372b41ba6562LL, 0x584e84179006d073LL, 0x9b3a7c0d7002e382LL,
    0xa5f1ab0f492f5079LL, 0x2822f6801dd68760LL, 0x445562b5ce3242f0LL,
    0xaa7af53f0e7da56dLL, 0x3c338dc0e9bd3e50LL, 0x3bb24e1204b0e0f7LL,
    0xd59dd998c4ff076aLL, 0x91c8bb2d0acd459aLL, 0x84a5ed0c96ee4005LL,
    0x33b8d3f0aeefcb44LL, 0x57c5da27d7542567LL, 0x32c4fe91c6a777ebLL,
    0x3439102243e215e3LL, 0xc7714c6bb5d1dc52LL, 0x3fb7fa6351650f54LL,
    0x87219aaf2e367101LL, 0xf5b5b2fa7376abb9LL, 0x412cfba5f3af11fcLL,
    0xdceb691b06e89076LL, 0xbb12176fc78b4f51LL, 0x73e8053435086617LL,
    0xe220be193fc5238dLL, 0xb09cfd2ed50c55e6LL, 0xb9ea4dad171bc2faLL,
    0x9e43e51d4d9fb08eLL, 0x36c14ae093729848LL, 0xa9fe829cb6a59469LL,
    0x0405b47155d5efa3LL, 0x0af2c7207acfa618LL, 0x7e9b01c6a2ca1ea8LL,
    0xdd97447a6ea02cd9LL, 0x0781c3d2ed0ddea7LL, 0x7866ef75278f7ca0LL,
    0xd1986de9912ae8c9LL, 0xcb7e65f84a5b1842LL, 0xcd838b4bcf1e7a4aLL,
    0xab06d85e663519c2LL, 0xd4e1f4f9acb7bbc5LL, 0xfdbf2f18d929800aLL,
    0xf23471289e7b751eLL, 0xbc93d4bd2a8691f6LL, 0x3d4fa0a181f582ffLL,
    0xba6e3a0eafc3f3feLL, 0x5ab6ded540965dd8LL, 0xeb560e9afdd2b491LL,
    0x0976b083c217971cLL, 0xecd7cd4810df6a36LL, 0x23ac1cc10f519dd7LL,
    0xbe6b8e7ffa161c5dLL, 0x7fe72ca7ca82a207LL, 0xc0f08fb958dc02f5LL,
    0x7a9eb5b7f71ff10bLL, 0xa709f1cd99bfddd2LL, 0x8dd35d8f54f9d719LL,
    0x8caf70ee3cb16bb6LL, 0xe4dd50aaba804185LL, 0x83242ede7be39ea2LL,
    0x98be0baec8dad286LL, 0x690e0d25ee79969cLL, 0x95cd0f5c5f18aa39LL,
    0x56b9f746bf1c99c8LL, 0x7469c6e6d805b8b0LL, 0x8a529e5db9f409beLL,
    0xe6250a686a10cc2eLL, 0x2fa33552f0db59c7LL, 0x42a88c064b7720f8LL,
    0x6d0bb954bbac793fLL, 0x181e52d30be17d20LL, 0xbf17a31e925ea0f2LL,
    0x94b1223d37501696LL, 0xe8d27939450a8595LL, 0xccffa62aa756c6e5LL,
    0x383639b1bc68d1f3LL, 0xee2f978ac04fe79dLL, 0xa30c45bccc6a3271LL,
    0x1f9f9101e6eca387LL, 0xb1e0d04fbd44e949LL, 0x242ddf13e25c4370LL,
    0x156d56219c23059fLL, 0x88aac49f69648415LL, 0x6280e764fcfe8c2bLL,
    0xdf6f1eb8be30a172LL, 0xe5a17dcbd2c8fd2aLL, 0xe0d8e4dbef55ae26LL,
    0x63fcca0594b63084LL, 0xa1f41f7e1cfabfdaLL, 0x295edbe1759e3bcfLL,
    0x67f97e74c163df27LL, 0x038477a3b8d83104LL, 0xde1333d9d6781dddLL,
    0x3ace63736cf85c58LL, 0xd619ae3b7c27366eLL, 0x5bcaf3b428dee177LL,
    0xb3188a8d6dd464e2LL, 0x1c1be6a25e349283LL, 0x017c2d616848bcafLL,
    0x8e572a2cec21e61dLL, 0xf631c559cbae9abdLL, 0x81dc741cab731309LL,
    0xff4775da09b90da1LL, 0xb499495f80d9ba45LL, 0x0f8b5e304752f514LL,
    0x394a14d0d4206d5cLL, 0xce07fce877c64b4eLL, 0xf4c99f9b1b3e1716LL,
    0xc4f53bc80d09ed56LL, 0xc208d57b884c8f5eLL, 0x080a9de2aa5f2bb3LL,
    0x314089327e7f46efLL, 0xfa3eecca34245eadLL, 0x20286b62b789acd3LL,
    0x7515eb87b04d041fLL, 0x513834945211476fLL, 0x650124b611f3528cLL,
    0x17950ce34cb38834LL, 0x45294fd4a67afe5fLL, 0x21544603dfc1107cLL,
    0x485a4b2631b886e0LL, 0x6872204486312a33LL, 0x647d09d779bbee23LL,
    0x2551f2728a14ffdfLL, 0xd765835a146f8ac1LL, 0xd21c1a4a29f2d9cdLL,
    0x99c226cfa0926e29LL, 0xfb42c1ab5c6ce202LL, 0xc374f81ae00433f1LL,
    0x964978ffe7c09b3dLL, 0xf74de838a3e62612LL},

   {0x74b87b36b0592c6aLL,
    0x3d82d75dffb4b81cLL, 0x8884246715267825LL, 0xdaf2d8a77ed4e5deLL,
    0xfeb118650e53f9c7LL, 0xbd2d1aea59226b06LL, 0x26ce87f6dbabb191LL,
    0x32772ecbeb66bd0aLL, 0xd4bbf82bc5104c8cLL, 0x055357720c4e03a1LL,
    0xef5be62a32d0f6fdLL, 0xbe1c84c45d186acaLL, 0xacc7e4a565a1643cLL,
    0x8dd7731519687b84LL, 0x11eafe4f3c830f3aLL, 0x04ef8e68a358afe5LL,
    0x40ad9ca1534b930dLL, 0xe44191d4855a5c0eLL, 0x6001d20b809420f1LL,
    0x73666b70173b8243LL, 0x372479b9e728beabLL, 0x45fecbd35f0590acLL,
    0x7057f55e1301838fLL, 0xff0dc17fa1455583LL, 0x0cc467b810e804daLL,
    0xb9c29482fa7ac4e3LL, 0xa003831d754960e6LL, 0x8a096353be0ad5adLL,
    0xdd2cc8e1d9b64bf7LL, 0xc7dc415052bfee3eLL, 0x9f0c137421d17572LL,
    0x35a93e8d4c041323LL, 0x9a5f44062d9f76d3LL, 0x71eb2c44bc172fcbLL,
    0x0ff5f99614d20516LL, 0x7789e518b4632da6LL, 0xc99561dce97b476cLL,
    0x5276fcc06bf29dfbLL, 0x4a0b32454bd795baLL, 0x9274add69e2fddecLL,
    0x4f5865374799961bLL, 0xb2d8e37c4df06e10LL, 0xc4eddf7e5685eff2LL,
    0xb3643a66e2e6c254LL, 0xd50721316a06e0c8LL, 0x8bb5ba49111c79e9LL,
    0x2bb639546455190fLL, 0xf8d3d1390627fbaaLL, 0x38d1802ff3fabbbdLL,
    0xdfa18fd5729ae67fLL, 0x4ee4bc2de88f3a5fLL, 0xf72628af12f5febcLL,
    0x0aa6aee4189c06b7LL, 0x0000000000000000LL, 0x9eb0ca6e8ec7d936LL,
    0xcb1826e84257eae4LL, 0x187dce8520250841LL, 0xc28f16225ef1ed9fLL,
    0xc333cf38f1e741dbLL, 0x4220db95f8673e85LL, 0xdc9011fb76a0e7b3LL,
    0x105627559395a37eLL, 0x2f59b73cc70db6eaLL, 0xe112c6a689145fafLL,
    0x82228a830dba7e92LL, 0x2ee56e26681b1aaeLL, 0x2a0ae04ecb43b54bLL,
    0x47738ce7f4293d24LL, 0xa7dd935bd22bcecfLL, 0xd2d93177cd644ee1LL,
    0xebb4684291885918LL, 0x0e49208cbbc4a952LL, 0xa550d46f79076347LL,
    0x411145bbfc5d3f49LL, 0xe6ccd6e02e76f186LL, 0x4bb7eb5fe4c139feLL,
    0x5d8305567f2098edLL, 0x95aabd90394d73c5LL, 0x25ff19d8df91b05dLL,
    0x86cd04ebaee2d177LL, 0x03319e2e043a01ccLL, 0x6b1ba5f5371e8a02LL,
    0x76353c021b7581e2LL, 0x64ee5c6323cc8f14LL, 0x5c3fdc4cd03634a9LL,
    0x6996e2c19c32278aLL, 0x8938fd7dba30d461LL, 0x7b4d82a0a48b297cLL,
    0xbfa05ddef20ec68eLL, 0x8ee6ed3b1d527a48LL, 0x61bd0b112f828cb5LL,
    0x66631b5788e0229cLL, 0x55a8ec86cc9033d2LL, 0x1c9240ed837da7a4LL,
    0x150570279fdba0dfLL, 0x53ca25dac4e431bfLL, 0xd636bf1f6e3ce104LL,
    0xcaa4fff2ed4146a0LL, 0x787c1c8ea0b128b0LL, 0xad7b3dbfcab7c878LL,
    0xfc3c5f51a57f544fLL, 0xb78bb40e41be6db1LL, 0x8c6baa0fb67ed7c0LL,
    0xce4b719a4e19e945LL, 0xf96f0823a93157eeLL, 0x7d2f4bfcacff2b11LL,
    0x3eb34973fb8eb9d0LL, 0xe39f81922238f227LL, 0x239dd084d7e5b230LL,
    0x1fa3dec38747a668LL, 0xc5510664f99343b6LL, 0xc829b8c6466deb28LL,
    0x85fc9ac5aad8d0bbLL, 0xb6376d14eea8c1f5LL, 0x9d8154408afdd8faLL,
    0x3be01e01f7c0ba71LL, 0x628c953f2bb88d79LL, 0x6d796ca93f6a886fLL,
    0xfa5e960dad0b5622LL, 0xe5fd48ce2a4cf04aLL, 0xe7700ffa81605dc2LL,
    0x2dd4f0086c211b62LL, 0x2221099e78f31e74LL, 0xdb4e01bdd1c2499aLL,
    0xf417b68116cfff70LL, 0xb506f33aea92c039LL, 0x514762ee6fc89c37LL,
    0x9c3d8d5a25eb74beLL, 0x396d59355cec17f9LL, 0xccc636aee53544cdLL,
    0x0b1a77feb78aaaf3LL, 0xe9392f763aa4f490LL, 0xaaa52df96dd56651LL,
    0x46cf55fd5b3f9160LL, 0xa4ec0d75d611cf03LL, 0xaff67a8b619b65f0LL,
    0x3415e797e312bf67LL, 0x7af15bba0b9d8538LL, 0x811314ad09807f5eLL,
    0x8771ddf101f47d33LL, 0x969b23be3d777209LL, 0xd365e86d6272e2a5LL,
    0x58d05224736e9b4cLL, 0xc660984afda9427aLL, 0x5414359c63869f96LL,
    0xe885f66c95b258d4LL, 0x655285798cda2350LL, 0x6cc5b5b3907c242bLL,
    0x6ff42b9d944625e7LL, 0xc0025116f5dd4017LL, 0xa28ec429de65cd6eLL,
    0x63304c2584ae213dLL, 0x7fa20cc807d38699LL, 0x996eda2829a5771fLL,
    0x1b4c50ab241f098dLL, 0x1e1f07d928510a2cLL, 0x33cbf7d14470114eLL,
    0xb055a448e6dcc398LL, 0x98d2033286b3db5bLL, 0xec6a780436eaf731LL,
    0xa1bf5a07da5fcca2LL, 0xbaf30aacfe40c52fLL, 0xf144e1f31a81fcd1LL,
    0xe0ae1fbc2602f3ebLL, 0x14b9a93d30cd0c9bLL, 0x596c8b3edc783708LL,
    0x682a3bdb33248bceLL, 0xb87e4d98556c68a7LL, 0x80afcdb7a696d31aLL,
    0x5725abb267bc9e5aLL, 0x914533f89a15dc20LL, 0x5eb29b787b1a9921LL,
    0x01bcd91aaf16ac44LL, 0xc1be880c5acbec53LL, 0xedd6a11e99fc5b75LL,
    0x028d4734ab2cad88LL, 0x8f5a3421b244d60cLL, 0x4dd52203ecb53b93LL,
    0x3f0f906954981594LL, 0xae4aa391ce8dc9b4LL, 0x3698a0a3483e12efLL,
    0xf5ab6f9bb9d95334LL, 0x082be9d0b3b0ab3fLL, 0xd1e8af59c95e4f2dLL,
    0xd87f9f93d5f84856LL, 0x6e48f2873b5089a3LL, 0x2443c0c270871c19LL,
    0xb1e97d5249ca6fdcLL, 0x7c9392e603e98755LL, 0x839e5399a2acd2d6LL,
    0x19c1179f8f33a405LL, 0xde1d56cfdd8c4a3bLL, 0x20ac4eaad3dfb3fcLL,
    0x1af089b18b09a5c9LL, 0x3a5cc71b58d61635LL, 0x444212c9f0133ce8LL,
    0x72dab26ab82d2e07LL, 0x4c69fb1943a397d7LL, 0xf3c9a6c7b1ad5159LL,
    0x1d2e99f72c6b0be0LL, 0xb4ba2a2045846c7dLL, 0xe22358888d2e5e63LL,
    0x2887a77a606f18c3LL, 0xa8286acdc6f9cbd9LL, 0x5f0e4262d40c3565LL,
    0xeee73f309dc65ab9LL, 0x9be39d1c8289da97LL, 0x1634ee099be1a113LL,
    0xea08b1583e9ef55cLL, 0x9727faa49261de4dLL, 0x2c682912c337b726LL,
    0xcff7a880e10f4501LL, 0x1788371334f70d57LL, 0x27725eec74bd1dd5LL,
    0x3146b0e5ef5cbcc6LL, 0x099730ca1ca6077bLL, 0xf2757fdd1ebbfd1dLL,
    0x6aa77cef98082646LL, 0xbb4fd3b65156696bLL, 0x569972a8c8aa321eLL,
    0xa3321d337173612aLL, 0x50fbbbf4c0de3073LL, 0x5a5d1510d84236c4LL,
    0xfd80864b0a69f80bLL, 0x07de1046a762ae29LL, 0xa6614a417d3d628bLL,
    0xd78a6605c12a4d40LL, 0x67dfc24d27f68ed8LL, 0xbc91c3f0f634c742LL,
    0xd05476436648e369LL, 0x493aac6b4fed9476LL, 0x12db606138b90ef6LL,
    0xa994b3d769ef679dLL, 0x211097b07cc91fb8LL, 0x30fa69ff404a1082LL,
    0x3c3e0e4750a21458LL, 0x7504a22c1f4f802eLL, 0x844043df05ce7cffLL,
    0xf0f838e9b5975095LL, 0x7e1ed5d2a8c52addLL, 0x90f9eae235037064LL,
    0x0662c95c0874026dLL, 0x9416648a965bdf81LL, 0xf69af1b5bde352f8LL,
    0x0d78bea2bffea89eLL, 0x293b7e60cf79b487LL, 0xd9c346897aeee412LL,
    0xfbe24f17021dfa66LL, 0x1367b97b97afa2b2LL, 0xab19f4e3c2c3ca15LL,
    0x48867571e0fb3832LL, 0x93c874cc313971a8LL, 0x79c0c5940fa784f4LL,
    0xcd7aefb44a23e889LL, 0x439c028f577192c1LL, 0x5be1cc0a77549a80LL},

   {0x714d28d778656928LL, 0xc88a7c6b84f64f7cLL, 0xec43cac5ab89aacaLL,
    0x777fa38110dc16a3LL, 0x0f7d5c87e4213b5cLL, 0x73f051e5f3a1ef51LL,
    0xea714193c330d541LL, 0x95e5f3dae016c4f3LL, 0x63d3738095a0e173LL,
    0x9825d66f8ff379d6LL, 0xe8cc38a148f45338LL, 0xa840b0c025f06bb0LL,
    0x944135c35f748735LL, 0x74661caa247ad31cLL, 0xe7b16426acd56864LL,
    0xd1e689df6e6f0589LL, 0xa73dec47c1d150ecLL, 0x64453ecf427bdd3eLL,
    0x0ed99a9e5b43789aLL, 0x7b1b402dc05be840LL, 0x0dc025b56fe5bd25LL,
    0x3f183a284e22293aLL, 0xa0aba108160a6ca1LL, 0x46be033705bd4703LL,
    0x86df6e94b2b10f6eLL, 0xa216d83a9dceead8LL, 0x129e5b57edc5885bLL,
    0x7e3074509c445274LL, 0x7d29cb7ba8e297cbLL, 0x1611a9330eb871a9LL,
    0x486799a95efe3f99LL, 0x9fb39b205828459bLL, 0xd0424fc6d10d464fLL,
    0xe968feb8f79610feLL, 0x5d6f8fb164e08b8fLL, 0xaafdc9f2ae34edc9LL,
    0x02bd79328bc48679LL, 0x9b3c6944bb55bc69LL, 0x6277b5992ac2a2b5LL,
    0x877ba88d0dd34ca8LL, 0xfa5263f6a531db63LL, 0x2e9fde54974164deLL,
    0xcda14816d8e9f548LL, 0x675c81e476dd1881LL, 0x2a102c30743c9d2cLL,
    0x37f32be07dd82e2bLL, 0x256d70b7901da670LL, 0x4ce86bcdbd83c66bLL,
    0x50afaa040b0536aaLL, 0xef5a75ee9f2f6f75LL, 0xb3913c4644ada73cLL,
    0x1187e47cd9634de4LL, 0xc54a59deeb13f259LL, 0x0000000000000000LL,
    0x01a4c619bf6243c6LL, 0x90cec7a7bc097ec7LL, 0xf94bdcdd91971edcLL,
    0x8e347f5c814b087fLL, 0xc7f720ec60d77420LL, 0x354e52d2f61ca852LL,
    0x34ea94cb497eeb94LL, 0xae723b964d49143bLL, 0xf48bf968fe72a3f9LL,
    0xfc60e8a0cd88a4e8LL, 0x2909931b409a5893LL, 0xbd48a6d81feedfa6LL,
    0x6cae2f077181da2fLL, 0xad6b84bd79efd184LL, 0x18c833ad55fb0933LL,
    0x204644cacc021c44LL, 0x392ab17e269b56b1LL, 0x14acd001857cf7d0LL,
    0x8abb8d386236f18dLL, 0xeefeb3f7204d2cb3LL, 0xf636805a75b62580LL,
    0x2bb4ea29cb5edeeaLL, 0xc653e6f5dfb537e6LL, 0x8d2dc077b5edcdc0LL,
    0x31c1a0b6156151a0LL, 0xf8ef1ac42ef55d1aLL, 0xdbb0e125d65184e1LL,
    0x82509cf051ccf69cLL, 0xe33e96424fa89196LL, 0xdf3f1341352c7d13LL,
    0x8f90b9453e294bb9LL, 0x1023226566010e22LL, 0xa58095754a15d695LL,
    0x2c22a7661c85e2a7LL, 0xe183ef70c46c17efLL, 0xafd6fd8ff22b57fdLL,
    0x471ac52ebadf04c5LL, 0x4d4cadd402e185adLL, 0x916a01be036b3d01LL,
    0x28ad5502fff81b55LL, 0x3657edf9c2ba6dedLL, 0xd2ff36f45ac9c036LL,
    0xf1a0cd15a26d19cdLL, 0xd90d98175d950298LL, 0xf7924643cad46646LL,
    0xdd826a73bee8fb6aLL, 0x9d0ee212d3ecc3e2LL, 0xb6ba083b18b21d08LL,
    0x3da5431ac5e6af43LL, 0x08eb11c833fa0711LL, 0x052b347d5c1fba34LL,
    0x6fb7902c45271f90LL, 0x133a9d4e52a7cb9dLL, 0x6e135635fa455c56LL,
    0x725497fc4cc3ac97LL, 0xf31db42729a99fb4LL, 0x846217a639758917LL,
    0x4b7e26826a58fa26LL, 0x235ffbe1f8a4d9fbLL, 0xff79578bf92e6157LL,
    0xda14273c6933c727LL, 0x8b1f4b21dd54b24bLL, 0x9caa240b6c8e8024LL,
    0xc1c5abba086e0babLL, 0xde9bd5588a4e3ed5LL, 0x2d86617fa3e7a161LL,
    0xbff5dfea942a59dfLL, 0x66f847fdc9bf5b47LL, 0x3b97c84cad5fd0c8LL,
    0x3ebcfc31f1406afcLL, 0xca3705590f32c905LL, 0x24c9b6ae2f7fe5b6LL,
    0x408c88616d043888LL, 0x93d7788c88afbb78LL, 0x196cf5b4ea994af5LL,
    0x9a98af5d0437ffafLL, 0x8c89066e0a8f8e06LL, 0xab590feb1156ae0fLL,
    0xd7d4028906d67a02LL, 0xe4a8db0d9873addbLL, 0xc378d28883aa8dd2LL,
    0x4ff1d4e6892503d4LL, 0xd670c490b9b439c4LL, 0x65e1f8d6fd199ef8LL,
    0xf2b9723e96cbdc72LL, 0xb12c4574cf692145LL, 0x569d215263bc4921LL,
    0x69851b7a2d9e601bLL, 0x5e76309a50464e30LL, 0x5fd2f683ef240df6LL,
    0xd8a95e0ee2f7415eLL, 0xe29a505bf0cad250LL, 0x96fc4cf1d4b0014cLL,
    0x8806f40ae9f277f4LL, 0x53b6152f3fa3f315LL, 0x1c47c1c9b686f0c1LL,
    0x80ede5c2da0870e5LL, 0xd5697bbb8d12fc7bLL, 0xfdc42eb972eae72eLL,
    0x0bf2aee3075cc2aeLL, 0x22fb3df847c69a3dLL, 0xbadeeb97c835e3ebLL,
    0xdc26ac6a018ab8acLL, 0xbcec60c1a08c9c60LL, 0x4231f153e6c0bef1LL,
    0x337cd9849ea5d7d9LL, 0x5b5d04e70c59f404LL, 0x79a6391f4b9f6e39LL,
    0x5212d33680c1b0d3LL, 0xb5a3b7102c14d8b7LL, 0x7f94b249232611b2LL,
    0x17b56f2ab1da326fLL, 0x59e07dd5879d727dLL, 0xebd5878a7c529687LL,
    0xbb7a2d8e7757a02dLL, 0x0319bf2b34a6c5bfLL, 0x5ccb49a8db82c849LL,
    0x1de307d009e4b307LL, 0x49c35fb0e19c7c5fLL, 0x55849e79571a8c9eLL,
    0x7abf86347f39ab86LL, 0x9273be9537cdf8beLL, 0xe615a23f13b72ba2LL,
    0x6821dd6392fc23ddLL, 0x5af9c2feb33bb7c2LL, 0x06328b5668b97f8bLL,
    0x44037a058e79c17aLL, 0x83f45ae9eeaeb55aLL, 0x5739e74bdcde0ae7LL,
    0xfbf6a5ef1a5398a5LL, 0xe50c1d142711ee1dLL, 0x1a754a9fde3f8f4aLL,
    0x7802ff06f4fd2dffLL, 0xf52f3f714110e03fLL, 0x2674cf9ca4bb63cfLL,
    0x60caccaba10624ccLL, 0xb088836d700b6283LL, 0xa6992a5e7eb3132aLL,
    0xa9e476d99a922876LL, 0x6b386248a65ae662LL, 0xc2dc14913cc8ce14LL,
    0x76db6598afbe5565LL, 0x32d81f9d21c7941fLL, 0x21e282d373605f82LL,
    0xc0616da3b70c486dLL, 0x616e0ab21e64670aLL, 0x6d0ae91ecee399e9LL,
    0x27d009851bd92009LL, 0xfedd9192464c2291LL, 0x45a7bc1c311b82bcLL,
    0x54205860e878cf58LL, 0xa10f6711a9682f67LL, 0x9981107630913a10LL,
    0xede70cdc14ebe90cLL, 0x70e9eecec7072aeeLL, 0x1f5e7ee28220357eLL,
    0x2f3b184d28232718LL, 0x41284e78d2667b4eLL, 0xa424536cf5779553LL,
    0xa3b21e2322aca91eLL, 0x4e5512ff36474012LL, 0x1efab8fb3d4276b8LL,
    0x89a2321356903432LL, 0xcb93c340b0508ac3LL, 0x306566afaa031266LL,
    0x4adae09bd53ab9e0LL, 0xc92eba723b940cbaLL, 0x094fd7d18c9844d7LL,
    0xcc058e0f678bb68eLL, 0xd4cdbda23270bfbdLL, 0x0a5668fab83e8168LL,
    0x510b6c1db467756cLL, 0xb86392a543f16592LL, 0x048ff264e37df9f2LL,
    0x3a330e55123d930eLL, 0xb235fa5ffbcfe4faLL, 0xb9c754bcfc932654LL,
    0x3c0185037a84ec85LL, 0x0c64e3acd087fee3LL, 0xe02729697b0e5429LL,
    0x07964d4fd7db3c4dLL, 0x814923db656a3323LL, 0x388e776799f91577LL,
    0x6a9ca4511938a5a4LL, 0x1bd18c86615dcc8cLL, 0xb407710993769b71LL,
    0x150816183a1eb416LL, 0x4395374a59a2fd37LL, 0xc4ee9fc75471b19fLL,
    0x5844bbcc38ff31bbLL, 0xcf1c3124532d7331LL, 0xb71ece22a7d05eceLL,
    0xaccf42a4c68d9242LL, 0x97588ae86bd2428aLL, 0x75c2dab39b1890daLL,
    0x9e175d39e74a065dLL, 0xf0040b0c1d0f5a0bLL, 0xceb8f73dec4f30f7LL,
    0xbe5119f32b481a19LL, 0xd35bf0ede5ab83f0LL, 0x7c8d0d621780d40dLL,
    0x85c6d1bf8617cad1LL},

   {0xb1c742127b66f2a4LL, 0xce916098d7a59fc1LL,
    0xc312ef8e2406fa70LL, 0x956c7dced81403d5LL, 0x5a0c9b2318dd9520LL,
    0xad0d57f51a480e8bLL, 0xe7b9d05287740b01LL, 0x0217f9ea2ed81268LL,
    0x4d7cff19f8cd3a06LL, 0x44d1772e572b7b67LL, 0xfb73c5b5e65af72eLL,
    0x91427aef84512705LL, 0x0c720963e4cf6c85LL, 0x87c398a0732d8117LL,
    0xa17f5e96fe87620eLL, 0x50476c8b8e8fcf1dLL, 0xcb4ee1cc9c8cb225LL,
    0x67b2304c91a8b59aLL, 0x54696baad2caebcdLL, 0xddcf03836bf01437LL,
    0x46c68ec479f3690fLL, 0x8f9f96e2cba7c942LL, 0xe1802e99f5e93db9LL,
    0x4e9a8086c179215aLL, 0xf0c9b4686764a427LL, 0xfd4a3b7e94c7c196LL,
    0xfcbbbd0b83abc8a2LL, 0xebcbd93163bb6784LL, 0xf9643c5fc882e546LL,
    0xc4da973041f7c5fcLL, 0x1af3eb2c13b3ca97LL, 0x6e1fb87b3e4ef4fbLL,
    0x5e229c024498b1f0LL, 0xf516353c2c4d89c3LL, 0xcc869972f97d8da9LL,
    0x8d886f08e57fdb2aLL, 0x1cca15e7612efc2fLL, 0x567e9240fc12f9a5LL,
    0x43190f9032da44ebLL, 0xfeac44e1ad73dacaLL, 0x07c878be65f13f8cLL,
    0x618bce87e3358322LL, 0xf895ba2adfeeec72LL, 0x751dd5223a913758LL,
    0x59eae4bc21698e7cLL, 0xff5dc294ba1fd3feLL, 0x03e67f9f39b41b5cLL,
    0x2292c117d1efc7c9LL, 0x8a4017b6808ee4a6LL, 0xd1bd0ae08f3f78b2LL,
    0x135e631bbc558bf6LL, 0xee14586528924a60LL, 0x8857ee5cae56f6ceLL,
    0x0000000000000000LL, 0x0e65f089ca177eedLL, 0x34132358269361dbLL,
    0x15679dd0cec8bd4eLL, 0x800be01e16dcbe9bLL, 0x949dfbbbcf780ae1LL,
    0xe397d773db312fd1LL, 0xedf227fa1126513cLL, 0xb5e945332723d674LL,
    0x53a11314b73bd441LL, 0x23634762c683cefdLL, 0x4b4501d28a500cbeLL,
    0x473708b16e9f603bLL, 0x1770643ae010af26LL, 0xa746a05d8c1a54b6LL,
    0x90b3fc9a933d2e31LL, 0x35e2a52d31ff68efLL, 0xab34a93e68d53833LL,
    0xd81082d720d939d3LL, 0xb86aca25d480b3c5LL, 0xdfd8fa694528065fLL,
    0x4f6b06f3d615286eLL, 0x578f1435eb7ef091LL, 0x9af80b32056f740cLL,
    0x92a40570bde53c59LL, 0xdbf6fd48196d228fLL, 0x1b026d5904dfc3a3LL,
    0x3c4f2d1a9e19298eLL, 0xc8a89e53a538a979LL, 0x991e74ad3cdb6f50LL,
    0x042e07215c4524d0LL, 0x8e6e1097dccbc076LL, 0xe071a8ece285348dLL,
    0xd784f42bfda24e0aLL, 0x7d41db60821b7f0dLL, 0x85d4614a5df5937fLL,
    0xbb8cb5baed34a899LL, 0x40ff700f0b6e5fb7LL, 0x2cf7319e1bf8b924LL,
    0x3a76d3d1ec841f36LL, 0x4520f15b40477253LL, 0xf138321d7008ad13LL,
    0x42e889e525b64ddfLL, 0x65a5c9a6bf70a7f2LL, 0x208538fdff37d5a1LL,
    0x410ef67a1c025683LL, 0x18e412c63d6bd8ffLL, 0x72d5ad9c5f6008d4LL,
    0x255ab9a9b41ef845LL, 0x93558305aa89356dLL, 0x70c2547671b81abcLL,
    0x3604dab2084b73b3LL, 0x05df81544b292de4LL, 0xf2de4d8249bcb64fLL,
    0x0bba71dd813e5309LL, 0xa368a77cd05f7066LL, 0x796fdc41de5e5bddLL,
    0xec03a18f064a5808LL, 0x085c0e42b88a4855LL, 0x274d40439ac6ea2dLL,
    0x31cca20c6dba4c3fLL, 0x322add93540e5763LL, 0xb60f3aac1e97cd28LL,
    0x7cb05d1595777639LL, 0xb036c4676c0afb90LL, 0x0a4bf7a896525a3dLL,
    0x73242be9480c01e0LL, 0x5bfd1d560fb19c14LL, 0x7b7825abf08649b5LL,
    0xb7febcd909fbc41cLL, 0x81fa666b01b0b7afLL, 0xd25b757fb68b63eeLL,
    0x0d838f16f3a365b1LL, 0x6a31bf5a620bd02bLL, 0x26bcc6368daae319LL,
    0x9ed60c13592a50dcLL, 0x581b62c936058748LL, 0x9cc1f5f977f242b4LL,
    0x83ed9f812f68a5c7LL, 0x74ec53572dfd3e6cLL, 0xb3d0bbf855bee0ccLL,
    0xacfcd1800d2407bfLL, 0x303d24797ad6450bLL, 0x7a89a3dee7ea4081LL,
    0x69d7c0c55bbfcb77LL, 0x770a2cc814492530LL, 0x0f9476fcdd7b77d9LL,
    0xaeeb286a23fc15d7LL, 0x2174be88e85bdc95LL, 0xde297c1c52440f6bLL,
    0xd04c8c9598537186LL, 0x2ee0c8743520ab4cLL, 0x977b8424f6cc11bdLL,
    0x10b81c8485e190aaLL, 0xa4a0dfc2b5ae4feaLL, 0x98eff2d82bb76664LL,
    0xa8d2d6a15161236fLL, 0xd4628bb4c4165556LL, 0x682646b04cd3c243LL,
    0x2d06b7eb0c94b010LL, 0x626db118da81987eLL, 0x2928b0ca50d194c0LL,
    0x6df9c7e407faefa7LL, 0x1681e24ff77ca612LL, 0x4952f838a4881ed6LL,
    0x76fbaabd03252c04LL, 0xc73ce8af7843dea0LL, 0xe82da6ae5a0f7cd8LL,
    0xc10516640adee818LL, 0x968a0251e1a01889LL, 0x37f55cc71f277a87LL,
    0xe5ae29b8a9ac1969LL, 0xcabf67b98be0bb11LL, 0xf4e7b3493b2180f7LL,
    0xe9dc20db4d6375ecLL, 0x639c376dcded914aLL, 0x12afe56eab3982c2LL,
    0xc2e369fb336af344LL, 0xa6b726289b765d82LL, 0x14961ba5d9a4b47aLL,
    0xbc44cd0488c59715LL, 0xd3aaf30aa1e76adaLL, 0x28d936bf47bd9df4LL,
    0xaf1aae1f34901ce3LL, 0x2f114e01224ca278LL, 0xe648562790180235LL,
    0x24ab3fdca372f171LL, 0x52509561a057dd75LL, 0xc6cd6eda6f2fd794LL,
    0xa08ed8e3e9eb6b3aLL, 0x09ad8837afe64161LL, 0xbdb54b719fa99e21LL,
    0x8c79e97df213d21eLL, 0xcf60e6edc0c996f5LL, 0x5dc4e39d7d2caaacLL,
    0x11499af1928d999eLL, 0x5fd31a7753f4b8c4LL, 0x01f18675176c0934LL,
    0xc52b1145569bccc8LL, 0x9f278a664e4659e8LL, 0x3dbeab6f897520baLL,
    0xa2992109c7337952LL, 0x9b098d4712037d38LL, 0xc9591826b254a04dLL,
    0x3b8755a4fbe81602LL, 0xbe5334eea61d857dLL, 0x51b6eafe99e3c629LL,
    0x191594b32a07d1cbLL, 0x1f2c6a78589ae773LL, 0x3fa95285a7ad32d2LL,
    0x5c3565e86a40a398LL, 0xb2213d8d42d2e9f8LL, 0xefe5de103ffe4354LL,
    0x4ab487a79d3c058aLL, 0xcd771f07ee11849dLL, 0xbfa2b29bb1718c49LL,
    0xba7d33cffa58a1adLL, 0x6fee3e0e2922fdcfLL, 0x64544fd3a81caec6LL,
    0xd9e104a237b530e7LL, 0xf32fcbf75ed0bf7bLL, 0x3e58d4f0b0c13be6LL,
    0xb418c346304fdf40LL, 0xaac52f4b7fb93107LL, 0xdc3e85f67c9c1d03LL,
    0xd5930dc1d37a5c62LL, 0x0639fecb729d36b8LL, 0xc0f490111db2e12cLL,
    0x7ea7a4ffbbaf6451LL, 0xf6f04aa315f9929fLL, 0x6643b63986c4bcaeLL,
    0x6c0841911096e693LL, 0x8425e73f4a999a4bLL, 0x7133d20366d41388LL,
    0x38612a3bc25c0d5eLL, 0xb99b4c50c3ecbaf1LL, 0x1d3b93927642f51bLL,
    0x7f56228aacc36d65LL, 0x9d30738c609e4b80LL, 0x48a37e4db3e417e2LL,
    0x8bb191c397e2ed92LL, 0x2acecf5569658f9cLL, 0xda077b3d0e012bbbLL,
    0xa55159b7a2c246deLL, 0x33db5be643625e57LL, 0x821c19f43804acf3LL,
    0x3990ac4ed530046aLL, 0xd675725eeace473eLL, 0x789e5a34c93252e9LL,
    0x86321ed564418823LL, 0xfa8243c0f136fe1aLL, 0xe45fafcdbec0105dLL,
    0x2b3f49207e0986a8LL, 0xa92350d4460d2a5bLL, 0x1eddec0d4ff6ee47LL,
    0x89a66829b93afffaLL, 0x607a48f2f4598a16LL, 0x6bc0392f7567d91fLL,
    0xea3a5f4474d76eb0LL, 0x5598eddfc5a6e2f9LL, 0x4c8d796cefa13332LL,
    0xf701ccd602959babLL, 0xe2665106cc5d26e5LL}
};

ddword cbox_dec[8][256] = {
    {0xe6126af05e55aff3LL, 0x4b6c893f310b0835LL, 0xaa4c0e84ebfc8d57LL,
    0xfb9b5c7bf3b3090dLL, 0x4508a6a9ccba5ce2LL, 0xe5d1d2064dc6bde9LL,
    0x348343755288eddeLL, 0xb684505de46b250cLL, 0xa8cede205a1e91e8LL,
    0x40b89b46f9fa6accLL, 0x8ee1ec1afab080baLL, 0xde77d6b7408e0a45LL,
    0x9a3e184c2e455802LL, 0xbe93fad23f0955efLL, 0x3ae76ce3af39b909LL,
    0xad7ee3cf6f5ea7c6LL, 0x8b51d1f5cff0b694LL, 0x70ca8d8e3c43bf99LL,
    0xccdba7f8b2a8f6c9LL, 0x4c5e6474b5a922a4LL, 0x5d31adcd541ccc32LL,
    0x9b7f701e8c3456a7LL, 0x2ac9cd08ecfd593aLL, 0x8fa0844858c18e1fLL,
    0x32f0c66c745bc9eaLL, 0xc58d6525cbbb888fLL, 0x8c633cbe4b529c05LL,
    0xf2cd9ea68aa0774bLL, 0x2cba4811ca2e7d0eLL, 0xe2e33f4dc9649778LL,
    0xf4be1bbfac73537fLL, 0x22de6787379f29d9LL, 0x0956c2dd79137e46LL,
    0xe061efe978868bc7LL, 0x1cc85ed90f97a85bLL, 0x31337e9a67c8dbf0LL,
    0x360193d1e36af161LL, 0x7fefca4a6383e5ebLL, 0x8535fe633241e243LL,
    0xc3fee03ced68acbbLL, 0x81c4abdea570dac8LL, 0x67d6c12efb25753bLL,
    0xa4282112164dd980LL, 0xcf181f0ea13be4d3LL, 0xa98fb672f86f9f4dLL,
    0x5c70c59ff66dc297LL, 0xb0f7d544c2b80138LL, 0x0da79760ee2246cdLL,
    0x3740fb83411bffc4LL, 0x24ade29e114c0dedLL, 0xf858e48de0201b17LL,
    0x0e642f96fdb154d7LL, 0xddb46e41531d185fLL, 0x25ec8accb33d0348LL,
    0x0282d0a4b1e21cbfLL, 0x1bfab3928b3582caLL, 0xaffc336bdebcbb79LL,
    0x35c22b27f0f9e37bLL, 0x03c3b8f61393121aLL, 0xb8e07fcb19da71dbLL,
    0x99fda0ba3dd64a18LL, 0xce59775c034aea76LL, 0x49ee599b80e9148aLL,
    0xfe2b6194c6f33f23LL, 0x4edcb4d0044b3e1bLL, 0xd5a3c4ce887f68bcLL,
    0xdf36bee5e2ff04e0LL, 0x171c4ca0c766caa2LL, 0x0bd41279c8f162f9LL,
    0xe490ba54efb7b34cLL, 0x5b4228d472cfe806LL, 0x5355825ba9ad98e5LL,
    0x9f8e25a31b056e2cLL, 0xcd9acfaa10d9f86cLL, 0x88926903dc63a48eLL,
    0xb40680f9558939b3LL, 0x239f0fd595ee277cLL, 0xec8710db34d5c3afLL,
    0x87b72ec783a3fefcLL, 0x632794936c144db0LL, 0x46cb1e5fdf294ef8LL,
    0x83467b7a1492c677LL, 0x9c4d9d5508967c36LL, 0xd6607c389bec7aa6LL,
    0x165d24f26517c407LL, 0xc4cc0d7769ca862aLL, 0xcbe94ab3360adc58LL,
    0x847496319030ece6LL, 0x7a5ff7a556c3d3c5LL, 0xc03d58cafefbbea1LL,
    0x76b908971a909badLL, 0x2f79f0e7d9bd6f14LL, 0x197863363ad79e75LL,
    0xda86830ad7bf32ceLL, 0x5a034086d0bee6a3LL, 0x97998f2cc0671ecfLL,
    0x552607428f7ebcd1LL, 0x51d752ff184f845aLL, 0xbb23c73d0a4963c1LL,
    0x2b88a55a4e8c579fLL, 0xd80453ae665d2e71LL, 0xee05c07f8537df10LL,
    0x423a4be248187673LL, 0xcaa822e1947bd2fdLL, 0x1abbdbc029448c6fLL,
    0x96d8e77e6216106aLL, 0x6266fcc1ce654315LL, 0x89d301517e12aa2bLL,
    0x730935782fd0ad83LL, 0x8085c38c0701d46dLL, 0x6b303e1cb7763d53LL,
    0x3f57510c9a798f27LL, 0x4449cefb6ecb5247LL, 0x48af31c922981a2fLL,
    0x98bcc8e89fa744bdLL, 0x69b2eeb8069421ecLL, 0xebb5fd90b077e93eLL,
    0x6a71564e150733f6LL, 0x116fc9b9e1b5ee96LL, 0x4a2de16d937a0690LL,
    0xb9a11799bbab7f7eLL, 0x9368da9157562644LL, 0x718be5dc9e32b13cLL,
    0xc82af2452599ce42LL, 0xb547e8abf7f83716LL, 0x33b1ae3ed62ac74fLL,
    0x799c4f534550c1dfLL, 0x3e16395e38088182LL, 0x7c2c72bc7010f7f1LL,
    0xf38cf6f428d179eeLL, 0xd29129850cdd422dLL, 0x41f9f3145b8b6469LL,
    0x945a37dad3f40cd5LL, 0x757ab061090389b7LL, 0x6554118a4ac76984LL,
    0x7d6d1aeed261f954LL, 0x01416852a2710ea5LL, 0xb27505e0735a1d87LL,
    0x77f860c5b8e19508LL, 0x78dd2701e721cf7aLL, 0xe12087bbdaf78562LL,
    0x86f6469521d2f059LL, 0xef44a82d2746d1b5LL, 0xbc112a768eeb4950LL,
    0xc2bf886e4f19a21eLL, 0x307216c8c5b9d555LL, 0xc96b9a1787e8c0e7LL,
    0xa31acc5992eff311LL, 0xa0d974af817ce10bLL, 0xdcf50613f16c16faLL,
    0xfca9b1307711239cLL, 0x57a4d7e63e9ca06eLL, 0xc64eddd3d8289a95LL,
    0xa25ba40b309efdb4LL, 0x2e3898b57bcc61b1LL, 0xf5ff73ed0e025ddaLL,
    0xa6aaf1b6a7afc53fLL, 0xd9453bfcc42c20d4LL, 0x9d0cf507aae77293LL,
    0x290a75feff6e4b20LL, 0xa7eb99e405decb9aLL, 0xa1981cfd230defaeLL,
    0x12ac714ff226fc8cLL, 0x743bd833ab728712LL, 0x6c02d35733d417c2LL,
    0xe9372d340195f581LL, 0xf77da349bfe04165LL, 0x68f386eaa4e52f49LL,
    0x211ddf71240c3bc3LL, 0x13ed191d5057f229LL, 0xe8764566a3e4fb24LL,
    0xf9198cdf425115b2LL, 0xd013f921bd3f5e92LL, 0x91ea0a35e6b43afbLL,
    0x0732ed4b84a22a91LL, 0xeaf495c21206e79bLL, 0x5214ea090bdc9640LL,
    0x0000000000000000LL, 0xb3346db2d12b1322LL, 0x0ce6ff324c534868LL,
    0xaebd5b397ccdb5dcLL, 0x0a957a2b6a806c5cLL, 0x1f0be62f1c04ba41LL,
    0x14dff456d4f5d8b8LL, 0x58819022615cfa1cLL, 0x05b03def3540362eLL,
    0xe3a2571f6b1599ddLL, 0x9229b2c3f52728e1LL, 0xba62af6fa8386d64LL,
    0x0673851926d32434LL, 0x641579d8e8b66721LL, 0x04f155bd9731388bLL,
    0x9ecf4df1b9746089LL, 0x205cb723867d3566LL, 0x102ea1eb43c4e033LL,
    0x3ba604b10d48b7acLL, 0x50963aadba3e8affLL, 0xac3f8b9dcd2fa963LL,
    0x7b1e9ff7f4b2dd60LL, 0xf63ccb1b1d914fc0LL, 0x7eaea218c1f2eb4eLL,
    0x5fb37d69e5fed08dLL, 0x56e5bfb49cedaecbLL, 0x2dfb2043685f73abLL,
    0x61a54437ddf6510fLL, 0x6fc16ba1204705d8LL, 0xe75302a2fc24a156LL,
    0x3dd581a82b9b9398LL, 0xdbc7eb5875ce3c6bLL, 0x90ab626744c5345eLL,
    0x59c0f870c32df4b9LL, 0x6697a97c59547b9eLL, 0xfde8d962d5602d39LL,
    0xd3d041d7aeac4c88LL, 0x5ef2153b478fde28LL, 0xd4e2ac9c2a0e6619LL,
    0x1e4a8e7dbe75b4e4LL, 0x72485d2a8da1a326LL, 0x437b23b0ea6978d6LL,
    0x159e9c047684d61dLL, 0x0f2547c45fc05a72LL, 0xf10e265099336551LL,
    0x3c94e9fa89ea9d3dLL, 0xbfd292809d785b4aLL, 0x0817aa8fdb6270e3LL,
    0x60e42c657f875faaLL, 0x18390b6498a690d0LL, 0x478a760d7d58405dLL,
    0x284b1dac5d1f4585LL, 0xb1b6bd1660c90f9dLL, 0xd15291731f4e5037LL,
    0x4d1f0c2617d82c01LL, 0xc70fb5817a599430LL, 0x6d43bb0591a51967LL,
    0x6e8003f382360b7dLL, 0x1d89368bade6a6feLL, 0x4f9ddc82a63a30beLL,
    0xedc6788996a4cd0aLL, 0xab0d66d6498d83f2LL, 0x54676f102d0fb274LL,
    0xc17c30985c8ab004LL, 0x3865bc471edba5b6LL, 0x3924d415bcaaab13LL,
    0x951b5f8871850270LL, 0x8a10b9a76d81b831LL, 0xbd5042242c9a47f5LL,
    0xa5694940b43cd725LL, 0xff6a09c664823186LL, 0x8d2254ece92392a0LL,
    0xb7c5380f461a2ba9LL, 0x82071328b6e3c8d2LL, 0xd721146a399d7403LL,
    0xfada342951c207a8LL, 0x262f323aa0ae1152LL, 0xf04f4e023b426bf4LL,
    0x276e5a6802df1ff7LL},

   {0x3b4016dbfd16e203LL, 0x9a7574c51174530aLL,
    0x90012e69c02ec8d3LL, 0xf44580e3d780e076LL, 0xf81dec2b49eca14bLL,
    0x26cae3e8a6e3d7efLL, 0x0962419e0c41f6abLL, 0x54d1eb4070ebd951LL,
    0x865e884b0188eec8LL, 0xdf76067ea406fe8aLL, 0x29849412e594fba0LL,
    0x461569896869c0f2LL, 0xb5ddd6b3bbd6724eLL, 0x0c586cc89e6c413dLL,
    0x6b0ad97054d904eaLL, 0xa135621eec62b109LL, 0x0eef7e47087ea461LL,
    0xfaaafea4dffe4417LL, 0xe0ad344e80342331LL, 0xab4138b23d382ad0LL,
    0x107390468e90fcffLL, 0xbe0885a2218561b9LL, 0xdbed22957d22c132LL,
    0x2251c7037fc7e857LL, 0x33835ef8ba5e9c86LL, 0xb3f1e0d7f4e0a8aaLL,
    0x3fdb32302432ddbbLL, 0xa719547aa3546bedLL, 0xe10c3df3cb3dab1fLL,
    0x17feaf9f8aafae35LL, 0x9df84b1c154b01c0LL, 0x8364a51d93a5595eLL,
    0x535cd49974d48b9bLL, 0x01a109bd4b09882eLL, 0xc4d0c529b0c51182LL,
    0x2e09abcbe1aba96aLL, 0x1f3de7bccde7d0b0LL, 0x9317355b1d35a5a1LL,
    0x6c87e6a950e65620LL, 0x8910ffb142ffc287LL, 0x40395fed275f1a16LL,
    0x7b794936da49f815LL, 0xf269b68798b63a92LL, 0xfd27c17ddbc116ddLL,
    0x8d8bdb5a9bdbfd3fLL, 0x1ba6c35714c3ef08LL, 0x6e30f426c6f4b37cLL,
    0x7fe26ddd036dc7adLL, 0x14e8b4ad57b4c347LL, 0xb985ba7b25ba3373LL,
    0xe9cf75d08c75d59aLL, 0x626898ee5898f241LL, 0x5b9f9cba339cf51eLL,
    0xb250e96abfe92084LL, 0x165fa622c1a6261bLL, 0xf5e4895e9c896858LL,
    0xb76ac43c2dc49712LL, 0x02b7128f9612e55cLL, 0x1d8af5335bf535ecLL,
    0x36b973ae28732b10LL, 0xa8572380e02347a2LL, 0xf6f2926c4192052aLL,
    0x8c2ad2e7d0d27511LL, 0xd32e6ab63a6abfb7LL, 0xbd1e9e90fc9e0ccbLL,
    0x03161b32dd1b6d72LL, 0x4dc03a98f23ad305LL, 0x81d3b79205b7bc02LL,
    0x450372bbb572ad80LL, 0x2d1fb0f93cb0c418LL, 0x2a928f20388f96d2LL,
    0x721b08a8d6080ebeLL, 0x92b63ce6563c2d8fLL, 0xeb78675f1a6730c6LL,
    0x13658b74538b918dLL, 0x428e4d62b14dff4aLL, 0x88b1f60c09f64aa9LL,
    0x75963771d2375c74LL, 0x7ad8408b9140703bLL, 0x57c7f072adf0b423LL,
    0xe5971918121994a7LL, 0x5666f9cfe6f93c0dLL, 0x8f3cc9d50dc91863LL,
    0x1e9cee0186ee589eLL, 0x8a06e4839fe4aff5LL, 0xb824b3c66eb3bb5dLL,
    0xd1997839ac785aebLL, 0x6752b5b8cab545d7LL, 0xb47cdf0ef0dffa60LL,
    0x949a0a82190af76bLL, 0xc04be1c269e12e3aLL, 0xfc86c8c090c89ef3LL,
    0xe3bb2f7c5d2f4e43LL, 0x6aabd0cd1fd08cc4LL, 0x2147dc31a2dc8525LL,
    0xca3fbb6eb8bbb5e3LL, 0x48fa17ce60176493LL, 0x6444ae8a17ae28a5LL,
    0x2b33869d73861efcLL, 0xd0387184e771d2c5LL, 0x7cf476efde76aadfLL,
    0x63c9915313917a6fLL, 0xc929a05c65a0d891LL, 0xda4c2b28362b491cLL,
    0xfe31da4f06da7bafLL, 0xc1eae87f22e8a614LL, 0x5c12a36337a3a7d4LL,
    0x18b0d865c9d8827aLL, 0xe7200b97840b71fbLL, 0x4bec0cfcbd0c09e1LL,
    0x0f4e77fa43772c4fLL, 0x4c613325b9335b2bLL, 0xf3c8bf3ad3bfb2bcLL,
    0x87ff81f64a8166e6LL, 0xa38270917a705455LL, 0x1911d1d882d10a54LL,
    0x44a27b06fe7b25aeLL, 0x049b24ebd9243fb8LL, 0xbb32a8f4b3a8d62fLL,
    0x91a027d48b2740fdLL, 0x3d6c20bfb22038e7LL, 0xe681022acf02f9d5LL,
    0xf17fadb545ad57e0LL, 0xcc138d0af78d6f07LL, 0x495b1e732b1eecbdLL,
    0x38560de9200d8f71LL, 0xa9f62a3dab2acf8cLL, 0x47b46034236048dcLL,
    0x8e9dc06846c0904dLL, 0xaccc076b3907781aLL, 0x32225745f15714a8LL,
    0xd4a3556f3e55ed7dLL, 0xd7b54e5de34e800fLL, 0xddc114f132141bd6LL,
    0x6d26ef141befde0eLL, 0x85489379dc9383baLL, 0x0bd553119a5313f7LL,
    0x786f520407529567LL, 0xcb9eb2d3f3b23dcdLL, 0xa223792c3179dc7bLL,
    0x0a745aacd15a9bd9LL, 0x710d139a0b1363ccLL, 0x681cc24289c26998LL,
    0x1a07caea5fca6726LL, 0x82c5aca0d8acd170LL, 0x25dcf8da7bf8ba9dLL,
    0xc7c6de1b6dde7cf0LL, 0xc35dfaf0b4fa4348LL, 0xded70fc3ef0f76a4LL,
    0x504acfaba9cfe6e9LL, 0xc571cc94fbcc99acLL, 0x5ea5b1eca1b14288LL,
    0xae7b15e4af159d46LL, 0xc888a9e12ea950bfLL, 0xf7539bd10a9b8d04LL,
    0x962d180d8f181237LL, 0xe43610a559101c89LL, 0x772125fe4425b928LL,
    0x84e99ac4979a0b94LL, 0xc667d7a626d7f4deLL, 0xefe343b4c3430f7eLL,
    0xd5025cd2755c6553LL, 0xa6b85dc7e85de3c3LL, 0xd61447e0a8470821LL,
    0x3e7a3b8d6f3b5595LL, 0x52fddd243fdd03b5LL, 0x8072be2f4ebe342cLL,
    0x12c482c9188219a3LL, 0x9eee502ec8506cb2LL, 0xad6d0ed6720ef034LL,
    0x59288e35a58e1042LL, 0xe21a26c11626c66dLL, 0x247df16730f132b3LL,
    0xf0dea4080ea4dfceLL, 0x31344c772c4c79daLL, 0x4f77281764283659LL,
    0x79ce5bb94c5b1d49LL, 0x0000000000000000LL, 0x73ba01159d018690LL,
    0x74373ecc993ed45aLL, 0xbcbf972db79784e5LL, 0x4ed621aa2f21be77LL,
    0xd95a301aeb30246eLL, 0x9c5942a15e4289eeLL, 0x37187a13637aa33eLL,
    0x276bea55edea5fc1LL, 0x1c2bfc8e10fcbdc2LL, 0xed54513b5551ea22LL,
    0x20e6d58ce9d50d0bLL, 0x3ae11f66b61f6a2dLL, 0x66f3bc0581bccdf9LL,
    0x2cbeb94477b94c36LL, 0x99636ff7cc6f3e78LL, 0x953b033f52037f45LL,
    0xb0e7fbe529fbc5d8LL, 0x60df8a61ce8a171dLL, 0x6f91fd9b8dfd3b52LL,
    0xaae0310f7631a2feLL, 0xbfa98c1f6a8ce997LL, 0x8ba7ed3ed4ed27dbLL,
    0x98c2664a8766b656LL, 0x062c36644f36dae4LL, 0x5570e2fd3be2517fLL,
    0xead96ee2516eb8e8LL, 0x419856506c569238LL, 0x23f0cebe34ce6079LL,
    0x309545ca6745f1f4LL, 0x5a3e950778957d30LL, 0x617e83dc85839f33LL,
    0xfb0bf71994f7cc39LL, 0x3ccd2902f929b0c9LL, 0x70ac1a27401aebe2LL,
    0xcea49f85619f8a5bLL, 0x39f704546b04075fLL, 0x0df96575d565c913LL,
    0x08c3482347487e85LL, 0xd28f630b71633799LL, 0xecf558861e58620cLL,
    0xc2fcf34dfff3cb66LL, 0x978c11b0c4119a19LL, 0x69bdcbffc2cbe1b6LL,
    0xba93a149f8a15e01LL, 0x51ebc616e2c66ec7LL, 0x078d3fd9043f52caLL,
    0x58898788ee87986cLL, 0x4a4d0541f60581cfLL, 0xe86e7c6dc77c5db4LL,
    0xee424a09884a8750LL, 0xcdb284b7bc84e729LL, 0x65e5a7375ca7a08bLL,
    0x2fa8a276aaa22144LL, 0xa0946ba3a76b3927LL, 0xa5ae46f535468eb1LL,
    0x35af689cf5684662LL, 0x28259dafae9d738eLL, 0xcf0596382a960275LL,
    0xb6cbcd8166cd1f3cLL, 0x7e43646048644f83LL, 0x9bd47d785a7ddb24LL,
    0x432f44dffa447764LL, 0x9f4f59938359e49cLL, 0x7d557f52957f22f1LL,
    0x76802c430f2c3106LL, 0xdc601d4c791d93f8LL, 0x053a2d56922db796LL,
    0x11d299fbc59974d1LL, 0xf9bce59602e52965LL, 0xd8fb39a7a039ac40LL,
    0x340e6121be61ce4cLL, 0x5f04b851eab8caa6LL, 0x5db3aade7caa2ffaLL,
    0x1549bd101cbd4b69LL, 0xff90d3f24dd3f381LL, 0xafda1c59e41c1568LL,
    0xb146f25862f24df6LL, 0xa40f4f487e4f069fLL},

   {0xa1a35cebf8f0f94cLL,
    0x2c203d650f3f095dLL, 0x1a2bdaee4084a2a7LL, 0xd32404574d7bcc68LL,
    0xf785bea594a9adc4LL, 0xf2eb54456206949cLL, 0x3f5e334d0475ced1LL,
    0x5994299b835d1f60LL, 0x785b7989ac204794LL, 0x025da6a2cf461a41LL,
    0xdf1f3a71f01a901bLL, 0x27284f018bb77637LL, 0xe1955a6d694c5310LL,
    0x24a1baf2d9d261acLL, 0xe4fbb08d9fe36a48LL, 0x8d83618ef7cff011LL,
    0x2ac72276abf5279eLL, 0xf9e32621e68eebf6LL, 0xbf323fb4d3f86f69LL,
    0xbb888605b8745bebLL, 0x70dafe1e7acd2f65LL, 0xd0adf1a41f1edbf3LL,
    0x1e91635f2b089625LL, 0xee2791b8864818f8LL, 0x99ce23e4c56c1484LL,
    0xf33f0714ff259946LL, 0xbd6f99161cbe7528LL, 0x9f293cf761a63a47LL,
    0xb80173f6ea114c70LL, 0x6543ef25d54dc62aLL, 0x39b92c5ea0bfe012LL,
    0x63a4f0367187e8e9LL, 0x4c0d38a02cddf62fLL, 0x07334c4239e92319LL,
    0x43bff375c3d9bdc7LL, 0xca862b4a5f9a7954LL, 0x5d2e902ae8d12be2LL,
    0x137e0e280b4ac78cLL, 0xf162a1b630638307LL, 0x55af17bd3e3c4313LL,
    0x358212781ddebc61LL, 0x94214e93e52e452dLL, 0xc18e592edb12063eLL,
    0xec7a371a490e02b9LL, 0x4963d240da72cf77LL, 0x41e255d70c9fa786LL,
    0xff0439324244c535LL, 0x88ed8b6e0160c949LL, 0x6c163be39e83a301LL,
    0xc534e09fb09e32bcLL, 0x806c0cf9d78da1b8LL, 0xdba583c09b96a499LL,
    0x746047af11411be7LL, 0xf40c4b56c6ccba5fLL, 0x6270a367eca4e533LL,
    0xd41748157492ef71LL, 0xeff3c2e91b6b1522LL, 0x0e66988472274632LL,
    0x534808ae9af66dd0LL, 0x8231aa5b18cbbbf9LL, 0xb2dd52c3f3ba3ec0LL,
    0xdd429cd33f5c8a5aLL, 0x4e509e02e39bec6eLL, 0x26fc1c5016947bedLL,
    0xd9f8256254d0bed8LL, 0x0955d4c64bce652bLL, 0x1610e4c8fde5fed4LL,
    0x6dc268b203a0aedbLL, 0x2e7d9bc7c079131cLL, 0xc3d3ff8c14541c7fLL,
    0xd64aeeb7bbd4f530LL, 0xab7f7ddee15b8bfcLL, 0x144d426a32a3e495LL,
    0x8e0a947da5aae78aLL, 0x798f2ad831034a4eLL, 0x3be48afc6ff9fa53LL,
    0x529c5bff07d5600aLL, 0xbee66ce54edb62b3LL, 0x931202d1dcc76634LL,
    0x50c1fd5dc8937a4bLL, 0xa4cdb60b0e5fc014LL, 0x57f2b11ff17a5952LL,
    0x47054ac4a8558945LL, 0x5a1ddc68d13808fbLL, 0x5cfac37b75f22638LL,
    0xc207acdd897711a5LL, 0x289a84d464b33ddfLL, 0xc05a0a7f46310be4LL,
    0xe6a6162f50a57009LL, 0x06e71f13a4ca2ec3LL, 0x5f733688279731a3LL,
    0xeb497b5870e721a0LL, 0xb667eb7298360a42LL, 0xe3c8fccfa60a4951LL,
    0xe772457ecd867dd3LL, 0x6978d103682c9a59LL, 0x0def6d77204251a9LL,
    0xc90fdeb90dff6ecfLL, 0xd179a2f5823dd629LL, 0x2fa9c8965d5a1ec6LL,
    0x81b85fa84aaeac62LL, 0xdc96cf82a27f8780LL, 0x602d05c523e2ff72LL,
    0x19a22f1d12e1b53cLL, 0xe52fe3dc02c06792LL, 0x58407aca1e7e12baLL,
    0x61f95694bec1f2a8LL, 0x48b781114751c2adLL, 0xaaab2e8f7c788626LL,
    0x04bab9b16b8c3482LL, 0x2df46e34921c0487LL, 0x1123a88ac40cddcdLL,
    0xc6bd156ce2fb2527LL, 0x7f6835cb95c9648dLL, 0x83e5f90a85e8b623LL,
    0x4f84cd537eb8e1b4LL, 0x294ed785f9903005LL, 0x1cccc5fde44e8c64LL,
    0xcb52781bc2b9748eLL, 0x1d1896ac796d81beLL, 0xb30901926e99331aLL,
    0xad9862cd4591a53fLL, 0xc8db8de890dc6315LL, 0x7bd28c7afe45500fLL,
    0x0adc213519ab72b0LL, 0xa8f6882db33e9c67LL, 0xb5ee1e81ca531dd9LL,
    0x201b0343b25e552eLL, 0x4036068691bcaa5cLL, 0xae11973e17f4b2a4LL,
    0x9efd6fa6fc85379dLL, 0x33650d6bb91492a2LL, 0x3a30d9adf2daf789LL,
    0x0c3b3e26bd615c73LL, 0xf651edf4098aa01eLL, 0x710ead4fe7ee22bfLL,
    0x3138abc9765288e3LL, 0x9d749a55aee02006LL, 0x6e4b9d4151c5b940LL,
    0x84d6b548bc01953aLL, 0x360be78b4fbbabfaLL, 0xa22aa918aa95eed7LL,
    0xedae644bd42d0f63LL, 0x46d119953576849fLL, 0x6497bc74486ecbf0LL,
    0xfbbe808329c8f1b7LL, 0x4aea27b38817d8ecLL, 0x5626e24e6c595488LL,
    0x056eeae0f6af3958LL, 0x4558ec6667139304LL, 0x448cbf37fa309edeLL,
    0x6f9fce10cce6b49aLL, 0xa0770fba65d3f496LL, 0x671e49871a0bdc6bLL,
    0xda71d09106b5a943LL, 0x08818797d6ed68f1LL, 0xa3fefa4937b6e30dLL,
    0xb080f4613cfc2481LL, 0x763de10dde0701a6LL, 0x4dd96bf1b1fefbf5LL,
    0x92c6518041e46beeLL, 0x3456412980fdb1bbLL, 0x981a70b5584f195eLL,
    0x3d0395efcb33d490LL, 0xba5cd55425575631LL, 0x4b3e74e21534d536LL,
    0x6af124f03a498dc2LL, 0x7ebc669a08ea6957LL, 0x30ecf898eb718539LL,
    0xa922db7c2e1d91bdLL, 0x7a06df2b63665dd5LL, 0xb154a730a1df295bLL,
    0xfc8dccc11021d2aeLL, 0xcfe8c1aaa935400cLL, 0x97a8bb60b74b52b6LL,
    0x18767c4c8fc2b8e6LL, 0x9a47d6179709031fLL, 0x0000000000000000LL,
    0xac4c319cd8b2a8e5LL, 0xb9d520a7773241aaLL, 0xdecb69206d399dc1LL,
    0x1f45300eb62b9bffLL, 0x10f7fbdb592fd017LL, 0x3e8a601c9956c30bLL,
    0x8502e619212298e0LL, 0xf5d818075befb785LL, 0x547b44eca31f4ec9LL,
    0x9ca0c90433c32ddcLL, 0xe041093cf46f5ecaLL, 0xa69010a9c119da55LL,
    0xc769463d7fd828fdLL, 0xc4e0b3ce2dbd3f66LL, 0x2575e9a344f16c76LL,
    0x01d453519d230ddaLL, 0xfa6ad3d2b4ebfc6dLL, 0xd5c31b44e9b1e2abLL,
    0xf83775707bade62cLL, 0xbcbbca47819d78f2LL, 0xd79ebde626f7f8eaLL,
    0x5bc98f394c1b0521LL, 0x2246a5e17d184f6fLL, 0x12aa5d799669ca56LL,
    0x5ea765d9bab43c79LL, 0x8939d83f9c43c493LL, 0x32b15e3a24379f78LL,
    0xe914ddfabfa13be1LL, 0x909bf7228ea271afLL, 0x73530bed28a838feLL,
    0xd2f05706d058c1b2LL, 0xfed06a63df67c8efLL, 0xb43a4dd057701003LL,
    0xa519e55a937ccdceLL, 0x75b414fe8c62163dLL, 0xafc5c46f8ad7bf7eLL,
    0x2392f6b0e03b42b5LL, 0x386d7f0f3d9cedc8LL, 0x21cf50122f7d58f4LL,
    0x9b9385460a2a0ec5LL, 0x5115ae0c55b07791LL, 0x0fb2cbd5ef044be8LL,
    0xea9d2809edc42c7aLL, 0xcc613459fb505797LL, 0x426ba0245efab01dLL,
    0x1599113baf80e94fLL, 0x7d3593695a8f7eccLL, 0x0389f5f35265179bLL,
    0x875f40bbee6482a1LL, 0x95f51dc2780d48f7LL, 0x7ce1c038c7ac7316LL,
    0xce3c92fb34164dd6LL, 0xcdb5670866735a4dLL, 0x8ab02dccce26d308LL,
    0x914fa47313817c75LL, 0x8b647e9d5305ded2LL, 0xd82c7633c9f3b302LL,
    0x728758bcb58b3524LL, 0xe8c08eab2282363bLL, 0x8fdec72c3889ea50LL,
    0x2b13712736d62a44LL, 0x3cd7c6be5610d94aLL, 0x37dfb4dad298a620LL,
    0x868b13ea73478f7bLL, 0xb7b3b82305150798LL, 0x0b08726484887f6aLL,
    0x1bff89bfdda7af7dLL, 0x77e9b25c43240c7cLL, 0xf0b6f2e7ad408eddLL,
    0x17c4b79960c6f30eLL, 0x8c5732df6aecfdcbLL, 0x68ac8252f50f9783LL,
    0x66ca1ad68728d1b1LL, 0x6b2577a1a76a8018LL, 0xe21caf9e3b29448bLL,
    0xa74443f85c3ad78fLL, 0xfd599f908d02df74LL, 0x967ce8312a685f6cLL},

   {0xfa7b9775ba3af751LL, 0x03ef98cb769c2d13LL, 0x7191ce067072359eLL,
    0xbab18b6bff7516a8LL, 0xe6e5ef4efbc1065eLL, 0x7bec74a3b1d0dbf4LL,
    0x656b4fb907c31c4aLL, 0x4e8520f99fc86304LL, 0x8fd8df31d16dae58LL,
    0x90a93fc1e60a7244LL, 0x30ad09f2b449cfc5LL, 0x8453be7e91bb5b90LL,
    0x1d68a3d1c08feaadLL, 0x5c54642504b410f6LL, 0x8061383c8a9e3707LL,
    0xf9940fbecca6da42LL, 0x46e1d97da982bbdfLL, 0xfc50521656f7ad77LL,
    0x5e4d2704f35c2647LL, 0x8bea5973ca48c2cfLL, 0xd06323dfa34593bdLL,
    0x62b651306a7a5dceLL, 0xa436b0714966d116LL, 0x4f73fb131ebc78a6LL,
    0x92b07ce011e244f5LL, 0x33429139c2d5e2d6LL, 0xcee418c515565403LL,
    0xd7be3d56cefcd239LL, 0x53ed83285f4789a9LL, 0xf3e9b51b0d043428LL,
    0x20650e0fd8dd8a86LL, 0xb6e7f4add21aa2e4LL, 0x6d0fb63d3189c491LL,
    0x0da0a42cac1bafeeLL, 0x3f14eeffefba569aLL, 0x13279f361a086850LL,
    0x9b225e8ea6dc878cLL, 0x6684d772715f3159LL, 0xa3ebaef824df9092LL,
    0xc499a260d4f4ba69LL, 0xaa798c9693e153ebLL, 0x50021be329dba4baLL,
    0x949bb983fd2f1ed3LL, 0xdfdac4d2f8b60ae2LL, 0xf0062dd07b98193bLL,
    0xafbdd13e09b024deLL, 0xb95e13a089e93bbbLL, 0x649d945386b707e8LL,
    0xe4fcac6f0c2930efLL, 0x413cc7f4c43bfa5bLL, 0x3b2668bdf49f3a0dLL,
    0xe50a77858d5d2b4dLL, 0x05c45da89a517735LL, 0x3ee235156ece4d38LL,
    0xfe491137a11f9bc6LL, 0xb7112f47536eb946LL, 0x07dd1e896db94184LL,
    0x1ab5bd58ad36ab29LL, 0x8197e3d60bea2ca5LL, 0xab8f577c12954849LL,
    0x9cff4007cb65c608LL, 0xa00436335243bd81LL, 0xfda689fcd783b6d5LL,
    0xccfd5be4e2be62b2LL, 0x75a348446b575909LL, 0x17151974012d04c7LL,
    0xfb8d4c9f3b4eecf3LL, 0xac5249f57f2c09cdLL, 0x9346a70a90965f57LL,
    0x043286421b256c97LL, 0x27b81086b564cb02LL, 0x3569545a2e18b8f0LL,
    0x6b24735edd449eb7LL, 0x2193d5e559a99124LL, 0xc7763aaba268977aLL,
    0xb0cc31ce3ed7f8c2LL, 0xc939064c78ef1587LL, 0x16e3c29e80591f65LL,
    0x5da2bfcf85c00b54LL, 0x5990398d9ee567c3LL, 0x67720c98f02b2afbLL,
    0x54309da132fec82dLL, 0xeab39088d6aeb212LL, 0x9682faa20ac72862LL,
    0xd38cbb14d5d9beaeLL, 0x4c9c63d8682055b5LL, 0xd648e6bc4f88c99bLL,
    0xdc355c198e2a27f1LL, 0x10c807fd6c944543LL, 0x450e41b6df1e96ccLL,
    0x0b8b614f40d6f5c8LL, 0xd27a60fe54ada50cLL, 0x49583e70f2712280LL,
    0x8dc19c10268598e9LL, 0x5866e2671f917c61LL, 0x79f537824638ed45LL,
    0xc2b267033839e04fLL, 0xcb20456d8f072336LL, 0x2a18b4aa197f64ecLL,
    0xdbe84290e3936675LL, 0x73888d27879a032fLL, 0xe8aad3a9214684a3LL,
    0x6ee02ef64715e982LL, 0xa996145de57d7ef8LL, 0xc8cfdda6f99b0e25LL,
    0x062bc563eccd5a26LL, 0x264ecb6c3410d0a0LL, 0xb8a8c84a089d2019LL,
    0x7dc7b1c05d1d81d2LL, 0xd5a77e773914e488LL, 0x4b417d5105991431LL,
    0xf62de8b39755431dLL, 0x993b1daf5134b13dLL, 0x82787b1d7d7601b6LL,
    0xe321b2e66190716bLL, 0xb5086c66a4868ff7LL, 0x9ee603263c8df0b9LL,
    0x349f8fb0af6ca352LL, 0x5b897aac690d5172LL, 0x7c316a2adc699a70LL,
    0xd451a59db860ff2aLL, 0x706715ecf1062e3cLL, 0x838ea0f7fc021a14LL,
    0x57df056a4462e53eLL, 0xcf12c32f94224fa1LL, 0xed6e8e01bb17f396LL,
    0x915fe42b677e69e6LL, 0x89f31a523da0f47eLL, 0xe71334a47ab51dfcLL,
    0xa860cfb76409655aLL, 0x9f10d8ccbdf9eb1bLL, 0xef77cd204cffc527LL,
    0xf862d4544dd2c1e0LL, 0x8a1c82994b3cd96dLL, 0xae4b0ad488c43f7cLL,
    0x98cdc645d040aa9fLL, 0x7fdef2e1aaf5b763LL, 0x4717029728f6a07dLL,
    0x745593aeea2342abLL, 0xee8116cacd8bde85LL, 0x727e56cd06ee188dLL,
    0x227c4d2e2f35bc37LL, 0x977421488bb333c0LL, 0xa21d7512a5ab8b30LL,
    0xbb4750817e010d0aLL, 0x6cf96dd7b0fddf33LL, 0x2801f78bee97525dLL,
    0x1c9e783b41fbf10fLL, 0x9d099bed4a11ddaaLL, 0x7a1aaf4930a4c056LL,
    0x32b44ad343a1f974LL, 0x3cfb763499267b89LL, 0xb2d572efc93fce73LL,
    0x63408adaeb0e466cLL, 0xada4921ffe58126fLL, 0x5fbbfcee72283de5LL,
    0x6ad2a8b45c308515LL, 0x0c567fc62d6fb44cLL, 0x956d62697c5b0571LL,
    0x25a153a7428cfdb3LL, 0x150c5a55f6c53276LL, 0xe2d7690ce0e46ac9LL,
    0xda1e997a62e77dd7LL, 0xf5c27078e1c96e0eLL, 0xc344bce9b94dfbedLL,
    0x60af12119d926b7fLL, 0xa1f2edd9d337a623LL, 0xcad69e870e733894LL,
    0x3770177bd9f08e41LL, 0xa5c06b9bc812cab4LL, 0x1f71e0f03767dc1cLL,
    0x44f89a5c5e6a8d6eLL, 0x6159c9fb1ce670ddLL, 0x8e2e04db5019b5faLL,
    0x8805c1b8bcd4efdcLL, 0xe138f1c7967847daLL, 0x4ab7a6bb84ed0f93LL,
    0x0000000000000000LL, 0x38c9f0768203171eLL, 0x1b4366b22c42b08bLL,
    0x7803ec68c74cf6e7LL, 0xec9855eb3a63e834LL, 0xbe830d29e4507a3fLL,
    0x2dc5aa2374c62568LL, 0xa62ff350be8ee7a7LL, 0x764cd08f1dcb741aLL,
    0x8c3747faa7f1834bLL, 0x0fb9e70d5bf3995fLL, 0x55c6464bb38ad38fLL,
    0xf7db3359162158bfLL, 0xd195f8352231881fLL, 0x0992226eb73ec379LL,
    0x14fa81bf77b129d4LL, 0x48aee59a73053922LL, 0x2457884dc3f8e611LL,
    0xffbfcadd206b8064LL, 0xb4feb78c25f29455LL, 0x864afd5f66536d21LL,
    0x6f16f51cc661f220LL, 0xde2c1f3879c21140LL, 0x195a2593dbaa863aLL,
    0x2e2a32e8025a087bLL, 0x432584d533d3cceaLL, 0x2c3371c9f5b23ecaLL,
    0xa7d928ba3ffafc05LL, 0x42d35f3fb2a7d748LL, 0x85a5659410cf4032LL,
    0x0864f984364ad8dbLL, 0xf21f6ef18c702f8aLL, 0xf1f0f63afaec0299LL,
    0xd9f101b1147b50c4LL, 0x2fdce902832e13d9LL, 0x4d6ab832e9544e17LL,
    0xe0ce2a2d170c5c78LL, 0x51f4c009a8afbf18LL, 0x68cbeb95abd8b3a4LL,
    0xc15dffc84ea5cd5cLL, 0x02194321f7e836b1LL, 0x113edc17ede05ee1LL,
    0x521b58c2de33920bLL, 0x9ad4856427a89c2eLL, 0x5629de80c516fe9cLL,
    0x77ba0b659cbf6fb8LL, 0x238a96c4ae41a795LL, 0x12d144dc9b7c73f2LL,
    0xd807da5b950f4b66LL, 0x3686cc91588495e3LL, 0x18acfe795ade9d98LL,
    0x5a7fa146e8794ad0LL, 0xc680e141231c8cd8LL, 0x1e873b1ab613c7beLL,
    0xf434ab9260bd75acLL, 0xcd0b800e63ca7910LL, 0xbc9a4e0813b84c8eLL,
    0x3d0dadde1852602bLL, 0x40ca1c1e454fe1f9LL, 0x0a7dbaa5c1a2ee6aLL,
    0x693d307f2aaca806LL, 0x0e4f3ce7da8782fdLL, 0xbd6c95e292cc572cLL,
    0x3ad0b35775eb21afLL, 0x7e28290b2b81acc1LL, 0x01f6dbea81741ba2LL,
    0x87bc26b5e7277683LL, 0x393f2b9c03770cbcLL, 0xddc387f30f5e3c53LL,
    0xeb454b6257daa9b0LL, 0xb323a905484bd5d1LL, 0xb13aea24bfa3e360LL,
    0x315bd218353dd467LL, 0x2bee6f40980b7f4eLL, 0xe95c0843a0329f01LL,
    0xc56f798a5580a1cbLL, 0xbf75d6c36524619dLL, 0x29f72c616fe349ffLL,
    0xc0ab2422cfd1d6feLL},

   {0x561fc423e957943cLL, 0x014287ca69079288LL,
    0x2f086129dfcd1d21LL, 0xc537d4aea044fd99LL, 0xf1e8c3bfd7c8a457LL,
    0x2971998a5cdf9bfbLL, 0x23fa649a2ce9e460LL, 0x3aa9e9c356a6716aLL,
    0xd6efa4e7aa3d1708LL, 0x705a24b1fda5b5ebLL, 0x101e0ce2b170a9fcLL,
    0x7ca821020e814caaLL, 0x0bc97ada1931ed13LL, 0x34df1711778c59ceLL,
    0xd35020ef9226d2bfLL, 0x575d43e9805006b4LL, 0x91acebec9b1db840LL,
    0x549b3f423b5945d9LL, 0x99a3ed9d3925163eLL, 0x7917a50a369a891dLL,
    0xe372343cb4b6dc4eLL, 0x8d40e2bdd949e8fdLL, 0xcfbc29bed0728202LL,
    0x969794857108ac12LL, 0xdd26de3db30cfa1bLL, 0x115c8b28d8773b74LL,
    0xe9f9c92cc480a3d5LL, 0x4dc8b21b4116d0d3LL, 0x316093194f979c79LL,
    0x5124bb4a0342806eLL, 0xb31408bcdef3cea8LL, 0xc1cad76cf158aaa6LL,
    0x88ff66b5e1522d4aLL, 0xa8c37e8476b28a47LL, 0x15a188ea896b6c4bLL,
    0xa24883940684f5dcLL, 0xda1da1545919ee49LL, 0x22b8e35045ee76e8LL,
    0x6106af9925d28e9fLL, 0xef80318f4792250fLL, 0x663dd0f0cfc79acdLL,
    0x302214d326900ef1LL, 0xdfa2255c61022bfeLL, 0xe6cdb0348cad19f9LL,
    0x50663c806a4512e6LL, 0x65fbac5b74ced9a0LL, 0xc4755364c9436f11LL,
    0x8fc419dc0b473918LL, 0x5c9439339961eba7LL, 0x3f166dcb6ebdb4ddLL,
    0xba59890715ccf25eLL, 0xf0aa4475becf36dfLL, 0x03c67cabbb09436dLL,
    0xb99ff5acaec5b133LL, 0xf9e7c5ce75f00a29LL, 0x6df4aa2ad6f677deLL,
    0xaeba8627f5a00c9dLL, 0xa573fcfdec91e18eLL, 0x7f6e5da9b5880fc7LL,
    0xca03adb6e86947b5LL, 0x74a72773acb9e2d4LL, 0x604428534cd51c17LL,
    0xf8a542041cf798a1LL, 0x448533a08a29ec25LL, 0x80f060c4436a8334LL,
    0x0db082799a236bc9LL, 0xfa21b965cef94944LL, 0x64b92b911dc94b28LL,
    0x7118a37b94a22763LL, 0xaff801ed9ca79e15LL, 0x1dae8e9b2b53c235LL,
    0x13d870490a79ea91LL, 0x8a7b9dd4335cfcafLL, 0x1f2a75faf95d13d0LL,
    0xeec2b6452e95b787LL, 0xc34e2c0d23567b43LL, 0x47434f0b3120af48LL,
    0xa18eff3fbd8db6b1LL, 0x98e16a57502284b6LL, 0x37196bbacc851aa3LL,
    0x8e869e166240ab90LL, 0x9fda153eba3790e4LL, 0xf515c07d86d4f368LL,
    0x72dedfd02fab640eLL, 0xe230b3f6ddb14ec6LL, 0x97d5134f180f3e9aLL,
    0xe1f6cf5d66b80dabLL, 0xe78f37fee5aa8b71LL, 0xa30a045e6f836754LL,
    0x90ee6c26f21a2ac8LL, 0xaa4785e5a4bc5ba2LL, 0x4e0eceb0fa1f93beLL,
    0x94136fe4a3067df7LL, 0x7b935e6be49458f8LL, 0x9b2716fceb2bc7dbLL,
    0x840d63061276d40bLL, 0xed04caee959cf4eaLL, 0xea3fb5877f89e0b8LL,
    0xb56df01f5de14872LL, 0x4935b1d9100a87ecLL, 0x82749ba5916452d1LL,
    0x58693af1c87dbc98LL, 0x89bde17f8855bfc2LL, 0x677f573aa6c00845LL,
    0xeb7d324d168e7230LL, 0x0284fb61d20ed1e5LL, 0xb190f3dd0cfd1f4dLL,
    0x684b2e22eeedb269LL, 0x2bf562eb8ed14a1eLL, 0xe0b448970fbf9f23LL,
    0x396f9568edaf3207LL, 0x52e2c7e1b84bc303LL, 0x77615bd817b0a1b9LL,
    0x7e2cda63dc8f9d4fLL, 0xf22ebf146cc1e73aLL, 0xc08850a6985f382eLL,
    0xd9dbddffe210ad24LL, 0xbfe60d0f2dd737e9LL, 0x9a659136822c5553LL,
    0x87cb1fada97f9766LL, 0x4c8a35d12811425bLL, 0x83361c6ff863c059LL,
    0xd212a725fb214037LL, 0x9e9892f4d330026cLL, 0x45c7b46ae32e7eadLL,
    0x5baf465a7374fff5LL, 0xdc6459f7da0b6893LL, 0xd46b5f867833c6edLL,
    0x5dd6bef9f066792fLL, 0xcb412a7c816ed53dLL, 0x75e5a0b9c5be705cLL,
    0xf6d3bcd63dddb005LL, 0xfb633eafa7fedbccLL, 0xd529d84c11345465LL,
    0xc9c5d11d536004d8LL, 0xdb5f269e301e7cc1LL, 0x86899867c07805eeLL,
    0x3d9296aabcb36538LL, 0x2cce1d8264c45e4cLL, 0x5aedc1901a736d7dLL,
    0x2e4ae6e3b6ca8fa9LL, 0x1e68f230905a8158LL, 0xdee0a2960805b976LL,
    0xcd38d2df027c53e7LL, 0x6909a9e887ea20e1LL, 0x24c11bf3c6fcf032LL,
    0x18110a9313480782LL, 0xa7f7079c3e9f306bLL, 0xd8995a358b173facLL,
    0x854fe4cc7b714683LL, 0xbd62f66effd9e60cLL, 0x14e30f20e06cfec3LL,
    0x6e32d6816dff34b3LL, 0x217e9ffbfee73585LL, 0xc88756d73a679650LL,
    0x359d90db1e8bcb46LL, 0x2645e09214f221d7LL, 0x04fd03c2511c573fLL,
    0x739c581a46acf686LL, 0xb0d2741765fa8dc5LL, 0xa0cc78f5d48a2439LL,
    0x5e10c2524b6f3a42LL, 0xe50bcc9f37a45a94LL, 0x53a0402bd14c518bLL,
    0x413ab7a8b2322992LL, 0x203c183197e0a70dLL, 0xcc7a55156b7bc16fLL,
    0x4601c8c158273dc0LL, 0xbea48ac544d0a561LL, 0x638254f8f7dc5f7aLL,
    0xa6b580565798a2e3LL, 0x3cd01160d5b4f7b0LL, 0x8c026577b04e7a75LL,
    0x7ad1d9a18d93ca70LL, 0x785522c05f9d1b95LL, 0x5f5245982268a8caLL,
    0x9551e82eca01ef7fLL, 0x0000000000000000LL, 0xbb1b0ecd7ccb60d6LL,
    0x094d81bbcb3f3cf6LL, 0x28331e4035d80973LL, 0xf7913b1c54da228dLL,
    0x6acfd5433ce3638cLL, 0x1bd77638a84144efLL, 0x62c0d3329edbcdf2LL,
    0x81b2e70e2a6d11bcLL, 0xd7ad232dc33a8580LL, 0x05bf8408381bc5b7LL,
    0x33e468789d994d9cLL, 0xfedcbaa79fe51e7bLL, 0x4f4c497a93180136LL,
    0x073b7f69ea151452LL, 0x0cf205b3f324f941LL, 0x382d12a284a8a08fLL,
    0x1cec0951425450bdLL, 0x55d9b888525ed751LL, 0x6cb62de0bff1e556LL,
    0xd1d4db8e4028035aLL, 0x25839c39affb62baLL, 0x4af3cd72ab03c481LL,
    0xa4317b3785967306LL, 0x1a95f1f2c146d667LL, 0x926a97472014fb2dLL,
    0xb7e90b7e8fef9997LL, 0xcefeae74b975108aLL, 0x3e54ea0107ba2655LL,
    0xd0965c44292f91d2LL, 0xab05022fcdbbc92aLL, 0xfd1ac60c24ec5d16LL,
    0xfc5841c64debcf9eLL, 0xe4494b555ea3c81cLL, 0xb6ab8cb4e6e80b1fLL,
    0x3beb6e093fa1e3e2LL, 0xf36c38de05c675b2LL, 0x9c1c6995013ed389LL,
    0x8b391a1e5a5b6e27LL, 0xec464d24fc9b6662LL, 0xad7cfa8c4ea94ff0LL,
    0x0f347918482dba2cLL, 0x9d5eee5f68394101LL, 0x7623dc127eb73331LL,
    0x32a6efb2f49edf14LL, 0x2d8c9a480dc3ccc4LL, 0xb2568f76b7f45c20LL,
    0x0e76fed2212a28a4LL, 0x48773613790d1564LL, 0x129af783637e7819LL,
    0x080f0671a238ae7eLL, 0x365bec70a582882bLL, 0x42fccb03093b6affLL,
    0x0a8bfd1070367f9bLL, 0xff9e3d6df6e28cf3LL, 0xe8bb4ee6ad87315dLL,
    0xc7b32fcf724a2c7cLL, 0xb8dd7266c7c223bbLL, 0x9328108d491369a5LL,
    0x0679f8a3831286daLL, 0x270767587df5b35fLL, 0xa981f94e1fb518cfLL,
    0x6b8d528955e4f104LL, 0x1667f44132622f26LL, 0x2ab7e521e7d6d896LL,
    0xac3e7d4627aedd78LL, 0x7deaa6c86786de22LL, 0x1725738b5b65bdaeLL,
    0x4bb14ab8c2045609LL, 0x592bbd3ba17a2e10LL, 0xc20cabc74a51e9cbLL,
    0x6f70514b04f8a63bLL, 0xbc2071a496de7484LL, 0x19538d597a4f950aLL,
    0xf45747b7efd361e0LL, 0x43be4cc9603cf877LL, 0xc6f1a8051b4dbef4LL,
    0xb42f77d534e6dafaLL, 0x40783062db35bb1aLL},

   {0xf5a96c292deb0a4eLL,
    0x211c9df6ee653c51LL, 0x04de5ddcbeeef596LL, 0xe1e5b06f7457c19fLL,
    0x74ca30f014a54fb6LL, 0xc296f9f7c5457d85LL, 0x7d4ee08a484d10b0LL,
    0xae87f2d0bf9b13adLL, 0x8df4bb480e89afb7LL, 0x2d8b7a67d9a2d61eLL,
    0x0f3559c8bd712adbLL, 0x541bc7312f013338LL, 0x9ec4848b636d5164LL,
    0x952f809f60f28e29LL, 0x28984d8cb28d6357LL, 0xd4b5f1dfc38e361fLL,
    0x5674135f7076b373LL, 0xb791a330042172ecLL, 0xab94c53bd4b4a6e4LL,
    0xf17731f59305ffd8LL, 0x39c7a621801e1dcfLL, 0x20d1f7c13ba47c8eLL,
    0x5e3da912f95facaaLL, 0xb1202a82e5b80731LL, 0x13303fc36de4fed3LL,
    0x2e29c43e5314168aLL, 0x861fbf5c0d1670faLL, 0x6458b16af3f771f1LL,
    0x3043765bdcf642c9LL, 0x12fd55f4b825be0cLL, 0x0a266e23d65e9f92LL,
    0x6595db5d2636312eLL, 0x85bd010587a0b06eLL, 0x9bd7b3600842e42dLL,
    0xaa59af0c0175e63bLL, 0x240faa1d854a8918LL, 0xf464061ef82a4a91LL,
    0x5c527d7ca6282ce1LL, 0x03a2be598ab6c094LL, 0x40571b7776bdf8e9LL,
    0xe4f687841f7874d6LL, 0x115febad32937e98LL, 0x5108f0da442e8671LL,
    0x9cab50e53c1ad12fLL, 0x33e1c8025640825dLL, 0x87d2d56bd8d73025LL,
    0xc0f92d999a32fdceLL, 0x62e938d8126e042cLL, 0x4a717554a0e3677bLL,
    0x0beb0414039fdf4dLL, 0xd6da25b19cf9b654LL, 0x55d6ad06fac073e7LL,
    0x632452efc7af44f3LL, 0xb5fe775e5b56f2a7LL, 0x892ae694b0675a21LL,
    0x7a32030f7c1525b2LL, 0x5d9f174b73e96c3eLL, 0xc35b93c010843d5aLL,
    0x373f95dee8ae77cbLL, 0xfb515fd6455b604aLL, 0xa9fb11558bc326afLL,
    0x22be23af64d3fcc5LL, 0xa8367b625e026670LL, 0xb8a4faf8b9505837LL,
    0x785dd7612362a5f9LL, 0x588c20a018c6d977LL, 0xea0eb47b77c81ed2LL,
    0xa6ce489d36b20c74LL, 0x0c97e79137c7ea4fLL, 0x7c838abd9d8c506fLL,
    0x57b97968a5b7f3acLL, 0x6c110b277ade6e28LL, 0xc785ce1cae6ac8ccLL,
    0x1581b6718c7d8b0eLL, 0x614b868198d8c4b8LL, 0x27ad14440ffc498cLL,
    0xdb80a8177eff1cc4LL, 0x472bf8f242e5cdebLL, 0x8a8858cd3ad19ab5LL,
    0xf60bd270a75dcadaLL, 0x43f5a52efc0b387dLL, 0x6ddc6110af1f2ef7LL,
    0xf0ba5bc246c4bf07LL, 0x6fb3b57ef068aebcLL, 0x18db3bd76e7b219eLL,
    0x903cb7740bdd3b60LL, 0x7bff6938a9d4656dLL, 0xbdb7cd13d27fed7eLL,
    0x051337eb6b2fb549LL, 0x77688ea99e138f22LL, 0xd9ef7c7921889c8fLL,
    0x077ce38534583502LL, 0xf318e59bcc727f93LL, 0xb34ffeecbacf877aLL,
    0xe9ac0a22fd7ede46LL, 0xfc2dbc5371035548LL, 0x026fd46e5f77804bLL,
    0xe53bedb3cab93409LL, 0xcc6eca08adf51781LL, 0xe028da58a1968140LL,
    0x3a6518780aa8dd5bLL, 0xce011e66f28297caLL, 0xa4a19cf369c58c3fLL,
    0xc5ea1a72f11d4887LL, 0xc427704524dc0858LL, 0x4238cf1929ca78a2LL,
    0x481ea13aff94e730LL, 0xdf5ef5cbc011e952LL, 0x80ae36eeec8f0527LL,
    0x5ae3f4ce47b1593cLL, 0xcda3a03f7834575eLL, 0x71d9071b7f8afaffLL,
    0xcadf43ba4c6c625cLL, 0x1623082806cb4b9aLL, 0x17ee621fd30a0b45LL,
    0x448946abc8530d7fLL, 0x974054f13f850e62LL, 0x73b6d37520fd7ab4LL,
    0xc8b097d4131be217LL, 0x9f09eebcb6ac11bbLL, 0x45442c9c1d924da0LL,
    0x1b79858ee4cde10aLL, 0x0984d07a5ce85f06LL, 0x4cc0fce6417a12a6LL,
    0x99b8670e57356466LL, 0xad254c89352dd339LL, 0x322ca2358381c282LL,
    0xcfcc74512743d715LL, 0x6b6de8a24e865b2aLL, 0xda4dc220ab3e5c1bLL,
    0x88e78ca365a61afeLL, 0x939e092d816bfbf4LL, 0xcb12298d99ad2283LL,
    0xeed0e9a7c926eb44LL, 0x98750d3982f424b9LL, 0xd5789be8164f76c0LL,
    0xbe15734a58c92deaLL, 0x49d3cb0d2a55a7efLL, 0x67fa0f337941b165LL,
    0x8c39d17fdb48ef68LL, 0x25c2c02a508bc9c7LL, 0x349d2b876218b75fLL,
    0x70146d2caa4bba20LL, 0x1c05660bd095d408LL, 0xfe42683d2e74d503LL,
    0x9a1ad957dd83a4f2LL, 0xf2d58fac19b33f4cLL, 0x81635cd9394e45f8LL,
    0xb65cc907d1e03233LL, 0xdd3121a59f666919LL, 0x318e1c6c09370216LL,
    0x8b4532faef10da6aLL, 0x191651e0bbba6141LL, 0x3f762f9361876812LL,
    0xb96990cf6c9118e8LL, 0xb4331d698e97b278LL, 0xd822164ef449dc50LL,
    0x84706b325261f0b1LL, 0x4eaf28881e0d92edLL, 0x69023ccc11f1db61LL,
    0x66376504ac80f1baLL, 0x0849ba4d89291fd9LL, 0xff8f020afbb595dcLL,
    0x50c59aed91efc6aeLL, 0x1dc80c3c055494d7LL, 0x1e6ab2658fe25443LL,
    0x3d19fbfd3ef0e859LL, 0xfa9c35e1909a2095LL, 0x52aa4e83ce9846e5LL,
    0x419a7140a37cb836LL, 0xa07fc12fd72b79a9LL, 0x68cf56fbc4309bbeLL,
    0x01cd6a37d5c140dfLL, 0x9253631a54aabb2bLL, 0xd06bac037d60c389LL,
    0x295527bb674c2388LL, 0xd204786d221743c2LL, 0x0000000000000000LL,
    0xf7c6b847729c8a05LL, 0xdcfc4b924aa729c6LL, 0xe38a64012b2041d4LL,
    0xb28294db6f0ec7a5LL, 0x9d663ad2e9db91f0LL, 0x91f1dd43de1c7bbfLL,
    0x6086ecb64d198467LL, 0x59414a97cd0799a8LL, 0xace826bee0ec93e6LL,
    0xa56cf6c4bc04cce0LL, 0x727bb942f53c3a6bLL, 0x6e7edf4925a9ee63LL,
    0x26607e73da3d0953LL, 0xe75439dd95ceb442LL, 0x7990bd56f6a3e526LL,
    0xecbf3dc996516b0fLL, 0x76a5e49e4bd2cffdLL, 0x968d3ec6ea444ebdLL,
    0x5b2e9ef9927019e3LL, 0x6aa082959b471bf5LL, 0xbb0644a133e698a3LL,
    0x830c88b76639c5b3LL, 0xe2470e36fee1010bLL, 0xb0ed40b5307947eeLL,
    0x355041b0b7d9f780LL, 0x8e560511843f6f23LL, 0x7f2134e4173a90fbLL,
    0x2af799e2edfae31cLL, 0x4bbc1f63752227a4LL, 0xf8f3e18fcfeda0deLL,
    0x0d5a8da6e206aa90LL, 0x2c4610500c6396c1LL, 0xde939ffc15d0a98dLL,
    0xaf4a98e76a5a5372LL, 0x8f9b6f2651fe2ffcLL, 0x36f2ffe93d6f3714LL,
    0x0ef833ff68b06a04LL, 0xe69953ea400ff49dLL, 0x23734998b112bc1aLL,
    0x3ebb45a4b44628cdLL, 0x1ab4efb9310ca1d5LL, 0x2fe4ae0986d55655LL,
    0xebc3de4ca2095e0dLL, 0x536724b41b59063aLL, 0x46e692c597248d34LL,
    0x2b3af3d5383ba3c3LL, 0x3ba8724fdf699d84LL, 0xc13447ae4ff3bd11LL,
    0x4d0d96d194bb5279LL, 0xfde0d664a4c21597LL, 0xd7174f864938f68bLL,
    0x7eec5ed3c2fbd024LL, 0xbfd8197d8d086d35LL, 0x4f6242bfcbccd232LL,
    0xa70322aae3734cabLL, 0xa3dd7f765d9db93dLL, 0x94e2eaa8b533cef6LL,
    0x144cdc4659bccbd1LL, 0xc648a42b7bab8813LL, 0xf93e8bb81a2ce001LL,
    0xbacb2e96e627d87cLL, 0xbc7aa72407beada1LL, 0xc97dfde3c6daa2c8LL,
    0xa1b2ab1802ea3976LL, 0x1fa7d8525a23149cLL, 0x75075ac7c1640f69LL,
    0xe861601528bf9e99LL, 0xa2101541885cf9e2LL, 0xef1d83901ce7ab9bLL,
    0x06b189b2e19975ddLL, 0x380acc1655df5d10LL, 0x1092819ae7523e47LL,
    0xd3c9125af7d6031dLL, 0xd1a6c634a8a18356LL, 0x5ff0c3252c9eec75LL,
    0x82c1e280b3f8856cLL, 0xed7257fe43902bd0LL, 0x3cd491caeb31a886LL},

   {0x94af9eb6fad9e7dfLL, 0x9208ae5e03c94dddLL, 0x1d8de8d67158480bLL,
    0xfd093cd2ba147af8LL, 0xa45ceb22e6597ccfLL, 0x9bbde6e77bf113daLL,
    0xe4edf4b465fffe5cLL, 0x7125622e4e8d2a2fLL, 0x1791b81b8f68430dLL,
    0xb56a63d1902195c0LL, 0xa980832b30d2ee67LL, 0x4c0a7fb384862397LL,
    0xed58bc0d1dc7a05bLL, 0x5955d7f05c4d0637LL, 0xd2b9b1c8806fcf4eLL,
    0x06a730e8f910aa02LL, 0xb8b60bd846aa0768LL, 0x45bf370afcbe7d90LL,
    0x16f6b0375ec370a1LL, 0x892276608b81afd4LL, 0xdcccc1b5d0ec08e7LL,
    0xe856949162df5f58LL, 0x82592e81a41a977eLL, 0xac8eabb74fca1164LL,
    0xfac9041692afe356LL, 0x3b882d75331ba3baLL, 0xa39cd3e6cee2e561LL,
    0xd077a190d7cca9e3LL, 0x9c7dde23534a8a74LL, 0x80973ed9f3b9f1d3LL,
    0xce535132209cb4e9LL, 0xaa299b5fb6dabb66LL, 0x2d7e9d426dd8d31bLL,
    0x8a8b6e140d89fad5LL, 0x6ca88af83fd56224LL, 0xf5db7c4713871753LL,
    0xeef1a4799bcff55aLL, 0x76e55aea6636b381LL, 0x8ee24ea4a33a367aLL,
    0x25acddd7c44bbeb0LL, 0x9adaeecbaa5a2076LL, 0x0e75707d5083c7a9LL,
    0x2bd9adaa94c87919LL, 0x19e4c866dfeb84a4LL, 0x129f9087f070bc0eLL,
    0xd9c2e929aff4f7e4LL, 0x6f01928cb9dd3725LL, 0x39463d2d64b8c517LL,
    0xebff8ce5e4d70a59LL, 0xb40d6bfd418aa66cLL, 0xf21b44833b3c8efdLL,
    0x3654457ce5903112LL, 0x431807e205aed792LL, 0xb10343613e92596fLL,
    0x0a1c50cdfe300b06LL, 0x778252c6b79d802dLL, 0x0cbb60250720a104LL,
    0xe1e3dc281ae7015fLL, 0x0f1278518128f405LL, 0x47712752ab1d1b3dLL,
    0xe24ac45c9cef545eLL, 0x1ceae0faa0f37ba7LL, 0x9814fe93fdf946dbLL,
    0xec3fb421cc6c93f7LL, 0x833e26ad75b1a4d2LL, 0x6b68b23c176efb8aLL,
    0x4904572ffb9edc94LL, 0x4bca4777ac3dba39LL, 0x2762cd8f93e8d81dLL,
    0x9eb3ce7b04e9ecd9LL, 0xc2e8311727bc15edLL, 0xea9884c9357c39f5LL,
    0xfc6e34fe6bbf4954LL, 0x13f898ab21db8fa2LL, 0xb7a47389c782f36dLL,
    0x7b3932e3b0bd2129LL, 0xaf27b3c3c9c24465LL, 0xb6c37ba51629c0c1LL,
    0x84fe1e695d0a3d7cLL, 0x1a4dd01259e3d1a5LL, 0xab4e9373677188caLL,
    0x90c6be06546a2b70LL, 0xf37c4cafea97bd51LL, 0x647aca6d96460f8fLL,
    0x4ec46febd325453aLL, 0x3e8605e94c035cb9LL, 0x0ddc6809d68b92a8LL,
    0x8bec6638dc22c979LL, 0x67d3d219104e5a8eLL, 0x2abea58645634ab5LL,
    0x5b9bc7a80bee609aLL, 0x936fa672d2627e71LL, 0x7d9e020b49ad8b2bLL,
    0x5832dfdc8de6359bLL, 0xc7e6198b58a4eaeeLL, 0xd41e8120797f654cLL,
    0xf4bc746bc22c24ffLL, 0xe084d404cb4c32f3LL, 0x48635f032a35ef38LL,
    0x8757061ddb02687dLL, 0x522e8f1173d63e9dLL, 0xbcdf2b68e819cbc7LL,
    0xbf76331c6e119ec6LL, 0x08d24095a9936dabLL, 0x728c7a5ac8857f2eLL,
    0xd110a9bc06679a4fLL, 0x1f43f88e26fb2ea6LL, 0xb2aa5b15b89a0c6eLL,
    0x4aad4f5b7d968995LL, 0x9fd4c657d542df75LL, 0x323d65cc4b23fdbdLL,
    0xc38f393bf6172641LL, 0xa152c3be994183ccLL, 0x9d1ad60f82e1b9d8LL,
    0xe744ecc0e3f7ab5dLL, 0x38213501b513f6bbLL, 0xade9a39b9e6122c8LL,
    0x37334d50343b02beLL, 0x55eeb7d55b6da733LL, 0x970686c27cd1b2deLL,
    0x427f0fced405e43eLL, 0xc026214f701f7340LL, 0x40b11f9683a68293LL,
    0x02ce105857a366adLL, 0x7e371a7fcfa5de2aLL, 0xffc72c8aedb71c55LL,
    0x68c1aa489166ae8bLL, 0xc68111a7890fd942LL, 0x79f722bbe71e4784LL,
    0xd579890ca8d456e0LL, 0x70426a029f261983LL, 0xb0644b4def396ac3LL,
    0xdb0cf971f8579149LL, 0x5489bff98ac6949fLL, 0x046920b0aeb3ccafLL,
    0x7cf90a279806b887LL, 0x050e289c7f18ff03LL, 0x651dc24147ed3c23LL,
    0x5e95ef3474f69f99LL, 0x6dcf82d4ee7e5188LL, 0x8f854688729105d6LL,
    0x81f036f52212c27fLL, 0xb9d103f4970134c4LL, 0x5349873da27d0d31LL,
    0x20a2f54bbb5341b3LL, 0xf0d554db6c9fe850LL, 0x07c038c428bb99aeLL,
    0x30f375941c809b10LL, 0x3fe10dc59da86f15LL, 0x46162f7e7ab62891LL,
    0xe623e4ec325c98f1LL, 0xfea024a63c1c2ff9LL, 0x349a5524b23357bfLL,
    0x35fd5d0863986413LL, 0x96618eeead7a8172LL, 0xcb5d79ae5f844beaLL,
    0x21c5fd676af8721fLL, 0x5720a78d0ccec19eLL, 0xf6726433958f4252LL,
    0x8d4b56d02532637bLL, 0x24cbd5fb15e08d1cLL, 0x3aef2559e2b09016LL,
    0x5afccf84da455336LL, 0x51879765f5de6b9cLL, 0x2917bdf2c36b1fb4LL,
    0xa7f5f356605129ceLL, 0xc1412963a1b440ecLL, 0x3d2f1d9dca0b09b8LL,
    0xa53be30e37f24f63LL, 0x5ff2e718a55dac35LL, 0xa2fbdbca1f49d6cdLL,
    0xf7156c1f442471feLL, 0x7a5e3acf61161285LL, 0xca3a71828e2f7846LL,
    0x1b2ad83e8848e209LL, 0xa8e78b07e179ddcbLL, 0xef96ac554a64c6f6LL,
    0x0000000000000000LL, 0x6013eadd38f5c320LL, 0x3c4815b11ba03a14LL,
    0x09b548b978385e07LL, 0x226ce513ecf0271eLL, 0x63baf2a9befd9621LL,
    0x44d83f262d154e3cLL, 0xcdfa4946a694e1e8LL, 0x113688f37678e90fLL,
    0x859916458ca10ed0LL, 0xc52809d30f078c43LL, 0x4d6d779f552d103bLL,
    0x1e24f0a2f7501d0aLL, 0x0167082cd1ab33acLL, 0x1438a06f0960160cLL,
    0xf9601c6214a7b657LL, 0xa035cb9248eab060LL, 0x50e09f4924755830LL,
    0xd7b79954ff77304dLL, 0xe58afc98b454cdf0LL, 0x03a9187486085501LL,
    0x62ddfa856f56a58dLL, 0xc44f01ffdeacbfefLL, 0x73eb7276192e4c82LL,
    0xd6d091782edc03e1LL, 0xfbae0c3a4304d0faLL, 0x9973f6bf2c527577LL,
    0x105180dfa7d3daa3LL, 0x2605c5a34243ebb1LL, 0x91a1b62a85c118dcLL,
    0xc99369f608272d47LL, 0x5d3cf740f2feca98LL, 0xcf34591ef1378745LL,
    0xc8f461dad98c1eebLL, 0x0b7b58e12f9b38aaLL, 0xe32dcc704d4467f2LL,
    0x754c429ee03ee680LL, 0xd3deb9e451c4fce2LL, 0x6e669aa068760489LL,
    0x66b4da35c1e56922LL, 0x4fa367c7028e7696LL, 0xba781b80110961c5LL,
    0x41d617ba520db13fLL, 0x335a6de09a88ce11LL, 0xdf65d9c156e45de6LL,
    0xcc9d416a773fd244LL, 0x5c5bff6c2355f934LL, 0x2870b5de12c02c18LL,
    0x155fa843d8cb25a0LL, 0x78902a9736b57428LL, 0xae40bbef186977c9LL,
    0x88457e4c5a2a9c78LL, 0x6a0fba10c6c5c826LL, 0x7f5012531e0eed86LL,
    0x8c2c5efcf49950d7LL, 0x31947db8cd2ba8bcLL, 0x2c19956ebc73e0b7LL,
    0x230bed3f3d5b14b2LL, 0x69a6a26440cd9d27LL, 0x86300e310aa95bd1LL,
    0xb3cd533969313fc2LL, 0x1883c04a0e40b708LL, 0xf1b25cf7bd34dbfcLL,
    0x2fb08d1a3a7bb5b6LL, 0xd8a5e1057e5fc448LL, 0xddabc99901473b4bLL,
    0xde02d1ed874f6e4aLL, 0xbdb8234439b2f86bLL, 0x5647afa1dd65f232LL,
    0x2ed78536ebd0861aLL, 0xe9319cbdb3746cf4LL, 0xa692fb7ab1fa1a62LL,
    0x742b4ab23195d52cLL, 0x95c8969a2b72d473LL, 0x6174e2f1e95ef08cLL,
    0xf807144ec50c85fbLL, 0xbe113b30bfbaad6aLL, 0xda6bf15d29fca2e5LL,
    0xbb1f13acc0a25269LL},

   {0xc22b27f0f9e37bf9LL, 0x93fad23f0955ef09LL,
    0x32ed4b84a22a91a2LL, 0x3898b57bcc61b1ccLL, 0x55825ba9ad98e5adLL,
    0xb2eeb8069421ec94LL, 0xc7eb5875ce3c6bceLL, 0x4b1dac5d1f45851fLL,
    0xc16ba1204705d847LL, 0xc5380f461a2ba91aLL, 0xb908971a909bad90LL,
    0x303e1cb7763d5376LL, 0xe6ff324c53486853LL, 0x6d1aeed261f95461LL,
    0x0193d1e36af1616aLL, 0x51d1f5cff0b694f0LL, 0x29b2c3f52728e127LL,
    0x112a768eeb4950ebLL, 0x8fb672f86f9f4d6fLL, 0xf0c66c745bc9ea5bLL,
    0x3f8b9dcd2fa9632fLL, 0x65bc471edba5b6dbLL, 0x4d9d5508967c3696LL,
    0x3a4be24818767318LL, 0x2794936c144db014LL, 0x2af2452599ce4299LL,
    0x4a8e7dbe75b4e475LL, 0x9ddc82a63a30be3aLL, 0xade29e114c0ded4cLL,
    0xd1d2064dc6bde9c6LL, 0x7da349bfe04165e0LL, 0x6b9a1787e8c0e7e8LL,
    0xa54437ddf6510ff6LL, 0x2254ece92392a023LL, 0x79f0e7d9bd6f14bdLL,
    0x57510c9a798f2779LL, 0x346db2d12b13222bLL, 0x54118a4ac76984c7LL,
    0xefca4a6383e5eb83LL, 0xca8d8e3c43bf9943LL, 0xfc336bdebcbb79bcLL,
    0x3e184c2e45580245LL, 0xf495c21206e79b06LL, 0xff73ed0e025dda02LL,
    0x4228d472cfe806cfLL, 0xbcc8e89fa744bda7LL, 0xab626744c5345ec5LL,
    0xb6bd1660c90f9dc9LL, 0xb72ec783a3fefca3LL, 0x8be5dc9e32b13c32LL,
    0x485d2a8da1a326a1LL, 0xc6788996a4cd0aa4LL, 0x40fb83411bffc41bLL,
    0x08a6a9ccba5ce2baLL, 0xf386eaa4e52f49e5LL, 0x1acc5992eff311efLL,
    0xa2571f6b1599dd15LL, 0x44a82d2746d1b546LL, 0x70c59ff66dc2976dLL,
    0x8d6525cbbb888fbbLL, 0x963aadba3e8aff3eLL, 0x7c30985c8ab0048aLL,
    0x607c389bec7aa6ecLL, 0xa822e1947bd2fd7bLL, 0x034086d0bee6a3beLL,
    0x66fcc1ce65431565LL, 0xb37d69e5fed08dfeLL, 0x2f323aa0ae1152aeLL,
    0x56c2dd79137e4613LL, 0x31adcd541ccc321cLL, 0xdff456d4f5d8b8f5LL,
    0xf9f3145b8b64698bLL, 0x764566a3e4fb24e4LL, 0x0cf507aae77293e7LL,
    0x59775c034aea764aLL, 0xb89b46f9fa6accfaLL, 0xe8d962d5602d3960LL,
    0x17aa8fdb6270e362LL, 0x1c4ca0c766caa266LL, 0x2de16d937a06907aLL,
    0x2547c45fc05a72c0LL, 0x0fb5817a59943059LL, 0x0680f9558939b389LL,
    0x16395e3808818208LL, 0xac714ff226fc8c26LL, 0xa9b1307711239c11LL,
    0xec8accb33d03483dLL, 0x6c893f310b08350bLL, 0xc4abdea570dac870LL,
    0xba4811ca2e7d0e2eLL, 0xf155bd9731388b31LL, 0xdd2701e721cf7a21LL,
    0xe94ab3360adc580aLL, 0x23c73d0a4963c149LL, 0x5cb723867d35667dLL,
    0x5042242c9a47f59aLL, 0x198cdf425115b251LL, 0x0a75feff6e4b206eLL,
    0xfda0ba3dd64a18d6LL, 0xcede205a1e91e81eLL, 0xd041d7aeac4c88acLL,
    0xe42c657f875faa87LL, 0x36bee5e2ff04e0ffLL, 0x6fc9b9e1b5ee96b5LL,
    0x998f2cc0671ecf67LL, 0xd301517e12aa2b12LL, 0xaea218c1f2eb4ef2LL,
    0xda342951c207a8c2LL, 0x61efe978868bc786LL, 0x7f701e8c3456a734LL,
    0x0be62f1c04ba4104LL, 0x9129850cdd422dddLL, 0xd6c12efb25753b25LL,
    0xe33f4dc964977864LL, 0x1579d8e8b66721b6LL, 0xf860c5b8e19508e1LL,
    0x7496319030ece630LL, 0x88a55a4e8c579f8cLL, 0xcf4df1b974608974LL,
    0x10b9a76d81b83181LL, 0x0e26509933655133LL, 0x43bb0591a51967a5LL,
    0x926903dc63a48e63LL, 0x9c4f534550c1df50LL, 0x3bd833ab72871272LL,
    0xa4d7e63e9ca06e9cLL, 0xb46e41531d185f1dLL, 0x126af05e55aff355LL,
    0x24d415bcaaab13aaLL, 0x1e9ff7f4b2dd60b2LL, 0x05c07f8537df1037LL,
    0x467b7a1492c67792LL, 0x2087bbdaf78562f7LL, 0x819022615cfa1c5cLL,
    0xcd9ea68aa0774ba0LL, 0xa79760ee2246cd22LL, 0x8343755288edde88LL,
    0x58e48de0201b1720LL, 0x7216c8c5b9d555b9LL, 0x372d340195f58195LL,
    0xa11799bbab7f7eabLL, 0x9f0fd595ee277ceeLL, 0x676f102d0fb2740fLL,
    0x9e9c047684d61d84LL, 0x49cefb6ecb5247cbLL, 0xd41279c8f162f9f1LL,
    0x1f0c2617d82c01d8LL, 0x97a97c59547b9e54LL, 0xe76ce3af39b90939LL,
    0xc3b8f61393121a93LL, 0x5ba40b309efdb49eLL, 0xea0a35e6b43afbb4LL,
    0x5a37dad3f40cd5f4LL, 0x14ea090bdc9640dcLL, 0x5e6474b5a922a4a9LL,
    0xfee03ced68acbb68LL, 0x071328b6e3c8d2e3LL, 0x5302a2fc24a15624LL,
    0x85c38c0701d46d01LL, 0x3d58cafefbbea1fbLL, 0x84505de46b250c6bLL,
    0x642f96fdb154d7b1LL, 0xbf886e4f19a21e19LL, 0x02d35733d417c2d4LL,
    0x68da915756264456LL, 0x8710db34d5c3afd5LL, 0x0d66d6498d83f28dLL,
    0x7b23b0ea6978d669LL, 0x1b5f887185027085LL, 0x3ccb1b1d914fc091LL,
    0x0453ae665d2e715dLL, 0xcb1e5fdf294ef829LL, 0xf6469521d2f059d2LL,
    0xb03def3540362e40LL, 0x633cbe4b529c0552LL, 0xf7d544c2b80138b8LL,
    0x7ab061090389b703LL, 0x0000000000000000LL, 0xdba7f8b2a8f6c9a8LL,
    0x35fe633241e24341LL, 0x21146a399d74039dLL, 0xd581a82b9b93989bLL,
    0x0935782fd0ad83d0LL, 0x5ff7a556c3d3c5c3LL, 0xaf31c922981a2f98LL,
    0x90ba54efb7b34cb7LL, 0x5291731f4e50374eLL, 0xc0f870c32df4b92dLL,
    0x7ee3cf6f5ea7c65eLL, 0xe07fcb19da71dbdaLL, 0x4eddd3d8289a9528LL,
    0x13f921bd3f5e923fLL, 0xf50613f16c16fa6cLL, 0x981cfd230defae0dLL,
    0x4c0e84ebfc8d57fcLL, 0x82d0a4b1e21cbfe2LL, 0x89368bade6a6fee6LL,
    0xd292809d785b4a78LL, 0x47e8abf7f83716f8LL, 0x8e25a31b056e2c05LL,
    0xd752ff184f845a4fLL, 0xcc0d7769ca862acaLL, 0x694940b43cd7253cLL,
    0x2ea1eb43c4e033c4LL, 0xde6787379f29d99fLL, 0x181f0ea13be4d33bLL,
    0x416852a2710ea571LL, 0x62af6fa8386d6438LL, 0xa0844858c18e1fc1LL,
    0x337e9a67c8dbf0c8LL, 0x2c72bc7010f7f110LL, 0xbd5b397ccdb5dccdLL,
    0xd8e77e6216106a16LL, 0x86830ad7bf32cebfLL, 0x4f4e023b426bf442LL,
    0xe5bfb49cedaecbedLL, 0x8a760d7d58405d58LL, 0xe2ac9c2a0e66190eLL,
    0xb5fd90b077e93e77LL, 0xdcb4d0044b3e1b4bLL, 0x453bfcc42c20d42cLL,
    0xed191d5057f22957LL, 0xe1ec1afab080bab0LL, 0xee599b80e9148ae9LL,
    0x2607428f7ebcd17eLL, 0x5d24f26517c40717LL, 0x6a09c66482318682LL,
    0xa604b10d48b7ac48LL, 0xbe1bbfac73537f73LL, 0x282112164dd9804dLL,
    0x7505e0735a1d875aLL, 0x73851926d32434d3LL, 0xd974af817ce10b7cLL,
    0xeb99e405decb9adeLL, 0x9b5c7bf3b3090db3LL, 0xfab3928b3582ca35LL,
    0x8003f382360b7d36LL, 0x94e9fa89ea9d3deaLL, 0xb1ae3ed62ac74f2aLL,
    0x9acfaa10d9f86cd9LL, 0x390b6498a690d0a6LL, 0xf2153b478fde288fLL,
    0x71564e150733f607LL, 0xa3c4ce887f68bc7fLL, 0xaaf1b6a7afc53fafLL,
    0x1ddf71240c3bc30cLL, 0x77d6b7408e0a458eLL, 0x2b6194c6f33f23f3LL,
    0xc9cd08ecfd593afdLL, 0xc85ed90f97a85b97LL, 0x8cf6f428d179eed1LL,
    0x957a2b6a806c5c80LL, 0xbbdbc029448c6f44LL, 0x7863363ad79e75d7LL,
    0x6e5a6802df1ff7dfLL, 0xfb2043685f73ab5fLL}
};

unsigned char slog[256], alog[256];
ddword cbox_enc_k[ROUNDS][8][256], cbox_dec_k[ROUNDS][8][256];
unsigned char pG[8][8];

/* print ssdwords */
void print64(FILE *f, ddword a)
{
   fprintf(f,"%08lx%08lx \n",(dword)(a >> 32), (dword)a);
}

/* multiply two elements of GF(2^m) */
unsigned char mul(unsigned char a, unsigned char b)
{
   if (a && b) return alog[(slog[a] + slog[b])%255];
   else return 0;
}

/* give the ddword that consists of
 * the 8 bytes that are the multiplicative
 * inverse of the 8 bytes a consists of
 */
ddword inverse(ddword a)
{
   unsigned char t;
   ddword r = 0;

   for(t = 0; t < 8; t++)
      r ^= ((ddword)alog[(255 - slog[(unsigned char)(a >> (56 - 8*t))])%255] << (56 - 8*t));
   return r;
}

/* check whether there are no
 * all-zero bytes in a
 */
unsigned char invertible(ddword a)
{
return (unsigned char)a & (unsigned char)(a >> 8) & (unsigned char)(a >> 16) & (unsigned char)(a >> 24)
  & (unsigned char)(a >> 32) & (unsigned char)(a >> 40) & (unsigned char)(a >> 48) & (unsigned char)(a >> 56);
}

/* produce logtabel and alogtabel,
 * needed for multiplying in the field GF(2^m)
 */
void init()
{
   word i, j;
   alog[0] = 1;
   for(i = 1; i < 256; i++) {
      j = alog[i-1] << 1;
      if (j & 0x100) j ^= ROOT;
      alog[i] = j;
      }
   slog[0] = 0;
   for(i = 1; i < 255; i++)
      slog[alog[i]] = i;
}

/* transform a roundkey
 * we use this when we interchange the key addition
 * and the linear operation
 */
ddword transform(ddword a)
{
   unsigned char i, j, k[8], t[8];
   ddword r;
   for(i = 0; i < 8; i++) k[i] = (unsigned char)(a >> (56 - 8*i));
   for(i = 0; i < 8; i++) {
      t[i] = mul(iG[i][0],k[0]);
      for(j = 1; j < 8; j++) t[i] ^= mul(iG[i][j],k[j]);
      }
   r = t[0];
   for(i = 1; i < 8; i++)
      r = (r << 8) ^ t[i];
   return r;
}


ddword encryption_key(ddword plain, ddword *roundkey)
{
   register ddword tmp = plain;
   register unsigned char r;

   for(r = 0; r < ROUNDS-1; r++) {
      tmp ^= roundkey[r];
      tmp = cbox_enc[0][(tmp >> 56) & 0xff]
          ^ cbox_enc[1][(tmp >> 48) & 0xff]
          ^ cbox_enc[2][(tmp >> 40) & 0xff]
          ^ cbox_enc[3][(tmp >> 32) & 0xff]
          ^ cbox_enc[4][(tmp >> 24) & 0xff]
          ^ cbox_enc[5][(tmp >> 16) & 0xff]
          ^ cbox_enc[6][(tmp >>  8) & 0xff]
          ^ cbox_enc[7][ tmp        & 0xff];
      }
   tmp ^= roundkey[ROUNDS-1];
   tmp = ((ddword)sbox_enc[(tmp >> 56) & 0xff] << 56)
       ^ ((ddword)sbox_enc[(tmp >> 48) & 0xff] << 48)
       ^ ((ddword)sbox_enc[(tmp >> 40) & 0xff] << 40)
       ^ ((ddword)sbox_enc[(tmp >> 32) & 0xff] << 32)
       ^ ((ddword)sbox_enc[(tmp >> 24) & 0xff] << 24)
       ^ ((ddword)sbox_enc[(tmp >> 16) & 0xff] << 16)
       ^ ((ddword)sbox_enc[(tmp >>  8) & 0xff] <<  8)
       ^  (ddword)sbox_enc[ tmp        & 0xff];
   return roundkey[ROUNDS] ^ tmp;
}

void encryption(unsigned char *plain, ddword* roundkey, unsigned char *ciphertext)
{
   register ddword tmp = 0;
   register unsigned char r;
   int i;

    for (i = 0; i < 8; i++) {
        tmp = (tmp << 8);
        tmp |= plain[i];
    }

    /* first key addition is not
     * incorporated in the cboxes
    */

   tmp = ((ddword)mul(tmp >> 56,roundkey[ROUNDS+1] >> 56) << 56)
       ^ ((ddword)mul((unsigned char)(tmp>>48),(unsigned char)(roundkey[ROUNDS+1]>>48)) << 48)
       ^ ((ddword)mul((unsigned char)(tmp>>40),(unsigned char)(roundkey[ROUNDS+1]>>40)) << 40)
       ^ ((ddword)mul((unsigned char)(tmp>>32),(unsigned char)(roundkey[ROUNDS+1]>>32)) << 32)
       ^ ((ddword)mul((unsigned char)(tmp>>24),(unsigned char)(roundkey[ROUNDS+1]>>24)) << 24)
       ^ ((ddword)mul((unsigned char)(tmp>>16),(unsigned char)(roundkey[ROUNDS+1]>>16)) << 16)
       ^ ((ddword)mul((unsigned char)(tmp>> 8),(unsigned char)(roundkey[ROUNDS+1]>> 8)) <<  8)
       ^ ((ddword)mul((unsigned char)tmp,(unsigned char)roundkey[ROUNDS+1]))
       ^ roundkey[0];

   for(r = 0; r < ROUNDS; r++) {
      tmp = cbox_enc_k[r][0][(tmp >> 56) & 0xff]
          ^ cbox_enc_k[r][1][(tmp >> 48) & 0xff]
          ^ cbox_enc_k[r][2][(tmp >> 40) & 0xff]
          ^ cbox_enc_k[r][3][(tmp >> 32) & 0xff]
          ^ cbox_enc_k[r][4][(tmp >> 24) & 0xff]
          ^ cbox_enc_k[r][5][(tmp >> 16) & 0xff]
          ^ cbox_enc_k[r][6][(tmp >>  8) & 0xff]
          ^ cbox_enc_k[r][7][ tmp        & 0xff];
      }

      ciphertext[0] = (unsigned char)((tmp >> 56) & 0xff);
      ciphertext[1] = (unsigned char)((tmp >> 48) & 0xff);
      ciphertext[2] = (unsigned char)((tmp >> 40) & 0xff);
      ciphertext[3] = (unsigned char)((tmp >> 32) & 0xff);
      ciphertext[4] = (unsigned char)((tmp >> 24) & 0xff);
      ciphertext[5] = (unsigned char)((tmp >> 16) & 0xff);
      ciphertext[6] = (unsigned char)((tmp >>  8) & 0xff);
      ciphertext[7] = (unsigned char)((tmp      ) & 0xff);
}

void decryption(unsigned char *cipher, ddword *roundkey, unsigned char *plaintext)
{
   ddword tmp = 0;
   unsigned char r;
   unsigned char t[8], i, j, u;

    for (i = 0; i < 8; i++) {
        tmp = (tmp << 8);
        tmp |= cipher[i];
    }

   tmp ^= roundkey[0];

/* first key addition is not
 * incorporated in the cboxes
 */
   for(i = 0; i < 8; i++) t[i] = (unsigned char)(tmp >> (56 - 8*i));
   tmp = 0;
   for(i = 0; i < 8; i++) {
      u = 0;
      for(j = 0; j < 8; j++) u ^= mul(pG[i][j],t[j]);
      tmp ^= ((ddword)u << (56 - 8*i));
      }

   for(r = 0; r < ROUNDS; r++) {
      tmp = cbox_dec_k[r][0][(tmp >> 56) & 0xff]
          ^ cbox_dec_k[r][1][(tmp >> 48) & 0xff]
          ^ cbox_dec_k[r][2][(tmp >> 40) & 0xff]
          ^ cbox_dec_k[r][3][(tmp >> 32) & 0xff]
          ^ cbox_dec_k[r][4][(tmp >> 24) & 0xff]
          ^ cbox_dec_k[r][5][(tmp >> 16) & 0xff]
          ^ cbox_dec_k[r][6][(tmp >>  8) & 0xff]
          ^ cbox_dec_k[r][7][ tmp        & 0xff];
      }

      plaintext[0] = (unsigned char)((tmp >> 56) & 0xff);
      plaintext[1] = (unsigned char)((tmp >> 48) & 0xff);
      plaintext[2] = (unsigned char)((tmp >> 40) & 0xff);
      plaintext[3] = (unsigned char)((tmp >> 32) & 0xff);
      plaintext[4] = (unsigned char)((tmp >> 24) & 0xff);
      plaintext[5] = (unsigned char)((tmp >> 16) & 0xff);
      plaintext[6] = (unsigned char)((tmp >>  8) & 0xff);
      plaintext[7] = (unsigned char)((tmp      ) & 0xff);
}

void box_init(ddword *roundkey_enc, ddword *roundkey_dec)
/*                                encryption   decryption
 * substitution                   sbox_enc     sbox_dec
 * linear diffusion               G            iG
 * matrix for linear transform    kappa        ikappa
 * exor-key                       K            K
 * whole operation                cbox_enc_k   cbox_dec_k
 *
 *  transform(kappa) = iG * kappa * G
 *  transform(K)     = iG * K
 *
 * encryption operation: (we take the following (!) key addition into cbox_enc)
 *  first R-1 rounds:
 *     cbox_enc(X) = kappa * G * sbox_enc(X) + K
 *  last round:
 *     cbox_enc(X) = transform(kappa) * sbox_enc(X) + transform(K)
 *                 = iG * kappa * G * sbox_enc(X) + iG * K
 *
 * decryption operation: (after reordening the operations)
 *  first R-1 rounds:
 *     cbox_dec(Y) = iG * ikappa * (sbox_dec(Y) + K)
 *  last round:
 *     cbox_dec(Y) = ikappa * (sbox_dec(Y) + K)
 */
{
   unsigned char i, j, r, t, G_k[8][8];
   word k;

/* encryption boxes
 */
/* first ROUNDS - 1 rounds
 */
   for(r = 0; r < ROUNDS - 1; r++) {
      for(i = 0; i < 8; i++)
         for(j = 0; j < 8; j++)
            G_k[i][j] = mul(G[i][j],(unsigned char)(roundkey_enc[r+ROUNDS+2]>>(56-8*i)));
      for(j = 0; j < 8; j++)
         for(k = 0; k < 256; k++) {
            cbox_enc_k[r][j][k] = 0;
            for(i = 0; i < 8; i++)
               cbox_enc_k[r][j][k] = (cbox_enc_k[r][j][k] << 8) ^
                                         mul(sbox_enc[k],G_k[i][j]);
            }
      for(k = 0; k < 256; k++)
         cbox_enc_k[r][0][k] ^= roundkey_enc[r+1];
      }
/* last round */
      for(i = 0; i < 8; i++)
         for(j = 0; j < 8; j++) {
            G_k[i][j] = 0;
            for(t = 0; t < 8; t++)
               G_k[i][j] ^=
                  mul(mul(iG[i][t],(unsigned char)(roundkey_enc[2*ROUNDS+1]>>(56-8*t))),
                      G[t][j]);
            }
      for(j = 0; j < 8; j++)
         for(k = 0; k < 256; k++) {
            cbox_enc_k[ROUNDS-1][j][k] = 0;
            for(i = 0; i < 8; i++)
               cbox_enc_k[ROUNDS-1][j][k] = (cbox_enc_k[ROUNDS-1][j][k] << 8) ^
                                         mul(sbox_enc[k],G_k[i][j]);
            }
      for(k = 0; k < 256; k++)
         cbox_enc_k[ROUNDS-1][0][k] ^= transform(roundkey_enc[ROUNDS]);


/* decryption boxes
 */
/* make the decryption keys
 */
   roundkey_dec[0] = transform(roundkey_enc[ROUNDS]);
   for(r = 1; r <= ROUNDS; r++)
      roundkey_dec[r] = roundkey_enc[ROUNDS-r];
   for(r = 0; r <= ROUNDS; r++)
      roundkey_dec[ROUNDS+1+r] = inverse(roundkey_enc[2*ROUNDS+1-r]);

/* first key addition: seperate
 */
   for(i = 0; i < 8; i++)
      for(j = 0; j < 8; j++) {
         pG[i][j] = 0;
         for(t = 0; t < 8; t++)
            pG[i][j] ^=
               mul(mul(iG[i][t],(unsigned char)(roundkey_dec[ROUNDS+1]>>(56-8*t))),
                   G[t][j]);
         }
/* first ROUNDS - 1 rounds
 */
   for(r = 0; r < ROUNDS - 1; r++) {
      for(i = 0; i < 8; i++)
         for(j = 0; j < 8; j++)
            G_k[i][j] = mul(iG[i][j],(unsigned char)(roundkey_dec[r+ROUNDS+2]>>(56-8*j)));
      for(j = 0; j < 8; j++)
         for(k = 0; k < 256; k++) {
            cbox_dec_k[r][j][k] = 0;
            for(i = 0; i < 8; i++)
               cbox_dec_k[r][j][k] = (cbox_dec_k[r][j][k] << 8) ^
               mul(sbox_dec[k] ^ (unsigned char)(roundkey_dec[r+1]>>(56-8*j)),G_k[i][j]);
            }
      }

/* last round
 */
      for(i = 0; i < 8; i++)
         for(j = 0; j < 8; j++) {
            if (i != j) G_k[i][j] = 0;
            else G_k[i][i] = (unsigned char)(roundkey_dec[2*ROUNDS+1]>>(56-8*i));
            }
      for(j = 0; j < 8; j++)
         for(k = 0; k < 256; k++) {
            cbox_dec_k[ROUNDS-1][j][k] = 0;
            for(i = 0; i < 8; i++)
               cbox_dec_k[ROUNDS-1][j][k] = (cbox_dec_k[ROUNDS-1][j][k] << 8) ^
               mul(sbox_dec[k] ^ (unsigned char)(roundkey_dec[r+1]>>(56-8*i)),G_k[i][j]);
            }
}

void key_init(unsigned char *key, ddword roundkey_enc[ROUNDKEYS])
/* produce the conceptual encryption roundkeys,
 * without any reordening
 */
{
   ddword tempkey[ROUNDS+1], a[ROUNDKEYS], tmp;
   unsigned char i, j, r, rr;

   /* read tempkey
    */
   for(r = 0; r <= ROUNDS; r++) {
      tempkey[r] = cbox_enc[0][r];
      }
   tempkey[ROUNDS] = transform(tempkey[ROUNDS]);

   /*  a = concatenation of key
    */
   i = 0;
   for(r = 0; r < ROUNDKEYS; r++) {
      a[r] = key[(i++)%KEYLENGTH];
      for(j = 1; j < 8; j++) {
         a[r] = (a[r] << 8) | key[(i++)%KEYLENGTH];
         }
      }

   /* conceptual roundkey_enc = SHARK_CFB(a,tempkey)
    * for r > ROUNDS, roundkey_enc[r] needs to have
    * a multiplicative inverse
    */
   roundkey_enc[0] = a[0] ^ encryption_key(0LL, tempkey);
   for(r = 1; r <= ROUNDS; r++)
      roundkey_enc[r] = a[r] ^ encryption_key(roundkey_enc[r-1], tempkey);

   r = rr = ROUNDS + 1;
   tmp = roundkey_enc[ROUNDS];
   while (rr < ROUNDKEYS) {
      tmp = a[rr++] ^ encryption_key(tmp, tempkey);
      if (invertible(tmp)) roundkey_enc[r++] = tmp;
      }
   while (r < ROUNDKEYS) {
      tmp = encryption_key(tmp, tempkey);
      if (invertible(tmp)) roundkey_enc[r++] = tmp;
      }
}

int main(void)
{
    unsigned char key[KEYLENGTH], i;
    ddword roundkey_enc[ROUNDKEYS], roundkey_dec[ROUNDKEYS];

    unsigned char ciphertext[8];
    unsigned char plaintext2[8];
    unsigned char cplaintext1[8] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01
    };

    init();
    for(i = 0; i < KEYLENGTH; i++) key[i] = i;
    key_init(key, roundkey_enc);
    box_init(roundkey_enc, roundkey_dec);
    printf("plaintext1 : ");
    for (i = 0; i < 8; i++) printf("%02x", cplaintext1[i]);
    printf("\n");
    encryption(cplaintext1,roundkey_enc, ciphertext);
    printf("ciphertext : ");
    for (i = 0; i < 8; i++) printf("%02x", ciphertext[i]);
    printf("\n");
    decryption(ciphertext, roundkey_dec, plaintext2);
    printf("plaintext2 : ");
    for (i = 0; i < 8; i++) printf("%02x", plaintext2[i]);
    printf("\n");
    return 0;
}
