package Crypt::AppleTwoFish;

use strict;
use warnings;
use Carp;
use vars qw($VERSION);
$VERSION="0.03";

my(@apple_tf_iTMS, @apple_tf_DRMS);

sub new	{
	my($class, $key) = @_;
    my $self = {};
    bless $self, $class;
    $self->{key} = $key;
    return $self;
}

sub key {
    my($self, $new_key) = @_;
    $self->{key} = $new_key if defined $new_key;
    return $self->{key};
}

sub process_iTMS_key {
    my($self) = @_;
    my $k = '';
    my $key = $self->{key};
    my $siz = length $key;
    for(my $i = 0; $i < $siz; $i++) { 
        $k .= chr $apple_tf_iTMS[$i % 16]->[ord substr($key, $i % 16, 1)];
    }
    return $k;
}

sub decrypted_for_iTMS { return shift->process_iTMS_key() }

sub process_DRMS_key {
    my($self) = @_;
    my $k = '';
    my $key = $self->{key};
    my $siz = length $key;
    for(my $i = 0; $i < $siz; $i++) { 
        $k .= chr $apple_tf_DRMS[$i % 16]->[ord substr($key, $i % 16, 1)];
    }
    return $k;
}

sub decrypted_for_DRMS { return shift->process_DRMS_key() }

@apple_tf_iTMS = (
[  4, 145, 105, 51, 65, 245, 121, 233, 87, 85, 24, 110, 118, 149, 117, 
2, 83, 91, 246, 57, 53, 251, 126, 69, 129, 144, 199, 164, 198, 181, 
132, 35, 206, 214, 21, 152, 146, 103, 93, 227, 23, 68, 44, 248, 169, 
217, 50, 92, 131, 224, 14, 204, 140, 114, 124, 143, 120, 171, 56, 158, 
232, 183, 48, 176, 37, 192, 41, 28, 36, 155, 231, 201, 221, 52, 189, 
125, 122, 191, 242, 178, 249, 111, 109, 170, 6, 180, 237, 174, 254, 202, 
17, 223, 230, 195, 141, 47, 67, 182, 99, 104, 15, 238, 45, 7, 27, 
20, 166, 207, 159, 196, 244, 162, 133, 54, 138, 116, 8, 168, 156, 16, 
0, 38, 148, 66, 19, 86, 115, 73, 239, 188, 136, 61, 108, 33, 247, 
142, 193, 39, 90, 82, 34, 200, 197, 26, 88, 10, 25, 71, 1, 119, 
130, 100, 98, 18, 154, 72, 106, 78, 70, 213, 173, 12, 229, 235, 228, 
186, 77, 209, 84, 147, 160, 127, 76, 64, 139, 112, 60, 222, 177, 253, 
49, 30, 81, 161, 13, 123, 243, 62, 212, 31, 97, 80, 250, 9, 225, 
153, 40, 46, 172, 218, 220, 184, 63, 29, 102, 194, 22, 79, 59, 179, 
96, 55, 11, 157, 175, 95, 113, 107, 185, 210, 208, 167, 236, 89, 32, 
128, 137, 43, 241, 75, 150, 42, 135, 234, 215, 5, 187, 163, 151, 3, 
94, 165, 203, 134, 211, 101, 216, 190, 58, 205, 219, 252, 74, 226, 255, 240, ] ,
[  201, 226, 95, 10, 98, 222, 106, 146, 254, 86, 109, 137, 35, 39, 56, 
243, 245, 241, 57, 181, 158, 250, 104, 89, 23, 154, 40, 42, 132, 179, 
195, 48, 76, 22, 167, 34, 25, 68, 62, 58, 235, 209, 125, 221, 206, 
174, 147, 242, 251, 194, 208, 220, 200, 63, 193, 11, 156, 9, 0, 4, 
46, 164, 41, 144, 212, 38, 101, 90, 85, 117, 28, 186, 159, 18, 183, 
173, 97, 213, 207, 94, 187, 72, 114, 157, 7, 6, 126, 53, 203, 121, 
188, 171, 78, 54, 202, 100, 130, 172, 232, 227, 224, 233, 122, 19, 108, 
236, 150, 69, 75, 43, 103, 142, 123, 70, 238, 45, 169, 211, 44, 120, 
71, 140, 124, 148, 197, 133, 113, 163, 88, 216, 79, 175, 199, 234, 80, 
99, 231, 110, 81, 92, 182, 37, 170, 155, 27, 84, 180, 33, 31, 111, 
13, 2, 136, 127, 105, 196, 59, 102, 184, 249, 73, 165, 237, 185, 15, 
160, 239, 112, 178, 162, 20, 47, 219, 192, 8, 66, 217, 161, 1, 55, 
91, 177, 246, 26, 198, 191, 17, 83, 141, 93, 32, 21, 30, 61, 52, 
253, 36, 96, 119, 116, 139, 252, 74, 51, 151, 145, 77, 255, 225, 176, 
248, 12, 3, 152, 134, 240, 230, 60, 118, 5, 210, 190, 129, 244, 205, 
14, 149, 166, 247, 204, 67, 189, 50, 153, 131, 135, 143, 214, 128, 223, 
229, 228, 64, 218, 138, 87, 29, 49, 168, 82, 215, 65, 115, 107, 16, 24, ] ,
[  208, 110, 109, 139, 9, 100, 10, 132, 96, 133, 5, 220, 250, 92, 36, 
61, 244, 117, 171, 68, 52, 8, 144, 162, 146, 67, 107, 200, 240, 147, 
213, 54, 253, 72, 85, 234, 11, 29, 38, 178, 184, 91, 44, 215, 202, 
101, 247, 46, 190, 1, 88, 229, 173, 114, 16, 99, 104, 26, 186, 148, 
89, 183, 137, 53, 185, 206, 175, 164, 218, 20, 225, 87, 231, 57, 121, 
168, 3, 120, 254, 83, 28, 80, 201, 60, 158, 76, 39, 0, 243, 166, 
204, 49, 189, 82, 255, 95, 62, 97, 69, 224, 63, 156, 154, 199, 246, 
212, 237, 56, 32, 149, 176, 163, 228, 252, 211, 24, 214, 188, 14, 222, 
84, 138, 221, 203, 55, 122, 35, 58, 127, 22, 71, 34, 170, 210, 98, 
7, 31, 226, 43, 151, 191, 59, 152, 23, 90, 66, 42, 223, 12, 187, 
33, 130, 118, 113, 41, 245, 6, 48, 238, 81, 242, 141, 78, 161, 21, 
179, 103, 249, 65, 216, 4, 155, 77, 159, 25, 18, 251, 174, 239, 111, 
169, 73, 230, 209, 241, 129, 160, 196, 2, 192, 150, 47, 45, 125, 75, 
30, 182, 51, 124, 13, 37, 227, 123, 15, 108, 126, 233, 248, 207, 119, 
131, 70, 136, 74, 180, 153, 172, 181, 193, 219, 217, 195, 236, 17, 143, 
79, 102, 19, 128, 235, 198, 27, 115, 194, 112, 177, 157, 165, 94, 140, 
86, 93, 142, 64, 145, 105, 205, 135, 106, 232, 116, 167, 50, 197, 134, 40, ] ,
[  117, 161, 170, 193, 109, 111, 58, 80, 55, 160, 8, 56, 106, 239, 53, 
247, 128, 65, 232, 173, 74, 105, 244, 188, 233, 190, 49, 159, 210, 110, 
212, 137, 92, 60, 67, 18, 107, 100, 115, 211, 185, 27, 31, 230, 7, 
32, 102, 77, 44, 199, 217, 13, 150, 252, 23, 62, 200, 255, 0, 29, 
54, 36, 103, 12, 162, 133, 191, 57, 240, 242, 2, 94, 194, 28, 147, 
157, 192, 213, 6, 43, 204, 154, 51, 153, 222, 121, 11, 254, 151, 180, 
71, 172, 225, 123, 127, 97, 25, 171, 249, 79, 227, 40, 136, 177, 4, 
229, 35, 243, 195, 39, 120, 168, 138, 9, 148, 184, 5, 113, 218, 101, 
45, 186, 140, 85, 143, 253, 181, 63, 228, 134, 75, 112, 219, 95, 108, 
96, 33, 201, 37, 3, 165, 226, 182, 175, 14, 223, 235, 87, 93, 251, 
198, 231, 183, 205, 220, 206, 16, 84, 119, 26, 238, 15, 73, 126, 82, 
78, 86, 88, 207, 141, 118, 89, 10, 236, 68, 216, 187, 114, 130, 144, 
131, 59, 64, 164, 241, 189, 214, 42, 41, 224, 197, 245, 208, 237, 48, 
24, 76, 129, 19, 1, 135, 30, 125, 38, 90, 99, 209, 166, 149, 47, 
83, 174, 203, 234, 46, 132, 142, 98, 202, 50, 81, 91, 248, 34, 246, 
250, 66, 196, 124, 69, 156, 22, 158, 145, 167, 176, 152, 17, 221, 179, 
52, 70, 104, 163, 61, 116, 139, 20, 146, 21, 215, 178, 72, 122, 169, 155, ] ,
[  12, 23, 233, 120, 139, 254, 24, 182, 41, 64, 69, 13, 98, 230, 65, 
190, 251, 172, 115, 144, 71, 155, 79, 111, 97, 208, 19, 143, 192, 209, 
219, 57, 250, 39, 119, 116, 34, 2, 134, 215, 84, 141, 61, 122, 59, 
27, 92, 194, 50, 17, 72, 51, 93, 245, 96, 177, 117, 226, 83, 153, 
135, 88, 175, 74, 160, 32, 29, 252, 110, 213, 114, 229, 63, 66, 1, 
113, 179, 176, 62, 90, 253, 157, 21, 5, 60, 94, 15, 185, 180, 168, 
235, 241, 107, 220, 9, 127, 99, 217, 211, 76, 212, 188, 45, 0, 68, 
26, 161, 75, 149, 239, 178, 35, 10, 214, 218, 131, 159, 20, 224, 30, 
199, 148, 163, 228, 195, 58, 78, 128, 154, 54, 193, 123, 101, 255, 196, 
244, 125, 25, 67, 187, 234, 170, 55, 186, 231, 236, 87, 232, 104, 124, 
103, 11, 207, 80, 138, 95, 109, 38, 223, 202, 47, 173, 189, 204, 4, 
147, 150, 200, 248, 167, 43, 40, 142, 133, 203, 53, 174, 22, 158, 171, 
184, 7, 242, 183, 197, 44, 249, 89, 81, 121, 85, 246, 164, 210, 166, 
82, 52, 18, 31, 151, 206, 49, 46, 238, 145, 240, 14, 130, 112, 3, 
77, 100, 205, 191, 243, 16, 8, 56, 106, 28, 225, 181, 108, 227, 136, 
221, 48, 237, 73, 146, 37, 91, 105, 6, 42, 118, 36, 33, 137, 156, 
247, 222, 216, 165, 86, 152, 140, 129, 169, 70, 126, 162, 198, 132, 201, 102, ] ,
[  32, 147, 54, 169, 8, 64, 100, 21, 49, 220, 73, 79, 236, 154, 232, 
210, 14, 132, 204, 188, 39, 241, 121, 170, 237, 224, 95, 126, 130, 173, 
211, 53, 19, 151, 202, 68, 219, 226, 229, 139, 22, 103, 96, 15, 93, 
1, 182, 111, 145, 52, 2, 149, 218, 84, 255, 207, 125, 178, 233, 90, 
28, 118, 193, 69, 75, 209, 5, 253, 26, 194, 82, 197, 98, 248, 114, 
215, 55, 243, 222, 57, 133, 245, 199, 51, 144, 198, 244, 59, 179, 16, 
3, 161, 155, 200, 213, 30, 61, 252, 135, 235, 146, 136, 143, 33, 113, 
124, 203, 206, 94, 238, 105, 36, 189, 24, 142, 186, 223, 87, 166, 76, 
181, 81, 184, 160, 176, 104, 46, 175, 44, 120, 85, 20, 177, 138, 190, 
56, 65, 71, 4, 106, 196, 134, 247, 108, 60, 109, 246, 48, 153, 119, 
62, 122, 250, 195, 234, 163, 74, 140, 31, 180, 63, 92, 230, 35, 101, 
227, 158, 0, 9, 13, 167, 239, 89, 17, 67, 38, 43, 192, 7, 29, 
70, 137, 240, 102, 117, 12, 172, 187, 34, 171, 99, 141, 150, 165, 97, 
41, 127, 66, 159, 91, 216, 83, 225, 6, 212, 47, 107, 164, 205, 152, 
251, 40, 249, 115, 191, 208, 214, 86, 37, 156, 128, 25, 88, 183, 116, 
129, 77, 157, 112, 221, 45, 174, 50, 123, 217, 27, 18, 168, 201, 72, 
185, 131, 78, 11, 148, 58, 23, 42, 162, 228, 10, 80, 242, 110, 231, 254, ] ,
[  240, 192, 203, 158, 19, 171, 135, 225, 193, 126, 67, 121, 100, 246, 186, 
195, 233, 7, 131, 55, 166, 39, 14, 64, 167, 173, 188, 127, 160, 125, 
59, 57, 237, 26, 56, 241, 189, 137, 23, 34, 86, 185, 37, 44, 17, 
8, 245, 165, 80, 35, 199, 175, 169, 43, 48, 176, 92, 0, 210, 178, 
238, 198, 208, 224, 105, 216, 141, 95, 150, 140, 236, 249, 235, 129, 106, 
138, 134, 103, 10, 73, 13, 212, 143, 219, 211, 252, 112, 229, 142, 155, 
108, 183, 244, 170, 18, 128, 184, 214, 96, 149, 254, 82, 88, 116, 230, 
97, 40, 60, 78, 79, 177, 85, 205, 6, 242, 49, 218, 123, 239, 54, 
201, 72, 151, 221, 107, 132, 75, 84, 94, 154, 182, 215, 174, 248, 213, 
99, 28, 231, 22, 70, 157, 164, 41, 172, 253, 5, 191, 200, 98, 247, 
45, 163, 32, 223, 24, 227, 89, 161, 16, 251, 130, 104, 30, 120, 145, 
91, 52, 65, 122, 4, 27, 93, 111, 124, 181, 250, 255, 217, 21, 29, 
179, 190, 206, 33, 196, 168, 46, 102, 71, 66, 81, 87, 76, 68, 147, 
162, 20, 207, 234, 117, 133, 36, 180, 204, 226, 209, 50, 159, 25, 119, 
101, 197, 15, 2, 202, 232, 31, 11, 113, 194, 38, 243, 9, 51, 69, 
61, 62, 58, 12, 228, 144, 115, 1, 42, 83, 156, 220, 3, 109, 77, 
114, 152, 187, 74, 146, 47, 136, 110, 90, 63, 222, 139, 148, 153, 53, 118, ] ,
[  159, 5, 106, 136, 30, 230, 132, 176, 109, 91, 85, 66, 222, 112, 226, 
71, 211, 245, 209, 34, 111, 197, 247, 26, 13, 153, 168, 215, 167, 121, 
194, 203, 244, 239, 148, 126, 69, 80, 7, 115, 0, 33, 131, 208, 25, 
94, 243, 249, 200, 97, 82, 8, 145, 221, 119, 207, 108, 22, 19, 163, 
155, 198, 170, 35, 120, 107, 231, 89, 98, 156, 86, 4, 241, 195, 44, 
157, 186, 224, 219, 164, 165, 54, 135, 143, 113, 116, 28, 59, 104, 90, 
125, 227, 218, 139, 63, 216, 27, 225, 220, 166, 41, 151, 100, 75, 193, 
37, 161, 150, 88, 129, 213, 16, 242, 147, 64, 49, 171, 117, 180, 29, 
252, 192, 60, 238, 114, 237, 236, 14, 202, 79, 96, 240, 189, 9, 36, 
196, 101, 2, 191, 68, 57, 124, 234, 250, 138, 46, 187, 123, 67, 253, 
81, 174, 62, 210, 169, 205, 146, 51, 162, 199, 23, 72, 178, 179, 18, 
160, 47, 184, 42, 65, 154, 38, 78, 92, 12, 20, 133, 223, 52, 11, 
212, 177, 201, 48, 55, 102, 134, 251, 206, 141, 110, 128, 56, 137, 1, 
74, 173, 158, 83, 255, 144, 181, 217, 17, 15, 127, 31, 190, 228, 24, 
84, 93, 204, 182, 149, 73, 21, 248, 61, 233, 103, 122, 3, 152, 50, 
140, 10, 39, 70, 118, 214, 142, 254, 229, 43, 32, 6, 45, 53, 235, 
246, 183, 99, 232, 87, 95, 185, 76, 188, 105, 77, 175, 130, 40, 58, 172, ] ,
[  211, 130, 35, 117, 136, 59, 57, 156, 143, 181, 42, 9, 63, 60, 132, 
195, 150, 183, 221, 33, 249, 171, 226, 191, 111, 68, 194, 229, 20, 26, 
77, 190, 179, 31, 86, 164, 103, 200, 122, 233, 167, 125, 159, 206, 168, 
104, 36, 222, 232, 234, 65, 245, 127, 94, 0, 210, 14, 67, 4, 173, 
16, 217, 186, 38, 92, 64, 43, 85, 71, 116, 30, 91, 45, 10, 53, 
49, 121, 139, 120, 62, 113, 72, 254, 144, 198, 23, 185, 252, 214, 141, 
225, 79, 46, 112, 172, 11, 27, 146, 81, 131, 74, 3, 213, 248, 95, 
8, 138, 51, 238, 18, 239, 178, 123, 228, 37, 90, 100, 251, 157, 151, 
166, 124, 187, 165, 203, 212, 240, 22, 73, 246, 48, 107, 34, 70, 61, 
78, 227, 153, 97, 40, 101, 69, 21, 50, 155, 25, 66, 148, 175, 205, 
242, 12, 87, 184, 55, 255, 76, 193, 28, 231, 58, 54, 17, 208, 137, 
202, 133, 96, 236, 41, 80, 39, 174, 163, 98, 6, 158, 224, 169, 161, 
47, 149, 147, 106, 189, 29, 89, 176, 152, 145, 83, 32, 2, 250, 52, 
118, 220, 142, 192, 93, 196, 253, 82, 128, 56, 88, 170, 237, 218, 247, 
140, 199, 204, 230, 7, 244, 209, 154, 15, 24, 201, 44, 99, 84, 223, 
135, 182, 243, 180, 160, 177, 129, 19, 119, 102, 115, 5, 219, 235, 162, 
109, 1, 13, 75, 241, 197, 216, 215, 126, 134, 114, 108, 105, 188, 110, 207, ] ,
[  90, 102, 154, 161, 197, 61, 105, 120, 16, 230, 127, 128, 36, 23, 103, 
92, 57, 212, 9, 169, 158, 123, 216, 232, 0, 231, 139, 153, 35, 104, 
144, 116, 142, 150, 87, 49, 113, 94, 206, 55, 3, 51, 151, 84, 214, 
133, 165, 201, 38, 60, 202, 54, 176, 119, 195, 166, 43, 252, 79, 72, 
107, 21, 219, 227, 18, 233, 88, 213, 243, 75, 41, 143, 164, 160, 147, 
46, 73, 225, 137, 210, 193, 240, 226, 152, 25, 218, 203, 101, 11, 254, 
220, 141, 209, 135, 115, 207, 148, 248, 157, 156, 68, 236, 234, 228, 253, 
196, 177, 63, 187, 12, 70, 204, 28, 114, 172, 200, 198, 31, 215, 8, 
159, 122, 132, 222, 19, 149, 44, 191, 26, 45, 7, 124, 192, 171, 67, 
29, 69, 24, 10, 199, 100, 173, 6, 98, 244, 89, 34, 81, 181, 255, 
80, 40, 109, 74, 211, 188, 118, 58, 130, 30, 239, 138, 71, 251, 146, 
145, 242, 163, 246, 66, 235, 97, 245, 167, 178, 241, 249, 221, 247, 53, 
62, 121, 237, 117, 110, 140, 131, 184, 2, 1, 48, 76, 217, 112, 136, 
15, 223, 78, 64, 99, 20, 205, 86, 83, 185, 174, 37, 183, 82, 13, 
65, 129, 125, 134, 186, 208, 27, 47, 190, 126, 52, 85, 155, 93, 50, 
22, 106, 224, 194, 180, 238, 95, 108, 96, 59, 111, 17, 182, 162, 250, 
56, 91, 32, 5, 175, 77, 42, 229, 39, 170, 14, 168, 4, 189, 33, 179, ] ,
[  164, 73, 41, 48, 14, 20, 92, 34, 57, 198, 27, 107, 119, 243, 188, 
140, 122, 97, 127, 62, 19, 46, 146, 224, 77, 245, 225, 210, 123, 230, 
26, 176, 191, 6, 169, 89, 218, 180, 227, 182, 148, 120, 234, 108, 156, 
209, 238, 167, 170, 183, 65, 186, 163, 141, 248, 145, 239, 112, 187, 247, 
79, 195, 222, 184, 82, 244, 3, 181, 233, 241, 11, 236, 161, 5, 117, 
153, 175, 205, 152, 98, 85, 76, 162, 40, 37, 229, 64, 160, 72, 24, 
157, 135, 16, 172, 174, 0, 90, 4, 190, 86, 61, 31, 80, 249, 149, 
151, 166, 138, 133, 110, 197, 189, 171, 78, 52, 214, 173, 54, 226, 116, 
237, 32, 179, 105, 22, 70, 150, 254, 131, 137, 12, 36, 235, 255, 66, 
60, 147, 193, 109, 211, 240, 212, 199, 38, 228, 154, 10, 30, 178, 42, 
7, 43, 88, 75, 130, 21, 47, 55, 231, 139, 124, 84, 177, 253, 196, 
29, 102, 39, 206, 221, 232, 81, 125, 136, 202, 83, 59, 53, 99, 192, 
201, 67, 216, 2, 94, 68, 33, 13, 159, 208, 242, 246, 69, 18, 185, 
58, 63, 104, 9, 252, 158, 115, 8, 118, 103, 132, 100, 194, 91, 87, 
142, 74, 213, 223, 106, 101, 165, 15, 251, 121, 25, 50, 51, 45, 168, 
93, 113, 250, 204, 126, 35, 28, 49, 143, 56, 200, 219, 128, 17, 207, 
95, 111, 215, 217, 96, 155, 144, 1, 129, 134, 220, 44, 71, 23, 203, 114, ] ,
[  245, 217, 174, 135, 25, 2, 99, 176, 57, 159, 150, 226, 243, 205, 55, 
109, 129, 203, 42, 253, 138, 105, 120, 111, 254, 74, 207, 110, 75, 147, 
36, 81, 255, 172, 53, 160, 238, 3, 199, 119, 169, 103, 244, 197, 189, 
45, 102, 193, 116, 232, 15, 16, 0, 41, 114, 167, 173, 247, 151, 158, 
191, 101, 68, 60, 54, 154, 77, 61, 219, 96, 231, 182, 47, 156, 95, 
155, 229, 82, 195, 26, 44, 89, 29, 200, 56, 49, 22, 213, 87, 28, 
124, 251, 133, 131, 126, 179, 225, 130, 220, 184, 67, 214, 187, 198, 65, 
218, 175, 48, 234, 71, 141, 127, 241, 192, 212, 239, 123, 165, 27, 40, 
107, 148, 34, 21, 108, 79, 227, 84, 221, 4, 181, 235, 90, 35, 223, 
85, 104, 201, 233, 112, 106, 190, 118, 146, 216, 248, 33, 163, 8, 24, 
73, 194, 246, 121, 117, 13, 140, 139, 149, 14, 37, 170, 98, 64, 128, 
88, 91, 94, 228, 78, 144, 152, 166, 252, 153, 115, 157, 46, 93, 113, 
58, 204, 177, 72, 188, 38, 183, 39, 11, 242, 145, 100, 164, 186, 132, 
66, 80, 10, 230, 162, 23, 202, 209, 43, 69, 249, 30, 59, 224, 196, 
211, 18, 178, 134, 208, 20, 125, 215, 83, 70, 122, 168, 62, 86, 92, 
143, 19, 206, 237, 97, 236, 6, 185, 180, 52, 76, 137, 12, 136, 1, 
51, 5, 171, 142, 161, 63, 7, 50, 210, 9, 240, 31, 250, 32, 222, 17, ] ,
[  194, 224, 115, 126, 70, 203, 214, 192, 157, 97, 146, 200, 10, 61, 238, 
129, 85, 84, 195, 50, 28, 218, 53, 136, 124, 169, 247, 229, 121, 88, 
57, 252, 153, 137, 141, 199, 81, 201, 11, 227, 144, 130, 120, 234, 216, 
98, 172, 119, 34, 46, 95, 44, 83, 249, 168, 72, 156, 237, 104, 245, 
179, 63, 189, 239, 159, 29, 110, 71, 36, 162, 65, 20, 160, 147, 107, 
246, 205, 251, 142, 17, 212, 230, 184, 235, 67, 41, 190, 128, 133, 92, 
102, 25, 22, 58, 149, 161, 174, 196, 4, 86, 5, 26, 135, 7, 117, 
167, 74, 62, 69, 170, 150, 176, 96, 166, 38, 106, 131, 180, 132, 202, 
134, 191, 254, 158, 250, 233, 78, 89, 109, 197, 105, 64, 68, 178, 118, 
240, 47, 56, 18, 209, 39, 100, 94, 24, 211, 173, 165, 45, 15, 12, 
164, 3, 19, 48, 213, 220, 243, 30, 187, 111, 181, 35, 13, 140, 222, 
186, 206, 151, 6, 113, 255, 145, 215, 54, 175, 55, 99, 125, 228, 27, 
101, 217, 244, 9, 139, 207, 33, 138, 91, 198, 232, 177, 80, 93, 90, 
73, 163, 122, 236, 14, 127, 226, 171, 66, 108, 219, 193, 112, 75, 40, 
223, 248, 60, 79, 210, 123, 32, 116, 52, 2, 114, 87, 204, 148, 143, 
241, 103, 1, 182, 42, 253, 59, 155, 188, 82, 76, 43, 49, 16, 37, 
221, 183, 154, 185, 242, 8, 31, 77, 0, 208, 51, 152, 231, 21, 23, 225, ] ,
[  110, 197, 222, 126, 246, 32, 225, 173, 0, 247, 204, 135, 35, 189, 87, 
148, 73, 206, 43, 75, 140, 1, 12, 141, 58, 113, 103, 166, 20, 33, 
236, 46, 172, 233, 229, 227, 85, 40, 152, 186, 223, 104, 88, 219, 97, 
124, 255, 25, 47, 59, 116, 81, 2, 90, 107, 60, 214, 109, 19, 108, 
6, 22, 41, 192, 48, 16, 61, 234, 155, 24, 118, 163, 147, 131, 7, 
72, 251, 79, 17, 162, 242, 129, 171, 184, 240, 138, 199, 183, 30, 66, 
217, 96, 212, 237, 21, 31, 74, 209, 28, 64, 82, 52, 123, 70, 94, 
198, 119, 182, 78, 29, 150, 228, 49, 5, 196, 215, 62, 9, 133, 232, 
65, 105, 159, 137, 180, 93, 51, 188, 208, 136, 158, 181, 231, 8, 80, 
4, 250, 13, 193, 125, 106, 11, 176, 156, 53, 54, 143, 86, 177, 55, 
239, 167, 202, 44, 238, 226, 187, 221, 15, 134, 178, 244, 216, 99, 114, 
207, 102, 38, 100, 146, 175, 200, 57, 151, 149, 203, 69, 169, 128, 160, 
121, 63, 161, 10, 224, 120, 190, 36, 249, 27, 243, 77, 185, 245, 92, 
98, 254, 165, 18, 101, 145, 170, 195, 39, 174, 76, 252, 95, 130, 248, 
111, 83, 179, 230, 91, 68, 218, 112, 210, 211, 235, 122, 37, 14, 115, 
220, 45, 127, 213, 164, 132, 89, 168, 50, 84, 3, 191, 139, 157, 154, 
194, 205, 67, 201, 142, 34, 153, 117, 26, 71, 241, 144, 23, 56, 42, 253, ] ,
[  175, 153, 20, 104, 23, 169, 5, 110, 234, 70, 161, 46, 210, 75, 254, 
174, 133, 225, 237, 118, 88, 59, 224, 68, 111, 69, 143, 87, 215, 248, 
36, 7, 168, 138, 177, 184, 229, 121, 142, 152, 77, 117, 182, 43, 85, 
176, 127, 12, 82, 81, 188, 231, 151, 226, 14, 65, 228, 206, 38, 211, 
204, 124, 180, 19, 22, 191, 157, 27, 9, 49, 72, 63, 24, 48, 141, 
134, 186, 18, 159, 230, 56, 219, 119, 245, 171, 105, 30, 158, 26, 155, 
189, 160, 57, 249, 207, 123, 112, 165, 251, 131, 154, 29, 95, 172, 192, 
200, 6, 67, 92, 106, 144, 255, 220, 198, 223, 140, 147, 130, 167, 145, 
61, 190, 54, 240, 202, 0, 13, 8, 58, 193, 238, 212, 203, 62, 129, 
173, 93, 187, 102, 214, 45, 47, 32, 40, 178, 170, 185, 205, 78, 218, 
103, 99, 16, 21, 52, 3, 42, 243, 71, 86, 94, 196, 120, 89, 232, 
31, 28, 73, 74, 90, 128, 137, 241, 217, 108, 76, 60, 209, 247, 183, 
44, 55, 125, 79, 4, 156, 233, 239, 216, 235, 98, 11, 15, 132, 181, 
163, 194, 222, 2, 17, 242, 96, 64, 35, 50, 246, 33, 115, 236, 139, 
164, 197, 53, 150, 135, 80, 84, 213, 113, 100, 107, 136, 208, 114, 97, 
166, 83, 25, 41, 66, 109, 10, 122, 1, 51, 91, 37, 250, 146, 195, 
148, 116, 227, 244, 199, 252, 39, 253, 126, 179, 201, 149, 221, 162, 34, 101, ] ,
[  10, 243, 251, 143, 29, 186, 72, 113, 185, 127, 94, 13, 47, 220, 193, 
188, 77, 207, 160, 181, 49, 116, 238, 81, 165, 85, 204, 100, 153, 123, 
236, 163, 159, 109, 3, 158, 133, 69, 192, 12, 125, 73, 48, 215, 247, 
245, 103, 146, 219, 168, 30, 52, 40, 120, 218, 101, 140, 230, 224, 86, 
58, 20, 149, 21, 114, 203, 142, 172, 104, 5, 174, 19, 75, 87, 56, 
148, 107, 232, 96, 4, 248, 129, 92, 246, 183, 249, 170, 57, 214, 226, 
150, 198, 144, 175, 110, 179, 233, 83, 212, 16, 61, 71, 234, 59, 205, 
45, 74, 36, 216, 34, 65, 119, 162, 190, 66, 115, 8, 196, 27, 237, 
176, 95, 197, 68, 76, 63, 108, 189, 97, 223, 187, 222, 79, 173, 199, 
126, 253, 89, 42, 156, 241, 18, 43, 182, 200, 152, 50, 24, 23, 221, 
70, 250, 157, 41, 124, 136, 178, 208, 90, 225, 244, 255, 184, 64, 210, 
195, 62, 44, 145, 78, 84, 242, 28, 130, 93, 213, 155, 132, 60, 154, 
161, 25, 167, 105, 39, 164, 7, 202, 91, 211, 0, 118, 106, 235, 254, 
191, 31, 147, 135, 131, 239, 228, 82, 122, 171, 26, 138, 134, 128, 121, 
33, 53, 54, 169, 88, 112, 55, 6, 117, 102, 252, 2, 206, 17, 1, 
32, 227, 98, 99, 11, 15, 14, 80, 35, 177, 22, 51, 9, 180, 166, 
46, 209, 111, 151, 194, 38, 37, 229, 141, 201, 67, 137, 240, 139, 231, 217, ] 
);

@apple_tf_DRMS = (
[ 157, 170, 213, 240, 230, 43, 19, 202, 225, 32, 247, 42, 63, 160, 132, 182, 
233, 244, 228, 187, 104, 245, 198, 140, 46, 231, 72, 16, 83, 212, 24, 224, 
156, 229, 163, 175, 162, 218, 54, 249, 30, 250, 185, 35, 118, 189, 171, 139, 
4, 8, 103, 253, 211, 21, 141, 20, 165, 128, 146, 243, 114, 2, 93, 242, 
10, 74, 84, 121, 34, 3, 36, 81, 252, 1, 14, 69, 108, 91, 246, 110, 
92, 6, 119, 207, 248, 38, 130, 55, 251, 194, 28, 180, 201, 178, 148, 67, 
236, 107, 22, 222, 147, 142, 18, 123, 197, 59, 190, 78, 125, 109, 127, 186, 
237, 66, 5, 234, 137, 100, 169, 52, 85, 117, 80, 70, 7, 60, 105, 183, 
138, 0, 235, 23, 145, 47, 129, 62, 77, 232, 149, 203, 172, 12, 68, 181, 
73, 255, 133, 53, 40, 45, 15, 150, 82, 90, 155, 79, 238, 111, 113, 112, 
71, 39, 88, 196, 205, 199, 27, 195, 215, 239, 41, 241, 122, 57, 217, 184, 
191, 44, 177, 216, 11, 226, 65, 50, 76, 95, 158, 136, 159, 210, 254, 134, 
151, 98, 61, 89, 164, 86, 33, 208, 99, 209, 152, 97, 179, 37, 168, 223, 
31, 102, 144, 167, 51, 192, 87, 166, 116, 49, 188, 13, 200, 221, 25, 9, 
64, 153, 219, 154, 94, 214, 204, 131, 220, 26, 75, 29, 227, 161, 48, 174, 
101, 124, 176, 193, 56, 96, 58, 206, 135, 17, 115, 173, 126, 120, 143, 106, ], 
[ 79, 114, 199, 94, 3, 36, 212, 117, 193, 121, 182, 76, 32, 137, 190, 231, 
104, 248, 210, 58, 213, 33, 21, 246, 101, 252, 46, 229, 133, 203, 96, 165, 
177, 53, 119, 171, 255, 127, 204, 161, 45, 24, 184, 111, 34, 55, 61, 168, 
202, 200, 169, 20, 142, 245, 150, 19, 4, 174, 77, 164, 62, 145, 48, 41, 
100, 249, 197, 147, 159, 240, 113, 99, 72, 124, 30, 154, 196, 211, 74, 223, 
0, 80, 207, 40, 185, 17, 37, 81, 15, 110, 148, 152, 160, 106, 85, 130, 
225, 22, 131, 47, 235, 52, 233, 189, 179, 68, 221, 51, 218, 173, 146, 97, 
181, 50, 157, 149, 14, 122, 241, 54, 59, 162, 89, 60, 87, 214, 39, 134, 
69, 5, 250, 139, 216, 11, 56, 31, 198, 155, 129, 67, 128, 236, 232, 175, 
105, 13, 84, 143, 95, 209, 75, 98, 219, 43, 224, 6, 156, 239, 27, 244, 
208, 205, 222, 25, 103, 135, 188, 86, 26, 228, 220, 2, 215, 8, 153, 186, 
115, 191, 195, 194, 243, 237, 170, 126, 178, 227, 163, 102, 91, 88, 254, 12, 
38, 66, 44, 63, 82, 151, 23, 35, 238, 242, 206, 118, 73, 16, 29, 158, 
172, 132, 42, 57, 138, 247, 234, 166, 176, 125, 116, 141, 107, 49, 78, 1, 
136, 217, 90, 109, 83, 192, 10, 187, 9, 120, 108, 123, 7, 28, 144, 70, 
230, 140, 18, 93, 183, 65, 180, 167, 64, 71, 253, 226, 201, 251, 92, 112, ], 
[ 234, 49, 53, 46, 190, 129, 148, 57, 174, 159, 74, 24, 51, 87, 76, 40, 
208, 196, 173, 91, 115, 82, 149, 120, 206, 68, 62, 10, 204, 209, 79, 253, 
108, 188, 214, 104, 243, 36, 164, 160, 21, 230, 19, 7, 229, 61, 23, 111, 
84, 151, 201, 71, 94, 152, 210, 17, 197, 205, 89, 232, 3, 156, 72, 241, 
220, 14, 8, 31, 179, 101, 110, 213, 216, 116, 75, 170, 70, 222, 227, 142, 
73, 6, 48, 167, 103, 117, 223, 171, 123, 128, 114, 38, 130, 145, 225, 132, 
168, 240, 112, 127, 247, 133, 161, 252, 172, 97, 88, 238, 184, 194, 125, 180, 
249, 66, 106, 9, 99, 203, 144, 33, 29, 195, 69, 22, 126, 176, 154, 45, 
13, 32, 131, 166, 44, 81, 119, 18, 221, 52, 12, 39, 41, 11, 92, 139, 
30, 255, 98, 34, 2, 153, 83, 212, 181, 86, 100, 239, 236, 85, 27, 54, 
141, 102, 250, 182, 163, 147, 96, 215, 157, 122, 124, 224, 56, 113, 134, 25, 
136, 107, 242, 146, 178, 219, 26, 158, 155, 198, 20, 246, 50, 16, 43, 67, 
237, 193, 254, 15, 140, 95, 1, 42, 105, 137, 218, 60, 187, 231, 47, 217, 
202, 162, 251, 80, 59, 207, 192, 183, 135, 118, 169, 175, 77, 226, 248, 244, 
78, 55, 233, 186, 211, 235, 63, 200, 121, 191, 245, 4, 150, 5, 109, 189, 
143, 0, 185, 28, 37, 93, 35, 199, 90, 165, 138, 65, 177, 228, 58, 64, ], 
[ 45, 196, 144, 81, 131, 53, 52, 59, 178, 174, 191, 237, 219, 186, 109, 125, 
247, 235, 19, 106, 1, 165, 95, 221, 38, 63, 117, 83, 244, 65, 4, 139, 
172, 26, 103, 159, 194, 220, 211, 160, 189, 13, 47, 3, 223, 215, 119, 147, 
50, 200, 171, 156, 225, 184, 89, 201, 169, 222, 78, 175, 255, 98, 15, 182, 
116, 213, 10, 249, 66, 21, 56, 48, 167, 203, 168, 240, 105, 33, 154, 5, 
73, 46, 254, 241, 31, 14, 180, 128, 0, 101, 87, 24, 68, 96, 107, 11, 
2, 157, 40, 250, 121, 236, 227, 140, 60, 64, 239, 115, 177, 179, 207, 246, 
198, 197, 166, 173, 233, 8, 202, 146, 205, 111, 170, 104, 248, 120, 187, 155, 
35, 55, 88, 90, 138, 152, 126, 6, 148, 110, 22, 86, 145, 124, 224, 84, 
62, 242, 39, 228, 135, 51, 85, 232, 226, 41, 77, 230, 37, 190, 231, 133, 
153, 9, 113, 57, 118, 93, 130, 143, 134, 58, 7, 245, 70, 23, 36, 76, 
199, 20, 183, 43, 163, 192, 136, 185, 92, 209, 72, 195, 204, 97, 251, 216, 
44, 214, 149, 34, 164, 114, 181, 122, 82, 99, 100, 75, 253, 30, 218, 25, 
29, 229, 162, 91, 71, 69, 210, 137, 27, 142, 243, 234, 42, 238, 102, 123, 
17, 193, 28, 151, 217, 252, 80, 61, 212, 54, 176, 94, 79, 18, 67, 150, 
12, 188, 49, 74, 127, 112, 208, 108, 141, 132, 32, 129, 161, 158, 16, 206, ], 
[ 240, 230, 183, 118, 16, 224, 217, 82, 219, 153, 156, 157, 5, 126, 100, 172, 
72, 160, 105, 176, 89, 63, 149, 91, 233, 4, 18, 192, 211, 216, 191, 46, 
99, 236, 200, 19, 25, 179, 62, 64, 71, 142, 237, 202, 108, 28, 54, 234, 
181, 50, 162, 39, 167, 141, 81, 229, 13, 185, 151, 83, 205, 186, 44, 196, 
210, 125, 146, 111, 165, 178, 35, 218, 103, 171, 119, 120, 2, 43, 7, 148, 
116, 93, 32, 24, 56, 232, 169, 70, 33, 241, 137, 253, 6, 98, 94, 128, 
154, 96, 17, 166, 66, 107, 67, 104, 212, 209, 40, 174, 213, 235, 51, 132, 
138, 255, 12, 21, 227, 190, 117, 173, 86, 163, 87, 225, 193, 0, 244, 27, 
243, 135, 139, 215, 187, 246, 97, 75, 80, 175, 206, 76, 189, 170, 38, 9, 
238, 144, 223, 79, 124, 101, 251, 22, 129, 3, 204, 214, 90, 220, 77, 195, 
26, 140, 134, 58, 112, 152, 59, 57, 68, 95, 245, 222, 41, 11, 31, 55, 
113, 102, 208, 45, 85, 250, 84, 36, 147, 133, 114, 106, 228, 150, 53, 201, 
121, 158, 248, 131, 188, 194, 30, 65, 110, 34, 221, 177, 226, 8, 69, 127, 
198, 164, 254, 109, 123, 14, 74, 61, 92, 161, 115, 88, 252, 231, 15, 155, 
73, 42, 168, 143, 249, 23, 78, 159, 207, 197, 1, 239, 29, 136, 49, 20, 
48, 10, 184, 130, 199, 242, 145, 60, 52, 247, 122, 182, 180, 47, 37, 203, ], 
[ 2, 128, 152, 3, 185, 50, 231, 58, 65, 124, 68, 36, 156, 59, 213, 165, 
180, 31, 89, 146, 252, 164, 76, 141, 228, 254, 119, 101, 183, 48, 159, 212, 
5, 86, 225, 221, 9, 195, 30, 20, 78, 81, 127, 19, 218, 120, 189, 223, 
147, 163, 170, 239, 148, 115, 17, 44, 167, 245, 63, 208, 74, 11, 202, 184, 
77, 102, 34, 206, 134, 217, 16, 246, 149, 140, 109, 25, 190, 151, 186, 236, 
69, 53, 203, 153, 150, 121, 92, 227, 187, 4, 15, 75, 113, 96, 251, 66, 
226, 49, 240, 40, 215, 143, 112, 204, 220, 238, 171, 83, 22, 1, 224, 244, 
234, 47, 242, 194, 41, 229, 26, 166, 100, 7, 211, 118, 80, 255, 130, 32, 
54, 175, 237, 232, 176, 168, 99, 73, 181, 29, 95, 135, 98, 188, 37, 111, 
233, 210, 79, 46, 55, 93, 247, 103, 248, 104, 137, 169, 154, 88, 117, 21, 
198, 173, 33, 132, 230, 178, 14, 38, 72, 18, 172, 129, 158, 201, 199, 97, 
214, 107, 139, 216, 142, 196, 138, 91, 64, 52, 123, 133, 131, 82, 27, 192, 
136, 197, 209, 126, 12, 191, 56, 243, 193, 110, 174, 6, 235, 253, 177, 61, 
122, 42, 125, 157, 108, 144, 200, 57, 205, 87, 8, 13, 114, 10, 23, 182, 
51, 106, 24, 62, 160, 67, 162, 241, 90, 35, 145, 179, 84, 85, 28, 250, 
116, 161, 94, 155, 71, 39, 222, 60, 43, 70, 105, 207, 45, 0, 249, 219, ], 
[ 152, 51, 46, 10, 108, 109, 173, 157, 35, 119, 74, 164, 70, 37, 254, 174, 
147, 183, 62, 99, 165, 248, 205, 145, 59, 223, 21, 246, 175, 120, 132, 83, 
187, 117, 128, 76, 63, 131, 27, 130, 72, 44, 189, 71, 203, 103, 106, 188, 
79, 206, 151, 148, 146, 249, 182, 200, 167, 125, 141, 49, 234, 38, 242, 171, 
22, 111, 34, 8, 82, 96, 154, 184, 161, 45, 105, 181, 155, 85, 232, 252, 
26, 43, 81, 69, 211, 153, 65, 133, 88, 89, 77, 142, 110, 222, 215, 224, 
239, 57, 0, 13, 66, 235, 9, 127, 163, 243, 238, 162, 75, 41, 11, 54, 
18, 25, 29, 197, 241, 80, 24, 98, 20, 87, 137, 214, 23, 217, 229, 124, 
225, 1, 30, 255, 169, 7, 114, 123, 4, 129, 227, 84, 28, 210, 190, 50, 
55, 101, 126, 247, 3, 186, 236, 115, 170, 212, 113, 48, 191, 64, 193, 202, 
56, 213, 149, 250, 185, 94, 140, 42, 194, 199, 156, 6, 244, 52, 216, 15, 
160, 231, 33, 135, 144, 168, 228, 97, 92, 172, 245, 104, 209, 220, 68, 230, 
195, 180, 138, 118, 179, 177, 139, 226, 31, 102, 233, 251, 5, 2, 32, 12, 
95, 208, 112, 14, 166, 122, 67, 36, 58, 158, 218, 39, 53, 86, 16, 159, 
107, 93, 192, 221, 207, 91, 237, 240, 198, 121, 196, 134, 73, 116, 78, 178, 
61, 150, 143, 176, 136, 219, 100, 201, 253, 40, 60, 47, 19, 204, 90, 17, ], 
[ 17, 92, 106, 71, 15, 76, 148, 14, 184, 69, 182, 145, 165, 189, 133, 176, 
223, 134, 234, 114, 249, 157, 137, 161, 41, 229, 48, 197, 169, 131, 65, 30, 
28, 55, 232, 104, 9, 132, 174, 124, 33, 213, 73, 190, 45, 151, 250, 116, 
154, 105, 158, 218, 98, 81, 27, 89, 42, 153, 253, 24, 150, 96, 110, 200, 
163, 143, 225, 85, 52, 1, 102, 83, 181, 94, 144, 29, 77, 123, 128, 79, 
7, 167, 117, 100, 194, 224, 210, 59, 171, 46, 62, 173, 159, 78, 51, 139, 
187, 162, 84, 11, 245, 72, 236, 152, 179, 108, 149, 64, 178, 99, 103, 129, 
109, 140, 192, 34, 227, 66, 240, 217, 204, 220, 57, 31, 122, 47, 22, 246, 
135, 39, 40, 2, 199, 231, 146, 3, 10, 58, 203, 242, 243, 170, 18, 138, 
172, 130, 191, 255, 221, 119, 202, 82, 118, 198, 97, 87, 86, 75, 25, 209, 
37, 16, 248, 20, 141, 80, 193, 74, 188, 201, 8, 19, 251, 233, 32, 70, 
147, 212, 126, 208, 230, 196, 219, 237, 186, 4, 120, 43, 26, 50, 35, 23, 
244, 222, 0, 226, 211, 53, 155, 254, 205, 195, 56, 91, 164, 241, 206, 160, 
107, 115, 235, 185, 38, 125, 13, 61, 238, 63, 111, 112, 252, 239, 90, 175, 
183, 101, 156, 67, 214, 121, 177, 168, 180, 54, 127, 207, 166, 228, 68, 93, 
44, 215, 142, 88, 49, 60, 113, 21, 36, 6, 216, 136, 247, 95, 12, 5, ], 
[ 213, 255, 153, 71, 239, 226, 145, 120, 124, 97, 233, 245, 121, 177, 212, 85, 
218, 112, 251, 180, 225, 73, 42, 94, 221, 95, 27, 47, 205, 165, 111, 98, 
247, 183, 2, 141, 56, 93, 129, 198, 31, 119, 7, 248, 211, 184, 171, 250, 
249, 66, 26, 9, 38, 133, 96, 228, 53, 237, 122, 50, 105, 37, 139, 11, 
219, 104, 126, 68, 18, 147, 25, 206, 240, 82, 158, 170, 178, 227, 234, 163, 
3, 208, 216, 176, 203, 92, 217, 128, 229, 109, 181, 215, 182, 114, 156, 75, 
10, 241, 244, 6, 34, 54, 232, 19, 209, 134, 195, 21, 159, 1, 67, 155, 
102, 46, 152, 90, 99, 74, 231, 35, 107, 58, 61, 127, 236, 235, 220, 57, 
254, 138, 223, 91, 191, 117, 130, 169, 62, 188, 36, 40, 246, 115, 135, 199, 
81, 100, 200, 230, 146, 150, 45, 222, 157, 72, 43, 15, 83, 214, 197, 175, 
39, 5, 193, 78, 161, 185, 55, 137, 101, 253, 87, 194, 166, 252, 210, 154, 
88, 41, 84, 140, 201, 143, 204, 60, 44, 123, 142, 192, 190, 187, 202, 80, 
12, 13, 29, 89, 33, 172, 242, 125, 160, 28, 76, 23, 64, 103, 52, 69, 
113, 136, 189, 167, 174, 164, 16, 168, 22, 24, 108, 59, 30, 32, 106, 79, 
173, 162, 224, 77, 86, 148, 63, 116, 179, 131, 238, 8, 48, 14, 149, 65, 
144, 20, 243, 196, 151, 118, 186, 110, 4, 207, 70, 51, 49, 0, 17, 132, ], 
[ 195, 179, 81, 140, 48, 69, 167, 183, 86, 26, 24, 161, 231, 2, 219, 133, 
254, 114, 240, 230, 128, 27, 163, 165, 82, 221, 17, 97, 202, 95, 223, 182, 
215, 246, 136, 15, 217, 113, 229, 177, 243, 239, 242, 213, 91, 11, 210, 204, 
160, 12, 200, 63, 252, 116, 33, 45, 147, 52, 3, 170, 162, 249, 1, 4, 
255, 209, 212, 85, 174, 236, 184, 18, 164, 145, 110, 238, 55, 60, 218, 74, 
67, 234, 20, 31, 0, 137, 142, 130, 253, 157, 192, 155, 190, 108, 84, 14, 
54, 40, 197, 92, 65, 119, 43, 208, 152, 94, 191, 189, 214, 25, 104, 80, 
153, 211, 76, 10, 90, 44, 149, 154, 121, 41, 247, 34, 58, 194, 127, 206, 
241, 22, 169, 248, 98, 88, 146, 46, 175, 102, 109, 68, 132, 126, 50, 232, 
235, 158, 135, 225, 101, 237, 23, 37, 13, 32, 185, 61, 173, 99, 47, 7, 
233, 205, 59, 123, 77, 124, 39, 6, 251, 49, 199, 115, 181, 62, 56, 203, 
66, 19, 228, 207, 138, 78, 141, 166, 122, 111, 73, 151, 134, 112, 87, 53, 
72, 156, 226, 148, 159, 89, 178, 196, 75, 139, 5, 168, 8, 9, 21, 188, 
131, 28, 16, 103, 176, 150, 96, 172, 180, 227, 117, 144, 79, 57, 143, 107, 
105, 93, 51, 245, 220, 186, 38, 35, 193, 64, 42, 201, 71, 120, 216, 244, 
198, 171, 83, 70, 250, 125, 129, 36, 118, 100, 222, 106, 187, 30, 224, 29, ], 
[ 122, 103, 120, 2, 33, 215, 203, 170, 76, 174, 61, 232, 183, 60, 42, 82, 
137, 84, 246, 96, 223, 62, 55, 228, 48, 193, 151, 123, 133, 64, 6, 58, 
30, 87, 16, 191, 105, 218, 165, 239, 107, 97, 206, 19, 175, 126, 116, 187, 
222, 69, 237, 88, 135, 98, 238, 155, 171, 247, 91, 149, 66, 169, 93, 241, 
44, 160, 54, 0, 176, 113, 75, 125, 202, 4, 45, 199, 121, 118, 8, 94, 
51, 12, 147, 243, 73, 15, 65, 31, 146, 158, 159, 225, 46, 28, 86, 13, 
172, 140, 251, 230, 26, 185, 161, 21, 178, 106, 198, 144, 108, 85, 227, 119, 
109, 49, 217, 67, 205, 81, 102, 139, 134, 29, 233, 209, 71, 131, 186, 130, 
14, 250, 40, 92, 179, 212, 127, 34, 25, 214, 150, 167, 7, 95, 195, 182, 
240, 52, 37, 77, 138, 156, 115, 22, 90, 111, 63, 79, 249, 18, 245, 190, 
173, 177, 197, 236, 252, 216, 57, 201, 10, 80, 229, 89, 180, 196, 74, 9, 
213, 153, 157, 117, 100, 253, 208, 78, 56, 11, 224, 184, 143, 39, 124, 242, 
168, 38, 59, 41, 235, 23, 164, 43, 83, 136, 145, 112, 53, 194, 110, 254, 
1, 5, 181, 221, 207, 162, 204, 72, 104, 99, 101, 154, 210, 152, 129, 255, 
244, 141, 163, 220, 20, 50, 192, 36, 219, 47, 24, 211, 188, 142, 70, 231, 
3, 68, 226, 148, 234, 132, 17, 248, 200, 32, 27, 166, 35, 128, 114, 189, ], 
[ 59, 55, 181, 60, 64, 203, 17, 19, 4, 100, 248, 43, 96, 148, 38, 173, 
91, 182, 110, 141, 13, 87, 193, 134, 185, 40, 174, 68, 168, 10, 66, 81, 
71, 241, 57, 105, 90, 254, 221, 124, 192, 200, 160, 218, 189, 121, 247, 27, 
42, 99, 226, 191, 210, 211, 177, 135, 30, 48, 164, 97, 8, 5, 183, 33, 
171, 11, 122, 21, 46, 94, 18, 41, 109, 147, 49, 229, 154, 9, 178, 236, 
239, 184, 116, 199, 132, 88, 216, 194, 54, 227, 86, 80, 158, 67, 228, 25, 
166, 22, 215, 212, 39, 136, 157, 152, 198, 85, 83, 172, 7, 26, 204, 61, 
34, 225, 169, 65, 126, 220, 98, 250, 156, 235, 159, 240, 69, 77, 186, 107, 
79, 31, 252, 104, 155, 29, 75, 78, 20, 163, 133, 249, 84, 3, 139, 108, 
230, 103, 222, 76, 12, 93, 195, 50, 35, 162, 117, 52, 58, 232, 47, 245, 
234, 202, 89, 246, 196, 112, 170, 62, 201, 131, 238, 111, 53, 56, 253, 114, 
140, 231, 153, 118, 180, 28, 143, 73, 37, 72, 237, 190, 208, 150, 179, 244, 
197, 146, 206, 113, 217, 142, 224, 138, 92, 74, 119, 63, 137, 32, 255, 125, 
24, 82, 144, 0, 102, 161, 149, 129, 151, 123, 95, 188, 242, 214, 223, 70, 
187, 2, 14, 120, 36, 16, 15, 128, 207, 6, 44, 106, 127, 45, 167, 101, 
1, 205, 251, 130, 51, 209, 243, 115, 165, 219, 175, 213, 145, 233, 176, 23, ], 
[ 251, 31, 207, 102, 22, 224, 76, 54, 108, 41, 70, 242, 104, 120, 160, 98, 
221, 48, 131, 121, 93, 79, 223, 141, 219, 177, 149, 36, 71, 17, 243, 62, 
164, 97, 56, 6, 55, 103, 234, 241, 38, 186, 53, 45, 231, 25, 193, 172, 
250, 27, 96, 249, 208, 2, 167, 145, 125, 150, 142, 137, 99, 138, 248, 205, 
80, 12, 107, 240, 105, 201, 85, 106, 86, 40, 34, 73, 196, 128, 52, 130, 
140, 233, 153, 65, 78, 47, 163, 44, 229, 169, 132, 174, 162, 21, 23, 225, 
237, 109, 139, 188, 58, 214, 143, 4, 7, 16, 67, 32, 185, 147, 89, 61, 
91, 247, 175, 14, 244, 90, 230, 181, 228, 220, 18, 178, 19, 37, 113, 134, 
235, 171, 168, 253, 199, 15, 66, 77, 211, 226, 83, 95, 239, 254, 69, 24, 
115, 42, 64, 245, 135, 10, 92, 206, 116, 51, 192, 252, 9, 82, 203, 100, 
212, 28, 176, 127, 200, 60, 26, 46, 33, 94, 72, 173, 119, 43, 101, 110, 
213, 136, 222, 122, 155, 59, 20, 146, 232, 0, 81, 50, 216, 148, 183, 154, 
210, 152, 227, 35, 187, 112, 118, 88, 3, 170, 1, 114, 158, 39, 191, 184, 
124, 218, 215, 182, 166, 133, 49, 194, 117, 159, 126, 202, 63, 11, 29, 75, 
8, 156, 68, 123, 30, 111, 5, 189, 84, 204, 157, 190, 13, 197, 144, 57, 
255, 151, 236, 165, 238, 217, 209, 161, 87, 246, 180, 179, 198, 74, 195, 129, ], 
[ 216, 20, 160, 73, 253, 2, 47, 246, 49, 159, 12, 76, 100, 69, 105, 213, 
0, 113, 143, 85, 94, 64, 180, 174, 40, 184, 254, 166, 83, 17, 252, 203, 
68, 16, 212, 13, 1, 206, 151, 177, 35, 176, 175, 54, 56, 89, 31, 157, 
240, 61, 59, 104, 186, 15, 82, 164, 133, 210, 72, 167, 170, 250, 226, 62, 
232, 245, 9, 211, 130, 162, 101, 168, 43, 75, 219, 197, 185, 200, 191, 107, 
215, 14, 91, 205, 63, 50, 96, 21, 58, 207, 106, 209, 111, 172, 204, 178, 
224, 169, 214, 201, 255, 229, 29, 146, 145, 22, 165, 150, 7, 27, 99, 87, 
41, 19, 26, 188, 92, 46, 81, 52, 51, 225, 187, 117, 93, 241, 28, 228, 
251, 235, 182, 227, 98, 67, 115, 221, 244, 102, 142, 114, 116, 153, 4, 34, 
33, 218, 6, 5, 154, 161, 42, 152, 132, 192, 247, 23, 121, 70, 148, 48, 
238, 103, 39, 144, 11, 230, 84, 136, 198, 60, 128, 38, 122, 208, 45, 149, 
119, 202, 127, 53, 24, 118, 36, 66, 195, 135, 141, 222, 179, 171, 239, 88, 
110, 220, 44, 234, 80, 125, 112, 37, 139, 134, 126, 183, 190, 131, 86, 10, 
173, 147, 78, 193, 248, 231, 8, 25, 140, 129, 95, 223, 236, 77, 18, 32, 
237, 249, 156, 243, 79, 196, 109, 155, 124, 137, 57, 217, 3, 97, 158, 199, 
120, 55, 30, 242, 65, 163, 194, 108, 90, 138, 123, 71, 233, 189, 181, 74, ], 
[ 46, 125, 92, 69, 40, 159, 217, 37, 43, 186, 19, 250, 247, 16, 205, 50, 
156, 103, 68, 187, 132, 184, 70, 11, 130, 163, 200, 74, 105, 89, 44, 248, 
77, 212, 143, 101, 98, 39, 241, 53, 116, 29, 84, 166, 1, 14, 23, 237, 
177, 196, 85, 142, 236, 6, 65, 88, 73, 117, 128, 172, 102, 213, 90, 233, 
180, 118, 107, 9, 173, 157, 195, 144, 160, 15, 243, 71, 136, 227, 152, 87, 
232, 223, 216, 79, 140, 182, 104, 194, 149, 168, 100, 93, 191, 120, 228, 175, 
51, 218, 34, 58, 208, 78, 48, 28, 226, 75, 113, 17, 225, 192, 244, 246, 
134, 253, 82, 60, 176, 52, 170, 126, 167, 30, 178, 8, 5, 188, 121, 4, 
135, 235, 10, 183, 59, 252, 27, 31, 76, 179, 254, 45, 222, 220, 138, 99, 
122, 209, 41, 202, 238, 33, 197, 147, 131, 38, 171, 239, 26, 215, 127, 63, 
169, 21, 151, 111, 207, 106, 229, 129, 133, 20, 83, 2, 193, 112, 13, 139, 
124, 119, 49, 245, 12, 95, 7, 224, 62, 240, 249, 55, 109, 36, 206, 198, 
108, 148, 165, 203, 61, 137, 96, 22, 164, 189, 158, 35, 153, 97, 154, 242, 
86, 24, 221, 91, 115, 3, 94, 72, 201, 161, 42, 123, 255, 64, 230, 204, 
150, 251, 146, 210, 162, 114, 190, 185, 66, 25, 67, 234, 145, 54, 110, 56, 
81, 32, 155, 219, 174, 0, 214, 47, 57, 181, 211, 18, 231, 141, 199, 80, ], 
[ 55, 223, 107, 214, 197, 109, 99, 16, 239, 155, 33, 188, 217, 96, 241, 69, 
4, 52, 122, 208, 179, 92, 141, 64, 173, 160, 63, 50, 86, 162, 201, 46, 
0, 140, 98, 85, 71, 75, 175, 195, 41, 167, 60, 131, 249, 245, 135, 228, 
9, 56, 84, 58, 221, 205, 233, 77, 13, 111, 49, 161, 152, 8, 32, 19, 
82, 106, 231, 229, 235, 67, 171, 124, 150, 80, 35, 73, 7, 242, 66, 211, 
236, 114, 250, 27, 51, 100, 14, 207, 1, 237, 138, 15, 157, 213, 72, 137, 
209, 177, 128, 47, 230, 108, 43, 119, 42, 127, 248, 144, 110, 24, 168, 74, 
54, 65, 184, 17, 206, 218, 104, 199, 253, 97, 11, 181, 126, 102, 191, 225, 
18, 254, 133, 81, 23, 232, 129, 26, 227, 186, 12, 244, 243, 22, 2, 123, 
185, 76, 154, 120, 178, 174, 116, 238, 89, 37, 193, 117, 166, 203, 31, 222, 
40, 25, 148, 79, 240, 113, 134, 83, 251, 139, 164, 130, 44, 48, 101, 61, 
182, 255, 147, 53, 183, 210, 192, 190, 39, 59, 176, 158, 95, 115, 216, 94, 
196, 34, 172, 118, 136, 88, 5, 252, 28, 151, 156, 112, 146, 247, 165, 93, 
21, 163, 215, 234, 212, 202, 194, 20, 159, 87, 200, 170, 125, 70, 38, 180, 
224, 132, 45, 62, 143, 121, 105, 226, 149, 246, 91, 30, 145, 142, 90, 103, 
220, 3, 189, 219, 78, 57, 10, 204, 153, 187, 169, 29, 198, 36, 68, 6, ], 
);

=head1 NAME

Crypt::AppleTwoFish -- an Apple iTMS internal key descrambling algorithm

=head1 DESCRIPTION

This code appears to have only cursory resemblance to Bruce Schneier's 
blowfish and twofish algorithms in that it too has a table-based decoder.

Derivation from FairKeys code by Jon Lech Johanson and others at nanocrew.net. 
If you don't know what that is, don't bother looking here further. This is
a Pure Perl implementation. I doubt there is any need for xs coding for 
what would mainly be processing 16 bytes at a time. 

=head1 SYNOPSIS

    use Crypt::AppleTwoFish;
    
    my $scrambled_key = '=sixteen uchars=';
    
    my $apple_twofish = new Crypt::AppleTwoFish($scrambled_key);
    
    my $descrambled_key = $apple_twofish->decrypted_for_iTMS;
    
    my $descrambled_another_way = $apple_twofish->decrypted_for_DRMS;
    

=head1 METHODS

=over 4

=item B<new>

Call with the key as a scalar argument. When passed (LWP simulating iTunes) over iTMS, 
encrypted M4P keys for your purchased music are currently 16 unsigned chars in length.

=item B<decrypted_for_iTMS>

Returns the unscrambled key for use with the Apple Music Store.

=item B<decrypted_for_DRMS>

Returns the unscrambled key for use with iTunes/iPod DRM.

=item key

key data field get/set

=item process_DRMS_key

process key for DRMS

=item process_iTMS_key

process key for iTMS

=back

=head1 AUTHOR 

   From the scramble function and scramble_vector adapted from iTMS.cs, FairKeys 0.5, 
   by Jon Lech Johansen, but derived from the alterate scramble table found by 
   FutureProof. Perl version: William Herrera B<wherrera@skylightview.com>. 

=head1 SUPPORT 

Questions, feature requests and bug reports should go to 
<wherrera@skylightview.com>.

=head1 COPYRIGHT 

=over 4

Copyright (c) 2005 William Herrera. All rights reserved.  
This program is free software; you can redistribute it and/or modify 
it under the same terms as Perl itself.

=back

=cut

1;

