use strict;
use Digest::SHA3;

my $TAGS = join('|', qw(Seed MD));
my @vecs = ();
while (<DATA>) {
	next unless /^\s*($TAGS)\s*=\s*([\da-fA-F]+)/o;
	push(@vecs, $2);
}

my $Seed = pack("H*", shift @vecs);
my $sha = Digest::SHA3->new(0)->add($Seed);

my $numtests = scalar(@vecs);
print "1..$numtests\n";

my $t;
for $t (1 .. $numtests) {
	my $d;
	for (1 .. 1000/8) {
		$d = $sha->squeeze;
	}
	print "not " unless substr($d, -64) eq pack("H*", shift @vecs);
	print "ok ", $t, "\n";
}

__DATA__
# MonteCarlo_0.txt
# Algorithm Name: Keccak
# Principal Submitter: The Keccak Team (Guido Bertoni, Joan Daemen, Michaël Peeters and Gilles Van Assche)

Seed = 6CD4C0C5CB2CA2A0F1D1AECEBAC03B52E64EA03D1A1654372936545B92BBC5484A59DB74BB60F9C40CEB1A5AA35A6FAFE80349E14C253A4E8B1D77612DDD81ACE926AE8B0AF6E53176DBFFCC2A6B88C6BD765F939D3D178A9BDE9EF3AA131C61E31C1E42CDFAF4B4DCDE579A37E150EFBEF5555B4C1CB40439D835A724E2FAE7

j = 0
MD = E161B709FA30F18FFDE2400BE660229847342F4B41CE15F0DC2020FCD0956BEC46E76C5DD05C2F28B3E92DDD469362DF2222050DDA792E111AA044F15D06C84D

j = 1
MD = 6BEF9BBAF8C4C9A74E135D7C5C4F6510F5F8F6E3810B8DEE98EBDF262160DB6620B75D081058A57C84B188C97B6AF8B9C3A4C574718F6B951E0A3A7D15897742

j = 2
MD = F3F41B9E57F35B1775E7F9703467D102816F6B69FA393001AE5D31F03D79AC137FBF20C05410429E915F9100A4029E86BEB772FBE2769854CC7035A98A19C948

j = 3
MD = 4C745BE8D71DBBE6B5FE54B7967091B4E84FAC7C147A7F730AEE561DC42BEB5760F733709149D2A6B658E166A3842EB10A8A5C519FCCEE1554C1341BAC6F61D5

j = 4
MD = F23027970F218574EC395BA03E4040B2B7BCB22DB858769DF7831CB917561969D39250AB4C451346514EF268A15322389D65327EBFD4548BAF88974685CFC3FF

j = 5
MD = 4F4B157E0A5CD0C848D6DB931686402B40C06203B4471D53233ED9B63AC5D6798C96FB833088E930621A21E70C86604F3703569279DCA710EC923AC04C9E920F

j = 6
MD = 4A4713EBF2D90B67D5FF16B5B656D2FDBCCB3A264F2D7A5158EA6DB91F3F29254CC4968F86DE04976905C0A5B8B38A60A580CE6BA5535FD31631CE304AC75038

j = 7
MD = 2C20DB9BEB8D6364B2885B640325A08588CD07CC5CAF0890394E4D114755B1B36B7AAB043F435ED52EBC16C9C104510ADFF8EBBACBA5269BA281F388C9AA56CF

j = 8
MD = 2C4936B1487BEBA3C6C32A42C6B7980D0F9631910756BAE5102BB73B26D055E8FF371CD98806800247EEF0607525B57306087F1B1D93BAC69C9925CC7173492F

j = 9
MD = F93B3607417FB6A3FBE97FFF53372065EBF9CB1ACE25E8BB23EDF6A94E43DF791B47A62D6FC5412F647CD84E21B02BA575F2F47DD69296440E376FB45693F2B8

j = 10
MD = 8885CEBED8BBC3CDD251D0F636BD7A41CC054BF11D8A4DC76D00326F83D9829E9BF2D54F0F3789FB5F49AD24B0215E15091A896C41F58298370302CE256567C1

j = 11
MD = 5CDFEF53701C786E10C6A4196699FC9472F0206879573E05BA6ED1163A26DA7738F015869080B65B930F1A82D6493F353EB5315BBA24A0AFBBFC8652AE0B0006

j = 12
MD = EAC1879138D7588505BF95D1B7E947A9258256B534A4B9DC9D8177C7778C7E45BF37DF25408D99B67958E2E25949E79296A359B72E5D214DA4FE334EC39F14E0

j = 13
MD = 2C0A9C02CE830F0E042BC579733D25D0A8C251EB223BCA8803ED55F15E3C613D386F70AF3BBB8C1CE39634123E8A5B854F4020F5A4E8DBCD6EACFCD9DF9F3890

j = 14
MD = FEDDC023ED6597A6B1665D93ECF2B93CFE08C41FA8618C85F48DE2788595FAC79D2EA70B9DF82FF8C7BC2AA5D7FFE30700C9B5450A05B809F169466D9321CCFC

j = 15
MD = 96111943E48C8E3579DDA6FFC81D340E0B45FFC040B471C2962FA2EF16DBDDC2FB621A0D97C79525D678E007047582D5DFD6FC63BC24198CBADE60EC89DAB49E

j = 16
MD = 3E8D061FCFE968B8AE956CF61536AAE306FDAE577AA4CEAF8421658B98A9FE90877BEFE9124019E9EE259D8A78636FFFBFFA7B46583C869D39AFDE32A267DD66

j = 17
MD = 86C71B0EFEC513F9CFBE9DE3B23A1CF6EFC26E14A35A7D9AB1162D7713750CB31E66542C61DD0793F02AA47F7CEC964D65550CF1958C4B6C94696D220BE052D3

j = 18
MD = F3D37FDD8F54A3FCBB408A43D7EF171409898C76BE8120927E3B3AD3E27BD630B6F435F4D34DEF974B95F47B1CEA4CC85C2341A6AE6A50F1F546C95394601ABF

j = 19
MD = F0B165FC20D99F0FE2808D00E868BAC70A5F8E969C6E7113D0646A1AA35596196DBDFBA31A19126497D3C8C237EE6D1B1D8EF79DD02AE8989B7C762C73B6C680

j = 20
MD = 121A0A11EEA7B1E34AC089B2C813521EFDD30A854364E1B8E8EADE0AB16CB030F1CADAEE2C1B48857FF05244E2C3048A9178AE989AB3264D3CCBB04F5975085F

j = 21
MD = B876CEE5F380645A7A51C1717F0228A77E77805DDF4C899BA55A0D0D5D6EC6766A078AD4A0487F176FEE50D1B2F2F51FBC950DBD5887D90ECFB84251DD67A00C

j = 22
MD = F887E9B6DAFD64D692CA0823EC7D91B12A229677622F97A53211D2B5FC4694DEE1A84DB43C06D0F51F4FE86F99C0D601C6AD7F4F321227985C18AE49FC27DA50

j = 23
MD = B73B302428FDC9930B1572BBCD26338BB7BAB37E46D0F6FB6AB2BB648D065316EC5ECFE8A1A93EFF71E511F2351E6555DB8DE105A1BF79D7929FDE7BAD410174

j = 24
MD = EF67B2CBFFF1FAD9AB2C485E692A97C699D918E636A07C5458ADEBE3C679A6FD3059B1510DCA7416E19FA5CC074B5DCACD6F44210283FDA784DF2656E21D0E4B

j = 25
MD = F9DD0D53DC7EE2937E025F9484F515BFDF280C10C1D62DE6823342765E170D304BA78EE9C95A816AF7AE3772E466160404126497325E3AACF60CF803FC2CA309

j = 26
MD = E5BBD6572A7966F922ECD5E56BD7248EAF2AEE0A9561F0E4BA8CA926174B60E24796A78E2E741B8E7DE1F958B7E97620CDD785AAACEEF3C5752FEBE5A5C7532E

j = 27
MD = 1DB390BE5C7F471167C5EDD1268355AF892C2A757B8D4FDBBA8F1CCE2A98C5D1C1DFE52BD40737DABE7548872DC24D12A052C21A716CB35D6A543D674FF6DE7F

j = 28
MD = DDD8260DEB7EA4B6D45A339B97A3640789D67468CE26981263128B8A27EADA09B75FF93460E62485C0CC98F3255186C91B72EAC1CFA4B4894D44EE5D7E8B44EE

j = 29
MD = 3B56D96FBE08E23846FE34C78999CBD69382479E6EACD3A2CA1D2893DCAF3DB9D72742B8961069EA1F51B939ACE48A5C75E7DC227CE4B079329B5A150A3ABCFA

j = 30
MD = 13EA05B5748F039552282CD8CEB80F4FC120A5F97AFB71A2998C5EE47B2E64FFE0B2D84BCA3BB9BA55488618701DC531456788987D2D17933DB45BB928C540B7

j = 31
MD = 9FA06D0378E74A8276D5351B7EB5CFE333EF759583861F05C5AE07B19054A6F7F851BC6889E7235A9CB316BB7D02C5CF78A039303A2BA11DF1212A41A09D226C

j = 32
MD = BC5CB4E284755A35EA109CBF5319E1B95119B96403CF1D9021FEF5B3BF146319C0BD05C6DEEC8AB1E107FD0B19E10B6285D28E111F4618A09707CEFF56215997

j = 33
MD = E99D13DAC5B013DE551FE6DCBC75721791C6BF77781A50454D9F30932730541E41FDAEE6262836D25167E811A056365B70736AA42A13CA25B3E2385C7EFEE615

j = 34
MD = B023014E7B73D2D59471B63055DEE0EAC95B3255A3436B3F55E6BE8E1203D1115EA944C73E545E2A6F652CFD980C157CDB975D279DEBD9288235C3161221703B

j = 35
MD = FB038E4300867AE9EA99D13922E72BF849F86CD045C091F3F75E243DEDE04B162BD77526570D227A503AA2529366F8B792B6F09F58EC6A531FE19A25EFB18CA8

j = 36
MD = 80630E18D9B6C3E63D32A33E4356F03E92B300DF2D894577793A6B39A4B9F6E40C480ACAB6CED0130455A13B695651B695B735994EC472D98F34C687447E5AE3

j = 37
MD = 1D2BAD36ED679AD0FB477E1B7D0F8E06916F38242C779CE13D76C5CD83D5D2B9CDF422A0AEFC038C79DC02ACAB193A433D07CA542A1FD0C043FD02F8E4EE40E6

j = 38
MD = E83C20F4D53EEAA493060E110FF4D7B5AF4E79FCBE1D487B76987C37B62EBF35A72704D36808B842759148B975E1D5E80C1BCA257CBEBFCF614BFB2EA77E7E99

j = 39
MD = 78E5A2176B00D4DABB05F2BA1BFC073B8996F868BA83EE9301F4C8B60C3E05C3A4552B9A82E148AA23481935A7B90E717B3A3B139E0D296DFF39E8692D67E874

j = 40
MD = 5D306BABA355D28CD2ABA298DA273237E3645EFCD1B0D58C0C6A3A9082480A9B468372A6BE727A0636F212905880C8CBEAE20D16AC0798E5A04F079D500D8B22

j = 41
MD = F41061BA1DD5C4E4942189DECC73099090807B8CE689F07531BA590A15F8E1558B32C9B397B6D95798BFF1285CEE720452A025F04D7D185EB35B77D5C314AA6D

j = 42
MD = C562B944999948E28EE0AB14383351F74FC2FB2140BC65FA1831A230F6A307AB816E8B2213E37360E09B3401C083ED1854419FFC2DBE6AA42A666ED99C7E8B30

j = 43
MD = 85CC6D28751C0BF9BA868879706AD2B63712CC149EE10438FF09AF3DCF6AACAB6E4D0D3CC2FAC75934B84F2042568AAE1ADF2B5343EFD5C822FCDBA1D05CB601

j = 44
MD = 191E9C2374E3DD2176BF9C794610CAC458FCE2B199989F5FE0DD87FC56B575EAF0412189FB426AC52DAB7DC1C38047A95904DEC885B598CBE03447783D5AF665

j = 45
MD = EA5531C2570EC57F45F00B9F457034F506614406F6C9AE3CA80490D2AB772D63078A3A869ECD57069AB4DE25AF83C54D37E46FBB7E25BC38F2CFFC62310ABA87

j = 46
MD = 1D5D758C049F092D6A111121EBC2612848D406DDBD60F14158F898C6F9F18944BC1EA4C4C9CDD679B426D203973B21008156E9A47CD14DE73AA04A35868D18C0

j = 47
MD = F03DB2C13B14FA66F59B5D8467F3F64C2AE8D887FA30E62AE831EB890CA48221F7848CE7485210E1C1A9BCD5A18A245C4274887476B8C7516A9F702E36C43762

j = 48
MD = EC6391D842B688C5764D253E3FC3B2D52A092C605C5FB435281C3BC5288292CB6ECA0CF9A1334655DDF1EF419C8B9996F5805EBA8BFAF3E501FC22A8D4E4F056

j = 49
MD = 809C3FD8BEA2D9C98725883DB841456FDDB177CBC161A25E88E4102772E808947209DED4B3E9C57891BE97CCA7D38F2676522EC236A099CC9B6AD953DB1A736F

j = 50
MD = 585C78404F93585D103686C7CAE342ACC95D3BF83C6D1F1AE234062DB1F25A351D9E6161AC4E0755316C276BE45DCE3E7483109347E35E615963F1024476F9D5

j = 51
MD = 91F3612F7EDE97036A9FE407D5ADF0E1C0329BC8B9DFBAB66E702ED4962E3A91CE07747310BBD9A1212A43B73D075714DE7242009CA5AC1229422157DF413C7C

j = 52
MD = 916B9F5D0BBD75BD60E6163068BCAAD81462513251120C5B55A803318EF35AC3D67DB437F5CD21106B9D8555B0D94FC485B214C7C0DF1CA6DE896A240A1E1BEF

j = 53
MD = ECC140AC8AB96FF7D3CD9C0E5C8F69DDC89C2B911C1799F5CF68DA2395F74D791E8F959DDAF0F91907DA352A2F27397ABB9395E7F840F5FD4F40A7B1B4A4D2C3

j = 54
MD = D15F948FF675BFA1591534E349ED5B1F37F4534E8F4E933F71B0E949115345DA3A4F748251749796C65253F81E6F96282D6D3AFE6AE90B3EF9D71D776021F8F5

j = 55
MD = 9CFF24F7BE47454687BF1927A223879E46F7CEF7BF10F7D664458CCE845A432D8838BDB9B83B9765766878E34319561A4DC27A43D12D866185F1F8D3E3BCAD93

j = 56
MD = B433C7875059786BEB9CB089EB86F4384386B65EF3EDE4D2BA71BF4BFD2B6A3D69F28DE23F4799622527DA8478ADFDE166D27568FF85A7A60437F9A1F1DE5023

j = 57
MD = 143367B987D9A8FD9C08C307CA56941F133C788015216BA334872424775CF01E1DCA070FF31CA9417F60CB43C6C640209B634BC7AC3EBCE7E6ED452E0E42648E

j = 58
MD = 5F58781FD7143D3A761E3E439E070B1FD9E92EC94BB2FD64113474F99F8566B77B7EE73A3D5A2A14C4073DC4A63169583B7C7F79A48B2D54B6604392A701F664

j = 59
MD = 1B82CB574B3718098B42650F87AF63781F5DFBB5C2EAF28E6FA30251306D6EC2C4ED57A21D1F1C0A0CC096BCBBE19D388AAA2450F0994EDD9CAADFF7D9825675

j = 60
MD = 7F784140A35F77B402E190A0345D0589FA5EF78D22C983D63AC574A033FBE108D4D5DDDE83F4EF65F54164FBDA94D7DC2211C267EB811778699ACBF4E36857EE

j = 61
MD = 3F03E74CF31D2603436DA829499DFB022A79711A00B64977363C9E00674C3F35BB480465672859FCEF830B6F728DCA03F4944134D312A2AE6C8918D83DF8A9B2

j = 62
MD = 3F465C4A05F577396C2470C88FCCD11495F62DF07F4CDC7B0DD384AEC3128957FC26FE0148E235B5C2E5B8E42AB88A57A75A1D9E3B56387FA5B360AA9D643F39

j = 63
MD = 567BE5FD77F07263F269F8FAAFC19CBEF4CD3900325F939EAC5BE155B5854ECAF487B09D5B96214B81EFFAD2D530F9ECED30E3F77483FE23E31E3E8A41F93DFF

j = 64
MD = CC10196F8653ADE035ED0C1A9FE0E3F6D81C7399C145A4218145CF6254B311F328EDD1F3F9AD78099B47DDC918117A7C4B514A2887DC3C4769C2F59AD66234DB

j = 65
MD = 0740A79C5D97BADD3EADF52A40A2B7392263072BC7478DFEA7A0B2D87CC0F911405684F5B2836A1017EB313E97708DB416EA20765E5C0518C8AD5A9DD61165E5

j = 66
MD = 34AC2FEE4BDEC65E1525F945EB151CD537ACF45B50A99B544286BA9D99B9282CD7635CD62330592CE2475BFCF127FF3A507B1D5400A41897872A50D235FA2854

j = 67
MD = 30B3838E6EE9CE96096FB37CAB213D8162C7812763881000AA1C3E0E2BA9DF49DF81965FA96EE492194A42A82605B89D56311CCCFB75A105D275581AE384F761

j = 68
MD = 89315A652573DDFA654836F7C27C7A79A9560B5864375F573A3F6AC86575E9CDC0404C0552A28199E1A0D9B612F2E69447FB1039178594A08F6CB93D598267BD

j = 69
MD = 0BD75243D540962CE6B1CEF0E8B58E06B42949FACFFE542E2479C0CE4C08C2E4FA598E8E95EF4E8B239FBB1B1B40AE5FD4FF03E04B0619C31428FAAEAF521C98

j = 70
MD = 28F58B059FCF684A22139F810DE4DFB1795EFAD94C84A5D32517E69EB0C0848B52A00D31405C32FFC29057B4B9A17AAEF09020DC696B9AC9CA81F963B662FC92

j = 71
MD = C3A21679C75555C8E0AE4CFA91CC736AF4DF25E2CB8CA1899B3218671DA414ECBA6C2FCD337A385C6E1948F6E1764F1C2380A5133562831F95DF9751F3C0CFAE

j = 72
MD = 493EF322517B6E0DC9D161C8AE0F35B43A02F96596CC007DA301CACA8474E8E66F6ED4D039111B7BE2F81FDD1DF286D484174A934E581166F8ACBA1ECF0AEA4D

j = 73
MD = 40A0468F54296377EB4AA052AB497362193AD57FF0397A6CDF0783B80B7E68A5E5C85AACBD2A68706752AB995DBF543A610FEFED912E8EE02A84574AFDD11364

j = 74
MD = 48C1331BCBA0FA812AE114A007A99198E67F55D41D2F3BD347373152B04E9B2F9C7E35BDE71DBBDEC21D3849176FDB8219A62DCB56B3618B839FCC8098DF5FF3

j = 75
MD = 1306EC45151B21677A2C10718542F17AFBB2049A9B358BEB6B218E341CB2FEFA964D92B0B5DDC8D849CF2E2E307B90C94807584E05A0402D70C65DC2511ACE97

j = 76
MD = 4E3894E12A67681424CFCB2FDED075FD9B830BEDE0F1CC0C3BF20A98494DF23A18F362965465F96377BB18A107176FA9D825AF1FBB013AD550D1854BDF1F260B

j = 77
MD = 676487E2CD299F21FEB05DB8EDE9E532AC26B8BF2C1D29A19E5B0648E2CE223BF3BDEB398AA028AAEB0B5F03D0A1CB69A5066830D53147F64DF14B93AE5F9713

j = 78
MD = 94CFB897DD965E3369596DCA598B86A014BEFA95521FCBDF4FC4BC855D7F591294DDC7C63E4A7155C334710774D997516F69B0BA42A793D7756458175E50B51D

j = 79
MD = 1F2AED846822D025C705D1CCD97E58B384F6567AF342046066DD81691F54230D574B578E5E42CC33A6F8F2E90B1A6C43FA804A81913AAAA8B66E864FCBF4BA3D

j = 80
MD = 47416060DD8FA27E034CC4CB64657630CA26C86E7E7E883FD8A3E00FFE1E596F3A2FE08BE2BD091CEFB15A3247D1A10B9B2E80AE8F3EDAE85D49E0AFDF064930

j = 81
MD = 15C6766056E153A93CF565E146C65DCDCE5715F751E2185050EBD888F4EE67E206F310ED5E2BB2F4AF2D2258432BCD9DDEA75FDA3E03F4BD7AB284A82E92A753

j = 82
MD = AC6F94355C6B23B7FF34FF367FFFD2EAF711853EA2A6D66CFA1E7FA96A71702DB349687F740039B2CA28F97DA0FDDA61FBAF92317830A895C08CC81F25344F70

j = 83
MD = CA87ED0E815D96264BFF40F8CFEBAECAA999E8766FFEB4A668D9D3CCC61DCB0D5E020251686798ED83E5FE6F0E4EE305CDABB89FDE7831B107EC34D6FDFA6A28

j = 84
MD = A1EDAFE09CCAAD563A5563C06377F458CCE9A67DFE80B436EF5639082B7E4441EA4A9140F7BEB66FC5E626024EA3572F06D0EE004603BA427513798BEF0F67CC

j = 85
MD = 8DEF608EA752332892C4C5F757CC18FDA273C38ABAE20436E2531B052A378A1770009262CC86D7F5BED32CF36B3D5699DE77DDCAD26F28D18F681674484B15F9

j = 86
MD = DC07F12C8517FC53EB9A831FF30426ABD6CAD42AB09620A9D4A72E8F8A992EB6C7BD6CA496B9262EEF02E06393294AD138C75CF4B8CCD24195B62B138D020FD0

j = 87
MD = 973356E54F006AD5E955CF835D25315DF1DE5DAF90236F870E0E9179C45879FDC39706D8669B74D9CD4E1EDC4D1D95A7DE3ED79AEAF75D4329EE13D01661BA0B

j = 88
MD = 9D87C70552844C210EBB45974A13EC1A4A6F2AE619FF2C51BADA17352C1A3398D613AC7C1517F820F6F3548208B1A8DDC794321D2A31E08C020AE43BEAABD65F

j = 89
MD = F1E21120C39FC5813DC0EF4F44F291730965203A398251D946AF99D616496B545566EAC69180A7101002E391DCD103CE63A4F8E5BD149494007EC9449276C992

j = 90
MD = 83DC5231810A99B18CC6BC1FBBF5F0BA37C86B8283019DBF3F4948F4E97331FD55C383C29F8D9403EDACB343A832B21C711AA8B558A3EA80FEC57BF65A75289C

j = 91
MD = F635077437B08EE139B93B9494F00E2C859A3B70C5C643C179FB445E0820C768EFFEBE8BCDF62CB8AA3EEA7CA32EF8CF5CAB4F6380BC37F0938B4D3919A3C2B1

j = 92
MD = 77C1EB9B29EDC685217C98EF4536B41EB3918265DFC15B038448812C86D0E35D1C77DE96E47520F93C94AA650133B4B5433AC70FDDBD13AEFBB243E7F281816C

j = 93
MD = 93B15E192B4C65E38EFBADE6A6A7101100DE371EA3BAC756286500E8B5A32618E7586D71F620B068FFA563D5AEAE745E87394E3EFDB049D6E851D61C76750ED7

j = 94
MD = 1236A96F0652FB28F333CA82AB9C9488666EE4B07172EAA0ECA110205B36C673B070C80688E81D7949829C3A01B21F6CD84944A4EF871EFEB92F2B0CBD327963

j = 95
MD = 3799D3BB78995C683EA2CDB64DD31FCFC725D3EF691E39102A2A9AAE8DEB2EB80907872AC8FB52E809FE1532703424041B062FAE271826CEA43AD6D38BFF4422

j = 96
MD = 3C90D01F0FC6979500E776FBD6F827F701BBF78E859C132968DB043D9BA69620C972CB451AADD182498B8F363B76691EE4717879D4ADD6A351AE9815A57E6DDB

j = 97
MD = 29038211CFCC3800E8E27B74EBEBB02C571DFD8E40E36C025098297D7CF3ACD1D02D4F7C533C4B3F1960C4F37E309530AD98756D0834B3CAC6D70FC0BF8EF281

j = 98
MD = D741EA9BBF48CA7B64E838427E642E2CB4F339D812CDF44484126D46AD37A0BFE6720897372B66B7D6D986E4758EB1886E92B4DFE7633B5E92207AD62D3DB150

j = 99
MD = 59415A96E02FCD1695247D3B4B390FF6833BA93AB4EE4EDAC6AA525C12708C5214451C58B479D664D1E22E01C396273E174266B3AC968379EADCE9DF24C7A341
